"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, Dict, List, Union, Literal, Optional, overload

from pydantic import BaseModel, TypeAdapter

from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    SelectedActionsType,
    ReviewCustomGatesStateRequiredType,
    OrgsOrgActionsVariablesPostBodyType,
    OrgsOrgActionsPermissionsPutBodyType,
    ReviewCustomGatesCommentRequiredType,
    ActionsWorkflowAccessToRepositoryType,
    ActionsSetDefaultWorkflowPermissionsType,
    OrgsOrgActionsVariablesNamePatchBodyType,
    OrgsOrgActionsSecretsSecretNamePutBodyType,
    ReposOwnerRepoActionsVariablesPostBodyType,
    ReposOwnerRepoActionsPermissionsPutBodyType,
    OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ReposOwnerRepoActionsJobsJobIdRerunPostBodyType,
    ReposOwnerRepoActionsRunsRunIdRerunPostBodyType,
    ReposOwnerRepoActionsVariablesNamePatchBodyType,
    OrgsOrgActionsPermissionsRepositoriesPutBodyType,
    ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    OrgsOrgActionsRunnersGenerateJitconfigPostBodyType,
    OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType,
    ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType,
    ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType,
    ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
)
from .models import (
    Job,
    Runner,
    Artifact,
    Workflow,
    BasicError,
    Deployment,
    EmptyObject,
    WorkflowRun,
    ActionsSecret,
    WorkflowUsage,
    ActionsVariable,
    SelectedActions,
    ActionsCacheList,
    ActionsPublicKey,
    WorkflowRunUsage,
    OidcCustomSubRepo,
    PendingDeployment,
    RunnerApplication,
    AuthenticationToken,
    EnvironmentApprovals,
    ValidationErrorSimple,
    OrganizationActionsSecret,
    OrganizationActionsVariable,
    ActionsRepositoryPermissions,
    ActionsCacheUsageByRepository,
    ActionsCacheUsageOrgEnterprise,
    ActionsOrganizationPermissions,
    ReviewCustomGatesStateRequired,
    OrgsOrgActionsVariablesPostBody,
    OrgsOrgActionsPermissionsPutBody,
    ReviewCustomGatesCommentRequired,
    ActionsWorkflowAccessToRepository,
    OrgsOrgActionsRunnersGetResponse200,
    OrgsOrgActionsSecretsGetResponse200,
    ActionsGetDefaultWorkflowPermissions,
    ActionsSetDefaultWorkflowPermissions,
    OrgsOrgActionsVariablesNamePatchBody,
    OrgsOrgActionsVariablesGetResponse200,
    OrgsOrgActionsSecretsSecretNamePutBody,
    ReposOwnerRepoActionsVariablesPostBody,
    ReposOwnerRepoActionsPermissionsPutBody,
    ReposOwnerRepoActionsRunsGetResponse200,
    OrgsOrgActionsRunnersRunnerIdLabelsPutBody,
    ReposOwnerRepoActionsRunnersGetResponse200,
    ReposOwnerRepoActionsSecretsGetResponse200,
    OrgsOrgActionsRunnersRunnerIdLabelsPostBody,
    ReposOwnerRepoActionsJobsJobIdRerunPostBody,
    ReposOwnerRepoActionsRunsRunIdRerunPostBody,
    ReposOwnerRepoActionsVariablesNamePatchBody,
    OrgsOrgActionsPermissionsRepositoriesPutBody,
    ReposOwnerRepoActionsArtifactsGetResponse200,
    ReposOwnerRepoActionsVariablesGetResponse200,
    ReposOwnerRepoActionsWorkflowsGetResponse200,
    ReposOwnerRepoActionsSecretsSecretNamePutBody,
    OrgsOrgActionsRunnersGenerateJitconfigPostBody,
    OrgsOrgActionsVariablesNameRepositoriesPutBody,
    ReposOwnerRepoActionsOidcCustomizationSubPutBody,
    ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
    OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody,
    OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
    OrgsOrgActionsSecretsSecretNameRepositoriesPutBody,
    ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody,
    OrgsOrgActionsPermissionsRepositoriesGetResponse200,
    OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
    OrgsOrgActionsRunnersGenerateJitconfigPostResponse201,
    OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
    ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody,
    ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
    ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody,
    ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
    ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
    ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody,
    OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
    ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody,
    ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody,
    ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200,
    RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class ActionsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_actions_cache_usage_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsCacheUsageOrgEnterprise]":
        url = f"/orgs/{org}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    async def async_get_actions_cache_usage_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsCacheUsageOrgEnterprise]":
        url = f"/orgs/{org}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    def get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsCacheUsageByRepositoryGetResponse200]":
        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    async def async_get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsCacheUsageByRepositoryGetResponse200]":
        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    def get_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsOrganizationPermissions]":
        url = f"/orgs/{org}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsOrganizationPermissions,
        )

    async def async_get_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsOrganizationPermissions]":
        url = f"/orgs/{org}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsOrganizationPermissions,
        )

    @overload
    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsPermissionsPutBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsPermissionsPutBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsPermissionsRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    async def async_list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsPermissionsRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsPermissionsRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsPermissionsRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            OrgsOrgActionsPermissionsRepositoriesPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsPermissionsRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsPermissionsRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            OrgsOrgActionsPermissionsRepositoriesPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[SelectedActions]":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[SelectedActions]":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> "Response":
        ...

    @overload
    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[List[str]] = UNSET,
    ) -> "Response":
        ...

    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(SelectedActions).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[List[str]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(SelectedActions).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
    ) -> "Response":
        ...

    @overload
    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ActionsSetDefaultWorkflowPermissions).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ActionsSetDefaultWorkflowPermissions).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_self_hosted_runners_for_org(
        self,
        org: str,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersGetResponse200]":
        url = f"/orgs/{org}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_org(
        self,
        org: str,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersGetResponse200]":
        url = f"/orgs/{org}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/orgs/{org}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/orgs/{org}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RunnerApplication],
        )

    @overload
    def generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersGenerateJitconfigPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        ...

    @overload
    def generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = "_work",
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        ...

    def generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersGenerateJitconfigPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        url = f"/orgs/{org}/actions/runners/generate-jitconfig"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            OrgsOrgActionsRunnersGenerateJitconfigPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersGenerateJitconfigPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        ...

    @overload
    async def async_generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = "_work",
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        ...

    async def async_generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersGenerateJitconfigPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        url = f"/orgs/{org}/actions/runners/generate-jitconfig"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            OrgsOrgActionsRunnersGenerateJitconfigPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def create_registration_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AuthenticationToken]":
        url = f"/orgs/{org}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Runner]":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Runner]":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsRunnersRunnerIdLabelsPutBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsRunnersRunnerIdLabelsPutBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsRunnersRunnerIdLabelsPostBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsRunnersRunnerIdLabelsPostBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsSecretsGetResponse200]":
        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsSecretsGetResponse200]":
        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsPublicKey]":
        url = f"/orgs/{org}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsPublicKey]":
        url = f"/orgs/{org}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrganizationActionsSecret]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationActionsSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrganizationActionsSecret]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationActionsSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsSecretsSecretNamePutBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsSecretsSecretNamePutBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            OrgsOrgActionsSecretsSecretNameRepositoriesPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            OrgsOrgActionsSecretsSecretNameRepositoriesPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_org_variables(
        self,
        org: str,
        per_page: Missing[int] = 10,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsVariablesGetResponse200]":
        url = f"/orgs/{org}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsVariablesGetResponse200,
        )

    async def async_list_org_variables(
        self,
        org: str,
        per_page: Missing[int] = 10,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsVariablesGetResponse200]":
        url = f"/orgs/{org}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsVariablesGetResponse200,
        )

    @overload
    def create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesPostBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_org_variable(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/variables"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsVariablesPostBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesPostBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_org_variable(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/orgs/{org}/actions/variables"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsVariablesPostBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def get_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrganizationActionsVariable]":
        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationActionsVariable,
        )

    async def async_get_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrganizationActionsVariable]":
        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationActionsVariable,
        )

    def delete_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
        visibility: Missing[Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> "Response":
        ...

    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsVariablesNamePatchBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
        visibility: Missing[Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> "Response":
        ...

    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(OrgsOrgActionsVariablesNamePatchBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsVariablesNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
            error_models={},
        )

    async def async_list_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsVariablesNameRepositoriesGetResponse200]":
        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
            error_models={},
        )

    @overload
    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            OrgsOrgActionsVariablesNameRepositoriesPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> "Response":
        ...

    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            OrgsOrgActionsVariablesNameRepositoriesPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    def add_selected_repo_to_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_add_selected_repo_to_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_selected_repo_from_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_selected_repo_from_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    async def async_list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    def get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Artifact]":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Artifact,
        )

    async def async_get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Artifact]":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Artifact,
        )

    def delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "410": BasicError,
            },
        )

    async def async_download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "410": BasicError,
            },
        )

    def get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsCacheUsageByRepository]":
        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageByRepository,
        )

    async def async_get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsCacheUsageByRepository]":
        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageByRepository,
        )

    def get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        ref: Missing[str] = UNSET,
        key: Missing[str] = UNSET,
        sort: Missing[
            Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = "last_accessed_at",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ActionsCacheList,
        )

    async def async_get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        ref: Missing[str] = UNSET,
        key: Missing[str] = UNSET,
        sort: Missing[
            Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = "last_accessed_at",
        direction: Missing[Literal["asc", "desc"]] = "desc",
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        key: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ActionsCacheList,
        )

    async def async_delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        key: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsCacheList]":
        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Job]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Job,
        )

    async def async_get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Job]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Job,
        )

    def download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    def get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OidcCustomSubRepo]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OidcCustomSubRepo,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OidcCustomSubRepo]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OidcCustomSubRepo,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        use_default: bool,
        include_claim_keys: Missing[List[str]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsOidcCustomizationSubPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsOidcCustomizationSubPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        use_default: bool,
        include_claim_keys: Missing[List[str]] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsOidcCustomizationSubPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsOidcCustomizationSubPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_repo_organization_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsOrganizationSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/organization-secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        )

    async def async_list_repo_organization_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsOrganizationSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/organization-secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        )

    def list_repo_organization_variables(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 10,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsOrganizationVariablesGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/organization-variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        )

    async def async_list_repo_organization_variables(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 10,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsOrganizationVariablesGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/organization-variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        )

    def get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsRepositoryPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsRepositoryPermissions,
        )

    async def async_get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsRepositoryPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsRepositoryPermissions,
        )

    @overload
    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enabled: bool,
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoActionsPermissionsPutBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsPermissionsPutBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enabled: bool,
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoActionsPermissionsPutBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsWorkflowAccessToRepository]":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsWorkflowAccessToRepository,
        )

    async def async_get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsWorkflowAccessToRepository]":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsWorkflowAccessToRepository,
        )

    @overload
    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsWorkflowAccessToRepositoryType,
    ) -> "Response":
        ...

    @overload
    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_level: Literal["none", "user", "organization"],
    ) -> "Response":
        ...

    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsWorkflowAccessToRepositoryType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ActionsWorkflowAccessToRepository).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsWorkflowAccessToRepositoryType,
    ) -> "Response":
        ...

    @overload
    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_level: Literal["none", "user", "organization"],
    ) -> "Response":
        ...

    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsWorkflowAccessToRepositoryType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ActionsWorkflowAccessToRepository).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[SelectedActions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[SelectedActions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> "Response":
        ...

    @overload
    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[List[str]] = UNSET,
    ) -> "Response":
        ...

    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(SelectedActions).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> "Response":
        ...

    @overload
    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[List[str]] = UNSET,
    ) -> "Response":
        ...

    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(SelectedActions).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsGetDefaultWorkflowPermissions]":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> "Response":
        ...

    @overload
    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> "Response":
        ...

    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ActionsSetDefaultWorkflowPermissions).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> "Response":
        ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> "Response":
        ...

    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ActionsSetDefaultWorkflowPermissions).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunnersGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunnersGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[RunnerApplication]]":
        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RunnerApplication],
        )

    @overload
    def generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        ...

    @overload
    def generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = "_work",
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        ...

    def generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        url = f"/repos/{owner}/{repo}/actions/runners/generate-jitconfig"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        ...

    @overload
    async def async_generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = "_work",
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        ...

    async def async_generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersGenerateJitconfigPostResponse201]":
        url = f"/repos/{owner}/{repo}/actions/runners/generate-jitconfig"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AuthenticationToken]":
        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Runner]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Runner]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        ...

    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        created: Missing[datetime] = UNSET,
        exclude_pull_requests: Missing[bool] = False,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    async def async_list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        created: Missing[datetime] = UNSET,
        exclude_pull_requests: Missing[bool] = False,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    def get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        exclude_pull_requests: Missing[bool] = False,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        exclude_pull_requests: Missing[bool] = False,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=WorkflowRun,
        )

    def delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[EnvironmentApprovals]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[EnvironmentApprovals],
        )

    async def async_get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[EnvironmentApprovals]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[EnvironmentApprovals],
        )

    def approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    async def async_list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    def get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        exclude_pull_requests: Missing[bool] = False,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        exclude_pull_requests: Missing[bool] = False,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WorkflowRun]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=WorkflowRun,
        )

    def list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    def cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    async def async_cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    @overload
    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
        ],
    ) -> "Response":
        ...

    @overload
    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_name: str,
        comment: str,
    ) -> "Response":
        ...

    @overload
    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_name: str,
        state: Literal["approved", "rejected"],
        comment: Missing[str] = UNSET,
    ) -> "Response":
        ...

    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReviewCustomGatesCommentRequired, ReviewCustomGatesStateRequired]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
        ],
    ) -> "Response":
        ...

    @overload
    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_name: str,
        comment: str,
    ) -> "Response":
        ...

    @overload
    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_name: str,
        state: Literal["approved", "rejected"],
        comment: Missing[str] = UNSET,
    ) -> "Response":
        ...

    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReviewCustomGatesCommentRequired, ReviewCustomGatesStateRequired]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        filter_: Missing[Literal["latest", "all"]] = "latest",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    async def async_list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        filter_: Missing[Literal["latest", "all"]] = "latest",
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsRunsRunIdJobsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    def download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    def delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    def get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PendingDeployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[PendingDeployment],
        )

    async def async_get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PendingDeployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[PendingDeployment],
        )

    @overload
    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    ) -> "Response[List[Deployment]]":
        ...

    @overload
    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_ids: List[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> "Response[List[Deployment]]":
        ...

    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Deployment],
        )

    @overload
    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    ) -> "Response[List[Deployment]]":
        ...

    @overload
    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_ids: List[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> "Response[List[Deployment]]":
        ...

    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[List[Deployment]]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Deployment],
        )

    @overload
    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = False,
    ) -> "Response[EmptyObject]":
        ...

    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WorkflowRunUsage]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WorkflowRunUsage,
        )

    async def async_get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WorkflowRunUsage]":
        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WorkflowRunUsage,
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsSecretsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsSecret]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsSecret]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsSecretsSecretNamePutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsSecretsSecretNamePutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_repo_variables(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 10,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsVariablesGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsVariablesGetResponse200,
        )

    async def async_list_repo_variables(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 10,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsVariablesGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsVariablesGetResponse200,
        )

    @overload
    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsVariablesPostBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
    ) -> "Response[EmptyObject]":
        ...

    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/variables"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoActionsVariablesPostBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsVariablesPostBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repos/{owner}/{repo}/actions/variables"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoActionsVariablesPostBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def get_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsVariable]":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsVariable,
        )

    async def async_get_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsVariable]":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsVariable,
        )

    def delete_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
    ) -> "Response":
        ...

    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoActionsVariablesNamePatchBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
    ) -> "Response":
        ...

    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoActionsVariablesNamePatchBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_repo_workflows(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    async def async_list_repo_workflows(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    def get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Workflow]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Workflow,
        )

    async def async_get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Workflow]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Workflow,
        )

    def disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    ) -> "Response":
        ...

    @overload
    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: str,
        inputs: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType
        ] = UNSET,
    ) -> "Response":
        ...

    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: str,
        inputs: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType
        ] = UNSET,
    ) -> "Response":
        ...

    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        created: Missing[datetime] = UNSET,
        exclude_pull_requests: Missing[bool] = False,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    async def async_list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        created: Missing[datetime] = UNSET,
        exclude_pull_requests: Missing[bool] = False,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    def get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WorkflowUsage]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WorkflowUsage,
        )

    async def async_get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WorkflowUsage]":
        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WorkflowUsage,
        )

    def list_environment_secrets(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    async def async_list_environment_secrets(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    def get_environment_public_key(
        self,
        repository_id: int,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    async def async_get_environment_public_key(
        self,
        repository_id: int,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsPublicKey]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    def get_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsSecret]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsSecret,
        )

    async def async_get_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsSecret]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsSecret,
        )

    @overload
    def create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: str,
        key_id: str,
    ) -> "Response[EmptyObject]":
        ...

    def create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: str,
        key_id: str,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_or_update_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_environment_secret(
        self,
        repository_id: int,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_environment_variables(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Missing[int] = 10,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

    async def async_list_environment_variables(
        self,
        repository_id: int,
        environment_name: str,
        per_page: Missing[int] = 10,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

    @overload
    def create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    def create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
    ) -> "Response[EmptyObject]":
        ...

    def create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType,
    ) -> "Response[EmptyObject]":
        ...

    @overload
    async def async_create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
    ) -> "Response[EmptyObject]":
        ...

    async def async_create_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[EmptyObject]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def get_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsVariable]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsVariable,
        )

    async def async_get_environment_variable(
        self,
        repository_id: int,
        environment_name: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ActionsVariable]":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsVariable,
        )

    def delete_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    def update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
    ) -> "Response":
        ...

    def update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
    ) -> "Response":
        ...

    async def async_update_environment_variable(
        self,
        repository_id: int,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/repositories/{repository_id}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )
