"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, Dict, List, Union, Literal, Optional, overload

from pydantic import BaseModel, TypeAdapter

from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    AppPermissionsType,
    AppHookConfigPatchBodyType,
    ApplicationsClientIdTokenPostBodyType,
    ApplicationsClientIdTokenPatchBodyType,
    ApplicationsClientIdGrantDeleteBodyType,
    ApplicationsClientIdTokenDeleteBodyType,
    ApplicationsClientIdTokenScopedPostBodyType,
    AppInstallationsInstallationIdAccessTokensPostBodyType,
)
from .models import (
    BasicError,
    Integration,
    HookDelivery,
    Installation,
    Authorization,
    WebhookConfig,
    ValidationError,
    HookDeliveryItem,
    InstallationToken,
    MarketplacePurchase,
    ValidationErrorSimple,
    AppHookConfigPatchBody,
    MarketplaceListingPlan,
    UserMarketplacePurchase,
    IntegrationInstallationRequest,
    UserInstallationsGetResponse200,
    ApplicationsClientIdTokenPostBody,
    ApplicationsClientIdTokenPatchBody,
    ApplicationsClientIdGrantDeleteBody,
    ApplicationsClientIdTokenDeleteBody,
    InstallationRepositoriesGetResponse200,
    ApplicationsClientIdTokenScopedPostBody,
    AppManifestsCodeConversionsPostResponse201,
    AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    AppInstallationsInstallationIdAccessTokensPostBody,
    UserInstallationsInstallationIdRepositoriesGetResponse200,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class AppsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_authenticated(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Integration]":
        url = "/app"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Integration,
        )

    async def async_get_authenticated(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Integration]":
        url = "/app"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Integration,
        )

    def create_from_manifest(
        self,
        code: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppManifestsCodeConversionsPostResponse201]":
        url = f"/app-manifests/{code}/conversions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppManifestsCodeConversionsPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_create_from_manifest(
        self,
        code: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppManifestsCodeConversionsPostResponse201]":
        url = f"/app-manifests/{code}/conversions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppManifestsCodeConversionsPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_webhook_config_for_app(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WebhookConfig]":
        url = "/app/hook/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_app(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[WebhookConfig]":
        url = "/app/hook/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_app(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: AppHookConfigPatchBodyType,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    def update_webhook_config_for_app(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    def update_webhook_config_for_app(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[AppHookConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = "/app/hook/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(AppHookConfigPatchBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_app(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: AppHookConfigPatchBodyType,
    ) -> "Response[WebhookConfig]":
        ...

    @overload
    async def async_update_webhook_config_for_app(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> "Response[WebhookConfig]":
        ...

    async def async_update_webhook_config_for_app(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[AppHookConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[WebhookConfig]":
        url = "/app/hook/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(AppHookConfigPatchBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        per_page: Missing[int] = 30,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[HookDeliveryItem]]":
        url = "/app/hook/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        per_page: Missing[int] = 30,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[HookDeliveryItem]]":
        url = "/app/hook/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[HookDelivery]":
        url = f"/app/hook/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[HookDelivery]":
        url = f"/app/hook/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/app/hook/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]":
        url = f"/app/hook/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def list_installation_requests_for_authenticated_app(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[IntegrationInstallationRequest]]":
        url = "/app/installation-requests"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[IntegrationInstallationRequest],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_installation_requests_for_authenticated_app(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[IntegrationInstallationRequest]]":
        url = "/app/installation-requests"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[IntegrationInstallationRequest],
            error_models={
                "401": BasicError,
            },
        )

    def list_installations(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        since: Missing[datetime] = UNSET,
        outdated: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Installation]]":
        url = "/app/installations"

        params = {
            "per_page": per_page,
            "page": page,
            "since": since,
            "outdated": outdated,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Installation],
        )

    async def async_list_installations(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        since: Missing[datetime] = UNSET,
        outdated: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Installation]]":
        url = "/app/installations"

        params = {
            "per_page": per_page,
            "page": page,
            "since": since,
            "outdated": outdated,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Installation],
        )

    def get_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Installation]":
        url = f"/app/installations/{installation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Installation]":
        url = f"/app/installations/{installation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    def delete_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/app/installations/{installation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/app/installations/{installation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_installation_access_token(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[AppInstallationsInstallationIdAccessTokensPostBodyType] = UNSET,
    ) -> "Response[InstallationToken]":
        ...

    @overload
    def create_installation_access_token(
        self,
        installation_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        repositories: Missing[List[str]] = UNSET,
        repository_ids: Missing[List[int]] = UNSET,
        permissions: Missing[AppPermissionsType] = UNSET,
    ) -> "Response[InstallationToken]":
        ...

    def create_installation_access_token(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[AppInstallationsInstallationIdAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[InstallationToken]":
        url = f"/app/installations/{installation_id}/access_tokens"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            AppInstallationsInstallationIdAccessTokensPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=InstallationToken,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_installation_access_token(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[AppInstallationsInstallationIdAccessTokensPostBodyType] = UNSET,
    ) -> "Response[InstallationToken]":
        ...

    @overload
    async def async_create_installation_access_token(
        self,
        installation_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        repositories: Missing[List[str]] = UNSET,
        repository_ids: Missing[List[int]] = UNSET,
        permissions: Missing[AppPermissionsType] = UNSET,
    ) -> "Response[InstallationToken]":
        ...

    async def async_create_installation_access_token(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[AppInstallationsInstallationIdAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[InstallationToken]":
        url = f"/app/installations/{installation_id}/access_tokens"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            AppInstallationsInstallationIdAccessTokensPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=InstallationToken,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def suspend_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/app/installations/{installation_id}/suspended"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_suspend_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/app/installations/{installation_id}/suspended"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def unsuspend_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/app/installations/{installation_id}/suspended"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_unsuspend_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/app/installations/{installation_id}/suspended"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def delete_authorization(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdGrantDeleteBodyType,
    ) -> "Response":
        ...

    @overload
    def delete_authorization(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
    ) -> "Response":
        ...

    def delete_authorization(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdGrantDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/applications/{client_id}/grant"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdGrantDeleteBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_delete_authorization(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdGrantDeleteBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_delete_authorization(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
    ) -> "Response":
        ...

    async def async_delete_authorization(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdGrantDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/applications/{client_id}/grant"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdGrantDeleteBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def check_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdTokenPostBodyType,
    ) -> "Response[Authorization]":
        ...

    @overload
    def check_token(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
    ) -> "Response[Authorization]":
        ...

    def check_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdTokenPostBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_check_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdTokenPostBodyType,
    ) -> "Response[Authorization]":
        ...

    @overload
    async def async_check_token(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
    ) -> "Response[Authorization]":
        ...

    async def async_check_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdTokenPostBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def delete_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdTokenDeleteBodyType,
    ) -> "Response":
        ...

    @overload
    def delete_token(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
    ) -> "Response":
        ...

    def delete_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/applications/{client_id}/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdTokenDeleteBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_delete_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdTokenDeleteBodyType,
    ) -> "Response":
        ...

    @overload
    async def async_delete_token(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
    ) -> "Response":
        ...

    async def async_delete_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenDeleteBodyType] = UNSET,
        **kwargs,
    ) -> "Response":
        url = f"/applications/{client_id}/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdTokenDeleteBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def reset_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdTokenPatchBodyType,
    ) -> "Response[Authorization]":
        ...

    @overload
    def reset_token(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
    ) -> "Response[Authorization]":
        ...

    def reset_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdTokenPatchBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_reset_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdTokenPatchBodyType,
    ) -> "Response[Authorization]":
        ...

    @overload
    async def async_reset_token(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
    ) -> "Response[Authorization]":
        ...

    async def async_reset_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdTokenPatchBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def scope_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdTokenScopedPostBodyType,
    ) -> "Response[Authorization]":
        ...

    @overload
    def scope_token(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
        target: Missing[str] = UNSET,
        target_id: Missing[int] = UNSET,
        repositories: Missing[List[str]] = UNSET,
        repository_ids: Missing[List[int]] = UNSET,
        permissions: Missing[AppPermissionsType] = UNSET,
    ) -> "Response[Authorization]":
        ...

    def scope_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenScopedPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token/scoped"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdTokenScopedPostBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_scope_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ApplicationsClientIdTokenScopedPostBodyType,
    ) -> "Response[Authorization]":
        ...

    @overload
    async def async_scope_token(
        self,
        client_id: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_token: str,
        target: Missing[str] = UNSET,
        target_id: Missing[int] = UNSET,
        repositories: Missing[List[str]] = UNSET,
        repository_ids: Missing[List[int]] = UNSET,
        permissions: Missing[AppPermissionsType] = UNSET,
    ) -> "Response[Authorization]":
        ...

    async def async_scope_token(
        self,
        client_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenScopedPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[Authorization]":
        url = f"/applications/{client_id}/token/scoped"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ApplicationsClientIdTokenScopedPostBody).validate_python(
            json
        )
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_by_slug(
        self,
        app_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Integration]":
        url = f"/apps/{app_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Integration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_by_slug(
        self,
        app_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Integration]":
        url = f"/apps/{app_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Integration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_repos_accessible_to_installation(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[InstallationRepositoriesGetResponse200]":
        url = "/installation/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=InstallationRepositoriesGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_repos_accessible_to_installation(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[InstallationRepositoriesGetResponse200]":
        url = "/installation/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=InstallationRepositoriesGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def revoke_installation_access_token(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = "/installation/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_installation_access_token(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = "/installation/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_subscription_plan_for_account(
        self,
        account_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[MarketplacePurchase]":
        url = f"/marketplace_listing/accounts/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=MarketplacePurchase,
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_subscription_plan_for_account(
        self,
        account_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[MarketplacePurchase]":
        url = f"/marketplace_listing/accounts/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=MarketplacePurchase,
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    def list_plans(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MarketplaceListingPlan]]":
        url = "/marketplace_listing/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MarketplaceListingPlan],
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_plans(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MarketplaceListingPlan]]":
        url = "/marketplace_listing/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MarketplaceListingPlan],
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    def list_accounts_for_plan(
        self,
        plan_id: int,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MarketplacePurchase]]":
        url = f"/marketplace_listing/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MarketplacePurchase],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    async def async_list_accounts_for_plan(
        self,
        plan_id: int,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MarketplacePurchase]]":
        url = f"/marketplace_listing/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MarketplacePurchase],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    def get_subscription_plan_for_account_stubbed(
        self,
        account_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[MarketplacePurchase]":
        url = f"/marketplace_listing/stubbed/accounts/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=MarketplacePurchase,
            error_models={
                "401": BasicError,
            },
        )

    async def async_get_subscription_plan_for_account_stubbed(
        self,
        account_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[MarketplacePurchase]":
        url = f"/marketplace_listing/stubbed/accounts/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=MarketplacePurchase,
            error_models={
                "401": BasicError,
            },
        )

    def list_plans_stubbed(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MarketplaceListingPlan]]":
        url = "/marketplace_listing/stubbed/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MarketplaceListingPlan],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_plans_stubbed(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MarketplaceListingPlan]]":
        url = "/marketplace_listing/stubbed/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MarketplaceListingPlan],
            error_models={
                "401": BasicError,
            },
        )

    def list_accounts_for_plan_stubbed(
        self,
        plan_id: int,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MarketplacePurchase]]":
        url = f"/marketplace_listing/stubbed/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_accounts_for_plan_stubbed(
        self,
        plan_id: int,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[MarketplacePurchase]]":
        url = f"/marketplace_listing/stubbed/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    def get_org_installation(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Installation]":
        url = f"/orgs/{org}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
        )

    async def async_get_org_installation(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Installation]":
        url = f"/orgs/{org}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
        )

    def get_repo_installation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Installation]":
        url = f"/repos/{owner}/{repo}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_repo_installation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Installation]":
        url = f"/repos/{owner}/{repo}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    def list_installations_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserInstallationsGetResponse200]":
        url = "/user/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserInstallationsGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_installations_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserInstallationsGetResponse200]":
        url = "/user/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserInstallationsGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_installation_repos_for_authenticated_user(
        self,
        installation_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserInstallationsInstallationIdRepositoriesGetResponse200]":
        url = f"/user/installations/{installation_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserInstallationsInstallationIdRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_installation_repos_for_authenticated_user(
        self,
        installation_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[UserInstallationsInstallationIdRepositoriesGetResponse200]":
        url = f"/user/installations/{installation_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserInstallationsInstallationIdRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def add_repo_to_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_add_repo_to_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def remove_repo_from_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_repo_from_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_subscriptions_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[UserMarketplacePurchase]]":
        url = "/user/marketplace_purchases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_subscriptions_for_authenticated_user(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[UserMarketplacePurchase]]":
        url = "/user/marketplace_purchases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
                "404": BasicError,
            },
        )

    def list_subscriptions_for_authenticated_user_stubbed(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[UserMarketplacePurchase]]":
        url = "/user/marketplace_purchases/stubbed"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_subscriptions_for_authenticated_user_stubbed(
        self,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[UserMarketplacePurchase]]":
        url = "/user/marketplace_purchases/stubbed"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    def get_user_installation(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Installation]":
        url = f"/users/{username}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
        )

    async def async_get_user_installation(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Installation]":
        url = f"/users/{username}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
        )
