"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Dict, List, Literal, Optional, overload

from pydantic import BaseModel, TypeAdapter

from githubkit.utils import UNSET, Missing, exclude_unset

from .models import (
    Classroom,
    BasicError,
    SimpleClassroom,
    ClassroomAssignment,
    ClassroomAssignmentGrade,
    SimpleClassroomAssignment,
    ClassroomAcceptedAssignment,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class ClassroomClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get_an_assignment(
        self,
        assignment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ClassroomAssignment]":
        url = f"/assignments/{assignment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ClassroomAssignment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_an_assignment(
        self,
        assignment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[ClassroomAssignment]":
        url = f"/assignments/{assignment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ClassroomAssignment,
            error_models={
                "404": BasicError,
            },
        )

    def list_accepted_assigments_for_an_assignment(
        self,
        assignment_id: int,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ClassroomAcceptedAssignment]]":
        url = f"/assignments/{assignment_id}/accepted_assignments"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ClassroomAcceptedAssignment],
        )

    async def async_list_accepted_assigments_for_an_assignment(
        self,
        assignment_id: int,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ClassroomAcceptedAssignment]]":
        url = f"/assignments/{assignment_id}/accepted_assignments"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ClassroomAcceptedAssignment],
        )

    def get_assignment_grades(
        self,
        assignment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ClassroomAssignmentGrade]]":
        url = f"/assignments/{assignment_id}/grades"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ClassroomAssignmentGrade],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_assignment_grades(
        self,
        assignment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ClassroomAssignmentGrade]]":
        url = f"/assignments/{assignment_id}/grades"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ClassroomAssignmentGrade],
            error_models={
                "404": BasicError,
            },
        )

    def list_classrooms(
        self,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[SimpleClassroom]]":
        url = "/classrooms"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleClassroom],
        )

    async def async_list_classrooms(
        self,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[SimpleClassroom]]":
        url = "/classrooms"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleClassroom],
        )

    def get_a_classroom(
        self,
        classroom_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Classroom]":
        url = f"/classrooms/{classroom_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Classroom,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_a_classroom(
        self,
        classroom_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[Classroom]":
        url = f"/classrooms/{classroom_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Classroom,
            error_models={
                "404": BasicError,
            },
        )

    def list_assignments_for_a_classroom(
        self,
        classroom_id: int,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[SimpleClassroomAssignment]]":
        url = f"/classrooms/{classroom_id}/assignments"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleClassroomAssignment],
        )

    async def async_list_assignments_for_a_classroom(
        self,
        classroom_id: int,
        page: Missing[int] = 1,
        per_page: Missing[int] = 30,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[SimpleClassroomAssignment]]":
        url = f"/classrooms/{classroom_id}/assignments"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleClassroomAssignment],
        )
