"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from __future__ import annotations

from datetime import date, datetime
from typing import Any, List, Union, Literal, Annotated

from pydantic import Extra, Field, BaseModel

from githubkit.utils import UNSET, Missing


class GitHubRestModel(BaseModel):
    model_config = {"extra": Extra.allow, "populate_by_name": True}


class Root(GitHubRestModel):
    """Root"""

    current_user_url: str = Field(default=...)
    current_user_authorizations_html_url: str = Field(default=...)
    authorizations_url: str = Field(default=...)
    code_search_url: str = Field(default=...)
    commit_search_url: str = Field(default=...)
    emails_url: str = Field(default=...)
    emojis_url: str = Field(default=...)
    events_url: str = Field(default=...)
    feeds_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    hub_url: str = Field(default=...)
    issue_search_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    label_search_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    organization_url: str = Field(default=...)
    organization_repositories_url: str = Field(default=...)
    organization_teams_url: str = Field(default=...)
    public_gists_url: str = Field(default=...)
    rate_limit_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    repository_search_url: str = Field(default=...)
    current_user_repositories_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    starred_gists_url: str = Field(default=...)
    topic_search_url: Missing[str] = Field(default=UNSET)
    user_url: str = Field(default=...)
    user_organizations_url: str = Field(default=...)
    user_repositories_url: str = Field(default=...)
    user_search_url: str = Field(default=...)


class SimpleUser(GitHubRestModel):
    """Simple User

    A GitHub user.
    """

    name: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_at: Missing[str] = Field(default=UNSET)


class GlobalAdvisory(GitHubRestModel):
    """GlobalAdvisory

    A GitHub Security Advisory.
    """

    ghsa_id: str = Field(description="The GitHub Security Advisory ID.", default=...)
    cve_id: Union[str, None] = Field(
        description="The Common Vulnerabilities and Exposures (CVE) ID.", default=...
    )
    url: str = Field(description="The API URL for the advisory.", default=...)
    html_url: str = Field(description="The URL for the advisory.", default=...)
    repository_advisory_url: Union[str, None] = Field(
        description="The API URL for the repository advisory.", default=...
    )
    summary: str = Field(
        description="A short summary of the advisory.", max_length=1024, default=...
    )
    description: Union[str, None] = Field(
        description="A detailed description of what the advisory entails.", default=...
    )
    type: Literal["reviewed", "unreviewed", "malware"] = Field(
        description="The type of advisory.", default=...
    )
    severity: Literal["critical", "high", "medium", "low", "unknown"] = Field(
        description="The severity of the advisory.", default=...
    )
    source_code_location: Union[str, None] = Field(
        description="The URL of the advisory's source code.", default=...
    )
    identifiers: Union[List[GlobalAdvisoryPropIdentifiersItems], None] = Field(
        default=...
    )
    references: Union[List[str], None] = Field(default=...)
    published_at: datetime = Field(
        description="The date and time of when the advisory was published, in ISO 8601 format.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The date and time of when the advisory was last updated, in ISO 8601 format.",
        default=...,
    )
    github_reviewed_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was reviewed by GitHub, in ISO 8601 format.",
        default=...,
    )
    nvd_published_at: Union[datetime, None] = Field(
        description="The date and time when the advisory was published in the National Vulnerability Database, in ISO 8601 format.\nThis field is only populated when the advisory is imported from the National Vulnerability Database.",
        default=...,
    )
    withdrawn_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was withdrawn, in ISO 8601 format.",
        default=...,
    )
    vulnerabilities: Union[List[GlobalAdvisoryPropVulnerabilitiesItems], None] = Field(
        description="The products and respective version ranges affected by the advisory.",
        default=...,
    )
    cvss: Union[GlobalAdvisoryPropCvss, None] = Field(default=...)
    cwes: Union[List[GlobalAdvisoryPropCwesItems], None] = Field(default=...)
    credits_: Union[List[GlobalAdvisoryPropCreditsItems], None] = Field(
        description="The users who contributed to the advisory.",
        default=...,
        alias="credits",
    )


class GlobalAdvisoryPropIdentifiersItems(GitHubRestModel):
    """GlobalAdvisoryPropIdentifiersItems"""

    type: Literal["CVE", "GHSA"] = Field(
        description="The type of identifier.", default=...
    )
    value: str = Field(description="The identifier value.", default=...)


class GlobalAdvisoryPropVulnerabilitiesItems(GitHubRestModel):
    """GlobalAdvisoryPropVulnerabilitiesItems"""

    package: Union[GlobalAdvisoryPropVulnerabilitiesItemsPropPackage, None] = Field(
        description="The name of the package affected by the vulnerability.",
        default=...,
    )
    vulnerable_version_range: Union[str, None] = Field(
        description="The range of the package versions affected by the vulnerability.",
        default=...,
    )
    first_patched_version: Union[str, None] = Field(
        description="The package version that resolve the vulnerability.", default=...
    )
    vulnerable_functions: Union[List[str], None] = Field(
        description="The functions in the package that are affected by the vulnerability.",
        default=...,
    )


class GlobalAdvisoryPropVulnerabilitiesItemsPropPackage(GitHubRestModel):
    """GlobalAdvisoryPropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(
        description="The package's language or package management ecosystem.",
        default=...,
    )
    name: Union[str, None] = Field(
        description="The unique package name within its ecosystem.", default=...
    )


class GlobalAdvisoryPropCvss(GitHubRestModel):
    """GlobalAdvisoryPropCvss"""

    vector_string: Union[str, None] = Field(description="The CVSS vector.", default=...)
    score: Union[float, None] = Field(description="The CVSS score.", default=...)


class GlobalAdvisoryPropCwesItems(GitHubRestModel):
    """GlobalAdvisoryPropCwesItems"""

    cwe_id: str = Field(
        description="The Common Weakness Enumeration (CWE) identifier.", default=...
    )
    name: str = Field(description="The name of the CWE.", default=...)


class GlobalAdvisoryPropCreditsItems(GitHubRestModel):
    """GlobalAdvisoryPropCreditsItems"""

    user: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ] = Field(description="The type of credit the user is receiving.", default=...)


class BasicError(GitHubRestModel):
    """Basic Error

    Basic Error
    """

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    status: Missing[str] = Field(default=UNSET)


class ValidationErrorSimple(GitHubRestModel):
    """Validation Error Simple

    Validation Error Simple
    """

    message: str = Field(default=...)
    documentation_url: str = Field(default=...)
    errors: Missing[List[str]] = Field(default=UNSET)


class Integration(GitHubRestModel):
    """GitHub app

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    id: int = Field(description="Unique identifier of the GitHub app", default=...)
    slug: Missing[str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    node_id: str = Field(default=...)
    owner: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    description: Union[str, None] = Field(default=...)
    external_url: str = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    permissions: IntegrationPropPermissions = Field(
        description="The set of permissions for the GitHub app", default=...
    )
    events: List[str] = Field(
        description="The list of events for the GitHub app", default=...
    )
    installations_count: Missing[int] = Field(
        description="The number of installations associated with the GitHub app",
        default=UNSET,
    )
    client_id: Missing[str] = Field(default=UNSET)
    client_secret: Missing[str] = Field(default=UNSET)
    webhook_secret: Missing[Union[str, None]] = Field(default=UNSET)
    pem: Missing[str] = Field(default=UNSET)


class IntegrationPropPermissions(GitHubRestModel, extra=Extra.allow):
    """IntegrationPropPermissions

    The set of permissions for the GitHub app

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """

    issues: Missing[str] = Field(default=UNSET)
    checks: Missing[str] = Field(default=UNSET)
    metadata: Missing[str] = Field(default=UNSET)
    contents: Missing[str] = Field(default=UNSET)
    deployments: Missing[str] = Field(default=UNSET)


class WebhookConfig(GitHubRestModel):
    """Webhook Configuration

    Configuration object of the webhook
    """

    url: Missing[str] = Field(
        description="The URL to which the payloads will be delivered.", default=UNSET
    )
    content_type: Missing[str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    insecure_ssl: Missing[Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )


class HookDeliveryItem(GitHubRestModel):
    """Simple webhook delivery

    Delivery made by a webhook, without request and response information.
    """

    id: int = Field(
        description="Unique identifier of the webhook delivery.", default=...
    )
    guid: str = Field(
        description="Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).",
        default=...,
    )
    delivered_at: datetime = Field(
        description="Time when the webhook delivery occurred.", default=...
    )
    redelivery: bool = Field(
        description="Whether the webhook delivery is a redelivery.", default=...
    )
    duration: float = Field(description="Time spent delivering.", default=...)
    status: str = Field(
        description="Describes the response returned after attempting the delivery.",
        default=...,
    )
    status_code: int = Field(
        description="Status code received when delivery was made.", default=...
    )
    event: str = Field(
        description="The event that triggered the delivery.", default=...
    )
    action: Union[str, None] = Field(
        description="The type of activity for the event that triggered the delivery.",
        default=...,
    )
    installation_id: Union[int, None] = Field(
        description="The id of the GitHub App installation associated with this event.",
        default=...,
    )
    repository_id: Union[int, None] = Field(
        description="The id of the repository associated with this event.", default=...
    )


class ScimError(GitHubRestModel):
    """Scim Error

    Scim Error
    """

    message: Missing[Union[str, None]] = Field(default=UNSET)
    documentation_url: Missing[Union[str, None]] = Field(default=UNSET)
    detail: Missing[Union[str, None]] = Field(default=UNSET)
    status: Missing[int] = Field(default=UNSET)
    scim_type: Missing[Union[str, None]] = Field(default=UNSET, alias="scimType")
    schemas: Missing[List[str]] = Field(default=UNSET)


class ValidationError(GitHubRestModel):
    """Validation Error

    Validation Error
    """

    message: str = Field(default=...)
    documentation_url: str = Field(default=...)
    errors: Missing[List[ValidationErrorPropErrorsItems]] = Field(default=UNSET)


class ValidationErrorPropErrorsItems(GitHubRestModel):
    """ValidationErrorPropErrorsItems"""

    resource: Missing[str] = Field(default=UNSET)
    field: Missing[str] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    code: str = Field(default=...)
    index: Missing[int] = Field(default=UNSET)
    value: Missing[Union[str, None, int, None, List[str], None]] = Field(default=UNSET)


class HookDelivery(GitHubRestModel):
    """Webhook delivery

    Delivery made by a webhook.
    """

    id: int = Field(description="Unique identifier of the delivery.", default=...)
    guid: str = Field(
        description="Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).",
        default=...,
    )
    delivered_at: datetime = Field(
        description="Time when the delivery was delivered.", default=...
    )
    redelivery: bool = Field(
        description="Whether the delivery is a redelivery.", default=...
    )
    duration: float = Field(description="Time spent delivering.", default=...)
    status: str = Field(
        description="Description of the status of the attempted delivery", default=...
    )
    status_code: int = Field(
        description="Status code received when delivery was made.", default=...
    )
    event: str = Field(
        description="The event that triggered the delivery.", default=...
    )
    action: Union[str, None] = Field(
        description="The type of activity for the event that triggered the delivery.",
        default=...,
    )
    installation_id: Union[int, None] = Field(
        description="The id of the GitHub App installation associated with this event.",
        default=...,
    )
    repository_id: Union[int, None] = Field(
        description="The id of the repository associated with this event.", default=...
    )
    url: Missing[str] = Field(
        description="The URL target of the delivery.", default=UNSET
    )
    request: HookDeliveryPropRequest = Field(default=...)
    response: HookDeliveryPropResponse = Field(default=...)


class HookDeliveryPropRequest(GitHubRestModel):
    """HookDeliveryPropRequest"""

    headers: Union[HookDeliveryPropRequestPropHeaders, None] = Field(
        description="The request headers sent with the webhook delivery.", default=...
    )
    payload: Union[HookDeliveryPropRequestPropPayload, None] = Field(
        description="The webhook payload.", default=...
    )


class HookDeliveryPropRequestPropHeaders(GitHubRestModel, extra=Extra.allow):
    """HookDeliveryPropRequestPropHeaders

    The request headers sent with the webhook delivery.
    """


class HookDeliveryPropRequestPropPayload(GitHubRestModel, extra=Extra.allow):
    """HookDeliveryPropRequestPropPayload

    The webhook payload.
    """


class HookDeliveryPropResponse(GitHubRestModel):
    """HookDeliveryPropResponse"""

    headers: Union[HookDeliveryPropResponsePropHeaders, None] = Field(
        description="The response headers received when the delivery was made.",
        default=...,
    )
    payload: Union[str, None] = Field(
        description="The response payload received.", default=...
    )


class HookDeliveryPropResponsePropHeaders(GitHubRestModel, extra=Extra.allow):
    """HookDeliveryPropResponsePropHeaders

    The response headers received when the delivery was made.
    """


class Enterprise(GitHubRestModel):
    """Enterprise

    An enterprise on GitHub.
    """

    description: Missing[Union[str, None]] = Field(
        description="A short description of the enterprise.", default=UNSET
    )
    html_url: str = Field(default=...)
    website_url: Missing[Union[str, None]] = Field(
        description="The enterprise's website URL.", default=UNSET
    )
    id: int = Field(description="Unique identifier of the enterprise", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the enterprise.", default=...)
    slug: str = Field(
        description="The slug url identifier for the enterprise.", default=...
    )
    created_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    avatar_url: str = Field(default=...)


class IntegrationInstallationRequest(GitHubRestModel):
    """Integration Installation Request

    Request to install an integration on a target
    """

    id: int = Field(
        description="Unique identifier of the request installation.", default=...
    )
    node_id: Missing[str] = Field(default=UNSET)
    account: Union[SimpleUser, Enterprise] = Field(
        title="Enterprise", description="An enterprise on GitHub.", default=...
    )
    requester: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    created_at: datetime = Field(default=...)


class AppPermissions(GitHubRestModel):
    """App Permissions

    The permissions granted to the user access token.

    Examples:
        {'contents': 'read', 'issues': 'read', 'deployments': 'write', 'single_file':
    'read'}
    """

    actions: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.",
        default=UNSET,
    )
    administration: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.",
        default=UNSET,
    )
    checks: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for checks on code.",
        default=UNSET,
    )
    contents: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.",
        default=UNSET,
    )
    deployments: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for deployments and deployment statuses.",
        default=UNSET,
    )
    environments: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for managing repository environments.",
        default=UNSET,
    )
    issues: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.",
        default=UNSET,
    )
    metadata: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.",
        default=UNSET,
    )
    packages: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for packages published to GitHub Packages.",
        default=UNSET,
    )
    pages: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.",
        default=UNSET,
    )
    pull_requests: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.",
        default=UNSET,
    )
    repository_hooks: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage the post-receive hooks for a repository.",
        default=UNSET,
    )
    repository_projects: Missing[Literal["read", "write", "admin"]] = Field(
        description="The level of permission to grant the access token to manage repository projects, columns, and cards.",
        default=UNSET,
    )
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage secret scanning alerts.",
        default=UNSET,
    )
    secrets: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage repository secrets.",
        default=UNSET,
    )
    security_events: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage security events like code scanning alerts.",
        default=UNSET,
    )
    single_file: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage just a single file.",
        default=UNSET,
    )
    statuses: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for commit statuses.",
        default=UNSET,
    )
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage Dependabot alerts.",
        default=UNSET,
    )
    workflows: Missing[Literal["write"]] = Field(
        description="The level of permission to grant the access token to update GitHub Actions workflow files.",
        default=UNSET,
    )
    members: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for organization teams and members.",
        default=UNSET,
    )
    organization_administration: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage access to an organization.",
        default=UNSET,
    )
    organization_custom_roles: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for custom repository roles management. This property is in beta and is subject to change.",
        default=UNSET,
    )
    organization_announcement_banners: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage announcement banners for an organization.",
        default=UNSET,
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage the post-receive hooks for an organization.",
        default=UNSET,
    )
    organization_personal_access_tokens: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.",
        default=UNSET,
    )
    organization_personal_access_token_requests: Missing[
        Literal["read", "write"]
    ] = Field(
        description="The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.",
        default=UNSET,
    )
    organization_plan: Missing[Literal["read"]] = Field(
        description="The level of permission to grant the access token for viewing an organization's plan.",
        default=UNSET,
    )
    organization_projects: Missing[Literal["read", "write", "admin"]] = Field(
        description="The level of permission to grant the access token to manage organization projects and projects beta (where available).",
        default=UNSET,
    )
    organization_packages: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token for organization packages published to GitHub Packages.",
        default=UNSET,
    )
    organization_secrets: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage organization secrets.",
        default=UNSET,
    )
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.",
        default=UNSET,
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to view and manage users blocked by the organization.",
        default=UNSET,
    )
    team_discussions: Missing[Literal["read", "write"]] = Field(
        description="The level of permission to grant the access token to manage team discussions and related comments.",
        default=UNSET,
    )


class Installation(GitHubRestModel):
    """Installation

    Installation
    """

    id: int = Field(description="The ID of the installation.", default=...)
    account: Union[SimpleUser, Enterprise, None] = Field(
        title="Enterprise", description="An enterprise on GitHub.", default=...
    )
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=...,
    )
    access_tokens_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    html_url: str = Field(default=...)
    app_id: int = Field(default=...)
    target_id: int = Field(
        description="The ID of the user or organization this token is being scoped to.",
        default=...,
    )
    target_type: str = Field(default=...)
    permissions: AppPermissions = Field(
        title="App Permissions",
        description="The permissions granted to the user access token.",
        default=...,
    )
    events: List[str] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    single_file_name: Union[str, None] = Field(default=...)
    has_multiple_single_files: Missing[bool] = Field(default=UNSET)
    single_file_paths: Missing[List[str]] = Field(default=UNSET)
    app_slug: str = Field(default=...)
    suspended_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    suspended_at: Union[datetime, None] = Field(default=...)
    contact_email: Missing[Union[str, None]] = Field(default=UNSET)


class LicenseSimple(GitHubRestModel):
    """License Simple

    License Simple
    """

    key: str = Field(default=...)
    name: str = Field(default=...)
    url: Union[str, None] = Field(default=...)
    spdx_id: Union[str, None] = Field(default=...)
    node_id: str = Field(default=...)
    html_url: Missing[str] = Field(default=UNSET)


class Repository(GitHubRestModel):
    """Repository

    A repository on GitHub.
    """

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    organization: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    forks: int = Field(default=...)
    permissions: Missing[RepositoryPropPermissions] = Field(default=UNSET)
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    private: bool = Field(
        description="Whether the repository is private or public.", default=False
    )
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    forks_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    hooks_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    forks_count: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    size: int = Field(
        description="The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.",
        default=...,
    )
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    open_issues_count: int = Field(default=...)
    is_template: Missing[bool] = Field(
        description="Whether this repository acts as a template that can be used to generate new repositories.",
        default=False,
    )
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_discussions: Missing[bool] = Field(
        description="Whether discussions are enabled.", default=False
    )
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: bool = Field(
        description="Returns whether or not this repository disabled.", default=...
    )
    visibility: Missing[str] = Field(
        description="The repository visibility: public, private, or internal.",
        default="public",
    )
    pushed_at: Union[datetime, None] = Field(default=...)
    created_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    allow_rebase_merge: Missing[bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    template_repository: Missing[Union[RepositoryPropTemplateRepository, None]] = Field(
        default=UNSET
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_auto_merge: Missing[bool] = Field(
        description="Whether to allow Auto-merge to be used on pull requests.",
        default=False,
    )
    delete_branch_on_merge: Missing[bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    allow_update_branch: Missing[bool] = Field(
        description="Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.",
        default=False,
    )
    use_squash_pr_title_as_default: Missing[bool] = Field(
        description="Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.",
        default=False,
    )
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    allow_merge_commit: Missing[bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_forking: Missing[bool] = Field(
        description="Whether to allow forking this repo", default=UNSET
    )
    web_commit_signoff_required: Missing[bool] = Field(
        description="Whether to require contributors to sign off on web-based commits",
        default=False,
    )
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    master_branch: Missing[str] = Field(default=UNSET)
    starred_at: Missing[str] = Field(default=UNSET)
    anonymous_access_enabled: Missing[bool] = Field(
        description="Whether anonymous git access is enabled for this repository",
        default=UNSET,
    )


class RepositoryPropPermissions(GitHubRestModel):
    """RepositoryPropPermissions"""

    admin: bool = Field(default=...)
    pull: bool = Field(default=...)
    triage: Missing[bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    maintain: Missing[bool] = Field(default=UNSET)


class RepositoryPropTemplateRepositoryPropOwner(GitHubRestModel):
    """RepositoryPropTemplateRepositoryPropOwner"""

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)


class RepositoryPropTemplateRepositoryPropPermissions(GitHubRestModel):
    """RepositoryPropTemplateRepositoryPropPermissions"""

    admin: Missing[bool] = Field(default=UNSET)
    maintain: Missing[bool] = Field(default=UNSET)
    push: Missing[bool] = Field(default=UNSET)
    triage: Missing[bool] = Field(default=UNSET)
    pull: Missing[bool] = Field(default=UNSET)


class RepositoryPropTemplateRepository(GitHubRestModel):
    """RepositoryPropTemplateRepository"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    owner: Missing[RepositoryPropTemplateRepositoryPropOwner] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    description: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    git_url: Missing[str] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    ssh_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    clone_url: Missing[str] = Field(default=UNSET)
    mirror_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    svn_url: Missing[str] = Field(default=UNSET)
    homepage: Missing[str] = Field(default=UNSET)
    language: Missing[str] = Field(default=UNSET)
    forks_count: Missing[int] = Field(default=UNSET)
    stargazers_count: Missing[int] = Field(default=UNSET)
    watchers_count: Missing[int] = Field(default=UNSET)
    size: Missing[int] = Field(default=UNSET)
    default_branch: Missing[str] = Field(default=UNSET)
    open_issues_count: Missing[int] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: Missing[bool] = Field(default=UNSET)
    has_projects: Missing[bool] = Field(default=UNSET)
    has_wiki: Missing[bool] = Field(default=UNSET)
    has_pages: Missing[bool] = Field(default=UNSET)
    has_downloads: Missing[bool] = Field(default=UNSET)
    archived: Missing[bool] = Field(default=UNSET)
    disabled: Missing[bool] = Field(default=UNSET)
    visibility: Missing[str] = Field(default=UNSET)
    pushed_at: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    permissions: Missing[RepositoryPropTemplateRepositoryPropPermissions] = Field(
        default=UNSET
    )
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_auto_merge: Missing[bool] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Missing[bool] = Field(default=UNSET)
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)


class InstallationToken(GitHubRestModel):
    """Installation Token

    Authentication token for a GitHub App installed on a user or org.
    """

    token: str = Field(default=...)
    expires_at: str = Field(default=...)
    permissions: Missing[AppPermissions] = Field(
        title="App Permissions",
        description="The permissions granted to the user access token.",
        default=UNSET,
    )
    repository_selection: Missing[Literal["all", "selected"]] = Field(default=UNSET)
    repositories: Missing[List[Repository]] = Field(default=UNSET)
    single_file: Missing[str] = Field(default=UNSET)
    has_multiple_single_files: Missing[bool] = Field(default=UNSET)
    single_file_paths: Missing[List[str]] = Field(default=UNSET)


class ScopedInstallation(GitHubRestModel):
    """Scoped Installation"""

    permissions: AppPermissions = Field(
        title="App Permissions",
        description="The permissions granted to the user access token.",
        default=...,
    )
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=...,
    )
    single_file_name: Union[str, None] = Field(default=...)
    has_multiple_single_files: Missing[bool] = Field(default=UNSET)
    single_file_paths: Missing[List[str]] = Field(default=UNSET)
    repositories_url: str = Field(default=...)
    account: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class Authorization(GitHubRestModel):
    """Authorization

    The authorization for an OAuth app, GitHub App, or a Personal Access Token.
    """

    id: int = Field(default=...)
    url: str = Field(default=...)
    scopes: Union[List[str], None] = Field(
        description="A list of scopes that this authorization is in.", default=...
    )
    token: str = Field(default=...)
    token_last_eight: Union[str, None] = Field(default=...)
    hashed_token: Union[str, None] = Field(default=...)
    app: AuthorizationPropApp = Field(default=...)
    note: Union[str, None] = Field(default=...)
    note_url: Union[str, None] = Field(default=...)
    updated_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)
    fingerprint: Union[str, None] = Field(default=...)
    user: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    installation: Missing[Union[None, ScopedInstallation]] = Field(
        title="Scoped Installation", default=UNSET
    )
    expires_at: Union[datetime, None] = Field(default=...)


class AuthorizationPropApp(GitHubRestModel):
    """AuthorizationPropApp"""

    client_id: str = Field(default=...)
    name: str = Field(default=...)
    url: str = Field(default=...)


class SimpleClassroomRepository(GitHubRestModel):
    """Simple Classroom Repository

    A GitHub repository view for Classroom
    """

    id: int = Field(description="A unique identifier of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique name of the repository.", default=...
    )
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    private: bool = Field(description="Whether the repository is private.", default=...)
    default_branch: str = Field(
        description="The default branch for the repository.", default=...
    )


class SimpleClassroomOrganization(GitHubRestModel):
    """Organization Simple for Classroom

    A GitHub organization.
    """

    id: int = Field(default=...)
    login: str = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    name: Union[str, None] = Field(default=...)
    avatar_url: str = Field(default=...)


class Classroom(GitHubRestModel):
    """Classroom

    A GitHub Classroom classroom
    """

    id: int = Field(description="Unique identifier of the classroom.", default=...)
    name: str = Field(description="The name of the classroom.", default=...)
    archived: bool = Field(description="Whether classroom is archived.", default=...)
    organization: SimpleClassroomOrganization = Field(
        title="Organization Simple for Classroom",
        description="A GitHub organization.",
        default=...,
    )
    url: str = Field(
        description="The URL of the classroom on GitHub Classroom.", default=...
    )


class ClassroomAssignment(GitHubRestModel):
    """Classroom Assignment

    A GitHub Classroom assignment
    """

    id: int = Field(description="Unique identifier of the repository.", default=...)
    public_repo: bool = Field(
        description="Whether an accepted assignment creates a public repository.",
        default=...,
    )
    title: str = Field(description="Assignment title.", default=...)
    type: Literal["individual", "group"] = Field(
        description="Whether it's a group assignment or individual assignment.",
        default=...,
    )
    invite_link: str = Field(
        description="The link that a student can use to accept the assignment.",
        default=...,
    )
    invitations_enabled: bool = Field(
        description="Whether the invitation link is enabled. Visiting an enabled invitation link will accept the assignment.",
        default=...,
    )
    slug: str = Field(description="Sluggified name of the assignment.", default=...)
    students_are_repo_admins: bool = Field(
        description="Whether students are admins on created repository when a student accepts the assignment.",
        default=...,
    )
    feedback_pull_requests_enabled: bool = Field(
        description="Whether feedback pull request will be created when a student accepts the assignment.",
        default=...,
    )
    max_teams: Union[int, None] = Field(
        description="The maximum allowable teams for the assignment.", default=...
    )
    max_members: Union[int, None] = Field(
        description="The maximum allowable members per team.", default=...
    )
    editor: str = Field(
        description="The selected editor for the assignment.", default=...
    )
    accepted: int = Field(
        description="The number of students that have accepted the assignment.",
        default=...,
    )
    submitted: int = Field(
        description="The number of students that have submitted the assignment.",
        default=...,
    )
    passing: int = Field(
        description="The number of students that have passed the assignment.",
        default=...,
    )
    language: str = Field(
        description="The programming language used in the assignment.", default=...
    )
    deadline: Union[datetime, None] = Field(
        description="The time at which the assignment is due.", default=...
    )
    starter_code_repository: SimpleClassroomRepository = Field(
        title="Simple Classroom Repository",
        description="A GitHub repository view for Classroom",
        default=...,
    )
    classroom: Classroom = Field(
        title="Classroom", description="A GitHub Classroom classroom", default=...
    )


class SimpleClassroomUser(GitHubRestModel):
    """Simple Classroom User

    A GitHub user simplified for Classroom.
    """

    id: int = Field(default=...)
    login: str = Field(default=...)
    avatar_url: str = Field(default=...)
    html_url: str = Field(default=...)


class SimpleClassroom(GitHubRestModel):
    """Simple Classroom

    A GitHub Classroom classroom
    """

    id: int = Field(description="Unique identifier of the classroom.", default=...)
    name: str = Field(description="The name of the classroom.", default=...)
    archived: bool = Field(
        description="Returns whether classroom is archived or not.", default=...
    )
    url: str = Field(
        description="The url of the classroom on GitHub Classroom.", default=...
    )


class SimpleClassroomAssignment(GitHubRestModel):
    """Simple Classroom Assignment

    A GitHub Classroom assignment
    """

    id: int = Field(description="Unique identifier of the repository.", default=...)
    public_repo: bool = Field(
        description="Whether an accepted assignment creates a public repository.",
        default=...,
    )
    title: str = Field(description="Assignment title.", default=...)
    type: Literal["individual", "group"] = Field(
        description="Whether it's a Group Assignment or Individual Assignment.",
        default=...,
    )
    invite_link: str = Field(
        description="The link that a student can use to accept the assignment.",
        default=...,
    )
    invitations_enabled: bool = Field(
        description="Whether the invitation link is enabled. Visiting an enabled invitation link will accept the assignment.",
        default=...,
    )
    slug: str = Field(description="Sluggified name of the assignment.", default=...)
    students_are_repo_admins: bool = Field(
        description="Whether students are admins on created repository on accepted assignment.",
        default=...,
    )
    feedback_pull_requests_enabled: bool = Field(
        description="Whether feedback pull request will be created on assignment acceptance.",
        default=...,
    )
    max_teams: Missing[Union[int, None]] = Field(
        description="The maximum allowable teams for the assignment.", default=UNSET
    )
    max_members: Missing[Union[int, None]] = Field(
        description="The maximum allowable members per team.", default=UNSET
    )
    editor: str = Field(
        description="The selected editor for the assignment.", default=...
    )
    accepted: int = Field(
        description="The number of students that have accepted the assignment.",
        default=...,
    )
    submitted: int = Field(
        description="The number of students that have submitted the assignment.",
        default=...,
    )
    passing: int = Field(
        description="The number of students that have passed the assignment.",
        default=...,
    )
    language: str = Field(
        description="The programming language used in the assignment.", default=...
    )
    deadline: Union[datetime, None] = Field(
        description="The time at which the assignment is due.", default=...
    )
    classroom: SimpleClassroom = Field(
        title="Simple Classroom",
        description="A GitHub Classroom classroom",
        default=...,
    )


class ClassroomAcceptedAssignment(GitHubRestModel):
    """Classroom Accepted Assignment

    A GitHub Classroom accepted assignment
    """

    id: int = Field(description="Unique identifier of the repository.", default=...)
    submitted: bool = Field(
        description="Whether an accepted assignment has been submitted.", default=...
    )
    passing: bool = Field(description="Whether a submission passed.", default=...)
    commit_count: int = Field(description="Count of student commits.", default=...)
    grade: str = Field(description="Most recent grade.", default=...)
    students: List[SimpleClassroomUser] = Field(default=...)
    repository: SimpleClassroomRepository = Field(
        title="Simple Classroom Repository",
        description="A GitHub repository view for Classroom",
        default=...,
    )
    assignment: SimpleClassroomAssignment = Field(
        title="Simple Classroom Assignment",
        description="A GitHub Classroom assignment",
        default=...,
    )


class ClassroomAssignmentGrade(GitHubRestModel):
    """Classroom Assignment Grade

    Grade for a student or groups GitHub Classroom assignment
    """

    assignment_name: str = Field(description="Name of the assignment", default=...)
    assignment_url: str = Field(description="URL of the assignment", default=...)
    starter_code_url: str = Field(
        description="URL of the starter code for the assignment", default=...
    )
    github_username: str = Field(
        description="GitHub username of the student", default=...
    )
    roster_identifier: str = Field(
        description="Roster identifier of the student", default=...
    )
    student_repository_name: str = Field(
        description="Name of the student's assignment repository", default=...
    )
    student_repository_url: str = Field(
        description="URL of the student's assignment repository", default=...
    )
    submission_timestamp: str = Field(
        description="Timestamp of the student's assignment submission", default=...
    )
    points_awarded: int = Field(
        description="Number of points awarded to the student", default=...
    )
    points_available: int = Field(
        description="Number of points available for the assignment", default=...
    )
    group_name: Missing[str] = Field(
        description="If a group assignment, name of the group the student is in",
        default=UNSET,
    )


class CodeOfConduct(GitHubRestModel):
    """Code Of Conduct

    Code Of Conduct
    """

    key: str = Field(default=...)
    name: str = Field(default=...)
    url: str = Field(default=...)
    body: Missing[str] = Field(default=UNSET)
    html_url: Union[str, None] = Field(default=...)


class DependabotAlertPackage(GitHubRestModel):
    """DependabotAlertPackage

    Details for the vulnerable package.
    """

    ecosystem: str = Field(
        description="The package's language or package management ecosystem.",
        default=...,
    )
    name: str = Field(
        description="The unique package name within its ecosystem.", default=...
    )


class DependabotAlertSecurityVulnerability(GitHubRestModel):
    """DependabotAlertSecurityVulnerability

    Details pertaining to one vulnerable version range for the advisory.
    """

    package: DependabotAlertPackage = Field(
        description="Details for the vulnerable package.", default=...
    )
    severity: Literal["low", "medium", "high", "critical"] = Field(
        description="The severity of the vulnerability.", default=...
    )
    vulnerable_version_range: str = Field(
        description="Conditions that identify vulnerable versions of this vulnerability's package.",
        default=...,
    )
    first_patched_version: Union[
        DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion, None
    ] = Field(
        description="Details pertaining to the package version that patches this vulnerability.",
        default=...,
    )


class DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion(GitHubRestModel):
    """DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion

    Details pertaining to the package version that patches this vulnerability.
    """

    identifier: str = Field(
        description="The package version that patches this vulnerability.", default=...
    )


class DependabotAlertSecurityAdvisory(GitHubRestModel):
    """DependabotAlertSecurityAdvisory

    Details for the GitHub Security Advisory.
    """

    ghsa_id: str = Field(
        description="The unique GitHub Security Advisory ID assigned to the advisory.",
        default=...,
    )
    cve_id: Union[str, None] = Field(
        description="The unique CVE ID assigned to the advisory.", default=...
    )
    summary: str = Field(
        description="A short, plain text summary of the advisory.",
        max_length=1024,
        default=...,
    )
    description: str = Field(
        description="A long-form Markdown-supported description of the advisory.",
        default=...,
    )
    vulnerabilities: List[DependabotAlertSecurityVulnerability] = Field(
        description="Vulnerable version range information for the advisory.",
        default=...,
    )
    severity: Literal["low", "medium", "high", "critical"] = Field(
        description="The severity of the advisory.", default=...
    )
    cvss: DependabotAlertSecurityAdvisoryPropCvss = Field(
        description="Details for the advisory pertaining to the Common Vulnerability Scoring System.",
        default=...,
    )
    cwes: List[DependabotAlertSecurityAdvisoryPropCwesItems] = Field(
        description="Details for the advisory pertaining to Common Weakness Enumeration.",
        default=...,
    )
    identifiers: List[DependabotAlertSecurityAdvisoryPropIdentifiersItems] = Field(
        description="Values that identify this advisory among security information sources.",
        default=...,
    )
    references: List[DependabotAlertSecurityAdvisoryPropReferencesItems] = Field(
        description="Links to additional advisory information.", default=...
    )
    published_at: datetime = Field(
        description="The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    withdrawn_at: Union[datetime, None] = Field(
        description="The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )


class DependabotAlertSecurityAdvisoryPropCvss(GitHubRestModel):
    """DependabotAlertSecurityAdvisoryPropCvss

    Details for the advisory pertaining to the Common Vulnerability Scoring System.
    """

    score: float = Field(
        description="The overall CVSS score of the advisory.", le=10.0, default=...
    )
    vector_string: Union[str, None] = Field(
        description="The full CVSS vector string for the advisory.", default=...
    )


class DependabotAlertSecurityAdvisoryPropCwesItems(GitHubRestModel):
    """DependabotAlertSecurityAdvisoryPropCwesItems

    A CWE weakness assigned to the advisory.
    """

    cwe_id: str = Field(description="The unique CWE ID.", default=...)
    name: str = Field(description="The short, plain text name of the CWE.", default=...)


class DependabotAlertSecurityAdvisoryPropIdentifiersItems(GitHubRestModel):
    """DependabotAlertSecurityAdvisoryPropIdentifiersItems

    An advisory identifier.
    """

    type: Literal["CVE", "GHSA"] = Field(
        description="The type of advisory identifier.", default=...
    )
    value: str = Field(description="The value of the advisory identifer.", default=...)


class DependabotAlertSecurityAdvisoryPropReferencesItems(GitHubRestModel):
    """DependabotAlertSecurityAdvisoryPropReferencesItems

    A link to additional advisory information.
    """

    url: str = Field(description="The URL of the reference.", default=...)


class SimpleRepository(GitHubRestModel):
    """Simple Repository

    A GitHub repository.
    """

    id: int = Field(description="A unique identifier of the repository.", default=...)
    node_id: str = Field(
        description="The GraphQL identifier of the repository.", default=...
    )
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(
        description="The full, globally unique, name of the repository.", default=...
    )
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    private: bool = Field(description="Whether the repository is private.", default=...)
    html_url: str = Field(
        description="The URL to view the repository on GitHub.com.", default=...
    )
    description: Union[str, None] = Field(
        description="The repository description.", default=...
    )
    fork: bool = Field(description="Whether the repository is a fork.", default=...)
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API.",
        default=...,
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive.",
        default=...,
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository.",
        default=...,
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository.",
        default=...,
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository.",
        default=...,
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository.",
        default=...,
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository.",
        default=...,
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository.",
        default=...,
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs.",
        default=...,
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository.",
        default=...,
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository.",
        default=...,
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository.",
        default=...,
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository.", default=...
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository.", default=...
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository.", default=...
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository.",
        default=...,
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository.",
        default=...,
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository.",
        default=...,
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository.",
        default=...,
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository.",
        default=...,
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository.",
        default=...,
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository.",
        default=...,
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository.",
        default=...,
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository.",
        default=...,
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository.", default=...
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository.",
        default=...,
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository.",
        default=...,
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository.",
        default=...,
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository.",
        default=...,
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository.", default=...
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit.",
        default=...,
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository.",
        default=...,
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository.",
        default=...,
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository.",
        default=...,
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository.", default=...
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository.",
        default=...,
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository.", default=...
    )


class DependabotAlertWithRepository(GitHubRestModel):
    """DependabotAlertWithRepository

    A Dependabot alert.
    """

    number: int = Field(description="The security alert number.", default=...)
    state: Literal["auto_dismissed", "dismissed", "fixed", "open"] = Field(
        description="The state of the Dependabot alert.", default=...
    )
    dependency: DependabotAlertWithRepositoryPropDependency = Field(
        description="Details for the vulnerable dependency.", default=...
    )
    security_advisory: DependabotAlertSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory.", default=...
    )
    security_vulnerability: DependabotAlertSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory.",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ] = Field(description="The reason that the alert was dismissed.", default=...)
    dismissed_comment: Union[str, None] = Field(
        description="An optional comment associated with the alert's dismissal.",
        default=...,
    )
    fixed_at: Union[datetime, None] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    auto_dismissed_at: Missing[Union[datetime, None]] = Field(
        description="The time that the alert was auto-dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    repository: SimpleRepository = Field(
        title="Simple Repository", description="A GitHub repository.", default=...
    )


class DependabotAlertWithRepositoryPropDependency(GitHubRestModel):
    """DependabotAlertWithRepositoryPropDependency

    Details for the vulnerable dependency.
    """

    package: Missing[DependabotAlertPackage] = Field(
        description="Details for the vulnerable package.", default=UNSET
    )
    manifest_path: Missing[str] = Field(
        description="The full path to the dependency manifest file, relative to the root of the repository.",
        default=UNSET,
    )
    scope: Missing[Union[None, Literal["development", "runtime"]]] = Field(
        description="The execution scope of the vulnerable dependency.", default=UNSET
    )


class OrganizationSecretScanningAlert(GitHubRestModel):
    """OrganizationSecretScanningAlert"""

    number: Missing[int] = Field(
        description="The security alert number.", default=UNSET
    )
    created_at: Missing[datetime] = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    updated_at: Missing[Union[None, datetime]] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: Missing[str] = Field(
        description="The REST API URL of the alert resource.", default=UNSET
    )
    html_url: Missing[str] = Field(
        description="The GitHub URL of the alert resource.", default=UNSET
    )
    locations_url: Missing[str] = Field(
        description="The REST API URL of the code locations for this alert.",
        default=UNSET,
    )
    state: Missing[Literal["open", "resolved"]] = Field(
        description="Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.",
        default=UNSET,
    )
    resolution: Missing[
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]]
    ] = Field(
        description="**Required when the `state` is `resolved`.** The reason for resolving the alert.",
        default=UNSET,
    )
    resolved_at: Missing[Union[datetime, None]] = Field(
        description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    resolved_by: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    secret_type: Missing[str] = Field(
        description="The type of secret that secret scanning detected.", default=UNSET
    )
    secret_type_display_name: Missing[str] = Field(
        description='User-friendly name for the detected secret, matching the `secret_type`.\nFor a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."',
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="The secret that was detected.", default=UNSET
    )
    repository: Missing[SimpleRepository] = Field(
        title="Simple Repository", description="A GitHub repository.", default=UNSET
    )
    push_protection_bypassed: Missing[Union[bool, None]] = Field(
        description="Whether push protection was bypassed for the detected secret.",
        default=UNSET,
    )
    push_protection_bypassed_by: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    push_protection_bypassed_at: Missing[Union[datetime, None]] = Field(
        description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    resolution_comment: Missing[Union[str, None]] = Field(
        description="The comment that was optionally added when this alert was closed",
        default=UNSET,
    )


class Actor(GitHubRestModel):
    """Actor

    Actor
    """

    id: int = Field(default=...)
    login: str = Field(default=...)
    display_login: Missing[str] = Field(default=UNSET)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    avatar_url: str = Field(default=...)


class Milestone(GitHubRestModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(description="The number of the milestone.", default=...)
    state: Literal["open", "closed"] = Field(
        description="The state of the milestone.", default="open"
    )
    title: str = Field(description="The title of the milestone.", default=...)
    description: Union[str, None] = Field(default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    open_issues: int = Field(default=...)
    closed_issues: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    due_on: Union[datetime, None] = Field(default=...)


class ReactionRollup(GitHubRestModel):
    """Reaction Rollup"""

    url: str = Field(default=...)
    total_count: int = Field(default=...)
    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    laugh: int = Field(default=...)
    confused: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    eyes: int = Field(default=...)
    rocket: int = Field(default=...)


class Issue(GitHubRestModel):
    """Issue

    Issues are a great way to keep track of tasks, enhancements, and bugs for your
    projects.
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the issue", default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the issue within its repository",
        default=...,
    )
    state: str = Field(
        description="State of the issue; either 'open' or 'closed'", default=...
    )
    state_reason: Missing[
        Union[None, Literal["completed", "reopened", "not_planned"]]
    ] = Field(description="The reason for the current state", default=UNSET)
    title: str = Field(description="Title of the issue", default=...)
    body: Missing[Union[str, None]] = Field(
        description="Contents of the issue", default=UNSET
    )
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    labels: List[Union[str, IssuePropLabelsItemsOneof1]] = Field(
        description="Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository",
        default=...,
    )
    assignee: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    assignees: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    milestone: Union[None, Milestone] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    locked: bool = Field(default=...)
    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    comments: int = Field(default=...)
    pull_request: Missing[IssuePropPullRequest] = Field(default=UNSET)
    closed_at: Union[datetime, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    draft: Missing[bool] = Field(default=UNSET)
    closed_by: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    body_html: Missing[Union[str, None]] = Field(default=UNSET)
    body_text: Missing[Union[str, None]] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    repository: Missing[Repository] = Field(
        title="Repository", description="A repository on GitHub.", default=UNSET
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)


class IssuePropLabelsItemsOneof1(GitHubRestModel):
    """IssuePropLabelsItemsOneof1"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    color: Missing[Union[str, None]] = Field(default=UNSET)
    default: Missing[bool] = Field(default=UNSET)


class IssuePropPullRequest(GitHubRestModel):
    """IssuePropPullRequest"""

    merged_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    diff_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    patch_url: Union[str, None] = Field(default=...)
    url: Union[str, None] = Field(default=...)


class IssueComment(GitHubRestModel):
    """Issue Comment

    Comments provide a way for people to collaborate on an issue.
    """

    id: int = Field(description="Unique identifier of the issue comment", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the issue comment", default=...)
    body: Missing[str] = Field(
        description="Contents of the issue comment", default=UNSET
    )
    body_text: Missing[str] = Field(default=UNSET)
    body_html: Missing[str] = Field(default=UNSET)
    html_url: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    issue_url: str = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)


class Event(GitHubRestModel):
    """Event

    Event
    """

    id: str = Field(default=...)
    type: Union[str, None] = Field(default=...)
    actor: Actor = Field(title="Actor", description="Actor", default=...)
    repo: EventPropRepo = Field(default=...)
    org: Missing[Actor] = Field(title="Actor", description="Actor", default=UNSET)
    payload: EventPropPayload = Field(default=...)
    public: bool = Field(default=...)
    created_at: Union[datetime, None] = Field(default=...)


class EventPropRepo(GitHubRestModel):
    """EventPropRepo"""

    id: int = Field(default=...)
    name: str = Field(default=...)
    url: str = Field(default=...)


class EventPropPayload(GitHubRestModel):
    """EventPropPayload"""

    action: Missing[str] = Field(default=UNSET)
    issue: Missing[Issue] = Field(
        title="Issue",
        description="Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.",
        default=UNSET,
    )
    comment: Missing[IssueComment] = Field(
        title="Issue Comment",
        description="Comments provide a way for people to collaborate on an issue.",
        default=UNSET,
    )
    pages: Missing[List[EventPropPayloadPropPagesItems]] = Field(default=UNSET)


class EventPropPayloadPropPagesItems(GitHubRestModel):
    """EventPropPayloadPropPagesItems"""

    page_name: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    summary: Missing[Union[str, None]] = Field(default=UNSET)
    action: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)


class LinkWithType(GitHubRestModel):
    """Link With Type

    Hypermedia Link with Type
    """

    href: str = Field(default=...)
    type: str = Field(default=...)


class Feed(GitHubRestModel):
    """Feed

    Feed
    """

    timeline_url: str = Field(default=...)
    user_url: str = Field(default=...)
    current_user_public_url: Missing[str] = Field(default=UNSET)
    current_user_url: Missing[str] = Field(default=UNSET)
    current_user_actor_url: Missing[str] = Field(default=UNSET)
    current_user_organization_url: Missing[str] = Field(default=UNSET)
    current_user_organization_urls: Missing[List[str]] = Field(default=UNSET)
    security_advisories_url: Missing[str] = Field(default=UNSET)
    repository_discussions_url: Missing[str] = Field(
        description="A feed of discussions for a given repository.", default=UNSET
    )
    repository_discussions_category_url: Missing[str] = Field(
        description="A feed of discussions for a given repository and category.",
        default=UNSET,
    )
    links: FeedPropLinks = Field(default=..., alias="_links")


class FeedPropLinks(GitHubRestModel):
    """FeedPropLinks"""

    timeline: LinkWithType = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=...
    )
    user: LinkWithType = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=...
    )
    security_advisories: Missing[LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user: Missing[LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user_public: Missing[LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user_actor: Missing[LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user_organization: Missing[LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    current_user_organizations: Missing[List[LinkWithType]] = Field(default=UNSET)
    repository_discussions: Missing[LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )
    repository_discussions_category: Missing[LinkWithType] = Field(
        title="Link With Type", description="Hypermedia Link with Type", default=UNSET
    )


class BaseGist(GitHubRestModel):
    """Base Gist

    Base Gist
    """

    url: str = Field(default=...)
    forks_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    id: str = Field(default=...)
    node_id: str = Field(default=...)
    git_pull_url: str = Field(default=...)
    git_push_url: str = Field(default=...)
    html_url: str = Field(default=...)
    files: BaseGistPropFiles = Field(default=...)
    public: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    description: Union[str, None] = Field(default=...)
    comments: int = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    comments_url: str = Field(default=...)
    owner: Missing[SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    truncated: Missing[bool] = Field(default=UNSET)
    forks: Missing[List[Any]] = Field(default=UNSET)
    history: Missing[List[Any]] = Field(default=UNSET)


class BaseGistPropFiles(GitHubRestModel, extra=Extra.allow):
    """BaseGistPropFiles"""


class PublicUser(GitHubRestModel):
    """Public User

    Public User
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    name: Union[str, None] = Field(default=...)
    company: Union[str, None] = Field(default=...)
    blog: Union[str, None] = Field(default=...)
    location: Union[str, None] = Field(default=...)
    email: Union[str, None] = Field(default=...)
    hireable: Union[bool, None] = Field(default=...)
    bio: Union[str, None] = Field(default=...)
    twitter_username: Missing[Union[str, None]] = Field(default=UNSET)
    public_repos: int = Field(default=...)
    public_gists: int = Field(default=...)
    followers: int = Field(default=...)
    following: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    plan: Missing[PublicUserPropPlan] = Field(default=UNSET)
    suspended_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    private_gists: Missing[int] = Field(default=UNSET)
    total_private_repos: Missing[int] = Field(default=UNSET)
    owned_private_repos: Missing[int] = Field(default=UNSET)
    disk_usage: Missing[int] = Field(default=UNSET)
    collaborators: Missing[int] = Field(default=UNSET)


class PublicUserPropPlan(GitHubRestModel):
    """PublicUserPropPlan"""

    collaborators: int = Field(default=...)
    name: str = Field(default=...)
    space: int = Field(default=...)
    private_repos: int = Field(default=...)


class GistHistory(GitHubRestModel):
    """Gist History

    Gist History
    """

    user: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    version: Missing[str] = Field(default=UNSET)
    committed_at: Missing[datetime] = Field(default=UNSET)
    change_status: Missing[GistHistoryPropChangeStatus] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class GistHistoryPropChangeStatus(GitHubRestModel):
    """GistHistoryPropChangeStatus"""

    total: Missing[int] = Field(default=UNSET)
    additions: Missing[int] = Field(default=UNSET)
    deletions: Missing[int] = Field(default=UNSET)


class GistSimple(GitHubRestModel):
    """Gist Simple

    Gist Simple
    """

    forks: Missing[Union[List[GistSimplePropForksItems], None]] = Field(default=UNSET)
    history: Missing[Union[List[GistHistory], None]] = Field(default=UNSET)
    fork_of: Missing[Union[GistSimplePropForkOf, None]] = Field(
        title="Gist", description="Gist", default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    id: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    git_pull_url: Missing[str] = Field(default=UNSET)
    git_push_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    files: Missing[GistSimplePropFiles] = Field(default=UNSET)
    public: Missing[bool] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    comments: Missing[int] = Field(default=UNSET)
    user: Missing[Union[str, None]] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    owner: Missing[SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    truncated: Missing[bool] = Field(default=UNSET)


class GistSimplePropForksItems(GitHubRestModel):
    """GistSimplePropForksItems"""

    id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user: Missing[PublicUser] = Field(
        title="Public User", description="Public User", default=UNSET
    )
    created_at: Missing[datetime] = Field(default=UNSET)
    updated_at: Missing[datetime] = Field(default=UNSET)


class GistSimplePropForkOfPropFiles(GitHubRestModel, extra=Extra.allow):
    """GistSimplePropForkOfPropFiles"""


class GistSimplePropForkOf(GitHubRestModel):
    """Gist

    Gist
    """

    url: str = Field(default=...)
    forks_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    id: str = Field(default=...)
    node_id: str = Field(default=...)
    git_pull_url: str = Field(default=...)
    git_push_url: str = Field(default=...)
    html_url: str = Field(default=...)
    files: GistSimplePropForkOfPropFiles = Field(default=...)
    public: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    description: Union[str, None] = Field(default=...)
    comments: int = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    comments_url: str = Field(default=...)
    owner: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    truncated: Missing[bool] = Field(default=UNSET)
    forks: Missing[List[Any]] = Field(default=UNSET)
    history: Missing[List[Any]] = Field(default=UNSET)


class GistSimplePropFiles(GitHubRestModel, extra=Extra.allow):
    """GistSimplePropFiles"""


class GistComment(GitHubRestModel):
    """Gist Comment

    A comment made to a gist.
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    body: str = Field(description="The comment text.", max_length=65535, default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )


class GistCommit(GitHubRestModel):
    """Gist Commit

    Gist Commit
    """

    url: str = Field(default=...)
    version: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    change_status: GistCommitPropChangeStatus = Field(default=...)
    committed_at: datetime = Field(default=...)


class GistCommitPropChangeStatus(GitHubRestModel):
    """GistCommitPropChangeStatus"""

    total: Missing[int] = Field(default=UNSET)
    additions: Missing[int] = Field(default=UNSET)
    deletions: Missing[int] = Field(default=UNSET)


class GitignoreTemplate(GitHubRestModel):
    """Gitignore Template

    Gitignore Template
    """

    name: str = Field(default=...)
    source: str = Field(default=...)


class License(GitHubRestModel):
    """License

    License
    """

    key: str = Field(default=...)
    name: str = Field(default=...)
    spdx_id: Union[str, None] = Field(default=...)
    url: Union[str, None] = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    description: str = Field(default=...)
    implementation: str = Field(default=...)
    permissions: List[str] = Field(default=...)
    conditions: List[str] = Field(default=...)
    limitations: List[str] = Field(default=...)
    body: str = Field(default=...)
    featured: bool = Field(default=...)


class MarketplaceListingPlan(GitHubRestModel):
    """Marketplace Listing Plan

    Marketplace Listing Plan
    """

    url: str = Field(default=...)
    accounts_url: str = Field(default=...)
    id: int = Field(default=...)
    number: int = Field(default=...)
    name: str = Field(default=...)
    description: str = Field(default=...)
    monthly_price_in_cents: int = Field(default=...)
    yearly_price_in_cents: int = Field(default=...)
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"] = Field(default=...)
    has_free_trial: bool = Field(default=...)
    unit_name: Union[str, None] = Field(default=...)
    state: str = Field(default=...)
    bullets: List[str] = Field(default=...)


class MarketplacePurchase(GitHubRestModel):
    """Marketplace Purchase

    Marketplace Purchase
    """

    url: str = Field(default=...)
    type: str = Field(default=...)
    id: int = Field(default=...)
    login: str = Field(default=...)
    organization_billing_email: Missing[str] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    marketplace_pending_change: Missing[
        Union[MarketplacePurchasePropMarketplacePendingChange, None]
    ] = Field(default=UNSET)
    marketplace_purchase: MarketplacePurchasePropMarketplacePurchase = Field(
        default=...
    )


class MarketplacePurchasePropMarketplacePendingChange(GitHubRestModel):
    """MarketplacePurchasePropMarketplacePendingChange"""

    is_installed: Missing[bool] = Field(default=UNSET)
    effective_date: Missing[str] = Field(default=UNSET)
    unit_count: Missing[Union[int, None]] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    plan: Missing[MarketplaceListingPlan] = Field(
        title="Marketplace Listing Plan",
        description="Marketplace Listing Plan",
        default=UNSET,
    )


class MarketplacePurchasePropMarketplacePurchase(GitHubRestModel):
    """MarketplacePurchasePropMarketplacePurchase"""

    billing_cycle: Missing[str] = Field(default=UNSET)
    next_billing_date: Missing[Union[str, None]] = Field(default=UNSET)
    is_installed: Missing[bool] = Field(default=UNSET)
    unit_count: Missing[Union[int, None]] = Field(default=UNSET)
    on_free_trial: Missing[bool] = Field(default=UNSET)
    free_trial_ends_on: Missing[Union[str, None]] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    plan: Missing[MarketplaceListingPlan] = Field(
        title="Marketplace Listing Plan",
        description="Marketplace Listing Plan",
        default=UNSET,
    )


class ApiOverview(GitHubRestModel):
    """Api Overview

    Api Overview
    """

    verifiable_password_authentication: bool = Field(default=...)
    ssh_key_fingerprints: Missing[ApiOverviewPropSshKeyFingerprints] = Field(
        default=UNSET
    )
    ssh_keys: Missing[List[str]] = Field(default=UNSET)
    hooks: Missing[List[str]] = Field(default=UNSET)
    github_enterprise_importer: Missing[List[str]] = Field(default=UNSET)
    web: Missing[List[str]] = Field(default=UNSET)
    api: Missing[List[str]] = Field(default=UNSET)
    git: Missing[List[str]] = Field(default=UNSET)
    packages: Missing[List[str]] = Field(default=UNSET)
    pages: Missing[List[str]] = Field(default=UNSET)
    importer: Missing[List[str]] = Field(default=UNSET)
    actions: Missing[List[str]] = Field(default=UNSET)
    dependabot: Missing[List[str]] = Field(default=UNSET)
    domains: Missing[ApiOverviewPropDomains] = Field(default=UNSET)


class ApiOverviewPropSshKeyFingerprints(GitHubRestModel):
    """ApiOverviewPropSshKeyFingerprints"""

    sha256_rsa: Missing[str] = Field(default=UNSET, alias="SHA256_RSA")
    sha256_dsa: Missing[str] = Field(default=UNSET, alias="SHA256_DSA")
    sha256_ecdsa: Missing[str] = Field(default=UNSET, alias="SHA256_ECDSA")
    sha256_ed25519: Missing[str] = Field(default=UNSET, alias="SHA256_ED25519")


class ApiOverviewPropDomains(GitHubRestModel):
    """ApiOverviewPropDomains"""

    website: Missing[List[str]] = Field(default=UNSET)
    codespaces: Missing[List[str]] = Field(default=UNSET)
    copilot: Missing[List[str]] = Field(default=UNSET)
    packages: Missing[List[str]] = Field(default=UNSET)


class SecurityAndAnalysisPropAdvancedSecurity(GitHubRestModel):
    """SecurityAndAnalysisPropAdvancedSecurity"""

    status: Missing[Literal["enabled", "disabled"]] = Field(default=UNSET)


class SecurityAndAnalysisPropDependabotSecurityUpdates(GitHubRestModel):
    """SecurityAndAnalysisPropDependabotSecurityUpdates

    Enable or disable Dependabot security updates for the repository.
    """

    status: Missing[Literal["enabled", "disabled"]] = Field(
        description="The enablement status of Dependabot security updates for the repository.",
        default=UNSET,
    )


class SecurityAndAnalysisPropSecretScanning(GitHubRestModel):
    """SecurityAndAnalysisPropSecretScanning"""

    status: Missing[Literal["enabled", "disabled"]] = Field(default=UNSET)


class SecurityAndAnalysisPropSecretScanningPushProtection(GitHubRestModel):
    """SecurityAndAnalysisPropSecretScanningPushProtection"""

    status: Missing[Literal["enabled", "disabled"]] = Field(default=UNSET)


class SecurityAndAnalysis(GitHubRestModel):
    """SecurityAndAnalysis"""

    advanced_security: Missing[SecurityAndAnalysisPropAdvancedSecurity] = Field(
        default=UNSET
    )
    dependabot_security_updates: Missing[
        SecurityAndAnalysisPropDependabotSecurityUpdates
    ] = Field(
        description="Enable or disable Dependabot security updates for the repository.",
        default=UNSET,
    )
    secret_scanning: Missing[SecurityAndAnalysisPropSecretScanning] = Field(
        default=UNSET
    )
    secret_scanning_push_protection: Missing[
        SecurityAndAnalysisPropSecretScanningPushProtection
    ] = Field(default=UNSET)


class MinimalRepository(GitHubRestModel):
    """Minimal Repository

    Minimal Repository
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    full_name: str = Field(default=...)
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    private: bool = Field(default=...)
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    forks_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: Missing[str] = Field(default=UNSET)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    ssh_url: Missing[str] = Field(default=UNSET)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    clone_url: Missing[str] = Field(default=UNSET)
    mirror_url: Missing[Union[str, None]] = Field(default=UNSET)
    hooks_url: str = Field(default=...)
    svn_url: Missing[str] = Field(default=UNSET)
    homepage: Missing[Union[str, None]] = Field(default=UNSET)
    language: Missing[Union[str, None]] = Field(default=UNSET)
    forks_count: Missing[int] = Field(default=UNSET)
    stargazers_count: Missing[int] = Field(default=UNSET)
    watchers_count: Missing[int] = Field(default=UNSET)
    size: Missing[int] = Field(
        description="The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.",
        default=UNSET,
    )
    default_branch: Missing[str] = Field(default=UNSET)
    open_issues_count: Missing[int] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: Missing[bool] = Field(default=UNSET)
    has_projects: Missing[bool] = Field(default=UNSET)
    has_wiki: Missing[bool] = Field(default=UNSET)
    has_pages: Missing[bool] = Field(default=UNSET)
    has_downloads: Missing[bool] = Field(default=UNSET)
    has_discussions: Missing[bool] = Field(default=UNSET)
    archived: Missing[bool] = Field(default=UNSET)
    disabled: Missing[bool] = Field(default=UNSET)
    visibility: Missing[str] = Field(default=UNSET)
    pushed_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    created_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    updated_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    permissions: Missing[MinimalRepositoryPropPermissions] = Field(default=UNSET)
    role_name: Missing[str] = Field(default=UNSET)
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)
    code_of_conduct: Missing[CodeOfConduct] = Field(
        title="Code Of Conduct", description="Code Of Conduct", default=UNSET
    )
    license_: Missing[Union[MinimalRepositoryPropLicense, None]] = Field(
        default=UNSET, alias="license"
    )
    forks: Missing[int] = Field(default=UNSET)
    open_issues: Missing[int] = Field(default=UNSET)
    watchers: Missing[int] = Field(default=UNSET)
    allow_forking: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)
    security_and_analysis: Missing[Union[SecurityAndAnalysis, None]] = Field(
        default=UNSET
    )


class MinimalRepositoryPropPermissions(GitHubRestModel):
    """MinimalRepositoryPropPermissions"""

    admin: Missing[bool] = Field(default=UNSET)
    maintain: Missing[bool] = Field(default=UNSET)
    push: Missing[bool] = Field(default=UNSET)
    triage: Missing[bool] = Field(default=UNSET)
    pull: Missing[bool] = Field(default=UNSET)


class MinimalRepositoryPropLicense(GitHubRestModel):
    """MinimalRepositoryPropLicense"""

    key: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    spdx_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)


class Thread(GitHubRestModel):
    """Thread

    Thread
    """

    id: str = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    subject: ThreadPropSubject = Field(default=...)
    reason: str = Field(default=...)
    unread: bool = Field(default=...)
    updated_at: str = Field(default=...)
    last_read_at: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    subscription_url: str = Field(default=...)


class ThreadPropSubject(GitHubRestModel):
    """ThreadPropSubject"""

    title: str = Field(default=...)
    url: str = Field(default=...)
    latest_comment_url: str = Field(default=...)
    type: str = Field(default=...)


class ThreadSubscription(GitHubRestModel):
    """Thread Subscription

    Thread Subscription
    """

    subscribed: bool = Field(default=...)
    ignored: bool = Field(default=...)
    reason: Union[str, None] = Field(default=...)
    created_at: Union[datetime, None] = Field(default=...)
    url: str = Field(default=...)
    thread_url: Missing[str] = Field(default=UNSET)
    repository_url: Missing[str] = Field(default=UNSET)


class OrganizationSimple(GitHubRestModel):
    """Organization Simple

    A GitHub organization.
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    members_url: str = Field(default=...)
    public_members_url: str = Field(default=...)
    avatar_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)


class OrganizationFull(GitHubRestModel):
    """Organization Full

    Organization Full
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    members_url: str = Field(default=...)
    public_members_url: str = Field(default=...)
    avatar_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    name: Missing[str] = Field(default=UNSET)
    company: Missing[Union[str, None]] = Field(default=UNSET)
    blog: Missing[str] = Field(default=UNSET)
    location: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    twitter_username: Missing[Union[str, None]] = Field(default=UNSET)
    is_verified: Missing[bool] = Field(default=UNSET)
    has_organization_projects: bool = Field(default=...)
    has_repository_projects: bool = Field(default=...)
    public_repos: int = Field(default=...)
    public_gists: int = Field(default=...)
    followers: int = Field(default=...)
    following: int = Field(default=...)
    html_url: str = Field(default=...)
    type: str = Field(default=...)
    total_private_repos: Missing[int] = Field(default=UNSET)
    owned_private_repos: Missing[int] = Field(default=UNSET)
    private_gists: Missing[Union[int, None]] = Field(default=UNSET)
    disk_usage: Missing[Union[int, None]] = Field(default=UNSET)
    collaborators: Missing[Union[int, None]] = Field(default=UNSET)
    billing_email: Missing[Union[str, None]] = Field(default=UNSET)
    plan: Missing[OrganizationFullPropPlan] = Field(default=UNSET)
    default_repository_permission: Missing[Union[str, None]] = Field(default=UNSET)
    members_can_create_repositories: Missing[Union[bool, None]] = Field(default=UNSET)
    two_factor_requirement_enabled: Missing[Union[bool, None]] = Field(default=UNSET)
    members_allowed_repository_creation_type: Missing[str] = Field(default=UNSET)
    members_can_create_public_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_private_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_internal_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_pages: Missing[bool] = Field(default=UNSET)
    members_can_create_public_pages: Missing[bool] = Field(default=UNSET)
    members_can_create_private_pages: Missing[bool] = Field(default=UNSET)
    members_can_fork_private_repositories: Missing[Union[bool, None]] = Field(
        default=UNSET
    )
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)
    advanced_security_enabled_for_new_repositories: Missing[bool] = Field(
        description="Whether GitHub Advanced Security is enabled for new repositories and repositories transferred to this organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    dependabot_alerts_enabled_for_new_repositories: Missing[bool] = Field(
        description="Whether GitHub Advanced Security is automatically enabled for new repositories and repositories transferred to\nthis organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = Field(
        description="Whether dependabot security updates are automatically enabled for new repositories and repositories transferred\nto this organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    dependency_graph_enabled_for_new_repositories: Missing[bool] = Field(
        description="Whether dependency graph is automatically enabled for new repositories and repositories transferred to this\norganization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    secret_scanning_enabled_for_new_repositories: Missing[bool] = Field(
        description="Whether secret scanning is automatically enabled for new repositories and repositories transferred to this\norganization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    secret_scanning_push_protection_enabled_for_new_repositories: Missing[bool] = Field(
        description="Whether secret scanning push protection is automatically enabled for new repositories and repositories\ntransferred to this organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
        default=UNSET,
    )
    secret_scanning_push_protection_custom_link_enabled: Missing[bool] = Field(
        description="Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.",
        default=UNSET,
    )
    secret_scanning_push_protection_custom_link: Missing[Union[str, None]] = Field(
        description="An optional URL string to display to contributors who are blocked from pushing a secret.",
        default=UNSET,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    archived_at: Union[datetime, None] = Field(default=...)


class OrganizationFullPropPlan(GitHubRestModel):
    """OrganizationFullPropPlan"""

    name: str = Field(default=...)
    space: int = Field(default=...)
    private_repos: int = Field(default=...)
    filled_seats: Missing[int] = Field(default=UNSET)
    seats: Missing[int] = Field(default=UNSET)


class ActionsCacheUsageOrgEnterprise(GitHubRestModel):
    """ActionsCacheUsageOrgEnterprise"""

    total_active_caches_count: int = Field(
        description="The count of active caches across all repositories of an enterprise or an organization.",
        default=...,
    )
    total_active_caches_size_in_bytes: int = Field(
        description="The total size in bytes of all active cache items across all repositories of an enterprise or an organization.",
        default=...,
    )


class ActionsCacheUsageByRepository(GitHubRestModel):
    """Actions Cache Usage by repository

    GitHub Actions Cache Usage by repository.
    """

    full_name: str = Field(
        description="The repository owner and name for the cache usage being shown.",
        default=...,
    )
    active_caches_size_in_bytes: int = Field(
        description="The sum of the size in bytes of all the active cache items in the repository.",
        default=...,
    )
    active_caches_count: int = Field(
        description="The number of active caches in the repository.", default=...
    )


class OidcCustomSub(GitHubRestModel):
    """Actions OIDC Subject customization

    Actions OIDC Subject customization
    """

    include_claim_keys: List[str] = Field(
        description="Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.",
        default=...,
    )


class EmptyObject(GitHubRestModel):
    """Empty Object

    An object without any properties.
    """


class ActionsOrganizationPermissions(GitHubRestModel):
    """ActionsOrganizationPermissions"""

    enabled_repositories: Literal["all", "none", "selected"] = Field(
        description="The policy that controls the repositories in the organization that are allowed to run GitHub Actions.",
        default=...,
    )
    selected_repositories_url: Missing[str] = Field(
        description="The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.",
        default=UNSET,
    )
    allowed_actions: Missing[Literal["all", "local_only", "selected"]] = Field(
        description="The permissions policy that controls the actions and reusable workflows that are allowed to run.",
        default=UNSET,
    )
    selected_actions_url: Missing[str] = Field(
        description="The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.",
        default=UNSET,
    )


class SelectedActions(GitHubRestModel):
    """SelectedActions"""

    github_owned_allowed: Missing[bool] = Field(
        description="Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.",
        default=UNSET,
    )
    verified_allowed: Missing[bool] = Field(
        description="Whether actions from GitHub Marketplace verified creators are allowed. Set to `true` to allow all actions by GitHub Marketplace verified creators.",
        default=UNSET,
    )
    patterns_allowed: Missing[List[str]] = Field(
        description="Specifies a list of string-matching patterns to allow specific action(s) and reusable workflow(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`.\n\n**Note**: The `patterns_allowed` setting only applies to public repositories.",
        default=UNSET,
    )


class ActionsGetDefaultWorkflowPermissions(GitHubRestModel):
    """ActionsGetDefaultWorkflowPermissions"""

    default_workflow_permissions: Literal["read", "write"] = Field(
        description="The default workflow permissions granted to the GITHUB_TOKEN when running workflows.",
        default=...,
    )
    can_approve_pull_request_reviews: bool = Field(
        description="Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.",
        default=...,
    )


class ActionsSetDefaultWorkflowPermissions(GitHubRestModel):
    """ActionsSetDefaultWorkflowPermissions"""

    default_workflow_permissions: Missing[Literal["read", "write"]] = Field(
        description="The default workflow permissions granted to the GITHUB_TOKEN when running workflows.",
        default=UNSET,
    )
    can_approve_pull_request_reviews: Missing[bool] = Field(
        description="Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.",
        default=UNSET,
    )


class RunnerLabel(GitHubRestModel):
    """Self hosted runner label

    A label for a self hosted runner
    """

    id: Missing[int] = Field(
        description="Unique identifier of the label.", default=UNSET
    )
    name: str = Field(description="Name of the label.", default=...)
    type: Missing[Literal["read-only", "custom"]] = Field(
        description="The type of label. Read-only labels are applied automatically when the runner is configured.",
        default=UNSET,
    )


class Runner(GitHubRestModel):
    """Self hosted runners

    A self hosted runner
    """

    id: int = Field(description="The id of the runner.", default=...)
    runner_group_id: Missing[int] = Field(
        description="The id of the runner group.", default=UNSET
    )
    name: str = Field(description="The name of the runner.", default=...)
    os: str = Field(description="The Operating System of the runner.", default=...)
    status: str = Field(description="The status of the runner.", default=...)
    busy: bool = Field(default=...)
    labels: List[RunnerLabel] = Field(default=...)


class RunnerApplication(GitHubRestModel):
    """Runner Application

    Runner Application
    """

    os: str = Field(default=...)
    architecture: str = Field(default=...)
    download_url: str = Field(default=...)
    filename: str = Field(default=...)
    temp_download_token: Missing[str] = Field(
        description="A short lived bearer token used to download the runner, if needed.",
        default=UNSET,
    )
    sha256_checksum: Missing[str] = Field(default=UNSET)


class AuthenticationToken(GitHubRestModel):
    """Authentication Token

    Authentication Token
    """

    token: str = Field(description="The token used for authentication", default=...)
    expires_at: datetime = Field(description="The time this token expires", default=...)
    permissions: Missing[AuthenticationTokenPropPermissions] = Field(default=UNSET)
    repositories: Missing[List[Repository]] = Field(
        description="The repositories this token has access to", default=UNSET
    )
    single_file: Missing[Union[str, None]] = Field(default=UNSET)
    repository_selection: Missing[Literal["all", "selected"]] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved",
        default=UNSET,
    )


class AuthenticationTokenPropPermissions(GitHubRestModel):
    """AuthenticationTokenPropPermissions

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """


class OrganizationActionsSecret(GitHubRestModel):
    """Actions Secret for an Organization

    Secrets for GitHub Actions for an organization.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    visibility: Literal["all", "private", "selected"] = Field(
        description="Visibility of a secret", default=...
    )
    selected_repositories_url: Missing[str] = Field(default=UNSET)


class ActionsPublicKey(GitHubRestModel):
    """ActionsPublicKey

    The public key used for setting Actions Secrets.
    """

    key_id: str = Field(description="The identifier for the key.", default=...)
    key: str = Field(description="The Base64 encoded public key.", default=...)
    id: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)


class OrganizationActionsVariable(GitHubRestModel):
    """Actions Variable for an Organization

    Organization variable for GitHub Actions.
    """

    name: str = Field(description="The name of the variable.", default=...)
    value: str = Field(description="The value of the variable.", default=...)
    created_at: datetime = Field(
        description="The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="Visibility of a variable", default=...
    )
    selected_repositories_url: Missing[str] = Field(default=UNSET)


class CodeScanningAlertRule(GitHubRestModel):
    """CodeScanningAlertRule"""

    id: Missing[Union[str, None]] = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=UNSET,
    )
    name: Missing[str] = Field(
        description="The name of the rule used to detect the alert.", default=UNSET
    )
    severity: Missing[Union[None, Literal["none", "note", "warning", "error"]]] = Field(
        description="The severity of the alert.", default=UNSET
    )
    security_severity_level: Missing[
        Union[None, Literal["low", "medium", "high", "critical"]]
    ] = Field(description="The security severity of the alert.", default=UNSET)
    description: Missing[str] = Field(
        description="A short description of the rule used to detect the alert.",
        default=UNSET,
    )
    full_description: Missing[str] = Field(
        description="description of the rule used to detect the alert.", default=UNSET
    )
    tags: Missing[Union[List[str], None]] = Field(
        description="A set of tags applicable for the rule.", default=UNSET
    )
    help_: Missing[Union[str, None]] = Field(
        description="Detailed documentation for the rule as GitHub Flavored Markdown.",
        default=UNSET,
        alias="help",
    )
    help_uri: Missing[Union[str, None]] = Field(
        description="A link to the documentation for the rule used to detect the alert.",
        default=UNSET,
    )


class CodeScanningAnalysisTool(GitHubRestModel):
    """CodeScanningAnalysisTool"""

    name: Missing[str] = Field(
        description="The name of the tool used to generate the code scanning analysis.",
        default=UNSET,
    )
    version: Missing[Union[str, None]] = Field(
        description="The version of the tool used to generate the code scanning analysis.",
        default=UNSET,
    )
    guid: Missing[Union[str, None]] = Field(
        description="The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data.",
        default=UNSET,
    )


class CodeScanningAlertLocation(GitHubRestModel):
    """CodeScanningAlertLocation

    Describe a region within a file for the alert.
    """

    path: Missing[str] = Field(default=UNSET)
    start_line: Missing[int] = Field(default=UNSET)
    end_line: Missing[int] = Field(default=UNSET)
    start_column: Missing[int] = Field(default=UNSET)
    end_column: Missing[int] = Field(default=UNSET)


class CodeScanningAlertInstance(GitHubRestModel):
    """CodeScanningAlertInstance"""

    ref: Missing[str] = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`,\n`refs/pull/<number>/merge`, or `refs/pull/<number>/head`.",
        default=UNSET,
    )
    analysis_key: Missing[str] = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=UNSET,
    )
    environment: Missing[str] = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
        default=UNSET,
    )
    category: Missing[str] = Field(
        description="Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.",
        default=UNSET,
    )
    state: Missing[Literal["open", "dismissed", "fixed"]] = Field(
        description="State of a code scanning alert.", default=UNSET
    )
    commit_sha: Missing[str] = Field(default=UNSET)
    message: Missing[CodeScanningAlertInstancePropMessage] = Field(default=UNSET)
    location: Missing[CodeScanningAlertLocation] = Field(
        description="Describe a region within a file for the alert.", default=UNSET
    )
    html_url: Missing[str] = Field(default=UNSET)
    classifications: Missing[
        List[Union[None, Literal["source", "generated", "test", "library"]]]
    ] = Field(
        description="Classifications that have been applied to the file that triggered the alert.\nFor example identifying it as documentation, or a generated file.",
        default=UNSET,
    )


class CodeScanningAlertInstancePropMessage(GitHubRestModel):
    """CodeScanningAlertInstancePropMessage"""

    text: Missing[str] = Field(default=UNSET)


class CodeScanningOrganizationAlertItems(GitHubRestModel):
    """CodeScanningOrganizationAlertItems"""

    number: int = Field(description="The security alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: Missing[datetime] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances_url: str = Field(
        description="The REST API URL for fetching the list of instances for an alert.",
        default=...,
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    fixed_at: Missing[Union[datetime, None]] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert.",
        default=...,
    )
    dismissed_comment: Missing[
        Annotated[Union[str, None], Field(max_length=280)]
    ] = Field(
        description="The dismissal comment associated with the dismissal of the alert.",
        default=UNSET,
    )
    rule: CodeScanningAlertRule = Field(default=...)
    tool: CodeScanningAnalysisTool = Field(default=...)
    most_recent_instance: CodeScanningAlertInstance = Field(default=...)
    repository: SimpleRepository = Field(
        title="Simple Repository", description="A GitHub repository.", default=...
    )


class CodespaceMachine(GitHubRestModel):
    """Codespace machine

    A description of the machine powering a codespace.
    """

    name: str = Field(description="The name of the machine.", default=...)
    display_name: str = Field(
        description="The display name of the machine includes cores, memory, and storage.",
        default=...,
    )
    operating_system: str = Field(
        description="The operating system of the machine.", default=...
    )
    storage_in_bytes: int = Field(
        description="How much storage is available to the codespace.", default=...
    )
    memory_in_bytes: int = Field(
        description="How much memory is available to the codespace.", default=...
    )
    cpus: int = Field(
        description="How many cores are available to the codespace.", default=...
    )
    prebuild_availability: Union[None, Literal["none", "ready", "in_progress"]] = Field(
        description='Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.',
        default=...,
    )


class Codespace(GitHubRestModel):
    """Codespace

    A codespace.
    """

    id: int = Field(default=...)
    name: str = Field(
        description="Automatically generated name of this codespace.", default=...
    )
    display_name: Missing[Union[str, None]] = Field(
        description="Display name for this codespace.", default=UNSET
    )
    environment_id: Union[str, None] = Field(
        description="UUID identifying this codespace's environment.", default=...
    )
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    billable_owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    machine: Union[None, CodespaceMachine] = Field(
        title="Codespace machine",
        description="A description of the machine powering a codespace.",
        default=...,
    )
    devcontainer_path: Missing[Union[str, None]] = Field(
        description="Path to devcontainer.json from repo root used to create Codespace.",
        default=UNSET,
    )
    prebuild: Union[bool, None] = Field(
        description="Whether the codespace was created from a prebuild.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    last_used_at: datetime = Field(
        description="Last known time this codespace was started.", default=...
    )
    state: Literal[
        "Unknown",
        "Created",
        "Queued",
        "Provisioning",
        "Available",
        "Awaiting",
        "Unavailable",
        "Deleted",
        "Moved",
        "Shutdown",
        "Archived",
        "Starting",
        "ShuttingDown",
        "Failed",
        "Exporting",
        "Updating",
        "Rebuilding",
    ] = Field(description="State of this codespace.", default=...)
    url: str = Field(description="API URL for this codespace.", default=...)
    git_status: CodespacePropGitStatus = Field(
        description="Details about the codespace's git repository.", default=...
    )
    location: Literal["EastUs", "SouthEastAsia", "WestEurope", "WestUs2"] = Field(
        description="The initally assigned location of a new codespace.", default=...
    )
    idle_timeout_minutes: Union[int, None] = Field(
        description="The number of minutes of inactivity after which this codespace will be automatically stopped.",
        default=...,
    )
    web_url: str = Field(
        description="URL to access this codespace on the web.", default=...
    )
    machines_url: str = Field(
        description="API URL to access available alternate machine types for this codespace.",
        default=...,
    )
    start_url: str = Field(description="API URL to start this codespace.", default=...)
    stop_url: str = Field(description="API URL to stop this codespace.", default=...)
    publish_url: Missing[Union[str, None]] = Field(
        description="API URL to publish this codespace to a new repository.",
        default=UNSET,
    )
    pulls_url: Union[str, None] = Field(
        description="API URL for the Pull Request associated with this codespace, if any.",
        default=...,
    )
    recent_folders: List[str] = Field(default=...)
    runtime_constraints: Missing[CodespacePropRuntimeConstraints] = Field(default=UNSET)
    pending_operation: Missing[Union[bool, None]] = Field(
        description="Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.",
        default=UNSET,
    )
    pending_operation_disabled_reason: Missing[Union[str, None]] = Field(
        description="Text to show user when codespace is disabled by a pending operation",
        default=UNSET,
    )
    idle_timeout_notice: Missing[Union[str, None]] = Field(
        description="Text to show user when codespace idle timeout minutes has been overriden by an organization policy",
        default=UNSET,
    )
    retention_period_minutes: Missing[Union[int, None]] = Field(
        description="Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).",
        default=UNSET,
    )
    retention_expires_at: Missing[Union[datetime, None]] = Field(
        description='When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"',
        default=UNSET,
    )
    last_known_stop_notice: Missing[Union[str, None]] = Field(
        description="The text to display to a user when a codespace has been stopped for a potentially actionable reason.",
        default=UNSET,
    )


class CodespacePropGitStatus(GitHubRestModel):
    """CodespacePropGitStatus

    Details about the codespace's git repository.
    """

    ahead: Missing[int] = Field(
        description="The number of commits the local repository is ahead of the remote.",
        default=UNSET,
    )
    behind: Missing[int] = Field(
        description="The number of commits the local repository is behind the remote.",
        default=UNSET,
    )
    has_unpushed_changes: Missing[bool] = Field(
        description="Whether the local repository has unpushed changes.", default=UNSET
    )
    has_uncommitted_changes: Missing[bool] = Field(
        description="Whether the local repository has uncommitted changes.",
        default=UNSET,
    )
    ref: Missing[str] = Field(
        description="The current branch (or SHA if in detached HEAD state) of the local repository.",
        default=UNSET,
    )


class CodespacePropRuntimeConstraints(GitHubRestModel):
    """CodespacePropRuntimeConstraints"""

    allowed_port_privacy_settings: Missing[Union[List[str], None]] = Field(
        description="The privacy settings a user can select from when forwarding a port.",
        default=UNSET,
    )


class CodespacesOrgSecret(GitHubRestModel):
    """Codespaces Secret

    Secrets for a GitHub Codespace.
    """

    name: str = Field(description="The name of the secret", default=...)
    created_at: datetime = Field(
        description="The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="The type of repositories in the organization that the secret is visible to",
        default=...,
    )
    selected_repositories_url: Missing[str] = Field(
        description="The API URL at which the list of repositories this secret is visible to can be retrieved",
        default=UNSET,
    )


class CodespacesPublicKey(GitHubRestModel):
    """CodespacesPublicKey

    The public key used for setting Codespaces secrets.
    """

    key_id: str = Field(description="The identifier for the key.", default=...)
    key: str = Field(description="The Base64 encoded public key.", default=...)
    id: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)


class CopilotSeatBreakdown(GitHubRestModel):
    """Copilot for Business Seat Breakdown

    The breakdown of Copilot for Business seats for the organization.
    """

    total: Missing[int] = Field(
        description="The total number of seats being billed for the organization as of the current billing cycle.",
        default=UNSET,
    )
    added_this_cycle: Missing[int] = Field(
        description="Seats added during the current billing cycle.", default=UNSET
    )
    pending_cancellation: Missing[int] = Field(
        description="The number of seats that are pending cancellation at the end of the current billing cycle.",
        default=UNSET,
    )
    pending_invitation: Missing[int] = Field(
        description="The number of seats that have been assigned to users that have not yet accepted an invitation to this organization.",
        default=UNSET,
    )
    active_this_cycle: Missing[int] = Field(
        description="The number of seats that have used Copilot during the current billing cycle.",
        default=UNSET,
    )
    inactive_this_cycle: Missing[int] = Field(
        description="The number of seats that have not used Copilot during the current billing cycle.",
        default=UNSET,
    )


class CopilotOrganizationDetails(GitHubRestModel, extra=Extra.allow):
    """Copilot for Business Organization Details

    Information about the seat breakdown and policies set for an organization with a
    Copilot for Business subscription.
    """

    seat_breakdown: CopilotSeatBreakdown = Field(
        title="Copilot for Business Seat Breakdown",
        description="The breakdown of Copilot for Business seats for the organization.",
        default=...,
    )
    public_code_suggestions: Literal[
        "allow", "block", "unconfigured", "unknown"
    ] = Field(
        description="The organization policy for allowing or disallowing Copilot to make suggestions that match public code.",
        default=...,
    )
    seat_management_setting: Literal[
        "assign_all", "assign_selected", "disabled", "unconfigured"
    ] = Field(description="The mode of assigning new seats.", default=...)


class TeamSimple(GitHubRestModel):
    """Team Simple

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int = Field(description="Unique identifier of the team", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the team", default=...)
    members_url: str = Field(default=...)
    name: str = Field(description="Name of the team", default=...)
    description: Union[str, None] = Field(
        description="Description of the team", default=...
    )
    permission: str = Field(
        description="Permission that the team will have for its repositories",
        default=...,
    )
    privacy: Missing[str] = Field(
        description="The level of privacy this team should have", default=UNSET
    )
    notification_setting: Missing[str] = Field(
        description="The notification setting the team has set", default=UNSET
    )
    html_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    slug: str = Field(default=...)
    ldap_dn: Missing[str] = Field(
        description="Distinguished Name (DN) that team maps to within LDAP environment",
        default=UNSET,
    )


class Team(GitHubRestModel):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    slug: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    privacy: Missing[str] = Field(default=UNSET)
    notification_setting: Missing[str] = Field(default=UNSET)
    permission: str = Field(default=...)
    permissions: Missing[TeamPropPermissions] = Field(default=UNSET)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    members_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    parent: Union[None, TeamSimple] = Field(
        title="Team Simple",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=...,
    )


class TeamPropPermissions(GitHubRestModel):
    """TeamPropPermissions"""

    pull: bool = Field(default=...)
    triage: bool = Field(default=...)
    push: bool = Field(default=...)
    maintain: bool = Field(default=...)
    admin: bool = Field(default=...)


class Organization(GitHubRestModel):
    """Organization

    GitHub account for managing multiple users, teams, and repositories
    """

    login: str = Field(description="Unique login name of the organization", default=...)
    url: str = Field(description="URL for the organization", default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    members_url: str = Field(default=...)
    public_members_url: str = Field(default=...)
    avatar_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    blog: Missing[str] = Field(
        description="Display blog url for the organization", default=UNSET
    )
    html_url: str = Field(default=...)
    name: Missing[str] = Field(
        description="Display name for the organization", default=UNSET
    )
    company: Missing[str] = Field(
        description="Display company name for the organization", default=UNSET
    )
    location: Missing[str] = Field(
        description="Display location for the organization", default=UNSET
    )
    email: Missing[str] = Field(
        description="Display email for the organization", default=UNSET
    )
    has_organization_projects: bool = Field(
        description="Specifies if organization projects are enabled for this org",
        default=...,
    )
    has_repository_projects: bool = Field(
        description="Specifies if repository projects are enabled for repositories that belong to this org",
        default=...,
    )
    is_verified: Missing[bool] = Field(default=UNSET)
    public_repos: int = Field(default=...)
    public_gists: int = Field(default=...)
    followers: int = Field(default=...)
    following: int = Field(default=...)
    type: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    plan: Missing[OrganizationPropPlan] = Field(default=UNSET)


class OrganizationPropPlan(GitHubRestModel):
    """OrganizationPropPlan"""

    name: Missing[str] = Field(default=UNSET)
    space: Missing[int] = Field(default=UNSET)
    private_repos: Missing[int] = Field(default=UNSET)
    filled_seats: Missing[int] = Field(default=UNSET)
    seats: Missing[int] = Field(default=UNSET)


class CopilotSeatDetails(GitHubRestModel):
    """Copilot for Business Seat Detail

    Information about a Copilot for Business seat assignment for a user, team, or
    organization.
    """

    assignee: Union[SimpleUser, Team, Organization] = Field(
        title="Organization",
        description="The assignee that has been granted access to GitHub Copilot.",
        default=...,
    )
    assigning_team: Missing[Union[Team, None]] = Field(
        title="Team",
        description="The team that granted access to GitHub Copilot to the assignee. This will be null if the user was assigned a seat individually.",
        default=UNSET,
    )
    pending_cancellation_date: Missing[Union[date, None]] = Field(
        description="The pending cancellation date for the seat, in `YYYY-MM-DD` format. This will be null unless the assignee's Copilot access has been canceled during the current billing cycle. If the seat has been cancelled, this corresponds to the start of the organization's next billing cycle.",
        default=UNSET,
    )
    last_activity_at: Missing[Union[datetime, None]] = Field(
        description="Timestamp of user's last GitHub Copilot activity, in ISO 8601 format.",
        default=UNSET,
    )
    last_activity_editor: Missing[Union[str, None]] = Field(
        description="Last editor that was used by the user for a GitHub Copilot completion.",
        default=UNSET,
    )
    created_at: datetime = Field(
        description="Timestamp of when the assignee was last granted access to GitHub Copilot, in ISO 8601 format.",
        default=...,
    )
    updated_at: Missing[datetime] = Field(
        description="Timestamp of when the assignee's GitHub Copilot access was last updated, in ISO 8601 format.",
        default=UNSET,
    )


class OrganizationDependabotSecret(GitHubRestModel):
    """Dependabot Secret for an Organization

    Secrets for GitHub Dependabot for an organization.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    visibility: Literal["all", "private", "selected"] = Field(
        description="Visibility of a secret", default=...
    )
    selected_repositories_url: Missing[str] = Field(default=UNSET)


class DependabotPublicKey(GitHubRestModel):
    """DependabotPublicKey

    The public key used for setting Dependabot Secrets.
    """

    key_id: str = Field(description="The identifier for the key.", default=...)
    key: str = Field(description="The Base64 encoded public key.", default=...)


class Package(GitHubRestModel):
    """Package

    A software package
    """

    id: int = Field(description="Unique identifier of the package.", default=...)
    name: str = Field(description="The name of the package.", default=...)
    package_type: Literal[
        "npm", "maven", "rubygems", "docker", "nuget", "container"
    ] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    version_count: int = Field(
        description="The number of versions of the package.", default=...
    )
    visibility: Literal["private", "public"] = Field(default=...)
    owner: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    repository: Missing[Union[None, MinimalRepository]] = Field(
        title="Minimal Repository", description="Minimal Repository", default=UNSET
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class OrganizationInvitation(GitHubRestModel):
    """Organization Invitation

    Organization Invitation
    """

    id: int = Field(default=...)
    login: Union[str, None] = Field(default=...)
    email: Union[str, None] = Field(default=...)
    role: str = Field(default=...)
    created_at: str = Field(default=...)
    failed_at: Missing[Union[str, None]] = Field(default=UNSET)
    failed_reason: Missing[Union[str, None]] = Field(default=UNSET)
    inviter: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    team_count: int = Field(default=...)
    node_id: str = Field(default=...)
    invitation_teams_url: str = Field(default=...)
    invitation_source: Missing[str] = Field(default=UNSET)


class OrgHook(GitHubRestModel):
    """Org Hook

    Org Hook
    """

    id: int = Field(default=...)
    url: str = Field(default=...)
    ping_url: str = Field(default=...)
    deliveries_url: Missing[str] = Field(default=UNSET)
    name: str = Field(default=...)
    events: List[str] = Field(default=...)
    active: bool = Field(default=...)
    config: OrgHookPropConfig = Field(default=...)
    updated_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)
    type: str = Field(default=...)


class OrgHookPropConfig(GitHubRestModel):
    """OrgHookPropConfig"""

    url: Missing[str] = Field(default=UNSET)
    insecure_ssl: Missing[str] = Field(default=UNSET)
    content_type: Missing[str] = Field(default=UNSET)
    secret: Missing[str] = Field(default=UNSET)


class InteractionLimitResponse(GitHubRestModel):
    """Interaction Limits

    Interaction limit settings.
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"] = Field(
        description="The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect.",
        default=...,
    )
    origin: str = Field(default=...)
    expires_at: datetime = Field(default=...)


class InteractionLimit(GitHubRestModel):
    """Interaction Restrictions

    Limit interactions to a specific type of user for a specified duration
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"] = Field(
        description="The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect.",
        default=...,
    )
    expiry: Missing[
        Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
    ] = Field(
        description="The duration of the interaction restriction. Default: `one_day`.",
        default=UNSET,
    )


class OrgMembership(GitHubRestModel):
    """Org Membership

    Org Membership
    """

    url: str = Field(default=...)
    state: Literal["active", "pending"] = Field(
        description="The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.",
        default=...,
    )
    role: Literal["admin", "member", "billing_manager"] = Field(
        description="The user's membership type in the organization.", default=...
    )
    organization_url: str = Field(default=...)
    organization: OrganizationSimple = Field(
        title="Organization Simple", description="A GitHub organization.", default=...
    )
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    permissions: Missing[OrgMembershipPropPermissions] = Field(default=UNSET)


class OrgMembershipPropPermissions(GitHubRestModel):
    """OrgMembershipPropPermissions"""

    can_create_repository: bool = Field(default=...)


class Migration(GitHubRestModel):
    """Migration

    A migration.
    """

    id: int = Field(default=...)
    owner: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    guid: str = Field(default=...)
    state: str = Field(default=...)
    lock_repositories: bool = Field(default=...)
    exclude_metadata: bool = Field(default=...)
    exclude_git_data: bool = Field(default=...)
    exclude_attachments: bool = Field(default=...)
    exclude_releases: bool = Field(default=...)
    exclude_owner_projects: bool = Field(default=...)
    org_metadata_only: bool = Field(default=...)
    repositories: List[Repository] = Field(
        description="The repositories included in the migration. Only returned for export migrations.",
        default=...,
    )
    url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    node_id: str = Field(default=...)
    archive_url: Missing[str] = Field(default=UNSET)
    exclude: Missing[List[str]] = Field(
        description='Exclude related items from being returned in the response in order to improve performance of the request. The array can include any of: `"repositories"`.',
        default=UNSET,
    )


class PackageVersion(GitHubRestModel):
    """Package Version

    A version of a software package
    """

    id: int = Field(
        description="Unique identifier of the package version.", default=...
    )
    name: str = Field(description="The name of the package version.", default=...)
    url: str = Field(default=...)
    package_html_url: str = Field(default=...)
    html_url: Missing[str] = Field(default=UNSET)
    license_: Missing[str] = Field(default=UNSET, alias="license")
    description: Missing[str] = Field(default=UNSET)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    deleted_at: Missing[datetime] = Field(default=UNSET)
    metadata: Missing[PackageVersionPropMetadata] = Field(
        title="Package Version Metadata", default=UNSET
    )


class PackageVersionPropMetadata(GitHubRestModel):
    """Package Version Metadata"""

    package_type: Literal[
        "npm", "maven", "rubygems", "docker", "nuget", "container"
    ] = Field(default=...)
    container: Missing[PackageVersionPropMetadataPropContainer] = Field(
        title="Container Metadata", default=UNSET
    )
    docker: Missing[PackageVersionPropMetadataPropDocker] = Field(
        title="Docker Metadata", default=UNSET
    )


class PackageVersionPropMetadataPropContainer(GitHubRestModel):
    """Container Metadata"""

    tags: List[str] = Field(default=...)


class PackageVersionPropMetadataPropDocker(GitHubRestModel):
    """Docker Metadata"""

    tag: Missing[List[str]] = Field(default=UNSET)


class OrganizationProgrammaticAccessGrantRequest(GitHubRestModel):
    """Simple Organization Programmatic Access Grant Request

    Minimal representation of an organization programmatic access grant request for
    enumerations
    """

    id: int = Field(
        description="Unique identifier of the request for access via fine-grained personal access token. The `pat_request_id` used to review PAT requests.",
        default=...,
    )
    reason: Union[str, None] = Field(
        description="Reason for requesting access.", default=...
    )
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    repository_selection: Literal["none", "all", "subset"] = Field(
        description="Type of repository selection requested.", default=...
    )
    repositories_url: str = Field(
        description="URL to the list of repositories requested to be accessed via fine-grained personal access token. Should only be followed when `repository_selection` is `subset`.",
        default=...,
    )
    permissions: OrganizationProgrammaticAccessGrantRequestPropPermissions = Field(
        description="Permissions requested, categorized by type of permission.",
        default=...,
    )
    created_at: str = Field(
        description="Date and time when the request for access was created.",
        default=...,
    )
    token_expired: bool = Field(
        description="Whether the associated fine-grained personal access token has expired.",
        default=...,
    )
    token_expires_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token expires.",
        default=...,
    )
    token_last_used_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token was last used for authentication.",
        default=...,
    )


class OrganizationProgrammaticAccessGrantRequestPropPermissions(GitHubRestModel):
    """OrganizationProgrammaticAccessGrantRequestPropPermissions

    Permissions requested, categorized by type of permission.
    """

    organization: Missing[
        OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepository
    ] = Field(default=UNSET)
    other: Missing[
        OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOther
    ] = Field(default=UNSET)


class OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganization(
    GitHubRestModel, extra=Extra.allow
):
    """OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganization"""


class OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepository(
    GitHubRestModel, extra=Extra.allow
):
    """OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepository"""


class OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOther(
    GitHubRestModel, extra=Extra.allow
):
    """OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOther"""


class OrganizationProgrammaticAccessGrant(GitHubRestModel):
    """Organization Programmatic Access Grant

    Minimal representation of an organization programmatic access grant for
    enumerations
    """

    id: int = Field(
        description="Unique identifier of the fine-grained personal access token. The `pat_id` used to get details about an approved fine-grained personal access token.",
        default=...,
    )
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    repository_selection: Literal["none", "all", "subset"] = Field(
        description="Type of repository selection requested.", default=...
    )
    repositories_url: str = Field(
        description="URL to the list of repositories the fine-grained personal access token can access. Only follow when `repository_selection` is `subset`.",
        default=...,
    )
    permissions: OrganizationProgrammaticAccessGrantPropPermissions = Field(
        description="Permissions requested, categorized by type of permission.",
        default=...,
    )
    access_granted_at: str = Field(
        description="Date and time when the fine-grained personal access token was approved to access the organization.",
        default=...,
    )
    token_expired: bool = Field(
        description="Whether the associated fine-grained personal access token has expired.",
        default=...,
    )
    token_expires_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token expires.",
        default=...,
    )
    token_last_used_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token was last used for authentication.",
        default=...,
    )


class OrganizationProgrammaticAccessGrantPropPermissions(GitHubRestModel):
    """OrganizationProgrammaticAccessGrantPropPermissions

    Permissions requested, categorized by type of permission.
    """

    organization: Missing[
        OrganizationProgrammaticAccessGrantPropPermissionsPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        OrganizationProgrammaticAccessGrantPropPermissionsPropRepository
    ] = Field(default=UNSET)
    other: Missing[OrganizationProgrammaticAccessGrantPropPermissionsPropOther] = Field(
        default=UNSET
    )


class OrganizationProgrammaticAccessGrantPropPermissionsPropOrganization(
    GitHubRestModel, extra=Extra.allow
):
    """OrganizationProgrammaticAccessGrantPropPermissionsPropOrganization"""


class OrganizationProgrammaticAccessGrantPropPermissionsPropRepository(
    GitHubRestModel, extra=Extra.allow
):
    """OrganizationProgrammaticAccessGrantPropPermissionsPropRepository"""


class OrganizationProgrammaticAccessGrantPropPermissionsPropOther(
    GitHubRestModel, extra=Extra.allow
):
    """OrganizationProgrammaticAccessGrantPropPermissionsPropOther"""


class Project(GitHubRestModel):
    """Project

    Projects are a way to organize columns and cards of work.
    """

    owner_url: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    columns_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="Name of the project", default=...)
    body: Union[str, None] = Field(description="Body of the project", default=...)
    number: int = Field(default=...)
    state: str = Field(
        description="State of the project; either 'open' or 'closed'", default=...
    )
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    organization_permission: Missing[Literal["read", "write", "admin", "none"]] = Field(
        description="The baseline permission that all organization members have on this project. Only present if owner is an organization.",
        default=UNSET,
    )
    private: Missing[bool] = Field(
        description="Whether or not this project can be seen by everyone. Only present if owner is an organization.",
        default=UNSET,
    )


class RepositoryRulesetBypassActor(GitHubRestModel):
    """Repository Ruleset Bypass Actor

    An actor that can bypass rules in a ruleset
    """

    actor_id: int = Field(
        description="The ID of the actor that can bypass a ruleset", default=...
    )
    actor_type: Literal[
        "RepositoryRole", "Team", "Integration", "OrganizationAdmin"
    ] = Field(description="The type of actor that can bypass a ruleset", default=...)
    bypass_mode: Literal["always", "pull_request"] = Field(
        description="When the specified actor can bypass the ruleset. `pull_request` means that an actor can only bypass rules on pull requests.",
        default=...,
    )


class RepositoryRulesetConditions(GitHubRestModel):
    """Repository ruleset conditions for ref names

    Parameters for a repository ruleset ref name condition
    """

    ref_name: Missing[RepositoryRulesetConditionsPropRefName] = Field(default=UNSET)


class RepositoryRulesetConditionsPropRefName(GitHubRestModel):
    """RepositoryRulesetConditionsPropRefName"""

    include: Missing[List[str]] = Field(
        description="Array of ref names or patterns to include. One of these patterns must match for the condition to pass. Also accepts `~DEFAULT_BRANCH` to include the default branch or `~ALL` to include all branches.",
        default=UNSET,
    )
    exclude: Missing[List[str]] = Field(
        description="Array of ref names or patterns to exclude. The condition will not pass if any of these patterns match.",
        default=UNSET,
    )


class RepositoryRulesetConditionsRepositoryNameTarget(GitHubRestModel):
    """Repository ruleset conditions for repository names

    Parameters for a repository name condition
    """

    repository_name: RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName = Field(
        default=...
    )


class RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName(
    GitHubRestModel
):
    """RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName"""

    include: Missing[List[str]] = Field(
        description="Array of repository names or patterns to include. One of these patterns must match for the condition to pass. Also accepts `~ALL` to include all repositories.",
        default=UNSET,
    )
    exclude: Missing[List[str]] = Field(
        description="Array of repository names or patterns to exclude. The condition will not pass if any of these patterns match.",
        default=UNSET,
    )
    protected: Missing[bool] = Field(
        description="Whether renaming of target repositories is prevented.",
        default=UNSET,
    )


class RepositoryRulesetConditionsRepositoryIdTarget(GitHubRestModel):
    """Repository ruleset conditions for repository IDs

    Parameters for a repository ID condition
    """

    repository_id: RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId = (
        Field(default=...)
    )


class RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId(GitHubRestModel):
    """RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId"""

    repository_ids: Missing[List[int]] = Field(
        description="The repository IDs that the ruleset applies to. One of these IDs must match for the condition to pass.",
        default=UNSET,
    )


class OrgRulesetConditionsOneof0(GitHubRestModel):
    """repository_name_and_ref_name

    Conditions to target repositories by name and refs by name
    """

    ref_name: Missing[RepositoryRulesetConditionsPropRefName] = Field(default=UNSET)
    repository_name: RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName = Field(
        default=...
    )


class OrgRulesetConditionsOneof1(GitHubRestModel):
    """repository_id_and_ref_name

    Conditions to target repositories by id and refs by name
    """

    ref_name: Missing[RepositoryRulesetConditionsPropRefName] = Field(default=UNSET)
    repository_id: RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId = (
        Field(default=...)
    )


class RepositoryRuleCreation(GitHubRestModel):
    """creation

    Only allow users with bypass permission to create matching refs.
    """

    type: Literal["creation"] = Field(default=...)


class RepositoryRuleUpdate(GitHubRestModel):
    """update

    Only allow users with bypass permission to update matching refs.
    """

    type: Literal["update"] = Field(default=...)
    parameters: Missing[RepositoryRuleUpdatePropParameters] = Field(default=UNSET)


class RepositoryRuleUpdatePropParameters(GitHubRestModel):
    """RepositoryRuleUpdatePropParameters"""

    update_allows_fetch_and_merge: bool = Field(
        description="Branch can pull changes from its upstream repository", default=...
    )


class RepositoryRuleDeletion(GitHubRestModel):
    """deletion

    Only allow users with bypass permissions to delete matching refs.
    """

    type: Literal["deletion"] = Field(default=...)


class RepositoryRuleRequiredLinearHistory(GitHubRestModel):
    """required_linear_history

    Prevent merge commits from being pushed to matching branches.
    """

    type: Literal["required_linear_history"] = Field(default=...)


class RepositoryRuleRequiredDeployments(GitHubRestModel):
    """required_deployments

    Choose which environments must be successfully deployed to before branches can
    be merged into a branch that matches this rule.
    """

    type: Literal["required_deployments"] = Field(default=...)
    parameters: Missing[RepositoryRuleRequiredDeploymentsPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleRequiredDeploymentsPropParameters(GitHubRestModel):
    """RepositoryRuleRequiredDeploymentsPropParameters"""

    required_deployment_environments: List[str] = Field(
        description="The environments that must be successfully deployed to before branches can be merged.",
        default=...,
    )


class RepositoryRuleRequiredSignatures(GitHubRestModel):
    """required_signatures

    Commits pushed to matching branches must have verified signatures.
    """

    type: Literal["required_signatures"] = Field(default=...)


class RepositoryRulePullRequest(GitHubRestModel):
    """pull_request

    Require all commits be made to a non-target branch and submitted via a pull
    request before they can be merged.
    """

    type: Literal["pull_request"] = Field(default=...)
    parameters: Missing[RepositoryRulePullRequestPropParameters] = Field(default=UNSET)


class RepositoryRulePullRequestPropParameters(GitHubRestModel):
    """RepositoryRulePullRequestPropParameters"""

    dismiss_stale_reviews_on_push: bool = Field(
        description="New, reviewable commits pushed will dismiss previous pull request review approvals.",
        default=...,
    )
    require_code_owner_review: bool = Field(
        description="Require an approving review in pull requests that modify files that have a designated code owner.",
        default=...,
    )
    require_last_push_approval: bool = Field(
        description="Whether the most recent reviewable push must be approved by someone other than the person who pushed it.",
        default=...,
    )
    required_approving_review_count: int = Field(
        description="The number of approving reviews that are required before a pull request can be merged.",
        le=10.0,
        default=...,
    )
    required_review_thread_resolution: bool = Field(
        description="All conversations on code must be resolved before a pull request can be merged.",
        default=...,
    )


class RepositoryRuleParamsStatusCheckConfiguration(GitHubRestModel):
    """StatusCheckConfiguration

    Required status check
    """

    context: str = Field(
        description="The status check context name that must be present on the commit.",
        default=...,
    )
    integration_id: Missing[int] = Field(
        description="The optional integration ID that this status check must originate from.",
        default=UNSET,
    )


class RepositoryRuleRequiredStatusChecks(GitHubRestModel):
    """required_status_checks

    Choose which status checks must pass before branches can be merged into a branch
    that matches this rule. When enabled, commits must first be pushed to another
    branch, then merged or pushed directly to a branch that matches this rule after
    status checks have passed.
    """

    type: Literal["required_status_checks"] = Field(default=...)
    parameters: Missing[RepositoryRuleRequiredStatusChecksPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleRequiredStatusChecksPropParameters(GitHubRestModel):
    """RepositoryRuleRequiredStatusChecksPropParameters"""

    required_status_checks: List[RepositoryRuleParamsStatusCheckConfiguration] = Field(
        description="Status checks that are required.", default=...
    )
    strict_required_status_checks_policy: bool = Field(
        description="Whether pull requests targeting a matching branch must be tested with the latest code. This setting will not take effect unless at least one status check is enabled.",
        default=...,
    )


class RepositoryRuleNonFastForward(GitHubRestModel):
    """non_fast_forward

    Prevent users with push access from force pushing to branches.
    """

    type: Literal["non_fast_forward"] = Field(default=...)


class RepositoryRuleCommitMessagePattern(GitHubRestModel):
    """commit_message_pattern

    Parameters to be used for the commit_message_pattern rule
    """

    type: Literal["commit_message_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleCommitMessagePatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleCommitMessagePatternPropParameters(GitHubRestModel):
    """RepositoryRuleCommitMessagePatternPropParameters"""

    name: Missing[str] = Field(
        description="How this rule will appear to users.", default=UNSET
    )
    negate: Missing[bool] = Field(
        description="If true, the rule will fail if the pattern matches.", default=UNSET
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching.", default=...
    )
    pattern: str = Field(description="The pattern to match with.", default=...)


class RepositoryRuleCommitAuthorEmailPattern(GitHubRestModel):
    """commit_author_email_pattern

    Parameters to be used for the commit_author_email_pattern rule
    """

    type: Literal["commit_author_email_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleCommitAuthorEmailPatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleCommitAuthorEmailPatternPropParameters(GitHubRestModel):
    """RepositoryRuleCommitAuthorEmailPatternPropParameters"""

    name: Missing[str] = Field(
        description="How this rule will appear to users.", default=UNSET
    )
    negate: Missing[bool] = Field(
        description="If true, the rule will fail if the pattern matches.", default=UNSET
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching.", default=...
    )
    pattern: str = Field(description="The pattern to match with.", default=...)


class RepositoryRuleCommitterEmailPattern(GitHubRestModel):
    """committer_email_pattern

    Parameters to be used for the committer_email_pattern rule
    """

    type: Literal["committer_email_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleCommitterEmailPatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleCommitterEmailPatternPropParameters(GitHubRestModel):
    """RepositoryRuleCommitterEmailPatternPropParameters"""

    name: Missing[str] = Field(
        description="How this rule will appear to users.", default=UNSET
    )
    negate: Missing[bool] = Field(
        description="If true, the rule will fail if the pattern matches.", default=UNSET
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching.", default=...
    )
    pattern: str = Field(description="The pattern to match with.", default=...)


class RepositoryRuleBranchNamePattern(GitHubRestModel):
    """branch_name_pattern

    Parameters to be used for the branch_name_pattern rule
    """

    type: Literal["branch_name_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleBranchNamePatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleBranchNamePatternPropParameters(GitHubRestModel):
    """RepositoryRuleBranchNamePatternPropParameters"""

    name: Missing[str] = Field(
        description="How this rule will appear to users.", default=UNSET
    )
    negate: Missing[bool] = Field(
        description="If true, the rule will fail if the pattern matches.", default=UNSET
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching.", default=...
    )
    pattern: str = Field(description="The pattern to match with.", default=...)


class RepositoryRuleTagNamePattern(GitHubRestModel):
    """tag_name_pattern

    Parameters to be used for the tag_name_pattern rule
    """

    type: Literal["tag_name_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleTagNamePatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleTagNamePatternPropParameters(GitHubRestModel):
    """RepositoryRuleTagNamePatternPropParameters"""

    name: Missing[str] = Field(
        description="How this rule will appear to users.", default=UNSET
    )
    negate: Missing[bool] = Field(
        description="If true, the rule will fail if the pattern matches.", default=UNSET
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching.", default=...
    )
    pattern: str = Field(description="The pattern to match with.", default=...)


class RepositoryRuleset(GitHubRestModel):
    """Repository ruleset

    A set of rules to apply when specified conditions are met.
    """

    id: int = Field(description="The ID of the ruleset", default=...)
    name: str = Field(description="The name of the ruleset", default=...)
    target: Missing[Literal["branch", "tag"]] = Field(
        description="The target of the ruleset", default=UNSET
    )
    source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of the source of the ruleset", default=UNSET
    )
    source: str = Field(description="The name of the source", default=...)
    enforcement: Literal["disabled", "active", "evaluate"] = Field(
        description="The enforcement level of the ruleset. `evaluate` allows admins to test rules before enforcing them. Admins can view insights on the Rule Insights page (`evaluate` is only available with GitHub Enterprise).",
        default=...,
    )
    bypass_actors: Missing[List[RepositoryRulesetBypassActor]] = Field(
        description="The actors that can bypass the rules in this ruleset",
        default=UNSET,
    )
    current_user_can_bypass: Missing[
        Literal["always", "pull_requests_only", "never"]
    ] = Field(
        description="The bypass type of the user making the API request for this ruleset. This field is only returned when\nquerying the repository-level endpoint.",
        default=UNSET,
    )
    node_id: Missing[str] = Field(default=UNSET)
    links: Missing[RepositoryRulesetPropLinks] = Field(default=UNSET, alias="_links")
    conditions: Missing[
        Union[
            RepositoryRulesetConditions,
            OrgRulesetConditionsOneof0,
            OrgRulesetConditionsOneof1,
        ]
    ] = Field(
        title="repository_id_and_ref_name",
        description="Conditions to target repositories by id and refs by name",
        default=UNSET,
    )
    rules: Missing[
        List[
            Union[
                RepositoryRuleCreation,
                RepositoryRuleUpdate,
                RepositoryRuleDeletion,
                RepositoryRuleRequiredLinearHistory,
                RepositoryRuleRequiredDeployments,
                RepositoryRuleRequiredSignatures,
                RepositoryRulePullRequest,
                RepositoryRuleRequiredStatusChecks,
                RepositoryRuleNonFastForward,
                RepositoryRuleCommitMessagePattern,
                RepositoryRuleCommitAuthorEmailPattern,
                RepositoryRuleCommitterEmailPattern,
                RepositoryRuleBranchNamePattern,
                RepositoryRuleTagNamePattern,
            ]
        ]
    ] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(default=UNSET)
    updated_at: Missing[datetime] = Field(default=UNSET)


class RepositoryRulesetPropLinks(GitHubRestModel):
    """RepositoryRulesetPropLinks"""

    self_: Missing[RepositoryRulesetPropLinksPropSelf] = Field(
        default=UNSET, alias="self"
    )
    html: Missing[RepositoryRulesetPropLinksPropHtml] = Field(default=UNSET)


class RepositoryRulesetPropLinksPropSelf(GitHubRestModel):
    """RepositoryRulesetPropLinksPropSelf"""

    href: Missing[str] = Field(description="The URL of the ruleset", default=UNSET)


class RepositoryRulesetPropLinksPropHtml(GitHubRestModel):
    """RepositoryRulesetPropLinksPropHtml"""

    href: Missing[str] = Field(description="The html URL of the ruleset", default=UNSET)


class RepositoryAdvisoryVulnerability(GitHubRestModel):
    """RepositoryAdvisoryVulnerability

    A product affected by the vulnerability detailed in a repository security
    advisory.
    """

    package: Union[RepositoryAdvisoryVulnerabilityPropPackage, None] = Field(
        description="The name of the package affected by the vulnerability.",
        default=...,
    )
    vulnerable_version_range: Union[str, None] = Field(
        description="The range of the package versions affected by the vulnerability.",
        default=...,
    )
    patched_versions: Union[str, None] = Field(
        description="The package version(s) that resolve the vulnerability.",
        default=...,
    )
    vulnerable_functions: Union[List[str], None] = Field(
        description="The functions in the package that are affected.", default=...
    )


class RepositoryAdvisoryVulnerabilityPropPackage(GitHubRestModel):
    """RepositoryAdvisoryVulnerabilityPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(
        description="The package's language or package management ecosystem.",
        default=...,
    )
    name: Union[str, None] = Field(
        description="The unique package name within its ecosystem.", default=...
    )


class RepositoryAdvisoryCredit(GitHubRestModel):
    """RepositoryAdvisoryCredit

    A credit given to a user for a repository security advisory.
    """

    user: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ] = Field(description="The type of credit the user is receiving.", default=...)
    state: Literal["accepted", "declined", "pending"] = Field(
        description="The state of the user's acceptance of the credit.", default=...
    )


class RepositoryAdvisory(GitHubRestModel):
    """RepositoryAdvisory

    A repository security advisory.
    """

    ghsa_id: str = Field(description="The GitHub Security Advisory ID.", default=...)
    cve_id: Union[str, None] = Field(
        description="The Common Vulnerabilities and Exposures (CVE) ID.", default=...
    )
    url: str = Field(description="The API URL for the advisory.", default=...)
    html_url: str = Field(description="The URL for the advisory.", default=...)
    summary: str = Field(
        description="A short summary of the advisory.", max_length=1024, default=...
    )
    description: Union[str, None] = Field(
        description="A detailed description of what the advisory entails.", default=...
    )
    severity: Union[None, Literal["critical", "high", "medium", "low"]] = Field(
        description="The severity of the advisory.", default=...
    )
    author: None = Field(description="The author of the advisory.", default=...)
    publisher: None = Field(description="The publisher of the advisory.", default=...)
    identifiers: List[RepositoryAdvisoryPropIdentifiersItems] = Field(default=...)
    state: Literal["published", "closed", "withdrawn", "draft", "triage"] = Field(
        description="The state of the advisory.", default=...
    )
    created_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was created, in ISO 8601 format.",
        default=...,
    )
    updated_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was last updated, in ISO 8601 format.",
        default=...,
    )
    published_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was published, in ISO 8601 format.",
        default=...,
    )
    closed_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was closed, in ISO 8601 format.",
        default=...,
    )
    withdrawn_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was withdrawn, in ISO 8601 format.",
        default=...,
    )
    submission: Union[RepositoryAdvisoryPropSubmission, None] = Field(default=...)
    vulnerabilities: Union[List[RepositoryAdvisoryVulnerability], None] = Field(
        default=...
    )
    cvss: Union[RepositoryAdvisoryPropCvss, None] = Field(default=...)
    cwes: Union[List[RepositoryAdvisoryPropCwesItems], None] = Field(default=...)
    cwe_ids: Union[List[str], None] = Field(
        description="A list of only the CWE IDs.", default=...
    )
    credits_: Union[List[RepositoryAdvisoryPropCreditsItems], None] = Field(
        default=..., alias="credits"
    )
    credits_detailed: Union[List[RepositoryAdvisoryCredit], None] = Field(default=...)
    collaborating_users: Union[List[SimpleUser], None] = Field(
        description="A list of users that collaborate on the advisory.", default=...
    )
    collaborating_teams: Union[List[Team], None] = Field(
        description="A list of teams that collaborate on the advisory.", default=...
    )
    private_fork: None = Field(
        description="A temporary private fork of the advisory's repository for collaborating on a fix.",
        default=...,
    )


class RepositoryAdvisoryPropIdentifiersItems(GitHubRestModel):
    """RepositoryAdvisoryPropIdentifiersItems"""

    type: Literal["CVE", "GHSA"] = Field(
        description="The type of identifier.", default=...
    )
    value: str = Field(description="The identifier value.", default=...)


class RepositoryAdvisoryPropSubmission(GitHubRestModel):
    """RepositoryAdvisoryPropSubmission"""

    accepted: bool = Field(
        description="Whether a private vulnerability report was accepted by the repository's administrators.",
        default=...,
    )


class RepositoryAdvisoryPropCvss(GitHubRestModel):
    """RepositoryAdvisoryPropCvss"""

    vector_string: Union[str, None] = Field(description="The CVSS vector.", default=...)
    score: Union[float, None] = Field(description="The CVSS score.", default=...)


class RepositoryAdvisoryPropCwesItems(GitHubRestModel):
    """RepositoryAdvisoryPropCwesItems"""

    cwe_id: str = Field(
        description="The Common Weakness Enumeration (CWE) identifier.", default=...
    )
    name: str = Field(description="The name of the CWE.", default=...)


class RepositoryAdvisoryPropCreditsItems(GitHubRestModel):
    """RepositoryAdvisoryPropCreditsItems"""

    login: Missing[str] = Field(
        description="The username of the user credited.", default=UNSET
    )
    type: Missing[
        Literal[
            "analyst",
            "finder",
            "reporter",
            "coordinator",
            "remediation_developer",
            "remediation_reviewer",
            "remediation_verifier",
            "tool",
            "sponsor",
            "other",
        ]
    ] = Field(description="The type of credit the user is receiving.", default=UNSET)


class ActionsBillingUsage(GitHubRestModel):
    """ActionsBillingUsage"""

    total_minutes_used: int = Field(
        description="The sum of the free and paid GitHub Actions minutes used.",
        default=...,
    )
    total_paid_minutes_used: int = Field(
        description="The total paid GitHub Actions minutes used.", default=...
    )
    included_minutes: int = Field(
        description="The amount of free GitHub Actions minutes available.", default=...
    )
    minutes_used_breakdown: ActionsBillingUsagePropMinutesUsedBreakdown = Field(
        default=...
    )


class ActionsBillingUsagePropMinutesUsedBreakdown(GitHubRestModel):
    """ActionsBillingUsagePropMinutesUsedBreakdown"""

    ubuntu: Missing[int] = Field(
        description="Total minutes used on Ubuntu runner machines.",
        default=UNSET,
        alias="UBUNTU",
    )
    macos: Missing[int] = Field(
        description="Total minutes used on macOS runner machines.",
        default=UNSET,
        alias="MACOS",
    )
    windows: Missing[int] = Field(
        description="Total minutes used on Windows runner machines.",
        default=UNSET,
        alias="WINDOWS",
    )
    ubuntu_4_core: Missing[int] = Field(
        description="Total minutes used on Ubuntu 4 core runner machines.",
        default=UNSET,
    )
    ubuntu_8_core: Missing[int] = Field(
        description="Total minutes used on Ubuntu 8 core runner machines.",
        default=UNSET,
    )
    ubuntu_16_core: Missing[int] = Field(
        description="Total minutes used on Ubuntu 16 core runner machines.",
        default=UNSET,
    )
    ubuntu_32_core: Missing[int] = Field(
        description="Total minutes used on Ubuntu 32 core runner machines.",
        default=UNSET,
    )
    ubuntu_64_core: Missing[int] = Field(
        description="Total minutes used on Ubuntu 64 core runner machines.",
        default=UNSET,
    )
    windows_4_core: Missing[int] = Field(
        description="Total minutes used on Windows 4 core runner machines.",
        default=UNSET,
    )
    windows_8_core: Missing[int] = Field(
        description="Total minutes used on Windows 8 core runner machines.",
        default=UNSET,
    )
    windows_16_core: Missing[int] = Field(
        description="Total minutes used on Windows 16 core runner machines.",
        default=UNSET,
    )
    windows_32_core: Missing[int] = Field(
        description="Total minutes used on Windows 32 core runner machines.",
        default=UNSET,
    )
    windows_64_core: Missing[int] = Field(
        description="Total minutes used on Windows 64 core runner machines.",
        default=UNSET,
    )
    macos_12_core: Missing[int] = Field(
        description="Total minutes used on macOS 12 core runner machines.",
        default=UNSET,
    )
    total: Missing[int] = Field(
        description="Total minutes used on all runner machines.", default=UNSET
    )


class PackagesBillingUsage(GitHubRestModel):
    """PackagesBillingUsage"""

    total_gigabytes_bandwidth_used: int = Field(
        description="Sum of the free and paid storage space (GB) for GitHuub Packages.",
        default=...,
    )
    total_paid_gigabytes_bandwidth_used: int = Field(
        description="Total paid storage space (GB) for GitHuub Packages.", default=...
    )
    included_gigabytes_bandwidth: int = Field(
        description="Free storage space (GB) for GitHub Packages.", default=...
    )


class CombinedBillingUsage(GitHubRestModel):
    """CombinedBillingUsage"""

    days_left_in_billing_cycle: int = Field(
        description="Numbers of days left in billing cycle.", default=...
    )
    estimated_paid_storage_for_month: int = Field(
        description="Estimated storage space (GB) used in billing cycle.", default=...
    )
    estimated_storage_for_month: int = Field(
        description="Estimated sum of free and paid storage space (GB) used in billing cycle.",
        default=...,
    )


class TeamOrganization(GitHubRestModel):
    """Team Organization

    Team Organization
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    members_url: str = Field(default=...)
    public_members_url: str = Field(default=...)
    avatar_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    name: Missing[str] = Field(default=UNSET)
    company: Missing[Union[str, None]] = Field(default=UNSET)
    blog: Missing[str] = Field(default=UNSET)
    location: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    twitter_username: Missing[Union[str, None]] = Field(default=UNSET)
    is_verified: Missing[bool] = Field(default=UNSET)
    has_organization_projects: bool = Field(default=...)
    has_repository_projects: bool = Field(default=...)
    public_repos: int = Field(default=...)
    public_gists: int = Field(default=...)
    followers: int = Field(default=...)
    following: int = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    type: str = Field(default=...)
    total_private_repos: Missing[int] = Field(default=UNSET)
    owned_private_repos: Missing[int] = Field(default=UNSET)
    private_gists: Missing[Union[int, None]] = Field(default=UNSET)
    disk_usage: Missing[Union[int, None]] = Field(default=UNSET)
    collaborators: Missing[Union[int, None]] = Field(default=UNSET)
    billing_email: Missing[Union[str, None]] = Field(default=UNSET)
    plan: Missing[TeamOrganizationPropPlan] = Field(default=UNSET)
    default_repository_permission: Missing[Union[str, None]] = Field(default=UNSET)
    members_can_create_repositories: Missing[Union[bool, None]] = Field(default=UNSET)
    two_factor_requirement_enabled: Missing[Union[bool, None]] = Field(default=UNSET)
    members_allowed_repository_creation_type: Missing[str] = Field(default=UNSET)
    members_can_create_public_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_private_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_internal_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_pages: Missing[bool] = Field(default=UNSET)
    members_can_create_public_pages: Missing[bool] = Field(default=UNSET)
    members_can_create_private_pages: Missing[bool] = Field(default=UNSET)
    members_can_fork_private_repositories: Missing[Union[bool, None]] = Field(
        default=UNSET
    )
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)
    updated_at: datetime = Field(default=...)
    archived_at: Union[datetime, None] = Field(default=...)


class TeamOrganizationPropPlan(GitHubRestModel):
    """TeamOrganizationPropPlan"""

    name: str = Field(default=...)
    space: int = Field(default=...)
    private_repos: int = Field(default=...)
    filled_seats: Missing[int] = Field(default=UNSET)
    seats: Missing[int] = Field(default=UNSET)


class TeamFull(GitHubRestModel):
    """Full Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int = Field(description="Unique identifier of the team", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the team", default=...)
    html_url: str = Field(default=...)
    name: str = Field(description="Name of the team", default=...)
    slug: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    privacy: Missing[Literal["closed", "secret"]] = Field(
        description="The level of privacy this team should have", default=UNSET
    )
    notification_setting: Missing[
        Literal["notifications_enabled", "notifications_disabled"]
    ] = Field(description="The notification setting the team has set", default=UNSET)
    permission: str = Field(
        description="Permission that the team will have for its repositories",
        default=...,
    )
    members_url: str = Field(default=...)
    repositories_url: str = Field(default=...)
    parent: Missing[Union[None, TeamSimple]] = Field(
        title="Team Simple",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )
    members_count: int = Field(default=...)
    repos_count: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    organization: TeamOrganization = Field(
        title="Team Organization", description="Team Organization", default=...
    )
    ldap_dn: Missing[str] = Field(
        description="Distinguished Name (DN) that team maps to within LDAP environment",
        default=UNSET,
    )


class TeamDiscussion(GitHubRestModel):
    """Team Discussion

    A team discussion is a persistent record of a free-form conversation within a
    team.
    """

    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    body: str = Field(description="The main text of the discussion.", default=...)
    body_html: str = Field(default=...)
    body_version: str = Field(
        description="The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.",
        default=...,
    )
    comments_count: int = Field(default=...)
    comments_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    last_edited_at: Union[datetime, None] = Field(default=...)
    html_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="The unique sequence number of a team discussion.", default=...
    )
    pinned: bool = Field(
        description="Whether or not this discussion should be pinned for easy retrieval.",
        default=...,
    )
    private: bool = Field(
        description="Whether or not this discussion should be restricted to team members and organization administrators.",
        default=...,
    )
    team_url: str = Field(default=...)
    title: str = Field(description="The title of the discussion.", default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)


class TeamDiscussionComment(GitHubRestModel):
    """Team Discussion Comment

    A reply to a discussion within a team.
    """

    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    body: str = Field(description="The main text of the comment.", default=...)
    body_html: str = Field(default=...)
    body_version: str = Field(
        description="The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    last_edited_at: Union[datetime, None] = Field(default=...)
    discussion_url: str = Field(default=...)
    html_url: str = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(
        description="The unique sequence number of a team discussion comment.",
        default=...,
    )
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)


class Reaction(GitHubRestModel):
    """Reaction

    Reactions to conversations provide a way to help people express their feelings
    more simply and effectively.
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(description="The reaction to use", default=...)
    created_at: datetime = Field(default=...)


class TeamMembership(GitHubRestModel):
    """Team Membership

    Team Membership
    """

    url: str = Field(default=...)
    role: Literal["member", "maintainer"] = Field(
        description="The role of the user in the team.", default="member"
    )
    state: Literal["active", "pending"] = Field(
        description="The state of the user's membership in the team.", default=...
    )


class TeamProject(GitHubRestModel):
    """Team Project

    A team's access to a project.
    """

    owner_url: str = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    columns_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    body: Union[str, None] = Field(default=...)
    number: int = Field(default=...)
    state: str = Field(default=...)
    creator: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    created_at: str = Field(default=...)
    updated_at: str = Field(default=...)
    organization_permission: Missing[str] = Field(
        description="The organization permission for this project. Only present when owner is an organization.",
        default=UNSET,
    )
    private: Missing[bool] = Field(
        description="Whether the project is private or not. Only present when owner is an organization.",
        default=UNSET,
    )
    permissions: TeamProjectPropPermissions = Field(default=...)


class TeamProjectPropPermissions(GitHubRestModel):
    """TeamProjectPropPermissions"""

    read: bool = Field(default=...)
    write: bool = Field(default=...)
    admin: bool = Field(default=...)


class TeamRepository(GitHubRestModel):
    """Team Repository

    A team's access to a repository.
    """

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    forks: int = Field(default=...)
    permissions: Missing[TeamRepositoryPropPermissions] = Field(default=UNSET)
    role_name: Missing[str] = Field(default=UNSET)
    owner: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    private: bool = Field(
        description="Whether the repository is private or public.", default=False
    )
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    forks_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    hooks_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    forks_count: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    size: int = Field(default=...)
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    open_issues_count: int = Field(default=...)
    is_template: Missing[bool] = Field(
        description="Whether this repository acts as a template that can be used to generate new repositories.",
        default=False,
    )
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: bool = Field(
        description="Returns whether or not this repository disabled.", default=...
    )
    visibility: Missing[str] = Field(
        description="The repository visibility: public, private, or internal.",
        default="public",
    )
    pushed_at: Union[datetime, None] = Field(default=...)
    created_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    allow_rebase_merge: Missing[bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    template_repository: Missing[Union[None, Repository]] = Field(
        title="Repository", description="A repository on GitHub.", default=UNSET
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_auto_merge: Missing[bool] = Field(
        description="Whether to allow Auto-merge to be used on pull requests.",
        default=False,
    )
    delete_branch_on_merge: Missing[bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    allow_merge_commit: Missing[bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_forking: Missing[bool] = Field(
        description="Whether to allow forking this repo", default=False
    )
    web_commit_signoff_required: Missing[bool] = Field(
        description="Whether to require contributors to sign off on web-based commits",
        default=False,
    )
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    master_branch: Missing[str] = Field(default=UNSET)


class TeamRepositoryPropPermissions(GitHubRestModel):
    """TeamRepositoryPropPermissions"""

    admin: bool = Field(default=...)
    pull: bool = Field(default=...)
    triage: Missing[bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    maintain: Missing[bool] = Field(default=UNSET)


class ProjectCard(GitHubRestModel):
    """Project Card

    Project cards represent a scope of work.
    """

    url: str = Field(default=...)
    id: int = Field(description="The project card's ID", default=...)
    node_id: str = Field(default=...)
    note: Union[str, None] = Field(default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    archived: Missing[bool] = Field(
        description="Whether or not the card is archived", default=UNSET
    )
    column_name: Missing[str] = Field(default=UNSET)
    project_id: Missing[str] = Field(default=UNSET)
    column_url: str = Field(default=...)
    content_url: Missing[str] = Field(default=UNSET)
    project_url: str = Field(default=...)


class ProjectColumn(GitHubRestModel):
    """Project Column

    Project columns contain cards of work.
    """

    url: str = Field(default=...)
    project_url: str = Field(default=...)
    cards_url: str = Field(default=...)
    id: int = Field(
        description="The unique identifier of the project column", default=...
    )
    node_id: str = Field(default=...)
    name: str = Field(description="Name of the project column", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class ProjectCollaboratorPermission(GitHubRestModel):
    """Project Collaborator Permission

    Project Collaborator Permission
    """

    permission: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class RateLimit(GitHubRestModel):
    """Rate Limit"""

    limit: int = Field(default=...)
    remaining: int = Field(default=...)
    reset: int = Field(default=...)
    used: int = Field(default=...)


class RateLimitOverview(GitHubRestModel):
    """Rate Limit Overview

    Rate Limit Overview
    """

    resources: RateLimitOverviewPropResources = Field(default=...)
    rate: RateLimit = Field(title="Rate Limit", default=...)


class RateLimitOverviewPropResources(GitHubRestModel):
    """RateLimitOverviewPropResources"""

    core: RateLimit = Field(title="Rate Limit", default=...)
    graphql: Missing[RateLimit] = Field(title="Rate Limit", default=UNSET)
    search: RateLimit = Field(title="Rate Limit", default=...)
    code_search: Missing[RateLimit] = Field(title="Rate Limit", default=UNSET)
    source_import: Missing[RateLimit] = Field(title="Rate Limit", default=UNSET)
    integration_manifest: Missing[RateLimit] = Field(title="Rate Limit", default=UNSET)
    code_scanning_upload: Missing[RateLimit] = Field(title="Rate Limit", default=UNSET)
    actions_runner_registration: Missing[RateLimit] = Field(
        title="Rate Limit", default=UNSET
    )
    scim: Missing[RateLimit] = Field(title="Rate Limit", default=UNSET)
    dependency_snapshots: Missing[RateLimit] = Field(title="Rate Limit", default=UNSET)


class CodeOfConductSimple(GitHubRestModel):
    """Code Of Conduct Simple

    Code of Conduct Simple
    """

    url: str = Field(default=...)
    key: str = Field(default=...)
    name: str = Field(default=...)
    html_url: Union[str, None] = Field(default=...)


class FullRepository(GitHubRestModel):
    """Full Repository

    Full Repository
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    full_name: str = Field(default=...)
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    private: bool = Field(default=...)
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    forks_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    hooks_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    forks_count: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    size: int = Field(
        description="The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.",
        default=...,
    )
    default_branch: str = Field(default=...)
    open_issues_count: int = Field(default=...)
    is_template: Missing[bool] = Field(default=UNSET)
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: bool = Field(default=...)
    has_projects: bool = Field(default=...)
    has_wiki: bool = Field(default=...)
    has_pages: bool = Field(default=...)
    has_downloads: bool = Field(default=...)
    has_discussions: bool = Field(default=...)
    archived: bool = Field(default=...)
    disabled: bool = Field(
        description="Returns whether or not this repository disabled.", default=...
    )
    visibility: Missing[str] = Field(
        description="The repository visibility: public, private, or internal.",
        default=UNSET,
    )
    pushed_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    permissions: Missing[FullRepositoryPropPermissions] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    template_repository: Missing[Union[None, Repository]] = Field(
        title="Repository", description="A repository on GitHub.", default=UNSET
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_auto_merge: Missing[bool] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Missing[bool] = Field(default=UNSET)
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n  - `PR_TITLE` - default to the pull request's title.\n  - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    allow_forking: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)
    subscribers_count: int = Field(default=...)
    network_count: int = Field(default=...)
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    organization: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    parent: Missing[Repository] = Field(
        title="Repository", description="A repository on GitHub.", default=UNSET
    )
    source: Missing[Repository] = Field(
        title="Repository", description="A repository on GitHub.", default=UNSET
    )
    forks: int = Field(default=...)
    master_branch: Missing[str] = Field(default=UNSET)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    anonymous_access_enabled: Missing[bool] = Field(
        description="Whether anonymous git access is allowed.", default=True
    )
    code_of_conduct: Missing[CodeOfConductSimple] = Field(
        title="Code Of Conduct Simple",
        description="Code of Conduct Simple",
        default=UNSET,
    )
    security_and_analysis: Missing[Union[SecurityAndAnalysis, None]] = Field(
        default=UNSET
    )


class FullRepositoryPropPermissions(GitHubRestModel):
    """FullRepositoryPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Missing[bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    triage: Missing[bool] = Field(default=UNSET)
    pull: bool = Field(default=...)


class Artifact(GitHubRestModel):
    """Artifact

    An artifact
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the artifact.", default=...)
    size_in_bytes: int = Field(
        description="The size in bytes of the artifact.", default=...
    )
    url: str = Field(default=...)
    archive_download_url: str = Field(default=...)
    expired: bool = Field(
        description="Whether or not the artifact has expired.", default=...
    )
    created_at: Union[datetime, None] = Field(default=...)
    expires_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    workflow_run: Missing[Union[ArtifactPropWorkflowRun, None]] = Field(default=UNSET)


class ArtifactPropWorkflowRun(GitHubRestModel):
    """ArtifactPropWorkflowRun"""

    id: Missing[int] = Field(default=UNSET)
    repository_id: Missing[int] = Field(default=UNSET)
    head_repository_id: Missing[int] = Field(default=UNSET)
    head_branch: Missing[str] = Field(default=UNSET)
    head_sha: Missing[str] = Field(default=UNSET)


class ActionsCacheList(GitHubRestModel):
    """Repository actions caches

    Repository actions caches
    """

    total_count: int = Field(description="Total number of caches", default=...)
    actions_caches: List[ActionsCacheListPropActionsCachesItems] = Field(
        description="Array of caches", default=...
    )


class ActionsCacheListPropActionsCachesItems(GitHubRestModel):
    """ActionsCacheListPropActionsCachesItems"""

    id: Missing[int] = Field(default=UNSET)
    ref: Missing[str] = Field(default=UNSET)
    key: Missing[str] = Field(default=UNSET)
    version: Missing[str] = Field(default=UNSET)
    last_accessed_at: Missing[datetime] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(default=UNSET)
    size_in_bytes: Missing[int] = Field(default=UNSET)


class Job(GitHubRestModel):
    """Job

    Information of a job execution in a workflow run
    """

    id: int = Field(description="The id of the job.", default=...)
    run_id: int = Field(
        description="The id of the associated workflow run.", default=...
    )
    run_url: str = Field(default=...)
    run_attempt: Missing[int] = Field(
        description="Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.",
        default=UNSET,
    )
    node_id: str = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the commit that is being run.", default=...
    )
    url: str = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The phase of the lifecycle that the job is currently in.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ] = Field(description="The outcome of the job.", default=...)
    created_at: datetime = Field(
        description="The time that the job created, in ISO 8601 format.", default=...
    )
    started_at: datetime = Field(
        description="The time that the job started, in ISO 8601 format.", default=...
    )
    completed_at: Union[datetime, None] = Field(
        description="The time that the job finished, in ISO 8601 format.", default=...
    )
    name: str = Field(description="The name of the job.", default=...)
    steps: Missing[List[JobPropStepsItems]] = Field(
        description="Steps in this job.", default=UNSET
    )
    check_run_url: str = Field(default=...)
    labels: List[str] = Field(
        description='Labels for the workflow job. Specified by the "runs_on" attribute in the action\'s workflow file.',
        default=...,
    )
    runner_id: Union[int, None] = Field(
        description="The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
        default=...,
    )
    runner_name: Union[str, None] = Field(
        description="The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
        default=...,
    )
    runner_group_id: Union[int, None] = Field(
        description="The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
        default=...,
    )
    runner_group_name: Union[str, None] = Field(
        description="The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
        default=...,
    )
    workflow_name: Union[str, None] = Field(
        description="The name of the workflow.", default=...
    )
    head_branch: Union[str, None] = Field(
        description="The name of the current branch.", default=...
    )


class JobPropStepsItems(GitHubRestModel):
    """JobPropStepsItems"""

    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The phase of the lifecycle that the job is currently in.",
        default=...,
    )
    conclusion: Union[str, None] = Field(
        description="The outcome of the job.", default=...
    )
    name: str = Field(description="The name of the job.", default=...)
    number: int = Field(default=...)
    started_at: Missing[Union[datetime, None]] = Field(
        description="The time that the step started, in ISO 8601 format.", default=UNSET
    )
    completed_at: Missing[Union[datetime, None]] = Field(
        description="The time that the job finished, in ISO 8601 format.", default=UNSET
    )


class OidcCustomSubRepo(GitHubRestModel):
    """Actions OIDC subject customization for a repository

    Actions OIDC subject customization for a repository
    """

    use_default: bool = Field(
        description="Whether to use the default template or not. If `true`, the `include_claim_keys` field is ignored.",
        default=...,
    )
    include_claim_keys: Missing[List[str]] = Field(
        description="Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.",
        default=UNSET,
    )


class ActionsSecret(GitHubRestModel):
    """Actions Secret

    Set secrets for GitHub Actions.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class ActionsVariable(GitHubRestModel):
    """Actions Variable"""

    name: str = Field(description="The name of the variable.", default=...)
    value: str = Field(description="The value of the variable.", default=...)
    created_at: datetime = Field(
        description="The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )


class ActionsRepositoryPermissions(GitHubRestModel):
    """ActionsRepositoryPermissions"""

    enabled: bool = Field(
        description="Whether GitHub Actions is enabled on the repository.", default=...
    )
    allowed_actions: Missing[Literal["all", "local_only", "selected"]] = Field(
        description="The permissions policy that controls the actions and reusable workflows that are allowed to run.",
        default=UNSET,
    )
    selected_actions_url: Missing[str] = Field(
        description="The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.",
        default=UNSET,
    )


class ActionsWorkflowAccessToRepository(GitHubRestModel):
    """ActionsWorkflowAccessToRepository"""

    access_level: Literal["none", "user", "organization"] = Field(
        description="Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the\nrepository.\n\n`none` means the access is only possible from workflows in this repository. `user` level access allows sharing across user owned private repos only. `organization` level access allows sharing across the organization.",
        default=...,
    )


class ReferencedWorkflow(GitHubRestModel):
    """Referenced workflow

    A workflow referenced/reused by the initial caller workflow
    """

    path: str = Field(default=...)
    sha: str = Field(default=...)
    ref: Missing[str] = Field(default=UNSET)


class PullRequestMinimal(GitHubRestModel):
    """Pull Request Minimal"""

    id: int = Field(default=...)
    number: int = Field(default=...)
    url: str = Field(default=...)
    head: PullRequestMinimalPropHead = Field(default=...)
    base: PullRequestMinimalPropBase = Field(default=...)


class PullRequestMinimalPropHead(GitHubRestModel):
    """PullRequestMinimalPropHead"""

    ref: str = Field(default=...)
    sha: str = Field(default=...)
    repo: PullRequestMinimalPropHeadPropRepo = Field(default=...)


class PullRequestMinimalPropHeadPropRepo(GitHubRestModel):
    """PullRequestMinimalPropHeadPropRepo"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)


class PullRequestMinimalPropBase(GitHubRestModel):
    """PullRequestMinimalPropBase"""

    ref: str = Field(default=...)
    sha: str = Field(default=...)
    repo: PullRequestMinimalPropBasePropRepo = Field(default=...)


class PullRequestMinimalPropBasePropRepo(GitHubRestModel):
    """PullRequestMinimalPropBasePropRepo"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)


class SimpleCommit(GitHubRestModel):
    """Simple Commit

    A commit.
    """

    id: str = Field(description="SHA for the commit", default=...)
    tree_id: str = Field(description="SHA for the commit's tree", default=...)
    message: str = Field(
        description="Message describing the purpose of the commit", default=...
    )
    timestamp: datetime = Field(description="Timestamp of the commit", default=...)
    author: Union[SimpleCommitPropAuthor, None] = Field(
        description="Information about the Git author", default=...
    )
    committer: Union[SimpleCommitPropCommitter, None] = Field(
        description="Information about the Git committer", default=...
    )


class SimpleCommitPropAuthor(GitHubRestModel):
    """SimpleCommitPropAuthor

    Information about the Git author
    """

    name: str = Field(description="Name of the commit's author", default=...)
    email: str = Field(
        description="Git email address of the commit's author", default=...
    )


class SimpleCommitPropCommitter(GitHubRestModel):
    """SimpleCommitPropCommitter

    Information about the Git committer
    """

    name: str = Field(description="Name of the commit's committer", default=...)
    email: str = Field(
        description="Git email address of the commit's committer", default=...
    )


class WorkflowRun(GitHubRestModel):
    """Workflow Run

    An invocation of a workflow
    """

    id: int = Field(description="The ID of the workflow run.", default=...)
    name: Missing[Union[str, None]] = Field(
        description="The name of the workflow run.", default=UNSET
    )
    node_id: str = Field(default=...)
    check_suite_id: Missing[int] = Field(
        description="The ID of the associated check suite.", default=UNSET
    )
    check_suite_node_id: Missing[str] = Field(
        description="The node ID of the associated check suite.", default=UNSET
    )
    head_branch: Union[str, None] = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that points to the version of the workflow being run.",
        default=...,
    )
    path: str = Field(description="The full path of the workflow", default=...)
    run_number: int = Field(
        description="The auto incrementing run number for the workflow run.",
        default=...,
    )
    run_attempt: Missing[int] = Field(
        description="Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.",
        default=UNSET,
    )
    referenced_workflows: Missing[Union[List[ReferencedWorkflow], None]] = Field(
        default=UNSET
    )
    event: str = Field(default=...)
    status: Union[str, None] = Field(default=...)
    conclusion: Union[str, None] = Field(default=...)
    workflow_id: int = Field(description="The ID of the parent workflow.", default=...)
    url: str = Field(description="The URL to the workflow run.", default=...)
    html_url: str = Field(default=...)
    pull_requests: Union[List[PullRequestMinimal], None] = Field(
        description="Pull requests that are open with a `head_sha` or `head_branch` that matches the workflow run. The returned pull requests do not necessarily indicate pull requests that triggered the run.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    actor: Missing[SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    triggering_actor: Missing[SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    run_started_at: Missing[datetime] = Field(
        description="The start time of the latest run. Resets on re-run.", default=UNSET
    )
    jobs_url: str = Field(
        description="The URL to the jobs for the workflow run.", default=...
    )
    logs_url: str = Field(
        description="The URL to download the logs for the workflow run.", default=...
    )
    check_suite_url: str = Field(
        description="The URL to the associated check suite.", default=...
    )
    artifacts_url: str = Field(
        description="The URL to the artifacts for the workflow run.", default=...
    )
    cancel_url: str = Field(
        description="The URL to cancel the workflow run.", default=...
    )
    rerun_url: str = Field(
        description="The URL to rerun the workflow run.", default=...
    )
    previous_attempt_url: Missing[Union[str, None]] = Field(
        description="The URL to the previous attempted run of this workflow, if one exists.",
        default=UNSET,
    )
    workflow_url: str = Field(description="The URL to the workflow.", default=...)
    head_commit: Union[None, SimpleCommit] = Field(
        title="Simple Commit", description="A commit.", default=...
    )
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    head_repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    head_repository_id: Missing[int] = Field(default=UNSET)
    display_title: str = Field(
        description="The event-specific title associated with the run or the run-name if set, or the value of `run-name` if it is set in the workflow.",
        default=...,
    )


class EnvironmentApprovals(GitHubRestModel):
    """Environment Approval

    An entry in the reviews log for environment deployments
    """

    environments: List[EnvironmentApprovalsPropEnvironmentsItems] = Field(
        description="The list of environments that were approved or rejected",
        default=...,
    )
    state: Literal["approved", "rejected", "pending"] = Field(
        description="Whether deployment to the environment(s) was approved or rejected or pending (with comments)",
        default=...,
    )
    user: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    comment: str = Field(
        description="The comment submitted with the deployment review", default=...
    )


class EnvironmentApprovalsPropEnvironmentsItems(GitHubRestModel):
    """EnvironmentApprovalsPropEnvironmentsItems"""

    id: Missing[int] = Field(description="The id of the environment.", default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(
        description="The name of the environment.", default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(
        description="The time that the environment was created, in ISO 8601 format.",
        default=UNSET,
    )
    updated_at: Missing[datetime] = Field(
        description="The time that the environment was last updated, in ISO 8601 format.",
        default=UNSET,
    )


class ReviewCustomGatesCommentRequired(GitHubRestModel):
    """ReviewCustomGatesCommentRequired"""

    environment_name: str = Field(
        description="The name of the environment to approve or reject.", default=...
    )
    comment: str = Field(
        description="Comment associated with the pending deployment protection rule. **Required when state is not provided.**",
        default=...,
    )


class ReviewCustomGatesStateRequired(GitHubRestModel):
    """ReviewCustomGatesStateRequired"""

    environment_name: str = Field(
        description="The name of the environment to approve or reject.", default=...
    )
    state: Literal["approved", "rejected"] = Field(
        description="Whether to approve or reject deployment to the specified environments.",
        default=...,
    )
    comment: Missing[str] = Field(
        description="Optional comment to include with the review.", default=UNSET
    )


class PendingDeployment(GitHubRestModel):
    """Pending Deployment

    Details of a deployment that is waiting for protection rules to pass
    """

    environment: PendingDeploymentPropEnvironment = Field(default=...)
    wait_timer: int = Field(
        description="The set duration of the wait timer", default=...
    )
    wait_timer_started_at: Union[datetime, None] = Field(
        description="The time that the wait timer began.", default=...
    )
    current_user_can_approve: bool = Field(
        description="Whether the currently authenticated user can approve the deployment",
        default=...,
    )
    reviewers: List[PendingDeploymentPropReviewersItems] = Field(
        description="The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.",
        default=...,
    )


class PendingDeploymentPropEnvironment(GitHubRestModel):
    """PendingDeploymentPropEnvironment"""

    id: Missing[int] = Field(description="The id of the environment.", default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(
        description="The name of the environment.", default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)


class PendingDeploymentPropReviewersItems(GitHubRestModel):
    """PendingDeploymentPropReviewersItems"""

    type: Missing[Literal["User", "Team"]] = Field(
        description="The type of reviewer.", default=UNSET
    )
    reviewer: Missing[Union[SimpleUser, Team]] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )


class Deployment(GitHubRestModel):
    """Deployment

    A request for a specific ref(branch,sha,tag) to be deployed
    """

    url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the deployment", default=...)
    node_id: str = Field(default=...)
    sha: str = Field(default=...)
    ref: str = Field(
        description="The ref to deploy. This can be a branch, tag, or sha.", default=...
    )
    task: str = Field(description="Parameter to specify a task to execute", default=...)
    payload: Union[DeploymentPropPayloadOneof0, str] = Field(default=...)
    original_environment: Missing[str] = Field(default=UNSET)
    environment: str = Field(
        description="Name for the target deployment environment.", default=...
    )
    description: Union[str, None] = Field(default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    statuses_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    transient_environment: Missing[bool] = Field(
        description="Specifies if the given environment is will no longer exist at some point in the future. Default: false.",
        default=UNSET,
    )
    production_environment: Missing[bool] = Field(
        description="Specifies if the given environment is one that end-users directly interact with. Default: false.",
        default=UNSET,
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class DeploymentPropPayloadOneof0(GitHubRestModel, extra=Extra.allow):
    """DeploymentPropPayloadOneof0"""


class WorkflowRunUsage(GitHubRestModel):
    """Workflow Run Usage

    Workflow Run Usage
    """

    billable: WorkflowRunUsagePropBillable = Field(default=...)
    run_duration_ms: Missing[int] = Field(default=UNSET)


class WorkflowRunUsagePropBillable(GitHubRestModel):
    """WorkflowRunUsagePropBillable"""

    ubuntu: Missing[WorkflowRunUsagePropBillablePropUbuntu] = Field(
        default=UNSET, alias="UBUNTU"
    )
    macos: Missing[WorkflowRunUsagePropBillablePropMacos] = Field(
        default=UNSET, alias="MACOS"
    )
    windows: Missing[WorkflowRunUsagePropBillablePropWindows] = Field(
        default=UNSET, alias="WINDOWS"
    )


class WorkflowRunUsagePropBillablePropUbuntu(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropUbuntu"""

    total_ms: int = Field(default=...)
    jobs: int = Field(default=...)
    job_runs: Missing[
        List[WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems]
    ] = Field(default=UNSET)


class WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems"""

    job_id: int = Field(default=...)
    duration_ms: int = Field(default=...)


class WorkflowRunUsagePropBillablePropMacos(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropMacos"""

    total_ms: int = Field(default=...)
    jobs: int = Field(default=...)
    job_runs: Missing[
        List[WorkflowRunUsagePropBillablePropMacosPropJobRunsItems]
    ] = Field(default=UNSET)


class WorkflowRunUsagePropBillablePropMacosPropJobRunsItems(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropMacosPropJobRunsItems"""

    job_id: int = Field(default=...)
    duration_ms: int = Field(default=...)


class WorkflowRunUsagePropBillablePropWindows(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropWindows"""

    total_ms: int = Field(default=...)
    jobs: int = Field(default=...)
    job_runs: Missing[
        List[WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems]
    ] = Field(default=UNSET)


class WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems(GitHubRestModel):
    """WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems"""

    job_id: int = Field(default=...)
    duration_ms: int = Field(default=...)


class Workflow(GitHubRestModel):
    """Workflow

    A GitHub Actions workflow
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    state: Literal[
        "active", "deleted", "disabled_fork", "disabled_inactivity", "disabled_manually"
    ] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    badge_url: str = Field(default=...)
    deleted_at: Missing[datetime] = Field(default=UNSET)


class WorkflowUsage(GitHubRestModel):
    """Workflow Usage

    Workflow Usage
    """

    billable: WorkflowUsagePropBillable = Field(default=...)


class WorkflowUsagePropBillable(GitHubRestModel):
    """WorkflowUsagePropBillable"""

    ubuntu: Missing[WorkflowUsagePropBillablePropUbuntu] = Field(
        default=UNSET, alias="UBUNTU"
    )
    macos: Missing[WorkflowUsagePropBillablePropMacos] = Field(
        default=UNSET, alias="MACOS"
    )
    windows: Missing[WorkflowUsagePropBillablePropWindows] = Field(
        default=UNSET, alias="WINDOWS"
    )


class WorkflowUsagePropBillablePropUbuntu(GitHubRestModel):
    """WorkflowUsagePropBillablePropUbuntu"""

    total_ms: Missing[int] = Field(default=UNSET)


class WorkflowUsagePropBillablePropMacos(GitHubRestModel):
    """WorkflowUsagePropBillablePropMacos"""

    total_ms: Missing[int] = Field(default=UNSET)


class WorkflowUsagePropBillablePropWindows(GitHubRestModel):
    """WorkflowUsagePropBillablePropWindows"""

    total_ms: Missing[int] = Field(default=UNSET)


class Activity(GitHubRestModel):
    """Activity

    Activity
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    before: str = Field(
        description="The SHA of the commit before the activity.", default=...
    )
    after: str = Field(
        description="The SHA of the commit after the activity.", default=...
    )
    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`.",
        default=...,
    )
    timestamp: datetime = Field(
        description="The time when the activity occurred.", default=...
    )
    activity_type: Literal[
        "push",
        "force_push",
        "branch_deletion",
        "branch_creation",
        "pr_merge",
        "merge_queue_merge",
    ] = Field(description="The type of the activity that was performed.", default=...)
    actor: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class Autolink(GitHubRestModel):
    """Autolink reference

    An autolink reference.
    """

    id: int = Field(default=...)
    key_prefix: str = Field(
        description="The prefix of a key that is linkified.", default=...
    )
    url_template: str = Field(
        description="A template for the target URL that is generated if a key was found.",
        default=...,
    )
    is_alphanumeric: bool = Field(
        description="Whether this autolink reference matches alphanumeric characters. If false, this autolink reference only matches numeric characters.",
        default=...,
    )


class CheckAutomatedSecurityFixes(GitHubRestModel):
    """Check Automated Security Fixes

    Check Automated Security Fixes
    """

    enabled: bool = Field(
        description="Whether automated security fixes are enabled for the repository.",
        default=...,
    )
    paused: bool = Field(
        description="Whether automated security fixes are paused for the repository.",
        default=...,
    )


class ProtectedBranchRequiredStatusCheck(GitHubRestModel):
    """Protected Branch Required Status Check

    Protected Branch Required Status Check
    """

    url: Missing[str] = Field(default=UNSET)
    enforcement_level: Missing[str] = Field(default=UNSET)
    contexts: List[str] = Field(default=...)
    checks: List[ProtectedBranchRequiredStatusCheckPropChecksItems] = Field(default=...)
    contexts_url: Missing[str] = Field(default=UNSET)
    strict: Missing[bool] = Field(default=UNSET)


class ProtectedBranchRequiredStatusCheckPropChecksItems(GitHubRestModel):
    """ProtectedBranchRequiredStatusCheckPropChecksItems"""

    context: str = Field(default=...)
    app_id: Union[int, None] = Field(default=...)


class ProtectedBranchAdminEnforced(GitHubRestModel):
    """Protected Branch Admin Enforced

    Protected Branch Admin Enforced
    """

    url: str = Field(default=...)
    enabled: bool = Field(default=...)


class ProtectedBranchPullRequestReview(GitHubRestModel):
    """Protected Branch Pull Request Review

    Protected Branch Pull Request Review
    """

    url: Missing[str] = Field(default=UNSET)
    dismissal_restrictions: Missing[
        ProtectedBranchPullRequestReviewPropDismissalRestrictions
    ] = Field(default=UNSET)
    bypass_pull_request_allowances: Missing[
        ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances
    ] = Field(
        description="Allow specific users, teams, or apps to bypass pull request requirements.",
        default=UNSET,
    )
    dismiss_stale_reviews: bool = Field(default=...)
    require_code_owner_reviews: bool = Field(default=...)
    required_approving_review_count: Missing[Annotated[int, Field(le=6.0)]] = Field(
        default=UNSET
    )
    require_last_push_approval: Missing[bool] = Field(
        description="Whether the most recent push must be approved by someone other than the person who pushed it.",
        default=False,
    )


class ProtectedBranchPullRequestReviewPropDismissalRestrictions(GitHubRestModel):
    """ProtectedBranchPullRequestReviewPropDismissalRestrictions"""

    users: Missing[List[SimpleUser]] = Field(
        description="The list of users with review dismissal access.", default=UNSET
    )
    teams: Missing[List[Team]] = Field(
        description="The list of teams with review dismissal access.", default=UNSET
    )
    apps: Missing[List[Integration]] = Field(
        description="The list of apps with review dismissal access.", default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    users_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)


class ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances(GitHubRestModel):
    """ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances

    Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: Missing[List[SimpleUser]] = Field(
        description="The list of users allowed to bypass pull request requirements.",
        default=UNSET,
    )
    teams: Missing[List[Team]] = Field(
        description="The list of teams allowed to bypass pull request requirements.",
        default=UNSET,
    )
    apps: Missing[List[Integration]] = Field(
        description="The list of apps allowed to bypass pull request requirements.",
        default=UNSET,
    )


class BranchRestrictionPolicy(GitHubRestModel):
    """Branch Restriction Policy

    Branch Restriction Policy
    """

    url: str = Field(default=...)
    users_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    apps_url: str = Field(default=...)
    users: List[BranchRestrictionPolicyPropUsersItems] = Field(default=...)
    teams: List[BranchRestrictionPolicyPropTeamsItems] = Field(default=...)
    apps: List[BranchRestrictionPolicyPropAppsItems] = Field(default=...)


class BranchRestrictionPolicyPropUsersItems(GitHubRestModel):
    """BranchRestrictionPolicyPropUsersItems"""

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)


class BranchRestrictionPolicyPropTeamsItems(GitHubRestModel):
    """BranchRestrictionPolicyPropTeamsItems"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    privacy: Missing[str] = Field(default=UNSET)
    notification_setting: Missing[str] = Field(default=UNSET)
    permission: Missing[str] = Field(default=UNSET)
    members_url: Missing[str] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    parent: Missing[Union[str, None]] = Field(default=UNSET)


class BranchRestrictionPolicyPropAppsItems(GitHubRestModel):
    """BranchRestrictionPolicyPropAppsItems"""

    id: Missing[int] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    owner: Missing[BranchRestrictionPolicyPropAppsItemsPropOwner] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    description: Missing[str] = Field(default=UNSET)
    external_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    permissions: Missing[BranchRestrictionPolicyPropAppsItemsPropPermissions] = Field(
        default=UNSET
    )
    events: Missing[List[str]] = Field(default=UNSET)


class BranchRestrictionPolicyPropAppsItemsPropOwner(GitHubRestModel):
    """BranchRestrictionPolicyPropAppsItemsPropOwner"""

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    members_url: Missing[str] = Field(default=UNSET)
    public_members_url: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    description: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)


class BranchRestrictionPolicyPropAppsItemsPropPermissions(GitHubRestModel):
    """BranchRestrictionPolicyPropAppsItemsPropPermissions"""

    metadata: Missing[str] = Field(default=UNSET)
    contents: Missing[str] = Field(default=UNSET)
    issues: Missing[str] = Field(default=UNSET)
    single_file: Missing[str] = Field(default=UNSET)


class BranchProtection(GitHubRestModel):
    """Branch Protection

    Branch Protection
    """

    url: Missing[str] = Field(default=UNSET)
    enabled: Missing[bool] = Field(default=UNSET)
    required_status_checks: Missing[ProtectedBranchRequiredStatusCheck] = Field(
        title="Protected Branch Required Status Check",
        description="Protected Branch Required Status Check",
        default=UNSET,
    )
    enforce_admins: Missing[ProtectedBranchAdminEnforced] = Field(
        title="Protected Branch Admin Enforced",
        description="Protected Branch Admin Enforced",
        default=UNSET,
    )
    required_pull_request_reviews: Missing[ProtectedBranchPullRequestReview] = Field(
        title="Protected Branch Pull Request Review",
        description="Protected Branch Pull Request Review",
        default=UNSET,
    )
    restrictions: Missing[BranchRestrictionPolicy] = Field(
        title="Branch Restriction Policy",
        description="Branch Restriction Policy",
        default=UNSET,
    )
    required_linear_history: Missing[BranchProtectionPropRequiredLinearHistory] = Field(
        default=UNSET
    )
    allow_force_pushes: Missing[BranchProtectionPropAllowForcePushes] = Field(
        default=UNSET
    )
    allow_deletions: Missing[BranchProtectionPropAllowDeletions] = Field(default=UNSET)
    block_creations: Missing[BranchProtectionPropBlockCreations] = Field(default=UNSET)
    required_conversation_resolution: Missing[
        BranchProtectionPropRequiredConversationResolution
    ] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    protection_url: Missing[str] = Field(default=UNSET)
    required_signatures: Missing[BranchProtectionPropRequiredSignatures] = Field(
        default=UNSET
    )
    lock_branch: Missing[BranchProtectionPropLockBranch] = Field(
        description="Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.",
        default=UNSET,
    )
    allow_fork_syncing: Missing[BranchProtectionPropAllowForkSyncing] = Field(
        description="Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.",
        default=UNSET,
    )


class BranchProtectionPropRequiredLinearHistory(GitHubRestModel):
    """BranchProtectionPropRequiredLinearHistory"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropAllowForcePushes(GitHubRestModel):
    """BranchProtectionPropAllowForcePushes"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropAllowDeletions(GitHubRestModel):
    """BranchProtectionPropAllowDeletions"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropBlockCreations(GitHubRestModel):
    """BranchProtectionPropBlockCreations"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropRequiredConversationResolution(GitHubRestModel):
    """BranchProtectionPropRequiredConversationResolution"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropRequiredSignatures(GitHubRestModel):
    """BranchProtectionPropRequiredSignatures"""

    url: str = Field(default=...)
    enabled: bool = Field(default=...)


class BranchProtectionPropLockBranch(GitHubRestModel):
    """BranchProtectionPropLockBranch

    Whether to set the branch as read-only. If this is true, users will not be able
    to push to the branch.
    """

    enabled: Missing[bool] = Field(default=False)


class BranchProtectionPropAllowForkSyncing(GitHubRestModel):
    """BranchProtectionPropAllowForkSyncing

    Whether users can pull changes from upstream when the branch is locked. Set to
    `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """

    enabled: Missing[bool] = Field(default=False)


class ShortBranch(GitHubRestModel):
    """Short Branch

    Short Branch
    """

    name: str = Field(default=...)
    commit: ShortBranchPropCommit = Field(default=...)
    protected: bool = Field(default=...)
    protection: Missing[BranchProtection] = Field(
        title="Branch Protection", description="Branch Protection", default=UNSET
    )
    protection_url: Missing[str] = Field(default=UNSET)


class ShortBranchPropCommit(GitHubRestModel):
    """ShortBranchPropCommit"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class GitUser(GitHubRestModel):
    """Git User

    Metaproperties for Git author/committer information.
    """

    name: Missing[str] = Field(default=UNSET)
    email: Missing[str] = Field(default=UNSET)
    date: Missing[str] = Field(default=UNSET)


class Verification(GitHubRestModel):
    """Verification"""

    verified: bool = Field(default=...)
    reason: str = Field(default=...)
    payload: Union[str, None] = Field(default=...)
    signature: Union[str, None] = Field(default=...)


class DiffEntry(GitHubRestModel):
    """Diff Entry

    Diff Entry
    """

    sha: str = Field(default=...)
    filename: str = Field(default=...)
    status: Literal[
        "added", "removed", "modified", "renamed", "copied", "changed", "unchanged"
    ] = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changes: int = Field(default=...)
    blob_url: str = Field(default=...)
    raw_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    patch: Missing[str] = Field(default=UNSET)
    previous_filename: Missing[str] = Field(default=UNSET)


class Commit(GitHubRestModel):
    """Commit

    Commit
    """

    url: str = Field(default=...)
    sha: str = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commit: CommitPropCommit = Field(default=...)
    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    committer: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    parents: List[CommitPropParentsItems] = Field(default=...)
    stats: Missing[CommitPropStats] = Field(default=UNSET)
    files: Missing[List[DiffEntry]] = Field(default=UNSET)


class CommitPropCommit(GitHubRestModel):
    """CommitPropCommit"""

    url: str = Field(default=...)
    author: Union[None, GitUser] = Field(
        title="Git User",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    committer: Union[None, GitUser] = Field(
        title="Git User",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    message: str = Field(default=...)
    comment_count: int = Field(default=...)
    tree: CommitPropCommitPropTree = Field(default=...)
    verification: Missing[Verification] = Field(title="Verification", default=UNSET)


class CommitPropCommitPropTree(GitHubRestModel):
    """CommitPropCommitPropTree"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class CommitPropParentsItems(GitHubRestModel):
    """CommitPropParentsItems"""

    sha: str = Field(default=...)
    url: str = Field(default=...)
    html_url: Missing[str] = Field(default=UNSET)


class CommitPropStats(GitHubRestModel):
    """CommitPropStats"""

    additions: Missing[int] = Field(default=UNSET)
    deletions: Missing[int] = Field(default=UNSET)
    total: Missing[int] = Field(default=UNSET)


class BranchWithProtection(GitHubRestModel):
    """Branch With Protection

    Branch With Protection
    """

    name: str = Field(default=...)
    commit: Commit = Field(title="Commit", description="Commit", default=...)
    links: BranchWithProtectionPropLinks = Field(default=..., alias="_links")
    protected: bool = Field(default=...)
    protection: BranchProtection = Field(
        title="Branch Protection", description="Branch Protection", default=...
    )
    protection_url: str = Field(default=...)
    pattern: Missing[str] = Field(default=UNSET)
    required_approving_review_count: Missing[int] = Field(default=UNSET)


class BranchWithProtectionPropLinks(GitHubRestModel):
    """BranchWithProtectionPropLinks"""

    html: str = Field(default=...)
    self_: str = Field(default=..., alias="self")


class StatusCheckPolicy(GitHubRestModel):
    """Status Check Policy

    Status Check Policy
    """

    url: str = Field(default=...)
    strict: bool = Field(default=...)
    contexts: List[str] = Field(default=...)
    checks: List[StatusCheckPolicyPropChecksItems] = Field(default=...)
    contexts_url: str = Field(default=...)


class StatusCheckPolicyPropChecksItems(GitHubRestModel):
    """StatusCheckPolicyPropChecksItems"""

    context: str = Field(default=...)
    app_id: Union[int, None] = Field(default=...)


class ProtectedBranch(GitHubRestModel):
    """Protected Branch

    Branch protections protect branches
    """

    url: str = Field(default=...)
    required_status_checks: Missing[StatusCheckPolicy] = Field(
        title="Status Check Policy", description="Status Check Policy", default=UNSET
    )
    required_pull_request_reviews: Missing[
        ProtectedBranchPropRequiredPullRequestReviews
    ] = Field(default=UNSET)
    required_signatures: Missing[ProtectedBranchPropRequiredSignatures] = Field(
        default=UNSET
    )
    enforce_admins: Missing[ProtectedBranchPropEnforceAdmins] = Field(default=UNSET)
    required_linear_history: Missing[ProtectedBranchPropRequiredLinearHistory] = Field(
        default=UNSET
    )
    allow_force_pushes: Missing[ProtectedBranchPropAllowForcePushes] = Field(
        default=UNSET
    )
    allow_deletions: Missing[ProtectedBranchPropAllowDeletions] = Field(default=UNSET)
    restrictions: Missing[BranchRestrictionPolicy] = Field(
        title="Branch Restriction Policy",
        description="Branch Restriction Policy",
        default=UNSET,
    )
    required_conversation_resolution: Missing[
        ProtectedBranchPropRequiredConversationResolution
    ] = Field(default=UNSET)
    block_creations: Missing[ProtectedBranchPropBlockCreations] = Field(default=UNSET)
    lock_branch: Missing[ProtectedBranchPropLockBranch] = Field(
        description="Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.",
        default=UNSET,
    )
    allow_fork_syncing: Missing[ProtectedBranchPropAllowForkSyncing] = Field(
        description="Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.",
        default=UNSET,
    )


class ProtectedBranchPropRequiredPullRequestReviews(GitHubRestModel):
    """ProtectedBranchPropRequiredPullRequestReviews"""

    url: str = Field(default=...)
    dismiss_stale_reviews: Missing[bool] = Field(default=UNSET)
    require_code_owner_reviews: Missing[bool] = Field(default=UNSET)
    required_approving_review_count: Missing[int] = Field(default=UNSET)
    require_last_push_approval: Missing[bool] = Field(
        description="Whether the most recent push must be approved by someone other than the person who pushed it.",
        default=False,
    )
    dismissal_restrictions: Missing[
        ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions
    ] = Field(default=UNSET)
    bypass_pull_request_allowances: Missing[
        ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances
    ] = Field(default=UNSET)


class ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions(
    GitHubRestModel
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions"""

    url: str = Field(default=...)
    users_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    users: List[SimpleUser] = Field(default=...)
    teams: List[Team] = Field(default=...)
    apps: Missing[List[Integration]] = Field(default=UNSET)


class ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances(
    GitHubRestModel
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances"""

    users: List[SimpleUser] = Field(default=...)
    teams: List[Team] = Field(default=...)
    apps: Missing[List[Integration]] = Field(default=UNSET)


class ProtectedBranchPropRequiredSignatures(GitHubRestModel):
    """ProtectedBranchPropRequiredSignatures"""

    url: str = Field(default=...)
    enabled: bool = Field(default=...)


class ProtectedBranchPropEnforceAdmins(GitHubRestModel):
    """ProtectedBranchPropEnforceAdmins"""

    url: str = Field(default=...)
    enabled: bool = Field(default=...)


class ProtectedBranchPropRequiredLinearHistory(GitHubRestModel):
    """ProtectedBranchPropRequiredLinearHistory"""

    enabled: bool = Field(default=...)


class ProtectedBranchPropAllowForcePushes(GitHubRestModel):
    """ProtectedBranchPropAllowForcePushes"""

    enabled: bool = Field(default=...)


class ProtectedBranchPropAllowDeletions(GitHubRestModel):
    """ProtectedBranchPropAllowDeletions"""

    enabled: bool = Field(default=...)


class ProtectedBranchPropRequiredConversationResolution(GitHubRestModel):
    """ProtectedBranchPropRequiredConversationResolution"""

    enabled: Missing[bool] = Field(default=UNSET)


class ProtectedBranchPropBlockCreations(GitHubRestModel):
    """ProtectedBranchPropBlockCreations"""

    enabled: bool = Field(default=...)


class ProtectedBranchPropLockBranch(GitHubRestModel):
    """ProtectedBranchPropLockBranch

    Whether to set the branch as read-only. If this is true, users will not be able
    to push to the branch.
    """

    enabled: Missing[bool] = Field(default=False)


class ProtectedBranchPropAllowForkSyncing(GitHubRestModel):
    """ProtectedBranchPropAllowForkSyncing

    Whether users can pull changes from upstream when the branch is locked. Set to
    `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """

    enabled: Missing[bool] = Field(default=False)


class DeploymentSimple(GitHubRestModel):
    """Deployment

    A deployment created as the result of an Actions check run from a workflow that
    references an environment
    """

    url: str = Field(default=...)
    id: int = Field(description="Unique identifier of the deployment", default=...)
    node_id: str = Field(default=...)
    task: str = Field(description="Parameter to specify a task to execute", default=...)
    original_environment: Missing[str] = Field(default=UNSET)
    environment: str = Field(
        description="Name for the target deployment environment.", default=...
    )
    description: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    statuses_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    transient_environment: Missing[bool] = Field(
        description="Specifies if the given environment is will no longer exist at some point in the future. Default: false.",
        default=UNSET,
    )
    production_environment: Missing[bool] = Field(
        description="Specifies if the given environment is one that end-users directly interact with. Default: false.",
        default=UNSET,
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class CheckRun(GitHubRestModel):
    """CheckRun

    A check performed on the code of a given code change
    """

    id: int = Field(description="The id of the check.", default=...)
    head_sha: str = Field(
        description="The SHA of the commit that is being checked.", default=...
    )
    node_id: str = Field(default=...)
    external_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    details_url: Union[str, None] = Field(default=...)
    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The phase of the lifecycle that the check is currently in.",
        default=...,
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ] = Field(default=...)
    started_at: Union[datetime, None] = Field(default=...)
    completed_at: Union[datetime, None] = Field(default=...)
    output: CheckRunPropOutput = Field(default=...)
    name: str = Field(description="The name of the check.", default=...)
    check_suite: Union[CheckRunPropCheckSuite, None] = Field(default=...)
    app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    pull_requests: List[PullRequestMinimal] = Field(
        description="Pull requests that are open with a `head_sha` or `head_branch` that matches the check. The returned pull requests do not necessarily indicate pull requests that triggered the check.",
        default=...,
    )
    deployment: Missing[DeploymentSimple] = Field(
        title="Deployment",
        description="A deployment created as the result of an Actions check run from a workflow that references an environment",
        default=UNSET,
    )


class CheckRunPropOutput(GitHubRestModel):
    """CheckRunPropOutput"""

    title: Union[str, None] = Field(default=...)
    summary: Union[str, None] = Field(default=...)
    text: Union[str, None] = Field(default=...)
    annotations_count: int = Field(default=...)
    annotations_url: str = Field(default=...)


class CheckRunPropCheckSuite(GitHubRestModel):
    """CheckRunPropCheckSuite"""

    id: int = Field(default=...)


class CheckAnnotation(GitHubRestModel):
    """Check Annotation

    Check Annotation
    """

    path: str = Field(default=...)
    start_line: int = Field(default=...)
    end_line: int = Field(default=...)
    start_column: Union[int, None] = Field(default=...)
    end_column: Union[int, None] = Field(default=...)
    annotation_level: Union[str, None] = Field(default=...)
    title: Union[str, None] = Field(default=...)
    message: Union[str, None] = Field(default=...)
    raw_details: Union[str, None] = Field(default=...)
    blob_href: str = Field(default=...)


class CheckSuite(GitHubRestModel):
    """CheckSuite

    A suite of checks performed on the code of a given code change
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    head_branch: Union[str, None] = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked.", default=...
    )
    status: Union[None, Literal["queued", "in_progress", "completed"]] = Field(
        default=...
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
            "startup_failure",
            "stale",
        ],
    ] = Field(default=...)
    url: Union[str, None] = Field(default=...)
    before: Union[str, None] = Field(default=...)
    after: Union[str, None] = Field(default=...)
    pull_requests: Union[List[PullRequestMinimal], None] = Field(default=...)
    app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    created_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    head_commit: SimpleCommit = Field(
        title="Simple Commit", description="A commit.", default=...
    )
    latest_check_runs_count: int = Field(default=...)
    check_runs_url: str = Field(default=...)
    rerequestable: Missing[bool] = Field(default=UNSET)
    runs_rerequestable: Missing[bool] = Field(default=UNSET)


class CheckSuitePreference(GitHubRestModel):
    """Check Suite Preference

    Check suite configuration preferences for a repository.
    """

    preferences: CheckSuitePreferencePropPreferences = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )


class CheckSuitePreferencePropPreferences(GitHubRestModel):
    """CheckSuitePreferencePropPreferences"""

    auto_trigger_checks: Missing[
        List[CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems]
    ] = Field(default=UNSET)


class CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems(GitHubRestModel):
    """CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems"""

    app_id: int = Field(default=...)
    setting: bool = Field(default=...)


class CodeScanningAlertRuleSummary(GitHubRestModel):
    """CodeScanningAlertRuleSummary"""

    id: Missing[Union[str, None]] = Field(
        description="A unique identifier for the rule used to detect the alert.",
        default=UNSET,
    )
    name: Missing[str] = Field(
        description="The name of the rule used to detect the alert.", default=UNSET
    )
    tags: Missing[Union[List[str], None]] = Field(
        description="A set of tags applicable for the rule.", default=UNSET
    )
    severity: Missing[Union[None, Literal["none", "note", "warning", "error"]]] = Field(
        description="The severity of the alert.", default=UNSET
    )
    description: Missing[str] = Field(
        description="A short description of the rule used to detect the alert.",
        default=UNSET,
    )


class CodeScanningAlertItems(GitHubRestModel):
    """CodeScanningAlertItems"""

    number: int = Field(description="The security alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: Missing[datetime] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances_url: str = Field(
        description="The REST API URL for fetching the list of instances for an alert.",
        default=...,
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    fixed_at: Missing[Union[datetime, None]] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert.",
        default=...,
    )
    dismissed_comment: Missing[
        Annotated[Union[str, None], Field(max_length=280)]
    ] = Field(
        description="The dismissal comment associated with the dismissal of the alert.",
        default=UNSET,
    )
    rule: CodeScanningAlertRuleSummary = Field(default=...)
    tool: CodeScanningAnalysisTool = Field(default=...)
    most_recent_instance: CodeScanningAlertInstance = Field(default=...)


class CodeScanningAlert(GitHubRestModel):
    """CodeScanningAlert"""

    number: int = Field(description="The security alert number.", default=...)
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: Missing[datetime] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    instances_url: str = Field(
        description="The REST API URL for fetching the list of instances for an alert.",
        default=...,
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert.", default=...
    )
    fixed_at: Missing[Union[datetime, None]] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert.",
        default=...,
    )
    dismissed_comment: Missing[
        Annotated[Union[str, None], Field(max_length=280)]
    ] = Field(
        description="The dismissal comment associated with the dismissal of the alert.",
        default=UNSET,
    )
    rule: CodeScanningAlertRule = Field(default=...)
    tool: CodeScanningAnalysisTool = Field(default=...)
    most_recent_instance: CodeScanningAlertInstance = Field(default=...)


class CodeScanningAnalysis(GitHubRestModel):
    """CodeScanningAnalysis"""

    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`,\n`refs/pull/<number>/merge`, or `refs/pull/<number>/head`.",
        default=...,
    )
    commit_sha: str = Field(
        description="The SHA of the commit to which the analysis you are uploading relates.",
        min_length=40,
        max_length=40,
        pattern="^[0-9a-fA-F]+$",
        default=...,
    )
    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
        default=...,
    )
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which this analysis was performed.",
        default=...,
    )
    category: Missing[str] = Field(
        description="Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.",
        default=UNSET,
    )
    error: str = Field(default=...)
    created_at: datetime = Field(
        description="The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    results_count: int = Field(
        description="The total number of results in the analysis.", default=...
    )
    rules_count: int = Field(
        description="The total number of rules used in the analysis.", default=...
    )
    id: int = Field(description="Unique identifier for this analysis.", default=...)
    url: str = Field(
        description="The REST API URL of the analysis resource.", default=...
    )
    sarif_id: str = Field(description="An identifier for the upload.", default=...)
    tool: CodeScanningAnalysisTool = Field(default=...)
    deletable: bool = Field(default=...)
    warning: str = Field(
        description="Warning generated when processing the analysis", default=...
    )


class CodeScanningAnalysisDeletion(GitHubRestModel):
    """Analysis deletion

    Successful deletion of a code scanning analysis
    """

    next_analysis_url: Union[str, None] = Field(
        description="Next deletable analysis in chain, without last analysis deletion confirmation",
        default=...,
    )
    confirm_delete_url: Union[str, None] = Field(
        description="Next deletable analysis in chain, with last analysis deletion confirmation",
        default=...,
    )


class CodeScanningCodeqlDatabase(GitHubRestModel):
    """CodeQL Database

    A CodeQL database.
    """

    id: int = Field(description="The ID of the CodeQL database.", default=...)
    name: str = Field(description="The name of the CodeQL database.", default=...)
    language: str = Field(
        description="The language of the CodeQL database.", default=...
    )
    uploader: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    content_type: str = Field(
        description="The MIME type of the CodeQL database file.", default=...
    )
    size: int = Field(
        description="The size of the CodeQL database file in bytes.", default=...
    )
    created_at: datetime = Field(
        description="The date and time at which the CodeQL database was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The date and time at which the CodeQL database was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    url: str = Field(
        description="The URL at which to download the CodeQL database. The `Accept` header must be set to the value of the `content_type` property.",
        default=...,
    )


class CodeScanningDefaultSetup(GitHubRestModel):
    """CodeScanningDefaultSetup

    Configuration for code scanning default setup.
    """

    state: Missing[Literal["configured", "not-configured"]] = Field(
        description="Code scanning default setup has been configured or not.",
        default=UNSET,
    )
    languages: Missing[
        List[
            Literal[
                "c-cpp",
                "csharp",
                "go",
                "java-kotlin",
                "javascript-typescript",
                "javascript",
                "python",
                "ruby",
                "typescript",
                "swift",
            ]
        ]
    ] = Field(description="Languages to be analysed.", default=UNSET)
    query_suite: Missing[Literal["default", "extended"]] = Field(
        description="CodeQL query suite to be used.", default=UNSET
    )
    updated_at: Missing[Union[datetime, None]] = Field(
        description="Timestamp of latest configuration update.", default=UNSET
    )
    schedule: Missing[Union[None, Literal["weekly"]]] = Field(
        description="The frequency of the periodic analysis.", default=UNSET
    )


class CodeScanningDefaultSetupUpdate(GitHubRestModel):
    """CodeScanningDefaultSetupUpdate

    Configuration for code scanning default setup.
    """

    state: Literal["configured", "not-configured"] = Field(
        description="Whether code scanning default setup has been configured or not.",
        default=...,
    )
    query_suite: Missing[Literal["default", "extended"]] = Field(
        description="CodeQL query suite to be used.", default=UNSET
    )
    languages: Missing[
        List[
            Literal[
                "c-cpp",
                "csharp",
                "go",
                "java-kotlin",
                "javascript-typescript",
                "python",
                "ruby",
                "swift",
            ]
        ]
    ] = Field(
        description="CodeQL languages to be analyzed. Supported values are: `c-cpp`, `csharp`, `go`, `java-kotlin`, `javascript-typescript`, `python`, `ruby`, and `swift`.",
        default=UNSET,
    )


class CodeScanningDefaultSetupUpdateResponse(GitHubRestModel):
    """CodeScanningDefaultSetupUpdateResponse

    You can use `run_url` to track the status of the run. This includes a property
    status and conclusion.
    You should not rely on this always being an actions workflow run object.
    """

    run_id: Missing[int] = Field(
        description="ID of the corresponding run.", default=UNSET
    )
    run_url: Missing[str] = Field(
        description="URL of the corresponding run.", default=UNSET
    )


class CodeScanningSarifsReceipt(GitHubRestModel):
    """CodeScanningSarifsReceipt"""

    id: Missing[str] = Field(description="An identifier for the upload.", default=UNSET)
    url: Missing[str] = Field(
        description="The REST API URL for checking the status of the upload.",
        default=UNSET,
    )


class CodeScanningSarifsStatus(GitHubRestModel):
    """CodeScanningSarifsStatus"""

    processing_status: Missing[Literal["pending", "complete", "failed"]] = Field(
        description="`pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.",
        default=UNSET,
    )
    analyses_url: Missing[Union[str, None]] = Field(
        description="The REST API URL for getting the analyses associated with the upload.",
        default=UNSET,
    )
    errors: Missing[Union[List[str], None]] = Field(
        description="Any errors that ocurred during processing of the delivery.",
        default=UNSET,
    )


class CodeownersErrors(GitHubRestModel):
    """CODEOWNERS errors

    A list of errors found in a repo's CODEOWNERS file
    """

    errors: List[CodeownersErrorsPropErrorsItems] = Field(default=...)


class CodeownersErrorsPropErrorsItems(GitHubRestModel):
    """CodeownersErrorsPropErrorsItems"""

    line: int = Field(
        description="The line number where this errors occurs.", default=...
    )
    column: int = Field(
        description="The column number where this errors occurs.", default=...
    )
    source: Missing[str] = Field(
        description="The contents of the line where the error occurs.", default=UNSET
    )
    kind: str = Field(description="The type of error.", default=...)
    suggestion: Missing[Union[str, None]] = Field(
        description="Suggested action to fix the error. This will usually be `null`, but is provided for some common errors.",
        default=UNSET,
    )
    message: str = Field(
        description="A human-readable description of the error, combining information from multiple fields, laid out for display in a monospaced typeface (for example, a command-line setting).",
        default=...,
    )
    path: str = Field(
        description="The path of the file where the error occured.", default=...
    )


class RepoCodespacesSecret(GitHubRestModel):
    """Codespaces Secret

    Set repository secrets for GitHub Codespaces.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class Collaborator(GitHubRestModel):
    """Collaborator

    Collaborator
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    name: Missing[Union[str, None]] = Field(default=UNSET)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    permissions: Missing[CollaboratorPropPermissions] = Field(default=UNSET)
    role_name: str = Field(default=...)


class CollaboratorPropPermissions(GitHubRestModel):
    """CollaboratorPropPermissions"""

    pull: bool = Field(default=...)
    triage: Missing[bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    maintain: Missing[bool] = Field(default=UNSET)
    admin: bool = Field(default=...)


class RepositoryInvitation(GitHubRestModel):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    id: int = Field(
        description="Unique identifier of the repository invitation.", default=...
    )
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    invitee: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    inviter: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    permissions: Literal["read", "write", "admin", "triage", "maintain"] = Field(
        description="The permission associated with the invitation.", default=...
    )
    created_at: datetime = Field(default=...)
    expired: Missing[bool] = Field(
        description="Whether or not the invitation has expired", default=UNSET
    )
    url: str = Field(description="URL for the repository invitation", default=...)
    html_url: str = Field(default=...)
    node_id: str = Field(default=...)


class RepositoryCollaboratorPermission(GitHubRestModel):
    """Repository Collaborator Permission

    Repository Collaborator Permission
    """

    permission: str = Field(default=...)
    role_name: str = Field(default=...)
    user: Union[None, Collaborator] = Field(
        title="Collaborator", description="Collaborator", default=...
    )


class CommitComment(GitHubRestModel):
    """Commit Comment

    Commit Comment
    """

    html_url: str = Field(default=...)
    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    body: str = Field(default=...)
    path: Union[str, None] = Field(default=...)
    position: Union[int, None] = Field(default=...)
    line: Union[int, None] = Field(default=...)
    commit_id: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)


class BranchShort(GitHubRestModel):
    """Branch Short

    Branch Short
    """

    name: str = Field(default=...)
    commit: BranchShortPropCommit = Field(default=...)
    protected: bool = Field(default=...)


class BranchShortPropCommit(GitHubRestModel):
    """BranchShortPropCommit"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class Link(GitHubRestModel):
    """Link

    Hypermedia Link
    """

    href: str = Field(default=...)


class AutoMerge(GitHubRestModel):
    """Auto merge

    The status of auto merging a pull request.
    """

    enabled_by: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    merge_method: Literal["merge", "squash", "rebase"] = Field(
        description="The merge method to use.", default=...
    )
    commit_title: Union[str, None] = Field(
        description="Title for the merge commit message.", default=...
    )
    commit_message: Union[str, None] = Field(
        description="Commit message for the merge commit.", default=...
    )


class PullRequestSimple(GitHubRestModel):
    """Pull Request Simple

    Pull Request Simple
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    number: int = Field(default=...)
    state: str = Field(default=...)
    locked: bool = Field(default=...)
    title: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    body: Union[str, None] = Field(default=...)
    labels: List[PullRequestSimplePropLabelsItems] = Field(default=...)
    milestone: Union[None, Milestone] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    assignees: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_reviewers: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_teams: Missing[Union[List[Team], None]] = Field(default=UNSET)
    head: PullRequestSimplePropHead = Field(default=...)
    base: PullRequestSimplePropBase = Field(default=...)
    links: PullRequestSimplePropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="Auto merge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    draft: Missing[bool] = Field(
        description="Indicates whether or not the pull request is a draft.",
        default=UNSET,
    )


class PullRequestSimplePropLabelsItems(GitHubRestModel):
    """PullRequestSimplePropLabelsItems"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    color: str = Field(default=...)
    default: bool = Field(default=...)


class PullRequestSimplePropHead(GitHubRestModel):
    """PullRequestSimplePropHead"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    repo: Union[None, Repository] = Field(
        title="Repository", description="A repository on GitHub.", default=...
    )
    sha: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class PullRequestSimplePropBase(GitHubRestModel):
    """PullRequestSimplePropBase"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    repo: Repository = Field(
        title="Repository", description="A repository on GitHub.", default=...
    )
    sha: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class PullRequestSimplePropLinks(GitHubRestModel):
    """PullRequestSimplePropLinks"""

    comments: Link = Field(title="Link", description="Hypermedia Link", default=...)
    commits: Link = Field(title="Link", description="Hypermedia Link", default=...)
    statuses: Link = Field(title="Link", description="Hypermedia Link", default=...)
    html: Link = Field(title="Link", description="Hypermedia Link", default=...)
    issue: Link = Field(title="Link", description="Hypermedia Link", default=...)
    review_comments: Link = Field(
        title="Link", description="Hypermedia Link", default=...
    )
    review_comment: Link = Field(
        title="Link", description="Hypermedia Link", default=...
    )
    self_: Link = Field(
        title="Link", description="Hypermedia Link", default=..., alias="self"
    )


class SimpleCommitStatus(GitHubRestModel):
    """Simple Commit Status"""

    description: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    state: str = Field(default=...)
    context: str = Field(default=...)
    target_url: Union[str, None] = Field(default=...)
    required: Missing[Union[bool, None]] = Field(default=UNSET)
    avatar_url: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class CombinedCommitStatus(GitHubRestModel):
    """Combined Commit Status

    Combined Commit Status
    """

    state: str = Field(default=...)
    statuses: List[SimpleCommitStatus] = Field(default=...)
    sha: str = Field(default=...)
    total_count: int = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    commit_url: str = Field(default=...)
    url: str = Field(default=...)


class Status(GitHubRestModel):
    """Status

    The status of a commit.
    """

    url: str = Field(default=...)
    avatar_url: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    state: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    target_url: Union[str, None] = Field(default=...)
    context: str = Field(default=...)
    created_at: str = Field(default=...)
    updated_at: str = Field(default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class CommunityHealthFile(GitHubRestModel):
    """Community Health File"""

    url: str = Field(default=...)
    html_url: str = Field(default=...)


class CommunityProfile(GitHubRestModel):
    """Community Profile

    Community Profile
    """

    health_percentage: int = Field(default=...)
    description: Union[str, None] = Field(default=...)
    documentation: Union[str, None] = Field(default=...)
    files: CommunityProfilePropFiles = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    content_reports_enabled: Missing[bool] = Field(default=UNSET)


class CommunityProfilePropFiles(GitHubRestModel):
    """CommunityProfilePropFiles"""

    code_of_conduct: Union[None, CodeOfConductSimple] = Field(
        title="Code Of Conduct Simple",
        description="Code of Conduct Simple",
        default=...,
    )
    code_of_conduct_file: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    contributing: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )
    readme: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )
    issue_template: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )
    pull_request_template: Union[None, CommunityHealthFile] = Field(
        title="Community Health File", default=...
    )


class CommitComparison(GitHubRestModel):
    """Commit Comparison

    Commit Comparison
    """

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    permalink_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    base_commit: Commit = Field(title="Commit", description="Commit", default=...)
    merge_base_commit: Commit = Field(title="Commit", description="Commit", default=...)
    status: Literal["diverged", "ahead", "behind", "identical"] = Field(default=...)
    ahead_by: int = Field(default=...)
    behind_by: int = Field(default=...)
    total_commits: int = Field(default=...)
    commits: List[Commit] = Field(default=...)
    files: Missing[List[DiffEntry]] = Field(default=UNSET)


class ContentTree(GitHubRestModel):
    """Content Tree

    Content Tree
    """

    type: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    entries: Missing[List[ContentTreePropEntriesItems]] = Field(default=UNSET)
    links: ContentTreePropLinks = Field(default=..., alias="_links")


class ContentTreePropEntriesItems(GitHubRestModel):
    """ContentTreePropEntriesItems"""

    type: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    content: Missing[str] = Field(default=UNSET)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentTreePropEntriesItemsPropLinks = Field(default=..., alias="_links")


class ContentTreePropEntriesItemsPropLinks(GitHubRestModel):
    """ContentTreePropEntriesItemsPropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentTreePropLinks(GitHubRestModel):
    """ContentTreePropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentDirectoryItems(GitHubRestModel):
    """ContentDirectoryItems"""

    type: Literal["dir", "file", "submodule", "symlink"] = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    content: Missing[str] = Field(default=UNSET)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentDirectoryItemsPropLinks = Field(default=..., alias="_links")


class ContentDirectoryItemsPropLinks(GitHubRestModel):
    """ContentDirectoryItemsPropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentFile(GitHubRestModel):
    """Content File

    Content File
    """

    type: Literal["file"] = Field(default=...)
    encoding: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    content: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentFilePropLinks = Field(default=..., alias="_links")
    target: Missing[str] = Field(default=UNSET)
    submodule_git_url: Missing[str] = Field(default=UNSET)


class ContentFilePropLinks(GitHubRestModel):
    """ContentFilePropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentSymlink(GitHubRestModel):
    """Symlink Content

    An object describing a symlink
    """

    type: Literal["symlink"] = Field(default=...)
    target: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentSymlinkPropLinks = Field(default=..., alias="_links")


class ContentSymlinkPropLinks(GitHubRestModel):
    """ContentSymlinkPropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class ContentSubmodule(GitHubRestModel):
    """Submodule Content

    An object describing a submodule
    """

    type: Literal["submodule"] = Field(default=...)
    submodule_git_url: str = Field(default=...)
    size: int = Field(default=...)
    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    links: ContentSubmodulePropLinks = Field(default=..., alias="_links")


class ContentSubmodulePropLinks(GitHubRestModel):
    """ContentSubmodulePropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class FileCommit(GitHubRestModel):
    """File Commit

    File Commit
    """

    content: Union[FileCommitPropContent, None] = Field(default=...)
    commit: FileCommitPropCommit = Field(default=...)


class FileCommitPropContentPropLinks(GitHubRestModel):
    """FileCommitPropContentPropLinks"""

    self_: Missing[str] = Field(default=UNSET, alias="self")
    git: Missing[str] = Field(default=UNSET)
    html: Missing[str] = Field(default=UNSET)


class FileCommitPropContent(GitHubRestModel):
    """FileCommitPropContent"""

    name: Missing[str] = Field(default=UNSET)
    path: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)
    size: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    git_url: Missing[str] = Field(default=UNSET)
    download_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    links: Missing[FileCommitPropContentPropLinks] = Field(
        default=UNSET, alias="_links"
    )


class FileCommitPropCommit(GitHubRestModel):
    """FileCommitPropCommit"""

    sha: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    author: Missing[FileCommitPropCommitPropAuthor] = Field(default=UNSET)
    committer: Missing[FileCommitPropCommitPropCommitter] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    tree: Missing[FileCommitPropCommitPropTree] = Field(default=UNSET)
    parents: Missing[List[FileCommitPropCommitPropParentsItems]] = Field(default=UNSET)
    verification: Missing[FileCommitPropCommitPropVerification] = Field(default=UNSET)


class FileCommitPropCommitPropAuthor(GitHubRestModel):
    """FileCommitPropCommitPropAuthor"""

    date: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    email: Missing[str] = Field(default=UNSET)


class FileCommitPropCommitPropCommitter(GitHubRestModel):
    """FileCommitPropCommitPropCommitter"""

    date: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    email: Missing[str] = Field(default=UNSET)


class FileCommitPropCommitPropTree(GitHubRestModel):
    """FileCommitPropCommitPropTree"""

    url: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)


class FileCommitPropCommitPropParentsItems(GitHubRestModel):
    """FileCommitPropCommitPropParentsItems"""

    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)


class FileCommitPropCommitPropVerification(GitHubRestModel):
    """FileCommitPropCommitPropVerification"""

    verified: Missing[bool] = Field(default=UNSET)
    reason: Missing[str] = Field(default=UNSET)
    signature: Missing[Union[str, None]] = Field(default=UNSET)
    payload: Missing[Union[str, None]] = Field(default=UNSET)


class Contributor(GitHubRestModel):
    """Contributor

    Contributor
    """

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[Union[str, None]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: str = Field(default=...)
    site_admin: Missing[bool] = Field(default=UNSET)
    contributions: int = Field(default=...)
    email: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)


class DependabotAlert(GitHubRestModel):
    """DependabotAlert

    A Dependabot alert.
    """

    number: int = Field(description="The security alert number.", default=...)
    state: Literal["auto_dismissed", "dismissed", "fixed", "open"] = Field(
        description="The state of the Dependabot alert.", default=...
    )
    dependency: DependabotAlertPropDependency = Field(
        description="Details for the vulnerable dependency.", default=...
    )
    security_advisory: DependabotAlertSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory.", default=...
    )
    security_vulnerability: DependabotAlertSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory.",
        default=...,
    )
    url: str = Field(description="The REST API URL of the alert resource.", default=...)
    html_url: str = Field(
        description="The GitHub URL of the alert resource.", default=...
    )
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    dismissed_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ] = Field(description="The reason that the alert was dismissed.", default=...)
    dismissed_comment: Union[str, None] = Field(
        description="An optional comment associated with the alert's dismissal.",
        default=...,
    )
    fixed_at: Union[datetime, None] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=...,
    )
    auto_dismissed_at: Missing[Union[datetime, None]] = Field(
        description="The time that the alert was auto-dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )


class DependabotAlertPropDependency(GitHubRestModel):
    """DependabotAlertPropDependency

    Details for the vulnerable dependency.
    """

    package: Missing[DependabotAlertPackage] = Field(
        description="Details for the vulnerable package.", default=UNSET
    )
    manifest_path: Missing[str] = Field(
        description="The full path to the dependency manifest file, relative to the root of the repository.",
        default=UNSET,
    )
    scope: Missing[Union[None, Literal["development", "runtime"]]] = Field(
        description="The execution scope of the vulnerable dependency.", default=UNSET
    )


class DependabotSecret(GitHubRestModel):
    """Dependabot Secret

    Set secrets for Dependabot.
    """

    name: str = Field(description="The name of the secret.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class DependencyGraphDiffItems(GitHubRestModel):
    """DependencyGraphDiffItems"""

    change_type: Literal["added", "removed"] = Field(default=...)
    manifest: str = Field(default=...)
    ecosystem: str = Field(default=...)
    name: str = Field(default=...)
    version: str = Field(default=...)
    package_url: Union[str, None] = Field(default=...)
    license_: Union[str, None] = Field(default=..., alias="license")
    source_repository_url: Union[str, None] = Field(default=...)
    vulnerabilities: List[DependencyGraphDiffItemsPropVulnerabilitiesItems] = Field(
        default=...
    )
    scope: Literal["unknown", "runtime", "development"] = Field(
        description="Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.",
        default=...,
    )


class DependencyGraphDiffItemsPropVulnerabilitiesItems(GitHubRestModel):
    """DependencyGraphDiffItemsPropVulnerabilitiesItems"""

    severity: str = Field(default=...)
    advisory_ghsa_id: str = Field(default=...)
    advisory_summary: str = Field(default=...)
    advisory_url: str = Field(default=...)


class DependencyGraphSpdxSbom(GitHubRestModel):
    """Dependency Graph SPDX SBOM

    A schema for the SPDX JSON format returned by the Dependency Graph.
    """

    sbom: DependencyGraphSpdxSbomPropSbom = Field(default=...)


class DependencyGraphSpdxSbomPropSbom(GitHubRestModel):
    """DependencyGraphSpdxSbomPropSbom"""

    spdxid: str = Field(
        description="The SPDX identifier for the SPDX document.",
        default=...,
        alias="SPDXID",
    )
    spdx_version: str = Field(
        description="The version of the SPDX specification that this document conforms to.",
        default=...,
        alias="spdxVersion",
    )
    creation_info: DependencyGraphSpdxSbomPropSbomPropCreationInfo = Field(
        default=..., alias="creationInfo"
    )
    name: str = Field(description="The name of the SPDX document.", default=...)
    data_license: str = Field(
        description="The license under which the SPDX document is licensed.",
        default=...,
        alias="dataLicense",
    )
    document_describes: List[str] = Field(
        description="The name of the repository that the SPDX document describes.",
        default=...,
        alias="documentDescribes",
    )
    document_namespace: str = Field(
        description="The namespace for the SPDX document.",
        default=...,
        alias="documentNamespace",
    )
    packages: List[DependencyGraphSpdxSbomPropSbomPropPackagesItems] = Field(
        default=...
    )


class DependencyGraphSpdxSbomPropSbomPropCreationInfo(GitHubRestModel):
    """DependencyGraphSpdxSbomPropSbomPropCreationInfo"""

    created: str = Field(
        description="The date and time the SPDX document was created.", default=...
    )
    creators: List[str] = Field(
        description="The tools that were used to generate the SPDX document.",
        default=...,
    )


class DependencyGraphSpdxSbomPropSbomPropPackagesItems(GitHubRestModel):
    """DependencyGraphSpdxSbomPropSbomPropPackagesItems"""

    spdxid: Missing[str] = Field(
        description="A unique SPDX identifier for the package.",
        default=UNSET,
        alias="SPDXID",
    )
    name: Missing[str] = Field(description="The name of the package.", default=UNSET)
    version_info: Missing[str] = Field(
        description="The version of the package. If the package does not have an exact version specified,\na version range is given.",
        default=UNSET,
        alias="versionInfo",
    )
    download_location: Missing[str] = Field(
        description="The location where the package can be downloaded,\nor NOASSERTION if this has not been determined.",
        default=UNSET,
        alias="downloadLocation",
    )
    files_analyzed: Missing[bool] = Field(
        description="Whether the package's file content has been subjected to\nanalysis during the creation of the SPDX document.",
        default=UNSET,
        alias="filesAnalyzed",
    )
    license_concluded: Missing[str] = Field(
        description="The license of the package as determined while creating the SPDX document.",
        default=UNSET,
        alias="licenseConcluded",
    )
    license_declared: Missing[str] = Field(
        description="The license of the package as declared by its author, or NOASSERTION if this information\nwas not available when the SPDX document was created.",
        default=UNSET,
        alias="licenseDeclared",
    )
    supplier: Missing[str] = Field(
        description="The distribution source of this package, or NOASSERTION if this was not determined.",
        default=UNSET,
    )
    external_refs: Missing[
        List[DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItems]
    ] = Field(default=UNSET, alias="externalRefs")


class DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItems(
    GitHubRestModel
):
    """DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItems"""

    reference_category: str = Field(
        description="The category of reference to an external resource this reference refers to.",
        default=...,
        alias="referenceCategory",
    )
    reference_locator: str = Field(
        description="A locator for the particular external resource this reference refers to.",
        default=...,
        alias="referenceLocator",
    )
    reference_type: str = Field(
        description="The category of reference to an external resource this reference refers to.",
        default=...,
        alias="referenceType",
    )


class Metadata(GitHubRestModel, extra=Extra.allow):
    """metadata

    User-defined metadata to store domain-specific information limited to 8 keys
    with scalar values.
    """


class Dependency(GitHubRestModel):
    """Dependency"""

    package_url: Missing[Annotated[str, Field(pattern="^pkg")]] = Field(
        description="Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.",
        default=UNSET,
    )
    metadata: Missing[Metadata] = Field(
        title="metadata",
        description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.",
        default=UNSET,
    )
    relationship: Missing[Literal["direct", "indirect"]] = Field(
        description="A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.",
        default=UNSET,
    )
    scope: Missing[Literal["runtime", "development"]] = Field(
        description="A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.",
        default=UNSET,
    )
    dependencies: Missing[List[str]] = Field(
        description="Array of package-url (PURLs) of direct child dependencies.",
        default=UNSET,
    )


class Manifest(GitHubRestModel):
    """Manifest"""

    name: str = Field(description="The name of the manifest.", default=...)
    file: Missing[ManifestPropFile] = Field(default=UNSET)
    metadata: Missing[Metadata] = Field(
        title="metadata",
        description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.",
        default=UNSET,
    )
    resolved: Missing[ManifestPropResolved] = Field(
        description="A collection of resolved package dependencies.", default=UNSET
    )


class ManifestPropFile(GitHubRestModel):
    """ManifestPropFile"""

    source_location: Missing[str] = Field(
        description="The path of the manifest file relative to the root of the Git repository.",
        default=UNSET,
    )


class ManifestPropResolved(GitHubRestModel, extra=Extra.allow):
    """ManifestPropResolved

    A collection of resolved package dependencies.
    """


class Snapshot(GitHubRestModel):
    """snapshot

    Create a new snapshot of a repository's dependencies.
    """

    version: int = Field(
        description="The version of the repository snapshot submission.", default=...
    )
    job: SnapshotPropJob = Field(default=...)
    sha: str = Field(
        description="The commit SHA associated with this dependency snapshot. Maximum length: 40 characters.",
        min_length=40,
        max_length=40,
        default=...,
    )
    ref: str = Field(
        description="The repository branch that triggered this snapshot.",
        pattern="^refs/",
        default=...,
    )
    detector: SnapshotPropDetector = Field(
        description="A description of the detector used.", default=...
    )
    metadata: Missing[Metadata] = Field(
        title="metadata",
        description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.",
        default=UNSET,
    )
    manifests: Missing[SnapshotPropManifests] = Field(
        description="A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.",
        default=UNSET,
    )
    scanned: datetime = Field(
        description="The time at which the snapshot was scanned.", default=...
    )


class SnapshotPropJob(GitHubRestModel):
    """SnapshotPropJob"""

    id: str = Field(description="The external ID of the job.", default=...)
    correlator: str = Field(
        description="Correlator provides a key that is used to group snapshots submitted over time. Only the \"latest\" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given \"wave\" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation.",
        default=...,
    )
    html_url: Missing[str] = Field(description="The url for the job.", default=UNSET)


class SnapshotPropDetector(GitHubRestModel):
    """SnapshotPropDetector

    A description of the detector used.
    """

    name: str = Field(description="The name of the detector used.", default=...)
    version: str = Field(description="The version of the detector used.", default=...)
    url: str = Field(description="The url of the detector used.", default=...)


class SnapshotPropManifests(GitHubRestModel, extra=Extra.allow):
    """SnapshotPropManifests

    A collection of package manifests, which are a collection of related
    dependencies declared in a file or representing a logical group of dependencies.
    """


class DeploymentStatus(GitHubRestModel):
    """Deployment Status

    The status of a deployment.
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    state: Literal[
        "error", "failure", "inactive", "pending", "success", "queued", "in_progress"
    ] = Field(description="The state of the status.", default=...)
    creator: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    description: str = Field(
        description="A short description of the status.", default="", max_length=140
    )
    environment: Missing[str] = Field(
        description="The environment of the deployment that the status is for.",
        default="",
    )
    target_url: str = Field(
        description="Deprecated: the URL to associate with this status.", default=""
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    deployment_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    environment_url: Missing[str] = Field(
        description="The URL for accessing your environment.", default=""
    )
    log_url: Missing[str] = Field(
        description="The URL to associate with this status.", default=""
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class DeploymentBranchPolicySettings(GitHubRestModel):
    """DeploymentBranchPolicySettings

    The type of deployment branch policy for this environment. To allow all branches
    to deploy, set to `null`.
    """

    protected_branches: bool = Field(
        description="Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`.",
        default=...,
    )
    custom_branch_policies: bool = Field(
        description="Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`.",
        default=...,
    )


class Environment(GitHubRestModel):
    """Environment

    Details of a deployment environment
    """

    id: int = Field(description="The id of the environment.", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the environment.", default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(
        description="The time that the environment was created, in ISO 8601 format.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The time that the environment was last updated, in ISO 8601 format.",
        default=...,
    )
    protection_rules: Missing[
        List[
            Union[
                EnvironmentPropProtectionRulesItemsAnyof0,
                EnvironmentPropProtectionRulesItemsAnyof1,
                EnvironmentPropProtectionRulesItemsAnyof2,
            ]
        ]
    ] = Field(
        description="Built-in deployment protection rules for the environment.",
        default=UNSET,
    )
    deployment_branch_policy: Missing[
        Union[DeploymentBranchPolicySettings, None]
    ] = Field(
        description="The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`.",
        default=UNSET,
    )


class EnvironmentPropProtectionRulesItemsAnyof0(GitHubRestModel):
    """EnvironmentPropProtectionRulesItemsAnyof0"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    type: str = Field(default=...)
    wait_timer: Missing[int] = Field(
        description="The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).",
        default=UNSET,
    )


class EnvironmentPropProtectionRulesItemsAnyof1(GitHubRestModel):
    """EnvironmentPropProtectionRulesItemsAnyof1"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    type: str = Field(default=...)
    reviewers: Missing[
        List[EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems]
    ] = Field(
        description="The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.",
        default=UNSET,
    )


class EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems(GitHubRestModel):
    """EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems"""

    type: Missing[Literal["User", "Team"]] = Field(
        description="The type of reviewer.", default=UNSET
    )
    reviewer: Missing[Union[SimpleUser, Team]] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )


class EnvironmentPropProtectionRulesItemsAnyof2(GitHubRestModel):
    """EnvironmentPropProtectionRulesItemsAnyof2"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    type: str = Field(default=...)


class DeploymentBranchPolicy(GitHubRestModel):
    """Deployment branch policy

    Details of a deployment branch policy.
    """

    id: Missing[int] = Field(
        description="The unique identifier of the branch policy.", default=UNSET
    )
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(
        description="The name pattern that branches must match in order to deploy to the environment.",
        default=UNSET,
    )


class DeploymentBranchPolicyNamePattern(GitHubRestModel):
    """Deployment branch policy name pattern"""

    name: str = Field(
        description="The name pattern that branches must match in order to deploy to the environment.\n\nWildcard characters will not match `/`. For example, to match branches that begin with `release/` and contain an additional single slash, use `release/*/*`.\nFor more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch).",
        default=...,
    )


class CustomDeploymentRuleApp(GitHubRestModel):
    """Custom deployment protection rule app

    A GitHub App that is providing a custom deployment protection rule.
    """

    id: int = Field(
        description="The unique identifier of the deployment protection rule integration.",
        default=...,
    )
    slug: str = Field(
        description="The slugified name of the deployment protection rule integration.",
        default=...,
    )
    integration_url: str = Field(
        description="The URL for the endpoint to get details about the app.",
        default=...,
    )
    node_id: str = Field(
        description="The node ID for the deployment protection rule integration.",
        default=...,
    )


class DeploymentProtectionRule(GitHubRestModel):
    """Deployment protection rule

    Deployment protection rule
    """

    id: int = Field(
        description="The unique identifier for the deployment protection rule.",
        default=...,
    )
    node_id: str = Field(
        description="The node ID for the deployment protection rule.", default=...
    )
    enabled: bool = Field(
        description="Whether the deployment protection rule is enabled for the environment.",
        default=...,
    )
    app: CustomDeploymentRuleApp = Field(
        title="Custom deployment protection rule app",
        description="A GitHub App that is providing a custom deployment protection rule.",
        default=...,
    )


class ShortBlob(GitHubRestModel):
    """Short Blob

    Short Blob
    """

    url: str = Field(default=...)
    sha: str = Field(default=...)


class Blob(GitHubRestModel):
    """Blob

    Blob
    """

    content: str = Field(default=...)
    encoding: str = Field(default=...)
    url: str = Field(default=...)
    sha: str = Field(default=...)
    size: Union[int, None] = Field(default=...)
    node_id: str = Field(default=...)
    highlighted_content: Missing[str] = Field(default=UNSET)


class GitCommit(GitHubRestModel):
    """Git Commit

    Low-level Git commit operations within a repository
    """

    sha: str = Field(description="SHA for the commit", default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    author: GitCommitPropAuthor = Field(
        description="Identifying information for the git-user", default=...
    )
    committer: GitCommitPropCommitter = Field(
        description="Identifying information for the git-user", default=...
    )
    message: str = Field(
        description="Message describing the purpose of the commit", default=...
    )
    tree: GitCommitPropTree = Field(default=...)
    parents: List[GitCommitPropParentsItems] = Field(default=...)
    verification: GitCommitPropVerification = Field(default=...)
    html_url: str = Field(default=...)


class GitCommitPropAuthor(GitHubRestModel):
    """GitCommitPropAuthor

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit", default=...)
    email: str = Field(description="Git email address of the user", default=...)
    name: str = Field(description="Name of the git user", default=...)


class GitCommitPropCommitter(GitHubRestModel):
    """GitCommitPropCommitter

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit", default=...)
    email: str = Field(description="Git email address of the user", default=...)
    name: str = Field(description="Name of the git user", default=...)


class GitCommitPropTree(GitHubRestModel):
    """GitCommitPropTree"""

    sha: str = Field(description="SHA for the commit", default=...)
    url: str = Field(default=...)


class GitCommitPropParentsItems(GitHubRestModel):
    """GitCommitPropParentsItems"""

    sha: str = Field(description="SHA for the commit", default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)


class GitCommitPropVerification(GitHubRestModel):
    """GitCommitPropVerification"""

    verified: bool = Field(default=...)
    reason: str = Field(default=...)
    signature: Union[str, None] = Field(default=...)
    payload: Union[str, None] = Field(default=...)


class GitRef(GitHubRestModel):
    """Git Reference

    Git references within a repository
    """

    ref: str = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    object_: GitRefPropObject = Field(default=..., alias="object")


class GitRefPropObject(GitHubRestModel):
    """GitRefPropObject"""

    type: str = Field(default=...)
    sha: str = Field(
        description="SHA for the reference", min_length=40, max_length=40, default=...
    )
    url: str = Field(default=...)


class GitTag(GitHubRestModel):
    """Git Tag

    Metadata for a Git tag
    """

    node_id: str = Field(default=...)
    tag: str = Field(description="Name of the tag", default=...)
    sha: str = Field(default=...)
    url: str = Field(description="URL for the tag", default=...)
    message: str = Field(
        description="Message describing the purpose of the tag", default=...
    )
    tagger: GitTagPropTagger = Field(default=...)
    object_: GitTagPropObject = Field(default=..., alias="object")
    verification: Missing[Verification] = Field(title="Verification", default=UNSET)


class GitTagPropTagger(GitHubRestModel):
    """GitTagPropTagger"""

    date: str = Field(default=...)
    email: str = Field(default=...)
    name: str = Field(default=...)


class GitTagPropObject(GitHubRestModel):
    """GitTagPropObject"""

    sha: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class GitTree(GitHubRestModel):
    """Git Tree

    The hierarchy between files in a Git repository.
    """

    sha: str = Field(default=...)
    url: str = Field(default=...)
    truncated: bool = Field(default=...)
    tree: List[GitTreePropTreeItems] = Field(
        description="Objects specifying a tree structure", default=...
    )


class GitTreePropTreeItems(GitHubRestModel):
    """GitTreePropTreeItems"""

    path: Missing[str] = Field(default=UNSET)
    mode: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)
    size: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class HookResponse(GitHubRestModel):
    """Hook Response"""

    code: Union[int, None] = Field(default=...)
    status: Union[str, None] = Field(default=...)
    message: Union[str, None] = Field(default=...)


class Hook(GitHubRestModel):
    """Webhook

    Webhooks for repositories.
    """

    type: str = Field(default=...)
    id: int = Field(description="Unique identifier of the webhook.", default=...)
    name: str = Field(
        description="The name of a valid service, use 'web' for a webhook.", default=...
    )
    active: bool = Field(
        description="Determines whether the hook is actually triggered on pushes.",
        default=...,
    )
    events: List[str] = Field(
        description="Determines what events the hook is triggered for. Default: ['push'].",
        default=...,
    )
    config: HookPropConfig = Field(default=...)
    updated_at: datetime = Field(default=...)
    created_at: datetime = Field(default=...)
    url: str = Field(default=...)
    test_url: str = Field(default=...)
    ping_url: str = Field(default=...)
    deliveries_url: Missing[str] = Field(default=UNSET)
    last_response: HookResponse = Field(title="Hook Response", default=...)


class HookPropConfig(GitHubRestModel):
    """HookPropConfig"""

    email: Missing[str] = Field(default=UNSET)
    password: Missing[str] = Field(default=UNSET)
    room: Missing[str] = Field(default=UNSET)
    subdomain: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(
        description="The URL to which the payloads will be delivered.", default=UNSET
    )
    insecure_ssl: Missing[Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )
    content_type: Missing[str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    digest: Missing[str] = Field(default=UNSET)
    secret: Missing[str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    token: Missing[str] = Field(default=UNSET)


class Import(GitHubRestModel):
    """Import

    A repository import from an external source.
    """

    vcs: Union[str, None] = Field(default=...)
    use_lfs: Missing[bool] = Field(default=UNSET)
    vcs_url: str = Field(
        description="The URL of the originating repository.", default=...
    )
    svc_root: Missing[str] = Field(default=UNSET)
    tfvc_project: Missing[str] = Field(default=UNSET)
    status: Literal[
        "auth",
        "error",
        "none",
        "detecting",
        "choose",
        "auth_failed",
        "importing",
        "mapping",
        "waiting_to_push",
        "pushing",
        "complete",
        "setup",
        "unknown",
        "detection_found_multiple",
        "detection_found_nothing",
        "detection_needs_auth",
    ] = Field(default=...)
    status_text: Missing[Union[str, None]] = Field(default=UNSET)
    failed_step: Missing[Union[str, None]] = Field(default=UNSET)
    error_message: Missing[Union[str, None]] = Field(default=UNSET)
    import_percent: Missing[Union[int, None]] = Field(default=UNSET)
    commit_count: Missing[Union[int, None]] = Field(default=UNSET)
    push_percent: Missing[Union[int, None]] = Field(default=UNSET)
    has_large_files: Missing[bool] = Field(default=UNSET)
    large_files_size: Missing[int] = Field(default=UNSET)
    large_files_count: Missing[int] = Field(default=UNSET)
    project_choices: Missing[List[ImportPropProjectChoicesItems]] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    authors_count: Missing[Union[int, None]] = Field(default=UNSET)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    authors_url: str = Field(default=...)
    repository_url: str = Field(default=...)
    svn_root: Missing[str] = Field(default=UNSET)


class ImportPropProjectChoicesItems(GitHubRestModel):
    """ImportPropProjectChoicesItems"""

    vcs: Missing[str] = Field(default=UNSET)
    tfvc_project: Missing[str] = Field(default=UNSET)
    human_name: Missing[str] = Field(default=UNSET)


class PorterAuthor(GitHubRestModel):
    """Porter Author

    Porter Author
    """

    id: int = Field(default=...)
    remote_id: str = Field(default=...)
    remote_name: str = Field(default=...)
    email: str = Field(default=...)
    name: str = Field(default=...)
    url: str = Field(default=...)
    import_url: str = Field(default=...)


class PorterLargeFile(GitHubRestModel):
    """Porter Large File

    Porter Large File
    """

    ref_name: str = Field(default=...)
    path: str = Field(default=...)
    oid: str = Field(default=...)
    size: int = Field(default=...)


class IssueEventLabel(GitHubRestModel):
    """Issue Event Label

    Issue Event Label
    """

    name: Union[str, None] = Field(default=...)
    color: Union[str, None] = Field(default=...)


class IssueEventDismissedReview(GitHubRestModel):
    """Issue Event Dismissed Review"""

    state: str = Field(default=...)
    review_id: int = Field(default=...)
    dismissal_message: Union[str, None] = Field(default=...)
    dismissal_commit_id: Missing[Union[str, None]] = Field(default=UNSET)


class IssueEventMilestone(GitHubRestModel):
    """Issue Event Milestone

    Issue Event Milestone
    """

    title: str = Field(default=...)


class IssueEventProjectCard(GitHubRestModel):
    """Issue Event Project Card

    Issue Event Project Card
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    project_url: str = Field(default=...)
    project_id: int = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Missing[str] = Field(default=UNSET)


class IssueEventRename(GitHubRestModel):
    """Issue Event Rename

    Issue Event Rename
    """

    from_: str = Field(default=..., alias="from")
    to: str = Field(default=...)


class IssueEvent(GitHubRestModel):
    """Issue Event

    Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: str = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    issue: Missing[Union[None, Issue]] = Field(
        title="Issue",
        description="Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.",
        default=UNSET,
    )
    label: Missing[IssueEventLabel] = Field(
        title="Issue Event Label", description="Issue Event Label", default=UNSET
    )
    assignee: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    assigner: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    review_requester: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    requested_reviewer: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    requested_team: Missing[Team] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )
    dismissed_review: Missing[IssueEventDismissedReview] = Field(
        title="Issue Event Dismissed Review", default=UNSET
    )
    milestone: Missing[IssueEventMilestone] = Field(
        title="Issue Event Milestone",
        description="Issue Event Milestone",
        default=UNSET,
    )
    project_card: Missing[IssueEventProjectCard] = Field(
        title="Issue Event Project Card",
        description="Issue Event Project Card",
        default=UNSET,
    )
    rename: Missing[IssueEventRename] = Field(
        title="Issue Event Rename", description="Issue Event Rename", default=UNSET
    )
    author_association: Missing[
        Literal[
            "COLLABORATOR",
            "CONTRIBUTOR",
            "FIRST_TIMER",
            "FIRST_TIME_CONTRIBUTOR",
            "MANNEQUIN",
            "MEMBER",
            "NONE",
            "OWNER",
        ]
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=UNSET,
    )
    lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    performed_via_github_app: Missing[Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )


class LabeledIssueEvent(GitHubRestModel):
    """Labeled Issue Event

    Labeled Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["labeled"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    label: LabeledIssueEventPropLabel = Field(default=...)


class LabeledIssueEventPropLabel(GitHubRestModel):
    """LabeledIssueEventPropLabel"""

    name: str = Field(default=...)
    color: str = Field(default=...)


class UnlabeledIssueEvent(GitHubRestModel):
    """Unlabeled Issue Event

    Unlabeled Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["unlabeled"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    label: UnlabeledIssueEventPropLabel = Field(default=...)


class UnlabeledIssueEventPropLabel(GitHubRestModel):
    """UnlabeledIssueEventPropLabel"""

    name: str = Field(default=...)
    color: str = Field(default=...)


class AssignedIssueEvent(GitHubRestModel):
    """Assigned Issue Event

    Assigned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: str = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Integration = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    assignee: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    assigner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class UnassignedIssueEvent(GitHubRestModel):
    """Unassigned Issue Event

    Unassigned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: str = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    assignee: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    assigner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class MilestonedIssueEvent(GitHubRestModel):
    """Milestoned Issue Event

    Milestoned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["milestoned"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    milestone: MilestonedIssueEventPropMilestone = Field(default=...)


class MilestonedIssueEventPropMilestone(GitHubRestModel):
    """MilestonedIssueEventPropMilestone"""

    title: str = Field(default=...)


class DemilestonedIssueEvent(GitHubRestModel):
    """Demilestoned Issue Event

    Demilestoned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["demilestoned"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    milestone: DemilestonedIssueEventPropMilestone = Field(default=...)


class DemilestonedIssueEventPropMilestone(GitHubRestModel):
    """DemilestonedIssueEventPropMilestone"""

    title: str = Field(default=...)


class RenamedIssueEvent(GitHubRestModel):
    """Renamed Issue Event

    Renamed Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["renamed"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    rename: RenamedIssueEventPropRename = Field(default=...)


class RenamedIssueEventPropRename(GitHubRestModel):
    """RenamedIssueEventPropRename"""

    from_: str = Field(default=..., alias="from")
    to: str = Field(default=...)


class ReviewRequestedIssueEvent(GitHubRestModel):
    """Review Requested Issue Event

    Review Requested Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["review_requested"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    review_requester: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    requested_team: Missing[Team] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )
    requested_reviewer: Missing[SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )


class ReviewRequestRemovedIssueEvent(GitHubRestModel):
    """Review Request Removed Issue Event

    Review Request Removed Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["review_request_removed"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    review_requester: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    requested_team: Missing[Team] = Field(
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
        default=UNSET,
    )
    requested_reviewer: Missing[SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )


class ReviewDismissedIssueEvent(GitHubRestModel):
    """Review Dismissed Issue Event

    Review Dismissed Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["review_dismissed"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    dismissed_review: ReviewDismissedIssueEventPropDismissedReview = Field(default=...)


class ReviewDismissedIssueEventPropDismissedReview(GitHubRestModel):
    """ReviewDismissedIssueEventPropDismissedReview"""

    state: str = Field(default=...)
    review_id: int = Field(default=...)
    dismissal_message: Union[str, None] = Field(default=...)
    dismissal_commit_id: Missing[str] = Field(default=UNSET)


class LockedIssueEvent(GitHubRestModel):
    """Locked Issue Event

    Locked Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["locked"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    lock_reason: Union[str, None] = Field(default=...)


class AddedToProjectIssueEvent(GitHubRestModel):
    """Added to Project Issue Event

    Added to Project Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["added_to_project"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    project_card: Missing[AddedToProjectIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class AddedToProjectIssueEventPropProjectCard(GitHubRestModel):
    """AddedToProjectIssueEventPropProjectCard"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    project_id: int = Field(default=...)
    project_url: str = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Missing[str] = Field(default=UNSET)


class MovedColumnInProjectIssueEvent(GitHubRestModel):
    """Moved Column in Project Issue Event

    Moved Column in Project Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["moved_columns_in_project"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    project_card: Missing[MovedColumnInProjectIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class MovedColumnInProjectIssueEventPropProjectCard(GitHubRestModel):
    """MovedColumnInProjectIssueEventPropProjectCard"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    project_id: int = Field(default=...)
    project_url: str = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Missing[str] = Field(default=UNSET)


class RemovedFromProjectIssueEvent(GitHubRestModel):
    """Removed from Project Issue Event

    Removed from Project Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["removed_from_project"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    project_card: Missing[RemovedFromProjectIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class RemovedFromProjectIssueEventPropProjectCard(GitHubRestModel):
    """RemovedFromProjectIssueEventPropProjectCard"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    project_id: int = Field(default=...)
    project_url: str = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Missing[str] = Field(default=UNSET)


class ConvertedNoteToIssueIssueEvent(GitHubRestModel):
    """Converted Note to Issue Issue Event

    Converted Note to Issue Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["converted_note_to_issue"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Integration = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    project_card: Missing[ConvertedNoteToIssueIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class ConvertedNoteToIssueIssueEventPropProjectCard(GitHubRestModel):
    """ConvertedNoteToIssueIssueEventPropProjectCard"""

    id: int = Field(default=...)
    url: str = Field(default=...)
    project_id: int = Field(default=...)
    project_url: str = Field(default=...)
    column_name: str = Field(default=...)
    previous_column_name: Missing[str] = Field(default=UNSET)


class Label(GitHubRestModel):
    """Label

    Color-coded labels help you categorize and filter your issues (just like labels
    in Gmail).
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the label", default=...)
    name: str = Field(description="The name of the label.", default=...)
    description: Union[str, None] = Field(default=...)
    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color",
        default=...,
    )
    default: bool = Field(default=...)


class TimelineCommentEvent(GitHubRestModel):
    """Timeline Comment Event

    Timeline Comment Event
    """

    event: Literal["commented"] = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    id: int = Field(description="Unique identifier of the issue comment", default=...)
    node_id: str = Field(default=...)
    url: str = Field(description="URL for the issue comment", default=...)
    body: Missing[str] = Field(
        description="Contents of the issue comment", default=UNSET
    )
    body_text: Missing[str] = Field(default=UNSET)
    body_html: Missing[str] = Field(default=UNSET)
    html_url: str = Field(default=...)
    user: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    issue_url: str = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)


class TimelineCrossReferencedEvent(GitHubRestModel):
    """Timeline Cross Referenced Event

    Timeline Cross Referenced Event
    """

    event: Literal["cross-referenced"] = Field(default=...)
    actor: Missing[SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    source: TimelineCrossReferencedEventPropSource = Field(default=...)


class TimelineCrossReferencedEventPropSource(GitHubRestModel):
    """TimelineCrossReferencedEventPropSource"""

    type: Missing[str] = Field(default=UNSET)
    issue: Missing[Issue] = Field(
        title="Issue",
        description="Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.",
        default=UNSET,
    )


class TimelineCommittedEvent(GitHubRestModel):
    """Timeline Committed Event

    Timeline Committed Event
    """

    event: Missing[Literal["committed"]] = Field(default=UNSET)
    sha: str = Field(description="SHA for the commit", default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    author: TimelineCommittedEventPropAuthor = Field(
        description="Identifying information for the git-user", default=...
    )
    committer: TimelineCommittedEventPropCommitter = Field(
        description="Identifying information for the git-user", default=...
    )
    message: str = Field(
        description="Message describing the purpose of the commit", default=...
    )
    tree: TimelineCommittedEventPropTree = Field(default=...)
    parents: List[TimelineCommittedEventPropParentsItems] = Field(default=...)
    verification: TimelineCommittedEventPropVerification = Field(default=...)
    html_url: str = Field(default=...)


class TimelineCommittedEventPropAuthor(GitHubRestModel):
    """TimelineCommittedEventPropAuthor

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit", default=...)
    email: str = Field(description="Git email address of the user", default=...)
    name: str = Field(description="Name of the git user", default=...)


class TimelineCommittedEventPropCommitter(GitHubRestModel):
    """TimelineCommittedEventPropCommitter

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit", default=...)
    email: str = Field(description="Git email address of the user", default=...)
    name: str = Field(description="Name of the git user", default=...)


class TimelineCommittedEventPropTree(GitHubRestModel):
    """TimelineCommittedEventPropTree"""

    sha: str = Field(description="SHA for the commit", default=...)
    url: str = Field(default=...)


class TimelineCommittedEventPropParentsItems(GitHubRestModel):
    """TimelineCommittedEventPropParentsItems"""

    sha: str = Field(description="SHA for the commit", default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)


class TimelineCommittedEventPropVerification(GitHubRestModel):
    """TimelineCommittedEventPropVerification"""

    verified: bool = Field(default=...)
    reason: str = Field(default=...)
    signature: Union[str, None] = Field(default=...)
    payload: Union[str, None] = Field(default=...)


class TimelineReviewedEvent(GitHubRestModel):
    """Timeline Reviewed Event

    Timeline Reviewed Event
    """

    event: Literal["reviewed"] = Field(default=...)
    id: int = Field(description="Unique identifier of the review", default=...)
    node_id: str = Field(default=...)
    user: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    body: Union[str, None] = Field(description="The text of the review.", default=...)
    state: str = Field(default=...)
    html_url: str = Field(default=...)
    pull_request_url: str = Field(default=...)
    links: TimelineReviewedEventPropLinks = Field(default=..., alias="_links")
    submitted_at: Missing[datetime] = Field(default=UNSET)
    commit_id: str = Field(description="A commit SHA for the review.", default=...)
    body_html: Missing[Union[str, None]] = Field(default=UNSET)
    body_text: Missing[Union[str, None]] = Field(default=UNSET)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )


class TimelineReviewedEventPropLinks(GitHubRestModel):
    """TimelineReviewedEventPropLinks"""

    html: TimelineReviewedEventPropLinksPropHtml = Field(default=...)
    pull_request: TimelineReviewedEventPropLinksPropPullRequest = Field(default=...)


class TimelineReviewedEventPropLinksPropHtml(GitHubRestModel):
    """TimelineReviewedEventPropLinksPropHtml"""

    href: str = Field(default=...)


class TimelineReviewedEventPropLinksPropPullRequest(GitHubRestModel):
    """TimelineReviewedEventPropLinksPropPullRequest"""

    href: str = Field(default=...)


class PullRequestReviewComment(GitHubRestModel):
    """Pull Request Review Comment

    Pull Request Review Comments are comments on a portion of the Pull Request's
    diff.
    """

    url: str = Field(description="URL for the pull request review comment", default=...)
    pull_request_review_id: Union[int, None] = Field(
        description="The ID of the pull request review to which the comment belongs.",
        default=...,
    )
    id: int = Field(
        description="The ID of the pull request review comment.", default=...
    )
    node_id: str = Field(
        description="The node ID of the pull request review comment.", default=...
    )
    diff_hunk: str = Field(
        description="The diff of the line that the comment refers to.", default=...
    )
    path: str = Field(
        description="The relative path of the file to which the comment applies.",
        default=...,
    )
    position: Missing[int] = Field(
        description="The line index in the diff to which the comment applies. This field is deprecated; use `line` instead.",
        default=UNSET,
    )
    original_position: Missing[int] = Field(
        description="The index of the original line in the diff to which the comment applies. This field is deprecated; use `original_line` instead.",
        default=UNSET,
    )
    commit_id: str = Field(
        description="The SHA of the commit to which the comment applies.", default=...
    )
    original_commit_id: str = Field(
        description="The SHA of the original commit to which the comment applies.",
        default=...,
    )
    in_reply_to_id: Missing[int] = Field(
        description="The comment ID to reply to.", default=UNSET
    )
    user: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    body: str = Field(description="The text of the comment.", default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    html_url: str = Field(
        description="HTML URL for the pull request review comment.", default=...
    )
    pull_request_url: str = Field(
        description="URL for the pull request that the review comment belongs to.",
        default=...,
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    links: PullRequestReviewCommentPropLinks = Field(default=..., alias="_links")
    start_line: Missing[Union[int, None]] = Field(
        description="The first line of the range for a multi-line comment.",
        default=UNSET,
    )
    original_start_line: Missing[Union[int, None]] = Field(
        description="The first line of the range for a multi-line comment.",
        default=UNSET,
    )
    start_side: Missing[Union[None, Literal["LEFT", "RIGHT"]]] = Field(
        description="The side of the first line of the range for a multi-line comment.",
        default="RIGHT",
    )
    line: Missing[int] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=UNSET,
    )
    original_line: Missing[int] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=UNSET,
    )
    side: Missing[Literal["LEFT", "RIGHT"]] = Field(
        description="The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment",
        default="RIGHT",
    )
    subject_type: Missing[Literal["line", "file"]] = Field(
        description="The level at which the comment is targeted, can be a diff line or a file.",
        default=UNSET,
    )
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)
    body_html: Missing[str] = Field(default=UNSET)
    body_text: Missing[str] = Field(default=UNSET)


class PullRequestReviewCommentPropLinks(GitHubRestModel):
    """PullRequestReviewCommentPropLinks"""

    self_: PullRequestReviewCommentPropLinksPropSelf = Field(default=..., alias="self")
    html: PullRequestReviewCommentPropLinksPropHtml = Field(default=...)
    pull_request: PullRequestReviewCommentPropLinksPropPullRequest = Field(default=...)


class PullRequestReviewCommentPropLinksPropSelf(GitHubRestModel):
    """PullRequestReviewCommentPropLinksPropSelf"""

    href: str = Field(default=...)


class PullRequestReviewCommentPropLinksPropHtml(GitHubRestModel):
    """PullRequestReviewCommentPropLinksPropHtml"""

    href: str = Field(default=...)


class PullRequestReviewCommentPropLinksPropPullRequest(GitHubRestModel):
    """PullRequestReviewCommentPropLinksPropPullRequest"""

    href: str = Field(default=...)


class TimelineLineCommentedEvent(GitHubRestModel):
    """Timeline Line Commented Event

    Timeline Line Commented Event
    """

    event: Missing[Literal["line_commented"]] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    comments: Missing[List[PullRequestReviewComment]] = Field(default=UNSET)


class TimelineCommitCommentedEvent(GitHubRestModel):
    """Timeline Commit Commented Event

    Timeline Commit Commented Event
    """

    event: Missing[Literal["commit_commented"]] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    commit_id: Missing[str] = Field(default=UNSET)
    comments: Missing[List[CommitComment]] = Field(default=UNSET)


class TimelineAssignedIssueEvent(GitHubRestModel):
    """Timeline Assigned Issue Event

    Timeline Assigned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["assigned"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    assignee: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class TimelineUnassignedIssueEvent(GitHubRestModel):
    """Timeline Unassigned Issue Event

    Timeline Unassigned Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: Literal["unassigned"] = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    assignee: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class StateChangeIssueEvent(GitHubRestModel):
    """State Change Issue Event

    State Change Issue Event
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    actor: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    event: str = Field(default=...)
    commit_id: Union[str, None] = Field(default=...)
    commit_url: Union[str, None] = Field(default=...)
    created_at: str = Field(default=...)
    performed_via_github_app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)


class DeployKey(GitHubRestModel):
    """Deploy Key

    An SSH key granting access to a single repository.
    """

    id: int = Field(default=...)
    key: str = Field(default=...)
    url: str = Field(default=...)
    title: str = Field(default=...)
    verified: bool = Field(default=...)
    created_at: str = Field(default=...)
    read_only: bool = Field(default=...)
    added_by: Missing[Union[str, None]] = Field(default=UNSET)
    last_used: Missing[Union[str, None]] = Field(default=UNSET)


class Language(GitHubRestModel, extra=Extra.allow):
    """Language

    Language
    """


class LicenseContent(GitHubRestModel):
    """License Content

    License Content
    """

    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    size: int = Field(default=...)
    url: str = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    git_url: Union[str, None] = Field(default=...)
    download_url: Union[str, None] = Field(default=...)
    type: str = Field(default=...)
    content: str = Field(default=...)
    encoding: str = Field(default=...)
    links: LicenseContentPropLinks = Field(default=..., alias="_links")
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )


class LicenseContentPropLinks(GitHubRestModel):
    """LicenseContentPropLinks"""

    git: Union[str, None] = Field(default=...)
    html: Union[str, None] = Field(default=...)
    self_: str = Field(default=..., alias="self")


class MergedUpstream(GitHubRestModel):
    """Merged upstream

    Results of a successful merge upstream request
    """

    message: Missing[str] = Field(default=UNSET)
    merge_type: Missing[Literal["merge", "fast-forward", "none"]] = Field(default=UNSET)
    base_branch: Missing[str] = Field(default=UNSET)


class PagesSourceHash(GitHubRestModel):
    """Pages Source Hash"""

    branch: str = Field(default=...)
    path: str = Field(default=...)


class PagesHttpsCertificate(GitHubRestModel):
    """Pages Https Certificate"""

    state: Literal[
        "new",
        "authorization_created",
        "authorization_pending",
        "authorized",
        "authorization_revoked",
        "issued",
        "uploaded",
        "approved",
        "errored",
        "bad_authz",
        "destroy_pending",
        "dns_changed",
    ] = Field(default=...)
    description: str = Field(default=...)
    domains: List[str] = Field(
        description="Array of the domain set and its alternate name (if it is configured)",
        default=...,
    )
    expires_at: Missing[date] = Field(default=UNSET)


class Page(GitHubRestModel):
    """GitHub Pages

    The configuration for GitHub Pages for a repository.
    """

    url: str = Field(
        description="The API address for accessing this Page resource.", default=...
    )
    status: Union[None, Literal["built", "building", "errored"]] = Field(
        description="The status of the most recent build of the Page.", default=...
    )
    cname: Union[str, None] = Field(
        description="The Pages site's custom domain", default=...
    )
    protected_domain_state: Missing[
        Union[None, Literal["pending", "verified", "unverified"]]
    ] = Field(description="The state if the domain is verified", default=UNSET)
    pending_domain_unverified_at: Missing[Union[datetime, None]] = Field(
        description="The timestamp when a pending domain becomes unverified.",
        default=UNSET,
    )
    custom_404: bool = Field(
        description="Whether the Page has a custom 404 page.", default=False
    )
    html_url: Missing[str] = Field(
        description="The web address the Page can be accessed from.", default=UNSET
    )
    build_type: Missing[Union[None, Literal["legacy", "workflow"]]] = Field(
        description="The process in which the Page will be built.", default=UNSET
    )
    source: Missing[PagesSourceHash] = Field(title="Pages Source Hash", default=UNSET)
    public: bool = Field(
        description="Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site.",
        default=...,
    )
    https_certificate: Missing[PagesHttpsCertificate] = Field(
        title="Pages Https Certificate", default=UNSET
    )
    https_enforced: Missing[bool] = Field(
        description="Whether https is enabled on the domain", default=UNSET
    )


class PageBuild(GitHubRestModel):
    """Page Build

    Page Build
    """

    url: str = Field(default=...)
    status: str = Field(default=...)
    error: PageBuildPropError = Field(default=...)
    pusher: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    commit: str = Field(default=...)
    duration: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)


class PageBuildPropError(GitHubRestModel):
    """PageBuildPropError"""

    message: Union[str, None] = Field(default=...)


class PageBuildStatus(GitHubRestModel):
    """Page Build Status

    Page Build Status
    """

    url: str = Field(default=...)
    status: str = Field(default=...)


class PageDeployment(GitHubRestModel):
    """GitHub Pages

    The GitHub Pages deployment status.
    """

    status_url: str = Field(
        description="The URI to monitor GitHub Pages deployment status.", default=...
    )
    page_url: str = Field(
        description="The URI to the deployed GitHub Pages.", default=...
    )
    preview_url: Missing[str] = Field(
        description="The URI to the deployed GitHub Pages preview.", default=UNSET
    )


class PagesHealthCheck(GitHubRestModel):
    """Pages Health Check Status

    Pages Health Check Status
    """

    domain: Missing[PagesHealthCheckPropDomain] = Field(default=UNSET)
    alt_domain: Missing[Union[PagesHealthCheckPropAltDomain, None]] = Field(
        default=UNSET
    )


class PagesHealthCheckPropDomain(GitHubRestModel):
    """PagesHealthCheckPropDomain"""

    host: Missing[str] = Field(default=UNSET)
    uri: Missing[str] = Field(default=UNSET)
    nameservers: Missing[str] = Field(default=UNSET)
    dns_resolves: Missing[bool] = Field(default=UNSET)
    is_proxied: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cloudflare_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_fastly_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_old_ip_address: Missing[Union[bool, None]] = Field(default=UNSET)
    is_a_record: Missing[Union[bool, None]] = Field(default=UNSET)
    has_cname_record: Missing[Union[bool, None]] = Field(default=UNSET)
    has_mx_records_present: Missing[Union[bool, None]] = Field(default=UNSET)
    is_valid_domain: Missing[bool] = Field(default=UNSET)
    is_apex_domain: Missing[bool] = Field(default=UNSET)
    should_be_a_record: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cname_to_github_user_domain: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cname_to_pages_dot_github_dot_com: Missing[Union[bool, None]] = Field(
        default=UNSET
    )
    is_cname_to_fastly: Missing[Union[bool, None]] = Field(default=UNSET)
    is_pointed_to_github_pages_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_non_github_pages_ip_present: Missing[Union[bool, None]] = Field(default=UNSET)
    is_pages_domain: Missing[bool] = Field(default=UNSET)
    is_served_by_pages: Missing[Union[bool, None]] = Field(default=UNSET)
    is_valid: Missing[bool] = Field(default=UNSET)
    reason: Missing[Union[str, None]] = Field(default=UNSET)
    responds_to_https: Missing[bool] = Field(default=UNSET)
    enforces_https: Missing[bool] = Field(default=UNSET)
    https_error: Missing[Union[str, None]] = Field(default=UNSET)
    is_https_eligible: Missing[Union[bool, None]] = Field(default=UNSET)
    caa_error: Missing[Union[str, None]] = Field(default=UNSET)


class PagesHealthCheckPropAltDomain(GitHubRestModel):
    """PagesHealthCheckPropAltDomain"""

    host: Missing[str] = Field(default=UNSET)
    uri: Missing[str] = Field(default=UNSET)
    nameservers: Missing[str] = Field(default=UNSET)
    dns_resolves: Missing[bool] = Field(default=UNSET)
    is_proxied: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cloudflare_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_fastly_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_old_ip_address: Missing[Union[bool, None]] = Field(default=UNSET)
    is_a_record: Missing[Union[bool, None]] = Field(default=UNSET)
    has_cname_record: Missing[Union[bool, None]] = Field(default=UNSET)
    has_mx_records_present: Missing[Union[bool, None]] = Field(default=UNSET)
    is_valid_domain: Missing[bool] = Field(default=UNSET)
    is_apex_domain: Missing[bool] = Field(default=UNSET)
    should_be_a_record: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cname_to_github_user_domain: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cname_to_pages_dot_github_dot_com: Missing[Union[bool, None]] = Field(
        default=UNSET
    )
    is_cname_to_fastly: Missing[Union[bool, None]] = Field(default=UNSET)
    is_pointed_to_github_pages_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_non_github_pages_ip_present: Missing[Union[bool, None]] = Field(default=UNSET)
    is_pages_domain: Missing[bool] = Field(default=UNSET)
    is_served_by_pages: Missing[Union[bool, None]] = Field(default=UNSET)
    is_valid: Missing[bool] = Field(default=UNSET)
    reason: Missing[Union[str, None]] = Field(default=UNSET)
    responds_to_https: Missing[bool] = Field(default=UNSET)
    enforces_https: Missing[bool] = Field(default=UNSET)
    https_error: Missing[Union[str, None]] = Field(default=UNSET)
    is_https_eligible: Missing[Union[bool, None]] = Field(default=UNSET)
    caa_error: Missing[Union[str, None]] = Field(default=UNSET)


class PullRequest(GitHubRestModel):
    """Pull Request

    Pull requests let you tell others about changes you've pushed to a repository on
    GitHub. Once a pull request is sent, interested parties can review the set of
    changes, discuss potential modifications, and even push follow-up commits if
    necessary.
    """

    url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    html_url: str = Field(default=...)
    diff_url: str = Field(default=...)
    patch_url: str = Field(default=...)
    issue_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    review_comments_url: str = Field(default=...)
    review_comment_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository.",
        default=...,
    )
    state: Literal["open", "closed"] = Field(
        description="State of this Pull Request. Either `open` or `closed`.",
        default=...,
    )
    locked: bool = Field(default=...)
    title: str = Field(description="The title of the pull request.", default=...)
    user: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    body: Union[str, None] = Field(default=...)
    labels: List[PullRequestPropLabelsItems] = Field(default=...)
    milestone: Union[None, Milestone] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    merged_at: Union[datetime, None] = Field(default=...)
    merge_commit_sha: Union[str, None] = Field(default=...)
    assignee: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    assignees: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_reviewers: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_teams: Missing[Union[List[TeamSimple], None]] = Field(default=UNSET)
    head: PullRequestPropHead = Field(default=...)
    base: PullRequestPropBase = Field(default=...)
    links: PullRequestPropLinks = Field(default=..., alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="Auto merge",
        description="The status of auto merging a pull request.",
        default=...,
    )
    draft: Missing[bool] = Field(
        description="Indicates whether or not the pull request is a draft.",
        default=UNSET,
    )
    merged: bool = Field(default=...)
    mergeable: Union[bool, None] = Field(default=...)
    rebaseable: Missing[Union[bool, None]] = Field(default=UNSET)
    mergeable_state: str = Field(default=...)
    merged_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    comments: int = Field(default=...)
    review_comments: int = Field(default=...)
    maintainer_can_modify: bool = Field(
        description="Indicates whether maintainers can modify the pull request.",
        default=...,
    )
    commits: int = Field(default=...)
    additions: int = Field(default=...)
    deletions: int = Field(default=...)
    changed_files: int = Field(default=...)


class PullRequestPropLabelsItems(GitHubRestModel):
    """PullRequestPropLabelsItems"""

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    color: str = Field(default=...)
    default: bool = Field(default=...)


class PullRequestPropHead(GitHubRestModel):
    """PullRequestPropHead"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    repo: Union[PullRequestPropHeadPropRepo, None] = Field(default=...)
    sha: str = Field(default=...)
    user: PullRequestPropHeadPropUser = Field(default=...)


class PullRequestPropHeadPropRepoPropOwner(GitHubRestModel):
    """PullRequestPropHeadPropRepoPropOwner"""

    avatar_url: str = Field(default=...)
    events_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    organizations_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class PullRequestPropHeadPropRepoPropPermissions(GitHubRestModel):
    """PullRequestPropHeadPropRepoPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Missing[bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    triage: Missing[bool] = Field(default=UNSET)
    pull: bool = Field(default=...)


class PullRequestPropHeadPropRepoPropLicense(GitHubRestModel):
    """PullRequestPropHeadPropRepoPropLicense"""

    key: str = Field(default=...)
    name: str = Field(default=...)
    url: Union[str, None] = Field(default=...)
    spdx_id: Union[str, None] = Field(default=...)
    node_id: str = Field(default=...)


class PullRequestPropHeadPropRepo(GitHubRestModel):
    """PullRequestPropHeadPropRepo"""

    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    fork: bool = Field(default=...)
    forks_url: str = Field(default=...)
    full_name: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    name: str = Field(default=...)
    notifications_url: str = Field(default=...)
    owner: PullRequestPropHeadPropRepoPropOwner = Field(default=...)
    private: bool = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    url: str = Field(default=...)
    clone_url: str = Field(default=...)
    default_branch: str = Field(default=...)
    forks: int = Field(default=...)
    forks_count: int = Field(default=...)
    git_url: str = Field(default=...)
    has_downloads: bool = Field(default=...)
    has_issues: bool = Field(default=...)
    has_projects: bool = Field(default=...)
    has_wiki: bool = Field(default=...)
    has_pages: bool = Field(default=...)
    has_discussions: bool = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    master_branch: Missing[str] = Field(default=UNSET)
    archived: bool = Field(default=...)
    disabled: bool = Field(default=...)
    visibility: Missing[str] = Field(
        description="The repository visibility: public, private, or internal.",
        default=UNSET,
    )
    mirror_url: Union[str, None] = Field(default=...)
    open_issues: int = Field(default=...)
    open_issues_count: int = Field(default=...)
    permissions: Missing[PullRequestPropHeadPropRepoPropPermissions] = Field(
        default=UNSET
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    license_: Union[PullRequestPropHeadPropRepoPropLicense, None] = Field(
        default=..., alias="license"
    )
    pushed_at: datetime = Field(default=...)
    size: int = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_count: int = Field(default=...)
    svn_url: str = Field(default=...)
    topics: Missing[List[str]] = Field(default=UNSET)
    watchers: int = Field(default=...)
    watchers_count: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    allow_forking: Missing[bool] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)


class PullRequestPropHeadPropUser(GitHubRestModel):
    """PullRequestPropHeadPropUser"""

    avatar_url: str = Field(default=...)
    events_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    organizations_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class PullRequestPropBase(GitHubRestModel):
    """PullRequestPropBase"""

    label: str = Field(default=...)
    ref: str = Field(default=...)
    repo: PullRequestPropBasePropRepo = Field(default=...)
    sha: str = Field(default=...)
    user: PullRequestPropBasePropUser = Field(default=...)


class PullRequestPropBasePropRepo(GitHubRestModel):
    """PullRequestPropBasePropRepo"""

    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    fork: bool = Field(default=...)
    forks_url: str = Field(default=...)
    full_name: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    is_template: Missing[bool] = Field(default=UNSET)
    node_id: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    name: str = Field(default=...)
    notifications_url: str = Field(default=...)
    owner: PullRequestPropBasePropRepoPropOwner = Field(default=...)
    private: bool = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    url: str = Field(default=...)
    clone_url: str = Field(default=...)
    default_branch: str = Field(default=...)
    forks: int = Field(default=...)
    forks_count: int = Field(default=...)
    git_url: str = Field(default=...)
    has_downloads: bool = Field(default=...)
    has_issues: bool = Field(default=...)
    has_projects: bool = Field(default=...)
    has_wiki: bool = Field(default=...)
    has_pages: bool = Field(default=...)
    has_discussions: bool = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    master_branch: Missing[str] = Field(default=UNSET)
    archived: bool = Field(default=...)
    disabled: bool = Field(default=...)
    visibility: Missing[str] = Field(
        description="The repository visibility: public, private, or internal.",
        default=UNSET,
    )
    mirror_url: Union[str, None] = Field(default=...)
    open_issues: int = Field(default=...)
    open_issues_count: int = Field(default=...)
    permissions: Missing[PullRequestPropBasePropRepoPropPermissions] = Field(
        default=UNSET
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    pushed_at: datetime = Field(default=...)
    size: int = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_count: int = Field(default=...)
    svn_url: str = Field(default=...)
    topics: Missing[List[str]] = Field(default=UNSET)
    watchers: int = Field(default=...)
    watchers_count: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    allow_forking: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)


class PullRequestPropBasePropRepoPropOwner(GitHubRestModel):
    """PullRequestPropBasePropRepoPropOwner"""

    avatar_url: str = Field(default=...)
    events_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    organizations_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class PullRequestPropBasePropRepoPropPermissions(GitHubRestModel):
    """PullRequestPropBasePropRepoPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Missing[bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    triage: Missing[bool] = Field(default=UNSET)
    pull: bool = Field(default=...)


class PullRequestPropBasePropUser(GitHubRestModel):
    """PullRequestPropBasePropUser"""

    avatar_url: str = Field(default=...)
    events_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    login: str = Field(default=...)
    organizations_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    type: str = Field(default=...)
    url: str = Field(default=...)


class PullRequestPropLinks(GitHubRestModel):
    """PullRequestPropLinks"""

    comments: Link = Field(title="Link", description="Hypermedia Link", default=...)
    commits: Link = Field(title="Link", description="Hypermedia Link", default=...)
    statuses: Link = Field(title="Link", description="Hypermedia Link", default=...)
    html: Link = Field(title="Link", description="Hypermedia Link", default=...)
    issue: Link = Field(title="Link", description="Hypermedia Link", default=...)
    review_comments: Link = Field(
        title="Link", description="Hypermedia Link", default=...
    )
    review_comment: Link = Field(
        title="Link", description="Hypermedia Link", default=...
    )
    self_: Link = Field(
        title="Link", description="Hypermedia Link", default=..., alias="self"
    )


class PullRequestMergeResult(GitHubRestModel):
    """Pull Request Merge Result

    Pull Request Merge Result
    """

    sha: str = Field(default=...)
    merged: bool = Field(default=...)
    message: str = Field(default=...)


class PullRequestReviewRequest(GitHubRestModel):
    """Pull Request Review Request

    Pull Request Review Request
    """

    users: List[SimpleUser] = Field(default=...)
    teams: List[Team] = Field(default=...)


class PullRequestReview(GitHubRestModel):
    """Pull Request Review

    Pull Request Reviews are reviews on pull requests.
    """

    id: int = Field(description="Unique identifier of the review", default=...)
    node_id: str = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    body: str = Field(description="The text of the review.", default=...)
    state: str = Field(default=...)
    html_url: str = Field(default=...)
    pull_request_url: str = Field(default=...)
    links: PullRequestReviewPropLinks = Field(default=..., alias="_links")
    submitted_at: Missing[datetime] = Field(default=UNSET)
    commit_id: Union[str, None] = Field(
        description="A commit SHA for the review. If the commit object was garbage collected or forcibly deleted, then it no longer exists in Git and this value will be `null`.",
        default=...,
    )
    body_html: Missing[str] = Field(default=UNSET)
    body_text: Missing[str] = Field(default=UNSET)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )


class PullRequestReviewPropLinks(GitHubRestModel):
    """PullRequestReviewPropLinks"""

    html: PullRequestReviewPropLinksPropHtml = Field(default=...)
    pull_request: PullRequestReviewPropLinksPropPullRequest = Field(default=...)


class PullRequestReviewPropLinksPropHtml(GitHubRestModel):
    """PullRequestReviewPropLinksPropHtml"""

    href: str = Field(default=...)


class PullRequestReviewPropLinksPropPullRequest(GitHubRestModel):
    """PullRequestReviewPropLinksPropPullRequest"""

    href: str = Field(default=...)


class ReviewComment(GitHubRestModel):
    """Legacy Review Comment

    Legacy Review Comment
    """

    url: str = Field(default=...)
    pull_request_review_id: Union[int, None] = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    diff_hunk: str = Field(default=...)
    path: str = Field(default=...)
    position: Union[int, None] = Field(default=...)
    original_position: int = Field(default=...)
    commit_id: str = Field(default=...)
    original_commit_id: str = Field(default=...)
    in_reply_to_id: Missing[int] = Field(default=UNSET)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    body: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    html_url: str = Field(default=...)
    pull_request_url: str = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    links: ReviewCommentPropLinks = Field(default=..., alias="_links")
    body_text: Missing[str] = Field(default=UNSET)
    body_html: Missing[str] = Field(default=UNSET)
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)
    side: Missing[Literal["LEFT", "RIGHT"]] = Field(
        description="The side of the first line of the range for a multi-line comment.",
        default="RIGHT",
    )
    start_side: Missing[Union[None, Literal["LEFT", "RIGHT"]]] = Field(
        description="The side of the first line of the range for a multi-line comment.",
        default="RIGHT",
    )
    line: Missing[int] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=UNSET,
    )
    original_line: Missing[int] = Field(
        description="The original line of the blob to which the comment applies. The last line of the range for a multi-line comment",
        default=UNSET,
    )
    start_line: Missing[Union[int, None]] = Field(
        description="The first line of the range for a multi-line comment.",
        default=UNSET,
    )
    original_start_line: Missing[Union[int, None]] = Field(
        description="The original first line of the range for a multi-line comment.",
        default=UNSET,
    )


class ReviewCommentPropLinks(GitHubRestModel):
    """ReviewCommentPropLinks"""

    self_: Link = Field(
        title="Link", description="Hypermedia Link", default=..., alias="self"
    )
    html: Link = Field(title="Link", description="Hypermedia Link", default=...)
    pull_request: Link = Field(title="Link", description="Hypermedia Link", default=...)


class ReleaseAsset(GitHubRestModel):
    """Release Asset

    Data related to a release.
    """

    url: str = Field(default=...)
    browser_download_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The file name of the asset.", default=...)
    label: Union[str, None] = Field(default=...)
    state: Literal["uploaded", "open"] = Field(
        description="State of the release asset.", default=...
    )
    content_type: str = Field(default=...)
    size: int = Field(default=...)
    download_count: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    uploader: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class Release(GitHubRestModel):
    """Release

    A release.
    """

    url: str = Field(default=...)
    html_url: str = Field(default=...)
    assets_url: str = Field(default=...)
    upload_url: str = Field(default=...)
    tarball_url: Union[str, None] = Field(default=...)
    zipball_url: Union[str, None] = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    tag_name: str = Field(description="The name of the tag.", default=...)
    target_commitish: str = Field(
        description="Specifies the commitish value that determines where the Git tag is created from.",
        default=...,
    )
    name: Union[str, None] = Field(default=...)
    body: Missing[Union[str, None]] = Field(default=UNSET)
    draft: bool = Field(
        description="true to create a draft (unpublished) release, false to create a published one.",
        default=...,
    )
    prerelease: bool = Field(
        description="Whether to identify the release as a prerelease or a full release.",
        default=...,
    )
    created_at: datetime = Field(default=...)
    published_at: Union[datetime, None] = Field(default=...)
    author: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    assets: List[ReleaseAsset] = Field(default=...)
    body_html: Missing[Union[str, None]] = Field(default=UNSET)
    body_text: Missing[Union[str, None]] = Field(default=UNSET)
    mentions_count: Missing[int] = Field(default=UNSET)
    discussion_url: Missing[str] = Field(
        description="The URL of the release discussion.", default=UNSET
    )
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)


class ReleaseNotesContent(GitHubRestModel):
    """Generated Release Notes Content

    Generated name and body describing a release
    """

    name: str = Field(description="The generated name of the release", default=...)
    body: str = Field(
        description="The generated body describing the contents of the release supporting markdown formatting",
        default=...,
    )


class RepositoryRuleRulesetInfo(GitHubRestModel):
    """repository ruleset data for rule

    User-defined metadata to store domain-specific information limited to 8 keys
    with scalar values.
    """

    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof0(GitHubRestModel):
    """RepositoryRuleDetailedOneof0"""

    type: Literal["creation"] = Field(default=...)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof1(GitHubRestModel):
    """RepositoryRuleDetailedOneof1"""

    type: Literal["update"] = Field(default=...)
    parameters: Missing[RepositoryRuleUpdatePropParameters] = Field(default=UNSET)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof2(GitHubRestModel):
    """RepositoryRuleDetailedOneof2"""

    type: Literal["deletion"] = Field(default=...)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof3(GitHubRestModel):
    """RepositoryRuleDetailedOneof3"""

    type: Literal["required_linear_history"] = Field(default=...)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof4(GitHubRestModel):
    """RepositoryRuleDetailedOneof4"""

    type: Literal["required_deployments"] = Field(default=...)
    parameters: Missing[RepositoryRuleRequiredDeploymentsPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof5(GitHubRestModel):
    """RepositoryRuleDetailedOneof5"""

    type: Literal["required_signatures"] = Field(default=...)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof6(GitHubRestModel):
    """RepositoryRuleDetailedOneof6"""

    type: Literal["pull_request"] = Field(default=...)
    parameters: Missing[RepositoryRulePullRequestPropParameters] = Field(default=UNSET)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof7(GitHubRestModel):
    """RepositoryRuleDetailedOneof7"""

    type: Literal["required_status_checks"] = Field(default=...)
    parameters: Missing[RepositoryRuleRequiredStatusChecksPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof8(GitHubRestModel):
    """RepositoryRuleDetailedOneof8"""

    type: Literal["non_fast_forward"] = Field(default=...)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof9(GitHubRestModel):
    """RepositoryRuleDetailedOneof9"""

    type: Literal["commit_message_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleCommitMessagePatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof10(GitHubRestModel):
    """RepositoryRuleDetailedOneof10"""

    type: Literal["commit_author_email_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleCommitAuthorEmailPatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof11(GitHubRestModel):
    """RepositoryRuleDetailedOneof11"""

    type: Literal["committer_email_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleCommitterEmailPatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof12(GitHubRestModel):
    """RepositoryRuleDetailedOneof12"""

    type: Literal["branch_name_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleBranchNamePatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class RepositoryRuleDetailedOneof13(GitHubRestModel):
    """RepositoryRuleDetailedOneof13"""

    type: Literal["tag_name_pattern"] = Field(default=...)
    parameters: Missing[RepositoryRuleTagNamePatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        description="The type of source for the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_source: Missing[str] = Field(
        description="The name of the source of the ruleset that includes this rule.",
        default=UNSET,
    )
    ruleset_id: Missing[int] = Field(
        description="The ID of the ruleset that includes this rule.", default=UNSET
    )


class SecretScanningAlert(GitHubRestModel):
    """SecretScanningAlert"""

    number: Missing[int] = Field(
        description="The security alert number.", default=UNSET
    )
    created_at: Missing[datetime] = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    updated_at: Missing[Union[None, datetime]] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: Missing[str] = Field(
        description="The REST API URL of the alert resource.", default=UNSET
    )
    html_url: Missing[str] = Field(
        description="The GitHub URL of the alert resource.", default=UNSET
    )
    locations_url: Missing[str] = Field(
        description="The REST API URL of the code locations for this alert.",
        default=UNSET,
    )
    state: Missing[Literal["open", "resolved"]] = Field(
        description="Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.",
        default=UNSET,
    )
    resolution: Missing[
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]]
    ] = Field(
        description="**Required when the `state` is `resolved`.** The reason for resolving the alert.",
        default=UNSET,
    )
    resolved_at: Missing[Union[datetime, None]] = Field(
        description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    resolved_by: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    resolution_comment: Missing[Union[str, None]] = Field(
        description="An optional comment to resolve an alert.", default=UNSET
    )
    secret_type: Missing[str] = Field(
        description="The type of secret that secret scanning detected.", default=UNSET
    )
    secret_type_display_name: Missing[str] = Field(
        description='User-friendly name for the detected secret, matching the `secret_type`.\nFor a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."',
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="The secret that was detected.", default=UNSET
    )
    push_protection_bypassed: Missing[Union[bool, None]] = Field(
        description="Whether push protection was bypassed for the detected secret.",
        default=UNSET,
    )
    push_protection_bypassed_by: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    push_protection_bypassed_at: Missing[Union[datetime, None]] = Field(
        description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )


class SecretScanningLocationCommit(GitHubRestModel):
    """SecretScanningLocationCommit

    Represents a 'commit' secret scanning location type. This location type shows
    that a secret was detected inside a commit to a repository.
    """

    path: str = Field(description="The file path in the repository", default=...)
    start_line: float = Field(
        description="Line number at which the secret starts in the file", default=...
    )
    end_line: float = Field(
        description="Line number at which the secret ends in the file", default=...
    )
    start_column: float = Field(
        description="The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII",
        default=...,
    )
    end_column: float = Field(
        description="The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII",
        default=...,
    )
    blob_sha: str = Field(
        description="SHA-1 hash ID of the associated blob", default=...
    )
    blob_url: str = Field(
        description="The API URL to get the associated blob resource", default=...
    )
    commit_sha: str = Field(
        description="SHA-1 hash ID of the associated commit", default=...
    )
    commit_url: str = Field(
        description="The API URL to get the associated commit resource", default=...
    )


class SecretScanningLocationIssueTitle(GitHubRestModel):
    """SecretScanningLocationIssueTitle

    Represents an 'issue_title' secret scanning location type. This location type
    shows that a secret was detected in the title of an issue.
    """

    issue_title_url: str = Field(
        description="The API URL to get the issue where the secret was detected.",
        default=...,
    )


class SecretScanningLocationIssueBody(GitHubRestModel):
    """SecretScanningLocationIssueBody

    Represents an 'issue_body' secret scanning location type. This location type
    shows that a secret was detected in the body of an issue.
    """

    issue_body_url: str = Field(
        description="The API URL to get the issue where the secret was detected.",
        default=...,
    )


class SecretScanningLocationIssueComment(GitHubRestModel):
    """SecretScanningLocationIssueComment

    Represents an 'issue_comment' secret scanning location type. This location type
    shows that a secret was detected in a comment on an issue.
    """

    issue_comment_url: str = Field(
        description="The API URL to get the issue comment where the secret was detected.",
        default=...,
    )


class SecretScanningLocation(GitHubRestModel):
    """SecretScanningLocation"""

    type: Literal["commit", "issue_title", "issue_body", "issue_comment"] = Field(
        description="The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.",
        default=...,
    )
    details: Union[
        SecretScanningLocationCommit,
        SecretScanningLocationIssueTitle,
        SecretScanningLocationIssueBody,
        SecretScanningLocationIssueComment,
    ] = Field(
        description="Represents an 'issue_comment' secret scanning location type. This location type shows that a secret was detected in a comment on an issue.",
        default=...,
    )


class RepositoryAdvisoryCreate(GitHubRestModel):
    """RepositoryAdvisoryCreate"""

    summary: str = Field(
        description="A short summary of the advisory.", max_length=1024, default=...
    )
    description: str = Field(
        description="A detailed description of what the advisory impacts.",
        max_length=65535,
        default=...,
    )
    cve_id: Missing[Union[str, None]] = Field(
        description="The Common Vulnerabilities and Exposures (CVE) ID.", default=UNSET
    )
    vulnerabilities: List[RepositoryAdvisoryCreatePropVulnerabilitiesItems] = Field(
        description="A product affected by the vulnerability detailed in a repository security advisory.",
        default=...,
    )
    cwe_ids: Missing[Union[List[str], None]] = Field(
        description="A list of Common Weakness Enumeration (CWE) IDs.", default=UNSET
    )
    credits_: Missing[
        Union[List[RepositoryAdvisoryCreatePropCreditsItems], None]
    ] = Field(
        description="A list of users receiving credit for their participation in the security advisory.",
        default=UNSET,
        alias="credits",
    )
    severity: Missing[
        Union[None, Literal["critical", "high", "medium", "low"]]
    ] = Field(
        description="The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.",
        default=UNSET,
    )
    cvss_vector_string: Missing[Union[str, None]] = Field(
        description="The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.",
        default=UNSET,
    )


class RepositoryAdvisoryCreatePropVulnerabilitiesItems(GitHubRestModel):
    """RepositoryAdvisoryCreatePropVulnerabilitiesItems"""

    package: RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackage = Field(
        description="The name of the package affected by the vulnerability.",
        default=...,
    )
    vulnerable_version_range: Missing[Union[str, None]] = Field(
        description="The range of the package versions affected by the vulnerability.",
        default=UNSET,
    )
    patched_versions: Missing[Union[str, None]] = Field(
        description="The package version(s) that resolve the vulnerability.",
        default=UNSET,
    )
    vulnerable_functions: Missing[Union[List[str], None]] = Field(
        description="The functions in the package that are affected.", default=UNSET
    )


class RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackage(GitHubRestModel):
    """RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(
        description="The package's language or package management ecosystem.",
        default=...,
    )
    name: Missing[Union[str, None]] = Field(
        description="The unique package name within its ecosystem.", default=UNSET
    )


class RepositoryAdvisoryCreatePropCreditsItems(GitHubRestModel):
    """RepositoryAdvisoryCreatePropCreditsItems"""

    login: str = Field(description="The username of the user credited.", default=...)
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ] = Field(description="The type of credit the user is receiving.", default=...)


class PrivateVulnerabilityReportCreate(GitHubRestModel):
    """PrivateVulnerabilityReportCreate"""

    summary: str = Field(
        description="A short summary of the advisory.", max_length=1024, default=...
    )
    description: str = Field(
        description="A detailed description of what the advisory impacts.",
        max_length=65535,
        default=...,
    )
    vulnerabilities: Missing[
        Union[List[PrivateVulnerabilityReportCreatePropVulnerabilitiesItems], None]
    ] = Field(
        description="An array of products affected by the vulnerability detailed in a repository security advisory.",
        default=UNSET,
    )
    cwe_ids: Missing[Union[List[str], None]] = Field(
        description="A list of Common Weakness Enumeration (CWE) IDs.", default=UNSET
    )
    severity: Missing[
        Union[None, Literal["critical", "high", "medium", "low"]]
    ] = Field(
        description="The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.",
        default=UNSET,
    )
    cvss_vector_string: Missing[Union[str, None]] = Field(
        description="The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.",
        default=UNSET,
    )


class PrivateVulnerabilityReportCreatePropVulnerabilitiesItems(GitHubRestModel):
    """PrivateVulnerabilityReportCreatePropVulnerabilitiesItems"""

    package: PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackage = (
        Field(
            description="The name of the package affected by the vulnerability.",
            default=...,
        )
    )
    vulnerable_version_range: Missing[Union[str, None]] = Field(
        description="The range of the package versions affected by the vulnerability.",
        default=UNSET,
    )
    patched_versions: Missing[Union[str, None]] = Field(
        description="The package version(s) that resolve the vulnerability.",
        default=UNSET,
    )
    vulnerable_functions: Missing[Union[List[str], None]] = Field(
        description="The functions in the package that are affected.", default=UNSET
    )


class PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackage(
    GitHubRestModel
):
    """PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(
        description="The package's language or package management ecosystem.",
        default=...,
    )
    name: Missing[Union[str, None]] = Field(
        description="The unique package name within its ecosystem.", default=UNSET
    )


class RepositoryAdvisoryUpdate(GitHubRestModel):
    """RepositoryAdvisoryUpdate"""

    summary: Missing[Annotated[str, Field(max_length=1024)]] = Field(
        description="A short summary of the advisory.", default=UNSET
    )
    description: Missing[Annotated[str, Field(max_length=65535)]] = Field(
        description="A detailed description of what the advisory impacts.",
        default=UNSET,
    )
    cve_id: Missing[Union[str, None]] = Field(
        description="The Common Vulnerabilities and Exposures (CVE) ID.", default=UNSET
    )
    vulnerabilities: Missing[
        List[RepositoryAdvisoryUpdatePropVulnerabilitiesItems]
    ] = Field(
        description="A product affected by the vulnerability detailed in a repository security advisory.",
        default=UNSET,
    )
    cwe_ids: Missing[Union[List[str], None]] = Field(
        description="A list of Common Weakness Enumeration (CWE) IDs.", default=UNSET
    )
    credits_: Missing[
        Union[List[RepositoryAdvisoryUpdatePropCreditsItems], None]
    ] = Field(
        description="A list of users receiving credit for their participation in the security advisory.",
        default=UNSET,
        alias="credits",
    )
    severity: Missing[
        Union[None, Literal["critical", "high", "medium", "low"]]
    ] = Field(
        description="The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.",
        default=UNSET,
    )
    cvss_vector_string: Missing[Union[str, None]] = Field(
        description="The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.",
        default=UNSET,
    )
    state: Missing[Literal["published", "closed", "draft"]] = Field(
        description="The state of the advisory.", default=UNSET
    )
    collaborating_users: Missing[Union[List[str], None]] = Field(
        description="A list of usernames who have been granted write access to the advisory.",
        default=UNSET,
    )
    collaborating_teams: Missing[Union[List[str], None]] = Field(
        description="A list of team slugs which have been granted write access to the advisory.",
        default=UNSET,
    )


class RepositoryAdvisoryUpdatePropVulnerabilitiesItems(GitHubRestModel):
    """RepositoryAdvisoryUpdatePropVulnerabilitiesItems"""

    package: RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackage = Field(
        description="The name of the package affected by the vulnerability.",
        default=...,
    )
    vulnerable_version_range: Missing[Union[str, None]] = Field(
        description="The range of the package versions affected by the vulnerability.",
        default=UNSET,
    )
    patched_versions: Missing[Union[str, None]] = Field(
        description="The package version(s) that resolve the vulnerability.",
        default=UNSET,
    )
    vulnerable_functions: Missing[Union[List[str], None]] = Field(
        description="The functions in the package that are affected.", default=UNSET
    )


class RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackage(GitHubRestModel):
    """RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(
        description="The package's language or package management ecosystem.",
        default=...,
    )
    name: Missing[Union[str, None]] = Field(
        description="The unique package name within its ecosystem.", default=UNSET
    )


class RepositoryAdvisoryUpdatePropCreditsItems(GitHubRestModel):
    """RepositoryAdvisoryUpdatePropCreditsItems"""

    login: str = Field(description="The username of the user credited.", default=...)
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ] = Field(description="The type of credit the user is receiving.", default=...)


class Stargazer(GitHubRestModel):
    """Stargazer

    Stargazer
    """

    starred_at: datetime = Field(default=...)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class CommitActivity(GitHubRestModel):
    """Commit Activity

    Commit Activity
    """

    days: List[int] = Field(default=...)
    total: int = Field(default=...)
    week: int = Field(default=...)


class ContributorActivity(GitHubRestModel):
    """Contributor Activity

    Contributor Activity
    """

    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    total: int = Field(default=...)
    weeks: List[ContributorActivityPropWeeksItems] = Field(default=...)


class ContributorActivityPropWeeksItems(GitHubRestModel):
    """ContributorActivityPropWeeksItems"""

    w: Missing[int] = Field(default=UNSET)
    a: Missing[int] = Field(default=UNSET)
    d: Missing[int] = Field(default=UNSET)
    c: Missing[int] = Field(default=UNSET)


class ParticipationStats(GitHubRestModel):
    """Participation Stats"""

    all_: List[int] = Field(default=..., alias="all")
    owner: List[int] = Field(default=...)


class RepositorySubscription(GitHubRestModel):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    subscribed: bool = Field(
        description="Determines if notifications should be received from this repository.",
        default=...,
    )
    ignored: bool = Field(
        description="Determines if all notifications should be blocked from this repository.",
        default=...,
    )
    reason: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    url: str = Field(default=...)
    repository_url: str = Field(default=...)


class Tag(GitHubRestModel):
    """Tag

    Tag
    """

    name: str = Field(default=...)
    commit: TagPropCommit = Field(default=...)
    zipball_url: str = Field(default=...)
    tarball_url: str = Field(default=...)
    node_id: str = Field(default=...)


class TagPropCommit(GitHubRestModel):
    """TagPropCommit"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class TagProtection(GitHubRestModel):
    """Tag protection

    Tag protection
    """

    id: Missing[int] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    enabled: Missing[bool] = Field(default=UNSET)
    pattern: str = Field(default=...)


class Topic(GitHubRestModel):
    """Topic

    A topic aggregates entities that are related to a subject.
    """

    names: List[str] = Field(default=...)


class Traffic(GitHubRestModel):
    """Traffic"""

    timestamp: datetime = Field(default=...)
    uniques: int = Field(default=...)
    count: int = Field(default=...)


class CloneTraffic(GitHubRestModel):
    """Clone Traffic

    Clone Traffic
    """

    count: int = Field(default=...)
    uniques: int = Field(default=...)
    clones: List[Traffic] = Field(default=...)


class ContentTraffic(GitHubRestModel):
    """Content Traffic

    Content Traffic
    """

    path: str = Field(default=...)
    title: str = Field(default=...)
    count: int = Field(default=...)
    uniques: int = Field(default=...)


class ReferrerTraffic(GitHubRestModel):
    """Referrer Traffic

    Referrer Traffic
    """

    referrer: str = Field(default=...)
    count: int = Field(default=...)
    uniques: int = Field(default=...)


class ViewTraffic(GitHubRestModel):
    """View Traffic

    View Traffic
    """

    count: int = Field(default=...)
    uniques: int = Field(default=...)
    views: List[Traffic] = Field(default=...)


class SearchResultTextMatchesItems(GitHubRestModel):
    """SearchResultTextMatchesItems"""

    object_url: Missing[str] = Field(default=UNSET)
    object_type: Missing[Union[str, None]] = Field(default=UNSET)
    property_: Missing[str] = Field(default=UNSET, alias="property")
    fragment: Missing[str] = Field(default=UNSET)
    matches: Missing[List[SearchResultTextMatchesItemsPropMatchesItems]] = Field(
        default=UNSET
    )


class SearchResultTextMatchesItemsPropMatchesItems(GitHubRestModel):
    """SearchResultTextMatchesItemsPropMatchesItems"""

    text: Missing[str] = Field(default=UNSET)
    indices: Missing[List[int]] = Field(default=UNSET)


class CodeSearchResultItem(GitHubRestModel):
    """Code Search Result Item

    Code Search Result Item
    """

    name: str = Field(default=...)
    path: str = Field(default=...)
    sha: str = Field(default=...)
    url: str = Field(default=...)
    git_url: str = Field(default=...)
    html_url: str = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    score: float = Field(default=...)
    file_size: Missing[int] = Field(default=UNSET)
    language: Missing[Union[str, None]] = Field(default=UNSET)
    last_modified_at: Missing[datetime] = Field(default=UNSET)
    line_numbers: Missing[List[str]] = Field(default=UNSET)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )


class CommitSearchResultItem(GitHubRestModel):
    """Commit Search Result Item

    Commit Search Result Item
    """

    url: str = Field(default=...)
    sha: str = Field(default=...)
    html_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commit: CommitSearchResultItemPropCommit = Field(default=...)
    author: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    committer: Union[None, GitUser] = Field(
        title="Git User",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    parents: List[CommitSearchResultItemPropParentsItems] = Field(default=...)
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository", default=...
    )
    score: float = Field(default=...)
    node_id: str = Field(default=...)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )


class CommitSearchResultItemPropCommit(GitHubRestModel):
    """CommitSearchResultItemPropCommit"""

    author: CommitSearchResultItemPropCommitPropAuthor = Field(default=...)
    committer: Union[None, GitUser] = Field(
        title="Git User",
        description="Metaproperties for Git author/committer information.",
        default=...,
    )
    comment_count: int = Field(default=...)
    message: str = Field(default=...)
    tree: CommitSearchResultItemPropCommitPropTree = Field(default=...)
    url: str = Field(default=...)
    verification: Missing[Verification] = Field(title="Verification", default=UNSET)


class CommitSearchResultItemPropCommitPropAuthor(GitHubRestModel):
    """CommitSearchResultItemPropCommitPropAuthor"""

    name: str = Field(default=...)
    email: str = Field(default=...)
    date: datetime = Field(default=...)


class CommitSearchResultItemPropCommitPropTree(GitHubRestModel):
    """CommitSearchResultItemPropCommitPropTree"""

    sha: str = Field(default=...)
    url: str = Field(default=...)


class CommitSearchResultItemPropParentsItems(GitHubRestModel):
    """CommitSearchResultItemPropParentsItems"""

    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)


class IssueSearchResultItem(GitHubRestModel):
    """Issue Search Result Item

    Issue Search Result Item
    """

    url: str = Field(default=...)
    repository_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    events_url: str = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    title: str = Field(default=...)
    locked: bool = Field(default=...)
    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    assignees: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    user: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    labels: List[IssueSearchResultItemPropLabelsItems] = Field(default=...)
    state: str = Field(default=...)
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)
    assignee: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    milestone: Union[None, Milestone] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
        default=...,
    )
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )
    pull_request: Missing[IssueSearchResultItemPropPullRequest] = Field(default=UNSET)
    body: Missing[str] = Field(default=UNSET)
    score: float = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
        default=...,
    )
    draft: Missing[bool] = Field(default=UNSET)
    repository: Missing[Repository] = Field(
        title="Repository", description="A repository on GitHub.", default=UNSET
    )
    body_html: Missing[str] = Field(default=UNSET)
    body_text: Missing[str] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    performed_via_github_app: Missing[Union[None, Integration]] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    reactions: Missing[ReactionRollup] = Field(title="Reaction Rollup", default=UNSET)


class IssueSearchResultItemPropLabelsItems(GitHubRestModel):
    """IssueSearchResultItemPropLabelsItems"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    color: Missing[str] = Field(default=UNSET)
    default: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)


class IssueSearchResultItemPropPullRequest(GitHubRestModel):
    """IssueSearchResultItemPropPullRequest"""

    merged_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    diff_url: Union[str, None] = Field(default=...)
    html_url: Union[str, None] = Field(default=...)
    patch_url: Union[str, None] = Field(default=...)
    url: Union[str, None] = Field(default=...)


class LabelSearchResultItem(GitHubRestModel):
    """Label Search Result Item

    Label Search Result Item
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    name: str = Field(default=...)
    color: str = Field(default=...)
    default: bool = Field(default=...)
    description: Union[str, None] = Field(default=...)
    score: float = Field(default=...)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )


class RepoSearchResultItem(GitHubRestModel):
    """Repo Search Result Item

    Repo Search Result Item
    """

    id: int = Field(default=...)
    node_id: str = Field(default=...)
    name: str = Field(default=...)
    full_name: str = Field(default=...)
    owner: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    private: bool = Field(default=...)
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    pushed_at: datetime = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    size: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    language: Union[str, None] = Field(default=...)
    forks_count: int = Field(default=...)
    open_issues_count: int = Field(default=...)
    master_branch: Missing[str] = Field(default=UNSET)
    default_branch: str = Field(default=...)
    score: float = Field(default=...)
    forks_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    events_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    archive_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    git_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    forks: int = Field(default=...)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    topics: Missing[List[str]] = Field(default=UNSET)
    mirror_url: Union[str, None] = Field(default=...)
    has_issues: bool = Field(default=...)
    has_projects: bool = Field(default=...)
    has_pages: bool = Field(default=...)
    has_wiki: bool = Field(default=...)
    has_downloads: bool = Field(default=...)
    has_discussions: Missing[bool] = Field(default=UNSET)
    archived: bool = Field(default=...)
    disabled: bool = Field(
        description="Returns whether or not this repository disabled.", default=...
    )
    visibility: Missing[str] = Field(
        description="The repository visibility: public, private, or internal.",
        default=UNSET,
    )
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    permissions: Missing[RepoSearchResultItemPropPermissions] = Field(default=UNSET)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    allow_auto_merge: Missing[bool] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    allow_forking: Missing[bool] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)


class RepoSearchResultItemPropPermissions(GitHubRestModel):
    """RepoSearchResultItemPropPermissions"""

    admin: bool = Field(default=...)
    maintain: Missing[bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    triage: Missing[bool] = Field(default=UNSET)
    pull: bool = Field(default=...)


class TopicSearchResultItem(GitHubRestModel):
    """Topic Search Result Item

    Topic Search Result Item
    """

    name: str = Field(default=...)
    display_name: Union[str, None] = Field(default=...)
    short_description: Union[str, None] = Field(default=...)
    description: Union[str, None] = Field(default=...)
    created_by: Union[str, None] = Field(default=...)
    released: Union[str, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    featured: bool = Field(default=...)
    curated: bool = Field(default=...)
    score: float = Field(default=...)
    repository_count: Missing[Union[int, None]] = Field(default=UNSET)
    logo_url: Missing[Union[str, None]] = Field(default=UNSET)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )
    related: Missing[Union[List[TopicSearchResultItemPropRelatedItems], None]] = Field(
        default=UNSET
    )
    aliases: Missing[Union[List[TopicSearchResultItemPropAliasesItems], None]] = Field(
        default=UNSET
    )


class TopicSearchResultItemPropRelatedItems(GitHubRestModel):
    """TopicSearchResultItemPropRelatedItems"""

    topic_relation: Missing[
        TopicSearchResultItemPropRelatedItemsPropTopicRelation
    ] = Field(default=UNSET)


class TopicSearchResultItemPropRelatedItemsPropTopicRelation(GitHubRestModel):
    """TopicSearchResultItemPropRelatedItemsPropTopicRelation"""

    id: Missing[int] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    topic_id: Missing[int] = Field(default=UNSET)
    relation_type: Missing[str] = Field(default=UNSET)


class TopicSearchResultItemPropAliasesItems(GitHubRestModel):
    """TopicSearchResultItemPropAliasesItems"""

    topic_relation: Missing[
        TopicSearchResultItemPropAliasesItemsPropTopicRelation
    ] = Field(default=UNSET)


class TopicSearchResultItemPropAliasesItemsPropTopicRelation(GitHubRestModel):
    """TopicSearchResultItemPropAliasesItemsPropTopicRelation"""

    id: Missing[int] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    topic_id: Missing[int] = Field(default=UNSET)
    relation_type: Missing[str] = Field(default=UNSET)


class UserSearchResultItem(GitHubRestModel):
    """User Search Result Item

    User Search Result Item
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    score: float = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    events_url: str = Field(default=...)
    public_repos: Missing[int] = Field(default=UNSET)
    public_gists: Missing[int] = Field(default=UNSET)
    followers: Missing[int] = Field(default=UNSET)
    following: Missing[int] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(default=UNSET)
    updated_at: Missing[datetime] = Field(default=UNSET)
    name: Missing[Union[str, None]] = Field(default=UNSET)
    bio: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    location: Missing[Union[str, None]] = Field(default=UNSET)
    site_admin: bool = Field(default=...)
    hireable: Missing[Union[bool, None]] = Field(default=UNSET)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        title="Search Result Text Matches", default=UNSET
    )
    blog: Missing[Union[str, None]] = Field(default=UNSET)
    company: Missing[Union[str, None]] = Field(default=UNSET)
    suspended_at: Missing[Union[datetime, None]] = Field(default=UNSET)


class PrivateUser(GitHubRestModel):
    """Private User

    Private User
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    name: Union[str, None] = Field(default=...)
    company: Union[str, None] = Field(default=...)
    blog: Union[str, None] = Field(default=...)
    location: Union[str, None] = Field(default=...)
    email: Union[str, None] = Field(default=...)
    hireable: Union[bool, None] = Field(default=...)
    bio: Union[str, None] = Field(default=...)
    twitter_username: Missing[Union[str, None]] = Field(default=UNSET)
    public_repos: int = Field(default=...)
    public_gists: int = Field(default=...)
    followers: int = Field(default=...)
    following: int = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    private_gists: int = Field(default=...)
    total_private_repos: int = Field(default=...)
    owned_private_repos: int = Field(default=...)
    disk_usage: int = Field(default=...)
    collaborators: int = Field(default=...)
    two_factor_authentication: bool = Field(default=...)
    plan: Missing[PrivateUserPropPlan] = Field(default=UNSET)
    suspended_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    business_plus: Missing[bool] = Field(default=UNSET)
    ldap_dn: Missing[str] = Field(default=UNSET)


class PrivateUserPropPlan(GitHubRestModel):
    """PrivateUserPropPlan"""

    collaborators: int = Field(default=...)
    name: str = Field(default=...)
    space: int = Field(default=...)
    private_repos: int = Field(default=...)


class CodespacesSecret(GitHubRestModel):
    """Codespaces Secret

    Secrets for a GitHub Codespace.
    """

    name: str = Field(description="The name of the secret", default=...)
    created_at: datetime = Field(
        description="The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    updated_at: datetime = Field(
        description="The date and time at which the secret was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
        default=...,
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="The type of repositories in the organization that the secret is visible to",
        default=...,
    )
    selected_repositories_url: str = Field(
        description="The API URL at which the list of repositories this secret is visible to can be retrieved",
        default=...,
    )


class CodespacesUserPublicKey(GitHubRestModel):
    """CodespacesUserPublicKey

    The public key used for setting user Codespaces' Secrets.
    """

    key_id: str = Field(description="The identifier for the key.", default=...)
    key: str = Field(description="The Base64 encoded public key.", default=...)


class CodespaceExportDetails(GitHubRestModel):
    """Fetches information about an export of a codespace.

    An export of a codespace. Also, latest export details for a codespace can be
    fetched with id = latest
    """

    state: Missing[Union[str, None]] = Field(
        description="State of the latest export", default=UNSET
    )
    completed_at: Missing[Union[datetime, None]] = Field(
        description="Completion time of the last export operation", default=UNSET
    )
    branch: Missing[Union[str, None]] = Field(
        description="Name of the exported branch", default=UNSET
    )
    sha: Missing[Union[str, None]] = Field(
        description="Git commit SHA of the exported branch", default=UNSET
    )
    id: Missing[str] = Field(description="Id for the export details", default=UNSET)
    export_url: Missing[str] = Field(
        description="Url for fetching export details", default=UNSET
    )
    html_url: Missing[Union[str, None]] = Field(
        description="Web url for the exported branch", default=UNSET
    )


class CodespaceWithFullRepository(GitHubRestModel):
    """Codespace

    A codespace.
    """

    id: int = Field(default=...)
    name: str = Field(
        description="Automatically generated name of this codespace.", default=...
    )
    display_name: Missing[Union[str, None]] = Field(
        description="Display name for this codespace.", default=UNSET
    )
    environment_id: Union[str, None] = Field(
        description="UUID identifying this codespace's environment.", default=...
    )
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    billable_owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    repository: FullRepository = Field(
        title="Full Repository", description="Full Repository", default=...
    )
    machine: Union[None, CodespaceMachine] = Field(
        title="Codespace machine",
        description="A description of the machine powering a codespace.",
        default=...,
    )
    devcontainer_path: Missing[Union[str, None]] = Field(
        description="Path to devcontainer.json from repo root used to create Codespace.",
        default=UNSET,
    )
    prebuild: Union[bool, None] = Field(
        description="Whether the codespace was created from a prebuild.", default=...
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    last_used_at: datetime = Field(
        description="Last known time this codespace was started.", default=...
    )
    state: Literal[
        "Unknown",
        "Created",
        "Queued",
        "Provisioning",
        "Available",
        "Awaiting",
        "Unavailable",
        "Deleted",
        "Moved",
        "Shutdown",
        "Archived",
        "Starting",
        "ShuttingDown",
        "Failed",
        "Exporting",
        "Updating",
        "Rebuilding",
    ] = Field(description="State of this codespace.", default=...)
    url: str = Field(description="API URL for this codespace.", default=...)
    git_status: CodespaceWithFullRepositoryPropGitStatus = Field(
        description="Details about the codespace's git repository.", default=...
    )
    location: Literal["EastUs", "SouthEastAsia", "WestEurope", "WestUs2"] = Field(
        description="The initally assigned location of a new codespace.", default=...
    )
    idle_timeout_minutes: Union[int, None] = Field(
        description="The number of minutes of inactivity after which this codespace will be automatically stopped.",
        default=...,
    )
    web_url: str = Field(
        description="URL to access this codespace on the web.", default=...
    )
    machines_url: str = Field(
        description="API URL to access available alternate machine types for this codespace.",
        default=...,
    )
    start_url: str = Field(description="API URL to start this codespace.", default=...)
    stop_url: str = Field(description="API URL to stop this codespace.", default=...)
    publish_url: Missing[Union[str, None]] = Field(
        description="API URL to publish this codespace to a new repository.",
        default=UNSET,
    )
    pulls_url: Union[str, None] = Field(
        description="API URL for the Pull Request associated with this codespace, if any.",
        default=...,
    )
    recent_folders: List[str] = Field(default=...)
    runtime_constraints: Missing[
        CodespaceWithFullRepositoryPropRuntimeConstraints
    ] = Field(default=UNSET)
    pending_operation: Missing[Union[bool, None]] = Field(
        description="Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.",
        default=UNSET,
    )
    pending_operation_disabled_reason: Missing[Union[str, None]] = Field(
        description="Text to show user when codespace is disabled by a pending operation",
        default=UNSET,
    )
    idle_timeout_notice: Missing[Union[str, None]] = Field(
        description="Text to show user when codespace idle timeout minutes has been overriden by an organization policy",
        default=UNSET,
    )
    retention_period_minutes: Missing[Union[int, None]] = Field(
        description="Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).",
        default=UNSET,
    )
    retention_expires_at: Missing[Union[datetime, None]] = Field(
        description='When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"',
        default=UNSET,
    )


class CodespaceWithFullRepositoryPropGitStatus(GitHubRestModel):
    """CodespaceWithFullRepositoryPropGitStatus

    Details about the codespace's git repository.
    """

    ahead: Missing[int] = Field(
        description="The number of commits the local repository is ahead of the remote.",
        default=UNSET,
    )
    behind: Missing[int] = Field(
        description="The number of commits the local repository is behind the remote.",
        default=UNSET,
    )
    has_unpushed_changes: Missing[bool] = Field(
        description="Whether the local repository has unpushed changes.", default=UNSET
    )
    has_uncommitted_changes: Missing[bool] = Field(
        description="Whether the local repository has uncommitted changes.",
        default=UNSET,
    )
    ref: Missing[str] = Field(
        description="The current branch (or SHA if in detached HEAD state) of the local repository.",
        default=UNSET,
    )


class CodespaceWithFullRepositoryPropRuntimeConstraints(GitHubRestModel):
    """CodespaceWithFullRepositoryPropRuntimeConstraints"""

    allowed_port_privacy_settings: Missing[Union[List[str], None]] = Field(
        description="The privacy settings a user can select from when forwarding a port.",
        default=UNSET,
    )


class Email(GitHubRestModel):
    """Email

    Email
    """

    email: str = Field(default=...)
    primary: bool = Field(default=...)
    verified: bool = Field(default=...)
    visibility: Union[str, None] = Field(default=...)


class GpgKey(GitHubRestModel):
    """GPG Key

    A unique encryption key
    """

    id: int = Field(default=...)
    name: Missing[Union[str, None]] = Field(default=UNSET)
    primary_key_id: Union[int, None] = Field(default=...)
    key_id: str = Field(default=...)
    public_key: str = Field(default=...)
    emails: List[GpgKeyPropEmailsItems] = Field(default=...)
    subkeys: List[GpgKeyPropSubkeysItems] = Field(default=...)
    can_sign: bool = Field(default=...)
    can_encrypt_comms: bool = Field(default=...)
    can_encrypt_storage: bool = Field(default=...)
    can_certify: bool = Field(default=...)
    created_at: datetime = Field(default=...)
    expires_at: Union[datetime, None] = Field(default=...)
    revoked: bool = Field(default=...)
    raw_key: Union[str, None] = Field(default=...)


class GpgKeyPropEmailsItems(GitHubRestModel):
    """GpgKeyPropEmailsItems"""

    email: Missing[str] = Field(default=UNSET)
    verified: Missing[bool] = Field(default=UNSET)


class GpgKeyPropSubkeysItems(GitHubRestModel):
    """GpgKeyPropSubkeysItems"""

    id: Missing[int] = Field(default=UNSET)
    primary_key_id: Missing[int] = Field(default=UNSET)
    key_id: Missing[str] = Field(default=UNSET)
    public_key: Missing[str] = Field(default=UNSET)
    emails: Missing[List[GpgKeyPropSubkeysItemsPropEmailsItems]] = Field(default=UNSET)
    subkeys: Missing[List[Any]] = Field(default=UNSET)
    can_sign: Missing[bool] = Field(default=UNSET)
    can_encrypt_comms: Missing[bool] = Field(default=UNSET)
    can_encrypt_storage: Missing[bool] = Field(default=UNSET)
    can_certify: Missing[bool] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    expires_at: Missing[Union[str, None]] = Field(default=UNSET)
    raw_key: Missing[Union[str, None]] = Field(default=UNSET)
    revoked: Missing[bool] = Field(default=UNSET)


class GpgKeyPropSubkeysItemsPropEmailsItems(GitHubRestModel):
    """GpgKeyPropSubkeysItemsPropEmailsItems"""

    email: Missing[str] = Field(default=UNSET)
    verified: Missing[bool] = Field(default=UNSET)


class Key(GitHubRestModel):
    """Key

    Key
    """

    key: str = Field(default=...)
    id: int = Field(default=...)
    url: str = Field(default=...)
    title: str = Field(default=...)
    created_at: datetime = Field(default=...)
    verified: bool = Field(default=...)
    read_only: bool = Field(default=...)


class MarketplaceAccount(GitHubRestModel):
    """Marketplace Account"""

    url: str = Field(default=...)
    id: int = Field(default=...)
    type: str = Field(default=...)
    node_id: Missing[str] = Field(default=UNSET)
    login: str = Field(default=...)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    organization_billing_email: Missing[Union[str, None]] = Field(default=UNSET)


class UserMarketplacePurchase(GitHubRestModel):
    """User Marketplace Purchase

    User Marketplace Purchase
    """

    billing_cycle: str = Field(default=...)
    next_billing_date: Union[datetime, None] = Field(default=...)
    unit_count: Union[int, None] = Field(default=...)
    on_free_trial: bool = Field(default=...)
    free_trial_ends_on: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    account: MarketplaceAccount = Field(title="Marketplace Account", default=...)
    plan: MarketplaceListingPlan = Field(
        title="Marketplace Listing Plan",
        description="Marketplace Listing Plan",
        default=...,
    )


class SocialAccount(GitHubRestModel):
    """Social account

    Social media account
    """

    provider: str = Field(default=...)
    url: str = Field(default=...)


class SshSigningKey(GitHubRestModel):
    """SSH Signing Key

    A public SSH key used to sign Git commits
    """

    key: str = Field(default=...)
    id: int = Field(default=...)
    title: str = Field(default=...)
    created_at: datetime = Field(default=...)


class StarredRepository(GitHubRestModel):
    """Starred Repository

    Starred Repository
    """

    starred_at: datetime = Field(default=...)
    repo: Repository = Field(
        title="Repository", description="A repository on GitHub.", default=...
    )


class Hovercard(GitHubRestModel):
    """Hovercard

    Hovercard
    """

    contexts: List[HovercardPropContextsItems] = Field(default=...)


class HovercardPropContextsItems(GitHubRestModel):
    """HovercardPropContextsItems"""

    message: str = Field(default=...)
    octicon: str = Field(default=...)


class KeySimple(GitHubRestModel):
    """Key Simple

    Key Simple
    """

    id: int = Field(default=...)
    key: str = Field(default=...)


class SimpleInstallation(GitHubRestModel):
    """Simple Installation

    The GitHub App installation. Webhook payloads contain the `installation`
    property when the event is configured
    for and sent to a GitHub App. For more information,
    see "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-
    github-apps/registering-a-github-app/using-webhooks-with-github-apps)."
    """

    id: int = Field(description="The ID of the installation.", default=...)
    node_id: str = Field(
        description="The global node ID of the installation.", default=...
    )


class OrganizationSimpleWebhooks(GitHubRestModel):
    """Organization Simple

    A GitHub organization. Webhook payloads contain the `organization` property when
    the webhook is configured for an
    organization, or when the event occurs from activity in a repository owned by an
    organization.
    """

    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    hooks_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    members_url: str = Field(default=...)
    public_members_url: str = Field(default=...)
    avatar_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)


class RepositoryWebhooks(GitHubRestModel):
    """Repository

    The repository on GitHub where the event occurred. Webhook payloads contain the
    `repository` property
    when the event occurs from activity in a repository.
    """

    id: int = Field(description="Unique identifier of the repository", default=...)
    node_id: str = Field(default=...)
    name: str = Field(description="The name of the repository.", default=...)
    full_name: str = Field(default=...)
    license_: Union[None, LicenseSimple] = Field(
        title="License Simple",
        description="License Simple",
        default=...,
        alias="license",
    )
    organization: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    forks: int = Field(default=...)
    permissions: Missing[RepositoryWebhooksPropPermissions] = Field(default=UNSET)
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    private: bool = Field(
        description="Whether the repository is private or public.", default=False
    )
    html_url: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    fork: bool = Field(default=...)
    url: str = Field(default=...)
    archive_url: str = Field(default=...)
    assignees_url: str = Field(default=...)
    blobs_url: str = Field(default=...)
    branches_url: str = Field(default=...)
    collaborators_url: str = Field(default=...)
    comments_url: str = Field(default=...)
    commits_url: str = Field(default=...)
    compare_url: str = Field(default=...)
    contents_url: str = Field(default=...)
    contributors_url: str = Field(default=...)
    deployments_url: str = Field(default=...)
    downloads_url: str = Field(default=...)
    events_url: str = Field(default=...)
    forks_url: str = Field(default=...)
    git_commits_url: str = Field(default=...)
    git_refs_url: str = Field(default=...)
    git_tags_url: str = Field(default=...)
    git_url: str = Field(default=...)
    issue_comment_url: str = Field(default=...)
    issue_events_url: str = Field(default=...)
    issues_url: str = Field(default=...)
    keys_url: str = Field(default=...)
    labels_url: str = Field(default=...)
    languages_url: str = Field(default=...)
    merges_url: str = Field(default=...)
    milestones_url: str = Field(default=...)
    notifications_url: str = Field(default=...)
    pulls_url: str = Field(default=...)
    releases_url: str = Field(default=...)
    ssh_url: str = Field(default=...)
    stargazers_url: str = Field(default=...)
    statuses_url: str = Field(default=...)
    subscribers_url: str = Field(default=...)
    subscription_url: str = Field(default=...)
    tags_url: str = Field(default=...)
    teams_url: str = Field(default=...)
    trees_url: str = Field(default=...)
    clone_url: str = Field(default=...)
    mirror_url: Union[str, None] = Field(default=...)
    hooks_url: str = Field(default=...)
    svn_url: str = Field(default=...)
    homepage: Union[str, None] = Field(default=...)
    language: Union[str, None] = Field(default=...)
    forks_count: int = Field(default=...)
    stargazers_count: int = Field(default=...)
    watchers_count: int = Field(default=...)
    size: int = Field(
        description="The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.",
        default=...,
    )
    default_branch: str = Field(
        description="The default branch of the repository.", default=...
    )
    open_issues_count: int = Field(default=...)
    is_template: Missing[bool] = Field(
        description="Whether this repository acts as a template that can be used to generate new repositories.",
        default=False,
    )
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: bool = Field(description="Whether issues are enabled.", default=True)
    has_projects: bool = Field(
        description="Whether projects are enabled.", default=True
    )
    has_wiki: bool = Field(description="Whether the wiki is enabled.", default=True)
    has_pages: bool = Field(default=...)
    has_downloads: bool = Field(
        description="Whether downloads are enabled.", default=True
    )
    has_discussions: Missing[bool] = Field(
        description="Whether discussions are enabled.", default=False
    )
    archived: bool = Field(
        description="Whether the repository is archived.", default=False
    )
    disabled: bool = Field(
        description="Returns whether or not this repository disabled.", default=...
    )
    visibility: Missing[str] = Field(
        description="The repository visibility: public, private, or internal.",
        default="public",
    )
    pushed_at: Union[datetime, None] = Field(default=...)
    created_at: Union[datetime, None] = Field(default=...)
    updated_at: Union[datetime, None] = Field(default=...)
    allow_rebase_merge: Missing[bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    template_repository: Missing[
        Union[RepositoryWebhooksPropTemplateRepository, None]
    ] = Field(default=UNSET)
    temp_clone_token: Missing[str] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_auto_merge: Missing[bool] = Field(
        description="Whether to allow Auto-merge to be used on pull requests.",
        default=False,
    )
    delete_branch_on_merge: Missing[bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    allow_update_branch: Missing[bool] = Field(
        description="Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.",
        default=False,
    )
    use_squash_pr_title_as_default: Missing[bool] = Field(
        description="Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.",
        default=False,
    )
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    allow_merge_commit: Missing[bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_forking: Missing[bool] = Field(
        description="Whether to allow forking this repo", default=UNSET
    )
    web_commit_signoff_required: Missing[bool] = Field(
        description="Whether to require contributors to sign off on web-based commits",
        default=False,
    )
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)
    open_issues: int = Field(default=...)
    watchers: int = Field(default=...)
    master_branch: Missing[str] = Field(default=UNSET)
    starred_at: Missing[str] = Field(default=UNSET)
    anonymous_access_enabled: Missing[bool] = Field(
        description="Whether anonymous git access is enabled for this repository",
        default=UNSET,
    )


class RepositoryWebhooksPropPermissions(GitHubRestModel):
    """RepositoryWebhooksPropPermissions"""

    admin: bool = Field(default=...)
    pull: bool = Field(default=...)
    triage: Missing[bool] = Field(default=UNSET)
    push: bool = Field(default=...)
    maintain: Missing[bool] = Field(default=UNSET)


class RepositoryWebhooksPropTemplateRepositoryPropOwner(GitHubRestModel):
    """RepositoryWebhooksPropTemplateRepositoryPropOwner"""

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)


class RepositoryWebhooksPropTemplateRepositoryPropPermissions(GitHubRestModel):
    """RepositoryWebhooksPropTemplateRepositoryPropPermissions"""

    admin: Missing[bool] = Field(default=UNSET)
    maintain: Missing[bool] = Field(default=UNSET)
    push: Missing[bool] = Field(default=UNSET)
    triage: Missing[bool] = Field(default=UNSET)
    pull: Missing[bool] = Field(default=UNSET)


class RepositoryWebhooksPropTemplateRepository(GitHubRestModel):
    """RepositoryWebhooksPropTemplateRepository"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    owner: Missing[RepositoryWebhooksPropTemplateRepositoryPropOwner] = Field(
        default=UNSET
    )
    private: Missing[bool] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    description: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    git_url: Missing[str] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    ssh_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    clone_url: Missing[str] = Field(default=UNSET)
    mirror_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    svn_url: Missing[str] = Field(default=UNSET)
    homepage: Missing[str] = Field(default=UNSET)
    language: Missing[str] = Field(default=UNSET)
    forks_count: Missing[int] = Field(default=UNSET)
    stargazers_count: Missing[int] = Field(default=UNSET)
    watchers_count: Missing[int] = Field(default=UNSET)
    size: Missing[int] = Field(default=UNSET)
    default_branch: Missing[str] = Field(default=UNSET)
    open_issues_count: Missing[int] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: Missing[bool] = Field(default=UNSET)
    has_projects: Missing[bool] = Field(default=UNSET)
    has_wiki: Missing[bool] = Field(default=UNSET)
    has_pages: Missing[bool] = Field(default=UNSET)
    has_downloads: Missing[bool] = Field(default=UNSET)
    archived: Missing[bool] = Field(default=UNSET)
    disabled: Missing[bool] = Field(default=UNSET)
    visibility: Missing[str] = Field(default=UNSET)
    pushed_at: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    permissions: Missing[
        RepositoryWebhooksPropTemplateRepositoryPropPermissions
    ] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    temp_clone_token: Missing[str] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_auto_merge: Missing[bool] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Missing[bool] = Field(default=UNSET)
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)


class SimpleUserWebhooks(GitHubRestModel):
    """Simple User

    The GitHub user that triggered the event. This property is included in every
    webhook payload.
    """

    name: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    login: str = Field(default=...)
    id: int = Field(default=...)
    node_id: str = Field(default=...)
    avatar_url: str = Field(default=...)
    gravatar_id: Union[str, None] = Field(default=...)
    url: str = Field(default=...)
    html_url: str = Field(default=...)
    followers_url: str = Field(default=...)
    following_url: str = Field(default=...)
    gists_url: str = Field(default=...)
    starred_url: str = Field(default=...)
    subscriptions_url: str = Field(default=...)
    organizations_url: str = Field(default=...)
    repos_url: str = Field(default=...)
    events_url: str = Field(default=...)
    received_events_url: str = Field(default=...)
    type: str = Field(default=...)
    site_admin: bool = Field(default=...)
    starred_at: Missing[str] = Field(default=UNSET)


class SimpleCheckSuite(GitHubRestModel):
    """SimpleCheckSuite

    A suite of checks performed on the code of a given code change
    """

    after: Missing[Union[str, None]] = Field(default=UNSET)
    app: Missing[Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=UNSET,
    )
    before: Missing[Union[str, None]] = Field(default=UNSET)
    conclusion: Missing[
        Union[
            None,
            Literal[
                "success",
                "failure",
                "neutral",
                "cancelled",
                "skipped",
                "timed_out",
                "action_required",
                "stale",
                "startup_failure",
            ],
        ]
    ] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(default=UNSET)
    head_branch: Missing[Union[str, None]] = Field(default=UNSET)
    head_sha: Missing[str] = Field(
        description="The SHA of the head commit that is being checked.", default=UNSET
    )
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    pull_requests: Missing[List[PullRequestMinimal]] = Field(default=UNSET)
    repository: Missing[MinimalRepository] = Field(
        title="Minimal Repository", description="Minimal Repository", default=UNSET
    )
    status: Missing[
        Literal["queued", "in_progress", "completed", "pending", "waiting"]
    ] = Field(default=UNSET)
    updated_at: Missing[datetime] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class CheckRunWithSimpleCheckSuite(GitHubRestModel):
    """CheckRun

    A check performed on the code of a given code change
    """

    app: Union[None, Integration] = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
        default=...,
    )
    check_suite: SimpleCheckSuite = Field(
        description="A suite of checks performed on the code of a given code change",
        default=...,
    )
    completed_at: Union[datetime, None] = Field(default=...)
    conclusion: Union[
        None,
        Literal[
            "waiting",
            "pending",
            "startup_failure",
            "stale",
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ] = Field(default=...)
    deployment: Missing[DeploymentSimple] = Field(
        title="Deployment",
        description="A deployment created as the result of an Actions check run from a workflow that references an environment",
        default=UNSET,
    )
    details_url: str = Field(default=...)
    external_id: str = Field(default=...)
    head_sha: str = Field(
        description="The SHA of the commit that is being checked.", default=...
    )
    html_url: str = Field(default=...)
    id: int = Field(description="The id of the check.", default=...)
    name: str = Field(description="The name of the check.", default=...)
    node_id: str = Field(default=...)
    output: CheckRunWithSimpleCheckSuitePropOutput = Field(default=...)
    pull_requests: List[PullRequestMinimal] = Field(default=...)
    started_at: datetime = Field(default=...)
    status: Literal["queued", "in_progress", "completed", "pending"] = Field(
        description="The phase of the lifecycle that the check is currently in.",
        default=...,
    )
    url: str = Field(default=...)


class CheckRunWithSimpleCheckSuitePropOutput(GitHubRestModel):
    """CheckRunWithSimpleCheckSuitePropOutput"""

    annotations_count: int = Field(default=...)
    annotations_url: str = Field(default=...)
    summary: Union[str, None] = Field(default=...)
    text: Union[str, None] = Field(default=...)
    title: Union[str, None] = Field(default=...)


class Discussion(GitHubRestModel):
    """Discussion

    A Discussion in a repository.
    """

    active_lock_reason: Union[str, None] = Field(default=...)
    answer_chosen_at: Union[str, None] = Field(default=...)
    answer_chosen_by: Union[DiscussionPropAnswerChosenBy, None] = Field(
        title="User", default=...
    )
    answer_html_url: Union[str, None] = Field(default=...)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
        default=...,
    )
    body: str = Field(default=...)
    category: DiscussionPropCategory = Field(default=...)
    comments: int = Field(default=...)
    created_at: datetime = Field(default=...)
    html_url: str = Field(default=...)
    id: int = Field(default=...)
    locked: bool = Field(default=...)
    node_id: str = Field(default=...)
    number: int = Field(default=...)
    reactions: Missing[DiscussionPropReactions] = Field(
        title="Reactions", default=UNSET
    )
    repository_url: str = Field(default=...)
    state: Literal["open", "closed", "locked", "converting", "transferring"] = Field(
        description="The current state of the discussion.\n`converting` means that the discussion is being converted from an issue.\n`transferring` means that the discussion is being transferred from another repository.",
        default=...,
    )
    state_reason: Union[
        None, Literal["resolved", "outdated", "duplicate", "reopened"]
    ] = Field(description="The reason for the current state", default=...)
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field(default=...)
    updated_at: datetime = Field(default=...)
    user: Union[DiscussionPropUser, None] = Field(title="User", default=...)


class DiscussionPropAnswerChosenBy(GitHubRestModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class DiscussionPropCategory(GitHubRestModel):
    """DiscussionPropCategory"""

    created_at: datetime = Field(default=...)
    description: str = Field(default=...)
    emoji: str = Field(default=...)
    id: int = Field(default=...)
    is_answerable: bool = Field(default=...)
    name: str = Field(default=...)
    node_id: Missing[str] = Field(default=UNSET)
    repository_id: int = Field(default=...)
    slug: str = Field(default=...)
    updated_at: str = Field(default=...)


class DiscussionPropReactions(GitHubRestModel):
    """Reactions"""

    plus_one: int = Field(default=..., alias="+1")
    minus_one: int = Field(default=..., alias="-1")
    confused: int = Field(default=...)
    eyes: int = Field(default=...)
    heart: int = Field(default=...)
    hooray: int = Field(default=...)
    laugh: int = Field(default=...)
    rocket: int = Field(default=...)
    total_count: int = Field(default=...)
    url: str = Field(default=...)


class DiscussionPropUser(GitHubRestModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(default=...)
    login: str = Field(default=...)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class MergeGroup(GitHubRestModel):
    """Merge Group

    A group of pull requests that the merge queue has grouped together to be merged.
    """

    head_sha: str = Field(description="The SHA of the merge group.", default=...)
    head_ref: str = Field(description="The full ref of the merge group.", default=...)
    base_sha: str = Field(
        description="The SHA of the merge group's parent commit.", default=...
    )
    base_ref: str = Field(
        description="The full ref of the branch the merge group will be merged into.",
        default=...,
    )
    head_commit: SimpleCommit = Field(
        title="Simple Commit", description="A commit.", default=...
    )


class PersonalAccessTokenRequest(GitHubRestModel):
    """Personal Access Token Request

    Details of a Personal Access Token Request.
    """

    id: int = Field(
        description="Unique identifier of the request for access via fine-grained personal access token. Used as the `pat_request_id` parameter in the list and review API calls.",
        default=...,
    )
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    permissions_added: PersonalAccessTokenRequestPropPermissionsAdded = Field(
        description="New requested permissions, categorized by type of permission.",
        default=...,
    )
    permissions_upgraded: PersonalAccessTokenRequestPropPermissionsUpgraded = Field(
        description="Requested permissions that elevate access for a previously approved request for access, categorized by type of permission.",
        default=...,
    )
    permissions_result: PersonalAccessTokenRequestPropPermissionsResult = Field(
        description="Permissions requested, categorized by type of permission. This field incorporates `permissions_added` and `permissions_upgraded`.",
        default=...,
    )
    repository_selection: Literal["none", "all", "subset"] = Field(
        description="Type of repository selection requested.", default=...
    )
    repository_count: Union[int, None] = Field(
        description="The number of repositories the token is requesting access to. This field is only populated when `repository_selection` is `subset`.",
        default=...,
    )
    repositories: Union[
        List[PersonalAccessTokenRequestPropRepositoriesItems], None
    ] = Field(
        description="An array of repository objects the token is requesting access to. This field is only populated when `repository_selection` is `subset`.",
        default=...,
    )
    created_at: str = Field(
        description="Date and time when the request for access was created.",
        default=...,
    )
    token_expired: bool = Field(
        description="Whether the associated fine-grained personal access token has expired.",
        default=...,
    )
    token_expires_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token expires.",
        default=...,
    )
    token_last_used_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token was last used for authentication.",
        default=...,
    )


class PersonalAccessTokenRequestPropPermissionsAdded(GitHubRestModel):
    """PersonalAccessTokenRequestPropPermissionsAdded

    New requested permissions, categorized by type of permission.
    """

    organization: Missing[
        PersonalAccessTokenRequestPropPermissionsAddedPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        PersonalAccessTokenRequestPropPermissionsAddedPropRepository
    ] = Field(default=UNSET)
    other: Missing[PersonalAccessTokenRequestPropPermissionsAddedPropOther] = Field(
        default=UNSET
    )


class PersonalAccessTokenRequestPropPermissionsAddedPropOrganization(
    GitHubRestModel, extra=Extra.allow
):
    """PersonalAccessTokenRequestPropPermissionsAddedPropOrganization"""


class PersonalAccessTokenRequestPropPermissionsAddedPropRepository(
    GitHubRestModel, extra=Extra.allow
):
    """PersonalAccessTokenRequestPropPermissionsAddedPropRepository"""


class PersonalAccessTokenRequestPropPermissionsAddedPropOther(
    GitHubRestModel, extra=Extra.allow
):
    """PersonalAccessTokenRequestPropPermissionsAddedPropOther"""


class PersonalAccessTokenRequestPropPermissionsUpgraded(GitHubRestModel):
    """PersonalAccessTokenRequestPropPermissionsUpgraded

    Requested permissions that elevate access for a previously approved request for
    access, categorized by type of permission.
    """

    organization: Missing[
        PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        PersonalAccessTokenRequestPropPermissionsUpgradedPropRepository
    ] = Field(default=UNSET)
    other: Missing[PersonalAccessTokenRequestPropPermissionsUpgradedPropOther] = Field(
        default=UNSET
    )


class PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganization(
    GitHubRestModel, extra=Extra.allow
):
    """PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganization"""


class PersonalAccessTokenRequestPropPermissionsUpgradedPropRepository(
    GitHubRestModel, extra=Extra.allow
):
    """PersonalAccessTokenRequestPropPermissionsUpgradedPropRepository"""


class PersonalAccessTokenRequestPropPermissionsUpgradedPropOther(
    GitHubRestModel, extra=Extra.allow
):
    """PersonalAccessTokenRequestPropPermissionsUpgradedPropOther"""


class PersonalAccessTokenRequestPropPermissionsResult(GitHubRestModel):
    """PersonalAccessTokenRequestPropPermissionsResult

    Permissions requested, categorized by type of permission. This field
    incorporates `permissions_added` and `permissions_upgraded`.
    """

    organization: Missing[
        PersonalAccessTokenRequestPropPermissionsResultPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        PersonalAccessTokenRequestPropPermissionsResultPropRepository
    ] = Field(default=UNSET)
    other: Missing[PersonalAccessTokenRequestPropPermissionsResultPropOther] = Field(
        default=UNSET
    )


class PersonalAccessTokenRequestPropPermissionsResultPropOrganization(
    GitHubRestModel, extra=Extra.allow
):
    """PersonalAccessTokenRequestPropPermissionsResultPropOrganization"""


class PersonalAccessTokenRequestPropPermissionsResultPropRepository(
    GitHubRestModel, extra=Extra.allow
):
    """PersonalAccessTokenRequestPropPermissionsResultPropRepository"""


class PersonalAccessTokenRequestPropPermissionsResultPropOther(
    GitHubRestModel, extra=Extra.allow
):
    """PersonalAccessTokenRequestPropPermissionsResultPropOther"""


class PersonalAccessTokenRequestPropRepositoriesItems(GitHubRestModel):
    """PersonalAccessTokenRequestPropRepositoriesItems"""

    full_name: str = Field(default=...)
    id: int = Field(description="Unique identifier of the repository", default=...)
    name: str = Field(description="The name of the repository.", default=...)
    node_id: str = Field(default=...)
    private: bool = Field(
        description="Whether the repository is private or public.", default=...
    )


class ProjectsV2(GitHubRestModel):
    """Projects v2 Project

    A projects v2 project
    """

    id: float = Field(default=...)
    node_id: str = Field(default=...)
    owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    creator: SimpleUser = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    title: str = Field(default=...)
    description: Union[str, None] = Field(default=...)
    public: bool = Field(default=...)
    closed_at: Union[datetime, None] = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    number: int = Field(default=...)
    short_description: Union[str, None] = Field(default=...)
    deleted_at: Union[datetime, None] = Field(default=...)
    deleted_by: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )


class ProjectsV2Item(GitHubRestModel):
    """Projects v2 Item

    An item belonging to a project
    """

    id: float = Field(default=...)
    node_id: Missing[str] = Field(default=UNSET)
    project_node_id: Missing[str] = Field(default=UNSET)
    content_node_id: str = Field(default=...)
    content_type: Literal["Issue", "PullRequest", "DraftIssue"] = Field(
        title="Projects v2 Item Content Type",
        description="The type of content tracked in a project item",
        default=...,
    )
    creator: Missing[SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    archived_at: Union[datetime, None] = Field(default=...)


class SecretScanningAlertWebhook(GitHubRestModel):
    """SecretScanningAlertWebhook"""

    number: Missing[int] = Field(
        description="The security alert number.", default=UNSET
    )
    created_at: Missing[datetime] = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    updated_at: Missing[Union[None, datetime]] = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    url: Missing[str] = Field(
        description="The REST API URL of the alert resource.", default=UNSET
    )
    html_url: Missing[str] = Field(
        description="The GitHub URL of the alert resource.", default=UNSET
    )
    locations_url: Missing[str] = Field(
        description="The REST API URL of the code locations for this alert.",
        default=UNSET,
    )
    resolution: Missing[
        Union[
            None,
            Literal[
                "false_positive",
                "wont_fix",
                "revoked",
                "used_in_tests",
                "pattern_deleted",
                "pattern_edited",
            ],
        ]
    ] = Field(description="The reason for resolving the alert.", default=UNSET)
    resolved_at: Missing[Union[datetime, None]] = Field(
        description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    resolved_by: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    resolution_comment: Missing[Union[str, None]] = Field(
        description="An optional comment to resolve an alert.", default=UNSET
    )
    secret_type: Missing[str] = Field(
        description="The type of secret that secret scanning detected.", default=UNSET
    )
    push_protection_bypassed: Missing[Union[bool, None]] = Field(
        description="Whether push protection was bypassed for the detected secret.",
        default=UNSET,
    )
    push_protection_bypassed_by: Missing[Union[None, SimpleUser]] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    push_protection_bypassed_at: Missing[Union[datetime, None]] = Field(
        description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )


class AppManifestsCodeConversionsPostResponse201(GitHubRestModel):
    """AppManifestsCodeConversionsPostResponse201"""

    id: int = Field(description="Unique identifier of the GitHub app", default=...)
    slug: Missing[str] = Field(
        description="The slug name of the GitHub app", default=UNSET
    )
    node_id: str = Field(default=...)
    owner: Union[None, SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=...
    )
    name: str = Field(description="The name of the GitHub app", default=...)
    description: Union[str, None] = Field(default=...)
    external_url: str = Field(default=...)
    html_url: str = Field(default=...)
    created_at: datetime = Field(default=...)
    updated_at: datetime = Field(default=...)
    permissions: IntegrationPropPermissions = Field(
        description="The set of permissions for the GitHub app", default=...
    )
    events: List[str] = Field(
        description="The list of events for the GitHub app", default=...
    )
    installations_count: Missing[int] = Field(
        description="The number of installations associated with the GitHub app",
        default=UNSET,
    )
    client_id: str = Field(default=...)
    client_secret: str = Field(default=...)
    webhook_secret: Union[Union[str, None], None] = Field(default=...)
    pem: str = Field(default=...)


class AppManifestsCodeConversionsPostResponse201Allof1(
    GitHubRestModel, extra=Extra.allow
):
    """AppManifestsCodeConversionsPostResponse201Allof1"""

    client_id: str = Field(default=...)
    client_secret: str = Field(default=...)
    webhook_secret: Union[str, None] = Field(default=...)
    pem: str = Field(default=...)


class AppHookConfigPatchBody(GitHubRestModel):
    """AppHookConfigPatchBody"""

    url: Missing[str] = Field(
        description="The URL to which the payloads will be delivered.", default=UNSET
    )
    content_type: Missing[str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    insecure_ssl: Missing[Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )


class AppHookDeliveriesDeliveryIdAttemptsPostResponse202(GitHubRestModel):
    """AppHookDeliveriesDeliveryIdAttemptsPostResponse202"""


class AppInstallationsInstallationIdAccessTokensPostBody(GitHubRestModel):
    """AppInstallationsInstallationIdAccessTokensPostBody"""

    repositories: Missing[List[str]] = Field(
        description="List of repository names that the token should have access to",
        default=UNSET,
    )
    repository_ids: Missing[List[int]] = Field(
        description="List of repository IDs that the token should have access to",
        default=UNSET,
    )
    permissions: Missing[AppPermissions] = Field(
        title="App Permissions",
        description="The permissions granted to the user access token.",
        default=UNSET,
    )


class ApplicationsClientIdGrantDeleteBody(GitHubRestModel):
    """ApplicationsClientIdGrantDeleteBody"""

    access_token: str = Field(
        description="The OAuth access token used to authenticate to the GitHub API.",
        default=...,
    )


class ApplicationsClientIdTokenPostBody(GitHubRestModel):
    """ApplicationsClientIdTokenPostBody"""

    access_token: str = Field(
        description="The access_token of the OAuth or GitHub application.", default=...
    )


class ApplicationsClientIdTokenDeleteBody(GitHubRestModel):
    """ApplicationsClientIdTokenDeleteBody"""

    access_token: str = Field(
        description="The OAuth access token used to authenticate to the GitHub API.",
        default=...,
    )


class ApplicationsClientIdTokenPatchBody(GitHubRestModel):
    """ApplicationsClientIdTokenPatchBody"""

    access_token: str = Field(
        description="The access_token of the OAuth or GitHub application.", default=...
    )


class ApplicationsClientIdTokenScopedPostBody(GitHubRestModel):
    """ApplicationsClientIdTokenScopedPostBody"""

    access_token: str = Field(
        description="The access token used to authenticate to the GitHub API.",
        default=...,
    )
    target: Missing[str] = Field(
        description="The name of the user or organization to scope the user access token to. **Required** unless `target_id` is specified.",
        default=UNSET,
    )
    target_id: Missing[int] = Field(
        description="The ID of the user or organization to scope the user access token to. **Required** unless `target` is specified.",
        default=UNSET,
    )
    repositories: Missing[List[str]] = Field(
        description="The list of repository names to scope the user access token to. `repositories` may not be specified if `repository_ids` is specified.",
        default=UNSET,
    )
    repository_ids: Missing[List[int]] = Field(
        description="The list of repository IDs to scope the user access token to. `repository_ids` may not be specified if `repositories` is specified.",
        default=UNSET,
    )
    permissions: Missing[AppPermissions] = Field(
        title="App Permissions",
        description="The permissions granted to the user access token.",
        default=UNSET,
    )


class EmojisGetResponse200(GitHubRestModel, extra=Extra.allow):
    """EmojisGetResponse200"""


class EnterprisesEnterpriseSecretScanningAlertsGetResponse503(GitHubRestModel):
    """EnterprisesEnterpriseSecretScanningAlertsGetResponse503"""

    code: Missing[str] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)


class GistsPostBody(GitHubRestModel):
    """GistsPostBody"""

    description: Missing[str] = Field(
        description="Description of the gist", default=UNSET
    )
    files: GistsPostBodyPropFiles = Field(
        description="Names and content for the files that make up the gist", default=...
    )
    public: Missing[Union[bool, Literal["true", "false"]]] = Field(
        description="Flag indicating whether the gist is public", default="false"
    )


class GistsPostBodyPropFiles(GitHubRestModel, extra=Extra.allow):
    """GistsPostBodyPropFiles

    Names and content for the files that make up the gist

    Examples:
        {'hello.rb': {'content': 'puts "Hello, World!"'}}
    """


class GistsGistIdGetResponse403(GitHubRestModel):
    """GistsGistIdGetResponse403"""

    block: Missing[GistsGistIdGetResponse403PropBlock] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)


class GistsGistIdGetResponse403PropBlock(GitHubRestModel):
    """GistsGistIdGetResponse403PropBlock"""

    reason: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    html_url: Missing[Union[str, None]] = Field(default=UNSET)


class GistsGistIdPatchBodyPropFiles(GitHubRestModel, extra=Extra.allow):
    """GistsGistIdPatchBodyPropFiles

    The gist files to be updated, renamed, or deleted. Each `key` must match the
    current filename
    (including extension) of the targeted gist file. For example: `hello.py`.

    To delete a file, set the whole file to null. For example: `hello.py : null`.
    The file will also be
    deleted if the specified object does not contain at least one of `content` or
    `filename`.

    Examples:
        {'hello.rb': {'content': 'blah', 'filename': 'goodbye.rb'}}
    """


class GistsGistIdPatchBody(GitHubRestModel):
    """GistsGistIdPatchBody"""

    description: Missing[str] = Field(
        description="The description of the gist.", default=UNSET
    )
    files: Missing[GistsGistIdPatchBodyPropFiles] = Field(
        description="The gist files to be updated, renamed, or deleted. Each `key` must match the current filename\n(including extension) of the targeted gist file. For example: `hello.py`.\n\nTo delete a file, set the whole file to null. For example: `hello.py : null`. The file will also be\ndeleted if the specified object does not contain at least one of `content` or `filename`.",
        default=UNSET,
    )


class GistsGistIdCommentsPostBody(GitHubRestModel):
    """GistsGistIdCommentsPostBody"""

    body: str = Field(description="The comment text.", max_length=65535, default=...)


class GistsGistIdCommentsCommentIdPatchBody(GitHubRestModel):
    """GistsGistIdCommentsCommentIdPatchBody"""

    body: str = Field(description="The comment text.", max_length=65535, default=...)


class GistsGistIdStarGetResponse404(GitHubRestModel):
    """GistsGistIdStarGetResponse404"""


class InstallationRepositoriesGetResponse200(GitHubRestModel):
    """InstallationRepositoriesGetResponse200"""

    total_count: int = Field(default=...)
    repositories: List[Repository] = Field(default=...)
    repository_selection: Missing[str] = Field(default=UNSET)


class MarkdownPostBody(GitHubRestModel):
    """MarkdownPostBody"""

    text: str = Field(description="The Markdown text to render in HTML.", default=...)
    mode: Missing[Literal["markdown", "gfm"]] = Field(
        description="The rendering mode.", default="markdown"
    )
    context: Missing[str] = Field(
        description="The repository context to use when creating references in `gfm` mode.  For example, setting `context` to `octo-org/octo-repo` will change the text `#42` into an HTML link to issue 42 in the `octo-org/octo-repo` repository.",
        default=UNSET,
    )


class NotificationsPutBody(GitHubRestModel):
    """NotificationsPutBody"""

    last_read_at: Missing[datetime] = Field(
        description="Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.",
        default=UNSET,
    )
    read: Missing[bool] = Field(
        description="Whether the notification has been read.", default=UNSET
    )


class NotificationsPutResponse202(GitHubRestModel):
    """NotificationsPutResponse202"""

    message: Missing[str] = Field(default=UNSET)


class NotificationsThreadsThreadIdSubscriptionPutBody(GitHubRestModel):
    """NotificationsThreadsThreadIdSubscriptionPutBody"""

    ignored: Missing[bool] = Field(
        description="Whether to block all notifications from a thread.", default=False
    )


class OrgsOrgPatchBody(GitHubRestModel):
    """OrgsOrgPatchBody"""

    billing_email: Missing[str] = Field(
        description="Billing email address. This address is not publicized.",
        default=UNSET,
    )
    company: Missing[str] = Field(description="The company name.", default=UNSET)
    email: Missing[str] = Field(
        description="The publicly visible email address.", default=UNSET
    )
    twitter_username: Missing[str] = Field(
        description="The Twitter username of the company.", default=UNSET
    )
    location: Missing[str] = Field(description="The location.", default=UNSET)
    name: Missing[str] = Field(
        description="The shorthand name of the company.", default=UNSET
    )
    description: Missing[str] = Field(
        description="The description of the company.", default=UNSET
    )
    has_organization_projects: Missing[bool] = Field(
        description="Whether an organization can use organization projects.",
        default=UNSET,
    )
    has_repository_projects: Missing[bool] = Field(
        description="Whether repositories that belong to the organization can use repository projects.",
        default=UNSET,
    )
    default_repository_permission: Missing[
        Literal["read", "write", "admin", "none"]
    ] = Field(
        description="Default permission level members have for organization repositories.",
        default="read",
    )
    members_can_create_repositories: Missing[bool] = Field(
        description="Whether of non-admin organization members can create repositories. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.",
        default=True,
    )
    members_can_create_internal_repositories: Missing[bool] = Field(
        description='Whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.',
        default=UNSET,
    )
    members_can_create_private_repositories: Missing[bool] = Field(
        description='Whether organization members can create private repositories, which are visible to organization members with permission. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.',
        default=UNSET,
    )
    members_can_create_public_repositories: Missing[bool] = Field(
        description='Whether organization members can create public repositories, which are visible to anyone. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.',
        default=UNSET,
    )
    members_allowed_repository_creation_type: Missing[
        Literal["all", "private", "none"]
    ] = Field(
        description="Specifies which types of repositories non-admin organization members can create. `private` is only available to repositories that are part of an organization on GitHub Enterprise Cloud. \n**Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See the parameter deprecation notice in the operation description for details.",
        default=UNSET,
    )
    members_can_create_pages: Missing[bool] = Field(
        description="Whether organization members can create GitHub Pages sites. Existing published sites will not be impacted.",
        default=True,
    )
    members_can_create_public_pages: Missing[bool] = Field(
        description="Whether organization members can create public GitHub Pages sites. Existing published sites will not be impacted.",
        default=True,
    )
    members_can_create_private_pages: Missing[bool] = Field(
        description="Whether organization members can create private GitHub Pages sites. Existing published sites will not be impacted.",
        default=True,
    )
    members_can_fork_private_repositories: Missing[bool] = Field(
        description="Whether organization members can fork private organization repositories.",
        default=False,
    )
    web_commit_signoff_required: Missing[bool] = Field(
        description="Whether contributors to organization repositories are required to sign off on commits they make through GitHub's web interface.",
        default=False,
    )
    blog: Missing[str] = Field(default=UNSET)
    advanced_security_enabled_for_new_repositories: Missing[bool] = Field(
        description='Whether GitHub Advanced Security is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.',
        default=UNSET,
    )
    dependabot_alerts_enabled_for_new_repositories: Missing[bool] = Field(
        description='Whether Dependabot alerts is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.',
        default=UNSET,
    )
    dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = Field(
        description='Whether Dependabot security updates is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.',
        default=UNSET,
    )
    dependency_graph_enabled_for_new_repositories: Missing[bool] = Field(
        description='Whether dependency graph is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.',
        default=UNSET,
    )
    secret_scanning_enabled_for_new_repositories: Missing[bool] = Field(
        description='Whether secret scanning is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.',
        default=UNSET,
    )
    secret_scanning_push_protection_enabled_for_new_repositories: Missing[bool] = Field(
        description='Whether secret scanning push protection is automatically enabled for new repositories.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."\n\nYou can check which security and analysis features are currently enabled by using a `GET /orgs/{org}` request.',
        default=UNSET,
    )
    secret_scanning_push_protection_custom_link_enabled: Missing[bool] = Field(
        description="Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.",
        default=UNSET,
    )
    secret_scanning_push_protection_custom_link: Missing[str] = Field(
        description="If `secret_scanning_push_protection_custom_link_enabled` is true, the URL that will be displayed to contributors who are blocked from pushing a secret.",
        default=UNSET,
    )


class OrgsOrgActionsCacheUsageByRepositoryGetResponse200(GitHubRestModel):
    """OrgsOrgActionsCacheUsageByRepositoryGetResponse200"""

    total_count: int = Field(default=...)
    repository_cache_usages: List[ActionsCacheUsageByRepository] = Field(default=...)


class OrgsOrgActionsPermissionsPutBody(GitHubRestModel):
    """OrgsOrgActionsPermissionsPutBody"""

    enabled_repositories: Literal["all", "none", "selected"] = Field(
        description="The policy that controls the repositories in the organization that are allowed to run GitHub Actions.",
        default=...,
    )
    allowed_actions: Missing[Literal["all", "local_only", "selected"]] = Field(
        description="The permissions policy that controls the actions and reusable workflows that are allowed to run.",
        default=UNSET,
    )


class OrgsOrgActionsPermissionsRepositoriesGetResponse200(GitHubRestModel):
    """OrgsOrgActionsPermissionsRepositoriesGetResponse200"""

    total_count: float = Field(default=...)
    repositories: List[Repository] = Field(default=...)


class OrgsOrgActionsPermissionsRepositoriesPutBody(GitHubRestModel):
    """OrgsOrgActionsPermissionsRepositoriesPutBody"""

    selected_repository_ids: List[int] = Field(
        description="List of repository IDs to enable for GitHub Actions.", default=...
    )


class OrgsOrgActionsRunnersGetResponse200(GitHubRestModel):
    """OrgsOrgActionsRunnersGetResponse200"""

    total_count: int = Field(default=...)
    runners: List[Runner] = Field(default=...)


class OrgsOrgActionsRunnersGenerateJitconfigPostBody(GitHubRestModel):
    """OrgsOrgActionsRunnersGenerateJitconfigPostBody"""

    name: str = Field(description="The name of the new runner.", default=...)
    runner_group_id: int = Field(
        description="The ID of the runner group to register the runner to.", default=...
    )
    labels: List[str] = Field(
        description="The names of the custom labels to add to the runner. **Minimum items**: 1. **Maximum items**: 100.",
        max_length=100,
        min_length=1,
        default=...,
    )
    work_folder: Missing[str] = Field(
        description="The working directory to be used for job execution, relative to the runner install directory.",
        default="_work",
    )


class OrgsOrgActionsRunnersGenerateJitconfigPostResponse201(GitHubRestModel):
    """OrgsOrgActionsRunnersGenerateJitconfigPostResponse201"""

    runner: Runner = Field(
        title="Self hosted runners", description="A self hosted runner", default=...
    )
    encoded_jit_config: str = Field(
        description="The base64 encoded runner configuration.", default=...
    )


class OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200(GitHubRestModel):
    """OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200"""

    total_count: int = Field(default=...)
    labels: List[RunnerLabel] = Field(default=...)


class OrgsOrgActionsRunnersRunnerIdLabelsPutBody(GitHubRestModel):
    """OrgsOrgActionsRunnersRunnerIdLabelsPutBody"""

    labels: List[str] = Field(
        description="The names of the custom labels to set for the runner. You can pass an empty array to remove all custom labels.",
        max_length=100,
        default=...,
    )


class OrgsOrgActionsRunnersRunnerIdLabelsPostBody(GitHubRestModel):
    """OrgsOrgActionsRunnersRunnerIdLabelsPostBody"""

    labels: List[str] = Field(
        description="The names of the custom labels to add to the runner.",
        max_length=100,
        min_length=1,
        default=...,
    )


class OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200(GitHubRestModel):
    """OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200"""

    total_count: int = Field(default=...)
    labels: List[RunnerLabel] = Field(default=...)


class OrgsOrgActionsSecretsGetResponse200(GitHubRestModel):
    """OrgsOrgActionsSecretsGetResponse200"""

    total_count: int = Field(default=...)
    secrets: List[OrganizationActionsSecret] = Field(default=...)


class OrgsOrgActionsSecretsSecretNamePutBody(GitHubRestModel):
    """OrgsOrgActionsSecretsSecretNamePutBody"""

    encrypted_value: Missing[
        Annotated[
            str,
            Field(
                pattern="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$"
            ),
        ]
    ] = Field(
        description="Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/actions/secrets#get-an-organization-public-key) endpoint.",
        default=UNSET,
    )
    key_id: Missing[str] = Field(
        description="ID of the key you used to encrypt the secret.", default=UNSET
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.",
        default=...,
    )
    selected_repository_ids: Missing[List[int]] = Field(
        description="An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/actions/secrets#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/actions/secrets#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/actions/secrets#remove-selected-repository-from-an-organization-secret) endpoints.",
        default=UNSET,
    )


class OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200(GitHubRestModel):
    """OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200"""

    total_count: int = Field(default=...)
    repositories: List[MinimalRepository] = Field(default=...)


class OrgsOrgActionsSecretsSecretNameRepositoriesPutBody(GitHubRestModel):
    """OrgsOrgActionsSecretsSecretNameRepositoriesPutBody"""

    selected_repository_ids: List[int] = Field(
        description="An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Add selected repository to an organization secret](https://docs.github.com/rest/actions/secrets#add-selected-repository-to-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/actions/secrets#remove-selected-repository-from-an-organization-secret) endpoints.",
        default=...,
    )


class OrgsOrgActionsVariablesGetResponse200(GitHubRestModel):
    """OrgsOrgActionsVariablesGetResponse200"""

    total_count: int = Field(default=...)
    variables: List[OrganizationActionsVariable] = Field(default=...)


class OrgsOrgActionsVariablesPostBody(GitHubRestModel):
    """OrgsOrgActionsVariablesPostBody"""

    name: str = Field(description="The name of the variable.", default=...)
    value: str = Field(description="The value of the variable.", default=...)
    visibility: Literal["all", "private", "selected"] = Field(
        description="The type of repositories in the organization that can access the variable. `selected` means only the repositories specified by `selected_repository_ids` can access the variable.",
        default=...,
    )
    selected_repository_ids: Missing[List[int]] = Field(
        description="An array of repository ids that can access the organization variable. You can only provide a list of repository ids when the `visibility` is set to `selected`.",
        default=UNSET,
    )


class OrgsOrgActionsVariablesNamePatchBody(GitHubRestModel):
    """OrgsOrgActionsVariablesNamePatchBody"""

    name: Missing[str] = Field(description="The name of the variable.", default=UNSET)
    value: Missing[str] = Field(description="The value of the variable.", default=UNSET)
    visibility: Missing[Literal["all", "private", "selected"]] = Field(
        description="The type of repositories in the organization that can access the variable. `selected` means only the repositories specified by `selected_repository_ids` can access the variable.",
        default=UNSET,
    )
    selected_repository_ids: Missing[List[int]] = Field(
        description="An array of repository ids that can access the organization variable. You can only provide a list of repository ids when the `visibility` is set to `selected`.",
        default=UNSET,
    )


class OrgsOrgActionsVariablesNameRepositoriesGetResponse200(GitHubRestModel):
    """OrgsOrgActionsVariablesNameRepositoriesGetResponse200"""

    total_count: int = Field(default=...)
    repositories: List[MinimalRepository] = Field(default=...)


class OrgsOrgActionsVariablesNameRepositoriesPutBody(GitHubRestModel):
    """OrgsOrgActionsVariablesNameRepositoriesPutBody"""

    selected_repository_ids: List[int] = Field(
        description="The IDs of the repositories that can access the organization variable.",
        default=...,
    )


class OrgsOrgCodespacesGetResponse200(GitHubRestModel):
    """OrgsOrgCodespacesGetResponse200"""

    total_count: int = Field(default=...)
    codespaces: List[Codespace] = Field(default=...)


class OrgsOrgCodespacesAccessPutBody(GitHubRestModel):
    """OrgsOrgCodespacesAccessPutBody"""

    visibility: Literal[
        "disabled",
        "selected_members",
        "all_members",
        "all_members_and_outside_collaborators",
    ] = Field(
        description="Which users can access codespaces in the organization. `disabled` means that no users can access codespaces in the organization.",
        default=...,
    )
    selected_usernames: Missing[Annotated[List[str], Field(max_length=100)]] = Field(
        description="The usernames of the organization members who should have access to codespaces in the organization. Required when `visibility` is `selected_members`. The provided list of usernames will replace any existing value.",
        default=UNSET,
    )


class OrgsOrgCodespacesAccessSelectedUsersPostBody(GitHubRestModel):
    """OrgsOrgCodespacesAccessSelectedUsersPostBody"""

    selected_usernames: List[str] = Field(
        description="The usernames of the organization members whose codespaces be billed to the organization.",
        max_length=100,
        default=...,
    )


class OrgsOrgCodespacesAccessSelectedUsersDeleteBody(GitHubRestModel):
    """OrgsOrgCodespacesAccessSelectedUsersDeleteBody"""

    selected_usernames: List[str] = Field(
        description="The usernames of the organization members whose codespaces should not be billed to the organization.",
        max_length=100,
        default=...,
    )


class OrgsOrgCodespacesSecretsGetResponse200(GitHubRestModel):
    """OrgsOrgCodespacesSecretsGetResponse200"""

    total_count: int = Field(default=...)
    secrets: List[CodespacesOrgSecret] = Field(default=...)


class OrgsOrgCodespacesSecretsSecretNamePutBody(GitHubRestModel):
    """OrgsOrgCodespacesSecretsSecretNamePutBody"""

    encrypted_value: Missing[
        Annotated[
            str,
            Field(
                pattern="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$"
            ),
        ]
    ] = Field(
        description="The value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/codespaces/organization-secrets#get-an-organization-public-key) endpoint.",
        default=UNSET,
    )
    key_id: Missing[str] = Field(
        description="The ID of the key you used to encrypt the secret.", default=UNSET
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.",
        default=...,
    )
    selected_repository_ids: Missing[List[int]] = Field(
        description="An array of repository IDs that can access the organization secret. You can only provide a list of repository IDs when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#remove-selected-repository-from-an-organization-secret) endpoints.",
        default=UNSET,
    )


class OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200(GitHubRestModel):
    """OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200"""

    total_count: int = Field(default=...)
    repositories: List[MinimalRepository] = Field(default=...)


class OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody(GitHubRestModel):
    """OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody"""

    selected_repository_ids: List[int] = Field(
        description="An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/codespaces/organization-secrets#remove-selected-repository-from-an-organization-secret) endpoints.",
        default=...,
    )


class OrgsOrgCopilotBillingSeatsGetResponse200(GitHubRestModel):
    """OrgsOrgCopilotBillingSeatsGetResponse200"""

    total_seats: Missing[int] = Field(
        description="Total number of Copilot For Business seats for the organization currently being billed.",
        default=UNSET,
    )
    seats: Missing[List[CopilotSeatDetails]] = Field(default=UNSET)


class OrgsOrgCopilotBillingSelectedTeamsPostBody(GitHubRestModel):
    """OrgsOrgCopilotBillingSelectedTeamsPostBody"""

    selected_teams: List[str] = Field(
        description="List of team names within the organization to which to grant access to GitHub Copilot.",
        min_length=1,
        default=...,
    )


class OrgsOrgCopilotBillingSelectedTeamsPostResponse201(GitHubRestModel):
    """OrgsOrgCopilotBillingSelectedTeamsPostResponse201

    The total number of seat assignments created.
    """

    seats_created: int = Field(default=...)


class OrgsOrgCopilotBillingSelectedTeamsDeleteBody(GitHubRestModel):
    """OrgsOrgCopilotBillingSelectedTeamsDeleteBody"""

    selected_teams: List[str] = Field(
        description="The names of teams from which to revoke access to GitHub Copilot.",
        min_length=1,
        default=...,
    )


class OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200(GitHubRestModel):
    """OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200

    The total number of seat assignments cancelled.
    """

    seats_cancelled: int = Field(default=...)


class OrgsOrgCopilotBillingSelectedUsersPostBody(GitHubRestModel):
    """OrgsOrgCopilotBillingSelectedUsersPostBody"""

    selected_usernames: List[str] = Field(
        description="The usernames of the organization members to be granted access to GitHub Copilot.",
        min_length=1,
        default=...,
    )


class OrgsOrgCopilotBillingSelectedUsersPostResponse201(GitHubRestModel):
    """OrgsOrgCopilotBillingSelectedUsersPostResponse201

    The total number of seat assignments created.
    """

    seats_created: int = Field(default=...)


class OrgsOrgCopilotBillingSelectedUsersDeleteBody(GitHubRestModel):
    """OrgsOrgCopilotBillingSelectedUsersDeleteBody"""

    selected_usernames: List[str] = Field(
        description="The usernames of the organization members for which to revoke access to GitHub Copilot.",
        min_length=1,
        default=...,
    )


class OrgsOrgCopilotBillingSelectedUsersDeleteResponse200(GitHubRestModel):
    """OrgsOrgCopilotBillingSelectedUsersDeleteResponse200

    The total number of seat assignments cancelled.
    """

    seats_cancelled: int = Field(default=...)


class OrgsOrgDependabotSecretsGetResponse200(GitHubRestModel):
    """OrgsOrgDependabotSecretsGetResponse200"""

    total_count: int = Field(default=...)
    secrets: List[OrganizationDependabotSecret] = Field(default=...)


class OrgsOrgDependabotSecretsSecretNamePutBody(GitHubRestModel):
    """OrgsOrgDependabotSecretsSecretNamePutBody"""

    encrypted_value: Missing[
        Annotated[
            str,
            Field(
                pattern="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$"
            ),
        ]
    ] = Field(
        description="Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/dependabot/secrets#get-an-organization-public-key) endpoint.",
        default=UNSET,
    )
    key_id: Missing[str] = Field(
        description="ID of the key you used to encrypt the secret.", default=UNSET
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret.",
        default=...,
    )
    selected_repository_ids: Missing[List[str]] = Field(
        description="An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret) endpoints.",
        default=UNSET,
    )


class OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200(GitHubRestModel):
    """OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200"""

    total_count: int = Field(default=...)
    repositories: List[MinimalRepository] = Field(default=...)


class OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody(GitHubRestModel):
    """OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody"""

    selected_repository_ids: List[int] = Field(
        description="An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret) endpoints.",
        default=...,
    )


class OrgsOrgHooksPostBody(GitHubRestModel):
    """OrgsOrgHooksPostBody"""

    name: str = Field(description='Must be passed as "web".', default=...)
    config: OrgsOrgHooksPostBodyPropConfig = Field(
        description="Key/value pairs to provide settings for this webhook.", default=...
    )
    events: Missing[List[str]] = Field(
        description='Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for. Set to `["*"]` to receive all possible events.',
        default=["push"],
    )
    active: Missing[bool] = Field(
        description="Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.",
        default=True,
    )


class OrgsOrgHooksPostBodyPropConfig(GitHubRestModel):
    """OrgsOrgHooksPostBodyPropConfig

    Key/value pairs to provide settings for this webhook.
    """

    url: str = Field(
        description="The URL to which the payloads will be delivered.", default=...
    )
    content_type: Missing[str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    insecure_ssl: Missing[Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )
    username: Missing[str] = Field(default=UNSET)
    password: Missing[str] = Field(default=UNSET)


class OrgsOrgHooksHookIdPatchBody(GitHubRestModel):
    """OrgsOrgHooksHookIdPatchBody"""

    config: Missing[OrgsOrgHooksHookIdPatchBodyPropConfig] = Field(
        description="Key/value pairs to provide settings for this webhook.",
        default=UNSET,
    )
    events: Missing[List[str]] = Field(
        description="Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.",
        default=["push"],
    )
    active: Missing[bool] = Field(
        description="Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.",
        default=True,
    )
    name: Missing[str] = Field(default=UNSET)


class OrgsOrgHooksHookIdPatchBodyPropConfig(GitHubRestModel):
    """OrgsOrgHooksHookIdPatchBodyPropConfig

    Key/value pairs to provide settings for this webhook.
    """

    url: str = Field(
        description="The URL to which the payloads will be delivered.", default=...
    )
    content_type: Missing[str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    insecure_ssl: Missing[Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )


class OrgsOrgHooksHookIdConfigPatchBody(GitHubRestModel):
    """OrgsOrgHooksHookIdConfigPatchBody"""

    url: Missing[str] = Field(
        description="The URL to which the payloads will be delivered.", default=UNSET
    )
    content_type: Missing[str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    insecure_ssl: Missing[Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )


class OrgsOrgInstallationsGetResponse200(GitHubRestModel):
    """OrgsOrgInstallationsGetResponse200"""

    total_count: int = Field(default=...)
    installations: List[Installation] = Field(default=...)


class OrgsOrgInteractionLimitsGetResponse200Anyof1(GitHubRestModel):
    """OrgsOrgInteractionLimitsGetResponse200Anyof1"""


class OrgsOrgInvitationsPostBody(GitHubRestModel):
    """OrgsOrgInvitationsPostBody"""

    invitee_id: Missing[int] = Field(
        description="**Required unless you provide `email`**. GitHub user ID for the person you are inviting.",
        default=UNSET,
    )
    email: Missing[str] = Field(
        description="**Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.",
        default=UNSET,
    )
    role: Missing[Literal["admin", "direct_member", "billing_manager"]] = Field(
        description="The role for the new member. \n * `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.  \n * `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.  \n * `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.",
        default="direct_member",
    )
    team_ids: Missing[List[int]] = Field(
        description="Specify IDs for the teams you want to invite new members to.",
        default=UNSET,
    )


class OrgsOrgMembersUsernameCodespacesGetResponse200(GitHubRestModel):
    """OrgsOrgMembersUsernameCodespacesGetResponse200"""

    total_count: int = Field(default=...)
    codespaces: List[Codespace] = Field(default=...)


class OrgsOrgMembershipsUsernamePutBody(GitHubRestModel):
    """OrgsOrgMembershipsUsernamePutBody"""

    role: Missing[Literal["admin", "member"]] = Field(
        description="The role to give the user in the organization. Can be one of:  \n * `admin` - The user will become an owner of the organization.  \n * `member` - The user will become a non-owner member of the organization.",
        default="member",
    )


class OrgsOrgMigrationsPostBody(GitHubRestModel):
    """OrgsOrgMigrationsPostBody"""

    repositories: List[str] = Field(
        description="A list of arrays indicating which repositories should be migrated.",
        default=...,
    )
    lock_repositories: Missing[bool] = Field(
        description="Indicates whether repositories should be locked (to prevent manipulation) while migrating data.",
        default=False,
    )
    exclude_metadata: Missing[bool] = Field(
        description="Indicates whether metadata should be excluded and only git source should be included for the migration.",
        default=False,
    )
    exclude_git_data: Missing[bool] = Field(
        description="Indicates whether the repository git data should be excluded from the migration.",
        default=False,
    )
    exclude_attachments: Missing[bool] = Field(
        description="Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).",
        default=False,
    )
    exclude_releases: Missing[bool] = Field(
        description="Indicates whether releases should be excluded from the migration (to reduce migration archive file size).",
        default=False,
    )
    exclude_owner_projects: Missing[bool] = Field(
        description="Indicates whether projects owned by the organization or users should be excluded. from the migration.",
        default=False,
    )
    org_metadata_only: Missing[bool] = Field(
        description="Indicates whether this should only include organization metadata (repositories array should be empty and will ignore other flags).",
        default=False,
    )
    exclude: Missing[List[Literal["repositories"]]] = Field(
        description='Exclude related items from being returned in the response in order to improve performance of the request. The array can include any of: `"repositories"`.',
        default=UNSET,
    )


class OrgsOrgOutsideCollaboratorsUsernamePutBody(GitHubRestModel):
    """OrgsOrgOutsideCollaboratorsUsernamePutBody"""

    async_: Missing[bool] = Field(
        description="When set to `true`, the request will be performed asynchronously. Returns a 202 status code when the job is successfully queued.",
        default=False,
        alias="async",
    )


class OrgsOrgOutsideCollaboratorsUsernamePutResponse202(GitHubRestModel):
    """OrgsOrgOutsideCollaboratorsUsernamePutResponse202"""


class OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422(GitHubRestModel):
    """OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)


class OrgsOrgPersonalAccessTokenRequestsPostBody(GitHubRestModel):
    """OrgsOrgPersonalAccessTokenRequestsPostBody"""

    pat_request_ids: Missing[
        Annotated[List[int], Field(max_length=100, min_length=1)]
    ] = Field(
        description="Unique identifiers of the requests for access via fine-grained personal access token. Must be formed of between 1 and 100 `pat_request_id` values.",
        default=UNSET,
    )
    action: Literal["approve", "deny"] = Field(
        description="Action to apply to the requests.", default=...
    )
    reason: Missing[Annotated[Union[str, None], Field(max_length=1024)]] = Field(
        description="Reason for approving or denying the requests. Max 1024 characters.",
        default=UNSET,
    )


class OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody(GitHubRestModel):
    """OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody"""

    action: Literal["approve", "deny"] = Field(
        description="Action to apply to the request.", default=...
    )
    reason: Missing[Annotated[Union[str, None], Field(max_length=1024)]] = Field(
        description="Reason for approving or denying the request. Max 1024 characters.",
        default=UNSET,
    )


class OrgsOrgPersonalAccessTokensPostBody(GitHubRestModel):
    """OrgsOrgPersonalAccessTokensPostBody"""

    action: Literal["revoke"] = Field(
        description="Action to apply to the fine-grained personal access token.",
        default=...,
    )
    pat_ids: List[int] = Field(
        description="The IDs of the fine-grained personal access tokens.",
        max_length=100,
        min_length=1,
        default=...,
    )


class OrgsOrgPersonalAccessTokensPatIdPostBody(GitHubRestModel):
    """OrgsOrgPersonalAccessTokensPatIdPostBody"""

    action: Literal["revoke"] = Field(
        description="Action to apply to the fine-grained personal access token.",
        default=...,
    )


class OrgsOrgProjectsPostBody(GitHubRestModel):
    """OrgsOrgProjectsPostBody"""

    name: str = Field(description="The name of the project.", default=...)
    body: Missing[str] = Field(
        description="The description of the project.", default=UNSET
    )


class OrgsOrgReposPostBody(GitHubRestModel):
    """OrgsOrgReposPostBody"""

    name: str = Field(description="The name of the repository.", default=...)
    description: Missing[str] = Field(
        description="A short description of the repository.", default=UNSET
    )
    homepage: Missing[str] = Field(
        description="A URL with more information about the repository.", default=UNSET
    )
    private: Missing[bool] = Field(
        description="Whether the repository is private.", default=False
    )
    visibility: Missing[Literal["public", "private"]] = Field(
        description="The visibility of the repository.", default=UNSET
    )
    has_issues: Missing[bool] = Field(
        description="Either `true` to enable issues for this repository or `false` to disable them.",
        default=True,
    )
    has_projects: Missing[bool] = Field(
        description="Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.",
        default=True,
    )
    has_wiki: Missing[bool] = Field(
        description="Either `true` to enable the wiki for this repository or `false` to disable it.",
        default=True,
    )
    has_downloads: Missing[bool] = Field(
        description="Whether downloads are enabled.", default=True
    )
    is_template: Missing[bool] = Field(
        description="Either `true` to make this repo available as a template repository or `false` to prevent it.",
        default=False,
    )
    team_id: Missing[int] = Field(
        description="The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.",
        default=UNSET,
    )
    auto_init: Missing[bool] = Field(
        description="Pass `true` to create an initial commit with empty README.",
        default=False,
    )
    gitignore_template: Missing[str] = Field(
        description='Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".',
        default=UNSET,
    )
    license_template: Missing[str] = Field(
        description='Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://docs.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".',
        default=UNSET,
    )
    allow_squash_merge: Missing[bool] = Field(
        description="Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.",
        default=True,
    )
    allow_merge_commit: Missing[bool] = Field(
        description="Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.",
        default=True,
    )
    allow_rebase_merge: Missing[bool] = Field(
        description="Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.",
        default=True,
    )
    allow_auto_merge: Missing[bool] = Field(
        description="Either `true` to allow auto-merge on pull requests, or `false` to disallow auto-merge.",
        default=False,
    )
    delete_branch_on_merge: Missing[bool] = Field(
        description="Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion. **The authenticated user must be an organization owner to set this property to `true`.**",
        default=False,
    )
    use_squash_pr_title_as_default: Missing[bool] = Field(
        description="Either `true` to allow squash-merge commits to use pull request title, or `false` to use commit message. **This property has been deprecated. Please use `squash_merge_commit_title` instead.",
        default=False,
    )
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )


class OrgsOrgRulesetsPostBody(GitHubRestModel):
    """OrgsOrgRulesetsPostBody"""

    name: str = Field(description="The name of the ruleset.", default=...)
    target: Missing[Literal["branch", "tag"]] = Field(
        description="The target of the ruleset.", default=UNSET
    )
    enforcement: Literal["disabled", "active", "evaluate"] = Field(
        description="The enforcement level of the ruleset. `evaluate` allows admins to test rules before enforcing them. Admins can view insights on the Rule Insights page (`evaluate` is only available with GitHub Enterprise).",
        default=...,
    )
    bypass_actors: Missing[List[RepositoryRulesetBypassActor]] = Field(
        description="The actors that can bypass the rules in this ruleset",
        default=UNSET,
    )
    conditions: Missing[
        Union[OrgRulesetConditionsOneof0, OrgRulesetConditionsOneof1]
    ] = Field(
        title="Organization ruleset conditions",
        description="Conditions for an organization ruleset. The conditions object should contain both `repository_name` and `ref_name` properties or both `repository_id` and `ref_name` properties.\n",
        default=UNSET,
    )
    rules: Missing[
        List[
            Union[
                RepositoryRuleCreation,
                RepositoryRuleUpdate,
                RepositoryRuleDeletion,
                RepositoryRuleRequiredLinearHistory,
                RepositoryRuleRequiredDeployments,
                RepositoryRuleRequiredSignatures,
                RepositoryRulePullRequest,
                RepositoryRuleRequiredStatusChecks,
                RepositoryRuleNonFastForward,
                RepositoryRuleCommitMessagePattern,
                RepositoryRuleCommitAuthorEmailPattern,
                RepositoryRuleCommitterEmailPattern,
                RepositoryRuleBranchNamePattern,
                RepositoryRuleTagNamePattern,
            ]
        ]
    ] = Field(description="An array of rules within the ruleset.", default=UNSET)


class OrgsOrgRulesetsRulesetIdPutBody(GitHubRestModel):
    """OrgsOrgRulesetsRulesetIdPutBody"""

    name: Missing[str] = Field(description="The name of the ruleset.", default=UNSET)
    target: Missing[Literal["branch", "tag"]] = Field(
        description="The target of the ruleset.", default=UNSET
    )
    enforcement: Missing[Literal["disabled", "active", "evaluate"]] = Field(
        description="The enforcement level of the ruleset. `evaluate` allows admins to test rules before enforcing them. Admins can view insights on the Rule Insights page (`evaluate` is only available with GitHub Enterprise).",
        default=UNSET,
    )
    bypass_actors: Missing[List[RepositoryRulesetBypassActor]] = Field(
        description="The actors that can bypass the rules in this ruleset",
        default=UNSET,
    )
    conditions: Missing[
        Union[OrgRulesetConditionsOneof0, OrgRulesetConditionsOneof1]
    ] = Field(
        title="Organization ruleset conditions",
        description="Conditions for an organization ruleset. The conditions object should contain both `repository_name` and `ref_name` properties or both `repository_id` and `ref_name` properties.\n",
        default=UNSET,
    )
    rules: Missing[
        List[
            Union[
                RepositoryRuleCreation,
                RepositoryRuleUpdate,
                RepositoryRuleDeletion,
                RepositoryRuleRequiredLinearHistory,
                RepositoryRuleRequiredDeployments,
                RepositoryRuleRequiredSignatures,
                RepositoryRulePullRequest,
                RepositoryRuleRequiredStatusChecks,
                RepositoryRuleNonFastForward,
                RepositoryRuleCommitMessagePattern,
                RepositoryRuleCommitAuthorEmailPattern,
                RepositoryRuleCommitterEmailPattern,
                RepositoryRuleBranchNamePattern,
                RepositoryRuleTagNamePattern,
            ]
        ]
    ] = Field(description="An array of rules within the ruleset.", default=UNSET)


class OrgsOrgTeamsPostBody(GitHubRestModel):
    """OrgsOrgTeamsPostBody"""

    name: str = Field(description="The name of the team.", default=...)
    description: Missing[str] = Field(
        description="The description of the team.", default=UNSET
    )
    maintainers: Missing[List[str]] = Field(
        description="List GitHub IDs for organization members who will become team maintainers.",
        default=UNSET,
    )
    repo_names: Missing[List[str]] = Field(
        description='The full name (e.g., "organization-name/repository-name") of repositories to add the team to.',
        default=UNSET,
    )
    privacy: Missing[Literal["secret", "closed"]] = Field(
        description="The level of privacy this team should have. The options are:  \n**For a non-nested team:**  \n * `secret` - only visible to organization owners and members of this team.  \n * `closed` - visible to all members of this organization.  \nDefault: `secret`  \n**For a parent or child team:**  \n * `closed` - visible to all members of this organization.  \nDefault for child team: `closed`",
        default=UNSET,
    )
    notification_setting: Missing[
        Literal["notifications_enabled", "notifications_disabled"]
    ] = Field(
        description="The notification setting the team has chosen. The options are:  \n * `notifications_enabled` - team members receive notifications when the team is @mentioned.  \n * `notifications_disabled` - no one receives notifications.  \nDefault: `notifications_enabled`",
        default=UNSET,
    )
    permission: Missing[Literal["pull", "push"]] = Field(
        description="**Deprecated**. The permission that new repositories will be added to the team with when none is specified.",
        default="pull",
    )
    parent_team_id: Missing[int] = Field(
        description="The ID of a team to set as the parent team.", default=UNSET
    )


class OrgsOrgTeamsTeamSlugPatchBody(GitHubRestModel):
    """OrgsOrgTeamsTeamSlugPatchBody"""

    name: Missing[str] = Field(description="The name of the team.", default=UNSET)
    description: Missing[str] = Field(
        description="The description of the team.", default=UNSET
    )
    privacy: Missing[Literal["secret", "closed"]] = Field(
        description="The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:  \n**For a non-nested team:**  \n * `secret` - only visible to organization owners and members of this team.  \n * `closed` - visible to all members of this organization.  \n**For a parent or child team:**  \n * `closed` - visible to all members of this organization.",
        default=UNSET,
    )
    notification_setting: Missing[
        Literal["notifications_enabled", "notifications_disabled"]
    ] = Field(
        description="The notification setting the team has chosen. Editing teams without specifying this parameter leaves `notification_setting` intact. The options are: \n * `notifications_enabled` - team members receive notifications when the team is @mentioned.  \n * `notifications_disabled` - no one receives notifications.",
        default=UNSET,
    )
    permission: Missing[Literal["pull", "push", "admin"]] = Field(
        description="**Deprecated**. The permission that new repositories will be added to the team with when none is specified.",
        default="pull",
    )
    parent_team_id: Missing[Union[int, None]] = Field(
        description="The ID of a team to set as the parent team.", default=UNSET
    )


class OrgsOrgTeamsTeamSlugDiscussionsPostBody(GitHubRestModel):
    """OrgsOrgTeamsTeamSlugDiscussionsPostBody"""

    title: str = Field(description="The discussion post's title.", default=...)
    body: str = Field(description="The discussion post's body text.", default=...)
    private: Missing[bool] = Field(
        description="Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.",
        default=False,
    )


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody(GitHubRestModel):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody"""

    title: Missing[str] = Field(
        description="The discussion post's title.", default=UNSET
    )
    body: Missing[str] = Field(
        description="The discussion post's body text.", default=UNSET
    )


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody(GitHubRestModel):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody"""

    body: str = Field(description="The discussion comment's body text.", default=...)


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody(
    GitHubRestModel
):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody"""

    body: str = Field(description="The discussion comment's body text.", default=...)


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody(
    GitHubRestModel
):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPos
    tBody
    """

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(
        description="The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion comment.",
        default=...,
    )


class OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody(GitHubRestModel):
    """OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(
        description="The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion.",
        default=...,
    )


class OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody(GitHubRestModel):
    """OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody"""

    role: Missing[Literal["member", "maintainer"]] = Field(
        description="The role that this user should have in the team.", default="member"
    )


class OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody(GitHubRestModel):
    """OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody"""

    permission: Missing[Literal["read", "write", "admin"]] = Field(
        description="The permission to grant to the team for this project. Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling this endpoint. For more information, see \"[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs).\"",
        default=UNSET,
    )


class OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403(GitHubRestModel):
    """OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)


class OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody(GitHubRestModel):
    """OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody"""

    permission: Missing[str] = Field(
        description="The permission to grant the team on this repository. We accept the following permissions to be set: `pull`, `triage`, `push`, `maintain`, `admin` and you can also specify a custom repository role name, if the owning organization has defined any. If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.",
        default="push",
    )


class OrgsOrgSecurityProductEnablementPostBody(GitHubRestModel):
    """OrgsOrgSecurityProductEnablementPostBody"""

    query_suite: Missing[Literal["default", "extended"]] = Field(
        description="CodeQL query suite to be used. If you specify the `query_suite` parameter, the default setup will be configured with this query suite only on all repositories that didn't have default setup already configured. It will not change the query suite on repositories that already have default setup configured.\nIf you don't specify any `query_suite` in your request, the preferred query suite of the organization will be applied.",
        default=UNSET,
    )


class ProjectsColumnsCardsCardIdDeleteResponse403(GitHubRestModel):
    """ProjectsColumnsCardsCardIdDeleteResponse403"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)
    errors: Missing[List[str]] = Field(default=UNSET)


class ProjectsColumnsCardsCardIdPatchBody(GitHubRestModel):
    """ProjectsColumnsCardsCardIdPatchBody"""

    note: Missing[Union[str, None]] = Field(
        description="The project card's note", default=UNSET
    )
    archived: Missing[bool] = Field(
        description="Whether or not the card is archived", default=UNSET
    )


class ProjectsColumnsCardsCardIdMovesPostBody(GitHubRestModel):
    """ProjectsColumnsCardsCardIdMovesPostBody"""

    position: str = Field(
        description="The position of the card in a column. Can be one of: `top`, `bottom`, or `after:<card_id>` to place after the specified card.",
        pattern="^(?:top|bottom|after:\\d+)$",
        default=...,
    )
    column_id: Missing[int] = Field(
        description="The unique identifier of the column the card should be moved to",
        default=UNSET,
    )


class ProjectsColumnsCardsCardIdMovesPostResponse201(GitHubRestModel):
    """ProjectsColumnsCardsCardIdMovesPostResponse201"""


class ProjectsColumnsCardsCardIdMovesPostResponse403(GitHubRestModel):
    """ProjectsColumnsCardsCardIdMovesPostResponse403"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)
    errors: Missing[
        List[ProjectsColumnsCardsCardIdMovesPostResponse403PropErrorsItems]
    ] = Field(default=UNSET)


class ProjectsColumnsCardsCardIdMovesPostResponse403PropErrorsItems(GitHubRestModel):
    """ProjectsColumnsCardsCardIdMovesPostResponse403PropErrorsItems"""

    code: Missing[str] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    resource: Missing[str] = Field(default=UNSET)
    field: Missing[str] = Field(default=UNSET)


class ProjectsColumnsCardsCardIdMovesPostResponse503(GitHubRestModel):
    """ProjectsColumnsCardsCardIdMovesPostResponse503"""

    code: Missing[str] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)
    errors: Missing[
        List[ProjectsColumnsCardsCardIdMovesPostResponse503PropErrorsItems]
    ] = Field(default=UNSET)


class ProjectsColumnsCardsCardIdMovesPostResponse503PropErrorsItems(GitHubRestModel):
    """ProjectsColumnsCardsCardIdMovesPostResponse503PropErrorsItems"""

    code: Missing[str] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)


class ProjectsColumnsColumnIdPatchBody(GitHubRestModel):
    """ProjectsColumnsColumnIdPatchBody"""

    name: str = Field(description="Name of the project column", default=...)


class ProjectsColumnsColumnIdCardsPostBodyOneof0(GitHubRestModel):
    """ProjectsColumnsColumnIdCardsPostBodyOneof0"""

    note: Union[str, None] = Field(description="The project card's note", default=...)


class ProjectsColumnsColumnIdCardsPostBodyOneof1(GitHubRestModel):
    """ProjectsColumnsColumnIdCardsPostBodyOneof1"""

    content_id: int = Field(
        description="The unique identifier of the content associated with the card",
        default=...,
    )
    content_type: str = Field(
        description="The piece of content associated with the card", default=...
    )


class ProjectsColumnsColumnIdCardsPostResponse503(GitHubRestModel):
    """ProjectsColumnsColumnIdCardsPostResponse503"""

    code: Missing[str] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)
    errors: Missing[
        List[ProjectsColumnsColumnIdCardsPostResponse503PropErrorsItems]
    ] = Field(default=UNSET)


class ProjectsColumnsColumnIdCardsPostResponse503PropErrorsItems(GitHubRestModel):
    """ProjectsColumnsColumnIdCardsPostResponse503PropErrorsItems"""

    code: Missing[str] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)


class ProjectsColumnsColumnIdMovesPostBody(GitHubRestModel):
    """ProjectsColumnsColumnIdMovesPostBody"""

    position: str = Field(
        description="The position of the column in a project. Can be one of: `first`, `last`, or `after:<column_id>` to place after the specified column.",
        pattern="^(?:first|last|after:\\d+)$",
        default=...,
    )


class ProjectsColumnsColumnIdMovesPostResponse201(GitHubRestModel):
    """ProjectsColumnsColumnIdMovesPostResponse201"""


class ProjectsProjectIdDeleteResponse403(GitHubRestModel):
    """ProjectsProjectIdDeleteResponse403"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)
    errors: Missing[List[str]] = Field(default=UNSET)


class ProjectsProjectIdPatchBody(GitHubRestModel):
    """ProjectsProjectIdPatchBody"""

    name: Missing[str] = Field(description="Name of the project", default=UNSET)
    body: Missing[Union[str, None]] = Field(
        description="Body of the project", default=UNSET
    )
    state: Missing[str] = Field(
        description="State of the project; either 'open' or 'closed'", default=UNSET
    )
    organization_permission: Missing[Literal["read", "write", "admin", "none"]] = Field(
        description="The baseline permission that all organization members have on this project",
        default=UNSET,
    )
    private: Missing[bool] = Field(
        description="Whether or not this project can be seen by everyone.",
        default=UNSET,
    )


class ProjectsProjectIdPatchResponse403(GitHubRestModel):
    """ProjectsProjectIdPatchResponse403"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)
    errors: Missing[List[str]] = Field(default=UNSET)


class ProjectsProjectIdCollaboratorsUsernamePutBody(GitHubRestModel):
    """ProjectsProjectIdCollaboratorsUsernamePutBody"""

    permission: Missing[Literal["read", "write", "admin"]] = Field(
        description="The permission to grant the collaborator.", default="write"
    )


class ProjectsProjectIdColumnsPostBody(GitHubRestModel):
    """ProjectsProjectIdColumnsPostBody"""

    name: str = Field(description="Name of the project column", default=...)


class ReposOwnerRepoDeleteResponse403(GitHubRestModel):
    """ReposOwnerRepoDeleteResponse403"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoPatchBody(GitHubRestModel):
    """ReposOwnerRepoPatchBody"""

    name: Missing[str] = Field(description="The name of the repository.", default=UNSET)
    description: Missing[str] = Field(
        description="A short description of the repository.", default=UNSET
    )
    homepage: Missing[str] = Field(
        description="A URL with more information about the repository.", default=UNSET
    )
    private: Missing[bool] = Field(
        description="Either `true` to make the repository private or `false` to make it public. Default: `false`.  \n**Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://docs.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.",
        default=False,
    )
    visibility: Missing[Literal["public", "private"]] = Field(
        description="The visibility of the repository.", default=UNSET
    )
    security_and_analysis: Missing[
        Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysis, None]
    ] = Field(
        description='Specify which security and analysis features to enable or disable for the repository.\n\nTo use this parameter, you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."\n\nFor example, to enable GitHub Advanced Security, use this data in the body of the `PATCH` request:\n`{ "security_and_analysis": {"advanced_security": { "status": "enabled" } } }`.\n\nYou can check which security and analysis features are currently enabled by using a `GET /repos/{owner}/{repo}` request.',
        default=UNSET,
    )
    has_issues: Missing[bool] = Field(
        description="Either `true` to enable issues for this repository or `false` to disable them.",
        default=True,
    )
    has_projects: Missing[bool] = Field(
        description="Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.",
        default=True,
    )
    has_wiki: Missing[bool] = Field(
        description="Either `true` to enable the wiki for this repository or `false` to disable it.",
        default=True,
    )
    is_template: Missing[bool] = Field(
        description="Either `true` to make this repo available as a template repository or `false` to prevent it.",
        default=False,
    )
    default_branch: Missing[str] = Field(
        description="Updates the default branch for this repository.", default=UNSET
    )
    allow_squash_merge: Missing[bool] = Field(
        description="Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.",
        default=True,
    )
    allow_merge_commit: Missing[bool] = Field(
        description="Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.",
        default=True,
    )
    allow_rebase_merge: Missing[bool] = Field(
        description="Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.",
        default=True,
    )
    allow_auto_merge: Missing[bool] = Field(
        description="Either `true` to allow auto-merge on pull requests, or `false` to disallow auto-merge.",
        default=False,
    )
    delete_branch_on_merge: Missing[bool] = Field(
        description="Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.",
        default=False,
    )
    allow_update_branch: Missing[bool] = Field(
        description="Either `true` to always allow a pull request head branch that is behind its base branch to be updated even if it is not required to be up to date before merging, or false otherwise.",
        default=False,
    )
    use_squash_pr_title_as_default: Missing[bool] = Field(
        description="Either `true` to allow squash-merge commits to use pull request title, or `false` to use commit message. **This property has been deprecated. Please use `squash_merge_commit_title` instead.",
        default=False,
    )
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    archived: Missing[bool] = Field(
        description="Whether to archive this repository. `false` will unarchive a previously archived repository.",
        default=False,
    )
    allow_forking: Missing[bool] = Field(
        description="Either `true` to allow private forks, or `false` to prevent private forks.",
        default=False,
    )
    web_commit_signoff_required: Missing[bool] = Field(
        description="Either `true` to require contributors to sign off on web-based commits, or `false` to not require contributors to sign off on web-based commits.",
        default=False,
    )


class ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropAdvancedSecurity(
    GitHubRestModel
):
    """ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropAdvancedSecurity

    Use the `status` property to enable or disable GitHub Advanced Security for this
    repository. For more information, see "[About GitHub Advanced
    Security](/github/getting-started-with-github/learning-about-github/about-
    github-advanced-security)."
    """

    status: Missing[str] = Field(
        description="Can be `enabled` or `disabled`.", default=UNSET
    )


class ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanning(GitHubRestModel):
    """ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanning

    Use the `status` property to enable or disable secret scanning for this
    repository. For more information, see "[About secret scanning](/code-
    security/secret-security/about-secret-scanning)."
    """

    status: Missing[str] = Field(
        description="Can be `enabled` or `disabled`.", default=UNSET
    )


class ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningPushProtection(
    GitHubRestModel
):
    """ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningPushProtection

    Use the `status` property to enable or disable secret scanning push protection
    for this repository. For more information, see "[Protecting pushes with secret
    scanning](/code-security/secret-scanning/protecting-pushes-with-secret-
    scanning)."
    """

    status: Missing[str] = Field(
        description="Can be `enabled` or `disabled`.", default=UNSET
    )


class ReposOwnerRepoPatchBodyPropSecurityAndAnalysis(GitHubRestModel):
    """ReposOwnerRepoPatchBodyPropSecurityAndAnalysis

    Specify which security and analysis features to enable or disable for the
    repository.

    To use this parameter, you must have admin permissions for the repository or be
    an owner or security manager for the organization that owns the repository. For
    more information, see "[Managing security managers in your
    organization](https://docs.github.com/organizations/managing-peoples-access-to-
    your-organization-with-roles/managing-security-managers-in-your-organization)."

    For example, to enable GitHub Advanced Security, use this data in the body of
    the `PATCH` request:
    `{ "security_and_analysis": {"advanced_security": { "status": "enabled" } } }`.

    You can check which security and analysis features are currently enabled by
    using a `GET /repos/{owner}/{repo}` request.
    """

    advanced_security: Missing[
        ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropAdvancedSecurity
    ] = Field(
        description='Use the `status` property to enable or disable GitHub Advanced Security for this repository. For more information, see "[About GitHub Advanced Security](/github/getting-started-with-github/learning-about-github/about-github-advanced-security)."',
        default=UNSET,
    )
    secret_scanning: Missing[
        ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanning
    ] = Field(
        description='Use the `status` property to enable or disable secret scanning for this repository. For more information, see "[About secret scanning](/code-security/secret-security/about-secret-scanning)."',
        default=UNSET,
    )
    secret_scanning_push_protection: Missing[
        ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningPushProtection
    ] = Field(
        description='Use the `status` property to enable or disable secret scanning push protection for this repository. For more information, see "[Protecting pushes with secret scanning](/code-security/secret-scanning/protecting-pushes-with-secret-scanning)."',
        default=UNSET,
    )


class ReposOwnerRepoActionsArtifactsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsArtifactsGetResponse200"""

    total_count: int = Field(default=...)
    artifacts: List[Artifact] = Field(default=...)


class ReposOwnerRepoActionsJobsJobIdRerunPostBody(GitHubRestModel):
    """ReposOwnerRepoActionsJobsJobIdRerunPostBody"""

    enable_debug_logging: Missing[bool] = Field(
        description="Whether to enable debug logging for the re-run.", default=False
    )


class ReposOwnerRepoActionsOidcCustomizationSubPutBody(GitHubRestModel):
    """Actions OIDC subject customization for a repository

    Actions OIDC subject customization for a repository
    """

    use_default: bool = Field(
        description="Whether to use the default template or not. If `true`, the `include_claim_keys` field is ignored.",
        default=...,
    )
    include_claim_keys: Missing[List[str]] = Field(
        description="Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.",
        default=UNSET,
    )


class ReposOwnerRepoActionsOrganizationSecretsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsOrganizationSecretsGetResponse200"""

    total_count: int = Field(default=...)
    secrets: List[ActionsSecret] = Field(default=...)


class ReposOwnerRepoActionsOrganizationVariablesGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsOrganizationVariablesGetResponse200"""

    total_count: int = Field(default=...)
    variables: List[ActionsVariable] = Field(default=...)


class ReposOwnerRepoActionsPermissionsPutBody(GitHubRestModel):
    """ReposOwnerRepoActionsPermissionsPutBody"""

    enabled: bool = Field(
        description="Whether GitHub Actions is enabled on the repository.", default=...
    )
    allowed_actions: Missing[Literal["all", "local_only", "selected"]] = Field(
        description="The permissions policy that controls the actions and reusable workflows that are allowed to run.",
        default=UNSET,
    )


class ReposOwnerRepoActionsRunnersGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsRunnersGetResponse200"""

    total_count: int = Field(default=...)
    runners: List[Runner] = Field(default=...)


class ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody(GitHubRestModel):
    """ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody"""

    name: str = Field(description="The name of the new runner.", default=...)
    runner_group_id: int = Field(
        description="The ID of the runner group to register the runner to.", default=...
    )
    labels: List[str] = Field(
        description="The names of the custom labels to add to the runner. **Minimum items**: 1. **Maximum items**: 100.",
        max_length=100,
        min_length=1,
        default=...,
    )
    work_folder: Missing[str] = Field(
        description="The working directory to be used for job execution, relative to the runner install directory.",
        default="_work",
    )


class ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody(GitHubRestModel):
    """ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody"""

    labels: List[str] = Field(
        description="The names of the custom labels to set for the runner. You can pass an empty array to remove all custom labels.",
        max_length=100,
        default=...,
    )


class ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody(GitHubRestModel):
    """ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody"""

    labels: List[str] = Field(
        description="The names of the custom labels to add to the runner.",
        max_length=100,
        min_length=1,
        default=...,
    )


class ReposOwnerRepoActionsRunsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsRunsGetResponse200"""

    total_count: int = Field(default=...)
    workflow_runs: List[WorkflowRun] = Field(default=...)


class ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200"""

    total_count: int = Field(default=...)
    artifacts: List[Artifact] = Field(default=...)


class ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200(
    GitHubRestModel
):
    """ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200"""

    total_count: int = Field(default=...)
    jobs: List[Job] = Field(default=...)


class ReposOwnerRepoActionsRunsRunIdJobsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsRunsRunIdJobsGetResponse200"""

    total_count: int = Field(default=...)
    jobs: List[Job] = Field(default=...)


class ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody(GitHubRestModel):
    """ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody"""

    environment_ids: List[int] = Field(
        description="The list of environment ids to approve or reject", default=...
    )
    state: Literal["approved", "rejected"] = Field(
        description="Whether to approve or reject deployment to the specified environments.",
        default=...,
    )
    comment: str = Field(
        description="A comment to accompany the deployment review", default=...
    )


class ReposOwnerRepoActionsRunsRunIdRerunPostBody(GitHubRestModel):
    """ReposOwnerRepoActionsRunsRunIdRerunPostBody"""

    enable_debug_logging: Missing[bool] = Field(
        description="Whether to enable debug logging for the re-run.", default=False
    )


class ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody(GitHubRestModel):
    """ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody"""

    enable_debug_logging: Missing[bool] = Field(
        description="Whether to enable debug logging for the re-run.", default=False
    )


class ReposOwnerRepoActionsSecretsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsSecretsGetResponse200"""

    total_count: int = Field(default=...)
    secrets: List[ActionsSecret] = Field(default=...)


class ReposOwnerRepoActionsSecretsSecretNamePutBody(GitHubRestModel):
    """ReposOwnerRepoActionsSecretsSecretNamePutBody"""

    encrypted_value: Missing[
        Annotated[
            str,
            Field(
                pattern="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$"
            ),
        ]
    ] = Field(
        description="Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://docs.github.com/rest/actions/secrets#get-a-repository-public-key) endpoint.",
        default=UNSET,
    )
    key_id: Missing[str] = Field(
        description="ID of the key you used to encrypt the secret.", default=UNSET
    )


class ReposOwnerRepoActionsVariablesGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsVariablesGetResponse200"""

    total_count: int = Field(default=...)
    variables: List[ActionsVariable] = Field(default=...)


class ReposOwnerRepoActionsVariablesPostBody(GitHubRestModel):
    """ReposOwnerRepoActionsVariablesPostBody"""

    name: str = Field(description="The name of the variable.", default=...)
    value: str = Field(description="The value of the variable.", default=...)


class ReposOwnerRepoActionsVariablesNamePatchBody(GitHubRestModel):
    """ReposOwnerRepoActionsVariablesNamePatchBody"""

    name: Missing[str] = Field(description="The name of the variable.", default=UNSET)
    value: Missing[str] = Field(description="The value of the variable.", default=UNSET)


class ReposOwnerRepoActionsWorkflowsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsWorkflowsGetResponse200"""

    total_count: int = Field(default=...)
    workflows: List[Workflow] = Field(default=...)


class ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody(GitHubRestModel):
    """ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody"""

    ref: str = Field(
        description="The git reference for the workflow. The reference can be a branch or tag name.",
        default=...,
    )
    inputs: Missing[
        ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputs
    ] = Field(
        description="Input keys and values configured in the workflow file. The maximum number of properties is 10. Any default properties configured in the workflow file will be used when `inputs` are omitted.",
        default=UNSET,
    )


class ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputs(
    GitHubRestModel, extra=Extra.allow
):
    """ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputs

    Input keys and values configured in the workflow file. The maximum number of
    properties is 10. Any default properties configured in the workflow file will be
    used when `inputs` are omitted.
    """


class ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200"""

    total_count: int = Field(default=...)
    workflow_runs: List[WorkflowRun] = Field(default=...)


class ReposOwnerRepoAutolinksPostBody(GitHubRestModel):
    """ReposOwnerRepoAutolinksPostBody"""

    key_prefix: str = Field(
        description="This prefix appended by certain characters will generate a link any time it is found in an issue, pull request, or commit.",
        default=...,
    )
    url_template: str = Field(
        description="The URL must contain `<num>` for the reference number. `<num>` matches different characters depending on the value of `is_alphanumeric`.",
        default=...,
    )
    is_alphanumeric: Missing[bool] = Field(
        description="Whether this autolink reference matches alphanumeric characters. If true, the `<num>` parameter of the `url_template` matches alphanumeric characters `A-Z` (case insensitive), `0-9`, and `-`. If false, this autolink reference only matches numeric characters.",
        default=True,
    )


class ReposOwnerRepoBranchesBranchProtectionPutBody(GitHubRestModel):
    """ReposOwnerRepoBranchesBranchProtectionPutBody"""

    required_status_checks: Union[
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecks, None
    ] = Field(
        description="Require status checks to pass before merging. Set to `null` to disable.",
        default=...,
    )
    enforce_admins: Union[bool, None] = Field(
        description="Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.",
        default=...,
    )
    required_pull_request_reviews: Union[
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviews,
        None,
    ] = Field(
        description="Require at least one approving review on a pull request, before merging. Set to `null` to disable.",
        default=...,
    )
    restrictions: Union[
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictions, None
    ] = Field(
        description="Restrict who can push to the protected branch. User, app, and team `restrictions` are only available for organization-owned repositories. Set to `null` to disable.",
        default=...,
    )
    required_linear_history: Missing[bool] = Field(
        description='Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see "[Requiring a linear commit history](https://docs.github.com/github/administering-a-repository/requiring-a-linear-commit-history)" in the GitHub Help documentation.',
        default=UNSET,
    )
    allow_force_pushes: Missing[Union[bool, None]] = Field(
        description='Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://docs.github.com/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation."',
        default=UNSET,
    )
    allow_deletions: Missing[bool] = Field(
        description='Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://docs.github.com/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation.',
        default=UNSET,
    )
    block_creations: Missing[bool] = Field(
        description="If set to `true`, the `restrictions` branch protection settings which limits who can push will also block pushes which create new branches, unless the push is initiated by a user, team, or app which has the ability to push. Set to `true` to restrict new branch creation. Default: `false`.",
        default=UNSET,
    )
    required_conversation_resolution: Missing[bool] = Field(
        description="Requires all conversations on code to be resolved before a pull request can be merged into a branch that matches this rule. Set to `false` to disable. Default: `false`.",
        default=UNSET,
    )
    lock_branch: Missing[bool] = Field(
        description="Whether to set the branch as read-only. If this is true, users will not be able to push to the branch. Default: `false`.",
        default=False,
    )
    allow_fork_syncing: Missing[bool] = Field(
        description="Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing. Default: `false`.",
        default=False,
    )


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksPropChecksItems(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksPropChecksI
    tems
    """

    context: str = Field(description="The name of the required check", default=...)
    app_id: Missing[int] = Field(
        description="The ID of the GitHub App that must provide this check. Omit this field to automatically select the GitHub App that has recently provided this check, or any app if it was not set by a GitHub App. Pass -1 to explicitly allow any app to set the status.",
        default=UNSET,
    )


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecks(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecks

    Require status checks to pass before merging. Set to `null` to disable.
    """

    strict: bool = Field(
        description="Require branches to be up to date before merging.", default=...
    )
    contexts: List[str] = Field(
        description="**Deprecated**: The list of status checks to require in order to merge into this branch. If any of these checks have recently been set by a particular GitHub App, they will be required to come from that app in future for the branch to merge. Use `checks` instead of `contexts` for more fine-grained control.\n",
        default=...,
    )
    checks: Missing[
        List[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksPropChecksItems
        ]
    ] = Field(
        description="The list of status checks to require in order to merge into this branch.",
        default=UNSET,
    )


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropDismissalRestrictions(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropD
    ismissalRestrictions

    Specify which users, teams, and apps can dismiss pull request reviews. Pass an
    empty `dismissal_restrictions` object to disable. User and team
    `dismissal_restrictions` are only available for organization-owned repositories.
    Omit this parameter for personal repositories.
    """

    users: Missing[List[str]] = Field(
        description="The list of user `login`s with dismissal access", default=UNSET
    )
    teams: Missing[List[str]] = Field(
        description="The list of team `slug`s with dismissal access", default=UNSET
    )
    apps: Missing[List[str]] = Field(
        description="The list of app `slug`s with dismissal access", default=UNSET
    )


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropBypassPullRequestAllowances(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropB
    ypassPullRequestAllowances

    Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: Missing[List[str]] = Field(
        description="The list of user `login`s allowed to bypass pull request requirements.",
        default=UNSET,
    )
    teams: Missing[List[str]] = Field(
        description="The list of team `slug`s allowed to bypass pull request requirements.",
        default=UNSET,
    )
    apps: Missing[List[str]] = Field(
        description="The list of app `slug`s allowed to bypass pull request requirements.",
        default=UNSET,
    )


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviews(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviews

    Require at least one approving review on a pull request, before merging. Set to
    `null` to disable.
    """

    dismissal_restrictions: Missing[
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropDismissalRestrictions
    ] = Field(
        description="Specify which users, teams, and apps can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.",
        default=UNSET,
    )
    dismiss_stale_reviews: Missing[bool] = Field(
        description="Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.",
        default=UNSET,
    )
    require_code_owner_reviews: Missing[bool] = Field(
        description="Blocks merging pull requests until [code owners](https://docs.github.com/articles/about-code-owners/) review them.",
        default=UNSET,
    )
    required_approving_review_count: Missing[int] = Field(
        description="Specify the number of reviewers required to approve pull requests. Use a number between 1 and 6 or 0 to not require reviewers.",
        default=UNSET,
    )
    require_last_push_approval: Missing[bool] = Field(
        description="Whether the most recent push must be approved by someone other than the person who pushed it. Default: `false`.",
        default=False,
    )
    bypass_pull_request_allowances: Missing[
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropBypassPullRequestAllowances
    ] = Field(
        description="Allow specific users, teams, or apps to bypass pull request requirements.",
        default=UNSET,
    )


class ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictions(GitHubRestModel):
    """ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictions

    Restrict who can push to the protected branch. User, app, and team
    `restrictions` are only available for organization-owned repositories. Set to
    `null` to disable.
    """

    users: List[str] = Field(
        description="The list of user `login`s with push access", default=...
    )
    teams: List[str] = Field(
        description="The list of team `slug`s with push access", default=...
    )
    apps: Missing[List[str]] = Field(
        description="The list of app `slug`s with push access", default=UNSET
    )


class ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody"""

    dismissal_restrictions: Missing[
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictions
    ] = Field(
        description="Specify which users, teams, and apps can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.",
        default=UNSET,
    )
    dismiss_stale_reviews: Missing[bool] = Field(
        description="Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.",
        default=UNSET,
    )
    require_code_owner_reviews: Missing[bool] = Field(
        description="Blocks merging pull requests until [code owners](https://docs.github.com/articles/about-code-owners/) have reviewed.",
        default=UNSET,
    )
    required_approving_review_count: Missing[int] = Field(
        description="Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6 or 0 to not require reviewers.",
        default=UNSET,
    )
    require_last_push_approval: Missing[bool] = Field(
        description="Whether the most recent push must be approved by someone other than the person who pushed it. Default: `false`",
        default=False,
    )
    bypass_pull_request_allowances: Missing[
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowances
    ] = Field(
        description="Allow specific users, teams, or apps to bypass pull request requirements.",
        default=UNSET,
    )


class ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictions(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDis
    missalRestrictions

    Specify which users, teams, and apps can dismiss pull request reviews. Pass an
    empty `dismissal_restrictions` object to disable. User and team
    `dismissal_restrictions` are only available for organization-owned repositories.
    Omit this parameter for personal repositories.
    """

    users: Missing[List[str]] = Field(
        description="The list of user `login`s with dismissal access", default=UNSET
    )
    teams: Missing[List[str]] = Field(
        description="The list of team `slug`s with dismissal access", default=UNSET
    )
    apps: Missing[List[str]] = Field(
        description="The list of app `slug`s with dismissal access", default=UNSET
    )


class ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowances(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropByp
    assPullRequestAllowances

    Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: Missing[List[str]] = Field(
        description="The list of user `login`s allowed to bypass pull request requirements.",
        default=UNSET,
    )
    teams: Missing[List[str]] = Field(
        description="The list of team `slug`s allowed to bypass pull request requirements.",
        default=UNSET,
    )
    apps: Missing[List[str]] = Field(
        description="The list of app `slug`s allowed to bypass pull request requirements.",
        default=UNSET,
    )


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody"""

    strict: Missing[bool] = Field(
        description="Require branches to be up to date before merging.", default=UNSET
    )
    contexts: Missing[List[str]] = Field(
        description="**Deprecated**: The list of status checks to require in order to merge into this branch. If any of these checks have recently been set by a particular GitHub App, they will be required to come from that app in future for the branch to merge. Use `checks` instead of `contexts` for more fine-grained control.\n",
        default=UNSET,
    )
    checks: Missing[
        List[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItems
        ]
    ] = Field(
        description="The list of status checks to require in order to merge into this branch.",
        default=UNSET,
    )


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItems(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksIte
    ms
    """

    context: str = Field(description="The name of the required check", default=...)
    app_id: Missing[int] = Field(
        description="The ID of the GitHub App that must provide this check. Omit this field to automatically select the GitHub App that has recently provided this check, or any app if it was not set by a GitHub App. Pass -1 to explicitly allow any app to set the status.",
        default=UNSET,
    )


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0

    Examples:
        {'contexts': ['contexts']}
    """

    contexts: List[str] = Field(
        description="The name of the status checks", default=...
    )


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0

    Examples:
        {'contexts': ['contexts']}
    """

    contexts: List[str] = Field(
        description="The name of the status checks", default=...
    )


class ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneo
    f0

    Examples:
        {'contexts': ['contexts']}
    """

    contexts: List[str] = Field(
        description="The name of the status checks", default=...
    )


class ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0

    Examples:
        {'apps': ['my-app']}
    """

    apps: List[str] = Field(
        description="The GitHub Apps that have push access to this branch. Use the slugified version of the app name. **Note**: The list of users, apps, and teams in total is limited to 100 items.",
        default=...,
    )


class ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0

    Examples:
        {'apps': ['my-app']}
    """

    apps: List[str] = Field(
        description="The GitHub Apps that have push access to this branch. Use the slugified version of the app name. **Note**: The list of users, apps, and teams in total is limited to 100 items.",
        default=...,
    )


class ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0

    Examples:
        {'apps': ['my-app']}
    """

    apps: List[str] = Field(
        description="The GitHub Apps that have push access to this branch. Use the slugified version of the app name. **Note**: The list of users, apps, and teams in total is limited to 100 items.",
        default=...,
    )


class ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0

    Examples:
        {'teams': ['justice-league']}
    """

    teams: List[str] = Field(description="The slug values for teams", default=...)


class ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0

    Examples:
        {'teams': ['my-team']}
    """

    teams: List[str] = Field(description="The slug values for teams", default=...)


class ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0

    Examples:
        {'teams': ['my-team']}
    """

    teams: List[str] = Field(description="The slug values for teams", default=...)


class ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0

    Examples:
        {'users': ['mona']}
    """

    users: List[str] = Field(description="The username for users", default=...)


class ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0

    Examples:
        {'users': ['mona']}
    """

    users: List[str] = Field(description="The username for users", default=...)


class ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0(
    GitHubRestModel
):
    """ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0

    Examples:
        {'users': ['mona']}
    """

    users: List[str] = Field(description="The username for users", default=...)


class ReposOwnerRepoBranchesBranchRenamePostBody(GitHubRestModel):
    """ReposOwnerRepoBranchesBranchRenamePostBody"""

    new_name: str = Field(description="The new name of the branch.", default=...)


class ReposOwnerRepoCheckRunsPostBodyPropOutput(GitHubRestModel):
    """ReposOwnerRepoCheckRunsPostBodyPropOutput

    Check runs can accept a variety of data in the `output` object, including a
    `title` and `summary` and can optionally provide descriptive details about the
    run.
    """

    title: str = Field(description="The title of the check run.", default=...)
    summary: str = Field(
        description="The summary of the check run. This parameter supports Markdown. **Maximum length**: 65535 characters.",
        max_length=65535,
        default=...,
    )
    text: Missing[Annotated[str, Field(max_length=65535)]] = Field(
        description="The details of the check run. This parameter supports Markdown. **Maximum length**: 65535 characters.",
        default=UNSET,
    )
    annotations: Missing[
        List[ReposOwnerRepoCheckRunsPostBodyPropOutputPropAnnotationsItems]
    ] = Field(
        description='Adds information from your analysis to specific lines of code. Annotations are visible on GitHub in the **Checks** and **Files changed** tab of the pull request. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://docs.github.com/rest/checks/runs#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. GitHub Actions are limited to 10 warning annotations and 10 error annotations per step. For details about how you can view annotations on GitHub, see "[About status checks](https://docs.github.com/articles/about-status-checks#checks)".',
        default=UNSET,
    )
    images: Missing[
        List[ReposOwnerRepoCheckRunsPostBodyPropOutputPropImagesItems]
    ] = Field(
        description="Adds images to the output displayed in the GitHub pull request UI.",
        default=UNSET,
    )


class ReposOwnerRepoCheckRunsPostBodyPropOutputPropAnnotationsItems(GitHubRestModel):
    """ReposOwnerRepoCheckRunsPostBodyPropOutputPropAnnotationsItems"""

    path: str = Field(
        description="The path of the file to add an annotation to. For example, `assets/css/main.css`.",
        default=...,
    )
    start_line: int = Field(
        description="The start line of the annotation. Line numbers start at 1.",
        default=...,
    )
    end_line: int = Field(description="The end line of the annotation.", default=...)
    start_column: Missing[int] = Field(
        description="The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values. Column numbers start at 1.",
        default=UNSET,
    )
    end_column: Missing[int] = Field(
        description="The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.",
        default=UNSET,
    )
    annotation_level: Literal["notice", "warning", "failure"] = Field(
        description="The level of the annotation.", default=...
    )
    message: str = Field(
        description="A short description of the feedback for these lines of code. The maximum size is 64 KB.",
        default=...,
    )
    title: Missing[str] = Field(
        description="The title that represents the annotation. The maximum size is 255 characters.",
        default=UNSET,
    )
    raw_details: Missing[str] = Field(
        description="Details about this annotation. The maximum size is 64 KB.",
        default=UNSET,
    )


class ReposOwnerRepoCheckRunsPostBodyPropOutputPropImagesItems(GitHubRestModel):
    """ReposOwnerRepoCheckRunsPostBodyPropOutputPropImagesItems"""

    alt: str = Field(description="The alternative text for the image.", default=...)
    image_url: str = Field(description="The full URL of the image.", default=...)
    caption: Missing[str] = Field(
        description="A short image description.", default=UNSET
    )


class ReposOwnerRepoCheckRunsPostBodyPropActionsItems(GitHubRestModel):
    """ReposOwnerRepoCheckRunsPostBodyPropActionsItems"""

    label: str = Field(
        description="The text to be displayed on a button in the web UI. The maximum size is 20 characters.",
        max_length=20,
        default=...,
    )
    description: str = Field(
        description="A short explanation of what this action would do. The maximum size is 40 characters.",
        max_length=40,
        default=...,
    )
    identifier: str = Field(
        description="A reference for the action on the integrator's system. The maximum size is 20 characters.",
        max_length=20,
        default=...,
    )


class ReposOwnerRepoCheckRunsPostBodyOneof0(GitHubRestModel, extra=Extra.allow):
    """ReposOwnerRepoCheckRunsPostBodyOneof0"""

    name: str = Field(
        description='The name of the check. For example, "code-coverage".', default=...
    )
    head_sha: str = Field(description="The SHA of the commit.", default=...)
    details_url: Missing[str] = Field(
        description="The URL of the integrator's site that has the full details of the check. If the integrator does not provide this, then the homepage of the GitHub app is used.",
        default=UNSET,
    )
    external_id: Missing[str] = Field(
        description="A reference for the run on the integrator's system.", default=UNSET
    )
    status: Literal["completed"] = Field(default=...)
    started_at: Missing[datetime] = Field(
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    conclusion: Literal[
        "action_required",
        "cancelled",
        "failure",
        "neutral",
        "success",
        "skipped",
        "stale",
        "timed_out",
    ] = Field(
        description="**Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. \n**Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. You cannot change a check run conclusion to `stale`, only GitHub can set this.",
        default=...,
    )
    completed_at: Missing[datetime] = Field(
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    output: Missing[ReposOwnerRepoCheckRunsPostBodyPropOutput] = Field(
        description="Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run.",
        default=UNSET,
    )
    actions: Missing[List[ReposOwnerRepoCheckRunsPostBodyPropActionsItems]] = Field(
        description='Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://docs.github.com/rest/guides/using-the-rest-api-to-interact-with-checks#check-runs-and-requested-actions)."',
        default=UNSET,
    )


class ReposOwnerRepoCheckRunsPostBodyOneof1(GitHubRestModel, extra=Extra.allow):
    """ReposOwnerRepoCheckRunsPostBodyOneof1"""

    name: str = Field(
        description='The name of the check. For example, "code-coverage".', default=...
    )
    head_sha: str = Field(description="The SHA of the commit.", default=...)
    details_url: Missing[str] = Field(
        description="The URL of the integrator's site that has the full details of the check. If the integrator does not provide this, then the homepage of the GitHub app is used.",
        default=UNSET,
    )
    external_id: Missing[str] = Field(
        description="A reference for the run on the integrator's system.", default=UNSET
    )
    status: Missing[Literal["queued", "in_progress"]] = Field(default=UNSET)
    started_at: Missing[datetime] = Field(
        description="The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    conclusion: Missing[
        Literal[
            "action_required",
            "cancelled",
            "failure",
            "neutral",
            "success",
            "skipped",
            "stale",
            "timed_out",
        ]
    ] = Field(
        description="**Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. \n**Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. You cannot change a check run conclusion to `stale`, only GitHub can set this.",
        default=UNSET,
    )
    completed_at: Missing[datetime] = Field(
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    output: Missing[ReposOwnerRepoCheckRunsPostBodyPropOutput] = Field(
        description="Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run.",
        default=UNSET,
    )
    actions: Missing[List[ReposOwnerRepoCheckRunsPostBodyPropActionsItems]] = Field(
        description='Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://docs.github.com/rest/guides/using-the-rest-api-to-interact-with-checks#check-runs-and-requested-actions)."',
        default=UNSET,
    )


class ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutput(GitHubRestModel):
    """ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutput

    Check runs can accept a variety of data in the `output` object, including a
    `title` and `summary` and can optionally provide descriptive details about the
    run.
    """

    title: Missing[str] = Field(description="**Required**.", default=UNSET)
    summary: str = Field(
        description="Can contain Markdown.", max_length=65535, default=...
    )
    text: Missing[Annotated[str, Field(max_length=65535)]] = Field(
        description="Can contain Markdown.", default=UNSET
    )
    annotations: Missing[
        List[ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropAnnotationsItems]
    ] = Field(
        description="Adds information from your analysis to specific lines of code. Annotations are visible in GitHub's pull request UI. Annotations are visible in GitHub's pull request UI. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://docs.github.com/rest/checks/runs#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. GitHub Actions are limited to 10 warning annotations and 10 error annotations per step. For details about annotations in the UI, see \"[About status checks](https://docs.github.com/articles/about-status-checks#checks)\".",
        default=UNSET,
    )
    images: Missing[
        List[ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropImagesItems]
    ] = Field(
        description="Adds images to the output displayed in the GitHub pull request UI.",
        default=UNSET,
    )


class ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropAnnotationsItems(
    GitHubRestModel
):
    """ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropAnnotationsItems"""

    path: str = Field(
        description="The path of the file to add an annotation to. For example, `assets/css/main.css`.",
        default=...,
    )
    start_line: int = Field(
        description="The start line of the annotation. Line numbers start at 1.",
        default=...,
    )
    end_line: int = Field(description="The end line of the annotation.", default=...)
    start_column: Missing[int] = Field(
        description="The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values. Column numbers start at 1.",
        default=UNSET,
    )
    end_column: Missing[int] = Field(
        description="The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.",
        default=UNSET,
    )
    annotation_level: Literal["notice", "warning", "failure"] = Field(
        description="The level of the annotation.", default=...
    )
    message: str = Field(
        description="A short description of the feedback for these lines of code. The maximum size is 64 KB.",
        default=...,
    )
    title: Missing[str] = Field(
        description="The title that represents the annotation. The maximum size is 255 characters.",
        default=UNSET,
    )
    raw_details: Missing[str] = Field(
        description="Details about this annotation. The maximum size is 64 KB.",
        default=UNSET,
    )


class ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropImagesItems(
    GitHubRestModel
):
    """ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropImagesItems"""

    alt: str = Field(description="The alternative text for the image.", default=...)
    image_url: str = Field(description="The full URL of the image.", default=...)
    caption: Missing[str] = Field(
        description="A short image description.", default=UNSET
    )


class ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropActionsItems(GitHubRestModel):
    """ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropActionsItems"""

    label: str = Field(
        description="The text to be displayed on a button in the web UI. The maximum size is 20 characters.",
        max_length=20,
        default=...,
    )
    description: str = Field(
        description="A short explanation of what this action would do. The maximum size is 40 characters.",
        max_length=40,
        default=...,
    )
    identifier: str = Field(
        description="A reference for the action on the integrator's system. The maximum size is 20 characters.",
        max_length=20,
        default=...,
    )


class ReposOwnerRepoCheckRunsCheckRunIdPatchBodyAnyof0(
    GitHubRestModel, extra=Extra.allow
):
    """ReposOwnerRepoCheckRunsCheckRunIdPatchBodyAnyof0"""

    name: Missing[str] = Field(
        description='The name of the check. For example, "code-coverage".',
        default=UNSET,
    )
    details_url: Missing[str] = Field(
        description="The URL of the integrator's site that has the full details of the check.",
        default=UNSET,
    )
    external_id: Missing[str] = Field(
        description="A reference for the run on the integrator's system.", default=UNSET
    )
    started_at: Missing[datetime] = Field(
        description="This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    status: Missing[Literal["completed"]] = Field(default=UNSET)
    conclusion: Literal[
        "action_required",
        "cancelled",
        "failure",
        "neutral",
        "success",
        "skipped",
        "stale",
        "timed_out",
    ] = Field(
        description="**Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. \n**Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. You cannot change a check run conclusion to `stale`, only GitHub can set this.",
        default=...,
    )
    completed_at: Missing[datetime] = Field(
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    output: Missing[ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutput] = Field(
        description="Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run.",
        default=UNSET,
    )
    actions: Missing[
        List[ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropActionsItems]
    ] = Field(
        description='Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://docs.github.com/rest/guides/using-the-rest-api-to-interact-with-checks#check-runs-and-requested-actions)."',
        default=UNSET,
    )


class ReposOwnerRepoCheckRunsCheckRunIdPatchBodyAnyof1(
    GitHubRestModel, extra=Extra.allow
):
    """ReposOwnerRepoCheckRunsCheckRunIdPatchBodyAnyof1"""

    name: Missing[str] = Field(
        description='The name of the check. For example, "code-coverage".',
        default=UNSET,
    )
    details_url: Missing[str] = Field(
        description="The URL of the integrator's site that has the full details of the check.",
        default=UNSET,
    )
    external_id: Missing[str] = Field(
        description="A reference for the run on the integrator's system.", default=UNSET
    )
    started_at: Missing[datetime] = Field(
        description="This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    status: Missing[Literal["queued", "in_progress"]] = Field(default=UNSET)
    conclusion: Missing[
        Literal[
            "action_required",
            "cancelled",
            "failure",
            "neutral",
            "success",
            "skipped",
            "stale",
            "timed_out",
        ]
    ] = Field(
        description="**Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. \n**Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. You cannot change a check run conclusion to `stale`, only GitHub can set this.",
        default=UNSET,
    )
    completed_at: Missing[datetime] = Field(
        description="The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    output: Missing[ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutput] = Field(
        description="Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run.",
        default=UNSET,
    )
    actions: Missing[
        List[ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropActionsItems]
    ] = Field(
        description='Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://docs.github.com/rest/guides/using-the-rest-api-to-interact-with-checks#check-runs-and-requested-actions)."',
        default=UNSET,
    )


class ReposOwnerRepoCheckSuitesPostBody(GitHubRestModel):
    """ReposOwnerRepoCheckSuitesPostBody"""

    head_sha: str = Field(description="The sha of the head commit.", default=...)


class ReposOwnerRepoCheckSuitesPreferencesPatchBody(GitHubRestModel):
    """ReposOwnerRepoCheckSuitesPreferencesPatchBody"""

    auto_trigger_checks: Missing[
        List[ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItems]
    ] = Field(
        description="Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default.",
        default=UNSET,
    )


class ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItems(
    GitHubRestModel
):
    """ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItems"""

    app_id: int = Field(description="The `id` of the GitHub App.", default=...)
    setting: bool = Field(
        description="Set to `true` to enable automatic creation of CheckSuite events upon pushes to the repository, or `false` to disable them.",
        default=True,
    )


class ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200"""

    total_count: int = Field(default=...)
    check_runs: List[CheckRun] = Field(default=...)


class ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBody(GitHubRestModel):
    """ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBody"""

    state: Literal["open", "dismissed"] = Field(
        description="Sets the state of the code scanning alert. You must provide `dismissed_reason` when you set the state to `dismissed`.",
        default=...,
    )
    dismissed_reason: Missing[
        Union[None, Literal["false positive", "won't fix", "used in tests"]]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert.",
        default=UNSET,
    )
    dismissed_comment: Missing[
        Annotated[Union[str, None], Field(max_length=280)]
    ] = Field(
        description="The dismissal comment associated with the dismissal of the alert.",
        default=UNSET,
    )


class ReposOwnerRepoCodeScanningSarifsPostBody(GitHubRestModel):
    """ReposOwnerRepoCodeScanningSarifsPostBody"""

    commit_sha: str = Field(
        description="The SHA of the commit to which the analysis you are uploading relates.",
        min_length=40,
        max_length=40,
        pattern="^[0-9a-fA-F]+$",
        default=...,
    )
    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`,\n`refs/pull/<number>/merge`, or `refs/pull/<number>/head`.",
        default=...,
    )
    sarif: str = Field(
        description='A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string. For more information, see "[SARIF support for code scanning](https://docs.github.com/code-security/secure-coding/sarif-support-for-code-scanning)."',
        default=...,
    )
    checkout_uri: Missing[str] = Field(
        description="The base directory used in the analysis, as it appears in the SARIF file.\nThis property is used to convert file paths from absolute to relative, so that alerts can be mapped to their correct location in the repository.",
        default=UNSET,
    )
    started_at: Missing[datetime] = Field(
        description="The time that the analysis run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )
    tool_name: Missing[str] = Field(
        description='The name of the tool used to generate the code scanning analysis. If this parameter is not used, the tool name defaults to "API". If the uploaded SARIF contains a tool GUID, this will be available for filtering using the `tool_guid` parameter of operations such as `GET /repos/{owner}/{repo}/code-scanning/alerts`.',
        default=UNSET,
    )
    validate_: Missing[bool] = Field(
        description="Whether the SARIF file will be validated according to the code scanning specifications.\nThis parameter is intended to help integrators ensure that the uploaded SARIF files are correctly rendered by code scanning.",
        default=UNSET,
        alias="validate",
    )


class ReposOwnerRepoCodespacesGetResponse200(GitHubRestModel):
    """ReposOwnerRepoCodespacesGetResponse200"""

    total_count: int = Field(default=...)
    codespaces: List[Codespace] = Field(default=...)


class ReposOwnerRepoCodespacesPostBody(GitHubRestModel):
    """ReposOwnerRepoCodespacesPostBody"""

    ref: Missing[str] = Field(
        description="Git ref (typically a branch name) for this codespace",
        default=UNSET,
    )
    location: Missing[str] = Field(
        description="The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.",
        default=UNSET,
    )
    geo: Missing[Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]] = Field(
        description="The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is being deprecated.",
        default=UNSET,
    )
    client_ip: Missing[str] = Field(
        description="IP for location auto-detection when proxying a request",
        default=UNSET,
    )
    machine: Missing[str] = Field(
        description="Machine type to use for this codespace", default=UNSET
    )
    devcontainer_path: Missing[str] = Field(
        description="Path to devcontainer.json config to use for this codespace",
        default=UNSET,
    )
    multi_repo_permissions_opt_out: Missing[bool] = Field(
        description="Whether to authorize requested permissions from devcontainer.json",
        default=UNSET,
    )
    working_directory: Missing[str] = Field(
        description="Working directory for this codespace", default=UNSET
    )
    idle_timeout_minutes: Missing[int] = Field(
        description="Time in minutes before codespace stops from inactivity",
        default=UNSET,
    )
    display_name: Missing[str] = Field(
        description="Display name for this codespace", default=UNSET
    )
    retention_period_minutes: Missing[int] = Field(
        description="Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).",
        default=UNSET,
    )


class ReposOwnerRepoCodespacesDevcontainersGetResponse200(GitHubRestModel):
    """ReposOwnerRepoCodespacesDevcontainersGetResponse200"""

    total_count: int = Field(default=...)
    devcontainers: List[
        ReposOwnerRepoCodespacesDevcontainersGetResponse200PropDevcontainersItems
    ] = Field(default=...)


class ReposOwnerRepoCodespacesDevcontainersGetResponse200PropDevcontainersItems(
    GitHubRestModel
):
    """ReposOwnerRepoCodespacesDevcontainersGetResponse200PropDevcontainersItems"""

    path: str = Field(default=...)
    name: Missing[str] = Field(default=UNSET)
    display_name: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoCodespacesMachinesGetResponse200(GitHubRestModel):
    """ReposOwnerRepoCodespacesMachinesGetResponse200"""

    total_count: int = Field(default=...)
    machines: List[CodespaceMachine] = Field(default=...)


class ReposOwnerRepoCodespacesNewGetResponse200(GitHubRestModel):
    """ReposOwnerRepoCodespacesNewGetResponse200"""

    billable_owner: Missing[SimpleUser] = Field(
        title="Simple User", description="A GitHub user.", default=UNSET
    )
    defaults: Missing[ReposOwnerRepoCodespacesNewGetResponse200PropDefaults] = Field(
        default=UNSET
    )


class ReposOwnerRepoCodespacesNewGetResponse200PropDefaults(GitHubRestModel):
    """ReposOwnerRepoCodespacesNewGetResponse200PropDefaults"""

    location: str = Field(default=...)
    devcontainer_path: Union[str, None] = Field(default=...)


class ReposOwnerRepoCodespacesSecretsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoCodespacesSecretsGetResponse200"""

    total_count: int = Field(default=...)
    secrets: List[RepoCodespacesSecret] = Field(default=...)


class ReposOwnerRepoCodespacesSecretsSecretNamePutBody(GitHubRestModel):
    """ReposOwnerRepoCodespacesSecretsSecretNamePutBody"""

    encrypted_value: Missing[
        Annotated[
            str,
            Field(
                pattern="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$"
            ),
        ]
    ] = Field(
        description="Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://docs.github.com/rest/codespaces/repository-secrets#get-a-repository-public-key) endpoint.",
        default=UNSET,
    )
    key_id: Missing[str] = Field(
        description="ID of the key you used to encrypt the secret.", default=UNSET
    )


class ReposOwnerRepoCollaboratorsUsernamePutBody(GitHubRestModel):
    """ReposOwnerRepoCollaboratorsUsernamePutBody"""

    permission: Missing[str] = Field(
        description="The permission to grant the collaborator. **Only valid on organization-owned repositories.** We accept the following permissions to be set: `pull`, `triage`, `push`, `maintain`, `admin` and you can also specify a custom repository role name, if the owning organization has defined any.",
        default="push",
    )


class ReposOwnerRepoCommentsCommentIdPatchBody(GitHubRestModel):
    """ReposOwnerRepoCommentsCommentIdPatchBody"""

    body: str = Field(description="The contents of the comment", default=...)


class ReposOwnerRepoCommentsCommentIdReactionsPostBody(GitHubRestModel):
    """ReposOwnerRepoCommentsCommentIdReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(
        description="The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the commit comment.",
        default=...,
    )


class ReposOwnerRepoCommitsCommitShaCommentsPostBody(GitHubRestModel):
    """ReposOwnerRepoCommitsCommitShaCommentsPostBody"""

    body: str = Field(description="The contents of the comment.", default=...)
    path: Missing[str] = Field(
        description="Relative path of the file to comment on.", default=UNSET
    )
    position: Missing[int] = Field(
        description="Line index in the diff to comment on.", default=UNSET
    )
    line: Missing[int] = Field(
        description="**Deprecated**. Use **position** parameter instead. Line number in the file to comment on.",
        default=UNSET,
    )


class ReposOwnerRepoCommitsRefCheckRunsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoCommitsRefCheckRunsGetResponse200"""

    total_count: int = Field(default=...)
    check_runs: List[CheckRun] = Field(default=...)


class ReposOwnerRepoCommitsRefCheckSuitesGetResponse200(GitHubRestModel):
    """ReposOwnerRepoCommitsRefCheckSuitesGetResponse200"""

    total_count: int = Field(default=...)
    check_suites: List[CheckSuite] = Field(default=...)


class ReposOwnerRepoContentsPathPutBody(GitHubRestModel):
    """ReposOwnerRepoContentsPathPutBody"""

    message: str = Field(description="The commit message.", default=...)
    content: str = Field(
        description="The new file content, using Base64 encoding.", default=...
    )
    sha: Missing[str] = Field(
        description="**Required if you are updating a file**. The blob SHA of the file being replaced.",
        default=UNSET,
    )
    branch: Missing[str] = Field(
        description="The branch name. Default: the repository’s default branch.",
        default=UNSET,
    )
    committer: Missing[ReposOwnerRepoContentsPathPutBodyPropCommitter] = Field(
        description="The person that committed the file. Default: the authenticated user.",
        default=UNSET,
    )
    author: Missing[ReposOwnerRepoContentsPathPutBodyPropAuthor] = Field(
        description="The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.",
        default=UNSET,
    )


class ReposOwnerRepoContentsPathPutBodyPropCommitter(GitHubRestModel):
    """ReposOwnerRepoContentsPathPutBodyPropCommitter

    The person that committed the file. Default: the authenticated user.
    """

    name: str = Field(
        description="The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.",
        default=...,
    )
    email: str = Field(
        description="The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.",
        default=...,
    )
    date: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoContentsPathPutBodyPropAuthor(GitHubRestModel):
    """ReposOwnerRepoContentsPathPutBodyPropAuthor

    The author of the file. Default: The `committer` or the authenticated user if
    you omit `committer`.
    """

    name: str = Field(
        description="The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.",
        default=...,
    )
    email: str = Field(
        description="The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.",
        default=...,
    )
    date: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoContentsPathDeleteBody(GitHubRestModel):
    """ReposOwnerRepoContentsPathDeleteBody"""

    message: str = Field(description="The commit message.", default=...)
    sha: str = Field(description="The blob SHA of the file being deleted.", default=...)
    branch: Missing[str] = Field(
        description="The branch name. Default: the repository’s default branch",
        default=UNSET,
    )
    committer: Missing[ReposOwnerRepoContentsPathDeleteBodyPropCommitter] = Field(
        description="object containing information about the committer.", default=UNSET
    )
    author: Missing[ReposOwnerRepoContentsPathDeleteBodyPropAuthor] = Field(
        description="object containing information about the author.", default=UNSET
    )


class ReposOwnerRepoContentsPathDeleteBodyPropCommitter(GitHubRestModel):
    """ReposOwnerRepoContentsPathDeleteBodyPropCommitter

    object containing information about the committer.
    """

    name: Missing[str] = Field(
        description="The name of the author (or committer) of the commit", default=UNSET
    )
    email: Missing[str] = Field(
        description="The email of the author (or committer) of the commit",
        default=UNSET,
    )


class ReposOwnerRepoContentsPathDeleteBodyPropAuthor(GitHubRestModel):
    """ReposOwnerRepoContentsPathDeleteBodyPropAuthor

    object containing information about the author.
    """

    name: Missing[str] = Field(
        description="The name of the author (or committer) of the commit", default=UNSET
    )
    email: Missing[str] = Field(
        description="The email of the author (or committer) of the commit",
        default=UNSET,
    )


class ReposOwnerRepoDependabotAlertsAlertNumberPatchBody(GitHubRestModel):
    """ReposOwnerRepoDependabotAlertsAlertNumberPatchBody"""

    state: Literal["dismissed", "open"] = Field(
        description="The state of the Dependabot alert.\nA `dismissed_reason` must be provided when setting the state to `dismissed`.",
        default=...,
    )
    dismissed_reason: Missing[
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ]
    ] = Field(
        description="**Required when `state` is `dismissed`.** A reason for dismissing the alert.",
        default=UNSET,
    )
    dismissed_comment: Missing[Annotated[str, Field(max_length=280)]] = Field(
        description="An optional comment associated with dismissing the alert.",
        default=UNSET,
    )


class ReposOwnerRepoDependabotSecretsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoDependabotSecretsGetResponse200"""

    total_count: int = Field(default=...)
    secrets: List[DependabotSecret] = Field(default=...)


class ReposOwnerRepoDependabotSecretsSecretNamePutBody(GitHubRestModel):
    """ReposOwnerRepoDependabotSecretsSecretNamePutBody"""

    encrypted_value: Missing[
        Annotated[
            str,
            Field(
                pattern="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$"
            ),
        ]
    ] = Field(
        description="Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://docs.github.com/rest/dependabot/secrets#get-a-repository-public-key) endpoint.",
        default=UNSET,
    )
    key_id: Missing[str] = Field(
        description="ID of the key you used to encrypt the secret.", default=UNSET
    )


class ReposOwnerRepoDependencyGraphSnapshotsPostResponse201(GitHubRestModel):
    """ReposOwnerRepoDependencyGraphSnapshotsPostResponse201"""

    id: int = Field(description="ID of the created snapshot.", default=...)
    created_at: str = Field(
        description="The time at which the snapshot was created.", default=...
    )
    result: str = Field(
        description='Either "SUCCESS", "ACCEPTED", or "INVALID". "SUCCESS" indicates that the snapshot was successfully created and the repository\'s dependencies were updated. "ACCEPTED" indicates that the snapshot was successfully created, but the repository\'s dependencies were not updated. "INVALID" indicates that the snapshot was malformed.',
        default=...,
    )
    message: str = Field(
        description="A message providing further details about the result, such as why the dependencies were not updated.",
        default=...,
    )


class ReposOwnerRepoDeploymentsPostBody(GitHubRestModel):
    """ReposOwnerRepoDeploymentsPostBody"""

    ref: str = Field(
        description="The ref to deploy. This can be a branch, tag, or SHA.", default=...
    )
    task: Missing[str] = Field(
        description="Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).",
        default="deploy",
    )
    auto_merge: Missing[bool] = Field(
        description="Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.",
        default=True,
    )
    required_contexts: Missing[List[str]] = Field(
        description="The [status](https://docs.github.com/rest/commits/statuses) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.",
        default=UNSET,
    )
    payload: Missing[
        Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0, str]
    ] = Field(
        description="JSON payload with extra information about the deployment.",
        default="",
    )
    environment: Missing[str] = Field(
        description="Name for the target deployment environment (e.g., `production`, `staging`, `qa`).",
        default="production",
    )
    description: Missing[Union[str, None]] = Field(
        description="Short description of the deployment.", default=""
    )
    transient_environment: Missing[bool] = Field(
        description="Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`",
        default=False,
    )
    production_environment: Missing[bool] = Field(
        description="Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.",
        default=UNSET,
    )


class ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0(
    GitHubRestModel, extra=Extra.allow
):
    """ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0"""


class ReposOwnerRepoDeploymentsPostResponse202(GitHubRestModel):
    """ReposOwnerRepoDeploymentsPostResponse202"""

    message: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody(GitHubRestModel):
    """ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody"""

    state: Literal[
        "error", "failure", "inactive", "in_progress", "queued", "pending", "success"
    ] = Field(
        description="The state of the status. When you set a transient deployment to `inactive`, the deployment will be shown as `destroyed` in GitHub.",
        default=...,
    )
    target_url: Missing[str] = Field(
        description="The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.",
        default="",
    )
    log_url: Missing[str] = Field(
        description='The full URL of the deployment\'s output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `""`',
        default="",
    )
    description: Missing[str] = Field(
        description="A short description of the status. The maximum description length is 140 characters.",
        default="",
    )
    environment: Missing[str] = Field(
        description="Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. If not defined, the environment of the previous status on the deployment will be used, if it exists. Otherwise, the environment of the deployment will be used.",
        default=UNSET,
    )
    environment_url: Missing[str] = Field(
        description='Sets the URL for accessing your environment. Default: `""`',
        default="",
    )
    auto_inactive: Missing[bool] = Field(
        description="Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`",
        default=UNSET,
    )


class ReposOwnerRepoDispatchesPostBody(GitHubRestModel):
    """ReposOwnerRepoDispatchesPostBody"""

    event_type: str = Field(
        description="A custom webhook event name. Must be 100 characters or fewer.",
        min_length=1,
        max_length=100,
        default=...,
    )
    client_payload: Missing[ReposOwnerRepoDispatchesPostBodyPropClientPayload] = Field(
        description="JSON payload with extra information about the webhook event that your action or workflow may use. The maximum number of top-level properties is 10.",
        default=UNSET,
    )


class ReposOwnerRepoDispatchesPostBodyPropClientPayload(
    GitHubRestModel, extra=Extra.allow
):
    """ReposOwnerRepoDispatchesPostBodyPropClientPayload

    JSON payload with extra information about the webhook event that your action or
    workflow may use. The maximum number of top-level properties is 10.
    """


class ReposOwnerRepoEnvironmentsGetResponse200(GitHubRestModel):
    """ReposOwnerRepoEnvironmentsGetResponse200"""

    total_count: Missing[int] = Field(
        description="The number of environments in this repository", default=UNSET
    )
    environments: Missing[List[Environment]] = Field(default=UNSET)


class ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItems(
    GitHubRestModel
):
    """ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItems"""

    type: Missing[Literal["User", "Team"]] = Field(
        description="The type of reviewer.", default=UNSET
    )
    id: Missing[int] = Field(
        description="The id of the user or team who can review the deployment",
        default=UNSET,
    )


class ReposOwnerRepoEnvironmentsEnvironmentNamePutBody(GitHubRestModel):
    """ReposOwnerRepoEnvironmentsEnvironmentNamePutBody"""

    wait_timer: Missing[int] = Field(
        description="The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).",
        default=UNSET,
    )
    reviewers: Missing[
        Union[
            List[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItems],
            None,
        ]
    ] = Field(
        description="The people or teams that may review jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.",
        default=UNSET,
    )
    deployment_branch_policy: Missing[
        Union[DeploymentBranchPolicySettings, None]
    ] = Field(
        description="The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`.",
        default=UNSET,
    )


class ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200(
    GitHubRestModel
):
    """ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200"""

    total_count: int = Field(
        description="The number of deployment branch policies for the environment.",
        default=...,
    )
    branch_policies: List[DeploymentBranchPolicy] = Field(default=...)


class ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200(
    GitHubRestModel
):
    """ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200

    Examples:
        {'$ref': '#/components/examples/deployment-protection-rules'}
    """

    total_count: Missing[int] = Field(
        description="The number of enabled custom deployment protection rules for this environment",
        default=UNSET,
    )
    custom_deployment_protection_rules: Missing[List[DeploymentProtectionRule]] = Field(
        default=UNSET
    )


class ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody(
    GitHubRestModel
):
    """ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody"""

    integration_id: Missing[int] = Field(
        description="The ID of the custom app that will be enabled on the environment.",
        default=UNSET,
    )


class ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200(
    GitHubRestModel
):
    """ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetRespons
    e200
    """

    total_count: Missing[int] = Field(
        description="The total number of custom deployment protection rule integrations available for this environment.",
        default=UNSET,
    )
    available_custom_deployment_protection_rule_integrations: Missing[
        List[CustomDeploymentRuleApp]
    ] = Field(default=UNSET)


class ReposOwnerRepoForksPostBody(GitHubRestModel):
    """ReposOwnerRepoForksPostBody"""

    organization: Missing[str] = Field(
        description="Optional parameter to specify the organization name if forking into an organization.",
        default=UNSET,
    )
    name: Missing[str] = Field(
        description="When forking from an existing repository, a new name for the fork.",
        default=UNSET,
    )
    default_branch_only: Missing[bool] = Field(
        description="When forking from an existing repository, fork with only the default branch.",
        default=UNSET,
    )


class ReposOwnerRepoGitBlobsPostBody(GitHubRestModel):
    """ReposOwnerRepoGitBlobsPostBody"""

    content: str = Field(description="The new blob's content.", default=...)
    encoding: Missing[str] = Field(
        description='The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.',
        default="utf-8",
    )


class ReposOwnerRepoGitCommitsPostBody(GitHubRestModel):
    """ReposOwnerRepoGitCommitsPostBody"""

    message: str = Field(description="The commit message", default=...)
    tree: str = Field(
        description="The SHA of the tree object this commit points to", default=...
    )
    parents: Missing[List[str]] = Field(
        description="The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.",
        default=UNSET,
    )
    author: Missing[ReposOwnerRepoGitCommitsPostBodyPropAuthor] = Field(
        description="Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.",
        default=UNSET,
    )
    committer: Missing[ReposOwnerRepoGitCommitsPostBodyPropCommitter] = Field(
        description="Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.",
        default=UNSET,
    )
    signature: Missing[str] = Field(
        description="The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.",
        default=UNSET,
    )


class ReposOwnerRepoGitCommitsPostBodyPropAuthor(GitHubRestModel):
    """ReposOwnerRepoGitCommitsPostBodyPropAuthor

    Information about the author of the commit. By default, the `author` will be the
    authenticated user and the current date. See the `author` and `committer` object
    below for details.
    """

    name: str = Field(
        description="The name of the author (or committer) of the commit", default=...
    )
    email: str = Field(
        description="The email of the author (or committer) of the commit", default=...
    )
    date: Missing[datetime] = Field(
        description="Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )


class ReposOwnerRepoGitCommitsPostBodyPropCommitter(GitHubRestModel):
    """ReposOwnerRepoGitCommitsPostBodyPropCommitter

    Information about the person who is making the commit. By default, `committer`
    will use the information set in `author`. See the `author` and `committer`
    object below for details.
    """

    name: Missing[str] = Field(
        description="The name of the author (or committer) of the commit", default=UNSET
    )
    email: Missing[str] = Field(
        description="The email of the author (or committer) of the commit",
        default=UNSET,
    )
    date: Missing[datetime] = Field(
        description="Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )


class ReposOwnerRepoGitRefsPostBody(GitHubRestModel):
    """ReposOwnerRepoGitRefsPostBody"""

    ref: str = Field(
        description="The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.",
        default=...,
    )
    sha: str = Field(description="The SHA1 value for this reference.", default=...)


class ReposOwnerRepoGitRefsRefPatchBody(GitHubRestModel):
    """ReposOwnerRepoGitRefsRefPatchBody"""

    sha: str = Field(description="The SHA1 value to set this reference to", default=...)
    force: Missing[bool] = Field(
        description="Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.",
        default=False,
    )


class ReposOwnerRepoGitTagsPostBody(GitHubRestModel):
    """ReposOwnerRepoGitTagsPostBody"""

    tag: str = Field(
        description='The tag\'s name. This is typically a version (e.g., "v0.0.1").',
        default=...,
    )
    message: str = Field(description="The tag message.", default=...)
    object_: str = Field(
        description="The SHA of the git object this is tagging.",
        default=...,
        alias="object",
    )
    type: Literal["commit", "tree", "blob"] = Field(
        description="The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.",
        default=...,
    )
    tagger: Missing[ReposOwnerRepoGitTagsPostBodyPropTagger] = Field(
        description="An object with information about the individual creating the tag.",
        default=UNSET,
    )


class ReposOwnerRepoGitTagsPostBodyPropTagger(GitHubRestModel):
    """ReposOwnerRepoGitTagsPostBodyPropTagger

    An object with information about the individual creating the tag.
    """

    name: str = Field(description="The name of the author of the tag", default=...)
    email: str = Field(description="The email of the author of the tag", default=...)
    date: Missing[datetime] = Field(
        description="When this object was tagged. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )


class ReposOwnerRepoGitTreesPostBody(GitHubRestModel):
    """ReposOwnerRepoGitTreesPostBody"""

    tree: List[ReposOwnerRepoGitTreesPostBodyPropTreeItems] = Field(
        description="Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.",
        default=...,
    )
    base_tree: Missing[str] = Field(
        description="The SHA1 of an existing Git tree object which will be used as the base for the new tree. If provided, a new Git tree object will be created from entries in the Git tree object pointed to by `base_tree` and entries defined in the `tree` parameter. Entries defined in the `tree` parameter will overwrite items from `base_tree` with the same `path`. If you're creating new changes on a branch, then normally you'd set `base_tree` to the SHA1 of the Git tree object of the current latest commit on the branch you're working on.\nIf not provided, GitHub will create a new Git tree object from only the entries defined in the `tree` parameter. If you create a new commit pointing to such a tree, then all files which were a part of the parent commit's tree and were not defined in the `tree` parameter will be listed as deleted by the new commit.\n",
        default=UNSET,
    )


class ReposOwnerRepoGitTreesPostBodyPropTreeItems(GitHubRestModel):
    """ReposOwnerRepoGitTreesPostBodyPropTreeItems"""

    path: Missing[str] = Field(
        description="The file referenced in the tree.", default=UNSET
    )
    mode: Missing[Literal["100644", "100755", "040000", "160000", "120000"]] = Field(
        description="The file mode; one of `100644` for file (blob), `100755` for executable (blob), `040000` for subdirectory (tree), `160000` for submodule (commit), or `120000` for a blob that specifies the path of a symlink.",
        default=UNSET,
    )
    type: Missing[Literal["blob", "tree", "commit"]] = Field(
        description="Either `blob`, `tree`, or `commit`.", default=UNSET
    )
    sha: Missing[Union[str, None]] = Field(
        description="The SHA1 checksum ID of the object in the tree. Also called `tree.sha`. If the value is `null` then the file will be deleted.  \n  \n**Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.",
        default=UNSET,
    )
    content: Missing[str] = Field(
        description="The content you want this file to have. GitHub will write this blob out and use that SHA for this entry. Use either this, or `tree.sha`.  \n  \n**Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.",
        default=UNSET,
    )


class ReposOwnerRepoHooksPostBodyPropConfig(GitHubRestModel):
    """ReposOwnerRepoHooksPostBodyPropConfig

    Key/value pairs to provide settings for this webhook.
    """

    url: Missing[str] = Field(
        description="The URL to which the payloads will be delivered.", default=UNSET
    )
    content_type: Missing[str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    insecure_ssl: Missing[Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )
    token: Missing[str] = Field(default=UNSET)
    digest: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoHooksPostBody(GitHubRestModel):
    """ReposOwnerRepoHooksPostBody"""

    name: Missing[str] = Field(
        description="Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.",
        default=UNSET,
    )
    config: Missing[ReposOwnerRepoHooksPostBodyPropConfig] = Field(
        description="Key/value pairs to provide settings for this webhook.",
        default=UNSET,
    )
    events: Missing[List[str]] = Field(
        description="Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.",
        default=["push"],
    )
    active: Missing[bool] = Field(
        description="Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.",
        default=True,
    )


class ReposOwnerRepoHooksHookIdPatchBody(GitHubRestModel):
    """ReposOwnerRepoHooksHookIdPatchBody"""

    config: Missing[ReposOwnerRepoHooksHookIdPatchBodyPropConfig] = Field(
        description="Key/value pairs to provide settings for this webhook.",
        default=UNSET,
    )
    events: Missing[List[str]] = Field(
        description="Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for. This replaces the entire array of events.",
        default=["push"],
    )
    add_events: Missing[List[str]] = Field(
        description="Determines a list of events to be added to the list of events that the Hook triggers for.",
        default=UNSET,
    )
    remove_events: Missing[List[str]] = Field(
        description="Determines a list of events to be removed from the list of events that the Hook triggers for.",
        default=UNSET,
    )
    active: Missing[bool] = Field(
        description="Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.",
        default=True,
    )


class ReposOwnerRepoHooksHookIdPatchBodyPropConfig(GitHubRestModel):
    """ReposOwnerRepoHooksHookIdPatchBodyPropConfig

    Key/value pairs to provide settings for this webhook.
    """

    url: str = Field(
        description="The URL to which the payloads will be delivered.", default=...
    )
    content_type: Missing[str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    insecure_ssl: Missing[Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )
    address: Missing[str] = Field(default=UNSET)
    room: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoHooksHookIdConfigPatchBody(GitHubRestModel):
    """ReposOwnerRepoHooksHookIdConfigPatchBody"""

    url: Missing[str] = Field(
        description="The URL to which the payloads will be delivered.", default=UNSET
    )
    content_type: Missing[str] = Field(
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
        default=UNSET,
    )
    secret: Missing[str] = Field(
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
        default=UNSET,
    )
    insecure_ssl: Missing[Union[str, float]] = Field(
        description="Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**",
        default=UNSET,
    )


class ReposOwnerRepoImportPutBody(GitHubRestModel):
    """ReposOwnerRepoImportPutBody"""

    vcs_url: str = Field(
        description="The URL of the originating repository.", default=...
    )
    vcs: Missing[Literal["subversion", "git", "mercurial", "tfvc"]] = Field(
        description="The originating VCS type. Without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.",
        default=UNSET,
    )
    vcs_username: Missing[str] = Field(
        description="If authentication is required, the username to provide to `vcs_url`.",
        default=UNSET,
    )
    vcs_password: Missing[str] = Field(
        description="If authentication is required, the password to provide to `vcs_url`.",
        default=UNSET,
    )
    tfvc_project: Missing[str] = Field(
        description="For a tfvc import, the name of the project that is being imported.",
        default=UNSET,
    )


class ReposOwnerRepoImportPatchBody(GitHubRestModel):
    """ReposOwnerRepoImportPatchBody"""

    vcs_username: Missing[str] = Field(
        description="The username to provide to the originating repository.",
        default=UNSET,
    )
    vcs_password: Missing[str] = Field(
        description="The password to provide to the originating repository.",
        default=UNSET,
    )
    vcs: Missing[Literal["subversion", "tfvc", "git", "mercurial"]] = Field(
        description="The type of version control system you are migrating from.",
        default=UNSET,
    )
    tfvc_project: Missing[str] = Field(
        description="For a tfvc import, the name of the project that is being imported.",
        default=UNSET,
    )


class ReposOwnerRepoImportAuthorsAuthorIdPatchBody(GitHubRestModel):
    """ReposOwnerRepoImportAuthorsAuthorIdPatchBody"""

    email: Missing[str] = Field(description="The new Git author email.", default=UNSET)
    name: Missing[str] = Field(description="The new Git author name.", default=UNSET)


class ReposOwnerRepoImportLfsPatchBody(GitHubRestModel):
    """ReposOwnerRepoImportLfsPatchBody"""

    use_lfs: Literal["opt_in", "opt_out"] = Field(
        description="Whether to store large files during the import. `opt_in` means large files will be stored using Git LFS. `opt_out` means large files will be removed during the import.",
        default=...,
    )


class ReposOwnerRepoInteractionLimitsGetResponse200Anyof1(GitHubRestModel):
    """ReposOwnerRepoInteractionLimitsGetResponse200Anyof1"""


class ReposOwnerRepoInvitationsInvitationIdPatchBody(GitHubRestModel):
    """ReposOwnerRepoInvitationsInvitationIdPatchBody"""

    permissions: Missing[
        Literal["read", "write", "maintain", "triage", "admin"]
    ] = Field(
        description="The permissions that the associated user will have on the repository. Valid values are `read`, `write`, `maintain`, `triage`, and `admin`.",
        default=UNSET,
    )


class ReposOwnerRepoIssuesPostBody(GitHubRestModel):
    """ReposOwnerRepoIssuesPostBody"""

    title: Union[str, int] = Field(description="The title of the issue.", default=...)
    body: Missing[str] = Field(description="The contents of the issue.", default=UNSET)
    assignee: Missing[Union[str, None]] = Field(
        description="Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_",
        default=UNSET,
    )
    milestone: Missing[Union[str, int, None]] = Field(
        description="The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._",
        default=UNSET,
    )
    labels: Missing[
        List[Union[str, ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1]]
    ] = Field(
        description="Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._",
        default=UNSET,
    )
    assignees: Missing[List[str]] = Field(
        description="Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._",
        default=UNSET,
    )


class ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1(GitHubRestModel):
    """ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1"""

    id: Missing[int] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    color: Missing[Union[str, None]] = Field(default=UNSET)


class ReposOwnerRepoIssuesCommentsCommentIdPatchBody(GitHubRestModel):
    """ReposOwnerRepoIssuesCommentsCommentIdPatchBody"""

    body: str = Field(description="The contents of the comment.", default=...)


class ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody(GitHubRestModel):
    """ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(
        description="The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the issue comment.",
        default=...,
    )


class ReposOwnerRepoIssuesIssueNumberPatchBody(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberPatchBody"""

    title: Missing[Union[str, int, None]] = Field(
        description="The title of the issue.", default=UNSET
    )
    body: Missing[Union[str, None]] = Field(
        description="The contents of the issue.", default=UNSET
    )
    assignee: Missing[Union[str, None]] = Field(
        description="Username to assign to this issue. **This field is deprecated.**",
        default=UNSET,
    )
    state: Missing[Literal["open", "closed"]] = Field(
        description="The open or closed state of the issue.", default=UNSET
    )
    state_reason: Missing[
        Union[None, Literal["completed", "not_planned", "reopened"]]
    ] = Field(
        description="The reason for the state change. Ignored unless `state` is changed.",
        default=UNSET,
    )
    milestone: Missing[Union[str, int, None]] = Field(
        description="The `number` of the milestone to associate this issue with or use `null` to remove the current milestone. Only users with push access can set the milestone for issues. Without push access to the repository, milestone changes are silently dropped.",
        default=UNSET,
    )
    labels: Missing[
        List[Union[str, ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1]]
    ] = Field(
        description="Labels to associate with this issue. Pass one or more labels to _replace_ the set of labels on this issue. Send an empty array (`[]`) to clear all labels from the issue. Only users with push access can set labels for issues. Without push access to the repository, label changes are silently dropped.",
        default=UNSET,
    )
    assignees: Missing[List[str]] = Field(
        description="Usernames to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this issue. Send an empty array (`[]`) to clear all assignees from the issue. Only users with push access can set assignees for new issues. Without push access to the repository, assignee changes are silently dropped.",
        default=UNSET,
    )


class ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1"""

    id: Missing[int] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    color: Missing[Union[str, None]] = Field(default=UNSET)


class ReposOwnerRepoIssuesIssueNumberAssigneesPostBody(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberAssigneesPostBody"""

    assignees: Missing[List[str]] = Field(
        description="Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._",
        default=UNSET,
    )


class ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody"""

    assignees: Missing[List[str]] = Field(
        description="Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._",
        default=UNSET,
    )


class ReposOwnerRepoIssuesIssueNumberCommentsPostBody(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberCommentsPostBody"""

    body: str = Field(description="The contents of the comment.", default=...)


class ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0"""

    labels: Missing[Annotated[List[str], Field(min_length=1)]] = Field(
        description='The names of the labels to set for the issue. The labels you set replace any existing labels. You can pass an empty array to remove all labels. Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key. You can also add labels to the existing labels for an issue. For more information, see "[Add labels to an issue](https://docs.github.com/rest/issues/labels#add-labels-to-an-issue)."',
        default=UNSET,
    )


class ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2"""

    labels: Missing[
        List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItems]
    ] = Field(default=UNSET)


class ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItems(
    GitHubRestModel
):
    """ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItems"""

    name: str = Field(default=...)


class ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items"""

    name: str = Field(default=...)


class ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0"""

    labels: Missing[Annotated[List[str], Field(min_length=1)]] = Field(
        description='The names of the labels to add to the issue\'s existing labels. You can pass an empty array to remove all labels. Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key. You can also replace all of the labels for an issue. For more information, see "[Set labels for an issue](https://docs.github.com/rest/issues/labels#set-labels-for-an-issue)."',
        default=UNSET,
    )


class ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2"""

    labels: Missing[
        List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItems]
    ] = Field(default=UNSET)


class ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItems(
    GitHubRestModel
):
    """ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItems"""

    name: str = Field(default=...)


class ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items"""

    name: str = Field(default=...)


class ReposOwnerRepoIssuesIssueNumberLockPutBody(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberLockPutBody"""

    lock_reason: Missing[
        Literal["off-topic", "too heated", "resolved", "spam"]
    ] = Field(
        description="The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:  \n * `off-topic`  \n * `too heated`  \n * `resolved`  \n * `spam`",
        default=UNSET,
    )


class ReposOwnerRepoIssuesIssueNumberReactionsPostBody(GitHubRestModel):
    """ReposOwnerRepoIssuesIssueNumberReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(
        description="The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the issue.",
        default=...,
    )


class ReposOwnerRepoKeysPostBody(GitHubRestModel):
    """ReposOwnerRepoKeysPostBody"""

    title: Missing[str] = Field(description="A name for the key.", default=UNSET)
    key: str = Field(description="The contents of the key.", default=...)
    read_only: Missing[bool] = Field(
        description='If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.  \n  \nDeploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see "[Repository permission levels for an organization](https://docs.github.com/articles/repository-permission-levels-for-an-organization/)" and "[Permission levels for a user account repository](https://docs.github.com/articles/permission-levels-for-a-user-account-repository/)."',
        default=UNSET,
    )


class ReposOwnerRepoLabelsPostBody(GitHubRestModel):
    """ReposOwnerRepoLabelsPostBody"""

    name: str = Field(
        description='The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see "[Emoji cheat sheet](https://github.com/ikatyang/emoji-cheat-sheet)."',
        default=...,
    )
    color: Missing[str] = Field(
        description="The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.",
        default=UNSET,
    )
    description: Missing[str] = Field(
        description="A short description of the label. Must be 100 characters or fewer.",
        default=UNSET,
    )


class ReposOwnerRepoLabelsNamePatchBody(GitHubRestModel):
    """ReposOwnerRepoLabelsNamePatchBody"""

    new_name: Missing[str] = Field(
        description='The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see "[Emoji cheat sheet](https://github.com/ikatyang/emoji-cheat-sheet)."',
        default=UNSET,
    )
    color: Missing[str] = Field(
        description="The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.",
        default=UNSET,
    )
    description: Missing[str] = Field(
        description="A short description of the label. Must be 100 characters or fewer.",
        default=UNSET,
    )


class ReposOwnerRepoMergeUpstreamPostBody(GitHubRestModel):
    """ReposOwnerRepoMergeUpstreamPostBody"""

    branch: str = Field(
        description="The name of the branch which should be updated to match upstream.",
        default=...,
    )


class ReposOwnerRepoMergesPostBody(GitHubRestModel):
    """ReposOwnerRepoMergesPostBody"""

    base: str = Field(
        description="The name of the base branch that the head will be merged into.",
        default=...,
    )
    head: str = Field(
        description="The head to merge. This can be a branch name or a commit SHA1.",
        default=...,
    )
    commit_message: Missing[str] = Field(
        description="Commit message to use for the merge commit. If omitted, a default message will be used.",
        default=UNSET,
    )


class ReposOwnerRepoMilestonesPostBody(GitHubRestModel):
    """ReposOwnerRepoMilestonesPostBody"""

    title: str = Field(description="The title of the milestone.", default=...)
    state: Missing[Literal["open", "closed"]] = Field(
        description="The state of the milestone. Either `open` or `closed`.",
        default="open",
    )
    description: Missing[str] = Field(
        description="A description of the milestone.", default=UNSET
    )
    due_on: Missing[datetime] = Field(
        description="The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )


class ReposOwnerRepoMilestonesMilestoneNumberPatchBody(GitHubRestModel):
    """ReposOwnerRepoMilestonesMilestoneNumberPatchBody"""

    title: Missing[str] = Field(
        description="The title of the milestone.", default=UNSET
    )
    state: Missing[Literal["open", "closed"]] = Field(
        description="The state of the milestone. Either `open` or `closed`.",
        default="open",
    )
    description: Missing[str] = Field(
        description="A description of the milestone.", default=UNSET
    )
    due_on: Missing[datetime] = Field(
        description="The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.",
        default=UNSET,
    )


class ReposOwnerRepoNotificationsPutBody(GitHubRestModel):
    """ReposOwnerRepoNotificationsPutBody"""

    last_read_at: Missing[datetime] = Field(
        description="Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.",
        default=UNSET,
    )


class ReposOwnerRepoNotificationsPutResponse202(GitHubRestModel):
    """ReposOwnerRepoNotificationsPutResponse202"""

    message: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoPagesPutBodyPropSourceAnyof1(GitHubRestModel):
    """ReposOwnerRepoPagesPutBodyPropSourceAnyof1

    Update the source for the repository. Must include the branch name and path.
    """

    branch: str = Field(
        description="The repository branch used to publish your site's source files.",
        default=...,
    )
    path: Literal["/", "/docs"] = Field(
        description="The repository directory that includes the source files for the Pages site. Allowed paths are `/` or `/docs`.",
        default=...,
    )


class ReposOwnerRepoPagesPutBodyAnyof0(GitHubRestModel):
    """ReposOwnerRepoPagesPutBodyAnyof0"""

    cname: Missing[Union[str, None]] = Field(
        description='Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://docs.github.com/articles/using-a-custom-domain-with-github-pages/)."',
        default=UNSET,
    )
    https_enforced: Missing[bool] = Field(
        description="Specify whether HTTPS should be enforced for the repository.",
        default=UNSET,
    )
    build_type: Literal["legacy", "workflow"] = Field(
        description="The process by which the GitHub Pages site will be built. `workflow` means that the site is built by a custom GitHub Actions workflow. `legacy` means that the site is built by GitHub when changes are pushed to a specific branch.",
        default=...,
    )
    source: Missing[
        Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1,
        ]
    ] = Field(
        description="Update the source for the repository. Must include the branch name and path.",
        default=UNSET,
    )


class ReposOwnerRepoPagesPutBodyAnyof1(GitHubRestModel):
    """ReposOwnerRepoPagesPutBodyAnyof1"""

    cname: Missing[Union[str, None]] = Field(
        description='Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://docs.github.com/articles/using-a-custom-domain-with-github-pages/)."',
        default=UNSET,
    )
    https_enforced: Missing[bool] = Field(
        description="Specify whether HTTPS should be enforced for the repository.",
        default=UNSET,
    )
    build_type: Missing[Literal["legacy", "workflow"]] = Field(
        description="The process by which the GitHub Pages site will be built. `workflow` means that the site is built by a custom GitHub Actions workflow. `legacy` means that the site is built by GitHub when changes are pushed to a specific branch.",
        default=UNSET,
    )
    source: Union[
        Literal["gh-pages", "master", "master /docs"],
        ReposOwnerRepoPagesPutBodyPropSourceAnyof1,
    ] = Field(
        description="Update the source for the repository. Must include the branch name and path.",
        default=...,
    )


class ReposOwnerRepoPagesPutBodyAnyof2(GitHubRestModel):
    """ReposOwnerRepoPagesPutBodyAnyof2"""

    cname: Union[str, None] = Field(
        description='Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://docs.github.com/articles/using-a-custom-domain-with-github-pages/)."',
        default=...,
    )
    https_enforced: Missing[bool] = Field(
        description="Specify whether HTTPS should be enforced for the repository.",
        default=UNSET,
    )
    build_type: Missing[Literal["legacy", "workflow"]] = Field(
        description="The process by which the GitHub Pages site will be built. `workflow` means that the site is built by a custom GitHub Actions workflow. `legacy` means that the site is built by GitHub when changes are pushed to a specific branch.",
        default=UNSET,
    )
    source: Missing[
        Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1,
        ]
    ] = Field(
        description="Update the source for the repository. Must include the branch name and path.",
        default=UNSET,
    )


class ReposOwnerRepoPagesPutBodyAnyof3(GitHubRestModel):
    """ReposOwnerRepoPagesPutBodyAnyof3"""

    cname: Missing[Union[str, None]] = Field(
        description='Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://docs.github.com/articles/using-a-custom-domain-with-github-pages/)."',
        default=UNSET,
    )
    https_enforced: Missing[bool] = Field(
        description="Specify whether HTTPS should be enforced for the repository.",
        default=UNSET,
    )
    build_type: Missing[Literal["legacy", "workflow"]] = Field(
        description="The process by which the GitHub Pages site will be built. `workflow` means that the site is built by a custom GitHub Actions workflow. `legacy` means that the site is built by GitHub when changes are pushed to a specific branch.",
        default=UNSET,
    )
    source: Missing[
        Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1,
        ]
    ] = Field(
        description="Update the source for the repository. Must include the branch name and path.",
        default=UNSET,
    )


class ReposOwnerRepoPagesPutBodyAnyof4(GitHubRestModel):
    """ReposOwnerRepoPagesPutBodyAnyof4"""

    cname: Missing[Union[str, None]] = Field(
        description='Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://docs.github.com/articles/using-a-custom-domain-with-github-pages/)."',
        default=UNSET,
    )
    https_enforced: bool = Field(
        description="Specify whether HTTPS should be enforced for the repository.",
        default=...,
    )
    build_type: Missing[Literal["legacy", "workflow"]] = Field(
        description="The process by which the GitHub Pages site will be built. `workflow` means that the site is built by a custom GitHub Actions workflow. `legacy` means that the site is built by GitHub when changes are pushed to a specific branch.",
        default=UNSET,
    )
    source: Missing[
        Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1,
        ]
    ] = Field(
        description="Update the source for the repository. Must include the branch name and path.",
        default=UNSET,
    )


class ReposOwnerRepoPagesPostBodyPropSource(GitHubRestModel):
    """ReposOwnerRepoPagesPostBodyPropSource

    The source branch and directory used to publish your Pages site.
    """

    branch: str = Field(
        description="The repository branch used to publish your site's source files.",
        default=...,
    )
    path: Missing[Literal["/", "/docs"]] = Field(
        description="The repository directory that includes the source files for the Pages site. Allowed paths are `/` or `/docs`. Default: `/`",
        default="/",
    )


class ReposOwnerRepoPagesPostBodyAnyof0(GitHubRestModel):
    """ReposOwnerRepoPagesPostBodyAnyof0"""

    build_type: Missing[Literal["legacy", "workflow"]] = Field(
        description='The process in which the Page will be built. Possible values are `"legacy"` and `"workflow"`.',
        default=UNSET,
    )
    source: ReposOwnerRepoPagesPostBodyPropSource = Field(
        description="The source branch and directory used to publish your Pages site.",
        default=...,
    )


class ReposOwnerRepoPagesPostBodyAnyof1(GitHubRestModel):
    """ReposOwnerRepoPagesPostBodyAnyof1"""

    build_type: Literal["legacy", "workflow"] = Field(
        description='The process in which the Page will be built. Possible values are `"legacy"` and `"workflow"`.',
        default=...,
    )
    source: Missing[ReposOwnerRepoPagesPostBodyPropSource] = Field(
        description="The source branch and directory used to publish your Pages site.",
        default=UNSET,
    )


class ReposOwnerRepoPagesDeploymentPostBody(GitHubRestModel):
    """ReposOwnerRepoPagesDeploymentPostBody

    The object used to create GitHub Pages deployment
    """

    artifact_url: str = Field(
        description="The URL of an artifact that contains the .zip or .tar of static assets to deploy. The artifact belongs to the repository.",
        default=...,
    )
    environment: Missing[str] = Field(
        description="The target environment for this GitHub Pages deployment.",
        default="github-pages",
    )
    pages_build_version: str = Field(
        description="A unique string that represents the version of the build for this deployment.",
        default="GITHUB_SHA",
    )
    oidc_token: str = Field(
        description="The OIDC token issued by GitHub Actions certifying the origin of the deployment.",
        default=...,
    )


class ReposOwnerRepoProjectsPostBody(GitHubRestModel):
    """ReposOwnerRepoProjectsPostBody"""

    name: str = Field(description="The name of the project.", default=...)
    body: Missing[str] = Field(
        description="The description of the project.", default=UNSET
    )


class ReposOwnerRepoPullsPostBody(GitHubRestModel):
    """ReposOwnerRepoPullsPostBody"""

    title: Missing[str] = Field(
        description="The title of the new pull request. Required unless `issue` is specified.",
        default=UNSET,
    )
    head: str = Field(
        description="The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.",
        default=...,
    )
    head_repo: Missing[str] = Field(
        description="The name of the repository where the changes in the pull request were made. This field is required for cross-repository pull requests if both repositories are owned by the same organization.",
        default=UNSET,
    )
    base: str = Field(
        description="The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.",
        default=...,
    )
    body: Missing[str] = Field(
        description="The contents of the pull request.", default=UNSET
    )
    maintainer_can_modify: Missing[bool] = Field(
        description="Indicates whether [maintainers can modify](https://docs.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.",
        default=UNSET,
    )
    draft: Missing[bool] = Field(
        description='Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://docs.github.com/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.',
        default=UNSET,
    )
    issue: Missing[int] = Field(
        description="An issue in the repository to convert to a pull request. The issue title, body, and comments will become the title, body, and comments on the new pull request. Required unless `title` is specified.",
        default=UNSET,
    )


class ReposOwnerRepoPullsCommentsCommentIdPatchBody(GitHubRestModel):
    """ReposOwnerRepoPullsCommentsCommentIdPatchBody"""

    body: str = Field(
        description="The text of the reply to the review comment.", default=...
    )


class ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody(GitHubRestModel):
    """ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(
        description="The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the pull request review comment.",
        default=...,
    )


class ReposOwnerRepoPullsPullNumberPatchBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberPatchBody"""

    title: Missing[str] = Field(
        description="The title of the pull request.", default=UNSET
    )
    body: Missing[str] = Field(
        description="The contents of the pull request.", default=UNSET
    )
    state: Missing[Literal["open", "closed"]] = Field(
        description="State of this Pull Request. Either `open` or `closed`.",
        default=UNSET,
    )
    base: Missing[str] = Field(
        description="The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.",
        default=UNSET,
    )
    maintainer_can_modify: Missing[bool] = Field(
        description="Indicates whether [maintainers can modify](https://docs.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.",
        default=UNSET,
    )


class ReposOwnerRepoPullsPullNumberCodespacesPostBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberCodespacesPostBody"""

    location: Missing[str] = Field(
        description="The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.",
        default=UNSET,
    )
    geo: Missing[Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]] = Field(
        description="The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is being deprecated.",
        default=UNSET,
    )
    client_ip: Missing[str] = Field(
        description="IP for location auto-detection when proxying a request",
        default=UNSET,
    )
    machine: Missing[str] = Field(
        description="Machine type to use for this codespace", default=UNSET
    )
    devcontainer_path: Missing[str] = Field(
        description="Path to devcontainer.json config to use for this codespace",
        default=UNSET,
    )
    multi_repo_permissions_opt_out: Missing[bool] = Field(
        description="Whether to authorize requested permissions from devcontainer.json",
        default=UNSET,
    )
    working_directory: Missing[str] = Field(
        description="Working directory for this codespace", default=UNSET
    )
    idle_timeout_minutes: Missing[int] = Field(
        description="Time in minutes before codespace stops from inactivity",
        default=UNSET,
    )
    display_name: Missing[str] = Field(
        description="Display name for this codespace", default=UNSET
    )
    retention_period_minutes: Missing[int] = Field(
        description="Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).",
        default=UNSET,
    )


class ReposOwnerRepoPullsPullNumberCommentsPostBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberCommentsPostBody"""

    body: str = Field(description="The text of the review comment.", default=...)
    commit_id: str = Field(
        description="The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.",
        default=...,
    )
    path: str = Field(
        description="The relative path to the file that necessitates a comment.",
        default=...,
    )
    position: Missing[int] = Field(
        description="**This parameter is deprecated. Use `line` instead**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.",
        default=UNSET,
    )
    side: Missing[Literal["LEFT", "RIGHT"]] = Field(
        description='In a split diff view, the side of the diff that the pull request\'s changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://docs.github.com/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.',
        default=UNSET,
    )
    line: Missing[int] = Field(
        description="**Required unless using `subject_type:file`**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.",
        default=UNSET,
    )
    start_line: Missing[int] = Field(
        description='**Required when using multi-line comments unless using `in_reply_to`**. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://docs.github.com/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.',
        default=UNSET,
    )
    start_side: Missing[Literal["LEFT", "RIGHT", "side"]] = Field(
        description='**Required when using multi-line comments unless using `in_reply_to`**. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://docs.github.com/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.',
        default=UNSET,
    )
    in_reply_to: Missing[int] = Field(
        description='The ID of the review comment to reply to. To find the ID of a review comment with ["List review comments on a pull request"](#list-review-comments-on-a-pull-request). When specified, all parameters other than `body` in the request body are ignored.',
        default=UNSET,
    )
    subject_type: Missing[Literal["line", "file"]] = Field(
        description="The level at which the comment is targeted.", default=UNSET
    )


class ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody"""

    body: str = Field(description="The text of the review comment.", default=...)


class ReposOwnerRepoPullsPullNumberMergePutBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberMergePutBody"""

    commit_title: Missing[str] = Field(
        description="Title for the automatic commit message.", default=UNSET
    )
    commit_message: Missing[str] = Field(
        description="Extra detail to append to automatic commit message.", default=UNSET
    )
    sha: Missing[str] = Field(
        description="SHA that pull request head must match to allow merge.",
        default=UNSET,
    )
    merge_method: Missing[Literal["merge", "squash", "rebase"]] = Field(
        description="The merge method to use.", default=UNSET
    )


class ReposOwnerRepoPullsPullNumberMergePutResponse405(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberMergePutResponse405"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoPullsPullNumberMergePutResponse409(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberMergePutResponse409"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0"""

    reviewers: List[str] = Field(
        description="An array of user `login`s that will be requested.", default=...
    )
    team_reviewers: Missing[List[str]] = Field(
        description="An array of team `slug`s that will be requested.", default=UNSET
    )


class ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1"""

    reviewers: Missing[List[str]] = Field(
        description="An array of user `login`s that will be requested.", default=UNSET
    )
    team_reviewers: List[str] = Field(
        description="An array of team `slug`s that will be requested.", default=...
    )


class ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody"""

    reviewers: List[str] = Field(
        description="An array of user `login`s that will be removed.", default=...
    )
    team_reviewers: Missing[List[str]] = Field(
        description="An array of team `slug`s that will be removed.", default=UNSET
    )


class ReposOwnerRepoPullsPullNumberReviewsPostBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberReviewsPostBody"""

    commit_id: Missing[str] = Field(
        description="The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.",
        default=UNSET,
    )
    body: Missing[str] = Field(
        description="**Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.",
        default=UNSET,
    )
    event: Missing[Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = Field(
        description="The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request) when you are ready.",
        default=UNSET,
    )
    comments: Missing[
        List[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItems]
    ] = Field(
        description="Use the following table to specify the location, destination, and contents of the draft review comment.",
        default=UNSET,
    )


class ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItems(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItems"""

    path: str = Field(
        description="The relative path to the file that necessitates a review comment.",
        default=...,
    )
    position: Missing[int] = Field(
        description="The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note below.",
        default=UNSET,
    )
    body: str = Field(description="Text of the review comment.", default=...)
    line: Missing[int] = Field(default=UNSET)
    side: Missing[str] = Field(default=UNSET)
    start_line: Missing[int] = Field(default=UNSET)
    start_side: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody"""

    body: str = Field(
        description="The body text of the pull request review.", default=...
    )


class ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody"""

    message: str = Field(
        description="The message for the pull request review dismissal", default=...
    )
    event: Missing[Literal["DISMISS"]] = Field(default=UNSET)


class ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody"""

    body: Missing[str] = Field(
        description="The body text of the pull request review", default=UNSET
    )
    event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"] = Field(
        description="The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.",
        default=...,
    )


class ReposOwnerRepoPullsPullNumberUpdateBranchPutBody(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberUpdateBranchPutBody"""

    expected_head_sha: Missing[str] = Field(
        description="The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the \"[List commits](https://docs.github.com/rest/commits/commits#list-commits)\" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.",
        default=UNSET,
    )


class ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202(GitHubRestModel):
    """ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202"""

    message: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoReleasesPostBody(GitHubRestModel):
    """ReposOwnerRepoReleasesPostBody"""

    tag_name: str = Field(description="The name of the tag.", default=...)
    target_commitish: Missing[str] = Field(
        description="Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch.",
        default=UNSET,
    )
    name: Missing[str] = Field(description="The name of the release.", default=UNSET)
    body: Missing[str] = Field(
        description="Text describing the contents of the tag.", default=UNSET
    )
    draft: Missing[bool] = Field(
        description="`true` to create a draft (unpublished) release, `false` to create a published one.",
        default=False,
    )
    prerelease: Missing[bool] = Field(
        description="`true` to identify the release as a prerelease. `false` to identify the release as a full release.",
        default=False,
    )
    discussion_category_name: Missing[str] = Field(
        description='If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. For more information, see "[Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository)."',
        default=UNSET,
    )
    generate_release_notes: Missing[bool] = Field(
        description="Whether to automatically generate the name and body for this release. If `name` is specified, the specified name will be used; otherwise, a name will be automatically generated. If `body` is specified, the body will be pre-pended to the automatically generated notes.",
        default=False,
    )
    make_latest: Missing[Literal["true", "false", "legacy"]] = Field(
        description="Specifies whether this release should be set as the latest release for the repository. Drafts and prereleases cannot be set as latest. Defaults to `true` for newly published releases. `legacy` specifies that the latest release should be determined based on the release creation date and higher semantic version.",
        default="true",
    )


class ReposOwnerRepoReleasesAssetsAssetIdPatchBody(GitHubRestModel):
    """ReposOwnerRepoReleasesAssetsAssetIdPatchBody"""

    name: Missing[str] = Field(description="The file name of the asset.", default=UNSET)
    label: Missing[str] = Field(
        description="An alternate short description of the asset. Used in place of the filename.",
        default=UNSET,
    )
    state: Missing[str] = Field(default=UNSET)


class ReposOwnerRepoReleasesGenerateNotesPostBody(GitHubRestModel):
    """ReposOwnerRepoReleasesGenerateNotesPostBody"""

    tag_name: str = Field(
        description="The tag name for the release. This can be an existing tag or a new one.",
        default=...,
    )
    target_commitish: Missing[str] = Field(
        description="Specifies the commitish value that will be the target for the release's tag. Required if the supplied tag_name does not reference an existing tag. Ignored if the tag_name already exists.",
        default=UNSET,
    )
    previous_tag_name: Missing[str] = Field(
        description="The name of the previous tag to use as the starting point for the release notes. Use to manually specify the range for the set of changes considered as part this release.",
        default=UNSET,
    )
    configuration_file_path: Missing[str] = Field(
        description="Specifies a path to a file in the repository containing configuration settings used for generating the release notes. If unspecified, the configuration file located in the repository at '.github/release.yml' or '.github/release.yaml' will be used. If that is not present, the default configuration will be used.",
        default=UNSET,
    )


class ReposOwnerRepoReleasesReleaseIdPatchBody(GitHubRestModel):
    """ReposOwnerRepoReleasesReleaseIdPatchBody"""

    tag_name: Missing[str] = Field(description="The name of the tag.", default=UNSET)
    target_commitish: Missing[str] = Field(
        description="Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch.",
        default=UNSET,
    )
    name: Missing[str] = Field(description="The name of the release.", default=UNSET)
    body: Missing[str] = Field(
        description="Text describing the contents of the tag.", default=UNSET
    )
    draft: Missing[bool] = Field(
        description="`true` makes the release a draft, and `false` publishes the release.",
        default=UNSET,
    )
    prerelease: Missing[bool] = Field(
        description="`true` to identify the release as a prerelease, `false` to identify the release as a full release.",
        default=UNSET,
    )
    make_latest: Missing[Literal["true", "false", "legacy"]] = Field(
        description="Specifies whether this release should be set as the latest release for the repository. Drafts and prereleases cannot be set as latest. Defaults to `true` for newly published releases. `legacy` specifies that the latest release should be determined based on the release creation date and higher semantic version.",
        default="true",
    )
    discussion_category_name: Missing[str] = Field(
        description='If specified, a discussion of the specified category is created and linked to the release. The value must be a category that already exists in the repository. If there is already a discussion linked to the release, this parameter is ignored. For more information, see "[Managing categories for discussions in your repository](https://docs.github.com/discussions/managing-discussions-for-your-community/managing-categories-for-discussions-in-your-repository)."',
        default=UNSET,
    )


class ReposOwnerRepoReleasesReleaseIdReactionsPostBody(GitHubRestModel):
    """ReposOwnerRepoReleasesReleaseIdReactionsPostBody"""

    content: Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"] = Field(
        description="The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the release.",
        default=...,
    )


class ReposOwnerRepoRulesetsPostBody(GitHubRestModel):
    """ReposOwnerRepoRulesetsPostBody"""

    name: str = Field(description="The name of the ruleset.", default=...)
    target: Missing[Literal["branch", "tag"]] = Field(
        description="The target of the ruleset.", default=UNSET
    )
    enforcement: Literal["disabled", "active", "evaluate"] = Field(
        description="The enforcement level of the ruleset. `evaluate` allows admins to test rules before enforcing them. Admins can view insights on the Rule Insights page (`evaluate` is only available with GitHub Enterprise).",
        default=...,
    )
    bypass_actors: Missing[List[RepositoryRulesetBypassActor]] = Field(
        description="The actors that can bypass the rules in this ruleset",
        default=UNSET,
    )
    conditions: Missing[RepositoryRulesetConditions] = Field(
        title="Repository ruleset conditions for ref names",
        description="Parameters for a repository ruleset ref name condition",
        default=UNSET,
    )
    rules: Missing[
        List[
            Union[
                RepositoryRuleCreation,
                RepositoryRuleUpdate,
                RepositoryRuleDeletion,
                RepositoryRuleRequiredLinearHistory,
                RepositoryRuleRequiredDeployments,
                RepositoryRuleRequiredSignatures,
                RepositoryRulePullRequest,
                RepositoryRuleRequiredStatusChecks,
                RepositoryRuleNonFastForward,
                RepositoryRuleCommitMessagePattern,
                RepositoryRuleCommitAuthorEmailPattern,
                RepositoryRuleCommitterEmailPattern,
                RepositoryRuleBranchNamePattern,
                RepositoryRuleTagNamePattern,
            ]
        ]
    ] = Field(description="An array of rules within the ruleset.", default=UNSET)


class ReposOwnerRepoRulesetsRulesetIdPutBody(GitHubRestModel):
    """ReposOwnerRepoRulesetsRulesetIdPutBody"""

    name: Missing[str] = Field(description="The name of the ruleset.", default=UNSET)
    target: Missing[Literal["branch", "tag"]] = Field(
        description="The target of the ruleset.", default=UNSET
    )
    enforcement: Missing[Literal["disabled", "active", "evaluate"]] = Field(
        description="The enforcement level of the ruleset. `evaluate` allows admins to test rules before enforcing them. Admins can view insights on the Rule Insights page (`evaluate` is only available with GitHub Enterprise).",
        default=UNSET,
    )
    bypass_actors: Missing[List[RepositoryRulesetBypassActor]] = Field(
        description="The actors that can bypass the rules in this ruleset",
        default=UNSET,
    )
    conditions: Missing[RepositoryRulesetConditions] = Field(
        title="Repository ruleset conditions for ref names",
        description="Parameters for a repository ruleset ref name condition",
        default=UNSET,
    )
    rules: Missing[
        List[
            Union[
                RepositoryRuleCreation,
                RepositoryRuleUpdate,
                RepositoryRuleDeletion,
                RepositoryRuleRequiredLinearHistory,
                RepositoryRuleRequiredDeployments,
                RepositoryRuleRequiredSignatures,
                RepositoryRulePullRequest,
                RepositoryRuleRequiredStatusChecks,
                RepositoryRuleNonFastForward,
                RepositoryRuleCommitMessagePattern,
                RepositoryRuleCommitAuthorEmailPattern,
                RepositoryRuleCommitterEmailPattern,
                RepositoryRuleBranchNamePattern,
                RepositoryRuleTagNamePattern,
            ]
        ]
    ] = Field(description="An array of rules within the ruleset.", default=UNSET)


class ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBody(GitHubRestModel):
    """ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBody"""

    state: Literal["open", "resolved"] = Field(
        description="Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.",
        default=...,
    )
    resolution: Missing[
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]]
    ] = Field(
        description="**Required when the `state` is `resolved`.** The reason for resolving the alert.",
        default=UNSET,
    )
    resolution_comment: Missing[Union[str, None]] = Field(
        description="An optional comment when closing an alert. Cannot be updated or deleted. Must be `null` when changing `state` to `open`.",
        default=UNSET,
    )


class ReposOwnerRepoStatusesShaPostBody(GitHubRestModel):
    """ReposOwnerRepoStatusesShaPostBody"""

    state: Literal["error", "failure", "pending", "success"] = Field(
        description="The state of the status.", default=...
    )
    target_url: Missing[Union[str, None]] = Field(
        description="The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.  \nFor example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:  \n`http://ci.example.com/user/repo/build/sha`",
        default=UNSET,
    )
    description: Missing[Union[str, None]] = Field(
        description="A short description of the status.", default=UNSET
    )
    context: Missing[str] = Field(
        description="A string label to differentiate this status from the status of other systems. This field is case-insensitive.",
        default="default",
    )


class ReposOwnerRepoSubscriptionPutBody(GitHubRestModel):
    """ReposOwnerRepoSubscriptionPutBody"""

    subscribed: Missing[bool] = Field(
        description="Determines if notifications should be received from this repository.",
        default=UNSET,
    )
    ignored: Missing[bool] = Field(
        description="Determines if all notifications should be blocked from this repository.",
        default=UNSET,
    )


class ReposOwnerRepoTagsProtectionPostBody(GitHubRestModel):
    """ReposOwnerRepoTagsProtectionPostBody"""

    pattern: str = Field(
        description="An optional glob pattern to match against when enforcing tag protection.",
        default=...,
    )


class ReposOwnerRepoTopicsPutBody(GitHubRestModel):
    """ReposOwnerRepoTopicsPutBody"""

    names: List[str] = Field(
        description="An array of topics to add to the repository. Pass one or more topics to _replace_ the set of existing topics. Send an empty array (`[]`) to clear all topics from the repository. **Note:** Topic `names` cannot contain uppercase letters.",
        default=...,
    )


class ReposOwnerRepoTransferPostBody(GitHubRestModel):
    """ReposOwnerRepoTransferPostBody"""

    new_owner: str = Field(
        description="The username or organization name the repository will be transferred to.",
        default=...,
    )
    new_name: Missing[str] = Field(
        description="The new name to be given to the repository.", default=UNSET
    )
    team_ids: Missing[List[int]] = Field(
        description="ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.",
        default=UNSET,
    )


class ReposTemplateOwnerTemplateRepoGeneratePostBody(GitHubRestModel):
    """ReposTemplateOwnerTemplateRepoGeneratePostBody"""

    owner: Missing[str] = Field(
        description="The organization or person who will own the new repository. To create a new repository in an organization, the authenticated user must be a member of the specified organization.",
        default=UNSET,
    )
    name: str = Field(description="The name of the new repository.", default=...)
    description: Missing[str] = Field(
        description="A short description of the new repository.", default=UNSET
    )
    include_all_branches: Missing[bool] = Field(
        description="Set to `true` to include the directory structure and files from all branches in the template repository, and not just the default branch. Default: `false`.",
        default=False,
    )
    private: Missing[bool] = Field(
        description="Either `true` to create a new private repository or `false` to create a new public one.",
        default=False,
    )


class RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200(
    GitHubRestModel
):
    """RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200"""

    total_count: int = Field(default=...)
    secrets: List[ActionsSecret] = Field(default=...)


class RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody(
    GitHubRestModel
):
    """RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody"""

    encrypted_value: str = Field(
        description="Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an environment public key](https://docs.github.com/rest/actions/secrets#get-an-environment-public-key) endpoint.",
        pattern="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$",
        default=...,
    )
    key_id: str = Field(
        description="ID of the key you used to encrypt the secret.", default=...
    )


class RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200(
    GitHubRestModel
):
    """RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200"""

    total_count: int = Field(default=...)
    variables: List[ActionsVariable] = Field(default=...)


class RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody(
    GitHubRestModel
):
    """RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody"""

    name: str = Field(description="The name of the variable.", default=...)
    value: str = Field(description="The value of the variable.", default=...)


class RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody(
    GitHubRestModel
):
    """RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody"""

    name: Missing[str] = Field(description="The name of the variable.", default=UNSET)
    value: Missing[str] = Field(description="The value of the variable.", default=UNSET)


class SearchCodeGetResponse200(GitHubRestModel):
    """SearchCodeGetResponse200"""

    total_count: int = Field(default=...)
    incomplete_results: bool = Field(default=...)
    items: List[CodeSearchResultItem] = Field(default=...)


class SearchCommitsGetResponse200(GitHubRestModel):
    """SearchCommitsGetResponse200"""

    total_count: int = Field(default=...)
    incomplete_results: bool = Field(default=...)
    items: List[CommitSearchResultItem] = Field(default=...)


class SearchIssuesGetResponse200(GitHubRestModel):
    """SearchIssuesGetResponse200"""

    total_count: int = Field(default=...)
    incomplete_results: bool = Field(default=...)
    items: List[IssueSearchResultItem] = Field(default=...)


class SearchLabelsGetResponse200(GitHubRestModel):
    """SearchLabelsGetResponse200"""

    total_count: int = Field(default=...)
    incomplete_results: bool = Field(default=...)
    items: List[LabelSearchResultItem] = Field(default=...)


class SearchRepositoriesGetResponse200(GitHubRestModel):
    """SearchRepositoriesGetResponse200"""

    total_count: int = Field(default=...)
    incomplete_results: bool = Field(default=...)
    items: List[RepoSearchResultItem] = Field(default=...)


class SearchTopicsGetResponse200(GitHubRestModel):
    """SearchTopicsGetResponse200"""

    total_count: int = Field(default=...)
    incomplete_results: bool = Field(default=...)
    items: List[TopicSearchResultItem] = Field(default=...)


class SearchUsersGetResponse200(GitHubRestModel):
    """SearchUsersGetResponse200"""

    total_count: int = Field(default=...)
    incomplete_results: bool = Field(default=...)
    items: List[UserSearchResultItem] = Field(default=...)


class TeamsTeamIdPatchBody(GitHubRestModel):
    """TeamsTeamIdPatchBody"""

    name: str = Field(description="The name of the team.", default=...)
    description: Missing[str] = Field(
        description="The description of the team.", default=UNSET
    )
    privacy: Missing[Literal["secret", "closed"]] = Field(
        description="The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:  \n**For a non-nested team:**  \n * `secret` - only visible to organization owners and members of this team.  \n * `closed` - visible to all members of this organization.  \n**For a parent or child team:**  \n * `closed` - visible to all members of this organization.",
        default=UNSET,
    )
    notification_setting: Missing[
        Literal["notifications_enabled", "notifications_disabled"]
    ] = Field(
        description="The notification setting the team has chosen. Editing teams without specifying this parameter leaves `notification_setting` intact. The options are: \n * `notifications_enabled` - team members receive notifications when the team is @mentioned.  \n * `notifications_disabled` - no one receives notifications.",
        default=UNSET,
    )
    permission: Missing[Literal["pull", "push", "admin"]] = Field(
        description="**Deprecated**. The permission that new repositories will be added to the team with when none is specified.",
        default="pull",
    )
    parent_team_id: Missing[Union[int, None]] = Field(
        description="The ID of a team to set as the parent team.", default=UNSET
    )


class TeamsTeamIdDiscussionsPostBody(GitHubRestModel):
    """TeamsTeamIdDiscussionsPostBody"""

    title: str = Field(description="The discussion post's title.", default=...)
    body: str = Field(description="The discussion post's body text.", default=...)
    private: Missing[bool] = Field(
        description="Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.",
        default=False,
    )


class TeamsTeamIdDiscussionsDiscussionNumberPatchBody(GitHubRestModel):
    """TeamsTeamIdDiscussionsDiscussionNumberPatchBody"""

    title: Missing[str] = Field(
        description="The discussion post's title.", default=UNSET
    )
    body: Missing[str] = Field(
        description="The discussion post's body text.", default=UNSET
    )


class TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody(GitHubRestModel):
    """TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody"""

    body: str = Field(description="The discussion comment's body text.", default=...)


class TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody(
    GitHubRestModel
):
    """TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody"""

    body: str = Field(description="The discussion comment's body text.", default=...)


class TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody(
    GitHubRestModel
):
    """TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(
        description="The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion comment.",
        default=...,
    )


class TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody(GitHubRestModel):
    """TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody"""

    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(
        description="The [reaction type](https://docs.github.com/rest/reactions/reactions#about-reactions) to add to the team discussion.",
        default=...,
    )


class TeamsTeamIdMembershipsUsernamePutBody(GitHubRestModel):
    """TeamsTeamIdMembershipsUsernamePutBody"""

    role: Missing[Literal["member", "maintainer"]] = Field(
        description="The role that this user should have in the team.", default="member"
    )


class TeamsTeamIdProjectsProjectIdPutBody(GitHubRestModel):
    """TeamsTeamIdProjectsProjectIdPutBody"""

    permission: Missing[Literal["read", "write", "admin"]] = Field(
        description="The permission to grant to the team for this project. Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling this endpoint. For more information, see \"[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs).\"",
        default=UNSET,
    )


class TeamsTeamIdProjectsProjectIdPutResponse403(GitHubRestModel):
    """TeamsTeamIdProjectsProjectIdPutResponse403"""

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)


class TeamsTeamIdReposOwnerRepoPutBody(GitHubRestModel):
    """TeamsTeamIdReposOwnerRepoPutBody"""

    permission: Missing[Literal["pull", "push", "admin"]] = Field(
        description="The permission to grant the team on this repository. If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.",
        default=UNSET,
    )


class UserPatchBody(GitHubRestModel):
    """UserPatchBody"""

    name: Missing[str] = Field(description="The new name of the user.", default=UNSET)
    email: Missing[str] = Field(
        description="The publicly visible email address of the user.", default=UNSET
    )
    blog: Missing[str] = Field(
        description="The new blog URL of the user.", default=UNSET
    )
    twitter_username: Missing[Union[str, None]] = Field(
        description="The new Twitter username of the user.", default=UNSET
    )
    company: Missing[str] = Field(
        description="The new company of the user.", default=UNSET
    )
    location: Missing[str] = Field(
        description="The new location of the user.", default=UNSET
    )
    hireable: Missing[bool] = Field(
        description="The new hiring availability of the user.", default=UNSET
    )
    bio: Missing[str] = Field(
        description="The new short biography of the user.", default=UNSET
    )


class UserCodespacesGetResponse200(GitHubRestModel):
    """UserCodespacesGetResponse200"""

    total_count: int = Field(default=...)
    codespaces: List[Codespace] = Field(default=...)


class UserCodespacesPostBodyOneof0(GitHubRestModel):
    """UserCodespacesPostBodyOneof0"""

    repository_id: int = Field(
        description="Repository id for this codespace", default=...
    )
    ref: Missing[str] = Field(
        description="Git ref (typically a branch name) for this codespace",
        default=UNSET,
    )
    location: Missing[str] = Field(
        description="The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.",
        default=UNSET,
    )
    geo: Missing[Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]] = Field(
        description="The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is being deprecated.",
        default=UNSET,
    )
    client_ip: Missing[str] = Field(
        description="IP for location auto-detection when proxying a request",
        default=UNSET,
    )
    machine: Missing[str] = Field(
        description="Machine type to use for this codespace", default=UNSET
    )
    devcontainer_path: Missing[str] = Field(
        description="Path to devcontainer.json config to use for this codespace",
        default=UNSET,
    )
    multi_repo_permissions_opt_out: Missing[bool] = Field(
        description="Whether to authorize requested permissions from devcontainer.json",
        default=UNSET,
    )
    working_directory: Missing[str] = Field(
        description="Working directory for this codespace", default=UNSET
    )
    idle_timeout_minutes: Missing[int] = Field(
        description="Time in minutes before codespace stops from inactivity",
        default=UNSET,
    )
    display_name: Missing[str] = Field(
        description="Display name for this codespace", default=UNSET
    )
    retention_period_minutes: Missing[int] = Field(
        description="Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).",
        default=UNSET,
    )


class UserCodespacesPostBodyOneof1(GitHubRestModel):
    """UserCodespacesPostBodyOneof1"""

    pull_request: UserCodespacesPostBodyOneof1PropPullRequest = Field(
        description="Pull request number for this codespace", default=...
    )
    location: Missing[str] = Field(
        description="The requested location for a new codespace. Best efforts are made to respect this upon creation. Assigned by IP if not provided.",
        default=UNSET,
    )
    geo: Missing[Literal["EuropeWest", "SoutheastAsia", "UsEast", "UsWest"]] = Field(
        description="The geographic area for this codespace. If not specified, the value is assigned by IP. This property replaces `location`, which is being deprecated.",
        default=UNSET,
    )
    machine: Missing[str] = Field(
        description="Machine type to use for this codespace", default=UNSET
    )
    devcontainer_path: Missing[str] = Field(
        description="Path to devcontainer.json config to use for this codespace",
        default=UNSET,
    )
    working_directory: Missing[str] = Field(
        description="Working directory for this codespace", default=UNSET
    )
    idle_timeout_minutes: Missing[int] = Field(
        description="Time in minutes before codespace stops from inactivity",
        default=UNSET,
    )


class UserCodespacesPostBodyOneof1PropPullRequest(GitHubRestModel):
    """UserCodespacesPostBodyOneof1PropPullRequest

    Pull request number for this codespace
    """

    pull_request_number: int = Field(description="Pull request number", default=...)
    repository_id: int = Field(
        description="Repository id for this codespace", default=...
    )


class UserCodespacesSecretsGetResponse200(GitHubRestModel):
    """UserCodespacesSecretsGetResponse200"""

    total_count: int = Field(default=...)
    secrets: List[CodespacesSecret] = Field(default=...)


class UserCodespacesSecretsSecretNamePutBody(GitHubRestModel):
    """UserCodespacesSecretsSecretNamePutBody"""

    encrypted_value: Missing[
        Annotated[
            str,
            Field(
                pattern="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$"
            ),
        ]
    ] = Field(
        description="Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get the public key for the authenticated user](https://docs.github.com/rest/codespaces/secrets#get-public-key-for-the-authenticated-user) endpoint.",
        default=UNSET,
    )
    key_id: str = Field(
        description="ID of the key you used to encrypt the secret.", default=...
    )
    selected_repository_ids: Missing[List[Union[int, str]]] = Field(
        description="An array of repository ids that can access the user secret. You can manage the list of selected repositories using the [List selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#list-selected-repositories-for-a-user-secret), [Set selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#set-selected-repositories-for-a-user-secret), and [Remove a selected repository from a user secret](https://docs.github.com/rest/codespaces/secrets#remove-a-selected-repository-from-a-user-secret) endpoints.",
        default=UNSET,
    )


class UserCodespacesSecretsSecretNameRepositoriesGetResponse200(GitHubRestModel):
    """UserCodespacesSecretsSecretNameRepositoriesGetResponse200"""

    total_count: int = Field(default=...)
    repositories: List[MinimalRepository] = Field(default=...)


class UserCodespacesSecretsSecretNameRepositoriesPutBody(GitHubRestModel):
    """UserCodespacesSecretsSecretNameRepositoriesPutBody"""

    selected_repository_ids: List[int] = Field(
        description="An array of repository ids for which a codespace can access the secret. You can manage the list of selected repositories using the [List selected repositories for a user secret](https://docs.github.com/rest/codespaces/secrets#list-selected-repositories-for-a-user-secret), [Add a selected repository to a user secret](https://docs.github.com/rest/codespaces/secrets#add-a-selected-repository-to-a-user-secret), and [Remove a selected repository from a user secret](https://docs.github.com/rest/codespaces/secrets#remove-a-selected-repository-from-a-user-secret) endpoints.",
        default=...,
    )


class UserCodespacesCodespaceNamePatchBody(GitHubRestModel):
    """UserCodespacesCodespaceNamePatchBody"""

    machine: Missing[str] = Field(
        description="A valid machine to transition this codespace to.", default=UNSET
    )
    display_name: Missing[str] = Field(
        description="Display name for this codespace", default=UNSET
    )
    recent_folders: Missing[List[str]] = Field(
        description="Recently opened folders inside the codespace. It is currently used by the clients to determine the folder path to load the codespace in.",
        default=UNSET,
    )


class UserCodespacesCodespaceNameMachinesGetResponse200(GitHubRestModel):
    """UserCodespacesCodespaceNameMachinesGetResponse200"""

    total_count: int = Field(default=...)
    machines: List[CodespaceMachine] = Field(default=...)


class UserCodespacesCodespaceNamePublishPostBody(GitHubRestModel):
    """UserCodespacesCodespaceNamePublishPostBody"""

    name: Missing[str] = Field(
        description="A name for the new repository.", default=UNSET
    )
    private: Missing[bool] = Field(
        description="Whether the new repository should be private.", default=False
    )


class UserEmailVisibilityPatchBody(GitHubRestModel):
    """UserEmailVisibilityPatchBody"""

    visibility: Literal["public", "private"] = Field(
        description="Denotes whether an email is publicly visible.", default=...
    )


class UserEmailsPostBodyOneof0(GitHubRestModel):
    """UserEmailsPostBodyOneof0

    Examples:
        {'emails': ['octocat@github.com', 'mona@github.com']}
    """

    emails: List[str] = Field(
        description="Adds one or more email addresses to your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.",
        default=...,
    )


class UserEmailsDeleteBodyOneof0(GitHubRestModel):
    """UserEmailsDeleteBodyOneof0

    Deletes one or more email addresses from your GitHub account. Must contain at
    least one email address. **Note:** Alternatively, you can pass a single email
    address or an `array` of emails addresses directly, but we recommend that you
    pass an object using the `emails` key.

    Examples:
        {'emails': ['octocat@github.com', 'mona@github.com']}
    """

    emails: List[str] = Field(
        description="Email addresses associated with the GitHub user account.",
        default=...,
    )


class UserGpgKeysPostBody(GitHubRestModel):
    """UserGpgKeysPostBody"""

    name: Missing[str] = Field(
        description="A descriptive name for the new key.", default=UNSET
    )
    armored_public_key: str = Field(
        description="A GPG key in ASCII-armored format.", default=...
    )


class UserInstallationsGetResponse200(GitHubRestModel):
    """UserInstallationsGetResponse200"""

    total_count: int = Field(default=...)
    installations: List[Installation] = Field(default=...)


class UserInstallationsInstallationIdRepositoriesGetResponse200(GitHubRestModel):
    """UserInstallationsInstallationIdRepositoriesGetResponse200"""

    total_count: int = Field(default=...)
    repository_selection: Missing[str] = Field(default=UNSET)
    repositories: List[Repository] = Field(default=...)


class UserInteractionLimitsGetResponse200Anyof1(GitHubRestModel):
    """UserInteractionLimitsGetResponse200Anyof1"""


class UserKeysPostBody(GitHubRestModel):
    """UserKeysPostBody"""

    title: Missing[str] = Field(
        description="A descriptive name for the new key.", default=UNSET
    )
    key: str = Field(
        description="The public SSH key to add to your GitHub account.",
        pattern="^ssh-(rsa|dss|ed25519) |^ecdsa-sha2-nistp(256|384|521) ",
        default=...,
    )


class UserMembershipsOrgsOrgPatchBody(GitHubRestModel):
    """UserMembershipsOrgsOrgPatchBody"""

    state: Literal["active"] = Field(
        description='The state that the membership should be in. Only `"active"` will be accepted.',
        default=...,
    )


class UserMigrationsPostBody(GitHubRestModel):
    """UserMigrationsPostBody"""

    lock_repositories: Missing[bool] = Field(
        description="Lock the repositories being migrated at the start of the migration",
        default=UNSET,
    )
    exclude_metadata: Missing[bool] = Field(
        description="Indicates whether metadata should be excluded and only git source should be included for the migration.",
        default=UNSET,
    )
    exclude_git_data: Missing[bool] = Field(
        description="Indicates whether the repository git data should be excluded from the migration.",
        default=UNSET,
    )
    exclude_attachments: Missing[bool] = Field(
        description="Do not include attachments in the migration", default=UNSET
    )
    exclude_releases: Missing[bool] = Field(
        description="Do not include releases in the migration", default=UNSET
    )
    exclude_owner_projects: Missing[bool] = Field(
        description="Indicates whether projects owned by the organization or users should be excluded.",
        default=UNSET,
    )
    org_metadata_only: Missing[bool] = Field(
        description="Indicates whether this should only include organization metadata (repositories array should be empty and will ignore other flags).",
        default=False,
    )
    exclude: Missing[List[Literal["repositories"]]] = Field(
        description="Exclude attributes from the API response to improve performance",
        default=UNSET,
    )
    repositories: List[str] = Field(default=...)


class UserProjectsPostBody(GitHubRestModel):
    """UserProjectsPostBody"""

    name: str = Field(description="Name of the project", default=...)
    body: Missing[Union[str, None]] = Field(
        description="Body of the project", default=UNSET
    )


class UserReposPostBody(GitHubRestModel):
    """UserReposPostBody"""

    name: str = Field(description="The name of the repository.", default=...)
    description: Missing[str] = Field(
        description="A short description of the repository.", default=UNSET
    )
    homepage: Missing[str] = Field(
        description="A URL with more information about the repository.", default=UNSET
    )
    private: Missing[bool] = Field(
        description="Whether the repository is private.", default=False
    )
    has_issues: Missing[bool] = Field(
        description="Whether issues are enabled.", default=True
    )
    has_projects: Missing[bool] = Field(
        description="Whether projects are enabled.", default=True
    )
    has_wiki: Missing[bool] = Field(
        description="Whether the wiki is enabled.", default=True
    )
    has_discussions: Missing[bool] = Field(
        description="Whether discussions are enabled.", default=False
    )
    team_id: Missing[int] = Field(
        description="The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.",
        default=UNSET,
    )
    auto_init: Missing[bool] = Field(
        description="Whether the repository is initialized with a minimal README.",
        default=False,
    )
    gitignore_template: Missing[str] = Field(
        description="The desired language or platform to apply to the .gitignore.",
        default=UNSET,
    )
    license_template: Missing[str] = Field(
        description="The license keyword of the open source license for this repository.",
        default=UNSET,
    )
    allow_squash_merge: Missing[bool] = Field(
        description="Whether to allow squash merges for pull requests.", default=True
    )
    allow_merge_commit: Missing[bool] = Field(
        description="Whether to allow merge commits for pull requests.", default=True
    )
    allow_rebase_merge: Missing[bool] = Field(
        description="Whether to allow rebase merges for pull requests.", default=True
    )
    allow_auto_merge: Missing[bool] = Field(
        description="Whether to allow Auto-merge to be used on pull requests.",
        default=False,
    )
    delete_branch_on_merge: Missing[bool] = Field(
        description="Whether to delete head branches when pull requests are merged",
        default=False,
    )
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        default=UNSET,
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
        default=UNSET,
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
        default=UNSET,
    )
    has_downloads: Missing[bool] = Field(
        description="Whether downloads are enabled.", default=True
    )
    is_template: Missing[bool] = Field(
        description="Whether this repository acts as a template that can be used to generate new repositories.",
        default=False,
    )


class UserSocialAccountsPostBody(GitHubRestModel):
    """UserSocialAccountsPostBody

    Examples:
        {'account_urls': ['https://www.linkedin.com/company/github/',
    'https://twitter.com/github']}
    """

    account_urls: List[str] = Field(
        description="Full URLs for the social media profiles to add.", default=...
    )


class UserSocialAccountsDeleteBody(GitHubRestModel):
    """UserSocialAccountsDeleteBody

    Examples:
        {'account_urls': ['https://www.linkedin.com/company/github/',
    'https://twitter.com/github']}
    """

    account_urls: List[str] = Field(
        description="Full URLs for the social media profiles to delete.", default=...
    )


class UserSshSigningKeysPostBody(GitHubRestModel):
    """UserSshSigningKeysPostBody"""

    title: Missing[str] = Field(
        description="A descriptive name for the new key.", default=UNSET
    )
    key: str = Field(
        description='The public SSH key to add to your GitHub account. For more information, see "[Checking for existing SSH keys](https://docs.github.com/authentication/connecting-to-github-with-ssh/checking-for-existing-ssh-keys)."',
        pattern="^ssh-(rsa|dss|ed25519) |^ecdsa-sha2-nistp(256|384|521) |^(sk-ssh-ed25519|sk-ecdsa-sha2-nistp256)@openssh.com ",
        default=...,
    )


Root.update_forward_refs()
SimpleUser.update_forward_refs()
GlobalAdvisory.update_forward_refs()
GlobalAdvisoryPropIdentifiersItems.update_forward_refs()
GlobalAdvisoryPropVulnerabilitiesItems.update_forward_refs()
GlobalAdvisoryPropVulnerabilitiesItemsPropPackage.update_forward_refs()
GlobalAdvisoryPropCvss.update_forward_refs()
GlobalAdvisoryPropCwesItems.update_forward_refs()
GlobalAdvisoryPropCreditsItems.update_forward_refs()
BasicError.update_forward_refs()
ValidationErrorSimple.update_forward_refs()
Integration.update_forward_refs()
IntegrationPropPermissions.update_forward_refs()
WebhookConfig.update_forward_refs()
HookDeliveryItem.update_forward_refs()
ScimError.update_forward_refs()
ValidationError.update_forward_refs()
ValidationErrorPropErrorsItems.update_forward_refs()
HookDelivery.update_forward_refs()
HookDeliveryPropRequest.update_forward_refs()
HookDeliveryPropRequestPropHeaders.update_forward_refs()
HookDeliveryPropRequestPropPayload.update_forward_refs()
HookDeliveryPropResponse.update_forward_refs()
HookDeliveryPropResponsePropHeaders.update_forward_refs()
Enterprise.update_forward_refs()
IntegrationInstallationRequest.update_forward_refs()
AppPermissions.update_forward_refs()
Installation.update_forward_refs()
LicenseSimple.update_forward_refs()
Repository.update_forward_refs()
RepositoryPropPermissions.update_forward_refs()
RepositoryPropTemplateRepositoryPropOwner.update_forward_refs()
RepositoryPropTemplateRepositoryPropPermissions.update_forward_refs()
RepositoryPropTemplateRepository.update_forward_refs()
InstallationToken.update_forward_refs()
ScopedInstallation.update_forward_refs()
Authorization.update_forward_refs()
AuthorizationPropApp.update_forward_refs()
SimpleClassroomRepository.update_forward_refs()
SimpleClassroomOrganization.update_forward_refs()
Classroom.update_forward_refs()
ClassroomAssignment.update_forward_refs()
SimpleClassroomUser.update_forward_refs()
SimpleClassroom.update_forward_refs()
SimpleClassroomAssignment.update_forward_refs()
ClassroomAcceptedAssignment.update_forward_refs()
ClassroomAssignmentGrade.update_forward_refs()
CodeOfConduct.update_forward_refs()
DependabotAlertPackage.update_forward_refs()
DependabotAlertSecurityVulnerability.update_forward_refs()
DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion.update_forward_refs()
DependabotAlertSecurityAdvisory.update_forward_refs()
DependabotAlertSecurityAdvisoryPropCvss.update_forward_refs()
DependabotAlertSecurityAdvisoryPropCwesItems.update_forward_refs()
DependabotAlertSecurityAdvisoryPropIdentifiersItems.update_forward_refs()
DependabotAlertSecurityAdvisoryPropReferencesItems.update_forward_refs()
SimpleRepository.update_forward_refs()
DependabotAlertWithRepository.update_forward_refs()
DependabotAlertWithRepositoryPropDependency.update_forward_refs()
OrganizationSecretScanningAlert.update_forward_refs()
Actor.update_forward_refs()
Milestone.update_forward_refs()
ReactionRollup.update_forward_refs()
Issue.update_forward_refs()
IssuePropLabelsItemsOneof1.update_forward_refs()
IssuePropPullRequest.update_forward_refs()
IssueComment.update_forward_refs()
Event.update_forward_refs()
EventPropRepo.update_forward_refs()
EventPropPayload.update_forward_refs()
EventPropPayloadPropPagesItems.update_forward_refs()
LinkWithType.update_forward_refs()
Feed.update_forward_refs()
FeedPropLinks.update_forward_refs()
BaseGist.update_forward_refs()
BaseGistPropFiles.update_forward_refs()
PublicUser.update_forward_refs()
PublicUserPropPlan.update_forward_refs()
GistHistory.update_forward_refs()
GistHistoryPropChangeStatus.update_forward_refs()
GistSimple.update_forward_refs()
GistSimplePropForksItems.update_forward_refs()
GistSimplePropForkOfPropFiles.update_forward_refs()
GistSimplePropForkOf.update_forward_refs()
GistSimplePropFiles.update_forward_refs()
GistComment.update_forward_refs()
GistCommit.update_forward_refs()
GistCommitPropChangeStatus.update_forward_refs()
GitignoreTemplate.update_forward_refs()
License.update_forward_refs()
MarketplaceListingPlan.update_forward_refs()
MarketplacePurchase.update_forward_refs()
MarketplacePurchasePropMarketplacePendingChange.update_forward_refs()
MarketplacePurchasePropMarketplacePurchase.update_forward_refs()
ApiOverview.update_forward_refs()
ApiOverviewPropSshKeyFingerprints.update_forward_refs()
ApiOverviewPropDomains.update_forward_refs()
SecurityAndAnalysisPropAdvancedSecurity.update_forward_refs()
SecurityAndAnalysisPropDependabotSecurityUpdates.update_forward_refs()
SecurityAndAnalysisPropSecretScanning.update_forward_refs()
SecurityAndAnalysisPropSecretScanningPushProtection.update_forward_refs()
SecurityAndAnalysis.update_forward_refs()
MinimalRepository.update_forward_refs()
MinimalRepositoryPropPermissions.update_forward_refs()
MinimalRepositoryPropLicense.update_forward_refs()
Thread.update_forward_refs()
ThreadPropSubject.update_forward_refs()
ThreadSubscription.update_forward_refs()
OrganizationSimple.update_forward_refs()
OrganizationFull.update_forward_refs()
OrganizationFullPropPlan.update_forward_refs()
ActionsCacheUsageOrgEnterprise.update_forward_refs()
ActionsCacheUsageByRepository.update_forward_refs()
OidcCustomSub.update_forward_refs()
EmptyObject.update_forward_refs()
ActionsOrganizationPermissions.update_forward_refs()
SelectedActions.update_forward_refs()
ActionsGetDefaultWorkflowPermissions.update_forward_refs()
ActionsSetDefaultWorkflowPermissions.update_forward_refs()
RunnerLabel.update_forward_refs()
Runner.update_forward_refs()
RunnerApplication.update_forward_refs()
AuthenticationToken.update_forward_refs()
AuthenticationTokenPropPermissions.update_forward_refs()
OrganizationActionsSecret.update_forward_refs()
ActionsPublicKey.update_forward_refs()
OrganizationActionsVariable.update_forward_refs()
CodeScanningAlertRule.update_forward_refs()
CodeScanningAnalysisTool.update_forward_refs()
CodeScanningAlertLocation.update_forward_refs()
CodeScanningAlertInstance.update_forward_refs()
CodeScanningAlertInstancePropMessage.update_forward_refs()
CodeScanningOrganizationAlertItems.update_forward_refs()
CodespaceMachine.update_forward_refs()
Codespace.update_forward_refs()
CodespacePropGitStatus.update_forward_refs()
CodespacePropRuntimeConstraints.update_forward_refs()
CodespacesOrgSecret.update_forward_refs()
CodespacesPublicKey.update_forward_refs()
CopilotSeatBreakdown.update_forward_refs()
CopilotOrganizationDetails.update_forward_refs()
TeamSimple.update_forward_refs()
Team.update_forward_refs()
TeamPropPermissions.update_forward_refs()
Organization.update_forward_refs()
OrganizationPropPlan.update_forward_refs()
CopilotSeatDetails.update_forward_refs()
OrganizationDependabotSecret.update_forward_refs()
DependabotPublicKey.update_forward_refs()
Package.update_forward_refs()
OrganizationInvitation.update_forward_refs()
OrgHook.update_forward_refs()
OrgHookPropConfig.update_forward_refs()
InteractionLimitResponse.update_forward_refs()
InteractionLimit.update_forward_refs()
OrgMembership.update_forward_refs()
OrgMembershipPropPermissions.update_forward_refs()
Migration.update_forward_refs()
PackageVersion.update_forward_refs()
PackageVersionPropMetadata.update_forward_refs()
PackageVersionPropMetadataPropContainer.update_forward_refs()
PackageVersionPropMetadataPropDocker.update_forward_refs()
OrganizationProgrammaticAccessGrantRequest.update_forward_refs()
OrganizationProgrammaticAccessGrantRequestPropPermissions.update_forward_refs()
OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganization.update_forward_refs()
OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepository.update_forward_refs()
OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOther.update_forward_refs()
OrganizationProgrammaticAccessGrant.update_forward_refs()
OrganizationProgrammaticAccessGrantPropPermissions.update_forward_refs()
OrganizationProgrammaticAccessGrantPropPermissionsPropOrganization.update_forward_refs()
OrganizationProgrammaticAccessGrantPropPermissionsPropRepository.update_forward_refs()
OrganizationProgrammaticAccessGrantPropPermissionsPropOther.update_forward_refs()
Project.update_forward_refs()
RepositoryRulesetBypassActor.update_forward_refs()
RepositoryRulesetConditions.update_forward_refs()
RepositoryRulesetConditionsPropRefName.update_forward_refs()
RepositoryRulesetConditionsRepositoryNameTarget.update_forward_refs()
RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName.update_forward_refs()
RepositoryRulesetConditionsRepositoryIdTarget.update_forward_refs()
RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId.update_forward_refs()
OrgRulesetConditionsOneof0.update_forward_refs()
OrgRulesetConditionsOneof1.update_forward_refs()
RepositoryRuleCreation.update_forward_refs()
RepositoryRuleUpdate.update_forward_refs()
RepositoryRuleUpdatePropParameters.update_forward_refs()
RepositoryRuleDeletion.update_forward_refs()
RepositoryRuleRequiredLinearHistory.update_forward_refs()
RepositoryRuleRequiredDeployments.update_forward_refs()
RepositoryRuleRequiredDeploymentsPropParameters.update_forward_refs()
RepositoryRuleRequiredSignatures.update_forward_refs()
RepositoryRulePullRequest.update_forward_refs()
RepositoryRulePullRequestPropParameters.update_forward_refs()
RepositoryRuleParamsStatusCheckConfiguration.update_forward_refs()
RepositoryRuleRequiredStatusChecks.update_forward_refs()
RepositoryRuleRequiredStatusChecksPropParameters.update_forward_refs()
RepositoryRuleNonFastForward.update_forward_refs()
RepositoryRuleCommitMessagePattern.update_forward_refs()
RepositoryRuleCommitMessagePatternPropParameters.update_forward_refs()
RepositoryRuleCommitAuthorEmailPattern.update_forward_refs()
RepositoryRuleCommitAuthorEmailPatternPropParameters.update_forward_refs()
RepositoryRuleCommitterEmailPattern.update_forward_refs()
RepositoryRuleCommitterEmailPatternPropParameters.update_forward_refs()
RepositoryRuleBranchNamePattern.update_forward_refs()
RepositoryRuleBranchNamePatternPropParameters.update_forward_refs()
RepositoryRuleTagNamePattern.update_forward_refs()
RepositoryRuleTagNamePatternPropParameters.update_forward_refs()
RepositoryRuleset.update_forward_refs()
RepositoryRulesetPropLinks.update_forward_refs()
RepositoryRulesetPropLinksPropSelf.update_forward_refs()
RepositoryRulesetPropLinksPropHtml.update_forward_refs()
RepositoryAdvisoryVulnerability.update_forward_refs()
RepositoryAdvisoryVulnerabilityPropPackage.update_forward_refs()
RepositoryAdvisoryCredit.update_forward_refs()
RepositoryAdvisory.update_forward_refs()
RepositoryAdvisoryPropIdentifiersItems.update_forward_refs()
RepositoryAdvisoryPropSubmission.update_forward_refs()
RepositoryAdvisoryPropCvss.update_forward_refs()
RepositoryAdvisoryPropCwesItems.update_forward_refs()
RepositoryAdvisoryPropCreditsItems.update_forward_refs()
ActionsBillingUsage.update_forward_refs()
ActionsBillingUsagePropMinutesUsedBreakdown.update_forward_refs()
PackagesBillingUsage.update_forward_refs()
CombinedBillingUsage.update_forward_refs()
TeamOrganization.update_forward_refs()
TeamOrganizationPropPlan.update_forward_refs()
TeamFull.update_forward_refs()
TeamDiscussion.update_forward_refs()
TeamDiscussionComment.update_forward_refs()
Reaction.update_forward_refs()
TeamMembership.update_forward_refs()
TeamProject.update_forward_refs()
TeamProjectPropPermissions.update_forward_refs()
TeamRepository.update_forward_refs()
TeamRepositoryPropPermissions.update_forward_refs()
ProjectCard.update_forward_refs()
ProjectColumn.update_forward_refs()
ProjectCollaboratorPermission.update_forward_refs()
RateLimit.update_forward_refs()
RateLimitOverview.update_forward_refs()
RateLimitOverviewPropResources.update_forward_refs()
CodeOfConductSimple.update_forward_refs()
FullRepository.update_forward_refs()
FullRepositoryPropPermissions.update_forward_refs()
Artifact.update_forward_refs()
ArtifactPropWorkflowRun.update_forward_refs()
ActionsCacheList.update_forward_refs()
ActionsCacheListPropActionsCachesItems.update_forward_refs()
Job.update_forward_refs()
JobPropStepsItems.update_forward_refs()
OidcCustomSubRepo.update_forward_refs()
ActionsSecret.update_forward_refs()
ActionsVariable.update_forward_refs()
ActionsRepositoryPermissions.update_forward_refs()
ActionsWorkflowAccessToRepository.update_forward_refs()
ReferencedWorkflow.update_forward_refs()
PullRequestMinimal.update_forward_refs()
PullRequestMinimalPropHead.update_forward_refs()
PullRequestMinimalPropHeadPropRepo.update_forward_refs()
PullRequestMinimalPropBase.update_forward_refs()
PullRequestMinimalPropBasePropRepo.update_forward_refs()
SimpleCommit.update_forward_refs()
SimpleCommitPropAuthor.update_forward_refs()
SimpleCommitPropCommitter.update_forward_refs()
WorkflowRun.update_forward_refs()
EnvironmentApprovals.update_forward_refs()
EnvironmentApprovalsPropEnvironmentsItems.update_forward_refs()
ReviewCustomGatesCommentRequired.update_forward_refs()
ReviewCustomGatesStateRequired.update_forward_refs()
PendingDeployment.update_forward_refs()
PendingDeploymentPropEnvironment.update_forward_refs()
PendingDeploymentPropReviewersItems.update_forward_refs()
Deployment.update_forward_refs()
DeploymentPropPayloadOneof0.update_forward_refs()
WorkflowRunUsage.update_forward_refs()
WorkflowRunUsagePropBillable.update_forward_refs()
WorkflowRunUsagePropBillablePropUbuntu.update_forward_refs()
WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems.update_forward_refs()
WorkflowRunUsagePropBillablePropMacos.update_forward_refs()
WorkflowRunUsagePropBillablePropMacosPropJobRunsItems.update_forward_refs()
WorkflowRunUsagePropBillablePropWindows.update_forward_refs()
WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems.update_forward_refs()
Workflow.update_forward_refs()
WorkflowUsage.update_forward_refs()
WorkflowUsagePropBillable.update_forward_refs()
WorkflowUsagePropBillablePropUbuntu.update_forward_refs()
WorkflowUsagePropBillablePropMacos.update_forward_refs()
WorkflowUsagePropBillablePropWindows.update_forward_refs()
Activity.update_forward_refs()
Autolink.update_forward_refs()
CheckAutomatedSecurityFixes.update_forward_refs()
ProtectedBranchRequiredStatusCheck.update_forward_refs()
ProtectedBranchRequiredStatusCheckPropChecksItems.update_forward_refs()
ProtectedBranchAdminEnforced.update_forward_refs()
ProtectedBranchPullRequestReview.update_forward_refs()
ProtectedBranchPullRequestReviewPropDismissalRestrictions.update_forward_refs()
ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances.update_forward_refs()
BranchRestrictionPolicy.update_forward_refs()
BranchRestrictionPolicyPropUsersItems.update_forward_refs()
BranchRestrictionPolicyPropTeamsItems.update_forward_refs()
BranchRestrictionPolicyPropAppsItems.update_forward_refs()
BranchRestrictionPolicyPropAppsItemsPropOwner.update_forward_refs()
BranchRestrictionPolicyPropAppsItemsPropPermissions.update_forward_refs()
BranchProtection.update_forward_refs()
BranchProtectionPropRequiredLinearHistory.update_forward_refs()
BranchProtectionPropAllowForcePushes.update_forward_refs()
BranchProtectionPropAllowDeletions.update_forward_refs()
BranchProtectionPropBlockCreations.update_forward_refs()
BranchProtectionPropRequiredConversationResolution.update_forward_refs()
BranchProtectionPropRequiredSignatures.update_forward_refs()
BranchProtectionPropLockBranch.update_forward_refs()
BranchProtectionPropAllowForkSyncing.update_forward_refs()
ShortBranch.update_forward_refs()
ShortBranchPropCommit.update_forward_refs()
GitUser.update_forward_refs()
Verification.update_forward_refs()
DiffEntry.update_forward_refs()
Commit.update_forward_refs()
CommitPropCommit.update_forward_refs()
CommitPropCommitPropTree.update_forward_refs()
CommitPropParentsItems.update_forward_refs()
CommitPropStats.update_forward_refs()
BranchWithProtection.update_forward_refs()
BranchWithProtectionPropLinks.update_forward_refs()
StatusCheckPolicy.update_forward_refs()
StatusCheckPolicyPropChecksItems.update_forward_refs()
ProtectedBranch.update_forward_refs()
ProtectedBranchPropRequiredPullRequestReviews.update_forward_refs()
ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions.update_forward_refs()
ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances.update_forward_refs()
ProtectedBranchPropRequiredSignatures.update_forward_refs()
ProtectedBranchPropEnforceAdmins.update_forward_refs()
ProtectedBranchPropRequiredLinearHistory.update_forward_refs()
ProtectedBranchPropAllowForcePushes.update_forward_refs()
ProtectedBranchPropAllowDeletions.update_forward_refs()
ProtectedBranchPropRequiredConversationResolution.update_forward_refs()
ProtectedBranchPropBlockCreations.update_forward_refs()
ProtectedBranchPropLockBranch.update_forward_refs()
ProtectedBranchPropAllowForkSyncing.update_forward_refs()
DeploymentSimple.update_forward_refs()
CheckRun.update_forward_refs()
CheckRunPropOutput.update_forward_refs()
CheckRunPropCheckSuite.update_forward_refs()
CheckAnnotation.update_forward_refs()
CheckSuite.update_forward_refs()
CheckSuitePreference.update_forward_refs()
CheckSuitePreferencePropPreferences.update_forward_refs()
CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems.update_forward_refs()
CodeScanningAlertRuleSummary.update_forward_refs()
CodeScanningAlertItems.update_forward_refs()
CodeScanningAlert.update_forward_refs()
CodeScanningAnalysis.update_forward_refs()
CodeScanningAnalysisDeletion.update_forward_refs()
CodeScanningCodeqlDatabase.update_forward_refs()
CodeScanningDefaultSetup.update_forward_refs()
CodeScanningDefaultSetupUpdate.update_forward_refs()
CodeScanningDefaultSetupUpdateResponse.update_forward_refs()
CodeScanningSarifsReceipt.update_forward_refs()
CodeScanningSarifsStatus.update_forward_refs()
CodeownersErrors.update_forward_refs()
CodeownersErrorsPropErrorsItems.update_forward_refs()
RepoCodespacesSecret.update_forward_refs()
Collaborator.update_forward_refs()
CollaboratorPropPermissions.update_forward_refs()
RepositoryInvitation.update_forward_refs()
RepositoryCollaboratorPermission.update_forward_refs()
CommitComment.update_forward_refs()
BranchShort.update_forward_refs()
BranchShortPropCommit.update_forward_refs()
Link.update_forward_refs()
AutoMerge.update_forward_refs()
PullRequestSimple.update_forward_refs()
PullRequestSimplePropLabelsItems.update_forward_refs()
PullRequestSimplePropHead.update_forward_refs()
PullRequestSimplePropBase.update_forward_refs()
PullRequestSimplePropLinks.update_forward_refs()
SimpleCommitStatus.update_forward_refs()
CombinedCommitStatus.update_forward_refs()
Status.update_forward_refs()
CommunityHealthFile.update_forward_refs()
CommunityProfile.update_forward_refs()
CommunityProfilePropFiles.update_forward_refs()
CommitComparison.update_forward_refs()
ContentTree.update_forward_refs()
ContentTreePropEntriesItems.update_forward_refs()
ContentTreePropEntriesItemsPropLinks.update_forward_refs()
ContentTreePropLinks.update_forward_refs()
ContentDirectoryItems.update_forward_refs()
ContentDirectoryItemsPropLinks.update_forward_refs()
ContentFile.update_forward_refs()
ContentFilePropLinks.update_forward_refs()
ContentSymlink.update_forward_refs()
ContentSymlinkPropLinks.update_forward_refs()
ContentSubmodule.update_forward_refs()
ContentSubmodulePropLinks.update_forward_refs()
FileCommit.update_forward_refs()
FileCommitPropContentPropLinks.update_forward_refs()
FileCommitPropContent.update_forward_refs()
FileCommitPropCommit.update_forward_refs()
FileCommitPropCommitPropAuthor.update_forward_refs()
FileCommitPropCommitPropCommitter.update_forward_refs()
FileCommitPropCommitPropTree.update_forward_refs()
FileCommitPropCommitPropParentsItems.update_forward_refs()
FileCommitPropCommitPropVerification.update_forward_refs()
Contributor.update_forward_refs()
DependabotAlert.update_forward_refs()
DependabotAlertPropDependency.update_forward_refs()
DependabotSecret.update_forward_refs()
DependencyGraphDiffItems.update_forward_refs()
DependencyGraphDiffItemsPropVulnerabilitiesItems.update_forward_refs()
DependencyGraphSpdxSbom.update_forward_refs()
DependencyGraphSpdxSbomPropSbom.update_forward_refs()
DependencyGraphSpdxSbomPropSbomPropCreationInfo.update_forward_refs()
DependencyGraphSpdxSbomPropSbomPropPackagesItems.update_forward_refs()
DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItems.update_forward_refs()
Metadata.update_forward_refs()
Dependency.update_forward_refs()
Manifest.update_forward_refs()
ManifestPropFile.update_forward_refs()
ManifestPropResolved.update_forward_refs()
Snapshot.update_forward_refs()
SnapshotPropJob.update_forward_refs()
SnapshotPropDetector.update_forward_refs()
SnapshotPropManifests.update_forward_refs()
DeploymentStatus.update_forward_refs()
DeploymentBranchPolicySettings.update_forward_refs()
Environment.update_forward_refs()
EnvironmentPropProtectionRulesItemsAnyof0.update_forward_refs()
EnvironmentPropProtectionRulesItemsAnyof1.update_forward_refs()
EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems.update_forward_refs()
EnvironmentPropProtectionRulesItemsAnyof2.update_forward_refs()
DeploymentBranchPolicy.update_forward_refs()
DeploymentBranchPolicyNamePattern.update_forward_refs()
CustomDeploymentRuleApp.update_forward_refs()
DeploymentProtectionRule.update_forward_refs()
ShortBlob.update_forward_refs()
Blob.update_forward_refs()
GitCommit.update_forward_refs()
GitCommitPropAuthor.update_forward_refs()
GitCommitPropCommitter.update_forward_refs()
GitCommitPropTree.update_forward_refs()
GitCommitPropParentsItems.update_forward_refs()
GitCommitPropVerification.update_forward_refs()
GitRef.update_forward_refs()
GitRefPropObject.update_forward_refs()
GitTag.update_forward_refs()
GitTagPropTagger.update_forward_refs()
GitTagPropObject.update_forward_refs()
GitTree.update_forward_refs()
GitTreePropTreeItems.update_forward_refs()
HookResponse.update_forward_refs()
Hook.update_forward_refs()
HookPropConfig.update_forward_refs()
Import.update_forward_refs()
ImportPropProjectChoicesItems.update_forward_refs()
PorterAuthor.update_forward_refs()
PorterLargeFile.update_forward_refs()
IssueEventLabel.update_forward_refs()
IssueEventDismissedReview.update_forward_refs()
IssueEventMilestone.update_forward_refs()
IssueEventProjectCard.update_forward_refs()
IssueEventRename.update_forward_refs()
IssueEvent.update_forward_refs()
LabeledIssueEvent.update_forward_refs()
LabeledIssueEventPropLabel.update_forward_refs()
UnlabeledIssueEvent.update_forward_refs()
UnlabeledIssueEventPropLabel.update_forward_refs()
AssignedIssueEvent.update_forward_refs()
UnassignedIssueEvent.update_forward_refs()
MilestonedIssueEvent.update_forward_refs()
MilestonedIssueEventPropMilestone.update_forward_refs()
DemilestonedIssueEvent.update_forward_refs()
DemilestonedIssueEventPropMilestone.update_forward_refs()
RenamedIssueEvent.update_forward_refs()
RenamedIssueEventPropRename.update_forward_refs()
ReviewRequestedIssueEvent.update_forward_refs()
ReviewRequestRemovedIssueEvent.update_forward_refs()
ReviewDismissedIssueEvent.update_forward_refs()
ReviewDismissedIssueEventPropDismissedReview.update_forward_refs()
LockedIssueEvent.update_forward_refs()
AddedToProjectIssueEvent.update_forward_refs()
AddedToProjectIssueEventPropProjectCard.update_forward_refs()
MovedColumnInProjectIssueEvent.update_forward_refs()
MovedColumnInProjectIssueEventPropProjectCard.update_forward_refs()
RemovedFromProjectIssueEvent.update_forward_refs()
RemovedFromProjectIssueEventPropProjectCard.update_forward_refs()
ConvertedNoteToIssueIssueEvent.update_forward_refs()
ConvertedNoteToIssueIssueEventPropProjectCard.update_forward_refs()
Label.update_forward_refs()
TimelineCommentEvent.update_forward_refs()
TimelineCrossReferencedEvent.update_forward_refs()
TimelineCrossReferencedEventPropSource.update_forward_refs()
TimelineCommittedEvent.update_forward_refs()
TimelineCommittedEventPropAuthor.update_forward_refs()
TimelineCommittedEventPropCommitter.update_forward_refs()
TimelineCommittedEventPropTree.update_forward_refs()
TimelineCommittedEventPropParentsItems.update_forward_refs()
TimelineCommittedEventPropVerification.update_forward_refs()
TimelineReviewedEvent.update_forward_refs()
TimelineReviewedEventPropLinks.update_forward_refs()
TimelineReviewedEventPropLinksPropHtml.update_forward_refs()
TimelineReviewedEventPropLinksPropPullRequest.update_forward_refs()
PullRequestReviewComment.update_forward_refs()
PullRequestReviewCommentPropLinks.update_forward_refs()
PullRequestReviewCommentPropLinksPropSelf.update_forward_refs()
PullRequestReviewCommentPropLinksPropHtml.update_forward_refs()
PullRequestReviewCommentPropLinksPropPullRequest.update_forward_refs()
TimelineLineCommentedEvent.update_forward_refs()
TimelineCommitCommentedEvent.update_forward_refs()
TimelineAssignedIssueEvent.update_forward_refs()
TimelineUnassignedIssueEvent.update_forward_refs()
StateChangeIssueEvent.update_forward_refs()
DeployKey.update_forward_refs()
Language.update_forward_refs()
LicenseContent.update_forward_refs()
LicenseContentPropLinks.update_forward_refs()
MergedUpstream.update_forward_refs()
PagesSourceHash.update_forward_refs()
PagesHttpsCertificate.update_forward_refs()
Page.update_forward_refs()
PageBuild.update_forward_refs()
PageBuildPropError.update_forward_refs()
PageBuildStatus.update_forward_refs()
PageDeployment.update_forward_refs()
PagesHealthCheck.update_forward_refs()
PagesHealthCheckPropDomain.update_forward_refs()
PagesHealthCheckPropAltDomain.update_forward_refs()
PullRequest.update_forward_refs()
PullRequestPropLabelsItems.update_forward_refs()
PullRequestPropHead.update_forward_refs()
PullRequestPropHeadPropRepoPropOwner.update_forward_refs()
PullRequestPropHeadPropRepoPropPermissions.update_forward_refs()
PullRequestPropHeadPropRepoPropLicense.update_forward_refs()
PullRequestPropHeadPropRepo.update_forward_refs()
PullRequestPropHeadPropUser.update_forward_refs()
PullRequestPropBase.update_forward_refs()
PullRequestPropBasePropRepo.update_forward_refs()
PullRequestPropBasePropRepoPropOwner.update_forward_refs()
PullRequestPropBasePropRepoPropPermissions.update_forward_refs()
PullRequestPropBasePropUser.update_forward_refs()
PullRequestPropLinks.update_forward_refs()
PullRequestMergeResult.update_forward_refs()
PullRequestReviewRequest.update_forward_refs()
PullRequestReview.update_forward_refs()
PullRequestReviewPropLinks.update_forward_refs()
PullRequestReviewPropLinksPropHtml.update_forward_refs()
PullRequestReviewPropLinksPropPullRequest.update_forward_refs()
ReviewComment.update_forward_refs()
ReviewCommentPropLinks.update_forward_refs()
ReleaseAsset.update_forward_refs()
Release.update_forward_refs()
ReleaseNotesContent.update_forward_refs()
RepositoryRuleRulesetInfo.update_forward_refs()
RepositoryRuleDetailedOneof0.update_forward_refs()
RepositoryRuleDetailedOneof1.update_forward_refs()
RepositoryRuleDetailedOneof2.update_forward_refs()
RepositoryRuleDetailedOneof3.update_forward_refs()
RepositoryRuleDetailedOneof4.update_forward_refs()
RepositoryRuleDetailedOneof5.update_forward_refs()
RepositoryRuleDetailedOneof6.update_forward_refs()
RepositoryRuleDetailedOneof7.update_forward_refs()
RepositoryRuleDetailedOneof8.update_forward_refs()
RepositoryRuleDetailedOneof9.update_forward_refs()
RepositoryRuleDetailedOneof10.update_forward_refs()
RepositoryRuleDetailedOneof11.update_forward_refs()
RepositoryRuleDetailedOneof12.update_forward_refs()
RepositoryRuleDetailedOneof13.update_forward_refs()
SecretScanningAlert.update_forward_refs()
SecretScanningLocationCommit.update_forward_refs()
SecretScanningLocationIssueTitle.update_forward_refs()
SecretScanningLocationIssueBody.update_forward_refs()
SecretScanningLocationIssueComment.update_forward_refs()
SecretScanningLocation.update_forward_refs()
RepositoryAdvisoryCreate.update_forward_refs()
RepositoryAdvisoryCreatePropVulnerabilitiesItems.update_forward_refs()
RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackage.update_forward_refs()
RepositoryAdvisoryCreatePropCreditsItems.update_forward_refs()
PrivateVulnerabilityReportCreate.update_forward_refs()
PrivateVulnerabilityReportCreatePropVulnerabilitiesItems.update_forward_refs()
PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackage.update_forward_refs()
RepositoryAdvisoryUpdate.update_forward_refs()
RepositoryAdvisoryUpdatePropVulnerabilitiesItems.update_forward_refs()
RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackage.update_forward_refs()
RepositoryAdvisoryUpdatePropCreditsItems.update_forward_refs()
Stargazer.update_forward_refs()
CommitActivity.update_forward_refs()
ContributorActivity.update_forward_refs()
ContributorActivityPropWeeksItems.update_forward_refs()
ParticipationStats.update_forward_refs()
RepositorySubscription.update_forward_refs()
Tag.update_forward_refs()
TagPropCommit.update_forward_refs()
TagProtection.update_forward_refs()
Topic.update_forward_refs()
Traffic.update_forward_refs()
CloneTraffic.update_forward_refs()
ContentTraffic.update_forward_refs()
ReferrerTraffic.update_forward_refs()
ViewTraffic.update_forward_refs()
SearchResultTextMatchesItems.update_forward_refs()
SearchResultTextMatchesItemsPropMatchesItems.update_forward_refs()
CodeSearchResultItem.update_forward_refs()
CommitSearchResultItem.update_forward_refs()
CommitSearchResultItemPropCommit.update_forward_refs()
CommitSearchResultItemPropCommitPropAuthor.update_forward_refs()
CommitSearchResultItemPropCommitPropTree.update_forward_refs()
CommitSearchResultItemPropParentsItems.update_forward_refs()
IssueSearchResultItem.update_forward_refs()
IssueSearchResultItemPropLabelsItems.update_forward_refs()
IssueSearchResultItemPropPullRequest.update_forward_refs()
LabelSearchResultItem.update_forward_refs()
RepoSearchResultItem.update_forward_refs()
RepoSearchResultItemPropPermissions.update_forward_refs()
TopicSearchResultItem.update_forward_refs()
TopicSearchResultItemPropRelatedItems.update_forward_refs()
TopicSearchResultItemPropRelatedItemsPropTopicRelation.update_forward_refs()
TopicSearchResultItemPropAliasesItems.update_forward_refs()
TopicSearchResultItemPropAliasesItemsPropTopicRelation.update_forward_refs()
UserSearchResultItem.update_forward_refs()
PrivateUser.update_forward_refs()
PrivateUserPropPlan.update_forward_refs()
CodespacesSecret.update_forward_refs()
CodespacesUserPublicKey.update_forward_refs()
CodespaceExportDetails.update_forward_refs()
CodespaceWithFullRepository.update_forward_refs()
CodespaceWithFullRepositoryPropGitStatus.update_forward_refs()
CodespaceWithFullRepositoryPropRuntimeConstraints.update_forward_refs()
Email.update_forward_refs()
GpgKey.update_forward_refs()
GpgKeyPropEmailsItems.update_forward_refs()
GpgKeyPropSubkeysItems.update_forward_refs()
GpgKeyPropSubkeysItemsPropEmailsItems.update_forward_refs()
Key.update_forward_refs()
MarketplaceAccount.update_forward_refs()
UserMarketplacePurchase.update_forward_refs()
SocialAccount.update_forward_refs()
SshSigningKey.update_forward_refs()
StarredRepository.update_forward_refs()
Hovercard.update_forward_refs()
HovercardPropContextsItems.update_forward_refs()
KeySimple.update_forward_refs()
SimpleInstallation.update_forward_refs()
OrganizationSimpleWebhooks.update_forward_refs()
RepositoryWebhooks.update_forward_refs()
RepositoryWebhooksPropPermissions.update_forward_refs()
RepositoryWebhooksPropTemplateRepositoryPropOwner.update_forward_refs()
RepositoryWebhooksPropTemplateRepositoryPropPermissions.update_forward_refs()
RepositoryWebhooksPropTemplateRepository.update_forward_refs()
SimpleUserWebhooks.update_forward_refs()
SimpleCheckSuite.update_forward_refs()
CheckRunWithSimpleCheckSuite.update_forward_refs()
CheckRunWithSimpleCheckSuitePropOutput.update_forward_refs()
Discussion.update_forward_refs()
DiscussionPropAnswerChosenBy.update_forward_refs()
DiscussionPropCategory.update_forward_refs()
DiscussionPropReactions.update_forward_refs()
DiscussionPropUser.update_forward_refs()
MergeGroup.update_forward_refs()
PersonalAccessTokenRequest.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsAdded.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsAddedPropOrganization.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsAddedPropRepository.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsAddedPropOther.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsUpgraded.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganization.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsUpgradedPropRepository.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsUpgradedPropOther.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsResult.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsResultPropOrganization.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsResultPropRepository.update_forward_refs()
PersonalAccessTokenRequestPropPermissionsResultPropOther.update_forward_refs()
PersonalAccessTokenRequestPropRepositoriesItems.update_forward_refs()
ProjectsV2.update_forward_refs()
ProjectsV2Item.update_forward_refs()
SecretScanningAlertWebhook.update_forward_refs()
AppManifestsCodeConversionsPostResponse201.update_forward_refs()
AppManifestsCodeConversionsPostResponse201Allof1.update_forward_refs()
AppHookConfigPatchBody.update_forward_refs()
AppHookDeliveriesDeliveryIdAttemptsPostResponse202.update_forward_refs()
AppInstallationsInstallationIdAccessTokensPostBody.update_forward_refs()
ApplicationsClientIdGrantDeleteBody.update_forward_refs()
ApplicationsClientIdTokenPostBody.update_forward_refs()
ApplicationsClientIdTokenDeleteBody.update_forward_refs()
ApplicationsClientIdTokenPatchBody.update_forward_refs()
ApplicationsClientIdTokenScopedPostBody.update_forward_refs()
EmojisGetResponse200.update_forward_refs()
EnterprisesEnterpriseSecretScanningAlertsGetResponse503.update_forward_refs()
GistsPostBody.update_forward_refs()
GistsPostBodyPropFiles.update_forward_refs()
GistsGistIdGetResponse403.update_forward_refs()
GistsGistIdGetResponse403PropBlock.update_forward_refs()
GistsGistIdPatchBodyPropFiles.update_forward_refs()
GistsGistIdPatchBody.update_forward_refs()
GistsGistIdCommentsPostBody.update_forward_refs()
GistsGistIdCommentsCommentIdPatchBody.update_forward_refs()
GistsGistIdStarGetResponse404.update_forward_refs()
InstallationRepositoriesGetResponse200.update_forward_refs()
MarkdownPostBody.update_forward_refs()
NotificationsPutBody.update_forward_refs()
NotificationsPutResponse202.update_forward_refs()
NotificationsThreadsThreadIdSubscriptionPutBody.update_forward_refs()
OrgsOrgPatchBody.update_forward_refs()
OrgsOrgActionsCacheUsageByRepositoryGetResponse200.update_forward_refs()
OrgsOrgActionsPermissionsPutBody.update_forward_refs()
OrgsOrgActionsPermissionsRepositoriesGetResponse200.update_forward_refs()
OrgsOrgActionsPermissionsRepositoriesPutBody.update_forward_refs()
OrgsOrgActionsRunnersGetResponse200.update_forward_refs()
OrgsOrgActionsRunnersGenerateJitconfigPostBody.update_forward_refs()
OrgsOrgActionsRunnersGenerateJitconfigPostResponse201.update_forward_refs()
OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200.update_forward_refs()
OrgsOrgActionsRunnersRunnerIdLabelsPutBody.update_forward_refs()
OrgsOrgActionsRunnersRunnerIdLabelsPostBody.update_forward_refs()
OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200.update_forward_refs()
OrgsOrgActionsSecretsGetResponse200.update_forward_refs()
OrgsOrgActionsSecretsSecretNamePutBody.update_forward_refs()
OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200.update_forward_refs()
OrgsOrgActionsSecretsSecretNameRepositoriesPutBody.update_forward_refs()
OrgsOrgActionsVariablesGetResponse200.update_forward_refs()
OrgsOrgActionsVariablesPostBody.update_forward_refs()
OrgsOrgActionsVariablesNamePatchBody.update_forward_refs()
OrgsOrgActionsVariablesNameRepositoriesGetResponse200.update_forward_refs()
OrgsOrgActionsVariablesNameRepositoriesPutBody.update_forward_refs()
OrgsOrgCodespacesGetResponse200.update_forward_refs()
OrgsOrgCodespacesAccessPutBody.update_forward_refs()
OrgsOrgCodespacesAccessSelectedUsersPostBody.update_forward_refs()
OrgsOrgCodespacesAccessSelectedUsersDeleteBody.update_forward_refs()
OrgsOrgCodespacesSecretsGetResponse200.update_forward_refs()
OrgsOrgCodespacesSecretsSecretNamePutBody.update_forward_refs()
OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200.update_forward_refs()
OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody.update_forward_refs()
OrgsOrgCopilotBillingSeatsGetResponse200.update_forward_refs()
OrgsOrgCopilotBillingSelectedTeamsPostBody.update_forward_refs()
OrgsOrgCopilotBillingSelectedTeamsPostResponse201.update_forward_refs()
OrgsOrgCopilotBillingSelectedTeamsDeleteBody.update_forward_refs()
OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200.update_forward_refs()
OrgsOrgCopilotBillingSelectedUsersPostBody.update_forward_refs()
OrgsOrgCopilotBillingSelectedUsersPostResponse201.update_forward_refs()
OrgsOrgCopilotBillingSelectedUsersDeleteBody.update_forward_refs()
OrgsOrgCopilotBillingSelectedUsersDeleteResponse200.update_forward_refs()
OrgsOrgDependabotSecretsGetResponse200.update_forward_refs()
OrgsOrgDependabotSecretsSecretNamePutBody.update_forward_refs()
OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200.update_forward_refs()
OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody.update_forward_refs()
OrgsOrgHooksPostBody.update_forward_refs()
OrgsOrgHooksPostBodyPropConfig.update_forward_refs()
OrgsOrgHooksHookIdPatchBody.update_forward_refs()
OrgsOrgHooksHookIdPatchBodyPropConfig.update_forward_refs()
OrgsOrgHooksHookIdConfigPatchBody.update_forward_refs()
OrgsOrgInstallationsGetResponse200.update_forward_refs()
OrgsOrgInteractionLimitsGetResponse200Anyof1.update_forward_refs()
OrgsOrgInvitationsPostBody.update_forward_refs()
OrgsOrgMembersUsernameCodespacesGetResponse200.update_forward_refs()
OrgsOrgMembershipsUsernamePutBody.update_forward_refs()
OrgsOrgMigrationsPostBody.update_forward_refs()
OrgsOrgOutsideCollaboratorsUsernamePutBody.update_forward_refs()
OrgsOrgOutsideCollaboratorsUsernamePutResponse202.update_forward_refs()
OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422.update_forward_refs()
OrgsOrgPersonalAccessTokenRequestsPostBody.update_forward_refs()
OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody.update_forward_refs()
OrgsOrgPersonalAccessTokensPostBody.update_forward_refs()
OrgsOrgPersonalAccessTokensPatIdPostBody.update_forward_refs()
OrgsOrgProjectsPostBody.update_forward_refs()
OrgsOrgReposPostBody.update_forward_refs()
OrgsOrgRulesetsPostBody.update_forward_refs()
OrgsOrgRulesetsRulesetIdPutBody.update_forward_refs()
OrgsOrgTeamsPostBody.update_forward_refs()
OrgsOrgTeamsTeamSlugPatchBody.update_forward_refs()
OrgsOrgTeamsTeamSlugDiscussionsPostBody.update_forward_refs()
OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody.update_forward_refs()
OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody.update_forward_refs()
OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody.update_forward_refs()
OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody.update_forward_refs()
OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody.update_forward_refs()
OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody.update_forward_refs()
OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody.update_forward_refs()
OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403.update_forward_refs()
OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody.update_forward_refs()
OrgsOrgSecurityProductEnablementPostBody.update_forward_refs()
ProjectsColumnsCardsCardIdDeleteResponse403.update_forward_refs()
ProjectsColumnsCardsCardIdPatchBody.update_forward_refs()
ProjectsColumnsCardsCardIdMovesPostBody.update_forward_refs()
ProjectsColumnsCardsCardIdMovesPostResponse201.update_forward_refs()
ProjectsColumnsCardsCardIdMovesPostResponse403.update_forward_refs()
ProjectsColumnsCardsCardIdMovesPostResponse403PropErrorsItems.update_forward_refs()
ProjectsColumnsCardsCardIdMovesPostResponse503.update_forward_refs()
ProjectsColumnsCardsCardIdMovesPostResponse503PropErrorsItems.update_forward_refs()
ProjectsColumnsColumnIdPatchBody.update_forward_refs()
ProjectsColumnsColumnIdCardsPostBodyOneof0.update_forward_refs()
ProjectsColumnsColumnIdCardsPostBodyOneof1.update_forward_refs()
ProjectsColumnsColumnIdCardsPostResponse503.update_forward_refs()
ProjectsColumnsColumnIdCardsPostResponse503PropErrorsItems.update_forward_refs()
ProjectsColumnsColumnIdMovesPostBody.update_forward_refs()
ProjectsColumnsColumnIdMovesPostResponse201.update_forward_refs()
ProjectsProjectIdDeleteResponse403.update_forward_refs()
ProjectsProjectIdPatchBody.update_forward_refs()
ProjectsProjectIdPatchResponse403.update_forward_refs()
ProjectsProjectIdCollaboratorsUsernamePutBody.update_forward_refs()
ProjectsProjectIdColumnsPostBody.update_forward_refs()
ReposOwnerRepoDeleteResponse403.update_forward_refs()
ReposOwnerRepoPatchBody.update_forward_refs()
ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropAdvancedSecurity.update_forward_refs()
ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanning.update_forward_refs()
ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningPushProtection.update_forward_refs()
ReposOwnerRepoPatchBodyPropSecurityAndAnalysis.update_forward_refs()
ReposOwnerRepoActionsArtifactsGetResponse200.update_forward_refs()
ReposOwnerRepoActionsJobsJobIdRerunPostBody.update_forward_refs()
ReposOwnerRepoActionsOidcCustomizationSubPutBody.update_forward_refs()
ReposOwnerRepoActionsOrganizationSecretsGetResponse200.update_forward_refs()
ReposOwnerRepoActionsOrganizationVariablesGetResponse200.update_forward_refs()
ReposOwnerRepoActionsPermissionsPutBody.update_forward_refs()
ReposOwnerRepoActionsRunnersGetResponse200.update_forward_refs()
ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody.update_forward_refs()
ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody.update_forward_refs()
ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody.update_forward_refs()
ReposOwnerRepoActionsRunsGetResponse200.update_forward_refs()
ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200.update_forward_refs()
ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200.update_forward_refs()
ReposOwnerRepoActionsRunsRunIdJobsGetResponse200.update_forward_refs()
ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody.update_forward_refs()
ReposOwnerRepoActionsRunsRunIdRerunPostBody.update_forward_refs()
ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody.update_forward_refs()
ReposOwnerRepoActionsSecretsGetResponse200.update_forward_refs()
ReposOwnerRepoActionsSecretsSecretNamePutBody.update_forward_refs()
ReposOwnerRepoActionsVariablesGetResponse200.update_forward_refs()
ReposOwnerRepoActionsVariablesPostBody.update_forward_refs()
ReposOwnerRepoActionsVariablesNamePatchBody.update_forward_refs()
ReposOwnerRepoActionsWorkflowsGetResponse200.update_forward_refs()
ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody.update_forward_refs()
ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputs.update_forward_refs()
ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200.update_forward_refs()
ReposOwnerRepoAutolinksPostBody.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionPutBody.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksPropChecksItems.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecks.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropDismissalRestrictions.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropBypassPullRequestAllowances.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviews.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictions.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictions.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowances.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItems.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0.update_forward_refs()
ReposOwnerRepoBranchesBranchRenamePostBody.update_forward_refs()
ReposOwnerRepoCheckRunsPostBodyPropOutput.update_forward_refs()
ReposOwnerRepoCheckRunsPostBodyPropOutputPropAnnotationsItems.update_forward_refs()
ReposOwnerRepoCheckRunsPostBodyPropOutputPropImagesItems.update_forward_refs()
ReposOwnerRepoCheckRunsPostBodyPropActionsItems.update_forward_refs()
ReposOwnerRepoCheckRunsPostBodyOneof0.update_forward_refs()
ReposOwnerRepoCheckRunsPostBodyOneof1.update_forward_refs()
ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutput.update_forward_refs()
ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropAnnotationsItems.update_forward_refs()
ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropImagesItems.update_forward_refs()
ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropActionsItems.update_forward_refs()
ReposOwnerRepoCheckRunsCheckRunIdPatchBodyAnyof0.update_forward_refs()
ReposOwnerRepoCheckRunsCheckRunIdPatchBodyAnyof1.update_forward_refs()
ReposOwnerRepoCheckSuitesPostBody.update_forward_refs()
ReposOwnerRepoCheckSuitesPreferencesPatchBody.update_forward_refs()
ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItems.update_forward_refs()
ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200.update_forward_refs()
ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBody.update_forward_refs()
ReposOwnerRepoCodeScanningSarifsPostBody.update_forward_refs()
ReposOwnerRepoCodespacesGetResponse200.update_forward_refs()
ReposOwnerRepoCodespacesPostBody.update_forward_refs()
ReposOwnerRepoCodespacesDevcontainersGetResponse200.update_forward_refs()
ReposOwnerRepoCodespacesDevcontainersGetResponse200PropDevcontainersItems.update_forward_refs()
ReposOwnerRepoCodespacesMachinesGetResponse200.update_forward_refs()
ReposOwnerRepoCodespacesNewGetResponse200.update_forward_refs()
ReposOwnerRepoCodespacesNewGetResponse200PropDefaults.update_forward_refs()
ReposOwnerRepoCodespacesSecretsGetResponse200.update_forward_refs()
ReposOwnerRepoCodespacesSecretsSecretNamePutBody.update_forward_refs()
ReposOwnerRepoCollaboratorsUsernamePutBody.update_forward_refs()
ReposOwnerRepoCommentsCommentIdPatchBody.update_forward_refs()
ReposOwnerRepoCommentsCommentIdReactionsPostBody.update_forward_refs()
ReposOwnerRepoCommitsCommitShaCommentsPostBody.update_forward_refs()
ReposOwnerRepoCommitsRefCheckRunsGetResponse200.update_forward_refs()
ReposOwnerRepoCommitsRefCheckSuitesGetResponse200.update_forward_refs()
ReposOwnerRepoContentsPathPutBody.update_forward_refs()
ReposOwnerRepoContentsPathPutBodyPropCommitter.update_forward_refs()
ReposOwnerRepoContentsPathPutBodyPropAuthor.update_forward_refs()
ReposOwnerRepoContentsPathDeleteBody.update_forward_refs()
ReposOwnerRepoContentsPathDeleteBodyPropCommitter.update_forward_refs()
ReposOwnerRepoContentsPathDeleteBodyPropAuthor.update_forward_refs()
ReposOwnerRepoDependabotAlertsAlertNumberPatchBody.update_forward_refs()
ReposOwnerRepoDependabotSecretsGetResponse200.update_forward_refs()
ReposOwnerRepoDependabotSecretsSecretNamePutBody.update_forward_refs()
ReposOwnerRepoDependencyGraphSnapshotsPostResponse201.update_forward_refs()
ReposOwnerRepoDeploymentsPostBody.update_forward_refs()
ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0.update_forward_refs()
ReposOwnerRepoDeploymentsPostResponse202.update_forward_refs()
ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody.update_forward_refs()
ReposOwnerRepoDispatchesPostBody.update_forward_refs()
ReposOwnerRepoDispatchesPostBodyPropClientPayload.update_forward_refs()
ReposOwnerRepoEnvironmentsGetResponse200.update_forward_refs()
ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItems.update_forward_refs()
ReposOwnerRepoEnvironmentsEnvironmentNamePutBody.update_forward_refs()
ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200.update_forward_refs()
ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200.update_forward_refs()
ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody.update_forward_refs()
ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200.update_forward_refs()
ReposOwnerRepoForksPostBody.update_forward_refs()
ReposOwnerRepoGitBlobsPostBody.update_forward_refs()
ReposOwnerRepoGitCommitsPostBody.update_forward_refs()
ReposOwnerRepoGitCommitsPostBodyPropAuthor.update_forward_refs()
ReposOwnerRepoGitCommitsPostBodyPropCommitter.update_forward_refs()
ReposOwnerRepoGitRefsPostBody.update_forward_refs()
ReposOwnerRepoGitRefsRefPatchBody.update_forward_refs()
ReposOwnerRepoGitTagsPostBody.update_forward_refs()
ReposOwnerRepoGitTagsPostBodyPropTagger.update_forward_refs()
ReposOwnerRepoGitTreesPostBody.update_forward_refs()
ReposOwnerRepoGitTreesPostBodyPropTreeItems.update_forward_refs()
ReposOwnerRepoHooksPostBodyPropConfig.update_forward_refs()
ReposOwnerRepoHooksPostBody.update_forward_refs()
ReposOwnerRepoHooksHookIdPatchBody.update_forward_refs()
ReposOwnerRepoHooksHookIdPatchBodyPropConfig.update_forward_refs()
ReposOwnerRepoHooksHookIdConfigPatchBody.update_forward_refs()
ReposOwnerRepoImportPutBody.update_forward_refs()
ReposOwnerRepoImportPatchBody.update_forward_refs()
ReposOwnerRepoImportAuthorsAuthorIdPatchBody.update_forward_refs()
ReposOwnerRepoImportLfsPatchBody.update_forward_refs()
ReposOwnerRepoInteractionLimitsGetResponse200Anyof1.update_forward_refs()
ReposOwnerRepoInvitationsInvitationIdPatchBody.update_forward_refs()
ReposOwnerRepoIssuesPostBody.update_forward_refs()
ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1.update_forward_refs()
ReposOwnerRepoIssuesCommentsCommentIdPatchBody.update_forward_refs()
ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberPatchBody.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberAssigneesPostBody.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberCommentsPostBody.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItems.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItems.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberLockPutBody.update_forward_refs()
ReposOwnerRepoIssuesIssueNumberReactionsPostBody.update_forward_refs()
ReposOwnerRepoKeysPostBody.update_forward_refs()
ReposOwnerRepoLabelsPostBody.update_forward_refs()
ReposOwnerRepoLabelsNamePatchBody.update_forward_refs()
ReposOwnerRepoMergeUpstreamPostBody.update_forward_refs()
ReposOwnerRepoMergesPostBody.update_forward_refs()
ReposOwnerRepoMilestonesPostBody.update_forward_refs()
ReposOwnerRepoMilestonesMilestoneNumberPatchBody.update_forward_refs()
ReposOwnerRepoNotificationsPutBody.update_forward_refs()
ReposOwnerRepoNotificationsPutResponse202.update_forward_refs()
ReposOwnerRepoPagesPutBodyPropSourceAnyof1.update_forward_refs()
ReposOwnerRepoPagesPutBodyAnyof0.update_forward_refs()
ReposOwnerRepoPagesPutBodyAnyof1.update_forward_refs()
ReposOwnerRepoPagesPutBodyAnyof2.update_forward_refs()
ReposOwnerRepoPagesPutBodyAnyof3.update_forward_refs()
ReposOwnerRepoPagesPutBodyAnyof4.update_forward_refs()
ReposOwnerRepoPagesPostBodyPropSource.update_forward_refs()
ReposOwnerRepoPagesPostBodyAnyof0.update_forward_refs()
ReposOwnerRepoPagesPostBodyAnyof1.update_forward_refs()
ReposOwnerRepoPagesDeploymentPostBody.update_forward_refs()
ReposOwnerRepoProjectsPostBody.update_forward_refs()
ReposOwnerRepoPullsPostBody.update_forward_refs()
ReposOwnerRepoPullsCommentsCommentIdPatchBody.update_forward_refs()
ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberPatchBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberCodespacesPostBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberCommentsPostBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberMergePutBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberMergePutResponse405.update_forward_refs()
ReposOwnerRepoPullsPullNumberMergePutResponse409.update_forward_refs()
ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0.update_forward_refs()
ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1.update_forward_refs()
ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberReviewsPostBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItems.update_forward_refs()
ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberUpdateBranchPutBody.update_forward_refs()
ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202.update_forward_refs()
ReposOwnerRepoReleasesPostBody.update_forward_refs()
ReposOwnerRepoReleasesAssetsAssetIdPatchBody.update_forward_refs()
ReposOwnerRepoReleasesGenerateNotesPostBody.update_forward_refs()
ReposOwnerRepoReleasesReleaseIdPatchBody.update_forward_refs()
ReposOwnerRepoReleasesReleaseIdReactionsPostBody.update_forward_refs()
ReposOwnerRepoRulesetsPostBody.update_forward_refs()
ReposOwnerRepoRulesetsRulesetIdPutBody.update_forward_refs()
ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBody.update_forward_refs()
ReposOwnerRepoStatusesShaPostBody.update_forward_refs()
ReposOwnerRepoSubscriptionPutBody.update_forward_refs()
ReposOwnerRepoTagsProtectionPostBody.update_forward_refs()
ReposOwnerRepoTopicsPutBody.update_forward_refs()
ReposOwnerRepoTransferPostBody.update_forward_refs()
ReposTemplateOwnerTemplateRepoGeneratePostBody.update_forward_refs()
RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200.update_forward_refs()
RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody.update_forward_refs()
RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200.update_forward_refs()
RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody.update_forward_refs()
RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody.update_forward_refs()
SearchCodeGetResponse200.update_forward_refs()
SearchCommitsGetResponse200.update_forward_refs()
SearchIssuesGetResponse200.update_forward_refs()
SearchLabelsGetResponse200.update_forward_refs()
SearchRepositoriesGetResponse200.update_forward_refs()
SearchTopicsGetResponse200.update_forward_refs()
SearchUsersGetResponse200.update_forward_refs()
TeamsTeamIdPatchBody.update_forward_refs()
TeamsTeamIdDiscussionsPostBody.update_forward_refs()
TeamsTeamIdDiscussionsDiscussionNumberPatchBody.update_forward_refs()
TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody.update_forward_refs()
TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody.update_forward_refs()
TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody.update_forward_refs()
TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody.update_forward_refs()
TeamsTeamIdMembershipsUsernamePutBody.update_forward_refs()
TeamsTeamIdProjectsProjectIdPutBody.update_forward_refs()
TeamsTeamIdProjectsProjectIdPutResponse403.update_forward_refs()
TeamsTeamIdReposOwnerRepoPutBody.update_forward_refs()
UserPatchBody.update_forward_refs()
UserCodespacesGetResponse200.update_forward_refs()
UserCodespacesPostBodyOneof0.update_forward_refs()
UserCodespacesPostBodyOneof1.update_forward_refs()
UserCodespacesPostBodyOneof1PropPullRequest.update_forward_refs()
UserCodespacesSecretsGetResponse200.update_forward_refs()
UserCodespacesSecretsSecretNamePutBody.update_forward_refs()
UserCodespacesSecretsSecretNameRepositoriesGetResponse200.update_forward_refs()
UserCodespacesSecretsSecretNameRepositoriesPutBody.update_forward_refs()
UserCodespacesCodespaceNamePatchBody.update_forward_refs()
UserCodespacesCodespaceNameMachinesGetResponse200.update_forward_refs()
UserCodespacesCodespaceNamePublishPostBody.update_forward_refs()
UserEmailVisibilityPatchBody.update_forward_refs()
UserEmailsPostBodyOneof0.update_forward_refs()
UserEmailsDeleteBodyOneof0.update_forward_refs()
UserGpgKeysPostBody.update_forward_refs()
UserInstallationsGetResponse200.update_forward_refs()
UserInstallationsInstallationIdRepositoriesGetResponse200.update_forward_refs()
UserInteractionLimitsGetResponse200Anyof1.update_forward_refs()
UserKeysPostBody.update_forward_refs()
UserMembershipsOrgsOrgPatchBody.update_forward_refs()
UserMigrationsPostBody.update_forward_refs()
UserProjectsPostBody.update_forward_refs()
UserReposPostBody.update_forward_refs()
UserSocialAccountsPostBody.update_forward_refs()
UserSocialAccountsDeleteBody.update_forward_refs()
UserSshSigningKeysPostBody.update_forward_refs()

__all__ = [
    "GitHubRestModel",
    "Root",
    "SimpleUser",
    "GlobalAdvisory",
    "GlobalAdvisoryPropIdentifiersItems",
    "GlobalAdvisoryPropVulnerabilitiesItems",
    "GlobalAdvisoryPropVulnerabilitiesItemsPropPackage",
    "GlobalAdvisoryPropCvss",
    "GlobalAdvisoryPropCwesItems",
    "GlobalAdvisoryPropCreditsItems",
    "BasicError",
    "ValidationErrorSimple",
    "Integration",
    "IntegrationPropPermissions",
    "WebhookConfig",
    "HookDeliveryItem",
    "ScimError",
    "ValidationError",
    "ValidationErrorPropErrorsItems",
    "HookDelivery",
    "HookDeliveryPropRequest",
    "HookDeliveryPropRequestPropHeaders",
    "HookDeliveryPropRequestPropPayload",
    "HookDeliveryPropResponse",
    "HookDeliveryPropResponsePropHeaders",
    "Enterprise",
    "IntegrationInstallationRequest",
    "AppPermissions",
    "Installation",
    "LicenseSimple",
    "Repository",
    "RepositoryPropPermissions",
    "RepositoryPropTemplateRepositoryPropOwner",
    "RepositoryPropTemplateRepositoryPropPermissions",
    "RepositoryPropTemplateRepository",
    "InstallationToken",
    "ScopedInstallation",
    "Authorization",
    "AuthorizationPropApp",
    "SimpleClassroomRepository",
    "SimpleClassroomOrganization",
    "Classroom",
    "ClassroomAssignment",
    "SimpleClassroomUser",
    "SimpleClassroom",
    "SimpleClassroomAssignment",
    "ClassroomAcceptedAssignment",
    "ClassroomAssignmentGrade",
    "CodeOfConduct",
    "DependabotAlertPackage",
    "DependabotAlertSecurityVulnerability",
    "DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion",
    "DependabotAlertSecurityAdvisory",
    "DependabotAlertSecurityAdvisoryPropCvss",
    "DependabotAlertSecurityAdvisoryPropCwesItems",
    "DependabotAlertSecurityAdvisoryPropIdentifiersItems",
    "DependabotAlertSecurityAdvisoryPropReferencesItems",
    "SimpleRepository",
    "DependabotAlertWithRepository",
    "DependabotAlertWithRepositoryPropDependency",
    "OrganizationSecretScanningAlert",
    "Actor",
    "Milestone",
    "ReactionRollup",
    "Issue",
    "IssuePropLabelsItemsOneof1",
    "IssuePropPullRequest",
    "IssueComment",
    "Event",
    "EventPropRepo",
    "EventPropPayload",
    "EventPropPayloadPropPagesItems",
    "LinkWithType",
    "Feed",
    "FeedPropLinks",
    "BaseGist",
    "BaseGistPropFiles",
    "PublicUser",
    "PublicUserPropPlan",
    "GistHistory",
    "GistHistoryPropChangeStatus",
    "GistSimple",
    "GistSimplePropForksItems",
    "GistSimplePropForkOfPropFiles",
    "GistSimplePropForkOf",
    "GistSimplePropFiles",
    "GistComment",
    "GistCommit",
    "GistCommitPropChangeStatus",
    "GitignoreTemplate",
    "License",
    "MarketplaceListingPlan",
    "MarketplacePurchase",
    "MarketplacePurchasePropMarketplacePendingChange",
    "MarketplacePurchasePropMarketplacePurchase",
    "ApiOverview",
    "ApiOverviewPropSshKeyFingerprints",
    "ApiOverviewPropDomains",
    "SecurityAndAnalysisPropAdvancedSecurity",
    "SecurityAndAnalysisPropDependabotSecurityUpdates",
    "SecurityAndAnalysisPropSecretScanning",
    "SecurityAndAnalysisPropSecretScanningPushProtection",
    "SecurityAndAnalysis",
    "MinimalRepository",
    "MinimalRepositoryPropPermissions",
    "MinimalRepositoryPropLicense",
    "Thread",
    "ThreadPropSubject",
    "ThreadSubscription",
    "OrganizationSimple",
    "OrganizationFull",
    "OrganizationFullPropPlan",
    "ActionsCacheUsageOrgEnterprise",
    "ActionsCacheUsageByRepository",
    "OidcCustomSub",
    "EmptyObject",
    "ActionsOrganizationPermissions",
    "SelectedActions",
    "ActionsGetDefaultWorkflowPermissions",
    "ActionsSetDefaultWorkflowPermissions",
    "RunnerLabel",
    "Runner",
    "RunnerApplication",
    "AuthenticationToken",
    "AuthenticationTokenPropPermissions",
    "OrganizationActionsSecret",
    "ActionsPublicKey",
    "OrganizationActionsVariable",
    "CodeScanningAlertRule",
    "CodeScanningAnalysisTool",
    "CodeScanningAlertLocation",
    "CodeScanningAlertInstance",
    "CodeScanningAlertInstancePropMessage",
    "CodeScanningOrganizationAlertItems",
    "CodespaceMachine",
    "Codespace",
    "CodespacePropGitStatus",
    "CodespacePropRuntimeConstraints",
    "CodespacesOrgSecret",
    "CodespacesPublicKey",
    "CopilotSeatBreakdown",
    "CopilotOrganizationDetails",
    "TeamSimple",
    "Team",
    "TeamPropPermissions",
    "Organization",
    "OrganizationPropPlan",
    "CopilotSeatDetails",
    "OrganizationDependabotSecret",
    "DependabotPublicKey",
    "Package",
    "OrganizationInvitation",
    "OrgHook",
    "OrgHookPropConfig",
    "InteractionLimitResponse",
    "InteractionLimit",
    "OrgMembership",
    "OrgMembershipPropPermissions",
    "Migration",
    "PackageVersion",
    "PackageVersionPropMetadata",
    "PackageVersionPropMetadataPropContainer",
    "PackageVersionPropMetadataPropDocker",
    "OrganizationProgrammaticAccessGrantRequest",
    "OrganizationProgrammaticAccessGrantRequestPropPermissions",
    "OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganization",
    "OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepository",
    "OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOther",
    "OrganizationProgrammaticAccessGrant",
    "OrganizationProgrammaticAccessGrantPropPermissions",
    "OrganizationProgrammaticAccessGrantPropPermissionsPropOrganization",
    "OrganizationProgrammaticAccessGrantPropPermissionsPropRepository",
    "OrganizationProgrammaticAccessGrantPropPermissionsPropOther",
    "Project",
    "RepositoryRulesetBypassActor",
    "RepositoryRulesetConditions",
    "RepositoryRulesetConditionsPropRefName",
    "RepositoryRulesetConditionsRepositoryNameTarget",
    "RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName",
    "RepositoryRulesetConditionsRepositoryIdTarget",
    "RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId",
    "OrgRulesetConditionsOneof0",
    "OrgRulesetConditionsOneof1",
    "RepositoryRuleCreation",
    "RepositoryRuleUpdate",
    "RepositoryRuleUpdatePropParameters",
    "RepositoryRuleDeletion",
    "RepositoryRuleRequiredLinearHistory",
    "RepositoryRuleRequiredDeployments",
    "RepositoryRuleRequiredDeploymentsPropParameters",
    "RepositoryRuleRequiredSignatures",
    "RepositoryRulePullRequest",
    "RepositoryRulePullRequestPropParameters",
    "RepositoryRuleParamsStatusCheckConfiguration",
    "RepositoryRuleRequiredStatusChecks",
    "RepositoryRuleRequiredStatusChecksPropParameters",
    "RepositoryRuleNonFastForward",
    "RepositoryRuleCommitMessagePattern",
    "RepositoryRuleCommitMessagePatternPropParameters",
    "RepositoryRuleCommitAuthorEmailPattern",
    "RepositoryRuleCommitAuthorEmailPatternPropParameters",
    "RepositoryRuleCommitterEmailPattern",
    "RepositoryRuleCommitterEmailPatternPropParameters",
    "RepositoryRuleBranchNamePattern",
    "RepositoryRuleBranchNamePatternPropParameters",
    "RepositoryRuleTagNamePattern",
    "RepositoryRuleTagNamePatternPropParameters",
    "RepositoryRuleset",
    "RepositoryRulesetPropLinks",
    "RepositoryRulesetPropLinksPropSelf",
    "RepositoryRulesetPropLinksPropHtml",
    "RepositoryAdvisoryVulnerability",
    "RepositoryAdvisoryVulnerabilityPropPackage",
    "RepositoryAdvisoryCredit",
    "RepositoryAdvisory",
    "RepositoryAdvisoryPropIdentifiersItems",
    "RepositoryAdvisoryPropSubmission",
    "RepositoryAdvisoryPropCvss",
    "RepositoryAdvisoryPropCwesItems",
    "RepositoryAdvisoryPropCreditsItems",
    "ActionsBillingUsage",
    "ActionsBillingUsagePropMinutesUsedBreakdown",
    "PackagesBillingUsage",
    "CombinedBillingUsage",
    "TeamOrganization",
    "TeamOrganizationPropPlan",
    "TeamFull",
    "TeamDiscussion",
    "TeamDiscussionComment",
    "Reaction",
    "TeamMembership",
    "TeamProject",
    "TeamProjectPropPermissions",
    "TeamRepository",
    "TeamRepositoryPropPermissions",
    "ProjectCard",
    "ProjectColumn",
    "ProjectCollaboratorPermission",
    "RateLimit",
    "RateLimitOverview",
    "RateLimitOverviewPropResources",
    "CodeOfConductSimple",
    "FullRepository",
    "FullRepositoryPropPermissions",
    "Artifact",
    "ArtifactPropWorkflowRun",
    "ActionsCacheList",
    "ActionsCacheListPropActionsCachesItems",
    "Job",
    "JobPropStepsItems",
    "OidcCustomSubRepo",
    "ActionsSecret",
    "ActionsVariable",
    "ActionsRepositoryPermissions",
    "ActionsWorkflowAccessToRepository",
    "ReferencedWorkflow",
    "PullRequestMinimal",
    "PullRequestMinimalPropHead",
    "PullRequestMinimalPropHeadPropRepo",
    "PullRequestMinimalPropBase",
    "PullRequestMinimalPropBasePropRepo",
    "SimpleCommit",
    "SimpleCommitPropAuthor",
    "SimpleCommitPropCommitter",
    "WorkflowRun",
    "EnvironmentApprovals",
    "EnvironmentApprovalsPropEnvironmentsItems",
    "ReviewCustomGatesCommentRequired",
    "ReviewCustomGatesStateRequired",
    "PendingDeployment",
    "PendingDeploymentPropEnvironment",
    "PendingDeploymentPropReviewersItems",
    "Deployment",
    "DeploymentPropPayloadOneof0",
    "WorkflowRunUsage",
    "WorkflowRunUsagePropBillable",
    "WorkflowRunUsagePropBillablePropUbuntu",
    "WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems",
    "WorkflowRunUsagePropBillablePropMacos",
    "WorkflowRunUsagePropBillablePropMacosPropJobRunsItems",
    "WorkflowRunUsagePropBillablePropWindows",
    "WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems",
    "Workflow",
    "WorkflowUsage",
    "WorkflowUsagePropBillable",
    "WorkflowUsagePropBillablePropUbuntu",
    "WorkflowUsagePropBillablePropMacos",
    "WorkflowUsagePropBillablePropWindows",
    "Activity",
    "Autolink",
    "CheckAutomatedSecurityFixes",
    "ProtectedBranchRequiredStatusCheck",
    "ProtectedBranchRequiredStatusCheckPropChecksItems",
    "ProtectedBranchAdminEnforced",
    "ProtectedBranchPullRequestReview",
    "ProtectedBranchPullRequestReviewPropDismissalRestrictions",
    "ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances",
    "BranchRestrictionPolicy",
    "BranchRestrictionPolicyPropUsersItems",
    "BranchRestrictionPolicyPropTeamsItems",
    "BranchRestrictionPolicyPropAppsItems",
    "BranchRestrictionPolicyPropAppsItemsPropOwner",
    "BranchRestrictionPolicyPropAppsItemsPropPermissions",
    "BranchProtection",
    "BranchProtectionPropRequiredLinearHistory",
    "BranchProtectionPropAllowForcePushes",
    "BranchProtectionPropAllowDeletions",
    "BranchProtectionPropBlockCreations",
    "BranchProtectionPropRequiredConversationResolution",
    "BranchProtectionPropRequiredSignatures",
    "BranchProtectionPropLockBranch",
    "BranchProtectionPropAllowForkSyncing",
    "ShortBranch",
    "ShortBranchPropCommit",
    "GitUser",
    "Verification",
    "DiffEntry",
    "Commit",
    "CommitPropCommit",
    "CommitPropCommitPropTree",
    "CommitPropParentsItems",
    "CommitPropStats",
    "BranchWithProtection",
    "BranchWithProtectionPropLinks",
    "StatusCheckPolicy",
    "StatusCheckPolicyPropChecksItems",
    "ProtectedBranch",
    "ProtectedBranchPropRequiredPullRequestReviews",
    "ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions",
    "ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances",
    "ProtectedBranchPropRequiredSignatures",
    "ProtectedBranchPropEnforceAdmins",
    "ProtectedBranchPropRequiredLinearHistory",
    "ProtectedBranchPropAllowForcePushes",
    "ProtectedBranchPropAllowDeletions",
    "ProtectedBranchPropRequiredConversationResolution",
    "ProtectedBranchPropBlockCreations",
    "ProtectedBranchPropLockBranch",
    "ProtectedBranchPropAllowForkSyncing",
    "DeploymentSimple",
    "CheckRun",
    "CheckRunPropOutput",
    "CheckRunPropCheckSuite",
    "CheckAnnotation",
    "CheckSuite",
    "CheckSuitePreference",
    "CheckSuitePreferencePropPreferences",
    "CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems",
    "CodeScanningAlertRuleSummary",
    "CodeScanningAlertItems",
    "CodeScanningAlert",
    "CodeScanningAnalysis",
    "CodeScanningAnalysisDeletion",
    "CodeScanningCodeqlDatabase",
    "CodeScanningDefaultSetup",
    "CodeScanningDefaultSetupUpdate",
    "CodeScanningDefaultSetupUpdateResponse",
    "CodeScanningSarifsReceipt",
    "CodeScanningSarifsStatus",
    "CodeownersErrors",
    "CodeownersErrorsPropErrorsItems",
    "RepoCodespacesSecret",
    "Collaborator",
    "CollaboratorPropPermissions",
    "RepositoryInvitation",
    "RepositoryCollaboratorPermission",
    "CommitComment",
    "BranchShort",
    "BranchShortPropCommit",
    "Link",
    "AutoMerge",
    "PullRequestSimple",
    "PullRequestSimplePropLabelsItems",
    "PullRequestSimplePropHead",
    "PullRequestSimplePropBase",
    "PullRequestSimplePropLinks",
    "SimpleCommitStatus",
    "CombinedCommitStatus",
    "Status",
    "CommunityHealthFile",
    "CommunityProfile",
    "CommunityProfilePropFiles",
    "CommitComparison",
    "ContentTree",
    "ContentTreePropEntriesItems",
    "ContentTreePropEntriesItemsPropLinks",
    "ContentTreePropLinks",
    "ContentDirectoryItems",
    "ContentDirectoryItemsPropLinks",
    "ContentFile",
    "ContentFilePropLinks",
    "ContentSymlink",
    "ContentSymlinkPropLinks",
    "ContentSubmodule",
    "ContentSubmodulePropLinks",
    "FileCommit",
    "FileCommitPropContentPropLinks",
    "FileCommitPropContent",
    "FileCommitPropCommit",
    "FileCommitPropCommitPropAuthor",
    "FileCommitPropCommitPropCommitter",
    "FileCommitPropCommitPropTree",
    "FileCommitPropCommitPropParentsItems",
    "FileCommitPropCommitPropVerification",
    "Contributor",
    "DependabotAlert",
    "DependabotAlertPropDependency",
    "DependabotSecret",
    "DependencyGraphDiffItems",
    "DependencyGraphDiffItemsPropVulnerabilitiesItems",
    "DependencyGraphSpdxSbom",
    "DependencyGraphSpdxSbomPropSbom",
    "DependencyGraphSpdxSbomPropSbomPropCreationInfo",
    "DependencyGraphSpdxSbomPropSbomPropPackagesItems",
    "DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItems",
    "Metadata",
    "Dependency",
    "Manifest",
    "ManifestPropFile",
    "ManifestPropResolved",
    "Snapshot",
    "SnapshotPropJob",
    "SnapshotPropDetector",
    "SnapshotPropManifests",
    "DeploymentStatus",
    "DeploymentBranchPolicySettings",
    "Environment",
    "EnvironmentPropProtectionRulesItemsAnyof0",
    "EnvironmentPropProtectionRulesItemsAnyof1",
    "EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems",
    "EnvironmentPropProtectionRulesItemsAnyof2",
    "DeploymentBranchPolicy",
    "DeploymentBranchPolicyNamePattern",
    "CustomDeploymentRuleApp",
    "DeploymentProtectionRule",
    "ShortBlob",
    "Blob",
    "GitCommit",
    "GitCommitPropAuthor",
    "GitCommitPropCommitter",
    "GitCommitPropTree",
    "GitCommitPropParentsItems",
    "GitCommitPropVerification",
    "GitRef",
    "GitRefPropObject",
    "GitTag",
    "GitTagPropTagger",
    "GitTagPropObject",
    "GitTree",
    "GitTreePropTreeItems",
    "HookResponse",
    "Hook",
    "HookPropConfig",
    "Import",
    "ImportPropProjectChoicesItems",
    "PorterAuthor",
    "PorterLargeFile",
    "IssueEventLabel",
    "IssueEventDismissedReview",
    "IssueEventMilestone",
    "IssueEventProjectCard",
    "IssueEventRename",
    "IssueEvent",
    "LabeledIssueEvent",
    "LabeledIssueEventPropLabel",
    "UnlabeledIssueEvent",
    "UnlabeledIssueEventPropLabel",
    "AssignedIssueEvent",
    "UnassignedIssueEvent",
    "MilestonedIssueEvent",
    "MilestonedIssueEventPropMilestone",
    "DemilestonedIssueEvent",
    "DemilestonedIssueEventPropMilestone",
    "RenamedIssueEvent",
    "RenamedIssueEventPropRename",
    "ReviewRequestedIssueEvent",
    "ReviewRequestRemovedIssueEvent",
    "ReviewDismissedIssueEvent",
    "ReviewDismissedIssueEventPropDismissedReview",
    "LockedIssueEvent",
    "AddedToProjectIssueEvent",
    "AddedToProjectIssueEventPropProjectCard",
    "MovedColumnInProjectIssueEvent",
    "MovedColumnInProjectIssueEventPropProjectCard",
    "RemovedFromProjectIssueEvent",
    "RemovedFromProjectIssueEventPropProjectCard",
    "ConvertedNoteToIssueIssueEvent",
    "ConvertedNoteToIssueIssueEventPropProjectCard",
    "Label",
    "TimelineCommentEvent",
    "TimelineCrossReferencedEvent",
    "TimelineCrossReferencedEventPropSource",
    "TimelineCommittedEvent",
    "TimelineCommittedEventPropAuthor",
    "TimelineCommittedEventPropCommitter",
    "TimelineCommittedEventPropTree",
    "TimelineCommittedEventPropParentsItems",
    "TimelineCommittedEventPropVerification",
    "TimelineReviewedEvent",
    "TimelineReviewedEventPropLinks",
    "TimelineReviewedEventPropLinksPropHtml",
    "TimelineReviewedEventPropLinksPropPullRequest",
    "PullRequestReviewComment",
    "PullRequestReviewCommentPropLinks",
    "PullRequestReviewCommentPropLinksPropSelf",
    "PullRequestReviewCommentPropLinksPropHtml",
    "PullRequestReviewCommentPropLinksPropPullRequest",
    "TimelineLineCommentedEvent",
    "TimelineCommitCommentedEvent",
    "TimelineAssignedIssueEvent",
    "TimelineUnassignedIssueEvent",
    "StateChangeIssueEvent",
    "DeployKey",
    "Language",
    "LicenseContent",
    "LicenseContentPropLinks",
    "MergedUpstream",
    "PagesSourceHash",
    "PagesHttpsCertificate",
    "Page",
    "PageBuild",
    "PageBuildPropError",
    "PageBuildStatus",
    "PageDeployment",
    "PagesHealthCheck",
    "PagesHealthCheckPropDomain",
    "PagesHealthCheckPropAltDomain",
    "PullRequest",
    "PullRequestPropLabelsItems",
    "PullRequestPropHead",
    "PullRequestPropHeadPropRepoPropOwner",
    "PullRequestPropHeadPropRepoPropPermissions",
    "PullRequestPropHeadPropRepoPropLicense",
    "PullRequestPropHeadPropRepo",
    "PullRequestPropHeadPropUser",
    "PullRequestPropBase",
    "PullRequestPropBasePropRepo",
    "PullRequestPropBasePropRepoPropOwner",
    "PullRequestPropBasePropRepoPropPermissions",
    "PullRequestPropBasePropUser",
    "PullRequestPropLinks",
    "PullRequestMergeResult",
    "PullRequestReviewRequest",
    "PullRequestReview",
    "PullRequestReviewPropLinks",
    "PullRequestReviewPropLinksPropHtml",
    "PullRequestReviewPropLinksPropPullRequest",
    "ReviewComment",
    "ReviewCommentPropLinks",
    "ReleaseAsset",
    "Release",
    "ReleaseNotesContent",
    "RepositoryRuleRulesetInfo",
    "RepositoryRuleDetailedOneof0",
    "RepositoryRuleDetailedOneof1",
    "RepositoryRuleDetailedOneof2",
    "RepositoryRuleDetailedOneof3",
    "RepositoryRuleDetailedOneof4",
    "RepositoryRuleDetailedOneof5",
    "RepositoryRuleDetailedOneof6",
    "RepositoryRuleDetailedOneof7",
    "RepositoryRuleDetailedOneof8",
    "RepositoryRuleDetailedOneof9",
    "RepositoryRuleDetailedOneof10",
    "RepositoryRuleDetailedOneof11",
    "RepositoryRuleDetailedOneof12",
    "RepositoryRuleDetailedOneof13",
    "SecretScanningAlert",
    "SecretScanningLocationCommit",
    "SecretScanningLocationIssueTitle",
    "SecretScanningLocationIssueBody",
    "SecretScanningLocationIssueComment",
    "SecretScanningLocation",
    "RepositoryAdvisoryCreate",
    "RepositoryAdvisoryCreatePropVulnerabilitiesItems",
    "RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackage",
    "RepositoryAdvisoryCreatePropCreditsItems",
    "PrivateVulnerabilityReportCreate",
    "PrivateVulnerabilityReportCreatePropVulnerabilitiesItems",
    "PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackage",
    "RepositoryAdvisoryUpdate",
    "RepositoryAdvisoryUpdatePropVulnerabilitiesItems",
    "RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackage",
    "RepositoryAdvisoryUpdatePropCreditsItems",
    "Stargazer",
    "CommitActivity",
    "ContributorActivity",
    "ContributorActivityPropWeeksItems",
    "ParticipationStats",
    "RepositorySubscription",
    "Tag",
    "TagPropCommit",
    "TagProtection",
    "Topic",
    "Traffic",
    "CloneTraffic",
    "ContentTraffic",
    "ReferrerTraffic",
    "ViewTraffic",
    "SearchResultTextMatchesItems",
    "SearchResultTextMatchesItemsPropMatchesItems",
    "CodeSearchResultItem",
    "CommitSearchResultItem",
    "CommitSearchResultItemPropCommit",
    "CommitSearchResultItemPropCommitPropAuthor",
    "CommitSearchResultItemPropCommitPropTree",
    "CommitSearchResultItemPropParentsItems",
    "IssueSearchResultItem",
    "IssueSearchResultItemPropLabelsItems",
    "IssueSearchResultItemPropPullRequest",
    "LabelSearchResultItem",
    "RepoSearchResultItem",
    "RepoSearchResultItemPropPermissions",
    "TopicSearchResultItem",
    "TopicSearchResultItemPropRelatedItems",
    "TopicSearchResultItemPropRelatedItemsPropTopicRelation",
    "TopicSearchResultItemPropAliasesItems",
    "TopicSearchResultItemPropAliasesItemsPropTopicRelation",
    "UserSearchResultItem",
    "PrivateUser",
    "PrivateUserPropPlan",
    "CodespacesSecret",
    "CodespacesUserPublicKey",
    "CodespaceExportDetails",
    "CodespaceWithFullRepository",
    "CodespaceWithFullRepositoryPropGitStatus",
    "CodespaceWithFullRepositoryPropRuntimeConstraints",
    "Email",
    "GpgKey",
    "GpgKeyPropEmailsItems",
    "GpgKeyPropSubkeysItems",
    "GpgKeyPropSubkeysItemsPropEmailsItems",
    "Key",
    "MarketplaceAccount",
    "UserMarketplacePurchase",
    "SocialAccount",
    "SshSigningKey",
    "StarredRepository",
    "Hovercard",
    "HovercardPropContextsItems",
    "KeySimple",
    "SimpleInstallation",
    "OrganizationSimpleWebhooks",
    "RepositoryWebhooks",
    "RepositoryWebhooksPropPermissions",
    "RepositoryWebhooksPropTemplateRepositoryPropOwner",
    "RepositoryWebhooksPropTemplateRepositoryPropPermissions",
    "RepositoryWebhooksPropTemplateRepository",
    "SimpleUserWebhooks",
    "SimpleCheckSuite",
    "CheckRunWithSimpleCheckSuite",
    "CheckRunWithSimpleCheckSuitePropOutput",
    "Discussion",
    "DiscussionPropAnswerChosenBy",
    "DiscussionPropCategory",
    "DiscussionPropReactions",
    "DiscussionPropUser",
    "MergeGroup",
    "PersonalAccessTokenRequest",
    "PersonalAccessTokenRequestPropPermissionsAdded",
    "PersonalAccessTokenRequestPropPermissionsAddedPropOrganization",
    "PersonalAccessTokenRequestPropPermissionsAddedPropRepository",
    "PersonalAccessTokenRequestPropPermissionsAddedPropOther",
    "PersonalAccessTokenRequestPropPermissionsUpgraded",
    "PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganization",
    "PersonalAccessTokenRequestPropPermissionsUpgradedPropRepository",
    "PersonalAccessTokenRequestPropPermissionsUpgradedPropOther",
    "PersonalAccessTokenRequestPropPermissionsResult",
    "PersonalAccessTokenRequestPropPermissionsResultPropOrganization",
    "PersonalAccessTokenRequestPropPermissionsResultPropRepository",
    "PersonalAccessTokenRequestPropPermissionsResultPropOther",
    "PersonalAccessTokenRequestPropRepositoriesItems",
    "ProjectsV2",
    "ProjectsV2Item",
    "SecretScanningAlertWebhook",
    "AppManifestsCodeConversionsPostResponse201",
    "AppManifestsCodeConversionsPostResponse201Allof1",
    "AppHookConfigPatchBody",
    "AppHookDeliveriesDeliveryIdAttemptsPostResponse202",
    "AppInstallationsInstallationIdAccessTokensPostBody",
    "ApplicationsClientIdGrantDeleteBody",
    "ApplicationsClientIdTokenPostBody",
    "ApplicationsClientIdTokenDeleteBody",
    "ApplicationsClientIdTokenPatchBody",
    "ApplicationsClientIdTokenScopedPostBody",
    "EmojisGetResponse200",
    "EnterprisesEnterpriseSecretScanningAlertsGetResponse503",
    "GistsPostBody",
    "GistsPostBodyPropFiles",
    "GistsGistIdGetResponse403",
    "GistsGistIdGetResponse403PropBlock",
    "GistsGistIdPatchBodyPropFiles",
    "GistsGistIdPatchBody",
    "GistsGistIdCommentsPostBody",
    "GistsGistIdCommentsCommentIdPatchBody",
    "GistsGistIdStarGetResponse404",
    "InstallationRepositoriesGetResponse200",
    "MarkdownPostBody",
    "NotificationsPutBody",
    "NotificationsPutResponse202",
    "NotificationsThreadsThreadIdSubscriptionPutBody",
    "OrgsOrgPatchBody",
    "OrgsOrgActionsCacheUsageByRepositoryGetResponse200",
    "OrgsOrgActionsPermissionsPutBody",
    "OrgsOrgActionsPermissionsRepositoriesGetResponse200",
    "OrgsOrgActionsPermissionsRepositoriesPutBody",
    "OrgsOrgActionsRunnersGetResponse200",
    "OrgsOrgActionsRunnersGenerateJitconfigPostBody",
    "OrgsOrgActionsRunnersGenerateJitconfigPostResponse201",
    "OrgsOrgActionsRunnersRunnerIdLabelsGetResponse200",
    "OrgsOrgActionsRunnersRunnerIdLabelsPutBody",
    "OrgsOrgActionsRunnersRunnerIdLabelsPostBody",
    "OrgsOrgActionsRunnersRunnerIdLabelsDeleteResponse200",
    "OrgsOrgActionsSecretsGetResponse200",
    "OrgsOrgActionsSecretsSecretNamePutBody",
    "OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200",
    "OrgsOrgActionsSecretsSecretNameRepositoriesPutBody",
    "OrgsOrgActionsVariablesGetResponse200",
    "OrgsOrgActionsVariablesPostBody",
    "OrgsOrgActionsVariablesNamePatchBody",
    "OrgsOrgActionsVariablesNameRepositoriesGetResponse200",
    "OrgsOrgActionsVariablesNameRepositoriesPutBody",
    "OrgsOrgCodespacesGetResponse200",
    "OrgsOrgCodespacesAccessPutBody",
    "OrgsOrgCodespacesAccessSelectedUsersPostBody",
    "OrgsOrgCodespacesAccessSelectedUsersDeleteBody",
    "OrgsOrgCodespacesSecretsGetResponse200",
    "OrgsOrgCodespacesSecretsSecretNamePutBody",
    "OrgsOrgCodespacesSecretsSecretNameRepositoriesGetResponse200",
    "OrgsOrgCodespacesSecretsSecretNameRepositoriesPutBody",
    "OrgsOrgCopilotBillingSeatsGetResponse200",
    "OrgsOrgCopilotBillingSelectedTeamsPostBody",
    "OrgsOrgCopilotBillingSelectedTeamsPostResponse201",
    "OrgsOrgCopilotBillingSelectedTeamsDeleteBody",
    "OrgsOrgCopilotBillingSelectedTeamsDeleteResponse200",
    "OrgsOrgCopilotBillingSelectedUsersPostBody",
    "OrgsOrgCopilotBillingSelectedUsersPostResponse201",
    "OrgsOrgCopilotBillingSelectedUsersDeleteBody",
    "OrgsOrgCopilotBillingSelectedUsersDeleteResponse200",
    "OrgsOrgDependabotSecretsGetResponse200",
    "OrgsOrgDependabotSecretsSecretNamePutBody",
    "OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200",
    "OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody",
    "OrgsOrgHooksPostBody",
    "OrgsOrgHooksPostBodyPropConfig",
    "OrgsOrgHooksHookIdPatchBody",
    "OrgsOrgHooksHookIdPatchBodyPropConfig",
    "OrgsOrgHooksHookIdConfigPatchBody",
    "OrgsOrgInstallationsGetResponse200",
    "OrgsOrgInteractionLimitsGetResponse200Anyof1",
    "OrgsOrgInvitationsPostBody",
    "OrgsOrgMembersUsernameCodespacesGetResponse200",
    "OrgsOrgMembershipsUsernamePutBody",
    "OrgsOrgMigrationsPostBody",
    "OrgsOrgOutsideCollaboratorsUsernamePutBody",
    "OrgsOrgOutsideCollaboratorsUsernamePutResponse202",
    "OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422",
    "OrgsOrgPersonalAccessTokenRequestsPostBody",
    "OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody",
    "OrgsOrgPersonalAccessTokensPostBody",
    "OrgsOrgPersonalAccessTokensPatIdPostBody",
    "OrgsOrgProjectsPostBody",
    "OrgsOrgReposPostBody",
    "OrgsOrgRulesetsPostBody",
    "OrgsOrgRulesetsRulesetIdPutBody",
    "OrgsOrgTeamsPostBody",
    "OrgsOrgTeamsTeamSlugPatchBody",
    "OrgsOrgTeamsTeamSlugDiscussionsPostBody",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody",
    "OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody",
    "OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody",
    "OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody",
    "OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403",
    "OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody",
    "OrgsOrgSecurityProductEnablementPostBody",
    "ProjectsColumnsCardsCardIdDeleteResponse403",
    "ProjectsColumnsCardsCardIdPatchBody",
    "ProjectsColumnsCardsCardIdMovesPostBody",
    "ProjectsColumnsCardsCardIdMovesPostResponse201",
    "ProjectsColumnsCardsCardIdMovesPostResponse403",
    "ProjectsColumnsCardsCardIdMovesPostResponse403PropErrorsItems",
    "ProjectsColumnsCardsCardIdMovesPostResponse503",
    "ProjectsColumnsCardsCardIdMovesPostResponse503PropErrorsItems",
    "ProjectsColumnsColumnIdPatchBody",
    "ProjectsColumnsColumnIdCardsPostBodyOneof0",
    "ProjectsColumnsColumnIdCardsPostBodyOneof1",
    "ProjectsColumnsColumnIdCardsPostResponse503",
    "ProjectsColumnsColumnIdCardsPostResponse503PropErrorsItems",
    "ProjectsColumnsColumnIdMovesPostBody",
    "ProjectsColumnsColumnIdMovesPostResponse201",
    "ProjectsProjectIdDeleteResponse403",
    "ProjectsProjectIdPatchBody",
    "ProjectsProjectIdPatchResponse403",
    "ProjectsProjectIdCollaboratorsUsernamePutBody",
    "ProjectsProjectIdColumnsPostBody",
    "ReposOwnerRepoDeleteResponse403",
    "ReposOwnerRepoPatchBody",
    "ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropAdvancedSecurity",
    "ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanning",
    "ReposOwnerRepoPatchBodyPropSecurityAndAnalysisPropSecretScanningPushProtection",
    "ReposOwnerRepoPatchBodyPropSecurityAndAnalysis",
    "ReposOwnerRepoActionsArtifactsGetResponse200",
    "ReposOwnerRepoActionsJobsJobIdRerunPostBody",
    "ReposOwnerRepoActionsOidcCustomizationSubPutBody",
    "ReposOwnerRepoActionsOrganizationSecretsGetResponse200",
    "ReposOwnerRepoActionsOrganizationVariablesGetResponse200",
    "ReposOwnerRepoActionsPermissionsPutBody",
    "ReposOwnerRepoActionsRunnersGetResponse200",
    "ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody",
    "ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody",
    "ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody",
    "ReposOwnerRepoActionsRunsGetResponse200",
    "ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200",
    "ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200",
    "ReposOwnerRepoActionsRunsRunIdJobsGetResponse200",
    "ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody",
    "ReposOwnerRepoActionsRunsRunIdRerunPostBody",
    "ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody",
    "ReposOwnerRepoActionsSecretsGetResponse200",
    "ReposOwnerRepoActionsSecretsSecretNamePutBody",
    "ReposOwnerRepoActionsVariablesGetResponse200",
    "ReposOwnerRepoActionsVariablesPostBody",
    "ReposOwnerRepoActionsVariablesNamePatchBody",
    "ReposOwnerRepoActionsWorkflowsGetResponse200",
    "ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody",
    "ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputs",
    "ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200",
    "ReposOwnerRepoAutolinksPostBody",
    "ReposOwnerRepoBranchesBranchProtectionPutBody",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksPropChecksItems",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecks",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropDismissalRestrictions",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsPropBypassPullRequestAllowances",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviews",
    "ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictions",
    "ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody",
    "ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictions",
    "ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowances",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItems",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0",
    "ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0",
    "ReposOwnerRepoBranchesBranchRenamePostBody",
    "ReposOwnerRepoCheckRunsPostBodyPropOutput",
    "ReposOwnerRepoCheckRunsPostBodyPropOutputPropAnnotationsItems",
    "ReposOwnerRepoCheckRunsPostBodyPropOutputPropImagesItems",
    "ReposOwnerRepoCheckRunsPostBodyPropActionsItems",
    "ReposOwnerRepoCheckRunsPostBodyOneof0",
    "ReposOwnerRepoCheckRunsPostBodyOneof1",
    "ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutput",
    "ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropAnnotationsItems",
    "ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropOutputPropImagesItems",
    "ReposOwnerRepoCheckRunsCheckRunIdPatchBodyPropActionsItems",
    "ReposOwnerRepoCheckRunsCheckRunIdPatchBodyAnyof0",
    "ReposOwnerRepoCheckRunsCheckRunIdPatchBodyAnyof1",
    "ReposOwnerRepoCheckSuitesPostBody",
    "ReposOwnerRepoCheckSuitesPreferencesPatchBody",
    "ReposOwnerRepoCheckSuitesPreferencesPatchBodyPropAutoTriggerChecksItems",
    "ReposOwnerRepoCheckSuitesCheckSuiteIdCheckRunsGetResponse200",
    "ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBody",
    "ReposOwnerRepoCodeScanningSarifsPostBody",
    "ReposOwnerRepoCodespacesGetResponse200",
    "ReposOwnerRepoCodespacesPostBody",
    "ReposOwnerRepoCodespacesDevcontainersGetResponse200",
    "ReposOwnerRepoCodespacesDevcontainersGetResponse200PropDevcontainersItems",
    "ReposOwnerRepoCodespacesMachinesGetResponse200",
    "ReposOwnerRepoCodespacesNewGetResponse200",
    "ReposOwnerRepoCodespacesNewGetResponse200PropDefaults",
    "ReposOwnerRepoCodespacesSecretsGetResponse200",
    "ReposOwnerRepoCodespacesSecretsSecretNamePutBody",
    "ReposOwnerRepoCollaboratorsUsernamePutBody",
    "ReposOwnerRepoCommentsCommentIdPatchBody",
    "ReposOwnerRepoCommentsCommentIdReactionsPostBody",
    "ReposOwnerRepoCommitsCommitShaCommentsPostBody",
    "ReposOwnerRepoCommitsRefCheckRunsGetResponse200",
    "ReposOwnerRepoCommitsRefCheckSuitesGetResponse200",
    "ReposOwnerRepoContentsPathPutBody",
    "ReposOwnerRepoContentsPathPutBodyPropCommitter",
    "ReposOwnerRepoContentsPathPutBodyPropAuthor",
    "ReposOwnerRepoContentsPathDeleteBody",
    "ReposOwnerRepoContentsPathDeleteBodyPropCommitter",
    "ReposOwnerRepoContentsPathDeleteBodyPropAuthor",
    "ReposOwnerRepoDependabotAlertsAlertNumberPatchBody",
    "ReposOwnerRepoDependabotSecretsGetResponse200",
    "ReposOwnerRepoDependabotSecretsSecretNamePutBody",
    "ReposOwnerRepoDependencyGraphSnapshotsPostResponse201",
    "ReposOwnerRepoDeploymentsPostBody",
    "ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0",
    "ReposOwnerRepoDeploymentsPostResponse202",
    "ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody",
    "ReposOwnerRepoDispatchesPostBody",
    "ReposOwnerRepoDispatchesPostBodyPropClientPayload",
    "ReposOwnerRepoEnvironmentsGetResponse200",
    "ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItems",
    "ReposOwnerRepoEnvironmentsEnvironmentNamePutBody",
    "ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200",
    "ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200",
    "ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody",
    "ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200",
    "ReposOwnerRepoForksPostBody",
    "ReposOwnerRepoGitBlobsPostBody",
    "ReposOwnerRepoGitCommitsPostBody",
    "ReposOwnerRepoGitCommitsPostBodyPropAuthor",
    "ReposOwnerRepoGitCommitsPostBodyPropCommitter",
    "ReposOwnerRepoGitRefsPostBody",
    "ReposOwnerRepoGitRefsRefPatchBody",
    "ReposOwnerRepoGitTagsPostBody",
    "ReposOwnerRepoGitTagsPostBodyPropTagger",
    "ReposOwnerRepoGitTreesPostBody",
    "ReposOwnerRepoGitTreesPostBodyPropTreeItems",
    "ReposOwnerRepoHooksPostBodyPropConfig",
    "ReposOwnerRepoHooksPostBody",
    "ReposOwnerRepoHooksHookIdPatchBody",
    "ReposOwnerRepoHooksHookIdPatchBodyPropConfig",
    "ReposOwnerRepoHooksHookIdConfigPatchBody",
    "ReposOwnerRepoImportPutBody",
    "ReposOwnerRepoImportPatchBody",
    "ReposOwnerRepoImportAuthorsAuthorIdPatchBody",
    "ReposOwnerRepoImportLfsPatchBody",
    "ReposOwnerRepoInteractionLimitsGetResponse200Anyof1",
    "ReposOwnerRepoInvitationsInvitationIdPatchBody",
    "ReposOwnerRepoIssuesPostBody",
    "ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1",
    "ReposOwnerRepoIssuesCommentsCommentIdPatchBody",
    "ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody",
    "ReposOwnerRepoIssuesIssueNumberPatchBody",
    "ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1",
    "ReposOwnerRepoIssuesIssueNumberAssigneesPostBody",
    "ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody",
    "ReposOwnerRepoIssuesIssueNumberCommentsPostBody",
    "ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0",
    "ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2",
    "ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItems",
    "ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items",
    "ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0",
    "ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2",
    "ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItems",
    "ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items",
    "ReposOwnerRepoIssuesIssueNumberLockPutBody",
    "ReposOwnerRepoIssuesIssueNumberReactionsPostBody",
    "ReposOwnerRepoKeysPostBody",
    "ReposOwnerRepoLabelsPostBody",
    "ReposOwnerRepoLabelsNamePatchBody",
    "ReposOwnerRepoMergeUpstreamPostBody",
    "ReposOwnerRepoMergesPostBody",
    "ReposOwnerRepoMilestonesPostBody",
    "ReposOwnerRepoMilestonesMilestoneNumberPatchBody",
    "ReposOwnerRepoNotificationsPutBody",
    "ReposOwnerRepoNotificationsPutResponse202",
    "ReposOwnerRepoPagesPutBodyPropSourceAnyof1",
    "ReposOwnerRepoPagesPutBodyAnyof0",
    "ReposOwnerRepoPagesPutBodyAnyof1",
    "ReposOwnerRepoPagesPutBodyAnyof2",
    "ReposOwnerRepoPagesPutBodyAnyof3",
    "ReposOwnerRepoPagesPutBodyAnyof4",
    "ReposOwnerRepoPagesPostBodyPropSource",
    "ReposOwnerRepoPagesPostBodyAnyof0",
    "ReposOwnerRepoPagesPostBodyAnyof1",
    "ReposOwnerRepoPagesDeploymentPostBody",
    "ReposOwnerRepoProjectsPostBody",
    "ReposOwnerRepoPullsPostBody",
    "ReposOwnerRepoPullsCommentsCommentIdPatchBody",
    "ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody",
    "ReposOwnerRepoPullsPullNumberPatchBody",
    "ReposOwnerRepoPullsPullNumberCodespacesPostBody",
    "ReposOwnerRepoPullsPullNumberCommentsPostBody",
    "ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody",
    "ReposOwnerRepoPullsPullNumberMergePutBody",
    "ReposOwnerRepoPullsPullNumberMergePutResponse405",
    "ReposOwnerRepoPullsPullNumberMergePutResponse409",
    "ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0",
    "ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1",
    "ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody",
    "ReposOwnerRepoPullsPullNumberReviewsPostBody",
    "ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItems",
    "ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody",
    "ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody",
    "ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody",
    "ReposOwnerRepoPullsPullNumberUpdateBranchPutBody",
    "ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202",
    "ReposOwnerRepoReleasesPostBody",
    "ReposOwnerRepoReleasesAssetsAssetIdPatchBody",
    "ReposOwnerRepoReleasesGenerateNotesPostBody",
    "ReposOwnerRepoReleasesReleaseIdPatchBody",
    "ReposOwnerRepoReleasesReleaseIdReactionsPostBody",
    "ReposOwnerRepoRulesetsPostBody",
    "ReposOwnerRepoRulesetsRulesetIdPutBody",
    "ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBody",
    "ReposOwnerRepoStatusesShaPostBody",
    "ReposOwnerRepoSubscriptionPutBody",
    "ReposOwnerRepoTagsProtectionPostBody",
    "ReposOwnerRepoTopicsPutBody",
    "ReposOwnerRepoTransferPostBody",
    "ReposTemplateOwnerTemplateRepoGeneratePostBody",
    "RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsGetResponse200",
    "RepositoriesRepositoryIdEnvironmentsEnvironmentNameSecretsSecretNamePutBody",
    "RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesGetResponse200",
    "RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesPostBody",
    "RepositoriesRepositoryIdEnvironmentsEnvironmentNameVariablesNamePatchBody",
    "SearchCodeGetResponse200",
    "SearchCommitsGetResponse200",
    "SearchIssuesGetResponse200",
    "SearchLabelsGetResponse200",
    "SearchRepositoriesGetResponse200",
    "SearchTopicsGetResponse200",
    "SearchUsersGetResponse200",
    "TeamsTeamIdPatchBody",
    "TeamsTeamIdDiscussionsPostBody",
    "TeamsTeamIdDiscussionsDiscussionNumberPatchBody",
    "TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody",
    "TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody",
    "TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody",
    "TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody",
    "TeamsTeamIdMembershipsUsernamePutBody",
    "TeamsTeamIdProjectsProjectIdPutBody",
    "TeamsTeamIdProjectsProjectIdPutResponse403",
    "TeamsTeamIdReposOwnerRepoPutBody",
    "UserPatchBody",
    "UserCodespacesGetResponse200",
    "UserCodespacesPostBodyOneof0",
    "UserCodespacesPostBodyOneof1",
    "UserCodespacesPostBodyOneof1PropPullRequest",
    "UserCodespacesSecretsGetResponse200",
    "UserCodespacesSecretsSecretNamePutBody",
    "UserCodespacesSecretsSecretNameRepositoriesGetResponse200",
    "UserCodespacesSecretsSecretNameRepositoriesPutBody",
    "UserCodespacesCodespaceNamePatchBody",
    "UserCodespacesCodespaceNameMachinesGetResponse200",
    "UserCodespacesCodespaceNamePublishPostBody",
    "UserEmailVisibilityPatchBody",
    "UserEmailsPostBodyOneof0",
    "UserEmailsDeleteBodyOneof0",
    "UserGpgKeysPostBody",
    "UserInstallationsGetResponse200",
    "UserInstallationsInstallationIdRepositoriesGetResponse200",
    "UserInteractionLimitsGetResponse200Anyof1",
    "UserKeysPostBody",
    "UserMembershipsOrgsOrgPatchBody",
    "UserMigrationsPostBody",
    "UserProjectsPostBody",
    "UserReposPostBody",
    "UserSocialAccountsPostBody",
    "UserSocialAccountsDeleteBody",
    "UserSshSigningKeysPostBody",
]
