"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from datetime import datetime
from typing import TYPE_CHECKING, Dict, List, Union, Literal, Optional, overload

from pydantic import BaseModel, TypeAdapter

from githubkit.utils import UNSET, Missing, exclude_unset

from .types import (
    ReposOwnerRepoPullsPostBodyType,
    ReposOwnerRepoPullsPullNumberPatchBodyType,
    ReposOwnerRepoPullsPullNumberMergePutBodyType,
    ReposOwnerRepoPullsPullNumberReviewsPostBodyType,
    ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
    ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
)
from .models import (
    Commit,
    DiffEntry,
    BasicError,
    PullRequest,
    ReviewComment,
    ValidationError,
    PullRequestReview,
    PullRequestSimple,
    ValidationErrorSimple,
    PullRequestMergeResult,
    PullRequestReviewComment,
    PullRequestReviewRequest,
    ReposOwnerRepoPullsPostBody,
    ReposOwnerRepoPullsPullNumberPatchBody,
    ReposOwnerRepoPullsPullNumberMergePutBody,
    ReposOwnerRepoPullsPullNumberReviewsPostBody,
    ReposOwnerRepoPullsCommentsCommentIdPatchBody,
    ReposOwnerRepoPullsPullNumberCommentsPostBody,
    ReposOwnerRepoPullsPullNumberMergePutResponse405,
    ReposOwnerRepoPullsPullNumberMergePutResponse409,
    ReposOwnerRepoPullsPullNumberUpdateBranchPutBody,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody,
    EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
    ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
    ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody,
    ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody,
    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
    ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody,
)

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class PullsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def list(
        self,
        owner: str,
        repo: str,
        state: Missing[Literal["open", "closed", "all"]] = "open",
        head: Missing[str] = UNSET,
        base: Missing[str] = UNSET,
        sort: Missing[
            Literal["created", "updated", "popularity", "long-running"]
        ] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list(
        self,
        owner: str,
        repo: str,
        state: Missing[Literal["open", "closed", "all"]] = "open",
        head: Missing[str] = UNSET,
        base: Missing[str] = UNSET,
        sort: Missing[
            Literal["created", "updated", "popularity", "long-running"]
        ] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestSimple]]":
        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPostBodyType,
    ) -> "Response[PullRequest]":
        ...

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        head: str,
        head_repo: Missing[str] = UNSET,
        base: str,
        body: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
        draft: Missing[bool] = UNSET,
        issue: Missing[int] = UNSET,
    ) -> "Response[PullRequest]":
        ...

    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoPullsPostBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPostBodyType,
    ) -> "Response[PullRequest]":
        ...

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        head: str,
        head_repo: Missing[str] = UNSET,
        base: str,
        body: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
        draft: Missing[bool] = UNSET,
        issue: Missing[int] = UNSET,
    ) -> "Response[PullRequest]":
        ...

    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoPullsPostBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["created", "updated", "created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReviewComment],
        )

    async def async_list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["created", "updated", "created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReviewComment],
        )

    def get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ) -> "Response[PullRequestReviewComment]":
        ...

    @overload
    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> "Response[PullRequestReviewComment]":
        ...

    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsCommentsCommentIdPatchBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
        )

    @overload
    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ) -> "Response[PullRequestReviewComment]":
        ...

    @overload
    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> "Response[PullRequestReviewComment]":
        ...

    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsCommentsCommentIdPatchBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
        )

    def get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
    ) -> "Response[PullRequest]":
        ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        base: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
    ) -> "Response[PullRequest]":
        ...

    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoPullsPullNumberPatchBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
    ) -> "Response[PullRequest]":
        ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        base: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
    ) -> "Response[PullRequest]":
        ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(ReposOwnerRepoPullsPullNumberPatchBody).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReviewComment],
        )

    async def async_list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        sort: Missing[Literal["created", "updated"]] = "created",
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReviewComment],
        )

    @overload
    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ) -> "Response[PullRequestReviewComment]":
        ...

    @overload
    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
        commit_id: str,
        path: str,
        position: Missing[int] = UNSET,
        side: Missing[Literal["LEFT", "RIGHT"]] = UNSET,
        line: Missing[int] = UNSET,
        start_line: Missing[int] = UNSET,
        start_side: Missing[Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Missing[int] = UNSET,
        subject_type: Missing[Literal["line", "file"]] = UNSET,
    ) -> "Response[PullRequestReviewComment]":
        ...

    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberCommentsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ) -> "Response[PullRequestReviewComment]":
        ...

    @overload
    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
        commit_id: str,
        path: str,
        position: Missing[int] = UNSET,
        side: Missing[Literal["LEFT", "RIGHT"]] = UNSET,
        line: Missing[int] = UNSET,
        start_line: Missing[int] = UNSET,
        start_side: Missing[Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Missing[int] = UNSET,
        subject_type: Missing[Literal["line", "file"]] = UNSET,
    ) -> "Response[PullRequestReviewComment]":
        ...

    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberCommentsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ) -> "Response[PullRequestReviewComment]":
        ...

    @overload
    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> "Response[PullRequestReviewComment]":
        ...

    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ) -> "Response[PullRequestReviewComment]":
        ...

    @overload
    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> "Response[PullRequestReviewComment]":
        ...

    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReviewComment]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Commit],
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[Commit]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Commit],
        )

    def list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DiffEntry]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[DiffEntry]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> "Response[PullRequestMergeResult]":
        ...

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        commit_title: Missing[str] = UNSET,
        commit_message: Missing[str] = UNSET,
        sha: Missing[str] = UNSET,
        merge_method: Missing[Literal["merge", "squash", "rebase"]] = UNSET,
    ) -> "Response[PullRequestMergeResult]":
        ...

    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestMergeResult]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoPullsPullNumberMergePutBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> "Response[PullRequestMergeResult]":
        ...

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        commit_title: Missing[str] = UNSET,
        commit_message: Missing[str] = UNSET,
        sha: Missing[str] = UNSET,
        merge_method: Missing[Literal["merge", "squash", "rebase"]] = UNSET,
    ) -> "Response[PullRequestMergeResult]":
        ...

    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestMergeResult]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoPullsPullNumberMergePutBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequestReviewRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewRequest,
        )

    async def async_list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequestReviewRequest]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewRequest,
        )

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response[PullRequestSimple]":
        ...

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: List[str],
        team_reviewers: Missing[List[str]] = UNSET,
    ) -> "Response[PullRequestSimple]":
        ...

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: Missing[List[str]] = UNSET,
        team_reviewers: List[str],
    ) -> "Response[PullRequestSimple]":
        ...

    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestSimple]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
            ]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
    ) -> "Response[PullRequestSimple]":
        ...

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: List[str],
        team_reviewers: Missing[List[str]] = UNSET,
    ) -> "Response[PullRequestSimple]":
        ...

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: Missing[List[str]] = UNSET,
        team_reviewers: List[str],
    ) -> "Response[PullRequestSimple]":
        ...

    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestSimple]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
            ]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ) -> "Response[PullRequestSimple]":
        ...

    @overload
    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: List[str],
        team_reviewers: Missing[List[str]] = UNSET,
    ) -> "Response[PullRequestSimple]":
        ...

    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestSimple]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ) -> "Response[PullRequestSimple]":
        ...

    @overload
    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: List[str],
        team_reviewers: Missing[List[str]] = UNSET,
    ) -> "Response[PullRequestSimple]":
        ...

    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestSimple]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    def list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestReview]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReview],
        )

    async def async_list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[PullRequestReview]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReview],
        )

    @overload
    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
    ) -> "Response[PullRequestReview]":
        ...

    @overload
    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        commit_id: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        event: Missing[Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Missing[
            List[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType]
        ] = UNSET,
    ) -> "Response[PullRequestReview]":
        ...

    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberReviewsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
    ) -> "Response[PullRequestReview]":
        ...

    @overload
    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        commit_id: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        event: Missing[Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Missing[
            List[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType]
        ] = UNSET,
    ) -> "Response[PullRequestReview]":
        ...

    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberReviewsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    def get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ) -> "Response[PullRequestReview]":
        ...

    @overload
    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> "Response[PullRequestReview]":
        ...

    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ) -> "Response[PullRequestReview]":
        ...

    @overload
    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> "Response[PullRequestReview]":
        ...

    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    async def async_delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        per_page: Missing[int] = 30,
        page: Missing[int] = 1,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[List[ReviewComment]]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
    ) -> "Response[PullRequestReview]":
        ...

    @overload
    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        event: Missing[Literal["DISMISS"]] = UNSET,
    ) -> "Response[PullRequestReview]":
        ...

    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReview]":
        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
    ) -> "Response[PullRequestReview]":
        ...

    @overload
    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        event: Missing[Literal["DISMISS"]] = UNSET,
    ) -> "Response[PullRequestReview]":
        ...

    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReview]":
        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ) -> "Response[PullRequestReview]":
        ...

    @overload
    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: Missing[str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> "Response[PullRequestReview]":
        ...

    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ) -> "Response[PullRequestReview]":
        ...

    @overload
    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: Missing[str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> "Response[PullRequestReview]":
        ...

    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> "Response[PullRequestReview]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> "Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]":
        ...

    @overload
    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        expected_head_sha: Missing[str] = UNSET,
    ) -> "Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]":
        ...

    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> "Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]":
        ...

    @overload
    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        expected_head_sha: Missing[str] = UNSET,
    ) -> "Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]":
        ...

    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> "Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]":
        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = TypeAdapter(
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBody, None]
        ).validate_python(json)
        json = json.model_dump(by_alias=True) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )
