"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

    python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel, TypeAdapter

from githubkit.utils import exclude_unset

from .models import BasicError, RateLimitOverview

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response


class RateLimitClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: "GitHubCore"):
        self._github = github

    def get(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RateLimitOverview]":
        url = "/rate_limit"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RateLimitOverview,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> "Response[RateLimitOverview]":
        url = "/rate_limit"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RateLimitOverview,
            error_models={
                "404": BasicError,
            },
        )
