"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from __future__ import annotations

from datetime import date, datetime
from typing_extensions import Annotated
from typing import Any, List, Union, Literal

from pydantic import Field

from githubkit.utils import UNSET
from githubkit.typing import Missing
from githubkit.compat import GitHubModel, ExtraGitHubModel, model_rebuild


class Root(GitHubModel):
    """Root"""

    current_user_url: str = Field()
    current_user_authorizations_html_url: str = Field()
    authorizations_url: str = Field()
    code_search_url: str = Field()
    commit_search_url: str = Field()
    emails_url: str = Field()
    emojis_url: str = Field()
    events_url: str = Field()
    feeds_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    hub_url: str = Field()
    issue_search_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    label_search_url: str = Field()
    notifications_url: str = Field()
    organization_url: str = Field()
    organization_repositories_url: str = Field()
    organization_teams_url: str = Field()
    public_gists_url: str = Field()
    rate_limit_url: str = Field()
    repository_url: str = Field()
    repository_search_url: str = Field()
    current_user_repositories_url: str = Field()
    starred_url: str = Field()
    starred_gists_url: str = Field()
    topic_search_url: Missing[str] = Field(default=UNSET)
    user_url: str = Field()
    user_organizations_url: str = Field()
    user_repositories_url: str = Field()
    user_search_url: str = Field()


class SimpleUser(GitHubModel):
    """Simple User

    A GitHub user.
    """

    name: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    login: str = Field()
    id: int = Field()
    node_id: str = Field()
    avatar_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    url: str = Field()
    html_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    starred_url: str = Field()
    subscriptions_url: str = Field()
    organizations_url: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    received_events_url: str = Field()
    type: str = Field()
    site_admin: bool = Field()
    starred_at: Missing[str] = Field(default=UNSET)


class GlobalAdvisory(GitHubModel):
    """GlobalAdvisory

    A GitHub Security Advisory.
    """

    ghsa_id: str = Field(description="The GitHub Security Advisory ID.")
    cve_id: Union[str, None] = Field(
        description="The Common Vulnerabilities and Exposures (CVE) ID."
    )
    url: str = Field(description="The API URL for the advisory.")
    html_url: str = Field(description="The URL for the advisory.")
    repository_advisory_url: Union[str, None] = Field(
        description="The API URL for the repository advisory."
    )
    summary: Annotated[str, Field(max_length=1024)] = Field(
        description="A short summary of the advisory."
    )
    description: Union[Annotated[str, Field(max_length=65535)], None] = Field(
        description="A detailed description of what the advisory entails."
    )
    type: Literal["reviewed", "unreviewed", "malware"] = Field(
        description="The type of advisory."
    )
    severity: Literal["critical", "high", "medium", "low", "unknown"] = Field(
        description="The severity of the advisory."
    )
    source_code_location: Union[str, None] = Field(
        description="The URL of the advisory's source code."
    )
    identifiers: Union[List[GlobalAdvisoryPropIdentifiersItems], None] = Field()
    references: Union[List[str], None] = Field()
    published_at: datetime = Field(
        description="The date and time of when the advisory was published, in ISO 8601 format."
    )
    updated_at: datetime = Field(
        description="The date and time of when the advisory was last updated, in ISO 8601 format."
    )
    github_reviewed_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was reviewed by GitHub, in ISO 8601 format."
    )
    nvd_published_at: Union[datetime, None] = Field(
        description="The date and time when the advisory was published in the National Vulnerability Database, in ISO 8601 format.\nThis field is only populated when the advisory is imported from the National Vulnerability Database."
    )
    withdrawn_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was withdrawn, in ISO 8601 format."
    )
    vulnerabilities: Union[List[GlobalAdvisoryPropVulnerabilitiesItems], None] = Field(
        description="The products and respective version ranges affected by the advisory."
    )
    cvss: Union[GlobalAdvisoryPropCvss, None] = Field()
    cwes: Union[List[GlobalAdvisoryPropCwesItems], None] = Field()
    credits_: Union[List[GlobalAdvisoryPropCreditsItems], None] = Field(
        alias="credits", description="The users who contributed to the advisory."
    )


class GlobalAdvisoryPropIdentifiersItems(GitHubModel):
    """GlobalAdvisoryPropIdentifiersItems"""

    type: Literal["CVE", "GHSA"] = Field(description="The type of identifier.")
    value: str = Field(description="The identifier value.")


class GlobalAdvisoryPropVulnerabilitiesItems(GitHubModel):
    """GlobalAdvisoryPropVulnerabilitiesItems"""

    package: Union[GlobalAdvisoryPropVulnerabilitiesItemsPropPackage, None] = Field(
        description="The name of the package affected by the vulnerability."
    )
    vulnerable_version_range: Union[str, None] = Field(
        description="The range of the package versions affected by the vulnerability."
    )
    first_patched_version: Union[str, None] = Field(
        description="The package version that resolve the vulnerability."
    )
    vulnerable_functions: Union[List[str], None] = Field(
        description="The functions in the package that are affected by the vulnerability."
    )


class GlobalAdvisoryPropVulnerabilitiesItemsPropPackage(GitHubModel):
    """GlobalAdvisoryPropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(description="The package's language or package management ecosystem.")
    name: Union[str, None] = Field(
        description="The unique package name within its ecosystem."
    )


class GlobalAdvisoryPropCvss(GitHubModel):
    """GlobalAdvisoryPropCvss"""

    vector_string: Union[str, None] = Field(description="The CVSS vector.")
    score: Union[Annotated[float, Field(le=10.0)], None] = Field(
        description="The CVSS score."
    )


class GlobalAdvisoryPropCwesItems(GitHubModel):
    """GlobalAdvisoryPropCwesItems"""

    cwe_id: str = Field(description="The Common Weakness Enumeration (CWE) identifier.")
    name: str = Field(description="The name of the CWE.")


class GlobalAdvisoryPropCreditsItems(GitHubModel):
    """GlobalAdvisoryPropCreditsItems"""

    user: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ] = Field(description="The type of credit the user is receiving.")


class BasicError(GitHubModel):
    """Basic Error

    Basic Error
    """

    message: Missing[str] = Field(default=UNSET)
    documentation_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    status: Missing[str] = Field(default=UNSET)


class ValidationErrorSimple(GitHubModel):
    """Validation Error Simple

    Validation Error Simple
    """

    message: str = Field()
    documentation_url: str = Field()
    errors: Missing[List[str]] = Field(default=UNSET)


class Integration(GitHubModel):
    """GitHub app

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    id: int = Field(description="Unique identifier of the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    node_id: str = Field()
    owner: Union[None, SimpleUser] = Field()
    name: str = Field(description="The name of the GitHub app")
    description: Union[str, None] = Field()
    external_url: str = Field()
    html_url: str = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    permissions: IntegrationPropPermissions = Field(
        description="The set of permissions for the GitHub app"
    )
    events: List[str] = Field(description="The list of events for the GitHub app")
    installations_count: Missing[int] = Field(
        default=UNSET,
        description="The number of installations associated with the GitHub app",
    )
    client_id: Missing[str] = Field(default=UNSET)
    client_secret: Missing[str] = Field(default=UNSET)
    webhook_secret: Missing[Union[str, None]] = Field(default=UNSET)
    pem: Missing[str] = Field(default=UNSET)


class IntegrationPropPermissions(ExtraGitHubModel):
    """IntegrationPropPermissions

    The set of permissions for the GitHub app

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """

    issues: Missing[str] = Field(default=UNSET)
    checks: Missing[str] = Field(default=UNSET)
    metadata: Missing[str] = Field(default=UNSET)
    contents: Missing[str] = Field(default=UNSET)
    deployments: Missing[str] = Field(default=UNSET)


class WebhookConfig(GitHubModel):
    """Webhook Configuration

    Configuration object of the webhook
    """

    url: Missing[str] = Field(
        default=UNSET, description="The URL to which the payloads will be delivered."
    )
    content_type: Missing[str] = Field(
        default=UNSET,
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
    )
    secret: Missing[str] = Field(
        default=UNSET,
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
    )
    insecure_ssl: Missing[Union[str, float]] = Field(default=UNSET)


class HookDeliveryItem(GitHubModel):
    """Simple webhook delivery

    Delivery made by a webhook, without request and response information.
    """

    id: int = Field(description="Unique identifier of the webhook delivery.")
    guid: str = Field(
        description="Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event)."
    )
    delivered_at: datetime = Field(
        description="Time when the webhook delivery occurred."
    )
    redelivery: bool = Field(
        description="Whether the webhook delivery is a redelivery."
    )
    duration: float = Field(description="Time spent delivering.")
    status: str = Field(
        description="Describes the response returned after attempting the delivery."
    )
    status_code: int = Field(description="Status code received when delivery was made.")
    event: str = Field(description="The event that triggered the delivery.")
    action: Union[str, None] = Field(
        description="The type of activity for the event that triggered the delivery."
    )
    installation_id: Union[int, None] = Field(
        description="The id of the GitHub App installation associated with this event."
    )
    repository_id: Union[int, None] = Field(
        description="The id of the repository associated with this event."
    )


class ScimError(GitHubModel):
    """Scim Error

    Scim Error
    """

    message: Missing[Union[str, None]] = Field(default=UNSET)
    documentation_url: Missing[Union[str, None]] = Field(default=UNSET)
    detail: Missing[Union[str, None]] = Field(default=UNSET)
    status: Missing[int] = Field(default=UNSET)
    scim_type: Missing[Union[str, None]] = Field(default=UNSET, alias="scimType")
    schemas: Missing[List[str]] = Field(default=UNSET)


class ValidationError(GitHubModel):
    """Validation Error

    Validation Error
    """

    message: str = Field()
    documentation_url: str = Field()
    errors: Missing[List[ValidationErrorPropErrorsItems]] = Field(default=UNSET)


class ValidationErrorPropErrorsItems(GitHubModel):
    """ValidationErrorPropErrorsItems"""

    resource: Missing[str] = Field(default=UNSET)
    field: Missing[str] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    code: str = Field()
    index: Missing[int] = Field(default=UNSET)
    value: Missing[Union[str, None, int, None, List[str], None]] = Field(default=UNSET)


class HookDelivery(GitHubModel):
    """Webhook delivery

    Delivery made by a webhook.
    """

    id: int = Field(description="Unique identifier of the delivery.")
    guid: str = Field(
        description="Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event)."
    )
    delivered_at: datetime = Field(description="Time when the delivery was delivered.")
    redelivery: bool = Field(description="Whether the delivery is a redelivery.")
    duration: float = Field(description="Time spent delivering.")
    status: str = Field(
        description="Description of the status of the attempted delivery"
    )
    status_code: int = Field(description="Status code received when delivery was made.")
    event: str = Field(description="The event that triggered the delivery.")
    action: Union[str, None] = Field(
        description="The type of activity for the event that triggered the delivery."
    )
    installation_id: Union[int, None] = Field(
        description="The id of the GitHub App installation associated with this event."
    )
    repository_id: Union[int, None] = Field(
        description="The id of the repository associated with this event."
    )
    url: Missing[str] = Field(
        default=UNSET, description="The URL target of the delivery."
    )
    request: HookDeliveryPropRequest = Field()
    response: HookDeliveryPropResponse = Field()


class HookDeliveryPropRequest(GitHubModel):
    """HookDeliveryPropRequest"""

    headers: Union[HookDeliveryPropRequestPropHeaders, None] = Field(
        description="The request headers sent with the webhook delivery."
    )
    payload: Union[HookDeliveryPropRequestPropPayload, None] = Field(
        description="The webhook payload."
    )


class HookDeliveryPropRequestPropHeaders(ExtraGitHubModel):
    """HookDeliveryPropRequestPropHeaders

    The request headers sent with the webhook delivery.
    """


class HookDeliveryPropRequestPropPayload(ExtraGitHubModel):
    """HookDeliveryPropRequestPropPayload

    The webhook payload.
    """


class HookDeliveryPropResponse(GitHubModel):
    """HookDeliveryPropResponse"""

    headers: Union[HookDeliveryPropResponsePropHeaders, None] = Field(
        description="The response headers received when the delivery was made."
    )
    payload: Union[str, None] = Field(description="The response payload received.")


class HookDeliveryPropResponsePropHeaders(ExtraGitHubModel):
    """HookDeliveryPropResponsePropHeaders

    The response headers received when the delivery was made.
    """


class Enterprise(GitHubModel):
    """Enterprise

    An enterprise on GitHub.
    """

    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="A short description of the enterprise."
    )
    html_url: str = Field()
    website_url: Missing[Union[str, None]] = Field(
        default=UNSET, description="The enterprise's website URL."
    )
    id: int = Field(description="Unique identifier of the enterprise")
    node_id: str = Field()
    name: str = Field(description="The name of the enterprise.")
    slug: str = Field(description="The slug url identifier for the enterprise.")
    created_at: Union[datetime, None] = Field()
    updated_at: Union[datetime, None] = Field()
    avatar_url: str = Field()


class IntegrationInstallationRequest(GitHubModel):
    """Integration Installation Request

    Request to install an integration on a target
    """

    id: int = Field(description="Unique identifier of the request installation.")
    node_id: Missing[str] = Field(default=UNSET)
    account: Union[SimpleUser, Enterprise] = Field()
    requester: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    created_at: datetime = Field()


class AppPermissions(GitHubModel):
    """App Permissions

    The permissions granted to the user access token.

    Examples:
        {'contents': 'read', 'issues': 'read', 'deployments': 'write', 'single_file':
    'read'}
    """

    actions: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.",
    )
    administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.",
    )
    checks: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for checks on code.",
    )
    codespaces: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to create, edit, delete, and list Codespaces.",
    )
    contents: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.",
    )
    dependabot_secrets: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The leve of permission to grant the access token to manage Dependabot secrets.",
    )
    deployments: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for deployments and deployment statuses.",
    )
    environments: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for managing repository environments.",
    )
    issues: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.",
    )
    metadata: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.",
    )
    packages: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for packages published to GitHub Packages.",
    )
    pages: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.",
    )
    pull_requests: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.",
    )
    repository_custom_properties: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to view and edit custom properties for a repository, when allowed by the property.",
    )
    repository_hooks: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage the post-receive hooks for a repository.",
    )
    repository_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage repository projects, columns, and cards.",
    )
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to view and manage secret scanning alerts.",
    )
    secrets: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage repository secrets.",
    )
    security_events: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to view and manage security events like code scanning alerts.",
    )
    single_file: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage just a single file.",
    )
    statuses: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for commit statuses.",
    )
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage Dependabot alerts.",
    )
    workflows: Missing[Literal["write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to update GitHub Actions workflow files.",
    )
    members: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for organization teams and members.",
    )
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage access to an organization.",
    )
    organization_custom_roles: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for custom repository roles management.",
    )
    organization_custom_org_roles: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for custom organization roles management.",
    )
    organization_custom_properties: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for custom property management.",
    )
    organization_copilot_seat_management: Missing[Literal["write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for managing access to GitHub Copilot for members of an organization with a Copilot Business subscription. This property is in beta and is subject to change.",
    )
    organization_announcement_banners: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to view and manage announcement banners for an organization.",
    )
    organization_events: Missing[Literal["read"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to view events triggered by an activity in an organization.",
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage the post-receive hooks for an organization.",
    )
    organization_personal_access_tokens: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for viewing and managing fine-grained personal access token requests to an organization.",
    )
    organization_personal_access_token_requests: Missing[
        Literal["read", "write"]
    ] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for viewing and managing fine-grained personal access tokens that have been approved by an organization.",
    )
    organization_plan: Missing[Literal["read"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for viewing an organization's plan.",
    )
    organization_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage organization projects and projects beta (where available).",
    )
    organization_packages: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token for organization packages published to GitHub Packages.",
    )
    organization_secrets: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage organization secrets.",
    )
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.",
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to view and manage users blocked by the organization.",
    )
    team_discussions: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage team discussions and related comments.",
    )
    email_addresses: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage the email addresses belonging to a user.",
    )
    followers: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage the followers belonging to a user.",
    )
    git_ssh_keys: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage git SSH keys.",
    )
    gpg_keys: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to view and manage GPG keys belonging to a user.",
    )
    interaction_limits: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to view and manage interaction limits on a repository.",
    )
    profile: Missing[Literal["write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to manage the profile settings belonging to a user.",
    )
    starring: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The level of permission to grant the access token to list and manage repositories a user is starring.",
    )


class Installation(GitHubModel):
    """Installation

    Installation
    """

    id: int = Field(description="The ID of the installation.")
    account: Union[SimpleUser, Enterprise, None] = Field()
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved"
    )
    access_tokens_url: str = Field()
    repositories_url: str = Field()
    html_url: str = Field()
    app_id: int = Field()
    target_id: int = Field(
        description="The ID of the user or organization this token is being scoped to."
    )
    target_type: str = Field()
    permissions: AppPermissions = Field(
        title="App Permissions",
        description="The permissions granted to the user access token.",
    )
    events: List[str] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    single_file_name: Union[str, None] = Field()
    has_multiple_single_files: Missing[bool] = Field(default=UNSET)
    single_file_paths: Missing[List[str]] = Field(default=UNSET)
    app_slug: str = Field()
    suspended_by: Union[None, SimpleUser] = Field()
    suspended_at: Union[datetime, None] = Field()
    contact_email: Missing[Union[str, None]] = Field(default=UNSET)


class LicenseSimple(GitHubModel):
    """License Simple

    License Simple
    """

    key: str = Field()
    name: str = Field()
    url: Union[str, None] = Field()
    spdx_id: Union[str, None] = Field()
    node_id: str = Field()
    html_url: Missing[str] = Field(default=UNSET)


class Repository(GitHubModel):
    """Repository

    A repository on GitHub.
    """

    id: int = Field(description="Unique identifier of the repository")
    node_id: str = Field()
    name: str = Field(description="The name of the repository.")
    full_name: str = Field()
    license_: Union[None, LicenseSimple] = Field(alias="license")
    organization: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    forks: int = Field()
    permissions: Missing[RepositoryPropPermissions] = Field(default=UNSET)
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    private: bool = Field(
        default=False, description="Whether the repository is private or public."
    )
    html_url: str = Field()
    description: Union[str, None] = Field()
    fork: bool = Field()
    url: str = Field()
    archive_url: str = Field()
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    deployments_url: str = Field()
    downloads_url: str = Field()
    events_url: str = Field()
    forks_url: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    languages_url: str = Field()
    merges_url: str = Field()
    milestones_url: str = Field()
    notifications_url: str = Field()
    pulls_url: str = Field()
    releases_url: str = Field()
    ssh_url: str = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    trees_url: str = Field()
    clone_url: str = Field()
    mirror_url: Union[str, None] = Field()
    hooks_url: str = Field()
    svn_url: str = Field()
    homepage: Union[str, None] = Field()
    language: Union[str, None] = Field()
    forks_count: int = Field()
    stargazers_count: int = Field()
    watchers_count: int = Field()
    size: int = Field(
        description="The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0."
    )
    default_branch: str = Field(description="The default branch of the repository.")
    open_issues_count: int = Field()
    is_template: Missing[bool] = Field(
        default=UNSET,
        description="Whether this repository acts as a template that can be used to generate new repositories.",
    )
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_pages: bool = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_discussions: Missing[bool] = Field(
        default=UNSET, description="Whether discussions are enabled."
    )
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    disabled: bool = Field(
        description="Returns whether or not this repository disabled."
    )
    visibility: Missing[str] = Field(
        default=UNSET,
        description="The repository visibility: public, private, or internal.",
    )
    pushed_at: Union[datetime, None] = Field()
    created_at: Union[datetime, None] = Field()
    updated_at: Union[datetime, None] = Field()
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    template_repository: Missing[Union[RepositoryPropTemplateRepository, None]] = Field(
        default=UNSET
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_auto_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to allow Auto-merge to be used on pull requests.",
    )
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    allow_update_branch: Missing[bool] = Field(
        default=UNSET,
        description="Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.",
    )
    use_squash_pr_title_as_default: Missing[bool] = Field(
        default=UNSET,
        description="Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.",
    )
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow forking this repo"
    )
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)
    open_issues: int = Field()
    watchers: int = Field()
    master_branch: Missing[str] = Field(default=UNSET)
    starred_at: Missing[str] = Field(default=UNSET)
    anonymous_access_enabled: Missing[bool] = Field(
        default=UNSET,
        description="Whether anonymous git access is enabled for this repository",
    )


class RepositoryPropPermissions(GitHubModel):
    """RepositoryPropPermissions"""

    admin: bool = Field()
    pull: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)
    push: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)


class RepositoryPropTemplateRepositoryPropOwner(GitHubModel):
    """RepositoryPropTemplateRepositoryPropOwner"""

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)


class RepositoryPropTemplateRepositoryPropPermissions(GitHubModel):
    """RepositoryPropTemplateRepositoryPropPermissions"""

    admin: Missing[bool] = Field(default=UNSET)
    maintain: Missing[bool] = Field(default=UNSET)
    push: Missing[bool] = Field(default=UNSET)
    triage: Missing[bool] = Field(default=UNSET)
    pull: Missing[bool] = Field(default=UNSET)


class RepositoryPropTemplateRepository(GitHubModel):
    """RepositoryPropTemplateRepository"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    owner: Missing[RepositoryPropTemplateRepositoryPropOwner] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    description: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    git_url: Missing[str] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    ssh_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    clone_url: Missing[str] = Field(default=UNSET)
    mirror_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    svn_url: Missing[str] = Field(default=UNSET)
    homepage: Missing[str] = Field(default=UNSET)
    language: Missing[str] = Field(default=UNSET)
    forks_count: Missing[int] = Field(default=UNSET)
    stargazers_count: Missing[int] = Field(default=UNSET)
    watchers_count: Missing[int] = Field(default=UNSET)
    size: Missing[int] = Field(default=UNSET)
    default_branch: Missing[str] = Field(default=UNSET)
    open_issues_count: Missing[int] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: Missing[bool] = Field(default=UNSET)
    has_projects: Missing[bool] = Field(default=UNSET)
    has_wiki: Missing[bool] = Field(default=UNSET)
    has_pages: Missing[bool] = Field(default=UNSET)
    has_downloads: Missing[bool] = Field(default=UNSET)
    archived: Missing[bool] = Field(default=UNSET)
    disabled: Missing[bool] = Field(default=UNSET)
    visibility: Missing[str] = Field(default=UNSET)
    pushed_at: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    permissions: Missing[RepositoryPropTemplateRepositoryPropPermissions] = Field(
        default=UNSET
    )
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_auto_merge: Missing[bool] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Missing[bool] = Field(default=UNSET)
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)


class InstallationToken(GitHubModel):
    """Installation Token

    Authentication token for a GitHub App installed on a user or org.
    """

    token: str = Field()
    expires_at: str = Field()
    permissions: Missing[AppPermissions] = Field(
        default=UNSET,
        title="App Permissions",
        description="The permissions granted to the user access token.",
    )
    repository_selection: Missing[Literal["all", "selected"]] = Field(default=UNSET)
    repositories: Missing[List[Repository]] = Field(default=UNSET)
    single_file: Missing[str] = Field(default=UNSET)
    has_multiple_single_files: Missing[bool] = Field(default=UNSET)
    single_file_paths: Missing[List[str]] = Field(default=UNSET)


class ScopedInstallation(GitHubModel):
    """Scoped Installation"""

    permissions: AppPermissions = Field(
        title="App Permissions",
        description="The permissions granted to the user access token.",
    )
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved"
    )
    single_file_name: Union[str, None] = Field()
    has_multiple_single_files: Missing[bool] = Field(default=UNSET)
    single_file_paths: Missing[List[str]] = Field(default=UNSET)
    repositories_url: str = Field()
    account: SimpleUser = Field(title="Simple User", description="A GitHub user.")


class Authorization(GitHubModel):
    """Authorization

    The authorization for an OAuth app, GitHub App, or a Personal Access Token.
    """

    id: int = Field()
    url: str = Field()
    scopes: Union[List[str], None] = Field(
        description="A list of scopes that this authorization is in."
    )
    token: str = Field()
    token_last_eight: Union[str, None] = Field()
    hashed_token: Union[str, None] = Field()
    app: AuthorizationPropApp = Field()
    note: Union[str, None] = Field()
    note_url: Union[str, None] = Field()
    updated_at: datetime = Field()
    created_at: datetime = Field()
    fingerprint: Union[str, None] = Field()
    user: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    installation: Missing[Union[None, ScopedInstallation]] = Field(default=UNSET)
    expires_at: Union[datetime, None] = Field()


class AuthorizationPropApp(GitHubModel):
    """AuthorizationPropApp"""

    client_id: str = Field()
    name: str = Field()
    url: str = Field()


class SimpleClassroomRepository(GitHubModel):
    """Simple Classroom Repository

    A GitHub repository view for Classroom
    """

    id: int = Field(description="A unique identifier of the repository.")
    full_name: str = Field(
        description="The full, globally unique name of the repository."
    )
    html_url: str = Field(description="The URL to view the repository on GitHub.com.")
    node_id: str = Field(description="The GraphQL identifier of the repository.")
    private: bool = Field(description="Whether the repository is private.")
    default_branch: str = Field(description="The default branch for the repository.")


class SimpleClassroomOrganization(GitHubModel):
    """Organization Simple for Classroom

    A GitHub organization.
    """

    id: int = Field()
    login: str = Field()
    node_id: str = Field()
    html_url: str = Field()
    name: Union[str, None] = Field()
    avatar_url: str = Field()


class Classroom(GitHubModel):
    """Classroom

    A GitHub Classroom classroom
    """

    id: int = Field(description="Unique identifier of the classroom.")
    name: str = Field(description="The name of the classroom.")
    archived: bool = Field(description="Whether classroom is archived.")
    organization: SimpleClassroomOrganization = Field(
        title="Organization Simple for Classroom", description="A GitHub organization."
    )
    url: str = Field(description="The URL of the classroom on GitHub Classroom.")


class ClassroomAssignment(GitHubModel):
    """Classroom Assignment

    A GitHub Classroom assignment
    """

    id: int = Field(description="Unique identifier of the repository.")
    public_repo: bool = Field(
        description="Whether an accepted assignment creates a public repository."
    )
    title: str = Field(description="Assignment title.")
    type: Literal["individual", "group"] = Field(
        description="Whether it's a group assignment or individual assignment."
    )
    invite_link: str = Field(
        description="The link that a student can use to accept the assignment."
    )
    invitations_enabled: bool = Field(
        description="Whether the invitation link is enabled. Visiting an enabled invitation link will accept the assignment."
    )
    slug: str = Field(description="Sluggified name of the assignment.")
    students_are_repo_admins: bool = Field(
        description="Whether students are admins on created repository when a student accepts the assignment."
    )
    feedback_pull_requests_enabled: bool = Field(
        description="Whether feedback pull request will be created when a student accepts the assignment."
    )
    max_teams: Union[int, None] = Field(
        description="The maximum allowable teams for the assignment."
    )
    max_members: Union[int, None] = Field(
        description="The maximum allowable members per team."
    )
    editor: str = Field(description="The selected editor for the assignment.")
    accepted: int = Field(
        description="The number of students that have accepted the assignment."
    )
    submitted: int = Field(
        description="The number of students that have submitted the assignment."
    )
    passing: int = Field(
        description="The number of students that have passed the assignment."
    )
    language: str = Field(
        description="The programming language used in the assignment."
    )
    deadline: Union[datetime, None] = Field(
        description="The time at which the assignment is due."
    )
    starter_code_repository: SimpleClassroomRepository = Field(
        title="Simple Classroom Repository",
        description="A GitHub repository view for Classroom",
    )
    classroom: Classroom = Field(
        title="Classroom", description="A GitHub Classroom classroom"
    )


class SimpleClassroomUser(GitHubModel):
    """Simple Classroom User

    A GitHub user simplified for Classroom.
    """

    id: int = Field()
    login: str = Field()
    avatar_url: str = Field()
    html_url: str = Field()


class SimpleClassroom(GitHubModel):
    """Simple Classroom

    A GitHub Classroom classroom
    """

    id: int = Field(description="Unique identifier of the classroom.")
    name: str = Field(description="The name of the classroom.")
    archived: bool = Field(description="Returns whether classroom is archived or not.")
    url: str = Field(description="The url of the classroom on GitHub Classroom.")


class SimpleClassroomAssignment(GitHubModel):
    """Simple Classroom Assignment

    A GitHub Classroom assignment
    """

    id: int = Field(description="Unique identifier of the repository.")
    public_repo: bool = Field(
        description="Whether an accepted assignment creates a public repository."
    )
    title: str = Field(description="Assignment title.")
    type: Literal["individual", "group"] = Field(
        description="Whether it's a Group Assignment or Individual Assignment."
    )
    invite_link: str = Field(
        description="The link that a student can use to accept the assignment."
    )
    invitations_enabled: bool = Field(
        description="Whether the invitation link is enabled. Visiting an enabled invitation link will accept the assignment."
    )
    slug: str = Field(description="Sluggified name of the assignment.")
    students_are_repo_admins: bool = Field(
        description="Whether students are admins on created repository on accepted assignment."
    )
    feedback_pull_requests_enabled: bool = Field(
        description="Whether feedback pull request will be created on assignment acceptance."
    )
    max_teams: Missing[Union[int, None]] = Field(
        default=UNSET, description="The maximum allowable teams for the assignment."
    )
    max_members: Missing[Union[int, None]] = Field(
        default=UNSET, description="The maximum allowable members per team."
    )
    editor: str = Field(description="The selected editor for the assignment.")
    accepted: int = Field(
        description="The number of students that have accepted the assignment."
    )
    submitted: int = Field(
        description="The number of students that have submitted the assignment."
    )
    passing: int = Field(
        description="The number of students that have passed the assignment."
    )
    language: str = Field(
        description="The programming language used in the assignment."
    )
    deadline: Union[datetime, None] = Field(
        description="The time at which the assignment is due."
    )
    classroom: SimpleClassroom = Field(
        title="Simple Classroom", description="A GitHub Classroom classroom"
    )


class ClassroomAcceptedAssignment(GitHubModel):
    """Classroom Accepted Assignment

    A GitHub Classroom accepted assignment
    """

    id: int = Field(description="Unique identifier of the repository.")
    submitted: bool = Field(
        description="Whether an accepted assignment has been submitted."
    )
    passing: bool = Field(description="Whether a submission passed.")
    commit_count: int = Field(description="Count of student commits.")
    grade: str = Field(description="Most recent grade.")
    students: List[SimpleClassroomUser] = Field()
    repository: SimpleClassroomRepository = Field(
        title="Simple Classroom Repository",
        description="A GitHub repository view for Classroom",
    )
    assignment: SimpleClassroomAssignment = Field(
        title="Simple Classroom Assignment", description="A GitHub Classroom assignment"
    )


class ClassroomAssignmentGrade(GitHubModel):
    """Classroom Assignment Grade

    Grade for a student or groups GitHub Classroom assignment
    """

    assignment_name: str = Field(description="Name of the assignment")
    assignment_url: str = Field(description="URL of the assignment")
    starter_code_url: str = Field(
        description="URL of the starter code for the assignment"
    )
    github_username: str = Field(description="GitHub username of the student")
    roster_identifier: str = Field(description="Roster identifier of the student")
    student_repository_name: str = Field(
        description="Name of the student's assignment repository"
    )
    student_repository_url: str = Field(
        description="URL of the student's assignment repository"
    )
    submission_timestamp: str = Field(
        description="Timestamp of the student's assignment submission"
    )
    points_awarded: int = Field(description="Number of points awarded to the student")
    points_available: int = Field(
        description="Number of points available for the assignment"
    )
    group_name: Missing[str] = Field(
        default=UNSET,
        description="If a group assignment, name of the group the student is in",
    )


class CodeOfConduct(GitHubModel):
    """Code Of Conduct

    Code Of Conduct
    """

    key: str = Field()
    name: str = Field()
    url: str = Field()
    body: Missing[str] = Field(default=UNSET)
    html_url: Union[str, None] = Field()


class DependabotAlertPackage(GitHubModel):
    """DependabotAlertPackage

    Details for the vulnerable package.
    """

    ecosystem: str = Field(
        description="The package's language or package management ecosystem."
    )
    name: str = Field(description="The unique package name within its ecosystem.")


class DependabotAlertSecurityVulnerability(GitHubModel):
    """DependabotAlertSecurityVulnerability

    Details pertaining to one vulnerable version range for the advisory.
    """

    package: DependabotAlertPackage = Field(
        description="Details for the vulnerable package."
    )
    severity: Literal["low", "medium", "high", "critical"] = Field(
        description="The severity of the vulnerability."
    )
    vulnerable_version_range: str = Field(
        description="Conditions that identify vulnerable versions of this vulnerability's package."
    )
    first_patched_version: Union[
        DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion, None
    ] = Field(
        description="Details pertaining to the package version that patches this vulnerability."
    )


class DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion(GitHubModel):
    """DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion

    Details pertaining to the package version that patches this vulnerability.
    """

    identifier: str = Field(
        description="The package version that patches this vulnerability."
    )


class DependabotAlertSecurityAdvisory(GitHubModel):
    """DependabotAlertSecurityAdvisory

    Details for the GitHub Security Advisory.
    """

    ghsa_id: str = Field(
        description="The unique GitHub Security Advisory ID assigned to the advisory."
    )
    cve_id: Union[str, None] = Field(
        description="The unique CVE ID assigned to the advisory."
    )
    summary: Annotated[str, Field(max_length=1024)] = Field(
        description="A short, plain text summary of the advisory."
    )
    description: str = Field(
        description="A long-form Markdown-supported description of the advisory."
    )
    vulnerabilities: List[DependabotAlertSecurityVulnerability] = Field(
        description="Vulnerable version range information for the advisory."
    )
    severity: Literal["low", "medium", "high", "critical"] = Field(
        description="The severity of the advisory."
    )
    cvss: DependabotAlertSecurityAdvisoryPropCvss = Field(
        description="Details for the advisory pertaining to the Common Vulnerability Scoring System."
    )
    cwes: List[DependabotAlertSecurityAdvisoryPropCwesItems] = Field(
        description="Details for the advisory pertaining to Common Weakness Enumeration."
    )
    identifiers: List[DependabotAlertSecurityAdvisoryPropIdentifiersItems] = Field(
        description="Values that identify this advisory among security information sources."
    )
    references: List[DependabotAlertSecurityAdvisoryPropReferencesItems] = Field(
        description="Links to additional advisory information."
    )
    published_at: datetime = Field(
        description="The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    updated_at: datetime = Field(
        description="The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    withdrawn_at: Union[datetime, None] = Field(
        description="The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )


class DependabotAlertSecurityAdvisoryPropCvss(GitHubModel):
    """DependabotAlertSecurityAdvisoryPropCvss

    Details for the advisory pertaining to the Common Vulnerability Scoring System.
    """

    score: Annotated[float, Field(le=10.0)] = Field(
        description="The overall CVSS score of the advisory."
    )
    vector_string: Union[str, None] = Field(
        description="The full CVSS vector string for the advisory."
    )


class DependabotAlertSecurityAdvisoryPropCwesItems(GitHubModel):
    """DependabotAlertSecurityAdvisoryPropCwesItems

    A CWE weakness assigned to the advisory.
    """

    cwe_id: str = Field(description="The unique CWE ID.")
    name: str = Field(description="The short, plain text name of the CWE.")


class DependabotAlertSecurityAdvisoryPropIdentifiersItems(GitHubModel):
    """DependabotAlertSecurityAdvisoryPropIdentifiersItems

    An advisory identifier.
    """

    type: Literal["CVE", "GHSA"] = Field(description="The type of advisory identifier.")
    value: str = Field(description="The value of the advisory identifer.")


class DependabotAlertSecurityAdvisoryPropReferencesItems(GitHubModel):
    """DependabotAlertSecurityAdvisoryPropReferencesItems

    A link to additional advisory information.
    """

    url: str = Field(description="The URL of the reference.")


class SimpleRepository(GitHubModel):
    """Simple Repository

    A GitHub repository.
    """

    id: int = Field(description="A unique identifier of the repository.")
    node_id: str = Field(description="The GraphQL identifier of the repository.")
    name: str = Field(description="The name of the repository.")
    full_name: str = Field(
        description="The full, globally unique, name of the repository."
    )
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    private: bool = Field(description="Whether the repository is private.")
    html_url: str = Field(description="The URL to view the repository on GitHub.com.")
    description: Union[str, None] = Field(description="The repository description.")
    fork: bool = Field(description="Whether the repository is a fork.")
    url: str = Field(
        description="The URL to get more information about the repository from the GitHub API."
    )
    archive_url: str = Field(
        description="A template for the API URL to download the repository as an archive."
    )
    assignees_url: str = Field(
        description="A template for the API URL to list the available assignees for issues in the repository."
    )
    blobs_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git blob in the repository."
    )
    branches_url: str = Field(
        description="A template for the API URL to get information about branches in the repository."
    )
    collaborators_url: str = Field(
        description="A template for the API URL to get information about collaborators of the repository."
    )
    comments_url: str = Field(
        description="A template for the API URL to get information about comments on the repository."
    )
    commits_url: str = Field(
        description="A template for the API URL to get information about commits on the repository."
    )
    compare_url: str = Field(
        description="A template for the API URL to compare two commits or refs."
    )
    contents_url: str = Field(
        description="A template for the API URL to get the contents of the repository."
    )
    contributors_url: str = Field(
        description="A template for the API URL to list the contributors to the repository."
    )
    deployments_url: str = Field(
        description="The API URL to list the deployments of the repository."
    )
    downloads_url: str = Field(
        description="The API URL to list the downloads on the repository."
    )
    events_url: str = Field(
        description="The API URL to list the events of the repository."
    )
    forks_url: str = Field(
        description="The API URL to list the forks of the repository."
    )
    git_commits_url: str = Field(
        description="A template for the API URL to get information about Git commits of the repository."
    )
    git_refs_url: str = Field(
        description="A template for the API URL to get information about Git refs of the repository."
    )
    git_tags_url: str = Field(
        description="A template for the API URL to get information about Git tags of the repository."
    )
    issue_comment_url: str = Field(
        description="A template for the API URL to get information about issue comments on the repository."
    )
    issue_events_url: str = Field(
        description="A template for the API URL to get information about issue events on the repository."
    )
    issues_url: str = Field(
        description="A template for the API URL to get information about issues on the repository."
    )
    keys_url: str = Field(
        description="A template for the API URL to get information about deploy keys on the repository."
    )
    labels_url: str = Field(
        description="A template for the API URL to get information about labels of the repository."
    )
    languages_url: str = Field(
        description="The API URL to get information about the languages of the repository."
    )
    merges_url: str = Field(
        description="The API URL to merge branches in the repository."
    )
    milestones_url: str = Field(
        description="A template for the API URL to get information about milestones of the repository."
    )
    notifications_url: str = Field(
        description="A template for the API URL to get information about notifications on the repository."
    )
    pulls_url: str = Field(
        description="A template for the API URL to get information about pull requests on the repository."
    )
    releases_url: str = Field(
        description="A template for the API URL to get information about releases on the repository."
    )
    stargazers_url: str = Field(
        description="The API URL to list the stargazers on the repository."
    )
    statuses_url: str = Field(
        description="A template for the API URL to get information about statuses of a commit."
    )
    subscribers_url: str = Field(
        description="The API URL to list the subscribers on the repository."
    )
    subscription_url: str = Field(
        description="The API URL to subscribe to notifications for this repository."
    )
    tags_url: str = Field(
        description="The API URL to get information about tags on the repository."
    )
    teams_url: str = Field(
        description="The API URL to list the teams on the repository."
    )
    trees_url: str = Field(
        description="A template for the API URL to create or retrieve a raw Git tree of the repository."
    )
    hooks_url: str = Field(
        description="The API URL to list the hooks on the repository."
    )


class DependabotAlertWithRepository(GitHubModel):
    """DependabotAlertWithRepository

    A Dependabot alert.
    """

    number: int = Field(description="The security alert number.")
    state: Literal["auto_dismissed", "dismissed", "fixed", "open"] = Field(
        description="The state of the Dependabot alert."
    )
    dependency: DependabotAlertWithRepositoryPropDependency = Field(
        description="Details for the vulnerable dependency."
    )
    security_advisory: DependabotAlertSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory."
    )
    security_vulnerability: DependabotAlertSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory."
    )
    url: str = Field(description="The REST API URL of the alert resource.")
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_by: Union[None, SimpleUser] = Field()
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ] = Field(description="The reason that the alert was dismissed.")
    dismissed_comment: Union[Annotated[str, Field(max_length=280)], None] = Field(
        description="An optional comment associated with the alert's dismissal."
    )
    fixed_at: Union[datetime, None] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    auto_dismissed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that the alert was auto-dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    repository: SimpleRepository = Field(
        title="Simple Repository", description="A GitHub repository."
    )


class DependabotAlertWithRepositoryPropDependency(GitHubModel):
    """DependabotAlertWithRepositoryPropDependency

    Details for the vulnerable dependency.
    """

    package: Missing[DependabotAlertPackage] = Field(
        default=UNSET, description="Details for the vulnerable package."
    )
    manifest_path: Missing[str] = Field(
        default=UNSET,
        description="The full path to the dependency manifest file, relative to the root of the repository.",
    )
    scope: Missing[Union[None, Literal["development", "runtime"]]] = Field(
        default=UNSET, description="The execution scope of the vulnerable dependency."
    )


class OrganizationSecretScanningAlert(GitHubModel):
    """OrganizationSecretScanningAlert"""

    number: Missing[int] = Field(
        default=UNSET, description="The security alert number."
    )
    created_at: Missing[datetime] = Field(
        default=UNSET,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    updated_at: Missing[Union[None, datetime]] = Field(default=UNSET)
    url: Missing[str] = Field(
        default=UNSET, description="The REST API URL of the alert resource."
    )
    html_url: Missing[str] = Field(
        default=UNSET, description="The GitHub URL of the alert resource."
    )
    locations_url: Missing[str] = Field(
        default=UNSET,
        description="The REST API URL of the code locations for this alert.",
    )
    state: Missing[Literal["open", "resolved"]] = Field(
        default=UNSET,
        description="Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.",
    )
    resolution: Missing[
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]]
    ] = Field(
        default=UNSET,
        description="**Required when the `state` is `resolved`.** The reason for resolving the alert.",
    )
    resolved_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    resolved_by: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    secret_type: Missing[str] = Field(
        default=UNSET, description="The type of secret that secret scanning detected."
    )
    secret_type_display_name: Missing[str] = Field(
        default=UNSET,
        description='User-friendly name for the detected secret, matching the `secret_type`.\nFor a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."',
    )
    secret: Missing[str] = Field(
        default=UNSET, description="The secret that was detected."
    )
    repository: Missing[SimpleRepository] = Field(
        default=UNSET, title="Simple Repository", description="A GitHub repository."
    )
    push_protection_bypassed: Missing[Union[bool, None]] = Field(
        default=UNSET,
        description="Whether push protection was bypassed for the detected secret.",
    )
    push_protection_bypassed_by: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    push_protection_bypassed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    resolution_comment: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The comment that was optionally added when this alert was closed",
    )
    validity: Missing[Literal["active", "inactive", "unknown"]] = Field(
        default=UNSET, description="The token status as of the latest validity check."
    )


class Actor(GitHubModel):
    """Actor

    Actor
    """

    id: int = Field()
    login: str = Field()
    display_login: Missing[str] = Field(default=UNSET)
    gravatar_id: Union[str, None] = Field()
    url: str = Field()
    avatar_url: str = Field()


class Milestone(GitHubModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    url: str = Field()
    html_url: str = Field()
    labels_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    state: Literal["open", "closed"] = Field(
        default="open", description="The state of the milestone."
    )
    title: str = Field(description="The title of the milestone.")
    description: Union[str, None] = Field()
    creator: Union[None, SimpleUser] = Field()
    open_issues: int = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    closed_at: Union[datetime, None] = Field()
    due_on: Union[datetime, None] = Field()


class ReactionRollup(GitHubModel):
    """Reaction Rollup"""

    url: str = Field()
    total_count: int = Field()
    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    laugh: int = Field()
    confused: int = Field()
    heart: int = Field()
    hooray: int = Field()
    eyes: int = Field()
    rocket: int = Field()


class Issue(GitHubModel):
    """Issue

    Issues are a great way to keep track of tasks, enhancements, and bugs for your
    projects.
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field(description="URL for the issue")
    repository_url: str = Field()
    labels_url: str = Field()
    comments_url: str = Field()
    events_url: str = Field()
    html_url: str = Field()
    number: int = Field(
        description="Number uniquely identifying the issue within its repository"
    )
    state: str = Field(description="State of the issue; either 'open' or 'closed'")
    state_reason: Missing[
        Union[None, Literal["completed", "reopened", "not_planned"]]
    ] = Field(default=UNSET, description="The reason for the current state")
    title: str = Field(description="Title of the issue")
    body: Missing[Union[str, None]] = Field(
        default=UNSET, description="Contents of the issue"
    )
    user: Union[None, SimpleUser] = Field()
    labels: List[Union[str, IssuePropLabelsItemsOneof1]] = Field(
        description="Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository"
    )
    assignee: Union[None, SimpleUser] = Field()
    assignees: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    milestone: Union[None, Milestone] = Field()
    locked: bool = Field()
    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    comments: int = Field()
    pull_request: Missing[IssuePropPullRequest] = Field(default=UNSET)
    closed_at: Union[datetime, None] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    draft: Missing[bool] = Field(default=UNSET)
    closed_by: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    body_html: Missing[Union[str, None]] = Field(default=UNSET)
    body_text: Missing[Union[str, None]] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    repository: Missing[Repository] = Field(
        default=UNSET, title="Repository", description="A repository on GitHub."
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(default=UNSET)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")


class IssuePropLabelsItemsOneof1(GitHubModel):
    """IssuePropLabelsItemsOneof1"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    color: Missing[Union[str, None]] = Field(default=UNSET)
    default: Missing[bool] = Field(default=UNSET)


class IssuePropPullRequest(GitHubModel):
    """IssuePropPullRequest"""

    merged_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    diff_url: Union[str, None] = Field()
    html_url: Union[str, None] = Field()
    patch_url: Union[str, None] = Field()
    url: Union[str, None] = Field()


class IssueComment(GitHubModel):
    """Issue Comment

    Comments provide a way for people to collaborate on an issue.
    """

    id: int = Field(description="Unique identifier of the issue comment")
    node_id: str = Field()
    url: str = Field(description="URL for the issue comment")
    body: Missing[str] = Field(
        default=UNSET, description="Contents of the issue comment"
    )
    body_text: Missing[str] = Field(default=UNSET)
    body_html: Missing[str] = Field(default=UNSET)
    html_url: str = Field()
    user: Union[None, SimpleUser] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    issue_url: str = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(default=UNSET)
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")


class Event(GitHubModel):
    """Event

    Event
    """

    id: str = Field()
    type: Union[str, None] = Field()
    actor: Actor = Field(title="Actor", description="Actor")
    repo: EventPropRepo = Field()
    org: Missing[Actor] = Field(default=UNSET, title="Actor", description="Actor")
    payload: EventPropPayload = Field()
    public: bool = Field()
    created_at: Union[datetime, None] = Field()


class EventPropRepo(GitHubModel):
    """EventPropRepo"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class EventPropPayload(GitHubModel):
    """EventPropPayload"""

    action: Missing[str] = Field(default=UNSET)
    issue: Missing[Issue] = Field(
        default=UNSET,
        title="Issue",
        description="Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.",
    )
    comment: Missing[IssueComment] = Field(
        default=UNSET,
        title="Issue Comment",
        description="Comments provide a way for people to collaborate on an issue.",
    )
    pages: Missing[List[EventPropPayloadPropPagesItems]] = Field(default=UNSET)


class EventPropPayloadPropPagesItems(GitHubModel):
    """EventPropPayloadPropPagesItems"""

    page_name: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    summary: Missing[Union[str, None]] = Field(default=UNSET)
    action: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)


class LinkWithType(GitHubModel):
    """Link With Type

    Hypermedia Link with Type
    """

    href: str = Field()
    type: str = Field()


class Feed(GitHubModel):
    """Feed

    Feed
    """

    timeline_url: str = Field()
    user_url: str = Field()
    current_user_public_url: Missing[str] = Field(default=UNSET)
    current_user_url: Missing[str] = Field(default=UNSET)
    current_user_actor_url: Missing[str] = Field(default=UNSET)
    current_user_organization_url: Missing[str] = Field(default=UNSET)
    current_user_organization_urls: Missing[List[str]] = Field(default=UNSET)
    security_advisories_url: Missing[str] = Field(default=UNSET)
    repository_discussions_url: Missing[str] = Field(
        default=UNSET, description="A feed of discussions for a given repository."
    )
    repository_discussions_category_url: Missing[str] = Field(
        default=UNSET,
        description="A feed of discussions for a given repository and category.",
    )
    links: FeedPropLinks = Field(alias="_links")


class FeedPropLinks(GitHubModel):
    """FeedPropLinks"""

    timeline: LinkWithType = Field(
        title="Link With Type", description="Hypermedia Link with Type"
    )
    user: LinkWithType = Field(
        title="Link With Type", description="Hypermedia Link with Type"
    )
    security_advisories: Missing[LinkWithType] = Field(
        default=UNSET, title="Link With Type", description="Hypermedia Link with Type"
    )
    current_user: Missing[LinkWithType] = Field(
        default=UNSET, title="Link With Type", description="Hypermedia Link with Type"
    )
    current_user_public: Missing[LinkWithType] = Field(
        default=UNSET, title="Link With Type", description="Hypermedia Link with Type"
    )
    current_user_actor: Missing[LinkWithType] = Field(
        default=UNSET, title="Link With Type", description="Hypermedia Link with Type"
    )
    current_user_organization: Missing[LinkWithType] = Field(
        default=UNSET, title="Link With Type", description="Hypermedia Link with Type"
    )
    current_user_organizations: Missing[List[LinkWithType]] = Field(default=UNSET)
    repository_discussions: Missing[LinkWithType] = Field(
        default=UNSET, title="Link With Type", description="Hypermedia Link with Type"
    )
    repository_discussions_category: Missing[LinkWithType] = Field(
        default=UNSET, title="Link With Type", description="Hypermedia Link with Type"
    )


class BaseGist(GitHubModel):
    """Base Gist

    Base Gist
    """

    url: str = Field()
    forks_url: str = Field()
    commits_url: str = Field()
    id: str = Field()
    node_id: str = Field()
    git_pull_url: str = Field()
    git_push_url: str = Field()
    html_url: str = Field()
    files: BaseGistPropFiles = Field()
    public: bool = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    description: Union[str, None] = Field()
    comments: int = Field()
    user: Union[None, SimpleUser] = Field()
    comments_url: str = Field()
    owner: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )
    truncated: Missing[bool] = Field(default=UNSET)
    forks: Missing[List[Any]] = Field(default=UNSET)
    history: Missing[List[Any]] = Field(default=UNSET)


class BaseGistPropFiles(ExtraGitHubModel):
    """BaseGistPropFiles"""


class PublicUser(GitHubModel):
    """Public User

    Public User
    """

    login: str = Field()
    id: int = Field()
    node_id: str = Field()
    avatar_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    url: str = Field()
    html_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    starred_url: str = Field()
    subscriptions_url: str = Field()
    organizations_url: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    received_events_url: str = Field()
    type: str = Field()
    site_admin: bool = Field()
    name: Union[str, None] = Field()
    company: Union[str, None] = Field()
    blog: Union[str, None] = Field()
    location: Union[str, None] = Field()
    email: Union[str, None] = Field()
    hireable: Union[bool, None] = Field()
    bio: Union[str, None] = Field()
    twitter_username: Missing[Union[str, None]] = Field(default=UNSET)
    public_repos: int = Field()
    public_gists: int = Field()
    followers: int = Field()
    following: int = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    plan: Missing[PublicUserPropPlan] = Field(default=UNSET)
    suspended_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    private_gists: Missing[int] = Field(default=UNSET)
    total_private_repos: Missing[int] = Field(default=UNSET)
    owned_private_repos: Missing[int] = Field(default=UNSET)
    disk_usage: Missing[int] = Field(default=UNSET)
    collaborators: Missing[int] = Field(default=UNSET)


class PublicUserPropPlan(GitHubModel):
    """PublicUserPropPlan"""

    collaborators: int = Field()
    name: str = Field()
    space: int = Field()
    private_repos: int = Field()


class GistHistory(GitHubModel):
    """Gist History

    Gist History
    """

    user: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    version: Missing[str] = Field(default=UNSET)
    committed_at: Missing[datetime] = Field(default=UNSET)
    change_status: Missing[GistHistoryPropChangeStatus] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class GistHistoryPropChangeStatus(GitHubModel):
    """GistHistoryPropChangeStatus"""

    total: Missing[int] = Field(default=UNSET)
    additions: Missing[int] = Field(default=UNSET)
    deletions: Missing[int] = Field(default=UNSET)


class GistSimple(GitHubModel):
    """Gist Simple

    Gist Simple
    """

    forks: Missing[Union[List[GistSimplePropForksItems], None]] = Field(default=UNSET)
    history: Missing[Union[List[GistHistory], None]] = Field(default=UNSET)
    fork_of: Missing[Union[GistSimplePropForkOf, None]] = Field(
        default=UNSET, title="Gist", description="Gist"
    )
    url: Missing[str] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    id: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    git_pull_url: Missing[str] = Field(default=UNSET)
    git_push_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    files: Missing[GistSimplePropFiles] = Field(default=UNSET)
    public: Missing[bool] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    comments: Missing[int] = Field(default=UNSET)
    user: Missing[Union[str, None]] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    owner: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )
    truncated: Missing[bool] = Field(default=UNSET)


class GistSimplePropForksItems(GitHubModel):
    """GistSimplePropForksItems"""

    id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user: Missing[PublicUser] = Field(
        default=UNSET, title="Public User", description="Public User"
    )
    created_at: Missing[datetime] = Field(default=UNSET)
    updated_at: Missing[datetime] = Field(default=UNSET)


class GistSimplePropForkOfPropFiles(ExtraGitHubModel):
    """GistSimplePropForkOfPropFiles"""


class GistSimplePropForkOf(GitHubModel):
    """Gist

    Gist
    """

    url: str = Field()
    forks_url: str = Field()
    commits_url: str = Field()
    id: str = Field()
    node_id: str = Field()
    git_pull_url: str = Field()
    git_push_url: str = Field()
    html_url: str = Field()
    files: GistSimplePropForkOfPropFiles = Field()
    public: bool = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    description: Union[str, None] = Field()
    comments: int = Field()
    user: Union[None, SimpleUser] = Field()
    comments_url: str = Field()
    owner: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    truncated: Missing[bool] = Field(default=UNSET)
    forks: Missing[List[Any]] = Field(default=UNSET)
    history: Missing[List[Any]] = Field(default=UNSET)


class GistSimplePropFiles(ExtraGitHubModel):
    """GistSimplePropFiles"""


class GistComment(GitHubModel):
    """Gist Comment

    A comment made to a gist.
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    body: Annotated[str, Field(max_length=65535)] = Field(
        description="The comment text."
    )
    user: Union[None, SimpleUser] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )


class GistCommit(GitHubModel):
    """Gist Commit

    Gist Commit
    """

    url: str = Field()
    version: str = Field()
    user: Union[None, SimpleUser] = Field()
    change_status: GistCommitPropChangeStatus = Field()
    committed_at: datetime = Field()


class GistCommitPropChangeStatus(GitHubModel):
    """GistCommitPropChangeStatus"""

    total: Missing[int] = Field(default=UNSET)
    additions: Missing[int] = Field(default=UNSET)
    deletions: Missing[int] = Field(default=UNSET)


class GitignoreTemplate(GitHubModel):
    """Gitignore Template

    Gitignore Template
    """

    name: str = Field()
    source: str = Field()


class License(GitHubModel):
    """License

    License
    """

    key: str = Field()
    name: str = Field()
    spdx_id: Union[str, None] = Field()
    url: Union[str, None] = Field()
    node_id: str = Field()
    html_url: str = Field()
    description: str = Field()
    implementation: str = Field()
    permissions: List[str] = Field()
    conditions: List[str] = Field()
    limitations: List[str] = Field()
    body: str = Field()
    featured: bool = Field()


class MarketplaceListingPlan(GitHubModel):
    """Marketplace Listing Plan

    Marketplace Listing Plan
    """

    url: str = Field()
    accounts_url: str = Field()
    id: int = Field()
    number: int = Field()
    name: str = Field()
    description: str = Field()
    monthly_price_in_cents: int = Field()
    yearly_price_in_cents: int = Field()
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"] = Field()
    has_free_trial: bool = Field()
    unit_name: Union[str, None] = Field()
    state: str = Field()
    bullets: List[str] = Field()


class MarketplacePurchase(GitHubModel):
    """Marketplace Purchase

    Marketplace Purchase
    """

    url: str = Field()
    type: str = Field()
    id: int = Field()
    login: str = Field()
    organization_billing_email: Missing[str] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    marketplace_pending_change: Missing[
        Union[MarketplacePurchasePropMarketplacePendingChange, None]
    ] = Field(default=UNSET)
    marketplace_purchase: MarketplacePurchasePropMarketplacePurchase = Field()


class MarketplacePurchasePropMarketplacePendingChange(GitHubModel):
    """MarketplacePurchasePropMarketplacePendingChange"""

    is_installed: Missing[bool] = Field(default=UNSET)
    effective_date: Missing[str] = Field(default=UNSET)
    unit_count: Missing[Union[int, None]] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    plan: Missing[MarketplaceListingPlan] = Field(
        default=UNSET,
        title="Marketplace Listing Plan",
        description="Marketplace Listing Plan",
    )


class MarketplacePurchasePropMarketplacePurchase(GitHubModel):
    """MarketplacePurchasePropMarketplacePurchase"""

    billing_cycle: Missing[str] = Field(default=UNSET)
    next_billing_date: Missing[Union[str, None]] = Field(default=UNSET)
    is_installed: Missing[bool] = Field(default=UNSET)
    unit_count: Missing[Union[int, None]] = Field(default=UNSET)
    on_free_trial: Missing[bool] = Field(default=UNSET)
    free_trial_ends_on: Missing[Union[str, None]] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    plan: Missing[MarketplaceListingPlan] = Field(
        default=UNSET,
        title="Marketplace Listing Plan",
        description="Marketplace Listing Plan",
    )


class ApiOverview(GitHubModel):
    """Api Overview

    Api Overview
    """

    verifiable_password_authentication: bool = Field()
    ssh_key_fingerprints: Missing[ApiOverviewPropSshKeyFingerprints] = Field(
        default=UNSET
    )
    ssh_keys: Missing[List[str]] = Field(default=UNSET)
    hooks: Missing[List[str]] = Field(default=UNSET)
    github_enterprise_importer: Missing[List[str]] = Field(default=UNSET)
    web: Missing[List[str]] = Field(default=UNSET)
    api: Missing[List[str]] = Field(default=UNSET)
    git: Missing[List[str]] = Field(default=UNSET)
    packages: Missing[List[str]] = Field(default=UNSET)
    pages: Missing[List[str]] = Field(default=UNSET)
    importer: Missing[List[str]] = Field(default=UNSET)
    actions: Missing[List[str]] = Field(default=UNSET)
    dependabot: Missing[List[str]] = Field(default=UNSET)
    domains: Missing[ApiOverviewPropDomains] = Field(default=UNSET)


class ApiOverviewPropSshKeyFingerprints(GitHubModel):
    """ApiOverviewPropSshKeyFingerprints"""

    sha256_rsa: Missing[str] = Field(default=UNSET, alias="SHA256_RSA")
    sha256_dsa: Missing[str] = Field(default=UNSET, alias="SHA256_DSA")
    sha256_ecdsa: Missing[str] = Field(default=UNSET, alias="SHA256_ECDSA")
    sha256_ed25519: Missing[str] = Field(default=UNSET, alias="SHA256_ED25519")


class ApiOverviewPropDomains(GitHubModel):
    """ApiOverviewPropDomains"""

    website: Missing[List[str]] = Field(default=UNSET)
    codespaces: Missing[List[str]] = Field(default=UNSET)
    copilot: Missing[List[str]] = Field(default=UNSET)
    packages: Missing[List[str]] = Field(default=UNSET)
    actions: Missing[List[str]] = Field(default=UNSET)


class SecurityAndAnalysisPropAdvancedSecurity(GitHubModel):
    """SecurityAndAnalysisPropAdvancedSecurity"""

    status: Missing[Literal["enabled", "disabled"]] = Field(default=UNSET)


class SecurityAndAnalysisPropDependabotSecurityUpdates(GitHubModel):
    """SecurityAndAnalysisPropDependabotSecurityUpdates

    Enable or disable Dependabot security updates for the repository.
    """

    status: Missing[Literal["enabled", "disabled"]] = Field(
        default=UNSET,
        description="The enablement status of Dependabot security updates for the repository.",
    )


class SecurityAndAnalysisPropSecretScanning(GitHubModel):
    """SecurityAndAnalysisPropSecretScanning"""

    status: Missing[Literal["enabled", "disabled"]] = Field(default=UNSET)


class SecurityAndAnalysisPropSecretScanningPushProtection(GitHubModel):
    """SecurityAndAnalysisPropSecretScanningPushProtection"""

    status: Missing[Literal["enabled", "disabled"]] = Field(default=UNSET)


class SecurityAndAnalysis(GitHubModel):
    """SecurityAndAnalysis"""

    advanced_security: Missing[SecurityAndAnalysisPropAdvancedSecurity] = Field(
        default=UNSET
    )
    dependabot_security_updates: Missing[
        SecurityAndAnalysisPropDependabotSecurityUpdates
    ] = Field(
        default=UNSET,
        description="Enable or disable Dependabot security updates for the repository.",
    )
    secret_scanning: Missing[SecurityAndAnalysisPropSecretScanning] = Field(
        default=UNSET
    )
    secret_scanning_push_protection: Missing[
        SecurityAndAnalysisPropSecretScanningPushProtection
    ] = Field(default=UNSET)


class MinimalRepository(GitHubModel):
    """Minimal Repository

    Minimal Repository
    """

    id: int = Field()
    node_id: str = Field()
    name: str = Field()
    full_name: str = Field()
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    private: bool = Field()
    html_url: str = Field()
    description: Union[str, None] = Field()
    fork: bool = Field()
    url: str = Field()
    archive_url: str = Field()
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    deployments_url: str = Field()
    downloads_url: str = Field()
    events_url: str = Field()
    forks_url: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: Missing[str] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    languages_url: str = Field()
    merges_url: str = Field()
    milestones_url: str = Field()
    notifications_url: str = Field()
    pulls_url: str = Field()
    releases_url: str = Field()
    ssh_url: Missing[str] = Field(default=UNSET)
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    trees_url: str = Field()
    clone_url: Missing[str] = Field(default=UNSET)
    mirror_url: Missing[Union[str, None]] = Field(default=UNSET)
    hooks_url: str = Field()
    svn_url: Missing[str] = Field(default=UNSET)
    homepage: Missing[Union[str, None]] = Field(default=UNSET)
    language: Missing[Union[str, None]] = Field(default=UNSET)
    forks_count: Missing[int] = Field(default=UNSET)
    stargazers_count: Missing[int] = Field(default=UNSET)
    watchers_count: Missing[int] = Field(default=UNSET)
    size: Missing[int] = Field(
        default=UNSET,
        description="The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0.",
    )
    default_branch: Missing[str] = Field(default=UNSET)
    open_issues_count: Missing[int] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: Missing[bool] = Field(default=UNSET)
    has_projects: Missing[bool] = Field(default=UNSET)
    has_wiki: Missing[bool] = Field(default=UNSET)
    has_pages: Missing[bool] = Field(default=UNSET)
    has_downloads: Missing[bool] = Field(default=UNSET)
    has_discussions: Missing[bool] = Field(default=UNSET)
    archived: Missing[bool] = Field(default=UNSET)
    disabled: Missing[bool] = Field(default=UNSET)
    visibility: Missing[str] = Field(default=UNSET)
    pushed_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    created_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    updated_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    permissions: Missing[MinimalRepositoryPropPermissions] = Field(default=UNSET)
    role_name: Missing[str] = Field(default=UNSET)
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)
    code_of_conduct: Missing[CodeOfConduct] = Field(
        default=UNSET, title="Code Of Conduct", description="Code Of Conduct"
    )
    license_: Missing[Union[MinimalRepositoryPropLicense, None]] = Field(
        default=UNSET, alias="license"
    )
    forks: Missing[int] = Field(default=UNSET)
    open_issues: Missing[int] = Field(default=UNSET)
    watchers: Missing[int] = Field(default=UNSET)
    allow_forking: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)
    security_and_analysis: Missing[Union[SecurityAndAnalysis, None]] = Field(
        default=UNSET
    )


class MinimalRepositoryPropPermissions(GitHubModel):
    """MinimalRepositoryPropPermissions"""

    admin: Missing[bool] = Field(default=UNSET)
    maintain: Missing[bool] = Field(default=UNSET)
    push: Missing[bool] = Field(default=UNSET)
    triage: Missing[bool] = Field(default=UNSET)
    pull: Missing[bool] = Field(default=UNSET)


class MinimalRepositoryPropLicense(GitHubModel):
    """MinimalRepositoryPropLicense"""

    key: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    spdx_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)


class Thread(GitHubModel):
    """Thread

    Thread
    """

    id: str = Field()
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )
    subject: ThreadPropSubject = Field()
    reason: str = Field()
    unread: bool = Field()
    updated_at: str = Field()
    last_read_at: Union[str, None] = Field()
    url: str = Field()
    subscription_url: str = Field()


class ThreadPropSubject(GitHubModel):
    """ThreadPropSubject"""

    title: str = Field()
    url: str = Field()
    latest_comment_url: str = Field()
    type: str = Field()


class ThreadSubscription(GitHubModel):
    """Thread Subscription

    Thread Subscription
    """

    subscribed: bool = Field()
    ignored: bool = Field()
    reason: Union[str, None] = Field()
    created_at: Union[datetime, None] = Field()
    url: str = Field()
    thread_url: Missing[str] = Field(default=UNSET)
    repository_url: Missing[str] = Field(default=UNSET)


class OrganizationSimple(GitHubModel):
    """Organization Simple

    A GitHub organization.
    """

    login: str = Field()
    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    hooks_url: str = Field()
    issues_url: str = Field()
    members_url: str = Field()
    public_members_url: str = Field()
    avatar_url: str = Field()
    description: Union[str, None] = Field()


class OrganizationFull(GitHubModel):
    """Organization Full

    Organization Full
    """

    login: str = Field()
    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    hooks_url: str = Field()
    issues_url: str = Field()
    members_url: str = Field()
    public_members_url: str = Field()
    avatar_url: str = Field()
    description: Union[str, None] = Field()
    name: Missing[Union[str, None]] = Field(default=UNSET)
    company: Missing[Union[str, None]] = Field(default=UNSET)
    blog: Missing[Union[str, None]] = Field(default=UNSET)
    location: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    twitter_username: Missing[Union[str, None]] = Field(default=UNSET)
    is_verified: Missing[bool] = Field(default=UNSET)
    has_organization_projects: bool = Field()
    has_repository_projects: bool = Field()
    public_repos: int = Field()
    public_gists: int = Field()
    followers: int = Field()
    following: int = Field()
    html_url: str = Field()
    type: str = Field()
    total_private_repos: Missing[int] = Field(default=UNSET)
    owned_private_repos: Missing[int] = Field(default=UNSET)
    private_gists: Missing[Union[int, None]] = Field(default=UNSET)
    disk_usage: Missing[Union[int, None]] = Field(default=UNSET)
    collaborators: Missing[Union[int, None]] = Field(default=UNSET)
    billing_email: Missing[Union[str, None]] = Field(default=UNSET)
    plan: Missing[OrganizationFullPropPlan] = Field(default=UNSET)
    default_repository_permission: Missing[Union[str, None]] = Field(default=UNSET)
    members_can_create_repositories: Missing[Union[bool, None]] = Field(default=UNSET)
    two_factor_requirement_enabled: Missing[Union[bool, None]] = Field(default=UNSET)
    members_allowed_repository_creation_type: Missing[str] = Field(default=UNSET)
    members_can_create_public_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_private_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_internal_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_pages: Missing[bool] = Field(default=UNSET)
    members_can_create_public_pages: Missing[bool] = Field(default=UNSET)
    members_can_create_private_pages: Missing[bool] = Field(default=UNSET)
    members_can_fork_private_repositories: Missing[Union[bool, None]] = Field(
        default=UNSET
    )
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)
    advanced_security_enabled_for_new_repositories: Missing[bool] = Field(
        default=UNSET,
        description="Whether GitHub Advanced Security is enabled for new repositories and repositories transferred to this organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
    )
    dependabot_alerts_enabled_for_new_repositories: Missing[bool] = Field(
        default=UNSET,
        description="Whether GitHub Advanced Security is automatically enabled for new repositories and repositories transferred to\nthis organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
    )
    dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = Field(
        default=UNSET,
        description="Whether dependabot security updates are automatically enabled for new repositories and repositories transferred\nto this organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
    )
    dependency_graph_enabled_for_new_repositories: Missing[bool] = Field(
        default=UNSET,
        description="Whether dependency graph is automatically enabled for new repositories and repositories transferred to this\norganization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
    )
    secret_scanning_enabled_for_new_repositories: Missing[bool] = Field(
        default=UNSET,
        description="Whether secret scanning is automatically enabled for new repositories and repositories transferred to this\norganization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
    )
    secret_scanning_push_protection_enabled_for_new_repositories: Missing[bool] = Field(
        default=UNSET,
        description="Whether secret scanning push protection is automatically enabled for new repositories and repositories\ntransferred to this organization.\n\nThis field is only visible to organization owners or members of a team with the security manager role.",
    )
    secret_scanning_push_protection_custom_link_enabled: Missing[bool] = Field(
        default=UNSET,
        description="Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.",
    )
    secret_scanning_push_protection_custom_link: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="An optional URL string to display to contributors who are blocked from pushing a secret.",
    )
    created_at: datetime = Field()
    updated_at: datetime = Field()
    archived_at: Union[datetime, None] = Field()


class OrganizationFullPropPlan(GitHubModel):
    """OrganizationFullPropPlan"""

    name: str = Field()
    space: int = Field()
    private_repos: int = Field()
    filled_seats: Missing[int] = Field(default=UNSET)
    seats: Missing[int] = Field(default=UNSET)


class ActionsCacheUsageOrgEnterprise(GitHubModel):
    """ActionsCacheUsageOrgEnterprise"""

    total_active_caches_count: int = Field(
        description="The count of active caches across all repositories of an enterprise or an organization."
    )
    total_active_caches_size_in_bytes: int = Field(
        description="The total size in bytes of all active cache items across all repositories of an enterprise or an organization."
    )


class ActionsCacheUsageByRepository(GitHubModel):
    """Actions Cache Usage by repository

    GitHub Actions Cache Usage by repository.
    """

    full_name: str = Field(
        description="The repository owner and name for the cache usage being shown."
    )
    active_caches_size_in_bytes: int = Field(
        description="The sum of the size in bytes of all the active cache items in the repository."
    )
    active_caches_count: int = Field(
        description="The number of active caches in the repository."
    )


class OidcCustomSub(GitHubModel):
    """Actions OIDC Subject customization

    Actions OIDC Subject customization
    """

    include_claim_keys: List[str] = Field(
        description="Array of unique strings. Each claim key can only contain alphanumeric characters and underscores."
    )


class EmptyObject(GitHubModel):
    """Empty Object

    An object without any properties.
    """


class ActionsOrganizationPermissions(GitHubModel):
    """ActionsOrganizationPermissions"""

    enabled_repositories: Literal["all", "none", "selected"] = Field(
        description="The policy that controls the repositories in the organization that are allowed to run GitHub Actions."
    )
    selected_repositories_url: Missing[str] = Field(
        default=UNSET,
        description="The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.",
    )
    allowed_actions: Missing[Literal["all", "local_only", "selected"]] = Field(
        default=UNSET,
        description="The permissions policy that controls the actions and reusable workflows that are allowed to run.",
    )
    selected_actions_url: Missing[str] = Field(
        default=UNSET,
        description="The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.",
    )


class SelectedActions(GitHubModel):
    """SelectedActions"""

    github_owned_allowed: Missing[bool] = Field(
        default=UNSET,
        description="Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.",
    )
    verified_allowed: Missing[bool] = Field(
        default=UNSET,
        description="Whether actions from GitHub Marketplace verified creators are allowed. Set to `true` to allow all actions by GitHub Marketplace verified creators.",
    )
    patterns_allowed: Missing[List[str]] = Field(
        default=UNSET,
        description="Specifies a list of string-matching patterns to allow specific action(s) and reusable workflow(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`.\n\n**Note**: The `patterns_allowed` setting only applies to public repositories.",
    )


class ActionsGetDefaultWorkflowPermissions(GitHubModel):
    """ActionsGetDefaultWorkflowPermissions"""

    default_workflow_permissions: Literal["read", "write"] = Field(
        description="The default workflow permissions granted to the GITHUB_TOKEN when running workflows."
    )
    can_approve_pull_request_reviews: bool = Field(
        description="Whether GitHub Actions can approve pull requests. Enabling this can be a security risk."
    )


class ActionsSetDefaultWorkflowPermissions(GitHubModel):
    """ActionsSetDefaultWorkflowPermissions"""

    default_workflow_permissions: Missing[Literal["read", "write"]] = Field(
        default=UNSET,
        description="The default workflow permissions granted to the GITHUB_TOKEN when running workflows.",
    )
    can_approve_pull_request_reviews: Missing[bool] = Field(
        default=UNSET,
        description="Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.",
    )


class RunnerLabel(GitHubModel):
    """Self hosted runner label

    A label for a self hosted runner
    """

    id: Missing[int] = Field(
        default=UNSET, description="Unique identifier of the label."
    )
    name: str = Field(description="Name of the label.")
    type: Missing[Literal["read-only", "custom"]] = Field(
        default=UNSET,
        description="The type of label. Read-only labels are applied automatically when the runner is configured.",
    )


class Runner(GitHubModel):
    """Self hosted runners

    A self hosted runner
    """

    id: int = Field(description="The id of the runner.")
    runner_group_id: Missing[int] = Field(
        default=UNSET, description="The id of the runner group."
    )
    name: str = Field(description="The name of the runner.")
    os: str = Field(description="The Operating System of the runner.")
    status: str = Field(description="The status of the runner.")
    busy: bool = Field()
    labels: List[RunnerLabel] = Field()


class RunnerApplication(GitHubModel):
    """Runner Application

    Runner Application
    """

    os: str = Field()
    architecture: str = Field()
    download_url: str = Field()
    filename: str = Field()
    temp_download_token: Missing[str] = Field(
        default=UNSET,
        description="A short lived bearer token used to download the runner, if needed.",
    )
    sha256_checksum: Missing[str] = Field(default=UNSET)


class AuthenticationToken(GitHubModel):
    """Authentication Token

    Authentication Token
    """

    token: str = Field(description="The token used for authentication")
    expires_at: datetime = Field(description="The time this token expires")
    permissions: Missing[AuthenticationTokenPropPermissions] = Field(default=UNSET)
    repositories: Missing[List[Repository]] = Field(
        default=UNSET, description="The repositories this token has access to"
    )
    single_file: Missing[Union[str, None]] = Field(default=UNSET)
    repository_selection: Missing[Literal["all", "selected"]] = Field(
        default=UNSET,
        description="Describe whether all repositories have been selected or there's a selection involved",
    )


class AuthenticationTokenPropPermissions(GitHubModel):
    """AuthenticationTokenPropPermissions

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """


class OrganizationActionsSecret(GitHubModel):
    """Actions Secret for an Organization

    Secrets for GitHub Actions for an organization.
    """

    name: str = Field(description="The name of the secret.")
    created_at: datetime = Field()
    updated_at: datetime = Field()
    visibility: Literal["all", "private", "selected"] = Field(
        description="Visibility of a secret"
    )
    selected_repositories_url: Missing[str] = Field(default=UNSET)


class ActionsPublicKey(GitHubModel):
    """ActionsPublicKey

    The public key used for setting Actions Secrets.
    """

    key_id: str = Field(description="The identifier for the key.")
    key: str = Field(description="The Base64 encoded public key.")
    id: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)


class OrganizationActionsVariable(GitHubModel):
    """Actions Variable for an Organization

    Organization variable for GitHub Actions.
    """

    name: str = Field(description="The name of the variable.")
    value: str = Field(description="The value of the variable.")
    created_at: datetime = Field(
        description="The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )
    updated_at: datetime = Field(
        description="The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="Visibility of a variable"
    )
    selected_repositories_url: Missing[str] = Field(default=UNSET)


class CodeScanningAlertRuleSummary(GitHubModel):
    """CodeScanningAlertRuleSummary"""

    id: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="A unique identifier for the rule used to detect the alert.",
    )
    name: Missing[str] = Field(
        default=UNSET, description="The name of the rule used to detect the alert."
    )
    tags: Missing[Union[List[str], None]] = Field(
        default=UNSET, description="A set of tags applicable for the rule."
    )
    severity: Missing[Union[None, Literal["none", "note", "warning", "error"]]] = Field(
        default=UNSET, description="The severity of the alert."
    )
    security_severity_level: Missing[
        Union[None, Literal["low", "medium", "high", "critical"]]
    ] = Field(default=UNSET, description="The security severity of the alert.")
    description: Missing[str] = Field(
        default=UNSET,
        description="A short description of the rule used to detect the alert.",
    )


class CodeScanningAnalysisTool(GitHubModel):
    """CodeScanningAnalysisTool"""

    name: Missing[str] = Field(
        default=UNSET,
        description="The name of the tool used to generate the code scanning analysis.",
    )
    version: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The version of the tool used to generate the code scanning analysis.",
    )
    guid: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data.",
    )


class CodeScanningAlertLocation(GitHubModel):
    """CodeScanningAlertLocation

    Describe a region within a file for the alert.
    """

    path: Missing[str] = Field(default=UNSET)
    start_line: Missing[int] = Field(default=UNSET)
    end_line: Missing[int] = Field(default=UNSET)
    start_column: Missing[int] = Field(default=UNSET)
    end_column: Missing[int] = Field(default=UNSET)


class CodeScanningAlertInstance(GitHubModel):
    """CodeScanningAlertInstance"""

    ref: Missing[str] = Field(
        default=UNSET,
        description="The Git reference, formatted as `refs/pull/<number>/merge`, `refs/pull/<number>/head`,\n`refs/heads/<branch name>` or simply `<branch name>`.",
    )
    analysis_key: Missing[str] = Field(
        default=UNSET,
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.",
    )
    environment: Missing[str] = Field(
        default=UNSET,
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.",
    )
    category: Missing[str] = Field(
        default=UNSET,
        description="Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.",
    )
    state: Missing[Literal["open", "dismissed", "fixed"]] = Field(
        default=UNSET, description="State of a code scanning alert."
    )
    commit_sha: Missing[str] = Field(default=UNSET)
    message: Missing[CodeScanningAlertInstancePropMessage] = Field(default=UNSET)
    location: Missing[CodeScanningAlertLocation] = Field(
        default=UNSET, description="Describe a region within a file for the alert."
    )
    html_url: Missing[str] = Field(default=UNSET)
    classifications: Missing[
        List[Union[None, Literal["source", "generated", "test", "library"]]]
    ] = Field(
        default=UNSET,
        description="Classifications that have been applied to the file that triggered the alert.\nFor example identifying it as documentation, or a generated file.",
    )


class CodeScanningAlertInstancePropMessage(GitHubModel):
    """CodeScanningAlertInstancePropMessage"""

    text: Missing[str] = Field(default=UNSET)


class CodeScanningOrganizationAlertItems(GitHubModel):
    """CodeScanningOrganizationAlertItems"""

    number: int = Field(description="The security alert number.")
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    updated_at: Missing[datetime] = Field(
        default=UNSET,
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    url: str = Field(description="The REST API URL of the alert resource.")
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    instances_url: str = Field(
        description="The REST API URL for fetching the list of instances for an alert."
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )
    fixed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    dismissed_by: Union[None, SimpleUser] = Field()
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert."
    )
    dismissed_comment: Missing[
        Union[Annotated[str, Field(max_length=280)], None]
    ] = Field(
        default=UNSET,
        description="The dismissal comment associated with the dismissal of the alert.",
    )
    rule: CodeScanningAlertRuleSummary = Field()
    tool: CodeScanningAnalysisTool = Field()
    most_recent_instance: CodeScanningAlertInstance = Field()
    repository: SimpleRepository = Field(
        title="Simple Repository", description="A GitHub repository."
    )


class CodespaceMachine(GitHubModel):
    """Codespace machine

    A description of the machine powering a codespace.
    """

    name: str = Field(description="The name of the machine.")
    display_name: str = Field(
        description="The display name of the machine includes cores, memory, and storage."
    )
    operating_system: str = Field(description="The operating system of the machine.")
    storage_in_bytes: int = Field(
        description="How much storage is available to the codespace."
    )
    memory_in_bytes: int = Field(
        description="How much memory is available to the codespace."
    )
    cpus: int = Field(description="How many cores are available to the codespace.")
    prebuild_availability: Union[None, Literal["none", "ready", "in_progress"]] = Field(
        description='Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.'
    )


class Codespace(GitHubModel):
    """Codespace

    A codespace.
    """

    id: int = Field()
    name: str = Field(description="Automatically generated name of this codespace.")
    display_name: Missing[Union[str, None]] = Field(
        default=UNSET, description="Display name for this codespace."
    )
    environment_id: Union[str, None] = Field(
        description="UUID identifying this codespace's environment."
    )
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    billable_owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user."
    )
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )
    machine: Union[None, CodespaceMachine] = Field()
    devcontainer_path: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="Path to devcontainer.json from repo root used to create Codespace.",
    )
    prebuild: Union[bool, None] = Field(
        description="Whether the codespace was created from a prebuild."
    )
    created_at: datetime = Field()
    updated_at: datetime = Field()
    last_used_at: datetime = Field(
        description="Last known time this codespace was started."
    )
    state: Literal[
        "Unknown",
        "Created",
        "Queued",
        "Provisioning",
        "Available",
        "Awaiting",
        "Unavailable",
        "Deleted",
        "Moved",
        "Shutdown",
        "Archived",
        "Starting",
        "ShuttingDown",
        "Failed",
        "Exporting",
        "Updating",
        "Rebuilding",
    ] = Field(description="State of this codespace.")
    url: str = Field(description="API URL for this codespace.")
    git_status: CodespacePropGitStatus = Field(
        description="Details about the codespace's git repository."
    )
    location: Literal["EastUs", "SouthEastAsia", "WestEurope", "WestUs2"] = Field(
        description="The initally assigned location of a new codespace."
    )
    idle_timeout_minutes: Union[int, None] = Field(
        description="The number of minutes of inactivity after which this codespace will be automatically stopped."
    )
    web_url: str = Field(description="URL to access this codespace on the web.")
    machines_url: str = Field(
        description="API URL to access available alternate machine types for this codespace."
    )
    start_url: str = Field(description="API URL to start this codespace.")
    stop_url: str = Field(description="API URL to stop this codespace.")
    publish_url: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="API URL to publish this codespace to a new repository.",
    )
    pulls_url: Union[str, None] = Field(
        description="API URL for the Pull Request associated with this codespace, if any."
    )
    recent_folders: List[str] = Field()
    runtime_constraints: Missing[CodespacePropRuntimeConstraints] = Field(default=UNSET)
    pending_operation: Missing[Union[bool, None]] = Field(
        default=UNSET,
        description="Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.",
    )
    pending_operation_disabled_reason: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="Text to show user when codespace is disabled by a pending operation",
    )
    idle_timeout_notice: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="Text to show user when codespace idle timeout minutes has been overriden by an organization policy",
    )
    retention_period_minutes: Missing[Union[int, None]] = Field(
        default=UNSET,
        description="Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).",
    )
    retention_expires_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description='When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"',
    )
    last_known_stop_notice: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The text to display to a user when a codespace has been stopped for a potentially actionable reason.",
    )


class CodespacePropGitStatus(GitHubModel):
    """CodespacePropGitStatus

    Details about the codespace's git repository.
    """

    ahead: Missing[int] = Field(
        default=UNSET,
        description="The number of commits the local repository is ahead of the remote.",
    )
    behind: Missing[int] = Field(
        default=UNSET,
        description="The number of commits the local repository is behind the remote.",
    )
    has_unpushed_changes: Missing[bool] = Field(
        default=UNSET, description="Whether the local repository has unpushed changes."
    )
    has_uncommitted_changes: Missing[bool] = Field(
        default=UNSET,
        description="Whether the local repository has uncommitted changes.",
    )
    ref: Missing[str] = Field(
        default=UNSET,
        description="The current branch (or SHA if in detached HEAD state) of the local repository.",
    )


class CodespacePropRuntimeConstraints(GitHubModel):
    """CodespacePropRuntimeConstraints"""

    allowed_port_privacy_settings: Missing[Union[List[str], None]] = Field(
        default=UNSET,
        description="The privacy settings a user can select from when forwarding a port.",
    )


class CodespacesOrgSecret(GitHubModel):
    """Codespaces Secret

    Secrets for a GitHub Codespace.
    """

    name: str = Field(description="The name of the secret")
    created_at: datetime = Field(
        description="The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )
    updated_at: datetime = Field(
        description="The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="The type of repositories in the organization that the secret is visible to"
    )
    selected_repositories_url: Missing[str] = Field(
        default=UNSET,
        description="The API URL at which the list of repositories this secret is visible to can be retrieved",
    )


class CodespacesPublicKey(GitHubModel):
    """CodespacesPublicKey

    The public key used for setting Codespaces secrets.
    """

    key_id: str = Field(description="The identifier for the key.")
    key: str = Field(description="The Base64 encoded public key.")
    id: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)


class CopilotSeatBreakdown(GitHubModel):
    """Copilot Business Seat Breakdown

    The breakdown of Copilot Business seats for the organization.
    """

    total: Missing[int] = Field(
        default=UNSET,
        description="The total number of seats being billed for the organization as of the current billing cycle.",
    )
    added_this_cycle: Missing[int] = Field(
        default=UNSET, description="Seats added during the current billing cycle."
    )
    pending_cancellation: Missing[int] = Field(
        default=UNSET,
        description="The number of seats that are pending cancellation at the end of the current billing cycle.",
    )
    pending_invitation: Missing[int] = Field(
        default=UNSET,
        description="The number of seats that have been assigned to users that have not yet accepted an invitation to this organization.",
    )
    active_this_cycle: Missing[int] = Field(
        default=UNSET,
        description="The number of seats that have used Copilot during the current billing cycle.",
    )
    inactive_this_cycle: Missing[int] = Field(
        default=UNSET,
        description="The number of seats that have not used Copilot during the current billing cycle.",
    )


class CopilotOrganizationDetails(ExtraGitHubModel):
    """Copilot Business Organization Details

    Information about the seat breakdown and policies set for an organization with a
    Copilot Business subscription.
    """

    seat_breakdown: CopilotSeatBreakdown = Field(
        title="Copilot Business Seat Breakdown",
        description="The breakdown of Copilot Business seats for the organization.",
    )
    public_code_suggestions: Literal[
        "allow", "block", "unconfigured", "unknown"
    ] = Field(
        description="The organization policy for allowing or disallowing Copilot to make suggestions that match public code."
    )
    copilot_chat: Missing[Literal["enabled", "disabled", "unconfigured"]] = Field(
        default=UNSET,
        description="The organization policy for allowing or disallowing organization members to use Copilot Chat within their editor.",
    )
    seat_management_setting: Literal[
        "assign_all", "assign_selected", "disabled", "unconfigured"
    ] = Field(description="The mode of assigning new seats.")


class TeamSimple(GitHubModel):
    """Team Simple

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int = Field(description="Unique identifier of the team")
    node_id: str = Field()
    url: str = Field(description="URL for the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    description: Union[str, None] = Field(description="Description of the team")
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Missing[str] = Field(
        default=UNSET, description="The level of privacy this team should have"
    )
    notification_setting: Missing[str] = Field(
        default=UNSET, description="The notification setting the team has set"
    )
    html_url: str = Field()
    repositories_url: str = Field()
    slug: str = Field()
    ldap_dn: Missing[str] = Field(
        default=UNSET,
        description="Distinguished Name (DN) that team maps to within LDAP environment",
    )


class Team(GitHubModel):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int = Field()
    node_id: str = Field()
    name: str = Field()
    slug: str = Field()
    description: Union[str, None] = Field()
    privacy: Missing[str] = Field(default=UNSET)
    notification_setting: Missing[str] = Field(default=UNSET)
    permission: str = Field()
    permissions: Missing[TeamPropPermissions] = Field(default=UNSET)
    url: str = Field()
    html_url: str = Field()
    members_url: str = Field()
    repositories_url: str = Field()
    parent: Union[None, TeamSimple] = Field()


class TeamPropPermissions(GitHubModel):
    """TeamPropPermissions"""

    pull: bool = Field()
    triage: bool = Field()
    push: bool = Field()
    maintain: bool = Field()
    admin: bool = Field()


class Organization(GitHubModel):
    """Organization

    GitHub account for managing multiple users, teams, and repositories
    """

    login: str = Field(description="Unique login name of the organization")
    url: str = Field(description="URL for the organization")
    id: int = Field()
    node_id: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    hooks_url: str = Field()
    issues_url: str = Field()
    members_url: str = Field()
    public_members_url: str = Field()
    avatar_url: str = Field()
    description: Union[str, None] = Field()
    blog: Missing[str] = Field(
        default=UNSET, description="Display blog url for the organization"
    )
    html_url: str = Field()
    name: Missing[str] = Field(
        default=UNSET, description="Display name for the organization"
    )
    company: Missing[str] = Field(
        default=UNSET, description="Display company name for the organization"
    )
    location: Missing[str] = Field(
        default=UNSET, description="Display location for the organization"
    )
    email: Missing[str] = Field(
        default=UNSET, description="Display email for the organization"
    )
    has_organization_projects: bool = Field(
        description="Specifies if organization projects are enabled for this org"
    )
    has_repository_projects: bool = Field(
        description="Specifies if repository projects are enabled for repositories that belong to this org"
    )
    is_verified: Missing[bool] = Field(default=UNSET)
    public_repos: int = Field()
    public_gists: int = Field()
    followers: int = Field()
    following: int = Field()
    type: str = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    plan: Missing[OrganizationPropPlan] = Field(default=UNSET)


class OrganizationPropPlan(GitHubModel):
    """OrganizationPropPlan"""

    name: Missing[str] = Field(default=UNSET)
    space: Missing[int] = Field(default=UNSET)
    private_repos: Missing[int] = Field(default=UNSET)
    filled_seats: Missing[int] = Field(default=UNSET)
    seats: Missing[int] = Field(default=UNSET)


class CopilotSeatDetails(GitHubModel):
    """Copilot Business Seat Detail

    Information about a Copilot Business seat assignment for a user, team, or
    organization.
    """

    assignee: Union[SimpleUser, Team, Organization] = Field(
        description="The assignee that has been granted access to GitHub Copilot."
    )
    assigning_team: Missing[Union[Team, None]] = Field(
        default=UNSET,
        description="The team that granted access to GitHub Copilot to the assignee. This will be null if the user was assigned a seat individually.",
    )
    pending_cancellation_date: Missing[Union[date, None]] = Field(
        default=UNSET,
        description="The pending cancellation date for the seat, in `YYYY-MM-DD` format. This will be null unless the assignee's Copilot access has been canceled during the current billing cycle. If the seat has been cancelled, this corresponds to the start of the organization's next billing cycle.",
    )
    last_activity_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="Timestamp of user's last GitHub Copilot activity, in ISO 8601 format.",
    )
    last_activity_editor: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="Last editor that was used by the user for a GitHub Copilot completion.",
    )
    created_at: datetime = Field(
        description="Timestamp of when the assignee was last granted access to GitHub Copilot, in ISO 8601 format."
    )
    updated_at: Missing[datetime] = Field(
        default=UNSET,
        description="Timestamp of when the assignee's GitHub Copilot access was last updated, in ISO 8601 format.",
    )


class OrganizationDependabotSecret(GitHubModel):
    """Dependabot Secret for an Organization

    Secrets for GitHub Dependabot for an organization.
    """

    name: str = Field(description="The name of the secret.")
    created_at: datetime = Field()
    updated_at: datetime = Field()
    visibility: Literal["all", "private", "selected"] = Field(
        description="Visibility of a secret"
    )
    selected_repositories_url: Missing[str] = Field(default=UNSET)


class DependabotPublicKey(GitHubModel):
    """DependabotPublicKey

    The public key used for setting Dependabot Secrets.
    """

    key_id: str = Field(description="The identifier for the key.")
    key: str = Field(description="The Base64 encoded public key.")


class Package(GitHubModel):
    """Package

    A software package
    """

    id: int = Field(description="Unique identifier of the package.")
    name: str = Field(description="The name of the package.")
    package_type: Literal[
        "npm", "maven", "rubygems", "docker", "nuget", "container"
    ] = Field()
    url: str = Field()
    html_url: str = Field()
    version_count: int = Field(description="The number of versions of the package.")
    visibility: Literal["private", "public"] = Field()
    owner: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    repository: Missing[Union[None, MinimalRepository]] = Field(default=UNSET)
    created_at: datetime = Field()
    updated_at: datetime = Field()


class OrganizationInvitation(GitHubModel):
    """Organization Invitation

    Organization Invitation
    """

    id: int = Field()
    login: Union[str, None] = Field()
    email: Union[str, None] = Field()
    role: str = Field()
    created_at: str = Field()
    failed_at: Missing[Union[str, None]] = Field(default=UNSET)
    failed_reason: Missing[Union[str, None]] = Field(default=UNSET)
    inviter: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    team_count: int = Field()
    node_id: str = Field()
    invitation_teams_url: str = Field()
    invitation_source: Missing[str] = Field(default=UNSET)


class OrgHook(GitHubModel):
    """Org Hook

    Org Hook
    """

    id: int = Field()
    url: str = Field()
    ping_url: str = Field()
    deliveries_url: Missing[str] = Field(default=UNSET)
    name: str = Field()
    events: List[str] = Field()
    active: bool = Field()
    config: OrgHookPropConfig = Field()
    updated_at: datetime = Field()
    created_at: datetime = Field()
    type: str = Field()


class OrgHookPropConfig(GitHubModel):
    """OrgHookPropConfig"""

    url: Missing[str] = Field(default=UNSET)
    insecure_ssl: Missing[str] = Field(default=UNSET)
    content_type: Missing[str] = Field(default=UNSET)
    secret: Missing[str] = Field(default=UNSET)


class InteractionLimitResponse(GitHubModel):
    """Interaction Limits

    Interaction limit settings.
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"] = Field(
        description="The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect."
    )
    origin: str = Field()
    expires_at: datetime = Field()


class InteractionLimit(GitHubModel):
    """Interaction Restrictions

    Limit interactions to a specific type of user for a specified duration
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"] = Field(
        description="The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect."
    )
    expiry: Missing[
        Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
    ] = Field(
        default=UNSET,
        description="The duration of the interaction restriction. Default: `one_day`.",
    )


class OrgMembership(GitHubModel):
    """Org Membership

    Org Membership
    """

    url: str = Field()
    state: Literal["active", "pending"] = Field(
        description="The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation."
    )
    role: Literal["admin", "member", "billing_manager"] = Field(
        description="The user's membership type in the organization."
    )
    organization_url: str = Field()
    organization: OrganizationSimple = Field(
        title="Organization Simple", description="A GitHub organization."
    )
    user: Union[None, SimpleUser] = Field()
    permissions: Missing[OrgMembershipPropPermissions] = Field(default=UNSET)


class OrgMembershipPropPermissions(GitHubModel):
    """OrgMembershipPropPermissions"""

    can_create_repository: bool = Field()


class Migration(GitHubModel):
    """Migration

    A migration.
    """

    id: int = Field()
    owner: Union[None, SimpleUser] = Field()
    guid: str = Field()
    state: str = Field()
    lock_repositories: bool = Field()
    exclude_metadata: bool = Field()
    exclude_git_data: bool = Field()
    exclude_attachments: bool = Field()
    exclude_releases: bool = Field()
    exclude_owner_projects: bool = Field()
    org_metadata_only: bool = Field()
    repositories: List[Repository] = Field(
        description="The repositories included in the migration. Only returned for export migrations."
    )
    url: str = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    node_id: str = Field()
    archive_url: Missing[str] = Field(default=UNSET)
    exclude: Missing[List[str]] = Field(
        default=UNSET,
        description='Exclude related items from being returned in the response in order to improve performance of the request. The array can include any of: `"repositories"`.',
    )


class OrganizationFineGrainedPermission(GitHubModel):
    """Organization Fine-Grained Permission

    A fine-grained permission that protects organization resources.
    """

    name: str = Field()
    description: str = Field()


class OrganizationRole(GitHubModel):
    """Organization Role

    Organization roles
    """

    id: int = Field(description="The unique identifier of the role.")
    name: str = Field(description="The name of the role.")
    description: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="A short description about who this role is for or what permissions it grants.",
    )
    permissions: List[str] = Field(
        description="A list of permissions included in this role."
    )
    organization: Union[None, SimpleUser] = Field()
    created_at: datetime = Field(description="The date and time the role was created.")
    updated_at: datetime = Field(
        description="The date and time the role was last updated."
    )


class PackageVersion(GitHubModel):
    """Package Version

    A version of a software package
    """

    id: int = Field(description="Unique identifier of the package version.")
    name: str = Field(description="The name of the package version.")
    url: str = Field()
    package_html_url: str = Field()
    html_url: Missing[str] = Field(default=UNSET)
    license_: Missing[str] = Field(default=UNSET, alias="license")
    description: Missing[str] = Field(default=UNSET)
    created_at: datetime = Field()
    updated_at: datetime = Field()
    deleted_at: Missing[datetime] = Field(default=UNSET)
    metadata: Missing[PackageVersionPropMetadata] = Field(
        default=UNSET, title="Package Version Metadata"
    )


class PackageVersionPropMetadata(GitHubModel):
    """Package Version Metadata"""

    package_type: Literal[
        "npm", "maven", "rubygems", "docker", "nuget", "container"
    ] = Field()
    container: Missing[PackageVersionPropMetadataPropContainer] = Field(
        default=UNSET, title="Container Metadata"
    )
    docker: Missing[PackageVersionPropMetadataPropDocker] = Field(
        default=UNSET, title="Docker Metadata"
    )


class PackageVersionPropMetadataPropContainer(GitHubModel):
    """Container Metadata"""

    tags: List[str] = Field()


class PackageVersionPropMetadataPropDocker(GitHubModel):
    """Docker Metadata"""

    tag: Missing[List[str]] = Field(default=UNSET)


class OrganizationProgrammaticAccessGrantRequest(GitHubModel):
    """Simple Organization Programmatic Access Grant Request

    Minimal representation of an organization programmatic access grant request for
    enumerations
    """

    id: int = Field(
        description="Unique identifier of the request for access via fine-grained personal access token. The `pat_request_id` used to review PAT requests."
    )
    reason: Union[str, None] = Field(description="Reason for requesting access.")
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    repository_selection: Literal["none", "all", "subset"] = Field(
        description="Type of repository selection requested."
    )
    repositories_url: str = Field(
        description="URL to the list of repositories requested to be accessed via fine-grained personal access token. Should only be followed when `repository_selection` is `subset`."
    )
    permissions: OrganizationProgrammaticAccessGrantRequestPropPermissions = Field(
        description="Permissions requested, categorized by type of permission."
    )
    created_at: str = Field(
        description="Date and time when the request for access was created."
    )
    token_expired: bool = Field(
        description="Whether the associated fine-grained personal access token has expired."
    )
    token_expires_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token expires."
    )
    token_last_used_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token was last used for authentication."
    )


class OrganizationProgrammaticAccessGrantRequestPropPermissions(GitHubModel):
    """OrganizationProgrammaticAccessGrantRequestPropPermissions

    Permissions requested, categorized by type of permission.
    """

    organization: Missing[
        OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepository
    ] = Field(default=UNSET)
    other: Missing[
        OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOther
    ] = Field(default=UNSET)


class OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganization(
    ExtraGitHubModel
):
    """OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganization"""


class OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepository(
    ExtraGitHubModel
):
    """OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepository"""


class OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOther(
    ExtraGitHubModel
):
    """OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOther"""


class OrganizationProgrammaticAccessGrant(GitHubModel):
    """Organization Programmatic Access Grant

    Minimal representation of an organization programmatic access grant for
    enumerations
    """

    id: int = Field(
        description="Unique identifier of the fine-grained personal access token. The `pat_id` used to get details about an approved fine-grained personal access token."
    )
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    repository_selection: Literal["none", "all", "subset"] = Field(
        description="Type of repository selection requested."
    )
    repositories_url: str = Field(
        description="URL to the list of repositories the fine-grained personal access token can access. Only follow when `repository_selection` is `subset`."
    )
    permissions: OrganizationProgrammaticAccessGrantPropPermissions = Field(
        description="Permissions requested, categorized by type of permission."
    )
    access_granted_at: str = Field(
        description="Date and time when the fine-grained personal access token was approved to access the organization."
    )
    token_expired: bool = Field(
        description="Whether the associated fine-grained personal access token has expired."
    )
    token_expires_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token expires."
    )
    token_last_used_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token was last used for authentication."
    )


class OrganizationProgrammaticAccessGrantPropPermissions(GitHubModel):
    """OrganizationProgrammaticAccessGrantPropPermissions

    Permissions requested, categorized by type of permission.
    """

    organization: Missing[
        OrganizationProgrammaticAccessGrantPropPermissionsPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        OrganizationProgrammaticAccessGrantPropPermissionsPropRepository
    ] = Field(default=UNSET)
    other: Missing[OrganizationProgrammaticAccessGrantPropPermissionsPropOther] = Field(
        default=UNSET
    )


class OrganizationProgrammaticAccessGrantPropPermissionsPropOrganization(
    ExtraGitHubModel
):
    """OrganizationProgrammaticAccessGrantPropPermissionsPropOrganization"""


class OrganizationProgrammaticAccessGrantPropPermissionsPropRepository(
    ExtraGitHubModel
):
    """OrganizationProgrammaticAccessGrantPropPermissionsPropRepository"""


class OrganizationProgrammaticAccessGrantPropPermissionsPropOther(ExtraGitHubModel):
    """OrganizationProgrammaticAccessGrantPropPermissionsPropOther"""


class Project(GitHubModel):
    """Project

    Projects are a way to organize columns and cards of work.
    """

    owner_url: str = Field()
    url: str = Field()
    html_url: str = Field()
    columns_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    name: str = Field(description="Name of the project")
    body: Union[str, None] = Field(description="Body of the project")
    number: int = Field()
    state: str = Field(description="State of the project; either 'open' or 'closed'")
    creator: Union[None, SimpleUser] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    organization_permission: Missing[Literal["read", "write", "admin", "none"]] = Field(
        default=UNSET,
        description="The baseline permission that all organization members have on this project. Only present if owner is an organization.",
    )
    private: Missing[bool] = Field(
        default=UNSET,
        description="Whether or not this project can be seen by everyone. Only present if owner is an organization.",
    )


class OrgCustomProperty(GitHubModel):
    """Organization Custom Property

    Custom property defined on an organization
    """

    property_name: str = Field(description="The name of the property")
    value_type: Literal["string", "single_select"] = Field(
        description="The type of the value for the property"
    )
    required: Missing[bool] = Field(
        default=UNSET, description="Whether the property is required."
    )
    default_value: Missing[Union[str, None]] = Field(
        default=UNSET, description="Default value of the property"
    )
    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="Short description of the property"
    )
    allowed_values: Missing[Union[List[str], None]] = Field(
        default=UNSET, description="Ordered list of allowed values of the property"
    )


class CustomPropertyValue(GitHubModel):
    """Custom Property Value

    Custom property name and associated value
    """

    property_name: str = Field(description="The name of the property")
    value: Union[str, None] = Field(description="The value assigned to the property")


class OrgRepoCustomPropertyValues(GitHubModel):
    """Organization Repository Custom Property Values

    List of custom property values for a repository
    """

    repository_id: int = Field()
    repository_name: str = Field()
    repository_full_name: str = Field()
    properties: List[CustomPropertyValue] = Field(
        description="List of custom property names and associated values"
    )


class CodeOfConductSimple(GitHubModel):
    """Code Of Conduct Simple

    Code of Conduct Simple
    """

    url: str = Field()
    key: str = Field()
    name: str = Field()
    html_url: Union[str, None] = Field()


class FullRepository(GitHubModel):
    """Full Repository

    Full Repository
    """

    id: int = Field()
    node_id: str = Field()
    name: str = Field()
    full_name: str = Field()
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    private: bool = Field()
    html_url: str = Field()
    description: Union[str, None] = Field()
    fork: bool = Field()
    url: str = Field()
    archive_url: str = Field()
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    deployments_url: str = Field()
    downloads_url: str = Field()
    events_url: str = Field()
    forks_url: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    languages_url: str = Field()
    merges_url: str = Field()
    milestones_url: str = Field()
    notifications_url: str = Field()
    pulls_url: str = Field()
    releases_url: str = Field()
    ssh_url: str = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    trees_url: str = Field()
    clone_url: str = Field()
    mirror_url: Union[str, None] = Field()
    hooks_url: str = Field()
    svn_url: str = Field()
    homepage: Union[str, None] = Field()
    language: Union[str, None] = Field()
    forks_count: int = Field()
    stargazers_count: int = Field()
    watchers_count: int = Field()
    size: int = Field(
        description="The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0."
    )
    default_branch: str = Field()
    open_issues_count: int = Field()
    is_template: Missing[bool] = Field(default=UNSET)
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: bool = Field()
    has_projects: bool = Field()
    has_wiki: bool = Field()
    has_pages: bool = Field()
    has_downloads: Missing[bool] = Field(default=UNSET)
    has_discussions: bool = Field()
    archived: bool = Field()
    disabled: bool = Field(
        description="Returns whether or not this repository disabled."
    )
    visibility: Missing[str] = Field(
        default=UNSET,
        description="The repository visibility: public, private, or internal.",
    )
    pushed_at: datetime = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    permissions: Missing[FullRepositoryPropPermissions] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    template_repository: Missing[Union[None, Repository]] = Field(default=UNSET)
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_auto_merge: Missing[bool] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Missing[bool] = Field(default=UNSET)
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n  - `PR_TITLE` - default to the pull request's title.\n  - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    allow_forking: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)
    subscribers_count: int = Field()
    network_count: int = Field()
    license_: Union[None, LicenseSimple] = Field(alias="license")
    organization: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    parent: Missing[Repository] = Field(
        default=UNSET, title="Repository", description="A repository on GitHub."
    )
    source: Missing[Repository] = Field(
        default=UNSET, title="Repository", description="A repository on GitHub."
    )
    forks: int = Field()
    master_branch: Missing[str] = Field(default=UNSET)
    open_issues: int = Field()
    watchers: int = Field()
    anonymous_access_enabled: Missing[bool] = Field(
        default=UNSET, description="Whether anonymous git access is allowed."
    )
    code_of_conduct: Missing[CodeOfConductSimple] = Field(
        default=UNSET,
        title="Code Of Conduct Simple",
        description="Code of Conduct Simple",
    )
    security_and_analysis: Missing[Union[SecurityAndAnalysis, None]] = Field(
        default=UNSET
    )


class FullRepositoryPropPermissions(GitHubModel):
    """FullRepositoryPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()


class RepositoryRulesetBypassActor(GitHubModel):
    """Repository Ruleset Bypass Actor

    An actor that can bypass rules in a ruleset
    """

    actor_id: int = Field(
        description="The ID of the actor that can bypass a ruleset. If `actor_type` is `OrganizationAdmin`, this should be `1`."
    )
    actor_type: Literal[
        "RepositoryRole", "Team", "Integration", "OrganizationAdmin"
    ] = Field(description="The type of actor that can bypass a ruleset")
    bypass_mode: Literal["always", "pull_request"] = Field(
        description="When the specified actor can bypass the ruleset. `pull_request` means that an actor can only bypass rules on pull requests."
    )


class RepositoryRulesetConditions(GitHubModel):
    """Repository ruleset conditions for ref names

    Parameters for a repository ruleset ref name condition
    """

    ref_name: Missing[RepositoryRulesetConditionsPropRefName] = Field(default=UNSET)


class RepositoryRulesetConditionsPropRefName(GitHubModel):
    """RepositoryRulesetConditionsPropRefName"""

    include: Missing[List[str]] = Field(
        default=UNSET,
        description="Array of ref names or patterns to include. One of these patterns must match for the condition to pass. Also accepts `~DEFAULT_BRANCH` to include the default branch or `~ALL` to include all branches.",
    )
    exclude: Missing[List[str]] = Field(
        default=UNSET,
        description="Array of ref names or patterns to exclude. The condition will not pass if any of these patterns match.",
    )


class RepositoryRulesetConditionsRepositoryNameTarget(GitHubModel):
    """Repository ruleset conditions for repository names

    Parameters for a repository name condition
    """

    repository_name: RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName = (
        Field()
    )


class RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName(GitHubModel):
    """RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName"""

    include: Missing[List[str]] = Field(
        default=UNSET,
        description="Array of repository names or patterns to include. One of these patterns must match for the condition to pass. Also accepts `~ALL` to include all repositories.",
    )
    exclude: Missing[List[str]] = Field(
        default=UNSET,
        description="Array of repository names or patterns to exclude. The condition will not pass if any of these patterns match.",
    )
    protected: Missing[bool] = Field(
        default=UNSET,
        description="Whether renaming of target repositories is prevented.",
    )


class RepositoryRulesetConditionsRepositoryIdTarget(GitHubModel):
    """Repository ruleset conditions for repository IDs

    Parameters for a repository ID condition
    """

    repository_id: RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId = (
        Field()
    )


class RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId(GitHubModel):
    """RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId"""

    repository_ids: Missing[List[int]] = Field(
        default=UNSET,
        description="The repository IDs that the ruleset applies to. One of these IDs must match for the condition to pass.",
    )


class OrgRulesetConditionsOneof0(GitHubModel):
    """repository_name_and_ref_name

    Conditions to target repositories by name and refs by name
    """

    ref_name: Missing[RepositoryRulesetConditionsPropRefName] = Field(default=UNSET)
    repository_name: RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName = (
        Field()
    )


class OrgRulesetConditionsOneof1(GitHubModel):
    """repository_id_and_ref_name

    Conditions to target repositories by id and refs by name
    """

    ref_name: Missing[RepositoryRulesetConditionsPropRefName] = Field(default=UNSET)
    repository_id: RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId = (
        Field()
    )


class RepositoryRuleCreation(GitHubModel):
    """creation

    Only allow users with bypass permission to create matching refs.
    """

    type: Literal["creation"] = Field()


class RepositoryRuleUpdate(GitHubModel):
    """update

    Only allow users with bypass permission to update matching refs.
    """

    type: Literal["update"] = Field()
    parameters: Missing[RepositoryRuleUpdatePropParameters] = Field(default=UNSET)


class RepositoryRuleUpdatePropParameters(GitHubModel):
    """RepositoryRuleUpdatePropParameters"""

    update_allows_fetch_and_merge: bool = Field(
        description="Branch can pull changes from its upstream repository"
    )


class RepositoryRuleDeletion(GitHubModel):
    """deletion

    Only allow users with bypass permissions to delete matching refs.
    """

    type: Literal["deletion"] = Field()


class RepositoryRuleRequiredLinearHistory(GitHubModel):
    """required_linear_history

    Prevent merge commits from being pushed to matching refs.
    """

    type: Literal["required_linear_history"] = Field()


class RepositoryRuleRequiredDeployments(GitHubModel):
    """required_deployments

    Choose which environments must be successfully deployed to before refs can be
    pushed into a ref that matches this rule.
    """

    type: Literal["required_deployments"] = Field()
    parameters: Missing[RepositoryRuleRequiredDeploymentsPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleRequiredDeploymentsPropParameters(GitHubModel):
    """RepositoryRuleRequiredDeploymentsPropParameters"""

    required_deployment_environments: List[str] = Field(
        description="The environments that must be successfully deployed to before branches can be merged."
    )


class RepositoryRuleRequiredSignatures(GitHubModel):
    """required_signatures

    Commits pushed to matching refs must have verified signatures.
    """

    type: Literal["required_signatures"] = Field()


class RepositoryRulePullRequest(GitHubModel):
    """pull_request

    Require all commits be made to a non-target branch and submitted via a pull
    request before they can be merged.
    """

    type: Literal["pull_request"] = Field()
    parameters: Missing[RepositoryRulePullRequestPropParameters] = Field(default=UNSET)


class RepositoryRulePullRequestPropParameters(GitHubModel):
    """RepositoryRulePullRequestPropParameters"""

    dismiss_stale_reviews_on_push: bool = Field(
        description="New, reviewable commits pushed will dismiss previous pull request review approvals."
    )
    require_code_owner_review: bool = Field(
        description="Require an approving review in pull requests that modify files that have a designated code owner."
    )
    require_last_push_approval: bool = Field(
        description="Whether the most recent reviewable push must be approved by someone other than the person who pushed it."
    )
    required_approving_review_count: Annotated[int, Field(le=10.0)] = Field(
        description="The number of approving reviews that are required before a pull request can be merged."
    )
    required_review_thread_resolution: bool = Field(
        description="All conversations on code must be resolved before a pull request can be merged."
    )


class RepositoryRuleParamsStatusCheckConfiguration(GitHubModel):
    """StatusCheckConfiguration

    Required status check
    """

    context: str = Field(
        description="The status check context name that must be present on the commit."
    )
    integration_id: Missing[int] = Field(
        default=UNSET,
        description="The optional integration ID that this status check must originate from.",
    )


class RepositoryRuleRequiredStatusChecks(GitHubModel):
    """required_status_checks

    Choose which status checks must pass before the ref is updated. When enabled,
    commits must first be pushed to another ref where the checks pass.
    """

    type: Literal["required_status_checks"] = Field()
    parameters: Missing[RepositoryRuleRequiredStatusChecksPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleRequiredStatusChecksPropParameters(GitHubModel):
    """RepositoryRuleRequiredStatusChecksPropParameters"""

    required_status_checks: List[RepositoryRuleParamsStatusCheckConfiguration] = Field(
        description="Status checks that are required."
    )
    strict_required_status_checks_policy: bool = Field(
        description="Whether pull requests targeting a matching branch must be tested with the latest code. This setting will not take effect unless at least one status check is enabled."
    )


class RepositoryRuleNonFastForward(GitHubModel):
    """non_fast_forward

    Prevent users with push access from force pushing to refs.
    """

    type: Literal["non_fast_forward"] = Field()


class RepositoryRuleCommitMessagePattern(GitHubModel):
    """commit_message_pattern

    Parameters to be used for the commit_message_pattern rule
    """

    type: Literal["commit_message_pattern"] = Field()
    parameters: Missing[RepositoryRuleCommitMessagePatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleCommitMessagePatternPropParameters(GitHubModel):
    """RepositoryRuleCommitMessagePatternPropParameters"""

    name: Missing[str] = Field(
        default=UNSET, description="How this rule will appear to users."
    )
    negate: Missing[bool] = Field(
        default=UNSET, description="If true, the rule will fail if the pattern matches."
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching."
    )
    pattern: str = Field(description="The pattern to match with.")


class RepositoryRuleCommitAuthorEmailPattern(GitHubModel):
    """commit_author_email_pattern

    Parameters to be used for the commit_author_email_pattern rule
    """

    type: Literal["commit_author_email_pattern"] = Field()
    parameters: Missing[RepositoryRuleCommitAuthorEmailPatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleCommitAuthorEmailPatternPropParameters(GitHubModel):
    """RepositoryRuleCommitAuthorEmailPatternPropParameters"""

    name: Missing[str] = Field(
        default=UNSET, description="How this rule will appear to users."
    )
    negate: Missing[bool] = Field(
        default=UNSET, description="If true, the rule will fail if the pattern matches."
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching."
    )
    pattern: str = Field(description="The pattern to match with.")


class RepositoryRuleCommitterEmailPattern(GitHubModel):
    """committer_email_pattern

    Parameters to be used for the committer_email_pattern rule
    """

    type: Literal["committer_email_pattern"] = Field()
    parameters: Missing[RepositoryRuleCommitterEmailPatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleCommitterEmailPatternPropParameters(GitHubModel):
    """RepositoryRuleCommitterEmailPatternPropParameters"""

    name: Missing[str] = Field(
        default=UNSET, description="How this rule will appear to users."
    )
    negate: Missing[bool] = Field(
        default=UNSET, description="If true, the rule will fail if the pattern matches."
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching."
    )
    pattern: str = Field(description="The pattern to match with.")


class RepositoryRuleBranchNamePattern(GitHubModel):
    """branch_name_pattern

    Parameters to be used for the branch_name_pattern rule
    """

    type: Literal["branch_name_pattern"] = Field()
    parameters: Missing[RepositoryRuleBranchNamePatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleBranchNamePatternPropParameters(GitHubModel):
    """RepositoryRuleBranchNamePatternPropParameters"""

    name: Missing[str] = Field(
        default=UNSET, description="How this rule will appear to users."
    )
    negate: Missing[bool] = Field(
        default=UNSET, description="If true, the rule will fail if the pattern matches."
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching."
    )
    pattern: str = Field(description="The pattern to match with.")


class RepositoryRuleTagNamePattern(GitHubModel):
    """tag_name_pattern

    Parameters to be used for the tag_name_pattern rule
    """

    type: Literal["tag_name_pattern"] = Field()
    parameters: Missing[RepositoryRuleTagNamePatternPropParameters] = Field(
        default=UNSET
    )


class RepositoryRuleTagNamePatternPropParameters(GitHubModel):
    """RepositoryRuleTagNamePatternPropParameters"""

    name: Missing[str] = Field(
        default=UNSET, description="How this rule will appear to users."
    )
    negate: Missing[bool] = Field(
        default=UNSET, description="If true, the rule will fail if the pattern matches."
    )
    operator: Literal["starts_with", "ends_with", "contains", "regex"] = Field(
        description="The operator to use for matching."
    )
    pattern: str = Field(description="The pattern to match with.")


class RepositoryRuleParamsWorkflowFileReference(GitHubModel):
    """WorkflowFileReference

    A workflow that must run for this rule to pass
    """

    path: str = Field(description="The path to the workflow file")
    ref: Missing[str] = Field(
        default=UNSET, description="The ref (branch or tag) of the workflow file to use"
    )
    repository_id: int = Field(
        description="The ID of the repository where the workflow is defined"
    )
    sha: Missing[str] = Field(
        default=UNSET, description="The commit SHA of the workflow file to use"
    )


class RepositoryRuleWorkflows(GitHubModel):
    """workflows

    Require all changes made to a targeted branch to pass the specified workflows
    before they can be merged.
    """

    type: Literal["workflows"] = Field()
    parameters: Missing[RepositoryRuleWorkflowsPropParameters] = Field(default=UNSET)


class RepositoryRuleWorkflowsPropParameters(GitHubModel):
    """RepositoryRuleWorkflowsPropParameters"""

    workflows: List[RepositoryRuleParamsWorkflowFileReference] = Field(
        description="Workflows that must pass for this rule to pass."
    )


class RepositoryRuleset(GitHubModel):
    """Repository ruleset

    A set of rules to apply when specified conditions are met.
    """

    id: int = Field(description="The ID of the ruleset")
    name: str = Field(description="The name of the ruleset")
    target: Missing[Literal["branch", "tag"]] = Field(
        default=UNSET, description="The target of the ruleset"
    )
    source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET, description="The type of the source of the ruleset"
    )
    source: str = Field(description="The name of the source")
    enforcement: Literal["disabled", "active", "evaluate"] = Field(
        description="The enforcement level of the ruleset. `evaluate` allows admins to test rules before enforcing them. Admins can view insights on the Rule Insights page (`evaluate` is only available with GitHub Enterprise)."
    )
    bypass_actors: Missing[List[RepositoryRulesetBypassActor]] = Field(
        default=UNSET,
        description="The actors that can bypass the rules in this ruleset",
    )
    current_user_can_bypass: Missing[
        Literal["always", "pull_requests_only", "never"]
    ] = Field(
        default=UNSET,
        description="The bypass type of the user making the API request for this ruleset. This field is only returned when\nquerying the repository-level endpoint.",
    )
    node_id: Missing[str] = Field(default=UNSET)
    links: Missing[RepositoryRulesetPropLinks] = Field(default=UNSET, alias="_links")
    conditions: Missing[
        Union[
            RepositoryRulesetConditions,
            OrgRulesetConditionsOneof0,
            OrgRulesetConditionsOneof1,
        ]
    ] = Field(default=UNSET)
    rules: Missing[
        List[
            Union[
                RepositoryRuleCreation,
                RepositoryRuleUpdate,
                RepositoryRuleDeletion,
                RepositoryRuleRequiredLinearHistory,
                RepositoryRuleRequiredDeployments,
                RepositoryRuleRequiredSignatures,
                RepositoryRulePullRequest,
                RepositoryRuleRequiredStatusChecks,
                RepositoryRuleNonFastForward,
                RepositoryRuleCommitMessagePattern,
                RepositoryRuleCommitAuthorEmailPattern,
                RepositoryRuleCommitterEmailPattern,
                RepositoryRuleBranchNamePattern,
                RepositoryRuleTagNamePattern,
                RepositoryRuleWorkflows,
            ]
        ]
    ] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(default=UNSET)
    updated_at: Missing[datetime] = Field(default=UNSET)


class RepositoryRulesetPropLinks(GitHubModel):
    """RepositoryRulesetPropLinks"""

    self_: Missing[RepositoryRulesetPropLinksPropSelf] = Field(
        default=UNSET, alias="self"
    )
    html: Missing[RepositoryRulesetPropLinksPropHtml] = Field(default=UNSET)


class RepositoryRulesetPropLinksPropSelf(GitHubModel):
    """RepositoryRulesetPropLinksPropSelf"""

    href: Missing[str] = Field(default=UNSET, description="The URL of the ruleset")


class RepositoryRulesetPropLinksPropHtml(GitHubModel):
    """RepositoryRulesetPropLinksPropHtml"""

    href: Missing[str] = Field(default=UNSET, description="The html URL of the ruleset")


class RuleSuitesItems(GitHubModel):
    """RuleSuitesItems"""

    id: Missing[int] = Field(
        default=UNSET, description="The unique identifier of the rule insight."
    )
    actor_id: Missing[int] = Field(
        default=UNSET, description="The number that identifies the user."
    )
    actor_name: Missing[str] = Field(
        default=UNSET, description="The handle for the GitHub user account."
    )
    before_sha: Missing[str] = Field(
        default=UNSET, description="The first commit sha before the push evaluation."
    )
    after_sha: Missing[str] = Field(
        default=UNSET, description="The last commit sha in the push evaluation."
    )
    ref: Missing[str] = Field(
        default=UNSET, description="The ref name that the evaluation ran on."
    )
    repository_id: Missing[int] = Field(
        default=UNSET,
        description="The ID of the repository associated with the rule evaluation.",
    )
    repository_name: Missing[str] = Field(
        default=UNSET,
        description="The name of the repository without the `.git` extension.",
    )
    pushed_at: Missing[datetime] = Field(default=UNSET)
    result: Missing[Literal["pass", "fail", "bypass"]] = Field(
        default=UNSET,
        description="The result of the rule evaluations for rules with the `active` enforcement status.",
    )
    evaluation_result: Missing[Literal["pass", "fail"]] = Field(
        default=UNSET,
        description="The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`.",
    )


class RuleSuite(GitHubModel):
    """Rule Suite

    Response
    """

    id: Missing[int] = Field(
        default=UNSET, description="The unique identifier of the rule insight."
    )
    actor_id: Missing[int] = Field(
        default=UNSET, description="The number that identifies the user."
    )
    actor_name: Missing[str] = Field(
        default=UNSET, description="The handle for the GitHub user account."
    )
    before_sha: Missing[str] = Field(
        default=UNSET, description="The first commit sha before the push evaluation."
    )
    after_sha: Missing[str] = Field(
        default=UNSET, description="The last commit sha in the push evaluation."
    )
    ref: Missing[str] = Field(
        default=UNSET, description="The ref name that the evaluation ran on."
    )
    repository_id: Missing[int] = Field(
        default=UNSET,
        description="The ID of the repository associated with the rule evaluation.",
    )
    repository_name: Missing[str] = Field(
        default=UNSET,
        description="The name of the repository without the `.git` extension.",
    )
    pushed_at: Missing[datetime] = Field(default=UNSET)
    result: Missing[Literal["pass", "fail", "bypass"]] = Field(
        default=UNSET,
        description="The result of the rule evaluations for rules with the `active` enforcement status.",
    )
    evaluation_result: Missing[Literal["pass", "fail"]] = Field(
        default=UNSET,
        description="The result of the rule evaluations for rules with the `active` and `evaluate` enforcement statuses, demonstrating whether rules would pass or fail if all rules in the rule suite were `active`.",
    )
    rule_evaluations: Missing[List[RuleSuitePropRuleEvaluationsItems]] = Field(
        default=UNSET, description="Details on the evaluated rules."
    )


class RuleSuitePropRuleEvaluationsItems(GitHubModel):
    """RuleSuitePropRuleEvaluationsItems"""

    rule_source: Missing[RuleSuitePropRuleEvaluationsItemsPropRuleSource] = Field(
        default=UNSET
    )
    enforcement: Missing[Literal["active", "evaluate", "deleted ruleset"]] = Field(
        default=UNSET, description="The enforcement level of this rule source."
    )
    result: Missing[Literal["pass", "fail"]] = Field(
        default=UNSET,
        description="The result of the evaluation of the individual rule.",
    )
    rule_type: Missing[str] = Field(default=UNSET, description="The type of rule.")
    details: Missing[str] = Field(
        default=UNSET, description="Any associated details with the rule evaluation."
    )


class RuleSuitePropRuleEvaluationsItemsPropRuleSource(GitHubModel):
    """RuleSuitePropRuleEvaluationsItemsPropRuleSource"""

    type: Missing[str] = Field(default=UNSET, description="The type of rule source.")
    id: Missing[Union[int, None]] = Field(
        default=UNSET, description="The ID of the rule source."
    )
    name: Missing[Union[str, None]] = Field(
        default=UNSET, description="The name of the rule source."
    )


class RepositoryAdvisoryVulnerability(GitHubModel):
    """RepositoryAdvisoryVulnerability

    A product affected by the vulnerability detailed in a repository security
    advisory.
    """

    package: Union[RepositoryAdvisoryVulnerabilityPropPackage, None] = Field(
        description="The name of the package affected by the vulnerability."
    )
    vulnerable_version_range: Union[str, None] = Field(
        description="The range of the package versions affected by the vulnerability."
    )
    patched_versions: Union[str, None] = Field(
        description="The package version(s) that resolve the vulnerability."
    )
    vulnerable_functions: Union[List[str], None] = Field(
        description="The functions in the package that are affected."
    )


class RepositoryAdvisoryVulnerabilityPropPackage(GitHubModel):
    """RepositoryAdvisoryVulnerabilityPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(description="The package's language or package management ecosystem.")
    name: Union[str, None] = Field(
        description="The unique package name within its ecosystem."
    )


class RepositoryAdvisoryCredit(GitHubModel):
    """RepositoryAdvisoryCredit

    A credit given to a user for a repository security advisory.
    """

    user: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ] = Field(description="The type of credit the user is receiving.")
    state: Literal["accepted", "declined", "pending"] = Field(
        description="The state of the user's acceptance of the credit."
    )


class RepositoryAdvisory(GitHubModel):
    """RepositoryAdvisory

    A repository security advisory.
    """

    ghsa_id: str = Field(description="The GitHub Security Advisory ID.")
    cve_id: Union[str, None] = Field(
        description="The Common Vulnerabilities and Exposures (CVE) ID."
    )
    url: str = Field(description="The API URL for the advisory.")
    html_url: str = Field(description="The URL for the advisory.")
    summary: Annotated[str, Field(max_length=1024)] = Field(
        description="A short summary of the advisory."
    )
    description: Union[Annotated[str, Field(max_length=65535)], None] = Field(
        description="A detailed description of what the advisory entails."
    )
    severity: Union[None, Literal["critical", "high", "medium", "low"]] = Field(
        description="The severity of the advisory."
    )
    author: None = Field(description="The author of the advisory.")
    publisher: None = Field(description="The publisher of the advisory.")
    identifiers: List[RepositoryAdvisoryPropIdentifiersItems] = Field()
    state: Literal["published", "closed", "withdrawn", "draft", "triage"] = Field(
        description="The state of the advisory."
    )
    created_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was created, in ISO 8601 format."
    )
    updated_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was last updated, in ISO 8601 format."
    )
    published_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was published, in ISO 8601 format."
    )
    closed_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was closed, in ISO 8601 format."
    )
    withdrawn_at: Union[datetime, None] = Field(
        description="The date and time of when the advisory was withdrawn, in ISO 8601 format."
    )
    submission: Union[RepositoryAdvisoryPropSubmission, None] = Field()
    vulnerabilities: Union[List[RepositoryAdvisoryVulnerability], None] = Field()
    cvss: Union[RepositoryAdvisoryPropCvss, None] = Field()
    cwes: Union[List[RepositoryAdvisoryPropCwesItems], None] = Field()
    cwe_ids: Union[List[str], None] = Field(description="A list of only the CWE IDs.")
    credits_: Union[List[RepositoryAdvisoryPropCreditsItems], None] = Field(
        alias="credits"
    )
    credits_detailed: Union[List[RepositoryAdvisoryCredit], None] = Field()
    collaborating_users: Union[List[SimpleUser], None] = Field(
        description="A list of users that collaborate on the advisory."
    )
    collaborating_teams: Union[List[Team], None] = Field(
        description="A list of teams that collaborate on the advisory."
    )
    private_fork: None = Field(
        description="A temporary private fork of the advisory's repository for collaborating on a fix."
    )


class RepositoryAdvisoryPropIdentifiersItems(GitHubModel):
    """RepositoryAdvisoryPropIdentifiersItems"""

    type: Literal["CVE", "GHSA"] = Field(description="The type of identifier.")
    value: str = Field(description="The identifier value.")


class RepositoryAdvisoryPropSubmission(GitHubModel):
    """RepositoryAdvisoryPropSubmission"""

    accepted: bool = Field(
        description="Whether a private vulnerability report was accepted by the repository's administrators."
    )


class RepositoryAdvisoryPropCvss(GitHubModel):
    """RepositoryAdvisoryPropCvss"""

    vector_string: Union[str, None] = Field(description="The CVSS vector.")
    score: Union[Annotated[float, Field(le=10.0)], None] = Field(
        description="The CVSS score."
    )


class RepositoryAdvisoryPropCwesItems(GitHubModel):
    """RepositoryAdvisoryPropCwesItems"""

    cwe_id: str = Field(description="The Common Weakness Enumeration (CWE) identifier.")
    name: str = Field(description="The name of the CWE.")


class RepositoryAdvisoryPropCreditsItems(GitHubModel):
    """RepositoryAdvisoryPropCreditsItems"""

    login: Missing[str] = Field(
        default=UNSET, description="The username of the user credited."
    )
    type: Missing[
        Literal[
            "analyst",
            "finder",
            "reporter",
            "coordinator",
            "remediation_developer",
            "remediation_reviewer",
            "remediation_verifier",
            "tool",
            "sponsor",
            "other",
        ]
    ] = Field(default=UNSET, description="The type of credit the user is receiving.")


class ActionsBillingUsage(GitHubModel):
    """ActionsBillingUsage"""

    total_minutes_used: int = Field(
        description="The sum of the free and paid GitHub Actions minutes used."
    )
    total_paid_minutes_used: int = Field(
        description="The total paid GitHub Actions minutes used."
    )
    included_minutes: int = Field(
        description="The amount of free GitHub Actions minutes available."
    )
    minutes_used_breakdown: ActionsBillingUsagePropMinutesUsedBreakdown = Field()


class ActionsBillingUsagePropMinutesUsedBreakdown(GitHubModel):
    """ActionsBillingUsagePropMinutesUsedBreakdown"""

    ubuntu: Missing[int] = Field(
        default=UNSET,
        alias="UBUNTU",
        description="Total minutes used on Ubuntu runner machines.",
    )
    macos: Missing[int] = Field(
        default=UNSET,
        alias="MACOS",
        description="Total minutes used on macOS runner machines.",
    )
    windows: Missing[int] = Field(
        default=UNSET,
        alias="WINDOWS",
        description="Total minutes used on Windows runner machines.",
    )
    ubuntu_4_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Ubuntu 4 core runner machines.",
    )
    ubuntu_8_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Ubuntu 8 core runner machines.",
    )
    ubuntu_16_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Ubuntu 16 core runner machines.",
    )
    ubuntu_32_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Ubuntu 32 core runner machines.",
    )
    ubuntu_64_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Ubuntu 64 core runner machines.",
    )
    windows_4_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Windows 4 core runner machines.",
    )
    windows_8_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Windows 8 core runner machines.",
    )
    windows_16_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Windows 16 core runner machines.",
    )
    windows_32_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Windows 32 core runner machines.",
    )
    windows_64_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on Windows 64 core runner machines.",
    )
    macos_12_core: Missing[int] = Field(
        default=UNSET,
        description="Total minutes used on macOS 12 core runner machines.",
    )
    total: Missing[int] = Field(
        default=UNSET, description="Total minutes used on all runner machines."
    )


class PackagesBillingUsage(GitHubModel):
    """PackagesBillingUsage"""

    total_gigabytes_bandwidth_used: int = Field(
        description="Sum of the free and paid storage space (GB) for GitHuub Packages."
    )
    total_paid_gigabytes_bandwidth_used: int = Field(
        description="Total paid storage space (GB) for GitHuub Packages."
    )
    included_gigabytes_bandwidth: int = Field(
        description="Free storage space (GB) for GitHub Packages."
    )


class CombinedBillingUsage(GitHubModel):
    """CombinedBillingUsage"""

    days_left_in_billing_cycle: int = Field(
        description="Numbers of days left in billing cycle."
    )
    estimated_paid_storage_for_month: int = Field(
        description="Estimated storage space (GB) used in billing cycle."
    )
    estimated_storage_for_month: int = Field(
        description="Estimated sum of free and paid storage space (GB) used in billing cycle."
    )


class TeamOrganization(GitHubModel):
    """Team Organization

    Team Organization
    """

    login: str = Field()
    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    hooks_url: str = Field()
    issues_url: str = Field()
    members_url: str = Field()
    public_members_url: str = Field()
    avatar_url: str = Field()
    description: Union[str, None] = Field()
    name: Missing[Union[str, None]] = Field(default=UNSET)
    company: Missing[Union[str, None]] = Field(default=UNSET)
    blog: Missing[Union[str, None]] = Field(default=UNSET)
    location: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    twitter_username: Missing[Union[str, None]] = Field(default=UNSET)
    is_verified: Missing[bool] = Field(default=UNSET)
    has_organization_projects: bool = Field()
    has_repository_projects: bool = Field()
    public_repos: int = Field()
    public_gists: int = Field()
    followers: int = Field()
    following: int = Field()
    html_url: str = Field()
    created_at: datetime = Field()
    type: str = Field()
    total_private_repos: Missing[int] = Field(default=UNSET)
    owned_private_repos: Missing[int] = Field(default=UNSET)
    private_gists: Missing[Union[int, None]] = Field(default=UNSET)
    disk_usage: Missing[Union[int, None]] = Field(default=UNSET)
    collaborators: Missing[Union[int, None]] = Field(default=UNSET)
    billing_email: Missing[Union[str, None]] = Field(default=UNSET)
    plan: Missing[TeamOrganizationPropPlan] = Field(default=UNSET)
    default_repository_permission: Missing[Union[str, None]] = Field(default=UNSET)
    members_can_create_repositories: Missing[Union[bool, None]] = Field(default=UNSET)
    two_factor_requirement_enabled: Missing[Union[bool, None]] = Field(default=UNSET)
    members_allowed_repository_creation_type: Missing[str] = Field(default=UNSET)
    members_can_create_public_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_private_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_internal_repositories: Missing[bool] = Field(default=UNSET)
    members_can_create_pages: Missing[bool] = Field(default=UNSET)
    members_can_create_public_pages: Missing[bool] = Field(default=UNSET)
    members_can_create_private_pages: Missing[bool] = Field(default=UNSET)
    members_can_fork_private_repositories: Missing[Union[bool, None]] = Field(
        default=UNSET
    )
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)
    updated_at: datetime = Field()
    archived_at: Union[datetime, None] = Field()


class TeamOrganizationPropPlan(GitHubModel):
    """TeamOrganizationPropPlan"""

    name: str = Field()
    space: int = Field()
    private_repos: int = Field()
    filled_seats: Missing[int] = Field(default=UNSET)
    seats: Missing[int] = Field(default=UNSET)


class TeamFull(GitHubModel):
    """Full Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int = Field(description="Unique identifier of the team")
    node_id: str = Field()
    url: str = Field(description="URL for the team")
    html_url: str = Field()
    name: str = Field(description="Name of the team")
    slug: str = Field()
    description: Union[str, None] = Field()
    privacy: Missing[Literal["closed", "secret"]] = Field(
        default=UNSET, description="The level of privacy this team should have"
    )
    notification_setting: Missing[
        Literal["notifications_enabled", "notifications_disabled"]
    ] = Field(default=UNSET, description="The notification setting the team has set")
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    members_url: str = Field()
    repositories_url: str = Field()
    parent: Missing[Union[None, TeamSimple]] = Field(default=UNSET)
    members_count: int = Field()
    repos_count: int = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    organization: TeamOrganization = Field(
        title="Team Organization", description="Team Organization"
    )
    ldap_dn: Missing[str] = Field(
        default=UNSET,
        description="Distinguished Name (DN) that team maps to within LDAP environment",
    )


class TeamDiscussion(GitHubModel):
    """Team Discussion

    A team discussion is a persistent record of a free-form conversation within a
    team.
    """

    author: Union[None, SimpleUser] = Field()
    body: str = Field(description="The main text of the discussion.")
    body_html: str = Field()
    body_version: str = Field(
        description="The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server."
    )
    comments_count: int = Field()
    comments_url: str = Field()
    created_at: datetime = Field()
    last_edited_at: Union[datetime, None] = Field()
    html_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The unique sequence number of a team discussion.")
    pinned: bool = Field(
        description="Whether or not this discussion should be pinned for easy retrieval."
    )
    private: bool = Field(
        description="Whether or not this discussion should be restricted to team members and organization owners."
    )
    team_url: str = Field()
    title: str = Field(description="The title of the discussion.")
    updated_at: datetime = Field()
    url: str = Field()
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")


class TeamDiscussionComment(GitHubModel):
    """Team Discussion Comment

    A reply to a discussion within a team.
    """

    author: Union[None, SimpleUser] = Field()
    body: str = Field(description="The main text of the comment.")
    body_html: str = Field()
    body_version: str = Field(
        description="The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server."
    )
    created_at: datetime = Field()
    last_edited_at: Union[datetime, None] = Field()
    discussion_url: str = Field()
    html_url: str = Field()
    node_id: str = Field()
    number: int = Field(
        description="The unique sequence number of a team discussion comment."
    )
    updated_at: datetime = Field()
    url: str = Field()
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")


class Reaction(GitHubModel):
    """Reaction

    Reactions to conversations provide a way to help people express their feelings
    more simply and effectively.
    """

    id: int = Field()
    node_id: str = Field()
    user: Union[None, SimpleUser] = Field()
    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ] = Field(description="The reaction to use")
    created_at: datetime = Field()


class TeamMembership(GitHubModel):
    """Team Membership

    Team Membership
    """

    url: str = Field()
    role: Literal["member", "maintainer"] = Field(
        default="member", description="The role of the user in the team."
    )
    state: Literal["active", "pending"] = Field(
        description="The state of the user's membership in the team."
    )


class TeamProject(GitHubModel):
    """Team Project

    A team's access to a project.
    """

    owner_url: str = Field()
    url: str = Field()
    html_url: str = Field()
    columns_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    name: str = Field()
    body: Union[str, None] = Field()
    number: int = Field()
    state: str = Field()
    creator: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    created_at: str = Field()
    updated_at: str = Field()
    organization_permission: Missing[str] = Field(
        default=UNSET,
        description="The organization permission for this project. Only present when owner is an organization.",
    )
    private: Missing[bool] = Field(
        default=UNSET,
        description="Whether the project is private or not. Only present when owner is an organization.",
    )
    permissions: TeamProjectPropPermissions = Field()


class TeamProjectPropPermissions(GitHubModel):
    """TeamProjectPropPermissions"""

    read: bool = Field()
    write: bool = Field()
    admin: bool = Field()


class TeamRepository(GitHubModel):
    """Team Repository

    A team's access to a repository.
    """

    id: int = Field(description="Unique identifier of the repository")
    node_id: str = Field()
    name: str = Field(description="The name of the repository.")
    full_name: str = Field()
    license_: Union[None, LicenseSimple] = Field(alias="license")
    forks: int = Field()
    permissions: Missing[TeamRepositoryPropPermissions] = Field(default=UNSET)
    role_name: Missing[str] = Field(default=UNSET)
    owner: Union[None, SimpleUser] = Field()
    private: bool = Field(
        default=False, description="Whether the repository is private or public."
    )
    html_url: str = Field()
    description: Union[str, None] = Field()
    fork: bool = Field()
    url: str = Field()
    archive_url: str = Field()
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    deployments_url: str = Field()
    downloads_url: str = Field()
    events_url: str = Field()
    forks_url: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    languages_url: str = Field()
    merges_url: str = Field()
    milestones_url: str = Field()
    notifications_url: str = Field()
    pulls_url: str = Field()
    releases_url: str = Field()
    ssh_url: str = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    trees_url: str = Field()
    clone_url: str = Field()
    mirror_url: Union[str, None] = Field()
    hooks_url: str = Field()
    svn_url: str = Field()
    homepage: Union[str, None] = Field()
    language: Union[str, None] = Field()
    forks_count: int = Field()
    stargazers_count: int = Field()
    watchers_count: int = Field()
    size: int = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    open_issues_count: int = Field()
    is_template: Missing[bool] = Field(
        default=UNSET,
        description="Whether this repository acts as a template that can be used to generate new repositories.",
    )
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_pages: bool = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    disabled: bool = Field(
        description="Returns whether or not this repository disabled."
    )
    visibility: Missing[str] = Field(
        default=UNSET,
        description="The repository visibility: public, private, or internal.",
    )
    pushed_at: Union[datetime, None] = Field()
    created_at: Union[datetime, None] = Field()
    updated_at: Union[datetime, None] = Field()
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_auto_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to allow Auto-merge to be used on pull requests.",
    )
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow forking this repo"
    )
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)
    open_issues: int = Field()
    watchers: int = Field()
    master_branch: Missing[str] = Field(default=UNSET)


class TeamRepositoryPropPermissions(GitHubModel):
    """TeamRepositoryPropPermissions"""

    admin: bool = Field()
    pull: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)
    push: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)


class ProjectCard(GitHubModel):
    """Project Card

    Project cards represent a scope of work.
    """

    url: str = Field()
    id: int = Field(description="The project card's ID")
    node_id: str = Field()
    note: Union[str, None] = Field()
    creator: Union[None, SimpleUser] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    archived: Missing[bool] = Field(
        default=UNSET, description="Whether or not the card is archived"
    )
    column_name: Missing[str] = Field(default=UNSET)
    project_id: Missing[str] = Field(default=UNSET)
    column_url: str = Field()
    content_url: Missing[str] = Field(default=UNSET)
    project_url: str = Field()


class ProjectColumn(GitHubModel):
    """Project Column

    Project columns contain cards of work.
    """

    url: str = Field()
    project_url: str = Field()
    cards_url: str = Field()
    id: int = Field(description="The unique identifier of the project column")
    node_id: str = Field()
    name: str = Field(description="Name of the project column")
    created_at: datetime = Field()
    updated_at: datetime = Field()


class ProjectCollaboratorPermission(GitHubModel):
    """Project Collaborator Permission

    Project Collaborator Permission
    """

    permission: str = Field()
    user: Union[None, SimpleUser] = Field()


class RateLimit(GitHubModel):
    """Rate Limit"""

    limit: int = Field()
    remaining: int = Field()
    reset: int = Field()
    used: int = Field()


class RateLimitOverview(GitHubModel):
    """Rate Limit Overview

    Rate Limit Overview
    """

    resources: RateLimitOverviewPropResources = Field()
    rate: RateLimit = Field(title="Rate Limit")


class RateLimitOverviewPropResources(GitHubModel):
    """RateLimitOverviewPropResources"""

    core: RateLimit = Field(title="Rate Limit")
    graphql: Missing[RateLimit] = Field(default=UNSET, title="Rate Limit")
    search: RateLimit = Field(title="Rate Limit")
    code_search: Missing[RateLimit] = Field(default=UNSET, title="Rate Limit")
    source_import: Missing[RateLimit] = Field(default=UNSET, title="Rate Limit")
    integration_manifest: Missing[RateLimit] = Field(default=UNSET, title="Rate Limit")
    code_scanning_upload: Missing[RateLimit] = Field(default=UNSET, title="Rate Limit")
    actions_runner_registration: Missing[RateLimit] = Field(
        default=UNSET, title="Rate Limit"
    )
    scim: Missing[RateLimit] = Field(default=UNSET, title="Rate Limit")
    dependency_snapshots: Missing[RateLimit] = Field(default=UNSET, title="Rate Limit")


class Artifact(GitHubModel):
    """Artifact

    An artifact
    """

    id: int = Field()
    node_id: str = Field()
    name: str = Field(description="The name of the artifact.")
    size_in_bytes: int = Field(description="The size in bytes of the artifact.")
    url: str = Field()
    archive_download_url: str = Field()
    expired: bool = Field(description="Whether or not the artifact has expired.")
    created_at: Union[datetime, None] = Field()
    expires_at: Union[datetime, None] = Field()
    updated_at: Union[datetime, None] = Field()
    workflow_run: Missing[Union[ArtifactPropWorkflowRun, None]] = Field(default=UNSET)


class ArtifactPropWorkflowRun(GitHubModel):
    """ArtifactPropWorkflowRun"""

    id: Missing[int] = Field(default=UNSET)
    repository_id: Missing[int] = Field(default=UNSET)
    head_repository_id: Missing[int] = Field(default=UNSET)
    head_branch: Missing[str] = Field(default=UNSET)
    head_sha: Missing[str] = Field(default=UNSET)


class ActionsCacheList(GitHubModel):
    """Repository actions caches

    Repository actions caches
    """

    total_count: int = Field(description="Total number of caches")
    actions_caches: List[ActionsCacheListPropActionsCachesItems] = Field(
        description="Array of caches"
    )


class ActionsCacheListPropActionsCachesItems(GitHubModel):
    """ActionsCacheListPropActionsCachesItems"""

    id: Missing[int] = Field(default=UNSET)
    ref: Missing[str] = Field(default=UNSET)
    key: Missing[str] = Field(default=UNSET)
    version: Missing[str] = Field(default=UNSET)
    last_accessed_at: Missing[datetime] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(default=UNSET)
    size_in_bytes: Missing[int] = Field(default=UNSET)


class Job(GitHubModel):
    """Job

    Information of a job execution in a workflow run
    """

    id: int = Field(description="The id of the job.")
    run_id: int = Field(description="The id of the associated workflow run.")
    run_url: str = Field()
    run_attempt: Missing[int] = Field(
        default=UNSET,
        description="Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.",
    )
    node_id: str = Field()
    head_sha: str = Field(description="The SHA of the commit that is being run.")
    url: str = Field()
    html_url: Union[str, None] = Field()
    status: Literal["queued", "in_progress", "completed", "waiting"] = Field(
        description="The phase of the lifecycle that the job is currently in."
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ] = Field(description="The outcome of the job.")
    created_at: datetime = Field(
        description="The time that the job created, in ISO 8601 format."
    )
    started_at: datetime = Field(
        description="The time that the job started, in ISO 8601 format."
    )
    completed_at: Union[datetime, None] = Field(
        description="The time that the job finished, in ISO 8601 format."
    )
    name: str = Field(description="The name of the job.")
    steps: Missing[List[JobPropStepsItems]] = Field(
        default=UNSET, description="Steps in this job."
    )
    check_run_url: str = Field()
    labels: List[str] = Field(
        description='Labels for the workflow job. Specified by the "runs_on" attribute in the action\'s workflow file.'
    )
    runner_id: Union[int, None] = Field(
        description="The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)"
    )
    runner_name: Union[str, None] = Field(
        description="The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)"
    )
    runner_group_id: Union[int, None] = Field(
        description="The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)"
    )
    runner_group_name: Union[str, None] = Field(
        description="The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)"
    )
    workflow_name: Union[str, None] = Field(description="The name of the workflow.")
    head_branch: Union[str, None] = Field(description="The name of the current branch.")


class JobPropStepsItems(GitHubModel):
    """JobPropStepsItems"""

    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The phase of the lifecycle that the job is currently in."
    )
    conclusion: Union[str, None] = Field(description="The outcome of the job.")
    name: str = Field(description="The name of the job.")
    number: int = Field()
    started_at: Missing[Union[datetime, None]] = Field(
        default=UNSET, description="The time that the step started, in ISO 8601 format."
    )
    completed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET, description="The time that the job finished, in ISO 8601 format."
    )


class OidcCustomSubRepo(GitHubModel):
    """Actions OIDC subject customization for a repository

    Actions OIDC subject customization for a repository
    """

    use_default: bool = Field(
        description="Whether to use the default template or not. If `true`, the `include_claim_keys` field is ignored."
    )
    include_claim_keys: Missing[List[str]] = Field(
        default=UNSET,
        description="Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.",
    )


class ActionsSecret(GitHubModel):
    """Actions Secret

    Set secrets for GitHub Actions.
    """

    name: str = Field(description="The name of the secret.")
    created_at: datetime = Field()
    updated_at: datetime = Field()


class ActionsVariable(GitHubModel):
    """Actions Variable"""

    name: str = Field(description="The name of the variable.")
    value: str = Field(description="The value of the variable.")
    created_at: datetime = Field(
        description="The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )
    updated_at: datetime = Field(
        description="The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )


class ActionsRepositoryPermissions(GitHubModel):
    """ActionsRepositoryPermissions"""

    enabled: bool = Field(
        description="Whether GitHub Actions is enabled on the repository."
    )
    allowed_actions: Missing[Literal["all", "local_only", "selected"]] = Field(
        default=UNSET,
        description="The permissions policy that controls the actions and reusable workflows that are allowed to run.",
    )
    selected_actions_url: Missing[str] = Field(
        default=UNSET,
        description="The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.",
    )


class ActionsWorkflowAccessToRepository(GitHubModel):
    """ActionsWorkflowAccessToRepository"""

    access_level: Literal["none", "user", "organization"] = Field(
        description="Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the\nrepository.\n\n`none` means the access is only possible from workflows in this repository. `user` level access allows sharing across user owned private repositories only. `organization` level access allows sharing across the organization."
    )


class ReferencedWorkflow(GitHubModel):
    """Referenced workflow

    A workflow referenced/reused by the initial caller workflow
    """

    path: str = Field()
    sha: str = Field()
    ref: Missing[str] = Field(default=UNSET)


class PullRequestMinimal(GitHubModel):
    """Pull Request Minimal"""

    id: int = Field()
    number: int = Field()
    url: str = Field()
    head: PullRequestMinimalPropHead = Field()
    base: PullRequestMinimalPropBase = Field()


class PullRequestMinimalPropHead(GitHubModel):
    """PullRequestMinimalPropHead"""

    ref: str = Field()
    sha: str = Field()
    repo: PullRequestMinimalPropHeadPropRepo = Field()


class PullRequestMinimalPropHeadPropRepo(GitHubModel):
    """PullRequestMinimalPropHeadPropRepo"""

    id: int = Field()
    url: str = Field()
    name: str = Field()


class PullRequestMinimalPropBase(GitHubModel):
    """PullRequestMinimalPropBase"""

    ref: str = Field()
    sha: str = Field()
    repo: PullRequestMinimalPropBasePropRepo = Field()


class PullRequestMinimalPropBasePropRepo(GitHubModel):
    """PullRequestMinimalPropBasePropRepo"""

    id: int = Field()
    url: str = Field()
    name: str = Field()


class SimpleCommit(GitHubModel):
    """Simple Commit

    A commit.
    """

    id: str = Field(description="SHA for the commit")
    tree_id: str = Field(description="SHA for the commit's tree")
    message: str = Field(description="Message describing the purpose of the commit")
    timestamp: datetime = Field(description="Timestamp of the commit")
    author: Union[SimpleCommitPropAuthor, None] = Field(
        description="Information about the Git author"
    )
    committer: Union[SimpleCommitPropCommitter, None] = Field(
        description="Information about the Git committer"
    )


class SimpleCommitPropAuthor(GitHubModel):
    """SimpleCommitPropAuthor

    Information about the Git author
    """

    name: str = Field(description="Name of the commit's author")
    email: str = Field(description="Git email address of the commit's author")


class SimpleCommitPropCommitter(GitHubModel):
    """SimpleCommitPropCommitter

    Information about the Git committer
    """

    name: str = Field(description="Name of the commit's committer")
    email: str = Field(description="Git email address of the commit's committer")


class WorkflowRun(GitHubModel):
    """Workflow Run

    An invocation of a workflow
    """

    id: int = Field(description="The ID of the workflow run.")
    name: Missing[Union[str, None]] = Field(
        default=UNSET, description="The name of the workflow run."
    )
    node_id: str = Field()
    check_suite_id: Missing[int] = Field(
        default=UNSET, description="The ID of the associated check suite."
    )
    check_suite_node_id: Missing[str] = Field(
        default=UNSET, description="The node ID of the associated check suite."
    )
    head_branch: Union[str, None] = Field()
    head_sha: str = Field(
        description="The SHA of the head commit that points to the version of the workflow being run."
    )
    path: str = Field(description="The full path of the workflow")
    run_number: int = Field(
        description="The auto incrementing run number for the workflow run."
    )
    run_attempt: Missing[int] = Field(
        default=UNSET,
        description="Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.",
    )
    referenced_workflows: Missing[Union[List[ReferencedWorkflow], None]] = Field(
        default=UNSET
    )
    event: str = Field()
    status: Union[str, None] = Field()
    conclusion: Union[str, None] = Field()
    workflow_id: int = Field(description="The ID of the parent workflow.")
    url: str = Field(description="The URL to the workflow run.")
    html_url: str = Field()
    pull_requests: Union[List[PullRequestMinimal], None] = Field(
        description="Pull requests that are open with a `head_sha` or `head_branch` that matches the workflow run. The returned pull requests do not necessarily indicate pull requests that triggered the run."
    )
    created_at: datetime = Field()
    updated_at: datetime = Field()
    actor: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )
    triggering_actor: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )
    run_started_at: Missing[datetime] = Field(
        default=UNSET, description="The start time of the latest run. Resets on re-run."
    )
    jobs_url: str = Field(description="The URL to the jobs for the workflow run.")
    logs_url: str = Field(
        description="The URL to download the logs for the workflow run."
    )
    check_suite_url: str = Field(description="The URL to the associated check suite.")
    artifacts_url: str = Field(
        description="The URL to the artifacts for the workflow run."
    )
    cancel_url: str = Field(description="The URL to cancel the workflow run.")
    rerun_url: str = Field(description="The URL to rerun the workflow run.")
    previous_attempt_url: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The URL to the previous attempted run of this workflow, if one exists.",
    )
    workflow_url: str = Field(description="The URL to the workflow.")
    head_commit: Union[None, SimpleCommit] = Field()
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )
    head_repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )
    head_repository_id: Missing[int] = Field(default=UNSET)
    display_title: str = Field(
        description="The event-specific title associated with the run or the run-name if set, or the value of `run-name` if it is set in the workflow."
    )


class EnvironmentApprovals(GitHubModel):
    """Environment Approval

    An entry in the reviews log for environment deployments
    """

    environments: List[EnvironmentApprovalsPropEnvironmentsItems] = Field(
        description="The list of environments that were approved or rejected"
    )
    state: Literal["approved", "rejected", "pending"] = Field(
        description="Whether deployment to the environment(s) was approved or rejected or pending (with comments)"
    )
    user: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    comment: str = Field(description="The comment submitted with the deployment review")


class EnvironmentApprovalsPropEnvironmentsItems(GitHubModel):
    """EnvironmentApprovalsPropEnvironmentsItems"""

    id: Missing[int] = Field(default=UNSET, description="The id of the environment.")
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(
        default=UNSET, description="The name of the environment."
    )
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(
        default=UNSET,
        description="The time that the environment was created, in ISO 8601 format.",
    )
    updated_at: Missing[datetime] = Field(
        default=UNSET,
        description="The time that the environment was last updated, in ISO 8601 format.",
    )


class ReviewCustomGatesCommentRequired(GitHubModel):
    """ReviewCustomGatesCommentRequired"""

    environment_name: str = Field(
        description="The name of the environment to approve or reject."
    )
    comment: str = Field(
        description="Comment associated with the pending deployment protection rule. **Required when state is not provided.**"
    )


class ReviewCustomGatesStateRequired(GitHubModel):
    """ReviewCustomGatesStateRequired"""

    environment_name: str = Field(
        description="The name of the environment to approve or reject."
    )
    state: Literal["approved", "rejected"] = Field(
        description="Whether to approve or reject deployment to the specified environments."
    )
    comment: Missing[str] = Field(
        default=UNSET, description="Optional comment to include with the review."
    )


class PendingDeployment(GitHubModel):
    """Pending Deployment

    Details of a deployment that is waiting for protection rules to pass
    """

    environment: PendingDeploymentPropEnvironment = Field()
    wait_timer: int = Field(description="The set duration of the wait timer")
    wait_timer_started_at: Union[datetime, None] = Field(
        description="The time that the wait timer began."
    )
    current_user_can_approve: bool = Field(
        description="Whether the currently authenticated user can approve the deployment"
    )
    reviewers: List[PendingDeploymentPropReviewersItems] = Field(
        description="The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed."
    )


class PendingDeploymentPropEnvironment(GitHubModel):
    """PendingDeploymentPropEnvironment"""

    id: Missing[int] = Field(default=UNSET, description="The id of the environment.")
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(
        default=UNSET, description="The name of the environment."
    )
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)


class PendingDeploymentPropReviewersItems(GitHubModel):
    """PendingDeploymentPropReviewersItems"""

    type: Missing[Literal["User", "Team"]] = Field(
        default=UNSET, description="The type of reviewer."
    )
    reviewer: Missing[Union[SimpleUser, Team]] = Field(default=UNSET)


class Deployment(GitHubModel):
    """Deployment

    A request for a specific ref(branch,sha,tag) to be deployed
    """

    url: str = Field()
    id: int = Field(description="Unique identifier of the deployment")
    node_id: str = Field()
    sha: str = Field()
    ref: str = Field(
        description="The ref to deploy. This can be a branch, tag, or sha."
    )
    task: str = Field(description="Parameter to specify a task to execute")
    payload: Union[DeploymentPropPayloadOneof0, str] = Field()
    original_environment: Missing[str] = Field(default=UNSET)
    environment: str = Field(description="Name for the target deployment environment.")
    description: Union[str, None] = Field()
    creator: Union[None, SimpleUser] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    statuses_url: str = Field()
    repository_url: str = Field()
    transient_environment: Missing[bool] = Field(
        default=UNSET,
        description="Specifies if the given environment is will no longer exist at some point in the future. Default: false.",
    )
    production_environment: Missing[bool] = Field(
        default=UNSET,
        description="Specifies if the given environment is one that end-users directly interact with. Default: false.",
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(default=UNSET)


class DeploymentPropPayloadOneof0(ExtraGitHubModel):
    """DeploymentPropPayloadOneof0"""


class WorkflowRunUsage(GitHubModel):
    """Workflow Run Usage

    Workflow Run Usage
    """

    billable: WorkflowRunUsagePropBillable = Field()
    run_duration_ms: Missing[int] = Field(default=UNSET)


class WorkflowRunUsagePropBillable(GitHubModel):
    """WorkflowRunUsagePropBillable"""

    ubuntu: Missing[WorkflowRunUsagePropBillablePropUbuntu] = Field(
        default=UNSET, alias="UBUNTU"
    )
    macos: Missing[WorkflowRunUsagePropBillablePropMacos] = Field(
        default=UNSET, alias="MACOS"
    )
    windows: Missing[WorkflowRunUsagePropBillablePropWindows] = Field(
        default=UNSET, alias="WINDOWS"
    )


class WorkflowRunUsagePropBillablePropUbuntu(GitHubModel):
    """WorkflowRunUsagePropBillablePropUbuntu"""

    total_ms: int = Field()
    jobs: int = Field()
    job_runs: Missing[
        List[WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems]
    ] = Field(default=UNSET)


class WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems(GitHubModel):
    """WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems"""

    job_id: int = Field()
    duration_ms: int = Field()


class WorkflowRunUsagePropBillablePropMacos(GitHubModel):
    """WorkflowRunUsagePropBillablePropMacos"""

    total_ms: int = Field()
    jobs: int = Field()
    job_runs: Missing[
        List[WorkflowRunUsagePropBillablePropMacosPropJobRunsItems]
    ] = Field(default=UNSET)


class WorkflowRunUsagePropBillablePropMacosPropJobRunsItems(GitHubModel):
    """WorkflowRunUsagePropBillablePropMacosPropJobRunsItems"""

    job_id: int = Field()
    duration_ms: int = Field()


class WorkflowRunUsagePropBillablePropWindows(GitHubModel):
    """WorkflowRunUsagePropBillablePropWindows"""

    total_ms: int = Field()
    jobs: int = Field()
    job_runs: Missing[
        List[WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems]
    ] = Field(default=UNSET)


class WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems(GitHubModel):
    """WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems"""

    job_id: int = Field()
    duration_ms: int = Field()


class Workflow(GitHubModel):
    """Workflow

    A GitHub Actions workflow
    """

    id: int = Field()
    node_id: str = Field()
    name: str = Field()
    path: str = Field()
    state: Literal[
        "active", "deleted", "disabled_fork", "disabled_inactivity", "disabled_manually"
    ] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    url: str = Field()
    html_url: str = Field()
    badge_url: str = Field()
    deleted_at: Missing[datetime] = Field(default=UNSET)


class WorkflowUsage(GitHubModel):
    """Workflow Usage

    Workflow Usage
    """

    billable: WorkflowUsagePropBillable = Field()


class WorkflowUsagePropBillable(GitHubModel):
    """WorkflowUsagePropBillable"""

    ubuntu: Missing[WorkflowUsagePropBillablePropUbuntu] = Field(
        default=UNSET, alias="UBUNTU"
    )
    macos: Missing[WorkflowUsagePropBillablePropMacos] = Field(
        default=UNSET, alias="MACOS"
    )
    windows: Missing[WorkflowUsagePropBillablePropWindows] = Field(
        default=UNSET, alias="WINDOWS"
    )


class WorkflowUsagePropBillablePropUbuntu(GitHubModel):
    """WorkflowUsagePropBillablePropUbuntu"""

    total_ms: Missing[int] = Field(default=UNSET)


class WorkflowUsagePropBillablePropMacos(GitHubModel):
    """WorkflowUsagePropBillablePropMacos"""

    total_ms: Missing[int] = Field(default=UNSET)


class WorkflowUsagePropBillablePropWindows(GitHubModel):
    """WorkflowUsagePropBillablePropWindows"""

    total_ms: Missing[int] = Field(default=UNSET)


class Activity(GitHubModel):
    """Activity

    Activity
    """

    id: int = Field()
    node_id: str = Field()
    before: str = Field(description="The SHA of the commit before the activity.")
    after: str = Field(description="The SHA of the commit after the activity.")
    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`."
    )
    timestamp: datetime = Field(description="The time when the activity occurred.")
    activity_type: Literal[
        "push",
        "force_push",
        "branch_deletion",
        "branch_creation",
        "pr_merge",
        "merge_queue_merge",
    ] = Field(description="The type of the activity that was performed.")
    actor: Union[None, SimpleUser] = Field()


class Autolink(GitHubModel):
    """Autolink reference

    An autolink reference.
    """

    id: int = Field()
    key_prefix: str = Field(description="The prefix of a key that is linkified.")
    url_template: str = Field(
        description="A template for the target URL that is generated if a key was found."
    )
    is_alphanumeric: bool = Field(
        description="Whether this autolink reference matches alphanumeric characters. If false, this autolink reference only matches numeric characters."
    )


class CheckAutomatedSecurityFixes(GitHubModel):
    """Check Automated Security Fixes

    Check Automated Security Fixes
    """

    enabled: bool = Field(
        description="Whether automated security fixes are enabled for the repository."
    )
    paused: bool = Field(
        description="Whether automated security fixes are paused for the repository."
    )


class ProtectedBranchRequiredStatusCheck(GitHubModel):
    """Protected Branch Required Status Check

    Protected Branch Required Status Check
    """

    url: Missing[str] = Field(default=UNSET)
    enforcement_level: Missing[str] = Field(default=UNSET)
    contexts: List[str] = Field()
    checks: List[ProtectedBranchRequiredStatusCheckPropChecksItems] = Field()
    contexts_url: Missing[str] = Field(default=UNSET)
    strict: Missing[bool] = Field(default=UNSET)


class ProtectedBranchRequiredStatusCheckPropChecksItems(GitHubModel):
    """ProtectedBranchRequiredStatusCheckPropChecksItems"""

    context: str = Field()
    app_id: Union[int, None] = Field()


class ProtectedBranchAdminEnforced(GitHubModel):
    """Protected Branch Admin Enforced

    Protected Branch Admin Enforced
    """

    url: str = Field()
    enabled: bool = Field()


class ProtectedBranchPullRequestReview(GitHubModel):
    """Protected Branch Pull Request Review

    Protected Branch Pull Request Review
    """

    url: Missing[str] = Field(default=UNSET)
    dismissal_restrictions: Missing[
        ProtectedBranchPullRequestReviewPropDismissalRestrictions
    ] = Field(default=UNSET)
    bypass_pull_request_allowances: Missing[
        ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances
    ] = Field(
        default=UNSET,
        description="Allow specific users, teams, or apps to bypass pull request requirements.",
    )
    dismiss_stale_reviews: bool = Field()
    require_code_owner_reviews: bool = Field()
    required_approving_review_count: Missing[Annotated[int, Field(le=6.0)]] = Field(
        default=UNSET
    )
    require_last_push_approval: Missing[bool] = Field(
        default=UNSET,
        description="Whether the most recent push must be approved by someone other than the person who pushed it.",
    )


class ProtectedBranchPullRequestReviewPropDismissalRestrictions(GitHubModel):
    """ProtectedBranchPullRequestReviewPropDismissalRestrictions"""

    users: Missing[List[SimpleUser]] = Field(
        default=UNSET, description="The list of users with review dismissal access."
    )
    teams: Missing[List[Team]] = Field(
        default=UNSET, description="The list of teams with review dismissal access."
    )
    apps: Missing[List[Integration]] = Field(
        default=UNSET, description="The list of apps with review dismissal access."
    )
    url: Missing[str] = Field(default=UNSET)
    users_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)


class ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances(GitHubModel):
    """ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances

    Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: Missing[List[SimpleUser]] = Field(
        default=UNSET,
        description="The list of users allowed to bypass pull request requirements.",
    )
    teams: Missing[List[Team]] = Field(
        default=UNSET,
        description="The list of teams allowed to bypass pull request requirements.",
    )
    apps: Missing[List[Integration]] = Field(
        default=UNSET,
        description="The list of apps allowed to bypass pull request requirements.",
    )


class BranchRestrictionPolicy(GitHubModel):
    """Branch Restriction Policy

    Branch Restriction Policy
    """

    url: str = Field()
    users_url: str = Field()
    teams_url: str = Field()
    apps_url: str = Field()
    users: List[BranchRestrictionPolicyPropUsersItems] = Field()
    teams: List[BranchRestrictionPolicyPropTeamsItems] = Field()
    apps: List[BranchRestrictionPolicyPropAppsItems] = Field()


class BranchRestrictionPolicyPropUsersItems(GitHubModel):
    """BranchRestrictionPolicyPropUsersItems"""

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)


class BranchRestrictionPolicyPropTeamsItems(GitHubModel):
    """BranchRestrictionPolicyPropTeamsItems"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    privacy: Missing[str] = Field(default=UNSET)
    notification_setting: Missing[str] = Field(default=UNSET)
    permission: Missing[str] = Field(default=UNSET)
    members_url: Missing[str] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    parent: Missing[Union[str, None]] = Field(default=UNSET)


class BranchRestrictionPolicyPropAppsItems(GitHubModel):
    """BranchRestrictionPolicyPropAppsItems"""

    id: Missing[int] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    owner: Missing[BranchRestrictionPolicyPropAppsItemsPropOwner] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    description: Missing[str] = Field(default=UNSET)
    external_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    permissions: Missing[BranchRestrictionPolicyPropAppsItemsPropPermissions] = Field(
        default=UNSET
    )
    events: Missing[List[str]] = Field(default=UNSET)


class BranchRestrictionPolicyPropAppsItemsPropOwner(GitHubModel):
    """BranchRestrictionPolicyPropAppsItemsPropOwner"""

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    members_url: Missing[str] = Field(default=UNSET)
    public_members_url: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    description: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)


class BranchRestrictionPolicyPropAppsItemsPropPermissions(GitHubModel):
    """BranchRestrictionPolicyPropAppsItemsPropPermissions"""

    metadata: Missing[str] = Field(default=UNSET)
    contents: Missing[str] = Field(default=UNSET)
    issues: Missing[str] = Field(default=UNSET)
    single_file: Missing[str] = Field(default=UNSET)


class BranchProtection(GitHubModel):
    """Branch Protection

    Branch Protection
    """

    url: Missing[str] = Field(default=UNSET)
    enabled: Missing[bool] = Field(default=UNSET)
    required_status_checks: Missing[ProtectedBranchRequiredStatusCheck] = Field(
        default=UNSET,
        title="Protected Branch Required Status Check",
        description="Protected Branch Required Status Check",
    )
    enforce_admins: Missing[ProtectedBranchAdminEnforced] = Field(
        default=UNSET,
        title="Protected Branch Admin Enforced",
        description="Protected Branch Admin Enforced",
    )
    required_pull_request_reviews: Missing[ProtectedBranchPullRequestReview] = Field(
        default=UNSET,
        title="Protected Branch Pull Request Review",
        description="Protected Branch Pull Request Review",
    )
    restrictions: Missing[BranchRestrictionPolicy] = Field(
        default=UNSET,
        title="Branch Restriction Policy",
        description="Branch Restriction Policy",
    )
    required_linear_history: Missing[BranchProtectionPropRequiredLinearHistory] = Field(
        default=UNSET
    )
    allow_force_pushes: Missing[BranchProtectionPropAllowForcePushes] = Field(
        default=UNSET
    )
    allow_deletions: Missing[BranchProtectionPropAllowDeletions] = Field(default=UNSET)
    block_creations: Missing[BranchProtectionPropBlockCreations] = Field(default=UNSET)
    required_conversation_resolution: Missing[
        BranchProtectionPropRequiredConversationResolution
    ] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    protection_url: Missing[str] = Field(default=UNSET)
    required_signatures: Missing[BranchProtectionPropRequiredSignatures] = Field(
        default=UNSET
    )
    lock_branch: Missing[BranchProtectionPropLockBranch] = Field(
        default=UNSET,
        description="Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.",
    )
    allow_fork_syncing: Missing[BranchProtectionPropAllowForkSyncing] = Field(
        default=UNSET,
        description="Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.",
    )


class BranchProtectionPropRequiredLinearHistory(GitHubModel):
    """BranchProtectionPropRequiredLinearHistory"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropAllowForcePushes(GitHubModel):
    """BranchProtectionPropAllowForcePushes"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropAllowDeletions(GitHubModel):
    """BranchProtectionPropAllowDeletions"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropBlockCreations(GitHubModel):
    """BranchProtectionPropBlockCreations"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropRequiredConversationResolution(GitHubModel):
    """BranchProtectionPropRequiredConversationResolution"""

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropRequiredSignatures(GitHubModel):
    """BranchProtectionPropRequiredSignatures"""

    url: str = Field()
    enabled: bool = Field()


class BranchProtectionPropLockBranch(GitHubModel):
    """BranchProtectionPropLockBranch

    Whether to set the branch as read-only. If this is true, users will not be able
    to push to the branch.
    """

    enabled: Missing[bool] = Field(default=UNSET)


class BranchProtectionPropAllowForkSyncing(GitHubModel):
    """BranchProtectionPropAllowForkSyncing

    Whether users can pull changes from upstream when the branch is locked. Set to
    `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """

    enabled: Missing[bool] = Field(default=UNSET)


class ShortBranch(GitHubModel):
    """Short Branch

    Short Branch
    """

    name: str = Field()
    commit: ShortBranchPropCommit = Field()
    protected: bool = Field()
    protection: Missing[BranchProtection] = Field(
        default=UNSET, title="Branch Protection", description="Branch Protection"
    )
    protection_url: Missing[str] = Field(default=UNSET)


class ShortBranchPropCommit(GitHubModel):
    """ShortBranchPropCommit"""

    sha: str = Field()
    url: str = Field()


class GitUser(GitHubModel):
    """Git User

    Metaproperties for Git author/committer information.
    """

    name: Missing[str] = Field(default=UNSET)
    email: Missing[str] = Field(default=UNSET)
    date: Missing[str] = Field(default=UNSET)


class Verification(GitHubModel):
    """Verification"""

    verified: bool = Field()
    reason: str = Field()
    payload: Union[str, None] = Field()
    signature: Union[str, None] = Field()


class DiffEntry(GitHubModel):
    """Diff Entry

    Diff Entry
    """

    sha: str = Field()
    filename: str = Field()
    status: Literal[
        "added", "removed", "modified", "renamed", "copied", "changed", "unchanged"
    ] = Field()
    additions: int = Field()
    deletions: int = Field()
    changes: int = Field()
    blob_url: str = Field()
    raw_url: str = Field()
    contents_url: str = Field()
    patch: Missing[str] = Field(default=UNSET)
    previous_filename: Missing[str] = Field(default=UNSET)


class Commit(GitHubModel):
    """Commit

    Commit
    """

    url: str = Field()
    sha: str = Field()
    node_id: str = Field()
    html_url: str = Field()
    comments_url: str = Field()
    commit: CommitPropCommit = Field()
    author: Union[None, SimpleUser] = Field()
    committer: Union[None, SimpleUser] = Field()
    parents: List[CommitPropParentsItems] = Field()
    stats: Missing[CommitPropStats] = Field(default=UNSET)
    files: Missing[List[DiffEntry]] = Field(default=UNSET)


class CommitPropCommit(GitHubModel):
    """CommitPropCommit"""

    url: str = Field()
    author: Union[None, GitUser] = Field()
    committer: Union[None, GitUser] = Field()
    message: str = Field()
    comment_count: int = Field()
    tree: CommitPropCommitPropTree = Field()
    verification: Missing[Verification] = Field(default=UNSET, title="Verification")


class CommitPropCommitPropTree(GitHubModel):
    """CommitPropCommitPropTree"""

    sha: str = Field()
    url: str = Field()


class CommitPropParentsItems(GitHubModel):
    """CommitPropParentsItems"""

    sha: str = Field()
    url: str = Field()
    html_url: Missing[str] = Field(default=UNSET)


class CommitPropStats(GitHubModel):
    """CommitPropStats"""

    additions: Missing[int] = Field(default=UNSET)
    deletions: Missing[int] = Field(default=UNSET)
    total: Missing[int] = Field(default=UNSET)


class BranchWithProtection(GitHubModel):
    """Branch With Protection

    Branch With Protection
    """

    name: str = Field()
    commit: Commit = Field(title="Commit", description="Commit")
    links: BranchWithProtectionPropLinks = Field(alias="_links")
    protected: bool = Field()
    protection: BranchProtection = Field(
        title="Branch Protection", description="Branch Protection"
    )
    protection_url: str = Field()
    pattern: Missing[str] = Field(default=UNSET)
    required_approving_review_count: Missing[int] = Field(default=UNSET)


class BranchWithProtectionPropLinks(GitHubModel):
    """BranchWithProtectionPropLinks"""

    html: str = Field()
    self_: str = Field(alias="self")


class StatusCheckPolicy(GitHubModel):
    """Status Check Policy

    Status Check Policy
    """

    url: str = Field()
    strict: bool = Field()
    contexts: List[str] = Field()
    checks: List[StatusCheckPolicyPropChecksItems] = Field()
    contexts_url: str = Field()


class StatusCheckPolicyPropChecksItems(GitHubModel):
    """StatusCheckPolicyPropChecksItems"""

    context: str = Field()
    app_id: Union[int, None] = Field()


class ProtectedBranch(GitHubModel):
    """Protected Branch

    Branch protections protect branches
    """

    url: str = Field()
    required_status_checks: Missing[StatusCheckPolicy] = Field(
        default=UNSET, title="Status Check Policy", description="Status Check Policy"
    )
    required_pull_request_reviews: Missing[
        ProtectedBranchPropRequiredPullRequestReviews
    ] = Field(default=UNSET)
    required_signatures: Missing[ProtectedBranchPropRequiredSignatures] = Field(
        default=UNSET
    )
    enforce_admins: Missing[ProtectedBranchPropEnforceAdmins] = Field(default=UNSET)
    required_linear_history: Missing[ProtectedBranchPropRequiredLinearHistory] = Field(
        default=UNSET
    )
    allow_force_pushes: Missing[ProtectedBranchPropAllowForcePushes] = Field(
        default=UNSET
    )
    allow_deletions: Missing[ProtectedBranchPropAllowDeletions] = Field(default=UNSET)
    restrictions: Missing[BranchRestrictionPolicy] = Field(
        default=UNSET,
        title="Branch Restriction Policy",
        description="Branch Restriction Policy",
    )
    required_conversation_resolution: Missing[
        ProtectedBranchPropRequiredConversationResolution
    ] = Field(default=UNSET)
    block_creations: Missing[ProtectedBranchPropBlockCreations] = Field(default=UNSET)
    lock_branch: Missing[ProtectedBranchPropLockBranch] = Field(
        default=UNSET,
        description="Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.",
    )
    allow_fork_syncing: Missing[ProtectedBranchPropAllowForkSyncing] = Field(
        default=UNSET,
        description="Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.",
    )


class ProtectedBranchPropRequiredPullRequestReviews(GitHubModel):
    """ProtectedBranchPropRequiredPullRequestReviews"""

    url: str = Field()
    dismiss_stale_reviews: Missing[bool] = Field(default=UNSET)
    require_code_owner_reviews: Missing[bool] = Field(default=UNSET)
    required_approving_review_count: Missing[int] = Field(default=UNSET)
    require_last_push_approval: Missing[bool] = Field(
        default=UNSET,
        description="Whether the most recent push must be approved by someone other than the person who pushed it.",
    )
    dismissal_restrictions: Missing[
        ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions
    ] = Field(default=UNSET)
    bypass_pull_request_allowances: Missing[
        ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances
    ] = Field(default=UNSET)


class ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions(
    GitHubModel
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions"""

    url: str = Field()
    users_url: str = Field()
    teams_url: str = Field()
    users: List[SimpleUser] = Field()
    teams: List[Team] = Field()
    apps: Missing[List[Integration]] = Field(default=UNSET)


class ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances(
    GitHubModel
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances"""

    users: List[SimpleUser] = Field()
    teams: List[Team] = Field()
    apps: Missing[List[Integration]] = Field(default=UNSET)


class ProtectedBranchPropRequiredSignatures(GitHubModel):
    """ProtectedBranchPropRequiredSignatures"""

    url: str = Field()
    enabled: bool = Field()


class ProtectedBranchPropEnforceAdmins(GitHubModel):
    """ProtectedBranchPropEnforceAdmins"""

    url: str = Field()
    enabled: bool = Field()


class ProtectedBranchPropRequiredLinearHistory(GitHubModel):
    """ProtectedBranchPropRequiredLinearHistory"""

    enabled: bool = Field()


class ProtectedBranchPropAllowForcePushes(GitHubModel):
    """ProtectedBranchPropAllowForcePushes"""

    enabled: bool = Field()


class ProtectedBranchPropAllowDeletions(GitHubModel):
    """ProtectedBranchPropAllowDeletions"""

    enabled: bool = Field()


class ProtectedBranchPropRequiredConversationResolution(GitHubModel):
    """ProtectedBranchPropRequiredConversationResolution"""

    enabled: Missing[bool] = Field(default=UNSET)


class ProtectedBranchPropBlockCreations(GitHubModel):
    """ProtectedBranchPropBlockCreations"""

    enabled: bool = Field()


class ProtectedBranchPropLockBranch(GitHubModel):
    """ProtectedBranchPropLockBranch

    Whether to set the branch as read-only. If this is true, users will not be able
    to push to the branch.
    """

    enabled: Missing[bool] = Field(default=UNSET)


class ProtectedBranchPropAllowForkSyncing(GitHubModel):
    """ProtectedBranchPropAllowForkSyncing

    Whether users can pull changes from upstream when the branch is locked. Set to
    `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """

    enabled: Missing[bool] = Field(default=UNSET)


class DeploymentSimple(GitHubModel):
    """Deployment

    A deployment created as the result of an Actions check run from a workflow that
    references an environment
    """

    url: str = Field()
    id: int = Field(description="Unique identifier of the deployment")
    node_id: str = Field()
    task: str = Field(description="Parameter to specify a task to execute")
    original_environment: Missing[str] = Field(default=UNSET)
    environment: str = Field(description="Name for the target deployment environment.")
    description: Union[str, None] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    statuses_url: str = Field()
    repository_url: str = Field()
    transient_environment: Missing[bool] = Field(
        default=UNSET,
        description="Specifies if the given environment is will no longer exist at some point in the future. Default: false.",
    )
    production_environment: Missing[bool] = Field(
        default=UNSET,
        description="Specifies if the given environment is one that end-users directly interact with. Default: false.",
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(default=UNSET)


class CheckRun(GitHubModel):
    """CheckRun

    A check performed on the code of a given code change
    """

    id: int = Field(description="The id of the check.")
    head_sha: str = Field(description="The SHA of the commit that is being checked.")
    node_id: str = Field()
    external_id: Union[str, None] = Field()
    url: str = Field()
    html_url: Union[str, None] = Field()
    details_url: Union[str, None] = Field()
    status: Literal["queued", "in_progress", "completed"] = Field(
        description="The phase of the lifecycle that the check is currently in."
    )
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ] = Field()
    started_at: Union[datetime, None] = Field()
    completed_at: Union[datetime, None] = Field()
    output: CheckRunPropOutput = Field()
    name: str = Field(description="The name of the check.")
    check_suite: Union[CheckRunPropCheckSuite, None] = Field()
    app: Union[None, Integration] = Field()
    pull_requests: List[PullRequestMinimal] = Field(
        description="Pull requests that are open with a `head_sha` or `head_branch` that matches the check. The returned pull requests do not necessarily indicate pull requests that triggered the check."
    )
    deployment: Missing[DeploymentSimple] = Field(
        default=UNSET,
        title="Deployment",
        description="A deployment created as the result of an Actions check run from a workflow that references an environment",
    )


class CheckRunPropOutput(GitHubModel):
    """CheckRunPropOutput"""

    title: Union[str, None] = Field()
    summary: Union[str, None] = Field()
    text: Union[str, None] = Field()
    annotations_count: int = Field()
    annotations_url: str = Field()


class CheckRunPropCheckSuite(GitHubModel):
    """CheckRunPropCheckSuite"""

    id: int = Field()


class CheckAnnotation(GitHubModel):
    """Check Annotation

    Check Annotation
    """

    path: str = Field()
    start_line: int = Field()
    end_line: int = Field()
    start_column: Union[int, None] = Field()
    end_column: Union[int, None] = Field()
    annotation_level: Union[str, None] = Field()
    title: Union[str, None] = Field()
    message: Union[str, None] = Field()
    raw_details: Union[str, None] = Field()
    blob_href: str = Field()


class CheckSuite(GitHubModel):
    """CheckSuite

    A suite of checks performed on the code of a given code change
    """

    id: int = Field()
    node_id: str = Field()
    head_branch: Union[str, None] = Field()
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked."
    )
    status: Union[None, Literal["queued", "in_progress", "completed"]] = Field()
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
            "startup_failure",
            "stale",
        ],
    ] = Field()
    url: Union[str, None] = Field()
    before: Union[str, None] = Field()
    after: Union[str, None] = Field()
    pull_requests: Union[List[PullRequestMinimal], None] = Field()
    app: Union[None, Integration] = Field()
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )
    created_at: Union[datetime, None] = Field()
    updated_at: Union[datetime, None] = Field()
    head_commit: SimpleCommit = Field(title="Simple Commit", description="A commit.")
    latest_check_runs_count: int = Field()
    check_runs_url: str = Field()
    rerequestable: Missing[bool] = Field(default=UNSET)
    runs_rerequestable: Missing[bool] = Field(default=UNSET)


class CheckSuitePreference(GitHubModel):
    """Check Suite Preference

    Check suite configuration preferences for a repository.
    """

    preferences: CheckSuitePreferencePropPreferences = Field()
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )


class CheckSuitePreferencePropPreferences(GitHubModel):
    """CheckSuitePreferencePropPreferences"""

    auto_trigger_checks: Missing[
        List[CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems]
    ] = Field(default=UNSET)


class CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems(GitHubModel):
    """CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems"""

    app_id: int = Field()
    setting: bool = Field()


class CodeScanningAlertItems(GitHubModel):
    """CodeScanningAlertItems"""

    number: int = Field(description="The security alert number.")
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    updated_at: Missing[datetime] = Field(
        default=UNSET,
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    url: str = Field(description="The REST API URL of the alert resource.")
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    instances_url: str = Field(
        description="The REST API URL for fetching the list of instances for an alert."
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )
    fixed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    dismissed_by: Union[None, SimpleUser] = Field()
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert."
    )
    dismissed_comment: Missing[
        Union[Annotated[str, Field(max_length=280)], None]
    ] = Field(
        default=UNSET,
        description="The dismissal comment associated with the dismissal of the alert.",
    )
    rule: CodeScanningAlertRuleSummary = Field()
    tool: CodeScanningAnalysisTool = Field()
    most_recent_instance: CodeScanningAlertInstance = Field()


class CodeScanningAlertRule(GitHubModel):
    """CodeScanningAlertRule"""

    id: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="A unique identifier for the rule used to detect the alert.",
    )
    name: Missing[str] = Field(
        default=UNSET, description="The name of the rule used to detect the alert."
    )
    severity: Missing[Union[None, Literal["none", "note", "warning", "error"]]] = Field(
        default=UNSET, description="The severity of the alert."
    )
    security_severity_level: Missing[
        Union[None, Literal["low", "medium", "high", "critical"]]
    ] = Field(default=UNSET, description="The security severity of the alert.")
    description: Missing[str] = Field(
        default=UNSET,
        description="A short description of the rule used to detect the alert.",
    )
    full_description: Missing[str] = Field(
        default=UNSET, description="description of the rule used to detect the alert."
    )
    tags: Missing[Union[List[str], None]] = Field(
        default=UNSET, description="A set of tags applicable for the rule."
    )
    help_: Missing[Union[str, None]] = Field(
        default=UNSET,
        alias="help",
        description="Detailed documentation for the rule as GitHub Flavored Markdown.",
    )
    help_uri: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="A link to the documentation for the rule used to detect the alert.",
    )


class CodeScanningAlert(GitHubModel):
    """CodeScanningAlert"""

    number: int = Field(description="The security alert number.")
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    updated_at: Missing[datetime] = Field(
        default=UNSET,
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    url: str = Field(description="The REST API URL of the alert resource.")
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    instances_url: str = Field(
        description="The REST API URL for fetching the list of instances for an alert."
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )
    fixed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    dismissed_by: Union[None, SimpleUser] = Field()
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(
        description="**Required when the state is dismissed.** The reason for dismissing or closing the alert."
    )
    dismissed_comment: Missing[
        Union[Annotated[str, Field(max_length=280)], None]
    ] = Field(
        default=UNSET,
        description="The dismissal comment associated with the dismissal of the alert.",
    )
    rule: CodeScanningAlertRule = Field()
    tool: CodeScanningAnalysisTool = Field()
    most_recent_instance: CodeScanningAlertInstance = Field()


class CodeScanningAnalysis(GitHubModel):
    """CodeScanningAnalysis"""

    ref: str = Field(
        description="The Git reference, formatted as `refs/pull/<number>/merge`, `refs/pull/<number>/head`,\n`refs/heads/<branch name>` or simply `<branch name>`."
    )
    commit_sha: Annotated[
        str, Field(min_length=40, max_length=40, pattern="^[0-9a-fA-F]+$")
    ] = Field(
        description="The SHA of the commit to which the analysis you are uploading relates."
    )
    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name."
    )
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which this analysis was performed."
    )
    category: Missing[str] = Field(
        default=UNSET,
        description="Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.",
    )
    error: str = Field()
    created_at: datetime = Field(
        description="The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    results_count: int = Field(
        description="The total number of results in the analysis."
    )
    rules_count: int = Field(
        description="The total number of rules used in the analysis."
    )
    id: int = Field(description="Unique identifier for this analysis.")
    url: str = Field(description="The REST API URL of the analysis resource.")
    sarif_id: str = Field(description="An identifier for the upload.")
    tool: CodeScanningAnalysisTool = Field()
    deletable: bool = Field()
    warning: str = Field(description="Warning generated when processing the analysis")


class CodeScanningAnalysisDeletion(GitHubModel):
    """Analysis deletion

    Successful deletion of a code scanning analysis
    """

    next_analysis_url: Union[str, None] = Field(
        description="Next deletable analysis in chain, without last analysis deletion confirmation"
    )
    confirm_delete_url: Union[str, None] = Field(
        description="Next deletable analysis in chain, with last analysis deletion confirmation"
    )


class CodeScanningCodeqlDatabase(GitHubModel):
    """CodeQL Database

    A CodeQL database.
    """

    id: int = Field(description="The ID of the CodeQL database.")
    name: str = Field(description="The name of the CodeQL database.")
    language: str = Field(description="The language of the CodeQL database.")
    uploader: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    content_type: str = Field(description="The MIME type of the CodeQL database file.")
    size: int = Field(description="The size of the CodeQL database file in bytes.")
    created_at: datetime = Field(
        description="The date and time at which the CodeQL database was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )
    updated_at: datetime = Field(
        description="The date and time at which the CodeQL database was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )
    url: str = Field(
        description="The URL at which to download the CodeQL database. The `Accept` header must be set to the value of the `content_type` property."
    )
    commit_oid: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The commit SHA of the repository at the time the CodeQL database was created.",
    )


class CodeScanningDefaultSetup(GitHubModel):
    """CodeScanningDefaultSetup

    Configuration for code scanning default setup.
    """

    state: Missing[Literal["configured", "not-configured"]] = Field(
        default=UNSET,
        description="Code scanning default setup has been configured or not.",
    )
    languages: Missing[
        List[
            Literal[
                "c-cpp",
                "csharp",
                "go",
                "java-kotlin",
                "javascript-typescript",
                "javascript",
                "python",
                "ruby",
                "typescript",
                "swift",
            ]
        ]
    ] = Field(default=UNSET, description="Languages to be analyzed.")
    query_suite: Missing[Literal["default", "extended"]] = Field(
        default=UNSET, description="CodeQL query suite to be used."
    )
    updated_at: Missing[Union[datetime, None]] = Field(
        default=UNSET, description="Timestamp of latest configuration update."
    )
    schedule: Missing[Union[None, Literal["weekly"]]] = Field(
        default=UNSET, description="The frequency of the periodic analysis."
    )


class CodeScanningDefaultSetupUpdate(GitHubModel):
    """CodeScanningDefaultSetupUpdate

    Configuration for code scanning default setup.
    """

    state: Missing[Literal["configured", "not-configured"]] = Field(
        default=UNSET, description="The desired state of code scanning default setup."
    )
    query_suite: Missing[Literal["default", "extended"]] = Field(
        default=UNSET, description="CodeQL query suite to be used."
    )
    languages: Missing[
        List[
            Literal[
                "c-cpp",
                "csharp",
                "go",
                "java-kotlin",
                "javascript-typescript",
                "python",
                "ruby",
                "swift",
            ]
        ]
    ] = Field(default=UNSET, description="CodeQL languages to be analyzed.")


class CodeScanningDefaultSetupUpdateResponse(GitHubModel):
    """CodeScanningDefaultSetupUpdateResponse

    You can use `run_url` to track the status of the run. This includes a property
    status and conclusion.
    You should not rely on this always being an actions workflow run object.
    """

    run_id: Missing[int] = Field(
        default=UNSET, description="ID of the corresponding run."
    )
    run_url: Missing[str] = Field(
        default=UNSET, description="URL of the corresponding run."
    )


class CodeScanningSarifsReceipt(GitHubModel):
    """CodeScanningSarifsReceipt"""

    id: Missing[str] = Field(default=UNSET, description="An identifier for the upload.")
    url: Missing[str] = Field(
        default=UNSET,
        description="The REST API URL for checking the status of the upload.",
    )


class CodeScanningSarifsStatus(GitHubModel):
    """CodeScanningSarifsStatus"""

    processing_status: Missing[Literal["pending", "complete", "failed"]] = Field(
        default=UNSET,
        description="`pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.",
    )
    analyses_url: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The REST API URL for getting the analyses associated with the upload.",
    )
    errors: Missing[Union[List[str], None]] = Field(
        default=UNSET,
        description="Any errors that ocurred during processing of the delivery.",
    )


class CodeownersErrors(GitHubModel):
    """CODEOWNERS errors

    A list of errors found in a repo's CODEOWNERS file
    """

    errors: List[CodeownersErrorsPropErrorsItems] = Field()


class CodeownersErrorsPropErrorsItems(GitHubModel):
    """CodeownersErrorsPropErrorsItems"""

    line: int = Field(description="The line number where this errors occurs.")
    column: int = Field(description="The column number where this errors occurs.")
    source: Missing[str] = Field(
        default=UNSET, description="The contents of the line where the error occurs."
    )
    kind: str = Field(description="The type of error.")
    suggestion: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="Suggested action to fix the error. This will usually be `null`, but is provided for some common errors.",
    )
    message: str = Field(
        description="A human-readable description of the error, combining information from multiple fields, laid out for display in a monospaced typeface (for example, a command-line setting)."
    )
    path: str = Field(description="The path of the file where the error occured.")


class CodespacesPermissionsCheckForDevcontainer(GitHubModel):
    """Codespaces Permissions Check

    Permission check result for a given devcontainer config.
    """

    accepted: bool = Field(
        description="Whether the user has accepted the permissions defined by the devcontainer config"
    )


class RepoCodespacesSecret(GitHubModel):
    """Codespaces Secret

    Set repository secrets for GitHub Codespaces.
    """

    name: str = Field(description="The name of the secret.")
    created_at: datetime = Field()
    updated_at: datetime = Field()


class Collaborator(GitHubModel):
    """Collaborator

    Collaborator
    """

    login: str = Field()
    id: int = Field()
    email: Missing[Union[str, None]] = Field(default=UNSET)
    name: Missing[Union[str, None]] = Field(default=UNSET)
    node_id: str = Field()
    avatar_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    url: str = Field()
    html_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    starred_url: str = Field()
    subscriptions_url: str = Field()
    organizations_url: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    received_events_url: str = Field()
    type: str = Field()
    site_admin: bool = Field()
    permissions: Missing[CollaboratorPropPermissions] = Field(default=UNSET)
    role_name: str = Field()


class CollaboratorPropPermissions(GitHubModel):
    """CollaboratorPropPermissions"""

    pull: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)
    push: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    admin: bool = Field()


class RepositoryInvitation(GitHubModel):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    id: int = Field(description="Unique identifier of the repository invitation.")
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )
    invitee: Union[None, SimpleUser] = Field()
    inviter: Union[None, SimpleUser] = Field()
    permissions: Literal["read", "write", "admin", "triage", "maintain"] = Field(
        description="The permission associated with the invitation."
    )
    created_at: datetime = Field()
    expired: Missing[bool] = Field(
        default=UNSET, description="Whether or not the invitation has expired"
    )
    url: str = Field(description="URL for the repository invitation")
    html_url: str = Field()
    node_id: str = Field()


class RepositoryCollaboratorPermission(GitHubModel):
    """Repository Collaborator Permission

    Repository Collaborator Permission
    """

    permission: str = Field()
    role_name: str = Field()
    user: Union[None, Collaborator] = Field()


class CommitComment(GitHubModel):
    """Commit Comment

    Commit Comment
    """

    html_url: str = Field()
    url: str = Field()
    id: int = Field()
    node_id: str = Field()
    body: str = Field()
    path: Union[str, None] = Field()
    position: Union[int, None] = Field()
    line: Union[int, None] = Field()
    commit_id: str = Field()
    user: Union[None, SimpleUser] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")


class BranchShort(GitHubModel):
    """Branch Short

    Branch Short
    """

    name: str = Field()
    commit: BranchShortPropCommit = Field()
    protected: bool = Field()


class BranchShortPropCommit(GitHubModel):
    """BranchShortPropCommit"""

    sha: str = Field()
    url: str = Field()


class Link(GitHubModel):
    """Link

    Hypermedia Link
    """

    href: str = Field()


class AutoMerge(GitHubModel):
    """Auto merge

    The status of auto merging a pull request.
    """

    enabled_by: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    merge_method: Literal["merge", "squash", "rebase"] = Field(
        description="The merge method to use."
    )
    commit_title: Union[str, None] = Field(
        description="Title for the merge commit message."
    )
    commit_message: Union[str, None] = Field(
        description="Commit message for the merge commit."
    )


class PullRequestSimple(GitHubModel):
    """Pull Request Simple

    Pull Request Simple
    """

    url: str = Field()
    id: int = Field()
    node_id: str = Field()
    html_url: str = Field()
    diff_url: str = Field()
    patch_url: str = Field()
    issue_url: str = Field()
    commits_url: str = Field()
    review_comments_url: str = Field()
    review_comment_url: str = Field()
    comments_url: str = Field()
    statuses_url: str = Field()
    number: int = Field()
    state: str = Field()
    locked: bool = Field()
    title: str = Field()
    user: Union[None, SimpleUser] = Field()
    body: Union[str, None] = Field()
    labels: List[PullRequestSimplePropLabelsItems] = Field()
    milestone: Union[None, Milestone] = Field()
    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    created_at: datetime = Field()
    updated_at: datetime = Field()
    closed_at: Union[datetime, None] = Field()
    merged_at: Union[datetime, None] = Field()
    merge_commit_sha: Union[str, None] = Field()
    assignee: Union[None, SimpleUser] = Field()
    assignees: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_reviewers: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_teams: Missing[Union[List[Team], None]] = Field(default=UNSET)
    head: PullRequestSimplePropHead = Field()
    base: PullRequestSimplePropBase = Field()
    links: PullRequestSimplePropLinks = Field(alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="Auto merge", description="The status of auto merging a pull request."
    )
    draft: Missing[bool] = Field(
        default=UNSET,
        description="Indicates whether or not the pull request is a draft.",
    )


class PullRequestSimplePropLabelsItems(GitHubModel):
    """PullRequestSimplePropLabelsItems"""

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    name: str = Field()
    description: Union[str, None] = Field()
    color: str = Field()
    default: bool = Field()


class PullRequestSimplePropHead(GitHubModel):
    """PullRequestSimplePropHead"""

    label: Union[str, None] = Field()
    ref: str = Field()
    repo: Union[None, Repository] = Field()
    sha: str = Field()
    user: Union[None, SimpleUser] = Field()


class PullRequestSimplePropBase(GitHubModel):
    """PullRequestSimplePropBase"""

    label: str = Field()
    ref: str = Field()
    repo: Repository = Field(title="Repository", description="A repository on GitHub.")
    sha: str = Field()
    user: Union[None, SimpleUser] = Field()


class PullRequestSimplePropLinks(GitHubModel):
    """PullRequestSimplePropLinks"""

    comments: Link = Field(title="Link", description="Hypermedia Link")
    commits: Link = Field(title="Link", description="Hypermedia Link")
    statuses: Link = Field(title="Link", description="Hypermedia Link")
    html: Link = Field(title="Link", description="Hypermedia Link")
    issue: Link = Field(title="Link", description="Hypermedia Link")
    review_comments: Link = Field(title="Link", description="Hypermedia Link")
    review_comment: Link = Field(title="Link", description="Hypermedia Link")
    self_: Link = Field(alias="self", title="Link", description="Hypermedia Link")


class SimpleCommitStatus(GitHubModel):
    """Simple Commit Status"""

    description: Union[str, None] = Field()
    id: int = Field()
    node_id: str = Field()
    state: str = Field()
    context: str = Field()
    target_url: Union[str, None] = Field()
    required: Missing[Union[bool, None]] = Field(default=UNSET)
    avatar_url: Union[str, None] = Field()
    url: str = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()


class CombinedCommitStatus(GitHubModel):
    """Combined Commit Status

    Combined Commit Status
    """

    state: str = Field()
    statuses: List[SimpleCommitStatus] = Field()
    sha: str = Field()
    total_count: int = Field()
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )
    commit_url: str = Field()
    url: str = Field()


class Status(GitHubModel):
    """Status

    The status of a commit.
    """

    url: str = Field()
    avatar_url: Union[str, None] = Field()
    id: int = Field()
    node_id: str = Field()
    state: str = Field()
    description: Union[str, None] = Field()
    target_url: Union[str, None] = Field()
    context: str = Field()
    created_at: str = Field()
    updated_at: str = Field()
    creator: Union[None, SimpleUser] = Field()


class CommunityHealthFile(GitHubModel):
    """Community Health File"""

    url: str = Field()
    html_url: str = Field()


class CommunityProfile(GitHubModel):
    """Community Profile

    Community Profile
    """

    health_percentage: int = Field()
    description: Union[str, None] = Field()
    documentation: Union[str, None] = Field()
    files: CommunityProfilePropFiles = Field()
    updated_at: Union[datetime, None] = Field()
    content_reports_enabled: Missing[bool] = Field(default=UNSET)


class CommunityProfilePropFiles(GitHubModel):
    """CommunityProfilePropFiles"""

    code_of_conduct: Union[None, CodeOfConductSimple] = Field()
    code_of_conduct_file: Union[None, CommunityHealthFile] = Field()
    license_: Union[None, LicenseSimple] = Field(alias="license")
    contributing: Union[None, CommunityHealthFile] = Field()
    readme: Union[None, CommunityHealthFile] = Field()
    issue_template: Union[None, CommunityHealthFile] = Field()
    pull_request_template: Union[None, CommunityHealthFile] = Field()


class CommitComparison(GitHubModel):
    """Commit Comparison

    Commit Comparison
    """

    url: str = Field()
    html_url: str = Field()
    permalink_url: str = Field()
    diff_url: str = Field()
    patch_url: str = Field()
    base_commit: Commit = Field(title="Commit", description="Commit")
    merge_base_commit: Commit = Field(title="Commit", description="Commit")
    status: Literal["diverged", "ahead", "behind", "identical"] = Field()
    ahead_by: int = Field()
    behind_by: int = Field()
    total_commits: int = Field()
    commits: List[Commit] = Field()
    files: Missing[List[DiffEntry]] = Field(default=UNSET)


class ContentTree(GitHubModel):
    """Content Tree

    Content Tree
    """

    type: str = Field()
    size: int = Field()
    name: str = Field()
    path: str = Field()
    sha: str = Field()
    url: str = Field()
    git_url: Union[str, None] = Field()
    html_url: Union[str, None] = Field()
    download_url: Union[str, None] = Field()
    entries: Missing[List[ContentTreePropEntriesItems]] = Field(default=UNSET)
    links: ContentTreePropLinks = Field(alias="_links")


class ContentTreePropEntriesItems(GitHubModel):
    """ContentTreePropEntriesItems"""

    type: str = Field()
    size: int = Field()
    name: str = Field()
    path: str = Field()
    content: Missing[str] = Field(default=UNSET)
    sha: str = Field()
    url: str = Field()
    git_url: Union[str, None] = Field()
    html_url: Union[str, None] = Field()
    download_url: Union[str, None] = Field()
    links: ContentTreePropEntriesItemsPropLinks = Field(alias="_links")


class ContentTreePropEntriesItemsPropLinks(GitHubModel):
    """ContentTreePropEntriesItemsPropLinks"""

    git: Union[str, None] = Field()
    html: Union[str, None] = Field()
    self_: str = Field(alias="self")


class ContentTreePropLinks(GitHubModel):
    """ContentTreePropLinks"""

    git: Union[str, None] = Field()
    html: Union[str, None] = Field()
    self_: str = Field(alias="self")


class ContentDirectoryItems(GitHubModel):
    """ContentDirectoryItems"""

    type: Literal["dir", "file", "submodule", "symlink"] = Field()
    size: int = Field()
    name: str = Field()
    path: str = Field()
    content: Missing[str] = Field(default=UNSET)
    sha: str = Field()
    url: str = Field()
    git_url: Union[str, None] = Field()
    html_url: Union[str, None] = Field()
    download_url: Union[str, None] = Field()
    links: ContentDirectoryItemsPropLinks = Field(alias="_links")


class ContentDirectoryItemsPropLinks(GitHubModel):
    """ContentDirectoryItemsPropLinks"""

    git: Union[str, None] = Field()
    html: Union[str, None] = Field()
    self_: str = Field(alias="self")


class ContentFile(GitHubModel):
    """Content File

    Content File
    """

    type: Literal["file"] = Field()
    encoding: str = Field()
    size: int = Field()
    name: str = Field()
    path: str = Field()
    content: str = Field()
    sha: str = Field()
    url: str = Field()
    git_url: Union[str, None] = Field()
    html_url: Union[str, None] = Field()
    download_url: Union[str, None] = Field()
    links: ContentFilePropLinks = Field(alias="_links")
    target: Missing[str] = Field(default=UNSET)
    submodule_git_url: Missing[str] = Field(default=UNSET)


class ContentFilePropLinks(GitHubModel):
    """ContentFilePropLinks"""

    git: Union[str, None] = Field()
    html: Union[str, None] = Field()
    self_: str = Field(alias="self")


class ContentSymlink(GitHubModel):
    """Symlink Content

    An object describing a symlink
    """

    type: Literal["symlink"] = Field()
    target: str = Field()
    size: int = Field()
    name: str = Field()
    path: str = Field()
    sha: str = Field()
    url: str = Field()
    git_url: Union[str, None] = Field()
    html_url: Union[str, None] = Field()
    download_url: Union[str, None] = Field()
    links: ContentSymlinkPropLinks = Field(alias="_links")


class ContentSymlinkPropLinks(GitHubModel):
    """ContentSymlinkPropLinks"""

    git: Union[str, None] = Field()
    html: Union[str, None] = Field()
    self_: str = Field(alias="self")


class ContentSubmodule(GitHubModel):
    """Submodule Content

    An object describing a submodule
    """

    type: Literal["submodule"] = Field()
    submodule_git_url: str = Field()
    size: int = Field()
    name: str = Field()
    path: str = Field()
    sha: str = Field()
    url: str = Field()
    git_url: Union[str, None] = Field()
    html_url: Union[str, None] = Field()
    download_url: Union[str, None] = Field()
    links: ContentSubmodulePropLinks = Field(alias="_links")


class ContentSubmodulePropLinks(GitHubModel):
    """ContentSubmodulePropLinks"""

    git: Union[str, None] = Field()
    html: Union[str, None] = Field()
    self_: str = Field(alias="self")


class FileCommit(GitHubModel):
    """File Commit

    File Commit
    """

    content: Union[FileCommitPropContent, None] = Field()
    commit: FileCommitPropCommit = Field()


class FileCommitPropContentPropLinks(GitHubModel):
    """FileCommitPropContentPropLinks"""

    self_: Missing[str] = Field(default=UNSET, alias="self")
    git: Missing[str] = Field(default=UNSET)
    html: Missing[str] = Field(default=UNSET)


class FileCommitPropContent(GitHubModel):
    """FileCommitPropContent"""

    name: Missing[str] = Field(default=UNSET)
    path: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)
    size: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    git_url: Missing[str] = Field(default=UNSET)
    download_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    links: Missing[FileCommitPropContentPropLinks] = Field(
        default=UNSET, alias="_links"
    )


class FileCommitPropCommit(GitHubModel):
    """FileCommitPropCommit"""

    sha: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    author: Missing[FileCommitPropCommitPropAuthor] = Field(default=UNSET)
    committer: Missing[FileCommitPropCommitPropCommitter] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    tree: Missing[FileCommitPropCommitPropTree] = Field(default=UNSET)
    parents: Missing[List[FileCommitPropCommitPropParentsItems]] = Field(default=UNSET)
    verification: Missing[FileCommitPropCommitPropVerification] = Field(default=UNSET)


class FileCommitPropCommitPropAuthor(GitHubModel):
    """FileCommitPropCommitPropAuthor"""

    date: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    email: Missing[str] = Field(default=UNSET)


class FileCommitPropCommitPropCommitter(GitHubModel):
    """FileCommitPropCommitPropCommitter"""

    date: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    email: Missing[str] = Field(default=UNSET)


class FileCommitPropCommitPropTree(GitHubModel):
    """FileCommitPropCommitPropTree"""

    url: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)


class FileCommitPropCommitPropParentsItems(GitHubModel):
    """FileCommitPropCommitPropParentsItems"""

    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)


class FileCommitPropCommitPropVerification(GitHubModel):
    """FileCommitPropCommitPropVerification"""

    verified: Missing[bool] = Field(default=UNSET)
    reason: Missing[str] = Field(default=UNSET)
    signature: Missing[Union[str, None]] = Field(default=UNSET)
    payload: Missing[Union[str, None]] = Field(default=UNSET)


class Contributor(GitHubModel):
    """Contributor

    Contributor
    """

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[Union[str, None]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: str = Field()
    site_admin: Missing[bool] = Field(default=UNSET)
    contributions: int = Field()
    email: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)


class DependabotAlert(GitHubModel):
    """DependabotAlert

    A Dependabot alert.
    """

    number: int = Field(description="The security alert number.")
    state: Literal["auto_dismissed", "dismissed", "fixed", "open"] = Field(
        description="The state of the Dependabot alert."
    )
    dependency: DependabotAlertPropDependency = Field(
        description="Details for the vulnerable dependency."
    )
    security_advisory: DependabotAlertSecurityAdvisory = Field(
        description="Details for the GitHub Security Advisory."
    )
    security_vulnerability: DependabotAlertSecurityVulnerability = Field(
        description="Details pertaining to one vulnerable version range for the advisory."
    )
    url: str = Field(description="The REST API URL of the alert resource.")
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    updated_at: datetime = Field(
        description="The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_by: Union[None, SimpleUser] = Field()
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ] = Field(description="The reason that the alert was dismissed.")
    dismissed_comment: Union[Annotated[str, Field(max_length=280)], None] = Field(
        description="An optional comment associated with the alert's dismissal."
    )
    fixed_at: Union[datetime, None] = Field(
        description="The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    auto_dismissed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that the alert was auto-dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )


class DependabotAlertPropDependency(GitHubModel):
    """DependabotAlertPropDependency

    Details for the vulnerable dependency.
    """

    package: Missing[DependabotAlertPackage] = Field(
        default=UNSET, description="Details for the vulnerable package."
    )
    manifest_path: Missing[str] = Field(
        default=UNSET,
        description="The full path to the dependency manifest file, relative to the root of the repository.",
    )
    scope: Missing[Union[None, Literal["development", "runtime"]]] = Field(
        default=UNSET, description="The execution scope of the vulnerable dependency."
    )


class DependabotSecret(GitHubModel):
    """Dependabot Secret

    Set secrets for Dependabot.
    """

    name: str = Field(description="The name of the secret.")
    created_at: datetime = Field()
    updated_at: datetime = Field()


class DependencyGraphDiffItems(GitHubModel):
    """DependencyGraphDiffItems"""

    change_type: Literal["added", "removed"] = Field()
    manifest: str = Field()
    ecosystem: str = Field()
    name: str = Field()
    version: str = Field()
    package_url: Union[str, None] = Field()
    license_: Union[str, None] = Field(alias="license")
    source_repository_url: Union[str, None] = Field()
    vulnerabilities: List[DependencyGraphDiffItemsPropVulnerabilitiesItems] = Field()
    scope: Literal["unknown", "runtime", "development"] = Field(
        description="Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment."
    )


class DependencyGraphDiffItemsPropVulnerabilitiesItems(GitHubModel):
    """DependencyGraphDiffItemsPropVulnerabilitiesItems"""

    severity: str = Field()
    advisory_ghsa_id: str = Field()
    advisory_summary: str = Field()
    advisory_url: str = Field()


class DependencyGraphSpdxSbom(GitHubModel):
    """Dependency Graph SPDX SBOM

    A schema for the SPDX JSON format returned by the Dependency Graph.
    """

    sbom: DependencyGraphSpdxSbomPropSbom = Field()


class DependencyGraphSpdxSbomPropSbom(GitHubModel):
    """DependencyGraphSpdxSbomPropSbom"""

    spdxid: str = Field(
        alias="SPDXID", description="The SPDX identifier for the SPDX document."
    )
    spdx_version: str = Field(
        alias="spdxVersion",
        description="The version of the SPDX specification that this document conforms to.",
    )
    creation_info: DependencyGraphSpdxSbomPropSbomPropCreationInfo = Field(
        alias="creationInfo"
    )
    name: str = Field(description="The name of the SPDX document.")
    data_license: str = Field(
        alias="dataLicense",
        description="The license under which the SPDX document is licensed.",
    )
    document_describes: List[str] = Field(
        alias="documentDescribes",
        description="The name of the repository that the SPDX document describes.",
    )
    document_namespace: str = Field(
        alias="documentNamespace", description="The namespace for the SPDX document."
    )
    packages: List[DependencyGraphSpdxSbomPropSbomPropPackagesItems] = Field()


class DependencyGraphSpdxSbomPropSbomPropCreationInfo(GitHubModel):
    """DependencyGraphSpdxSbomPropSbomPropCreationInfo"""

    created: str = Field(description="The date and time the SPDX document was created.")
    creators: List[str] = Field(
        description="The tools that were used to generate the SPDX document."
    )


class DependencyGraphSpdxSbomPropSbomPropPackagesItems(GitHubModel):
    """DependencyGraphSpdxSbomPropSbomPropPackagesItems"""

    spdxid: Missing[str] = Field(
        default=UNSET,
        alias="SPDXID",
        description="A unique SPDX identifier for the package.",
    )
    name: Missing[str] = Field(default=UNSET, description="The name of the package.")
    version_info: Missing[str] = Field(
        default=UNSET,
        alias="versionInfo",
        description="The version of the package. If the package does not have an exact version specified,\na version range is given.",
    )
    download_location: Missing[str] = Field(
        default=UNSET,
        alias="downloadLocation",
        description="The location where the package can be downloaded,\nor NOASSERTION if this has not been determined.",
    )
    files_analyzed: Missing[bool] = Field(
        default=UNSET,
        alias="filesAnalyzed",
        description="Whether the package's file content has been subjected to\nanalysis during the creation of the SPDX document.",
    )
    license_concluded: Missing[str] = Field(
        default=UNSET,
        alias="licenseConcluded",
        description="The license of the package as determined while creating the SPDX document.",
    )
    license_declared: Missing[str] = Field(
        default=UNSET,
        alias="licenseDeclared",
        description="The license of the package as declared by its author, or NOASSERTION if this information\nwas not available when the SPDX document was created.",
    )
    supplier: Missing[str] = Field(
        default=UNSET,
        description="The distribution source of this package, or NOASSERTION if this was not determined.",
    )
    external_refs: Missing[
        List[DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItems]
    ] = Field(default=UNSET, alias="externalRefs")


class DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItems(
    GitHubModel
):
    """DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItems"""

    reference_category: str = Field(
        alias="referenceCategory",
        description="The category of reference to an external resource this reference refers to.",
    )
    reference_locator: str = Field(
        alias="referenceLocator",
        description="A locator for the particular external resource this reference refers to.",
    )
    reference_type: str = Field(
        alias="referenceType",
        description="The category of reference to an external resource this reference refers to.",
    )


class Metadata(ExtraGitHubModel):
    """metadata

    User-defined metadata to store domain-specific information limited to 8 keys
    with scalar values.
    """


class Dependency(GitHubModel):
    """Dependency"""

    package_url: Missing[Annotated[str, Field(pattern="^pkg")]] = Field(
        default=UNSET,
        description="Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.",
    )
    metadata: Missing[Metadata] = Field(
        default=UNSET,
        title="metadata",
        description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.",
    )
    relationship: Missing[Literal["direct", "indirect"]] = Field(
        default=UNSET,
        description="A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.",
    )
    scope: Missing[Literal["runtime", "development"]] = Field(
        default=UNSET,
        description="A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.",
    )
    dependencies: Missing[List[str]] = Field(
        default=UNSET,
        description="Array of package-url (PURLs) of direct child dependencies.",
    )


class Manifest(GitHubModel):
    """Manifest"""

    name: str = Field(description="The name of the manifest.")
    file: Missing[ManifestPropFile] = Field(default=UNSET)
    metadata: Missing[Metadata] = Field(
        default=UNSET,
        title="metadata",
        description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.",
    )
    resolved: Missing[ManifestPropResolved] = Field(
        default=UNSET, description="A collection of resolved package dependencies."
    )


class ManifestPropFile(GitHubModel):
    """ManifestPropFile"""

    source_location: Missing[str] = Field(
        default=UNSET,
        description="The path of the manifest file relative to the root of the Git repository.",
    )


class ManifestPropResolved(ExtraGitHubModel):
    """ManifestPropResolved

    A collection of resolved package dependencies.
    """


class Snapshot(GitHubModel):
    """snapshot

    Create a new snapshot of a repository's dependencies.
    """

    version: int = Field(
        description="The version of the repository snapshot submission."
    )
    job: SnapshotPropJob = Field()
    sha: Annotated[str, Field(min_length=40, max_length=40)] = Field(
        description="The commit SHA associated with this dependency snapshot. Maximum length: 40 characters."
    )
    ref: Annotated[str, Field(pattern="^refs/")] = Field(
        description="The repository branch that triggered this snapshot."
    )
    detector: SnapshotPropDetector = Field(
        description="A description of the detector used."
    )
    metadata: Missing[Metadata] = Field(
        default=UNSET,
        title="metadata",
        description="User-defined metadata to store domain-specific information limited to 8 keys with scalar values.",
    )
    manifests: Missing[SnapshotPropManifests] = Field(
        default=UNSET,
        description="A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.",
    )
    scanned: datetime = Field(description="The time at which the snapshot was scanned.")


class SnapshotPropJob(GitHubModel):
    """SnapshotPropJob"""

    id: str = Field(description="The external ID of the job.")
    correlator: str = Field(
        description="Correlator provides a key that is used to group snapshots submitted over time. Only the \"latest\" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given \"wave\" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation."
    )
    html_url: Missing[str] = Field(default=UNSET, description="The url for the job.")


class SnapshotPropDetector(GitHubModel):
    """SnapshotPropDetector

    A description of the detector used.
    """

    name: str = Field(description="The name of the detector used.")
    version: str = Field(description="The version of the detector used.")
    url: str = Field(description="The url of the detector used.")


class SnapshotPropManifests(ExtraGitHubModel):
    """SnapshotPropManifests

    A collection of package manifests, which are a collection of related
    dependencies declared in a file or representing a logical group of dependencies.
    """


class DeploymentStatus(GitHubModel):
    """Deployment Status

    The status of a deployment.
    """

    url: str = Field()
    id: int = Field()
    node_id: str = Field()
    state: Literal[
        "error", "failure", "inactive", "pending", "success", "queued", "in_progress"
    ] = Field(description="The state of the status.")
    creator: Union[None, SimpleUser] = Field()
    description: Annotated[str, Field(max_length=140)] = Field(
        default="", description="A short description of the status."
    )
    environment: Missing[str] = Field(
        default=UNSET,
        description="The environment of the deployment that the status is for.",
    )
    target_url: str = Field(
        default="", description="Deprecated: the URL to associate with this status."
    )
    created_at: datetime = Field()
    updated_at: datetime = Field()
    deployment_url: str = Field()
    repository_url: str = Field()
    environment_url: Missing[str] = Field(
        default=UNSET, description="The URL for accessing your environment."
    )
    log_url: Missing[str] = Field(
        default=UNSET, description="The URL to associate with this status."
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(default=UNSET)


class DeploymentBranchPolicySettings(GitHubModel):
    """DeploymentBranchPolicySettings

    The type of deployment branch policy for this environment. To allow all branches
    to deploy, set to `null`.
    """

    protected_branches: bool = Field(
        description="Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`."
    )
    custom_branch_policies: bool = Field(
        description="Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`."
    )


class Environment(GitHubModel):
    """Environment

    Details of a deployment environment
    """

    id: int = Field(description="The id of the environment.")
    node_id: str = Field()
    name: str = Field(description="The name of the environment.")
    url: str = Field()
    html_url: str = Field()
    created_at: datetime = Field(
        description="The time that the environment was created, in ISO 8601 format."
    )
    updated_at: datetime = Field(
        description="The time that the environment was last updated, in ISO 8601 format."
    )
    protection_rules: Missing[
        List[
            Union[
                EnvironmentPropProtectionRulesItemsAnyof0,
                EnvironmentPropProtectionRulesItemsAnyof1,
                EnvironmentPropProtectionRulesItemsAnyof2,
            ]
        ]
    ] = Field(
        default=UNSET,
        description="Built-in deployment protection rules for the environment.",
    )
    deployment_branch_policy: Missing[
        Union[DeploymentBranchPolicySettings, None]
    ] = Field(
        default=UNSET,
        description="The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`.",
    )


class EnvironmentPropProtectionRulesItemsAnyof0(GitHubModel):
    """EnvironmentPropProtectionRulesItemsAnyof0"""

    id: int = Field()
    node_id: str = Field()
    type: str = Field()
    wait_timer: Missing[int] = Field(
        default=UNSET,
        description="The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).",
    )


class EnvironmentPropProtectionRulesItemsAnyof1(GitHubModel):
    """EnvironmentPropProtectionRulesItemsAnyof1"""

    id: int = Field()
    node_id: str = Field()
    prevent_self_review: Missing[bool] = Field(
        default=UNSET,
        description="Whether deployments to this environment can be approved by the user who created the deployment.",
    )
    type: str = Field()
    reviewers: Missing[
        List[EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems]
    ] = Field(
        default=UNSET,
        description="The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.",
    )


class EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems(GitHubModel):
    """EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems"""

    type: Missing[Literal["User", "Team"]] = Field(
        default=UNSET, description="The type of reviewer."
    )
    reviewer: Missing[Union[SimpleUser, Team]] = Field(default=UNSET)


class EnvironmentPropProtectionRulesItemsAnyof2(GitHubModel):
    """EnvironmentPropProtectionRulesItemsAnyof2"""

    id: int = Field()
    node_id: str = Field()
    type: str = Field()


class DeploymentBranchPolicy(GitHubModel):
    """Deployment branch policy

    Details of a deployment branch or tag policy.
    """

    id: Missing[int] = Field(
        default=UNSET, description="The unique identifier of the branch or tag policy."
    )
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(
        default=UNSET,
        description="The name pattern that branches or tags must match in order to deploy to the environment.",
    )
    type: Missing[Literal["branch", "tag"]] = Field(
        default=UNSET, description="Whether this rule targets a branch or tag."
    )


class DeploymentBranchPolicyNamePatternWithType(GitHubModel):
    """Deployment branch and tag policy name pattern"""

    name: str = Field(
        description="The name pattern that branches or tags must match in order to deploy to the environment.\n\nWildcard characters will not match `/`. For example, to match branches that begin with `release/` and contain an additional single slash, use `release/*/*`.\nFor more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch)."
    )
    type: Missing[Literal["branch", "tag"]] = Field(
        default=UNSET, description="Whether this rule targets a branch or tag"
    )


class DeploymentBranchPolicyNamePattern(GitHubModel):
    """Deployment branch policy name pattern"""

    name: str = Field(
        description="The name pattern that branches must match in order to deploy to the environment.\n\nWildcard characters will not match `/`. For example, to match branches that begin with `release/` and contain an additional single slash, use `release/*/*`.\nFor more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch)."
    )


class CustomDeploymentRuleApp(GitHubModel):
    """Custom deployment protection rule app

    A GitHub App that is providing a custom deployment protection rule.
    """

    id: int = Field(
        description="The unique identifier of the deployment protection rule integration."
    )
    slug: str = Field(
        description="The slugified name of the deployment protection rule integration."
    )
    integration_url: str = Field(
        description="The URL for the endpoint to get details about the app."
    )
    node_id: str = Field(
        description="The node ID for the deployment protection rule integration."
    )


class DeploymentProtectionRule(GitHubModel):
    """Deployment protection rule

    Deployment protection rule
    """

    id: int = Field(
        description="The unique identifier for the deployment protection rule."
    )
    node_id: str = Field(description="The node ID for the deployment protection rule.")
    enabled: bool = Field(
        description="Whether the deployment protection rule is enabled for the environment."
    )
    app: CustomDeploymentRuleApp = Field(
        title="Custom deployment protection rule app",
        description="A GitHub App that is providing a custom deployment protection rule.",
    )


class ShortBlob(GitHubModel):
    """Short Blob

    Short Blob
    """

    url: str = Field()
    sha: str = Field()


class Blob(GitHubModel):
    """Blob

    Blob
    """

    content: str = Field()
    encoding: str = Field()
    url: str = Field()
    sha: str = Field()
    size: Union[int, None] = Field()
    node_id: str = Field()
    highlighted_content: Missing[str] = Field(default=UNSET)


class GitCommit(GitHubModel):
    """Git Commit

    Low-level Git commit operations within a repository
    """

    sha: str = Field(description="SHA for the commit")
    node_id: str = Field()
    url: str = Field()
    author: GitCommitPropAuthor = Field(
        description="Identifying information for the git-user"
    )
    committer: GitCommitPropCommitter = Field(
        description="Identifying information for the git-user"
    )
    message: str = Field(description="Message describing the purpose of the commit")
    tree: GitCommitPropTree = Field()
    parents: List[GitCommitPropParentsItems] = Field()
    verification: GitCommitPropVerification = Field()
    html_url: str = Field()


class GitCommitPropAuthor(GitHubModel):
    """GitCommitPropAuthor

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit")
    email: str = Field(description="Git email address of the user")
    name: str = Field(description="Name of the git user")


class GitCommitPropCommitter(GitHubModel):
    """GitCommitPropCommitter

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit")
    email: str = Field(description="Git email address of the user")
    name: str = Field(description="Name of the git user")


class GitCommitPropTree(GitHubModel):
    """GitCommitPropTree"""

    sha: str = Field(description="SHA for the commit")
    url: str = Field()


class GitCommitPropParentsItems(GitHubModel):
    """GitCommitPropParentsItems"""

    sha: str = Field(description="SHA for the commit")
    url: str = Field()
    html_url: str = Field()


class GitCommitPropVerification(GitHubModel):
    """GitCommitPropVerification"""

    verified: bool = Field()
    reason: str = Field()
    signature: Union[str, None] = Field()
    payload: Union[str, None] = Field()


class GitRef(GitHubModel):
    """Git Reference

    Git references within a repository
    """

    ref: str = Field()
    node_id: str = Field()
    url: str = Field()
    object_: GitRefPropObject = Field(alias="object")


class GitRefPropObject(GitHubModel):
    """GitRefPropObject"""

    type: str = Field()
    sha: Annotated[str, Field(min_length=40, max_length=40)] = Field(
        description="SHA for the reference"
    )
    url: str = Field()


class GitTag(GitHubModel):
    """Git Tag

    Metadata for a Git tag
    """

    node_id: str = Field()
    tag: str = Field(description="Name of the tag")
    sha: str = Field()
    url: str = Field(description="URL for the tag")
    message: str = Field(description="Message describing the purpose of the tag")
    tagger: GitTagPropTagger = Field()
    object_: GitTagPropObject = Field(alias="object")
    verification: Missing[Verification] = Field(default=UNSET, title="Verification")


class GitTagPropTagger(GitHubModel):
    """GitTagPropTagger"""

    date: str = Field()
    email: str = Field()
    name: str = Field()


class GitTagPropObject(GitHubModel):
    """GitTagPropObject"""

    sha: str = Field()
    type: str = Field()
    url: str = Field()


class GitTree(GitHubModel):
    """Git Tree

    The hierarchy between files in a Git repository.
    """

    sha: str = Field()
    url: str = Field()
    truncated: bool = Field()
    tree: List[GitTreePropTreeItems] = Field(
        description="Objects specifying a tree structure"
    )


class GitTreePropTreeItems(GitHubModel):
    """GitTreePropTreeItems"""

    path: Missing[str] = Field(default=UNSET)
    mode: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)
    size: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class HookResponse(GitHubModel):
    """Hook Response"""

    code: Union[int, None] = Field()
    status: Union[str, None] = Field()
    message: Union[str, None] = Field()


class Hook(GitHubModel):
    """Webhook

    Webhooks for repositories.
    """

    type: str = Field()
    id: int = Field(description="Unique identifier of the webhook.")
    name: str = Field(
        description="The name of a valid service, use 'web' for a webhook."
    )
    active: bool = Field(
        description="Determines whether the hook is actually triggered on pushes."
    )
    events: List[str] = Field(
        description="Determines what events the hook is triggered for. Default: ['push']."
    )
    config: HookPropConfig = Field()
    updated_at: datetime = Field()
    created_at: datetime = Field()
    url: str = Field()
    test_url: str = Field()
    ping_url: str = Field()
    deliveries_url: Missing[str] = Field(default=UNSET)
    last_response: HookResponse = Field(title="Hook Response")


class HookPropConfig(GitHubModel):
    """HookPropConfig"""

    email: Missing[str] = Field(default=UNSET)
    password: Missing[str] = Field(default=UNSET)
    room: Missing[str] = Field(default=UNSET)
    subdomain: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(
        default=UNSET, description="The URL to which the payloads will be delivered."
    )
    insecure_ssl: Missing[Union[str, float]] = Field(default=UNSET)
    content_type: Missing[str] = Field(
        default=UNSET,
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
    )
    digest: Missing[str] = Field(default=UNSET)
    secret: Missing[str] = Field(
        default=UNSET,
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
    )
    token: Missing[str] = Field(default=UNSET)


class Import(GitHubModel):
    """Import

    A repository import from an external source.
    """

    vcs: Union[str, None] = Field()
    use_lfs: Missing[bool] = Field(default=UNSET)
    vcs_url: str = Field(description="The URL of the originating repository.")
    svc_root: Missing[str] = Field(default=UNSET)
    tfvc_project: Missing[str] = Field(default=UNSET)
    status: Literal[
        "auth",
        "error",
        "none",
        "detecting",
        "choose",
        "auth_failed",
        "importing",
        "mapping",
        "waiting_to_push",
        "pushing",
        "complete",
        "setup",
        "unknown",
        "detection_found_multiple",
        "detection_found_nothing",
        "detection_needs_auth",
    ] = Field()
    status_text: Missing[Union[str, None]] = Field(default=UNSET)
    failed_step: Missing[Union[str, None]] = Field(default=UNSET)
    error_message: Missing[Union[str, None]] = Field(default=UNSET)
    import_percent: Missing[Union[int, None]] = Field(default=UNSET)
    commit_count: Missing[Union[int, None]] = Field(default=UNSET)
    push_percent: Missing[Union[int, None]] = Field(default=UNSET)
    has_large_files: Missing[bool] = Field(default=UNSET)
    large_files_size: Missing[int] = Field(default=UNSET)
    large_files_count: Missing[int] = Field(default=UNSET)
    project_choices: Missing[List[ImportPropProjectChoicesItems]] = Field(default=UNSET)
    message: Missing[str] = Field(default=UNSET)
    authors_count: Missing[Union[int, None]] = Field(default=UNSET)
    url: str = Field()
    html_url: str = Field()
    authors_url: str = Field()
    repository_url: str = Field()
    svn_root: Missing[str] = Field(default=UNSET)


class ImportPropProjectChoicesItems(GitHubModel):
    """ImportPropProjectChoicesItems"""

    vcs: Missing[str] = Field(default=UNSET)
    tfvc_project: Missing[str] = Field(default=UNSET)
    human_name: Missing[str] = Field(default=UNSET)


class PorterAuthor(GitHubModel):
    """Porter Author

    Porter Author
    """

    id: int = Field()
    remote_id: str = Field()
    remote_name: str = Field()
    email: str = Field()
    name: str = Field()
    url: str = Field()
    import_url: str = Field()


class PorterLargeFile(GitHubModel):
    """Porter Large File

    Porter Large File
    """

    ref_name: str = Field()
    path: str = Field()
    oid: str = Field()
    size: int = Field()


class IssueEventLabel(GitHubModel):
    """Issue Event Label

    Issue Event Label
    """

    name: Union[str, None] = Field()
    color: Union[str, None] = Field()


class IssueEventDismissedReview(GitHubModel):
    """Issue Event Dismissed Review"""

    state: str = Field()
    review_id: int = Field()
    dismissal_message: Union[str, None] = Field()
    dismissal_commit_id: Missing[Union[str, None]] = Field(default=UNSET)


class IssueEventMilestone(GitHubModel):
    """Issue Event Milestone

    Issue Event Milestone
    """

    title: str = Field()


class IssueEventProjectCard(GitHubModel):
    """Issue Event Project Card

    Issue Event Project Card
    """

    url: str = Field()
    id: int = Field()
    project_url: str = Field()
    project_id: int = Field()
    column_name: str = Field()
    previous_column_name: Missing[str] = Field(default=UNSET)


class IssueEventRename(GitHubModel):
    """Issue Event Rename

    Issue Event Rename
    """

    from_: str = Field(alias="from")
    to: str = Field()


class IssueEvent(GitHubModel):
    """Issue Event

    Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: Union[None, SimpleUser] = Field()
    event: str = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: datetime = Field()
    issue: Missing[Union[None, Issue]] = Field(default=UNSET)
    label: Missing[IssueEventLabel] = Field(
        default=UNSET, title="Issue Event Label", description="Issue Event Label"
    )
    assignee: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    assigner: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    review_requester: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    requested_reviewer: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    requested_team: Missing[Team] = Field(
        default=UNSET,
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
    )
    dismissed_review: Missing[IssueEventDismissedReview] = Field(
        default=UNSET, title="Issue Event Dismissed Review"
    )
    milestone: Missing[IssueEventMilestone] = Field(
        default=UNSET,
        title="Issue Event Milestone",
        description="Issue Event Milestone",
    )
    project_card: Missing[IssueEventProjectCard] = Field(
        default=UNSET,
        title="Issue Event Project Card",
        description="Issue Event Project Card",
    )
    rename: Missing[IssueEventRename] = Field(
        default=UNSET, title="Issue Event Rename", description="Issue Event Rename"
    )
    author_association: Missing[
        Literal[
            "COLLABORATOR",
            "CONTRIBUTOR",
            "FIRST_TIMER",
            "FIRST_TIME_CONTRIBUTOR",
            "MANNEQUIN",
            "MEMBER",
            "NONE",
            "OWNER",
        ]
    ] = Field(
        default=UNSET,
        title="author_association",
        description="How the author is associated with the repository.",
    )
    lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    performed_via_github_app: Missing[Union[None, Integration]] = Field(default=UNSET)


class LabeledIssueEvent(GitHubModel):
    """Labeled Issue Event

    Labeled Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["labeled"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    label: LabeledIssueEventPropLabel = Field()


class LabeledIssueEventPropLabel(GitHubModel):
    """LabeledIssueEventPropLabel"""

    name: str = Field()
    color: str = Field()


class UnlabeledIssueEvent(GitHubModel):
    """Unlabeled Issue Event

    Unlabeled Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["unlabeled"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    label: UnlabeledIssueEventPropLabel = Field()


class UnlabeledIssueEventPropLabel(GitHubModel):
    """UnlabeledIssueEventPropLabel"""

    name: str = Field()
    color: str = Field()


class AssignedIssueEvent(GitHubModel):
    """Assigned Issue Event

    Assigned Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: str = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Integration = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    assignee: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    assigner: SimpleUser = Field(title="Simple User", description="A GitHub user.")


class UnassignedIssueEvent(GitHubModel):
    """Unassigned Issue Event

    Unassigned Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: str = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    assignee: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    assigner: SimpleUser = Field(title="Simple User", description="A GitHub user.")


class MilestonedIssueEvent(GitHubModel):
    """Milestoned Issue Event

    Milestoned Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["milestoned"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    milestone: MilestonedIssueEventPropMilestone = Field()


class MilestonedIssueEventPropMilestone(GitHubModel):
    """MilestonedIssueEventPropMilestone"""

    title: str = Field()


class DemilestonedIssueEvent(GitHubModel):
    """Demilestoned Issue Event

    Demilestoned Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["demilestoned"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    milestone: DemilestonedIssueEventPropMilestone = Field()


class DemilestonedIssueEventPropMilestone(GitHubModel):
    """DemilestonedIssueEventPropMilestone"""

    title: str = Field()


class RenamedIssueEvent(GitHubModel):
    """Renamed Issue Event

    Renamed Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["renamed"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    rename: RenamedIssueEventPropRename = Field()


class RenamedIssueEventPropRename(GitHubModel):
    """RenamedIssueEventPropRename"""

    from_: str = Field(alias="from")
    to: str = Field()


class ReviewRequestedIssueEvent(GitHubModel):
    """Review Requested Issue Event

    Review Requested Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["review_requested"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    review_requester: SimpleUser = Field(
        title="Simple User", description="A GitHub user."
    )
    requested_team: Missing[Team] = Field(
        default=UNSET,
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
    )
    requested_reviewer: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )


class ReviewRequestRemovedIssueEvent(GitHubModel):
    """Review Request Removed Issue Event

    Review Request Removed Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["review_request_removed"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    review_requester: SimpleUser = Field(
        title="Simple User", description="A GitHub user."
    )
    requested_team: Missing[Team] = Field(
        default=UNSET,
        title="Team",
        description="Groups of organization members that gives permissions on specified repositories.",
    )
    requested_reviewer: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )


class ReviewDismissedIssueEvent(GitHubModel):
    """Review Dismissed Issue Event

    Review Dismissed Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["review_dismissed"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    dismissed_review: ReviewDismissedIssueEventPropDismissedReview = Field()


class ReviewDismissedIssueEventPropDismissedReview(GitHubModel):
    """ReviewDismissedIssueEventPropDismissedReview"""

    state: str = Field()
    review_id: int = Field()
    dismissal_message: Union[str, None] = Field()
    dismissal_commit_id: Missing[str] = Field(default=UNSET)


class LockedIssueEvent(GitHubModel):
    """Locked Issue Event

    Locked Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["locked"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    lock_reason: Union[str, None] = Field()


class AddedToProjectIssueEvent(GitHubModel):
    """Added to Project Issue Event

    Added to Project Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["added_to_project"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    project_card: Missing[AddedToProjectIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class AddedToProjectIssueEventPropProjectCard(GitHubModel):
    """AddedToProjectIssueEventPropProjectCard"""

    id: int = Field()
    url: str = Field()
    project_id: int = Field()
    project_url: str = Field()
    column_name: str = Field()
    previous_column_name: Missing[str] = Field(default=UNSET)


class MovedColumnInProjectIssueEvent(GitHubModel):
    """Moved Column in Project Issue Event

    Moved Column in Project Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["moved_columns_in_project"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    project_card: Missing[MovedColumnInProjectIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class MovedColumnInProjectIssueEventPropProjectCard(GitHubModel):
    """MovedColumnInProjectIssueEventPropProjectCard"""

    id: int = Field()
    url: str = Field()
    project_id: int = Field()
    project_url: str = Field()
    column_name: str = Field()
    previous_column_name: Missing[str] = Field(default=UNSET)


class RemovedFromProjectIssueEvent(GitHubModel):
    """Removed from Project Issue Event

    Removed from Project Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["removed_from_project"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    project_card: Missing[RemovedFromProjectIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class RemovedFromProjectIssueEventPropProjectCard(GitHubModel):
    """RemovedFromProjectIssueEventPropProjectCard"""

    id: int = Field()
    url: str = Field()
    project_id: int = Field()
    project_url: str = Field()
    column_name: str = Field()
    previous_column_name: Missing[str] = Field(default=UNSET)


class ConvertedNoteToIssueIssueEvent(GitHubModel):
    """Converted Note to Issue Issue Event

    Converted Note to Issue Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["converted_note_to_issue"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Integration = Field(
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    project_card: Missing[ConvertedNoteToIssueIssueEventPropProjectCard] = Field(
        default=UNSET
    )


class ConvertedNoteToIssueIssueEventPropProjectCard(GitHubModel):
    """ConvertedNoteToIssueIssueEventPropProjectCard"""

    id: int = Field()
    url: str = Field()
    project_id: int = Field()
    project_url: str = Field()
    column_name: str = Field()
    previous_column_name: Missing[str] = Field(default=UNSET)


class Label(GitHubModel):
    """Label

    Color-coded labels help you categorize and filter your issues (just like labels
    in Gmail).
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field(description="URL for the label")
    name: str = Field(description="The name of the label.")
    description: Union[str, None] = Field()
    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()


class TimelineCommentEvent(GitHubModel):
    """Timeline Comment Event

    Timeline Comment Event
    """

    event: Literal["commented"] = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    id: int = Field(description="Unique identifier of the issue comment")
    node_id: str = Field()
    url: str = Field(description="URL for the issue comment")
    body: Missing[str] = Field(
        default=UNSET, description="Contents of the issue comment"
    )
    body_text: Missing[str] = Field(default=UNSET)
    body_html: Missing[str] = Field(default=UNSET)
    html_url: str = Field()
    user: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    created_at: datetime = Field()
    updated_at: datetime = Field()
    issue_url: str = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(default=UNSET)
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")


class TimelineCrossReferencedEvent(GitHubModel):
    """Timeline Cross Referenced Event

    Timeline Cross Referenced Event
    """

    event: Literal["cross-referenced"] = Field()
    actor: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )
    created_at: datetime = Field()
    updated_at: datetime = Field()
    source: TimelineCrossReferencedEventPropSource = Field()


class TimelineCrossReferencedEventPropSource(GitHubModel):
    """TimelineCrossReferencedEventPropSource"""

    type: Missing[str] = Field(default=UNSET)
    issue: Missing[Issue] = Field(
        default=UNSET,
        title="Issue",
        description="Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.",
    )


class TimelineCommittedEvent(GitHubModel):
    """Timeline Committed Event

    Timeline Committed Event
    """

    event: Missing[Literal["committed"]] = Field(default=UNSET)
    sha: str = Field(description="SHA for the commit")
    node_id: str = Field()
    url: str = Field()
    author: TimelineCommittedEventPropAuthor = Field(
        description="Identifying information for the git-user"
    )
    committer: TimelineCommittedEventPropCommitter = Field(
        description="Identifying information for the git-user"
    )
    message: str = Field(description="Message describing the purpose of the commit")
    tree: TimelineCommittedEventPropTree = Field()
    parents: List[TimelineCommittedEventPropParentsItems] = Field()
    verification: TimelineCommittedEventPropVerification = Field()
    html_url: str = Field()


class TimelineCommittedEventPropAuthor(GitHubModel):
    """TimelineCommittedEventPropAuthor

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit")
    email: str = Field(description="Git email address of the user")
    name: str = Field(description="Name of the git user")


class TimelineCommittedEventPropCommitter(GitHubModel):
    """TimelineCommittedEventPropCommitter

    Identifying information for the git-user
    """

    date: datetime = Field(description="Timestamp of the commit")
    email: str = Field(description="Git email address of the user")
    name: str = Field(description="Name of the git user")


class TimelineCommittedEventPropTree(GitHubModel):
    """TimelineCommittedEventPropTree"""

    sha: str = Field(description="SHA for the commit")
    url: str = Field()


class TimelineCommittedEventPropParentsItems(GitHubModel):
    """TimelineCommittedEventPropParentsItems"""

    sha: str = Field(description="SHA for the commit")
    url: str = Field()
    html_url: str = Field()


class TimelineCommittedEventPropVerification(GitHubModel):
    """TimelineCommittedEventPropVerification"""

    verified: bool = Field()
    reason: str = Field()
    signature: Union[str, None] = Field()
    payload: Union[str, None] = Field()


class TimelineReviewedEvent(GitHubModel):
    """Timeline Reviewed Event

    Timeline Reviewed Event
    """

    event: Literal["reviewed"] = Field()
    id: int = Field(description="Unique identifier of the review")
    node_id: str = Field()
    user: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    body: Union[str, None] = Field(description="The text of the review.")
    state: str = Field()
    html_url: str = Field()
    pull_request_url: str = Field()
    links: TimelineReviewedEventPropLinks = Field(alias="_links")
    submitted_at: Missing[datetime] = Field(default=UNSET)
    commit_id: str = Field(description="A commit SHA for the review.")
    body_html: Missing[Union[str, None]] = Field(default=UNSET)
    body_text: Missing[Union[str, None]] = Field(default=UNSET)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )


class TimelineReviewedEventPropLinks(GitHubModel):
    """TimelineReviewedEventPropLinks"""

    html: TimelineReviewedEventPropLinksPropHtml = Field()
    pull_request: TimelineReviewedEventPropLinksPropPullRequest = Field()


class TimelineReviewedEventPropLinksPropHtml(GitHubModel):
    """TimelineReviewedEventPropLinksPropHtml"""

    href: str = Field()


class TimelineReviewedEventPropLinksPropPullRequest(GitHubModel):
    """TimelineReviewedEventPropLinksPropPullRequest"""

    href: str = Field()


class PullRequestReviewComment(GitHubModel):
    """Pull Request Review Comment

    Pull Request Review Comments are comments on a portion of the Pull Request's
    diff.
    """

    url: str = Field(description="URL for the pull request review comment")
    pull_request_review_id: Union[int, None] = Field(
        description="The ID of the pull request review to which the comment belongs."
    )
    id: int = Field(description="The ID of the pull request review comment.")
    node_id: str = Field(description="The node ID of the pull request review comment.")
    diff_hunk: str = Field(
        description="The diff of the line that the comment refers to."
    )
    path: str = Field(
        description="The relative path of the file to which the comment applies."
    )
    position: Missing[int] = Field(
        default=UNSET,
        description="The line index in the diff to which the comment applies. This field is deprecated; use `line` instead.",
    )
    original_position: Missing[int] = Field(
        default=UNSET,
        description="The index of the original line in the diff to which the comment applies. This field is deprecated; use `original_line` instead.",
    )
    commit_id: str = Field(
        description="The SHA of the commit to which the comment applies."
    )
    original_commit_id: str = Field(
        description="The SHA of the original commit to which the comment applies."
    )
    in_reply_to_id: Missing[int] = Field(
        default=UNSET, description="The comment ID to reply to."
    )
    user: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    body: str = Field(description="The text of the comment.")
    created_at: datetime = Field()
    updated_at: datetime = Field()
    html_url: str = Field(description="HTML URL for the pull request review comment.")
    pull_request_url: str = Field(
        description="URL for the pull request that the review comment belongs to."
    )
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )
    links: PullRequestReviewCommentPropLinks = Field(alias="_links")
    start_line: Missing[Union[int, None]] = Field(
        default=UNSET,
        description="The first line of the range for a multi-line comment.",
    )
    original_start_line: Missing[Union[int, None]] = Field(
        default=UNSET,
        description="The first line of the range for a multi-line comment.",
    )
    start_side: Missing[Union[None, Literal["LEFT", "RIGHT"]]] = Field(
        default=UNSET,
        description="The side of the first line of the range for a multi-line comment.",
    )
    line: Missing[int] = Field(
        default=UNSET,
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
    )
    original_line: Missing[int] = Field(
        default=UNSET,
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
    )
    side: Missing[Literal["LEFT", "RIGHT"]] = Field(
        default=UNSET,
        description="The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment",
    )
    subject_type: Missing[Literal["line", "file"]] = Field(
        default=UNSET,
        description="The level at which the comment is targeted, can be a diff line or a file.",
    )
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")
    body_html: Missing[str] = Field(default=UNSET)
    body_text: Missing[str] = Field(default=UNSET)


class PullRequestReviewCommentPropLinks(GitHubModel):
    """PullRequestReviewCommentPropLinks"""

    self_: PullRequestReviewCommentPropLinksPropSelf = Field(alias="self")
    html: PullRequestReviewCommentPropLinksPropHtml = Field()
    pull_request: PullRequestReviewCommentPropLinksPropPullRequest = Field()


class PullRequestReviewCommentPropLinksPropSelf(GitHubModel):
    """PullRequestReviewCommentPropLinksPropSelf"""

    href: str = Field()


class PullRequestReviewCommentPropLinksPropHtml(GitHubModel):
    """PullRequestReviewCommentPropLinksPropHtml"""

    href: str = Field()


class PullRequestReviewCommentPropLinksPropPullRequest(GitHubModel):
    """PullRequestReviewCommentPropLinksPropPullRequest"""

    href: str = Field()


class TimelineLineCommentedEvent(GitHubModel):
    """Timeline Line Commented Event

    Timeline Line Commented Event
    """

    event: Missing[Literal["line_commented"]] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    comments: Missing[List[PullRequestReviewComment]] = Field(default=UNSET)


class TimelineCommitCommentedEvent(GitHubModel):
    """Timeline Commit Commented Event

    Timeline Commit Commented Event
    """

    event: Missing[Literal["commit_commented"]] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    commit_id: Missing[str] = Field(default=UNSET)
    comments: Missing[List[CommitComment]] = Field(default=UNSET)


class TimelineAssignedIssueEvent(GitHubModel):
    """Timeline Assigned Issue Event

    Timeline Assigned Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["assigned"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    assignee: SimpleUser = Field(title="Simple User", description="A GitHub user.")


class TimelineUnassignedIssueEvent(GitHubModel):
    """Timeline Unassigned Issue Event

    Timeline Unassigned Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: Literal["unassigned"] = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    assignee: SimpleUser = Field(title="Simple User", description="A GitHub user.")


class StateChangeIssueEvent(GitHubModel):
    """State Change Issue Event

    State Change Issue Event
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    actor: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    event: str = Field()
    commit_id: Union[str, None] = Field()
    commit_url: Union[str, None] = Field()
    created_at: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)


class DeployKey(GitHubModel):
    """Deploy Key

    An SSH key granting access to a single repository.
    """

    id: int = Field()
    key: str = Field()
    url: str = Field()
    title: str = Field()
    verified: bool = Field()
    created_at: str = Field()
    read_only: bool = Field()
    added_by: Missing[Union[str, None]] = Field(default=UNSET)
    last_used: Missing[Union[str, None]] = Field(default=UNSET)


class Language(ExtraGitHubModel):
    """Language

    Language
    """


class LicenseContent(GitHubModel):
    """License Content

    License Content
    """

    name: str = Field()
    path: str = Field()
    sha: str = Field()
    size: int = Field()
    url: str = Field()
    html_url: Union[str, None] = Field()
    git_url: Union[str, None] = Field()
    download_url: Union[str, None] = Field()
    type: str = Field()
    content: str = Field()
    encoding: str = Field()
    links: LicenseContentPropLinks = Field(alias="_links")
    license_: Union[None, LicenseSimple] = Field(alias="license")


class LicenseContentPropLinks(GitHubModel):
    """LicenseContentPropLinks"""

    git: Union[str, None] = Field()
    html: Union[str, None] = Field()
    self_: str = Field(alias="self")


class MergedUpstream(GitHubModel):
    """Merged upstream

    Results of a successful merge upstream request
    """

    message: Missing[str] = Field(default=UNSET)
    merge_type: Missing[Literal["merge", "fast-forward", "none"]] = Field(default=UNSET)
    base_branch: Missing[str] = Field(default=UNSET)


class PagesSourceHash(GitHubModel):
    """Pages Source Hash"""

    branch: str = Field()
    path: str = Field()


class PagesHttpsCertificate(GitHubModel):
    """Pages Https Certificate"""

    state: Literal[
        "new",
        "authorization_created",
        "authorization_pending",
        "authorized",
        "authorization_revoked",
        "issued",
        "uploaded",
        "approved",
        "errored",
        "bad_authz",
        "destroy_pending",
        "dns_changed",
    ] = Field()
    description: str = Field()
    domains: List[str] = Field(
        description="Array of the domain set and its alternate name (if it is configured)"
    )
    expires_at: Missing[date] = Field(default=UNSET)


class Page(GitHubModel):
    """GitHub Pages

    The configuration for GitHub Pages for a repository.
    """

    url: str = Field(description="The API address for accessing this Page resource.")
    status: Union[None, Literal["built", "building", "errored"]] = Field(
        description="The status of the most recent build of the Page."
    )
    cname: Union[str, None] = Field(description="The Pages site's custom domain")
    protected_domain_state: Missing[
        Union[None, Literal["pending", "verified", "unverified"]]
    ] = Field(default=UNSET, description="The state if the domain is verified")
    pending_domain_unverified_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The timestamp when a pending domain becomes unverified.",
    )
    custom_404: bool = Field(
        default=False, description="Whether the Page has a custom 404 page."
    )
    html_url: Missing[str] = Field(
        default=UNSET, description="The web address the Page can be accessed from."
    )
    build_type: Missing[Union[None, Literal["legacy", "workflow"]]] = Field(
        default=UNSET, description="The process in which the Page will be built."
    )
    source: Missing[PagesSourceHash] = Field(default=UNSET, title="Pages Source Hash")
    public: bool = Field(
        description="Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site."
    )
    https_certificate: Missing[PagesHttpsCertificate] = Field(
        default=UNSET, title="Pages Https Certificate"
    )
    https_enforced: Missing[bool] = Field(
        default=UNSET, description="Whether https is enabled on the domain"
    )


class PageBuild(GitHubModel):
    """Page Build

    Page Build
    """

    url: str = Field()
    status: str = Field()
    error: PageBuildPropError = Field()
    pusher: Union[None, SimpleUser] = Field()
    commit: str = Field()
    duration: int = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()


class PageBuildPropError(GitHubModel):
    """PageBuildPropError"""

    message: Union[str, None] = Field()


class PageBuildStatus(GitHubModel):
    """Page Build Status

    Page Build Status
    """

    url: str = Field()
    status: str = Field()


class PageDeployment(GitHubModel):
    """GitHub Pages

    The GitHub Pages deployment status.
    """

    status_url: str = Field(
        description="The URI to monitor GitHub Pages deployment status."
    )
    page_url: str = Field(description="The URI to the deployed GitHub Pages.")
    preview_url: Missing[str] = Field(
        default=UNSET, description="The URI to the deployed GitHub Pages preview."
    )


class PagesHealthCheck(GitHubModel):
    """Pages Health Check Status

    Pages Health Check Status
    """

    domain: Missing[PagesHealthCheckPropDomain] = Field(default=UNSET)
    alt_domain: Missing[Union[PagesHealthCheckPropAltDomain, None]] = Field(
        default=UNSET
    )


class PagesHealthCheckPropDomain(GitHubModel):
    """PagesHealthCheckPropDomain"""

    host: Missing[str] = Field(default=UNSET)
    uri: Missing[str] = Field(default=UNSET)
    nameservers: Missing[str] = Field(default=UNSET)
    dns_resolves: Missing[bool] = Field(default=UNSET)
    is_proxied: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cloudflare_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_fastly_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_old_ip_address: Missing[Union[bool, None]] = Field(default=UNSET)
    is_a_record: Missing[Union[bool, None]] = Field(default=UNSET)
    has_cname_record: Missing[Union[bool, None]] = Field(default=UNSET)
    has_mx_records_present: Missing[Union[bool, None]] = Field(default=UNSET)
    is_valid_domain: Missing[bool] = Field(default=UNSET)
    is_apex_domain: Missing[bool] = Field(default=UNSET)
    should_be_a_record: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cname_to_github_user_domain: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cname_to_pages_dot_github_dot_com: Missing[Union[bool, None]] = Field(
        default=UNSET
    )
    is_cname_to_fastly: Missing[Union[bool, None]] = Field(default=UNSET)
    is_pointed_to_github_pages_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_non_github_pages_ip_present: Missing[Union[bool, None]] = Field(default=UNSET)
    is_pages_domain: Missing[bool] = Field(default=UNSET)
    is_served_by_pages: Missing[Union[bool, None]] = Field(default=UNSET)
    is_valid: Missing[bool] = Field(default=UNSET)
    reason: Missing[Union[str, None]] = Field(default=UNSET)
    responds_to_https: Missing[bool] = Field(default=UNSET)
    enforces_https: Missing[bool] = Field(default=UNSET)
    https_error: Missing[Union[str, None]] = Field(default=UNSET)
    is_https_eligible: Missing[Union[bool, None]] = Field(default=UNSET)
    caa_error: Missing[Union[str, None]] = Field(default=UNSET)


class PagesHealthCheckPropAltDomain(GitHubModel):
    """PagesHealthCheckPropAltDomain"""

    host: Missing[str] = Field(default=UNSET)
    uri: Missing[str] = Field(default=UNSET)
    nameservers: Missing[str] = Field(default=UNSET)
    dns_resolves: Missing[bool] = Field(default=UNSET)
    is_proxied: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cloudflare_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_fastly_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_old_ip_address: Missing[Union[bool, None]] = Field(default=UNSET)
    is_a_record: Missing[Union[bool, None]] = Field(default=UNSET)
    has_cname_record: Missing[Union[bool, None]] = Field(default=UNSET)
    has_mx_records_present: Missing[Union[bool, None]] = Field(default=UNSET)
    is_valid_domain: Missing[bool] = Field(default=UNSET)
    is_apex_domain: Missing[bool] = Field(default=UNSET)
    should_be_a_record: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cname_to_github_user_domain: Missing[Union[bool, None]] = Field(default=UNSET)
    is_cname_to_pages_dot_github_dot_com: Missing[Union[bool, None]] = Field(
        default=UNSET
    )
    is_cname_to_fastly: Missing[Union[bool, None]] = Field(default=UNSET)
    is_pointed_to_github_pages_ip: Missing[Union[bool, None]] = Field(default=UNSET)
    is_non_github_pages_ip_present: Missing[Union[bool, None]] = Field(default=UNSET)
    is_pages_domain: Missing[bool] = Field(default=UNSET)
    is_served_by_pages: Missing[Union[bool, None]] = Field(default=UNSET)
    is_valid: Missing[bool] = Field(default=UNSET)
    reason: Missing[Union[str, None]] = Field(default=UNSET)
    responds_to_https: Missing[bool] = Field(default=UNSET)
    enforces_https: Missing[bool] = Field(default=UNSET)
    https_error: Missing[Union[str, None]] = Field(default=UNSET)
    is_https_eligible: Missing[Union[bool, None]] = Field(default=UNSET)
    caa_error: Missing[Union[str, None]] = Field(default=UNSET)


class PullRequest(GitHubModel):
    """Pull Request

    Pull requests let you tell others about changes you've pushed to a repository on
    GitHub. Once a pull request is sent, interested parties can review the set of
    changes, discuss potential modifications, and even push follow-up commits if
    necessary.
    """

    url: str = Field()
    id: int = Field()
    node_id: str = Field()
    html_url: str = Field()
    diff_url: str = Field()
    patch_url: str = Field()
    issue_url: str = Field()
    commits_url: str = Field()
    review_comments_url: str = Field()
    review_comment_url: str = Field()
    comments_url: str = Field()
    statuses_url: str = Field()
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository."
    )
    state: Literal["open", "closed"] = Field(
        description="State of this Pull Request. Either `open` or `closed`."
    )
    locked: bool = Field()
    title: str = Field(description="The title of the pull request.")
    user: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    body: Union[str, None] = Field()
    labels: List[PullRequestPropLabelsItems] = Field()
    milestone: Union[None, Milestone] = Field()
    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    created_at: datetime = Field()
    updated_at: datetime = Field()
    closed_at: Union[datetime, None] = Field()
    merged_at: Union[datetime, None] = Field()
    merge_commit_sha: Union[str, None] = Field()
    assignee: Union[None, SimpleUser] = Field()
    assignees: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_reviewers: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    requested_teams: Missing[Union[List[TeamSimple], None]] = Field(default=UNSET)
    head: PullRequestPropHead = Field()
    base: PullRequestPropBase = Field()
    links: PullRequestPropLinks = Field(alias="_links")
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )
    auto_merge: Union[AutoMerge, None] = Field(
        title="Auto merge", description="The status of auto merging a pull request."
    )
    draft: Missing[bool] = Field(
        default=UNSET,
        description="Indicates whether or not the pull request is a draft.",
    )
    merged: bool = Field()
    mergeable: Union[bool, None] = Field()
    rebaseable: Missing[Union[bool, None]] = Field(default=UNSET)
    mergeable_state: str = Field()
    merged_by: Union[None, SimpleUser] = Field()
    comments: int = Field()
    review_comments: int = Field()
    maintainer_can_modify: bool = Field(
        description="Indicates whether maintainers can modify the pull request."
    )
    commits: int = Field()
    additions: int = Field()
    deletions: int = Field()
    changed_files: int = Field()


class PullRequestPropLabelsItems(GitHubModel):
    """PullRequestPropLabelsItems"""

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    name: str = Field()
    description: Union[str, None] = Field()
    color: str = Field()
    default: bool = Field()


class PullRequestPropHead(GitHubModel):
    """PullRequestPropHead"""

    label: Union[str, None] = Field()
    ref: str = Field()
    repo: Union[PullRequestPropHeadPropRepo, None] = Field()
    sha: str = Field()
    user: Union[PullRequestPropHeadPropUser, None] = Field()


class PullRequestPropHeadPropRepoPropOwner(GitHubModel):
    """PullRequestPropHeadPropRepoPropOwner"""

    avatar_url: str = Field()
    events_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    login: str = Field()
    organizations_url: str = Field()
    received_events_url: str = Field()
    repos_url: str = Field()
    site_admin: bool = Field()
    starred_url: str = Field()
    subscriptions_url: str = Field()
    type: str = Field()
    url: str = Field()


class PullRequestPropHeadPropRepoPropPermissions(GitHubModel):
    """PullRequestPropHeadPropRepoPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()


class PullRequestPropHeadPropRepoPropLicense(GitHubModel):
    """PullRequestPropHeadPropRepoPropLicense"""

    key: str = Field()
    name: str = Field()
    url: Union[str, None] = Field()
    spdx_id: Union[str, None] = Field()
    node_id: str = Field()


class PullRequestPropHeadPropRepo(GitHubModel):
    """PullRequestPropHeadPropRepo"""

    archive_url: str = Field()
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    languages_url: str = Field()
    merges_url: str = Field()
    milestones_url: str = Field()
    name: str = Field()
    notifications_url: str = Field()
    owner: PullRequestPropHeadPropRepoPropOwner = Field()
    private: bool = Field()
    pulls_url: str = Field()
    releases_url: str = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    trees_url: str = Field()
    url: str = Field()
    clone_url: str = Field()
    default_branch: str = Field()
    forks: int = Field()
    forks_count: int = Field()
    git_url: str = Field()
    has_downloads: bool = Field()
    has_issues: bool = Field()
    has_projects: bool = Field()
    has_wiki: bool = Field()
    has_pages: bool = Field()
    has_discussions: bool = Field()
    homepage: Union[str, None] = Field()
    language: Union[str, None] = Field()
    master_branch: Missing[str] = Field(default=UNSET)
    archived: bool = Field()
    disabled: bool = Field()
    visibility: Missing[str] = Field(
        default=UNSET,
        description="The repository visibility: public, private, or internal.",
    )
    mirror_url: Union[str, None] = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    permissions: Missing[PullRequestPropHeadPropRepoPropPermissions] = Field(
        default=UNSET
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    license_: Union[PullRequestPropHeadPropRepoPropLicense, None] = Field(
        alias="license"
    )
    pushed_at: datetime = Field()
    size: int = Field()
    ssh_url: str = Field()
    stargazers_count: int = Field()
    svn_url: str = Field()
    topics: Missing[List[str]] = Field(default=UNSET)
    watchers: int = Field()
    watchers_count: int = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    allow_forking: Missing[bool] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)


class PullRequestPropHeadPropUser(GitHubModel):
    """PullRequestPropHeadPropUser"""

    avatar_url: str = Field()
    events_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    login: str = Field()
    organizations_url: str = Field()
    received_events_url: str = Field()
    repos_url: str = Field()
    site_admin: bool = Field()
    starred_url: str = Field()
    subscriptions_url: str = Field()
    type: str = Field()
    url: str = Field()


class PullRequestPropBase(GitHubModel):
    """PullRequestPropBase"""

    label: str = Field()
    ref: str = Field()
    repo: PullRequestPropBasePropRepo = Field()
    sha: str = Field()
    user: PullRequestPropBasePropUser = Field()


class PullRequestPropBasePropRepo(GitHubModel):
    """PullRequestPropBasePropRepo"""

    archive_url: str = Field()
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    is_template: Missing[bool] = Field(default=UNSET)
    node_id: str = Field()
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    languages_url: str = Field()
    merges_url: str = Field()
    milestones_url: str = Field()
    name: str = Field()
    notifications_url: str = Field()
    owner: PullRequestPropBasePropRepoPropOwner = Field()
    private: bool = Field()
    pulls_url: str = Field()
    releases_url: str = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    trees_url: str = Field()
    url: str = Field()
    clone_url: str = Field()
    default_branch: str = Field()
    forks: int = Field()
    forks_count: int = Field()
    git_url: str = Field()
    has_downloads: bool = Field()
    has_issues: bool = Field()
    has_projects: bool = Field()
    has_wiki: bool = Field()
    has_pages: bool = Field()
    has_discussions: bool = Field()
    homepage: Union[str, None] = Field()
    language: Union[str, None] = Field()
    master_branch: Missing[str] = Field(default=UNSET)
    archived: bool = Field()
    disabled: bool = Field()
    visibility: Missing[str] = Field(
        default=UNSET,
        description="The repository visibility: public, private, or internal.",
    )
    mirror_url: Union[str, None] = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    permissions: Missing[PullRequestPropBasePropRepoPropPermissions] = Field(
        default=UNSET
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    license_: Union[None, LicenseSimple] = Field(alias="license")
    pushed_at: datetime = Field()
    size: int = Field()
    ssh_url: str = Field()
    stargazers_count: int = Field()
    svn_url: str = Field()
    topics: Missing[List[str]] = Field(default=UNSET)
    watchers: int = Field()
    watchers_count: int = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    allow_forking: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)


class PullRequestPropBasePropRepoPropOwner(GitHubModel):
    """PullRequestPropBasePropRepoPropOwner"""

    avatar_url: str = Field()
    events_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    login: str = Field()
    organizations_url: str = Field()
    received_events_url: str = Field()
    repos_url: str = Field()
    site_admin: bool = Field()
    starred_url: str = Field()
    subscriptions_url: str = Field()
    type: str = Field()
    url: str = Field()


class PullRequestPropBasePropRepoPropPermissions(GitHubModel):
    """PullRequestPropBasePropRepoPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()


class PullRequestPropBasePropUser(GitHubModel):
    """PullRequestPropBasePropUser"""

    avatar_url: str = Field()
    events_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    login: str = Field()
    organizations_url: str = Field()
    received_events_url: str = Field()
    repos_url: str = Field()
    site_admin: bool = Field()
    starred_url: str = Field()
    subscriptions_url: str = Field()
    type: str = Field()
    url: str = Field()


class PullRequestPropLinks(GitHubModel):
    """PullRequestPropLinks"""

    comments: Link = Field(title="Link", description="Hypermedia Link")
    commits: Link = Field(title="Link", description="Hypermedia Link")
    statuses: Link = Field(title="Link", description="Hypermedia Link")
    html: Link = Field(title="Link", description="Hypermedia Link")
    issue: Link = Field(title="Link", description="Hypermedia Link")
    review_comments: Link = Field(title="Link", description="Hypermedia Link")
    review_comment: Link = Field(title="Link", description="Hypermedia Link")
    self_: Link = Field(alias="self", title="Link", description="Hypermedia Link")


class PullRequestMergeResult(GitHubModel):
    """Pull Request Merge Result

    Pull Request Merge Result
    """

    sha: str = Field()
    merged: bool = Field()
    message: str = Field()


class PullRequestReviewRequest(GitHubModel):
    """Pull Request Review Request

    Pull Request Review Request
    """

    users: List[SimpleUser] = Field()
    teams: List[Team] = Field()


class PullRequestReview(GitHubModel):
    """Pull Request Review

    Pull Request Reviews are reviews on pull requests.
    """

    id: int = Field(description="Unique identifier of the review")
    node_id: str = Field()
    user: Union[None, SimpleUser] = Field()
    body: str = Field(description="The text of the review.")
    state: str = Field()
    html_url: str = Field()
    pull_request_url: str = Field()
    links: PullRequestReviewPropLinks = Field(alias="_links")
    submitted_at: Missing[datetime] = Field(default=UNSET)
    commit_id: Union[str, None] = Field(
        description="A commit SHA for the review. If the commit object was garbage collected or forcibly deleted, then it no longer exists in Git and this value will be `null`."
    )
    body_html: Missing[str] = Field(default=UNSET)
    body_text: Missing[str] = Field(default=UNSET)
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )


class PullRequestReviewPropLinks(GitHubModel):
    """PullRequestReviewPropLinks"""

    html: PullRequestReviewPropLinksPropHtml = Field()
    pull_request: PullRequestReviewPropLinksPropPullRequest = Field()


class PullRequestReviewPropLinksPropHtml(GitHubModel):
    """PullRequestReviewPropLinksPropHtml"""

    href: str = Field()


class PullRequestReviewPropLinksPropPullRequest(GitHubModel):
    """PullRequestReviewPropLinksPropPullRequest"""

    href: str = Field()


class ReviewComment(GitHubModel):
    """Legacy Review Comment

    Legacy Review Comment
    """

    url: str = Field()
    pull_request_review_id: Union[int, None] = Field()
    id: int = Field()
    node_id: str = Field()
    diff_hunk: str = Field()
    path: str = Field()
    position: Union[int, None] = Field()
    original_position: int = Field()
    commit_id: str = Field()
    original_commit_id: str = Field()
    in_reply_to_id: Missing[int] = Field(default=UNSET)
    user: Union[None, SimpleUser] = Field()
    body: str = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    html_url: str = Field()
    pull_request_url: str = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )
    links: ReviewCommentPropLinks = Field(alias="_links")
    body_text: Missing[str] = Field(default=UNSET)
    body_html: Missing[str] = Field(default=UNSET)
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")
    side: Missing[Literal["LEFT", "RIGHT"]] = Field(
        default=UNSET,
        description="The side of the first line of the range for a multi-line comment.",
    )
    start_side: Missing[Union[None, Literal["LEFT", "RIGHT"]]] = Field(
        default=UNSET,
        description="The side of the first line of the range for a multi-line comment.",
    )
    line: Missing[int] = Field(
        default=UNSET,
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment",
    )
    original_line: Missing[int] = Field(
        default=UNSET,
        description="The original line of the blob to which the comment applies. The last line of the range for a multi-line comment",
    )
    start_line: Missing[Union[int, None]] = Field(
        default=UNSET,
        description="The first line of the range for a multi-line comment.",
    )
    original_start_line: Missing[Union[int, None]] = Field(
        default=UNSET,
        description="The original first line of the range for a multi-line comment.",
    )


class ReviewCommentPropLinks(GitHubModel):
    """ReviewCommentPropLinks"""

    self_: Link = Field(alias="self", title="Link", description="Hypermedia Link")
    html: Link = Field(title="Link", description="Hypermedia Link")
    pull_request: Link = Field(title="Link", description="Hypermedia Link")


class ReleaseAsset(GitHubModel):
    """Release Asset

    Data related to a release.
    """

    url: str = Field()
    browser_download_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    name: str = Field(description="The file name of the asset.")
    label: Union[str, None] = Field()
    state: Literal["uploaded", "open"] = Field(
        description="State of the release asset."
    )
    content_type: str = Field()
    size: int = Field()
    download_count: int = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    uploader: Union[None, SimpleUser] = Field()


class Release(GitHubModel):
    """Release

    A release.
    """

    url: str = Field()
    html_url: str = Field()
    assets_url: str = Field()
    upload_url: str = Field()
    tarball_url: Union[str, None] = Field()
    zipball_url: Union[str, None] = Field()
    id: int = Field()
    node_id: str = Field()
    tag_name: str = Field(description="The name of the tag.")
    target_commitish: str = Field(
        description="Specifies the commitish value that determines where the Git tag is created from."
    )
    name: Union[str, None] = Field()
    body: Missing[Union[str, None]] = Field(default=UNSET)
    draft: bool = Field(
        description="true to create a draft (unpublished) release, false to create a published one."
    )
    prerelease: bool = Field(
        description="Whether to identify the release as a prerelease or a full release."
    )
    created_at: datetime = Field()
    published_at: Union[datetime, None] = Field()
    author: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    assets: List[ReleaseAsset] = Field()
    body_html: Missing[Union[str, None]] = Field(default=UNSET)
    body_text: Missing[Union[str, None]] = Field(default=UNSET)
    mentions_count: Missing[int] = Field(default=UNSET)
    discussion_url: Missing[str] = Field(
        default=UNSET, description="The URL of the release discussion."
    )
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")


class ReleaseNotesContent(GitHubModel):
    """Generated Release Notes Content

    Generated name and body describing a release
    """

    name: str = Field(description="The generated name of the release")
    body: str = Field(
        description="The generated body describing the contents of the release supporting markdown formatting"
    )


class RepositoryRuleRulesetInfo(GitHubModel):
    """repository ruleset data for rule

    User-defined metadata to store domain-specific information limited to 8 keys
    with scalar values.
    """

    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof0(GitHubModel):
    """RepositoryRuleDetailedOneof0"""

    type: Literal["creation"] = Field()
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof1(GitHubModel):
    """RepositoryRuleDetailedOneof1"""

    type: Literal["update"] = Field()
    parameters: Missing[RepositoryRuleUpdatePropParameters] = Field(default=UNSET)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof2(GitHubModel):
    """RepositoryRuleDetailedOneof2"""

    type: Literal["deletion"] = Field()
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof3(GitHubModel):
    """RepositoryRuleDetailedOneof3"""

    type: Literal["required_linear_history"] = Field()
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof4(GitHubModel):
    """RepositoryRuleDetailedOneof4"""

    type: Literal["required_deployments"] = Field()
    parameters: Missing[RepositoryRuleRequiredDeploymentsPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof5(GitHubModel):
    """RepositoryRuleDetailedOneof5"""

    type: Literal["required_signatures"] = Field()
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof6(GitHubModel):
    """RepositoryRuleDetailedOneof6"""

    type: Literal["pull_request"] = Field()
    parameters: Missing[RepositoryRulePullRequestPropParameters] = Field(default=UNSET)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof7(GitHubModel):
    """RepositoryRuleDetailedOneof7"""

    type: Literal["required_status_checks"] = Field()
    parameters: Missing[RepositoryRuleRequiredStatusChecksPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof8(GitHubModel):
    """RepositoryRuleDetailedOneof8"""

    type: Literal["non_fast_forward"] = Field()
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof9(GitHubModel):
    """RepositoryRuleDetailedOneof9"""

    type: Literal["commit_message_pattern"] = Field()
    parameters: Missing[RepositoryRuleCommitMessagePatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof10(GitHubModel):
    """RepositoryRuleDetailedOneof10"""

    type: Literal["commit_author_email_pattern"] = Field()
    parameters: Missing[RepositoryRuleCommitAuthorEmailPatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof11(GitHubModel):
    """RepositoryRuleDetailedOneof11"""

    type: Literal["committer_email_pattern"] = Field()
    parameters: Missing[RepositoryRuleCommitterEmailPatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof12(GitHubModel):
    """RepositoryRuleDetailedOneof12"""

    type: Literal["branch_name_pattern"] = Field()
    parameters: Missing[RepositoryRuleBranchNamePatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof13(GitHubModel):
    """RepositoryRuleDetailedOneof13"""

    type: Literal["tag_name_pattern"] = Field()
    parameters: Missing[RepositoryRuleTagNamePatternPropParameters] = Field(
        default=UNSET
    )
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class RepositoryRuleDetailedOneof14(GitHubModel):
    """RepositoryRuleDetailedOneof14"""

    type: Literal["workflows"] = Field()
    parameters: Missing[RepositoryRuleWorkflowsPropParameters] = Field(default=UNSET)
    ruleset_source_type: Missing[Literal["Repository", "Organization"]] = Field(
        default=UNSET,
        description="The type of source for the ruleset that includes this rule.",
    )
    ruleset_source: Missing[str] = Field(
        default=UNSET,
        description="The name of the source of the ruleset that includes this rule.",
    )
    ruleset_id: Missing[int] = Field(
        default=UNSET, description="The ID of the ruleset that includes this rule."
    )


class SecretScanningAlert(GitHubModel):
    """SecretScanningAlert"""

    number: Missing[int] = Field(
        default=UNSET, description="The security alert number."
    )
    created_at: Missing[datetime] = Field(
        default=UNSET,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    updated_at: Missing[Union[None, datetime]] = Field(default=UNSET)
    url: Missing[str] = Field(
        default=UNSET, description="The REST API URL of the alert resource."
    )
    html_url: Missing[str] = Field(
        default=UNSET, description="The GitHub URL of the alert resource."
    )
    locations_url: Missing[str] = Field(
        default=UNSET,
        description="The REST API URL of the code locations for this alert.",
    )
    state: Missing[Literal["open", "resolved"]] = Field(
        default=UNSET,
        description="Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.",
    )
    resolution: Missing[
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]]
    ] = Field(
        default=UNSET,
        description="**Required when the `state` is `resolved`.** The reason for resolving the alert.",
    )
    resolved_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    resolved_by: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    resolution_comment: Missing[Union[str, None]] = Field(
        default=UNSET, description="An optional comment to resolve an alert."
    )
    secret_type: Missing[str] = Field(
        default=UNSET, description="The type of secret that secret scanning detected."
    )
    secret_type_display_name: Missing[str] = Field(
        default=UNSET,
        description='User-friendly name for the detected secret, matching the `secret_type`.\nFor a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."',
    )
    secret: Missing[str] = Field(
        default=UNSET, description="The secret that was detected."
    )
    push_protection_bypassed: Missing[Union[bool, None]] = Field(
        default=UNSET,
        description="Whether push protection was bypassed for the detected secret.",
    )
    push_protection_bypassed_by: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    push_protection_bypassed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    validity: Missing[Literal["active", "inactive", "unknown"]] = Field(
        default=UNSET, description="The token status as of the latest validity check."
    )


class SecretScanningLocationCommit(GitHubModel):
    """SecretScanningLocationCommit

    Represents a 'commit' secret scanning location type. This location type shows
    that a secret was detected inside a commit to a repository.
    """

    path: str = Field(description="The file path in the repository")
    start_line: float = Field(
        description="Line number at which the secret starts in the file"
    )
    end_line: float = Field(
        description="Line number at which the secret ends in the file"
    )
    start_column: float = Field(
        description="The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII"
    )
    end_column: float = Field(
        description="The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII"
    )
    blob_sha: str = Field(description="SHA-1 hash ID of the associated blob")
    blob_url: str = Field(description="The API URL to get the associated blob resource")
    commit_sha: str = Field(description="SHA-1 hash ID of the associated commit")
    commit_url: str = Field(
        description="The API URL to get the associated commit resource"
    )


class SecretScanningLocationIssueTitle(GitHubModel):
    """SecretScanningLocationIssueTitle

    Represents an 'issue_title' secret scanning location type. This location type
    shows that a secret was detected in the title of an issue.
    """

    issue_title_url: str = Field(
        description="The API URL to get the issue where the secret was detected."
    )


class SecretScanningLocationIssueBody(GitHubModel):
    """SecretScanningLocationIssueBody

    Represents an 'issue_body' secret scanning location type. This location type
    shows that a secret was detected in the body of an issue.
    """

    issue_body_url: str = Field(
        description="The API URL to get the issue where the secret was detected."
    )


class SecretScanningLocationIssueComment(GitHubModel):
    """SecretScanningLocationIssueComment

    Represents an 'issue_comment' secret scanning location type. This location type
    shows that a secret was detected in a comment on an issue.
    """

    issue_comment_url: str = Field(
        description="The API URL to get the issue comment where the secret was detected."
    )


class SecretScanningLocationDiscussionTitle(GitHubModel):
    """SecretScanningLocationDiscussionTitle

    Represents a 'discussion_title' secret scanning location type. This location
    type shows that a secret was detected in the title of a discussion.
    """

    discussion_title_url: str = Field(
        description="The URL to the discussion where the secret was detected."
    )


class SecretScanningLocationDiscussionBody(GitHubModel):
    """SecretScanningLocationDiscussionBody

    Represents a 'discussion_body' secret scanning location type. This location type
    shows that a secret was detected in the body of a discussion.
    """

    discussion_body_url: str = Field(
        description="The URL to the discussion where the secret was detected."
    )


class SecretScanningLocationDiscussionComment(GitHubModel):
    """SecretScanningLocationDiscussionComment

    Represents a 'discussion_comment' secret scanning location type. This location
    type shows that a secret was detected in a comment on a discussion.
    """

    discussion_comment_url: str = Field(
        description="The API URL to get the discussion comment where the secret was detected."
    )


class SecretScanningLocationPullRequestTitle(GitHubModel):
    """SecretScanningLocationPullRequestTitle

    Represents a 'pull_request_title' secret scanning location type. This location
    type shows that a secret was detected in the title of a pull request.
    """

    pull_request_title_url: str = Field(
        description="The API URL to get the pull request where the secret was detected."
    )


class SecretScanningLocationPullRequestBody(GitHubModel):
    """SecretScanningLocationPullRequestBody

    Represents a 'pull_request_body' secret scanning location type. This location
    type shows that a secret was detected in the body of a pull request.
    """

    pull_request_body_url: str = Field(
        description="The API URL to get the pull request where the secret was detected."
    )


class SecretScanningLocationPullRequestComment(GitHubModel):
    """SecretScanningLocationPullRequestComment

    Represents a 'pull_request_comment' secret scanning location type. This location
    type shows that a secret was detected in a comment on a pull request.
    """

    pull_request_comment_url: str = Field(
        description="The API URL to get the pull request comment where the secret was detected."
    )


class SecretScanningLocationPullRequestReview(GitHubModel):
    """SecretScanningLocationPullRequestReview

    Represents a 'pull_request_review' secret scanning location type. This location
    type shows that a secret was detected in a review on a pull request.
    """

    pull_request_review_url: str = Field(
        description="The API URL to get the pull request review where the secret was detected."
    )


class SecretScanningLocationPullRequestReviewComment(GitHubModel):
    """SecretScanningLocationPullRequestReviewComment

    Represents a 'pull_request_review_comment' secret scanning location type. This
    location type shows that a secret was detected in a review comment on a pull
    request.
    """

    pull_request_review_comment_url: str = Field(
        description="The API URL to get the pull request review comment where the secret was detected."
    )


class SecretScanningLocation(GitHubModel):
    """SecretScanningLocation"""

    type: Literal[
        "commit",
        "issue_title",
        "issue_body",
        "issue_comment",
        "discussion_title",
        "discussion_body",
        "discussion_comment",
        "pull_request_title",
        "pull_request_body",
        "pull_request_comment",
        "pull_request_review",
        "pull_request_review_comment",
    ] = Field(
        description="The location type. Because secrets may be found in different types of resources (ie. code, comments, issues, pull requests, discussions), this field identifies the type of resource where the secret was found."
    )
    details: Union[
        SecretScanningLocationCommit,
        SecretScanningLocationIssueTitle,
        SecretScanningLocationIssueBody,
        SecretScanningLocationIssueComment,
        SecretScanningLocationDiscussionTitle,
        SecretScanningLocationDiscussionBody,
        SecretScanningLocationDiscussionComment,
        SecretScanningLocationPullRequestTitle,
        SecretScanningLocationPullRequestBody,
        SecretScanningLocationPullRequestComment,
        SecretScanningLocationPullRequestReview,
        SecretScanningLocationPullRequestReviewComment,
    ] = Field()


class RepositoryAdvisoryCreate(GitHubModel):
    """RepositoryAdvisoryCreate"""

    summary: Annotated[str, Field(max_length=1024)] = Field(
        description="A short summary of the advisory."
    )
    description: Annotated[str, Field(max_length=65535)] = Field(
        description="A detailed description of what the advisory impacts."
    )
    cve_id: Missing[Union[str, None]] = Field(
        default=UNSET, description="The Common Vulnerabilities and Exposures (CVE) ID."
    )
    vulnerabilities: List[RepositoryAdvisoryCreatePropVulnerabilitiesItems] = Field(
        description="A product affected by the vulnerability detailed in a repository security advisory."
    )
    cwe_ids: Missing[Union[List[str], None]] = Field(
        default=UNSET, description="A list of Common Weakness Enumeration (CWE) IDs."
    )
    credits_: Missing[
        Union[List[RepositoryAdvisoryCreatePropCreditsItems], None]
    ] = Field(
        default=UNSET,
        alias="credits",
        description="A list of users receiving credit for their participation in the security advisory.",
    )
    severity: Missing[
        Union[None, Literal["critical", "high", "medium", "low"]]
    ] = Field(
        default=UNSET,
        description="The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.",
    )
    cvss_vector_string: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.",
    )
    start_private_fork: Missing[bool] = Field(
        default=UNSET,
        description="Whether to create a temporary private fork of the repository to collaborate on a fix.",
    )


class RepositoryAdvisoryCreatePropVulnerabilitiesItems(GitHubModel):
    """RepositoryAdvisoryCreatePropVulnerabilitiesItems"""

    package: RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackage = Field(
        description="The name of the package affected by the vulnerability."
    )
    vulnerable_version_range: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The range of the package versions affected by the vulnerability.",
    )
    patched_versions: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The package version(s) that resolve the vulnerability.",
    )
    vulnerable_functions: Missing[Union[List[str], None]] = Field(
        default=UNSET, description="The functions in the package that are affected."
    )


class RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackage(GitHubModel):
    """RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(description="The package's language or package management ecosystem.")
    name: Missing[Union[str, None]] = Field(
        default=UNSET, description="The unique package name within its ecosystem."
    )


class RepositoryAdvisoryCreatePropCreditsItems(GitHubModel):
    """RepositoryAdvisoryCreatePropCreditsItems"""

    login: str = Field(description="The username of the user credited.")
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ] = Field(description="The type of credit the user is receiving.")


class PrivateVulnerabilityReportCreate(GitHubModel):
    """PrivateVulnerabilityReportCreate"""

    summary: Annotated[str, Field(max_length=1024)] = Field(
        description="A short summary of the advisory."
    )
    description: Annotated[str, Field(max_length=65535)] = Field(
        description="A detailed description of what the advisory impacts."
    )
    vulnerabilities: Missing[
        Union[List[PrivateVulnerabilityReportCreatePropVulnerabilitiesItems], None]
    ] = Field(
        default=UNSET,
        description="An array of products affected by the vulnerability detailed in a repository security advisory.",
    )
    cwe_ids: Missing[Union[List[str], None]] = Field(
        default=UNSET, description="A list of Common Weakness Enumeration (CWE) IDs."
    )
    severity: Missing[
        Union[None, Literal["critical", "high", "medium", "low"]]
    ] = Field(
        default=UNSET,
        description="The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.",
    )
    cvss_vector_string: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.",
    )
    start_private_fork: Missing[bool] = Field(
        default=UNSET,
        description="Whether to create a temporary private fork of the repository to collaborate on a fix.",
    )


class PrivateVulnerabilityReportCreatePropVulnerabilitiesItems(GitHubModel):
    """PrivateVulnerabilityReportCreatePropVulnerabilitiesItems"""

    package: PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackage = (
        Field(description="The name of the package affected by the vulnerability.")
    )
    vulnerable_version_range: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The range of the package versions affected by the vulnerability.",
    )
    patched_versions: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The package version(s) that resolve the vulnerability.",
    )
    vulnerable_functions: Missing[Union[List[str], None]] = Field(
        default=UNSET, description="The functions in the package that are affected."
    )


class PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackage(GitHubModel):
    """PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(description="The package's language or package management ecosystem.")
    name: Missing[Union[str, None]] = Field(
        default=UNSET, description="The unique package name within its ecosystem."
    )


class RepositoryAdvisoryUpdate(GitHubModel):
    """RepositoryAdvisoryUpdate"""

    summary: Missing[Annotated[str, Field(max_length=1024)]] = Field(
        default=UNSET, description="A short summary of the advisory."
    )
    description: Missing[Annotated[str, Field(max_length=65535)]] = Field(
        default=UNSET,
        description="A detailed description of what the advisory impacts.",
    )
    cve_id: Missing[Union[str, None]] = Field(
        default=UNSET, description="The Common Vulnerabilities and Exposures (CVE) ID."
    )
    vulnerabilities: Missing[
        List[RepositoryAdvisoryUpdatePropVulnerabilitiesItems]
    ] = Field(
        default=UNSET,
        description="A product affected by the vulnerability detailed in a repository security advisory.",
    )
    cwe_ids: Missing[Union[List[str], None]] = Field(
        default=UNSET, description="A list of Common Weakness Enumeration (CWE) IDs."
    )
    credits_: Missing[
        Union[List[RepositoryAdvisoryUpdatePropCreditsItems], None]
    ] = Field(
        default=UNSET,
        alias="credits",
        description="A list of users receiving credit for their participation in the security advisory.",
    )
    severity: Missing[
        Union[None, Literal["critical", "high", "medium", "low"]]
    ] = Field(
        default=UNSET,
        description="The severity of the advisory. You must choose between setting this field or `cvss_vector_string`.",
    )
    cvss_vector_string: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The CVSS vector that calculates the severity of the advisory. You must choose between setting this field or `severity`.",
    )
    state: Missing[Literal["published", "closed", "draft"]] = Field(
        default=UNSET, description="The state of the advisory."
    )
    collaborating_users: Missing[Union[List[str], None]] = Field(
        default=UNSET,
        description="A list of usernames who have been granted write access to the advisory.",
    )
    collaborating_teams: Missing[Union[List[str], None]] = Field(
        default=UNSET,
        description="A list of team slugs which have been granted write access to the advisory.",
    )


class RepositoryAdvisoryUpdatePropVulnerabilitiesItems(GitHubModel):
    """RepositoryAdvisoryUpdatePropVulnerabilitiesItems"""

    package: RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackage = Field(
        description="The name of the package affected by the vulnerability."
    )
    vulnerable_version_range: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The range of the package versions affected by the vulnerability.",
    )
    patched_versions: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="The package version(s) that resolve the vulnerability.",
    )
    vulnerable_functions: Missing[Union[List[str], None]] = Field(
        default=UNSET, description="The functions in the package that are affected."
    )


class RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackage(GitHubModel):
    """RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ] = Field(description="The package's language or package management ecosystem.")
    name: Missing[Union[str, None]] = Field(
        default=UNSET, description="The unique package name within its ecosystem."
    )


class RepositoryAdvisoryUpdatePropCreditsItems(GitHubModel):
    """RepositoryAdvisoryUpdatePropCreditsItems"""

    login: str = Field(description="The username of the user credited.")
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ] = Field(description="The type of credit the user is receiving.")


class Stargazer(GitHubModel):
    """Stargazer

    Stargazer
    """

    starred_at: datetime = Field()
    user: Union[None, SimpleUser] = Field()


class CommitActivity(GitHubModel):
    """Commit Activity

    Commit Activity
    """

    days: List[int] = Field()
    total: int = Field()
    week: int = Field()


class ContributorActivity(GitHubModel):
    """Contributor Activity

    Contributor Activity
    """

    author: Union[None, SimpleUser] = Field()
    total: int = Field()
    weeks: List[ContributorActivityPropWeeksItems] = Field()


class ContributorActivityPropWeeksItems(GitHubModel):
    """ContributorActivityPropWeeksItems"""

    w: Missing[int] = Field(default=UNSET)
    a: Missing[int] = Field(default=UNSET)
    d: Missing[int] = Field(default=UNSET)
    c: Missing[int] = Field(default=UNSET)


class ParticipationStats(GitHubModel):
    """Participation Stats"""

    all_: List[int] = Field(alias="all")
    owner: List[int] = Field()


class RepositorySubscription(GitHubModel):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    subscribed: bool = Field(
        description="Determines if notifications should be received from this repository."
    )
    ignored: bool = Field(
        description="Determines if all notifications should be blocked from this repository."
    )
    reason: Union[str, None] = Field()
    created_at: datetime = Field()
    url: str = Field()
    repository_url: str = Field()


class Tag(GitHubModel):
    """Tag

    Tag
    """

    name: str = Field()
    commit: TagPropCommit = Field()
    zipball_url: str = Field()
    tarball_url: str = Field()
    node_id: str = Field()


class TagPropCommit(GitHubModel):
    """TagPropCommit"""

    sha: str = Field()
    url: str = Field()


class TagProtection(GitHubModel):
    """Tag protection

    Tag protection
    """

    id: Missing[int] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    enabled: Missing[bool] = Field(default=UNSET)
    pattern: str = Field()


class Topic(GitHubModel):
    """Topic

    A topic aggregates entities that are related to a subject.
    """

    names: List[str] = Field()


class Traffic(GitHubModel):
    """Traffic"""

    timestamp: datetime = Field()
    uniques: int = Field()
    count: int = Field()


class CloneTraffic(GitHubModel):
    """Clone Traffic

    Clone Traffic
    """

    count: int = Field()
    uniques: int = Field()
    clones: List[Traffic] = Field()


class ContentTraffic(GitHubModel):
    """Content Traffic

    Content Traffic
    """

    path: str = Field()
    title: str = Field()
    count: int = Field()
    uniques: int = Field()


class ReferrerTraffic(GitHubModel):
    """Referrer Traffic

    Referrer Traffic
    """

    referrer: str = Field()
    count: int = Field()
    uniques: int = Field()


class ViewTraffic(GitHubModel):
    """View Traffic

    View Traffic
    """

    count: int = Field()
    uniques: int = Field()
    views: List[Traffic] = Field()


class SearchResultTextMatchesItems(GitHubModel):
    """SearchResultTextMatchesItems"""

    object_url: Missing[str] = Field(default=UNSET)
    object_type: Missing[Union[str, None]] = Field(default=UNSET)
    property_: Missing[str] = Field(default=UNSET, alias="property")
    fragment: Missing[str] = Field(default=UNSET)
    matches: Missing[List[SearchResultTextMatchesItemsPropMatchesItems]] = Field(
        default=UNSET
    )


class SearchResultTextMatchesItemsPropMatchesItems(GitHubModel):
    """SearchResultTextMatchesItemsPropMatchesItems"""

    text: Missing[str] = Field(default=UNSET)
    indices: Missing[List[int]] = Field(default=UNSET)


class CodeSearchResultItem(GitHubModel):
    """Code Search Result Item

    Code Search Result Item
    """

    name: str = Field()
    path: str = Field()
    sha: str = Field()
    url: str = Field()
    git_url: str = Field()
    html_url: str = Field()
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )
    score: float = Field()
    file_size: Missing[int] = Field(default=UNSET)
    language: Missing[Union[str, None]] = Field(default=UNSET)
    last_modified_at: Missing[datetime] = Field(default=UNSET)
    line_numbers: Missing[List[str]] = Field(default=UNSET)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        default=UNSET, title="Search Result Text Matches"
    )


class CommitSearchResultItem(GitHubModel):
    """Commit Search Result Item

    Commit Search Result Item
    """

    url: str = Field()
    sha: str = Field()
    html_url: str = Field()
    comments_url: str = Field()
    commit: CommitSearchResultItemPropCommit = Field()
    author: Union[None, SimpleUser] = Field()
    committer: Union[None, GitUser] = Field()
    parents: List[CommitSearchResultItemPropParentsItems] = Field()
    repository: MinimalRepository = Field(
        title="Minimal Repository", description="Minimal Repository"
    )
    score: float = Field()
    node_id: str = Field()
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        default=UNSET, title="Search Result Text Matches"
    )


class CommitSearchResultItemPropCommit(GitHubModel):
    """CommitSearchResultItemPropCommit"""

    author: CommitSearchResultItemPropCommitPropAuthor = Field()
    committer: Union[None, GitUser] = Field()
    comment_count: int = Field()
    message: str = Field()
    tree: CommitSearchResultItemPropCommitPropTree = Field()
    url: str = Field()
    verification: Missing[Verification] = Field(default=UNSET, title="Verification")


class CommitSearchResultItemPropCommitPropAuthor(GitHubModel):
    """CommitSearchResultItemPropCommitPropAuthor"""

    name: str = Field()
    email: str = Field()
    date: datetime = Field()


class CommitSearchResultItemPropCommitPropTree(GitHubModel):
    """CommitSearchResultItemPropCommitPropTree"""

    sha: str = Field()
    url: str = Field()


class CommitSearchResultItemPropParentsItems(GitHubModel):
    """CommitSearchResultItemPropParentsItems"""

    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    sha: Missing[str] = Field(default=UNSET)


class IssueSearchResultItem(GitHubModel):
    """Issue Search Result Item

    Issue Search Result Item
    """

    url: str = Field()
    repository_url: str = Field()
    labels_url: str = Field()
    comments_url: str = Field()
    events_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    number: int = Field()
    title: str = Field()
    locked: bool = Field()
    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    assignees: Missing[Union[List[SimpleUser], None]] = Field(default=UNSET)
    user: Union[None, SimpleUser] = Field()
    labels: List[IssueSearchResultItemPropLabelsItems] = Field()
    state: str = Field()
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)
    assignee: Union[None, SimpleUser] = Field()
    milestone: Union[None, Milestone] = Field()
    comments: int = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    closed_at: Union[datetime, None] = Field()
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        default=UNSET, title="Search Result Text Matches"
    )
    pull_request: Missing[IssueSearchResultItemPropPullRequest] = Field(default=UNSET)
    body: Missing[str] = Field(default=UNSET)
    score: float = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="author_association",
        description="How the author is associated with the repository.",
    )
    draft: Missing[bool] = Field(default=UNSET)
    repository: Missing[Repository] = Field(
        default=UNSET, title="Repository", description="A repository on GitHub."
    )
    body_html: Missing[str] = Field(default=UNSET)
    body_text: Missing[str] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    performed_via_github_app: Missing[Union[None, Integration]] = Field(default=UNSET)
    reactions: Missing[ReactionRollup] = Field(default=UNSET, title="Reaction Rollup")


class IssueSearchResultItemPropLabelsItems(GitHubModel):
    """IssueSearchResultItemPropLabelsItems"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    color: Missing[str] = Field(default=UNSET)
    default: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)


class IssueSearchResultItemPropPullRequest(GitHubModel):
    """IssueSearchResultItemPropPullRequest"""

    merged_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    diff_url: Union[str, None] = Field()
    html_url: Union[str, None] = Field()
    patch_url: Union[str, None] = Field()
    url: Union[str, None] = Field()


class LabelSearchResultItem(GitHubModel):
    """Label Search Result Item

    Label Search Result Item
    """

    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    name: str = Field()
    color: str = Field()
    default: bool = Field()
    description: Union[str, None] = Field()
    score: float = Field()
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        default=UNSET, title="Search Result Text Matches"
    )


class RepoSearchResultItem(GitHubModel):
    """Repo Search Result Item

    Repo Search Result Item
    """

    id: int = Field()
    node_id: str = Field()
    name: str = Field()
    full_name: str = Field()
    owner: Union[None, SimpleUser] = Field()
    private: bool = Field()
    html_url: str = Field()
    description: Union[str, None] = Field()
    fork: bool = Field()
    url: str = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    pushed_at: datetime = Field()
    homepage: Union[str, None] = Field()
    size: int = Field()
    stargazers_count: int = Field()
    watchers_count: int = Field()
    language: Union[str, None] = Field()
    forks_count: int = Field()
    open_issues_count: int = Field()
    master_branch: Missing[str] = Field(default=UNSET)
    default_branch: str = Field()
    score: float = Field()
    forks_url: str = Field()
    keys_url: str = Field()
    collaborators_url: str = Field()
    teams_url: str = Field()
    hooks_url: str = Field()
    issue_events_url: str = Field()
    events_url: str = Field()
    assignees_url: str = Field()
    branches_url: str = Field()
    tags_url: str = Field()
    blobs_url: str = Field()
    git_tags_url: str = Field()
    git_refs_url: str = Field()
    trees_url: str = Field()
    statuses_url: str = Field()
    languages_url: str = Field()
    stargazers_url: str = Field()
    contributors_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    commits_url: str = Field()
    git_commits_url: str = Field()
    comments_url: str = Field()
    issue_comment_url: str = Field()
    contents_url: str = Field()
    compare_url: str = Field()
    merges_url: str = Field()
    archive_url: str = Field()
    downloads_url: str = Field()
    issues_url: str = Field()
    pulls_url: str = Field()
    milestones_url: str = Field()
    notifications_url: str = Field()
    labels_url: str = Field()
    releases_url: str = Field()
    deployments_url: str = Field()
    git_url: str = Field()
    ssh_url: str = Field()
    clone_url: str = Field()
    svn_url: str = Field()
    forks: int = Field()
    open_issues: int = Field()
    watchers: int = Field()
    topics: Missing[List[str]] = Field(default=UNSET)
    mirror_url: Union[str, None] = Field()
    has_issues: bool = Field()
    has_projects: bool = Field()
    has_pages: bool = Field()
    has_wiki: bool = Field()
    has_downloads: bool = Field()
    has_discussions: Missing[bool] = Field(default=UNSET)
    archived: bool = Field()
    disabled: bool = Field(
        description="Returns whether or not this repository disabled."
    )
    visibility: Missing[str] = Field(
        default=UNSET,
        description="The repository visibility: public, private, or internal.",
    )
    license_: Union[None, LicenseSimple] = Field(alias="license")
    permissions: Missing[RepoSearchResultItemPropPermissions] = Field(default=UNSET)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        default=UNSET, title="Search Result Text Matches"
    )
    temp_clone_token: Missing[Union[str, None]] = Field(default=UNSET)
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    allow_auto_merge: Missing[bool] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    allow_forking: Missing[bool] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    web_commit_signoff_required: Missing[bool] = Field(default=UNSET)


class RepoSearchResultItemPropPermissions(GitHubModel):
    """RepoSearchResultItemPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()


class TopicSearchResultItem(GitHubModel):
    """Topic Search Result Item

    Topic Search Result Item
    """

    name: str = Field()
    display_name: Union[str, None] = Field()
    short_description: Union[str, None] = Field()
    description: Union[str, None] = Field()
    created_by: Union[str, None] = Field()
    released: Union[str, None] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    featured: bool = Field()
    curated: bool = Field()
    score: float = Field()
    repository_count: Missing[Union[int, None]] = Field(default=UNSET)
    logo_url: Missing[Union[str, None]] = Field(default=UNSET)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        default=UNSET, title="Search Result Text Matches"
    )
    related: Missing[Union[List[TopicSearchResultItemPropRelatedItems], None]] = Field(
        default=UNSET
    )
    aliases: Missing[Union[List[TopicSearchResultItemPropAliasesItems], None]] = Field(
        default=UNSET
    )


class TopicSearchResultItemPropRelatedItems(GitHubModel):
    """TopicSearchResultItemPropRelatedItems"""

    topic_relation: Missing[
        TopicSearchResultItemPropRelatedItemsPropTopicRelation
    ] = Field(default=UNSET)


class TopicSearchResultItemPropRelatedItemsPropTopicRelation(GitHubModel):
    """TopicSearchResultItemPropRelatedItemsPropTopicRelation"""

    id: Missing[int] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    topic_id: Missing[int] = Field(default=UNSET)
    relation_type: Missing[str] = Field(default=UNSET)


class TopicSearchResultItemPropAliasesItems(GitHubModel):
    """TopicSearchResultItemPropAliasesItems"""

    topic_relation: Missing[
        TopicSearchResultItemPropAliasesItemsPropTopicRelation
    ] = Field(default=UNSET)


class TopicSearchResultItemPropAliasesItemsPropTopicRelation(GitHubModel):
    """TopicSearchResultItemPropAliasesItemsPropTopicRelation"""

    id: Missing[int] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    topic_id: Missing[int] = Field(default=UNSET)
    relation_type: Missing[str] = Field(default=UNSET)


class UserSearchResultItem(GitHubModel):
    """User Search Result Item

    User Search Result Item
    """

    login: str = Field()
    id: int = Field()
    node_id: str = Field()
    avatar_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    url: str = Field()
    html_url: str = Field()
    followers_url: str = Field()
    subscriptions_url: str = Field()
    organizations_url: str = Field()
    repos_url: str = Field()
    received_events_url: str = Field()
    type: str = Field()
    score: float = Field()
    following_url: str = Field()
    gists_url: str = Field()
    starred_url: str = Field()
    events_url: str = Field()
    public_repos: Missing[int] = Field(default=UNSET)
    public_gists: Missing[int] = Field(default=UNSET)
    followers: Missing[int] = Field(default=UNSET)
    following: Missing[int] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(default=UNSET)
    updated_at: Missing[datetime] = Field(default=UNSET)
    name: Missing[Union[str, None]] = Field(default=UNSET)
    bio: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    location: Missing[Union[str, None]] = Field(default=UNSET)
    site_admin: bool = Field()
    hireable: Missing[Union[bool, None]] = Field(default=UNSET)
    text_matches: Missing[List[SearchResultTextMatchesItems]] = Field(
        default=UNSET, title="Search Result Text Matches"
    )
    blog: Missing[Union[str, None]] = Field(default=UNSET)
    company: Missing[Union[str, None]] = Field(default=UNSET)
    suspended_at: Missing[Union[datetime, None]] = Field(default=UNSET)


class PrivateUser(GitHubModel):
    """Private User

    Private User
    """

    login: str = Field()
    id: int = Field()
    node_id: str = Field()
    avatar_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    url: str = Field()
    html_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    starred_url: str = Field()
    subscriptions_url: str = Field()
    organizations_url: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    received_events_url: str = Field()
    type: str = Field()
    site_admin: bool = Field()
    name: Union[str, None] = Field()
    company: Union[str, None] = Field()
    blog: Union[str, None] = Field()
    location: Union[str, None] = Field()
    email: Union[str, None] = Field()
    hireable: Union[bool, None] = Field()
    bio: Union[str, None] = Field()
    twitter_username: Missing[Union[str, None]] = Field(default=UNSET)
    public_repos: int = Field()
    public_gists: int = Field()
    followers: int = Field()
    following: int = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    private_gists: int = Field()
    total_private_repos: int = Field()
    owned_private_repos: int = Field()
    disk_usage: int = Field()
    collaborators: int = Field()
    two_factor_authentication: bool = Field()
    plan: Missing[PrivateUserPropPlan] = Field(default=UNSET)
    suspended_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    business_plus: Missing[bool] = Field(default=UNSET)
    ldap_dn: Missing[str] = Field(default=UNSET)


class PrivateUserPropPlan(GitHubModel):
    """PrivateUserPropPlan"""

    collaborators: int = Field()
    name: str = Field()
    space: int = Field()
    private_repos: int = Field()


class CodespacesSecret(GitHubModel):
    """Codespaces Secret

    Secrets for a GitHub Codespace.
    """

    name: str = Field(description="The name of the secret")
    created_at: datetime = Field(
        description="The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )
    updated_at: datetime = Field(
        description="The date and time at which the secret was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ."
    )
    visibility: Literal["all", "private", "selected"] = Field(
        description="The type of repositories in the organization that the secret is visible to"
    )
    selected_repositories_url: str = Field(
        description="The API URL at which the list of repositories this secret is visible to can be retrieved"
    )


class CodespacesUserPublicKey(GitHubModel):
    """CodespacesUserPublicKey

    The public key used for setting user Codespaces' Secrets.
    """

    key_id: str = Field(description="The identifier for the key.")
    key: str = Field(description="The Base64 encoded public key.")


class CodespaceExportDetails(GitHubModel):
    """Fetches information about an export of a codespace.

    An export of a codespace. Also, latest export details for a codespace can be
    fetched with id = latest
    """

    state: Missing[Union[str, None]] = Field(
        default=UNSET, description="State of the latest export"
    )
    completed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET, description="Completion time of the last export operation"
    )
    branch: Missing[Union[str, None]] = Field(
        default=UNSET, description="Name of the exported branch"
    )
    sha: Missing[Union[str, None]] = Field(
        default=UNSET, description="Git commit SHA of the exported branch"
    )
    id: Missing[str] = Field(default=UNSET, description="Id for the export details")
    export_url: Missing[str] = Field(
        default=UNSET, description="Url for fetching export details"
    )
    html_url: Missing[Union[str, None]] = Field(
        default=UNSET, description="Web url for the exported branch"
    )


class CodespaceWithFullRepository(GitHubModel):
    """Codespace

    A codespace.
    """

    id: int = Field()
    name: str = Field(description="Automatically generated name of this codespace.")
    display_name: Missing[Union[str, None]] = Field(
        default=UNSET, description="Display name for this codespace."
    )
    environment_id: Union[str, None] = Field(
        description="UUID identifying this codespace's environment."
    )
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    billable_owner: SimpleUser = Field(
        title="Simple User", description="A GitHub user."
    )
    repository: FullRepository = Field(
        title="Full Repository", description="Full Repository"
    )
    machine: Union[None, CodespaceMachine] = Field()
    devcontainer_path: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="Path to devcontainer.json from repo root used to create Codespace.",
    )
    prebuild: Union[bool, None] = Field(
        description="Whether the codespace was created from a prebuild."
    )
    created_at: datetime = Field()
    updated_at: datetime = Field()
    last_used_at: datetime = Field(
        description="Last known time this codespace was started."
    )
    state: Literal[
        "Unknown",
        "Created",
        "Queued",
        "Provisioning",
        "Available",
        "Awaiting",
        "Unavailable",
        "Deleted",
        "Moved",
        "Shutdown",
        "Archived",
        "Starting",
        "ShuttingDown",
        "Failed",
        "Exporting",
        "Updating",
        "Rebuilding",
    ] = Field(description="State of this codespace.")
    url: str = Field(description="API URL for this codespace.")
    git_status: CodespaceWithFullRepositoryPropGitStatus = Field(
        description="Details about the codespace's git repository."
    )
    location: Literal["EastUs", "SouthEastAsia", "WestEurope", "WestUs2"] = Field(
        description="The initally assigned location of a new codespace."
    )
    idle_timeout_minutes: Union[int, None] = Field(
        description="The number of minutes of inactivity after which this codespace will be automatically stopped."
    )
    web_url: str = Field(description="URL to access this codespace on the web.")
    machines_url: str = Field(
        description="API URL to access available alternate machine types for this codespace."
    )
    start_url: str = Field(description="API URL to start this codespace.")
    stop_url: str = Field(description="API URL to stop this codespace.")
    publish_url: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="API URL to publish this codespace to a new repository.",
    )
    pulls_url: Union[str, None] = Field(
        description="API URL for the Pull Request associated with this codespace, if any."
    )
    recent_folders: List[str] = Field()
    runtime_constraints: Missing[
        CodespaceWithFullRepositoryPropRuntimeConstraints
    ] = Field(default=UNSET)
    pending_operation: Missing[Union[bool, None]] = Field(
        default=UNSET,
        description="Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.",
    )
    pending_operation_disabled_reason: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="Text to show user when codespace is disabled by a pending operation",
    )
    idle_timeout_notice: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="Text to show user when codespace idle timeout minutes has been overriden by an organization policy",
    )
    retention_period_minutes: Missing[Union[int, None]] = Field(
        default=UNSET,
        description="Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).",
    )
    retention_expires_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description='When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"',
    )


class CodespaceWithFullRepositoryPropGitStatus(GitHubModel):
    """CodespaceWithFullRepositoryPropGitStatus

    Details about the codespace's git repository.
    """

    ahead: Missing[int] = Field(
        default=UNSET,
        description="The number of commits the local repository is ahead of the remote.",
    )
    behind: Missing[int] = Field(
        default=UNSET,
        description="The number of commits the local repository is behind the remote.",
    )
    has_unpushed_changes: Missing[bool] = Field(
        default=UNSET, description="Whether the local repository has unpushed changes."
    )
    has_uncommitted_changes: Missing[bool] = Field(
        default=UNSET,
        description="Whether the local repository has uncommitted changes.",
    )
    ref: Missing[str] = Field(
        default=UNSET,
        description="The current branch (or SHA if in detached HEAD state) of the local repository.",
    )


class CodespaceWithFullRepositoryPropRuntimeConstraints(GitHubModel):
    """CodespaceWithFullRepositoryPropRuntimeConstraints"""

    allowed_port_privacy_settings: Missing[Union[List[str], None]] = Field(
        default=UNSET,
        description="The privacy settings a user can select from when forwarding a port.",
    )


class Email(GitHubModel):
    """Email

    Email
    """

    email: str = Field()
    primary: bool = Field()
    verified: bool = Field()
    visibility: Union[str, None] = Field()


class GpgKey(GitHubModel):
    """GPG Key

    A unique encryption key
    """

    id: int = Field()
    name: Missing[Union[str, None]] = Field(default=UNSET)
    primary_key_id: Union[int, None] = Field()
    key_id: str = Field()
    public_key: str = Field()
    emails: List[GpgKeyPropEmailsItems] = Field()
    subkeys: List[GpgKeyPropSubkeysItems] = Field()
    can_sign: bool = Field()
    can_encrypt_comms: bool = Field()
    can_encrypt_storage: bool = Field()
    can_certify: bool = Field()
    created_at: datetime = Field()
    expires_at: Union[datetime, None] = Field()
    revoked: bool = Field()
    raw_key: Union[str, None] = Field()


class GpgKeyPropEmailsItems(GitHubModel):
    """GpgKeyPropEmailsItems"""

    email: Missing[str] = Field(default=UNSET)
    verified: Missing[bool] = Field(default=UNSET)


class GpgKeyPropSubkeysItems(GitHubModel):
    """GpgKeyPropSubkeysItems"""

    id: Missing[int] = Field(default=UNSET)
    primary_key_id: Missing[int] = Field(default=UNSET)
    key_id: Missing[str] = Field(default=UNSET)
    public_key: Missing[str] = Field(default=UNSET)
    emails: Missing[List[GpgKeyPropSubkeysItemsPropEmailsItems]] = Field(default=UNSET)
    subkeys: Missing[List[Any]] = Field(default=UNSET)
    can_sign: Missing[bool] = Field(default=UNSET)
    can_encrypt_comms: Missing[bool] = Field(default=UNSET)
    can_encrypt_storage: Missing[bool] = Field(default=UNSET)
    can_certify: Missing[bool] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    expires_at: Missing[Union[str, None]] = Field(default=UNSET)
    raw_key: Missing[Union[str, None]] = Field(default=UNSET)
    revoked: Missing[bool] = Field(default=UNSET)


class GpgKeyPropSubkeysItemsPropEmailsItems(GitHubModel):
    """GpgKeyPropSubkeysItemsPropEmailsItems"""

    email: Missing[str] = Field(default=UNSET)
    verified: Missing[bool] = Field(default=UNSET)


class Key(GitHubModel):
    """Key

    Key
    """

    key: str = Field()
    id: int = Field()
    url: str = Field()
    title: str = Field()
    created_at: datetime = Field()
    verified: bool = Field()
    read_only: bool = Field()


class MarketplaceAccount(GitHubModel):
    """Marketplace Account"""

    url: str = Field()
    id: int = Field()
    type: str = Field()
    node_id: Missing[str] = Field(default=UNSET)
    login: str = Field()
    email: Missing[Union[str, None]] = Field(default=UNSET)
    organization_billing_email: Missing[Union[str, None]] = Field(default=UNSET)


class UserMarketplacePurchase(GitHubModel):
    """User Marketplace Purchase

    User Marketplace Purchase
    """

    billing_cycle: str = Field()
    next_billing_date: Union[datetime, None] = Field()
    unit_count: Union[int, None] = Field()
    on_free_trial: bool = Field()
    free_trial_ends_on: Union[datetime, None] = Field()
    updated_at: Union[datetime, None] = Field()
    account: MarketplaceAccount = Field(title="Marketplace Account")
    plan: MarketplaceListingPlan = Field(
        title="Marketplace Listing Plan", description="Marketplace Listing Plan"
    )


class SocialAccount(GitHubModel):
    """Social account

    Social media account
    """

    provider: str = Field()
    url: str = Field()


class SshSigningKey(GitHubModel):
    """SSH Signing Key

    A public SSH key used to sign Git commits
    """

    key: str = Field()
    id: int = Field()
    title: str = Field()
    created_at: datetime = Field()


class StarredRepository(GitHubModel):
    """Starred Repository

    Starred Repository
    """

    starred_at: datetime = Field()
    repo: Repository = Field(title="Repository", description="A repository on GitHub.")


class Hovercard(GitHubModel):
    """Hovercard

    Hovercard
    """

    contexts: List[HovercardPropContextsItems] = Field()


class HovercardPropContextsItems(GitHubModel):
    """HovercardPropContextsItems"""

    message: str = Field()
    octicon: str = Field()


class KeySimple(GitHubModel):
    """Key Simple

    Key Simple
    """

    id: int = Field()
    key: str = Field()


class EnterpriseWebhooks(GitHubModel):
    """Enterprise

    An enterprise on GitHub. Webhook payloads contain the `enterprise` property when
    the webhook is configured
    on an enterprise account or an organization that's part of an enterprise
    account. For more information,
    see "[About enterprise accounts](https://docs.github.com/admin/overview/about-
    enterprise-accounts)."
    """

    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="A short description of the enterprise."
    )
    html_url: str = Field()
    website_url: Missing[Union[str, None]] = Field(
        default=UNSET, description="The enterprise's website URL."
    )
    id: int = Field(description="Unique identifier of the enterprise")
    node_id: str = Field()
    name: str = Field(description="The name of the enterprise.")
    slug: str = Field(description="The slug url identifier for the enterprise.")
    created_at: Union[datetime, None] = Field()
    updated_at: Union[datetime, None] = Field()
    avatar_url: str = Field()


class SimpleInstallation(GitHubModel):
    """Simple Installation

    The GitHub App installation. Webhook payloads contain the `installation`
    property when the event is configured
    for and sent to a GitHub App. For more information,
    see "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-
    github-apps/registering-a-github-app/using-webhooks-with-github-apps)."
    """

    id: int = Field(description="The ID of the installation.")
    node_id: str = Field(description="The global node ID of the installation.")


class OrganizationSimpleWebhooks(GitHubModel):
    """Organization Simple

    A GitHub organization. Webhook payloads contain the `organization` property when
    the webhook is configured for an
    organization, or when the event occurs from activity in a repository owned by an
    organization.
    """

    login: str = Field()
    id: int = Field()
    node_id: str = Field()
    url: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    hooks_url: str = Field()
    issues_url: str = Field()
    members_url: str = Field()
    public_members_url: str = Field()
    avatar_url: str = Field()
    description: Union[str, None] = Field()


class RepositoryWebhooks(GitHubModel):
    """Repository

    The repository on GitHub where the event occurred. Webhook payloads contain the
    `repository` property
    when the event occurs from activity in a repository.
    """

    id: int = Field(description="Unique identifier of the repository")
    node_id: str = Field()
    name: str = Field(description="The name of the repository.")
    full_name: str = Field()
    license_: Union[None, LicenseSimple] = Field(alias="license")
    organization: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    forks: int = Field()
    permissions: Missing[RepositoryWebhooksPropPermissions] = Field(default=UNSET)
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    private: bool = Field(
        default=False, description="Whether the repository is private or public."
    )
    html_url: str = Field()
    description: Union[str, None] = Field()
    fork: bool = Field()
    url: str = Field()
    archive_url: str = Field()
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    deployments_url: str = Field()
    downloads_url: str = Field()
    events_url: str = Field()
    forks_url: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    languages_url: str = Field()
    merges_url: str = Field()
    milestones_url: str = Field()
    notifications_url: str = Field()
    pulls_url: str = Field()
    releases_url: str = Field()
    ssh_url: str = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    trees_url: str = Field()
    clone_url: str = Field()
    mirror_url: Union[str, None] = Field()
    hooks_url: str = Field()
    svn_url: str = Field()
    homepage: Union[str, None] = Field()
    language: Union[str, None] = Field()
    forks_count: int = Field()
    stargazers_count: int = Field()
    watchers_count: int = Field()
    size: int = Field(
        description="The size of the repository, in kilobytes. Size is calculated hourly. When a repository is initially created, the size is 0."
    )
    default_branch: str = Field(description="The default branch of the repository.")
    open_issues_count: int = Field()
    is_template: Missing[bool] = Field(
        default=UNSET,
        description="Whether this repository acts as a template that can be used to generate new repositories.",
    )
    topics: Missing[List[str]] = Field(default=UNSET)
    custom_properties: Missing[RepositoryWebhooksPropCustomProperties] = Field(
        default=UNSET,
        description="The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.",
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_pages: bool = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_discussions: Missing[bool] = Field(
        default=UNSET, description="Whether discussions are enabled."
    )
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    disabled: bool = Field(
        description="Returns whether or not this repository disabled."
    )
    visibility: Missing[str] = Field(
        default=UNSET,
        description="The repository visibility: public, private, or internal.",
    )
    pushed_at: Union[datetime, None] = Field()
    created_at: Union[datetime, None] = Field()
    updated_at: Union[datetime, None] = Field()
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    template_repository: Missing[
        Union[RepositoryWebhooksPropTemplateRepository, None]
    ] = Field(default=UNSET)
    temp_clone_token: Missing[str] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_auto_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to allow Auto-merge to be used on pull requests.",
    )
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    allow_update_branch: Missing[bool] = Field(
        default=UNSET,
        description="Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.",
    )
    use_squash_pr_title_as_default: Missing[bool] = Field(
        default=UNSET,
        description="Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.",
    )
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow forking this repo"
    )
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)
    open_issues: int = Field()
    watchers: int = Field()
    master_branch: Missing[str] = Field(default=UNSET)
    starred_at: Missing[str] = Field(default=UNSET)
    anonymous_access_enabled: Missing[bool] = Field(
        default=UNSET,
        description="Whether anonymous git access is enabled for this repository",
    )


class RepositoryWebhooksPropPermissions(GitHubModel):
    """RepositoryWebhooksPropPermissions"""

    admin: bool = Field()
    pull: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)
    push: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)


class RepositoryWebhooksPropCustomProperties(ExtraGitHubModel):
    """RepositoryWebhooksPropCustomProperties

    The custom properties that were defined for the repository. The keys are the
    custom property names, and the values are the corresponding custom property
    values.
    """


class RepositoryWebhooksPropTemplateRepositoryPropOwner(GitHubModel):
    """RepositoryWebhooksPropTemplateRepositoryPropOwner"""

    login: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    avatar_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)


class RepositoryWebhooksPropTemplateRepositoryPropPermissions(GitHubModel):
    """RepositoryWebhooksPropTemplateRepositoryPropPermissions"""

    admin: Missing[bool] = Field(default=UNSET)
    maintain: Missing[bool] = Field(default=UNSET)
    push: Missing[bool] = Field(default=UNSET)
    triage: Missing[bool] = Field(default=UNSET)
    pull: Missing[bool] = Field(default=UNSET)


class RepositoryWebhooksPropTemplateRepository(GitHubModel):
    """RepositoryWebhooksPropTemplateRepository"""

    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    owner: Missing[RepositoryWebhooksPropTemplateRepositoryPropOwner] = Field(
        default=UNSET
    )
    private: Missing[bool] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    description: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    git_url: Missing[str] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    ssh_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    clone_url: Missing[str] = Field(default=UNSET)
    mirror_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    svn_url: Missing[str] = Field(default=UNSET)
    homepage: Missing[str] = Field(default=UNSET)
    language: Missing[str] = Field(default=UNSET)
    forks_count: Missing[int] = Field(default=UNSET)
    stargazers_count: Missing[int] = Field(default=UNSET)
    watchers_count: Missing[int] = Field(default=UNSET)
    size: Missing[int] = Field(default=UNSET)
    default_branch: Missing[str] = Field(default=UNSET)
    open_issues_count: Missing[int] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    topics: Missing[List[str]] = Field(default=UNSET)
    has_issues: Missing[bool] = Field(default=UNSET)
    has_projects: Missing[bool] = Field(default=UNSET)
    has_wiki: Missing[bool] = Field(default=UNSET)
    has_pages: Missing[bool] = Field(default=UNSET)
    has_downloads: Missing[bool] = Field(default=UNSET)
    archived: Missing[bool] = Field(default=UNSET)
    disabled: Missing[bool] = Field(default=UNSET)
    visibility: Missing[str] = Field(default=UNSET)
    pushed_at: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    permissions: Missing[
        RepositoryWebhooksPropTemplateRepositoryPropPermissions
    ] = Field(default=UNSET)
    allow_rebase_merge: Missing[bool] = Field(default=UNSET)
    temp_clone_token: Missing[str] = Field(default=UNSET)
    allow_squash_merge: Missing[bool] = Field(default=UNSET)
    allow_auto_merge: Missing[bool] = Field(default=UNSET)
    delete_branch_on_merge: Missing[bool] = Field(default=UNSET)
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    use_squash_pr_title_as_default: Missing[bool] = Field(default=UNSET)
    squash_merge_commit_title: Missing[
        Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
    )
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    allow_merge_commit: Missing[bool] = Field(default=UNSET)
    subscribers_count: Missing[int] = Field(default=UNSET)
    network_count: Missing[int] = Field(default=UNSET)


class SimpleUserWebhooks(GitHubModel):
    """Simple User

    The GitHub user that triggered the event. This property is included in every
    webhook payload.
    """

    name: Missing[Union[str, None]] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    login: str = Field()
    id: int = Field()
    node_id: str = Field()
    avatar_url: str = Field()
    gravatar_id: Union[str, None] = Field()
    url: str = Field()
    html_url: str = Field()
    followers_url: str = Field()
    following_url: str = Field()
    gists_url: str = Field()
    starred_url: str = Field()
    subscriptions_url: str = Field()
    organizations_url: str = Field()
    repos_url: str = Field()
    events_url: str = Field()
    received_events_url: str = Field()
    type: str = Field()
    site_admin: bool = Field()
    starred_at: Missing[str] = Field(default=UNSET)


class SimpleCheckSuite(GitHubModel):
    """SimpleCheckSuite

    A suite of checks performed on the code of a given code change
    """

    after: Missing[Union[str, None]] = Field(default=UNSET)
    app: Missing[Integration] = Field(
        default=UNSET,
        title="GitHub app",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    before: Missing[Union[str, None]] = Field(default=UNSET)
    conclusion: Missing[
        Union[
            None,
            Literal[
                "success",
                "failure",
                "neutral",
                "cancelled",
                "skipped",
                "timed_out",
                "action_required",
                "stale",
                "startup_failure",
            ],
        ]
    ] = Field(default=UNSET)
    created_at: Missing[datetime] = Field(default=UNSET)
    head_branch: Missing[Union[str, None]] = Field(default=UNSET)
    head_sha: Missing[str] = Field(
        default=UNSET, description="The SHA of the head commit that is being checked."
    )
    id: Missing[int] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    pull_requests: Missing[List[PullRequestMinimal]] = Field(default=UNSET)
    repository: Missing[MinimalRepository] = Field(
        default=UNSET, title="Minimal Repository", description="Minimal Repository"
    )
    status: Missing[
        Literal["queued", "in_progress", "completed", "pending", "waiting"]
    ] = Field(default=UNSET)
    updated_at: Missing[datetime] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class CheckRunWithSimpleCheckSuite(GitHubModel):
    """CheckRun

    A check performed on the code of a given code change
    """

    app: Union[None, Integration] = Field()
    check_suite: SimpleCheckSuite = Field(
        description="A suite of checks performed on the code of a given code change"
    )
    completed_at: Union[datetime, None] = Field()
    conclusion: Union[
        None,
        Literal[
            "waiting",
            "pending",
            "startup_failure",
            "stale",
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ] = Field()
    deployment: Missing[DeploymentSimple] = Field(
        default=UNSET,
        title="Deployment",
        description="A deployment created as the result of an Actions check run from a workflow that references an environment",
    )
    details_url: str = Field()
    external_id: str = Field()
    head_sha: str = Field(description="The SHA of the commit that is being checked.")
    html_url: str = Field()
    id: int = Field(description="The id of the check.")
    name: str = Field(description="The name of the check.")
    node_id: str = Field()
    output: CheckRunWithSimpleCheckSuitePropOutput = Field()
    pull_requests: List[PullRequestMinimal] = Field()
    started_at: datetime = Field()
    status: Literal["queued", "in_progress", "completed", "pending"] = Field(
        description="The phase of the lifecycle that the check is currently in."
    )
    url: str = Field()


class CheckRunWithSimpleCheckSuitePropOutput(GitHubModel):
    """CheckRunWithSimpleCheckSuitePropOutput"""

    annotations_count: int = Field()
    annotations_url: str = Field()
    summary: Union[str, None] = Field()
    text: Union[str, None] = Field()
    title: Union[str, None] = Field()


class Discussion(GitHubModel):
    """Discussion

    A Discussion in a repository.
    """

    active_lock_reason: Union[str, None] = Field()
    answer_chosen_at: Union[str, None] = Field()
    answer_chosen_by: Union[DiscussionPropAnswerChosenBy, None] = Field(title="User")
    answer_html_url: Union[str, None] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field()
    category: DiscussionPropCategory = Field()
    comments: int = Field()
    created_at: datetime = Field()
    html_url: str = Field()
    id: int = Field()
    locked: bool = Field()
    node_id: str = Field()
    number: int = Field()
    reactions: Missing[DiscussionPropReactions] = Field(
        default=UNSET, title="Reactions"
    )
    repository_url: str = Field()
    state: Literal["open", "closed", "locked", "converting", "transferring"] = Field(
        description="The current state of the discussion.\n`converting` means that the discussion is being converted from an issue.\n`transferring` means that the discussion is being transferred from another repository."
    )
    state_reason: Union[
        None, Literal["resolved", "outdated", "duplicate", "reopened"]
    ] = Field(description="The reason for the current state")
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field()
    updated_at: datetime = Field()
    user: Union[DiscussionPropUser, None] = Field(title="User")


class DiscussionPropAnswerChosenBy(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class DiscussionPropCategory(GitHubModel):
    """DiscussionPropCategory"""

    created_at: datetime = Field()
    description: str = Field()
    emoji: str = Field()
    id: int = Field()
    is_answerable: bool = Field()
    name: str = Field()
    node_id: Missing[str] = Field(default=UNSET)
    repository_id: int = Field()
    slug: str = Field()
    updated_at: str = Field()


class DiscussionPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class DiscussionPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class MergeGroup(GitHubModel):
    """Merge Group

    A group of pull requests that the merge queue has grouped together to be merged.
    """

    head_sha: str = Field(description="The SHA of the merge group.")
    head_ref: str = Field(description="The full ref of the merge group.")
    base_sha: str = Field(description="The SHA of the merge group's parent commit.")
    base_ref: str = Field(
        description="The full ref of the branch the merge group will be merged into."
    )
    head_commit: SimpleCommit = Field(title="Simple Commit", description="A commit.")


class PersonalAccessTokenRequest(GitHubModel):
    """Personal Access Token Request

    Details of a Personal Access Token Request.
    """

    id: int = Field(
        description="Unique identifier of the request for access via fine-grained personal access token. Used as the `pat_request_id` parameter in the list and review API calls."
    )
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    permissions_added: PersonalAccessTokenRequestPropPermissionsAdded = Field(
        description="New requested permissions, categorized by type of permission."
    )
    permissions_upgraded: PersonalAccessTokenRequestPropPermissionsUpgraded = Field(
        description="Requested permissions that elevate access for a previously approved request for access, categorized by type of permission."
    )
    permissions_result: PersonalAccessTokenRequestPropPermissionsResult = Field(
        description="Permissions requested, categorized by type of permission. This field incorporates `permissions_added` and `permissions_upgraded`."
    )
    repository_selection: Literal["none", "all", "subset"] = Field(
        description="Type of repository selection requested."
    )
    repository_count: Union[int, None] = Field(
        description="The number of repositories the token is requesting access to. This field is only populated when `repository_selection` is `subset`."
    )
    repositories: Union[
        List[PersonalAccessTokenRequestPropRepositoriesItems], None
    ] = Field(
        description="An array of repository objects the token is requesting access to. This field is only populated when `repository_selection` is `subset`."
    )
    created_at: str = Field(
        description="Date and time when the request for access was created."
    )
    token_expired: bool = Field(
        description="Whether the associated fine-grained personal access token has expired."
    )
    token_expires_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token expires."
    )
    token_last_used_at: Union[str, None] = Field(
        description="Date and time when the associated fine-grained personal access token was last used for authentication."
    )


class PersonalAccessTokenRequestPropPermissionsAdded(GitHubModel):
    """PersonalAccessTokenRequestPropPermissionsAdded

    New requested permissions, categorized by type of permission.
    """

    organization: Missing[
        PersonalAccessTokenRequestPropPermissionsAddedPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        PersonalAccessTokenRequestPropPermissionsAddedPropRepository
    ] = Field(default=UNSET)
    other: Missing[PersonalAccessTokenRequestPropPermissionsAddedPropOther] = Field(
        default=UNSET
    )


class PersonalAccessTokenRequestPropPermissionsAddedPropOrganization(ExtraGitHubModel):
    """PersonalAccessTokenRequestPropPermissionsAddedPropOrganization"""


class PersonalAccessTokenRequestPropPermissionsAddedPropRepository(ExtraGitHubModel):
    """PersonalAccessTokenRequestPropPermissionsAddedPropRepository"""


class PersonalAccessTokenRequestPropPermissionsAddedPropOther(ExtraGitHubModel):
    """PersonalAccessTokenRequestPropPermissionsAddedPropOther"""


class PersonalAccessTokenRequestPropPermissionsUpgraded(GitHubModel):
    """PersonalAccessTokenRequestPropPermissionsUpgraded

    Requested permissions that elevate access for a previously approved request for
    access, categorized by type of permission.
    """

    organization: Missing[
        PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        PersonalAccessTokenRequestPropPermissionsUpgradedPropRepository
    ] = Field(default=UNSET)
    other: Missing[PersonalAccessTokenRequestPropPermissionsUpgradedPropOther] = Field(
        default=UNSET
    )


class PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganization(
    ExtraGitHubModel
):
    """PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganization"""


class PersonalAccessTokenRequestPropPermissionsUpgradedPropRepository(ExtraGitHubModel):
    """PersonalAccessTokenRequestPropPermissionsUpgradedPropRepository"""


class PersonalAccessTokenRequestPropPermissionsUpgradedPropOther(ExtraGitHubModel):
    """PersonalAccessTokenRequestPropPermissionsUpgradedPropOther"""


class PersonalAccessTokenRequestPropPermissionsResult(GitHubModel):
    """PersonalAccessTokenRequestPropPermissionsResult

    Permissions requested, categorized by type of permission. This field
    incorporates `permissions_added` and `permissions_upgraded`.
    """

    organization: Missing[
        PersonalAccessTokenRequestPropPermissionsResultPropOrganization
    ] = Field(default=UNSET)
    repository: Missing[
        PersonalAccessTokenRequestPropPermissionsResultPropRepository
    ] = Field(default=UNSET)
    other: Missing[PersonalAccessTokenRequestPropPermissionsResultPropOther] = Field(
        default=UNSET
    )


class PersonalAccessTokenRequestPropPermissionsResultPropOrganization(ExtraGitHubModel):
    """PersonalAccessTokenRequestPropPermissionsResultPropOrganization"""


class PersonalAccessTokenRequestPropPermissionsResultPropRepository(ExtraGitHubModel):
    """PersonalAccessTokenRequestPropPermissionsResultPropRepository"""


class PersonalAccessTokenRequestPropPermissionsResultPropOther(ExtraGitHubModel):
    """PersonalAccessTokenRequestPropPermissionsResultPropOther"""


class PersonalAccessTokenRequestPropRepositoriesItems(GitHubModel):
    """PersonalAccessTokenRequestPropRepositoriesItems"""

    full_name: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    private: bool = Field(description="Whether the repository is private or public.")


class ProjectsV2(GitHubModel):
    """Projects v2 Project

    A projects v2 project
    """

    id: float = Field()
    node_id: str = Field()
    owner: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    creator: SimpleUser = Field(title="Simple User", description="A GitHub user.")
    title: str = Field()
    description: Union[str, None] = Field()
    public: bool = Field()
    closed_at: Union[datetime, None] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    number: int = Field()
    short_description: Union[str, None] = Field()
    deleted_at: Union[datetime, None] = Field()
    deleted_by: Union[None, SimpleUser] = Field()


class ProjectsV2Item(GitHubModel):
    """Projects v2 Item

    An item belonging to a project
    """

    id: float = Field()
    node_id: Missing[str] = Field(default=UNSET)
    project_node_id: Missing[str] = Field(default=UNSET)
    content_node_id: str = Field()
    content_type: Literal["Issue", "PullRequest", "DraftIssue"] = Field(
        title="Projects v2 Item Content Type",
        description="The type of content tracked in a project item",
    )
    creator: Missing[SimpleUser] = Field(
        default=UNSET, title="Simple User", description="A GitHub user."
    )
    created_at: datetime = Field()
    updated_at: datetime = Field()
    archived_at: Union[datetime, None] = Field()


class SecretScanningAlertWebhook(GitHubModel):
    """SecretScanningAlertWebhook"""

    number: Missing[int] = Field(
        default=UNSET, description="The security alert number."
    )
    created_at: Missing[datetime] = Field(
        default=UNSET,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    updated_at: Missing[Union[None, datetime]] = Field(default=UNSET)
    url: Missing[str] = Field(
        default=UNSET, description="The REST API URL of the alert resource."
    )
    html_url: Missing[str] = Field(
        default=UNSET, description="The GitHub URL of the alert resource."
    )
    locations_url: Missing[str] = Field(
        default=UNSET,
        description="The REST API URL of the code locations for this alert.",
    )
    resolution: Missing[
        Union[
            None,
            Literal[
                "false_positive",
                "wont_fix",
                "revoked",
                "used_in_tests",
                "pattern_deleted",
                "pattern_edited",
            ],
        ]
    ] = Field(default=UNSET, description="The reason for resolving the alert.")
    resolved_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    resolved_by: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    resolution_comment: Missing[Union[str, None]] = Field(
        default=UNSET, description="An optional comment to resolve an alert."
    )
    secret_type: Missing[str] = Field(
        default=UNSET, description="The type of secret that secret scanning detected."
    )
    push_protection_bypassed: Missing[Union[bool, None]] = Field(
        default=UNSET,
        description="Whether push protection was bypassed for the detected secret.",
    )
    push_protection_bypassed_by: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    push_protection_bypassed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )


class WebhookBranchProtectionConfigurationDisabled(GitHubModel):
    """branch protection configuration disabled event"""

    action: Literal["disabled"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookBranchProtectionConfigurationEnabled(GitHubModel):
    """branch protection configuration enabled event"""

    action: Literal["enabled"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookBranchProtectionRuleCreated(GitHubModel):
    """branch protection rule created event"""

    action: Literal["created"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    rule: WebhookBranchProtectionRuleCreatedPropRule = Field(
        title="branch protection rule",
        description="The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookBranchProtectionRuleCreatedPropRule(GitHubModel):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool = Field()
    allow_deletions_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    allow_force_pushes_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    authorized_actor_names: List[str] = Field()
    authorized_actors_only: bool = Field()
    authorized_dismissal_actors_only: bool = Field()
    create_protected: Missing[bool] = Field(default=UNSET)
    created_at: datetime = Field()
    dismiss_stale_reviews_on_push: bool = Field()
    id: int = Field()
    ignore_approvals_from_contributors: bool = Field()
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"] = Field()
    name: str = Field()
    pull_request_reviews_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    repository_id: int = Field()
    require_code_owner_review: bool = Field()
    require_last_push_approval: Missing[bool] = Field(
        default=UNSET,
        description="Whether the most recent push must be approved by someone other than the person who pushed it",
    )
    required_approving_review_count: int = Field()
    required_conversation_resolution_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    required_deployments_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    required_status_checks: List[str] = Field()
    required_status_checks_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    signature_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    strict_required_status_checks_policy: bool = Field()
    updated_at: datetime = Field()


class WebhookBranchProtectionRuleDeleted(GitHubModel):
    """branch protection rule deleted event"""

    action: Literal["deleted"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    rule: WebhookBranchProtectionRuleDeletedPropRule = Field(
        title="branch protection rule",
        description="The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookBranchProtectionRuleDeletedPropRule(GitHubModel):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool = Field()
    allow_deletions_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    allow_force_pushes_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    authorized_actor_names: List[str] = Field()
    authorized_actors_only: bool = Field()
    authorized_dismissal_actors_only: bool = Field()
    create_protected: Missing[bool] = Field(default=UNSET)
    created_at: datetime = Field()
    dismiss_stale_reviews_on_push: bool = Field()
    id: int = Field()
    ignore_approvals_from_contributors: bool = Field()
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"] = Field()
    name: str = Field()
    pull_request_reviews_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    repository_id: int = Field()
    require_code_owner_review: bool = Field()
    require_last_push_approval: Missing[bool] = Field(
        default=UNSET,
        description="Whether the most recent push must be approved by someone other than the person who pushed it",
    )
    required_approving_review_count: int = Field()
    required_conversation_resolution_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    required_deployments_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    required_status_checks: List[str] = Field()
    required_status_checks_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    signature_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    strict_required_status_checks_policy: bool = Field()
    updated_at: datetime = Field()


class WebhookBranchProtectionRuleEdited(GitHubModel):
    """branch protection rule edited event"""

    action: Literal["edited"] = Field()
    changes: Missing[WebhookBranchProtectionRuleEditedPropChanges] = Field(
        default=UNSET,
        description="If the action was `edited`, the changes to the rule.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    rule: WebhookBranchProtectionRuleEditedPropRule = Field(
        title="branch protection rule",
        description="The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookBranchProtectionRuleEditedPropChanges(GitHubModel):
    """WebhookBranchProtectionRuleEditedPropChanges

    If the action was `edited`, the changes to the rule.
    """

    admin_enforced: Missing[
        WebhookBranchProtectionRuleEditedPropChangesPropAdminEnforced
    ] = Field(default=UNSET)
    authorized_actor_names: Missing[
        WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorNames
    ] = Field(default=UNSET)
    authorized_actors_only: Missing[
        WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly
    ] = Field(default=UNSET)
    authorized_dismissal_actors_only: Missing[
        WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly
    ] = Field(default=UNSET)
    linear_history_requirement_enforcement_level: Missing[
        WebhookBranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevel
    ] = Field(default=UNSET)
    required_status_checks: Missing[
        WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecks
    ] = Field(default=UNSET)
    required_status_checks_enforcement_level: Missing[
        WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevel
    ] = Field(default=UNSET)


class WebhookBranchProtectionRuleEditedPropChangesPropAdminEnforced(GitHubModel):
    """WebhookBranchProtectionRuleEditedPropChangesPropAdminEnforced"""

    from_: Union[bool, None] = Field(alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorNames(GitHubModel):
    """WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorNames"""

    from_: List[str] = Field(alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly(GitHubModel):
    """WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly"""

    from_: Union[bool, None] = Field(alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly(
    GitHubModel
):
    """WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly"""

    from_: Union[bool, None] = Field(alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevel(
    GitHubModel
):
    """WebhookBranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcem
    entLevel
    """

    from_: Literal["off", "non_admins", "everyone"] = Field(alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecks(GitHubModel):
    """WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecks"""

    from_: List[str] = Field(alias="from")


class WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevel(
    GitHubModel
):
    """WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementL
    evel
    """

    from_: Literal["off", "non_admins", "everyone"] = Field(alias="from")


class WebhookBranchProtectionRuleEditedPropRule(GitHubModel):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool = Field()
    allow_deletions_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    allow_force_pushes_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    authorized_actor_names: List[str] = Field()
    authorized_actors_only: bool = Field()
    authorized_dismissal_actors_only: bool = Field()
    create_protected: Missing[bool] = Field(default=UNSET)
    created_at: datetime = Field()
    dismiss_stale_reviews_on_push: bool = Field()
    id: int = Field()
    ignore_approvals_from_contributors: bool = Field()
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"] = Field()
    name: str = Field()
    pull_request_reviews_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    repository_id: int = Field()
    require_code_owner_review: bool = Field()
    require_last_push_approval: Missing[bool] = Field(
        default=UNSET,
        description="Whether the most recent push must be approved by someone other than the person who pushed it",
    )
    required_approving_review_count: int = Field()
    required_conversation_resolution_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    required_deployments_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    required_status_checks: List[str] = Field()
    required_status_checks_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    signature_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ] = Field()
    strict_required_status_checks_policy: bool = Field()
    updated_at: datetime = Field()


class WebhookCheckRunCompleted(GitHubModel):
    """Check Run Completed Event"""

    action: Literal["completed"] = Field()
    check_run: CheckRunWithSimpleCheckSuite = Field(
        title="CheckRun",
        description="A check performed on the code of a given code change",
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCheckRunCompletedFormEncoded(GitHubModel):
    """Check Run Completed Event

    The check_run.completed webhook encoded with URL encoding
    """

    payload: str = Field(
        description="A URL-encoded string of the check_run.completed JSON payload. The decoded payload is a JSON object."
    )


class WebhookCheckRunCreated(GitHubModel):
    """Check Run Created Event"""

    action: Literal["created"] = Field()
    check_run: CheckRunWithSimpleCheckSuite = Field(
        title="CheckRun",
        description="A check performed on the code of a given code change",
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCheckRunCreatedFormEncoded(GitHubModel):
    """Check Run Created Event

    The check_run.created webhook encoded with URL encoding
    """

    payload: str = Field(
        description="A URL-encoded string of the check_run.created JSON payload. The decoded payload is a JSON object."
    )


class WebhookCheckRunRequestedAction(GitHubModel):
    """Check Run Requested Action Event"""

    action: Literal["requested_action"] = Field()
    check_run: CheckRunWithSimpleCheckSuite = Field(
        title="CheckRun",
        description="A check performed on the code of a given code change",
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    requested_action: Missing[
        WebhookCheckRunRequestedActionPropRequestedAction
    ] = Field(default=UNSET, description="The action requested by the user.")
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCheckRunRequestedActionPropRequestedAction(GitHubModel):
    """WebhookCheckRunRequestedActionPropRequestedAction

    The action requested by the user.
    """

    identifier: Missing[str] = Field(
        default=UNSET,
        description="The integrator reference of the action requested by the user.",
    )


class WebhookCheckRunRequestedActionFormEncoded(GitHubModel):
    """Check Run Requested Action Event

    The check_run.requested_action webhook encoded with URL encoding
    """

    payload: str = Field(
        description="A URL-encoded string of the check_run.requested_action JSON payload. The decoded payload is a JSON object."
    )


class WebhookCheckRunRerequested(GitHubModel):
    """Check Run Re-Requested Event"""

    action: Literal["rerequested"] = Field()
    check_run: CheckRunWithSimpleCheckSuite = Field(
        title="CheckRun",
        description="A check performed on the code of a given code change",
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCheckRunRerequestedFormEncoded(GitHubModel):
    """Check Run Re-Requested Event

    The check_run.rerequested webhook encoded with URL encoding
    """

    payload: str = Field(
        description="A URL-encoded string of the check_run.rerequested JSON payload. The decoded payload is a JSON object."
    )


class WebhookCheckSuiteCompleted(GitHubModel):
    """check_suite completed event"""

    action: Literal["completed"] = Field()
    check_suite: WebhookCheckSuiteCompletedPropCheckSuite = Field(
        description="The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite)."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCheckSuiteCompletedPropCheckSuite(GitHubModel):
    """WebhookCheckSuiteCompletedPropCheckSuite

    The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite).
    """

    after: Union[str, None] = Field()
    app: WebhookCheckSuiteCompletedPropCheckSuitePropApp = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    before: Union[str, None] = Field()
    check_runs_url: str = Field()
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
            "startup_failure",
        ],
    ] = Field(
        description="The summary conclusion for all check runs that are part of the check suite. This value will be `null` until the check run has `completed`."
    )
    created_at: datetime = Field()
    head_branch: Union[str, None] = Field(
        description="The head branch name the changes are on."
    )
    head_commit: WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommit = Field(
        title="SimpleCommit"
    )
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked."
    )
    id: int = Field()
    latest_check_runs_count: int = Field()
    node_id: str = Field()
    pull_requests: List[
        WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItems
    ] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty."
    )
    rerequestable: Missing[bool] = Field(default=UNSET)
    runs_rerequestable: Missing[bool] = Field(default=UNSET)
    status: Union[
        None, Literal["requested", "in_progress", "completed", "queued", "pending"]
    ] = Field(
        description="The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`."
    )
    updated_at: datetime = Field()
    url: str = Field(description="URL that points to the check suite API resource.")


class WebhookCheckSuiteCompletedPropCheckSuitePropApp(GitHubModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "merge_group",
                "pull_request_review_thread",
                "workflow_job",
                "merge_queue_entry",
                "security_and_analysis",
                "projects_v2_item",
                "secret_scanning_alert_location",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookCheckSuiteCompletedPropCheckSuitePropAppPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookCheckSuiteCompletedPropCheckSuitePropAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookCheckSuiteCompletedPropCheckSuitePropAppPropOwner(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookCheckSuiteCompletedPropCheckSuitePropAppPropPermissions(GitHubModel):
    """WebhookCheckSuiteCompletedPropCheckSuitePropAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    administration: Missing[Literal["read", "write"]] = Field(default=UNSET)
    checks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    content_references: Missing[Literal["read", "write"]] = Field(default=UNSET)
    contents: Missing[Literal["read", "write"]] = Field(default=UNSET)
    deployments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    emails: Missing[Literal["read", "write"]] = Field(default=UNSET)
    environments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    issues: Missing[Literal["read", "write"]] = Field(default=UNSET)
    keys: Missing[Literal["read", "write"]] = Field(default=UNSET)
    members: Missing[Literal["read", "write"]] = Field(default=UNSET)
    metadata: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(default=UNSET)
    packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_events: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Missing[Literal["read", "write"]] = Field(default=UNSET)
    single_file: Missing[Literal["read", "write"]] = Field(default=UNSET)
    statuses: Missing[Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    workflows: Missing[Literal["read", "write"]] = Field(default=UNSET)


class WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommit(GitHubModel):
    """SimpleCommit"""

    author: WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitPropAuthor = Field(
        title="Committer",
        description="Metaproperties for Git author/committer information.",
    )
    committer: WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitPropCommitter = (
        Field(
            title="Committer",
            description="Metaproperties for Git author/committer information.",
        )
    )
    id: str = Field()
    message: str = Field()
    timestamp: str = Field()
    tree_id: str = Field()


class WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitPropAuthor(GitHubModel):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: Missing[datetime] = Field(default=UNSET)
    email: Union[str, None] = Field()
    name: str = Field(description="The git author's name.")
    username: Missing[str] = Field(default=UNSET)


class WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitPropCommitter(GitHubModel):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: Missing[datetime] = Field(default=UNSET)
    email: Union[str, None] = Field()
    name: str = Field(description="The git author's name.")
    username: Missing[str] = Field(default=UNSET)


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItems(GitHubModel):
    """Check Run Pull Request"""

    base: WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBase = (
        Field()
    )
    head: WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHead = (
        Field()
    )
    id: int = Field()
    number: int = Field()
    url: str = Field()


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBase(
    GitHubModel
):
    """WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBase"""

    ref: str = Field()
    repo: WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBasePropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBasePropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHead(
    GitHubModel
):
    """WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHead"""

    ref: str = Field()
    repo: WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHeadPropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHeadPropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookCheckSuiteRequested(GitHubModel):
    """check_suite requested event"""

    action: Literal["requested"] = Field()
    check_suite: WebhookCheckSuiteRequestedPropCheckSuite = Field(
        description="The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite)."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCheckSuiteRequestedPropCheckSuite(GitHubModel):
    """WebhookCheckSuiteRequestedPropCheckSuite

    The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite).
    """

    after: Union[str, None] = Field()
    app: WebhookCheckSuiteRequestedPropCheckSuitePropApp = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    before: Union[str, None] = Field()
    check_runs_url: str = Field()
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ] = Field(
        description="The summary conclusion for all check runs that are part of the check suite. This value will be `null` until the check run has completed."
    )
    created_at: datetime = Field()
    head_branch: Union[str, None] = Field(
        description="The head branch name the changes are on."
    )
    head_commit: WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommit = Field(
        title="SimpleCommit"
    )
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked."
    )
    id: int = Field()
    latest_check_runs_count: int = Field()
    node_id: str = Field()
    pull_requests: List[
        WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItems
    ] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty."
    )
    rerequestable: Missing[bool] = Field(default=UNSET)
    runs_rerequestable: Missing[bool] = Field(default=UNSET)
    status: Union[
        None, Literal["requested", "in_progress", "completed", "queued"]
    ] = Field(
        description="The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`."
    )
    updated_at: datetime = Field()
    url: str = Field(description="URL that points to the check suite API resource.")


class WebhookCheckSuiteRequestedPropCheckSuitePropApp(GitHubModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "workflow_job",
                "merge_queue_entry",
                "security_and_analysis",
                "secret_scanning_alert_location",
                "projects_v2_item",
                "merge_group",
                "repository_import",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookCheckSuiteRequestedPropCheckSuitePropAppPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookCheckSuiteRequestedPropCheckSuitePropAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookCheckSuiteRequestedPropCheckSuitePropAppPropOwner(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookCheckSuiteRequestedPropCheckSuitePropAppPropPermissions(GitHubModel):
    """WebhookCheckSuiteRequestedPropCheckSuitePropAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    administration: Missing[Literal["read", "write"]] = Field(default=UNSET)
    checks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    content_references: Missing[Literal["read", "write"]] = Field(default=UNSET)
    contents: Missing[Literal["read", "write"]] = Field(default=UNSET)
    deployments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    emails: Missing[Literal["read", "write"]] = Field(default=UNSET)
    environments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    issues: Missing[Literal["read", "write"]] = Field(default=UNSET)
    keys: Missing[Literal["read", "write"]] = Field(default=UNSET)
    members: Missing[Literal["read", "write"]] = Field(default=UNSET)
    metadata: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(default=UNSET)
    packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_events: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Missing[Literal["read", "write"]] = Field(default=UNSET)
    single_file: Missing[Literal["read", "write"]] = Field(default=UNSET)
    statuses: Missing[Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    workflows: Missing[Literal["read", "write"]] = Field(default=UNSET)


class WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommit(GitHubModel):
    """SimpleCommit"""

    author: WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitPropAuthor = Field(
        title="Committer",
        description="Metaproperties for Git author/committer information.",
    )
    committer: WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitPropCommitter = (
        Field(
            title="Committer",
            description="Metaproperties for Git author/committer information.",
        )
    )
    id: str = Field()
    message: str = Field()
    timestamp: str = Field()
    tree_id: str = Field()


class WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitPropAuthor(GitHubModel):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: Missing[datetime] = Field(default=UNSET)
    email: Union[str, None] = Field()
    name: str = Field(description="The git author's name.")
    username: Missing[str] = Field(default=UNSET)


class WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitPropCommitter(GitHubModel):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: Missing[datetime] = Field(default=UNSET)
    email: Union[str, None] = Field()
    name: str = Field(description="The git author's name.")
    username: Missing[str] = Field(default=UNSET)


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItems(GitHubModel):
    """Check Run Pull Request"""

    base: WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBase = (
        Field()
    )
    head: WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHead = (
        Field()
    )
    id: int = Field()
    number: int = Field()
    url: str = Field()


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBase(
    GitHubModel
):
    """WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBase"""

    ref: str = Field()
    repo: WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBasePropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBasePropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHead(
    GitHubModel
):
    """WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHead"""

    ref: str = Field()
    repo: WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHeadPropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHeadPropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookCheckSuiteRerequested(GitHubModel):
    """check_suite rerequested event"""

    action: Literal["rerequested"] = Field()
    check_suite: WebhookCheckSuiteRerequestedPropCheckSuite = Field(
        description="The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite)."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCheckSuiteRerequestedPropCheckSuite(GitHubModel):
    """WebhookCheckSuiteRerequestedPropCheckSuite

    The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite).
    """

    after: Union[str, None] = Field()
    app: WebhookCheckSuiteRerequestedPropCheckSuitePropApp = Field(
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    before: Union[str, None] = Field()
    check_runs_url: str = Field()
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field(
        description="The summary conclusion for all check runs that are part of the check suite. This value will be `null` until the check run has completed."
    )
    created_at: datetime = Field()
    head_branch: Union[str, None] = Field(
        description="The head branch name the changes are on."
    )
    head_commit: WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommit = Field(
        title="SimpleCommit"
    )
    head_sha: str = Field(
        description="The SHA of the head commit that is being checked."
    )
    id: int = Field()
    latest_check_runs_count: int = Field()
    node_id: str = Field()
    pull_requests: List[
        WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItems
    ] = Field(
        description="An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty."
    )
    rerequestable: Missing[bool] = Field(default=UNSET)
    runs_rerequestable: Missing[bool] = Field(default=UNSET)
    status: Union[
        None, Literal["requested", "in_progress", "completed", "queued"]
    ] = Field(
        description="The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`."
    )
    updated_at: datetime = Field()
    url: str = Field(description="URL that points to the check suite API resource.")


class WebhookCheckSuiteRerequestedPropCheckSuitePropApp(GitHubModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "merge_queue_entry",
                "workflow_job",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropOwner(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropPermissions(GitHubModel):
    """WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    administration: Missing[Literal["read", "write"]] = Field(default=UNSET)
    checks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    content_references: Missing[Literal["read", "write"]] = Field(default=UNSET)
    contents: Missing[Literal["read", "write"]] = Field(default=UNSET)
    deployments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    emails: Missing[Literal["read", "write"]] = Field(default=UNSET)
    environments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    issues: Missing[Literal["read", "write"]] = Field(default=UNSET)
    keys: Missing[Literal["read", "write"]] = Field(default=UNSET)
    members: Missing[Literal["read", "write"]] = Field(default=UNSET)
    metadata: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(default=UNSET)
    packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_events: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Missing[Literal["read", "write"]] = Field(default=UNSET)
    single_file: Missing[Literal["read", "write"]] = Field(default=UNSET)
    statuses: Missing[Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    workflows: Missing[Literal["read", "write"]] = Field(default=UNSET)


class WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommit(GitHubModel):
    """SimpleCommit"""

    author: WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitPropAuthor = Field(
        title="Committer",
        description="Metaproperties for Git author/committer information.",
    )
    committer: WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitPropCommitter = (
        Field(
            title="Committer",
            description="Metaproperties for Git author/committer information.",
        )
    )
    id: str = Field()
    message: str = Field()
    timestamp: str = Field()
    tree_id: str = Field()


class WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitPropAuthor(GitHubModel):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: Missing[datetime] = Field(default=UNSET)
    email: Union[str, None] = Field()
    name: str = Field(description="The git author's name.")
    username: Missing[str] = Field(default=UNSET)


class WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitPropCommitter(
    GitHubModel
):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: Missing[datetime] = Field(default=UNSET)
    email: Union[str, None] = Field()
    name: str = Field(description="The git author's name.")
    username: Missing[str] = Field(default=UNSET)


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItems(GitHubModel):
    """Check Run Pull Request"""

    base: WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBase = (
        Field()
    )
    head: WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHead = (
        Field()
    )
    id: int = Field()
    number: int = Field()
    url: str = Field()


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBase(
    GitHubModel
):
    """WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBase"""

    ref: str = Field()
    repo: WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBasePropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBasePropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHead(
    GitHubModel
):
    """WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHead"""

    ref: str = Field()
    repo: WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHeadPropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHeadPropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookCodeScanningAlertAppearedInBranch(GitHubModel):
    """code_scanning_alert appeared_in_branch event"""

    action: Literal["appeared_in_branch"] = Field()
    alert: WebhookCodeScanningAlertAppearedInBranchPropAlert = Field(
        description="The code scanning alert involved in the event."
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCodeScanningAlertAppearedInBranchPropAlert(GitHubModel):
    """WebhookCodeScanningAlertAppearedInBranchPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`"
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_by: Union[
        WebhookCodeScanningAlertAppearedInBranchPropAlertPropDismissedBy, None
    ] = Field(title="User")
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(description="The reason for dismissing or closing the alert.")
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    most_recent_instance: Missing[
        Union[
            WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstance,
            None,
        ]
    ] = Field(default=UNSET, title="Alert Instance")
    number: int = Field(description="The code scanning alert number.")
    rule: WebhookCodeScanningAlertAppearedInBranchPropAlertPropRule = Field()
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )
    tool: WebhookCodeScanningAlertAppearedInBranchPropAlertPropTool = Field()
    url: str = Field()


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropDismissedBy(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropLocation(
    GitHubModel
):
    """WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropLocat
    ion
    """

    end_column: Missing[int] = Field(default=UNSET)
    end_line: Missing[int] = Field(default=UNSET)
    path: Missing[str] = Field(default=UNSET)
    start_column: Missing[int] = Field(default=UNSET)
    start_line: Missing[int] = Field(default=UNSET)


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropMessage(
    GitHubModel
):
    """WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropMessa
    ge
    """

    text: Missing[str] = Field(default=UNSET)


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstance(
    GitHubModel
):
    """Alert Instance"""

    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name."
    )
    category: Missing[str] = Field(
        default=UNSET,
        description="Identifies the configuration under which the analysis was executed.",
    )
    classifications: Missing[List[str]] = Field(default=UNSET)
    commit_sha: Missing[str] = Field(default=UNSET)
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed."
    )
    location: Missing[
        WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropLocation
    ] = Field(default=UNSET)
    message: Missing[
        WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropMessage
    ] = Field(default=UNSET)
    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`."
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropRule(GitHubModel):
    """WebhookCodeScanningAlertAppearedInBranchPropAlertPropRule"""

    description: str = Field(
        description="A short description of the rule used to detect the alert."
    )
    id: str = Field(
        description="A unique identifier for the rule used to detect the alert."
    )
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert."
    )


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropTool(GitHubModel):
    """WebhookCodeScanningAlertAppearedInBranchPropAlertPropTool"""

    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert."
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert."
    )


class WebhookCodeScanningAlertClosedByUser(GitHubModel):
    """code_scanning_alert closed_by_user event"""

    action: Literal["closed_by_user"] = Field()
    alert: WebhookCodeScanningAlertClosedByUserPropAlert = Field(
        description="The code scanning alert involved in the event."
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCodeScanningAlertClosedByUserPropAlert(GitHubModel):
    """WebhookCodeScanningAlertClosedByUserPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`"
    )
    dismissed_at: datetime = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_by: Union[
        WebhookCodeScanningAlertClosedByUserPropAlertPropDismissedBy, None
    ] = Field(title="User")
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(description="The reason for dismissing or closing the alert.")
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    most_recent_instance: Missing[
        Union[WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstance, None]
    ] = Field(default=UNSET, title="Alert Instance")
    number: int = Field(description="The code scanning alert number.")
    rule: WebhookCodeScanningAlertClosedByUserPropAlertPropRule = Field()
    state: Literal["dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )
    tool: WebhookCodeScanningAlertClosedByUserPropAlertPropTool = Field()
    url: str = Field()


class WebhookCodeScanningAlertClosedByUserPropAlertPropDismissedBy(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropLocation(
    GitHubModel
):
    """WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropLocation"""

    end_column: Missing[int] = Field(default=UNSET)
    end_line: Missing[int] = Field(default=UNSET)
    path: Missing[str] = Field(default=UNSET)
    start_column: Missing[int] = Field(default=UNSET)
    start_line: Missing[int] = Field(default=UNSET)


class WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropMessage(
    GitHubModel
):
    """WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropMessage"""

    text: Missing[str] = Field(default=UNSET)


class WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstance(GitHubModel):
    """Alert Instance"""

    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name."
    )
    category: Missing[str] = Field(
        default=UNSET,
        description="Identifies the configuration under which the analysis was executed.",
    )
    classifications: Missing[List[str]] = Field(default=UNSET)
    commit_sha: Missing[str] = Field(default=UNSET)
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed."
    )
    location: Missing[
        WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropLocation
    ] = Field(default=UNSET)
    message: Missing[
        WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropMessage
    ] = Field(default=UNSET)
    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`."
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )


class WebhookCodeScanningAlertClosedByUserPropAlertPropRule(GitHubModel):
    """WebhookCodeScanningAlertClosedByUserPropAlertPropRule"""

    description: str = Field(
        description="A short description of the rule used to detect the alert."
    )
    full_description: Missing[str] = Field(default=UNSET)
    help_: Missing[Union[str, None]] = Field(default=UNSET, alias="help")
    help_uri: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="A link to the documentation for the rule used to detect the alert.",
    )
    id: str = Field(
        description="A unique identifier for the rule used to detect the alert."
    )
    name: Missing[str] = Field(default=UNSET)
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert."
    )
    tags: Missing[Union[List[str], None]] = Field(default=UNSET)


class WebhookCodeScanningAlertClosedByUserPropAlertPropTool(GitHubModel):
    """WebhookCodeScanningAlertClosedByUserPropAlertPropTool"""

    guid: Missing[Union[str, None]] = Field(default=UNSET)
    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert."
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert."
    )


class WebhookCodeScanningAlertCreated(GitHubModel):
    """code_scanning_alert created event"""

    action: Literal["created"] = Field()
    alert: WebhookCodeScanningAlertCreatedPropAlert = Field(
        description="The code scanning alert involved in the event."
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCodeScanningAlertCreatedPropAlert(GitHubModel):
    """WebhookCodeScanningAlertCreatedPropAlert

    The code scanning alert involved in the event.
    """

    created_at: Union[datetime, None] = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`"
    )
    dismissed_at: None = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_by: None = Field()
    dismissed_comment: Missing[
        Union[Annotated[str, Field(max_length=280)], None]
    ] = Field(
        default=UNSET,
        description="The dismissal comment associated with the dismissal of the alert.",
    )
    dismissed_reason: None = Field(
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`."
    )
    fixed_at: Missing[None] = Field(default=UNSET)
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    instances_url: Missing[str] = Field(default=UNSET)
    most_recent_instance: Missing[
        Union[WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstance, None]
    ] = Field(default=UNSET, title="Alert Instance")
    number: int = Field(description="The code scanning alert number.")
    rule: WebhookCodeScanningAlertCreatedPropAlertPropRule = Field()
    state: Literal["open", "dismissed"] = Field(
        description="State of a code scanning alert."
    )
    tool: Union[WebhookCodeScanningAlertCreatedPropAlertPropTool, None] = Field()
    updated_at: Missing[Union[str, None]] = Field(default=UNSET)
    url: str = Field()


class WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropLocation(
    GitHubModel
):
    """WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropLocation"""

    end_column: Missing[int] = Field(default=UNSET)
    end_line: Missing[int] = Field(default=UNSET)
    path: Missing[str] = Field(default=UNSET)
    start_column: Missing[int] = Field(default=UNSET)
    start_line: Missing[int] = Field(default=UNSET)


class WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropMessage(
    GitHubModel
):
    """WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropMessage"""

    text: Missing[str] = Field(default=UNSET)


class WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstance(GitHubModel):
    """Alert Instance"""

    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name."
    )
    category: Missing[str] = Field(
        default=UNSET,
        description="Identifies the configuration under which the analysis was executed.",
    )
    classifications: Missing[List[str]] = Field(default=UNSET)
    commit_sha: Missing[str] = Field(default=UNSET)
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed."
    )
    location: Missing[
        WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropLocation
    ] = Field(default=UNSET)
    message: Missing[
        WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropMessage
    ] = Field(default=UNSET)
    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`."
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )


class WebhookCodeScanningAlertCreatedPropAlertPropRule(GitHubModel):
    """WebhookCodeScanningAlertCreatedPropAlertPropRule"""

    description: str = Field(
        description="A short description of the rule used to detect the alert."
    )
    full_description: Missing[str] = Field(default=UNSET)
    help_: Missing[Union[str, None]] = Field(default=UNSET, alias="help")
    help_uri: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="A link to the documentation for the rule used to detect the alert.",
    )
    id: str = Field(
        description="A unique identifier for the rule used to detect the alert."
    )
    name: Missing[str] = Field(default=UNSET)
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert."
    )
    tags: Missing[Union[List[str], None]] = Field(default=UNSET)


class WebhookCodeScanningAlertCreatedPropAlertPropTool(GitHubModel):
    """WebhookCodeScanningAlertCreatedPropAlertPropTool"""

    guid: Missing[Union[str, None]] = Field(default=UNSET)
    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert."
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert."
    )


class WebhookCodeScanningAlertFixed(GitHubModel):
    """code_scanning_alert fixed event"""

    action: Literal["fixed"] = Field()
    alert: WebhookCodeScanningAlertFixedPropAlert = Field(
        description="The code scanning alert involved in the event."
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCodeScanningAlertFixedPropAlert(GitHubModel):
    """WebhookCodeScanningAlertFixedPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`"
    )
    dismissed_at: Union[datetime, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_by: Union[
        WebhookCodeScanningAlertFixedPropAlertPropDismissedBy, None
    ] = Field(title="User")
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ] = Field(description="The reason for dismissing or closing the alert.")
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    instances_url: Missing[str] = Field(default=UNSET)
    most_recent_instance: Missing[
        Union[WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstance, None]
    ] = Field(default=UNSET, title="Alert Instance")
    number: int = Field(description="The code scanning alert number.")
    rule: WebhookCodeScanningAlertFixedPropAlertPropRule = Field()
    state: Literal["fixed"] = Field(description="State of a code scanning alert.")
    tool: WebhookCodeScanningAlertFixedPropAlertPropTool = Field()
    url: str = Field()


class WebhookCodeScanningAlertFixedPropAlertPropDismissedBy(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropLocation(
    GitHubModel
):
    """WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropLocation"""

    end_column: Missing[int] = Field(default=UNSET)
    end_line: Missing[int] = Field(default=UNSET)
    path: Missing[str] = Field(default=UNSET)
    start_column: Missing[int] = Field(default=UNSET)
    start_line: Missing[int] = Field(default=UNSET)


class WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropMessage(
    GitHubModel
):
    """WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropMessage"""

    text: Missing[str] = Field(default=UNSET)


class WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstance(GitHubModel):
    """Alert Instance"""

    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name."
    )
    category: Missing[str] = Field(
        default=UNSET,
        description="Identifies the configuration under which the analysis was executed.",
    )
    classifications: Missing[List[str]] = Field(default=UNSET)
    commit_sha: Missing[str] = Field(default=UNSET)
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed."
    )
    location: Missing[
        WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropLocation
    ] = Field(default=UNSET)
    message: Missing[
        WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropMessage
    ] = Field(default=UNSET)
    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`."
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )


class WebhookCodeScanningAlertFixedPropAlertPropRule(GitHubModel):
    """WebhookCodeScanningAlertFixedPropAlertPropRule"""

    description: str = Field(
        description="A short description of the rule used to detect the alert."
    )
    full_description: Missing[str] = Field(default=UNSET)
    help_: Missing[Union[str, None]] = Field(default=UNSET, alias="help")
    help_uri: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="A link to the documentation for the rule used to detect the alert.",
    )
    id: str = Field(
        description="A unique identifier for the rule used to detect the alert."
    )
    name: Missing[str] = Field(default=UNSET)
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert."
    )
    tags: Missing[Union[List[str], None]] = Field(default=UNSET)


class WebhookCodeScanningAlertFixedPropAlertPropTool(GitHubModel):
    """WebhookCodeScanningAlertFixedPropAlertPropTool"""

    guid: Missing[Union[str, None]] = Field(default=UNSET)
    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert."
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert."
    )


class WebhookCodeScanningAlertReopened(GitHubModel):
    """code_scanning_alert reopened event"""

    action: Literal["reopened"] = Field()
    alert: Union[WebhookCodeScanningAlertReopenedPropAlert, None] = Field(
        description="The code scanning alert involved in the event."
    )
    commit_oid: Union[str, None] = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    ref: Union[str, None] = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCodeScanningAlertReopenedPropAlertPropDismissedBy(GitHubModel):
    """WebhookCodeScanningAlertReopenedPropAlertPropDismissedBy"""


class WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropLocation(
    GitHubModel
):
    """WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropLocation"""

    end_column: Missing[int] = Field(default=UNSET)
    end_line: Missing[int] = Field(default=UNSET)
    path: Missing[str] = Field(default=UNSET)
    start_column: Missing[int] = Field(default=UNSET)
    start_line: Missing[int] = Field(default=UNSET)


class WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropMessage(
    GitHubModel
):
    """WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropMessage"""

    text: Missing[str] = Field(default=UNSET)


class WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstance(GitHubModel):
    """Alert Instance"""

    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name."
    )
    category: Missing[str] = Field(
        default=UNSET,
        description="Identifies the configuration under which the analysis was executed.",
    )
    classifications: Missing[List[str]] = Field(default=UNSET)
    commit_sha: Missing[str] = Field(default=UNSET)
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed."
    )
    location: Missing[
        WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropLocation
    ] = Field(default=UNSET)
    message: Missing[
        WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropMessage
    ] = Field(default=UNSET)
    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`."
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )


class WebhookCodeScanningAlertReopenedPropAlertPropRule(GitHubModel):
    """WebhookCodeScanningAlertReopenedPropAlertPropRule"""

    description: str = Field(
        description="A short description of the rule used to detect the alert."
    )
    full_description: Missing[str] = Field(default=UNSET)
    help_: Missing[Union[str, None]] = Field(default=UNSET, alias="help")
    help_uri: Missing[Union[str, None]] = Field(
        default=UNSET,
        description="A link to the documentation for the rule used to detect the alert.",
    )
    id: str = Field(
        description="A unique identifier for the rule used to detect the alert."
    )
    name: Missing[str] = Field(default=UNSET)
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert."
    )
    tags: Missing[Union[List[str], None]] = Field(default=UNSET)


class WebhookCodeScanningAlertReopenedPropAlertPropTool(GitHubModel):
    """WebhookCodeScanningAlertReopenedPropAlertPropTool"""

    guid: Missing[Union[str, None]] = Field(default=UNSET)
    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert."
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert."
    )


class WebhookCodeScanningAlertReopenedPropAlert(GitHubModel):
    """WebhookCodeScanningAlertReopenedPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`"
    )
    dismissed_at: Union[str, None] = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_by: Union[
        WebhookCodeScanningAlertReopenedPropAlertPropDismissedBy, None
    ] = Field()
    dismissed_reason: Union[str, None] = Field(
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`."
    )
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    most_recent_instance: Missing[
        Union[WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstance, None]
    ] = Field(default=UNSET, title="Alert Instance")
    number: int = Field(description="The code scanning alert number.")
    rule: WebhookCodeScanningAlertReopenedPropAlertPropRule = Field()
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )
    tool: WebhookCodeScanningAlertReopenedPropAlertPropTool = Field()
    url: str = Field()


class WebhookCodeScanningAlertReopenedByUser(GitHubModel):
    """code_scanning_alert reopened_by_user event"""

    action: Literal["reopened_by_user"] = Field()
    alert: WebhookCodeScanningAlertReopenedByUserPropAlert = Field(
        description="The code scanning alert involved in the event."
    )
    commit_oid: str = Field(
        description="The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    ref: str = Field(
        description="The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty."
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCodeScanningAlertReopenedByUserPropAlert(GitHubModel):
    """WebhookCodeScanningAlertReopenedByUserPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime = Field(
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`"
    )
    dismissed_at: None = Field(
        description="The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`."
    )
    dismissed_by: None = Field()
    dismissed_reason: None = Field(
        description="The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`."
    )
    html_url: str = Field(description="The GitHub URL of the alert resource.")
    most_recent_instance: Missing[
        Union[
            WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstance, None
        ]
    ] = Field(default=UNSET, title="Alert Instance")
    number: int = Field(description="The code scanning alert number.")
    rule: WebhookCodeScanningAlertReopenedByUserPropAlertPropRule = Field()
    state: Literal["open", "fixed"] = Field(
        description="State of a code scanning alert."
    )
    tool: WebhookCodeScanningAlertReopenedByUserPropAlertPropTool = Field()
    url: str = Field()


class WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropLocation(
    GitHubModel
):
    """WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropLocatio
    n
    """

    end_column: Missing[int] = Field(default=UNSET)
    end_line: Missing[int] = Field(default=UNSET)
    path: Missing[str] = Field(default=UNSET)
    start_column: Missing[int] = Field(default=UNSET)
    start_line: Missing[int] = Field(default=UNSET)


class WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropMessage(
    GitHubModel
):
    """WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropMessage"""

    text: Missing[str] = Field(default=UNSET)


class WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstance(
    GitHubModel
):
    """Alert Instance"""

    analysis_key: str = Field(
        description="Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name."
    )
    category: Missing[str] = Field(
        default=UNSET,
        description="Identifies the configuration under which the analysis was executed.",
    )
    classifications: Missing[List[str]] = Field(default=UNSET)
    commit_sha: Missing[str] = Field(default=UNSET)
    environment: str = Field(
        description="Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed."
    )
    location: Missing[
        WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropLocation
    ] = Field(default=UNSET)
    message: Missing[
        WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropMessage
    ] = Field(default=UNSET)
    ref: str = Field(
        description="The full Git reference, formatted as `refs/heads/<branch name>`."
    )
    state: Literal["open", "dismissed", "fixed"] = Field(
        description="State of a code scanning alert."
    )


class WebhookCodeScanningAlertReopenedByUserPropAlertPropRule(GitHubModel):
    """WebhookCodeScanningAlertReopenedByUserPropAlertPropRule"""

    description: str = Field(
        description="A short description of the rule used to detect the alert."
    )
    id: str = Field(
        description="A unique identifier for the rule used to detect the alert."
    )
    severity: Union[None, Literal["none", "note", "warning", "error"]] = Field(
        description="The severity of the alert."
    )


class WebhookCodeScanningAlertReopenedByUserPropAlertPropTool(GitHubModel):
    """WebhookCodeScanningAlertReopenedByUserPropAlertPropTool"""

    name: str = Field(
        description="The name of the tool used to generate the code scanning analysis alert."
    )
    version: Union[str, None] = Field(
        description="The version of the tool used to detect the alert."
    )


class WebhookCommitCommentCreated(GitHubModel):
    """commit_comment created event"""

    action: Literal["created"] = Field(
        description="The action performed. Can be `created`."
    )
    comment: WebhookCommitCommentCreatedPropComment = Field(
        description="The [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-comment) resource."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCommitCommentCreatedPropComment(GitHubModel):
    """WebhookCommitCommentCreatedPropComment

    The [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-
    comment) resource.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field(description="The text of the comment.")
    commit_id: str = Field(
        description="The SHA of the commit to which the comment applies."
    )
    created_at: str = Field()
    html_url: str = Field()
    id: int = Field(description="The ID of the commit comment.")
    line: Union[int, None] = Field(
        description="The line of the blob to which the comment applies. The last line of the range for a multi-line comment"
    )
    node_id: str = Field(description="The node ID of the commit comment.")
    path: Union[str, None] = Field(
        description="The relative path of the file to which the comment applies."
    )
    position: Union[int, None] = Field(
        description="The line index in the diff to which the comment applies."
    )
    reactions: Missing[WebhookCommitCommentCreatedPropCommentPropReactions] = Field(
        default=UNSET, title="Reactions"
    )
    updated_at: str = Field()
    url: str = Field()
    user: Union[WebhookCommitCommentCreatedPropCommentPropUser, None] = Field(
        title="User"
    )


class WebhookCommitCommentCreatedPropCommentPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookCommitCommentCreatedPropCommentPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookCreate(GitHubModel):
    """create event"""

    description: Union[str, None] = Field(
        description="The repository's current description."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    master_branch: str = Field(
        description="The name of the repository's default branch (usually `main`)."
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    pusher_type: str = Field(
        description="The pusher type for the event. Can be either `user` or a deploy key."
    )
    ref: str = Field(
        description="The [`git ref`](https://docs.github.com/rest/git/refs#get-a-reference) resource."
    )
    ref_type: Literal["tag", "branch"] = Field(
        description="The type of Git ref object created in the repository."
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCustomPropertyCreated(GitHubModel):
    """custom property created event"""

    action: Literal["created"] = Field()
    definition: OrgCustomProperty = Field(
        title="Organization Custom Property",
        description="Custom property defined on an organization",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: OrganizationSimpleWebhooks = Field(
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    sender: Missing[SimpleUserWebhooks] = Field(
        default=UNSET,
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCustomPropertyDeleted(GitHubModel):
    """custom property deleted event"""

    action: Literal["deleted"] = Field()
    definition: WebhookCustomPropertyDeletedPropDefinition = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: OrganizationSimpleWebhooks = Field(
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    sender: Missing[SimpleUserWebhooks] = Field(
        default=UNSET,
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCustomPropertyDeletedPropDefinition(GitHubModel):
    """WebhookCustomPropertyDeletedPropDefinition"""

    property_name: str = Field(description="The name of the property that was deleted.")


class WebhookCustomPropertyUpdated(GitHubModel):
    """custom property updated event"""

    action: Literal["updated"] = Field()
    definition: OrgCustomProperty = Field(
        title="Organization Custom Property",
        description="Custom property defined on an organization",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: OrganizationSimpleWebhooks = Field(
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    sender: Missing[SimpleUserWebhooks] = Field(
        default=UNSET,
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookCustomPropertyValuesUpdated(GitHubModel):
    """Custom property values updated event"""

    action: Literal["updated"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    organization: OrganizationSimpleWebhooks = Field(
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    sender: Missing[SimpleUserWebhooks] = Field(
        default=UNSET,
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )
    new_property_values: List[CustomPropertyValue] = Field(
        description="The new custom property values for the repository."
    )
    old_property_values: List[CustomPropertyValue] = Field(
        description="The old custom property values for the repository."
    )


class WebhookDelete(GitHubModel):
    """delete event"""

    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    pusher_type: str = Field(
        description="The pusher type for the event. Can be either `user` or a deploy key."
    )
    ref: str = Field(
        description="The [`git ref`](https://docs.github.com/rest/git/refs#get-a-reference) resource."
    )
    ref_type: Literal["tag", "branch"] = Field(
        description="The type of Git ref object deleted in the repository."
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDependabotAlertAutoDismissed(GitHubModel):
    """Dependabot alert auto-dismissed event"""

    action: Literal["auto_dismissed"] = Field()
    alert: DependabotAlert = Field(description="A Dependabot alert.")
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDependabotAlertAutoReopened(GitHubModel):
    """Dependabot alert auto-reopened event"""

    action: Literal["auto_reopened"] = Field()
    alert: DependabotAlert = Field(description="A Dependabot alert.")
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDependabotAlertCreated(GitHubModel):
    """Dependabot alert created event"""

    action: Literal["created"] = Field()
    alert: DependabotAlert = Field(description="A Dependabot alert.")
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDependabotAlertDismissed(GitHubModel):
    """Dependabot alert dismissed event"""

    action: Literal["dismissed"] = Field()
    alert: DependabotAlert = Field(description="A Dependabot alert.")
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDependabotAlertFixed(GitHubModel):
    """Dependabot alert fixed event"""

    action: Literal["fixed"] = Field()
    alert: DependabotAlert = Field(description="A Dependabot alert.")
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDependabotAlertReintroduced(GitHubModel):
    """Dependabot alert reintroduced event"""

    action: Literal["reintroduced"] = Field()
    alert: DependabotAlert = Field(description="A Dependabot alert.")
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDependabotAlertReopened(GitHubModel):
    """Dependabot alert reopened event"""

    action: Literal["reopened"] = Field()
    alert: DependabotAlert = Field(description="A Dependabot alert.")
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDeployKeyCreated(GitHubModel):
    """deploy_key created event"""

    action: Literal["created"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    key: WebhookDeployKeyCreatedPropKey = Field(
        description="The [`deploy key`](https://docs.github.com/rest/deploy-keys/deploy-keys#get-a-deploy-key) resource."
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDeployKeyCreatedPropKey(GitHubModel):
    """WebhookDeployKeyCreatedPropKey

    The [`deploy key`](https://docs.github.com/rest/deploy-keys/deploy-keys#get-a-
    deploy-key) resource.
    """

    added_by: Missing[Union[str, None]] = Field(default=UNSET)
    created_at: str = Field()
    id: int = Field()
    key: str = Field()
    last_used: Missing[Union[str, None]] = Field(default=UNSET)
    read_only: bool = Field()
    title: str = Field()
    url: str = Field()
    verified: bool = Field()


class WebhookDeployKeyDeleted(GitHubModel):
    """deploy_key deleted event"""

    action: Literal["deleted"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    key: WebhookDeployKeyDeletedPropKey = Field(
        description="The [`deploy key`](https://docs.github.com/rest/deploy-keys/deploy-keys#get-a-deploy-key) resource."
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDeployKeyDeletedPropKey(GitHubModel):
    """WebhookDeployKeyDeletedPropKey

    The [`deploy key`](https://docs.github.com/rest/deploy-keys/deploy-keys#get-a-
    deploy-key) resource.
    """

    added_by: Missing[Union[str, None]] = Field(default=UNSET)
    created_at: str = Field()
    id: int = Field()
    key: str = Field()
    last_used: Missing[Union[str, None]] = Field(default=UNSET)
    read_only: bool = Field()
    title: str = Field()
    url: str = Field()
    verified: bool = Field()


class WebhookDeploymentCreated(GitHubModel):
    """deployment created event"""

    action: Literal["created"] = Field()
    deployment: WebhookDeploymentCreatedPropDeployment = Field(
        title="Deployment",
        description="The [deployment](https://docs.github.com/rest/deployments/deployments#list-deployments).",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )
    workflow: Union[WebhookDeploymentCreatedPropWorkflow, None] = Field(
        title="Workflow"
    )
    workflow_run: Union[WebhookDeploymentCreatedPropWorkflowRun, None] = Field(
        title="Deployment Workflow Run"
    )


class WebhookDeploymentCreatedPropDeployment(GitHubModel):
    """Deployment

    The [deployment](https://docs.github.com/rest/deployments/deployments#list-
    deployments).
    """

    created_at: str = Field()
    creator: Union[WebhookDeploymentCreatedPropDeploymentPropCreator, None] = Field(
        title="User"
    )
    description: Union[str, None] = Field()
    environment: str = Field()
    id: int = Field()
    node_id: str = Field()
    original_environment: str = Field()
    payload: Union[
        WebhookDeploymentCreatedPropDeploymentPropPayloadOneof0, str
    ] = Field()
    performed_via_github_app: Missing[
        Union[WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubApp, None]
    ] = Field(
        default=UNSET,
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    production_environment: Missing[bool] = Field(default=UNSET)
    ref: str = Field()
    repository_url: str = Field()
    sha: str = Field()
    statuses_url: str = Field()
    task: str = Field()
    transient_environment: Missing[bool] = Field(default=UNSET)
    updated_at: str = Field()
    url: str = Field()


class WebhookDeploymentCreatedPropDeploymentPropCreator(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentCreatedPropDeploymentPropPayloadOneof0(GitHubModel):
    """WebhookDeploymentCreatedPropDeploymentPropPayloadOneof0"""


class WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropPermissions(
    GitHubModel
):
    """WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    administration: Missing[Literal["read", "write"]] = Field(default=UNSET)
    checks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    content_references: Missing[Literal["read", "write"]] = Field(default=UNSET)
    contents: Missing[Literal["read", "write"]] = Field(default=UNSET)
    deployments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    emails: Missing[Literal["read", "write"]] = Field(default=UNSET)
    environments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    issues: Missing[Literal["read", "write"]] = Field(default=UNSET)
    keys: Missing[Literal["read", "write"]] = Field(default=UNSET)
    members: Missing[Literal["read", "write"]] = Field(default=UNSET)
    metadata: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(default=UNSET)
    packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_events: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Missing[Literal["read", "write"]] = Field(default=UNSET)
    single_file: Missing[Literal["read", "write"]] = Field(default=UNSET)
    statuses: Missing[Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    workflows: Missing[Literal["read", "write"]] = Field(default=UNSET)


class WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubApp(GitHubModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "workflow_job",
                "pull_request_review_thread",
                "merge_queue_entry",
                "secret_scanning_alert_location",
                "merge_group",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookDeploymentCreatedPropWorkflow(GitHubModel):
    """Workflow"""

    badge_url: str = Field()
    created_at: datetime = Field()
    html_url: str = Field()
    id: int = Field()
    name: str = Field()
    node_id: str = Field()
    path: str = Field()
    state: str = Field()
    updated_at: datetime = Field()
    url: str = Field()


class WebhookDeploymentCreatedPropWorkflowRunPropActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentCreatedPropWorkflowRunPropHeadRepository(GitHubModel):
    """WebhookDeploymentCreatedPropWorkflowRunPropHeadRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[None] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentCreatedPropWorkflowRunPropHeadRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentCreatedPropWorkflowRunPropHeadRepositoryPropOwner(GitHubModel):
    """WebhookDeploymentCreatedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItems(GitHubModel):
    """Check Run Pull Request"""

    base: WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBase = Field()
    head: WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHead = Field()
    id: int = Field()
    number: int = Field()
    url: str = Field()


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBase(GitHubModel):
    """WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str = Field()
    repo: WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHead(GitHubModel):
    """WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str = Field()
    repo: WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentCreatedPropWorkflowRunPropReferencedWorkflowsItems(GitHubModel):
    """WebhookDeploymentCreatedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str = Field()
    ref: Missing[str] = Field(default=UNSET)
    sha: str = Field()


class WebhookDeploymentCreatedPropWorkflowRunPropRepository(GitHubModel):
    """WebhookDeploymentCreatedPropWorkflowRunPropRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[None] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentCreatedPropWorkflowRunPropRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentCreatedPropWorkflowRunPropRepositoryPropOwner(GitHubModel):
    """WebhookDeploymentCreatedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentCreatedPropWorkflowRunPropTriggeringActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentCreatedPropWorkflowRun(GitHubModel):
    """Deployment Workflow Run"""

    actor: Union[WebhookDeploymentCreatedPropWorkflowRunPropActor, None] = Field(
        title="User"
    )
    artifacts_url: Missing[str] = Field(default=UNSET)
    cancel_url: Missing[str] = Field(default=UNSET)
    check_suite_id: int = Field()
    check_suite_node_id: str = Field()
    check_suite_url: Missing[str] = Field(default=UNSET)
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field()
    created_at: datetime = Field()
    display_title: str = Field()
    event: str = Field()
    head_branch: str = Field()
    head_commit: Missing[None] = Field(default=UNSET)
    head_repository: Missing[
        WebhookDeploymentCreatedPropWorkflowRunPropHeadRepository
    ] = Field(default=UNSET)
    head_sha: str = Field()
    html_url: str = Field()
    id: int = Field()
    jobs_url: Missing[str] = Field(default=UNSET)
    logs_url: Missing[str] = Field(default=UNSET)
    name: str = Field()
    node_id: str = Field()
    path: str = Field()
    previous_attempt_url: Missing[None] = Field(default=UNSET)
    pull_requests: List[
        WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItems
    ] = Field()
    referenced_workflows: Missing[
        Union[
            List[WebhookDeploymentCreatedPropWorkflowRunPropReferencedWorkflowsItems],
            None,
        ]
    ] = Field(default=UNSET)
    repository: Missing[WebhookDeploymentCreatedPropWorkflowRunPropRepository] = Field(
        default=UNSET
    )
    rerun_url: Missing[str] = Field(default=UNSET)
    run_attempt: int = Field()
    run_number: int = Field()
    run_started_at: datetime = Field()
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting", "pending"
    ] = Field()
    triggering_actor: Missing[
        Union[WebhookDeploymentCreatedPropWorkflowRunPropTriggeringActor, None]
    ] = Field(default=UNSET, title="User")
    updated_at: datetime = Field()
    url: str = Field()
    workflow_id: int = Field()
    workflow_url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentProtectionRuleRequested(GitHubModel):
    """deployment protection rule requested event"""

    action: Literal["requested"] = Field()
    environment: Missing[str] = Field(
        default=UNSET,
        description="The name of the environment that has the deployment protection rule.",
    )
    event: Missing[str] = Field(
        default=UNSET,
        description="The event that triggered the deployment protection rule.",
    )
    deployment_callback_url: Missing[str] = Field(
        default=UNSET, description="The URL to review the deployment protection rule."
    )
    deployment: Missing[Deployment] = Field(
        default=UNSET,
        title="Deployment",
        description="A request for a specific ref(branch,sha,tag) to be deployed",
    )
    pull_requests: Missing[List[PullRequest]] = Field(default=UNSET)
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    sender: Missing[SimpleUserWebhooks] = Field(
        default=UNSET,
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDeploymentReviewApproved(GitHubModel):
    """WebhookDeploymentReviewApproved"""

    action: Literal["approved"] = Field()
    approver: Missing[WebhookDeploymentReviewApprovedPropApprover] = Field(
        default=UNSET
    )
    comment: Missing[str] = Field(default=UNSET)
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: OrganizationSimpleWebhooks = Field(
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    reviewers: Missing[List[WebhookDeploymentReviewApprovedPropReviewersItems]] = Field(
        default=UNSET
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )
    since: str = Field()
    workflow_job_run: Missing[
        WebhookDeploymentReviewApprovedPropWorkflowJobRun
    ] = Field(default=UNSET)
    workflow_job_runs: Missing[
        List[WebhookDeploymentReviewApprovedPropWorkflowJobRunsItems]
    ] = Field(default=UNSET)
    workflow_run: Union[WebhookDeploymentReviewApprovedPropWorkflowRun, None] = Field(
        title="Deployment Workflow Run"
    )


class WebhookDeploymentReviewApprovedPropApprover(GitHubModel):
    """WebhookDeploymentReviewApprovedPropApprover"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropReviewersItems(GitHubModel):
    """WebhookDeploymentReviewApprovedPropReviewersItems"""

    reviewer: Missing[
        Union[WebhookDeploymentReviewApprovedPropReviewersItemsPropReviewer, None]
    ] = Field(default=UNSET, title="User")
    type: Missing[Literal["User"]] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropReviewersItemsPropReviewer(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropWorkflowJobRun(GitHubModel):
    """WebhookDeploymentReviewApprovedPropWorkflowJobRun"""

    conclusion: None = Field()
    created_at: str = Field()
    environment: str = Field()
    html_url: str = Field()
    id: int = Field()
    name: None = Field()
    status: str = Field()
    updated_at: str = Field()


class WebhookDeploymentReviewApprovedPropWorkflowJobRunsItems(GitHubModel):
    """WebhookDeploymentReviewApprovedPropWorkflowJobRunsItems"""

    conclusion: Missing[None] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    environment: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    name: Missing[Union[str, None]] = Field(default=UNSET)
    status: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropWorkflowRunPropActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadCommit(GitHubModel):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadCommit"""


class WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepository(GitHubModel):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepositoryPropOwner(
    GitHubModel
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItems(GitHubModel):
    """Check Run Pull Request"""

    base: WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBase = (
        Field()
    )
    head: WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHead = (
        Field()
    )
    id: int = Field()
    number: int = Field()
    url: str = Field()


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBase(
    GitHubModel
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str = Field()
    repo: WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHead(
    GitHubModel
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str = Field()
    repo: WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentReviewApprovedPropWorkflowRunPropReferencedWorkflowsItems(
    GitHubModel
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str = Field()
    ref: Missing[str] = Field(default=UNSET)
    sha: str = Field()


class WebhookDeploymentReviewApprovedPropWorkflowRunPropRepository(GitHubModel):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropWorkflowRunPropRepositoryPropOwner(
    GitHubModel
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropWorkflowRunPropTriggeringActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewApprovedPropWorkflowRun(GitHubModel):
    """Deployment Workflow Run"""

    actor: Union[WebhookDeploymentReviewApprovedPropWorkflowRunPropActor, None] = Field(
        title="User"
    )
    artifacts_url: Missing[str] = Field(default=UNSET)
    cancel_url: Missing[str] = Field(default=UNSET)
    check_suite_id: int = Field()
    check_suite_node_id: str = Field()
    check_suite_url: Missing[str] = Field(default=UNSET)
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field()
    created_at: datetime = Field()
    display_title: str = Field()
    event: str = Field()
    head_branch: str = Field()
    head_commit: Missing[
        Union[WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadCommit, None]
    ] = Field(default=UNSET)
    head_repository: Missing[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepository
    ] = Field(default=UNSET)
    head_sha: str = Field()
    html_url: str = Field()
    id: int = Field()
    jobs_url: Missing[str] = Field(default=UNSET)
    logs_url: Missing[str] = Field(default=UNSET)
    name: str = Field()
    node_id: str = Field()
    path: str = Field()
    previous_attempt_url: Missing[Union[str, None]] = Field(default=UNSET)
    pull_requests: List[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItems
    ] = Field()
    referenced_workflows: Missing[
        Union[
            List[
                WebhookDeploymentReviewApprovedPropWorkflowRunPropReferencedWorkflowsItems
            ],
            None,
        ]
    ] = Field(default=UNSET)
    repository: Missing[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropRepository
    ] = Field(default=UNSET)
    rerun_url: Missing[str] = Field(default=UNSET)
    run_attempt: int = Field()
    run_number: int = Field()
    run_started_at: datetime = Field()
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting", "pending"
    ] = Field()
    triggering_actor: Union[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropTriggeringActor, None
    ] = Field(title="User")
    updated_at: datetime = Field()
    url: str = Field()
    workflow_id: int = Field()
    workflow_url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejected(GitHubModel):
    """WebhookDeploymentReviewRejected"""

    action: Literal["rejected"] = Field()
    approver: Missing[WebhookDeploymentReviewRejectedPropApprover] = Field(
        default=UNSET
    )
    comment: Missing[str] = Field(default=UNSET)
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: OrganizationSimpleWebhooks = Field(
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    reviewers: Missing[List[WebhookDeploymentReviewRejectedPropReviewersItems]] = Field(
        default=UNSET
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )
    since: str = Field()
    workflow_job_run: Missing[
        WebhookDeploymentReviewRejectedPropWorkflowJobRun
    ] = Field(default=UNSET)
    workflow_job_runs: Missing[
        List[WebhookDeploymentReviewRejectedPropWorkflowJobRunsItems]
    ] = Field(default=UNSET)
    workflow_run: Union[WebhookDeploymentReviewRejectedPropWorkflowRun, None] = Field(
        title="Deployment Workflow Run"
    )


class WebhookDeploymentReviewRejectedPropApprover(GitHubModel):
    """WebhookDeploymentReviewRejectedPropApprover"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropReviewersItems(GitHubModel):
    """WebhookDeploymentReviewRejectedPropReviewersItems"""

    reviewer: Missing[
        Union[WebhookDeploymentReviewRejectedPropReviewersItemsPropReviewer, None]
    ] = Field(default=UNSET, title="User")
    type: Missing[Literal["User"]] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropReviewersItemsPropReviewer(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropWorkflowJobRun(GitHubModel):
    """WebhookDeploymentReviewRejectedPropWorkflowJobRun"""

    conclusion: None = Field()
    created_at: str = Field()
    environment: str = Field()
    html_url: str = Field()
    id: int = Field()
    name: None = Field()
    status: str = Field()
    updated_at: str = Field()


class WebhookDeploymentReviewRejectedPropWorkflowJobRunsItems(GitHubModel):
    """WebhookDeploymentReviewRejectedPropWorkflowJobRunsItems"""

    conclusion: Missing[Union[str, None]] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    environment: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    name: Missing[Union[str, None]] = Field(default=UNSET)
    status: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropWorkflowRunPropActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadCommit(GitHubModel):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadCommit"""


class WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepository(GitHubModel):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepositoryPropOwner(
    GitHubModel
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItems(GitHubModel):
    """Check Run Pull Request"""

    base: WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBase = (
        Field()
    )
    head: WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHead = (
        Field()
    )
    id: int = Field()
    number: int = Field()
    url: str = Field()


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBase(
    GitHubModel
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str = Field()
    repo: WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHead(
    GitHubModel
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str = Field()
    repo: WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentReviewRejectedPropWorkflowRunPropReferencedWorkflowsItems(
    GitHubModel
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str = Field()
    ref: Missing[str] = Field(default=UNSET)
    sha: str = Field()


class WebhookDeploymentReviewRejectedPropWorkflowRunPropRepository(GitHubModel):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropWorkflowRunPropRepositoryPropOwner(
    GitHubModel
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropWorkflowRunPropTriggeringActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRejectedPropWorkflowRun(GitHubModel):
    """Deployment Workflow Run"""

    actor: Union[WebhookDeploymentReviewRejectedPropWorkflowRunPropActor, None] = Field(
        title="User"
    )
    artifacts_url: Missing[str] = Field(default=UNSET)
    cancel_url: Missing[str] = Field(default=UNSET)
    check_suite_id: int = Field()
    check_suite_node_id: str = Field()
    check_suite_url: Missing[str] = Field(default=UNSET)
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field()
    created_at: datetime = Field()
    event: str = Field()
    head_branch: str = Field()
    head_commit: Missing[
        Union[WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadCommit, None]
    ] = Field(default=UNSET)
    head_repository: Missing[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepository
    ] = Field(default=UNSET)
    head_sha: str = Field()
    html_url: str = Field()
    id: int = Field()
    jobs_url: Missing[str] = Field(default=UNSET)
    logs_url: Missing[str] = Field(default=UNSET)
    name: str = Field()
    node_id: str = Field()
    path: str = Field()
    previous_attempt_url: Missing[Union[str, None]] = Field(default=UNSET)
    pull_requests: List[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItems
    ] = Field()
    referenced_workflows: Missing[
        Union[
            List[
                WebhookDeploymentReviewRejectedPropWorkflowRunPropReferencedWorkflowsItems
            ],
            None,
        ]
    ] = Field(default=UNSET)
    repository: Missing[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropRepository
    ] = Field(default=UNSET)
    rerun_url: Missing[str] = Field(default=UNSET)
    run_attempt: int = Field()
    run_number: int = Field()
    run_started_at: datetime = Field()
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting"
    ] = Field()
    triggering_actor: Union[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropTriggeringActor, None
    ] = Field(title="User")
    updated_at: datetime = Field()
    url: str = Field()
    workflow_id: int = Field()
    workflow_url: Missing[str] = Field(default=UNSET)
    display_title: str = Field()


class WebhookDeploymentReviewRequested(GitHubModel):
    """WebhookDeploymentReviewRequested"""

    action: Literal["requested"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    environment: str = Field()
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: OrganizationSimpleWebhooks = Field(
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    requestor: Union[WebhookDeploymentReviewRequestedPropRequestor, None] = Field(
        title="User"
    )
    reviewers: List[WebhookDeploymentReviewRequestedPropReviewersItems] = Field()
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )
    since: str = Field()
    workflow_job_run: WebhookDeploymentReviewRequestedPropWorkflowJobRun = Field()
    workflow_run: Union[WebhookDeploymentReviewRequestedPropWorkflowRun, None] = Field(
        title="Deployment Workflow Run"
    )


class WebhookDeploymentReviewRequestedPropRequestor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRequestedPropReviewersItems(GitHubModel):
    """WebhookDeploymentReviewRequestedPropReviewersItems"""

    reviewer: Missing[
        Union[WebhookDeploymentReviewRequestedPropReviewersItemsPropReviewer, None]
    ] = Field(default=UNSET, title="User")
    type: Missing[Literal["User", "Team"]] = Field(default=UNSET)


class WebhookDeploymentReviewRequestedPropReviewersItemsPropReviewer(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRequestedPropWorkflowJobRun(GitHubModel):
    """WebhookDeploymentReviewRequestedPropWorkflowJobRun"""

    conclusion: None = Field()
    created_at: str = Field()
    environment: str = Field()
    html_url: str = Field()
    id: int = Field()
    name: Union[str, None] = Field()
    status: str = Field()
    updated_at: str = Field()


class WebhookDeploymentReviewRequestedPropWorkflowRunPropActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadCommit(GitHubModel):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadCommit"""


class WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepository(GitHubModel):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepositoryPropOwner(
    GitHubModel
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItems(GitHubModel):
    """Check Run Pull Request"""

    base: WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBase = (
        Field()
    )
    head: WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHead = (
        Field()
    )
    id: int = Field()
    number: int = Field()
    url: str = Field()


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBase(
    GitHubModel
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str = Field()
    repo: WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHead(
    GitHubModel
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str = Field()
    repo: WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentReviewRequestedPropWorkflowRunPropReferencedWorkflowsItems(
    GitHubModel
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str = Field()
    ref: Missing[str] = Field(default=UNSET)
    sha: str = Field()


class WebhookDeploymentReviewRequestedPropWorkflowRunPropRepository(GitHubModel):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRequestedPropWorkflowRunPropRepositoryPropOwner(
    GitHubModel
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRequestedPropWorkflowRunPropTriggeringActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentReviewRequestedPropWorkflowRun(GitHubModel):
    """Deployment Workflow Run"""

    actor: Union[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropActor, None
    ] = Field(title="User")
    artifacts_url: Missing[str] = Field(default=UNSET)
    cancel_url: Missing[str] = Field(default=UNSET)
    check_suite_id: int = Field()
    check_suite_node_id: str = Field()
    check_suite_url: Missing[str] = Field(default=UNSET)
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ] = Field()
    created_at: datetime = Field()
    event: str = Field()
    head_branch: str = Field()
    head_commit: Missing[
        Union[WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadCommit, None]
    ] = Field(default=UNSET)
    head_repository: Missing[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepository
    ] = Field(default=UNSET)
    head_sha: str = Field()
    html_url: str = Field()
    id: int = Field()
    jobs_url: Missing[str] = Field(default=UNSET)
    logs_url: Missing[str] = Field(default=UNSET)
    name: str = Field()
    node_id: str = Field()
    path: str = Field()
    previous_attempt_url: Missing[Union[str, None]] = Field(default=UNSET)
    pull_requests: List[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItems
    ] = Field()
    referenced_workflows: Missing[
        Union[
            List[
                WebhookDeploymentReviewRequestedPropWorkflowRunPropReferencedWorkflowsItems
            ],
            None,
        ]
    ] = Field(default=UNSET)
    repository: Missing[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropRepository
    ] = Field(default=UNSET)
    rerun_url: Missing[str] = Field(default=UNSET)
    run_attempt: int = Field()
    run_number: int = Field()
    run_started_at: datetime = Field()
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting", "pending"
    ] = Field()
    triggering_actor: Union[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropTriggeringActor, None
    ] = Field(title="User")
    updated_at: datetime = Field()
    url: str = Field()
    workflow_id: int = Field()
    workflow_url: Missing[str] = Field(default=UNSET)
    display_title: str = Field()


class WebhookDeploymentStatusCreated(GitHubModel):
    """deployment_status created event"""

    action: Literal["created"] = Field()
    check_run: Missing[Union[WebhookDeploymentStatusCreatedPropCheckRun, None]] = Field(
        default=UNSET
    )
    deployment: WebhookDeploymentStatusCreatedPropDeployment = Field(
        title="Deployment",
        description="The [deployment](https://docs.github.com/rest/deployments/deployments#list-deployments).",
    )
    deployment_status: WebhookDeploymentStatusCreatedPropDeploymentStatus = Field(
        description="The [deployment status](https://docs.github.com/rest/deployments/statuses#list-deployment-statuses)."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )
    workflow: Missing[Union[WebhookDeploymentStatusCreatedPropWorkflow, None]] = Field(
        default=UNSET, title="Workflow"
    )
    workflow_run: Missing[
        Union[WebhookDeploymentStatusCreatedPropWorkflowRun, None]
    ] = Field(default=UNSET, title="Deployment Workflow Run")


class WebhookDeploymentStatusCreatedPropCheckRun(GitHubModel):
    """WebhookDeploymentStatusCreatedPropCheckRun"""

    completed_at: Union[datetime, None] = Field()
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ] = Field(
        description="The result of the completed check run. This value will be `null` until the check run has completed."
    )
    details_url: str = Field()
    external_id: str = Field()
    head_sha: str = Field(description="The SHA of the commit that is being checked.")
    html_url: str = Field()
    id: int = Field(description="The id of the check.")
    name: str = Field(description="The name of the check run.")
    node_id: str = Field()
    started_at: datetime = Field()
    status: Literal["queued", "in_progress", "completed", "waiting", "pending"] = Field(
        description="The current status of the check run. Can be `queued`, `in_progress`, or `completed`."
    )
    url: str = Field()


class WebhookDeploymentStatusCreatedPropDeployment(GitHubModel):
    """Deployment

    The [deployment](https://docs.github.com/rest/deployments/deployments#list-
    deployments).
    """

    created_at: str = Field()
    creator: Union[
        WebhookDeploymentStatusCreatedPropDeploymentPropCreator, None
    ] = Field(title="User")
    description: Union[str, None] = Field()
    environment: str = Field()
    id: int = Field()
    node_id: str = Field()
    original_environment: str = Field()
    payload: Union[
        str, WebhookDeploymentStatusCreatedPropDeploymentPropPayloadOneof1, None
    ] = Field()
    performed_via_github_app: Missing[
        Union[
            WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubApp, None
        ]
    ] = Field(
        default=UNSET,
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    production_environment: Missing[bool] = Field(default=UNSET)
    ref: str = Field()
    repository_url: str = Field()
    sha: str = Field()
    statuses_url: str = Field()
    task: str = Field()
    transient_environment: Missing[bool] = Field(default=UNSET)
    updated_at: str = Field()
    url: str = Field()


class WebhookDeploymentStatusCreatedPropDeploymentPropCreator(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropDeploymentPropPayloadOneof1(GitHubModel):
    """WebhookDeploymentStatusCreatedPropDeploymentPropPayloadOneof1"""


class WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropPermissions(
    GitHubModel
):
    """WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropPermiss
    ions

    The set of permissions for the GitHub app
    """

    actions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    administration: Missing[Literal["read", "write"]] = Field(default=UNSET)
    checks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    content_references: Missing[Literal["read", "write"]] = Field(default=UNSET)
    contents: Missing[Literal["read", "write"]] = Field(default=UNSET)
    deployments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    emails: Missing[Literal["read", "write"]] = Field(default=UNSET)
    environments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    issues: Missing[Literal["read", "write"]] = Field(default=UNSET)
    keys: Missing[Literal["read", "write"]] = Field(default=UNSET)
    members: Missing[Literal["read", "write"]] = Field(default=UNSET)
    metadata: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(default=UNSET)
    packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_events: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Missing[Literal["read", "write"]] = Field(default=UNSET)
    single_file: Missing[Literal["read", "write"]] = Field(default=UNSET)
    statuses: Missing[Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    workflows: Missing[Literal["read", "write"]] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubApp(
    GitHubModel
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "merge_queue_entry",
                "workflow_job",
                "pull_request_review_thread",
                "secret_scanning_alert_location",
                "merge_group",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookDeploymentStatusCreatedPropDeploymentStatus(GitHubModel):
    """WebhookDeploymentStatusCreatedPropDeploymentStatus

    The [deployment status](https://docs.github.com/rest/deployments/statuses#list-
    deployment-statuses).
    """

    created_at: str = Field()
    creator: Union[
        WebhookDeploymentStatusCreatedPropDeploymentStatusPropCreator, None
    ] = Field(title="User")
    deployment_url: str = Field()
    description: str = Field(
        description="The optional human-readable description added to the status."
    )
    environment: str = Field()
    environment_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    log_url: Missing[str] = Field(default=UNSET)
    node_id: str = Field()
    performed_via_github_app: Missing[
        Union[
            WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubApp,
            None,
        ]
    ] = Field(
        default=UNSET,
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    repository_url: str = Field()
    state: str = Field(
        description="The new state. Can be `pending`, `success`, `failure`, or `error`."
    )
    target_url: str = Field(description="The optional link added to the status.")
    updated_at: str = Field()
    url: str = Field()


class WebhookDeploymentStatusCreatedPropDeploymentStatusPropCreator(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropPermissions(
    GitHubModel
):
    """WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropP
    ermissions

    The set of permissions for the GitHub app
    """

    actions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    administration: Missing[Literal["read", "write"]] = Field(default=UNSET)
    checks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    content_references: Missing[Literal["read", "write"]] = Field(default=UNSET)
    contents: Missing[Literal["read", "write"]] = Field(default=UNSET)
    deployments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    emails: Missing[Literal["read", "write"]] = Field(default=UNSET)
    environments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    issues: Missing[Literal["read", "write"]] = Field(default=UNSET)
    keys: Missing[Literal["read", "write"]] = Field(default=UNSET)
    members: Missing[Literal["read", "write"]] = Field(default=UNSET)
    metadata: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(default=UNSET)
    packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_events: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Missing[Literal["read", "write"]] = Field(default=UNSET)
    single_file: Missing[Literal["read", "write"]] = Field(default=UNSET)
    statuses: Missing[Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    workflows: Missing[Literal["read", "write"]] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubApp(
    GitHubModel
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "merge_queue_entry",
                "workflow_job",
                "merge_group",
                "secret_scanning_alert_location",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookDeploymentStatusCreatedPropWorkflow(GitHubModel):
    """Workflow"""

    badge_url: str = Field()
    created_at: datetime = Field()
    html_url: str = Field()
    id: int = Field()
    name: str = Field()
    node_id: str = Field()
    path: str = Field()
    state: str = Field()
    updated_at: datetime = Field()
    url: str = Field()


class WebhookDeploymentStatusCreatedPropWorkflowRunPropActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepository(GitHubModel):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[None] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepositoryPropOwner(
    GitHubModel
):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItems(GitHubModel):
    """Check Run Pull Request"""

    base: WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBase = (
        Field()
    )
    head: WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHead = (
        Field()
    )
    id: int = Field()
    number: int = Field()
    url: str = Field()


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBase(
    GitHubModel
):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str = Field()
    repo: WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBasePropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHead(
    GitHubModel
):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str = Field()
    repo: WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo = Field(
        title="Repo Ref"
    )
    sha: str = Field()


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepo(
    GitHubModel
):
    """Repo Ref"""

    id: int = Field()
    name: str = Field()
    url: str = Field()


class WebhookDeploymentStatusCreatedPropWorkflowRunPropReferencedWorkflowsItems(
    GitHubModel
):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str = Field()
    ref: Missing[str] = Field(default=UNSET)
    sha: str = Field()


class WebhookDeploymentStatusCreatedPropWorkflowRunPropRepository(GitHubModel):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropRepository"""

    archive_url: Missing[str] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[None] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[bool] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    owner: Missing[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropRepositoryPropOwner
    ] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropWorkflowRunPropRepositoryPropOwner(GitHubModel):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropWorkflowRunPropTriggeringActor(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDeploymentStatusCreatedPropWorkflowRun(GitHubModel):
    """Deployment Workflow Run"""

    actor: Union[WebhookDeploymentStatusCreatedPropWorkflowRunPropActor, None] = Field(
        title="User"
    )
    artifacts_url: Missing[str] = Field(default=UNSET)
    cancel_url: Missing[str] = Field(default=UNSET)
    check_suite_id: int = Field()
    check_suite_node_id: str = Field()
    check_suite_url: Missing[str] = Field(default=UNSET)
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "startup_failure",
        ],
    ] = Field()
    created_at: datetime = Field()
    display_title: str = Field()
    event: str = Field()
    head_branch: str = Field()
    head_commit: Missing[None] = Field(default=UNSET)
    head_repository: Missing[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepository
    ] = Field(default=UNSET)
    head_sha: str = Field()
    html_url: str = Field()
    id: int = Field()
    jobs_url: Missing[str] = Field(default=UNSET)
    logs_url: Missing[str] = Field(default=UNSET)
    name: str = Field()
    node_id: str = Field()
    path: str = Field()
    previous_attempt_url: Missing[None] = Field(default=UNSET)
    pull_requests: List[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItems
    ] = Field()
    referenced_workflows: Missing[
        Union[
            List[
                WebhookDeploymentStatusCreatedPropWorkflowRunPropReferencedWorkflowsItems
            ],
            None,
        ]
    ] = Field(default=UNSET)
    repository: Missing[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropRepository
    ] = Field(default=UNSET)
    rerun_url: Missing[str] = Field(default=UNSET)
    run_attempt: int = Field()
    run_number: int = Field()
    run_started_at: datetime = Field()
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting", "pending"
    ] = Field()
    triggering_actor: Union[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropTriggeringActor, None
    ] = Field(title="User")
    updated_at: datetime = Field()
    url: str = Field()
    workflow_id: int = Field()
    workflow_url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionAnswered(GitHubModel):
    """discussion answered event"""

    action: Literal["answered"] = Field()
    answer: WebhookDiscussionAnsweredPropAnswer = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionAnsweredPropAnswer(GitHubModel):
    """WebhookDiscussionAnsweredPropAnswer"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field()
    child_comment_count: int = Field()
    created_at: datetime = Field()
    discussion_id: int = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    parent_id: None = Field()
    reactions: Missing[WebhookDiscussionAnsweredPropAnswerPropReactions] = Field(
        default=UNSET, title="Reactions"
    )
    repository_url: str = Field()
    updated_at: datetime = Field()
    user: Union[WebhookDiscussionAnsweredPropAnswerPropUser, None] = Field(title="User")


class WebhookDiscussionAnsweredPropAnswerPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookDiscussionAnsweredPropAnswerPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionCategoryChanged(GitHubModel):
    """discussion category changed event"""

    action: Literal["category_changed"] = Field()
    changes: WebhookDiscussionCategoryChangedPropChanges = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionCategoryChangedPropChanges(GitHubModel):
    """WebhookDiscussionCategoryChangedPropChanges"""

    category: WebhookDiscussionCategoryChangedPropChangesPropCategory = Field()


class WebhookDiscussionCategoryChangedPropChangesPropCategory(GitHubModel):
    """WebhookDiscussionCategoryChangedPropChangesPropCategory"""

    from_: WebhookDiscussionCategoryChangedPropChangesPropCategoryPropFrom = Field(
        alias="from"
    )


class WebhookDiscussionCategoryChangedPropChangesPropCategoryPropFrom(GitHubModel):
    """WebhookDiscussionCategoryChangedPropChangesPropCategoryPropFrom"""

    created_at: datetime = Field()
    description: str = Field()
    emoji: str = Field()
    id: int = Field()
    is_answerable: bool = Field()
    name: str = Field()
    node_id: Missing[str] = Field(default=UNSET)
    repository_id: int = Field()
    slug: str = Field()
    updated_at: str = Field()


class WebhookDiscussionClosed(GitHubModel):
    """discussion closed event"""

    action: Literal["closed"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionCommentCreated(GitHubModel):
    """discussion_comment created event"""

    action: Literal["created"] = Field()
    comment: WebhookDiscussionCommentCreatedPropComment = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionCommentCreatedPropComment(GitHubModel):
    """WebhookDiscussionCommentCreatedPropComment"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field()
    child_comment_count: int = Field()
    created_at: str = Field()
    discussion_id: int = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    parent_id: Union[int, None] = Field()
    reactions: WebhookDiscussionCommentCreatedPropCommentPropReactions = Field(
        title="Reactions"
    )
    repository_url: str = Field()
    updated_at: str = Field()
    user: Union[WebhookDiscussionCommentCreatedPropCommentPropUser, None] = Field(
        title="User"
    )


class WebhookDiscussionCommentCreatedPropCommentPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookDiscussionCommentCreatedPropCommentPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionCommentDeleted(GitHubModel):
    """discussion_comment deleted event"""

    action: Literal["deleted"] = Field()
    comment: WebhookDiscussionCommentDeletedPropComment = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionCommentDeletedPropComment(GitHubModel):
    """WebhookDiscussionCommentDeletedPropComment"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field()
    child_comment_count: int = Field()
    created_at: str = Field()
    discussion_id: int = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    parent_id: Union[int, None] = Field()
    reactions: WebhookDiscussionCommentDeletedPropCommentPropReactions = Field(
        title="Reactions"
    )
    repository_url: str = Field()
    updated_at: str = Field()
    user: Union[WebhookDiscussionCommentDeletedPropCommentPropUser, None] = Field(
        title="User"
    )


class WebhookDiscussionCommentDeletedPropCommentPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookDiscussionCommentDeletedPropCommentPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionCommentEdited(GitHubModel):
    """discussion_comment edited event"""

    action: Literal["edited"] = Field()
    changes: WebhookDiscussionCommentEditedPropChanges = Field()
    comment: WebhookDiscussionCommentEditedPropComment = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionCommentEditedPropChanges(GitHubModel):
    """WebhookDiscussionCommentEditedPropChanges"""

    body: WebhookDiscussionCommentEditedPropChangesPropBody = Field()


class WebhookDiscussionCommentEditedPropChangesPropBody(GitHubModel):
    """WebhookDiscussionCommentEditedPropChangesPropBody"""

    from_: str = Field(alias="from")


class WebhookDiscussionCommentEditedPropComment(GitHubModel):
    """WebhookDiscussionCommentEditedPropComment"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field()
    child_comment_count: int = Field()
    created_at: str = Field()
    discussion_id: int = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    parent_id: Union[int, None] = Field()
    reactions: WebhookDiscussionCommentEditedPropCommentPropReactions = Field(
        title="Reactions"
    )
    repository_url: str = Field()
    updated_at: str = Field()
    user: Union[WebhookDiscussionCommentEditedPropCommentPropUser, None] = Field(
        title="User"
    )


class WebhookDiscussionCommentEditedPropCommentPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookDiscussionCommentEditedPropCommentPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionCreated(GitHubModel):
    """discussion created event"""

    action: Literal["created"] = Field()
    discussion: WebhookDiscussionCreatedPropDiscussion = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionCreatedPropDiscussion(GitHubModel):
    """WebhookDiscussionCreatedPropDiscussion"""

    active_lock_reason: Union[None, None] = Field()
    answer_chosen_at: Union[None, None] = Field()
    answer_chosen_by: Union[None, None] = Field()
    answer_html_url: Union[Union[str, None], None] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: Union[Union[str, None], None] = Field()
    category: WebhookDiscussionCreatedPropDiscussionMergedCategory = Field()
    comments: int = Field()
    created_at: datetime = Field()
    html_url: str = Field()
    id: int = Field()
    locked: Literal[False] = Field()
    node_id: str = Field()
    number: int = Field()
    reactions: Missing[WebhookDiscussionCreatedPropDiscussionMergedReactions] = Field(
        default=UNSET
    )
    repository_url: str = Field()
    state: Literal["open", "converting", "transferring"] = Field()
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field()
    updated_at: datetime = Field()
    user: WebhookDiscussionCreatedPropDiscussionMergedUser = Field()


class WebhookDiscussionCreatedPropDiscussionAllof0(GitHubModel):
    """Discussion"""

    active_lock_reason: Union[str, None] = Field()
    answer_chosen_at: Union[str, None] = Field()
    answer_chosen_by: Union[
        WebhookDiscussionCreatedPropDiscussionAllof0PropAnswerChosenBy, None
    ] = Field(title="User")
    answer_html_url: Union[str, None] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: Union[str, None] = Field()
    category: WebhookDiscussionCreatedPropDiscussionAllof0PropCategory = Field()
    comments: int = Field()
    created_at: datetime = Field()
    html_url: str = Field()
    id: int = Field()
    locked: bool = Field()
    node_id: str = Field()
    number: int = Field()
    reactions: Missing[
        WebhookDiscussionCreatedPropDiscussionAllof0PropReactions
    ] = Field(default=UNSET, title="Reactions")
    repository_url: str = Field()
    state: Literal["open", "locked", "converting", "transferring"] = Field()
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field()
    updated_at: datetime = Field()
    user: Union[WebhookDiscussionCreatedPropDiscussionAllof0PropUser, None] = Field(
        title="User"
    )


class WebhookDiscussionCreatedPropDiscussionAllof0PropAnswerChosenBy(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionCreatedPropDiscussionAllof0PropCategory(GitHubModel):
    """WebhookDiscussionCreatedPropDiscussionAllof0PropCategory"""

    created_at: datetime = Field()
    description: str = Field()
    emoji: str = Field()
    id: int = Field()
    is_answerable: bool = Field()
    name: str = Field()
    node_id: Missing[str] = Field(default=UNSET)
    repository_id: int = Field()
    slug: str = Field()
    updated_at: str = Field()


class WebhookDiscussionCreatedPropDiscussionAllof0PropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookDiscussionCreatedPropDiscussionAllof0PropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionCreatedPropDiscussionAllof1(GitHubModel):
    """WebhookDiscussionCreatedPropDiscussionAllof1"""

    active_lock_reason: Missing[None] = Field(default=UNSET)
    answer_chosen_at: None = Field()
    answer_chosen_by: None = Field()
    answer_html_url: Union[str, None] = Field()
    author_association: Missing[str] = Field(default=UNSET)
    body: Missing[Union[str, None]] = Field(default=UNSET)
    category: Missing[WebhookDiscussionCreatedPropDiscussionAllof1PropCategory] = Field(
        default=UNSET
    )
    comments: Missing[int] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    locked: Literal[False] = Field()
    node_id: Missing[str] = Field(default=UNSET)
    number: Missing[int] = Field(default=UNSET)
    reactions: Missing[
        WebhookDiscussionCreatedPropDiscussionAllof1PropReactions
    ] = Field(default=UNSET)
    repository_url: Missing[str] = Field(default=UNSET)
    state: Literal["open", "converting", "transferring"] = Field()
    timeline_url: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    user: Missing[WebhookDiscussionCreatedPropDiscussionAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookDiscussionCreatedPropDiscussionAllof1PropCategory(GitHubModel):
    """WebhookDiscussionCreatedPropDiscussionAllof1PropCategory"""

    created_at: Missing[str] = Field(default=UNSET)
    description: Missing[str] = Field(default=UNSET)
    emoji: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    is_answerable: Missing[bool] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    repository_id: Missing[int] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)


class WebhookDiscussionCreatedPropDiscussionAllof1PropReactions(GitHubModel):
    """WebhookDiscussionCreatedPropDiscussionAllof1PropReactions"""

    plus_one: Missing[int] = Field(default=UNSET, alias="+1")
    minus_one: Missing[int] = Field(default=UNSET, alias="-1")
    confused: Missing[int] = Field(default=UNSET)
    eyes: Missing[int] = Field(default=UNSET)
    heart: Missing[int] = Field(default=UNSET)
    hooray: Missing[int] = Field(default=UNSET)
    laugh: Missing[int] = Field(default=UNSET)
    rocket: Missing[int] = Field(default=UNSET)
    total_count: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionCreatedPropDiscussionAllof1PropUser(GitHubModel):
    """WebhookDiscussionCreatedPropDiscussionAllof1PropUser"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionCreatedPropDiscussionMergedCategory(GitHubModel):
    """WebhookDiscussionCreatedPropDiscussionMergedCategory"""

    created_at: datetime = Field()
    description: str = Field()
    emoji: str = Field()
    id: int = Field()
    is_answerable: bool = Field()
    name: str = Field()
    node_id: Missing[str] = Field(default=UNSET)
    repository_id: int = Field()
    slug: str = Field()
    updated_at: str = Field()


class WebhookDiscussionCreatedPropDiscussionMergedReactions(GitHubModel):
    """WebhookDiscussionCreatedPropDiscussionMergedReactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookDiscussionCreatedPropDiscussionMergedUser(GitHubModel):
    """WebhookDiscussionCreatedPropDiscussionMergedUser"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionDeleted(GitHubModel):
    """discussion deleted event"""

    action: Literal["deleted"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionEdited(GitHubModel):
    """discussion edited event"""

    action: Literal["edited"] = Field()
    changes: Missing[WebhookDiscussionEditedPropChanges] = Field(default=UNSET)
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionEditedPropChanges(GitHubModel):
    """WebhookDiscussionEditedPropChanges"""

    body: Missing[WebhookDiscussionEditedPropChangesPropBody] = Field(default=UNSET)
    title: Missing[WebhookDiscussionEditedPropChangesPropTitle] = Field(default=UNSET)


class WebhookDiscussionEditedPropChangesPropBody(GitHubModel):
    """WebhookDiscussionEditedPropChangesPropBody"""

    from_: str = Field(alias="from")


class WebhookDiscussionEditedPropChangesPropTitle(GitHubModel):
    """WebhookDiscussionEditedPropChangesPropTitle"""

    from_: str = Field(alias="from")


class WebhookDiscussionLabeled(GitHubModel):
    """discussion labeled event"""

    action: Literal["labeled"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    label: WebhookDiscussionLabeledPropLabel = Field(title="Label")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionLabeledPropLabel(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookDiscussionLocked(GitHubModel):
    """discussion locked event"""

    action: Literal["locked"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionPinned(GitHubModel):
    """discussion pinned event"""

    action: Literal["pinned"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionReopened(GitHubModel):
    """discussion reopened event"""

    action: Literal["reopened"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionTransferred(GitHubModel):
    """discussion transferred event"""

    action: Literal["transferred"] = Field()
    changes: WebhookDiscussionTransferredPropChanges = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionTransferredPropChanges(GitHubModel):
    """WebhookDiscussionTransferredPropChanges"""

    new_discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    new_repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )


class WebhookDiscussionUnanswered(GitHubModel):
    """discussion unanswered event"""

    action: Literal["unanswered"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    old_answer: WebhookDiscussionUnansweredPropOldAnswer = Field()
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: Missing[SimpleUserWebhooks] = Field(
        default=UNSET,
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionUnansweredPropOldAnswer(GitHubModel):
    """WebhookDiscussionUnansweredPropOldAnswer"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field()
    child_comment_count: int = Field()
    created_at: datetime = Field()
    discussion_id: int = Field()
    html_url: str = Field()
    id: int = Field()
    node_id: str = Field()
    parent_id: None = Field()
    reactions: Missing[WebhookDiscussionUnansweredPropOldAnswerPropReactions] = Field(
        default=UNSET, title="Reactions"
    )
    repository_url: str = Field()
    updated_at: datetime = Field()
    user: Union[WebhookDiscussionUnansweredPropOldAnswerPropUser, None] = Field(
        title="User"
    )


class WebhookDiscussionUnansweredPropOldAnswerPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookDiscussionUnansweredPropOldAnswerPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookDiscussionUnlabeled(GitHubModel):
    """discussion unlabeled event"""

    action: Literal["unlabeled"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    label: WebhookDiscussionUnlabeledPropLabel = Field(title="Label")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionUnlabeledPropLabel(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookDiscussionUnlocked(GitHubModel):
    """discussion unlocked event"""

    action: Literal["unlocked"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookDiscussionUnpinned(GitHubModel):
    """discussion unpinned event"""

    action: Literal["unpinned"] = Field()
    discussion: Discussion = Field(
        title="Discussion", description="A Discussion in a repository."
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookFork(GitHubModel):
    """fork event

    A user forks a repository.
    """

    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    forkee: WebhookForkPropForkee = Field(
        description="The created [`repository`](https://docs.github.com/rest/repos/repos#get-a-repository) resource."
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookForkPropForkee(GitHubModel):
    """WebhookForkPropForkee

    The created [`repository`](https://docs.github.com/rest/repos/repos#get-a-
    repository) resource.
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: datetime = Field()
    custom_properties: Missing[WebhookForkPropForkeeAllof0PropCustomProperties] = Field(
        default=UNSET,
        description="The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.",
    )
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[Union[str, None], None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: Literal[True] = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    homepage: Union[Union[str, None], None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[None, None] = Field()
    languages_url: str = Field()
    license_: Union[WebhookForkPropForkeeMergedLicense, None] = Field(alias="license")
    master_branch: Missing[str] = Field(default=UNSET)
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[None, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: WebhookForkPropForkeeMergedOwner = Field()
    permissions: Missing[WebhookForkPropForkeeAllof0PropPermissions] = Field(
        default=UNSET
    )
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: datetime = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: List[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhookForkPropForkeeAllof0(GitHubModel):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, datetime] = Field()
    custom_properties: Missing[WebhookForkPropForkeeAllof0PropCustomProperties] = Field(
        default=UNSET,
        description="The custom properties that were defined for the repository. The keys are the custom property names, and the values are the corresponding custom property values.",
    )
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[WebhookForkPropForkeeAllof0PropLicense, None] = Field(
        alias="license", title="License"
    )
    master_branch: Missing[str] = Field(default=UNSET)
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[WebhookForkPropForkeeAllof0PropOwner, None] = Field(title="User")
    permissions: Missing[WebhookForkPropForkeeAllof0PropPermissions] = Field(
        default=UNSET
    )
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: List[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhookForkPropForkeeAllof0PropCustomProperties(ExtraGitHubModel):
    """WebhookForkPropForkeeAllof0PropCustomProperties

    The custom properties that were defined for the repository. The keys are the
    custom property names, and the values are the corresponding custom property
    values.
    """


class WebhookForkPropForkeeAllof0PropLicense(GitHubModel):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookForkPropForkeeAllof0PropOwner(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookForkPropForkeeAllof0PropPermissions(GitHubModel):
    """WebhookForkPropForkeeAllof0PropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhookForkPropForkeeAllof1(GitHubModel):
    """WebhookForkPropForkeeAllof1"""

    allow_forking: Missing[bool] = Field(default=UNSET)
    archive_url: Missing[str] = Field(default=UNSET)
    archived: Missing[bool] = Field(default=UNSET)
    assignees_url: Missing[str] = Field(default=UNSET)
    blobs_url: Missing[str] = Field(default=UNSET)
    branches_url: Missing[str] = Field(default=UNSET)
    clone_url: Missing[str] = Field(default=UNSET)
    collaborators_url: Missing[str] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    commits_url: Missing[str] = Field(default=UNSET)
    compare_url: Missing[str] = Field(default=UNSET)
    contents_url: Missing[str] = Field(default=UNSET)
    contributors_url: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    default_branch: Missing[str] = Field(default=UNSET)
    deployments_url: Missing[str] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(default=UNSET)
    disabled: Missing[bool] = Field(default=UNSET)
    downloads_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    fork: Missing[Literal[True]] = Field(default=UNSET)
    forks: Missing[int] = Field(default=UNSET)
    forks_count: Missing[int] = Field(default=UNSET)
    forks_url: Missing[str] = Field(default=UNSET)
    full_name: Missing[str] = Field(default=UNSET)
    git_commits_url: Missing[str] = Field(default=UNSET)
    git_refs_url: Missing[str] = Field(default=UNSET)
    git_tags_url: Missing[str] = Field(default=UNSET)
    git_url: Missing[str] = Field(default=UNSET)
    has_downloads: Missing[bool] = Field(default=UNSET)
    has_issues: Missing[bool] = Field(default=UNSET)
    has_pages: Missing[bool] = Field(default=UNSET)
    has_projects: Missing[bool] = Field(default=UNSET)
    has_wiki: Missing[bool] = Field(default=UNSET)
    homepage: Missing[Union[str, None]] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: Missing[str] = Field(default=UNSET)
    issue_events_url: Missing[str] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    keys_url: Missing[str] = Field(default=UNSET)
    labels_url: Missing[str] = Field(default=UNSET)
    language: Missing[None] = Field(default=UNSET)
    languages_url: Missing[str] = Field(default=UNSET)
    license_: Missing[Union[WebhookForkPropForkeeAllof1PropLicense, None]] = Field(
        default=UNSET, alias="license"
    )
    merges_url: Missing[str] = Field(default=UNSET)
    milestones_url: Missing[str] = Field(default=UNSET)
    mirror_url: Missing[None] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    notifications_url: Missing[str] = Field(default=UNSET)
    open_issues: Missing[int] = Field(default=UNSET)
    open_issues_count: Missing[int] = Field(default=UNSET)
    owner: Missing[WebhookForkPropForkeeAllof1PropOwner] = Field(default=UNSET)
    private: Missing[bool] = Field(default=UNSET)
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: Missing[str] = Field(default=UNSET)
    pushed_at: Missing[str] = Field(default=UNSET)
    releases_url: Missing[str] = Field(default=UNSET)
    size: Missing[int] = Field(default=UNSET)
    ssh_url: Missing[str] = Field(default=UNSET)
    stargazers_count: Missing[int] = Field(default=UNSET)
    stargazers_url: Missing[str] = Field(default=UNSET)
    statuses_url: Missing[str] = Field(default=UNSET)
    subscribers_url: Missing[str] = Field(default=UNSET)
    subscription_url: Missing[str] = Field(default=UNSET)
    svn_url: Missing[str] = Field(default=UNSET)
    tags_url: Missing[str] = Field(default=UNSET)
    teams_url: Missing[str] = Field(default=UNSET)
    topics: Missing[List[Union[str, None]]] = Field(default=UNSET)
    trees_url: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    visibility: Missing[str] = Field(default=UNSET)
    watchers: Missing[int] = Field(default=UNSET)
    watchers_count: Missing[int] = Field(default=UNSET)


class WebhookForkPropForkeeAllof1PropLicense(GitHubModel):
    """WebhookForkPropForkeeAllof1PropLicense"""


class WebhookForkPropForkeeAllof1PropOwner(GitHubModel):
    """WebhookForkPropForkeeAllof1PropOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookForkPropForkeeMergedLicense(GitHubModel):
    """WebhookForkPropForkeeMergedLicense"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookForkPropForkeeMergedOwner(GitHubModel):
    """WebhookForkPropForkeeMergedOwner"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookGithubAppAuthorizationRevoked(GitHubModel):
    """github_app_authorization revoked event"""

    action: Literal["revoked"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookGollum(GitHubModel):
    """gollum event"""

    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    pages: List[WebhookGollumPropPagesItems] = Field(
        description="The pages that were updated."
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookGollumPropPagesItems(GitHubModel):
    """WebhookGollumPropPagesItems"""

    action: Literal["created", "edited"] = Field(
        description="The action that was performed on the page. Can be `created` or `edited`."
    )
    html_url: str = Field(description="Points to the HTML wiki page.")
    page_name: str = Field(description="The name of the page.")
    sha: str = Field(description="The latest commit SHA of the page.")
    summary: Union[str, None] = Field()
    title: str = Field(description="The current page title.")


class WebhookInstallationCreated(GitHubModel):
    """installation created event"""

    action: Literal["created"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Installation = Field(title="Installation", description="Installation")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repositories: Missing[
        List[WebhookInstallationCreatedPropRepositoriesItems]
    ] = Field(
        default=UNSET,
        description="An array of repository objects that the installation can access.",
    )
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    requester: Missing[Union[WebhookInstallationCreatedPropRequester, None]] = Field(
        default=UNSET, title="User"
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookInstallationCreatedPropRepositoriesItems(GitHubModel):
    """WebhookInstallationCreatedPropRepositoriesItems"""

    full_name: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    private: bool = Field(description="Whether the repository is private or public.")


class WebhookInstallationCreatedPropRequester(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookInstallationDeleted(GitHubModel):
    """installation deleted event"""

    action: Literal["deleted"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Installation = Field(title="Installation", description="Installation")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repositories: Missing[
        List[WebhookInstallationDeletedPropRepositoriesItems]
    ] = Field(
        default=UNSET,
        description="An array of repository objects that the installation can access.",
    )
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    requester: Missing[None] = Field(default=UNSET)
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookInstallationDeletedPropRepositoriesItems(GitHubModel):
    """WebhookInstallationDeletedPropRepositoriesItems"""

    full_name: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    private: bool = Field(description="Whether the repository is private or public.")


class WebhookInstallationNewPermissionsAccepted(GitHubModel):
    """installation new_permissions_accepted event"""

    action: Literal["new_permissions_accepted"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Installation = Field(title="Installation", description="Installation")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repositories: Missing[
        List[WebhookInstallationNewPermissionsAcceptedPropRepositoriesItems]
    ] = Field(
        default=UNSET,
        description="An array of repository objects that the installation can access.",
    )
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    requester: Missing[None] = Field(default=UNSET)
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookInstallationNewPermissionsAcceptedPropRepositoriesItems(GitHubModel):
    """WebhookInstallationNewPermissionsAcceptedPropRepositoriesItems"""

    full_name: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    private: bool = Field(description="Whether the repository is private or public.")


class WebhookInstallationRepositoriesAdded(GitHubModel):
    """installation_repositories added event"""

    action: Literal["added"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Installation = Field(title="Installation", description="Installation")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repositories_added: List[
        WebhookInstallationRepositoriesAddedPropRepositoriesAddedItems
    ] = Field(
        description="An array of repository objects, which were added to the installation."
    )
    repositories_removed: List[
        WebhookInstallationRepositoriesAddedPropRepositoriesRemovedItems
    ] = Field(
        description="An array of repository objects, which were removed from the installation."
    )
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved"
    )
    requester: Union[WebhookInstallationRepositoriesAddedPropRequester, None] = Field(
        title="User"
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookInstallationRepositoriesAddedPropRepositoriesAddedItems(GitHubModel):
    """WebhookInstallationRepositoriesAddedPropRepositoriesAddedItems"""

    full_name: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    private: bool = Field(description="Whether the repository is private or public.")


class WebhookInstallationRepositoriesAddedPropRepositoriesRemovedItems(GitHubModel):
    """WebhookInstallationRepositoriesAddedPropRepositoriesRemovedItems"""

    full_name: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(
        default=UNSET, description="Unique identifier of the repository"
    )
    name: Missing[str] = Field(default=UNSET, description="The name of the repository.")
    node_id: Missing[str] = Field(default=UNSET)
    private: Missing[bool] = Field(
        default=UNSET, description="Whether the repository is private or public."
    )


class WebhookInstallationRepositoriesAddedPropRequester(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookInstallationRepositoriesRemoved(GitHubModel):
    """installation_repositories removed event"""

    action: Literal["removed"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Installation = Field(title="Installation", description="Installation")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repositories_added: List[
        WebhookInstallationRepositoriesRemovedPropRepositoriesAddedItems
    ] = Field(
        description="An array of repository objects, which were added to the installation."
    )
    repositories_removed: List[
        WebhookInstallationRepositoriesRemovedPropRepositoriesRemovedItems
    ] = Field(
        description="An array of repository objects, which were removed from the installation."
    )
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    repository_selection: Literal["all", "selected"] = Field(
        description="Describe whether all repositories have been selected or there's a selection involved"
    )
    requester: Union[WebhookInstallationRepositoriesRemovedPropRequester, None] = Field(
        title="User"
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookInstallationRepositoriesRemovedPropRepositoriesAddedItems(GitHubModel):
    """WebhookInstallationRepositoriesRemovedPropRepositoriesAddedItems"""

    full_name: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    private: bool = Field(description="Whether the repository is private or public.")


class WebhookInstallationRepositoriesRemovedPropRepositoriesRemovedItems(GitHubModel):
    """WebhookInstallationRepositoriesRemovedPropRepositoriesRemovedItems"""

    full_name: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    private: bool = Field(description="Whether the repository is private or public.")


class WebhookInstallationRepositoriesRemovedPropRequester(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookInstallationSuspend(GitHubModel):
    """installation suspend event"""

    action: Literal["suspend"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Installation = Field(title="Installation", description="Installation")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repositories: Missing[
        List[WebhookInstallationSuspendPropRepositoriesItems]
    ] = Field(
        default=UNSET,
        description="An array of repository objects that the installation can access.",
    )
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    requester: Missing[None] = Field(default=UNSET)
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookInstallationSuspendPropRepositoriesItems(GitHubModel):
    """WebhookInstallationSuspendPropRepositoriesItems"""

    full_name: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    private: bool = Field(description="Whether the repository is private or public.")


class WebhookInstallationTargetRenamed(GitHubModel):
    """WebhookInstallationTargetRenamed"""

    account: WebhookInstallationTargetRenamedPropAccount = Field()
    action: Literal["renamed"] = Field()
    changes: WebhookInstallationTargetRenamedPropChanges = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: SimpleInstallation = Field(
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: Missing[SimpleUserWebhooks] = Field(
        default=UNSET,
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )
    target_type: str = Field()


class WebhookInstallationTargetRenamedPropAccount(GitHubModel):
    """WebhookInstallationTargetRenamedPropAccount"""

    archived_at: Missing[Union[str, None]] = Field(default=UNSET)
    avatar_url: str = Field()
    created_at: Missing[str] = Field(default=UNSET)
    description: Missing[None] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers: Missing[int] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following: Missing[int] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    has_organization_projects: Missing[bool] = Field(default=UNSET)
    has_repository_projects: Missing[bool] = Field(default=UNSET)
    hooks_url: Missing[str] = Field(default=UNSET)
    html_url: str = Field()
    id: int = Field()
    is_verified: Missing[bool] = Field(default=UNSET)
    issues_url: Missing[str] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    members_url: Missing[str] = Field(default=UNSET)
    name: Missing[str] = Field(default=UNSET)
    node_id: str = Field()
    organizations_url: Missing[str] = Field(default=UNSET)
    public_gists: Missing[int] = Field(default=UNSET)
    public_members_url: Missing[str] = Field(default=UNSET)
    public_repos: Missing[int] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    website_url: Missing[None] = Field(default=UNSET)


class WebhookInstallationTargetRenamedPropChanges(GitHubModel):
    """WebhookInstallationTargetRenamedPropChanges"""

    login: Missing[WebhookInstallationTargetRenamedPropChangesPropLogin] = Field(
        default=UNSET
    )
    slug: Missing[WebhookInstallationTargetRenamedPropChangesPropSlug] = Field(
        default=UNSET
    )


class WebhookInstallationTargetRenamedPropChangesPropLogin(GitHubModel):
    """WebhookInstallationTargetRenamedPropChangesPropLogin"""

    from_: str = Field(alias="from")


class WebhookInstallationTargetRenamedPropChangesPropSlug(GitHubModel):
    """WebhookInstallationTargetRenamedPropChangesPropSlug"""

    from_: str = Field(alias="from")


class WebhookInstallationUnsuspend(GitHubModel):
    """installation unsuspend event"""

    action: Literal["unsuspend"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Installation = Field(title="Installation", description="Installation")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repositories: Missing[
        List[WebhookInstallationUnsuspendPropRepositoriesItems]
    ] = Field(
        default=UNSET,
        description="An array of repository objects that the installation can access.",
    )
    repository: Missing[RepositoryWebhooks] = Field(
        default=UNSET,
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    requester: Missing[None] = Field(default=UNSET)
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookInstallationUnsuspendPropRepositoriesItems(GitHubModel):
    """WebhookInstallationUnsuspendPropRepositoriesItems"""

    full_name: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    private: bool = Field(description="Whether the repository is private or public.")


class WebhookIssueCommentCreated(GitHubModel):
    """issue_comment created event"""

    action: Literal["created"] = Field()
    comment: WebhookIssueCommentCreatedPropComment = Field(
        title="issue comment",
        description="The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment) itself.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    issue: WebhookIssueCommentCreatedPropIssue = Field(
        description="The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment belongs to."
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookIssueCommentCreatedPropComment(GitHubModel):
    """issue comment

    The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment)
    itself.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field(description="Contents of the issue comment")
    created_at: datetime = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the issue comment")
    issue_url: str = Field()
    node_id: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    reactions: WebhookIssueCommentCreatedPropCommentPropReactions = Field(
        title="Reactions"
    )
    updated_at: datetime = Field()
    url: str = Field(description="URL for the issue comment")
    user: Union[WebhookIssueCommentCreatedPropCommentPropUser, None] = Field(
        title="User"
    )


class WebhookIssueCommentCreatedPropCommentPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookIssueCommentCreatedPropCommentPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssue(GitHubModel):
    """WebhookIssueCommentCreatedPropIssue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment
    belongs to.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field()
    assignee: Union[
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropAssignee, None], None
    ] = Field(title="User")
    assignees: List[WebhookIssueCommentCreatedPropIssueMergedAssignees] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: Union[Union[str, None], None] = Field(description="Contents of the issue")
    closed_at: Union[datetime, None] = Field()
    comments: int = Field()
    comments_url: str = Field()
    created_at: datetime = Field()
    draft: Missing[bool] = Field(default=UNSET)
    events_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    labels: List[WebhookIssueCommentCreatedPropIssueAllof0PropLabelsItems] = Field()
    labels_url: str = Field()
    locked: bool = Field()
    milestone: Union[WebhookIssueCommentCreatedPropIssueMergedMilestone, None] = Field()
    node_id: str = Field()
    number: int = Field()
    performed_via_github_app: Missing[
        Union[WebhookIssueCommentCreatedPropIssueMergedPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    pull_request: Missing[
        WebhookIssueCommentCreatedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentCreatedPropIssueMergedReactions = Field()
    repository_url: str = Field()
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'"
    )
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue")
    updated_at: datetime = Field()
    url: str = Field(description="URL for the issue")
    user: WebhookIssueCommentCreatedPropIssueMergedUser = Field()


class WebhookIssueCommentCreatedPropIssueAllof0(GitHubModel):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field()
    assignee: Missing[
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropAssignee, None]
    ] = Field(default=UNSET, title="User")
    assignees: List[
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropAssigneesItems, None]
    ] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: Union[str, None] = Field(description="Contents of the issue")
    closed_at: Union[datetime, None] = Field()
    comments: int = Field()
    comments_url: str = Field()
    created_at: datetime = Field()
    draft: Missing[bool] = Field(default=UNSET)
    events_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    labels: Missing[
        List[WebhookIssueCommentCreatedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field()
    locked: Missing[bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    node_id: str = Field()
    number: int = Field()
    performed_via_github_app: Missing[
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubApp, None]
    ] = Field(
        default=UNSET,
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    pull_request: Missing[
        WebhookIssueCommentCreatedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentCreatedPropIssueAllof0PropReactions = Field(
        title="Reactions"
    )
    repository_url: str = Field()
    state: Missing[Literal["open", "closed"]] = Field(
        default=UNSET, description="State of the issue; either 'open' or 'closed'"
    )
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue")
    updated_at: datetime = Field()
    url: str = Field(description="URL for the issue")
    user: Union[WebhookIssueCommentCreatedPropIssueAllof0PropUser, None] = Field(
        title="User"
    )


class WebhookIssueCommentCreatedPropIssueAllof0PropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropAssigneesItems(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookIssueCommentCreatedPropIssueAllof0PropMilestonePropCreator(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropMilestone(GitHubModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubModel
):
    """WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermission
    s

    The set of permissions for the GitHub app
    """

    actions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    administration: Missing[Literal["read", "write"]] = Field(default=UNSET)
    checks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    content_references: Missing[Literal["read", "write"]] = Field(default=UNSET)
    contents: Missing[Literal["read", "write"]] = Field(default=UNSET)
    deployments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    emails: Missing[Literal["read", "write"]] = Field(default=UNSET)
    environments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    issues: Missing[Literal["read", "write"]] = Field(default=UNSET)
    keys: Missing[Literal["read", "write"]] = Field(default=UNSET)
    members: Missing[Literal["read", "write"]] = Field(default=UNSET)
    metadata: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(default=UNSET)
    packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_events: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Missing[Literal["read", "write"]] = Field(default=UNSET)
    single_file: Missing[Literal["read", "write"]] = Field(default=UNSET)
    statuses: Missing[Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    workflows: Missing[Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubApp(GitHubModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookIssueCommentCreatedPropIssueAllof0PropPullRequest(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueAllof0PropPullRequest"""

    diff_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    merged_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    patch_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof0PropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookIssueCommentCreatedPropIssueAllof0PropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof1(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueAllof1"""

    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    assignee: Union[
        WebhookIssueCommentCreatedPropIssueAllof1PropAssignee, None
    ] = Field(title="User")
    assignees: Missing[
        List[Union[WebhookIssueCommentCreatedPropIssueAllof1PropAssigneesItems, None]]
    ] = Field(default=UNSET)
    author_association: Missing[str] = Field(default=UNSET)
    body: Missing[Union[str, None]] = Field(default=UNSET)
    closed_at: Missing[Union[str, None]] = Field(default=UNSET)
    comments: Missing[int] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    labels: List[WebhookIssueCommentCreatedPropIssueAllof1PropLabelsItems] = Field()
    labels_url: Missing[str] = Field(default=UNSET)
    locked: bool = Field()
    milestone: Missing[
        Union[WebhookIssueCommentCreatedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    number: Missing[int] = Field(default=UNSET)
    performed_via_github_app: Missing[
        Union[WebhookIssueCommentCreatedPropIssueAllof1PropPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    reactions: Missing[WebhookIssueCommentCreatedPropIssueAllof1PropReactions] = Field(
        default=UNSET
    )
    repository_url: Missing[str] = Field(default=UNSET)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'"
    )
    timeline_url: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user: Missing[WebhookIssueCommentCreatedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssueCommentCreatedPropIssueAllof1PropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof1PropAssigneesItems(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueAllof1PropAssigneesItems"""


class WebhookIssueCommentCreatedPropIssueAllof1PropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookIssueCommentCreatedPropIssueAllof1PropMilestone(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueAllof1PropMilestone"""


class WebhookIssueCommentCreatedPropIssueAllof1PropPerformedViaGithubApp(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssueCommentCreatedPropIssueAllof1PropReactions(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueAllof1PropReactions"""

    plus_one: Missing[int] = Field(default=UNSET, alias="+1")
    minus_one: Missing[int] = Field(default=UNSET, alias="-1")
    confused: Missing[int] = Field(default=UNSET)
    eyes: Missing[int] = Field(default=UNSET)
    heart: Missing[int] = Field(default=UNSET)
    hooray: Missing[int] = Field(default=UNSET)
    laugh: Missing[int] = Field(default=UNSET)
    rocket: Missing[int] = Field(default=UNSET)
    total_count: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueAllof1PropUser(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueAllof1PropUser"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueMergedAssignees(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueMergedAssignees"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentCreatedPropIssueMergedMilestone(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhookIssueCommentCreatedPropIssueMergedPerformedViaGithubApp(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookIssueCommentCreatedPropIssueMergedReactions(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueMergedReactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookIssueCommentCreatedPropIssueMergedUser(GitHubModel):
    """WebhookIssueCommentCreatedPropIssueMergedUser"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeleted(GitHubModel):
    """issue_comment deleted event"""

    action: Literal["deleted"] = Field()
    comment: WebhookIssueCommentDeletedPropComment = Field(
        title="issue comment",
        description="The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment) itself.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    issue: WebhookIssueCommentDeletedPropIssue = Field(
        description="The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment belongs to."
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookIssueCommentDeletedPropComment(GitHubModel):
    """issue comment

    The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment)
    itself.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field(description="Contents of the issue comment")
    created_at: datetime = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the issue comment")
    issue_url: str = Field()
    node_id: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    reactions: WebhookIssueCommentDeletedPropCommentPropReactions = Field(
        title="Reactions"
    )
    updated_at: datetime = Field()
    url: str = Field(description="URL for the issue comment")
    user: Union[WebhookIssueCommentDeletedPropCommentPropUser, None] = Field(
        title="User"
    )


class WebhookIssueCommentDeletedPropCommentPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookIssueCommentDeletedPropCommentPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssue(GitHubModel):
    """WebhookIssueCommentDeletedPropIssue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment
    belongs to.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field()
    assignee: Union[
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropAssignee, None], None
    ] = Field(title="User")
    assignees: List[WebhookIssueCommentDeletedPropIssueMergedAssignees] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: Union[Union[str, None], None] = Field(description="Contents of the issue")
    closed_at: Union[datetime, None] = Field()
    comments: int = Field()
    comments_url: str = Field()
    created_at: datetime = Field()
    draft: Missing[bool] = Field(default=UNSET)
    events_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    labels: List[WebhookIssueCommentDeletedPropIssueAllof0PropLabelsItems] = Field()
    labels_url: str = Field()
    locked: bool = Field()
    milestone: Union[WebhookIssueCommentDeletedPropIssueMergedMilestone, None] = Field()
    node_id: str = Field()
    number: int = Field()
    performed_via_github_app: Missing[
        Union[WebhookIssueCommentDeletedPropIssueMergedPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    pull_request: Missing[
        WebhookIssueCommentDeletedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentDeletedPropIssueMergedReactions = Field()
    repository_url: str = Field()
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'"
    )
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue")
    updated_at: datetime = Field()
    url: str = Field(description="URL for the issue")
    user: WebhookIssueCommentDeletedPropIssueMergedUser = Field()


class WebhookIssueCommentDeletedPropIssueAllof0(GitHubModel):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field()
    assignee: Missing[
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropAssignee, None]
    ] = Field(default=UNSET, title="User")
    assignees: List[
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropAssigneesItems, None]
    ] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: Union[str, None] = Field(description="Contents of the issue")
    closed_at: Union[datetime, None] = Field()
    comments: int = Field()
    comments_url: str = Field()
    created_at: datetime = Field()
    draft: Missing[bool] = Field(default=UNSET)
    events_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    labels: Missing[
        List[WebhookIssueCommentDeletedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field()
    locked: Missing[bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    node_id: str = Field()
    number: int = Field()
    performed_via_github_app: Missing[
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubApp, None]
    ] = Field(
        default=UNSET,
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    pull_request: Missing[
        WebhookIssueCommentDeletedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentDeletedPropIssueAllof0PropReactions = Field(
        title="Reactions"
    )
    repository_url: str = Field()
    state: Missing[Literal["open", "closed"]] = Field(
        default=UNSET, description="State of the issue; either 'open' or 'closed'"
    )
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue")
    updated_at: datetime = Field()
    url: str = Field(description="URL for the issue")
    user: Union[WebhookIssueCommentDeletedPropIssueAllof0PropUser, None] = Field(
        title="User"
    )


class WebhookIssueCommentDeletedPropIssueAllof0PropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropAssigneesItems(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookIssueCommentDeletedPropIssueAllof0PropMilestonePropCreator(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropMilestone(GitHubModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubModel
):
    """WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermission
    s

    The set of permissions for the GitHub app
    """

    actions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    administration: Missing[Literal["read", "write"]] = Field(default=UNSET)
    checks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    content_references: Missing[Literal["read", "write"]] = Field(default=UNSET)
    contents: Missing[Literal["read", "write"]] = Field(default=UNSET)
    deployments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    emails: Missing[Literal["read", "write"]] = Field(default=UNSET)
    environments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    issues: Missing[Literal["read", "write"]] = Field(default=UNSET)
    keys: Missing[Literal["read", "write"]] = Field(default=UNSET)
    members: Missing[Literal["read", "write"]] = Field(default=UNSET)
    metadata: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(default=UNSET)
    packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_events: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Missing[Literal["read", "write"]] = Field(default=UNSET)
    single_file: Missing[Literal["read", "write"]] = Field(default=UNSET)
    statuses: Missing[Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    workflows: Missing[Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubApp(GitHubModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookIssueCommentDeletedPropIssueAllof0PropPullRequest(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueAllof0PropPullRequest"""

    diff_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    merged_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    patch_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof0PropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookIssueCommentDeletedPropIssueAllof0PropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof1(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueAllof1"""

    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    assignee: Union[
        WebhookIssueCommentDeletedPropIssueAllof1PropAssignee, None
    ] = Field(title="User")
    assignees: Missing[
        List[Union[WebhookIssueCommentDeletedPropIssueAllof1PropAssigneesItems, None]]
    ] = Field(default=UNSET)
    author_association: Missing[str] = Field(default=UNSET)
    body: Missing[Union[str, None]] = Field(default=UNSET)
    closed_at: Missing[Union[str, None]] = Field(default=UNSET)
    comments: Missing[int] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    labels: List[WebhookIssueCommentDeletedPropIssueAllof1PropLabelsItems] = Field()
    labels_url: Missing[str] = Field(default=UNSET)
    locked: bool = Field()
    milestone: Missing[
        Union[WebhookIssueCommentDeletedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    number: Missing[int] = Field(default=UNSET)
    performed_via_github_app: Missing[
        Union[WebhookIssueCommentDeletedPropIssueAllof1PropPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    reactions: Missing[WebhookIssueCommentDeletedPropIssueAllof1PropReactions] = Field(
        default=UNSET
    )
    repository_url: Missing[str] = Field(default=UNSET)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'"
    )
    timeline_url: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user: Missing[WebhookIssueCommentDeletedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssueCommentDeletedPropIssueAllof1PropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof1PropAssigneesItems(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueAllof1PropAssigneesItems"""


class WebhookIssueCommentDeletedPropIssueAllof1PropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookIssueCommentDeletedPropIssueAllof1PropMilestone(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueAllof1PropMilestone"""


class WebhookIssueCommentDeletedPropIssueAllof1PropPerformedViaGithubApp(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssueCommentDeletedPropIssueAllof1PropReactions(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueAllof1PropReactions"""

    plus_one: Missing[int] = Field(default=UNSET, alias="+1")
    minus_one: Missing[int] = Field(default=UNSET, alias="-1")
    confused: Missing[int] = Field(default=UNSET)
    eyes: Missing[int] = Field(default=UNSET)
    heart: Missing[int] = Field(default=UNSET)
    hooray: Missing[int] = Field(default=UNSET)
    laugh: Missing[int] = Field(default=UNSET)
    rocket: Missing[int] = Field(default=UNSET)
    total_count: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueAllof1PropUser(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueAllof1PropUser"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueMergedAssignees(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueMergedAssignees"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentDeletedPropIssueMergedMilestone(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhookIssueCommentDeletedPropIssueMergedPerformedViaGithubApp(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookIssueCommentDeletedPropIssueMergedReactions(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueMergedReactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookIssueCommentDeletedPropIssueMergedUser(GitHubModel):
    """WebhookIssueCommentDeletedPropIssueMergedUser"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEdited(GitHubModel):
    """issue_comment edited event"""

    action: Literal["edited"] = Field()
    changes: WebhookIssueCommentEditedPropChanges = Field(
        description="The changes to the comment."
    )
    comment: WebhookIssueCommentEditedPropComment = Field(
        title="issue comment",
        description="The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment) itself.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    issue: WebhookIssueCommentEditedPropIssue = Field(
        description="The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment belongs to."
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookIssueCommentEditedPropChanges(GitHubModel):
    """WebhookIssueCommentEditedPropChanges

    The changes to the comment.
    """

    body: Missing[WebhookIssueCommentEditedPropChangesPropBody] = Field(default=UNSET)


class WebhookIssueCommentEditedPropChangesPropBody(GitHubModel):
    """WebhookIssueCommentEditedPropChangesPropBody"""

    from_: str = Field(alias="from", description="The previous version of the body.")


class WebhookIssueCommentEditedPropComment(GitHubModel):
    """issue comment

    The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment)
    itself.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: str = Field(description="Contents of the issue comment")
    created_at: datetime = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the issue comment")
    issue_url: str = Field()
    node_id: str = Field()
    performed_via_github_app: Union[None, Integration] = Field()
    reactions: WebhookIssueCommentEditedPropCommentPropReactions = Field(
        title="Reactions"
    )
    updated_at: datetime = Field()
    url: str = Field(description="URL for the issue comment")
    user: Union[WebhookIssueCommentEditedPropCommentPropUser, None] = Field(
        title="User"
    )


class WebhookIssueCommentEditedPropCommentPropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookIssueCommentEditedPropCommentPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssue(GitHubModel):
    """WebhookIssueCommentEditedPropIssue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment
    belongs to.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ] = Field()
    assignee: Union[
        Union[WebhookIssueCommentEditedPropIssueAllof0PropAssignee, None], None
    ] = Field(title="User")
    assignees: List[WebhookIssueCommentEditedPropIssueMergedAssignees] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: Union[Union[str, None], None] = Field(description="Contents of the issue")
    closed_at: Union[datetime, None] = Field()
    comments: int = Field()
    comments_url: str = Field()
    created_at: datetime = Field()
    draft: Missing[bool] = Field(default=UNSET)
    events_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    labels: List[WebhookIssueCommentEditedPropIssueAllof0PropLabelsItems] = Field()
    labels_url: str = Field()
    locked: bool = Field()
    milestone: Union[WebhookIssueCommentEditedPropIssueMergedMilestone, None] = Field()
    node_id: str = Field()
    number: int = Field()
    performed_via_github_app: Missing[
        Union[WebhookIssueCommentEditedPropIssueMergedPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    pull_request: Missing[
        WebhookIssueCommentEditedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentEditedPropIssueMergedReactions = Field()
    repository_url: str = Field()
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'"
    )
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue")
    updated_at: datetime = Field()
    url: str = Field(description="URL for the issue")
    user: WebhookIssueCommentEditedPropIssueMergedUser = Field()


class WebhookIssueCommentEditedPropIssueAllof0(GitHubModel):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field()
    assignee: Missing[
        Union[WebhookIssueCommentEditedPropIssueAllof0PropAssignee, None]
    ] = Field(default=UNSET, title="User")
    assignees: List[
        Union[WebhookIssueCommentEditedPropIssueAllof0PropAssigneesItems, None]
    ] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: Union[str, None] = Field(description="Contents of the issue")
    closed_at: Union[datetime, None] = Field()
    comments: int = Field()
    comments_url: str = Field()
    created_at: datetime = Field()
    draft: Missing[bool] = Field(default=UNSET)
    events_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    labels: Missing[
        List[WebhookIssueCommentEditedPropIssueAllof0PropLabelsItems]
    ] = Field(default=UNSET)
    labels_url: str = Field()
    locked: Missing[bool] = Field(default=UNSET)
    milestone: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    node_id: str = Field()
    number: int = Field()
    performed_via_github_app: Missing[
        Union[WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubApp, None]
    ] = Field(
        default=UNSET,
        title="App",
        description="GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.",
    )
    pull_request: Missing[
        WebhookIssueCommentEditedPropIssueAllof0PropPullRequest
    ] = Field(default=UNSET)
    reactions: WebhookIssueCommentEditedPropIssueAllof0PropReactions = Field(
        title="Reactions"
    )
    repository_url: str = Field()
    state: Missing[Literal["open", "closed"]] = Field(
        default=UNSET, description="State of the issue; either 'open' or 'closed'"
    )
    state_reason: Missing[Union[str, None]] = Field(default=UNSET)
    timeline_url: Missing[str] = Field(default=UNSET)
    title: str = Field(description="Title of the issue")
    updated_at: datetime = Field()
    url: str = Field(description="URL for the issue")
    user: Union[WebhookIssueCommentEditedPropIssueAllof0PropUser, None] = Field(
        title="User"
    )


class WebhookIssueCommentEditedPropIssueAllof0PropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropAssigneesItems(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookIssueCommentEditedPropIssueAllof0PropMilestonePropCreator(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropMilestone(GitHubModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissions(
    GitHubModel
):
    """WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    administration: Missing[Literal["read", "write"]] = Field(default=UNSET)
    checks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    content_references: Missing[Literal["read", "write"]] = Field(default=UNSET)
    contents: Missing[Literal["read", "write"]] = Field(default=UNSET)
    deployments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    emails: Missing[Literal["read", "write"]] = Field(default=UNSET)
    environments: Missing[Literal["read", "write"]] = Field(default=UNSET)
    issues: Missing[Literal["read", "write"]] = Field(default=UNSET)
    keys: Missing[Literal["read", "write"]] = Field(default=UNSET)
    members: Missing[Literal["read", "write"]] = Field(default=UNSET)
    metadata: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_administration: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_plan: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_projects: Missing[Literal["read", "write", "admin"]] = Field(
        default=UNSET
    )
    organization_secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    organization_self_hosted_runners: Missing[Literal["read", "write"]] = Field(
        default=UNSET
    )
    organization_user_blocking: Missing[Literal["read", "write"]] = Field(default=UNSET)
    packages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pages: Missing[Literal["read", "write"]] = Field(default=UNSET)
    pull_requests: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_hooks: Missing[Literal["read", "write"]] = Field(default=UNSET)
    repository_projects: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secret_scanning_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    secrets: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_events: Missing[Literal["read", "write"]] = Field(default=UNSET)
    security_scanning_alert: Missing[Literal["read", "write"]] = Field(default=UNSET)
    single_file: Missing[Literal["read", "write"]] = Field(default=UNSET)
    statuses: Missing[Literal["read", "write"]] = Field(default=UNSET)
    team_discussions: Missing[Literal["read", "write"]] = Field(default=UNSET)
    vulnerability_alerts: Missing[Literal["read", "write"]] = Field(default=UNSET)
    workflows: Missing[Literal["read", "write"]] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubApp(GitHubModel):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookIssueCommentEditedPropIssueAllof0PropPullRequest(GitHubModel):
    """WebhookIssueCommentEditedPropIssueAllof0PropPullRequest"""

    diff_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    merged_at: Missing[Union[datetime, None]] = Field(default=UNSET)
    patch_url: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof0PropReactions(GitHubModel):
    """Reactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookIssueCommentEditedPropIssueAllof0PropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof1(GitHubModel):
    """WebhookIssueCommentEditedPropIssueAllof1"""

    active_lock_reason: Missing[Union[str, None]] = Field(default=UNSET)
    assignee: Union[WebhookIssueCommentEditedPropIssueAllof1PropAssignee, None] = Field(
        title="User"
    )
    assignees: Missing[
        List[Union[WebhookIssueCommentEditedPropIssueAllof1PropAssigneesItems, None]]
    ] = Field(default=UNSET)
    author_association: Missing[str] = Field(default=UNSET)
    body: Missing[Union[str, None]] = Field(default=UNSET)
    closed_at: Missing[Union[str, None]] = Field(default=UNSET)
    comments: Missing[int] = Field(default=UNSET)
    comments_url: Missing[str] = Field(default=UNSET)
    created_at: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    labels: List[WebhookIssueCommentEditedPropIssueAllof1PropLabelsItems] = Field()
    labels_url: Missing[str] = Field(default=UNSET)
    locked: bool = Field()
    milestone: Missing[
        Union[WebhookIssueCommentEditedPropIssueAllof1PropMilestone, None]
    ] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    number: Missing[int] = Field(default=UNSET)
    performed_via_github_app: Missing[
        Union[WebhookIssueCommentEditedPropIssueAllof1PropPerformedViaGithubApp, None]
    ] = Field(default=UNSET)
    reactions: Missing[WebhookIssueCommentEditedPropIssueAllof1PropReactions] = Field(
        default=UNSET
    )
    repository_url: Missing[str] = Field(default=UNSET)
    state: Literal["open", "closed"] = Field(
        description="State of the issue; either 'open' or 'closed'"
    )
    timeline_url: Missing[str] = Field(default=UNSET)
    title: Missing[str] = Field(default=UNSET)
    updated_at: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user: Missing[WebhookIssueCommentEditedPropIssueAllof1PropUser] = Field(
        default=UNSET
    )


class WebhookIssueCommentEditedPropIssueAllof1PropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof1PropAssigneesItems(GitHubModel):
    """WebhookIssueCommentEditedPropIssueAllof1PropAssigneesItems"""


class WebhookIssueCommentEditedPropIssueAllof1PropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookIssueCommentEditedPropIssueAllof1PropMilestone(GitHubModel):
    """WebhookIssueCommentEditedPropIssueAllof1PropMilestone"""


class WebhookIssueCommentEditedPropIssueAllof1PropPerformedViaGithubApp(GitHubModel):
    """WebhookIssueCommentEditedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssueCommentEditedPropIssueAllof1PropReactions(GitHubModel):
    """WebhookIssueCommentEditedPropIssueAllof1PropReactions"""

    plus_one: Missing[int] = Field(default=UNSET, alias="+1")
    minus_one: Missing[int] = Field(default=UNSET, alias="-1")
    confused: Missing[int] = Field(default=UNSET)
    eyes: Missing[int] = Field(default=UNSET)
    heart: Missing[int] = Field(default=UNSET)
    hooray: Missing[int] = Field(default=UNSET)
    laugh: Missing[int] = Field(default=UNSET)
    rocket: Missing[int] = Field(default=UNSET)
    total_count: Missing[int] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueAllof1PropUser(GitHubModel):
    """WebhookIssueCommentEditedPropIssueAllof1PropUser"""

    avatar_url: Missing[str] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: Missing[int] = Field(default=UNSET)
    login: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueMergedAssignees(GitHubModel):
    """WebhookIssueCommentEditedPropIssueMergedAssignees"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssueCommentEditedPropIssueMergedMilestone(GitHubModel):
    """WebhookIssueCommentEditedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropMilestonePropCreator, None
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhookIssueCommentEditedPropIssueMergedPerformedViaGithubApp(GitHubModel):
    """WebhookIssueCommentEditedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None] = Field()
    description: Union[str, None] = Field()
    events: Missing[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ] = Field(default=UNSET, description="The list of events for the GitHub app")
    external_url: Union[str, None] = Field()
    html_url: str = Field()
    id: Union[int, None] = Field(description="Unique identifier of the GitHub app")
    name: str = Field(description="The name of the GitHub app")
    node_id: str = Field()
    owner: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissions
    ] = Field(default=UNSET, description="The set of permissions for the GitHub app")
    slug: Missing[str] = Field(
        default=UNSET, description="The slug name of the GitHub app"
    )
    updated_at: Union[datetime, None] = Field()


class WebhookIssueCommentEditedPropIssueMergedReactions(GitHubModel):
    """WebhookIssueCommentEditedPropIssueMergedReactions"""

    plus_one: int = Field(alias="+1")
    minus_one: int = Field(alias="-1")
    confused: int = Field()
    eyes: int = Field()
    heart: int = Field()
    hooray: int = Field()
    laugh: int = Field()
    rocket: int = Field()
    total_count: int = Field()
    url: str = Field()


class WebhookIssueCommentEditedPropIssueMergedUser(GitHubModel):
    """WebhookIssueCommentEditedPropIssueMergedUser"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookIssuesAssigned(GitHubModel):
    """issues assigned event"""

    action: Literal["assigned"] = Field(description="The action that was performed.")
    assignee: Missing[Union[WebhookIssuesAssignedPropAssignee, None]] = Field(
        default=UNSET, title="User"
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    issue: WebhookIssuesAssignedPropIssue = Field(
        title="Issue",
        description="The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.",
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookIssuesAssignedPropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookIssuesAssignedPropIssue(GitHubModel):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field()
    assignee: Missing[Union[WebhookIssuesAssignedPropIssuePropAssignee, None]] = Field(
        default=UNSET, title="User"
    )
    assignees: List[
        Union[WebhookIssuesAssignedPropIssuePropAssigneesItems, None]
    ] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    body: Union[str, None] = Field(description="Contents of the issue")
    closed_at: Union[datetime, None] = Field()
    comments: int = Field()
    comments_url: str = Field()
    created_at: datetime = Field()
    draft: Missing[bool] = Field(default=UNSET)
    events_url: str = Field()
    html_url: str = Field()
    id: int = Field()
    labels: Missing[List[WebhookIssuesAssignedPropIssuePropLabelsItems]] = Field(
        default=UNSET
    )
    labels_url: str = Field()
    locked: Missing[bool] = Field(default=UNSET)
    milestone: Union[WebhookIssuesAssignedPropIssuePropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    node_id: str = Field()
    number: int = Field()
    performed_via_github_app: Missing[
        Union[WebhookIssuesAssignedPropIssuePropPerformedViaGit