"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from __future__ import annotations

from typing_extensions import Annotated
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import Field, BaseModel

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..types import MarkdownPostBodyType


class MarkdownClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github = github

    @overload
    def render(
        self, *, headers: Optional[Dict[str, str]] = None, data: MarkdownPostBodyType
    ) -> Response[str]:
        ...

    @overload
    def render(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        text: str,
        mode: Missing[Literal["markdown", "gfm"]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[str]:
        ...

    def render(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[MarkdownPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[str]:
        from ..models import MarkdownPostBody

        url = "/markdown"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(MarkdownPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=str,
        )

    @overload
    async def async_render(
        self, *, headers: Optional[Dict[str, str]] = None, data: MarkdownPostBodyType
    ) -> Response[str]:
        ...

    @overload
    async def async_render(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        text: str,
        mode: Missing[Literal["markdown", "gfm"]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[str]:
        ...

    async def async_render(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[MarkdownPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[str]:
        from ..models import MarkdownPostBody

        url = "/markdown"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(MarkdownPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=str,
        )

    def render_raw(
        self, *, headers: Optional[Dict[str, str]] = None, data: str, **kwargs
    ) -> Response[str]:
        url = "/markdown/raw"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = type_validate_python(str, content)
        content = model_dump(content) if isinstance(content, BaseModel) else content

        return self._github.request(
            "POST",
            url,
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=str,
        )

    async def async_render_raw(
        self, *, headers: Optional[Dict[str, str]] = None, data: str, **kwargs
    ) -> Response[str]:
        url = "/markdown/raw"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = type_validate_python(str, content)
        content = model_dump(content) if isinstance(content, BaseModel) else content

        return await self._github.arequest(
            "POST",
            url,
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=str,
        )
