"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from __future__ import annotations

from datetime import date, datetime
from typing import Any, List, Union, Literal
from typing_extensions import TypedDict, NotRequired


class RootType(TypedDict):
    """Root"""

    current_user_url: str
    current_user_authorizations_html_url: str
    authorizations_url: str
    code_search_url: str
    commit_search_url: str
    emails_url: str
    emojis_url: str
    events_url: str
    feeds_url: str
    followers_url: str
    following_url: str
    gists_url: str
    hub_url: str
    issue_search_url: str
    issues_url: str
    keys_url: str
    label_search_url: str
    notifications_url: str
    organization_url: str
    organization_repositories_url: str
    organization_teams_url: str
    public_gists_url: str
    rate_limit_url: str
    repository_url: str
    repository_search_url: str
    current_user_repositories_url: str
    starred_url: str
    starred_gists_url: str
    topic_search_url: NotRequired[str]
    user_url: str
    user_organizations_url: str
    user_repositories_url: str
    user_search_url: str


class SimpleUserType(TypedDict):
    """Simple User

    A GitHub user.
    """

    name: NotRequired[Union[str, None]]
    email: NotRequired[Union[str, None]]
    login: str
    id: int
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    following_url: str
    gists_url: str
    starred_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    events_url: str
    received_events_url: str
    type: str
    site_admin: bool
    starred_at: NotRequired[str]


class GlobalAdvisoryType(TypedDict):
    """GlobalAdvisory

    A GitHub Security Advisory.
    """

    ghsa_id: str
    cve_id: Union[str, None]
    url: str
    html_url: str
    repository_advisory_url: Union[str, None]
    summary: str
    description: Union[str, None]
    type: Literal["reviewed", "unreviewed", "malware"]
    severity: Literal["critical", "high", "medium", "low", "unknown"]
    source_code_location: Union[str, None]
    identifiers: Union[List[GlobalAdvisoryPropIdentifiersItemsType], None]
    references: Union[List[str], None]
    published_at: datetime
    updated_at: datetime
    github_reviewed_at: Union[datetime, None]
    nvd_published_at: Union[datetime, None]
    withdrawn_at: Union[datetime, None]
    vulnerabilities: Union[List[GlobalAdvisoryPropVulnerabilitiesItemsType], None]
    cvss: Union[GlobalAdvisoryPropCvssType, None]
    cwes: Union[List[GlobalAdvisoryPropCwesItemsType], None]
    credits_: Union[List[GlobalAdvisoryPropCreditsItemsType], None]


class GlobalAdvisoryPropIdentifiersItemsType(TypedDict):
    """GlobalAdvisoryPropIdentifiersItems"""

    type: Literal["CVE", "GHSA"]
    value: str


class GlobalAdvisoryPropVulnerabilitiesItemsType(TypedDict):
    """GlobalAdvisoryPropVulnerabilitiesItems"""

    package: Union[GlobalAdvisoryPropVulnerabilitiesItemsPropPackageType, None]
    vulnerable_version_range: Union[str, None]
    first_patched_version: Union[str, None]
    vulnerable_functions: Union[List[str], None]


class GlobalAdvisoryPropVulnerabilitiesItemsPropPackageType(TypedDict):
    """GlobalAdvisoryPropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ]
    name: Union[str, None]


class GlobalAdvisoryPropCvssType(TypedDict):
    """GlobalAdvisoryPropCvss"""

    vector_string: Union[str, None]
    score: Union[float, None]


class GlobalAdvisoryPropCwesItemsType(TypedDict):
    """GlobalAdvisoryPropCwesItems"""

    cwe_id: str
    name: str


class GlobalAdvisoryPropCreditsItemsType(TypedDict):
    """GlobalAdvisoryPropCreditsItems"""

    user: SimpleUserType
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ]


class BasicErrorType(TypedDict):
    """Basic Error

    Basic Error
    """

    message: NotRequired[str]
    documentation_url: NotRequired[str]
    url: NotRequired[str]
    status: NotRequired[str]


class ValidationErrorSimpleType(TypedDict):
    """Validation Error Simple

    Validation Error Simple
    """

    message: str
    documentation_url: str
    errors: NotRequired[List[str]]


class IntegrationType(TypedDict):
    """GitHub app

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    id: int
    slug: NotRequired[str]
    node_id: str
    owner: Union[None, SimpleUserType]
    name: str
    description: Union[str, None]
    external_url: str
    html_url: str
    created_at: datetime
    updated_at: datetime
    permissions: IntegrationPropPermissionsType
    events: List[str]
    installations_count: NotRequired[int]
    client_id: NotRequired[str]
    client_secret: NotRequired[str]
    webhook_secret: NotRequired[Union[str, None]]
    pem: NotRequired[str]


class IntegrationPropPermissionsType(TypedDict):
    """IntegrationPropPermissions

    The set of permissions for the GitHub app

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """

    issues: NotRequired[str]
    checks: NotRequired[str]
    metadata: NotRequired[str]
    contents: NotRequired[str]
    deployments: NotRequired[str]


class WebhookConfigType(TypedDict):
    """Webhook Configuration

    Configuration object of the webhook
    """

    url: NotRequired[str]
    content_type: NotRequired[str]
    secret: NotRequired[str]
    insecure_ssl: NotRequired[Union[str, float]]


class HookDeliveryItemType(TypedDict):
    """Simple webhook delivery

    Delivery made by a webhook, without request and response information.
    """

    id: int
    guid: str
    delivered_at: datetime
    redelivery: bool
    duration: float
    status: str
    status_code: int
    event: str
    action: Union[str, None]
    installation_id: Union[int, None]
    repository_id: Union[int, None]


class ScimErrorType(TypedDict):
    """Scim Error

    Scim Error
    """

    message: NotRequired[Union[str, None]]
    documentation_url: NotRequired[Union[str, None]]
    detail: NotRequired[Union[str, None]]
    status: NotRequired[int]
    scim_type: NotRequired[Union[str, None]]
    schemas: NotRequired[List[str]]


class ValidationErrorType(TypedDict):
    """Validation Error

    Validation Error
    """

    message: str
    documentation_url: str
    errors: NotRequired[List[ValidationErrorPropErrorsItemsType]]


class ValidationErrorPropErrorsItemsType(TypedDict):
    """ValidationErrorPropErrorsItems"""

    resource: NotRequired[str]
    field: NotRequired[str]
    message: NotRequired[str]
    code: str
    index: NotRequired[int]
    value: NotRequired[Union[str, None, int, None, List[str], None]]


class HookDeliveryType(TypedDict):
    """Webhook delivery

    Delivery made by a webhook.
    """

    id: int
    guid: str
    delivered_at: datetime
    redelivery: bool
    duration: float
    status: str
    status_code: int
    event: str
    action: Union[str, None]
    installation_id: Union[int, None]
    repository_id: Union[int, None]
    url: NotRequired[str]
    request: HookDeliveryPropRequestType
    response: HookDeliveryPropResponseType


class HookDeliveryPropRequestType(TypedDict):
    """HookDeliveryPropRequest"""

    headers: Union[HookDeliveryPropRequestPropHeadersType, None]
    payload: Union[HookDeliveryPropRequestPropPayloadType, None]


class HookDeliveryPropRequestPropHeadersType(TypedDict):
    """HookDeliveryPropRequestPropHeaders

    The request headers sent with the webhook delivery.
    """


class HookDeliveryPropRequestPropPayloadType(TypedDict):
    """HookDeliveryPropRequestPropPayload

    The webhook payload.
    """


class HookDeliveryPropResponseType(TypedDict):
    """HookDeliveryPropResponse"""

    headers: Union[HookDeliveryPropResponsePropHeadersType, None]
    payload: Union[str, None]


class HookDeliveryPropResponsePropHeadersType(TypedDict):
    """HookDeliveryPropResponsePropHeaders

    The response headers received when the delivery was made.
    """


class EnterpriseType(TypedDict):
    """Enterprise

    An enterprise on GitHub.
    """

    description: NotRequired[Union[str, None]]
    html_url: str
    website_url: NotRequired[Union[str, None]]
    id: int
    node_id: str
    name: str
    slug: str
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    avatar_url: str


class IntegrationInstallationRequestType(TypedDict):
    """Integration Installation Request

    Request to install an integration on a target
    """

    id: int
    node_id: NotRequired[str]
    account: Union[SimpleUserType, EnterpriseType]
    requester: SimpleUserType
    created_at: datetime


class AppPermissionsType(TypedDict):
    """App Permissions

    The permissions granted to the user access token.

    Examples:
        {'contents': 'read', 'issues': 'read', 'deployments': 'write', 'single_file':
    'read'}
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    codespaces: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    dependabot_secrets: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_custom_properties: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write", "admin"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["write"]]
    members: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_custom_roles: NotRequired[Literal["read", "write"]]
    organization_custom_org_roles: NotRequired[Literal["read", "write"]]
    organization_custom_properties: NotRequired[Literal["read", "write", "admin"]]
    organization_copilot_seat_management: NotRequired[Literal["write"]]
    organization_announcement_banners: NotRequired[Literal["read", "write"]]
    organization_events: NotRequired[Literal["read"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_personal_access_tokens: NotRequired[Literal["read", "write"]]
    organization_personal_access_token_requests: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    email_addresses: NotRequired[Literal["read", "write"]]
    followers: NotRequired[Literal["read", "write"]]
    git_ssh_keys: NotRequired[Literal["read", "write"]]
    gpg_keys: NotRequired[Literal["read", "write"]]
    interaction_limits: NotRequired[Literal["read", "write"]]
    profile: NotRequired[Literal["write"]]
    starring: NotRequired[Literal["read", "write"]]


class InstallationType(TypedDict):
    """Installation

    Installation
    """

    id: int
    account: Union[SimpleUserType, EnterpriseType, None]
    repository_selection: Literal["all", "selected"]
    access_tokens_url: str
    repositories_url: str
    html_url: str
    app_id: int
    target_id: int
    target_type: str
    permissions: AppPermissionsType
    events: List[str]
    created_at: datetime
    updated_at: datetime
    single_file_name: Union[str, None]
    has_multiple_single_files: NotRequired[bool]
    single_file_paths: NotRequired[List[str]]
    app_slug: str
    suspended_by: Union[None, SimpleUserType]
    suspended_at: Union[datetime, None]
    contact_email: NotRequired[Union[str, None]]


class LicenseSimpleType(TypedDict):
    """License Simple

    License Simple
    """

    key: str
    name: str
    url: Union[str, None]
    spdx_id: Union[str, None]
    node_id: str
    html_url: NotRequired[str]


class RepositoryType(TypedDict):
    """Repository

    A repository on GitHub.
    """

    id: int
    node_id: str
    name: str
    full_name: str
    license_: Union[None, LicenseSimpleType]
    organization: NotRequired[Union[None, SimpleUserType]]
    forks: int
    permissions: NotRequired[RepositoryPropPermissionsType]
    owner: SimpleUserType
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    ssh_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    clone_url: str
    mirror_url: Union[str, None]
    hooks_url: str
    svn_url: str
    homepage: Union[str, None]
    language: Union[str, None]
    forks_count: int
    stargazers_count: int
    watchers_count: int
    size: int
    default_branch: str
    open_issues_count: int
    is_template: NotRequired[bool]
    topics: NotRequired[List[str]]
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    has_downloads: bool
    has_discussions: NotRequired[bool]
    archived: bool
    disabled: bool
    visibility: NotRequired[str]
    pushed_at: Union[datetime, None]
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    allow_rebase_merge: NotRequired[bool]
    template_repository: NotRequired[Union[RepositoryPropTemplateRepositoryType, None]]
    temp_clone_token: NotRequired[Union[str, None]]
    allow_squash_merge: NotRequired[bool]
    allow_auto_merge: NotRequired[bool]
    delete_branch_on_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    use_squash_pr_title_as_default: NotRequired[bool]
    squash_merge_commit_title: NotRequired[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]]
    squash_merge_commit_message: NotRequired[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ]
    merge_commit_title: NotRequired[Literal["PR_TITLE", "MERGE_MESSAGE"]]
    merge_commit_message: NotRequired[Literal["PR_BODY", "PR_TITLE", "BLANK"]]
    allow_merge_commit: NotRequired[bool]
    allow_forking: NotRequired[bool]
    web_commit_signoff_required: NotRequired[bool]
    subscribers_count: NotRequired[int]
    network_count: NotRequired[int]
    open_issues: int
    watchers: int
    master_branch: NotRequired[str]
    starred_at: NotRequired[str]
    anonymous_access_enabled: NotRequired[bool]


class RepositoryPropPermissionsType(TypedDict):
    """RepositoryPropPermissions"""

    admin: bool
    pull: bool
    triage: NotRequired[bool]
    push: bool
    maintain: NotRequired[bool]


class RepositoryPropTemplateRepositoryPropOwnerType(TypedDict):
    """RepositoryPropTemplateRepositoryPropOwner"""

    login: NotRequired[str]
    id: NotRequired[int]
    node_id: NotRequired[str]
    avatar_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    url: NotRequired[str]
    html_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    organizations_url: NotRequired[str]
    repos_url: NotRequired[str]
    events_url: NotRequired[str]
    received_events_url: NotRequired[str]
    type: NotRequired[str]
    site_admin: NotRequired[bool]


class RepositoryPropTemplateRepositoryPropPermissionsType(TypedDict):
    """RepositoryPropTemplateRepositoryPropPermissions"""

    admin: NotRequired[bool]
    maintain: NotRequired[bool]
    push: NotRequired[bool]
    triage: NotRequired[bool]
    pull: NotRequired[bool]


class RepositoryPropTemplateRepositoryType(TypedDict):
    """RepositoryPropTemplateRepository"""

    id: NotRequired[int]
    node_id: NotRequired[str]
    name: NotRequired[str]
    full_name: NotRequired[str]
    owner: NotRequired[RepositoryPropTemplateRepositoryPropOwnerType]
    private: NotRequired[bool]
    html_url: NotRequired[str]
    description: NotRequired[str]
    fork: NotRequired[bool]
    url: NotRequired[str]
    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    forks_url: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    git_url: NotRequired[str]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    notifications_url: NotRequired[str]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    ssh_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    clone_url: NotRequired[str]
    mirror_url: NotRequired[str]
    hooks_url: NotRequired[str]
    svn_url: NotRequired[str]
    homepage: NotRequired[str]
    language: NotRequired[str]
    forks_count: NotRequired[int]
    stargazers_count: NotRequired[int]
    watchers_count: NotRequired[int]
    size: NotRequired[int]
    default_branch: NotRequired[str]
    open_issues_count: NotRequired[int]
    is_template: NotRequired[bool]
    topics: NotRequired[List[str]]
    has_issues: NotRequired[bool]
    has_projects: NotRequired[bool]
    has_wiki: NotRequired[bool]
    has_pages: NotRequired[bool]
    has_downloads: NotRequired[bool]
    archived: NotRequired[bool]
    disabled: NotRequired[bool]
    visibility: NotRequired[str]
    pushed_at: NotRequired[str]
    created_at: NotRequired[str]
    updated_at: NotRequired[str]
    permissions: NotRequired[RepositoryPropTemplateRepositoryPropPermissionsType]
    allow_rebase_merge: NotRequired[bool]
    temp_clone_token: NotRequired[Union[str, None]]
    allow_squash_merge: NotRequired[bool]
    allow_auto_merge: NotRequired[bool]
    delete_branch_on_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    use_squash_pr_title_as_default: NotRequired[bool]
    squash_merge_commit_title: NotRequired[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]]
    squash_merge_commit_message: NotRequired[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ]
    merge_commit_title: NotRequired[Literal["PR_TITLE", "MERGE_MESSAGE"]]
    merge_commit_message: NotRequired[Literal["PR_BODY", "PR_TITLE", "BLANK"]]
    allow_merge_commit: NotRequired[bool]
    subscribers_count: NotRequired[int]
    network_count: NotRequired[int]


class InstallationTokenType(TypedDict):
    """Installation Token

    Authentication token for a GitHub App installed on a user or org.
    """

    token: str
    expires_at: str
    permissions: NotRequired[AppPermissionsType]
    repository_selection: NotRequired[Literal["all", "selected"]]
    repositories: NotRequired[List[RepositoryType]]
    single_file: NotRequired[str]
    has_multiple_single_files: NotRequired[bool]
    single_file_paths: NotRequired[List[str]]


class ScopedInstallationType(TypedDict):
    """Scoped Installation"""

    permissions: AppPermissionsType
    repository_selection: Literal["all", "selected"]
    single_file_name: Union[str, None]
    has_multiple_single_files: NotRequired[bool]
    single_file_paths: NotRequired[List[str]]
    repositories_url: str
    account: SimpleUserType


class AuthorizationType(TypedDict):
    """Authorization

    The authorization for an OAuth app, GitHub App, or a Personal Access Token.
    """

    id: int
    url: str
    scopes: Union[List[str], None]
    token: str
    token_last_eight: Union[str, None]
    hashed_token: Union[str, None]
    app: AuthorizationPropAppType
    note: Union[str, None]
    note_url: Union[str, None]
    updated_at: datetime
    created_at: datetime
    fingerprint: Union[str, None]
    user: NotRequired[Union[None, SimpleUserType]]
    installation: NotRequired[Union[None, ScopedInstallationType]]
    expires_at: Union[datetime, None]


class AuthorizationPropAppType(TypedDict):
    """AuthorizationPropApp"""

    client_id: str
    name: str
    url: str


class SimpleClassroomRepositoryType(TypedDict):
    """Simple Classroom Repository

    A GitHub repository view for Classroom
    """

    id: int
    full_name: str
    html_url: str
    node_id: str
    private: bool
    default_branch: str


class SimpleClassroomOrganizationType(TypedDict):
    """Organization Simple for Classroom

    A GitHub organization.
    """

    id: int
    login: str
    node_id: str
    html_url: str
    name: Union[str, None]
    avatar_url: str


class ClassroomType(TypedDict):
    """Classroom

    A GitHub Classroom classroom
    """

    id: int
    name: str
    archived: bool
    organization: SimpleClassroomOrganizationType
    url: str


class ClassroomAssignmentType(TypedDict):
    """Classroom Assignment

    A GitHub Classroom assignment
    """

    id: int
    public_repo: bool
    title: str
    type: Literal["individual", "group"]
    invite_link: str
    invitations_enabled: bool
    slug: str
    students_are_repo_admins: bool
    feedback_pull_requests_enabled: bool
    max_teams: Union[int, None]
    max_members: Union[int, None]
    editor: str
    accepted: int
    submitted: int
    passing: int
    language: str
    deadline: Union[datetime, None]
    starter_code_repository: SimpleClassroomRepositoryType
    classroom: ClassroomType


class SimpleClassroomUserType(TypedDict):
    """Simple Classroom User

    A GitHub user simplified for Classroom.
    """

    id: int
    login: str
    avatar_url: str
    html_url: str


class SimpleClassroomType(TypedDict):
    """Simple Classroom

    A GitHub Classroom classroom
    """

    id: int
    name: str
    archived: bool
    url: str


class SimpleClassroomAssignmentType(TypedDict):
    """Simple Classroom Assignment

    A GitHub Classroom assignment
    """

    id: int
    public_repo: bool
    title: str
    type: Literal["individual", "group"]
    invite_link: str
    invitations_enabled: bool
    slug: str
    students_are_repo_admins: bool
    feedback_pull_requests_enabled: bool
    max_teams: NotRequired[Union[int, None]]
    max_members: NotRequired[Union[int, None]]
    editor: str
    accepted: int
    submitted: int
    passing: int
    language: str
    deadline: Union[datetime, None]
    classroom: SimpleClassroomType


class ClassroomAcceptedAssignmentType(TypedDict):
    """Classroom Accepted Assignment

    A GitHub Classroom accepted assignment
    """

    id: int
    submitted: bool
    passing: bool
    commit_count: int
    grade: str
    students: List[SimpleClassroomUserType]
    repository: SimpleClassroomRepositoryType
    assignment: SimpleClassroomAssignmentType


class ClassroomAssignmentGradeType(TypedDict):
    """Classroom Assignment Grade

    Grade for a student or groups GitHub Classroom assignment
    """

    assignment_name: str
    assignment_url: str
    starter_code_url: str
    github_username: str
    roster_identifier: str
    student_repository_name: str
    student_repository_url: str
    submission_timestamp: str
    points_awarded: int
    points_available: int
    group_name: NotRequired[str]


class CodeOfConductType(TypedDict):
    """Code Of Conduct

    Code Of Conduct
    """

    key: str
    name: str
    url: str
    body: NotRequired[str]
    html_url: Union[str, None]


class DependabotAlertPackageType(TypedDict):
    """DependabotAlertPackage

    Details for the vulnerable package.
    """

    ecosystem: str
    name: str


class DependabotAlertSecurityVulnerabilityType(TypedDict):
    """DependabotAlertSecurityVulnerability

    Details pertaining to one vulnerable version range for the advisory.
    """

    package: DependabotAlertPackageType
    severity: Literal["low", "medium", "high", "critical"]
    vulnerable_version_range: str
    first_patched_version: Union[
        DependabotAlertSecurityVulnerabilityPropFirstPatchedVersionType, None
    ]


class DependabotAlertSecurityVulnerabilityPropFirstPatchedVersionType(TypedDict):
    """DependabotAlertSecurityVulnerabilityPropFirstPatchedVersion

    Details pertaining to the package version that patches this vulnerability.
    """

    identifier: str


class DependabotAlertSecurityAdvisoryType(TypedDict):
    """DependabotAlertSecurityAdvisory

    Details for the GitHub Security Advisory.
    """

    ghsa_id: str
    cve_id: Union[str, None]
    summary: str
    description: str
    vulnerabilities: List[DependabotAlertSecurityVulnerabilityType]
    severity: Literal["low", "medium", "high", "critical"]
    cvss: DependabotAlertSecurityAdvisoryPropCvssType
    cwes: List[DependabotAlertSecurityAdvisoryPropCwesItemsType]
    identifiers: List[DependabotAlertSecurityAdvisoryPropIdentifiersItemsType]
    references: List[DependabotAlertSecurityAdvisoryPropReferencesItemsType]
    published_at: datetime
    updated_at: datetime
    withdrawn_at: Union[datetime, None]


class DependabotAlertSecurityAdvisoryPropCvssType(TypedDict):
    """DependabotAlertSecurityAdvisoryPropCvss

    Details for the advisory pertaining to the Common Vulnerability Scoring System.
    """

    score: float
    vector_string: Union[str, None]


class DependabotAlertSecurityAdvisoryPropCwesItemsType(TypedDict):
    """DependabotAlertSecurityAdvisoryPropCwesItems

    A CWE weakness assigned to the advisory.
    """

    cwe_id: str
    name: str


class DependabotAlertSecurityAdvisoryPropIdentifiersItemsType(TypedDict):
    """DependabotAlertSecurityAdvisoryPropIdentifiersItems

    An advisory identifier.
    """

    type: Literal["CVE", "GHSA"]
    value: str


class DependabotAlertSecurityAdvisoryPropReferencesItemsType(TypedDict):
    """DependabotAlertSecurityAdvisoryPropReferencesItems

    A link to additional advisory information.
    """

    url: str


class SimpleRepositoryType(TypedDict):
    """Simple Repository

    A GitHub repository.
    """

    id: int
    node_id: str
    name: str
    full_name: str
    owner: SimpleUserType
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    hooks_url: str


class DependabotAlertWithRepositoryType(TypedDict):
    """DependabotAlertWithRepository

    A Dependabot alert.
    """

    number: int
    state: Literal["auto_dismissed", "dismissed", "fixed", "open"]
    dependency: DependabotAlertWithRepositoryPropDependencyType
    security_advisory: DependabotAlertSecurityAdvisoryType
    security_vulnerability: DependabotAlertSecurityVulnerabilityType
    url: str
    html_url: str
    created_at: datetime
    updated_at: datetime
    dismissed_at: Union[datetime, None]
    dismissed_by: Union[None, SimpleUserType]
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ]
    dismissed_comment: Union[str, None]
    fixed_at: Union[datetime, None]
    auto_dismissed_at: NotRequired[Union[datetime, None]]
    repository: SimpleRepositoryType


class DependabotAlertWithRepositoryPropDependencyType(TypedDict):
    """DependabotAlertWithRepositoryPropDependency

    Details for the vulnerable dependency.
    """

    package: NotRequired[DependabotAlertPackageType]
    manifest_path: NotRequired[str]
    scope: NotRequired[Union[None, Literal["development", "runtime"]]]


class OrganizationSecretScanningAlertType(TypedDict):
    """OrganizationSecretScanningAlert"""

    number: NotRequired[int]
    created_at: NotRequired[datetime]
    updated_at: NotRequired[Union[None, datetime]]
    url: NotRequired[str]
    html_url: NotRequired[str]
    locations_url: NotRequired[str]
    state: NotRequired[Literal["open", "resolved"]]
    resolution: NotRequired[
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]]
    ]
    resolved_at: NotRequired[Union[datetime, None]]
    resolved_by: NotRequired[Union[None, SimpleUserType]]
    secret_type: NotRequired[str]
    secret_type_display_name: NotRequired[str]
    secret: NotRequired[str]
    repository: NotRequired[SimpleRepositoryType]
    push_protection_bypassed: NotRequired[Union[bool, None]]
    push_protection_bypassed_by: NotRequired[Union[None, SimpleUserType]]
    push_protection_bypassed_at: NotRequired[Union[datetime, None]]
    resolution_comment: NotRequired[Union[str, None]]
    validity: NotRequired[Literal["active", "inactive", "unknown"]]


class ActorType(TypedDict):
    """Actor

    Actor
    """

    id: int
    login: str
    display_login: NotRequired[str]
    gravatar_id: Union[str, None]
    url: str
    avatar_url: str


class MilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    url: str
    html_url: str
    labels_url: str
    id: int
    node_id: str
    number: int
    state: Literal["open", "closed"]
    title: str
    description: Union[str, None]
    creator: Union[None, SimpleUserType]
    open_issues: int
    closed_issues: int
    created_at: datetime
    updated_at: datetime
    closed_at: Union[datetime, None]
    due_on: Union[datetime, None]


class ReactionRollupType(TypedDict):
    """Reaction Rollup"""

    url: str
    total_count: int
    plus_one: int
    minus_one: int
    laugh: int
    confused: int
    heart: int
    hooray: int
    eyes: int
    rocket: int


class IssueType(TypedDict):
    """Issue

    Issues are a great way to keep track of tasks, enhancements, and bugs for your
    projects.
    """

    id: int
    node_id: str
    url: str
    repository_url: str
    labels_url: str
    comments_url: str
    events_url: str
    html_url: str
    number: int
    state: str
    state_reason: NotRequired[
        Union[None, Literal["completed", "reopened", "not_planned"]]
    ]
    title: str
    body: NotRequired[Union[str, None]]
    user: Union[None, SimpleUserType]
    labels: List[Union[str, IssuePropLabelsItemsOneof1Type]]
    assignee: Union[None, SimpleUserType]
    assignees: NotRequired[Union[List[SimpleUserType], None]]
    milestone: Union[None, MilestoneType]
    locked: bool
    active_lock_reason: NotRequired[Union[str, None]]
    comments: int
    pull_request: NotRequired[IssuePropPullRequestType]
    closed_at: Union[datetime, None]
    created_at: datetime
    updated_at: datetime
    draft: NotRequired[bool]
    closed_by: NotRequired[Union[None, SimpleUserType]]
    body_html: NotRequired[Union[str, None]]
    body_text: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    repository: NotRequired[RepositoryType]
    performed_via_github_app: NotRequired[Union[None, IntegrationType]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    reactions: NotRequired[ReactionRollupType]


class IssuePropLabelsItemsOneof1Type(TypedDict):
    """IssuePropLabelsItemsOneof1"""

    id: NotRequired[int]
    node_id: NotRequired[str]
    url: NotRequired[str]
    name: NotRequired[str]
    description: NotRequired[Union[str, None]]
    color: NotRequired[Union[str, None]]
    default: NotRequired[bool]


class IssuePropPullRequestType(TypedDict):
    """IssuePropPullRequest"""

    merged_at: NotRequired[Union[datetime, None]]
    diff_url: Union[str, None]
    html_url: Union[str, None]
    patch_url: Union[str, None]
    url: Union[str, None]


class IssueCommentType(TypedDict):
    """Issue Comment

    Comments provide a way for people to collaborate on an issue.
    """

    id: int
    node_id: str
    url: str
    body: NotRequired[str]
    body_text: NotRequired[str]
    body_html: NotRequired[str]
    html_url: str
    user: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    issue_url: str
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    performed_via_github_app: NotRequired[Union[None, IntegrationType]]
    reactions: NotRequired[ReactionRollupType]


class EventType(TypedDict):
    """Event

    Event
    """

    id: str
    type: Union[str, None]
    actor: ActorType
    repo: EventPropRepoType
    org: NotRequired[ActorType]
    payload: EventPropPayloadType
    public: bool
    created_at: Union[datetime, None]


class EventPropRepoType(TypedDict):
    """EventPropRepo"""

    id: int
    name: str
    url: str


class EventPropPayloadType(TypedDict):
    """EventPropPayload"""

    action: NotRequired[str]
    issue: NotRequired[IssueType]
    comment: NotRequired[IssueCommentType]
    pages: NotRequired[List[EventPropPayloadPropPagesItemsType]]


class EventPropPayloadPropPagesItemsType(TypedDict):
    """EventPropPayloadPropPagesItems"""

    page_name: NotRequired[str]
    title: NotRequired[str]
    summary: NotRequired[Union[str, None]]
    action: NotRequired[str]
    sha: NotRequired[str]
    html_url: NotRequired[str]


class LinkWithTypeType(TypedDict):
    """Link With Type

    Hypermedia Link with Type
    """

    href: str
    type: str


class FeedType(TypedDict):
    """Feed

    Feed
    """

    timeline_url: str
    user_url: str
    current_user_public_url: NotRequired[str]
    current_user_url: NotRequired[str]
    current_user_actor_url: NotRequired[str]
    current_user_organization_url: NotRequired[str]
    current_user_organization_urls: NotRequired[List[str]]
    security_advisories_url: NotRequired[str]
    repository_discussions_url: NotRequired[str]
    repository_discussions_category_url: NotRequired[str]
    links: FeedPropLinksType


class FeedPropLinksType(TypedDict):
    """FeedPropLinks"""

    timeline: LinkWithTypeType
    user: LinkWithTypeType
    security_advisories: NotRequired[LinkWithTypeType]
    current_user: NotRequired[LinkWithTypeType]
    current_user_public: NotRequired[LinkWithTypeType]
    current_user_actor: NotRequired[LinkWithTypeType]
    current_user_organization: NotRequired[LinkWithTypeType]
    current_user_organizations: NotRequired[List[LinkWithTypeType]]
    repository_discussions: NotRequired[LinkWithTypeType]
    repository_discussions_category: NotRequired[LinkWithTypeType]


class BaseGistType(TypedDict):
    """Base Gist

    Base Gist
    """

    url: str
    forks_url: str
    commits_url: str
    id: str
    node_id: str
    git_pull_url: str
    git_push_url: str
    html_url: str
    files: BaseGistPropFilesType
    public: bool
    created_at: datetime
    updated_at: datetime
    description: Union[str, None]
    comments: int
    user: Union[None, SimpleUserType]
    comments_url: str
    owner: NotRequired[SimpleUserType]
    truncated: NotRequired[bool]
    forks: NotRequired[List[Any]]
    history: NotRequired[List[Any]]


class BaseGistPropFilesType(TypedDict):
    """BaseGistPropFiles"""


class PublicUserType(TypedDict):
    """Public User

    Public User
    """

    login: str
    id: int
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    following_url: str
    gists_url: str
    starred_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    events_url: str
    received_events_url: str
    type: str
    site_admin: bool
    name: Union[str, None]
    company: Union[str, None]
    blog: Union[str, None]
    location: Union[str, None]
    email: Union[str, None]
    hireable: Union[bool, None]
    bio: Union[str, None]
    twitter_username: NotRequired[Union[str, None]]
    public_repos: int
    public_gists: int
    followers: int
    following: int
    created_at: datetime
    updated_at: datetime
    plan: NotRequired[PublicUserPropPlanType]
    suspended_at: NotRequired[Union[datetime, None]]
    private_gists: NotRequired[int]
    total_private_repos: NotRequired[int]
    owned_private_repos: NotRequired[int]
    disk_usage: NotRequired[int]
    collaborators: NotRequired[int]


class PublicUserPropPlanType(TypedDict):
    """PublicUserPropPlan"""

    collaborators: int
    name: str
    space: int
    private_repos: int


class GistHistoryType(TypedDict):
    """Gist History

    Gist History
    """

    user: NotRequired[Union[None, SimpleUserType]]
    version: NotRequired[str]
    committed_at: NotRequired[datetime]
    change_status: NotRequired[GistHistoryPropChangeStatusType]
    url: NotRequired[str]


class GistHistoryPropChangeStatusType(TypedDict):
    """GistHistoryPropChangeStatus"""

    total: NotRequired[int]
    additions: NotRequired[int]
    deletions: NotRequired[int]


class GistSimpleType(TypedDict):
    """Gist Simple

    Gist Simple
    """

    forks: NotRequired[Union[List[GistSimplePropForksItemsType], None]]
    history: NotRequired[Union[List[GistHistoryType], None]]
    fork_of: NotRequired[Union[GistSimplePropForkOfType, None]]
    url: NotRequired[str]
    forks_url: NotRequired[str]
    commits_url: NotRequired[str]
    id: NotRequired[str]
    node_id: NotRequired[str]
    git_pull_url: NotRequired[str]
    git_push_url: NotRequired[str]
    html_url: NotRequired[str]
    files: NotRequired[GistSimplePropFilesType]
    public: NotRequired[bool]
    created_at: NotRequired[str]
    updated_at: NotRequired[str]
    description: NotRequired[Union[str, None]]
    comments: NotRequired[int]
    user: NotRequired[Union[str, None]]
    comments_url: NotRequired[str]
    owner: NotRequired[SimpleUserType]
    truncated: NotRequired[bool]


class GistSimplePropForksItemsType(TypedDict):
    """GistSimplePropForksItems"""

    id: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[PublicUserType]
    created_at: NotRequired[datetime]
    updated_at: NotRequired[datetime]


class GistSimplePropForkOfPropFilesType(TypedDict):
    """GistSimplePropForkOfPropFiles"""


class GistSimplePropForkOfType(TypedDict):
    """Gist

    Gist
    """

    url: str
    forks_url: str
    commits_url: str
    id: str
    node_id: str
    git_pull_url: str
    git_push_url: str
    html_url: str
    files: GistSimplePropForkOfPropFilesType
    public: bool
    created_at: datetime
    updated_at: datetime
    description: Union[str, None]
    comments: int
    user: Union[None, SimpleUserType]
    comments_url: str
    owner: NotRequired[Union[None, SimpleUserType]]
    truncated: NotRequired[bool]
    forks: NotRequired[List[Any]]
    history: NotRequired[List[Any]]


class GistSimplePropFilesType(TypedDict):
    """GistSimplePropFiles"""


class GistCommentType(TypedDict):
    """Gist Comment

    A comment made to a gist.
    """

    id: int
    node_id: str
    url: str
    body: str
    user: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]


class GistCommitType(TypedDict):
    """Gist Commit

    Gist Commit
    """

    url: str
    version: str
    user: Union[None, SimpleUserType]
    change_status: GistCommitPropChangeStatusType
    committed_at: datetime


class GistCommitPropChangeStatusType(TypedDict):
    """GistCommitPropChangeStatus"""

    total: NotRequired[int]
    additions: NotRequired[int]
    deletions: NotRequired[int]


class GitignoreTemplateType(TypedDict):
    """Gitignore Template

    Gitignore Template
    """

    name: str
    source: str


class LicenseType(TypedDict):
    """License

    License
    """

    key: str
    name: str
    spdx_id: Union[str, None]
    url: Union[str, None]
    node_id: str
    html_url: str
    description: str
    implementation: str
    permissions: List[str]
    conditions: List[str]
    limitations: List[str]
    body: str
    featured: bool


class MarketplaceListingPlanType(TypedDict):
    """Marketplace Listing Plan

    Marketplace Listing Plan
    """

    url: str
    accounts_url: str
    id: int
    number: int
    name: str
    description: str
    monthly_price_in_cents: int
    yearly_price_in_cents: int
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    has_free_trial: bool
    unit_name: Union[str, None]
    state: str
    bullets: List[str]


class MarketplacePurchaseType(TypedDict):
    """Marketplace Purchase

    Marketplace Purchase
    """

    url: str
    type: str
    id: int
    login: str
    organization_billing_email: NotRequired[str]
    email: NotRequired[Union[str, None]]
    marketplace_pending_change: NotRequired[
        Union[MarketplacePurchasePropMarketplacePendingChangeType, None]
    ]
    marketplace_purchase: MarketplacePurchasePropMarketplacePurchaseType


class MarketplacePurchasePropMarketplacePendingChangeType(TypedDict):
    """MarketplacePurchasePropMarketplacePendingChange"""

    is_installed: NotRequired[bool]
    effective_date: NotRequired[str]
    unit_count: NotRequired[Union[int, None]]
    id: NotRequired[int]
    plan: NotRequired[MarketplaceListingPlanType]


class MarketplacePurchasePropMarketplacePurchaseType(TypedDict):
    """MarketplacePurchasePropMarketplacePurchase"""

    billing_cycle: NotRequired[str]
    next_billing_date: NotRequired[Union[str, None]]
    is_installed: NotRequired[bool]
    unit_count: NotRequired[Union[int, None]]
    on_free_trial: NotRequired[bool]
    free_trial_ends_on: NotRequired[Union[str, None]]
    updated_at: NotRequired[str]
    plan: NotRequired[MarketplaceListingPlanType]


class ApiOverviewType(TypedDict):
    """Api Overview

    Api Overview
    """

    verifiable_password_authentication: bool
    ssh_key_fingerprints: NotRequired[ApiOverviewPropSshKeyFingerprintsType]
    ssh_keys: NotRequired[List[str]]
    hooks: NotRequired[List[str]]
    github_enterprise_importer: NotRequired[List[str]]
    web: NotRequired[List[str]]
    api: NotRequired[List[str]]
    git: NotRequired[List[str]]
    packages: NotRequired[List[str]]
    pages: NotRequired[List[str]]
    importer: NotRequired[List[str]]
    actions: NotRequired[List[str]]
    dependabot: NotRequired[List[str]]
    domains: NotRequired[ApiOverviewPropDomainsType]


class ApiOverviewPropSshKeyFingerprintsType(TypedDict):
    """ApiOverviewPropSshKeyFingerprints"""

    sha256_rsa: NotRequired[str]
    sha256_dsa: NotRequired[str]
    sha256_ecdsa: NotRequired[str]
    sha256_ed25519: NotRequired[str]


class ApiOverviewPropDomainsType(TypedDict):
    """ApiOverviewPropDomains"""

    website: NotRequired[List[str]]
    codespaces: NotRequired[List[str]]
    copilot: NotRequired[List[str]]
    packages: NotRequired[List[str]]
    actions: NotRequired[List[str]]


class SecurityAndAnalysisPropAdvancedSecurityType(TypedDict):
    """SecurityAndAnalysisPropAdvancedSecurity"""

    status: NotRequired[Literal["enabled", "disabled"]]


class SecurityAndAnalysisPropDependabotSecurityUpdatesType(TypedDict):
    """SecurityAndAnalysisPropDependabotSecurityUpdates

    Enable or disable Dependabot security updates for the repository.
    """

    status: NotRequired[Literal["enabled", "disabled"]]


class SecurityAndAnalysisPropSecretScanningType(TypedDict):
    """SecurityAndAnalysisPropSecretScanning"""

    status: NotRequired[Literal["enabled", "disabled"]]


class SecurityAndAnalysisPropSecretScanningPushProtectionType(TypedDict):
    """SecurityAndAnalysisPropSecretScanningPushProtection"""

    status: NotRequired[Literal["enabled", "disabled"]]


class SecurityAndAnalysisType(TypedDict):
    """SecurityAndAnalysis"""

    advanced_security: NotRequired[SecurityAndAnalysisPropAdvancedSecurityType]
    dependabot_security_updates: NotRequired[
        SecurityAndAnalysisPropDependabotSecurityUpdatesType
    ]
    secret_scanning: NotRequired[SecurityAndAnalysisPropSecretScanningType]
    secret_scanning_push_protection: NotRequired[
        SecurityAndAnalysisPropSecretScanningPushProtectionType
    ]


class MinimalRepositoryType(TypedDict):
    """Minimal Repository

    Minimal Repository
    """

    id: int
    node_id: str
    name: str
    full_name: str
    owner: SimpleUserType
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: NotRequired[str]
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    ssh_url: NotRequired[str]
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    clone_url: NotRequired[str]
    mirror_url: NotRequired[Union[str, None]]
    hooks_url: str
    svn_url: NotRequired[str]
    homepage: NotRequired[Union[str, None]]
    language: NotRequired[Union[str, None]]
    forks_count: NotRequired[int]
    stargazers_count: NotRequired[int]
    watchers_count: NotRequired[int]
    size: NotRequired[int]
    default_branch: NotRequired[str]
    open_issues_count: NotRequired[int]
    is_template: NotRequired[bool]
    topics: NotRequired[List[str]]
    has_issues: NotRequired[bool]
    has_projects: NotRequired[bool]
    has_wiki: NotRequired[bool]
    has_pages: NotRequired[bool]
    has_downloads: NotRequired[bool]
    has_discussions: NotRequired[bool]
    archived: NotRequired[bool]
    disabled: NotRequired[bool]
    visibility: NotRequired[str]
    pushed_at: NotRequired[Union[datetime, None]]
    created_at: NotRequired[Union[datetime, None]]
    updated_at: NotRequired[Union[datetime, None]]
    permissions: NotRequired[MinimalRepositoryPropPermissionsType]
    role_name: NotRequired[str]
    temp_clone_token: NotRequired[Union[str, None]]
    delete_branch_on_merge: NotRequired[bool]
    subscribers_count: NotRequired[int]
    network_count: NotRequired[int]
    code_of_conduct: NotRequired[CodeOfConductType]
    license_: NotRequired[Union[MinimalRepositoryPropLicenseType, None]]
    forks: NotRequired[int]
    open_issues: NotRequired[int]
    watchers: NotRequired[int]
    allow_forking: NotRequired[bool]
    web_commit_signoff_required: NotRequired[bool]
    security_and_analysis: NotRequired[Union[SecurityAndAnalysisType, None]]


class MinimalRepositoryPropPermissionsType(TypedDict):
    """MinimalRepositoryPropPermissions"""

    admin: NotRequired[bool]
    maintain: NotRequired[bool]
    push: NotRequired[bool]
    triage: NotRequired[bool]
    pull: NotRequired[bool]


class MinimalRepositoryPropLicenseType(TypedDict):
    """MinimalRepositoryPropLicense"""

    key: NotRequired[str]
    name: NotRequired[str]
    spdx_id: NotRequired[str]
    url: NotRequired[str]
    node_id: NotRequired[str]


class ThreadType(TypedDict):
    """Thread

    Thread
    """

    id: str
    repository: MinimalRepositoryType
    subject: ThreadPropSubjectType
    reason: str
    unread: bool
    updated_at: str
    last_read_at: Union[str, None]
    url: str
    subscription_url: str


class ThreadPropSubjectType(TypedDict):
    """ThreadPropSubject"""

    title: str
    url: str
    latest_comment_url: str
    type: str


class ThreadSubscriptionType(TypedDict):
    """Thread Subscription

    Thread Subscription
    """

    subscribed: bool
    ignored: bool
    reason: Union[str, None]
    created_at: Union[datetime, None]
    url: str
    thread_url: NotRequired[str]
    repository_url: NotRequired[str]


class OrganizationSimpleType(TypedDict):
    """Organization Simple

    A GitHub organization.
    """

    login: str
    id: int
    node_id: str
    url: str
    repos_url: str
    events_url: str
    hooks_url: str
    issues_url: str
    members_url: str
    public_members_url: str
    avatar_url: str
    description: Union[str, None]


class OrganizationFullType(TypedDict):
    """Organization Full

    Organization Full
    """

    login: str
    id: int
    node_id: str
    url: str
    repos_url: str
    events_url: str
    hooks_url: str
    issues_url: str
    members_url: str
    public_members_url: str
    avatar_url: str
    description: Union[str, None]
    name: NotRequired[Union[str, None]]
    company: NotRequired[Union[str, None]]
    blog: NotRequired[Union[str, None]]
    location: NotRequired[Union[str, None]]
    email: NotRequired[Union[str, None]]
    twitter_username: NotRequired[Union[str, None]]
    is_verified: NotRequired[bool]
    has_organization_projects: bool
    has_repository_projects: bool
    public_repos: int
    public_gists: int
    followers: int
    following: int
    html_url: str
    type: str
    total_private_repos: NotRequired[int]
    owned_private_repos: NotRequired[int]
    private_gists: NotRequired[Union[int, None]]
    disk_usage: NotRequired[Union[int, None]]
    collaborators: NotRequired[Union[int, None]]
    billing_email: NotRequired[Union[str, None]]
    plan: NotRequired[OrganizationFullPropPlanType]
    default_repository_permission: NotRequired[Union[str, None]]
    members_can_create_repositories: NotRequired[Union[bool, None]]
    two_factor_requirement_enabled: NotRequired[Union[bool, None]]
    members_allowed_repository_creation_type: NotRequired[str]
    members_can_create_public_repositories: NotRequired[bool]
    members_can_create_private_repositories: NotRequired[bool]
    members_can_create_internal_repositories: NotRequired[bool]
    members_can_create_pages: NotRequired[bool]
    members_can_create_public_pages: NotRequired[bool]
    members_can_create_private_pages: NotRequired[bool]
    members_can_fork_private_repositories: NotRequired[Union[bool, None]]
    web_commit_signoff_required: NotRequired[bool]
    advanced_security_enabled_for_new_repositories: NotRequired[bool]
    dependabot_alerts_enabled_for_new_repositories: NotRequired[bool]
    dependabot_security_updates_enabled_for_new_repositories: NotRequired[bool]
    dependency_graph_enabled_for_new_repositories: NotRequired[bool]
    secret_scanning_enabled_for_new_repositories: NotRequired[bool]
    secret_scanning_push_protection_enabled_for_new_repositories: NotRequired[bool]
    secret_scanning_push_protection_custom_link_enabled: NotRequired[bool]
    secret_scanning_push_protection_custom_link: NotRequired[Union[str, None]]
    created_at: datetime
    updated_at: datetime
    archived_at: Union[datetime, None]


class OrganizationFullPropPlanType(TypedDict):
    """OrganizationFullPropPlan"""

    name: str
    space: int
    private_repos: int
    filled_seats: NotRequired[int]
    seats: NotRequired[int]


class ActionsCacheUsageOrgEnterpriseType(TypedDict):
    """ActionsCacheUsageOrgEnterprise"""

    total_active_caches_count: int
    total_active_caches_size_in_bytes: int


class ActionsCacheUsageByRepositoryType(TypedDict):
    """Actions Cache Usage by repository

    GitHub Actions Cache Usage by repository.
    """

    full_name: str
    active_caches_size_in_bytes: int
    active_caches_count: int


class OidcCustomSubType(TypedDict):
    """Actions OIDC Subject customization

    Actions OIDC Subject customization
    """

    include_claim_keys: List[str]


class EmptyObjectType(TypedDict):
    """Empty Object

    An object without any properties.
    """


class ActionsOrganizationPermissionsType(TypedDict):
    """ActionsOrganizationPermissions"""

    enabled_repositories: Literal["all", "none", "selected"]
    selected_repositories_url: NotRequired[str]
    allowed_actions: NotRequired[Literal["all", "local_only", "selected"]]
    selected_actions_url: NotRequired[str]


class SelectedActionsType(TypedDict):
    """SelectedActions"""

    github_owned_allowed: NotRequired[bool]
    verified_allowed: NotRequired[bool]
    patterns_allowed: NotRequired[List[str]]


class ActionsGetDefaultWorkflowPermissionsType(TypedDict):
    """ActionsGetDefaultWorkflowPermissions"""

    default_workflow_permissions: Literal["read", "write"]
    can_approve_pull_request_reviews: bool


class ActionsSetDefaultWorkflowPermissionsType(TypedDict):
    """ActionsSetDefaultWorkflowPermissions"""

    default_workflow_permissions: NotRequired[Literal["read", "write"]]
    can_approve_pull_request_reviews: NotRequired[bool]


class RunnerLabelType(TypedDict):
    """Self hosted runner label

    A label for a self hosted runner
    """

    id: NotRequired[int]
    name: str
    type: NotRequired[Literal["read-only", "custom"]]


class RunnerType(TypedDict):
    """Self hosted runners

    A self hosted runner
    """

    id: int
    runner_group_id: NotRequired[int]
    name: str
    os: str
    status: str
    busy: bool
    labels: List[RunnerLabelType]


class RunnerApplicationType(TypedDict):
    """Runner Application

    Runner Application
    """

    os: str
    architecture: str
    download_url: str
    filename: str
    temp_download_token: NotRequired[str]
    sha256_checksum: NotRequired[str]


class AuthenticationTokenType(TypedDict):
    """Authentication Token

    Authentication Token
    """

    token: str
    expires_at: datetime
    permissions: NotRequired[AuthenticationTokenPropPermissionsType]
    repositories: NotRequired[List[RepositoryType]]
    single_file: NotRequired[Union[str, None]]
    repository_selection: NotRequired[Literal["all", "selected"]]


class AuthenticationTokenPropPermissionsType(TypedDict):
    """AuthenticationTokenPropPermissions

    Examples:
        {'issues': 'read', 'deployments': 'write'}
    """


class OrganizationActionsSecretType(TypedDict):
    """Actions Secret for an Organization

    Secrets for GitHub Actions for an organization.
    """

    name: str
    created_at: datetime
    updated_at: datetime
    visibility: Literal["all", "private", "selected"]
    selected_repositories_url: NotRequired[str]


class ActionsPublicKeyType(TypedDict):
    """ActionsPublicKey

    The public key used for setting Actions Secrets.
    """

    key_id: str
    key: str
    id: NotRequired[int]
    url: NotRequired[str]
    title: NotRequired[str]
    created_at: NotRequired[str]


class OrganizationActionsVariableType(TypedDict):
    """Actions Variable for an Organization

    Organization variable for GitHub Actions.
    """

    name: str
    value: str
    created_at: datetime
    updated_at: datetime
    visibility: Literal["all", "private", "selected"]
    selected_repositories_url: NotRequired[str]


class CodeScanningAlertRuleSummaryType(TypedDict):
    """CodeScanningAlertRuleSummary"""

    id: NotRequired[Union[str, None]]
    name: NotRequired[str]
    tags: NotRequired[Union[List[str], None]]
    severity: NotRequired[Union[None, Literal["none", "note", "warning", "error"]]]
    security_severity_level: NotRequired[
        Union[None, Literal["low", "medium", "high", "critical"]]
    ]
    description: NotRequired[str]


class CodeScanningAnalysisToolType(TypedDict):
    """CodeScanningAnalysisTool"""

    name: NotRequired[str]
    version: NotRequired[Union[str, None]]
    guid: NotRequired[Union[str, None]]


class CodeScanningAlertLocationType(TypedDict):
    """CodeScanningAlertLocation

    Describe a region within a file for the alert.
    """

    path: NotRequired[str]
    start_line: NotRequired[int]
    end_line: NotRequired[int]
    start_column: NotRequired[int]
    end_column: NotRequired[int]


class CodeScanningAlertInstanceType(TypedDict):
    """CodeScanningAlertInstance"""

    ref: NotRequired[str]
    analysis_key: NotRequired[str]
    environment: NotRequired[str]
    category: NotRequired[str]
    state: NotRequired[Literal["open", "dismissed", "fixed"]]
    commit_sha: NotRequired[str]
    message: NotRequired[CodeScanningAlertInstancePropMessageType]
    location: NotRequired[CodeScanningAlertLocationType]
    html_url: NotRequired[str]
    classifications: NotRequired[
        List[Union[None, Literal["source", "generated", "test", "library"]]]
    ]


class CodeScanningAlertInstancePropMessageType(TypedDict):
    """CodeScanningAlertInstancePropMessage"""

    text: NotRequired[str]


class CodeScanningOrganizationAlertItemsType(TypedDict):
    """CodeScanningOrganizationAlertItems"""

    number: int
    created_at: datetime
    updated_at: NotRequired[datetime]
    url: str
    html_url: str
    instances_url: str
    state: Literal["open", "dismissed", "fixed"]
    fixed_at: NotRequired[Union[datetime, None]]
    dismissed_by: Union[None, SimpleUserType]
    dismissed_at: Union[datetime, None]
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ]
    dismissed_comment: NotRequired[Union[str, None]]
    rule: CodeScanningAlertRuleSummaryType
    tool: CodeScanningAnalysisToolType
    most_recent_instance: CodeScanningAlertInstanceType
    repository: SimpleRepositoryType


class CodespaceMachineType(TypedDict):
    """Codespace machine

    A description of the machine powering a codespace.
    """

    name: str
    display_name: str
    operating_system: str
    storage_in_bytes: int
    memory_in_bytes: int
    cpus: int
    prebuild_availability: Union[None, Literal["none", "ready", "in_progress"]]


class CodespaceType(TypedDict):
    """Codespace

    A codespace.
    """

    id: int
    name: str
    display_name: NotRequired[Union[str, None]]
    environment_id: Union[str, None]
    owner: SimpleUserType
    billable_owner: SimpleUserType
    repository: MinimalRepositoryType
    machine: Union[None, CodespaceMachineType]
    devcontainer_path: NotRequired[Union[str, None]]
    prebuild: Union[bool, None]
    created_at: datetime
    updated_at: datetime
    last_used_at: datetime
    state: Literal[
        "Unknown",
        "Created",
        "Queued",
        "Provisioning",
        "Available",
        "Awaiting",
        "Unavailable",
        "Deleted",
        "Moved",
        "Shutdown",
        "Archived",
        "Starting",
        "ShuttingDown",
        "Failed",
        "Exporting",
        "Updating",
        "Rebuilding",
    ]
    url: str
    git_status: CodespacePropGitStatusType
    location: Literal["EastUs", "SouthEastAsia", "WestEurope", "WestUs2"]
    idle_timeout_minutes: Union[int, None]
    web_url: str
    machines_url: str
    start_url: str
    stop_url: str
    publish_url: NotRequired[Union[str, None]]
    pulls_url: Union[str, None]
    recent_folders: List[str]
    runtime_constraints: NotRequired[CodespacePropRuntimeConstraintsType]
    pending_operation: NotRequired[Union[bool, None]]
    pending_operation_disabled_reason: NotRequired[Union[str, None]]
    idle_timeout_notice: NotRequired[Union[str, None]]
    retention_period_minutes: NotRequired[Union[int, None]]
    retention_expires_at: NotRequired[Union[datetime, None]]
    last_known_stop_notice: NotRequired[Union[str, None]]


class CodespacePropGitStatusType(TypedDict):
    """CodespacePropGitStatus

    Details about the codespace's git repository.
    """

    ahead: NotRequired[int]
    behind: NotRequired[int]
    has_unpushed_changes: NotRequired[bool]
    has_uncommitted_changes: NotRequired[bool]
    ref: NotRequired[str]


class CodespacePropRuntimeConstraintsType(TypedDict):
    """CodespacePropRuntimeConstraints"""

    allowed_port_privacy_settings: NotRequired[Union[List[str], None]]


class CodespacesOrgSecretType(TypedDict):
    """Codespaces Secret

    Secrets for a GitHub Codespace.
    """

    name: str
    created_at: datetime
    updated_at: datetime
    visibility: Literal["all", "private", "selected"]
    selected_repositories_url: NotRequired[str]


class CodespacesPublicKeyType(TypedDict):
    """CodespacesPublicKey

    The public key used for setting Codespaces secrets.
    """

    key_id: str
    key: str
    id: NotRequired[int]
    url: NotRequired[str]
    title: NotRequired[str]
    created_at: NotRequired[str]


class CopilotSeatBreakdownType(TypedDict):
    """Copilot Business Seat Breakdown

    The breakdown of Copilot Business seats for the organization.
    """

    total: NotRequired[int]
    added_this_cycle: NotRequired[int]
    pending_cancellation: NotRequired[int]
    pending_invitation: NotRequired[int]
    active_this_cycle: NotRequired[int]
    inactive_this_cycle: NotRequired[int]


class CopilotOrganizationDetailsType(TypedDict):
    """Copilot Business Organization Details

    Information about the seat breakdown and policies set for an organization with a
    Copilot Business subscription.
    """

    seat_breakdown: CopilotSeatBreakdownType
    public_code_suggestions: Literal["allow", "block", "unconfigured", "unknown"]
    copilot_chat: NotRequired[Literal["enabled", "disabled", "unconfigured"]]
    seat_management_setting: Literal[
        "assign_all", "assign_selected", "disabled", "unconfigured"
    ]


class TeamSimpleType(TypedDict):
    """Team Simple

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int
    node_id: str
    url: str
    members_url: str
    name: str
    description: Union[str, None]
    permission: str
    privacy: NotRequired[str]
    notification_setting: NotRequired[str]
    html_url: str
    repositories_url: str
    slug: str
    ldap_dn: NotRequired[str]


class TeamType(TypedDict):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int
    node_id: str
    name: str
    slug: str
    description: Union[str, None]
    privacy: NotRequired[str]
    notification_setting: NotRequired[str]
    permission: str
    permissions: NotRequired[TeamPropPermissionsType]
    url: str
    html_url: str
    members_url: str
    repositories_url: str
    parent: Union[None, TeamSimpleType]


class TeamPropPermissionsType(TypedDict):
    """TeamPropPermissions"""

    pull: bool
    triage: bool
    push: bool
    maintain: bool
    admin: bool


class OrganizationType(TypedDict):
    """Organization

    GitHub account for managing multiple users, teams, and repositories
    """

    login: str
    url: str
    id: int
    node_id: str
    repos_url: str
    events_url: str
    hooks_url: str
    issues_url: str
    members_url: str
    public_members_url: str
    avatar_url: str
    description: Union[str, None]
    blog: NotRequired[str]
    html_url: str
    name: NotRequired[str]
    company: NotRequired[str]
    location: NotRequired[str]
    email: NotRequired[str]
    has_organization_projects: bool
    has_repository_projects: bool
    is_verified: NotRequired[bool]
    public_repos: int
    public_gists: int
    followers: int
    following: int
    type: str
    created_at: datetime
    updated_at: datetime
    plan: NotRequired[OrganizationPropPlanType]


class OrganizationPropPlanType(TypedDict):
    """OrganizationPropPlan"""

    name: NotRequired[str]
    space: NotRequired[int]
    private_repos: NotRequired[int]
    filled_seats: NotRequired[int]
    seats: NotRequired[int]


class CopilotSeatDetailsType(TypedDict):
    """Copilot Business Seat Detail

    Information about a Copilot Business seat assignment for a user, team, or
    organization.
    """

    assignee: Union[SimpleUserType, TeamType, OrganizationType]
    assigning_team: NotRequired[Union[TeamType, None]]
    pending_cancellation_date: NotRequired[Union[date, None]]
    last_activity_at: NotRequired[Union[datetime, None]]
    last_activity_editor: NotRequired[Union[str, None]]
    created_at: datetime
    updated_at: NotRequired[datetime]


class OrganizationDependabotSecretType(TypedDict):
    """Dependabot Secret for an Organization

    Secrets for GitHub Dependabot for an organization.
    """

    name: str
    created_at: datetime
    updated_at: datetime
    visibility: Literal["all", "private", "selected"]
    selected_repositories_url: NotRequired[str]


class DependabotPublicKeyType(TypedDict):
    """DependabotPublicKey

    The public key used for setting Dependabot Secrets.
    """

    key_id: str
    key: str


class PackageType(TypedDict):
    """Package

    A software package
    """

    id: int
    name: str
    package_type: Literal["npm", "maven", "rubygems", "docker", "nuget", "container"]
    url: str
    html_url: str
    version_count: int
    visibility: Literal["private", "public"]
    owner: NotRequired[Union[None, SimpleUserType]]
    repository: NotRequired[Union[None, MinimalRepositoryType]]
    created_at: datetime
    updated_at: datetime


class OrganizationInvitationType(TypedDict):
    """Organization Invitation

    Organization Invitation
    """

    id: int
    login: Union[str, None]
    email: Union[str, None]
    role: str
    created_at: str
    failed_at: NotRequired[Union[str, None]]
    failed_reason: NotRequired[Union[str, None]]
    inviter: SimpleUserType
    team_count: int
    node_id: str
    invitation_teams_url: str
    invitation_source: NotRequired[str]


class OrgHookType(TypedDict):
    """Org Hook

    Org Hook
    """

    id: int
    url: str
    ping_url: str
    deliveries_url: NotRequired[str]
    name: str
    events: List[str]
    active: bool
    config: OrgHookPropConfigType
    updated_at: datetime
    created_at: datetime
    type: str


class OrgHookPropConfigType(TypedDict):
    """OrgHookPropConfig"""

    url: NotRequired[str]
    insecure_ssl: NotRequired[str]
    content_type: NotRequired[str]
    secret: NotRequired[str]


class InteractionLimitResponseType(TypedDict):
    """Interaction Limits

    Interaction limit settings.
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"]
    origin: str
    expires_at: datetime


class InteractionLimitType(TypedDict):
    """Interaction Restrictions

    Limit interactions to a specific type of user for a specified duration
    """

    limit: Literal["existing_users", "contributors_only", "collaborators_only"]
    expiry: NotRequired[
        Literal["one_day", "three_days", "one_week", "one_month", "six_months"]
    ]


class OrgMembershipType(TypedDict):
    """Org Membership

    Org Membership
    """

    url: str
    state: Literal["active", "pending"]
    role: Literal["admin", "member", "billing_manager"]
    organization_url: str
    organization: OrganizationSimpleType
    user: Union[None, SimpleUserType]
    permissions: NotRequired[OrgMembershipPropPermissionsType]


class OrgMembershipPropPermissionsType(TypedDict):
    """OrgMembershipPropPermissions"""

    can_create_repository: bool


class MigrationType(TypedDict):
    """Migration

    A migration.
    """

    id: int
    owner: Union[None, SimpleUserType]
    guid: str
    state: str
    lock_repositories: bool
    exclude_metadata: bool
    exclude_git_data: bool
    exclude_attachments: bool
    exclude_releases: bool
    exclude_owner_projects: bool
    org_metadata_only: bool
    repositories: List[RepositoryType]
    url: str
    created_at: datetime
    updated_at: datetime
    node_id: str
    archive_url: NotRequired[str]
    exclude: NotRequired[List[str]]


class OrganizationFineGrainedPermissionType(TypedDict):
    """Organization Fine-Grained Permission

    A fine-grained permission that protects organization resources.
    """

    name: str
    description: str


class OrganizationRoleType(TypedDict):
    """Organization Role

    Organization roles
    """

    id: int
    name: str
    description: NotRequired[Union[str, None]]
    permissions: List[str]
    organization: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime


class PackageVersionType(TypedDict):
    """Package Version

    A version of a software package
    """

    id: int
    name: str
    url: str
    package_html_url: str
    html_url: NotRequired[str]
    license_: NotRequired[str]
    description: NotRequired[str]
    created_at: datetime
    updated_at: datetime
    deleted_at: NotRequired[datetime]
    metadata: NotRequired[PackageVersionPropMetadataType]


class PackageVersionPropMetadataType(TypedDict):
    """Package Version Metadata"""

    package_type: Literal["npm", "maven", "rubygems", "docker", "nuget", "container"]
    container: NotRequired[PackageVersionPropMetadataPropContainerType]
    docker: NotRequired[PackageVersionPropMetadataPropDockerType]


class PackageVersionPropMetadataPropContainerType(TypedDict):
    """Container Metadata"""

    tags: List[str]


class PackageVersionPropMetadataPropDockerType(TypedDict):
    """Docker Metadata"""

    tag: NotRequired[List[str]]


class OrganizationProgrammaticAccessGrantRequestType(TypedDict):
    """Simple Organization Programmatic Access Grant Request

    Minimal representation of an organization programmatic access grant request for
    enumerations
    """

    id: int
    reason: Union[str, None]
    owner: SimpleUserType
    repository_selection: Literal["none", "all", "subset"]
    repositories_url: str
    permissions: OrganizationProgrammaticAccessGrantRequestPropPermissionsType
    created_at: str
    token_expired: bool
    token_expires_at: Union[str, None]
    token_last_used_at: Union[str, None]


class OrganizationProgrammaticAccessGrantRequestPropPermissionsType(TypedDict):
    """OrganizationProgrammaticAccessGrantRequestPropPermissions

    Permissions requested, categorized by type of permission.
    """

    organization: NotRequired[
        OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganizationType
    ]
    repository: NotRequired[
        OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepositoryType
    ]
    other: NotRequired[
        OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOtherType
    ]


class OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganizationType(
    TypedDict
):
    """OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOrganization"""


class OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepositoryType(
    TypedDict
):
    """OrganizationProgrammaticAccessGrantRequestPropPermissionsPropRepository"""


class OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOtherType(TypedDict):
    """OrganizationProgrammaticAccessGrantRequestPropPermissionsPropOther"""


class OrganizationProgrammaticAccessGrantType(TypedDict):
    """Organization Programmatic Access Grant

    Minimal representation of an organization programmatic access grant for
    enumerations
    """

    id: int
    owner: SimpleUserType
    repository_selection: Literal["none", "all", "subset"]
    repositories_url: str
    permissions: OrganizationProgrammaticAccessGrantPropPermissionsType
    access_granted_at: str
    token_expired: bool
    token_expires_at: Union[str, None]
    token_last_used_at: Union[str, None]


class OrganizationProgrammaticAccessGrantPropPermissionsType(TypedDict):
    """OrganizationProgrammaticAccessGrantPropPermissions

    Permissions requested, categorized by type of permission.
    """

    organization: NotRequired[
        OrganizationProgrammaticAccessGrantPropPermissionsPropOrganizationType
    ]
    repository: NotRequired[
        OrganizationProgrammaticAccessGrantPropPermissionsPropRepositoryType
    ]
    other: NotRequired[OrganizationProgrammaticAccessGrantPropPermissionsPropOtherType]


class OrganizationProgrammaticAccessGrantPropPermissionsPropOrganizationType(TypedDict):
    """OrganizationProgrammaticAccessGrantPropPermissionsPropOrganization"""


class OrganizationProgrammaticAccessGrantPropPermissionsPropRepositoryType(TypedDict):
    """OrganizationProgrammaticAccessGrantPropPermissionsPropRepository"""


class OrganizationProgrammaticAccessGrantPropPermissionsPropOtherType(TypedDict):
    """OrganizationProgrammaticAccessGrantPropPermissionsPropOther"""


class ProjectType(TypedDict):
    """Project

    Projects are a way to organize columns and cards of work.
    """

    owner_url: str
    url: str
    html_url: str
    columns_url: str
    id: int
    node_id: str
    name: str
    body: Union[str, None]
    number: int
    state: str
    creator: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    organization_permission: NotRequired[Literal["read", "write", "admin", "none"]]
    private: NotRequired[bool]


class OrgCustomPropertyType(TypedDict):
    """Organization Custom Property

    Custom property defined on an organization
    """

    property_name: str
    value_type: Literal["string", "single_select"]
    required: NotRequired[bool]
    default_value: NotRequired[Union[str, None]]
    description: NotRequired[Union[str, None]]
    allowed_values: NotRequired[Union[List[str], None]]


class CustomPropertyValueType(TypedDict):
    """Custom Property Value

    Custom property name and associated value
    """

    property_name: str
    value: Union[str, None]


class OrgRepoCustomPropertyValuesType(TypedDict):
    """Organization Repository Custom Property Values

    List of custom property values for a repository
    """

    repository_id: int
    repository_name: str
    repository_full_name: str
    properties: List[CustomPropertyValueType]


class CodeOfConductSimpleType(TypedDict):
    """Code Of Conduct Simple

    Code of Conduct Simple
    """

    url: str
    key: str
    name: str
    html_url: Union[str, None]


class FullRepositoryType(TypedDict):
    """Full Repository

    Full Repository
    """

    id: int
    node_id: str
    name: str
    full_name: str
    owner: SimpleUserType
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    ssh_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    clone_url: str
    mirror_url: Union[str, None]
    hooks_url: str
    svn_url: str
    homepage: Union[str, None]
    language: Union[str, None]
    forks_count: int
    stargazers_count: int
    watchers_count: int
    size: int
    default_branch: str
    open_issues_count: int
    is_template: NotRequired[bool]
    topics: NotRequired[List[str]]
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    has_downloads: NotRequired[bool]
    has_discussions: bool
    archived: bool
    disabled: bool
    visibility: NotRequired[str]
    pushed_at: datetime
    created_at: datetime
    updated_at: datetime
    permissions: NotRequired[FullRepositoryPropPermissionsType]
    allow_rebase_merge: NotRequired[bool]
    template_repository: NotRequired[Union[None, RepositoryType]]
    temp_clone_token: NotRequired[Union[str, None]]
    allow_squash_merge: NotRequired[bool]
    allow_auto_merge: NotRequired[bool]
    delete_branch_on_merge: NotRequired[bool]
    allow_merge_commit: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    use_squash_pr_title_as_default: NotRequired[bool]
    squash_merge_commit_title: NotRequired[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]]
    squash_merge_commit_message: NotRequired[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ]
    merge_commit_title: NotRequired[Literal["PR_TITLE", "MERGE_MESSAGE"]]
    merge_commit_message: NotRequired[Literal["PR_BODY", "PR_TITLE", "BLANK"]]
    allow_forking: NotRequired[bool]
    web_commit_signoff_required: NotRequired[bool]
    subscribers_count: int
    network_count: int
    license_: Union[None, LicenseSimpleType]
    organization: NotRequired[Union[None, SimpleUserType]]
    parent: NotRequired[RepositoryType]
    source: NotRequired[RepositoryType]
    forks: int
    master_branch: NotRequired[str]
    open_issues: int
    watchers: int
    anonymous_access_enabled: NotRequired[bool]
    code_of_conduct: NotRequired[CodeOfConductSimpleType]
    security_and_analysis: NotRequired[Union[SecurityAndAnalysisType, None]]


class FullRepositoryPropPermissionsType(TypedDict):
    """FullRepositoryPropPermissions"""

    admin: bool
    maintain: NotRequired[bool]
    push: bool
    triage: NotRequired[bool]
    pull: bool


class RepositoryRulesetBypassActorType(TypedDict):
    """Repository Ruleset Bypass Actor

    An actor that can bypass rules in a ruleset
    """

    actor_id: int
    actor_type: Literal["RepositoryRole", "Team", "Integration", "OrganizationAdmin"]
    bypass_mode: Literal["always", "pull_request"]


class RepositoryRulesetConditionsType(TypedDict):
    """Repository ruleset conditions for ref names

    Parameters for a repository ruleset ref name condition
    """

    ref_name: NotRequired[RepositoryRulesetConditionsPropRefNameType]


class RepositoryRulesetConditionsPropRefNameType(TypedDict):
    """RepositoryRulesetConditionsPropRefName"""

    include: NotRequired[List[str]]
    exclude: NotRequired[List[str]]


class RepositoryRulesetConditionsRepositoryNameTargetType(TypedDict):
    """Repository ruleset conditions for repository names

    Parameters for a repository name condition
    """

    repository_name: RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryNameType


class RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryNameType(TypedDict):
    """RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryName"""

    include: NotRequired[List[str]]
    exclude: NotRequired[List[str]]
    protected: NotRequired[bool]


class RepositoryRulesetConditionsRepositoryIdTargetType(TypedDict):
    """Repository ruleset conditions for repository IDs

    Parameters for a repository ID condition
    """

    repository_id: RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryIdType


class RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryIdType(TypedDict):
    """RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryId"""

    repository_ids: NotRequired[List[int]]


class OrgRulesetConditionsOneof0Type(TypedDict):
    """repository_name_and_ref_name

    Conditions to target repositories by name and refs by name
    """

    ref_name: NotRequired[RepositoryRulesetConditionsPropRefNameType]
    repository_name: RepositoryRulesetConditionsRepositoryNameTargetPropRepositoryNameType


class OrgRulesetConditionsOneof1Type(TypedDict):
    """repository_id_and_ref_name

    Conditions to target repositories by id and refs by name
    """

    ref_name: NotRequired[RepositoryRulesetConditionsPropRefNameType]
    repository_id: RepositoryRulesetConditionsRepositoryIdTargetPropRepositoryIdType


class RepositoryRuleCreationType(TypedDict):
    """creation

    Only allow users with bypass permission to create matching refs.
    """

    type: Literal["creation"]


class RepositoryRuleUpdateType(TypedDict):
    """update

    Only allow users with bypass permission to update matching refs.
    """

    type: Literal["update"]
    parameters: NotRequired[RepositoryRuleUpdatePropParametersType]


class RepositoryRuleUpdatePropParametersType(TypedDict):
    """RepositoryRuleUpdatePropParameters"""

    update_allows_fetch_and_merge: bool


class RepositoryRuleDeletionType(TypedDict):
    """deletion

    Only allow users with bypass permissions to delete matching refs.
    """

    type: Literal["deletion"]


class RepositoryRuleRequiredLinearHistoryType(TypedDict):
    """required_linear_history

    Prevent merge commits from being pushed to matching refs.
    """

    type: Literal["required_linear_history"]


class RepositoryRuleRequiredDeploymentsType(TypedDict):
    """required_deployments

    Choose which environments must be successfully deployed to before refs can be
    pushed into a ref that matches this rule.
    """

    type: Literal["required_deployments"]
    parameters: NotRequired[RepositoryRuleRequiredDeploymentsPropParametersType]


class RepositoryRuleRequiredDeploymentsPropParametersType(TypedDict):
    """RepositoryRuleRequiredDeploymentsPropParameters"""

    required_deployment_environments: List[str]


class RepositoryRuleRequiredSignaturesType(TypedDict):
    """required_signatures

    Commits pushed to matching refs must have verified signatures.
    """

    type: Literal["required_signatures"]


class RepositoryRulePullRequestType(TypedDict):
    """pull_request

    Require all commits be made to a non-target branch and submitted via a pull
    request before they can be merged.
    """

    type: Literal["pull_request"]
    parameters: NotRequired[RepositoryRulePullRequestPropParametersType]


class RepositoryRulePullRequestPropParametersType(TypedDict):
    """RepositoryRulePullRequestPropParameters"""

    dismiss_stale_reviews_on_push: bool
    require_code_owner_review: bool
    require_last_push_approval: bool
    required_approving_review_count: int
    required_review_thread_resolution: bool


class RepositoryRuleParamsStatusCheckConfigurationType(TypedDict):
    """StatusCheckConfiguration

    Required status check
    """

    context: str
    integration_id: NotRequired[int]


class RepositoryRuleRequiredStatusChecksType(TypedDict):
    """required_status_checks

    Choose which status checks must pass before the ref is updated. When enabled,
    commits must first be pushed to another ref where the checks pass.
    """

    type: Literal["required_status_checks"]
    parameters: NotRequired[RepositoryRuleRequiredStatusChecksPropParametersType]


class RepositoryRuleRequiredStatusChecksPropParametersType(TypedDict):
    """RepositoryRuleRequiredStatusChecksPropParameters"""

    required_status_checks: List[RepositoryRuleParamsStatusCheckConfigurationType]
    strict_required_status_checks_policy: bool


class RepositoryRuleNonFastForwardType(TypedDict):
    """non_fast_forward

    Prevent users with push access from force pushing to refs.
    """

    type: Literal["non_fast_forward"]


class RepositoryRuleCommitMessagePatternType(TypedDict):
    """commit_message_pattern

    Parameters to be used for the commit_message_pattern rule
    """

    type: Literal["commit_message_pattern"]
    parameters: NotRequired[RepositoryRuleCommitMessagePatternPropParametersType]


class RepositoryRuleCommitMessagePatternPropParametersType(TypedDict):
    """RepositoryRuleCommitMessagePatternPropParameters"""

    name: NotRequired[str]
    negate: NotRequired[bool]
    operator: Literal["starts_with", "ends_with", "contains", "regex"]
    pattern: str


class RepositoryRuleCommitAuthorEmailPatternType(TypedDict):
    """commit_author_email_pattern

    Parameters to be used for the commit_author_email_pattern rule
    """

    type: Literal["commit_author_email_pattern"]
    parameters: NotRequired[RepositoryRuleCommitAuthorEmailPatternPropParametersType]


class RepositoryRuleCommitAuthorEmailPatternPropParametersType(TypedDict):
    """RepositoryRuleCommitAuthorEmailPatternPropParameters"""

    name: NotRequired[str]
    negate: NotRequired[bool]
    operator: Literal["starts_with", "ends_with", "contains", "regex"]
    pattern: str


class RepositoryRuleCommitterEmailPatternType(TypedDict):
    """committer_email_pattern

    Parameters to be used for the committer_email_pattern rule
    """

    type: Literal["committer_email_pattern"]
    parameters: NotRequired[RepositoryRuleCommitterEmailPatternPropParametersType]


class RepositoryRuleCommitterEmailPatternPropParametersType(TypedDict):
    """RepositoryRuleCommitterEmailPatternPropParameters"""

    name: NotRequired[str]
    negate: NotRequired[bool]
    operator: Literal["starts_with", "ends_with", "contains", "regex"]
    pattern: str


class RepositoryRuleBranchNamePatternType(TypedDict):
    """branch_name_pattern

    Parameters to be used for the branch_name_pattern rule
    """

    type: Literal["branch_name_pattern"]
    parameters: NotRequired[RepositoryRuleBranchNamePatternPropParametersType]


class RepositoryRuleBranchNamePatternPropParametersType(TypedDict):
    """RepositoryRuleBranchNamePatternPropParameters"""

    name: NotRequired[str]
    negate: NotRequired[bool]
    operator: Literal["starts_with", "ends_with", "contains", "regex"]
    pattern: str


class RepositoryRuleTagNamePatternType(TypedDict):
    """tag_name_pattern

    Parameters to be used for the tag_name_pattern rule
    """

    type: Literal["tag_name_pattern"]
    parameters: NotRequired[RepositoryRuleTagNamePatternPropParametersType]


class RepositoryRuleTagNamePatternPropParametersType(TypedDict):
    """RepositoryRuleTagNamePatternPropParameters"""

    name: NotRequired[str]
    negate: NotRequired[bool]
    operator: Literal["starts_with", "ends_with", "contains", "regex"]
    pattern: str


class RepositoryRuleParamsWorkflowFileReferenceType(TypedDict):
    """WorkflowFileReference

    A workflow that must run for this rule to pass
    """

    path: str
    ref: NotRequired[str]
    repository_id: int
    sha: NotRequired[str]


class RepositoryRuleWorkflowsType(TypedDict):
    """workflows

    Require all changes made to a targeted branch to pass the specified workflows
    before they can be merged.
    """

    type: Literal["workflows"]
    parameters: NotRequired[RepositoryRuleWorkflowsPropParametersType]


class RepositoryRuleWorkflowsPropParametersType(TypedDict):
    """RepositoryRuleWorkflowsPropParameters"""

    workflows: List[RepositoryRuleParamsWorkflowFileReferenceType]


class RepositoryRulesetType(TypedDict):
    """Repository ruleset

    A set of rules to apply when specified conditions are met.
    """

    id: int
    name: str
    target: NotRequired[Literal["branch", "tag"]]
    source_type: NotRequired[Literal["Repository", "Organization"]]
    source: str
    enforcement: Literal["disabled", "active", "evaluate"]
    bypass_actors: NotRequired[List[RepositoryRulesetBypassActorType]]
    current_user_can_bypass: NotRequired[
        Literal["always", "pull_requests_only", "never"]
    ]
    node_id: NotRequired[str]
    links: NotRequired[RepositoryRulesetPropLinksType]
    conditions: NotRequired[
        Union[
            RepositoryRulesetConditionsType,
            OrgRulesetConditionsOneof0Type,
            OrgRulesetConditionsOneof1Type,
        ]
    ]
    rules: NotRequired[
        List[
            Union[
                RepositoryRuleCreationType,
                RepositoryRuleUpdateType,
                RepositoryRuleDeletionType,
                RepositoryRuleRequiredLinearHistoryType,
                RepositoryRuleRequiredDeploymentsType,
                RepositoryRuleRequiredSignaturesType,
                RepositoryRulePullRequestType,
                RepositoryRuleRequiredStatusChecksType,
                RepositoryRuleNonFastForwardType,
                RepositoryRuleCommitMessagePatternType,
                RepositoryRuleCommitAuthorEmailPatternType,
                RepositoryRuleCommitterEmailPatternType,
                RepositoryRuleBranchNamePatternType,
                RepositoryRuleTagNamePatternType,
                RepositoryRuleWorkflowsType,
            ]
        ]
    ]
    created_at: NotRequired[datetime]
    updated_at: NotRequired[datetime]


class RepositoryRulesetPropLinksType(TypedDict):
    """RepositoryRulesetPropLinks"""

    self_: NotRequired[RepositoryRulesetPropLinksPropSelfType]
    html: NotRequired[RepositoryRulesetPropLinksPropHtmlType]


class RepositoryRulesetPropLinksPropSelfType(TypedDict):
    """RepositoryRulesetPropLinksPropSelf"""

    href: NotRequired[str]


class RepositoryRulesetPropLinksPropHtmlType(TypedDict):
    """RepositoryRulesetPropLinksPropHtml"""

    href: NotRequired[str]


class RuleSuitesItemsType(TypedDict):
    """RuleSuitesItems"""

    id: NotRequired[int]
    actor_id: NotRequired[int]
    actor_name: NotRequired[str]
    before_sha: NotRequired[str]
    after_sha: NotRequired[str]
    ref: NotRequired[str]
    repository_id: NotRequired[int]
    repository_name: NotRequired[str]
    pushed_at: NotRequired[datetime]
    result: NotRequired[Literal["pass", "fail", "bypass"]]
    evaluation_result: NotRequired[Literal["pass", "fail"]]


class RuleSuiteType(TypedDict):
    """Rule Suite

    Response
    """

    id: NotRequired[int]
    actor_id: NotRequired[int]
    actor_name: NotRequired[str]
    before_sha: NotRequired[str]
    after_sha: NotRequired[str]
    ref: NotRequired[str]
    repository_id: NotRequired[int]
    repository_name: NotRequired[str]
    pushed_at: NotRequired[datetime]
    result: NotRequired[Literal["pass", "fail", "bypass"]]
    evaluation_result: NotRequired[Literal["pass", "fail"]]
    rule_evaluations: NotRequired[List[RuleSuitePropRuleEvaluationsItemsType]]


class RuleSuitePropRuleEvaluationsItemsType(TypedDict):
    """RuleSuitePropRuleEvaluationsItems"""

    rule_source: NotRequired[RuleSuitePropRuleEvaluationsItemsPropRuleSourceType]
    enforcement: NotRequired[Literal["active", "evaluate", "deleted ruleset"]]
    result: NotRequired[Literal["pass", "fail"]]
    rule_type: NotRequired[str]
    details: NotRequired[str]


class RuleSuitePropRuleEvaluationsItemsPropRuleSourceType(TypedDict):
    """RuleSuitePropRuleEvaluationsItemsPropRuleSource"""

    type: NotRequired[str]
    id: NotRequired[Union[int, None]]
    name: NotRequired[Union[str, None]]


class RepositoryAdvisoryVulnerabilityType(TypedDict):
    """RepositoryAdvisoryVulnerability

    A product affected by the vulnerability detailed in a repository security
    advisory.
    """

    package: Union[RepositoryAdvisoryVulnerabilityPropPackageType, None]
    vulnerable_version_range: Union[str, None]
    patched_versions: Union[str, None]
    vulnerable_functions: Union[List[str], None]


class RepositoryAdvisoryVulnerabilityPropPackageType(TypedDict):
    """RepositoryAdvisoryVulnerabilityPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ]
    name: Union[str, None]


class RepositoryAdvisoryCreditType(TypedDict):
    """RepositoryAdvisoryCredit

    A credit given to a user for a repository security advisory.
    """

    user: SimpleUserType
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ]
    state: Literal["accepted", "declined", "pending"]


class RepositoryAdvisoryType(TypedDict):
    """RepositoryAdvisory

    A repository security advisory.
    """

    ghsa_id: str
    cve_id: Union[str, None]
    url: str
    html_url: str
    summary: str
    description: Union[str, None]
    severity: Union[None, Literal["critical", "high", "medium", "low"]]
    author: None
    publisher: None
    identifiers: List[RepositoryAdvisoryPropIdentifiersItemsType]
    state: Literal["published", "closed", "withdrawn", "draft", "triage"]
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    published_at: Union[datetime, None]
    closed_at: Union[datetime, None]
    withdrawn_at: Union[datetime, None]
    submission: Union[RepositoryAdvisoryPropSubmissionType, None]
    vulnerabilities: Union[List[RepositoryAdvisoryVulnerabilityType], None]
    cvss: Union[RepositoryAdvisoryPropCvssType, None]
    cwes: Union[List[RepositoryAdvisoryPropCwesItemsType], None]
    cwe_ids: Union[List[str], None]
    credits_: Union[List[RepositoryAdvisoryPropCreditsItemsType], None]
    credits_detailed: Union[List[RepositoryAdvisoryCreditType], None]
    collaborating_users: Union[List[SimpleUserType], None]
    collaborating_teams: Union[List[TeamType], None]
    private_fork: None


class RepositoryAdvisoryPropIdentifiersItemsType(TypedDict):
    """RepositoryAdvisoryPropIdentifiersItems"""

    type: Literal["CVE", "GHSA"]
    value: str


class RepositoryAdvisoryPropSubmissionType(TypedDict):
    """RepositoryAdvisoryPropSubmission"""

    accepted: bool


class RepositoryAdvisoryPropCvssType(TypedDict):
    """RepositoryAdvisoryPropCvss"""

    vector_string: Union[str, None]
    score: Union[float, None]


class RepositoryAdvisoryPropCwesItemsType(TypedDict):
    """RepositoryAdvisoryPropCwesItems"""

    cwe_id: str
    name: str


class RepositoryAdvisoryPropCreditsItemsType(TypedDict):
    """RepositoryAdvisoryPropCreditsItems"""

    login: NotRequired[str]
    type: NotRequired[
        Literal[
            "analyst",
            "finder",
            "reporter",
            "coordinator",
            "remediation_developer",
            "remediation_reviewer",
            "remediation_verifier",
            "tool",
            "sponsor",
            "other",
        ]
    ]


class ActionsBillingUsageType(TypedDict):
    """ActionsBillingUsage"""

    total_minutes_used: int
    total_paid_minutes_used: int
    included_minutes: int
    minutes_used_breakdown: ActionsBillingUsagePropMinutesUsedBreakdownType


class ActionsBillingUsagePropMinutesUsedBreakdownType(TypedDict):
    """ActionsBillingUsagePropMinutesUsedBreakdown"""

    ubuntu: NotRequired[int]
    macos: NotRequired[int]
    windows: NotRequired[int]
    ubuntu_4_core: NotRequired[int]
    ubuntu_8_core: NotRequired[int]
    ubuntu_16_core: NotRequired[int]
    ubuntu_32_core: NotRequired[int]
    ubuntu_64_core: NotRequired[int]
    windows_4_core: NotRequired[int]
    windows_8_core: NotRequired[int]
    windows_16_core: NotRequired[int]
    windows_32_core: NotRequired[int]
    windows_64_core: NotRequired[int]
    macos_12_core: NotRequired[int]
    total: NotRequired[int]


class PackagesBillingUsageType(TypedDict):
    """PackagesBillingUsage"""

    total_gigabytes_bandwidth_used: int
    total_paid_gigabytes_bandwidth_used: int
    included_gigabytes_bandwidth: int


class CombinedBillingUsageType(TypedDict):
    """CombinedBillingUsage"""

    days_left_in_billing_cycle: int
    estimated_paid_storage_for_month: int
    estimated_storage_for_month: int


class TeamOrganizationType(TypedDict):
    """Team Organization

    Team Organization
    """

    login: str
    id: int
    node_id: str
    url: str
    repos_url: str
    events_url: str
    hooks_url: str
    issues_url: str
    members_url: str
    public_members_url: str
    avatar_url: str
    description: Union[str, None]
    name: NotRequired[Union[str, None]]
    company: NotRequired[Union[str, None]]
    blog: NotRequired[Union[str, None]]
    location: NotRequired[Union[str, None]]
    email: NotRequired[Union[str, None]]
    twitter_username: NotRequired[Union[str, None]]
    is_verified: NotRequired[bool]
    has_organization_projects: bool
    has_repository_projects: bool
    public_repos: int
    public_gists: int
    followers: int
    following: int
    html_url: str
    created_at: datetime
    type: str
    total_private_repos: NotRequired[int]
    owned_private_repos: NotRequired[int]
    private_gists: NotRequired[Union[int, None]]
    disk_usage: NotRequired[Union[int, None]]
    collaborators: NotRequired[Union[int, None]]
    billing_email: NotRequired[Union[str, None]]
    plan: NotRequired[TeamOrganizationPropPlanType]
    default_repository_permission: NotRequired[Union[str, None]]
    members_can_create_repositories: NotRequired[Union[bool, None]]
    two_factor_requirement_enabled: NotRequired[Union[bool, None]]
    members_allowed_repository_creation_type: NotRequired[str]
    members_can_create_public_repositories: NotRequired[bool]
    members_can_create_private_repositories: NotRequired[bool]
    members_can_create_internal_repositories: NotRequired[bool]
    members_can_create_pages: NotRequired[bool]
    members_can_create_public_pages: NotRequired[bool]
    members_can_create_private_pages: NotRequired[bool]
    members_can_fork_private_repositories: NotRequired[Union[bool, None]]
    web_commit_signoff_required: NotRequired[bool]
    updated_at: datetime
    archived_at: Union[datetime, None]


class TeamOrganizationPropPlanType(TypedDict):
    """TeamOrganizationPropPlan"""

    name: str
    space: int
    private_repos: int
    filled_seats: NotRequired[int]
    seats: NotRequired[int]


class TeamFullType(TypedDict):
    """Full Team

    Groups of organization members that gives permissions on specified repositories.
    """

    id: int
    node_id: str
    url: str
    html_url: str
    name: str
    slug: str
    description: Union[str, None]
    privacy: NotRequired[Literal["closed", "secret"]]
    notification_setting: NotRequired[
        Literal["notifications_enabled", "notifications_disabled"]
    ]
    permission: str
    members_url: str
    repositories_url: str
    parent: NotRequired[Union[None, TeamSimpleType]]
    members_count: int
    repos_count: int
    created_at: datetime
    updated_at: datetime
    organization: TeamOrganizationType
    ldap_dn: NotRequired[str]


class TeamDiscussionType(TypedDict):
    """Team Discussion

    A team discussion is a persistent record of a free-form conversation within a
    team.
    """

    author: Union[None, SimpleUserType]
    body: str
    body_html: str
    body_version: str
    comments_count: int
    comments_url: str
    created_at: datetime
    last_edited_at: Union[datetime, None]
    html_url: str
    node_id: str
    number: int
    pinned: bool
    private: bool
    team_url: str
    title: str
    updated_at: datetime
    url: str
    reactions: NotRequired[ReactionRollupType]


class TeamDiscussionCommentType(TypedDict):
    """Team Discussion Comment

    A reply to a discussion within a team.
    """

    author: Union[None, SimpleUserType]
    body: str
    body_html: str
    body_version: str
    created_at: datetime
    last_edited_at: Union[datetime, None]
    discussion_url: str
    html_url: str
    node_id: str
    number: int
    updated_at: datetime
    url: str
    reactions: NotRequired[ReactionRollupType]


class ReactionType(TypedDict):
    """Reaction

    Reactions to conversations provide a way to help people express their feelings
    more simply and effectively.
    """

    id: int
    node_id: str
    user: Union[None, SimpleUserType]
    content: Literal[
        "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
    ]
    created_at: datetime


class TeamMembershipType(TypedDict):
    """Team Membership

    Team Membership
    """

    url: str
    role: Literal["member", "maintainer"]
    state: Literal["active", "pending"]


class TeamProjectType(TypedDict):
    """Team Project

    A team's access to a project.
    """

    owner_url: str
    url: str
    html_url: str
    columns_url: str
    id: int
    node_id: str
    name: str
    body: Union[str, None]
    number: int
    state: str
    creator: SimpleUserType
    created_at: str
    updated_at: str
    organization_permission: NotRequired[str]
    private: NotRequired[bool]
    permissions: TeamProjectPropPermissionsType


class TeamProjectPropPermissionsType(TypedDict):
    """TeamProjectPropPermissions"""

    read: bool
    write: bool
    admin: bool


class TeamRepositoryType(TypedDict):
    """Team Repository

    A team's access to a repository.
    """

    id: int
    node_id: str
    name: str
    full_name: str
    license_: Union[None, LicenseSimpleType]
    forks: int
    permissions: NotRequired[TeamRepositoryPropPermissionsType]
    role_name: NotRequired[str]
    owner: Union[None, SimpleUserType]
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    ssh_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    clone_url: str
    mirror_url: Union[str, None]
    hooks_url: str
    svn_url: str
    homepage: Union[str, None]
    language: Union[str, None]
    forks_count: int
    stargazers_count: int
    watchers_count: int
    size: int
    default_branch: str
    open_issues_count: int
    is_template: NotRequired[bool]
    topics: NotRequired[List[str]]
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    has_downloads: bool
    archived: bool
    disabled: bool
    visibility: NotRequired[str]
    pushed_at: Union[datetime, None]
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    allow_rebase_merge: NotRequired[bool]
    temp_clone_token: NotRequired[Union[str, None]]
    allow_squash_merge: NotRequired[bool]
    allow_auto_merge: NotRequired[bool]
    delete_branch_on_merge: NotRequired[bool]
    allow_merge_commit: NotRequired[bool]
    allow_forking: NotRequired[bool]
    web_commit_signoff_required: NotRequired[bool]
    subscribers_count: NotRequired[int]
    network_count: NotRequired[int]
    open_issues: int
    watchers: int
    master_branch: NotRequired[str]


class TeamRepositoryPropPermissionsType(TypedDict):
    """TeamRepositoryPropPermissions"""

    admin: bool
    pull: bool
    triage: NotRequired[bool]
    push: bool
    maintain: NotRequired[bool]


class ProjectCardType(TypedDict):
    """Project Card

    Project cards represent a scope of work.
    """

    url: str
    id: int
    node_id: str
    note: Union[str, None]
    creator: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    archived: NotRequired[bool]
    column_name: NotRequired[str]
    project_id: NotRequired[str]
    column_url: str
    content_url: NotRequired[str]
    project_url: str


class ProjectColumnType(TypedDict):
    """Project Column

    Project columns contain cards of work.
    """

    url: str
    project_url: str
    cards_url: str
    id: int
    node_id: str
    name: str
    created_at: datetime
    updated_at: datetime


class ProjectCollaboratorPermissionType(TypedDict):
    """Project Collaborator Permission

    Project Collaborator Permission
    """

    permission: str
    user: Union[None, SimpleUserType]


class RateLimitType(TypedDict):
    """Rate Limit"""

    limit: int
    remaining: int
    reset: int
    used: int


class RateLimitOverviewType(TypedDict):
    """Rate Limit Overview

    Rate Limit Overview
    """

    resources: RateLimitOverviewPropResourcesType
    rate: RateLimitType


class RateLimitOverviewPropResourcesType(TypedDict):
    """RateLimitOverviewPropResources"""

    core: RateLimitType
    graphql: NotRequired[RateLimitType]
    search: RateLimitType
    code_search: NotRequired[RateLimitType]
    source_import: NotRequired[RateLimitType]
    integration_manifest: NotRequired[RateLimitType]
    code_scanning_upload: NotRequired[RateLimitType]
    actions_runner_registration: NotRequired[RateLimitType]
    scim: NotRequired[RateLimitType]
    dependency_snapshots: NotRequired[RateLimitType]


class ArtifactType(TypedDict):
    """Artifact

    An artifact
    """

    id: int
    node_id: str
    name: str
    size_in_bytes: int
    url: str
    archive_download_url: str
    expired: bool
    created_at: Union[datetime, None]
    expires_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    workflow_run: NotRequired[Union[ArtifactPropWorkflowRunType, None]]


class ArtifactPropWorkflowRunType(TypedDict):
    """ArtifactPropWorkflowRun"""

    id: NotRequired[int]
    repository_id: NotRequired[int]
    head_repository_id: NotRequired[int]
    head_branch: NotRequired[str]
    head_sha: NotRequired[str]


class ActionsCacheListType(TypedDict):
    """Repository actions caches

    Repository actions caches
    """

    total_count: int
    actions_caches: List[ActionsCacheListPropActionsCachesItemsType]


class ActionsCacheListPropActionsCachesItemsType(TypedDict):
    """ActionsCacheListPropActionsCachesItems"""

    id: NotRequired[int]
    ref: NotRequired[str]
    key: NotRequired[str]
    version: NotRequired[str]
    last_accessed_at: NotRequired[datetime]
    created_at: NotRequired[datetime]
    size_in_bytes: NotRequired[int]


class JobType(TypedDict):
    """Job

    Information of a job execution in a workflow run
    """

    id: int
    run_id: int
    run_url: str
    run_attempt: NotRequired[int]
    node_id: str
    head_sha: str
    url: str
    html_url: Union[str, None]
    status: Literal["queued", "in_progress", "completed", "waiting"]
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ]
    created_at: datetime
    started_at: datetime
    completed_at: Union[datetime, None]
    name: str
    steps: NotRequired[List[JobPropStepsItemsType]]
    check_run_url: str
    labels: List[str]
    runner_id: Union[int, None]
    runner_name: Union[str, None]
    runner_group_id: Union[int, None]
    runner_group_name: Union[str, None]
    workflow_name: Union[str, None]
    head_branch: Union[str, None]


class JobPropStepsItemsType(TypedDict):
    """JobPropStepsItems"""

    status: Literal["queued", "in_progress", "completed"]
    conclusion: Union[str, None]
    name: str
    number: int
    started_at: NotRequired[Union[datetime, None]]
    completed_at: NotRequired[Union[datetime, None]]


class OidcCustomSubRepoType(TypedDict):
    """Actions OIDC subject customization for a repository

    Actions OIDC subject customization for a repository
    """

    use_default: bool
    include_claim_keys: NotRequired[List[str]]


class ActionsSecretType(TypedDict):
    """Actions Secret

    Set secrets for GitHub Actions.
    """

    name: str
    created_at: datetime
    updated_at: datetime


class ActionsVariableType(TypedDict):
    """Actions Variable"""

    name: str
    value: str
    created_at: datetime
    updated_at: datetime


class ActionsRepositoryPermissionsType(TypedDict):
    """ActionsRepositoryPermissions"""

    enabled: bool
    allowed_actions: NotRequired[Literal["all", "local_only", "selected"]]
    selected_actions_url: NotRequired[str]


class ActionsWorkflowAccessToRepositoryType(TypedDict):
    """ActionsWorkflowAccessToRepository"""

    access_level: Literal["none", "user", "organization"]


class ReferencedWorkflowType(TypedDict):
    """Referenced workflow

    A workflow referenced/reused by the initial caller workflow
    """

    path: str
    sha: str
    ref: NotRequired[str]


class PullRequestMinimalType(TypedDict):
    """Pull Request Minimal"""

    id: int
    number: int
    url: str
    head: PullRequestMinimalPropHeadType
    base: PullRequestMinimalPropBaseType


class PullRequestMinimalPropHeadType(TypedDict):
    """PullRequestMinimalPropHead"""

    ref: str
    sha: str
    repo: PullRequestMinimalPropHeadPropRepoType


class PullRequestMinimalPropHeadPropRepoType(TypedDict):
    """PullRequestMinimalPropHeadPropRepo"""

    id: int
    url: str
    name: str


class PullRequestMinimalPropBaseType(TypedDict):
    """PullRequestMinimalPropBase"""

    ref: str
    sha: str
    repo: PullRequestMinimalPropBasePropRepoType


class PullRequestMinimalPropBasePropRepoType(TypedDict):
    """PullRequestMinimalPropBasePropRepo"""

    id: int
    url: str
    name: str


class SimpleCommitType(TypedDict):
    """Simple Commit

    A commit.
    """

    id: str
    tree_id: str
    message: str
    timestamp: datetime
    author: Union[SimpleCommitPropAuthorType, None]
    committer: Union[SimpleCommitPropCommitterType, None]


class SimpleCommitPropAuthorType(TypedDict):
    """SimpleCommitPropAuthor

    Information about the Git author
    """

    name: str
    email: str


class SimpleCommitPropCommitterType(TypedDict):
    """SimpleCommitPropCommitter

    Information about the Git committer
    """

    name: str
    email: str


class WorkflowRunType(TypedDict):
    """Workflow Run

    An invocation of a workflow
    """

    id: int
    name: NotRequired[Union[str, None]]
    node_id: str
    check_suite_id: NotRequired[int]
    check_suite_node_id: NotRequired[str]
    head_branch: Union[str, None]
    head_sha: str
    path: str
    run_number: int
    run_attempt: NotRequired[int]
    referenced_workflows: NotRequired[Union[List[ReferencedWorkflowType], None]]
    event: str
    status: Union[str, None]
    conclusion: Union[str, None]
    workflow_id: int
    url: str
    html_url: str
    pull_requests: Union[List[PullRequestMinimalType], None]
    created_at: datetime
    updated_at: datetime
    actor: NotRequired[SimpleUserType]
    triggering_actor: NotRequired[SimpleUserType]
    run_started_at: NotRequired[datetime]
    jobs_url: str
    logs_url: str
    check_suite_url: str
    artifacts_url: str
    cancel_url: str
    rerun_url: str
    previous_attempt_url: NotRequired[Union[str, None]]
    workflow_url: str
    head_commit: Union[None, SimpleCommitType]
    repository: MinimalRepositoryType
    head_repository: MinimalRepositoryType
    head_repository_id: NotRequired[int]
    display_title: str


class EnvironmentApprovalsType(TypedDict):
    """Environment Approval

    An entry in the reviews log for environment deployments
    """

    environments: List[EnvironmentApprovalsPropEnvironmentsItemsType]
    state: Literal["approved", "rejected", "pending"]
    user: SimpleUserType
    comment: str


class EnvironmentApprovalsPropEnvironmentsItemsType(TypedDict):
    """EnvironmentApprovalsPropEnvironmentsItems"""

    id: NotRequired[int]
    node_id: NotRequired[str]
    name: NotRequired[str]
    url: NotRequired[str]
    html_url: NotRequired[str]
    created_at: NotRequired[datetime]
    updated_at: NotRequired[datetime]


class ReviewCustomGatesCommentRequiredType(TypedDict):
    """ReviewCustomGatesCommentRequired"""

    environment_name: str
    comment: str


class ReviewCustomGatesStateRequiredType(TypedDict):
    """ReviewCustomGatesStateRequired"""

    environment_name: str
    state: Literal["approved", "rejected"]
    comment: NotRequired[str]


class PendingDeploymentType(TypedDict):
    """Pending Deployment

    Details of a deployment that is waiting for protection rules to pass
    """

    environment: PendingDeploymentPropEnvironmentType
    wait_timer: int
    wait_timer_started_at: Union[datetime, None]
    current_user_can_approve: bool
    reviewers: List[PendingDeploymentPropReviewersItemsType]


class PendingDeploymentPropEnvironmentType(TypedDict):
    """PendingDeploymentPropEnvironment"""

    id: NotRequired[int]
    node_id: NotRequired[str]
    name: NotRequired[str]
    url: NotRequired[str]
    html_url: NotRequired[str]


class PendingDeploymentPropReviewersItemsType(TypedDict):
    """PendingDeploymentPropReviewersItems"""

    type: NotRequired[Literal["User", "Team"]]
    reviewer: NotRequired[Union[SimpleUserType, TeamType]]


class DeploymentType(TypedDict):
    """Deployment

    A request for a specific ref(branch,sha,tag) to be deployed
    """

    url: str
    id: int
    node_id: str
    sha: str
    ref: str
    task: str
    payload: Union[DeploymentPropPayloadOneof0Type, str]
    original_environment: NotRequired[str]
    environment: str
    description: Union[str, None]
    creator: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    statuses_url: str
    repository_url: str
    transient_environment: NotRequired[bool]
    production_environment: NotRequired[bool]
    performed_via_github_app: NotRequired[Union[None, IntegrationType]]


class DeploymentPropPayloadOneof0Type(TypedDict):
    """DeploymentPropPayloadOneof0"""


class WorkflowRunUsageType(TypedDict):
    """Workflow Run Usage

    Workflow Run Usage
    """

    billable: WorkflowRunUsagePropBillableType
    run_duration_ms: NotRequired[int]


class WorkflowRunUsagePropBillableType(TypedDict):
    """WorkflowRunUsagePropBillable"""

    ubuntu: NotRequired[WorkflowRunUsagePropBillablePropUbuntuType]
    macos: NotRequired[WorkflowRunUsagePropBillablePropMacosType]
    windows: NotRequired[WorkflowRunUsagePropBillablePropWindowsType]


class WorkflowRunUsagePropBillablePropUbuntuType(TypedDict):
    """WorkflowRunUsagePropBillablePropUbuntu"""

    total_ms: int
    jobs: int
    job_runs: NotRequired[
        List[WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItemsType]
    ]


class WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItemsType(TypedDict):
    """WorkflowRunUsagePropBillablePropUbuntuPropJobRunsItems"""

    job_id: int
    duration_ms: int


class WorkflowRunUsagePropBillablePropMacosType(TypedDict):
    """WorkflowRunUsagePropBillablePropMacos"""

    total_ms: int
    jobs: int
    job_runs: NotRequired[
        List[WorkflowRunUsagePropBillablePropMacosPropJobRunsItemsType]
    ]


class WorkflowRunUsagePropBillablePropMacosPropJobRunsItemsType(TypedDict):
    """WorkflowRunUsagePropBillablePropMacosPropJobRunsItems"""

    job_id: int
    duration_ms: int


class WorkflowRunUsagePropBillablePropWindowsType(TypedDict):
    """WorkflowRunUsagePropBillablePropWindows"""

    total_ms: int
    jobs: int
    job_runs: NotRequired[
        List[WorkflowRunUsagePropBillablePropWindowsPropJobRunsItemsType]
    ]


class WorkflowRunUsagePropBillablePropWindowsPropJobRunsItemsType(TypedDict):
    """WorkflowRunUsagePropBillablePropWindowsPropJobRunsItems"""

    job_id: int
    duration_ms: int


class WorkflowType(TypedDict):
    """Workflow

    A GitHub Actions workflow
    """

    id: int
    node_id: str
    name: str
    path: str
    state: Literal[
        "active", "deleted", "disabled_fork", "disabled_inactivity", "disabled_manually"
    ]
    created_at: datetime
    updated_at: datetime
    url: str
    html_url: str
    badge_url: str
    deleted_at: NotRequired[datetime]


class WorkflowUsageType(TypedDict):
    """Workflow Usage

    Workflow Usage
    """

    billable: WorkflowUsagePropBillableType


class WorkflowUsagePropBillableType(TypedDict):
    """WorkflowUsagePropBillable"""

    ubuntu: NotRequired[WorkflowUsagePropBillablePropUbuntuType]
    macos: NotRequired[WorkflowUsagePropBillablePropMacosType]
    windows: NotRequired[WorkflowUsagePropBillablePropWindowsType]


class WorkflowUsagePropBillablePropUbuntuType(TypedDict):
    """WorkflowUsagePropBillablePropUbuntu"""

    total_ms: NotRequired[int]


class WorkflowUsagePropBillablePropMacosType(TypedDict):
    """WorkflowUsagePropBillablePropMacos"""

    total_ms: NotRequired[int]


class WorkflowUsagePropBillablePropWindowsType(TypedDict):
    """WorkflowUsagePropBillablePropWindows"""

    total_ms: NotRequired[int]


class ActivityType(TypedDict):
    """Activity

    Activity
    """

    id: int
    node_id: str
    before: str
    after: str
    ref: str
    timestamp: datetime
    activity_type: Literal[
        "push",
        "force_push",
        "branch_deletion",
        "branch_creation",
        "pr_merge",
        "merge_queue_merge",
    ]
    actor: Union[None, SimpleUserType]


class AutolinkType(TypedDict):
    """Autolink reference

    An autolink reference.
    """

    id: int
    key_prefix: str
    url_template: str
    is_alphanumeric: bool


class CheckAutomatedSecurityFixesType(TypedDict):
    """Check Automated Security Fixes

    Check Automated Security Fixes
    """

    enabled: bool
    paused: bool


class ProtectedBranchRequiredStatusCheckType(TypedDict):
    """Protected Branch Required Status Check

    Protected Branch Required Status Check
    """

    url: NotRequired[str]
    enforcement_level: NotRequired[str]
    contexts: List[str]
    checks: List[ProtectedBranchRequiredStatusCheckPropChecksItemsType]
    contexts_url: NotRequired[str]
    strict: NotRequired[bool]


class ProtectedBranchRequiredStatusCheckPropChecksItemsType(TypedDict):
    """ProtectedBranchRequiredStatusCheckPropChecksItems"""

    context: str
    app_id: Union[int, None]


class ProtectedBranchAdminEnforcedType(TypedDict):
    """Protected Branch Admin Enforced

    Protected Branch Admin Enforced
    """

    url: str
    enabled: bool


class ProtectedBranchPullRequestReviewType(TypedDict):
    """Protected Branch Pull Request Review

    Protected Branch Pull Request Review
    """

    url: NotRequired[str]
    dismissal_restrictions: NotRequired[
        ProtectedBranchPullRequestReviewPropDismissalRestrictionsType
    ]
    bypass_pull_request_allowances: NotRequired[
        ProtectedBranchPullRequestReviewPropBypassPullRequestAllowancesType
    ]
    dismiss_stale_reviews: bool
    require_code_owner_reviews: bool
    required_approving_review_count: NotRequired[int]
    require_last_push_approval: NotRequired[bool]


class ProtectedBranchPullRequestReviewPropDismissalRestrictionsType(TypedDict):
    """ProtectedBranchPullRequestReviewPropDismissalRestrictions"""

    users: NotRequired[List[SimpleUserType]]
    teams: NotRequired[List[TeamType]]
    apps: NotRequired[List[IntegrationType]]
    url: NotRequired[str]
    users_url: NotRequired[str]
    teams_url: NotRequired[str]


class ProtectedBranchPullRequestReviewPropBypassPullRequestAllowancesType(TypedDict):
    """ProtectedBranchPullRequestReviewPropBypassPullRequestAllowances

    Allow specific users, teams, or apps to bypass pull request requirements.
    """

    users: NotRequired[List[SimpleUserType]]
    teams: NotRequired[List[TeamType]]
    apps: NotRequired[List[IntegrationType]]


class BranchRestrictionPolicyType(TypedDict):
    """Branch Restriction Policy

    Branch Restriction Policy
    """

    url: str
    users_url: str
    teams_url: str
    apps_url: str
    users: List[BranchRestrictionPolicyPropUsersItemsType]
    teams: List[BranchRestrictionPolicyPropTeamsItemsType]
    apps: List[BranchRestrictionPolicyPropAppsItemsType]


class BranchRestrictionPolicyPropUsersItemsType(TypedDict):
    """BranchRestrictionPolicyPropUsersItems"""

    login: NotRequired[str]
    id: NotRequired[int]
    node_id: NotRequired[str]
    avatar_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    url: NotRequired[str]
    html_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    organizations_url: NotRequired[str]
    repos_url: NotRequired[str]
    events_url: NotRequired[str]
    received_events_url: NotRequired[str]
    type: NotRequired[str]
    site_admin: NotRequired[bool]


class BranchRestrictionPolicyPropTeamsItemsType(TypedDict):
    """BranchRestrictionPolicyPropTeamsItems"""

    id: NotRequired[int]
    node_id: NotRequired[str]
    url: NotRequired[str]
    html_url: NotRequired[str]
    name: NotRequired[str]
    slug: NotRequired[str]
    description: NotRequired[Union[str, None]]
    privacy: NotRequired[str]
    notification_setting: NotRequired[str]
    permission: NotRequired[str]
    members_url: NotRequired[str]
    repositories_url: NotRequired[str]
    parent: NotRequired[Union[str, None]]


class BranchRestrictionPolicyPropAppsItemsType(TypedDict):
    """BranchRestrictionPolicyPropAppsItems"""

    id: NotRequired[int]
    slug: NotRequired[str]
    node_id: NotRequired[str]
    owner: NotRequired[BranchRestrictionPolicyPropAppsItemsPropOwnerType]
    name: NotRequired[str]
    description: NotRequired[str]
    external_url: NotRequired[str]
    html_url: NotRequired[str]
    created_at: NotRequired[str]
    updated_at: NotRequired[str]
    permissions: NotRequired[BranchRestrictionPolicyPropAppsItemsPropPermissionsType]
    events: NotRequired[List[str]]


class BranchRestrictionPolicyPropAppsItemsPropOwnerType(TypedDict):
    """BranchRestrictionPolicyPropAppsItemsPropOwner"""

    login: NotRequired[str]
    id: NotRequired[int]
    node_id: NotRequired[str]
    url: NotRequired[str]
    repos_url: NotRequired[str]
    events_url: NotRequired[str]
    hooks_url: NotRequired[str]
    issues_url: NotRequired[str]
    members_url: NotRequired[str]
    public_members_url: NotRequired[str]
    avatar_url: NotRequired[str]
    description: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    type: NotRequired[str]
    site_admin: NotRequired[bool]


class BranchRestrictionPolicyPropAppsItemsPropPermissionsType(TypedDict):
    """BranchRestrictionPolicyPropAppsItemsPropPermissions"""

    metadata: NotRequired[str]
    contents: NotRequired[str]
    issues: NotRequired[str]
    single_file: NotRequired[str]


class BranchProtectionType(TypedDict):
    """Branch Protection

    Branch Protection
    """

    url: NotRequired[str]
    enabled: NotRequired[bool]
    required_status_checks: NotRequired[ProtectedBranchRequiredStatusCheckType]
    enforce_admins: NotRequired[ProtectedBranchAdminEnforcedType]
    required_pull_request_reviews: NotRequired[ProtectedBranchPullRequestReviewType]
    restrictions: NotRequired[BranchRestrictionPolicyType]
    required_linear_history: NotRequired[BranchProtectionPropRequiredLinearHistoryType]
    allow_force_pushes: NotRequired[BranchProtectionPropAllowForcePushesType]
    allow_deletions: NotRequired[BranchProtectionPropAllowDeletionsType]
    block_creations: NotRequired[BranchProtectionPropBlockCreationsType]
    required_conversation_resolution: NotRequired[
        BranchProtectionPropRequiredConversationResolutionType
    ]
    name: NotRequired[str]
    protection_url: NotRequired[str]
    required_signatures: NotRequired[BranchProtectionPropRequiredSignaturesType]
    lock_branch: NotRequired[BranchProtectionPropLockBranchType]
    allow_fork_syncing: NotRequired[BranchProtectionPropAllowForkSyncingType]


class BranchProtectionPropRequiredLinearHistoryType(TypedDict):
    """BranchProtectionPropRequiredLinearHistory"""

    enabled: NotRequired[bool]


class BranchProtectionPropAllowForcePushesType(TypedDict):
    """BranchProtectionPropAllowForcePushes"""

    enabled: NotRequired[bool]


class BranchProtectionPropAllowDeletionsType(TypedDict):
    """BranchProtectionPropAllowDeletions"""

    enabled: NotRequired[bool]


class BranchProtectionPropBlockCreationsType(TypedDict):
    """BranchProtectionPropBlockCreations"""

    enabled: NotRequired[bool]


class BranchProtectionPropRequiredConversationResolutionType(TypedDict):
    """BranchProtectionPropRequiredConversationResolution"""

    enabled: NotRequired[bool]


class BranchProtectionPropRequiredSignaturesType(TypedDict):
    """BranchProtectionPropRequiredSignatures"""

    url: str
    enabled: bool


class BranchProtectionPropLockBranchType(TypedDict):
    """BranchProtectionPropLockBranch

    Whether to set the branch as read-only. If this is true, users will not be able
    to push to the branch.
    """

    enabled: NotRequired[bool]


class BranchProtectionPropAllowForkSyncingType(TypedDict):
    """BranchProtectionPropAllowForkSyncing

    Whether users can pull changes from upstream when the branch is locked. Set to
    `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """

    enabled: NotRequired[bool]


class ShortBranchType(TypedDict):
    """Short Branch

    Short Branch
    """

    name: str
    commit: ShortBranchPropCommitType
    protected: bool
    protection: NotRequired[BranchProtectionType]
    protection_url: NotRequired[str]


class ShortBranchPropCommitType(TypedDict):
    """ShortBranchPropCommit"""

    sha: str
    url: str


class GitUserType(TypedDict):
    """Git User

    Metaproperties for Git author/committer information.
    """

    name: NotRequired[str]
    email: NotRequired[str]
    date: NotRequired[str]


class VerificationType(TypedDict):
    """Verification"""

    verified: bool
    reason: str
    payload: Union[str, None]
    signature: Union[str, None]


class DiffEntryType(TypedDict):
    """Diff Entry

    Diff Entry
    """

    sha: str
    filename: str
    status: Literal[
        "added", "removed", "modified", "renamed", "copied", "changed", "unchanged"
    ]
    additions: int
    deletions: int
    changes: int
    blob_url: str
    raw_url: str
    contents_url: str
    patch: NotRequired[str]
    previous_filename: NotRequired[str]


class CommitType(TypedDict):
    """Commit

    Commit
    """

    url: str
    sha: str
    node_id: str
    html_url: str
    comments_url: str
    commit: CommitPropCommitType
    author: Union[None, SimpleUserType]
    committer: Union[None, SimpleUserType]
    parents: List[CommitPropParentsItemsType]
    stats: NotRequired[CommitPropStatsType]
    files: NotRequired[List[DiffEntryType]]


class CommitPropCommitType(TypedDict):
    """CommitPropCommit"""

    url: str
    author: Union[None, GitUserType]
    committer: Union[None, GitUserType]
    message: str
    comment_count: int
    tree: CommitPropCommitPropTreeType
    verification: NotRequired[VerificationType]


class CommitPropCommitPropTreeType(TypedDict):
    """CommitPropCommitPropTree"""

    sha: str
    url: str


class CommitPropParentsItemsType(TypedDict):
    """CommitPropParentsItems"""

    sha: str
    url: str
    html_url: NotRequired[str]


class CommitPropStatsType(TypedDict):
    """CommitPropStats"""

    additions: NotRequired[int]
    deletions: NotRequired[int]
    total: NotRequired[int]


class BranchWithProtectionType(TypedDict):
    """Branch With Protection

    Branch With Protection
    """

    name: str
    commit: CommitType
    links: BranchWithProtectionPropLinksType
    protected: bool
    protection: BranchProtectionType
    protection_url: str
    pattern: NotRequired[str]
    required_approving_review_count: NotRequired[int]


class BranchWithProtectionPropLinksType(TypedDict):
    """BranchWithProtectionPropLinks"""

    html: str
    self_: str


class StatusCheckPolicyType(TypedDict):
    """Status Check Policy

    Status Check Policy
    """

    url: str
    strict: bool
    contexts: List[str]
    checks: List[StatusCheckPolicyPropChecksItemsType]
    contexts_url: str


class StatusCheckPolicyPropChecksItemsType(TypedDict):
    """StatusCheckPolicyPropChecksItems"""

    context: str
    app_id: Union[int, None]


class ProtectedBranchType(TypedDict):
    """Protected Branch

    Branch protections protect branches
    """

    url: str
    required_status_checks: NotRequired[StatusCheckPolicyType]
    required_pull_request_reviews: NotRequired[
        ProtectedBranchPropRequiredPullRequestReviewsType
    ]
    required_signatures: NotRequired[ProtectedBranchPropRequiredSignaturesType]
    enforce_admins: NotRequired[ProtectedBranchPropEnforceAdminsType]
    required_linear_history: NotRequired[ProtectedBranchPropRequiredLinearHistoryType]
    allow_force_pushes: NotRequired[ProtectedBranchPropAllowForcePushesType]
    allow_deletions: NotRequired[ProtectedBranchPropAllowDeletionsType]
    restrictions: NotRequired[BranchRestrictionPolicyType]
    required_conversation_resolution: NotRequired[
        ProtectedBranchPropRequiredConversationResolutionType
    ]
    block_creations: NotRequired[ProtectedBranchPropBlockCreationsType]
    lock_branch: NotRequired[ProtectedBranchPropLockBranchType]
    allow_fork_syncing: NotRequired[ProtectedBranchPropAllowForkSyncingType]


class ProtectedBranchPropRequiredPullRequestReviewsType(TypedDict):
    """ProtectedBranchPropRequiredPullRequestReviews"""

    url: str
    dismiss_stale_reviews: NotRequired[bool]
    require_code_owner_reviews: NotRequired[bool]
    required_approving_review_count: NotRequired[int]
    require_last_push_approval: NotRequired[bool]
    dismissal_restrictions: NotRequired[
        ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictionsType
    ]
    bypass_pull_request_allowances: NotRequired[
        ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowancesType
    ]


class ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictionsType(
    TypedDict
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropDismissalRestrictions"""

    url: str
    users_url: str
    teams_url: str
    users: List[SimpleUserType]
    teams: List[TeamType]
    apps: NotRequired[List[IntegrationType]]


class ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowancesType(
    TypedDict
):
    """ProtectedBranchPropRequiredPullRequestReviewsPropBypassPullRequestAllowances"""

    users: List[SimpleUserType]
    teams: List[TeamType]
    apps: NotRequired[List[IntegrationType]]


class ProtectedBranchPropRequiredSignaturesType(TypedDict):
    """ProtectedBranchPropRequiredSignatures"""

    url: str
    enabled: bool


class ProtectedBranchPropEnforceAdminsType(TypedDict):
    """ProtectedBranchPropEnforceAdmins"""

    url: str
    enabled: bool


class ProtectedBranchPropRequiredLinearHistoryType(TypedDict):
    """ProtectedBranchPropRequiredLinearHistory"""

    enabled: bool


class ProtectedBranchPropAllowForcePushesType(TypedDict):
    """ProtectedBranchPropAllowForcePushes"""

    enabled: bool


class ProtectedBranchPropAllowDeletionsType(TypedDict):
    """ProtectedBranchPropAllowDeletions"""

    enabled: bool


class ProtectedBranchPropRequiredConversationResolutionType(TypedDict):
    """ProtectedBranchPropRequiredConversationResolution"""

    enabled: NotRequired[bool]


class ProtectedBranchPropBlockCreationsType(TypedDict):
    """ProtectedBranchPropBlockCreations"""

    enabled: bool


class ProtectedBranchPropLockBranchType(TypedDict):
    """ProtectedBranchPropLockBranch

    Whether to set the branch as read-only. If this is true, users will not be able
    to push to the branch.
    """

    enabled: NotRequired[bool]


class ProtectedBranchPropAllowForkSyncingType(TypedDict):
    """ProtectedBranchPropAllowForkSyncing

    Whether users can pull changes from upstream when the branch is locked. Set to
    `true` to allow fork syncing. Set to `false` to prevent fork syncing.
    """

    enabled: NotRequired[bool]


class DeploymentSimpleType(TypedDict):
    """Deployment

    A deployment created as the result of an Actions check run from a workflow that
    references an environment
    """

    url: str
    id: int
    node_id: str
    task: str
    original_environment: NotRequired[str]
    environment: str
    description: Union[str, None]
    created_at: datetime
    updated_at: datetime
    statuses_url: str
    repository_url: str
    transient_environment: NotRequired[bool]
    production_environment: NotRequired[bool]
    performed_via_github_app: NotRequired[Union[None, IntegrationType]]


class CheckRunType(TypedDict):
    """CheckRun

    A check performed on the code of a given code change
    """

    id: int
    head_sha: str
    node_id: str
    external_id: Union[str, None]
    url: str
    html_url: Union[str, None]
    details_url: Union[str, None]
    status: Literal["queued", "in_progress", "completed"]
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ]
    started_at: Union[datetime, None]
    completed_at: Union[datetime, None]
    output: CheckRunPropOutputType
    name: str
    check_suite: Union[CheckRunPropCheckSuiteType, None]
    app: Union[None, IntegrationType]
    pull_requests: List[PullRequestMinimalType]
    deployment: NotRequired[DeploymentSimpleType]


class CheckRunPropOutputType(TypedDict):
    """CheckRunPropOutput"""

    title: Union[str, None]
    summary: Union[str, None]
    text: Union[str, None]
    annotations_count: int
    annotations_url: str


class CheckRunPropCheckSuiteType(TypedDict):
    """CheckRunPropCheckSuite"""

    id: int


class CheckAnnotationType(TypedDict):
    """Check Annotation

    Check Annotation
    """

    path: str
    start_line: int
    end_line: int
    start_column: Union[int, None]
    end_column: Union[int, None]
    annotation_level: Union[str, None]
    title: Union[str, None]
    message: Union[str, None]
    raw_details: Union[str, None]
    blob_href: str


class CheckSuiteType(TypedDict):
    """CheckSuite

    A suite of checks performed on the code of a given code change
    """

    id: int
    node_id: str
    head_branch: Union[str, None]
    head_sha: str
    status: Union[None, Literal["queued", "in_progress", "completed"]]
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
            "startup_failure",
            "stale",
        ],
    ]
    url: Union[str, None]
    before: Union[str, None]
    after: Union[str, None]
    pull_requests: Union[List[PullRequestMinimalType], None]
    app: Union[None, IntegrationType]
    repository: MinimalRepositoryType
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    head_commit: SimpleCommitType
    latest_check_runs_count: int
    check_runs_url: str
    rerequestable: NotRequired[bool]
    runs_rerequestable: NotRequired[bool]


class CheckSuitePreferenceType(TypedDict):
    """Check Suite Preference

    Check suite configuration preferences for a repository.
    """

    preferences: CheckSuitePreferencePropPreferencesType
    repository: MinimalRepositoryType


class CheckSuitePreferencePropPreferencesType(TypedDict):
    """CheckSuitePreferencePropPreferences"""

    auto_trigger_checks: NotRequired[
        List[CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItemsType]
    ]


class CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItemsType(TypedDict):
    """CheckSuitePreferencePropPreferencesPropAutoTriggerChecksItems"""

    app_id: int
    setting: bool


class CodeScanningAlertItemsType(TypedDict):
    """CodeScanningAlertItems"""

    number: int
    created_at: datetime
    updated_at: NotRequired[datetime]
    url: str
    html_url: str
    instances_url: str
    state: Literal["open", "dismissed", "fixed"]
    fixed_at: NotRequired[Union[datetime, None]]
    dismissed_by: Union[None, SimpleUserType]
    dismissed_at: Union[datetime, None]
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ]
    dismissed_comment: NotRequired[Union[str, None]]
    rule: CodeScanningAlertRuleSummaryType
    tool: CodeScanningAnalysisToolType
    most_recent_instance: CodeScanningAlertInstanceType


class CodeScanningAlertRuleType(TypedDict):
    """CodeScanningAlertRule"""

    id: NotRequired[Union[str, None]]
    name: NotRequired[str]
    severity: NotRequired[Union[None, Literal["none", "note", "warning", "error"]]]
    security_severity_level: NotRequired[
        Union[None, Literal["low", "medium", "high", "critical"]]
    ]
    description: NotRequired[str]
    full_description: NotRequired[str]
    tags: NotRequired[Union[List[str], None]]
    help_: NotRequired[Union[str, None]]
    help_uri: NotRequired[Union[str, None]]


class CodeScanningAlertType(TypedDict):
    """CodeScanningAlert"""

    number: int
    created_at: datetime
    updated_at: NotRequired[datetime]
    url: str
    html_url: str
    instances_url: str
    state: Literal["open", "dismissed", "fixed"]
    fixed_at: NotRequired[Union[datetime, None]]
    dismissed_by: Union[None, SimpleUserType]
    dismissed_at: Union[datetime, None]
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ]
    dismissed_comment: NotRequired[Union[str, None]]
    rule: CodeScanningAlertRuleType
    tool: CodeScanningAnalysisToolType
    most_recent_instance: CodeScanningAlertInstanceType


class CodeScanningAnalysisType(TypedDict):
    """CodeScanningAnalysis"""

    ref: str
    commit_sha: str
    analysis_key: str
    environment: str
    category: NotRequired[str]
    error: str
    created_at: datetime
    results_count: int
    rules_count: int
    id: int
    url: str
    sarif_id: str
    tool: CodeScanningAnalysisToolType
    deletable: bool
    warning: str


class CodeScanningAnalysisDeletionType(TypedDict):
    """Analysis deletion

    Successful deletion of a code scanning analysis
    """

    next_analysis_url: Union[str, None]
    confirm_delete_url: Union[str, None]


class CodeScanningCodeqlDatabaseType(TypedDict):
    """CodeQL Database

    A CodeQL database.
    """

    id: int
    name: str
    language: str
    uploader: SimpleUserType
    content_type: str
    size: int
    created_at: datetime
    updated_at: datetime
    url: str
    commit_oid: NotRequired[Union[str, None]]


class CodeScanningDefaultSetupType(TypedDict):
    """CodeScanningDefaultSetup

    Configuration for code scanning default setup.
    """

    state: NotRequired[Literal["configured", "not-configured"]]
    languages: NotRequired[
        List[
            Literal[
                "c-cpp",
                "csharp",
                "go",
                "java-kotlin",
                "javascript-typescript",
                "javascript",
                "python",
                "ruby",
                "typescript",
                "swift",
            ]
        ]
    ]
    query_suite: NotRequired[Literal["default", "extended"]]
    updated_at: NotRequired[Union[datetime, None]]
    schedule: NotRequired[Union[None, Literal["weekly"]]]


class CodeScanningDefaultSetupUpdateType(TypedDict):
    """CodeScanningDefaultSetupUpdate

    Configuration for code scanning default setup.
    """

    state: NotRequired[Literal["configured", "not-configured"]]
    query_suite: NotRequired[Literal["default", "extended"]]
    languages: NotRequired[
        List[
            Literal[
                "c-cpp",
                "csharp",
                "go",
                "java-kotlin",
                "javascript-typescript",
                "python",
                "ruby",
                "swift",
            ]
        ]
    ]


class CodeScanningDefaultSetupUpdateResponseType(TypedDict):
    """CodeScanningDefaultSetupUpdateResponse

    You can use `run_url` to track the status of the run. This includes a property
    status and conclusion.
    You should not rely on this always being an actions workflow run object.
    """

    run_id: NotRequired[int]
    run_url: NotRequired[str]


class CodeScanningSarifsReceiptType(TypedDict):
    """CodeScanningSarifsReceipt"""

    id: NotRequired[str]
    url: NotRequired[str]


class CodeScanningSarifsStatusType(TypedDict):
    """CodeScanningSarifsStatus"""

    processing_status: NotRequired[Literal["pending", "complete", "failed"]]
    analyses_url: NotRequired[Union[str, None]]
    errors: NotRequired[Union[List[str], None]]


class CodeownersErrorsType(TypedDict):
    """CODEOWNERS errors

    A list of errors found in a repo's CODEOWNERS file
    """

    errors: List[CodeownersErrorsPropErrorsItemsType]


class CodeownersErrorsPropErrorsItemsType(TypedDict):
    """CodeownersErrorsPropErrorsItems"""

    line: int
    column: int
    source: NotRequired[str]
    kind: str
    suggestion: NotRequired[Union[str, None]]
    message: str
    path: str


class CodespacesPermissionsCheckForDevcontainerType(TypedDict):
    """Codespaces Permissions Check

    Permission check result for a given devcontainer config.
    """

    accepted: bool


class RepoCodespacesSecretType(TypedDict):
    """Codespaces Secret

    Set repository secrets for GitHub Codespaces.
    """

    name: str
    created_at: datetime
    updated_at: datetime


class CollaboratorType(TypedDict):
    """Collaborator

    Collaborator
    """

    login: str
    id: int
    email: NotRequired[Union[str, None]]
    name: NotRequired[Union[str, None]]
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    following_url: str
    gists_url: str
    starred_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    events_url: str
    received_events_url: str
    type: str
    site_admin: bool
    permissions: NotRequired[CollaboratorPropPermissionsType]
    role_name: str


class CollaboratorPropPermissionsType(TypedDict):
    """CollaboratorPropPermissions"""

    pull: bool
    triage: NotRequired[bool]
    push: bool
    maintain: NotRequired[bool]
    admin: bool


class RepositoryInvitationType(TypedDict):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    id: int
    repository: MinimalRepositoryType
    invitee: Union[None, SimpleUserType]
    inviter: Union[None, SimpleUserType]
    permissions: Literal["read", "write", "admin", "triage", "maintain"]
    created_at: datetime
    expired: NotRequired[bool]
    url: str
    html_url: str
    node_id: str


class RepositoryCollaboratorPermissionType(TypedDict):
    """Repository Collaborator Permission

    Repository Collaborator Permission
    """

    permission: str
    role_name: str
    user: Union[None, CollaboratorType]


class CommitCommentType(TypedDict):
    """Commit Comment

    Commit Comment
    """

    html_url: str
    url: str
    id: int
    node_id: str
    body: str
    path: Union[str, None]
    position: Union[int, None]
    line: Union[int, None]
    commit_id: str
    user: Union[None, SimpleUserType]
    created_at: datetime
    updated_at: datetime
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    reactions: NotRequired[ReactionRollupType]


class BranchShortType(TypedDict):
    """Branch Short

    Branch Short
    """

    name: str
    commit: BranchShortPropCommitType
    protected: bool


class BranchShortPropCommitType(TypedDict):
    """BranchShortPropCommit"""

    sha: str
    url: str


class LinkType(TypedDict):
    """Link

    Hypermedia Link
    """

    href: str


class AutoMergeType(TypedDict):
    """Auto merge

    The status of auto merging a pull request.
    """

    enabled_by: SimpleUserType
    merge_method: Literal["merge", "squash", "rebase"]
    commit_title: Union[str, None]
    commit_message: Union[str, None]


class PullRequestSimpleType(TypedDict):
    """Pull Request Simple

    Pull Request Simple
    """

    url: str
    id: int
    node_id: str
    html_url: str
    diff_url: str
    patch_url: str
    issue_url: str
    commits_url: str
    review_comments_url: str
    review_comment_url: str
    comments_url: str
    statuses_url: str
    number: int
    state: str
    locked: bool
    title: str
    user: Union[None, SimpleUserType]
    body: Union[str, None]
    labels: List[PullRequestSimplePropLabelsItemsType]
    milestone: Union[None, MilestoneType]
    active_lock_reason: NotRequired[Union[str, None]]
    created_at: datetime
    updated_at: datetime
    closed_at: Union[datetime, None]
    merged_at: Union[datetime, None]
    merge_commit_sha: Union[str, None]
    assignee: Union[None, SimpleUserType]
    assignees: NotRequired[Union[List[SimpleUserType], None]]
    requested_reviewers: NotRequired[Union[List[SimpleUserType], None]]
    requested_teams: NotRequired[Union[List[TeamType], None]]
    head: PullRequestSimplePropHeadType
    base: PullRequestSimplePropBaseType
    links: PullRequestSimplePropLinksType
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    auto_merge: Union[AutoMergeType, None]
    draft: NotRequired[bool]


class PullRequestSimplePropLabelsItemsType(TypedDict):
    """PullRequestSimplePropLabelsItems"""

    id: int
    node_id: str
    url: str
    name: str
    description: Union[str, None]
    color: str
    default: bool


class PullRequestSimplePropHeadType(TypedDict):
    """PullRequestSimplePropHead"""

    label: Union[str, None]
    ref: str
    repo: Union[None, RepositoryType]
    sha: str
    user: Union[None, SimpleUserType]


class PullRequestSimplePropBaseType(TypedDict):
    """PullRequestSimplePropBase"""

    label: str
    ref: str
    repo: RepositoryType
    sha: str
    user: Union[None, SimpleUserType]


class PullRequestSimplePropLinksType(TypedDict):
    """PullRequestSimplePropLinks"""

    comments: LinkType
    commits: LinkType
    statuses: LinkType
    html: LinkType
    issue: LinkType
    review_comments: LinkType
    review_comment: LinkType
    self_: LinkType


class SimpleCommitStatusType(TypedDict):
    """Simple Commit Status"""

    description: Union[str, None]
    id: int
    node_id: str
    state: str
    context: str
    target_url: Union[str, None]
    required: NotRequired[Union[bool, None]]
    avatar_url: Union[str, None]
    url: str
    created_at: datetime
    updated_at: datetime


class CombinedCommitStatusType(TypedDict):
    """Combined Commit Status

    Combined Commit Status
    """

    state: str
    statuses: List[SimpleCommitStatusType]
    sha: str
    total_count: int
    repository: MinimalRepositoryType
    commit_url: str
    url: str


class StatusType(TypedDict):
    """Status

    The status of a commit.
    """

    url: str
    avatar_url: Union[str, None]
    id: int
    node_id: str
    state: str
    description: Union[str, None]
    target_url: Union[str, None]
    context: str
    created_at: str
    updated_at: str
    creator: Union[None, SimpleUserType]


class CommunityHealthFileType(TypedDict):
    """Community Health File"""

    url: str
    html_url: str


class CommunityProfileType(TypedDict):
    """Community Profile

    Community Profile
    """

    health_percentage: int
    description: Union[str, None]
    documentation: Union[str, None]
    files: CommunityProfilePropFilesType
    updated_at: Union[datetime, None]
    content_reports_enabled: NotRequired[bool]


class CommunityProfilePropFilesType(TypedDict):
    """CommunityProfilePropFiles"""

    code_of_conduct: Union[None, CodeOfConductSimpleType]
    code_of_conduct_file: Union[None, CommunityHealthFileType]
    license_: Union[None, LicenseSimpleType]
    contributing: Union[None, CommunityHealthFileType]
    readme: Union[None, CommunityHealthFileType]
    issue_template: Union[None, CommunityHealthFileType]
    pull_request_template: Union[None, CommunityHealthFileType]


class CommitComparisonType(TypedDict):
    """Commit Comparison

    Commit Comparison
    """

    url: str
    html_url: str
    permalink_url: str
    diff_url: str
    patch_url: str
    base_commit: CommitType
    merge_base_commit: CommitType
    status: Literal["diverged", "ahead", "behind", "identical"]
    ahead_by: int
    behind_by: int
    total_commits: int
    commits: List[CommitType]
    files: NotRequired[List[DiffEntryType]]


class ContentTreeType(TypedDict):
    """Content Tree

    Content Tree
    """

    type: str
    size: int
    name: str
    path: str
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    entries: NotRequired[List[ContentTreePropEntriesItemsType]]
    links: ContentTreePropLinksType


class ContentTreePropEntriesItemsType(TypedDict):
    """ContentTreePropEntriesItems"""

    type: str
    size: int
    name: str
    path: str
    content: NotRequired[str]
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentTreePropEntriesItemsPropLinksType


class ContentTreePropEntriesItemsPropLinksType(TypedDict):
    """ContentTreePropEntriesItemsPropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentTreePropLinksType(TypedDict):
    """ContentTreePropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentDirectoryItemsType(TypedDict):
    """ContentDirectoryItems"""

    type: Literal["dir", "file", "submodule", "symlink"]
    size: int
    name: str
    path: str
    content: NotRequired[str]
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentDirectoryItemsPropLinksType


class ContentDirectoryItemsPropLinksType(TypedDict):
    """ContentDirectoryItemsPropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentFileType(TypedDict):
    """Content File

    Content File
    """

    type: Literal["file"]
    encoding: str
    size: int
    name: str
    path: str
    content: str
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentFilePropLinksType
    target: NotRequired[str]
    submodule_git_url: NotRequired[str]


class ContentFilePropLinksType(TypedDict):
    """ContentFilePropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentSymlinkType(TypedDict):
    """Symlink Content

    An object describing a symlink
    """

    type: Literal["symlink"]
    target: str
    size: int
    name: str
    path: str
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentSymlinkPropLinksType


class ContentSymlinkPropLinksType(TypedDict):
    """ContentSymlinkPropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class ContentSubmoduleType(TypedDict):
    """Submodule Content

    An object describing a submodule
    """

    type: Literal["submodule"]
    submodule_git_url: str
    size: int
    name: str
    path: str
    sha: str
    url: str
    git_url: Union[str, None]
    html_url: Union[str, None]
    download_url: Union[str, None]
    links: ContentSubmodulePropLinksType


class ContentSubmodulePropLinksType(TypedDict):
    """ContentSubmodulePropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class FileCommitType(TypedDict):
    """File Commit

    File Commit
    """

    content: Union[FileCommitPropContentType, None]
    commit: FileCommitPropCommitType


class FileCommitPropContentPropLinksType(TypedDict):
    """FileCommitPropContentPropLinks"""

    self_: NotRequired[str]
    git: NotRequired[str]
    html: NotRequired[str]


class FileCommitPropContentType(TypedDict):
    """FileCommitPropContent"""

    name: NotRequired[str]
    path: NotRequired[str]
    sha: NotRequired[str]
    size: NotRequired[int]
    url: NotRequired[str]
    html_url: NotRequired[str]
    git_url: NotRequired[str]
    download_url: NotRequired[str]
    type: NotRequired[str]
    links: NotRequired[FileCommitPropContentPropLinksType]


class FileCommitPropCommitType(TypedDict):
    """FileCommitPropCommit"""

    sha: NotRequired[str]
    node_id: NotRequired[str]
    url: NotRequired[str]
    html_url: NotRequired[str]
    author: NotRequired[FileCommitPropCommitPropAuthorType]
    committer: NotRequired[FileCommitPropCommitPropCommitterType]
    message: NotRequired[str]
    tree: NotRequired[FileCommitPropCommitPropTreeType]
    parents: NotRequired[List[FileCommitPropCommitPropParentsItemsType]]
    verification: NotRequired[FileCommitPropCommitPropVerificationType]


class FileCommitPropCommitPropAuthorType(TypedDict):
    """FileCommitPropCommitPropAuthor"""

    date: NotRequired[str]
    name: NotRequired[str]
    email: NotRequired[str]


class FileCommitPropCommitPropCommitterType(TypedDict):
    """FileCommitPropCommitPropCommitter"""

    date: NotRequired[str]
    name: NotRequired[str]
    email: NotRequired[str]


class FileCommitPropCommitPropTreeType(TypedDict):
    """FileCommitPropCommitPropTree"""

    url: NotRequired[str]
    sha: NotRequired[str]


class FileCommitPropCommitPropParentsItemsType(TypedDict):
    """FileCommitPropCommitPropParentsItems"""

    url: NotRequired[str]
    html_url: NotRequired[str]
    sha: NotRequired[str]


class FileCommitPropCommitPropVerificationType(TypedDict):
    """FileCommitPropCommitPropVerification"""

    verified: NotRequired[bool]
    reason: NotRequired[str]
    signature: NotRequired[Union[str, None]]
    payload: NotRequired[Union[str, None]]


class ContributorType(TypedDict):
    """Contributor

    Contributor
    """

    login: NotRequired[str]
    id: NotRequired[int]
    node_id: NotRequired[str]
    avatar_url: NotRequired[str]
    gravatar_id: NotRequired[Union[str, None]]
    url: NotRequired[str]
    html_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    organizations_url: NotRequired[str]
    repos_url: NotRequired[str]
    events_url: NotRequired[str]
    received_events_url: NotRequired[str]
    type: str
    site_admin: NotRequired[bool]
    contributions: int
    email: NotRequired[str]
    name: NotRequired[str]


class DependabotAlertType(TypedDict):
    """DependabotAlert

    A Dependabot alert.
    """

    number: int
    state: Literal["auto_dismissed", "dismissed", "fixed", "open"]
    dependency: DependabotAlertPropDependencyType
    security_advisory: DependabotAlertSecurityAdvisoryType
    security_vulnerability: DependabotAlertSecurityVulnerabilityType
    url: str
    html_url: str
    created_at: datetime
    updated_at: datetime
    dismissed_at: Union[datetime, None]
    dismissed_by: Union[None, SimpleUserType]
    dismissed_reason: Union[
        None,
        Literal[
            "fix_started", "inaccurate", "no_bandwidth", "not_used", "tolerable_risk"
        ],
    ]
    dismissed_comment: Union[str, None]
    fixed_at: Union[datetime, None]
    auto_dismissed_at: NotRequired[Union[datetime, None]]


class DependabotAlertPropDependencyType(TypedDict):
    """DependabotAlertPropDependency

    Details for the vulnerable dependency.
    """

    package: NotRequired[DependabotAlertPackageType]
    manifest_path: NotRequired[str]
    scope: NotRequired[Union[None, Literal["development", "runtime"]]]


class DependabotSecretType(TypedDict):
    """Dependabot Secret

    Set secrets for Dependabot.
    """

    name: str
    created_at: datetime
    updated_at: datetime


class DependencyGraphDiffItemsType(TypedDict):
    """DependencyGraphDiffItems"""

    change_type: Literal["added", "removed"]
    manifest: str
    ecosystem: str
    name: str
    version: str
    package_url: Union[str, None]
    license_: Union[str, None]
    source_repository_url: Union[str, None]
    vulnerabilities: List[DependencyGraphDiffItemsPropVulnerabilitiesItemsType]
    scope: Literal["unknown", "runtime", "development"]


class DependencyGraphDiffItemsPropVulnerabilitiesItemsType(TypedDict):
    """DependencyGraphDiffItemsPropVulnerabilitiesItems"""

    severity: str
    advisory_ghsa_id: str
    advisory_summary: str
    advisory_url: str


class DependencyGraphSpdxSbomType(TypedDict):
    """Dependency Graph SPDX SBOM

    A schema for the SPDX JSON format returned by the Dependency Graph.
    """

    sbom: DependencyGraphSpdxSbomPropSbomType


class DependencyGraphSpdxSbomPropSbomType(TypedDict):
    """DependencyGraphSpdxSbomPropSbom"""

    spdxid: str
    spdx_version: str
    creation_info: DependencyGraphSpdxSbomPropSbomPropCreationInfoType
    name: str
    data_license: str
    document_describes: List[str]
    document_namespace: str
    packages: List[DependencyGraphSpdxSbomPropSbomPropPackagesItemsType]


class DependencyGraphSpdxSbomPropSbomPropCreationInfoType(TypedDict):
    """DependencyGraphSpdxSbomPropSbomPropCreationInfo"""

    created: str
    creators: List[str]


class DependencyGraphSpdxSbomPropSbomPropPackagesItemsType(TypedDict):
    """DependencyGraphSpdxSbomPropSbomPropPackagesItems"""

    spdxid: NotRequired[str]
    name: NotRequired[str]
    version_info: NotRequired[str]
    download_location: NotRequired[str]
    files_analyzed: NotRequired[bool]
    license_concluded: NotRequired[str]
    license_declared: NotRequired[str]
    supplier: NotRequired[str]
    external_refs: NotRequired[
        List[DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItemsType]
    ]


class DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItemsType(
    TypedDict
):
    """DependencyGraphSpdxSbomPropSbomPropPackagesItemsPropExternalRefsItems"""

    reference_category: str
    reference_locator: str
    reference_type: str


class MetadataType(TypedDict):
    """metadata

    User-defined metadata to store domain-specific information limited to 8 keys
    with scalar values.
    """


class DependencyType(TypedDict):
    """Dependency"""

    package_url: NotRequired[str]
    metadata: NotRequired[MetadataType]
    relationship: NotRequired[Literal["direct", "indirect"]]
    scope: NotRequired[Literal["runtime", "development"]]
    dependencies: NotRequired[List[str]]


class ManifestType(TypedDict):
    """Manifest"""

    name: str
    file: NotRequired[ManifestPropFileType]
    metadata: NotRequired[MetadataType]
    resolved: NotRequired[ManifestPropResolvedType]


class ManifestPropFileType(TypedDict):
    """ManifestPropFile"""

    source_location: NotRequired[str]


class ManifestPropResolvedType(TypedDict):
    """ManifestPropResolved

    A collection of resolved package dependencies.
    """


class SnapshotType(TypedDict):
    """snapshot

    Create a new snapshot of a repository's dependencies.
    """

    version: int
    job: SnapshotPropJobType
    sha: str
    ref: str
    detector: SnapshotPropDetectorType
    metadata: NotRequired[MetadataType]
    manifests: NotRequired[SnapshotPropManifestsType]
    scanned: datetime


class SnapshotPropJobType(TypedDict):
    """SnapshotPropJob"""

    id: str
    correlator: str
    html_url: NotRequired[str]


class SnapshotPropDetectorType(TypedDict):
    """SnapshotPropDetector

    A description of the detector used.
    """

    name: str
    version: str
    url: str


class SnapshotPropManifestsType(TypedDict):
    """SnapshotPropManifests

    A collection of package manifests, which are a collection of related
    dependencies declared in a file or representing a logical group of dependencies.
    """


class DeploymentStatusType(TypedDict):
    """Deployment Status

    The status of a deployment.
    """

    url: str
    id: int
    node_id: str
    state: Literal[
        "error", "failure", "inactive", "pending", "success", "queued", "in_progress"
    ]
    creator: Union[None, SimpleUserType]
    description: str
    environment: NotRequired[str]
    target_url: str
    created_at: datetime
    updated_at: datetime
    deployment_url: str
    repository_url: str
    environment_url: NotRequired[str]
    log_url: NotRequired[str]
    performed_via_github_app: NotRequired[Union[None, IntegrationType]]


class DeploymentBranchPolicySettingsType(TypedDict):
    """DeploymentBranchPolicySettings

    The type of deployment branch policy for this environment. To allow all branches
    to deploy, set to `null`.
    """

    protected_branches: bool
    custom_branch_policies: bool


class EnvironmentType(TypedDict):
    """Environment

    Details of a deployment environment
    """

    id: int
    node_id: str
    name: str
    url: str
    html_url: str
    created_at: datetime
    updated_at: datetime
    protection_rules: NotRequired[
        List[
            Union[
                EnvironmentPropProtectionRulesItemsAnyof0Type,
                EnvironmentPropProtectionRulesItemsAnyof1Type,
                EnvironmentPropProtectionRulesItemsAnyof2Type,
            ]
        ]
    ]
    deployment_branch_policy: NotRequired[
        Union[DeploymentBranchPolicySettingsType, None]
    ]


class EnvironmentPropProtectionRulesItemsAnyof0Type(TypedDict):
    """EnvironmentPropProtectionRulesItemsAnyof0"""

    id: int
    node_id: str
    type: str
    wait_timer: NotRequired[int]


class EnvironmentPropProtectionRulesItemsAnyof1Type(TypedDict):
    """EnvironmentPropProtectionRulesItemsAnyof1"""

    id: int
    node_id: str
    prevent_self_review: NotRequired[bool]
    type: str
    reviewers: NotRequired[
        List[EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItemsType]
    ]


class EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItemsType(TypedDict):
    """EnvironmentPropProtectionRulesItemsAnyof1PropReviewersItems"""

    type: NotRequired[Literal["User", "Team"]]
    reviewer: NotRequired[Union[SimpleUserType, TeamType]]


class EnvironmentPropProtectionRulesItemsAnyof2Type(TypedDict):
    """EnvironmentPropProtectionRulesItemsAnyof2"""

    id: int
    node_id: str
    type: str


class DeploymentBranchPolicyType(TypedDict):
    """Deployment branch policy

    Details of a deployment branch or tag policy.
    """

    id: NotRequired[int]
    node_id: NotRequired[str]
    name: NotRequired[str]
    type: NotRequired[Literal["branch", "tag"]]


class DeploymentBranchPolicyNamePatternWithTypeType(TypedDict):
    """Deployment branch and tag policy name pattern"""

    name: str
    type: NotRequired[Literal["branch", "tag"]]


class DeploymentBranchPolicyNamePatternType(TypedDict):
    """Deployment branch policy name pattern"""

    name: str


class CustomDeploymentRuleAppType(TypedDict):
    """Custom deployment protection rule app

    A GitHub App that is providing a custom deployment protection rule.
    """

    id: int
    slug: str
    integration_url: str
    node_id: str


class DeploymentProtectionRuleType(TypedDict):
    """Deployment protection rule

    Deployment protection rule
    """

    id: int
    node_id: str
    enabled: bool
    app: CustomDeploymentRuleAppType


class ShortBlobType(TypedDict):
    """Short Blob

    Short Blob
    """

    url: str
    sha: str


class BlobType(TypedDict):
    """Blob

    Blob
    """

    content: str
    encoding: str
    url: str
    sha: str
    size: Union[int, None]
    node_id: str
    highlighted_content: NotRequired[str]


class GitCommitType(TypedDict):
    """Git Commit

    Low-level Git commit operations within a repository
    """

    sha: str
    node_id: str
    url: str
    author: GitCommitPropAuthorType
    committer: GitCommitPropCommitterType
    message: str
    tree: GitCommitPropTreeType
    parents: List[GitCommitPropParentsItemsType]
    verification: GitCommitPropVerificationType
    html_url: str


class GitCommitPropAuthorType(TypedDict):
    """GitCommitPropAuthor

    Identifying information for the git-user
    """

    date: datetime
    email: str
    name: str


class GitCommitPropCommitterType(TypedDict):
    """GitCommitPropCommitter

    Identifying information for the git-user
    """

    date: datetime
    email: str
    name: str


class GitCommitPropTreeType(TypedDict):
    """GitCommitPropTree"""

    sha: str
    url: str


class GitCommitPropParentsItemsType(TypedDict):
    """GitCommitPropParentsItems"""

    sha: str
    url: str
    html_url: str


class GitCommitPropVerificationType(TypedDict):
    """GitCommitPropVerification"""

    verified: bool
    reason: str
    signature: Union[str, None]
    payload: Union[str, None]


class GitRefType(TypedDict):
    """Git Reference

    Git references within a repository
    """

    ref: str
    node_id: str
    url: str
    object_: GitRefPropObjectType


class GitRefPropObjectType(TypedDict):
    """GitRefPropObject"""

    type: str
    sha: str
    url: str


class GitTagType(TypedDict):
    """Git Tag

    Metadata for a Git tag
    """

    node_id: str
    tag: str
    sha: str
    url: str
    message: str
    tagger: GitTagPropTaggerType
    object_: GitTagPropObjectType
    verification: NotRequired[VerificationType]


class GitTagPropTaggerType(TypedDict):
    """GitTagPropTagger"""

    date: str
    email: str
    name: str


class GitTagPropObjectType(TypedDict):
    """GitTagPropObject"""

    sha: str
    type: str
    url: str


class GitTreeType(TypedDict):
    """Git Tree

    The hierarchy between files in a Git repository.
    """

    sha: str
    url: str
    truncated: bool
    tree: List[GitTreePropTreeItemsType]


class GitTreePropTreeItemsType(TypedDict):
    """GitTreePropTreeItems"""

    path: NotRequired[str]
    mode: NotRequired[str]
    type: NotRequired[str]
    sha: NotRequired[str]
    size: NotRequired[int]
    url: NotRequired[str]


class HookResponseType(TypedDict):
    """Hook Response"""

    code: Union[int, None]
    status: Union[str, None]
    message: Union[str, None]


class HookType(TypedDict):
    """Webhook

    Webhooks for repositories.
    """

    type: str
    id: int
    name: str
    active: bool
    events: List[str]
    config: HookPropConfigType
    updated_at: datetime
    created_at: datetime
    url: str
    test_url: str
    ping_url: str
    deliveries_url: NotRequired[str]
    last_response: HookResponseType


class HookPropConfigType(TypedDict):
    """HookPropConfig"""

    email: NotRequired[str]
    password: NotRequired[str]
    room: NotRequired[str]
    subdomain: NotRequired[str]
    url: NotRequired[str]
    insecure_ssl: NotRequired[Union[str, float]]
    content_type: NotRequired[str]
    digest: NotRequired[str]
    secret: NotRequired[str]
    token: NotRequired[str]


class ImportType(TypedDict):
    """Import

    A repository import from an external source.
    """

    vcs: Union[str, None]
    use_lfs: NotRequired[bool]
    vcs_url: str
    svc_root: NotRequired[str]
    tfvc_project: NotRequired[str]
    status: Literal[
        "auth",
        "error",
        "none",
        "detecting",
        "choose",
        "auth_failed",
        "importing",
        "mapping",
        "waiting_to_push",
        "pushing",
        "complete",
        "setup",
        "unknown",
        "detection_found_multiple",
        "detection_found_nothing",
        "detection_needs_auth",
    ]
    status_text: NotRequired[Union[str, None]]
    failed_step: NotRequired[Union[str, None]]
    error_message: NotRequired[Union[str, None]]
    import_percent: NotRequired[Union[int, None]]
    commit_count: NotRequired[Union[int, None]]
    push_percent: NotRequired[Union[int, None]]
    has_large_files: NotRequired[bool]
    large_files_size: NotRequired[int]
    large_files_count: NotRequired[int]
    project_choices: NotRequired[List[ImportPropProjectChoicesItemsType]]
    message: NotRequired[str]
    authors_count: NotRequired[Union[int, None]]
    url: str
    html_url: str
    authors_url: str
    repository_url: str
    svn_root: NotRequired[str]


class ImportPropProjectChoicesItemsType(TypedDict):
    """ImportPropProjectChoicesItems"""

    vcs: NotRequired[str]
    tfvc_project: NotRequired[str]
    human_name: NotRequired[str]


class PorterAuthorType(TypedDict):
    """Porter Author

    Porter Author
    """

    id: int
    remote_id: str
    remote_name: str
    email: str
    name: str
    url: str
    import_url: str


class PorterLargeFileType(TypedDict):
    """Porter Large File

    Porter Large File
    """

    ref_name: str
    path: str
    oid: str
    size: int


class IssueEventLabelType(TypedDict):
    """Issue Event Label

    Issue Event Label
    """

    name: Union[str, None]
    color: Union[str, None]


class IssueEventDismissedReviewType(TypedDict):
    """Issue Event Dismissed Review"""

    state: str
    review_id: int
    dismissal_message: Union[str, None]
    dismissal_commit_id: NotRequired[Union[str, None]]


class IssueEventMilestoneType(TypedDict):
    """Issue Event Milestone

    Issue Event Milestone
    """

    title: str


class IssueEventProjectCardType(TypedDict):
    """Issue Event Project Card

    Issue Event Project Card
    """

    url: str
    id: int
    project_url: str
    project_id: int
    column_name: str
    previous_column_name: NotRequired[str]


class IssueEventRenameType(TypedDict):
    """Issue Event Rename

    Issue Event Rename
    """

    from_: str
    to: str


class IssueEventType(TypedDict):
    """Issue Event

    Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: Union[None, SimpleUserType]
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: datetime
    issue: NotRequired[Union[None, IssueType]]
    label: NotRequired[IssueEventLabelType]
    assignee: NotRequired[Union[None, SimpleUserType]]
    assigner: NotRequired[Union[None, SimpleUserType]]
    review_requester: NotRequired[Union[None, SimpleUserType]]
    requested_reviewer: NotRequired[Union[None, SimpleUserType]]
    requested_team: NotRequired[TeamType]
    dismissed_review: NotRequired[IssueEventDismissedReviewType]
    milestone: NotRequired[IssueEventMilestoneType]
    project_card: NotRequired[IssueEventProjectCardType]
    rename: NotRequired[IssueEventRenameType]
    author_association: NotRequired[
        Literal[
            "COLLABORATOR",
            "CONTRIBUTOR",
            "FIRST_TIMER",
            "FIRST_TIME_CONTRIBUTOR",
            "MANNEQUIN",
            "MEMBER",
            "NONE",
            "OWNER",
        ]
    ]
    lock_reason: NotRequired[Union[str, None]]
    performed_via_github_app: NotRequired[Union[None, IntegrationType]]


class LabeledIssueEventType(TypedDict):
    """Labeled Issue Event

    Labeled Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["labeled"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    label: LabeledIssueEventPropLabelType


class LabeledIssueEventPropLabelType(TypedDict):
    """LabeledIssueEventPropLabel"""

    name: str
    color: str


class UnlabeledIssueEventType(TypedDict):
    """Unlabeled Issue Event

    Unlabeled Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["unlabeled"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    label: UnlabeledIssueEventPropLabelType


class UnlabeledIssueEventPropLabelType(TypedDict):
    """UnlabeledIssueEventPropLabel"""

    name: str
    color: str


class AssignedIssueEventType(TypedDict):
    """Assigned Issue Event

    Assigned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: IntegrationType
    assignee: SimpleUserType
    assigner: SimpleUserType


class UnassignedIssueEventType(TypedDict):
    """Unassigned Issue Event

    Unassigned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    assignee: SimpleUserType
    assigner: SimpleUserType


class MilestonedIssueEventType(TypedDict):
    """Milestoned Issue Event

    Milestoned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["milestoned"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    milestone: MilestonedIssueEventPropMilestoneType


class MilestonedIssueEventPropMilestoneType(TypedDict):
    """MilestonedIssueEventPropMilestone"""

    title: str


class DemilestonedIssueEventType(TypedDict):
    """Demilestoned Issue Event

    Demilestoned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["demilestoned"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    milestone: DemilestonedIssueEventPropMilestoneType


class DemilestonedIssueEventPropMilestoneType(TypedDict):
    """DemilestonedIssueEventPropMilestone"""

    title: str


class RenamedIssueEventType(TypedDict):
    """Renamed Issue Event

    Renamed Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["renamed"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    rename: RenamedIssueEventPropRenameType


class RenamedIssueEventPropRenameType(TypedDict):
    """RenamedIssueEventPropRename"""

    from_: str
    to: str


class ReviewRequestedIssueEventType(TypedDict):
    """Review Requested Issue Event

    Review Requested Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["review_requested"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    review_requester: SimpleUserType
    requested_team: NotRequired[TeamType]
    requested_reviewer: NotRequired[SimpleUserType]


class ReviewRequestRemovedIssueEventType(TypedDict):
    """Review Request Removed Issue Event

    Review Request Removed Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["review_request_removed"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    review_requester: SimpleUserType
    requested_team: NotRequired[TeamType]
    requested_reviewer: NotRequired[SimpleUserType]


class ReviewDismissedIssueEventType(TypedDict):
    """Review Dismissed Issue Event

    Review Dismissed Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["review_dismissed"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    dismissed_review: ReviewDismissedIssueEventPropDismissedReviewType


class ReviewDismissedIssueEventPropDismissedReviewType(TypedDict):
    """ReviewDismissedIssueEventPropDismissedReview"""

    state: str
    review_id: int
    dismissal_message: Union[str, None]
    dismissal_commit_id: NotRequired[str]


class LockedIssueEventType(TypedDict):
    """Locked Issue Event

    Locked Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["locked"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    lock_reason: Union[str, None]


class AddedToProjectIssueEventType(TypedDict):
    """Added to Project Issue Event

    Added to Project Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["added_to_project"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    project_card: NotRequired[AddedToProjectIssueEventPropProjectCardType]


class AddedToProjectIssueEventPropProjectCardType(TypedDict):
    """AddedToProjectIssueEventPropProjectCard"""

    id: int
    url: str
    project_id: int
    project_url: str
    column_name: str
    previous_column_name: NotRequired[str]


class MovedColumnInProjectIssueEventType(TypedDict):
    """Moved Column in Project Issue Event

    Moved Column in Project Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["moved_columns_in_project"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    project_card: NotRequired[MovedColumnInProjectIssueEventPropProjectCardType]


class MovedColumnInProjectIssueEventPropProjectCardType(TypedDict):
    """MovedColumnInProjectIssueEventPropProjectCard"""

    id: int
    url: str
    project_id: int
    project_url: str
    column_name: str
    previous_column_name: NotRequired[str]


class RemovedFromProjectIssueEventType(TypedDict):
    """Removed from Project Issue Event

    Removed from Project Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["removed_from_project"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    project_card: NotRequired[RemovedFromProjectIssueEventPropProjectCardType]


class RemovedFromProjectIssueEventPropProjectCardType(TypedDict):
    """RemovedFromProjectIssueEventPropProjectCard"""

    id: int
    url: str
    project_id: int
    project_url: str
    column_name: str
    previous_column_name: NotRequired[str]


class ConvertedNoteToIssueIssueEventType(TypedDict):
    """Converted Note to Issue Issue Event

    Converted Note to Issue Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["converted_note_to_issue"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: IntegrationType
    project_card: NotRequired[ConvertedNoteToIssueIssueEventPropProjectCardType]


class ConvertedNoteToIssueIssueEventPropProjectCardType(TypedDict):
    """ConvertedNoteToIssueIssueEventPropProjectCard"""

    id: int
    url: str
    project_id: int
    project_url: str
    column_name: str
    previous_column_name: NotRequired[str]


class LabelType(TypedDict):
    """Label

    Color-coded labels help you categorize and filter your issues (just like labels
    in Gmail).
    """

    id: int
    node_id: str
    url: str
    name: str
    description: Union[str, None]
    color: str
    default: bool


class TimelineCommentEventType(TypedDict):
    """Timeline Comment Event

    Timeline Comment Event
    """

    event: Literal["commented"]
    actor: SimpleUserType
    id: int
    node_id: str
    url: str
    body: NotRequired[str]
    body_text: NotRequired[str]
    body_html: NotRequired[str]
    html_url: str
    user: SimpleUserType
    created_at: datetime
    updated_at: datetime
    issue_url: str
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    performed_via_github_app: NotRequired[Union[None, IntegrationType]]
    reactions: NotRequired[ReactionRollupType]


class TimelineCrossReferencedEventType(TypedDict):
    """Timeline Cross Referenced Event

    Timeline Cross Referenced Event
    """

    event: Literal["cross-referenced"]
    actor: NotRequired[SimpleUserType]
    created_at: datetime
    updated_at: datetime
    source: TimelineCrossReferencedEventPropSourceType


class TimelineCrossReferencedEventPropSourceType(TypedDict):
    """TimelineCrossReferencedEventPropSource"""

    type: NotRequired[str]
    issue: NotRequired[IssueType]


class TimelineCommittedEventType(TypedDict):
    """Timeline Committed Event

    Timeline Committed Event
    """

    event: NotRequired[Literal["committed"]]
    sha: str
    node_id: str
    url: str
    author: TimelineCommittedEventPropAuthorType
    committer: TimelineCommittedEventPropCommitterType
    message: str
    tree: TimelineCommittedEventPropTreeType
    parents: List[TimelineCommittedEventPropParentsItemsType]
    verification: TimelineCommittedEventPropVerificationType
    html_url: str


class TimelineCommittedEventPropAuthorType(TypedDict):
    """TimelineCommittedEventPropAuthor

    Identifying information for the git-user
    """

    date: datetime
    email: str
    name: str


class TimelineCommittedEventPropCommitterType(TypedDict):
    """TimelineCommittedEventPropCommitter

    Identifying information for the git-user
    """

    date: datetime
    email: str
    name: str


class TimelineCommittedEventPropTreeType(TypedDict):
    """TimelineCommittedEventPropTree"""

    sha: str
    url: str


class TimelineCommittedEventPropParentsItemsType(TypedDict):
    """TimelineCommittedEventPropParentsItems"""

    sha: str
    url: str
    html_url: str


class TimelineCommittedEventPropVerificationType(TypedDict):
    """TimelineCommittedEventPropVerification"""

    verified: bool
    reason: str
    signature: Union[str, None]
    payload: Union[str, None]


class TimelineReviewedEventType(TypedDict):
    """Timeline Reviewed Event

    Timeline Reviewed Event
    """

    event: Literal["reviewed"]
    id: int
    node_id: str
    user: SimpleUserType
    body: Union[str, None]
    state: str
    html_url: str
    pull_request_url: str
    links: TimelineReviewedEventPropLinksType
    submitted_at: NotRequired[datetime]
    commit_id: str
    body_html: NotRequired[Union[str, None]]
    body_text: NotRequired[Union[str, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]


class TimelineReviewedEventPropLinksType(TypedDict):
    """TimelineReviewedEventPropLinks"""

    html: TimelineReviewedEventPropLinksPropHtmlType
    pull_request: TimelineReviewedEventPropLinksPropPullRequestType


class TimelineReviewedEventPropLinksPropHtmlType(TypedDict):
    """TimelineReviewedEventPropLinksPropHtml"""

    href: str


class TimelineReviewedEventPropLinksPropPullRequestType(TypedDict):
    """TimelineReviewedEventPropLinksPropPullRequest"""

    href: str


class PullRequestReviewCommentType(TypedDict):
    """Pull Request Review Comment

    Pull Request Review Comments are comments on a portion of the Pull Request's
    diff.
    """

    url: str
    pull_request_review_id: Union[int, None]
    id: int
    node_id: str
    diff_hunk: str
    path: str
    position: NotRequired[int]
    original_position: NotRequired[int]
    commit_id: str
    original_commit_id: str
    in_reply_to_id: NotRequired[int]
    user: SimpleUserType
    body: str
    created_at: datetime
    updated_at: datetime
    html_url: str
    pull_request_url: str
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    links: PullRequestReviewCommentPropLinksType
    start_line: NotRequired[Union[int, None]]
    original_start_line: NotRequired[Union[int, None]]
    start_side: NotRequired[Union[None, Literal["LEFT", "RIGHT"]]]
    line: NotRequired[int]
    original_line: NotRequired[int]
    side: NotRequired[Literal["LEFT", "RIGHT"]]
    subject_type: NotRequired[Literal["line", "file"]]
    reactions: NotRequired[ReactionRollupType]
    body_html: NotRequired[str]
    body_text: NotRequired[str]


class PullRequestReviewCommentPropLinksType(TypedDict):
    """PullRequestReviewCommentPropLinks"""

    self_: PullRequestReviewCommentPropLinksPropSelfType
    html: PullRequestReviewCommentPropLinksPropHtmlType
    pull_request: PullRequestReviewCommentPropLinksPropPullRequestType


class PullRequestReviewCommentPropLinksPropSelfType(TypedDict):
    """PullRequestReviewCommentPropLinksPropSelf"""

    href: str


class PullRequestReviewCommentPropLinksPropHtmlType(TypedDict):
    """PullRequestReviewCommentPropLinksPropHtml"""

    href: str


class PullRequestReviewCommentPropLinksPropPullRequestType(TypedDict):
    """PullRequestReviewCommentPropLinksPropPullRequest"""

    href: str


class TimelineLineCommentedEventType(TypedDict):
    """Timeline Line Commented Event

    Timeline Line Commented Event
    """

    event: NotRequired[Literal["line_commented"]]
    node_id: NotRequired[str]
    comments: NotRequired[List[PullRequestReviewCommentType]]


class TimelineCommitCommentedEventType(TypedDict):
    """Timeline Commit Commented Event

    Timeline Commit Commented Event
    """

    event: NotRequired[Literal["commit_commented"]]
    node_id: NotRequired[str]
    commit_id: NotRequired[str]
    comments: NotRequired[List[CommitCommentType]]


class TimelineAssignedIssueEventType(TypedDict):
    """Timeline Assigned Issue Event

    Timeline Assigned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["assigned"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    assignee: SimpleUserType


class TimelineUnassignedIssueEventType(TypedDict):
    """Timeline Unassigned Issue Event

    Timeline Unassigned Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: Literal["unassigned"]
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    assignee: SimpleUserType


class StateChangeIssueEventType(TypedDict):
    """State Change Issue Event

    State Change Issue Event
    """

    id: int
    node_id: str
    url: str
    actor: SimpleUserType
    event: str
    commit_id: Union[str, None]
    commit_url: Union[str, None]
    created_at: str
    performed_via_github_app: Union[None, IntegrationType]
    state_reason: NotRequired[Union[str, None]]


class DeployKeyType(TypedDict):
    """Deploy Key

    An SSH key granting access to a single repository.
    """

    id: int
    key: str
    url: str
    title: str
    verified: bool
    created_at: str
    read_only: bool
    added_by: NotRequired[Union[str, None]]
    last_used: NotRequired[Union[str, None]]


class LanguageType(TypedDict):
    """Language

    Language
    """


class LicenseContentType(TypedDict):
    """License Content

    License Content
    """

    name: str
    path: str
    sha: str
    size: int
    url: str
    html_url: Union[str, None]
    git_url: Union[str, None]
    download_url: Union[str, None]
    type: str
    content: str
    encoding: str
    links: LicenseContentPropLinksType
    license_: Union[None, LicenseSimpleType]


class LicenseContentPropLinksType(TypedDict):
    """LicenseContentPropLinks"""

    git: Union[str, None]
    html: Union[str, None]
    self_: str


class MergedUpstreamType(TypedDict):
    """Merged upstream

    Results of a successful merge upstream request
    """

    message: NotRequired[str]
    merge_type: NotRequired[Literal["merge", "fast-forward", "none"]]
    base_branch: NotRequired[str]


class PagesSourceHashType(TypedDict):
    """Pages Source Hash"""

    branch: str
    path: str


class PagesHttpsCertificateType(TypedDict):
    """Pages Https Certificate"""

    state: Literal[
        "new",
        "authorization_created",
        "authorization_pending",
        "authorized",
        "authorization_revoked",
        "issued",
        "uploaded",
        "approved",
        "errored",
        "bad_authz",
        "destroy_pending",
        "dns_changed",
    ]
    description: str
    domains: List[str]
    expires_at: NotRequired[date]


class PageType(TypedDict):
    """GitHub Pages

    The configuration for GitHub Pages for a repository.
    """

    url: str
    status: Union[None, Literal["built", "building", "errored"]]
    cname: Union[str, None]
    protected_domain_state: NotRequired[
        Union[None, Literal["pending", "verified", "unverified"]]
    ]
    pending_domain_unverified_at: NotRequired[Union[datetime, None]]
    custom_404: bool
    html_url: NotRequired[str]
    build_type: NotRequired[Union[None, Literal["legacy", "workflow"]]]
    source: NotRequired[PagesSourceHashType]
    public: bool
    https_certificate: NotRequired[PagesHttpsCertificateType]
    https_enforced: NotRequired[bool]


class PageBuildType(TypedDict):
    """Page Build

    Page Build
    """

    url: str
    status: str
    error: PageBuildPropErrorType
    pusher: Union[None, SimpleUserType]
    commit: str
    duration: int
    created_at: datetime
    updated_at: datetime


class PageBuildPropErrorType(TypedDict):
    """PageBuildPropError"""

    message: Union[str, None]


class PageBuildStatusType(TypedDict):
    """Page Build Status

    Page Build Status
    """

    url: str
    status: str


class PageDeploymentType(TypedDict):
    """GitHub Pages

    The GitHub Pages deployment status.
    """

    status_url: str
    page_url: str
    preview_url: NotRequired[str]


class PagesHealthCheckType(TypedDict):
    """Pages Health Check Status

    Pages Health Check Status
    """

    domain: NotRequired[PagesHealthCheckPropDomainType]
    alt_domain: NotRequired[Union[PagesHealthCheckPropAltDomainType, None]]


class PagesHealthCheckPropDomainType(TypedDict):
    """PagesHealthCheckPropDomain"""

    host: NotRequired[str]
    uri: NotRequired[str]
    nameservers: NotRequired[str]
    dns_resolves: NotRequired[bool]
    is_proxied: NotRequired[Union[bool, None]]
    is_cloudflare_ip: NotRequired[Union[bool, None]]
    is_fastly_ip: NotRequired[Union[bool, None]]
    is_old_ip_address: NotRequired[Union[bool, None]]
    is_a_record: NotRequired[Union[bool, None]]
    has_cname_record: NotRequired[Union[bool, None]]
    has_mx_records_present: NotRequired[Union[bool, None]]
    is_valid_domain: NotRequired[bool]
    is_apex_domain: NotRequired[bool]
    should_be_a_record: NotRequired[Union[bool, None]]
    is_cname_to_github_user_domain: NotRequired[Union[bool, None]]
    is_cname_to_pages_dot_github_dot_com: NotRequired[Union[bool, None]]
    is_cname_to_fastly: NotRequired[Union[bool, None]]
    is_pointed_to_github_pages_ip: NotRequired[Union[bool, None]]
    is_non_github_pages_ip_present: NotRequired[Union[bool, None]]
    is_pages_domain: NotRequired[bool]
    is_served_by_pages: NotRequired[Union[bool, None]]
    is_valid: NotRequired[bool]
    reason: NotRequired[Union[str, None]]
    responds_to_https: NotRequired[bool]
    enforces_https: NotRequired[bool]
    https_error: NotRequired[Union[str, None]]
    is_https_eligible: NotRequired[Union[bool, None]]
    caa_error: NotRequired[Union[str, None]]


class PagesHealthCheckPropAltDomainType(TypedDict):
    """PagesHealthCheckPropAltDomain"""

    host: NotRequired[str]
    uri: NotRequired[str]
    nameservers: NotRequired[str]
    dns_resolves: NotRequired[bool]
    is_proxied: NotRequired[Union[bool, None]]
    is_cloudflare_ip: NotRequired[Union[bool, None]]
    is_fastly_ip: NotRequired[Union[bool, None]]
    is_old_ip_address: NotRequired[Union[bool, None]]
    is_a_record: NotRequired[Union[bool, None]]
    has_cname_record: NotRequired[Union[bool, None]]
    has_mx_records_present: NotRequired[Union[bool, None]]
    is_valid_domain: NotRequired[bool]
    is_apex_domain: NotRequired[bool]
    should_be_a_record: NotRequired[Union[bool, None]]
    is_cname_to_github_user_domain: NotRequired[Union[bool, None]]
    is_cname_to_pages_dot_github_dot_com: NotRequired[Union[bool, None]]
    is_cname_to_fastly: NotRequired[Union[bool, None]]
    is_pointed_to_github_pages_ip: NotRequired[Union[bool, None]]
    is_non_github_pages_ip_present: NotRequired[Union[bool, None]]
    is_pages_domain: NotRequired[bool]
    is_served_by_pages: NotRequired[Union[bool, None]]
    is_valid: NotRequired[bool]
    reason: NotRequired[Union[str, None]]
    responds_to_https: NotRequired[bool]
    enforces_https: NotRequired[bool]
    https_error: NotRequired[Union[str, None]]
    is_https_eligible: NotRequired[Union[bool, None]]
    caa_error: NotRequired[Union[str, None]]


class PullRequestType(TypedDict):
    """Pull Request

    Pull requests let you tell others about changes you've pushed to a repository on
    GitHub. Once a pull request is sent, interested parties can review the set of
    changes, discuss potential modifications, and even push follow-up commits if
    necessary.
    """

    url: str
    id: int
    node_id: str
    html_url: str
    diff_url: str
    patch_url: str
    issue_url: str
    commits_url: str
    review_comments_url: str
    review_comment_url: str
    comments_url: str
    statuses_url: str
    number: int
    state: Literal["open", "closed"]
    locked: bool
    title: str
    user: SimpleUserType
    body: Union[str, None]
    labels: List[PullRequestPropLabelsItemsType]
    milestone: Union[None, MilestoneType]
    active_lock_reason: NotRequired[Union[str, None]]
    created_at: datetime
    updated_at: datetime
    closed_at: Union[datetime, None]
    merged_at: Union[datetime, None]
    merge_commit_sha: Union[str, None]
    assignee: Union[None, SimpleUserType]
    assignees: NotRequired[Union[List[SimpleUserType], None]]
    requested_reviewers: NotRequired[Union[List[SimpleUserType], None]]
    requested_teams: NotRequired[Union[List[TeamSimpleType], None]]
    head: PullRequestPropHeadType
    base: PullRequestPropBaseType
    links: PullRequestPropLinksType
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    auto_merge: Union[AutoMergeType, None]
    draft: NotRequired[bool]
    merged: bool
    mergeable: Union[bool, None]
    rebaseable: NotRequired[Union[bool, None]]
    mergeable_state: str
    merged_by: Union[None, SimpleUserType]
    comments: int
    review_comments: int
    maintainer_can_modify: bool
    commits: int
    additions: int
    deletions: int
    changed_files: int


class PullRequestPropLabelsItemsType(TypedDict):
    """PullRequestPropLabelsItems"""

    id: int
    node_id: str
    url: str
    name: str
    description: Union[str, None]
    color: str
    default: bool


class PullRequestPropHeadType(TypedDict):
    """PullRequestPropHead"""

    label: Union[str, None]
    ref: str
    repo: Union[PullRequestPropHeadPropRepoType, None]
    sha: str
    user: Union[PullRequestPropHeadPropUserType, None]


class PullRequestPropHeadPropRepoPropOwnerType(TypedDict):
    """PullRequestPropHeadPropRepoPropOwner"""

    avatar_url: str
    events_url: str
    followers_url: str
    following_url: str
    gists_url: str
    gravatar_id: Union[str, None]
    html_url: str
    id: int
    node_id: str
    login: str
    organizations_url: str
    received_events_url: str
    repos_url: str
    site_admin: bool
    starred_url: str
    subscriptions_url: str
    type: str
    url: str


class PullRequestPropHeadPropRepoPropPermissionsType(TypedDict):
    """PullRequestPropHeadPropRepoPropPermissions"""

    admin: bool
    maintain: NotRequired[bool]
    push: bool
    triage: NotRequired[bool]
    pull: bool


class PullRequestPropHeadPropRepoPropLicenseType(TypedDict):
    """PullRequestPropHeadPropRepoPropLicense"""

    key: str
    name: str
    url: Union[str, None]
    spdx_id: Union[str, None]
    node_id: str


class PullRequestPropHeadPropRepoType(TypedDict):
    """PullRequestPropHeadPropRepo"""

    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    description: Union[str, None]
    downloads_url: str
    events_url: str
    fork: bool
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    hooks_url: str
    html_url: str
    id: int
    node_id: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    name: str
    notifications_url: str
    owner: PullRequestPropHeadPropRepoPropOwnerType
    private: bool
    pulls_url: str
    releases_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    url: str
    clone_url: str
    default_branch: str
    forks: int
    forks_count: int
    git_url: str
    has_downloads: bool
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    has_discussions: bool
    homepage: Union[str, None]
    language: Union[str, None]
    master_branch: NotRequired[str]
    archived: bool
    disabled: bool
    visibility: NotRequired[str]
    mirror_url: Union[str, None]
    open_issues: int
    open_issues_count: int
    permissions: NotRequired[PullRequestPropHeadPropRepoPropPermissionsType]
    temp_clone_token: NotRequired[Union[str, None]]
    allow_merge_commit: NotRequired[bool]
    allow_squash_merge: NotRequired[bool]
    allow_rebase_merge: NotRequired[bool]
    license_: Union[PullRequestPropHeadPropRepoPropLicenseType, None]
    pushed_at: datetime
    size: int
    ssh_url: str
    stargazers_count: int
    svn_url: str
    topics: NotRequired[List[str]]
    watchers: int
    watchers_count: int
    created_at: datetime
    updated_at: datetime
    allow_forking: NotRequired[bool]
    is_template: NotRequired[bool]
    web_commit_signoff_required: NotRequired[bool]


class PullRequestPropHeadPropUserType(TypedDict):
    """PullRequestPropHeadPropUser"""

    avatar_url: str
    events_url: str
    followers_url: str
    following_url: str
    gists_url: str
    gravatar_id: Union[str, None]
    html_url: str
    id: int
    node_id: str
    login: str
    organizations_url: str
    received_events_url: str
    repos_url: str
    site_admin: bool
    starred_url: str
    subscriptions_url: str
    type: str
    url: str


class PullRequestPropBaseType(TypedDict):
    """PullRequestPropBase"""

    label: str
    ref: str
    repo: PullRequestPropBasePropRepoType
    sha: str
    user: PullRequestPropBasePropUserType


class PullRequestPropBasePropRepoType(TypedDict):
    """PullRequestPropBasePropRepo"""

    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    description: Union[str, None]
    downloads_url: str
    events_url: str
    fork: bool
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    hooks_url: str
    html_url: str
    id: int
    is_template: NotRequired[bool]
    node_id: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    name: str
    notifications_url: str
    owner: PullRequestPropBasePropRepoPropOwnerType
    private: bool
    pulls_url: str
    releases_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    url: str
    clone_url: str
    default_branch: str
    forks: int
    forks_count: int
    git_url: str
    has_downloads: bool
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    has_discussions: bool
    homepage: Union[str, None]
    language: Union[str, None]
    master_branch: NotRequired[str]
    archived: bool
    disabled: bool
    visibility: NotRequired[str]
    mirror_url: Union[str, None]
    open_issues: int
    open_issues_count: int
    permissions: NotRequired[PullRequestPropBasePropRepoPropPermissionsType]
    temp_clone_token: NotRequired[Union[str, None]]
    allow_merge_commit: NotRequired[bool]
    allow_squash_merge: NotRequired[bool]
    allow_rebase_merge: NotRequired[bool]
    license_: Union[None, LicenseSimpleType]
    pushed_at: datetime
    size: int
    ssh_url: str
    stargazers_count: int
    svn_url: str
    topics: NotRequired[List[str]]
    watchers: int
    watchers_count: int
    created_at: datetime
    updated_at: datetime
    allow_forking: NotRequired[bool]
    web_commit_signoff_required: NotRequired[bool]


class PullRequestPropBasePropRepoPropOwnerType(TypedDict):
    """PullRequestPropBasePropRepoPropOwner"""

    avatar_url: str
    events_url: str
    followers_url: str
    following_url: str
    gists_url: str
    gravatar_id: Union[str, None]
    html_url: str
    id: int
    node_id: str
    login: str
    organizations_url: str
    received_events_url: str
    repos_url: str
    site_admin: bool
    starred_url: str
    subscriptions_url: str
    type: str
    url: str


class PullRequestPropBasePropRepoPropPermissionsType(TypedDict):
    """PullRequestPropBasePropRepoPropPermissions"""

    admin: bool
    maintain: NotRequired[bool]
    push: bool
    triage: NotRequired[bool]
    pull: bool


class PullRequestPropBasePropUserType(TypedDict):
    """PullRequestPropBasePropUser"""

    avatar_url: str
    events_url: str
    followers_url: str
    following_url: str
    gists_url: str
    gravatar_id: Union[str, None]
    html_url: str
    id: int
    node_id: str
    login: str
    organizations_url: str
    received_events_url: str
    repos_url: str
    site_admin: bool
    starred_url: str
    subscriptions_url: str
    type: str
    url: str


class PullRequestPropLinksType(TypedDict):
    """PullRequestPropLinks"""

    comments: LinkType
    commits: LinkType
    statuses: LinkType
    html: LinkType
    issue: LinkType
    review_comments: LinkType
    review_comment: LinkType
    self_: LinkType


class PullRequestMergeResultType(TypedDict):
    """Pull Request Merge Result

    Pull Request Merge Result
    """

    sha: str
    merged: bool
    message: str


class PullRequestReviewRequestType(TypedDict):
    """Pull Request Review Request

    Pull Request Review Request
    """

    users: List[SimpleUserType]
    teams: List[TeamType]


class PullRequestReviewType(TypedDict):
    """Pull Request Review

    Pull Request Reviews are reviews on pull requests.
    """

    id: int
    node_id: str
    user: Union[None, SimpleUserType]
    body: str
    state: str
    html_url: str
    pull_request_url: str
    links: PullRequestReviewPropLinksType
    submitted_at: NotRequired[datetime]
    commit_id: Union[str, None]
    body_html: NotRequired[str]
    body_text: NotRequired[str]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]


class PullRequestReviewPropLinksType(TypedDict):
    """PullRequestReviewPropLinks"""

    html: PullRequestReviewPropLinksPropHtmlType
    pull_request: PullRequestReviewPropLinksPropPullRequestType


class PullRequestReviewPropLinksPropHtmlType(TypedDict):
    """PullRequestReviewPropLinksPropHtml"""

    href: str


class PullRequestReviewPropLinksPropPullRequestType(TypedDict):
    """PullRequestReviewPropLinksPropPullRequest"""

    href: str


class ReviewCommentType(TypedDict):
    """Legacy Review Comment

    Legacy Review Comment
    """

    url: str
    pull_request_review_id: Union[int, None]
    id: int
    node_id: str
    diff_hunk: str
    path: str
    position: Union[int, None]
    original_position: int
    commit_id: str
    original_commit_id: str
    in_reply_to_id: NotRequired[int]
    user: Union[None, SimpleUserType]
    body: str
    created_at: datetime
    updated_at: datetime
    html_url: str
    pull_request_url: str
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    links: ReviewCommentPropLinksType
    body_text: NotRequired[str]
    body_html: NotRequired[str]
    reactions: NotRequired[ReactionRollupType]
    side: NotRequired[Literal["LEFT", "RIGHT"]]
    start_side: NotRequired[Union[None, Literal["LEFT", "RIGHT"]]]
    line: NotRequired[int]
    original_line: NotRequired[int]
    start_line: NotRequired[Union[int, None]]
    original_start_line: NotRequired[Union[int, None]]


class ReviewCommentPropLinksType(TypedDict):
    """ReviewCommentPropLinks"""

    self_: LinkType
    html: LinkType
    pull_request: LinkType


class ReleaseAssetType(TypedDict):
    """Release Asset

    Data related to a release.
    """

    url: str
    browser_download_url: str
    id: int
    node_id: str
    name: str
    label: Union[str, None]
    state: Literal["uploaded", "open"]
    content_type: str
    size: int
    download_count: int
    created_at: datetime
    updated_at: datetime
    uploader: Union[None, SimpleUserType]


class ReleaseType(TypedDict):
    """Release

    A release.
    """

    url: str
    html_url: str
    assets_url: str
    upload_url: str
    tarball_url: Union[str, None]
    zipball_url: Union[str, None]
    id: int
    node_id: str
    tag_name: str
    target_commitish: str
    name: Union[str, None]
    body: NotRequired[Union[str, None]]
    draft: bool
    prerelease: bool
    created_at: datetime
    published_at: Union[datetime, None]
    author: SimpleUserType
    assets: List[ReleaseAssetType]
    body_html: NotRequired[Union[str, None]]
    body_text: NotRequired[Union[str, None]]
    mentions_count: NotRequired[int]
    discussion_url: NotRequired[str]
    reactions: NotRequired[ReactionRollupType]


class ReleaseNotesContentType(TypedDict):
    """Generated Release Notes Content

    Generated name and body describing a release
    """

    name: str
    body: str


class RepositoryRuleRulesetInfoType(TypedDict):
    """repository ruleset data for rule

    User-defined metadata to store domain-specific information limited to 8 keys
    with scalar values.
    """

    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof0Type(TypedDict):
    """RepositoryRuleDetailedOneof0"""

    type: Literal["creation"]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof1Type(TypedDict):
    """RepositoryRuleDetailedOneof1"""

    type: Literal["update"]
    parameters: NotRequired[RepositoryRuleUpdatePropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof2Type(TypedDict):
    """RepositoryRuleDetailedOneof2"""

    type: Literal["deletion"]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof3Type(TypedDict):
    """RepositoryRuleDetailedOneof3"""

    type: Literal["required_linear_history"]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof4Type(TypedDict):
    """RepositoryRuleDetailedOneof4"""

    type: Literal["required_deployments"]
    parameters: NotRequired[RepositoryRuleRequiredDeploymentsPropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof5Type(TypedDict):
    """RepositoryRuleDetailedOneof5"""

    type: Literal["required_signatures"]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof6Type(TypedDict):
    """RepositoryRuleDetailedOneof6"""

    type: Literal["pull_request"]
    parameters: NotRequired[RepositoryRulePullRequestPropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof7Type(TypedDict):
    """RepositoryRuleDetailedOneof7"""

    type: Literal["required_status_checks"]
    parameters: NotRequired[RepositoryRuleRequiredStatusChecksPropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof8Type(TypedDict):
    """RepositoryRuleDetailedOneof8"""

    type: Literal["non_fast_forward"]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof9Type(TypedDict):
    """RepositoryRuleDetailedOneof9"""

    type: Literal["commit_message_pattern"]
    parameters: NotRequired[RepositoryRuleCommitMessagePatternPropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof10Type(TypedDict):
    """RepositoryRuleDetailedOneof10"""

    type: Literal["commit_author_email_pattern"]
    parameters: NotRequired[RepositoryRuleCommitAuthorEmailPatternPropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof11Type(TypedDict):
    """RepositoryRuleDetailedOneof11"""

    type: Literal["committer_email_pattern"]
    parameters: NotRequired[RepositoryRuleCommitterEmailPatternPropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof12Type(TypedDict):
    """RepositoryRuleDetailedOneof12"""

    type: Literal["branch_name_pattern"]
    parameters: NotRequired[RepositoryRuleBranchNamePatternPropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof13Type(TypedDict):
    """RepositoryRuleDetailedOneof13"""

    type: Literal["tag_name_pattern"]
    parameters: NotRequired[RepositoryRuleTagNamePatternPropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class RepositoryRuleDetailedOneof14Type(TypedDict):
    """RepositoryRuleDetailedOneof14"""

    type: Literal["workflows"]
    parameters: NotRequired[RepositoryRuleWorkflowsPropParametersType]
    ruleset_source_type: NotRequired[Literal["Repository", "Organization"]]
    ruleset_source: NotRequired[str]
    ruleset_id: NotRequired[int]


class SecretScanningAlertType(TypedDict):
    """SecretScanningAlert"""

    number: NotRequired[int]
    created_at: NotRequired[datetime]
    updated_at: NotRequired[Union[None, datetime]]
    url: NotRequired[str]
    html_url: NotRequired[str]
    locations_url: NotRequired[str]
    state: NotRequired[Literal["open", "resolved"]]
    resolution: NotRequired[
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]]
    ]
    resolved_at: NotRequired[Union[datetime, None]]
    resolved_by: NotRequired[Union[None, SimpleUserType]]
    resolution_comment: NotRequired[Union[str, None]]
    secret_type: NotRequired[str]
    secret_type_display_name: NotRequired[str]
    secret: NotRequired[str]
    push_protection_bypassed: NotRequired[Union[bool, None]]
    push_protection_bypassed_by: NotRequired[Union[None, SimpleUserType]]
    push_protection_bypassed_at: NotRequired[Union[datetime, None]]
    validity: NotRequired[Literal["active", "inactive", "unknown"]]


class SecretScanningLocationCommitType(TypedDict):
    """SecretScanningLocationCommit

    Represents a 'commit' secret scanning location type. This location type shows
    that a secret was detected inside a commit to a repository.
    """

    path: str
    start_line: float
    end_line: float
    start_column: float
    end_column: float
    blob_sha: str
    blob_url: str
    commit_sha: str
    commit_url: str


class SecretScanningLocationIssueTitleType(TypedDict):
    """SecretScanningLocationIssueTitle

    Represents an 'issue_title' secret scanning location type. This location type
    shows that a secret was detected in the title of an issue.
    """

    issue_title_url: str


class SecretScanningLocationIssueBodyType(TypedDict):
    """SecretScanningLocationIssueBody

    Represents an 'issue_body' secret scanning location type. This location type
    shows that a secret was detected in the body of an issue.
    """

    issue_body_url: str


class SecretScanningLocationIssueCommentType(TypedDict):
    """SecretScanningLocationIssueComment

    Represents an 'issue_comment' secret scanning location type. This location type
    shows that a secret was detected in a comment on an issue.
    """

    issue_comment_url: str


class SecretScanningLocationDiscussionTitleType(TypedDict):
    """SecretScanningLocationDiscussionTitle

    Represents a 'discussion_title' secret scanning location type. This location
    type shows that a secret was detected in the title of a discussion.
    """

    discussion_title_url: str


class SecretScanningLocationDiscussionBodyType(TypedDict):
    """SecretScanningLocationDiscussionBody

    Represents a 'discussion_body' secret scanning location type. This location type
    shows that a secret was detected in the body of a discussion.
    """

    discussion_body_url: str


class SecretScanningLocationDiscussionCommentType(TypedDict):
    """SecretScanningLocationDiscussionComment

    Represents a 'discussion_comment' secret scanning location type. This location
    type shows that a secret was detected in a comment on a discussion.
    """

    discussion_comment_url: str


class SecretScanningLocationPullRequestTitleType(TypedDict):
    """SecretScanningLocationPullRequestTitle

    Represents a 'pull_request_title' secret scanning location type. This location
    type shows that a secret was detected in the title of a pull request.
    """

    pull_request_title_url: str


class SecretScanningLocationPullRequestBodyType(TypedDict):
    """SecretScanningLocationPullRequestBody

    Represents a 'pull_request_body' secret scanning location type. This location
    type shows that a secret was detected in the body of a pull request.
    """

    pull_request_body_url: str


class SecretScanningLocationPullRequestCommentType(TypedDict):
    """SecretScanningLocationPullRequestComment

    Represents a 'pull_request_comment' secret scanning location type. This location
    type shows that a secret was detected in a comment on a pull request.
    """

    pull_request_comment_url: str


class SecretScanningLocationPullRequestReviewType(TypedDict):
    """SecretScanningLocationPullRequestReview

    Represents a 'pull_request_review' secret scanning location type. This location
    type shows that a secret was detected in a review on a pull request.
    """

    pull_request_review_url: str


class SecretScanningLocationPullRequestReviewCommentType(TypedDict):
    """SecretScanningLocationPullRequestReviewComment

    Represents a 'pull_request_review_comment' secret scanning location type. This
    location type shows that a secret was detected in a review comment on a pull
    request.
    """

    pull_request_review_comment_url: str


class SecretScanningLocationType(TypedDict):
    """SecretScanningLocation"""

    type: Literal[
        "commit",
        "issue_title",
        "issue_body",
        "issue_comment",
        "discussion_title",
        "discussion_body",
        "discussion_comment",
        "pull_request_title",
        "pull_request_body",
        "pull_request_comment",
        "pull_request_review",
        "pull_request_review_comment",
    ]
    details: Union[
        SecretScanningLocationCommitType,
        SecretScanningLocationIssueTitleType,
        SecretScanningLocationIssueBodyType,
        SecretScanningLocationIssueCommentType,
        SecretScanningLocationDiscussionTitleType,
        SecretScanningLocationDiscussionBodyType,
        SecretScanningLocationDiscussionCommentType,
        SecretScanningLocationPullRequestTitleType,
        SecretScanningLocationPullRequestBodyType,
        SecretScanningLocationPullRequestCommentType,
        SecretScanningLocationPullRequestReviewType,
        SecretScanningLocationPullRequestReviewCommentType,
    ]


class RepositoryAdvisoryCreateType(TypedDict):
    """RepositoryAdvisoryCreate"""

    summary: str
    description: str
    cve_id: NotRequired[Union[str, None]]
    vulnerabilities: List[RepositoryAdvisoryCreatePropVulnerabilitiesItemsType]
    cwe_ids: NotRequired[Union[List[str], None]]
    credits_: NotRequired[
        Union[List[RepositoryAdvisoryCreatePropCreditsItemsType], None]
    ]
    severity: NotRequired[Union[None, Literal["critical", "high", "medium", "low"]]]
    cvss_vector_string: NotRequired[Union[str, None]]
    start_private_fork: NotRequired[bool]


class RepositoryAdvisoryCreatePropVulnerabilitiesItemsType(TypedDict):
    """RepositoryAdvisoryCreatePropVulnerabilitiesItems"""

    package: RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackageType
    vulnerable_version_range: NotRequired[Union[str, None]]
    patched_versions: NotRequired[Union[str, None]]
    vulnerable_functions: NotRequired[Union[List[str], None]]


class RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackageType(TypedDict):
    """RepositoryAdvisoryCreatePropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ]
    name: NotRequired[Union[str, None]]


class RepositoryAdvisoryCreatePropCreditsItemsType(TypedDict):
    """RepositoryAdvisoryCreatePropCreditsItems"""

    login: str
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ]


class PrivateVulnerabilityReportCreateType(TypedDict):
    """PrivateVulnerabilityReportCreate"""

    summary: str
    description: str
    vulnerabilities: NotRequired[
        Union[List[PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsType], None]
    ]
    cwe_ids: NotRequired[Union[List[str], None]]
    severity: NotRequired[Union[None, Literal["critical", "high", "medium", "low"]]]
    cvss_vector_string: NotRequired[Union[str, None]]
    start_private_fork: NotRequired[bool]


class PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsType(TypedDict):
    """PrivateVulnerabilityReportCreatePropVulnerabilitiesItems"""

    package: PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackageType
    vulnerable_version_range: NotRequired[Union[str, None]]
    patched_versions: NotRequired[Union[str, None]]
    vulnerable_functions: NotRequired[Union[List[str], None]]


class PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackageType(
    TypedDict
):
    """PrivateVulnerabilityReportCreatePropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ]
    name: NotRequired[Union[str, None]]


class RepositoryAdvisoryUpdateType(TypedDict):
    """RepositoryAdvisoryUpdate"""

    summary: NotRequired[str]
    description: NotRequired[str]
    cve_id: NotRequired[Union[str, None]]
    vulnerabilities: NotRequired[
        List[RepositoryAdvisoryUpdatePropVulnerabilitiesItemsType]
    ]
    cwe_ids: NotRequired[Union[List[str], None]]
    credits_: NotRequired[
        Union[List[RepositoryAdvisoryUpdatePropCreditsItemsType], None]
    ]
    severity: NotRequired[Union[None, Literal["critical", "high", "medium", "low"]]]
    cvss_vector_string: NotRequired[Union[str, None]]
    state: NotRequired[Literal["published", "closed", "draft"]]
    collaborating_users: NotRequired[Union[List[str], None]]
    collaborating_teams: NotRequired[Union[List[str], None]]


class RepositoryAdvisoryUpdatePropVulnerabilitiesItemsType(TypedDict):
    """RepositoryAdvisoryUpdatePropVulnerabilitiesItems"""

    package: RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackageType
    vulnerable_version_range: NotRequired[Union[str, None]]
    patched_versions: NotRequired[Union[str, None]]
    vulnerable_functions: NotRequired[Union[List[str], None]]


class RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackageType(TypedDict):
    """RepositoryAdvisoryUpdatePropVulnerabilitiesItemsPropPackage

    The name of the package affected by the vulnerability.
    """

    ecosystem: Literal[
        "rubygems",
        "npm",
        "pip",
        "maven",
        "nuget",
        "composer",
        "go",
        "rust",
        "erlang",
        "actions",
        "pub",
        "other",
        "swift",
    ]
    name: NotRequired[Union[str, None]]


class RepositoryAdvisoryUpdatePropCreditsItemsType(TypedDict):
    """RepositoryAdvisoryUpdatePropCreditsItems"""

    login: str
    type: Literal[
        "analyst",
        "finder",
        "reporter",
        "coordinator",
        "remediation_developer",
        "remediation_reviewer",
        "remediation_verifier",
        "tool",
        "sponsor",
        "other",
    ]


class StargazerType(TypedDict):
    """Stargazer

    Stargazer
    """

    starred_at: datetime
    user: Union[None, SimpleUserType]


class CommitActivityType(TypedDict):
    """Commit Activity

    Commit Activity
    """

    days: List[int]
    total: int
    week: int


class ContributorActivityType(TypedDict):
    """Contributor Activity

    Contributor Activity
    """

    author: Union[None, SimpleUserType]
    total: int
    weeks: List[ContributorActivityPropWeeksItemsType]


class ContributorActivityPropWeeksItemsType(TypedDict):
    """ContributorActivityPropWeeksItems"""

    w: NotRequired[int]
    a: NotRequired[int]
    d: NotRequired[int]
    c: NotRequired[int]


class ParticipationStatsType(TypedDict):
    """Participation Stats"""

    all_: List[int]
    owner: List[int]


class RepositorySubscriptionType(TypedDict):
    """Repository Invitation

    Repository invitations let you manage who you collaborate with.
    """

    subscribed: bool
    ignored: bool
    reason: Union[str, None]
    created_at: datetime
    url: str
    repository_url: str


class TagType(TypedDict):
    """Tag

    Tag
    """

    name: str
    commit: TagPropCommitType
    zipball_url: str
    tarball_url: str
    node_id: str


class TagPropCommitType(TypedDict):
    """TagPropCommit"""

    sha: str
    url: str


class TagProtectionType(TypedDict):
    """Tag protection

    Tag protection
    """

    id: NotRequired[int]
    created_at: NotRequired[str]
    updated_at: NotRequired[str]
    enabled: NotRequired[bool]
    pattern: str


class TopicType(TypedDict):
    """Topic

    A topic aggregates entities that are related to a subject.
    """

    names: List[str]


class TrafficType(TypedDict):
    """Traffic"""

    timestamp: datetime
    uniques: int
    count: int


class CloneTrafficType(TypedDict):
    """Clone Traffic

    Clone Traffic
    """

    count: int
    uniques: int
    clones: List[TrafficType]


class ContentTrafficType(TypedDict):
    """Content Traffic

    Content Traffic
    """

    path: str
    title: str
    count: int
    uniques: int


class ReferrerTrafficType(TypedDict):
    """Referrer Traffic

    Referrer Traffic
    """

    referrer: str
    count: int
    uniques: int


class ViewTrafficType(TypedDict):
    """View Traffic

    View Traffic
    """

    count: int
    uniques: int
    views: List[TrafficType]


class SearchResultTextMatchesItemsType(TypedDict):
    """SearchResultTextMatchesItems"""

    object_url: NotRequired[str]
    object_type: NotRequired[Union[str, None]]
    property_: NotRequired[str]
    fragment: NotRequired[str]
    matches: NotRequired[List[SearchResultTextMatchesItemsPropMatchesItemsType]]


class SearchResultTextMatchesItemsPropMatchesItemsType(TypedDict):
    """SearchResultTextMatchesItemsPropMatchesItems"""

    text: NotRequired[str]
    indices: NotRequired[List[int]]


class CodeSearchResultItemType(TypedDict):
    """Code Search Result Item

    Code Search Result Item
    """

    name: str
    path: str
    sha: str
    url: str
    git_url: str
    html_url: str
    repository: MinimalRepositoryType
    score: float
    file_size: NotRequired[int]
    language: NotRequired[Union[str, None]]
    last_modified_at: NotRequired[datetime]
    line_numbers: NotRequired[List[str]]
    text_matches: NotRequired[List[SearchResultTextMatchesItemsType]]


class CommitSearchResultItemType(TypedDict):
    """Commit Search Result Item

    Commit Search Result Item
    """

    url: str
    sha: str
    html_url: str
    comments_url: str
    commit: CommitSearchResultItemPropCommitType
    author: Union[None, SimpleUserType]
    committer: Union[None, GitUserType]
    parents: List[CommitSearchResultItemPropParentsItemsType]
    repository: MinimalRepositoryType
    score: float
    node_id: str
    text_matches: NotRequired[List[SearchResultTextMatchesItemsType]]


class CommitSearchResultItemPropCommitType(TypedDict):
    """CommitSearchResultItemPropCommit"""

    author: CommitSearchResultItemPropCommitPropAuthorType
    committer: Union[None, GitUserType]
    comment_count: int
    message: str
    tree: CommitSearchResultItemPropCommitPropTreeType
    url: str
    verification: NotRequired[VerificationType]


class CommitSearchResultItemPropCommitPropAuthorType(TypedDict):
    """CommitSearchResultItemPropCommitPropAuthor"""

    name: str
    email: str
    date: datetime


class CommitSearchResultItemPropCommitPropTreeType(TypedDict):
    """CommitSearchResultItemPropCommitPropTree"""

    sha: str
    url: str


class CommitSearchResultItemPropParentsItemsType(TypedDict):
    """CommitSearchResultItemPropParentsItems"""

    url: NotRequired[str]
    html_url: NotRequired[str]
    sha: NotRequired[str]


class IssueSearchResultItemType(TypedDict):
    """Issue Search Result Item

    Issue Search Result Item
    """

    url: str
    repository_url: str
    labels_url: str
    comments_url: str
    events_url: str
    html_url: str
    id: int
    node_id: str
    number: int
    title: str
    locked: bool
    active_lock_reason: NotRequired[Union[str, None]]
    assignees: NotRequired[Union[List[SimpleUserType], None]]
    user: Union[None, SimpleUserType]
    labels: List[IssueSearchResultItemPropLabelsItemsType]
    state: str
    state_reason: NotRequired[Union[str, None]]
    assignee: Union[None, SimpleUserType]
    milestone: Union[None, MilestoneType]
    comments: int
    created_at: datetime
    updated_at: datetime
    closed_at: Union[datetime, None]
    text_matches: NotRequired[List[SearchResultTextMatchesItemsType]]
    pull_request: NotRequired[IssueSearchResultItemPropPullRequestType]
    body: NotRequired[str]
    score: float
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    draft: NotRequired[bool]
    repository: NotRequired[RepositoryType]
    body_html: NotRequired[str]
    body_text: NotRequired[str]
    timeline_url: NotRequired[str]
    performed_via_github_app: NotRequired[Union[None, IntegrationType]]
    reactions: NotRequired[ReactionRollupType]


class IssueSearchResultItemPropLabelsItemsType(TypedDict):
    """IssueSearchResultItemPropLabelsItems"""

    id: NotRequired[int]
    node_id: NotRequired[str]
    url: NotRequired[str]
    name: NotRequired[str]
    color: NotRequired[str]
    default: NotRequired[bool]
    description: NotRequired[Union[str, None]]


class IssueSearchResultItemPropPullRequestType(TypedDict):
    """IssueSearchResultItemPropPullRequest"""

    merged_at: NotRequired[Union[datetime, None]]
    diff_url: Union[str, None]
    html_url: Union[str, None]
    patch_url: Union[str, None]
    url: Union[str, None]


class LabelSearchResultItemType(TypedDict):
    """Label Search Result Item

    Label Search Result Item
    """

    id: int
    node_id: str
    url: str
    name: str
    color: str
    default: bool
    description: Union[str, None]
    score: float
    text_matches: NotRequired[List[SearchResultTextMatchesItemsType]]


class RepoSearchResultItemType(TypedDict):
    """Repo Search Result Item

    Repo Search Result Item
    """

    id: int
    node_id: str
    name: str
    full_name: str
    owner: Union[None, SimpleUserType]
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    created_at: datetime
    updated_at: datetime
    pushed_at: datetime
    homepage: Union[str, None]
    size: int
    stargazers_count: int
    watchers_count: int
    language: Union[str, None]
    forks_count: int
    open_issues_count: int
    master_branch: NotRequired[str]
    default_branch: str
    score: float
    forks_url: str
    keys_url: str
    collaborators_url: str
    teams_url: str
    hooks_url: str
    issue_events_url: str
    events_url: str
    assignees_url: str
    branches_url: str
    tags_url: str
    blobs_url: str
    git_tags_url: str
    git_refs_url: str
    trees_url: str
    statuses_url: str
    languages_url: str
    stargazers_url: str
    contributors_url: str
    subscribers_url: str
    subscription_url: str
    commits_url: str
    git_commits_url: str
    comments_url: str
    issue_comment_url: str
    contents_url: str
    compare_url: str
    merges_url: str
    archive_url: str
    downloads_url: str
    issues_url: str
    pulls_url: str
    milestones_url: str
    notifications_url: str
    labels_url: str
    releases_url: str
    deployments_url: str
    git_url: str
    ssh_url: str
    clone_url: str
    svn_url: str
    forks: int
    open_issues: int
    watchers: int
    topics: NotRequired[List[str]]
    mirror_url: Union[str, None]
    has_issues: bool
    has_projects: bool
    has_pages: bool
    has_wiki: bool
    has_downloads: bool
    has_discussions: NotRequired[bool]
    archived: bool
    disabled: bool
    visibility: NotRequired[str]
    license_: Union[None, LicenseSimpleType]
    permissions: NotRequired[RepoSearchResultItemPropPermissionsType]
    text_matches: NotRequired[List[SearchResultTextMatchesItemsType]]
    temp_clone_token: NotRequired[Union[str, None]]
    allow_merge_commit: NotRequired[bool]
    allow_squash_merge: NotRequired[bool]
    allow_rebase_merge: NotRequired[bool]
    allow_auto_merge: NotRequired[bool]
    delete_branch_on_merge: NotRequired[bool]
    allow_forking: NotRequired[bool]
    is_template: NotRequired[bool]
    web_commit_signoff_required: NotRequired[bool]


class RepoSearchResultItemPropPermissionsType(TypedDict):
    """RepoSearchResultItemPropPermissions"""

    admin: bool
    maintain: NotRequired[bool]
    push: bool
    triage: NotRequired[bool]
    pull: bool


class TopicSearchResultItemType(TypedDict):
    """Topic Search Result Item

    Topic Search Result Item
    """

    name: str
    display_name: Union[str, None]
    short_description: Union[str, None]
    description: Union[str, None]
    created_by: Union[str, None]
    released: Union[str, None]
    created_at: datetime
    updated_at: datetime
    featured: bool
    curated: bool
    score: float
    repository_count: NotRequired[Union[int, None]]
    logo_url: NotRequired[Union[str, None]]
    text_matches: NotRequired[List[SearchResultTextMatchesItemsType]]
    related: NotRequired[Union[List[TopicSearchResultItemPropRelatedItemsType], None]]
    aliases: NotRequired[Union[List[TopicSearchResultItemPropAliasesItemsType], None]]


class TopicSearchResultItemPropRelatedItemsType(TypedDict):
    """TopicSearchResultItemPropRelatedItems"""

    topic_relation: NotRequired[
        TopicSearchResultItemPropRelatedItemsPropTopicRelationType
    ]


class TopicSearchResultItemPropRelatedItemsPropTopicRelationType(TypedDict):
    """TopicSearchResultItemPropRelatedItemsPropTopicRelation"""

    id: NotRequired[int]
    name: NotRequired[str]
    topic_id: NotRequired[int]
    relation_type: NotRequired[str]


class TopicSearchResultItemPropAliasesItemsType(TypedDict):
    """TopicSearchResultItemPropAliasesItems"""

    topic_relation: NotRequired[
        TopicSearchResultItemPropAliasesItemsPropTopicRelationType
    ]


class TopicSearchResultItemPropAliasesItemsPropTopicRelationType(TypedDict):
    """TopicSearchResultItemPropAliasesItemsPropTopicRelation"""

    id: NotRequired[int]
    name: NotRequired[str]
    topic_id: NotRequired[int]
    relation_type: NotRequired[str]


class UserSearchResultItemType(TypedDict):
    """User Search Result Item

    User Search Result Item
    """

    login: str
    id: int
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    received_events_url: str
    type: str
    score: float
    following_url: str
    gists_url: str
    starred_url: str
    events_url: str
    public_repos: NotRequired[int]
    public_gists: NotRequired[int]
    followers: NotRequired[int]
    following: NotRequired[int]
    created_at: NotRequired[datetime]
    updated_at: NotRequired[datetime]
    name: NotRequired[Union[str, None]]
    bio: NotRequired[Union[str, None]]
    email: NotRequired[Union[str, None]]
    location: NotRequired[Union[str, None]]
    site_admin: bool
    hireable: NotRequired[Union[bool, None]]
    text_matches: NotRequired[List[SearchResultTextMatchesItemsType]]
    blog: NotRequired[Union[str, None]]
    company: NotRequired[Union[str, None]]
    suspended_at: NotRequired[Union[datetime, None]]


class PrivateUserType(TypedDict):
    """Private User

    Private User
    """

    login: str
    id: int
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    following_url: str
    gists_url: str
    starred_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    events_url: str
    received_events_url: str
    type: str
    site_admin: bool
    name: Union[str, None]
    company: Union[str, None]
    blog: Union[str, None]
    location: Union[str, None]
    email: Union[str, None]
    hireable: Union[bool, None]
    bio: Union[str, None]
    twitter_username: NotRequired[Union[str, None]]
    public_repos: int
    public_gists: int
    followers: int
    following: int
    created_at: datetime
    updated_at: datetime
    private_gists: int
    total_private_repos: int
    owned_private_repos: int
    disk_usage: int
    collaborators: int
    two_factor_authentication: bool
    plan: NotRequired[PrivateUserPropPlanType]
    suspended_at: NotRequired[Union[datetime, None]]
    business_plus: NotRequired[bool]
    ldap_dn: NotRequired[str]


class PrivateUserPropPlanType(TypedDict):
    """PrivateUserPropPlan"""

    collaborators: int
    name: str
    space: int
    private_repos: int


class CodespacesSecretType(TypedDict):
    """Codespaces Secret

    Secrets for a GitHub Codespace.
    """

    name: str
    created_at: datetime
    updated_at: datetime
    visibility: Literal["all", "private", "selected"]
    selected_repositories_url: str


class CodespacesUserPublicKeyType(TypedDict):
    """CodespacesUserPublicKey

    The public key used for setting user Codespaces' Secrets.
    """

    key_id: str
    key: str


class CodespaceExportDetailsType(TypedDict):
    """Fetches information about an export of a codespace.

    An export of a codespace. Also, latest export details for a codespace can be
    fetched with id = latest
    """

    state: NotRequired[Union[str, None]]
    completed_at: NotRequired[Union[datetime, None]]
    branch: NotRequired[Union[str, None]]
    sha: NotRequired[Union[str, None]]
    id: NotRequired[str]
    export_url: NotRequired[str]
    html_url: NotRequired[Union[str, None]]


class CodespaceWithFullRepositoryType(TypedDict):
    """Codespace

    A codespace.
    """

    id: int
    name: str
    display_name: NotRequired[Union[str, None]]
    environment_id: Union[str, None]
    owner: SimpleUserType
    billable_owner: SimpleUserType
    repository: FullRepositoryType
    machine: Union[None, CodespaceMachineType]
    devcontainer_path: NotRequired[Union[str, None]]
    prebuild: Union[bool, None]
    created_at: datetime
    updated_at: datetime
    last_used_at: datetime
    state: Literal[
        "Unknown",
        "Created",
        "Queued",
        "Provisioning",
        "Available",
        "Awaiting",
        "Unavailable",
        "Deleted",
        "Moved",
        "Shutdown",
        "Archived",
        "Starting",
        "ShuttingDown",
        "Failed",
        "Exporting",
        "Updating",
        "Rebuilding",
    ]
    url: str
    git_status: CodespaceWithFullRepositoryPropGitStatusType
    location: Literal["EastUs", "SouthEastAsia", "WestEurope", "WestUs2"]
    idle_timeout_minutes: Union[int, None]
    web_url: str
    machines_url: str
    start_url: str
    stop_url: str
    publish_url: NotRequired[Union[str, None]]
    pulls_url: Union[str, None]
    recent_folders: List[str]
    runtime_constraints: NotRequired[
        CodespaceWithFullRepositoryPropRuntimeConstraintsType
    ]
    pending_operation: NotRequired[Union[bool, None]]
    pending_operation_disabled_reason: NotRequired[Union[str, None]]
    idle_timeout_notice: NotRequired[Union[str, None]]
    retention_period_minutes: NotRequired[Union[int, None]]
    retention_expires_at: NotRequired[Union[datetime, None]]


class CodespaceWithFullRepositoryPropGitStatusType(TypedDict):
    """CodespaceWithFullRepositoryPropGitStatus

    Details about the codespace's git repository.
    """

    ahead: NotRequired[int]
    behind: NotRequired[int]
    has_unpushed_changes: NotRequired[bool]
    has_uncommitted_changes: NotRequired[bool]
    ref: NotRequired[str]


class CodespaceWithFullRepositoryPropRuntimeConstraintsType(TypedDict):
    """CodespaceWithFullRepositoryPropRuntimeConstraints"""

    allowed_port_privacy_settings: NotRequired[Union[List[str], None]]


class EmailType(TypedDict):
    """Email

    Email
    """

    email: str
    primary: bool
    verified: bool
    visibility: Union[str, None]


class GpgKeyType(TypedDict):
    """GPG Key

    A unique encryption key
    """

    id: int
    name: NotRequired[Union[str, None]]
    primary_key_id: Union[int, None]
    key_id: str
    public_key: str
    emails: List[GpgKeyPropEmailsItemsType]
    subkeys: List[GpgKeyPropSubkeysItemsType]
    can_sign: bool
    can_encrypt_comms: bool
    can_encrypt_storage: bool
    can_certify: bool
    created_at: datetime
    expires_at: Union[datetime, None]
    revoked: bool
    raw_key: Union[str, None]


class GpgKeyPropEmailsItemsType(TypedDict):
    """GpgKeyPropEmailsItems"""

    email: NotRequired[str]
    verified: NotRequired[bool]


class GpgKeyPropSubkeysItemsType(TypedDict):
    """GpgKeyPropSubkeysItems"""

    id: NotRequired[int]
    primary_key_id: NotRequired[int]
    key_id: NotRequired[str]
    public_key: NotRequired[str]
    emails: NotRequired[List[GpgKeyPropSubkeysItemsPropEmailsItemsType]]
    subkeys: NotRequired[List[Any]]
    can_sign: NotRequired[bool]
    can_encrypt_comms: NotRequired[bool]
    can_encrypt_storage: NotRequired[bool]
    can_certify: NotRequired[bool]
    created_at: NotRequired[str]
    expires_at: NotRequired[Union[str, None]]
    raw_key: NotRequired[Union[str, None]]
    revoked: NotRequired[bool]


class GpgKeyPropSubkeysItemsPropEmailsItemsType(TypedDict):
    """GpgKeyPropSubkeysItemsPropEmailsItems"""

    email: NotRequired[str]
    verified: NotRequired[bool]


class KeyType(TypedDict):
    """Key

    Key
    """

    key: str
    id: int
    url: str
    title: str
    created_at: datetime
    verified: bool
    read_only: bool


class MarketplaceAccountType(TypedDict):
    """Marketplace Account"""

    url: str
    id: int
    type: str
    node_id: NotRequired[str]
    login: str
    email: NotRequired[Union[str, None]]
    organization_billing_email: NotRequired[Union[str, None]]


class UserMarketplacePurchaseType(TypedDict):
    """User Marketplace Purchase

    User Marketplace Purchase
    """

    billing_cycle: str
    next_billing_date: Union[datetime, None]
    unit_count: Union[int, None]
    on_free_trial: bool
    free_trial_ends_on: Union[datetime, None]
    updated_at: Union[datetime, None]
    account: MarketplaceAccountType
    plan: MarketplaceListingPlanType


class SocialAccountType(TypedDict):
    """Social account

    Social media account
    """

    provider: str
    url: str


class SshSigningKeyType(TypedDict):
    """SSH Signing Key

    A public SSH key used to sign Git commits
    """

    key: str
    id: int
    title: str
    created_at: datetime


class StarredRepositoryType(TypedDict):
    """Starred Repository

    Starred Repository
    """

    starred_at: datetime
    repo: RepositoryType


class HovercardType(TypedDict):
    """Hovercard

    Hovercard
    """

    contexts: List[HovercardPropContextsItemsType]


class HovercardPropContextsItemsType(TypedDict):
    """HovercardPropContextsItems"""

    message: str
    octicon: str


class KeySimpleType(TypedDict):
    """Key Simple

    Key Simple
    """

    id: int
    key: str


class EnterpriseWebhooksType(TypedDict):
    """Enterprise

    An enterprise on GitHub. Webhook payloads contain the `enterprise` property when
    the webhook is configured
    on an enterprise account or an organization that's part of an enterprise
    account. For more information,
    see "[About enterprise accounts](https://docs.github.com/admin/overview/about-
    enterprise-accounts)."
    """

    description: NotRequired[Union[str, None]]
    html_url: str
    website_url: NotRequired[Union[str, None]]
    id: int
    node_id: str
    name: str
    slug: str
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    avatar_url: str


class SimpleInstallationType(TypedDict):
    """Simple Installation

    The GitHub App installation. Webhook payloads contain the `installation`
    property when the event is configured
    for and sent to a GitHub App. For more information,
    see "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-
    github-apps/registering-a-github-app/using-webhooks-with-github-apps)."
    """

    id: int
    node_id: str


class OrganizationSimpleWebhooksType(TypedDict):
    """Organization Simple

    A GitHub organization. Webhook payloads contain the `organization` property when
    the webhook is configured for an
    organization, or when the event occurs from activity in a repository owned by an
    organization.
    """

    login: str
    id: int
    node_id: str
    url: str
    repos_url: str
    events_url: str
    hooks_url: str
    issues_url: str
    members_url: str
    public_members_url: str
    avatar_url: str
    description: Union[str, None]


class RepositoryWebhooksType(TypedDict):
    """Repository

    The repository on GitHub where the event occurred. Webhook payloads contain the
    `repository` property
    when the event occurs from activity in a repository.
    """

    id: int
    node_id: str
    name: str
    full_name: str
    license_: Union[None, LicenseSimpleType]
    organization: NotRequired[Union[None, SimpleUserType]]
    forks: int
    permissions: NotRequired[RepositoryWebhooksPropPermissionsType]
    owner: SimpleUserType
    private: bool
    html_url: str
    description: Union[str, None]
    fork: bool
    url: str
    archive_url: str
    assignees_url: str
    blobs_url: str
    branches_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    deployments_url: str
    downloads_url: str
    events_url: str
    forks_url: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    languages_url: str
    merges_url: str
    milestones_url: str
    notifications_url: str
    pulls_url: str
    releases_url: str
    ssh_url: str
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    tags_url: str
    teams_url: str
    trees_url: str
    clone_url: str
    mirror_url: Union[str, None]
    hooks_url: str
    svn_url: str
    homepage: Union[str, None]
    language: Union[str, None]
    forks_count: int
    stargazers_count: int
    watchers_count: int
    size: int
    default_branch: str
    open_issues_count: int
    is_template: NotRequired[bool]
    topics: NotRequired[List[str]]
    custom_properties: NotRequired[RepositoryWebhooksPropCustomPropertiesType]
    has_issues: bool
    has_projects: bool
    has_wiki: bool
    has_pages: bool
    has_downloads: bool
    has_discussions: NotRequired[bool]
    archived: bool
    disabled: bool
    visibility: NotRequired[str]
    pushed_at: Union[datetime, None]
    created_at: Union[datetime, None]
    updated_at: Union[datetime, None]
    allow_rebase_merge: NotRequired[bool]
    template_repository: NotRequired[
        Union[RepositoryWebhooksPropTemplateRepositoryType, None]
    ]
    temp_clone_token: NotRequired[str]
    allow_squash_merge: NotRequired[bool]
    allow_auto_merge: NotRequired[bool]
    delete_branch_on_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    use_squash_pr_title_as_default: NotRequired[bool]
    squash_merge_commit_title: NotRequired[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]]
    squash_merge_commit_message: NotRequired[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ]
    merge_commit_title: NotRequired[Literal["PR_TITLE", "MERGE_MESSAGE"]]
    merge_commit_message: NotRequired[Literal["PR_BODY", "PR_TITLE", "BLANK"]]
    allow_merge_commit: NotRequired[bool]
    allow_forking: NotRequired[bool]
    web_commit_signoff_required: NotRequired[bool]
    subscribers_count: NotRequired[int]
    network_count: NotRequired[int]
    open_issues: int
    watchers: int
    master_branch: NotRequired[str]
    starred_at: NotRequired[str]
    anonymous_access_enabled: NotRequired[bool]


class RepositoryWebhooksPropPermissionsType(TypedDict):
    """RepositoryWebhooksPropPermissions"""

    admin: bool
    pull: bool
    triage: NotRequired[bool]
    push: bool
    maintain: NotRequired[bool]


class RepositoryWebhooksPropCustomPropertiesType(TypedDict):
    """RepositoryWebhooksPropCustomProperties

    The custom properties that were defined for the repository. The keys are the
    custom property names, and the values are the corresponding custom property
    values.
    """


class RepositoryWebhooksPropTemplateRepositoryPropOwnerType(TypedDict):
    """RepositoryWebhooksPropTemplateRepositoryPropOwner"""

    login: NotRequired[str]
    id: NotRequired[int]
    node_id: NotRequired[str]
    avatar_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    url: NotRequired[str]
    html_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    organizations_url: NotRequired[str]
    repos_url: NotRequired[str]
    events_url: NotRequired[str]
    received_events_url: NotRequired[str]
    type: NotRequired[str]
    site_admin: NotRequired[bool]


class RepositoryWebhooksPropTemplateRepositoryPropPermissionsType(TypedDict):
    """RepositoryWebhooksPropTemplateRepositoryPropPermissions"""

    admin: NotRequired[bool]
    maintain: NotRequired[bool]
    push: NotRequired[bool]
    triage: NotRequired[bool]
    pull: NotRequired[bool]


class RepositoryWebhooksPropTemplateRepositoryType(TypedDict):
    """RepositoryWebhooksPropTemplateRepository"""

    id: NotRequired[int]
    node_id: NotRequired[str]
    name: NotRequired[str]
    full_name: NotRequired[str]
    owner: NotRequired[RepositoryWebhooksPropTemplateRepositoryPropOwnerType]
    private: NotRequired[bool]
    html_url: NotRequired[str]
    description: NotRequired[str]
    fork: NotRequired[bool]
    url: NotRequired[str]
    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    forks_url: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    git_url: NotRequired[str]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    notifications_url: NotRequired[str]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    ssh_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    clone_url: NotRequired[str]
    mirror_url: NotRequired[str]
    hooks_url: NotRequired[str]
    svn_url: NotRequired[str]
    homepage: NotRequired[str]
    language: NotRequired[str]
    forks_count: NotRequired[int]
    stargazers_count: NotRequired[int]
    watchers_count: NotRequired[int]
    size: NotRequired[int]
    default_branch: NotRequired[str]
    open_issues_count: NotRequired[int]
    is_template: NotRequired[bool]
    topics: NotRequired[List[str]]
    has_issues: NotRequired[bool]
    has_projects: NotRequired[bool]
    has_wiki: NotRequired[bool]
    has_pages: NotRequired[bool]
    has_downloads: NotRequired[bool]
    archived: NotRequired[bool]
    disabled: NotRequired[bool]
    visibility: NotRequired[str]
    pushed_at: NotRequired[str]
    created_at: NotRequired[str]
    updated_at: NotRequired[str]
    permissions: NotRequired[
        RepositoryWebhooksPropTemplateRepositoryPropPermissionsType
    ]
    allow_rebase_merge: NotRequired[bool]
    temp_clone_token: NotRequired[str]
    allow_squash_merge: NotRequired[bool]
    allow_auto_merge: NotRequired[bool]
    delete_branch_on_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    use_squash_pr_title_as_default: NotRequired[bool]
    squash_merge_commit_title: NotRequired[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]]
    squash_merge_commit_message: NotRequired[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ]
    merge_commit_title: NotRequired[Literal["PR_TITLE", "MERGE_MESSAGE"]]
    merge_commit_message: NotRequired[Literal["PR_BODY", "PR_TITLE", "BLANK"]]
    allow_merge_commit: NotRequired[bool]
    subscribers_count: NotRequired[int]
    network_count: NotRequired[int]


class SimpleUserWebhooksType(TypedDict):
    """Simple User

    The GitHub user that triggered the event. This property is included in every
    webhook payload.
    """

    name: NotRequired[Union[str, None]]
    email: NotRequired[Union[str, None]]
    login: str
    id: int
    node_id: str
    avatar_url: str
    gravatar_id: Union[str, None]
    url: str
    html_url: str
    followers_url: str
    following_url: str
    gists_url: str
    starred_url: str
    subscriptions_url: str
    organizations_url: str
    repos_url: str
    events_url: str
    received_events_url: str
    type: str
    site_admin: bool
    starred_at: NotRequired[str]


class SimpleCheckSuiteType(TypedDict):
    """SimpleCheckSuite

    A suite of checks performed on the code of a given code change
    """

    after: NotRequired[Union[str, None]]
    app: NotRequired[IntegrationType]
    before: NotRequired[Union[str, None]]
    conclusion: NotRequired[
        Union[
            None,
            Literal[
                "success",
                "failure",
                "neutral",
                "cancelled",
                "skipped",
                "timed_out",
                "action_required",
                "stale",
                "startup_failure",
            ],
        ]
    ]
    created_at: NotRequired[datetime]
    head_branch: NotRequired[Union[str, None]]
    head_sha: NotRequired[str]
    id: NotRequired[int]
    node_id: NotRequired[str]
    pull_requests: NotRequired[List[PullRequestMinimalType]]
    repository: NotRequired[MinimalRepositoryType]
    status: NotRequired[
        Literal["queued", "in_progress", "completed", "pending", "waiting"]
    ]
    updated_at: NotRequired[datetime]
    url: NotRequired[str]


class CheckRunWithSimpleCheckSuiteType(TypedDict):
    """CheckRun

    A check performed on the code of a given code change
    """

    app: Union[None, IntegrationType]
    check_suite: SimpleCheckSuiteType
    completed_at: Union[datetime, None]
    conclusion: Union[
        None,
        Literal[
            "waiting",
            "pending",
            "startup_failure",
            "stale",
            "success",
            "failure",
            "neutral",
            "cancelled",
            "skipped",
            "timed_out",
            "action_required",
        ],
    ]
    deployment: NotRequired[DeploymentSimpleType]
    details_url: str
    external_id: str
    head_sha: str
    html_url: str
    id: int
    name: str
    node_id: str
    output: CheckRunWithSimpleCheckSuitePropOutputType
    pull_requests: List[PullRequestMinimalType]
    started_at: datetime
    status: Literal["queued", "in_progress", "completed", "pending"]
    url: str


class CheckRunWithSimpleCheckSuitePropOutputType(TypedDict):
    """CheckRunWithSimpleCheckSuitePropOutput"""

    annotations_count: int
    annotations_url: str
    summary: Union[str, None]
    text: Union[str, None]
    title: Union[str, None]


class DiscussionType(TypedDict):
    """Discussion

    A Discussion in a repository.
    """

    active_lock_reason: Union[str, None]
    answer_chosen_at: Union[str, None]
    answer_chosen_by: Union[DiscussionPropAnswerChosenByType, None]
    answer_html_url: Union[str, None]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    category: DiscussionPropCategoryType
    comments: int
    created_at: datetime
    html_url: str
    id: int
    locked: bool
    node_id: str
    number: int
    reactions: NotRequired[DiscussionPropReactionsType]
    repository_url: str
    state: Literal["open", "closed", "locked", "converting", "transferring"]
    state_reason: Union[None, Literal["resolved", "outdated", "duplicate", "reopened"]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    user: Union[DiscussionPropUserType, None]


class DiscussionPropAnswerChosenByType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class DiscussionPropCategoryType(TypedDict):
    """DiscussionPropCategory"""

    created_at: datetime
    description: str
    emoji: str
    id: int
    is_answerable: bool
    name: str
    node_id: NotRequired[str]
    repository_id: int
    slug: str
    updated_at: str


class DiscussionPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class DiscussionPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class MergeGroupType(TypedDict):
    """Merge Group

    A group of pull requests that the merge queue has grouped together to be merged.
    """

    head_sha: str
    head_ref: str
    base_sha: str
    base_ref: str
    head_commit: SimpleCommitType


class PersonalAccessTokenRequestType(TypedDict):
    """Personal Access Token Request

    Details of a Personal Access Token Request.
    """

    id: int
    owner: SimpleUserType
    permissions_added: PersonalAccessTokenRequestPropPermissionsAddedType
    permissions_upgraded: PersonalAccessTokenRequestPropPermissionsUpgradedType
    permissions_result: PersonalAccessTokenRequestPropPermissionsResultType
    repository_selection: Literal["none", "all", "subset"]
    repository_count: Union[int, None]
    repositories: Union[List[PersonalAccessTokenRequestPropRepositoriesItemsType], None]
    created_at: str
    token_expired: bool
    token_expires_at: Union[str, None]
    token_last_used_at: Union[str, None]


class PersonalAccessTokenRequestPropPermissionsAddedType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsAdded

    New requested permissions, categorized by type of permission.
    """

    organization: NotRequired[
        PersonalAccessTokenRequestPropPermissionsAddedPropOrganizationType
    ]
    repository: NotRequired[
        PersonalAccessTokenRequestPropPermissionsAddedPropRepositoryType
    ]
    other: NotRequired[PersonalAccessTokenRequestPropPermissionsAddedPropOtherType]


class PersonalAccessTokenRequestPropPermissionsAddedPropOrganizationType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsAddedPropOrganization"""


class PersonalAccessTokenRequestPropPermissionsAddedPropRepositoryType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsAddedPropRepository"""


class PersonalAccessTokenRequestPropPermissionsAddedPropOtherType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsAddedPropOther"""


class PersonalAccessTokenRequestPropPermissionsUpgradedType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsUpgraded

    Requested permissions that elevate access for a previously approved request for
    access, categorized by type of permission.
    """

    organization: NotRequired[
        PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganizationType
    ]
    repository: NotRequired[
        PersonalAccessTokenRequestPropPermissionsUpgradedPropRepositoryType
    ]
    other: NotRequired[PersonalAccessTokenRequestPropPermissionsUpgradedPropOtherType]


class PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganizationType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsUpgradedPropOrganization"""


class PersonalAccessTokenRequestPropPermissionsUpgradedPropRepositoryType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsUpgradedPropRepository"""


class PersonalAccessTokenRequestPropPermissionsUpgradedPropOtherType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsUpgradedPropOther"""


class PersonalAccessTokenRequestPropPermissionsResultType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsResult

    Permissions requested, categorized by type of permission. This field
    incorporates `permissions_added` and `permissions_upgraded`.
    """

    organization: NotRequired[
        PersonalAccessTokenRequestPropPermissionsResultPropOrganizationType
    ]
    repository: NotRequired[
        PersonalAccessTokenRequestPropPermissionsResultPropRepositoryType
    ]
    other: NotRequired[PersonalAccessTokenRequestPropPermissionsResultPropOtherType]


class PersonalAccessTokenRequestPropPermissionsResultPropOrganizationType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsResultPropOrganization"""


class PersonalAccessTokenRequestPropPermissionsResultPropRepositoryType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsResultPropRepository"""


class PersonalAccessTokenRequestPropPermissionsResultPropOtherType(TypedDict):
    """PersonalAccessTokenRequestPropPermissionsResultPropOther"""


class PersonalAccessTokenRequestPropRepositoriesItemsType(TypedDict):
    """PersonalAccessTokenRequestPropRepositoriesItems"""

    full_name: str
    id: int
    name: str
    node_id: str
    private: bool


class ProjectsV2Type(TypedDict):
    """Projects v2 Project

    A projects v2 project
    """

    id: float
    node_id: str
    owner: SimpleUserType
    creator: SimpleUserType
    title: str
    description: Union[str, None]
    public: bool
    closed_at: Union[datetime, None]
    created_at: datetime
    updated_at: datetime
    number: int
    short_description: Union[str, None]
    deleted_at: Union[datetime, None]
    deleted_by: Union[None, SimpleUserType]


class ProjectsV2ItemType(TypedDict):
    """Projects v2 Item

    An item belonging to a project
    """

    id: float
    node_id: NotRequired[str]
    project_node_id: NotRequired[str]
    content_node_id: str
    content_type: Literal["Issue", "PullRequest", "DraftIssue"]
    creator: NotRequired[SimpleUserType]
    created_at: datetime
    updated_at: datetime
    archived_at: Union[datetime, None]


class SecretScanningAlertWebhookType(TypedDict):
    """SecretScanningAlertWebhook"""

    number: NotRequired[int]
    created_at: NotRequired[datetime]
    updated_at: NotRequired[Union[None, datetime]]
    url: NotRequired[str]
    html_url: NotRequired[str]
    locations_url: NotRequired[str]
    resolution: NotRequired[
        Union[
            None,
            Literal[
                "false_positive",
                "wont_fix",
                "revoked",
                "used_in_tests",
                "pattern_deleted",
                "pattern_edited",
            ],
        ]
    ]
    resolved_at: NotRequired[Union[datetime, None]]
    resolved_by: NotRequired[Union[None, SimpleUserType]]
    resolution_comment: NotRequired[Union[str, None]]
    secret_type: NotRequired[str]
    push_protection_bypassed: NotRequired[Union[bool, None]]
    push_protection_bypassed_by: NotRequired[Union[None, SimpleUserType]]
    push_protection_bypassed_at: NotRequired[Union[datetime, None]]


class WebhookBranchProtectionConfigurationDisabledType(TypedDict):
    """branch protection configuration disabled event"""

    action: Literal["disabled"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookBranchProtectionConfigurationEnabledType(TypedDict):
    """branch protection configuration enabled event"""

    action: Literal["enabled"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookBranchProtectionRuleCreatedType(TypedDict):
    """branch protection rule created event"""

    action: Literal["created"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    rule: WebhookBranchProtectionRuleCreatedPropRuleType
    sender: SimpleUserWebhooksType


class WebhookBranchProtectionRuleCreatedPropRuleType(TypedDict):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool
    allow_deletions_enforcement_level: Literal["off", "non_admins", "everyone"]
    allow_force_pushes_enforcement_level: Literal["off", "non_admins", "everyone"]
    authorized_actor_names: List[str]
    authorized_actors_only: bool
    authorized_dismissal_actors_only: bool
    create_protected: NotRequired[bool]
    created_at: datetime
    dismiss_stale_reviews_on_push: bool
    id: int
    ignore_approvals_from_contributors: bool
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ]
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"]
    name: str
    pull_request_reviews_enforcement_level: Literal["off", "non_admins", "everyone"]
    repository_id: int
    require_code_owner_review: bool
    require_last_push_approval: NotRequired[bool]
    required_approving_review_count: int
    required_conversation_resolution_level: Literal["off", "non_admins", "everyone"]
    required_deployments_enforcement_level: Literal["off", "non_admins", "everyone"]
    required_status_checks: List[str]
    required_status_checks_enforcement_level: Literal["off", "non_admins", "everyone"]
    signature_requirement_enforcement_level: Literal["off", "non_admins", "everyone"]
    strict_required_status_checks_policy: bool
    updated_at: datetime


class WebhookBranchProtectionRuleDeletedType(TypedDict):
    """branch protection rule deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    rule: WebhookBranchProtectionRuleDeletedPropRuleType
    sender: SimpleUserWebhooksType


class WebhookBranchProtectionRuleDeletedPropRuleType(TypedDict):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool
    allow_deletions_enforcement_level: Literal["off", "non_admins", "everyone"]
    allow_force_pushes_enforcement_level: Literal["off", "non_admins", "everyone"]
    authorized_actor_names: List[str]
    authorized_actors_only: bool
    authorized_dismissal_actors_only: bool
    create_protected: NotRequired[bool]
    created_at: datetime
    dismiss_stale_reviews_on_push: bool
    id: int
    ignore_approvals_from_contributors: bool
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ]
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"]
    name: str
    pull_request_reviews_enforcement_level: Literal["off", "non_admins", "everyone"]
    repository_id: int
    require_code_owner_review: bool
    require_last_push_approval: NotRequired[bool]
    required_approving_review_count: int
    required_conversation_resolution_level: Literal["off", "non_admins", "everyone"]
    required_deployments_enforcement_level: Literal["off", "non_admins", "everyone"]
    required_status_checks: List[str]
    required_status_checks_enforcement_level: Literal["off", "non_admins", "everyone"]
    signature_requirement_enforcement_level: Literal["off", "non_admins", "everyone"]
    strict_required_status_checks_policy: bool
    updated_at: datetime


class WebhookBranchProtectionRuleEditedType(TypedDict):
    """branch protection rule edited event"""

    action: Literal["edited"]
    changes: NotRequired[WebhookBranchProtectionRuleEditedPropChangesType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    rule: WebhookBranchProtectionRuleEditedPropRuleType
    sender: SimpleUserWebhooksType


class WebhookBranchProtectionRuleEditedPropChangesType(TypedDict):
    """WebhookBranchProtectionRuleEditedPropChanges

    If the action was `edited`, the changes to the rule.
    """

    admin_enforced: NotRequired[
        WebhookBranchProtectionRuleEditedPropChangesPropAdminEnforcedType
    ]
    authorized_actor_names: NotRequired[
        WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorNamesType
    ]
    authorized_actors_only: NotRequired[
        WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnlyType
    ]
    authorized_dismissal_actors_only: NotRequired[
        WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnlyType
    ]
    linear_history_requirement_enforcement_level: NotRequired[
        WebhookBranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevelType
    ]
    required_status_checks: NotRequired[
        WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksType
    ]
    required_status_checks_enforcement_level: NotRequired[
        WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevelType
    ]


class WebhookBranchProtectionRuleEditedPropChangesPropAdminEnforcedType(TypedDict):
    """WebhookBranchProtectionRuleEditedPropChangesPropAdminEnforced"""

    from_: Union[bool, None]


class WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorNamesType(
    TypedDict
):
    """WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorNames"""

    from_: List[str]


class WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnlyType(
    TypedDict
):
    """WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedActorsOnly"""

    from_: Union[bool, None]


class WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnlyType(
    TypedDict
):
    """WebhookBranchProtectionRuleEditedPropChangesPropAuthorizedDismissalActorsOnly"""

    from_: Union[bool, None]


class WebhookBranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcementLevelType(
    TypedDict
):
    """WebhookBranchProtectionRuleEditedPropChangesPropLinearHistoryRequirementEnforcem
    entLevel
    """

    from_: Literal["off", "non_admins", "everyone"]


class WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksType(
    TypedDict
):
    """WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecks"""

    from_: List[str]


class WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementLevelType(
    TypedDict
):
    """WebhookBranchProtectionRuleEditedPropChangesPropRequiredStatusChecksEnforcementL
    evel
    """

    from_: Literal["off", "non_admins", "everyone"]


class WebhookBranchProtectionRuleEditedPropRuleType(TypedDict):
    """branch protection rule

    The branch protection rule. Includes a `name` and all the [branch protection
    settings](https://docs.github.com/github/administering-a-repository/defining-
    the-mergeability-of-pull-requests/about-protected-branches#about-branch-
    protection-settings) applied to branches that match the name. Binary settings
    are boolean. Multi-level configurations are one of `off`, `non_admins`, or
    `everyone`. Actor and build lists are arrays of strings.
    """

    admin_enforced: bool
    allow_deletions_enforcement_level: Literal["off", "non_admins", "everyone"]
    allow_force_pushes_enforcement_level: Literal["off", "non_admins", "everyone"]
    authorized_actor_names: List[str]
    authorized_actors_only: bool
    authorized_dismissal_actors_only: bool
    create_protected: NotRequired[bool]
    created_at: datetime
    dismiss_stale_reviews_on_push: bool
    id: int
    ignore_approvals_from_contributors: bool
    linear_history_requirement_enforcement_level: Literal[
        "off", "non_admins", "everyone"
    ]
    merge_queue_enforcement_level: Literal["off", "non_admins", "everyone"]
    name: str
    pull_request_reviews_enforcement_level: Literal["off", "non_admins", "everyone"]
    repository_id: int
    require_code_owner_review: bool
    require_last_push_approval: NotRequired[bool]
    required_approving_review_count: int
    required_conversation_resolution_level: Literal["off", "non_admins", "everyone"]
    required_deployments_enforcement_level: Literal["off", "non_admins", "everyone"]
    required_status_checks: List[str]
    required_status_checks_enforcement_level: Literal["off", "non_admins", "everyone"]
    signature_requirement_enforcement_level: Literal["off", "non_admins", "everyone"]
    strict_required_status_checks_policy: bool
    updated_at: datetime


class WebhookCheckRunCompletedType(TypedDict):
    """Check Run Completed Event"""

    action: Literal["completed"]
    check_run: CheckRunWithSimpleCheckSuiteType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCheckRunCompletedFormEncodedType(TypedDict):
    """Check Run Completed Event

    The check_run.completed webhook encoded with URL encoding
    """

    payload: str


class WebhookCheckRunCreatedType(TypedDict):
    """Check Run Created Event"""

    action: Literal["created"]
    check_run: CheckRunWithSimpleCheckSuiteType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCheckRunCreatedFormEncodedType(TypedDict):
    """Check Run Created Event

    The check_run.created webhook encoded with URL encoding
    """

    payload: str


class WebhookCheckRunRequestedActionType(TypedDict):
    """Check Run Requested Action Event"""

    action: Literal["requested_action"]
    check_run: CheckRunWithSimpleCheckSuiteType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    requested_action: NotRequired[WebhookCheckRunRequestedActionPropRequestedActionType]
    sender: SimpleUserWebhooksType


class WebhookCheckRunRequestedActionPropRequestedActionType(TypedDict):
    """WebhookCheckRunRequestedActionPropRequestedAction

    The action requested by the user.
    """

    identifier: NotRequired[str]


class WebhookCheckRunRequestedActionFormEncodedType(TypedDict):
    """Check Run Requested Action Event

    The check_run.requested_action webhook encoded with URL encoding
    """

    payload: str


class WebhookCheckRunRerequestedType(TypedDict):
    """Check Run Re-Requested Event"""

    action: Literal["rerequested"]
    check_run: CheckRunWithSimpleCheckSuiteType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCheckRunRerequestedFormEncodedType(TypedDict):
    """Check Run Re-Requested Event

    The check_run.rerequested webhook encoded with URL encoding
    """

    payload: str


class WebhookCheckSuiteCompletedType(TypedDict):
    """check_suite completed event"""

    action: Literal["completed"]
    check_suite: WebhookCheckSuiteCompletedPropCheckSuiteType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCheckSuiteCompletedPropCheckSuiteType(TypedDict):
    """WebhookCheckSuiteCompletedPropCheckSuite

    The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite).
    """

    after: Union[str, None]
    app: WebhookCheckSuiteCompletedPropCheckSuitePropAppType
    before: Union[str, None]
    check_runs_url: str
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
            "startup_failure",
        ],
    ]
    created_at: datetime
    head_branch: Union[str, None]
    head_commit: WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitType
    head_sha: str
    id: int
    latest_check_runs_count: int
    node_id: str
    pull_requests: List[
        WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsType
    ]
    rerequestable: NotRequired[bool]
    runs_rerequestable: NotRequired[bool]
    status: Union[
        None, Literal["requested", "in_progress", "completed", "queued", "pending"]
    ]
    updated_at: datetime
    url: str


class WebhookCheckSuiteCompletedPropCheckSuitePropAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "merge_group",
                "pull_request_review_thread",
                "workflow_job",
                "merge_queue_entry",
                "security_and_analysis",
                "projects_v2_item",
                "secret_scanning_alert_location",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[WebhookCheckSuiteCompletedPropCheckSuitePropAppPropOwnerType, None]
    permissions: NotRequired[
        WebhookCheckSuiteCompletedPropCheckSuitePropAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookCheckSuiteCompletedPropCheckSuitePropAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookCheckSuiteCompletedPropCheckSuitePropAppPropPermissionsType(TypedDict):
    """WebhookCheckSuiteCompletedPropCheckSuitePropAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write", "admin"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitType(TypedDict):
    """SimpleCommit"""

    author: WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitPropAuthorType
    committer: WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitPropCommitterType
    id: str
    message: str
    timestamp: str
    tree_id: str


class WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitPropAuthorType(TypedDict):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: NotRequired[datetime]
    email: Union[str, None]
    name: str
    username: NotRequired[str]


class WebhookCheckSuiteCompletedPropCheckSuitePropHeadCommitPropCommitterType(
    TypedDict
):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: NotRequired[datetime]
    email: Union[str, None]
    name: str
    username: NotRequired[str]


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsType(TypedDict):
    """Check Run Pull Request"""

    base: WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBaseType
    head: WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHeadType
    id: int
    number: int
    url: str


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBaseType(
    TypedDict
):
    """WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBase"""

    ref: str
    repo: WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBasePropRepoType
    sha: str


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropBasePropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHeadType(
    TypedDict
):
    """WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHead"""

    ref: str
    repo: WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHeadPropRepoType
    sha: str


class WebhookCheckSuiteCompletedPropCheckSuitePropPullRequestsItemsPropHeadPropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookCheckSuiteRequestedType(TypedDict):
    """check_suite requested event"""

    action: Literal["requested"]
    check_suite: WebhookCheckSuiteRequestedPropCheckSuiteType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCheckSuiteRequestedPropCheckSuiteType(TypedDict):
    """WebhookCheckSuiteRequestedPropCheckSuite

    The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite).
    """

    after: Union[str, None]
    app: WebhookCheckSuiteRequestedPropCheckSuitePropAppType
    before: Union[str, None]
    check_runs_url: str
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ]
    created_at: datetime
    head_branch: Union[str, None]
    head_commit: WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitType
    head_sha: str
    id: int
    latest_check_runs_count: int
    node_id: str
    pull_requests: List[
        WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsType
    ]
    rerequestable: NotRequired[bool]
    runs_rerequestable: NotRequired[bool]
    status: Union[None, Literal["requested", "in_progress", "completed", "queued"]]
    updated_at: datetime
    url: str


class WebhookCheckSuiteRequestedPropCheckSuitePropAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "workflow_job",
                "merge_queue_entry",
                "security_and_analysis",
                "secret_scanning_alert_location",
                "projects_v2_item",
                "merge_group",
                "repository_import",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[WebhookCheckSuiteRequestedPropCheckSuitePropAppPropOwnerType, None]
    permissions: NotRequired[
        WebhookCheckSuiteRequestedPropCheckSuitePropAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookCheckSuiteRequestedPropCheckSuitePropAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookCheckSuiteRequestedPropCheckSuitePropAppPropPermissionsType(TypedDict):
    """WebhookCheckSuiteRequestedPropCheckSuitePropAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write", "admin"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitType(TypedDict):
    """SimpleCommit"""

    author: WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitPropAuthorType
    committer: WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitPropCommitterType
    id: str
    message: str
    timestamp: str
    tree_id: str


class WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitPropAuthorType(TypedDict):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: NotRequired[datetime]
    email: Union[str, None]
    name: str
    username: NotRequired[str]


class WebhookCheckSuiteRequestedPropCheckSuitePropHeadCommitPropCommitterType(
    TypedDict
):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: NotRequired[datetime]
    email: Union[str, None]
    name: str
    username: NotRequired[str]


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsType(TypedDict):
    """Check Run Pull Request"""

    base: WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBaseType
    head: WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHeadType
    id: int
    number: int
    url: str


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBaseType(
    TypedDict
):
    """WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBase"""

    ref: str
    repo: WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBasePropRepoType
    sha: str


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropBasePropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHeadType(
    TypedDict
):
    """WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHead"""

    ref: str
    repo: WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHeadPropRepoType
    sha: str


class WebhookCheckSuiteRequestedPropCheckSuitePropPullRequestsItemsPropHeadPropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookCheckSuiteRerequestedType(TypedDict):
    """check_suite rerequested event"""

    action: Literal["rerequested"]
    check_suite: WebhookCheckSuiteRerequestedPropCheckSuiteType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCheckSuiteRerequestedPropCheckSuiteType(TypedDict):
    """WebhookCheckSuiteRerequestedPropCheckSuite

    The [check_suite](https://docs.github.com/rest/checks/suites#get-a-check-suite).
    """

    after: Union[str, None]
    app: WebhookCheckSuiteRerequestedPropCheckSuitePropAppType
    before: Union[str, None]
    check_runs_url: str
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ]
    created_at: datetime
    head_branch: Union[str, None]
    head_commit: WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitType
    head_sha: str
    id: int
    latest_check_runs_count: int
    node_id: str
    pull_requests: List[
        WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsType
    ]
    rerequestable: NotRequired[bool]
    runs_rerequestable: NotRequired[bool]
    status: Union[None, Literal["requested", "in_progress", "completed", "queued"]]
    updated_at: datetime
    url: str


class WebhookCheckSuiteRerequestedPropCheckSuitePropAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "merge_queue_entry",
                "workflow_job",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropOwnerType, None]
    permissions: NotRequired[
        WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropPermissionsType(TypedDict):
    """WebhookCheckSuiteRerequestedPropCheckSuitePropAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write", "admin"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitType(TypedDict):
    """SimpleCommit"""

    author: WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitPropAuthorType
    committer: WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitPropCommitterType
    id: str
    message: str
    timestamp: str
    tree_id: str


class WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitPropAuthorType(TypedDict):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: NotRequired[datetime]
    email: Union[str, None]
    name: str
    username: NotRequired[str]


class WebhookCheckSuiteRerequestedPropCheckSuitePropHeadCommitPropCommitterType(
    TypedDict
):
    """Committer

    Metaproperties for Git author/committer information.
    """

    date: NotRequired[datetime]
    email: Union[str, None]
    name: str
    username: NotRequired[str]


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsType(TypedDict):
    """Check Run Pull Request"""

    base: WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBaseType
    head: WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHeadType
    id: int
    number: int
    url: str


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBaseType(
    TypedDict
):
    """WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBase"""

    ref: str
    repo: WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBasePropRepoType
    sha: str


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropBasePropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHeadType(
    TypedDict
):
    """WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHead"""

    ref: str
    repo: WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHeadPropRepoType
    sha: str


class WebhookCheckSuiteRerequestedPropCheckSuitePropPullRequestsItemsPropHeadPropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookCodeScanningAlertAppearedInBranchType(TypedDict):
    """code_scanning_alert appeared_in_branch event"""

    action: Literal["appeared_in_branch"]
    alert: WebhookCodeScanningAlertAppearedInBranchPropAlertType
    commit_oid: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    ref: str
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCodeScanningAlertAppearedInBranchPropAlertType(TypedDict):
    """WebhookCodeScanningAlertAppearedInBranchPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime
    dismissed_at: Union[datetime, None]
    dismissed_by: Union[
        WebhookCodeScanningAlertAppearedInBranchPropAlertPropDismissedByType, None
    ]
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ]
    html_url: str
    most_recent_instance: NotRequired[
        Union[
            WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstanceType,
            None,
        ]
    ]
    number: int
    rule: WebhookCodeScanningAlertAppearedInBranchPropAlertPropRuleType
    state: Literal["open", "dismissed", "fixed"]
    tool: WebhookCodeScanningAlertAppearedInBranchPropAlertPropToolType
    url: str


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropDismissedByType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropLocationType(
    TypedDict
):
    """WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropLocat
    ion
    """

    end_column: NotRequired[int]
    end_line: NotRequired[int]
    path: NotRequired[str]
    start_column: NotRequired[int]
    start_line: NotRequired[int]


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropMessageType(
    TypedDict
):
    """WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropMessa
    ge
    """

    text: NotRequired[str]


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstanceType(
    TypedDict
):
    """Alert Instance"""

    analysis_key: str
    category: NotRequired[str]
    classifications: NotRequired[List[str]]
    commit_sha: NotRequired[str]
    environment: str
    location: NotRequired[
        WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropLocationType
    ]
    message: NotRequired[
        WebhookCodeScanningAlertAppearedInBranchPropAlertPropMostRecentInstancePropMessageType
    ]
    ref: str
    state: Literal["open", "dismissed", "fixed"]


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropRuleType(TypedDict):
    """WebhookCodeScanningAlertAppearedInBranchPropAlertPropRule"""

    description: str
    id: str
    severity: Union[None, Literal["none", "note", "warning", "error"]]


class WebhookCodeScanningAlertAppearedInBranchPropAlertPropToolType(TypedDict):
    """WebhookCodeScanningAlertAppearedInBranchPropAlertPropTool"""

    name: str
    version: Union[str, None]


class WebhookCodeScanningAlertClosedByUserType(TypedDict):
    """code_scanning_alert closed_by_user event"""

    action: Literal["closed_by_user"]
    alert: WebhookCodeScanningAlertClosedByUserPropAlertType
    commit_oid: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    ref: str
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCodeScanningAlertClosedByUserPropAlertType(TypedDict):
    """WebhookCodeScanningAlertClosedByUserPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime
    dismissed_at: datetime
    dismissed_by: Union[
        WebhookCodeScanningAlertClosedByUserPropAlertPropDismissedByType, None
    ]
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ]
    html_url: str
    most_recent_instance: NotRequired[
        Union[
            WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstanceType,
            None,
        ]
    ]
    number: int
    rule: WebhookCodeScanningAlertClosedByUserPropAlertPropRuleType
    state: Literal["dismissed", "fixed"]
    tool: WebhookCodeScanningAlertClosedByUserPropAlertPropToolType
    url: str


class WebhookCodeScanningAlertClosedByUserPropAlertPropDismissedByType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropLocationType(
    TypedDict
):
    """WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropLocation"""

    end_column: NotRequired[int]
    end_line: NotRequired[int]
    path: NotRequired[str]
    start_column: NotRequired[int]
    start_line: NotRequired[int]


class WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropMessageType(
    TypedDict
):
    """WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropMessage"""

    text: NotRequired[str]


class WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstanceType(
    TypedDict
):
    """Alert Instance"""

    analysis_key: str
    category: NotRequired[str]
    classifications: NotRequired[List[str]]
    commit_sha: NotRequired[str]
    environment: str
    location: NotRequired[
        WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropLocationType
    ]
    message: NotRequired[
        WebhookCodeScanningAlertClosedByUserPropAlertPropMostRecentInstancePropMessageType
    ]
    ref: str
    state: Literal["open", "dismissed", "fixed"]


class WebhookCodeScanningAlertClosedByUserPropAlertPropRuleType(TypedDict):
    """WebhookCodeScanningAlertClosedByUserPropAlertPropRule"""

    description: str
    full_description: NotRequired[str]
    help_: NotRequired[Union[str, None]]
    help_uri: NotRequired[Union[str, None]]
    id: str
    name: NotRequired[str]
    severity: Union[None, Literal["none", "note", "warning", "error"]]
    tags: NotRequired[Union[List[str], None]]


class WebhookCodeScanningAlertClosedByUserPropAlertPropToolType(TypedDict):
    """WebhookCodeScanningAlertClosedByUserPropAlertPropTool"""

    guid: NotRequired[Union[str, None]]
    name: str
    version: Union[str, None]


class WebhookCodeScanningAlertCreatedType(TypedDict):
    """code_scanning_alert created event"""

    action: Literal["created"]
    alert: WebhookCodeScanningAlertCreatedPropAlertType
    commit_oid: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    ref: str
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCodeScanningAlertCreatedPropAlertType(TypedDict):
    """WebhookCodeScanningAlertCreatedPropAlert

    The code scanning alert involved in the event.
    """

    created_at: Union[datetime, None]
    dismissed_at: None
    dismissed_by: None
    dismissed_comment: NotRequired[Union[str, None]]
    dismissed_reason: None
    fixed_at: NotRequired[None]
    html_url: str
    instances_url: NotRequired[str]
    most_recent_instance: NotRequired[
        Union[WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstanceType, None]
    ]
    number: int
    rule: WebhookCodeScanningAlertCreatedPropAlertPropRuleType
    state: Literal["open", "dismissed"]
    tool: Union[WebhookCodeScanningAlertCreatedPropAlertPropToolType, None]
    updated_at: NotRequired[Union[str, None]]
    url: str


class WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropLocationType(
    TypedDict
):
    """WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropLocation"""

    end_column: NotRequired[int]
    end_line: NotRequired[int]
    path: NotRequired[str]
    start_column: NotRequired[int]
    start_line: NotRequired[int]


class WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropMessageType(
    TypedDict
):
    """WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropMessage"""

    text: NotRequired[str]


class WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstanceType(TypedDict):
    """Alert Instance"""

    analysis_key: str
    category: NotRequired[str]
    classifications: NotRequired[List[str]]
    commit_sha: NotRequired[str]
    environment: str
    location: NotRequired[
        WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropLocationType
    ]
    message: NotRequired[
        WebhookCodeScanningAlertCreatedPropAlertPropMostRecentInstancePropMessageType
    ]
    ref: str
    state: Literal["open", "dismissed", "fixed"]


class WebhookCodeScanningAlertCreatedPropAlertPropRuleType(TypedDict):
    """WebhookCodeScanningAlertCreatedPropAlertPropRule"""

    description: str
    full_description: NotRequired[str]
    help_: NotRequired[Union[str, None]]
    help_uri: NotRequired[Union[str, None]]
    id: str
    name: NotRequired[str]
    severity: Union[None, Literal["none", "note", "warning", "error"]]
    tags: NotRequired[Union[List[str], None]]


class WebhookCodeScanningAlertCreatedPropAlertPropToolType(TypedDict):
    """WebhookCodeScanningAlertCreatedPropAlertPropTool"""

    guid: NotRequired[Union[str, None]]
    name: str
    version: Union[str, None]


class WebhookCodeScanningAlertFixedType(TypedDict):
    """code_scanning_alert fixed event"""

    action: Literal["fixed"]
    alert: WebhookCodeScanningAlertFixedPropAlertType
    commit_oid: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    ref: str
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCodeScanningAlertFixedPropAlertType(TypedDict):
    """WebhookCodeScanningAlertFixedPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime
    dismissed_at: Union[datetime, None]
    dismissed_by: Union[WebhookCodeScanningAlertFixedPropAlertPropDismissedByType, None]
    dismissed_reason: Union[
        None, Literal["false positive", "won't fix", "used in tests"]
    ]
    html_url: str
    instances_url: NotRequired[str]
    most_recent_instance: NotRequired[
        Union[WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstanceType, None]
    ]
    number: int
    rule: WebhookCodeScanningAlertFixedPropAlertPropRuleType
    state: Literal["fixed"]
    tool: WebhookCodeScanningAlertFixedPropAlertPropToolType
    url: str


class WebhookCodeScanningAlertFixedPropAlertPropDismissedByType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropLocationType(
    TypedDict
):
    """WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropLocation"""

    end_column: NotRequired[int]
    end_line: NotRequired[int]
    path: NotRequired[str]
    start_column: NotRequired[int]
    start_line: NotRequired[int]


class WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropMessageType(
    TypedDict
):
    """WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropMessage"""

    text: NotRequired[str]


class WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstanceType(TypedDict):
    """Alert Instance"""

    analysis_key: str
    category: NotRequired[str]
    classifications: NotRequired[List[str]]
    commit_sha: NotRequired[str]
    environment: str
    location: NotRequired[
        WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropLocationType
    ]
    message: NotRequired[
        WebhookCodeScanningAlertFixedPropAlertPropMostRecentInstancePropMessageType
    ]
    ref: str
    state: Literal["open", "dismissed", "fixed"]


class WebhookCodeScanningAlertFixedPropAlertPropRuleType(TypedDict):
    """WebhookCodeScanningAlertFixedPropAlertPropRule"""

    description: str
    full_description: NotRequired[str]
    help_: NotRequired[Union[str, None]]
    help_uri: NotRequired[Union[str, None]]
    id: str
    name: NotRequired[str]
    severity: Union[None, Literal["none", "note", "warning", "error"]]
    tags: NotRequired[Union[List[str], None]]


class WebhookCodeScanningAlertFixedPropAlertPropToolType(TypedDict):
    """WebhookCodeScanningAlertFixedPropAlertPropTool"""

    guid: NotRequired[Union[str, None]]
    name: str
    version: Union[str, None]


class WebhookCodeScanningAlertReopenedType(TypedDict):
    """code_scanning_alert reopened event"""

    action: Literal["reopened"]
    alert: Union[WebhookCodeScanningAlertReopenedPropAlertType, None]
    commit_oid: Union[str, None]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    ref: Union[str, None]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCodeScanningAlertReopenedPropAlertPropDismissedByType(TypedDict):
    """WebhookCodeScanningAlertReopenedPropAlertPropDismissedBy"""


class WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropLocationType(
    TypedDict
):
    """WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropLocation"""

    end_column: NotRequired[int]
    end_line: NotRequired[int]
    path: NotRequired[str]
    start_column: NotRequired[int]
    start_line: NotRequired[int]


class WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropMessageType(
    TypedDict
):
    """WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropMessage"""

    text: NotRequired[str]


class WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstanceType(TypedDict):
    """Alert Instance"""

    analysis_key: str
    category: NotRequired[str]
    classifications: NotRequired[List[str]]
    commit_sha: NotRequired[str]
    environment: str
    location: NotRequired[
        WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropLocationType
    ]
    message: NotRequired[
        WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstancePropMessageType
    ]
    ref: str
    state: Literal["open", "dismissed", "fixed"]


class WebhookCodeScanningAlertReopenedPropAlertPropRuleType(TypedDict):
    """WebhookCodeScanningAlertReopenedPropAlertPropRule"""

    description: str
    full_description: NotRequired[str]
    help_: NotRequired[Union[str, None]]
    help_uri: NotRequired[Union[str, None]]
    id: str
    name: NotRequired[str]
    severity: Union[None, Literal["none", "note", "warning", "error"]]
    tags: NotRequired[Union[List[str], None]]


class WebhookCodeScanningAlertReopenedPropAlertPropToolType(TypedDict):
    """WebhookCodeScanningAlertReopenedPropAlertPropTool"""

    guid: NotRequired[Union[str, None]]
    name: str
    version: Union[str, None]


class WebhookCodeScanningAlertReopenedPropAlertType(TypedDict):
    """WebhookCodeScanningAlertReopenedPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime
    dismissed_at: Union[str, None]
    dismissed_by: Union[
        WebhookCodeScanningAlertReopenedPropAlertPropDismissedByType, None
    ]
    dismissed_reason: Union[str, None]
    html_url: str
    most_recent_instance: NotRequired[
        Union[WebhookCodeScanningAlertReopenedPropAlertPropMostRecentInstanceType, None]
    ]
    number: int
    rule: WebhookCodeScanningAlertReopenedPropAlertPropRuleType
    state: Literal["open", "dismissed", "fixed"]
    tool: WebhookCodeScanningAlertReopenedPropAlertPropToolType
    url: str


class WebhookCodeScanningAlertReopenedByUserType(TypedDict):
    """code_scanning_alert reopened_by_user event"""

    action: Literal["reopened_by_user"]
    alert: WebhookCodeScanningAlertReopenedByUserPropAlertType
    commit_oid: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    ref: str
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCodeScanningAlertReopenedByUserPropAlertType(TypedDict):
    """WebhookCodeScanningAlertReopenedByUserPropAlert

    The code scanning alert involved in the event.
    """

    created_at: datetime
    dismissed_at: None
    dismissed_by: None
    dismissed_reason: None
    html_url: str
    most_recent_instance: NotRequired[
        Union[
            WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstanceType,
            None,
        ]
    ]
    number: int
    rule: WebhookCodeScanningAlertReopenedByUserPropAlertPropRuleType
    state: Literal["open", "fixed"]
    tool: WebhookCodeScanningAlertReopenedByUserPropAlertPropToolType
    url: str


class WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropLocationType(
    TypedDict
):
    """WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropLocatio
    n
    """

    end_column: NotRequired[int]
    end_line: NotRequired[int]
    path: NotRequired[str]
    start_column: NotRequired[int]
    start_line: NotRequired[int]


class WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropMessageType(
    TypedDict
):
    """WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropMessage"""

    text: NotRequired[str]


class WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstanceType(
    TypedDict
):
    """Alert Instance"""

    analysis_key: str
    category: NotRequired[str]
    classifications: NotRequired[List[str]]
    commit_sha: NotRequired[str]
    environment: str
    location: NotRequired[
        WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropLocationType
    ]
    message: NotRequired[
        WebhookCodeScanningAlertReopenedByUserPropAlertPropMostRecentInstancePropMessageType
    ]
    ref: str
    state: Literal["open", "dismissed", "fixed"]


class WebhookCodeScanningAlertReopenedByUserPropAlertPropRuleType(TypedDict):
    """WebhookCodeScanningAlertReopenedByUserPropAlertPropRule"""

    description: str
    id: str
    severity: Union[None, Literal["none", "note", "warning", "error"]]


class WebhookCodeScanningAlertReopenedByUserPropAlertPropToolType(TypedDict):
    """WebhookCodeScanningAlertReopenedByUserPropAlertPropTool"""

    name: str
    version: Union[str, None]


class WebhookCommitCommentCreatedType(TypedDict):
    """commit_comment created event"""

    action: Literal["created"]
    comment: WebhookCommitCommentCreatedPropCommentType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCommitCommentCreatedPropCommentType(TypedDict):
    """WebhookCommitCommentCreatedPropComment

    The [commit comment](https://docs.github.com/rest/commits/comments#get-a-commit-
    comment) resource.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    commit_id: str
    created_at: str
    html_url: str
    id: int
    line: Union[int, None]
    node_id: str
    path: Union[str, None]
    position: Union[int, None]
    reactions: NotRequired[WebhookCommitCommentCreatedPropCommentPropReactionsType]
    updated_at: str
    url: str
    user: Union[WebhookCommitCommentCreatedPropCommentPropUserType, None]


class WebhookCommitCommentCreatedPropCommentPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookCommitCommentCreatedPropCommentPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookCreateType(TypedDict):
    """create event"""

    description: Union[str, None]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    master_branch: str
    organization: NotRequired[OrganizationSimpleWebhooksType]
    pusher_type: str
    ref: str
    ref_type: Literal["tag", "branch"]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookCustomPropertyCreatedType(TypedDict):
    """custom property created event"""

    action: Literal["created"]
    definition: OrgCustomPropertyType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookCustomPropertyDeletedType(TypedDict):
    """custom property deleted event"""

    action: Literal["deleted"]
    definition: WebhookCustomPropertyDeletedPropDefinitionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookCustomPropertyDeletedPropDefinitionType(TypedDict):
    """WebhookCustomPropertyDeletedPropDefinition"""

    property_name: str


class WebhookCustomPropertyUpdatedType(TypedDict):
    """custom property updated event"""

    action: Literal["updated"]
    definition: OrgCustomPropertyType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookCustomPropertyValuesUpdatedType(TypedDict):
    """Custom property values updated event"""

    action: Literal["updated"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    repository: RepositoryWebhooksType
    organization: OrganizationSimpleWebhooksType
    sender: NotRequired[SimpleUserWebhooksType]
    new_property_values: List[CustomPropertyValueType]
    old_property_values: List[CustomPropertyValueType]


class WebhookDeleteType(TypedDict):
    """delete event"""

    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    pusher_type: str
    ref: str
    ref_type: Literal["tag", "branch"]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDependabotAlertAutoDismissedType(TypedDict):
    """Dependabot alert auto-dismissed event"""

    action: Literal["auto_dismissed"]
    alert: DependabotAlertType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDependabotAlertAutoReopenedType(TypedDict):
    """Dependabot alert auto-reopened event"""

    action: Literal["auto_reopened"]
    alert: DependabotAlertType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDependabotAlertCreatedType(TypedDict):
    """Dependabot alert created event"""

    action: Literal["created"]
    alert: DependabotAlertType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDependabotAlertDismissedType(TypedDict):
    """Dependabot alert dismissed event"""

    action: Literal["dismissed"]
    alert: DependabotAlertType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDependabotAlertFixedType(TypedDict):
    """Dependabot alert fixed event"""

    action: Literal["fixed"]
    alert: DependabotAlertType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDependabotAlertReintroducedType(TypedDict):
    """Dependabot alert reintroduced event"""

    action: Literal["reintroduced"]
    alert: DependabotAlertType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDependabotAlertReopenedType(TypedDict):
    """Dependabot alert reopened event"""

    action: Literal["reopened"]
    alert: DependabotAlertType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDeployKeyCreatedType(TypedDict):
    """deploy_key created event"""

    action: Literal["created"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    key: WebhookDeployKeyCreatedPropKeyType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDeployKeyCreatedPropKeyType(TypedDict):
    """WebhookDeployKeyCreatedPropKey

    The [`deploy key`](https://docs.github.com/rest/deploy-keys/deploy-keys#get-a-
    deploy-key) resource.
    """

    added_by: NotRequired[Union[str, None]]
    created_at: str
    id: int
    key: str
    last_used: NotRequired[Union[str, None]]
    read_only: bool
    title: str
    url: str
    verified: bool


class WebhookDeployKeyDeletedType(TypedDict):
    """deploy_key deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    key: WebhookDeployKeyDeletedPropKeyType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDeployKeyDeletedPropKeyType(TypedDict):
    """WebhookDeployKeyDeletedPropKey

    The [`deploy key`](https://docs.github.com/rest/deploy-keys/deploy-keys#get-a-
    deploy-key) resource.
    """

    added_by: NotRequired[Union[str, None]]
    created_at: str
    id: int
    key: str
    last_used: NotRequired[Union[str, None]]
    read_only: bool
    title: str
    url: str
    verified: bool


class WebhookDeploymentCreatedType(TypedDict):
    """deployment created event"""

    action: Literal["created"]
    deployment: WebhookDeploymentCreatedPropDeploymentType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType
    workflow: Union[WebhookDeploymentCreatedPropWorkflowType, None]
    workflow_run: Union[WebhookDeploymentCreatedPropWorkflowRunType, None]


class WebhookDeploymentCreatedPropDeploymentType(TypedDict):
    """Deployment

    The [deployment](https://docs.github.com/rest/deployments/deployments#list-
    deployments).
    """

    created_at: str
    creator: Union[WebhookDeploymentCreatedPropDeploymentPropCreatorType, None]
    description: Union[str, None]
    environment: str
    id: int
    node_id: str
    original_environment: str
    payload: Union[WebhookDeploymentCreatedPropDeploymentPropPayloadOneof0Type, str]
    performed_via_github_app: NotRequired[
        Union[WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppType, None]
    ]
    production_environment: NotRequired[bool]
    ref: str
    repository_url: str
    sha: str
    statuses_url: str
    task: str
    transient_environment: NotRequired[bool]
    updated_at: str
    url: str


class WebhookDeploymentCreatedPropDeploymentPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentCreatedPropDeploymentPropPayloadOneof0Type(TypedDict):
    """WebhookDeploymentCreatedPropDeploymentPropPayloadOneof0"""


class WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "workflow_job",
                "pull_request_review_thread",
                "merge_queue_entry",
                "secret_scanning_alert_location",
                "merge_group",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookDeploymentCreatedPropDeploymentPropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookDeploymentCreatedPropWorkflowType(TypedDict):
    """Workflow"""

    badge_url: str
    created_at: datetime
    html_url: str
    id: int
    name: str
    node_id: str
    path: str
    state: str
    updated_at: datetime
    url: str


class WebhookDeploymentCreatedPropWorkflowRunPropActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentCreatedPropWorkflowRunPropHeadRepositoryType(TypedDict):
    """WebhookDeploymentCreatedPropWorkflowRunPropHeadRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[None]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentCreatedPropWorkflowRunPropHeadRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentCreatedPropWorkflowRunPropHeadRepositoryPropOwnerType(TypedDict):
    """WebhookDeploymentCreatedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsType(TypedDict):
    """Check Run Pull Request"""

    base: WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBaseType
    head: WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHeadType
    id: int
    number: int
    url: str


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBaseType(
    TypedDict
):
    """WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str
    repo: WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType
    sha: str


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHeadType(
    TypedDict
):
    """WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str
    repo: WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType
    sha: str


class WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentCreatedPropWorkflowRunPropReferencedWorkflowsItemsType(
    TypedDict
):
    """WebhookDeploymentCreatedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str
    ref: NotRequired[str]
    sha: str


class WebhookDeploymentCreatedPropWorkflowRunPropRepositoryType(TypedDict):
    """WebhookDeploymentCreatedPropWorkflowRunPropRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[None]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentCreatedPropWorkflowRunPropRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentCreatedPropWorkflowRunPropRepositoryPropOwnerType(TypedDict):
    """WebhookDeploymentCreatedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentCreatedPropWorkflowRunPropTriggeringActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentCreatedPropWorkflowRunType(TypedDict):
    """Deployment Workflow Run"""

    actor: Union[WebhookDeploymentCreatedPropWorkflowRunPropActorType, None]
    artifacts_url: NotRequired[str]
    cancel_url: NotRequired[str]
    check_suite_id: int
    check_suite_node_id: str
    check_suite_url: NotRequired[str]
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ]
    created_at: datetime
    display_title: str
    event: str
    head_branch: str
    head_commit: NotRequired[None]
    head_repository: NotRequired[
        WebhookDeploymentCreatedPropWorkflowRunPropHeadRepositoryType
    ]
    head_sha: str
    html_url: str
    id: int
    jobs_url: NotRequired[str]
    logs_url: NotRequired[str]
    name: str
    node_id: str
    path: str
    previous_attempt_url: NotRequired[None]
    pull_requests: List[
        WebhookDeploymentCreatedPropWorkflowRunPropPullRequestsItemsType
    ]
    referenced_workflows: NotRequired[
        Union[
            List[
                WebhookDeploymentCreatedPropWorkflowRunPropReferencedWorkflowsItemsType
            ],
            None,
        ]
    ]
    repository: NotRequired[WebhookDeploymentCreatedPropWorkflowRunPropRepositoryType]
    rerun_url: NotRequired[str]
    run_attempt: int
    run_number: int
    run_started_at: datetime
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting", "pending"
    ]
    triggering_actor: NotRequired[
        Union[WebhookDeploymentCreatedPropWorkflowRunPropTriggeringActorType, None]
    ]
    updated_at: datetime
    url: str
    workflow_id: int
    workflow_url: NotRequired[str]


class WebhookDeploymentProtectionRuleRequestedType(TypedDict):
    """deployment protection rule requested event"""

    action: Literal["requested"]
    environment: NotRequired[str]
    event: NotRequired[str]
    deployment_callback_url: NotRequired[str]
    deployment: NotRequired[DeploymentType]
    pull_requests: NotRequired[List[PullRequestType]]
    repository: NotRequired[RepositoryWebhooksType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookDeploymentReviewApprovedType(TypedDict):
    """WebhookDeploymentReviewApproved"""

    action: Literal["approved"]
    approver: NotRequired[WebhookDeploymentReviewApprovedPropApproverType]
    comment: NotRequired[str]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    repository: RepositoryWebhooksType
    reviewers: NotRequired[List[WebhookDeploymentReviewApprovedPropReviewersItemsType]]
    sender: SimpleUserWebhooksType
    since: str
    workflow_job_run: NotRequired[WebhookDeploymentReviewApprovedPropWorkflowJobRunType]
    workflow_job_runs: NotRequired[
        List[WebhookDeploymentReviewApprovedPropWorkflowJobRunsItemsType]
    ]
    workflow_run: Union[WebhookDeploymentReviewApprovedPropWorkflowRunType, None]


class WebhookDeploymentReviewApprovedPropApproverType(TypedDict):
    """WebhookDeploymentReviewApprovedPropApprover"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewApprovedPropReviewersItemsType(TypedDict):
    """WebhookDeploymentReviewApprovedPropReviewersItems"""

    reviewer: NotRequired[
        Union[WebhookDeploymentReviewApprovedPropReviewersItemsPropReviewerType, None]
    ]
    type: NotRequired[Literal["User"]]


class WebhookDeploymentReviewApprovedPropReviewersItemsPropReviewerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewApprovedPropWorkflowJobRunType(TypedDict):
    """WebhookDeploymentReviewApprovedPropWorkflowJobRun"""

    conclusion: None
    created_at: str
    environment: str
    html_url: str
    id: int
    name: None
    status: str
    updated_at: str


class WebhookDeploymentReviewApprovedPropWorkflowJobRunsItemsType(TypedDict):
    """WebhookDeploymentReviewApprovedPropWorkflowJobRunsItems"""

    conclusion: NotRequired[None]
    created_at: NotRequired[str]
    environment: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    name: NotRequired[Union[str, None]]
    status: NotRequired[str]
    updated_at: NotRequired[str]


class WebhookDeploymentReviewApprovedPropWorkflowRunPropActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadCommitType(TypedDict):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadCommit"""


class WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepositoryType(TypedDict):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[Union[str, None]]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepositoryPropOwnerType(
    TypedDict
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsType(
    TypedDict
):
    """Check Run Pull Request"""

    base: WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBaseType
    head: WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHeadType
    id: int
    number: int
    url: str


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBaseType(
    TypedDict
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str
    repo: WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType
    sha: str


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHeadType(
    TypedDict
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str
    repo: WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType
    sha: str


class WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentReviewApprovedPropWorkflowRunPropReferencedWorkflowsItemsType(
    TypedDict
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str
    ref: NotRequired[str]
    sha: str


class WebhookDeploymentReviewApprovedPropWorkflowRunPropRepositoryType(TypedDict):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[Union[str, None]]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewApprovedPropWorkflowRunPropRepositoryPropOwnerType(
    TypedDict
):
    """WebhookDeploymentReviewApprovedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewApprovedPropWorkflowRunPropTriggeringActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewApprovedPropWorkflowRunType(TypedDict):
    """Deployment Workflow Run"""

    actor: Union[WebhookDeploymentReviewApprovedPropWorkflowRunPropActorType, None]
    artifacts_url: NotRequired[str]
    cancel_url: NotRequired[str]
    check_suite_id: int
    check_suite_node_id: str
    check_suite_url: NotRequired[str]
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ]
    created_at: datetime
    display_title: str
    event: str
    head_branch: str
    head_commit: NotRequired[
        Union[WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadCommitType, None]
    ]
    head_repository: NotRequired[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropHeadRepositoryType
    ]
    head_sha: str
    html_url: str
    id: int
    jobs_url: NotRequired[str]
    logs_url: NotRequired[str]
    name: str
    node_id: str
    path: str
    previous_attempt_url: NotRequired[Union[str, None]]
    pull_requests: List[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropPullRequestsItemsType
    ]
    referenced_workflows: NotRequired[
        Union[
            List[
                WebhookDeploymentReviewApprovedPropWorkflowRunPropReferencedWorkflowsItemsType
            ],
            None,
        ]
    ]
    repository: NotRequired[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropRepositoryType
    ]
    rerun_url: NotRequired[str]
    run_attempt: int
    run_number: int
    run_started_at: datetime
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting", "pending"
    ]
    triggering_actor: Union[
        WebhookDeploymentReviewApprovedPropWorkflowRunPropTriggeringActorType, None
    ]
    updated_at: datetime
    url: str
    workflow_id: int
    workflow_url: NotRequired[str]


class WebhookDeploymentReviewRejectedType(TypedDict):
    """WebhookDeploymentReviewRejected"""

    action: Literal["rejected"]
    approver: NotRequired[WebhookDeploymentReviewRejectedPropApproverType]
    comment: NotRequired[str]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    repository: RepositoryWebhooksType
    reviewers: NotRequired[List[WebhookDeploymentReviewRejectedPropReviewersItemsType]]
    sender: SimpleUserWebhooksType
    since: str
    workflow_job_run: NotRequired[WebhookDeploymentReviewRejectedPropWorkflowJobRunType]
    workflow_job_runs: NotRequired[
        List[WebhookDeploymentReviewRejectedPropWorkflowJobRunsItemsType]
    ]
    workflow_run: Union[WebhookDeploymentReviewRejectedPropWorkflowRunType, None]


class WebhookDeploymentReviewRejectedPropApproverType(TypedDict):
    """WebhookDeploymentReviewRejectedPropApprover"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewRejectedPropReviewersItemsType(TypedDict):
    """WebhookDeploymentReviewRejectedPropReviewersItems"""

    reviewer: NotRequired[
        Union[WebhookDeploymentReviewRejectedPropReviewersItemsPropReviewerType, None]
    ]
    type: NotRequired[Literal["User"]]


class WebhookDeploymentReviewRejectedPropReviewersItemsPropReviewerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewRejectedPropWorkflowJobRunType(TypedDict):
    """WebhookDeploymentReviewRejectedPropWorkflowJobRun"""

    conclusion: None
    created_at: str
    environment: str
    html_url: str
    id: int
    name: None
    status: str
    updated_at: str


class WebhookDeploymentReviewRejectedPropWorkflowJobRunsItemsType(TypedDict):
    """WebhookDeploymentReviewRejectedPropWorkflowJobRunsItems"""

    conclusion: NotRequired[Union[str, None]]
    created_at: NotRequired[str]
    environment: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    name: NotRequired[Union[str, None]]
    status: NotRequired[str]
    updated_at: NotRequired[str]


class WebhookDeploymentReviewRejectedPropWorkflowRunPropActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadCommitType(TypedDict):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadCommit"""


class WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepositoryType(TypedDict):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[Union[str, None]]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepositoryPropOwnerType(
    TypedDict
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsType(
    TypedDict
):
    """Check Run Pull Request"""

    base: WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBaseType
    head: WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHeadType
    id: int
    number: int
    url: str


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBaseType(
    TypedDict
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str
    repo: WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType
    sha: str


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHeadType(
    TypedDict
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str
    repo: WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType
    sha: str


class WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentReviewRejectedPropWorkflowRunPropReferencedWorkflowsItemsType(
    TypedDict
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str
    ref: NotRequired[str]
    sha: str


class WebhookDeploymentReviewRejectedPropWorkflowRunPropRepositoryType(TypedDict):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[Union[str, None]]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewRejectedPropWorkflowRunPropRepositoryPropOwnerType(
    TypedDict
):
    """WebhookDeploymentReviewRejectedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewRejectedPropWorkflowRunPropTriggeringActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewRejectedPropWorkflowRunType(TypedDict):
    """Deployment Workflow Run"""

    actor: Union[WebhookDeploymentReviewRejectedPropWorkflowRunPropActorType, None]
    artifacts_url: NotRequired[str]
    cancel_url: NotRequired[str]
    check_suite_id: int
    check_suite_node_id: str
    check_suite_url: NotRequired[str]
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ]
    created_at: datetime
    event: str
    head_branch: str
    head_commit: NotRequired[
        Union[WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadCommitType, None]
    ]
    head_repository: NotRequired[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropHeadRepositoryType
    ]
    head_sha: str
    html_url: str
    id: int
    jobs_url: NotRequired[str]
    logs_url: NotRequired[str]
    name: str
    node_id: str
    path: str
    previous_attempt_url: NotRequired[Union[str, None]]
    pull_requests: List[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropPullRequestsItemsType
    ]
    referenced_workflows: NotRequired[
        Union[
            List[
                WebhookDeploymentReviewRejectedPropWorkflowRunPropReferencedWorkflowsItemsType
            ],
            None,
        ]
    ]
    repository: NotRequired[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropRepositoryType
    ]
    rerun_url: NotRequired[str]
    run_attempt: int
    run_number: int
    run_started_at: datetime
    status: Literal["requested", "in_progress", "completed", "queued", "waiting"]
    triggering_actor: Union[
        WebhookDeploymentReviewRejectedPropWorkflowRunPropTriggeringActorType, None
    ]
    updated_at: datetime
    url: str
    workflow_id: int
    workflow_url: NotRequired[str]
    display_title: str


class WebhookDeploymentReviewRequestedType(TypedDict):
    """WebhookDeploymentReviewRequested"""

    action: Literal["requested"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    environment: str
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    repository: RepositoryWebhooksType
    requestor: Union[WebhookDeploymentReviewRequestedPropRequestorType, None]
    reviewers: List[WebhookDeploymentReviewRequestedPropReviewersItemsType]
    sender: SimpleUserWebhooksType
    since: str
    workflow_job_run: WebhookDeploymentReviewRequestedPropWorkflowJobRunType
    workflow_run: Union[WebhookDeploymentReviewRequestedPropWorkflowRunType, None]


class WebhookDeploymentReviewRequestedPropRequestorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewRequestedPropReviewersItemsType(TypedDict):
    """WebhookDeploymentReviewRequestedPropReviewersItems"""

    reviewer: NotRequired[
        Union[WebhookDeploymentReviewRequestedPropReviewersItemsPropReviewerType, None]
    ]
    type: NotRequired[Literal["User", "Team"]]


class WebhookDeploymentReviewRequestedPropReviewersItemsPropReviewerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewRequestedPropWorkflowJobRunType(TypedDict):
    """WebhookDeploymentReviewRequestedPropWorkflowJobRun"""

    conclusion: None
    created_at: str
    environment: str
    html_url: str
    id: int
    name: Union[str, None]
    status: str
    updated_at: str


class WebhookDeploymentReviewRequestedPropWorkflowRunPropActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadCommitType(TypedDict):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadCommit"""


class WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepositoryType(TypedDict):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[Union[str, None]]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepositoryPropOwnerType(
    TypedDict
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsType(
    TypedDict
):
    """Check Run Pull Request"""

    base: WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBaseType
    head: WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHeadType
    id: int
    number: int
    url: str


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBaseType(
    TypedDict
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str
    repo: WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType
    sha: str


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHeadType(
    TypedDict
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str
    repo: WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType
    sha: str


class WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentReviewRequestedPropWorkflowRunPropReferencedWorkflowsItemsType(
    TypedDict
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str
    ref: NotRequired[str]
    sha: str


class WebhookDeploymentReviewRequestedPropWorkflowRunPropRepositoryType(TypedDict):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[Union[str, None]]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewRequestedPropWorkflowRunPropRepositoryPropOwnerType(
    TypedDict
):
    """WebhookDeploymentReviewRequestedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentReviewRequestedPropWorkflowRunPropTriggeringActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentReviewRequestedPropWorkflowRunType(TypedDict):
    """Deployment Workflow Run"""

    actor: Union[WebhookDeploymentReviewRequestedPropWorkflowRunPropActorType, None]
    artifacts_url: NotRequired[str]
    cancel_url: NotRequired[str]
    check_suite_id: int
    check_suite_node_id: str
    check_suite_url: NotRequired[str]
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
        ],
    ]
    created_at: datetime
    event: str
    head_branch: str
    head_commit: NotRequired[
        Union[WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadCommitType, None]
    ]
    head_repository: NotRequired[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropHeadRepositoryType
    ]
    head_sha: str
    html_url: str
    id: int
    jobs_url: NotRequired[str]
    logs_url: NotRequired[str]
    name: str
    node_id: str
    path: str
    previous_attempt_url: NotRequired[Union[str, None]]
    pull_requests: List[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropPullRequestsItemsType
    ]
    referenced_workflows: NotRequired[
        Union[
            List[
                WebhookDeploymentReviewRequestedPropWorkflowRunPropReferencedWorkflowsItemsType
            ],
            None,
        ]
    ]
    repository: NotRequired[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropRepositoryType
    ]
    rerun_url: NotRequired[str]
    run_attempt: int
    run_number: int
    run_started_at: datetime
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting", "pending"
    ]
    triggering_actor: Union[
        WebhookDeploymentReviewRequestedPropWorkflowRunPropTriggeringActorType, None
    ]
    updated_at: datetime
    url: str
    workflow_id: int
    workflow_url: NotRequired[str]
    display_title: str


class WebhookDeploymentStatusCreatedType(TypedDict):
    """deployment_status created event"""

    action: Literal["created"]
    check_run: NotRequired[Union[WebhookDeploymentStatusCreatedPropCheckRunType, None]]
    deployment: WebhookDeploymentStatusCreatedPropDeploymentType
    deployment_status: WebhookDeploymentStatusCreatedPropDeploymentStatusType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType
    workflow: NotRequired[Union[WebhookDeploymentStatusCreatedPropWorkflowType, None]]
    workflow_run: NotRequired[
        Union[WebhookDeploymentStatusCreatedPropWorkflowRunType, None]
    ]


class WebhookDeploymentStatusCreatedPropCheckRunType(TypedDict):
    """WebhookDeploymentStatusCreatedPropCheckRun"""

    completed_at: Union[datetime, None]
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "skipped",
        ],
    ]
    details_url: str
    external_id: str
    head_sha: str
    html_url: str
    id: int
    name: str
    node_id: str
    started_at: datetime
    status: Literal["queued", "in_progress", "completed", "waiting", "pending"]
    url: str


class WebhookDeploymentStatusCreatedPropDeploymentType(TypedDict):
    """Deployment

    The [deployment](https://docs.github.com/rest/deployments/deployments#list-
    deployments).
    """

    created_at: str
    creator: Union[WebhookDeploymentStatusCreatedPropDeploymentPropCreatorType, None]
    description: Union[str, None]
    environment: str
    id: int
    node_id: str
    original_environment: str
    payload: Union[
        str, WebhookDeploymentStatusCreatedPropDeploymentPropPayloadOneof1Type, None
    ]
    performed_via_github_app: NotRequired[
        Union[
            WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppType,
            None,
        ]
    ]
    production_environment: NotRequired[bool]
    ref: str
    repository_url: str
    sha: str
    statuses_url: str
    task: str
    transient_environment: NotRequired[bool]
    updated_at: str
    url: str


class WebhookDeploymentStatusCreatedPropDeploymentPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropDeploymentPropPayloadOneof1Type(TypedDict):
    """WebhookDeploymentStatusCreatedPropDeploymentPropPayloadOneof1"""


class WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropPermiss
    ions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppType(
    TypedDict
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "merge_queue_entry",
                "workflow_job",
                "pull_request_review_thread",
                "secret_scanning_alert_location",
                "merge_group",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookDeploymentStatusCreatedPropDeploymentPropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookDeploymentStatusCreatedPropDeploymentStatusType(TypedDict):
    """WebhookDeploymentStatusCreatedPropDeploymentStatus

    The [deployment status](https://docs.github.com/rest/deployments/statuses#list-
    deployment-statuses).
    """

    created_at: str
    creator: Union[
        WebhookDeploymentStatusCreatedPropDeploymentStatusPropCreatorType, None
    ]
    deployment_url: str
    description: str
    environment: str
    environment_url: NotRequired[str]
    id: int
    log_url: NotRequired[str]
    node_id: str
    performed_via_github_app: NotRequired[
        Union[
            WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppType,
            None,
        ]
    ]
    repository_url: str
    state: str
    target_url: str
    updated_at: str
    url: str


class WebhookDeploymentStatusCreatedPropDeploymentStatusPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropP
    ermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppType(
    TypedDict
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "merge_queue_entry",
                "workflow_job",
                "merge_group",
                "secret_scanning_alert_location",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookDeploymentStatusCreatedPropDeploymentStatusPropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookDeploymentStatusCreatedPropWorkflowType(TypedDict):
    """Workflow"""

    badge_url: str
    created_at: datetime
    html_url: str
    id: int
    name: str
    node_id: str
    path: str
    state: str
    updated_at: datetime
    url: str


class WebhookDeploymentStatusCreatedPropWorkflowRunPropActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepositoryType(TypedDict):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[None]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepositoryPropOwnerType(
    TypedDict
):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsType(TypedDict):
    """Check Run Pull Request"""

    base: WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBaseType
    head: WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHeadType
    id: int
    number: int
    url: str


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBaseType(
    TypedDict
):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBase"""

    ref: str
    repo: WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType
    sha: str


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropBasePropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHeadType(
    TypedDict
):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHead"""

    ref: str
    repo: WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType
    sha: str


class WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsPropHeadPropRepoType(
    TypedDict
):
    """Repo Ref"""

    id: int
    name: str
    url: str


class WebhookDeploymentStatusCreatedPropWorkflowRunPropReferencedWorkflowsItemsType(
    TypedDict
):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropReferencedWorkflowsItems"""

    path: str
    ref: NotRequired[str]
    sha: str


class WebhookDeploymentStatusCreatedPropWorkflowRunPropRepositoryType(TypedDict):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropRepository"""

    archive_url: NotRequired[str]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[None]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[bool]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    languages_url: NotRequired[str]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    owner: NotRequired[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropRepositoryPropOwnerType
    ]
    private: NotRequired[bool]
    pulls_url: NotRequired[str]
    releases_url: NotRequired[str]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    trees_url: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropWorkflowRunPropRepositoryPropOwnerType(
    TypedDict
):
    """WebhookDeploymentStatusCreatedPropWorkflowRunPropRepositoryPropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropWorkflowRunPropTriggeringActorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDeploymentStatusCreatedPropWorkflowRunType(TypedDict):
    """Deployment Workflow Run"""

    actor: Union[WebhookDeploymentStatusCreatedPropWorkflowRunPropActorType, None]
    artifacts_url: NotRequired[str]
    cancel_url: NotRequired[str]
    check_suite_id: int
    check_suite_node_id: str
    check_suite_url: NotRequired[str]
    conclusion: Union[
        None,
        Literal[
            "success",
            "failure",
            "neutral",
            "cancelled",
            "timed_out",
            "action_required",
            "stale",
            "startup_failure",
        ],
    ]
    created_at: datetime
    display_title: str
    event: str
    head_branch: str
    head_commit: NotRequired[None]
    head_repository: NotRequired[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropHeadRepositoryType
    ]
    head_sha: str
    html_url: str
    id: int
    jobs_url: NotRequired[str]
    logs_url: NotRequired[str]
    name: str
    node_id: str
    path: str
    previous_attempt_url: NotRequired[None]
    pull_requests: List[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropPullRequestsItemsType
    ]
    referenced_workflows: NotRequired[
        Union[
            List[
                WebhookDeploymentStatusCreatedPropWorkflowRunPropReferencedWorkflowsItemsType
            ],
            None,
        ]
    ]
    repository: NotRequired[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropRepositoryType
    ]
    rerun_url: NotRequired[str]
    run_attempt: int
    run_number: int
    run_started_at: datetime
    status: Literal[
        "requested", "in_progress", "completed", "queued", "waiting", "pending"
    ]
    triggering_actor: Union[
        WebhookDeploymentStatusCreatedPropWorkflowRunPropTriggeringActorType, None
    ]
    updated_at: datetime
    url: str
    workflow_id: int
    workflow_url: NotRequired[str]


class WebhookDiscussionAnsweredType(TypedDict):
    """discussion answered event"""

    action: Literal["answered"]
    answer: WebhookDiscussionAnsweredPropAnswerType
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionAnsweredPropAnswerType(TypedDict):
    """WebhookDiscussionAnsweredPropAnswer"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    child_comment_count: int
    created_at: datetime
    discussion_id: int
    html_url: str
    id: int
    node_id: str
    parent_id: None
    reactions: NotRequired[WebhookDiscussionAnsweredPropAnswerPropReactionsType]
    repository_url: str
    updated_at: datetime
    user: Union[WebhookDiscussionAnsweredPropAnswerPropUserType, None]


class WebhookDiscussionAnsweredPropAnswerPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookDiscussionAnsweredPropAnswerPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDiscussionCategoryChangedType(TypedDict):
    """discussion category changed event"""

    action: Literal["category_changed"]
    changes: WebhookDiscussionCategoryChangedPropChangesType
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionCategoryChangedPropChangesType(TypedDict):
    """WebhookDiscussionCategoryChangedPropChanges"""

    category: WebhookDiscussionCategoryChangedPropChangesPropCategoryType


class WebhookDiscussionCategoryChangedPropChangesPropCategoryType(TypedDict):
    """WebhookDiscussionCategoryChangedPropChangesPropCategory"""

    from_: WebhookDiscussionCategoryChangedPropChangesPropCategoryPropFromType


class WebhookDiscussionCategoryChangedPropChangesPropCategoryPropFromType(TypedDict):
    """WebhookDiscussionCategoryChangedPropChangesPropCategoryPropFrom"""

    created_at: datetime
    description: str
    emoji: str
    id: int
    is_answerable: bool
    name: str
    node_id: NotRequired[str]
    repository_id: int
    slug: str
    updated_at: str


class WebhookDiscussionClosedType(TypedDict):
    """discussion closed event"""

    action: Literal["closed"]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionCommentCreatedType(TypedDict):
    """discussion_comment created event"""

    action: Literal["created"]
    comment: WebhookDiscussionCommentCreatedPropCommentType
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionCommentCreatedPropCommentType(TypedDict):
    """WebhookDiscussionCommentCreatedPropComment"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    child_comment_count: int
    created_at: str
    discussion_id: int
    html_url: str
    id: int
    node_id: str
    parent_id: Union[int, None]
    reactions: WebhookDiscussionCommentCreatedPropCommentPropReactionsType
    repository_url: str
    updated_at: str
    user: Union[WebhookDiscussionCommentCreatedPropCommentPropUserType, None]


class WebhookDiscussionCommentCreatedPropCommentPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookDiscussionCommentCreatedPropCommentPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDiscussionCommentDeletedType(TypedDict):
    """discussion_comment deleted event"""

    action: Literal["deleted"]
    comment: WebhookDiscussionCommentDeletedPropCommentType
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionCommentDeletedPropCommentType(TypedDict):
    """WebhookDiscussionCommentDeletedPropComment"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    child_comment_count: int
    created_at: str
    discussion_id: int
    html_url: str
    id: int
    node_id: str
    parent_id: Union[int, None]
    reactions: WebhookDiscussionCommentDeletedPropCommentPropReactionsType
    repository_url: str
    updated_at: str
    user: Union[WebhookDiscussionCommentDeletedPropCommentPropUserType, None]


class WebhookDiscussionCommentDeletedPropCommentPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookDiscussionCommentDeletedPropCommentPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDiscussionCommentEditedType(TypedDict):
    """discussion_comment edited event"""

    action: Literal["edited"]
    changes: WebhookDiscussionCommentEditedPropChangesType
    comment: WebhookDiscussionCommentEditedPropCommentType
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionCommentEditedPropChangesType(TypedDict):
    """WebhookDiscussionCommentEditedPropChanges"""

    body: WebhookDiscussionCommentEditedPropChangesPropBodyType


class WebhookDiscussionCommentEditedPropChangesPropBodyType(TypedDict):
    """WebhookDiscussionCommentEditedPropChangesPropBody"""

    from_: str


class WebhookDiscussionCommentEditedPropCommentType(TypedDict):
    """WebhookDiscussionCommentEditedPropComment"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    child_comment_count: int
    created_at: str
    discussion_id: int
    html_url: str
    id: int
    node_id: str
    parent_id: Union[int, None]
    reactions: WebhookDiscussionCommentEditedPropCommentPropReactionsType
    repository_url: str
    updated_at: str
    user: Union[WebhookDiscussionCommentEditedPropCommentPropUserType, None]


class WebhookDiscussionCommentEditedPropCommentPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookDiscussionCommentEditedPropCommentPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDiscussionCreatedType(TypedDict):
    """discussion created event"""

    action: Literal["created"]
    discussion: WebhookDiscussionCreatedPropDiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionCreatedPropDiscussionType(TypedDict):
    """WebhookDiscussionCreatedPropDiscussion"""

    active_lock_reason: Union[None, None]
    answer_chosen_at: Union[None, None]
    answer_chosen_by: Union[None, None]
    answer_html_url: Union[Union[str, None], None]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    category: WebhookDiscussionCreatedPropDiscussionMergedCategoryType
    comments: int
    created_at: datetime
    html_url: str
    id: int
    locked: Literal[False]
    node_id: str
    number: int
    reactions: NotRequired[WebhookDiscussionCreatedPropDiscussionMergedReactionsType]
    repository_url: str
    state: Literal["open", "converting", "transferring"]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    user: WebhookDiscussionCreatedPropDiscussionMergedUserType


class WebhookDiscussionCreatedPropDiscussionAllof0Type(TypedDict):
    """Discussion"""

    active_lock_reason: Union[str, None]
    answer_chosen_at: Union[str, None]
    answer_chosen_by: Union[
        WebhookDiscussionCreatedPropDiscussionAllof0PropAnswerChosenByType, None
    ]
    answer_html_url: Union[str, None]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    category: WebhookDiscussionCreatedPropDiscussionAllof0PropCategoryType
    comments: int
    created_at: datetime
    html_url: str
    id: int
    locked: bool
    node_id: str
    number: int
    reactions: NotRequired[
        WebhookDiscussionCreatedPropDiscussionAllof0PropReactionsType
    ]
    repository_url: str
    state: Literal["open", "locked", "converting", "transferring"]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    user: Union[WebhookDiscussionCreatedPropDiscussionAllof0PropUserType, None]


class WebhookDiscussionCreatedPropDiscussionAllof0PropAnswerChosenByType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDiscussionCreatedPropDiscussionAllof0PropCategoryType(TypedDict):
    """WebhookDiscussionCreatedPropDiscussionAllof0PropCategory"""

    created_at: datetime
    description: str
    emoji: str
    id: int
    is_answerable: bool
    name: str
    node_id: NotRequired[str]
    repository_id: int
    slug: str
    updated_at: str


class WebhookDiscussionCreatedPropDiscussionAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookDiscussionCreatedPropDiscussionAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDiscussionCreatedPropDiscussionAllof1Type(TypedDict):
    """WebhookDiscussionCreatedPropDiscussionAllof1"""

    active_lock_reason: NotRequired[None]
    answer_chosen_at: None
    answer_chosen_by: None
    answer_html_url: Union[str, None]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    category: NotRequired[WebhookDiscussionCreatedPropDiscussionAllof1PropCategoryType]
    comments: NotRequired[int]
    created_at: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    locked: Literal[False]
    node_id: NotRequired[str]
    number: NotRequired[int]
    reactions: NotRequired[
        WebhookDiscussionCreatedPropDiscussionAllof1PropReactionsType
    ]
    repository_url: NotRequired[str]
    state: Literal["open", "converting", "transferring"]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    user: NotRequired[WebhookDiscussionCreatedPropDiscussionAllof1PropUserType]


class WebhookDiscussionCreatedPropDiscussionAllof1PropCategoryType(TypedDict):
    """WebhookDiscussionCreatedPropDiscussionAllof1PropCategory"""

    created_at: NotRequired[str]
    description: NotRequired[str]
    emoji: NotRequired[str]
    id: NotRequired[int]
    is_answerable: NotRequired[bool]
    name: NotRequired[str]
    node_id: NotRequired[str]
    repository_id: NotRequired[int]
    slug: NotRequired[str]
    updated_at: NotRequired[str]


class WebhookDiscussionCreatedPropDiscussionAllof1PropReactionsType(TypedDict):
    """WebhookDiscussionCreatedPropDiscussionAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookDiscussionCreatedPropDiscussionAllof1PropUserType(TypedDict):
    """WebhookDiscussionCreatedPropDiscussionAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookDiscussionCreatedPropDiscussionMergedCategoryType(TypedDict):
    """WebhookDiscussionCreatedPropDiscussionMergedCategory"""

    created_at: datetime
    description: str
    emoji: str
    id: int
    is_answerable: bool
    name: str
    node_id: NotRequired[str]
    repository_id: int
    slug: str
    updated_at: str


class WebhookDiscussionCreatedPropDiscussionMergedReactionsType(TypedDict):
    """WebhookDiscussionCreatedPropDiscussionMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookDiscussionCreatedPropDiscussionMergedUserType(TypedDict):
    """WebhookDiscussionCreatedPropDiscussionMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDiscussionDeletedType(TypedDict):
    """discussion deleted event"""

    action: Literal["deleted"]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionEditedType(TypedDict):
    """discussion edited event"""

    action: Literal["edited"]
    changes: NotRequired[WebhookDiscussionEditedPropChangesType]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionEditedPropChangesType(TypedDict):
    """WebhookDiscussionEditedPropChanges"""

    body: NotRequired[WebhookDiscussionEditedPropChangesPropBodyType]
    title: NotRequired[WebhookDiscussionEditedPropChangesPropTitleType]


class WebhookDiscussionEditedPropChangesPropBodyType(TypedDict):
    """WebhookDiscussionEditedPropChangesPropBody"""

    from_: str


class WebhookDiscussionEditedPropChangesPropTitleType(TypedDict):
    """WebhookDiscussionEditedPropChangesPropTitle"""

    from_: str


class WebhookDiscussionLabeledType(TypedDict):
    """discussion labeled event"""

    action: Literal["labeled"]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    label: WebhookDiscussionLabeledPropLabelType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionLabeledPropLabelType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookDiscussionLockedType(TypedDict):
    """discussion locked event"""

    action: Literal["locked"]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionPinnedType(TypedDict):
    """discussion pinned event"""

    action: Literal["pinned"]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionReopenedType(TypedDict):
    """discussion reopened event"""

    action: Literal["reopened"]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionTransferredType(TypedDict):
    """discussion transferred event"""

    action: Literal["transferred"]
    changes: WebhookDiscussionTransferredPropChangesType
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionTransferredPropChangesType(TypedDict):
    """WebhookDiscussionTransferredPropChanges"""

    new_discussion: DiscussionType
    new_repository: RepositoryWebhooksType


class WebhookDiscussionUnansweredType(TypedDict):
    """discussion unanswered event"""

    action: Literal["unanswered"]
    discussion: DiscussionType
    old_answer: WebhookDiscussionUnansweredPropOldAnswerType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookDiscussionUnansweredPropOldAnswerType(TypedDict):
    """WebhookDiscussionUnansweredPropOldAnswer"""

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    child_comment_count: int
    created_at: datetime
    discussion_id: int
    html_url: str
    id: int
    node_id: str
    parent_id: None
    reactions: NotRequired[WebhookDiscussionUnansweredPropOldAnswerPropReactionsType]
    repository_url: str
    updated_at: datetime
    user: Union[WebhookDiscussionUnansweredPropOldAnswerPropUserType, None]


class WebhookDiscussionUnansweredPropOldAnswerPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookDiscussionUnansweredPropOldAnswerPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookDiscussionUnlabeledType(TypedDict):
    """discussion unlabeled event"""

    action: Literal["unlabeled"]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    label: WebhookDiscussionUnlabeledPropLabelType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionUnlabeledPropLabelType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookDiscussionUnlockedType(TypedDict):
    """discussion unlocked event"""

    action: Literal["unlocked"]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookDiscussionUnpinnedType(TypedDict):
    """discussion unpinned event"""

    action: Literal["unpinned"]
    discussion: DiscussionType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookForkType(TypedDict):
    """fork event

    A user forks a repository.
    """

    enterprise: NotRequired[EnterpriseWebhooksType]
    forkee: WebhookForkPropForkeeType
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookForkPropForkeeType(TypedDict):
    """WebhookForkPropForkee

    The created [`repository`](https://docs.github.com/rest/repos/repos#get-a-
    repository) resource.
    """

    allow_auto_merge: NotRequired[bool]
    allow_forking: NotRequired[bool]
    allow_merge_commit: NotRequired[bool]
    allow_rebase_merge: NotRequired[bool]
    allow_squash_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    archive_url: str
    archived: bool
    assignees_url: str
    blobs_url: str
    branches_url: str
    clone_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    created_at: datetime
    custom_properties: NotRequired[WebhookForkPropForkeeAllof0PropCustomPropertiesType]
    default_branch: str
    delete_branch_on_merge: NotRequired[bool]
    deployments_url: str
    description: Union[Union[str, None], None]
    disabled: NotRequired[bool]
    downloads_url: str
    events_url: str
    fork: Literal[True]
    forks: int
    forks_count: int
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    has_downloads: bool
    has_issues: bool
    has_pages: bool
    has_projects: bool
    has_wiki: bool
    homepage: Union[Union[str, None], None]
    hooks_url: str
    html_url: str
    id: int
    is_template: NotRequired[bool]
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    language: Union[None, None]
    languages_url: str
    license_: Union[WebhookForkPropForkeeMergedLicenseType, None]
    master_branch: NotRequired[str]
    merges_url: str
    milestones_url: str
    mirror_url: Union[None, None]
    name: str
    node_id: str
    notifications_url: str
    open_issues: int
    open_issues_count: int
    organization: NotRequired[str]
    owner: WebhookForkPropForkeeMergedOwnerType
    permissions: NotRequired[WebhookForkPropForkeeAllof0PropPermissionsType]
    private: bool
    public: NotRequired[bool]
    pulls_url: str
    pushed_at: datetime
    releases_url: str
    role_name: NotRequired[Union[str, None]]
    size: int
    ssh_url: str
    stargazers: NotRequired[int]
    stargazers_count: int
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    svn_url: str
    tags_url: str
    teams_url: str
    topics: List[str]
    trees_url: str
    updated_at: datetime
    url: str
    visibility: Literal["public", "private", "internal"]
    watchers: int
    watchers_count: int
    web_commit_signoff_required: NotRequired[bool]


class WebhookForkPropForkeeAllof0Type(TypedDict):
    """Repository

    A git repository
    """

    allow_auto_merge: NotRequired[bool]
    allow_forking: NotRequired[bool]
    allow_merge_commit: NotRequired[bool]
    allow_rebase_merge: NotRequired[bool]
    allow_squash_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    archive_url: str
    archived: bool
    assignees_url: str
    blobs_url: str
    branches_url: str
    clone_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    created_at: Union[int, datetime]
    custom_properties: NotRequired[WebhookForkPropForkeeAllof0PropCustomPropertiesType]
    default_branch: str
    delete_branch_on_merge: NotRequired[bool]
    deployments_url: str
    description: Union[str, None]
    disabled: NotRequired[bool]
    downloads_url: str
    events_url: str
    fork: bool
    forks: int
    forks_count: int
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    has_downloads: bool
    has_issues: bool
    has_pages: bool
    has_projects: bool
    has_wiki: bool
    homepage: Union[str, None]
    hooks_url: str
    html_url: str
    id: int
    is_template: NotRequired[bool]
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    language: Union[str, None]
    languages_url: str
    license_: Union[WebhookForkPropForkeeAllof0PropLicenseType, None]
    master_branch: NotRequired[str]
    merges_url: str
    milestones_url: str
    mirror_url: Union[str, None]
    name: str
    node_id: str
    notifications_url: str
    open_issues: int
    open_issues_count: int
    organization: NotRequired[str]
    owner: Union[WebhookForkPropForkeeAllof0PropOwnerType, None]
    permissions: NotRequired[WebhookForkPropForkeeAllof0PropPermissionsType]
    private: bool
    public: NotRequired[bool]
    pulls_url: str
    pushed_at: Union[int, datetime, None]
    releases_url: str
    role_name: NotRequired[Union[str, None]]
    size: int
    ssh_url: str
    stargazers: NotRequired[int]
    stargazers_count: int
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    svn_url: str
    tags_url: str
    teams_url: str
    topics: List[str]
    trees_url: str
    updated_at: datetime
    url: str
    visibility: Literal["public", "private", "internal"]
    watchers: int
    watchers_count: int
    web_commit_signoff_required: NotRequired[bool]


class WebhookForkPropForkeeAllof0PropCustomPropertiesType(TypedDict):
    """WebhookForkPropForkeeAllof0PropCustomProperties

    The custom properties that were defined for the repository. The keys are the
    custom property names, and the values are the corresponding custom property
    values.
    """


class WebhookForkPropForkeeAllof0PropLicenseType(TypedDict):
    """License"""

    key: str
    name: str
    node_id: str
    spdx_id: str
    url: Union[str, None]


class WebhookForkPropForkeeAllof0PropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookForkPropForkeeAllof0PropPermissionsType(TypedDict):
    """WebhookForkPropForkeeAllof0PropPermissions"""

    admin: bool
    maintain: NotRequired[bool]
    pull: bool
    push: bool
    triage: NotRequired[bool]


class WebhookForkPropForkeeAllof1Type(TypedDict):
    """WebhookForkPropForkeeAllof1"""

    allow_forking: NotRequired[bool]
    archive_url: NotRequired[str]
    archived: NotRequired[bool]
    assignees_url: NotRequired[str]
    blobs_url: NotRequired[str]
    branches_url: NotRequired[str]
    clone_url: NotRequired[str]
    collaborators_url: NotRequired[str]
    comments_url: NotRequired[str]
    commits_url: NotRequired[str]
    compare_url: NotRequired[str]
    contents_url: NotRequired[str]
    contributors_url: NotRequired[str]
    created_at: NotRequired[str]
    default_branch: NotRequired[str]
    deployments_url: NotRequired[str]
    description: NotRequired[Union[str, None]]
    disabled: NotRequired[bool]
    downloads_url: NotRequired[str]
    events_url: NotRequired[str]
    fork: NotRequired[Literal[True]]
    forks: NotRequired[int]
    forks_count: NotRequired[int]
    forks_url: NotRequired[str]
    full_name: NotRequired[str]
    git_commits_url: NotRequired[str]
    git_refs_url: NotRequired[str]
    git_tags_url: NotRequired[str]
    git_url: NotRequired[str]
    has_downloads: NotRequired[bool]
    has_issues: NotRequired[bool]
    has_pages: NotRequired[bool]
    has_projects: NotRequired[bool]
    has_wiki: NotRequired[bool]
    homepage: NotRequired[Union[str, None]]
    hooks_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    is_template: NotRequired[bool]
    issue_comment_url: NotRequired[str]
    issue_events_url: NotRequired[str]
    issues_url: NotRequired[str]
    keys_url: NotRequired[str]
    labels_url: NotRequired[str]
    language: NotRequired[None]
    languages_url: NotRequired[str]
    license_: NotRequired[Union[WebhookForkPropForkeeAllof1PropLicenseType, None]]
    merges_url: NotRequired[str]
    milestones_url: NotRequired[str]
    mirror_url: NotRequired[None]
    name: NotRequired[str]
    node_id: NotRequired[str]
    notifications_url: NotRequired[str]
    open_issues: NotRequired[int]
    open_issues_count: NotRequired[int]
    owner: NotRequired[WebhookForkPropForkeeAllof1PropOwnerType]
    private: NotRequired[bool]
    public: NotRequired[bool]
    pulls_url: NotRequired[str]
    pushed_at: NotRequired[str]
    releases_url: NotRequired[str]
    size: NotRequired[int]
    ssh_url: NotRequired[str]
    stargazers_count: NotRequired[int]
    stargazers_url: NotRequired[str]
    statuses_url: NotRequired[str]
    subscribers_url: NotRequired[str]
    subscription_url: NotRequired[str]
    svn_url: NotRequired[str]
    tags_url: NotRequired[str]
    teams_url: NotRequired[str]
    topics: NotRequired[List[Union[str, None]]]
    trees_url: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    visibility: NotRequired[str]
    watchers: NotRequired[int]
    watchers_count: NotRequired[int]


class WebhookForkPropForkeeAllof1PropLicenseType(TypedDict):
    """WebhookForkPropForkeeAllof1PropLicense"""


class WebhookForkPropForkeeAllof1PropOwnerType(TypedDict):
    """WebhookForkPropForkeeAllof1PropOwner"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookForkPropForkeeMergedLicenseType(TypedDict):
    """WebhookForkPropForkeeMergedLicense"""

    key: str
    name: str
    node_id: str
    spdx_id: str
    url: Union[str, None]


class WebhookForkPropForkeeMergedOwnerType(TypedDict):
    """WebhookForkPropForkeeMergedOwner"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookGithubAppAuthorizationRevokedType(TypedDict):
    """github_app_authorization revoked event"""

    action: Literal["revoked"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookGollumType(TypedDict):
    """gollum event"""

    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    pages: List[WebhookGollumPropPagesItemsType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookGollumPropPagesItemsType(TypedDict):
    """WebhookGollumPropPagesItems"""

    action: Literal["created", "edited"]
    html_url: str
    page_name: str
    sha: str
    summary: Union[str, None]
    title: str


class WebhookInstallationCreatedType(TypedDict):
    """installation created event"""

    action: Literal["created"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: InstallationType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repositories: NotRequired[List[WebhookInstallationCreatedPropRepositoriesItemsType]]
    repository: NotRequired[RepositoryWebhooksType]
    requester: NotRequired[Union[WebhookInstallationCreatedPropRequesterType, None]]
    sender: SimpleUserWebhooksType


class WebhookInstallationCreatedPropRepositoriesItemsType(TypedDict):
    """WebhookInstallationCreatedPropRepositoriesItems"""

    full_name: str
    id: int
    name: str
    node_id: str
    private: bool


class WebhookInstallationCreatedPropRequesterType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookInstallationDeletedType(TypedDict):
    """installation deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: InstallationType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repositories: NotRequired[List[WebhookInstallationDeletedPropRepositoriesItemsType]]
    repository: NotRequired[RepositoryWebhooksType]
    requester: NotRequired[None]
    sender: SimpleUserWebhooksType


class WebhookInstallationDeletedPropRepositoriesItemsType(TypedDict):
    """WebhookInstallationDeletedPropRepositoriesItems"""

    full_name: str
    id: int
    name: str
    node_id: str
    private: bool


class WebhookInstallationNewPermissionsAcceptedType(TypedDict):
    """installation new_permissions_accepted event"""

    action: Literal["new_permissions_accepted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: InstallationType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repositories: NotRequired[
        List[WebhookInstallationNewPermissionsAcceptedPropRepositoriesItemsType]
    ]
    repository: NotRequired[RepositoryWebhooksType]
    requester: NotRequired[None]
    sender: SimpleUserWebhooksType


class WebhookInstallationNewPermissionsAcceptedPropRepositoriesItemsType(TypedDict):
    """WebhookInstallationNewPermissionsAcceptedPropRepositoriesItems"""

    full_name: str
    id: int
    name: str
    node_id: str
    private: bool


class WebhookInstallationRepositoriesAddedType(TypedDict):
    """installation_repositories added event"""

    action: Literal["added"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: InstallationType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repositories_added: List[
        WebhookInstallationRepositoriesAddedPropRepositoriesAddedItemsType
    ]
    repositories_removed: List[
        WebhookInstallationRepositoriesAddedPropRepositoriesRemovedItemsType
    ]
    repository: NotRequired[RepositoryWebhooksType]
    repository_selection: Literal["all", "selected"]
    requester: Union[WebhookInstallationRepositoriesAddedPropRequesterType, None]
    sender: SimpleUserWebhooksType


class WebhookInstallationRepositoriesAddedPropRepositoriesAddedItemsType(TypedDict):
    """WebhookInstallationRepositoriesAddedPropRepositoriesAddedItems"""

    full_name: str
    id: int
    name: str
    node_id: str
    private: bool


class WebhookInstallationRepositoriesAddedPropRepositoriesRemovedItemsType(TypedDict):
    """WebhookInstallationRepositoriesAddedPropRepositoriesRemovedItems"""

    full_name: NotRequired[str]
    id: NotRequired[int]
    name: NotRequired[str]
    node_id: NotRequired[str]
    private: NotRequired[bool]


class WebhookInstallationRepositoriesAddedPropRequesterType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookInstallationRepositoriesRemovedType(TypedDict):
    """installation_repositories removed event"""

    action: Literal["removed"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: InstallationType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repositories_added: List[
        WebhookInstallationRepositoriesRemovedPropRepositoriesAddedItemsType
    ]
    repositories_removed: List[
        WebhookInstallationRepositoriesRemovedPropRepositoriesRemovedItemsType
    ]
    repository: NotRequired[RepositoryWebhooksType]
    repository_selection: Literal["all", "selected"]
    requester: Union[WebhookInstallationRepositoriesRemovedPropRequesterType, None]
    sender: SimpleUserWebhooksType


class WebhookInstallationRepositoriesRemovedPropRepositoriesAddedItemsType(TypedDict):
    """WebhookInstallationRepositoriesRemovedPropRepositoriesAddedItems"""

    full_name: str
    id: int
    name: str
    node_id: str
    private: bool


class WebhookInstallationRepositoriesRemovedPropRepositoriesRemovedItemsType(TypedDict):
    """WebhookInstallationRepositoriesRemovedPropRepositoriesRemovedItems"""

    full_name: str
    id: int
    name: str
    node_id: str
    private: bool


class WebhookInstallationRepositoriesRemovedPropRequesterType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookInstallationSuspendType(TypedDict):
    """installation suspend event"""

    action: Literal["suspend"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: InstallationType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repositories: NotRequired[List[WebhookInstallationSuspendPropRepositoriesItemsType]]
    repository: NotRequired[RepositoryWebhooksType]
    requester: NotRequired[None]
    sender: SimpleUserWebhooksType


class WebhookInstallationSuspendPropRepositoriesItemsType(TypedDict):
    """WebhookInstallationSuspendPropRepositoriesItems"""

    full_name: str
    id: int
    name: str
    node_id: str
    private: bool


class WebhookInstallationTargetRenamedType(TypedDict):
    """WebhookInstallationTargetRenamed"""

    account: WebhookInstallationTargetRenamedPropAccountType
    action: Literal["renamed"]
    changes: WebhookInstallationTargetRenamedPropChangesType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: SimpleInstallationType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: NotRequired[RepositoryWebhooksType]
    sender: NotRequired[SimpleUserWebhooksType]
    target_type: str


class WebhookInstallationTargetRenamedPropAccountType(TypedDict):
    """WebhookInstallationTargetRenamedPropAccount"""

    archived_at: NotRequired[Union[str, None]]
    avatar_url: str
    created_at: NotRequired[str]
    description: NotRequired[None]
    events_url: NotRequired[str]
    followers: NotRequired[int]
    followers_url: NotRequired[str]
    following: NotRequired[int]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    has_organization_projects: NotRequired[bool]
    has_repository_projects: NotRequired[bool]
    hooks_url: NotRequired[str]
    html_url: str
    id: int
    is_verified: NotRequired[bool]
    issues_url: NotRequired[str]
    login: NotRequired[str]
    members_url: NotRequired[str]
    name: NotRequired[str]
    node_id: str
    organizations_url: NotRequired[str]
    public_gists: NotRequired[int]
    public_members_url: NotRequired[str]
    public_repos: NotRequired[int]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    slug: NotRequired[str]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    website_url: NotRequired[None]


class WebhookInstallationTargetRenamedPropChangesType(TypedDict):
    """WebhookInstallationTargetRenamedPropChanges"""

    login: NotRequired[WebhookInstallationTargetRenamedPropChangesPropLoginType]
    slug: NotRequired[WebhookInstallationTargetRenamedPropChangesPropSlugType]


class WebhookInstallationTargetRenamedPropChangesPropLoginType(TypedDict):
    """WebhookInstallationTargetRenamedPropChangesPropLogin"""

    from_: str


class WebhookInstallationTargetRenamedPropChangesPropSlugType(TypedDict):
    """WebhookInstallationTargetRenamedPropChangesPropSlug"""

    from_: str


class WebhookInstallationUnsuspendType(TypedDict):
    """installation unsuspend event"""

    action: Literal["unsuspend"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: InstallationType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repositories: NotRequired[
        List[WebhookInstallationUnsuspendPropRepositoriesItemsType]
    ]
    repository: NotRequired[RepositoryWebhooksType]
    requester: NotRequired[None]
    sender: SimpleUserWebhooksType


class WebhookInstallationUnsuspendPropRepositoriesItemsType(TypedDict):
    """WebhookInstallationUnsuspendPropRepositoriesItems"""

    full_name: str
    id: int
    name: str
    node_id: str
    private: bool


class WebhookIssueCommentCreatedType(TypedDict):
    """issue_comment created event"""

    action: Literal["created"]
    comment: WebhookIssueCommentCreatedPropCommentType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssueCommentCreatedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssueCommentCreatedPropCommentType(TypedDict):
    """issue comment

    The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment)
    itself.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    created_at: datetime
    html_url: str
    id: int
    issue_url: str
    node_id: str
    performed_via_github_app: Union[None, IntegrationType]
    reactions: WebhookIssueCommentCreatedPropCommentPropReactionsType
    updated_at: datetime
    url: str
    user: Union[WebhookIssueCommentCreatedPropCommentPropUserType, None]


class WebhookIssueCommentCreatedPropCommentPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssueCommentCreatedPropCommentPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueType(TypedDict):
    """WebhookIssueCommentCreatedPropIssue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment
    belongs to.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ]
    assignee: Union[
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropAssigneeType, None], None
    ]
    assignees: List[WebhookIssueCommentCreatedPropIssueMergedAssigneesType]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: List[WebhookIssueCommentCreatedPropIssueAllof0PropLabelsItemsType]
    labels_url: str
    locked: bool
    milestone: Union[WebhookIssueCommentCreatedPropIssueMergedMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssueCommentCreatedPropIssueMergedPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[
        WebhookIssueCommentCreatedPropIssueAllof0PropPullRequestType
    ]
    reactions: WebhookIssueCommentCreatedPropIssueMergedReactionsType
    repository_url: str
    state: Literal["open", "closed"]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: WebhookIssueCommentCreatedPropIssueMergedUserType


class WebhookIssueCommentCreatedPropIssueAllof0Type(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssueCommentCreatedPropIssueAllof0PropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[
        List[WebhookIssueCommentCreatedPropIssueAllof0PropLabelsItemsType]
    ]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssueCommentCreatedPropIssueAllof0PropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppType, None
        ]
    ]
    pull_request: NotRequired[
        WebhookIssueCommentCreatedPropIssueAllof0PropPullRequestType
    ]
    reactions: WebhookIssueCommentCreatedPropIssueAllof0PropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssueCommentCreatedPropIssueAllof0PropUserType, None]


class WebhookIssueCommentCreatedPropIssueAllof0PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueAllof0PropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueAllof0PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssueCommentCreatedPropIssueAllof0PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueAllof0PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermission
    s

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write", "admin"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssueCommentCreatedPropIssueAllof0PropPullRequestType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueAllof0PropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssueCommentCreatedPropIssueAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueAllof1Type(TypedDict):
    """WebhookIssueCommentCreatedPropIssueAllof1"""

    active_lock_reason: NotRequired[Union[str, None]]
    assignee: Union[WebhookIssueCommentCreatedPropIssueAllof1PropAssigneeType, None]
    assignees: NotRequired[
        List[
            Union[WebhookIssueCommentCreatedPropIssueAllof1PropAssigneesItemsType, None]
        ]
    ]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    closed_at: NotRequired[Union[str, None]]
    comments: NotRequired[int]
    comments_url: NotRequired[str]
    created_at: NotRequired[str]
    events_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    labels: List[WebhookIssueCommentCreatedPropIssueAllof1PropLabelsItemsType]
    labels_url: NotRequired[str]
    locked: bool
    milestone: NotRequired[
        Union[WebhookIssueCommentCreatedPropIssueAllof1PropMilestoneType, None]
    ]
    node_id: NotRequired[str]
    number: NotRequired[int]
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssueCommentCreatedPropIssueAllof1PropPerformedViaGithubAppType, None
        ]
    ]
    reactions: NotRequired[WebhookIssueCommentCreatedPropIssueAllof1PropReactionsType]
    repository_url: NotRequired[str]
    state: Literal["open", "closed"]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[WebhookIssueCommentCreatedPropIssueAllof1PropUserType]


class WebhookIssueCommentCreatedPropIssueAllof1PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueAllof1PropAssigneesItemsType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueAllof1PropAssigneesItems"""


class WebhookIssueCommentCreatedPropIssueAllof1PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssueCommentCreatedPropIssueAllof1PropMilestoneType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueAllof1PropMilestone"""


class WebhookIssueCommentCreatedPropIssueAllof1PropPerformedViaGithubAppType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssueCommentCreatedPropIssueAllof1PropReactionsType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueAllof1PropUserType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueMergedAssigneesType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueMergedAssignees"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentCreatedPropIssueMergedMilestoneType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssueCommentCreatedPropIssueMergedPerformedViaGithubAppType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssueCommentCreatedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssueCommentCreatedPropIssueMergedReactionsType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssueCommentCreatedPropIssueMergedUserType(TypedDict):
    """WebhookIssueCommentCreatedPropIssueMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentDeletedType(TypedDict):
    """issue_comment deleted event"""

    action: Literal["deleted"]
    comment: WebhookIssueCommentDeletedPropCommentType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssueCommentDeletedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssueCommentDeletedPropCommentType(TypedDict):
    """issue comment

    The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment)
    itself.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    created_at: datetime
    html_url: str
    id: int
    issue_url: str
    node_id: str
    performed_via_github_app: Union[None, IntegrationType]
    reactions: WebhookIssueCommentDeletedPropCommentPropReactionsType
    updated_at: datetime
    url: str
    user: Union[WebhookIssueCommentDeletedPropCommentPropUserType, None]


class WebhookIssueCommentDeletedPropCommentPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssueCommentDeletedPropCommentPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueType(TypedDict):
    """WebhookIssueCommentDeletedPropIssue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment
    belongs to.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ]
    assignee: Union[
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropAssigneeType, None], None
    ]
    assignees: List[WebhookIssueCommentDeletedPropIssueMergedAssigneesType]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: List[WebhookIssueCommentDeletedPropIssueAllof0PropLabelsItemsType]
    labels_url: str
    locked: bool
    milestone: Union[WebhookIssueCommentDeletedPropIssueMergedMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssueCommentDeletedPropIssueMergedPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[
        WebhookIssueCommentDeletedPropIssueAllof0PropPullRequestType
    ]
    reactions: WebhookIssueCommentDeletedPropIssueMergedReactionsType
    repository_url: str
    state: Literal["open", "closed"]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: WebhookIssueCommentDeletedPropIssueMergedUserType


class WebhookIssueCommentDeletedPropIssueAllof0Type(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssueCommentDeletedPropIssueAllof0PropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[
        List[WebhookIssueCommentDeletedPropIssueAllof0PropLabelsItemsType]
    ]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssueCommentDeletedPropIssueAllof0PropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppType, None
        ]
    ]
    pull_request: NotRequired[
        WebhookIssueCommentDeletedPropIssueAllof0PropPullRequestType
    ]
    reactions: WebhookIssueCommentDeletedPropIssueAllof0PropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssueCommentDeletedPropIssueAllof0PropUserType, None]


class WebhookIssueCommentDeletedPropIssueAllof0PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueAllof0PropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueAllof0PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssueCommentDeletedPropIssueAllof0PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueAllof0PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermission
    s

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssueCommentDeletedPropIssueAllof0PropPullRequestType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueAllof0PropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssueCommentDeletedPropIssueAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueAllof1Type(TypedDict):
    """WebhookIssueCommentDeletedPropIssueAllof1"""

    active_lock_reason: NotRequired[Union[str, None]]
    assignee: Union[WebhookIssueCommentDeletedPropIssueAllof1PropAssigneeType, None]
    assignees: NotRequired[
        List[
            Union[WebhookIssueCommentDeletedPropIssueAllof1PropAssigneesItemsType, None]
        ]
    ]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    closed_at: NotRequired[Union[str, None]]
    comments: NotRequired[int]
    comments_url: NotRequired[str]
    created_at: NotRequired[str]
    events_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    labels: List[WebhookIssueCommentDeletedPropIssueAllof1PropLabelsItemsType]
    labels_url: NotRequired[str]
    locked: bool
    milestone: NotRequired[
        Union[WebhookIssueCommentDeletedPropIssueAllof1PropMilestoneType, None]
    ]
    node_id: NotRequired[str]
    number: NotRequired[int]
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssueCommentDeletedPropIssueAllof1PropPerformedViaGithubAppType, None
        ]
    ]
    reactions: NotRequired[WebhookIssueCommentDeletedPropIssueAllof1PropReactionsType]
    repository_url: NotRequired[str]
    state: Literal["open", "closed"]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[WebhookIssueCommentDeletedPropIssueAllof1PropUserType]


class WebhookIssueCommentDeletedPropIssueAllof1PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueAllof1PropAssigneesItemsType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueAllof1PropAssigneesItems"""


class WebhookIssueCommentDeletedPropIssueAllof1PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssueCommentDeletedPropIssueAllof1PropMilestoneType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueAllof1PropMilestone"""


class WebhookIssueCommentDeletedPropIssueAllof1PropPerformedViaGithubAppType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssueCommentDeletedPropIssueAllof1PropReactionsType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueAllof1PropUserType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueMergedAssigneesType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueMergedAssignees"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentDeletedPropIssueMergedMilestoneType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssueCommentDeletedPropIssueMergedPerformedViaGithubAppType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssueCommentDeletedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssueCommentDeletedPropIssueMergedReactionsType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssueCommentDeletedPropIssueMergedUserType(TypedDict):
    """WebhookIssueCommentDeletedPropIssueMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentEditedType(TypedDict):
    """issue_comment edited event"""

    action: Literal["edited"]
    changes: WebhookIssueCommentEditedPropChangesType
    comment: WebhookIssueCommentEditedPropCommentType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssueCommentEditedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssueCommentEditedPropChangesType(TypedDict):
    """WebhookIssueCommentEditedPropChanges

    The changes to the comment.
    """

    body: NotRequired[WebhookIssueCommentEditedPropChangesPropBodyType]


class WebhookIssueCommentEditedPropChangesPropBodyType(TypedDict):
    """WebhookIssueCommentEditedPropChangesPropBody"""

    from_: str


class WebhookIssueCommentEditedPropCommentType(TypedDict):
    """issue comment

    The [comment](https://docs.github.com/rest/issues/comments#get-an-issue-comment)
    itself.
    """

    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: str
    created_at: datetime
    html_url: str
    id: int
    issue_url: str
    node_id: str
    performed_via_github_app: Union[None, IntegrationType]
    reactions: WebhookIssueCommentEditedPropCommentPropReactionsType
    updated_at: datetime
    url: str
    user: Union[WebhookIssueCommentEditedPropCommentPropUserType, None]


class WebhookIssueCommentEditedPropCommentPropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssueCommentEditedPropCommentPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueType(TypedDict):
    """WebhookIssueCommentEditedPropIssue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) the comment
    belongs to.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ]
    assignee: Union[
        Union[WebhookIssueCommentEditedPropIssueAllof0PropAssigneeType, None], None
    ]
    assignees: List[WebhookIssueCommentEditedPropIssueMergedAssigneesType]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: List[WebhookIssueCommentEditedPropIssueAllof0PropLabelsItemsType]
    labels_url: str
    locked: bool
    milestone: Union[WebhookIssueCommentEditedPropIssueMergedMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssueCommentEditedPropIssueMergedPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[
        WebhookIssueCommentEditedPropIssueAllof0PropPullRequestType
    ]
    reactions: WebhookIssueCommentEditedPropIssueMergedReactionsType
    repository_url: str
    state: Literal["open", "closed"]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: WebhookIssueCommentEditedPropIssueMergedUserType


class WebhookIssueCommentEditedPropIssueAllof0Type(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssueCommentEditedPropIssueAllof0PropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssueCommentEditedPropIssueAllof0PropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[
        List[WebhookIssueCommentEditedPropIssueAllof0PropLabelsItemsType]
    ]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssueCommentEditedPropIssueAllof0PropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppType, None
        ]
    ]
    pull_request: NotRequired[
        WebhookIssueCommentEditedPropIssueAllof0PropPullRequestType
    ]
    reactions: WebhookIssueCommentEditedPropIssueAllof0PropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssueCommentEditedPropIssueAllof0PropUserType, None]


class WebhookIssueCommentEditedPropIssueAllof0PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueAllof0PropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueAllof0PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssueCommentEditedPropIssueAllof0PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueAllof0PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssueCommentEditedPropIssueAllof0PropPullRequestType(TypedDict):
    """WebhookIssueCommentEditedPropIssueAllof0PropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssueCommentEditedPropIssueAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueAllof1Type(TypedDict):
    """WebhookIssueCommentEditedPropIssueAllof1"""

    active_lock_reason: NotRequired[Union[str, None]]
    assignee: Union[WebhookIssueCommentEditedPropIssueAllof1PropAssigneeType, None]
    assignees: NotRequired[
        List[
            Union[WebhookIssueCommentEditedPropIssueAllof1PropAssigneesItemsType, None]
        ]
    ]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    closed_at: NotRequired[Union[str, None]]
    comments: NotRequired[int]
    comments_url: NotRequired[str]
    created_at: NotRequired[str]
    events_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    labels: List[WebhookIssueCommentEditedPropIssueAllof1PropLabelsItemsType]
    labels_url: NotRequired[str]
    locked: bool
    milestone: NotRequired[
        Union[WebhookIssueCommentEditedPropIssueAllof1PropMilestoneType, None]
    ]
    node_id: NotRequired[str]
    number: NotRequired[int]
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssueCommentEditedPropIssueAllof1PropPerformedViaGithubAppType, None
        ]
    ]
    reactions: NotRequired[WebhookIssueCommentEditedPropIssueAllof1PropReactionsType]
    repository_url: NotRequired[str]
    state: Literal["open", "closed"]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[WebhookIssueCommentEditedPropIssueAllof1PropUserType]


class WebhookIssueCommentEditedPropIssueAllof1PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueAllof1PropAssigneesItemsType(TypedDict):
    """WebhookIssueCommentEditedPropIssueAllof1PropAssigneesItems"""


class WebhookIssueCommentEditedPropIssueAllof1PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssueCommentEditedPropIssueAllof1PropMilestoneType(TypedDict):
    """WebhookIssueCommentEditedPropIssueAllof1PropMilestone"""


class WebhookIssueCommentEditedPropIssueAllof1PropPerformedViaGithubAppType(TypedDict):
    """WebhookIssueCommentEditedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssueCommentEditedPropIssueAllof1PropReactionsType(TypedDict):
    """WebhookIssueCommentEditedPropIssueAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueAllof1PropUserType(TypedDict):
    """WebhookIssueCommentEditedPropIssueAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueMergedAssigneesType(TypedDict):
    """WebhookIssueCommentEditedPropIssueMergedAssignees"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssueCommentEditedPropIssueMergedMilestoneType(TypedDict):
    """WebhookIssueCommentEditedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssueCommentEditedPropIssueMergedPerformedViaGithubAppType(TypedDict):
    """WebhookIssueCommentEditedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssueCommentEditedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssueCommentEditedPropIssueMergedReactionsType(TypedDict):
    """WebhookIssueCommentEditedPropIssueMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssueCommentEditedPropIssueMergedUserType(TypedDict):
    """WebhookIssueCommentEditedPropIssueMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesAssignedType(TypedDict):
    """issues assigned event"""

    action: Literal["assigned"]
    assignee: NotRequired[Union[WebhookIssuesAssignedPropAssigneeType, None]]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesAssignedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesAssignedPropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesAssignedPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[Union[WebhookIssuesAssignedPropIssuePropAssigneeType, None]]
    assignees: List[Union[WebhookIssuesAssignedPropIssuePropAssigneesItemsType, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesAssignedPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesAssignedPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesAssignedPropIssuePropPullRequestType]
    reactions: WebhookIssuesAssignedPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesAssignedPropIssuePropUserType, None]


class WebhookIssuesAssignedPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesAssignedPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesAssignedPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesAssignedPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesAssignedPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesAssignedPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesAssignedPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesAssignedPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesAssignedPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesAssignedPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesAssignedPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesClosedType(TypedDict):
    """issues closed event"""

    action: Literal["closed"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesClosedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesClosedPropIssueType(TypedDict):
    """WebhookIssuesClosedPropIssue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ]
    assignee: NotRequired[Union[WebhookIssuesClosedPropIssueMergedAssigneeType, None]]
    assignees: List[WebhookIssuesClosedPropIssueMergedAssigneesType]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesClosedPropIssueMergedLabelsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesClosedPropIssueMergedMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesClosedPropIssueMergedPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesClosedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesClosedPropIssueMergedReactionsType
    repository_url: str
    state: Literal["open", "closed"]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: WebhookIssuesClosedPropIssueMergedUserType


class WebhookIssuesClosedPropIssueAllof0Type(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesClosedPropIssueAllof0PropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssuesClosedPropIssueAllof0PropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesClosedPropIssueAllof0PropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesClosedPropIssueAllof0PropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesClosedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesClosedPropIssueAllof0PropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesClosedPropIssueAllof0PropUserType, None]


class WebhookIssuesClosedPropIssueAllof0PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueAllof0PropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueAllof0PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesClosedPropIssueAllof0PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueAllof0PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesClosedPropIssueAllof0PropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "security_and_analysis",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesClosedPropIssueAllof0PropPullRequestType(TypedDict):
    """WebhookIssuesClosedPropIssueAllof0PropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesClosedPropIssueAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueAllof1Type(TypedDict):
    """WebhookIssuesClosedPropIssueAllof1"""

    active_lock_reason: NotRequired[Union[str, None]]
    assignee: NotRequired[
        Union[WebhookIssuesClosedPropIssueAllof1PropAssigneeType, None]
    ]
    assignees: NotRequired[
        List[Union[WebhookIssuesClosedPropIssueAllof1PropAssigneesItemsType, None]]
    ]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    closed_at: Union[str, None]
    comments: NotRequired[int]
    comments_url: NotRequired[str]
    created_at: NotRequired[str]
    events_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    labels: NotRequired[
        List[Union[WebhookIssuesClosedPropIssueAllof1PropLabelsItemsType, None]]
    ]
    labels_url: NotRequired[str]
    locked: NotRequired[bool]
    milestone: NotRequired[
        Union[WebhookIssuesClosedPropIssueAllof1PropMilestoneType, None]
    ]
    node_id: NotRequired[str]
    number: NotRequired[int]
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesClosedPropIssueAllof1PropPerformedViaGithubAppType, None]
    ]
    reactions: NotRequired[WebhookIssuesClosedPropIssueAllof1PropReactionsType]
    repository_url: NotRequired[str]
    state: Literal["closed", "open"]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[WebhookIssuesClosedPropIssueAllof1PropUserType]


class WebhookIssuesClosedPropIssueAllof1PropAssigneeType(TypedDict):
    """WebhookIssuesClosedPropIssueAllof1PropAssignee"""


class WebhookIssuesClosedPropIssueAllof1PropAssigneesItemsType(TypedDict):
    """WebhookIssuesClosedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesClosedPropIssueAllof1PropLabelsItemsType(TypedDict):
    """WebhookIssuesClosedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesClosedPropIssueAllof1PropMilestoneType(TypedDict):
    """WebhookIssuesClosedPropIssueAllof1PropMilestone"""


class WebhookIssuesClosedPropIssueAllof1PropPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesClosedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesClosedPropIssueAllof1PropReactionsType(TypedDict):
    """WebhookIssuesClosedPropIssueAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueAllof1PropUserType(TypedDict):
    """WebhookIssuesClosedPropIssueAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueMergedAssigneeType(TypedDict):
    """WebhookIssuesClosedPropIssueMergedAssignee"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueMergedAssigneesType(TypedDict):
    """WebhookIssuesClosedPropIssueMergedAssignees"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesClosedPropIssueMergedLabelsType(TypedDict):
    """WebhookIssuesClosedPropIssueMergedLabels"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesClosedPropIssueMergedMilestoneType(TypedDict):
    """WebhookIssuesClosedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesClosedPropIssueAllof0PropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesClosedPropIssueMergedPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesClosedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "security_and_analysis",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesClosedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesClosedPropIssueMergedReactionsType(TypedDict):
    """WebhookIssuesClosedPropIssueMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesClosedPropIssueMergedUserType(TypedDict):
    """WebhookIssuesClosedPropIssueMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesDeletedType(TypedDict):
    """issues deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesDeletedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesDeletedPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[Union[WebhookIssuesDeletedPropIssuePropAssigneeType, None]]
    assignees: List[Union[WebhookIssuesDeletedPropIssuePropAssigneesItemsType, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesDeletedPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesDeletedPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesDeletedPropIssuePropPullRequestType]
    reactions: WebhookIssuesDeletedPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesDeletedPropIssuePropUserType, None]


class WebhookIssuesDeletedPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesDeletedPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesDeletedPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesDeletedPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesDeletedPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesDeletedPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesDeletedPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesDeletedPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesDeletedPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesDeletedPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesDeletedPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedType(TypedDict):
    """issues demilestoned event"""

    action: Literal["demilestoned"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesDemilestonedPropIssueType
    milestone: NotRequired[WebhookIssuesDemilestonedPropMilestoneType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesDemilestonedPropIssueType(TypedDict):
    """WebhookIssuesDemilestonedPropIssue"""

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ]
    assignee: NotRequired[
        Union[WebhookIssuesDemilestonedPropIssueMergedAssigneeType, None]
    ]
    assignees: List[WebhookIssuesDemilestonedPropIssueMergedAssigneesType]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesDemilestonedPropIssueMergedLabelsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[
        Union[WebhookIssuesDemilestonedPropIssueAllof0PropMilestoneType, None], None
    ]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesDemilestonedPropIssueMergedPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[
        WebhookIssuesDemilestonedPropIssueAllof0PropPullRequestType
    ]
    reactions: WebhookIssuesDemilestonedPropIssueMergedReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: WebhookIssuesDemilestonedPropIssueMergedUserType


class WebhookIssuesDemilestonedPropIssueAllof0Type(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesDemilestonedPropIssueAllof0PropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssuesDemilestonedPropIssueAllof0PropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[
        List[WebhookIssuesDemilestonedPropIssueAllof0PropLabelsItemsType]
    ]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesDemilestonedPropIssueAllof0PropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppType, None
        ]
    ]
    pull_request: NotRequired[
        WebhookIssuesDemilestonedPropIssueAllof0PropPullRequestType
    ]
    reactions: WebhookIssuesDemilestonedPropIssueAllof0PropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesDemilestonedPropIssueAllof0PropUserType, None]


class WebhookIssuesDemilestonedPropIssueAllof0PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueAllof0PropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueAllof0PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesDemilestonedPropIssueAllof0PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueAllof0PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesDemilestonedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesDemilestonedPropIssueAllof0PropPullRequestType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueAllof0PropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesDemilestonedPropIssueAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueAllof1Type(TypedDict):
    """WebhookIssuesDemilestonedPropIssueAllof1"""

    active_lock_reason: NotRequired[Union[str, None]]
    assignee: NotRequired[
        Union[WebhookIssuesDemilestonedPropIssueAllof1PropAssigneeType, None]
    ]
    assignees: NotRequired[
        List[
            Union[WebhookIssuesDemilestonedPropIssueAllof1PropAssigneesItemsType, None]
        ]
    ]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    closed_at: NotRequired[Union[str, None]]
    comments: NotRequired[int]
    comments_url: NotRequired[str]
    created_at: NotRequired[str]
    events_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    labels: NotRequired[
        List[Union[WebhookIssuesDemilestonedPropIssueAllof1PropLabelsItemsType, None]]
    ]
    labels_url: NotRequired[str]
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesDemilestonedPropIssueAllof1PropMilestoneType, None]
    node_id: NotRequired[str]
    number: NotRequired[int]
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssuesDemilestonedPropIssueAllof1PropPerformedViaGithubAppType, None
        ]
    ]
    reactions: NotRequired[WebhookIssuesDemilestonedPropIssueAllof1PropReactionsType]
    repository_url: NotRequired[str]
    state: NotRequired[str]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[WebhookIssuesDemilestonedPropIssueAllof1PropUserType]


class WebhookIssuesDemilestonedPropIssueAllof1PropAssigneeType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueAllof1PropAssignee"""


class WebhookIssuesDemilestonedPropIssueAllof1PropAssigneesItemsType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesDemilestonedPropIssueAllof1PropLabelsItemsType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesDemilestonedPropIssueAllof1PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueAllof1PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesDemilestonedPropIssueAllof1PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesDemilestonedPropIssueAllof1PropPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesDemilestonedPropIssueAllof1PropReactionsType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueAllof1PropUserType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueMergedAssigneeType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueMergedAssignee"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueMergedAssigneesType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueMergedAssignees"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropIssueMergedLabelsType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueMergedLabels"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesDemilestonedPropIssueMergedPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssuesDemilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesDemilestonedPropIssueMergedReactionsType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesDemilestonedPropIssueMergedUserType(TypedDict):
    """WebhookIssuesDemilestonedPropIssueMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesDemilestonedPropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesDemilestonedPropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesDemilestonedPropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesEditedType(TypedDict):
    """issues edited event"""

    action: Literal["edited"]
    changes: WebhookIssuesEditedPropChangesType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesEditedPropIssueType
    label: NotRequired[WebhookIssuesEditedPropLabelType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesEditedPropChangesType(TypedDict):
    """WebhookIssuesEditedPropChanges

    The changes to the issue.
    """

    body: NotRequired[WebhookIssuesEditedPropChangesPropBodyType]
    title: NotRequired[WebhookIssuesEditedPropChangesPropTitleType]


class WebhookIssuesEditedPropChangesPropBodyType(TypedDict):
    """WebhookIssuesEditedPropChangesPropBody"""

    from_: str


class WebhookIssuesEditedPropChangesPropTitleType(TypedDict):
    """WebhookIssuesEditedPropChangesPropTitle"""

    from_: str


class WebhookIssuesEditedPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[Union[WebhookIssuesEditedPropIssuePropAssigneeType, None]]
    assignees: List[Union[WebhookIssuesEditedPropIssuePropAssigneesItemsType, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesEditedPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesEditedPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesEditedPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesEditedPropIssuePropPullRequestType]
    reactions: WebhookIssuesEditedPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesEditedPropIssuePropUserType, None]


class WebhookIssuesEditedPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesEditedPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesEditedPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesEditedPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesEditedPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesEditedPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesEditedPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "security_and_analysis",
                "pull_request_review_thread",
                "reminder",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesEditedPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesEditedPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesEditedPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesEditedPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesEditedPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesEditedPropLabelType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesLabeledType(TypedDict):
    """issues labeled event"""

    action: Literal["labeled"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesLabeledPropIssueType
    label: NotRequired[WebhookIssuesLabeledPropLabelType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesLabeledPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[Union[WebhookIssuesLabeledPropIssuePropAssigneeType, None]]
    assignees: List[Union[WebhookIssuesLabeledPropIssuePropAssigneesItemsType, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesLabeledPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesLabeledPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesLabeledPropIssuePropPullRequestType]
    reactions: WebhookIssuesLabeledPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesLabeledPropIssuePropUserType, None]


class WebhookIssuesLabeledPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesLabeledPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesLabeledPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesLabeledPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesLabeledPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesLabeledPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "reminder",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesLabeledPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesLabeledPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesLabeledPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesLabeledPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesLabeledPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesLabeledPropLabelType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesLockedType(TypedDict):
    """issues locked event"""

    action: Literal["locked"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesLockedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesLockedPropIssueType(TypedDict):
    """WebhookIssuesLockedPropIssue"""

    active_lock_reason: Union[
        Union[None, Literal["resolved", "off-topic", "too heated", "spam"]], None
    ]
    assignee: NotRequired[Union[WebhookIssuesLockedPropIssueMergedAssigneeType, None]]
    assignees: List[WebhookIssuesLockedPropIssueMergedAssigneesType]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesLockedPropIssueMergedLabelsType]]
    labels_url: str
    locked: Literal[True]
    milestone: Union[WebhookIssuesLockedPropIssueMergedMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesLockedPropIssueMergedPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesLockedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesLockedPropIssueMergedReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: WebhookIssuesLockedPropIssueMergedUserType


class WebhookIssuesLockedPropIssueAllof0Type(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesLockedPropIssueAllof0PropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssuesLockedPropIssueAllof0PropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesLockedPropIssueAllof0PropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesLockedPropIssueAllof0PropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesLockedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesLockedPropIssueAllof0PropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesLockedPropIssueAllof0PropUserType, None]


class WebhookIssuesLockedPropIssueAllof0PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueAllof0PropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueAllof0PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesLockedPropIssueAllof0PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueAllof0PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesLockedPropIssueAllof0PropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "security_and_analysis",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesLockedPropIssueAllof0PropPullRequestType(TypedDict):
    """WebhookIssuesLockedPropIssueAllof0PropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesLockedPropIssueAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueAllof1Type(TypedDict):
    """WebhookIssuesLockedPropIssueAllof1"""

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesLockedPropIssueAllof1PropAssigneeType, None]
    ]
    assignees: NotRequired[
        List[Union[WebhookIssuesLockedPropIssueAllof1PropAssigneesItemsType, None]]
    ]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    closed_at: NotRequired[Union[str, None]]
    comments: NotRequired[int]
    comments_url: NotRequired[str]
    created_at: NotRequired[str]
    events_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    labels: NotRequired[
        List[Union[WebhookIssuesLockedPropIssueAllof1PropLabelsItemsType, None]]
    ]
    labels_url: NotRequired[str]
    locked: Literal[True]
    milestone: NotRequired[
        Union[WebhookIssuesLockedPropIssueAllof1PropMilestoneType, None]
    ]
    node_id: NotRequired[str]
    number: NotRequired[int]
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesLockedPropIssueAllof1PropPerformedViaGithubAppType, None]
    ]
    reactions: NotRequired[WebhookIssuesLockedPropIssueAllof1PropReactionsType]
    repository_url: NotRequired[str]
    state: NotRequired[str]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[WebhookIssuesLockedPropIssueAllof1PropUserType]


class WebhookIssuesLockedPropIssueAllof1PropAssigneeType(TypedDict):
    """WebhookIssuesLockedPropIssueAllof1PropAssignee"""


class WebhookIssuesLockedPropIssueAllof1PropAssigneesItemsType(TypedDict):
    """WebhookIssuesLockedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesLockedPropIssueAllof1PropLabelsItemsType(TypedDict):
    """WebhookIssuesLockedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesLockedPropIssueAllof1PropMilestoneType(TypedDict):
    """WebhookIssuesLockedPropIssueAllof1PropMilestone"""


class WebhookIssuesLockedPropIssueAllof1PropPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesLockedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesLockedPropIssueAllof1PropReactionsType(TypedDict):
    """WebhookIssuesLockedPropIssueAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueAllof1PropUserType(TypedDict):
    """WebhookIssuesLockedPropIssueAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueMergedAssigneeType(TypedDict):
    """WebhookIssuesLockedPropIssueMergedAssignee"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueMergedAssigneesType(TypedDict):
    """WebhookIssuesLockedPropIssueMergedAssignees"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesLockedPropIssueMergedLabelsType(TypedDict):
    """WebhookIssuesLockedPropIssueMergedLabels"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesLockedPropIssueMergedMilestoneType(TypedDict):
    """WebhookIssuesLockedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesLockedPropIssueAllof0PropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesLockedPropIssueMergedPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesLockedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "security_and_analysis",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesLockedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesLockedPropIssueMergedReactionsType(TypedDict):
    """WebhookIssuesLockedPropIssueMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesLockedPropIssueMergedUserType(TypedDict):
    """WebhookIssuesLockedPropIssueMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedType(TypedDict):
    """issues milestoned event"""

    action: Literal["milestoned"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesMilestonedPropIssueType
    milestone: WebhookIssuesMilestonedPropMilestoneType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesMilestonedPropIssueType(TypedDict):
    """WebhookIssuesMilestonedPropIssue"""

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ]
    assignee: NotRequired[
        Union[WebhookIssuesMilestonedPropIssueMergedAssigneeType, None]
    ]
    assignees: List[WebhookIssuesMilestonedPropIssueMergedAssigneesType]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesMilestonedPropIssueMergedLabelsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: WebhookIssuesMilestonedPropIssueAllof1PropMilestoneType
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesMilestonedPropIssueMergedPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesMilestonedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesMilestonedPropIssueMergedReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: WebhookIssuesMilestonedPropIssueMergedUserType


class WebhookIssuesMilestonedPropIssueAllof0Type(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesMilestonedPropIssueAllof0PropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssuesMilestonedPropIssueAllof0PropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesMilestonedPropIssueAllof0PropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesMilestonedPropIssueAllof0PropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesMilestonedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesMilestonedPropIssueAllof0PropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesMilestonedPropIssueAllof0PropUserType, None]


class WebhookIssuesMilestonedPropIssueAllof0PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueAllof0PropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueAllof0PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesMilestonedPropIssueAllof0PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueAllof0PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesMilestonedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesMilestonedPropIssueAllof0PropPullRequestType(TypedDict):
    """WebhookIssuesMilestonedPropIssueAllof0PropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesMilestonedPropIssueAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueAllof1Type(TypedDict):
    """WebhookIssuesMilestonedPropIssueAllof1"""

    active_lock_reason: NotRequired[Union[str, None]]
    assignee: NotRequired[
        Union[WebhookIssuesMilestonedPropIssueAllof1PropAssigneeType, None]
    ]
    assignees: NotRequired[
        List[Union[WebhookIssuesMilestonedPropIssueAllof1PropAssigneesItemsType, None]]
    ]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    closed_at: NotRequired[Union[str, None]]
    comments: NotRequired[int]
    comments_url: NotRequired[str]
    created_at: NotRequired[str]
    events_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    labels: NotRequired[
        List[Union[WebhookIssuesMilestonedPropIssueAllof1PropLabelsItemsType, None]]
    ]
    labels_url: NotRequired[str]
    locked: NotRequired[bool]
    milestone: WebhookIssuesMilestonedPropIssueAllof1PropMilestoneType
    node_id: NotRequired[str]
    number: NotRequired[int]
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesMilestonedPropIssueAllof1PropPerformedViaGithubAppType, None]
    ]
    reactions: NotRequired[WebhookIssuesMilestonedPropIssueAllof1PropReactionsType]
    repository_url: NotRequired[str]
    state: NotRequired[str]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[WebhookIssuesMilestonedPropIssueAllof1PropUserType]


class WebhookIssuesMilestonedPropIssueAllof1PropAssigneeType(TypedDict):
    """WebhookIssuesMilestonedPropIssueAllof1PropAssignee"""


class WebhookIssuesMilestonedPropIssueAllof1PropAssigneesItemsType(TypedDict):
    """WebhookIssuesMilestonedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesMilestonedPropIssueAllof1PropLabelsItemsType(TypedDict):
    """WebhookIssuesMilestonedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesMilestonedPropIssueAllof1PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesMilestonedPropIssueAllof1PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesMilestonedPropIssueAllof1PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueAllof1PropPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesMilestonedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesMilestonedPropIssueAllof1PropReactionsType(TypedDict):
    """WebhookIssuesMilestonedPropIssueAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueAllof1PropUserType(TypedDict):
    """WebhookIssuesMilestonedPropIssueAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueMergedAssigneeType(TypedDict):
    """WebhookIssuesMilestonedPropIssueMergedAssignee"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueMergedAssigneesType(TypedDict):
    """WebhookIssuesMilestonedPropIssueMergedAssignees"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropIssueMergedLabelsType(TypedDict):
    """WebhookIssuesMilestonedPropIssueMergedLabels"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesMilestonedPropIssueMergedPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesMilestonedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssuesMilestonedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesMilestonedPropIssueMergedReactionsType(TypedDict):
    """WebhookIssuesMilestonedPropIssueMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesMilestonedPropIssueMergedUserType(TypedDict):
    """WebhookIssuesMilestonedPropIssueMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesMilestonedPropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesMilestonedPropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesMilestonedPropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesOpenedType(TypedDict):
    """issues opened event"""

    action: Literal["opened"]
    changes: NotRequired[WebhookIssuesOpenedPropChangesType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesOpenedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesOpenedPropChangesType(TypedDict):
    """WebhookIssuesOpenedPropChanges"""

    old_issue: Union[WebhookIssuesOpenedPropChangesPropOldIssueType, None]
    old_repository: WebhookIssuesOpenedPropChangesPropOldRepositoryType


class WebhookIssuesOpenedPropChangesPropOldIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropChangesPropOldIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropChangesPropOldIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesOpenedPropChangesPropOldIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropChangesPropOldIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesOpenedPropChangesPropOldIssuePropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropPermissio
    ns

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppType(
    TypedDict
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesOpenedPropChangesPropOldIssuePropPullRequestType(TypedDict):
    """WebhookIssuesOpenedPropChangesPropOldIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesOpenedPropChangesPropOldIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesOpenedPropChangesPropOldIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropChangesPropOldIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesOpenedPropChangesPropOldIssuePropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssuesOpenedPropChangesPropOldIssuePropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[
        List[WebhookIssuesOpenedPropChangesPropOldIssuePropLabelsItemsType]
    ]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesOpenedPropChangesPropOldIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssuesOpenedPropChangesPropOldIssuePropPerformedViaGithubAppType,
            None,
        ]
    ]
    pull_request: NotRequired[
        WebhookIssuesOpenedPropChangesPropOldIssuePropPullRequestType
    ]
    reactions: WebhookIssuesOpenedPropChangesPropOldIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesOpenedPropChangesPropOldIssuePropUserType, None]


class WebhookIssuesOpenedPropChangesPropOldRepositoryType(TypedDict):
    """Repository

    A git repository
    """

    allow_auto_merge: NotRequired[bool]
    allow_forking: NotRequired[bool]
    allow_merge_commit: NotRequired[bool]
    allow_rebase_merge: NotRequired[bool]
    allow_squash_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    archive_url: str
    archived: bool
    assignees_url: str
    blobs_url: str
    branches_url: str
    clone_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    created_at: Union[int, datetime]
    custom_properties: NotRequired[
        WebhookIssuesOpenedPropChangesPropOldRepositoryPropCustomPropertiesType
    ]
    default_branch: str
    delete_branch_on_merge: NotRequired[bool]
    deployments_url: str
    description: Union[str, None]
    disabled: NotRequired[bool]
    downloads_url: str
    events_url: str
    fork: bool
    forks: int
    forks_count: int
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    has_discussions: NotRequired[bool]
    has_downloads: bool
    has_issues: bool
    has_pages: bool
    has_projects: bool
    has_wiki: bool
    homepage: Union[str, None]
    hooks_url: str
    html_url: str
    id: int
    is_template: NotRequired[bool]
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    language: Union[str, None]
    languages_url: str
    license_: Union[
        WebhookIssuesOpenedPropChangesPropOldRepositoryPropLicenseType, None
    ]
    master_branch: NotRequired[str]
    merges_url: str
    milestones_url: str
    mirror_url: Union[str, None]
    name: str
    node_id: str
    notifications_url: str
    open_issues: int
    open_issues_count: int
    organization: NotRequired[str]
    owner: Union[WebhookIssuesOpenedPropChangesPropOldRepositoryPropOwnerType, None]
    permissions: NotRequired[
        WebhookIssuesOpenedPropChangesPropOldRepositoryPropPermissionsType
    ]
    private: bool
    public: NotRequired[bool]
    pulls_url: str
    pushed_at: Union[int, datetime, None]
    releases_url: str
    role_name: NotRequired[Union[str, None]]
    size: int
    ssh_url: str
    stargazers: NotRequired[int]
    stargazers_count: int
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    svn_url: str
    tags_url: str
    teams_url: str
    topics: List[str]
    trees_url: str
    updated_at: datetime
    url: str
    visibility: Literal["public", "private", "internal"]
    watchers: int
    watchers_count: int
    web_commit_signoff_required: NotRequired[bool]


class WebhookIssuesOpenedPropChangesPropOldRepositoryPropCustomPropertiesType(
    TypedDict
):
    """WebhookIssuesOpenedPropChangesPropOldRepositoryPropCustomProperties

    The custom properties that were defined for the repository. The keys are the
    custom property names, and the values are the corresponding custom property
    values.
    """


class WebhookIssuesOpenedPropChangesPropOldRepositoryPropLicenseType(TypedDict):
    """License"""

    key: str
    name: str
    node_id: str
    spdx_id: str
    url: Union[str, None]


class WebhookIssuesOpenedPropChangesPropOldRepositoryPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropChangesPropOldRepositoryPropPermissionsType(TypedDict):
    """WebhookIssuesOpenedPropChangesPropOldRepositoryPropPermissions"""

    admin: bool
    maintain: NotRequired[bool]
    pull: bool
    push: bool
    triage: NotRequired[bool]


class WebhookIssuesOpenedPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[Union[WebhookIssuesOpenedPropIssuePropAssigneeType, None]]
    assignees: List[Union[WebhookIssuesOpenedPropIssuePropAssigneesItemsType, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesOpenedPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesOpenedPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesOpenedPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesOpenedPropIssuePropPullRequestType]
    reactions: WebhookIssuesOpenedPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesOpenedPropIssuePropUserType, None]


class WebhookIssuesOpenedPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesOpenedPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesOpenedPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesOpenedPropIssuePropPerformedViaGithubAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesOpenedPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesOpenedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesOpenedPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "security_and_analysis",
                "pull_request_review_thread",
                "reminder",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesOpenedPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesOpenedPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesOpenedPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesOpenedPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesOpenedPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesOpenedPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesPinnedType(TypedDict):
    """issues pinned event"""

    action: Literal["pinned"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesPinnedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesPinnedPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[Union[WebhookIssuesPinnedPropIssuePropAssigneeType, None]]
    assignees: List[Union[WebhookIssuesPinnedPropIssuePropAssigneesItemsType, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesPinnedPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesPinnedPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesPinnedPropIssuePropPullRequestType]
    reactions: WebhookIssuesPinnedPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesPinnedPropIssuePropUserType, None]


class WebhookIssuesPinnedPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesPinnedPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesPinnedPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesPinnedPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesPinnedPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesPinnedPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesPinnedPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesPinnedPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesPinnedPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesPinnedPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesPinnedPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesReopenedType(TypedDict):
    """issues reopened event"""

    action: Literal["reopened"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesReopenedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesReopenedPropIssueType(TypedDict):
    """WebhookIssuesReopenedPropIssue"""

    active_lock_reason: Union[
        Literal["resolved", "off-topic", "too heated", "spam"], None
    ]
    assignee: NotRequired[Union[WebhookIssuesReopenedPropIssueMergedAssigneeType, None]]
    assignees: List[WebhookIssuesReopenedPropIssueMergedAssigneesType]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesReopenedPropIssueMergedLabelsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesReopenedPropIssueMergedMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesReopenedPropIssueMergedPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesReopenedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesReopenedPropIssueMergedReactionsType
    repository_url: str
    state: Literal["open", "closed"]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: WebhookIssuesReopenedPropIssueMergedUserType


class WebhookIssuesReopenedPropIssueAllof0Type(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesReopenedPropIssueAllof0PropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssuesReopenedPropIssueAllof0PropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesReopenedPropIssueAllof0PropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesReopenedPropIssueAllof0PropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesReopenedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesReopenedPropIssueAllof0PropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesReopenedPropIssueAllof0PropUserType, None]


class WebhookIssuesReopenedPropIssueAllof0PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueAllof0PropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueAllof0PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesReopenedPropIssueAllof0PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueAllof0PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesReopenedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write", "admin"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "reminder",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesReopenedPropIssueAllof0PropPullRequestType(TypedDict):
    """WebhookIssuesReopenedPropIssueAllof0PropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesReopenedPropIssueAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueAllof1Type(TypedDict):
    """WebhookIssuesReopenedPropIssueAllof1"""

    active_lock_reason: NotRequired[Union[str, None]]
    assignee: NotRequired[
        Union[WebhookIssuesReopenedPropIssueAllof1PropAssigneeType, None]
    ]
    assignees: NotRequired[
        List[Union[WebhookIssuesReopenedPropIssueAllof1PropAssigneesItemsType, None]]
    ]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    closed_at: NotRequired[Union[str, None]]
    comments: NotRequired[int]
    comments_url: NotRequired[str]
    created_at: NotRequired[str]
    events_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    labels: NotRequired[
        List[Union[WebhookIssuesReopenedPropIssueAllof1PropLabelsItemsType, None]]
    ]
    labels_url: NotRequired[str]
    locked: NotRequired[bool]
    milestone: NotRequired[
        Union[WebhookIssuesReopenedPropIssueAllof1PropMilestoneType, None]
    ]
    node_id: NotRequired[str]
    number: NotRequired[int]
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesReopenedPropIssueAllof1PropPerformedViaGithubAppType, None]
    ]
    reactions: NotRequired[WebhookIssuesReopenedPropIssueAllof1PropReactionsType]
    repository_url: NotRequired[str]
    state: Literal["open", "closed"]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[WebhookIssuesReopenedPropIssueAllof1PropUserType]


class WebhookIssuesReopenedPropIssueAllof1PropAssigneeType(TypedDict):
    """WebhookIssuesReopenedPropIssueAllof1PropAssignee"""


class WebhookIssuesReopenedPropIssueAllof1PropAssigneesItemsType(TypedDict):
    """WebhookIssuesReopenedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesReopenedPropIssueAllof1PropLabelsItemsType(TypedDict):
    """WebhookIssuesReopenedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesReopenedPropIssueAllof1PropMilestoneType(TypedDict):
    """WebhookIssuesReopenedPropIssueAllof1PropMilestone"""


class WebhookIssuesReopenedPropIssueAllof1PropPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesReopenedPropIssueAllof1PropPerformedViaGithubApp"""


class WebhookIssuesReopenedPropIssueAllof1PropReactionsType(TypedDict):
    """WebhookIssuesReopenedPropIssueAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueAllof1PropUserType(TypedDict):
    """WebhookIssuesReopenedPropIssueAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueMergedAssigneeType(TypedDict):
    """WebhookIssuesReopenedPropIssueMergedAssignee"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueMergedAssigneesType(TypedDict):
    """WebhookIssuesReopenedPropIssueMergedAssignees"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesReopenedPropIssueMergedLabelsType(TypedDict):
    """WebhookIssuesReopenedPropIssueMergedLabels"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesReopenedPropIssueMergedMilestoneType(TypedDict):
    """WebhookIssuesReopenedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesReopenedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesReopenedPropIssueMergedPerformedViaGithubAppType(TypedDict):
    """WebhookIssuesReopenedPropIssueMergedPerformedViaGithubApp"""

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "pull_request_review_thread",
                "reminder",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesReopenedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesReopenedPropIssueMergedReactionsType(TypedDict):
    """WebhookIssuesReopenedPropIssueMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesReopenedPropIssueMergedUserType(TypedDict):
    """WebhookIssuesReopenedPropIssueMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesTransferredType(TypedDict):
    """issues transferred event"""

    action: Literal["transferred"]
    changes: WebhookIssuesTransferredPropChangesType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesTransferredPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesTransferredPropChangesType(TypedDict):
    """WebhookIssuesTransferredPropChanges"""

    new_issue: WebhookIssuesTransferredPropChangesPropNewIssueType
    new_repository: WebhookIssuesTransferredPropChangesPropNewRepositoryType


class WebhookIssuesTransferredPropChangesPropNewIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesTransferredPropChangesPropNewIssuePropAssigneeType, None]
    ]
    assignees: List[
        Union[
            WebhookIssuesTransferredPropChangesPropNewIssuePropAssigneesItemsType, None
        ]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[
        List[WebhookIssuesTransferredPropChangesPropNewIssuePropLabelsItemsType]
    ]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[
        WebhookIssuesTransferredPropChangesPropNewIssuePropMilestoneType, None
    ]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[
            WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppType,
            None,
        ]
    ]
    pull_request: NotRequired[
        WebhookIssuesTransferredPropChangesPropNewIssuePropPullRequestType
    ]
    reactions: WebhookIssuesTransferredPropChangesPropNewIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesTransferredPropChangesPropNewIssuePropUserType, None]


class WebhookIssuesTransferredPropChangesPropNewIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropChangesPropNewIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropChangesPropNewIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesTransferredPropChangesPropNewIssuePropMilestonePropCreatorType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropChangesPropNewIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesTransferredPropChangesPropNewIssuePropMilestonePropCreatorType,
        None,
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropPerm
    issions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppType(
    TypedDict
):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropOwnerType,
        None,
    ]
    permissions: NotRequired[
        WebhookIssuesTransferredPropChangesPropNewIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesTransferredPropChangesPropNewIssuePropPullRequestType(TypedDict):
    """WebhookIssuesTransferredPropChangesPropNewIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesTransferredPropChangesPropNewIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesTransferredPropChangesPropNewIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropChangesPropNewRepositoryType(TypedDict):
    """Repository

    A git repository
    """

    allow_auto_merge: NotRequired[bool]
    allow_forking: NotRequired[bool]
    allow_merge_commit: NotRequired[bool]
    allow_rebase_merge: NotRequired[bool]
    allow_squash_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    archive_url: str
    archived: bool
    assignees_url: str
    blobs_url: str
    branches_url: str
    clone_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    created_at: Union[int, datetime]
    custom_properties: NotRequired[
        WebhookIssuesTransferredPropChangesPropNewRepositoryPropCustomPropertiesType
    ]
    default_branch: str
    delete_branch_on_merge: NotRequired[bool]
    deployments_url: str
    description: Union[str, None]
    disabled: NotRequired[bool]
    downloads_url: str
    events_url: str
    fork: bool
    forks: int
    forks_count: int
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    has_downloads: bool
    has_issues: bool
    has_pages: bool
    has_projects: bool
    has_wiki: bool
    has_discussions: bool
    homepage: Union[str, None]
    hooks_url: str
    html_url: str
    id: int
    is_template: NotRequired[bool]
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    language: Union[str, None]
    languages_url: str
    license_: Union[
        WebhookIssuesTransferredPropChangesPropNewRepositoryPropLicenseType, None
    ]
    master_branch: NotRequired[str]
    merges_url: str
    milestones_url: str
    mirror_url: Union[str, None]
    name: str
    node_id: str
    notifications_url: str
    open_issues: int
    open_issues_count: int
    organization: NotRequired[str]
    owner: Union[
        WebhookIssuesTransferredPropChangesPropNewRepositoryPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesTransferredPropChangesPropNewRepositoryPropPermissionsType
    ]
    private: bool
    public: NotRequired[bool]
    pulls_url: str
    pushed_at: Union[int, datetime, None]
    releases_url: str
    role_name: NotRequired[Union[str, None]]
    size: int
    ssh_url: str
    stargazers: NotRequired[int]
    stargazers_count: int
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    svn_url: str
    tags_url: str
    teams_url: str
    topics: List[str]
    trees_url: str
    updated_at: datetime
    url: str
    visibility: Literal["public", "private", "internal"]
    watchers: int
    watchers_count: int
    web_commit_signoff_required: NotRequired[bool]


class WebhookIssuesTransferredPropChangesPropNewRepositoryPropCustomPropertiesType(
    TypedDict
):
    """WebhookIssuesTransferredPropChangesPropNewRepositoryPropCustomProperties

    The custom properties that were defined for the repository. The keys are the
    custom property names, and the values are the corresponding custom property
    values.
    """


class WebhookIssuesTransferredPropChangesPropNewRepositoryPropLicenseType(TypedDict):
    """License"""

    key: str
    name: str
    node_id: str
    spdx_id: str
    url: Union[str, None]


class WebhookIssuesTransferredPropChangesPropNewRepositoryPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropChangesPropNewRepositoryPropPermissionsType(
    TypedDict
):
    """WebhookIssuesTransferredPropChangesPropNewRepositoryPropPermissions"""

    admin: bool
    maintain: NotRequired[bool]
    pull: bool
    push: bool
    triage: NotRequired[bool]


class WebhookIssuesTransferredPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesTransferredPropIssuePropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssuesTransferredPropIssuePropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesTransferredPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesTransferredPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesTransferredPropIssuePropPullRequestType]
    reactions: WebhookIssuesTransferredPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesTransferredPropIssuePropUserType, None]


class WebhookIssuesTransferredPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesTransferredPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesTransferredPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesTransferredPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesTransferredPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesTransferredPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesTransferredPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesTransferredPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnassignedType(TypedDict):
    """issues unassigned event"""

    action: Literal["unassigned"]
    assignee: NotRequired[Union[WebhookIssuesUnassignedPropAssigneeType, None]]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesUnassignedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesUnassignedPropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesUnassignedPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[Union[WebhookIssuesUnassignedPropIssuePropAssigneeType, None]]
    assignees: List[Union[WebhookIssuesUnassignedPropIssuePropAssigneesItemsType, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesUnassignedPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesUnassignedPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesUnassignedPropIssuePropPullRequestType]
    reactions: WebhookIssuesUnassignedPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesUnassignedPropIssuePropUserType, None]


class WebhookIssuesUnassignedPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesUnassignedPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesUnassignedPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesUnassignedPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesUnassignedPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesUnassignedPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesUnassignedPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesUnassignedPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesUnassignedPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesUnassignedPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesUnassignedPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesUnlabeledType(TypedDict):
    """issues unlabeled event"""

    action: Literal["unlabeled"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesUnlabeledPropIssueType
    label: NotRequired[WebhookIssuesUnlabeledPropLabelType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesUnlabeledPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[Union[WebhookIssuesUnlabeledPropIssuePropAssigneeType, None]]
    assignees: List[Union[WebhookIssuesUnlabeledPropIssuePropAssigneesItemsType, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesUnlabeledPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesUnlabeledPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesUnlabeledPropIssuePropPullRequestType]
    reactions: WebhookIssuesUnlabeledPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesUnlabeledPropIssuePropUserType, None]


class WebhookIssuesUnlabeledPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesUnlabeledPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesUnlabeledPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesUnlabeledPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesUnlabeledPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesUnlabeledPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write", "admin"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
                "reminder",
                "pull_request_review_thread",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesUnlabeledPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesUnlabeledPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesUnlabeledPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesUnlabeledPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesUnlabeledPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookIssuesUnlabeledPropLabelType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesUnlockedType(TypedDict):
    """issues unlocked event"""

    action: Literal["unlocked"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesUnlockedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesUnlockedPropIssueType(TypedDict):
    """WebhookIssuesUnlockedPropIssue"""

    active_lock_reason: Union[None, None]
    assignee: NotRequired[Union[WebhookIssuesUnlockedPropIssueMergedAssigneeType, None]]
    assignees: List[WebhookIssuesUnlockedPropIssueMergedAssigneesType]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[Union[str, None], None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesUnlockedPropIssueMergedLabelsType]]
    labels_url: str
    locked: Literal[False]
    milestone: Union[WebhookIssuesUnlockedPropIssueMergedMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[Union[None, None]]
    pull_request: NotRequired[WebhookIssuesUnlockedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesUnlockedPropIssueMergedReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: WebhookIssuesUnlockedPropIssueMergedUserType


class WebhookIssuesUnlockedPropIssueAllof0Type(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[
        Union[WebhookIssuesUnlockedPropIssueAllof0PropAssigneeType, None]
    ]
    assignees: List[
        Union[WebhookIssuesUnlockedPropIssueAllof0PropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesUnlockedPropIssueAllof0PropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesUnlockedPropIssueAllof0PropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesUnlockedPropIssueAllof0PropPullRequestType]
    reactions: WebhookIssuesUnlockedPropIssueAllof0PropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesUnlockedPropIssueAllof0PropUserType, None]


class WebhookIssuesUnlockedPropIssueAllof0PropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueAllof0PropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueAllof0PropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesUnlockedPropIssueAllof0PropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueAllof0PropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesUnlockedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesUnlockedPropIssueAllof0PropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesUnlockedPropIssueAllof0PropPullRequestType(TypedDict):
    """WebhookIssuesUnlockedPropIssueAllof0PropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueAllof0PropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesUnlockedPropIssueAllof0PropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueAllof1Type(TypedDict):
    """WebhookIssuesUnlockedPropIssueAllof1"""

    active_lock_reason: None
    assignee: NotRequired[
        Union[WebhookIssuesUnlockedPropIssueAllof1PropAssigneeType, None]
    ]
    assignees: NotRequired[
        List[Union[WebhookIssuesUnlockedPropIssueAllof1PropAssigneesItemsType, None]]
    ]
    author_association: NotRequired[str]
    body: NotRequired[Union[str, None]]
    closed_at: NotRequired[Union[str, None]]
    comments: NotRequired[int]
    comments_url: NotRequired[str]
    created_at: NotRequired[str]
    events_url: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    labels: NotRequired[
        List[Union[WebhookIssuesUnlockedPropIssueAllof1PropLabelsItemsType, None]]
    ]
    labels_url: NotRequired[str]
    locked: Literal[False]
    milestone: NotRequired[
        Union[WebhookIssuesUnlockedPropIssueAllof1PropMilestoneType, None]
    ]
    node_id: NotRequired[str]
    number: NotRequired[int]
    performed_via_github_app: NotRequired[None]
    reactions: NotRequired[WebhookIssuesUnlockedPropIssueAllof1PropReactionsType]
    repository_url: NotRequired[str]
    state: NotRequired[str]
    timeline_url: NotRequired[str]
    title: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]
    user: NotRequired[WebhookIssuesUnlockedPropIssueAllof1PropUserType]


class WebhookIssuesUnlockedPropIssueAllof1PropAssigneeType(TypedDict):
    """WebhookIssuesUnlockedPropIssueAllof1PropAssignee"""


class WebhookIssuesUnlockedPropIssueAllof1PropAssigneesItemsType(TypedDict):
    """WebhookIssuesUnlockedPropIssueAllof1PropAssigneesItems"""


class WebhookIssuesUnlockedPropIssueAllof1PropLabelsItemsType(TypedDict):
    """WebhookIssuesUnlockedPropIssueAllof1PropLabelsItems"""


class WebhookIssuesUnlockedPropIssueAllof1PropMilestoneType(TypedDict):
    """WebhookIssuesUnlockedPropIssueAllof1PropMilestone"""


class WebhookIssuesUnlockedPropIssueAllof1PropReactionsType(TypedDict):
    """WebhookIssuesUnlockedPropIssueAllof1PropReactions"""

    plus_one: NotRequired[int]
    minus_one: NotRequired[int]
    confused: NotRequired[int]
    eyes: NotRequired[int]
    heart: NotRequired[int]
    hooray: NotRequired[int]
    laugh: NotRequired[int]
    rocket: NotRequired[int]
    total_count: NotRequired[int]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueAllof1PropUserType(TypedDict):
    """WebhookIssuesUnlockedPropIssueAllof1PropUser"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueMergedAssigneeType(TypedDict):
    """WebhookIssuesUnlockedPropIssueMergedAssignee"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueMergedAssigneesType(TypedDict):
    """WebhookIssuesUnlockedPropIssueMergedAssignees"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnlockedPropIssueMergedLabelsType(TypedDict):
    """WebhookIssuesUnlockedPropIssueMergedLabels"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesUnlockedPropIssueMergedMilestoneType(TypedDict):
    """WebhookIssuesUnlockedPropIssueMergedMilestone"""

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[
        WebhookIssuesUnlockedPropIssueAllof0PropMilestonePropCreatorType, None
    ]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesUnlockedPropIssueMergedReactionsType(TypedDict):
    """WebhookIssuesUnlockedPropIssueMergedReactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesUnlockedPropIssueMergedUserType(TypedDict):
    """WebhookIssuesUnlockedPropIssueMergedUser"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnpinnedType(TypedDict):
    """issues unpinned event"""

    action: Literal["unpinned"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    issue: WebhookIssuesUnpinnedPropIssueType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookIssuesUnpinnedPropIssueType(TypedDict):
    """Issue

    The [issue](https://docs.github.com/rest/issues/issues#get-an-issue) itself.
    """

    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    assignee: NotRequired[Union[WebhookIssuesUnpinnedPropIssuePropAssigneeType, None]]
    assignees: List[Union[WebhookIssuesUnpinnedPropIssuePropAssigneesItemsType, None]]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    body: Union[str, None]
    closed_at: Union[datetime, None]
    comments: int
    comments_url: str
    created_at: datetime
    draft: NotRequired[bool]
    events_url: str
    html_url: str
    id: int
    labels: NotRequired[List[WebhookIssuesUnpinnedPropIssuePropLabelsItemsType]]
    labels_url: str
    locked: NotRequired[bool]
    milestone: Union[WebhookIssuesUnpinnedPropIssuePropMilestoneType, None]
    node_id: str
    number: int
    performed_via_github_app: NotRequired[
        Union[WebhookIssuesUnpinnedPropIssuePropPerformedViaGithubAppType, None]
    ]
    pull_request: NotRequired[WebhookIssuesUnpinnedPropIssuePropPullRequestType]
    reactions: WebhookIssuesUnpinnedPropIssuePropReactionsType
    repository_url: str
    state: NotRequired[Literal["open", "closed"]]
    state_reason: NotRequired[Union[str, None]]
    timeline_url: NotRequired[str]
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookIssuesUnpinnedPropIssuePropUserType, None]


class WebhookIssuesUnpinnedPropIssuePropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnpinnedPropIssuePropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnpinnedPropIssuePropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookIssuesUnpinnedPropIssuePropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnpinnedPropIssuePropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookIssuesUnpinnedPropIssuePropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookIssuesUnpinnedPropIssuePropPerformedViaGithubAppPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookIssuesUnpinnedPropIssuePropPerformedViaGithubAppPropPermissionsType(
    TypedDict
):
    """WebhookIssuesUnpinnedPropIssuePropPerformedViaGithubAppPropPermissions

    The set of permissions for the GitHub app
    """

    actions: NotRequired[Literal["read", "write"]]
    administration: NotRequired[Literal["read", "write"]]
    checks: NotRequired[Literal["read", "write"]]
    content_references: NotRequired[Literal["read", "write"]]
    contents: NotRequired[Literal["read", "write"]]
    deployments: NotRequired[Literal["read", "write"]]
    discussions: NotRequired[Literal["read", "write"]]
    emails: NotRequired[Literal["read", "write"]]
    environments: NotRequired[Literal["read", "write"]]
    issues: NotRequired[Literal["read", "write"]]
    keys: NotRequired[Literal["read", "write"]]
    members: NotRequired[Literal["read", "write"]]
    metadata: NotRequired[Literal["read", "write"]]
    organization_administration: NotRequired[Literal["read", "write"]]
    organization_hooks: NotRequired[Literal["read", "write"]]
    organization_packages: NotRequired[Literal["read", "write"]]
    organization_plan: NotRequired[Literal["read", "write"]]
    organization_projects: NotRequired[Literal["read", "write"]]
    organization_secrets: NotRequired[Literal["read", "write"]]
    organization_self_hosted_runners: NotRequired[Literal["read", "write"]]
    organization_user_blocking: NotRequired[Literal["read", "write"]]
    packages: NotRequired[Literal["read", "write"]]
    pages: NotRequired[Literal["read", "write"]]
    pull_requests: NotRequired[Literal["read", "write"]]
    repository_hooks: NotRequired[Literal["read", "write"]]
    repository_projects: NotRequired[Literal["read", "write"]]
    secret_scanning_alerts: NotRequired[Literal["read", "write"]]
    secrets: NotRequired[Literal["read", "write"]]
    security_events: NotRequired[Literal["read", "write"]]
    security_scanning_alert: NotRequired[Literal["read", "write"]]
    single_file: NotRequired[Literal["read", "write"]]
    statuses: NotRequired[Literal["read", "write"]]
    team_discussions: NotRequired[Literal["read", "write"]]
    vulnerability_alerts: NotRequired[Literal["read", "write"]]
    workflows: NotRequired[Literal["read", "write"]]


class WebhookIssuesUnpinnedPropIssuePropPerformedViaGithubAppType(TypedDict):
    """App

    GitHub apps are a new way to extend GitHub. They can be installed directly on
    organizations and user accounts and granted access to specific repositories.
    They come with granular permissions and built-in webhooks. GitHub apps are first
    class actors within GitHub.
    """

    created_at: Union[datetime, None]
    description: Union[str, None]
    events: NotRequired[
        List[
            Literal[
                "branch_protection_rule",
                "check_run",
                "check_suite",
                "code_scanning_alert",
                "commit_comment",
                "content_reference",
                "create",
                "delete",
                "deployment",
                "deployment_review",
                "deployment_status",
                "deploy_key",
                "discussion",
                "discussion_comment",
                "fork",
                "gollum",
                "issues",
                "issue_comment",
                "label",
                "member",
                "membership",
                "milestone",
                "organization",
                "org_block",
                "page_build",
                "project",
                "project_card",
                "project_column",
                "public",
                "pull_request",
                "pull_request_review",
                "pull_request_review_comment",
                "push",
                "registry_package",
                "release",
                "repository",
                "repository_dispatch",
                "secret_scanning_alert",
                "star",
                "status",
                "team",
                "team_add",
                "watch",
                "workflow_dispatch",
                "workflow_run",
            ]
        ]
    ]
    external_url: Union[str, None]
    html_url: str
    id: Union[int, None]
    name: str
    node_id: str
    owner: Union[
        WebhookIssuesUnpinnedPropIssuePropPerformedViaGithubAppPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookIssuesUnpinnedPropIssuePropPerformedViaGithubAppPropPermissionsType
    ]
    slug: NotRequired[str]
    updated_at: Union[datetime, None]


class WebhookIssuesUnpinnedPropIssuePropPullRequestType(TypedDict):
    """WebhookIssuesUnpinnedPropIssuePropPullRequest"""

    diff_url: NotRequired[str]
    html_url: NotRequired[str]
    merged_at: NotRequired[Union[datetime, None]]
    patch_url: NotRequired[str]
    url: NotRequired[str]


class WebhookIssuesUnpinnedPropIssuePropReactionsType(TypedDict):
    """Reactions"""

    plus_one: int
    minus_one: int
    confused: int
    eyes: int
    heart: int
    hooray: int
    laugh: int
    rocket: int
    total_count: int
    url: str


class WebhookIssuesUnpinnedPropIssuePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookLabelCreatedType(TypedDict):
    """label created event"""

    action: Literal["created"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    label: WebhookLabelCreatedPropLabelType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookLabelCreatedPropLabelType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookLabelDeletedType(TypedDict):
    """label deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    label: WebhookLabelDeletedPropLabelType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookLabelDeletedPropLabelType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookLabelEditedType(TypedDict):
    """label edited event"""

    action: Literal["edited"]
    changes: NotRequired[WebhookLabelEditedPropChangesType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    label: WebhookLabelEditedPropLabelType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookLabelEditedPropChangesType(TypedDict):
    """WebhookLabelEditedPropChanges

    The changes to the label if the action was `edited`.
    """

    color: NotRequired[WebhookLabelEditedPropChangesPropColorType]
    description: NotRequired[WebhookLabelEditedPropChangesPropDescriptionType]
    name: NotRequired[WebhookLabelEditedPropChangesPropNameType]


class WebhookLabelEditedPropChangesPropColorType(TypedDict):
    """WebhookLabelEditedPropChangesPropColor"""

    from_: str


class WebhookLabelEditedPropChangesPropDescriptionType(TypedDict):
    """WebhookLabelEditedPropChangesPropDescription"""

    from_: str


class WebhookLabelEditedPropChangesPropNameType(TypedDict):
    """WebhookLabelEditedPropChangesPropName"""

    from_: str


class WebhookLabelEditedPropLabelType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookMarketplacePurchaseCancelledType(TypedDict):
    """marketplace_purchase cancelled event"""

    action: Literal["cancelled"]
    effective_date: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    marketplace_purchase: WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    previous_marketplace_purchase: NotRequired[
        WebhookMarketplacePurchaseCancelledPropPreviousMarketplacePurchaseType
    ]
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseType(TypedDict):
    """WebhookMarketplacePurchaseCancelledPropMarketplacePurchase"""

    account: WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseMergedAccountType
    billing_cycle: str
    free_trial_ends_on: Union[Union[str, None], None]
    next_billing_date: Union[Union[str, None], None]
    on_free_trial: bool
    plan: WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseMergedPlanType
    unit_count: int


class WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof0Type(TypedDict):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof0PropAccountType
    billing_cycle: str
    free_trial_ends_on: Union[str, None]
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: bool
    plan: WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof0PropPlanType
    unit_count: int


class WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof0PropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof0PropAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof0PropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof0PropPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof1Type(TypedDict):
    """WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof1"""

    account: NotRequired[
        WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof1PropAccountType
    ]
    billing_cycle: NotRequired[str]
    free_trial_ends_on: NotRequired[Union[str, None]]
    next_billing_date: Union[str, None]
    on_free_trial: NotRequired[bool]
    plan: NotRequired[
        WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof1PropPlanType
    ]
    unit_count: NotRequired[int]


class WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof1PropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof1PropAccount"""

    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organization_billing_email: NotRequired[Union[str, None]]
    type: NotRequired[str]


class WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof1PropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseAllof1PropPlan"""

    bullets: NotRequired[List[Union[str, None]]]
    description: NotRequired[str]
    has_free_trial: NotRequired[bool]
    id: NotRequired[int]
    monthly_price_in_cents: NotRequired[int]
    name: NotRequired[str]
    price_model: NotRequired[Literal["FREE", "FLAT_RATE", "PER_UNIT"]]
    unit_name: NotRequired[Union[str, None]]
    yearly_price_in_cents: NotRequired[int]


class WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseMergedAccountType(
    TypedDict
):
    """WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseMergedAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[Union[str, None], None]
    type: str


class WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseMergedPlanType(
    TypedDict
):
    """WebhookMarketplacePurchaseCancelledPropMarketplacePurchaseMergedPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[Union[str, None], None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchaseCancelledPropPreviousMarketplacePurchaseType(TypedDict):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchaseCancelledPropPreviousMarketplacePurchasePropAccountType
    billing_cycle: str
    free_trial_ends_on: None
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: bool
    plan: WebhookMarketplacePurchaseCancelledPropPreviousMarketplacePurchasePropPlanType
    unit_count: int


class WebhookMarketplacePurchaseCancelledPropPreviousMarketplacePurchasePropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchaseCancelledPropPreviousMarketplacePurchasePropAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchaseCancelledPropPreviousMarketplacePurchasePropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchaseCancelledPropPreviousMarketplacePurchasePropPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchaseChangedType(TypedDict):
    """marketplace_purchase changed event"""

    action: Literal["changed"]
    effective_date: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    marketplace_purchase: WebhookMarketplacePurchaseChangedPropMarketplacePurchaseType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    previous_marketplace_purchase: NotRequired[
        WebhookMarketplacePurchaseChangedPropPreviousMarketplacePurchaseType
    ]
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookMarketplacePurchaseChangedPropMarketplacePurchaseType(TypedDict):
    """WebhookMarketplacePurchaseChangedPropMarketplacePurchase"""

    account: WebhookMarketplacePurchaseChangedPropMarketplacePurchaseMergedAccountType
    billing_cycle: str
    free_trial_ends_on: Union[Union[str, None], None]
    next_billing_date: Union[Union[str, None], None]
    on_free_trial: bool
    plan: WebhookMarketplacePurchaseChangedPropMarketplacePurchaseMergedPlanType
    unit_count: int


class WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof0Type(TypedDict):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof0PropAccountType
    billing_cycle: str
    free_trial_ends_on: Union[str, None]
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: bool
    plan: WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof0PropPlanType
    unit_count: int


class WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof0PropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof0PropAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof0PropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof0PropPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof1Type(TypedDict):
    """WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof1"""

    account: NotRequired[
        WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof1PropAccountType
    ]
    billing_cycle: NotRequired[str]
    free_trial_ends_on: NotRequired[Union[str, None]]
    next_billing_date: Union[str, None]
    on_free_trial: NotRequired[bool]
    plan: NotRequired[
        WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof1PropPlanType
    ]
    unit_count: NotRequired[int]


class WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof1PropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof1PropAccount"""

    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organization_billing_email: NotRequired[Union[str, None]]
    type: NotRequired[str]


class WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof1PropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchaseChangedPropMarketplacePurchaseAllof1PropPlan"""

    bullets: NotRequired[List[Union[str, None]]]
    description: NotRequired[str]
    has_free_trial: NotRequired[bool]
    id: NotRequired[int]
    monthly_price_in_cents: NotRequired[int]
    name: NotRequired[str]
    price_model: NotRequired[Literal["FREE", "FLAT_RATE", "PER_UNIT"]]
    unit_name: NotRequired[Union[str, None]]
    yearly_price_in_cents: NotRequired[int]


class WebhookMarketplacePurchaseChangedPropMarketplacePurchaseMergedAccountType(
    TypedDict
):
    """WebhookMarketplacePurchaseChangedPropMarketplacePurchaseMergedAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[Union[str, None], None]
    type: str


class WebhookMarketplacePurchaseChangedPropMarketplacePurchaseMergedPlanType(TypedDict):
    """WebhookMarketplacePurchaseChangedPropMarketplacePurchaseMergedPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[Union[str, None], None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchaseChangedPropPreviousMarketplacePurchaseType(TypedDict):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchaseChangedPropPreviousMarketplacePurchasePropAccountType
    billing_cycle: str
    free_trial_ends_on: Union[str, None]
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: Union[bool, None]
    plan: WebhookMarketplacePurchaseChangedPropPreviousMarketplacePurchasePropPlanType
    unit_count: int


class WebhookMarketplacePurchaseChangedPropPreviousMarketplacePurchasePropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchaseChangedPropPreviousMarketplacePurchasePropAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchaseChangedPropPreviousMarketplacePurchasePropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchaseChangedPropPreviousMarketplacePurchasePropPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchasePendingChangeType(TypedDict):
    """marketplace_purchase pending_change event"""

    action: Literal["pending_change"]
    effective_date: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    marketplace_purchase: WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    previous_marketplace_purchase: NotRequired[
        WebhookMarketplacePurchasePendingChangePropPreviousMarketplacePurchaseType
    ]
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseType(TypedDict):
    """WebhookMarketplacePurchasePendingChangePropMarketplacePurchase"""

    account: WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseMergedAccountType
    billing_cycle: str
    free_trial_ends_on: Union[Union[str, None], None]
    next_billing_date: Union[Union[str, None], None]
    on_free_trial: bool
    plan: WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseMergedPlanType
    unit_count: int


class WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof0Type(
    TypedDict
):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof0PropAccountType
    billing_cycle: str
    free_trial_ends_on: Union[str, None]
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: bool
    plan: WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof0PropPlanType
    unit_count: int


class WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof0PropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof0PropAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof0PropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof0PropPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof1Type(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof1"""

    account: NotRequired[
        WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof1PropAccountType
    ]
    billing_cycle: NotRequired[str]
    free_trial_ends_on: NotRequired[Union[str, None]]
    next_billing_date: Union[str, None]
    on_free_trial: NotRequired[bool]
    plan: NotRequired[
        WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof1PropPlanType
    ]
    unit_count: NotRequired[int]


class WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof1PropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof1PropAccount"""

    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organization_billing_email: NotRequired[Union[str, None]]
    type: NotRequired[str]


class WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof1PropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseAllof1PropPlan"""

    bullets: NotRequired[List[Union[str, None]]]
    description: NotRequired[str]
    has_free_trial: NotRequired[bool]
    id: NotRequired[int]
    monthly_price_in_cents: NotRequired[int]
    name: NotRequired[str]
    price_model: NotRequired[Literal["FREE", "FLAT_RATE", "PER_UNIT"]]
    unit_name: NotRequired[Union[str, None]]
    yearly_price_in_cents: NotRequired[int]


class WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseMergedAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseMergedAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[Union[str, None], None]
    type: str


class WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseMergedPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangePropMarketplacePurchaseMergedPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[Union[str, None], None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchasePendingChangePropPreviousMarketplacePurchaseType(
    TypedDict
):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchasePendingChangePropPreviousMarketplacePurchasePropAccountType
    billing_cycle: str
    free_trial_ends_on: Union[str, None]
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: bool
    plan: WebhookMarketplacePurchasePendingChangePropPreviousMarketplacePurchasePropPlanType
    unit_count: int


class WebhookMarketplacePurchasePendingChangePropPreviousMarketplacePurchasePropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangePropPreviousMarketplacePurchasePropAccoun
    t
    """

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchasePendingChangePropPreviousMarketplacePurchasePropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangePropPreviousMarketplacePurchasePropPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchasePendingChangeCancelledType(TypedDict):
    """marketplace_purchase pending_change_cancelled event"""

    action: Literal["pending_change_cancelled"]
    effective_date: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    marketplace_purchase: WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    previous_marketplace_purchase: NotRequired[
        WebhookMarketplacePurchasePendingChangeCancelledPropPreviousMarketplacePurchaseType
    ]
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchase"""

    account: WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof0PropAccountType
    billing_cycle: str
    free_trial_ends_on: None
    next_billing_date: str
    on_free_trial: bool
    plan: WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof0PropPlanType
    unit_count: int


class WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof0Type(
    TypedDict
):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof0PropAccountType
    billing_cycle: str
    free_trial_ends_on: None
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: bool
    plan: WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof0PropPlanType
    unit_count: int


class WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof0PropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof0Pro
    pAccount
    """

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof0PropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof0Pro
    pPlan
    """

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof1Type(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangeCancelledPropMarketplacePurchaseAllof1"""

    next_billing_date: str


class WebhookMarketplacePurchasePendingChangeCancelledPropPreviousMarketplacePurchaseType(
    TypedDict
):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchasePendingChangeCancelledPropPreviousMarketplacePurchasePropAccountType
    billing_cycle: str
    free_trial_ends_on: None
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: bool
    plan: WebhookMarketplacePurchasePendingChangeCancelledPropPreviousMarketplacePurchasePropPlanType
    unit_count: int


class WebhookMarketplacePurchasePendingChangeCancelledPropPreviousMarketplacePurchasePropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangeCancelledPropPreviousMarketplacePurchaseP
    ropAccount
    """

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchasePendingChangeCancelledPropPreviousMarketplacePurchasePropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePendingChangeCancelledPropPreviousMarketplacePurchaseP
    ropPlan
    """

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchasePurchasedType(TypedDict):
    """marketplace_purchase purchased event"""

    action: Literal["purchased"]
    effective_date: str
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    marketplace_purchase: WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    previous_marketplace_purchase: NotRequired[
        WebhookMarketplacePurchasePurchasedPropPreviousMarketplacePurchaseType
    ]
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseType(TypedDict):
    """WebhookMarketplacePurchasePurchasedPropMarketplacePurchase"""

    account: WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseMergedAccountType
    billing_cycle: str
    free_trial_ends_on: Union[Union[str, None], None]
    next_billing_date: Union[Union[str, None], None]
    on_free_trial: bool
    plan: WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseMergedPlanType
    unit_count: int


class WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof0Type(TypedDict):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof0PropAccountType
    billing_cycle: str
    free_trial_ends_on: Union[str, None]
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: bool
    plan: WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof0PropPlanType
    unit_count: int


class WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof0PropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof0PropAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof0PropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof0PropPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof1Type(TypedDict):
    """WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof1"""

    account: NotRequired[
        WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof1PropAccountType
    ]
    billing_cycle: NotRequired[str]
    free_trial_ends_on: NotRequired[Union[str, None]]
    next_billing_date: Union[str, None]
    on_free_trial: NotRequired[bool]
    plan: NotRequired[
        WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof1PropPlanType
    ]
    unit_count: NotRequired[int]


class WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof1PropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof1PropAccount"""

    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organization_billing_email: NotRequired[Union[str, None]]
    type: NotRequired[str]


class WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof1PropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseAllof1PropPlan"""

    bullets: NotRequired[List[Union[str, None]]]
    description: NotRequired[str]
    has_free_trial: NotRequired[bool]
    id: NotRequired[int]
    monthly_price_in_cents: NotRequired[int]
    name: NotRequired[str]
    price_model: NotRequired[Literal["FREE", "FLAT_RATE", "PER_UNIT"]]
    unit_name: NotRequired[Union[str, None]]
    yearly_price_in_cents: NotRequired[int]


class WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseMergedAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseMergedAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[Union[str, None], None]
    type: str


class WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseMergedPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePurchasedPropMarketplacePurchaseMergedPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[Union[str, None], None]
    yearly_price_in_cents: int


class WebhookMarketplacePurchasePurchasedPropPreviousMarketplacePurchaseType(TypedDict):
    """Marketplace Purchase"""

    account: WebhookMarketplacePurchasePurchasedPropPreviousMarketplacePurchasePropAccountType
    billing_cycle: str
    free_trial_ends_on: None
    next_billing_date: NotRequired[Union[str, None]]
    on_free_trial: bool
    plan: WebhookMarketplacePurchasePurchasedPropPreviousMarketplacePurchasePropPlanType
    unit_count: int


class WebhookMarketplacePurchasePurchasedPropPreviousMarketplacePurchasePropAccountType(
    TypedDict
):
    """WebhookMarketplacePurchasePurchasedPropPreviousMarketplacePurchasePropAccount"""

    id: int
    login: str
    node_id: str
    organization_billing_email: Union[str, None]
    type: str


class WebhookMarketplacePurchasePurchasedPropPreviousMarketplacePurchasePropPlanType(
    TypedDict
):
    """WebhookMarketplacePurchasePurchasedPropPreviousMarketplacePurchasePropPlan"""

    bullets: List[str]
    description: str
    has_free_trial: bool
    id: int
    monthly_price_in_cents: int
    name: str
    price_model: Literal["FREE", "FLAT_RATE", "PER_UNIT"]
    unit_name: Union[str, None]
    yearly_price_in_cents: int


class WebhookMemberAddedType(TypedDict):
    """member added event"""

    action: Literal["added"]
    changes: NotRequired[WebhookMemberAddedPropChangesType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    member: Union[WebhookMemberAddedPropMemberType, None]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookMemberAddedPropChangesType(TypedDict):
    """WebhookMemberAddedPropChanges"""

    permission: NotRequired[WebhookMemberAddedPropChangesPropPermissionType]


class WebhookMemberAddedPropChangesPropPermissionType(TypedDict):
    """WebhookMemberAddedPropChangesPropPermission"""

    to: Literal["write", "admin", "read"]


class WebhookMemberAddedPropMemberType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookMemberEditedType(TypedDict):
    """member edited event"""

    action: Literal["edited"]
    changes: WebhookMemberEditedPropChangesType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    member: Union[WebhookMemberEditedPropMemberType, None]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookMemberEditedPropChangesType(TypedDict):
    """WebhookMemberEditedPropChanges

    The changes to the collaborator permissions
    """

    old_permission: NotRequired[WebhookMemberEditedPropChangesPropOldPermissionType]
    permission: NotRequired[WebhookMemberEditedPropChangesPropPermissionType]


class WebhookMemberEditedPropChangesPropOldPermissionType(TypedDict):
    """WebhookMemberEditedPropChangesPropOldPermission"""

    from_: str


class WebhookMemberEditedPropChangesPropPermissionType(TypedDict):
    """WebhookMemberEditedPropChangesPropPermission"""

    from_: NotRequired[Union[str, None]]
    to: NotRequired[Union[str, None]]


class WebhookMemberEditedPropMemberType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookMemberRemovedType(TypedDict):
    """member removed event"""

    action: Literal["removed"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    member: Union[WebhookMemberRemovedPropMemberType, None]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookMemberRemovedPropMemberType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookMembershipAddedType(TypedDict):
    """membership added event"""

    action: Literal["added"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    member: Union[WebhookMembershipAddedPropMemberType, None]
    organization: OrganizationSimpleWebhooksType
    repository: NotRequired[RepositoryWebhooksType]
    scope: Literal["team"]
    sender: Union[WebhookMembershipAddedPropSenderType, None]
    team: WebhookMembershipAddedPropTeamType


class WebhookMembershipAddedPropMemberType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookMembershipAddedPropSenderType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookMembershipAddedPropTeamType(TypedDict):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: NotRequired[bool]
    description: NotRequired[Union[str, None]]
    html_url: NotRequired[str]
    id: int
    members_url: NotRequired[str]
    name: str
    node_id: NotRequired[str]
    parent: NotRequired[Union[WebhookMembershipAddedPropTeamPropParentType, None]]
    permission: NotRequired[str]
    privacy: NotRequired[Literal["open", "closed", "secret"]]
    notification_setting: NotRequired[
        Literal["notifications_enabled", "notifications_disabled"]
    ]
    repositories_url: NotRequired[str]
    slug: NotRequired[str]
    url: NotRequired[str]


class WebhookMembershipAddedPropTeamPropParentType(TypedDict):
    """WebhookMembershipAddedPropTeamPropParent"""

    description: Union[str, None]
    html_url: str
    id: int
    members_url: str
    name: str
    node_id: str
    permission: str
    privacy: Literal["open", "closed", "secret"]
    notification_setting: Literal["notifications_enabled", "notifications_disabled"]
    repositories_url: str
    slug: str
    url: str


class WebhookMembershipRemovedType(TypedDict):
    """membership removed event"""

    action: Literal["removed"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    member: Union[WebhookMembershipRemovedPropMemberType, None]
    organization: OrganizationSimpleWebhooksType
    repository: NotRequired[RepositoryWebhooksType]
    scope: Literal["team", "organization"]
    sender: Union[WebhookMembershipRemovedPropSenderType, None]
    team: WebhookMembershipRemovedPropTeamType


class WebhookMembershipRemovedPropMemberType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookMembershipRemovedPropSenderType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookMembershipRemovedPropTeamType(TypedDict):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: NotRequired[bool]
    description: NotRequired[Union[str, None]]
    html_url: NotRequired[str]
    id: int
    members_url: NotRequired[str]
    name: str
    node_id: NotRequired[str]
    parent: NotRequired[Union[WebhookMembershipRemovedPropTeamPropParentType, None]]
    permission: NotRequired[str]
    privacy: NotRequired[Literal["open", "closed", "secret"]]
    notification_setting: NotRequired[
        Literal["notifications_enabled", "notifications_disabled"]
    ]
    repositories_url: NotRequired[str]
    slug: NotRequired[str]
    url: NotRequired[str]


class WebhookMembershipRemovedPropTeamPropParentType(TypedDict):
    """WebhookMembershipRemovedPropTeamPropParent"""

    description: Union[str, None]
    html_url: str
    id: int
    members_url: str
    name: str
    node_id: str
    permission: str
    privacy: Literal["open", "closed", "secret"]
    notification_setting: Literal["notifications_enabled", "notifications_disabled"]
    repositories_url: str
    slug: str
    url: str


class WebhookMergeGroupChecksRequestedType(TypedDict):
    """WebhookMergeGroupChecksRequested"""

    action: Literal["checks_requested"]
    installation: NotRequired[SimpleInstallationType]
    merge_group: MergeGroupType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: NotRequired[RepositoryWebhooksType]
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookMergeGroupDestroyedType(TypedDict):
    """WebhookMergeGroupDestroyed"""

    action: Literal["destroyed"]
    reason: NotRequired[Literal["merged", "invalidated", "dequeued"]]
    installation: NotRequired[SimpleInstallationType]
    merge_group: MergeGroupType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: NotRequired[RepositoryWebhooksType]
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookMetaDeletedType(TypedDict):
    """meta deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    hook: WebhookMetaDeletedPropHookType
    hook_id: int
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: NotRequired[Union[None, RepositoryWebhooksType]]
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookMetaDeletedPropHookType(TypedDict):
    """WebhookMetaDeletedPropHook

    The modified webhook. This will contain different keys based on the type of
    webhook it is: repository, organization, business, app, or GitHub Marketplace.
    """

    active: bool
    config: WebhookMetaDeletedPropHookPropConfigType
    created_at: str
    events: List[
        Literal[
            "*",
            "branch_protection_rule",
            "check_run",
            "check_suite",
            "code_scanning_alert",
            "commit_comment",
            "create",
            "delete",
            "deployment",
            "deployment_status",
            "deploy_key",
            "discussion",
            "discussion_comment",
            "fork",
            "gollum",
            "issues",
            "issue_comment",
            "label",
            "member",
            "membership",
            "meta",
            "milestone",
            "organization",
            "org_block",
            "package",
            "page_build",
            "project",
            "project_card",
            "project_column",
            "public",
            "pull_request",
            "pull_request_review",
            "pull_request_review_comment",
            "pull_request_review_thread",
            "push",
            "registry_package",
            "release",
            "repository",
            "repository_import",
            "repository_vulnerability_alert",
            "secret_scanning_alert",
            "secret_scanning_alert_location",
            "security_and_analysis",
            "star",
            "status",
            "team",
            "team_add",
            "watch",
            "workflow_job",
            "workflow_run",
            "repository_dispatch",
            "projects_v2_item",
        ]
    ]
    id: int
    name: str
    type: str
    updated_at: str


class WebhookMetaDeletedPropHookPropConfigType(TypedDict):
    """WebhookMetaDeletedPropHookPropConfig"""

    content_type: Literal["json", "form"]
    insecure_ssl: str
    secret: NotRequired[str]
    url: str


class WebhookMilestoneClosedType(TypedDict):
    """milestone closed event"""

    action: Literal["closed"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    milestone: WebhookMilestoneClosedPropMilestoneType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookMilestoneClosedPropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookMilestoneClosedPropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookMilestoneClosedPropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookMilestoneCreatedType(TypedDict):
    """milestone created event"""

    action: Literal["created"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    milestone: WebhookMilestoneCreatedPropMilestoneType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookMilestoneCreatedPropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookMilestoneCreatedPropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookMilestoneCreatedPropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookMilestoneDeletedType(TypedDict):
    """milestone deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    milestone: WebhookMilestoneDeletedPropMilestoneType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookMilestoneDeletedPropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookMilestoneDeletedPropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookMilestoneDeletedPropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookMilestoneEditedType(TypedDict):
    """milestone edited event"""

    action: Literal["edited"]
    changes: WebhookMilestoneEditedPropChangesType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    milestone: WebhookMilestoneEditedPropMilestoneType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookMilestoneEditedPropChangesType(TypedDict):
    """WebhookMilestoneEditedPropChanges

    The changes to the milestone if the action was `edited`.
    """

    description: NotRequired[WebhookMilestoneEditedPropChangesPropDescriptionType]
    due_on: NotRequired[WebhookMilestoneEditedPropChangesPropDueOnType]
    title: NotRequired[WebhookMilestoneEditedPropChangesPropTitleType]


class WebhookMilestoneEditedPropChangesPropDescriptionType(TypedDict):
    """WebhookMilestoneEditedPropChangesPropDescription"""

    from_: str


class WebhookMilestoneEditedPropChangesPropDueOnType(TypedDict):
    """WebhookMilestoneEditedPropChangesPropDueOn"""

    from_: str


class WebhookMilestoneEditedPropChangesPropTitleType(TypedDict):
    """WebhookMilestoneEditedPropChangesPropTitle"""

    from_: str


class WebhookMilestoneEditedPropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookMilestoneEditedPropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookMilestoneEditedPropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookMilestoneOpenedType(TypedDict):
    """milestone opened event"""

    action: Literal["opened"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    milestone: WebhookMilestoneOpenedPropMilestoneType
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookMilestoneOpenedPropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None]
    closed_issues: int
    created_at: datetime
    creator: Union[WebhookMilestoneOpenedPropMilestonePropCreatorType, None]
    description: Union[str, None]
    due_on: Union[datetime, None]
    html_url: str
    id: int
    labels_url: str
    node_id: str
    number: int
    open_issues: int
    state: Literal["open", "closed"]
    title: str
    updated_at: datetime
    url: str


class WebhookMilestoneOpenedPropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookOrgBlockBlockedType(TypedDict):
    """org_block blocked event"""

    action: Literal["blocked"]
    blocked_user: Union[WebhookOrgBlockBlockedPropBlockedUserType, None]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookOrgBlockBlockedPropBlockedUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookOrgBlockUnblockedType(TypedDict):
    """org_block unblocked event"""

    action: Literal["unblocked"]
    blocked_user: Union[WebhookOrgBlockUnblockedPropBlockedUserType, None]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookOrgBlockUnblockedPropBlockedUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookOrganizationDeletedType(TypedDict):
    """organization deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    membership: NotRequired[WebhookOrganizationDeletedPropMembershipType]
    organization: OrganizationSimpleWebhooksType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookOrganizationDeletedPropMembershipType(TypedDict):
    """Membership

    The membership between the user and the organization. Not present when the
    action is `member_invited`.
    """

    organization_url: str
    role: str
    state: str
    url: str
    user: Union[WebhookOrganizationDeletedPropMembershipPropUserType, None]


class WebhookOrganizationDeletedPropMembershipPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookOrganizationMemberAddedType(TypedDict):
    """organization member_added event"""

    action: Literal["member_added"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    membership: WebhookOrganizationMemberAddedPropMembershipType
    organization: OrganizationSimpleWebhooksType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookOrganizationMemberAddedPropMembershipType(TypedDict):
    """Membership

    The membership between the user and the organization. Not present when the
    action is `member_invited`.
    """

    organization_url: str
    role: str
    state: str
    url: str
    user: Union[WebhookOrganizationMemberAddedPropMembershipPropUserType, None]


class WebhookOrganizationMemberAddedPropMembershipPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookOrganizationMemberInvitedType(TypedDict):
    """organization member_invited event"""

    action: Literal["member_invited"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    invitation: WebhookOrganizationMemberInvitedPropInvitationType
    organization: OrganizationSimpleWebhooksType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType
    user: NotRequired[Union[WebhookOrganizationMemberInvitedPropUserType, None]]


class WebhookOrganizationMemberInvitedPropInvitationType(TypedDict):
    """WebhookOrganizationMemberInvitedPropInvitation

    The invitation for the user or email if the action is `member_invited`.
    """

    created_at: datetime
    email: Union[str, None]
    failed_at: Union[datetime, None]
    failed_reason: Union[str, None]
    id: float
    invitation_teams_url: str
    inviter: Union[WebhookOrganizationMemberInvitedPropInvitationPropInviterType, None]
    login: Union[str, None]
    node_id: str
    role: str
    team_count: float
    invitation_source: NotRequired[str]


class WebhookOrganizationMemberInvitedPropInvitationPropInviterType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookOrganizationMemberInvitedPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookOrganizationMemberRemovedType(TypedDict):
    """organization member_removed event"""

    action: Literal["member_removed"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    membership: WebhookOrganizationMemberRemovedPropMembershipType
    organization: OrganizationSimpleWebhooksType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookOrganizationMemberRemovedPropMembershipType(TypedDict):
    """Membership

    The membership between the user and the organization. Not present when the
    action is `member_invited`.
    """

    organization_url: str
    role: str
    state: str
    url: str
    user: Union[WebhookOrganizationMemberRemovedPropMembershipPropUserType, None]


class WebhookOrganizationMemberRemovedPropMembershipPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookOrganizationRenamedType(TypedDict):
    """organization renamed event"""

    action: Literal["renamed"]
    changes: NotRequired[WebhookOrganizationRenamedPropChangesType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    membership: NotRequired[WebhookOrganizationRenamedPropMembershipType]
    organization: OrganizationSimpleWebhooksType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookOrganizationRenamedPropChangesType(TypedDict):
    """WebhookOrganizationRenamedPropChanges"""

    login: NotRequired[WebhookOrganizationRenamedPropChangesPropLoginType]


class WebhookOrganizationRenamedPropChangesPropLoginType(TypedDict):
    """WebhookOrganizationRenamedPropChangesPropLogin"""

    from_: NotRequired[str]


class WebhookOrganizationRenamedPropMembershipType(TypedDict):
    """Membership

    The membership between the user and the organization. Not present when the
    action is `member_invited`.
    """

    organization_url: str
    role: str
    state: str
    url: str
    user: Union[WebhookOrganizationRenamedPropMembershipPropUserType, None]


class WebhookOrganizationRenamedPropMembershipPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookRubygemsMetadataType(TypedDict):
    """Ruby Gems metadata"""

    name: NotRequired[str]
    description: NotRequired[str]
    readme: NotRequired[str]
    homepage: NotRequired[str]
    version_info: NotRequired[WebhookRubygemsMetadataPropVersionInfoType]
    platform: NotRequired[str]
    metadata: NotRequired[WebhookRubygemsMetadataPropMetadataType]
    repo: NotRequired[str]
    dependencies: NotRequired[List[WebhookRubygemsMetadataPropDependenciesItemsType]]
    commit_oid: NotRequired[str]


class WebhookRubygemsMetadataPropVersionInfoType(TypedDict):
    """WebhookRubygemsMetadataPropVersionInfo"""

    version: NotRequired[str]


class WebhookRubygemsMetadataPropMetadataType(TypedDict):
    """WebhookRubygemsMetadataPropMetadata"""


class WebhookRubygemsMetadataPropDependenciesItemsType(TypedDict):
    """WebhookRubygemsMetadataPropDependenciesItems"""


class WebhookPackagePublishedType(TypedDict):
    """package published event"""

    action: Literal["published"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    package: WebhookPackagePublishedPropPackageType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookPackagePublishedPropPackageType(TypedDict):
    """WebhookPackagePublishedPropPackage

    Information about the package.
    """

    created_at: Union[str, None]
    description: Union[str, None]
    ecosystem: str
    html_url: str
    id: int
    name: str
    namespace: str
    owner: Union[WebhookPackagePublishedPropPackagePropOwnerType, None]
    package_type: str
    package_version: Union[
        WebhookPackagePublishedPropPackagePropPackageVersionType, None
    ]
    registry: Union[WebhookPackagePublishedPropPackagePropRegistryType, None]
    updated_at: Union[str, None]


class WebhookPackagePublishedPropPackagePropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPackagePublishedPropPackagePropPackageVersionPropAuthorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPackagePublishedPropPackagePropPackageVersionPropBodyOneof1Type(TypedDict):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropBodyOneof1"""


class WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataPropLabelsType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataPropLab
    els
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataPropManifestType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataPropMan
    ifest
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataPropTagType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataPropTag"""

    digest: NotRequired[str]
    name: NotRequired[str]


class WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadata"""

    labels: NotRequired[
        Union[
            WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataPropLabelsType,
            None,
        ]
    ]
    manifest: NotRequired[
        Union[
            WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataPropManifestType,
            None,
        ]
    ]
    tag: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataPropTagType
    ]


class WebhookPackagePublishedPropPackagePropPackageVersionPropDockerMetadataItemsType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropDockerMetadataItems"""

    tags: NotRequired[List[str]]


class WebhookPackagePublishedPropPackagePropPackageVersionPropMetadataItemsType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropMetadataItems"""


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropAuthorType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropAuthor"""


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropBugsType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropBugs"""


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDependenciesType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDependenc
    ies
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDevDependenciesType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDevDepend
    encies
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropPeerDependenciesType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropPeerDepen
    dencies
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropOptionalDependenciesType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropOptionalD
    ependencies
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDistType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDist"""


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropRepositoryType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropRepositor
    y
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropScriptsType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropScripts"""


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropMaintainersItemsType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropMaintaine
    rsItems
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropContributorsItemsType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropContribut
    orsItems
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropEnginesType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropEngines"""


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropBinType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropBin"""


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropManType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropMan"""


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDirectoriesType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDirectori
    es
    """


class WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadata"""

    name: NotRequired[str]
    version: NotRequired[str]
    npm_user: NotRequired[str]
    author: NotRequired[
        Union[
            WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropAuthorType,
            None,
        ]
    ]
    bugs: NotRequired[
        Union[
            WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropBugsType,
            None,
        ]
    ]
    dependencies: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDependenciesType
    ]
    dev_dependencies: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDevDependenciesType
    ]
    peer_dependencies: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropPeerDependenciesType
    ]
    optional_dependencies: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropOptionalDependenciesType
    ]
    description: NotRequired[str]
    dist: NotRequired[
        Union[
            WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDistType,
            None,
        ]
    ]
    git_head: NotRequired[str]
    homepage: NotRequired[str]
    license_: NotRequired[str]
    main: NotRequired[str]
    repository: NotRequired[
        Union[
            WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropRepositoryType,
            None,
        ]
    ]
    scripts: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropScriptsType
    ]
    id: NotRequired[str]
    node_version: NotRequired[str]
    npm_version: NotRequired[str]
    has_shrinkwrap: NotRequired[bool]
    maintainers: NotRequired[
        List[
            WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropMaintainersItemsType
        ]
    ]
    contributors: NotRequired[
        List[
            WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropContributorsItemsType
        ]
    ]
    engines: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropEnginesType
    ]
    keywords: NotRequired[List[str]]
    files: NotRequired[List[str]]
    bin_: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropBinType
    ]
    man: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropManType
    ]
    directories: NotRequired[
        Union[
            WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataPropDirectoriesType,
            None,
        ]
    ]
    os: NotRequired[List[str]]
    cpu: NotRequired[List[str]]
    readme: NotRequired[str]
    installation_command: NotRequired[str]
    release_id: NotRequired[int]
    commit_oid: NotRequired[str]
    published_via_actions: NotRequired[bool]
    deleted_by_id: NotRequired[int]


class WebhookPackagePublishedPropPackagePropPackageVersionPropNugetMetadataItemsType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNugetMetadataItems"""

    id: NotRequired[Union[int, str]]
    name: NotRequired[str]
    value: NotRequired[
        Union[
            bool,
            str,
            int,
            WebhookPackagePublishedPropPackagePropPackageVersionPropNugetMetadataItemsPropValueOneof3Type,
        ]
    ]


class WebhookPackagePublishedPropPackagePropPackageVersionPropNugetMetadataItemsPropValueOneof3Type(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropNugetMetadataItemsPropVa
    lueOneof3
    """

    url: NotRequired[str]
    branch: NotRequired[str]
    commit: NotRequired[str]
    type: NotRequired[str]


class WebhookPackagePublishedPropPackagePropPackageVersionPropPackageFilesItemsType(
    TypedDict
):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropPackageFilesItems"""

    content_type: str
    created_at: str
    download_url: str
    id: int
    md5: Union[str, None]
    name: str
    sha1: Union[str, None]
    sha256: Union[str, None]
    size: int
    state: Union[str, None]
    updated_at: str


class WebhookPackagePublishedPropPackagePropPackageVersionPropReleaseType(TypedDict):
    """WebhookPackagePublishedPropPackagePropPackageVersionPropRelease"""

    author: Union[
        WebhookPackagePublishedPropPackagePropPackageVersionPropReleasePropAuthorType,
        None,
    ]
    created_at: str
    draft: bool
    html_url: str
    id: int
    name: Union[str, None]
    prerelease: bool
    published_at: str
    tag_name: str
    target_commitish: str
    url: str


class WebhookPackagePublishedPropPackagePropPackageVersionPropReleasePropAuthorType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPackagePublishedPropPackagePropPackageVersionType(TypedDict):
    """WebhookPackagePublishedPropPackagePropPackageVersion"""

    author: NotRequired[
        Union[WebhookPackagePublishedPropPackagePropPackageVersionPropAuthorType, None]
    ]
    body: NotRequired[
        Union[
            str, WebhookPackagePublishedPropPackagePropPackageVersionPropBodyOneof1Type
        ]
    ]
    body_html: NotRequired[str]
    container_metadata: NotRequired[
        Union[
            WebhookPackagePublishedPropPackagePropPackageVersionPropContainerMetadataType,
            None,
        ]
    ]
    created_at: NotRequired[str]
    description: str
    docker_metadata: NotRequired[
        List[
            WebhookPackagePublishedPropPackagePropPackageVersionPropDockerMetadataItemsType
        ]
    ]
    draft: NotRequired[bool]
    html_url: str
    id: int
    installation_command: str
    manifest: NotRequired[str]
    metadata: List[
        WebhookPackagePublishedPropPackagePropPackageVersionPropMetadataItemsType
    ]
    name: str
    npm_metadata: NotRequired[
        Union[
            WebhookPackagePublishedPropPackagePropPackageVersionPropNpmMetadataType,
            None,
        ]
    ]
    nuget_metadata: NotRequired[
        Union[
            List[
                WebhookPackagePublishedPropPackagePropPackageVersionPropNugetMetadataItemsType
            ],
            None,
        ]
    ]
    package_files: List[
        WebhookPackagePublishedPropPackagePropPackageVersionPropPackageFilesItemsType
    ]
    package_url: NotRequired[str]
    prerelease: NotRequired[bool]
    release: NotRequired[
        WebhookPackagePublishedPropPackagePropPackageVersionPropReleaseType
    ]
    rubygems_metadata: NotRequired[List[WebhookRubygemsMetadataType]]
    source_url: NotRequired[str]
    summary: str
    tag_name: NotRequired[str]
    target_commitish: NotRequired[str]
    target_oid: NotRequired[str]
    updated_at: NotRequired[str]
    version: str


class WebhookPackagePublishedPropPackagePropRegistryType(TypedDict):
    """WebhookPackagePublishedPropPackagePropRegistry"""

    about_url: str
    name: str
    type: str
    url: str
    vendor: str


class WebhookPackageUpdatedType(TypedDict):
    """package updated event"""

    action: Literal["updated"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    package: WebhookPackageUpdatedPropPackageType
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookPackageUpdatedPropPackageType(TypedDict):
    """WebhookPackageUpdatedPropPackage

    Information about the package.
    """

    created_at: str
    description: Union[str, None]
    ecosystem: str
    html_url: str
    id: int
    name: str
    namespace: str
    owner: Union[WebhookPackageUpdatedPropPackagePropOwnerType, None]
    package_type: str
    package_version: WebhookPackageUpdatedPropPackagePropPackageVersionType
    registry: Union[WebhookPackageUpdatedPropPackagePropRegistryType, None]
    updated_at: str


class WebhookPackageUpdatedPropPackagePropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPackageUpdatedPropPackagePropPackageVersionType(TypedDict):
    """WebhookPackageUpdatedPropPackagePropPackageVersion"""

    author: Union[
        WebhookPackageUpdatedPropPackagePropPackageVersionPropAuthorType, None
    ]
    body: str
    body_html: str
    created_at: str
    description: str
    docker_metadata: NotRequired[
        List[
            WebhookPackageUpdatedPropPackagePropPackageVersionPropDockerMetadataItemsType
        ]
    ]
    draft: NotRequired[bool]
    html_url: str
    id: int
    installation_command: str
    manifest: NotRequired[str]
    metadata: List[
        WebhookPackageUpdatedPropPackagePropPackageVersionPropMetadataItemsType
    ]
    name: str
    package_files: List[
        WebhookPackageUpdatedPropPackagePropPackageVersionPropPackageFilesItemsType
    ]
    package_url: NotRequired[str]
    prerelease: NotRequired[bool]
    release: NotRequired[
        WebhookPackageUpdatedPropPackagePropPackageVersionPropReleaseType
    ]
    rubygems_metadata: NotRequired[List[WebhookRubygemsMetadataType]]
    source_url: NotRequired[str]
    summary: str
    tag_name: NotRequired[str]
    target_commitish: str
    target_oid: str
    updated_at: str
    version: str


class WebhookPackageUpdatedPropPackagePropPackageVersionPropAuthorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPackageUpdatedPropPackagePropPackageVersionPropDockerMetadataItemsType(
    TypedDict
):
    """WebhookPackageUpdatedPropPackagePropPackageVersionPropDockerMetadataItems"""

    tags: NotRequired[List[str]]


class WebhookPackageUpdatedPropPackagePropPackageVersionPropMetadataItemsType(
    TypedDict
):
    """WebhookPackageUpdatedPropPackagePropPackageVersionPropMetadataItems"""


class WebhookPackageUpdatedPropPackagePropPackageVersionPropPackageFilesItemsType(
    TypedDict
):
    """WebhookPackageUpdatedPropPackagePropPackageVersionPropPackageFilesItems"""

    content_type: str
    created_at: str
    download_url: str
    id: int
    md5: Union[str, None]
    name: str
    sha1: Union[str, None]
    sha256: str
    size: int
    state: str
    updated_at: str


class WebhookPackageUpdatedPropPackagePropPackageVersionPropReleaseType(TypedDict):
    """WebhookPackageUpdatedPropPackagePropPackageVersionPropRelease"""

    author: Union[
        WebhookPackageUpdatedPropPackagePropPackageVersionPropReleasePropAuthorType,
        None,
    ]
    created_at: str
    draft: bool
    html_url: str
    id: int
    name: str
    prerelease: bool
    published_at: str
    tag_name: str
    target_commitish: str
    url: str


class WebhookPackageUpdatedPropPackagePropPackageVersionPropReleasePropAuthorType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPackageUpdatedPropPackagePropRegistryType(TypedDict):
    """WebhookPackageUpdatedPropPackagePropRegistry"""

    about_url: str
    name: str
    type: str
    url: str
    vendor: str


class WebhookPageBuildType(TypedDict):
    """page_build event"""

    build: WebhookPageBuildPropBuildType
    enterprise: NotRequired[EnterpriseWebhooksType]
    id: int
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookPageBuildPropBuildType(TypedDict):
    """WebhookPageBuildPropBuild

    The [List GitHub Pages builds](https://docs.github.com/rest/pages/pages#list-
    github-pages-builds) itself.
    """

    commit: Union[str, None]
    created_at: str
    duration: int
    error: WebhookPageBuildPropBuildPropErrorType
    pusher: Union[WebhookPageBuildPropBuildPropPusherType, None]
    status: str
    updated_at: str
    url: str


class WebhookPageBuildPropBuildPropErrorType(TypedDict):
    """WebhookPageBuildPropBuildPropError"""

    message: Union[str, None]


class WebhookPageBuildPropBuildPropPusherType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPersonalAccessTokenRequestApprovedType(TypedDict):
    """personal_access_token_request approved event"""

    action: Literal["approved"]
    personal_access_token_request: PersonalAccessTokenRequestType
    organization: OrganizationSimpleWebhooksType
    sender: SimpleUserWebhooksType
    installation: SimpleInstallationType


class WebhookPersonalAccessTokenRequestCancelledType(TypedDict):
    """personal_access_token_request cancelled event"""

    action: Literal["cancelled"]
    personal_access_token_request: PersonalAccessTokenRequestType
    organization: OrganizationSimpleWebhooksType
    sender: SimpleUserWebhooksType
    installation: SimpleInstallationType


class WebhookPersonalAccessTokenRequestCreatedType(TypedDict):
    """personal_access_token_request created event"""

    action: Literal["created"]
    personal_access_token_request: PersonalAccessTokenRequestType
    organization: OrganizationSimpleWebhooksType
    sender: SimpleUserWebhooksType
    installation: SimpleInstallationType


class WebhookPersonalAccessTokenRequestDeniedType(TypedDict):
    """personal_access_token_request denied event"""

    action: Literal["denied"]
    personal_access_token_request: PersonalAccessTokenRequestType
    organization: OrganizationSimpleWebhooksType
    sender: SimpleUserWebhooksType
    installation: SimpleInstallationType


class WebhookPingType(TypedDict):
    """WebhookPing"""

    hook: NotRequired[WebhookPingPropHookType]
    hook_id: NotRequired[int]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: NotRequired[RepositoryWebhooksType]
    sender: NotRequired[SimpleUserWebhooksType]
    zen: NotRequired[str]


class WebhookPingPropHookType(TypedDict):
    """Webhook

    The webhook that is being pinged
    """

    active: bool
    app_id: NotRequired[int]
    config: WebhookPingPropHookPropConfigType
    created_at: datetime
    deliveries_url: NotRequired[str]
    events: List[str]
    id: int
    last_response: NotRequired[HookResponseType]
    name: Literal["web"]
    ping_url: NotRequired[str]
    test_url: NotRequired[str]
    type: str
    updated_at: datetime
    url: NotRequired[str]


class WebhookPingPropHookPropConfigType(TypedDict):
    """WebhookPingPropHookPropConfig"""

    content_type: NotRequired[str]
    insecure_ssl: NotRequired[Union[str, float]]
    secret: NotRequired[str]
    url: NotRequired[str]


class WebhookPingFormEncodedType(TypedDict):
    """WebhookPingFormEncoded

    The webhooks ping payload encoded with URL encoding.
    """

    payload: str


class WebhookProjectCardConvertedType(TypedDict):
    """project_card converted event"""

    action: Literal["converted"]
    changes: WebhookProjectCardConvertedPropChangesType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project_card: WebhookProjectCardConvertedPropProjectCardType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookProjectCardConvertedPropChangesType(TypedDict):
    """WebhookProjectCardConvertedPropChanges"""

    note: WebhookProjectCardConvertedPropChangesPropNoteType


class WebhookProjectCardConvertedPropChangesPropNoteType(TypedDict):
    """WebhookProjectCardConvertedPropChangesPropNote"""

    from_: str


class WebhookProjectCardConvertedPropProjectCardType(TypedDict):
    """Project Card"""

    after_id: NotRequired[Union[int, None]]
    archived: bool
    column_id: int
    column_url: str
    content_url: NotRequired[str]
    created_at: datetime
    creator: Union[WebhookProjectCardConvertedPropProjectCardPropCreatorType, None]
    id: int
    node_id: str
    note: Union[str, None]
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectCardConvertedPropProjectCardPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookProjectCardCreatedType(TypedDict):
    """project_card created event"""

    action: Literal["created"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project_card: WebhookProjectCardCreatedPropProjectCardType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookProjectCardCreatedPropProjectCardType(TypedDict):
    """Project Card"""

    after_id: NotRequired[Union[int, None]]
    archived: bool
    column_id: int
    column_url: str
    content_url: NotRequired[str]
    created_at: datetime
    creator: Union[WebhookProjectCardCreatedPropProjectCardPropCreatorType, None]
    id: int
    node_id: str
    note: Union[str, None]
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectCardCreatedPropProjectCardPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookProjectCardDeletedType(TypedDict):
    """project_card deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project_card: WebhookProjectCardDeletedPropProjectCardType
    repository: NotRequired[Union[None, RepositoryWebhooksType]]
    sender: SimpleUserWebhooksType


class WebhookProjectCardDeletedPropProjectCardType(TypedDict):
    """Project Card"""

    after_id: NotRequired[Union[int, None]]
    archived: bool
    column_id: Union[int, None]
    column_url: str
    content_url: NotRequired[str]
    created_at: datetime
    creator: Union[WebhookProjectCardDeletedPropProjectCardPropCreatorType, None]
    id: int
    node_id: str
    note: Union[str, None]
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectCardDeletedPropProjectCardPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookProjectCardEditedType(TypedDict):
    """project_card edited event"""

    action: Literal["edited"]
    changes: WebhookProjectCardEditedPropChangesType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project_card: WebhookProjectCardEditedPropProjectCardType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookProjectCardEditedPropChangesType(TypedDict):
    """WebhookProjectCardEditedPropChanges"""

    note: WebhookProjectCardEditedPropChangesPropNoteType


class WebhookProjectCardEditedPropChangesPropNoteType(TypedDict):
    """WebhookProjectCardEditedPropChangesPropNote"""

    from_: Union[str, None]


class WebhookProjectCardEditedPropProjectCardType(TypedDict):
    """Project Card"""

    after_id: NotRequired[Union[int, None]]
    archived: bool
    column_id: int
    column_url: str
    content_url: NotRequired[str]
    created_at: datetime
    creator: Union[WebhookProjectCardEditedPropProjectCardPropCreatorType, None]
    id: int
    node_id: str
    note: Union[str, None]
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectCardEditedPropProjectCardPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookProjectCardMovedType(TypedDict):
    """project_card moved event"""

    action: Literal["moved"]
    changes: NotRequired[WebhookProjectCardMovedPropChangesType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project_card: WebhookProjectCardMovedPropProjectCardType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookProjectCardMovedPropChangesType(TypedDict):
    """WebhookProjectCardMovedPropChanges"""

    column_id: WebhookProjectCardMovedPropChangesPropColumnIdType


class WebhookProjectCardMovedPropChangesPropColumnIdType(TypedDict):
    """WebhookProjectCardMovedPropChangesPropColumnId"""

    from_: int


class WebhookProjectCardMovedPropProjectCardType(TypedDict):
    """WebhookProjectCardMovedPropProjectCard"""

    after_id: Union[Union[int, None], None]
    archived: bool
    column_id: int
    column_url: str
    content_url: NotRequired[str]
    created_at: datetime
    creator: Union[WebhookProjectCardMovedPropProjectCardMergedCreatorType, None]
    id: int
    node_id: str
    note: Union[Union[str, None], None]
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectCardMovedPropProjectCardAllof0Type(TypedDict):
    """Project Card"""

    after_id: NotRequired[Union[int, None]]
    archived: bool
    column_id: int
    column_url: str
    content_url: NotRequired[str]
    created_at: datetime
    creator: Union[WebhookProjectCardMovedPropProjectCardAllof0PropCreatorType, None]
    id: int
    node_id: str
    note: Union[str, None]
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectCardMovedPropProjectCardAllof0PropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookProjectCardMovedPropProjectCardAllof1Type(TypedDict):
    """WebhookProjectCardMovedPropProjectCardAllof1"""

    after_id: Union[int, None]
    archived: NotRequired[bool]
    column_id: NotRequired[int]
    column_url: NotRequired[str]
    created_at: NotRequired[str]
    creator: NotRequired[
        Union[WebhookProjectCardMovedPropProjectCardAllof1PropCreatorType, None]
    ]
    id: NotRequired[int]
    node_id: NotRequired[str]
    note: NotRequired[Union[str, None]]
    project_url: NotRequired[str]
    updated_at: NotRequired[str]
    url: NotRequired[str]


class WebhookProjectCardMovedPropProjectCardAllof1PropCreatorType(TypedDict):
    """WebhookProjectCardMovedPropProjectCardAllof1PropCreator"""

    avatar_url: NotRequired[str]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: NotRequired[int]
    login: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[str]
    url: NotRequired[str]


class WebhookProjectCardMovedPropProjectCardMergedCreatorType(TypedDict):
    """WebhookProjectCardMovedPropProjectCardMergedCreator"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookProjectClosedType(TypedDict):
    """project closed event"""

    action: Literal["closed"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project: WebhookProjectClosedPropProjectType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookProjectClosedPropProjectType(TypedDict):
    """Project"""

    body: Union[str, None]
    columns_url: str
    created_at: datetime
    creator: Union[WebhookProjectClosedPropProjectPropCreatorType, None]
    html_url: str
    id: int
    name: str
    node_id: str
    number: int
    owner_url: str
    state: Literal["open", "closed"]
    updated_at: datetime
    url: str


class WebhookProjectClosedPropProjectPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookProjectColumnCreatedType(TypedDict):
    """project_column created event"""

    action: Literal["created"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project_column: WebhookProjectColumnCreatedPropProjectColumnType
    repository: NotRequired[RepositoryWebhooksType]
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookProjectColumnCreatedPropProjectColumnType(TypedDict):
    """Project Column"""

    after_id: NotRequired[Union[int, None]]
    cards_url: str
    created_at: datetime
    id: int
    name: str
    node_id: str
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectColumnDeletedType(TypedDict):
    """project_column deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project_column: WebhookProjectColumnDeletedPropProjectColumnType
    repository: NotRequired[Union[None, RepositoryWebhooksType]]
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookProjectColumnDeletedPropProjectColumnType(TypedDict):
    """Project Column"""

    after_id: NotRequired[Union[int, None]]
    cards_url: str
    created_at: datetime
    id: int
    name: str
    node_id: str
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectColumnEditedType(TypedDict):
    """project_column edited event"""

    action: Literal["edited"]
    changes: WebhookProjectColumnEditedPropChangesType
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project_column: WebhookProjectColumnEditedPropProjectColumnType
    repository: NotRequired[RepositoryWebhooksType]
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookProjectColumnEditedPropChangesType(TypedDict):
    """WebhookProjectColumnEditedPropChanges"""

    name: NotRequired[WebhookProjectColumnEditedPropChangesPropNameType]


class WebhookProjectColumnEditedPropChangesPropNameType(TypedDict):
    """WebhookProjectColumnEditedPropChangesPropName"""

    from_: str


class WebhookProjectColumnEditedPropProjectColumnType(TypedDict):
    """Project Column"""

    after_id: NotRequired[Union[int, None]]
    cards_url: str
    created_at: datetime
    id: int
    name: str
    node_id: str
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectColumnMovedType(TypedDict):
    """project_column moved event"""

    action: Literal["moved"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project_column: WebhookProjectColumnMovedPropProjectColumnType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookProjectColumnMovedPropProjectColumnType(TypedDict):
    """Project Column"""

    after_id: NotRequired[Union[int, None]]
    cards_url: str
    created_at: datetime
    id: int
    name: str
    node_id: str
    project_url: str
    updated_at: datetime
    url: str


class WebhookProjectCreatedType(TypedDict):
    """project created event"""

    action: Literal["created"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project: WebhookProjectCreatedPropProjectType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookProjectCreatedPropProjectType(TypedDict):
    """Project"""

    body: Union[str, None]
    columns_url: str
    created_at: datetime
    creator: Union[WebhookProjectCreatedPropProjectPropCreatorType, None]
    html_url: str
    id: int
    name: str
    node_id: str
    number: int
    owner_url: str
    state: Literal["open", "closed"]
    updated_at: datetime
    url: str


class WebhookProjectCreatedPropProjectPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookProjectDeletedType(TypedDict):
    """project deleted event"""

    action: Literal["deleted"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project: WebhookProjectDeletedPropProjectType
    repository: NotRequired[Union[None, RepositoryWebhooksType]]
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookProjectDeletedPropProjectType(TypedDict):
    """Project"""

    body: Union[str, None]
    columns_url: str
    created_at: datetime
    creator: Union[WebhookProjectDeletedPropProjectPropCreatorType, None]
    html_url: str
    id: int
    name: str
    node_id: str
    number: int
    owner_url: str
    state: Literal["open", "closed"]
    updated_at: datetime
    url: str


class WebhookProjectDeletedPropProjectPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookProjectEditedType(TypedDict):
    """project edited event"""

    action: Literal["edited"]
    changes: NotRequired[WebhookProjectEditedPropChangesType]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project: WebhookProjectEditedPropProjectType
    repository: NotRequired[RepositoryWebhooksType]
    sender: NotRequired[SimpleUserWebhooksType]


class WebhookProjectEditedPropChangesType(TypedDict):
    """WebhookProjectEditedPropChanges

    The changes to the project if the action was `edited`.
    """

    body: NotRequired[WebhookProjectEditedPropChangesPropBodyType]
    name: NotRequired[WebhookProjectEditedPropChangesPropNameType]


class WebhookProjectEditedPropChangesPropBodyType(TypedDict):
    """WebhookProjectEditedPropChangesPropBody"""

    from_: str


class WebhookProjectEditedPropChangesPropNameType(TypedDict):
    """WebhookProjectEditedPropChangesPropName"""

    from_: str


class WebhookProjectEditedPropProjectType(TypedDict):
    """Project"""

    body: Union[str, None]
    columns_url: str
    created_at: datetime
    creator: Union[WebhookProjectEditedPropProjectPropCreatorType, None]
    html_url: str
    id: int
    name: str
    node_id: str
    number: int
    owner_url: str
    state: Literal["open", "closed"]
    updated_at: datetime
    url: str


class WebhookProjectEditedPropProjectPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookProjectReopenedType(TypedDict):
    """project reopened event"""

    action: Literal["reopened"]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    project: WebhookProjectReopenedPropProjectType
    repository: NotRequired[RepositoryWebhooksType]
    sender: SimpleUserWebhooksType


class WebhookProjectReopenedPropProjectType(TypedDict):
    """Project"""

    body: Union[str, None]
    columns_url: str
    created_at: datetime
    creator: Union[WebhookProjectReopenedPropProjectPropCreatorType, None]
    html_url: str
    id: int
    name: str
    node_id: str
    number: int
    owner_url: str
    state: Literal["open", "closed"]
    updated_at: datetime
    url: str


class WebhookProjectReopenedPropProjectPropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookProjectsV2ProjectClosedType(TypedDict):
    """Projects v2 Project Closed Event"""

    action: Literal["closed"]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2: ProjectsV2Type
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ProjectCreatedType(TypedDict):
    """WebhookProjectsV2ProjectCreated

    A project was created
    """

    action: Literal["created"]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2: ProjectsV2Type
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ProjectDeletedType(TypedDict):
    """Projects v2 Project Deleted Event"""

    action: Literal["deleted"]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2: ProjectsV2Type
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ProjectEditedType(TypedDict):
    """Projects v2 Project Edited Event"""

    action: Literal["edited"]
    changes: WebhookProjectsV2ProjectEditedPropChangesType
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2: ProjectsV2Type
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ProjectEditedPropChangesType(TypedDict):
    """WebhookProjectsV2ProjectEditedPropChanges"""

    description: NotRequired[
        WebhookProjectsV2ProjectEditedPropChangesPropDescriptionType
    ]
    public: NotRequired[WebhookProjectsV2ProjectEditedPropChangesPropPublicType]
    short_description: NotRequired[
        WebhookProjectsV2ProjectEditedPropChangesPropShortDescriptionType
    ]
    title: NotRequired[WebhookProjectsV2ProjectEditedPropChangesPropTitleType]


class WebhookProjectsV2ProjectEditedPropChangesPropDescriptionType(TypedDict):
    """WebhookProjectsV2ProjectEditedPropChangesPropDescription"""

    from_: NotRequired[Union[str, None]]
    to: NotRequired[Union[str, None]]


class WebhookProjectsV2ProjectEditedPropChangesPropPublicType(TypedDict):
    """WebhookProjectsV2ProjectEditedPropChangesPropPublic"""

    from_: NotRequired[bool]
    to: NotRequired[bool]


class WebhookProjectsV2ProjectEditedPropChangesPropShortDescriptionType(TypedDict):
    """WebhookProjectsV2ProjectEditedPropChangesPropShortDescription"""

    from_: NotRequired[Union[str, None]]
    to: NotRequired[Union[str, None]]


class WebhookProjectsV2ProjectEditedPropChangesPropTitleType(TypedDict):
    """WebhookProjectsV2ProjectEditedPropChangesPropTitle"""

    from_: NotRequired[str]
    to: NotRequired[str]


class WebhookProjectsV2ItemArchivedType(TypedDict):
    """Projects v2 Item Archived Event"""

    action: Literal["archived"]
    changes: WebhookProjectsV2ItemArchivedPropChangesType
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2_item: ProjectsV2ItemType
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ItemArchivedPropChangesType(TypedDict):
    """WebhookProjectsV2ItemArchivedPropChanges"""

    archived_at: NotRequired[WebhookProjectsV2ItemArchivedPropChangesPropArchivedAtType]


class WebhookProjectsV2ItemArchivedPropChangesPropArchivedAtType(TypedDict):
    """WebhookProjectsV2ItemArchivedPropChangesPropArchivedAt"""

    from_: NotRequired[Union[datetime, None]]
    to: NotRequired[Union[datetime, None]]


class WebhookProjectsV2ItemConvertedType(TypedDict):
    """Projects v2 Item Converted Event"""

    action: Literal["converted"]
    changes: WebhookProjectsV2ItemConvertedPropChangesType
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2_item: ProjectsV2ItemType
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ItemConvertedPropChangesType(TypedDict):
    """WebhookProjectsV2ItemConvertedPropChanges"""

    content_type: NotRequired[
        WebhookProjectsV2ItemConvertedPropChangesPropContentTypeType
    ]


class WebhookProjectsV2ItemConvertedPropChangesPropContentTypeType(TypedDict):
    """WebhookProjectsV2ItemConvertedPropChangesPropContentType"""

    from_: NotRequired[Union[str, None]]
    to: NotRequired[str]


class WebhookProjectsV2ItemCreatedType(TypedDict):
    """Projects v2 Item Created Event"""

    action: Literal["created"]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2_item: ProjectsV2ItemType
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ItemDeletedType(TypedDict):
    """Projects v2 Item Deleted Event"""

    action: Literal["deleted"]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2_item: ProjectsV2ItemType
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ItemEditedType(TypedDict):
    """Projects v2 Item Edited Event"""

    action: Literal["edited"]
    changes: NotRequired[
        Union[
            WebhookProjectsV2ItemEditedPropChangesOneof0Type,
            WebhookProjectsV2ItemEditedPropChangesOneof1Type,
        ]
    ]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2_item: ProjectsV2ItemType
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ItemEditedPropChangesOneof0Type(TypedDict):
    """WebhookProjectsV2ItemEditedPropChangesOneof0"""

    field_value: WebhookProjectsV2ItemEditedPropChangesOneof0PropFieldValueType


class WebhookProjectsV2ItemEditedPropChangesOneof0PropFieldValueType(TypedDict):
    """WebhookProjectsV2ItemEditedPropChangesOneof0PropFieldValue"""

    field_node_id: NotRequired[str]
    field_type: NotRequired[str]


class WebhookProjectsV2ItemEditedPropChangesOneof1Type(TypedDict):
    """WebhookProjectsV2ItemEditedPropChangesOneof1"""

    body: WebhookProjectsV2ItemEditedPropChangesOneof1PropBodyType


class WebhookProjectsV2ItemEditedPropChangesOneof1PropBodyType(TypedDict):
    """WebhookProjectsV2ItemEditedPropChangesOneof1PropBody"""

    from_: NotRequired[Union[str, None]]
    to: NotRequired[Union[str, None]]


class WebhookProjectsV2ItemReorderedType(TypedDict):
    """Projects v2 Item Reordered Event"""

    action: Literal["reordered"]
    changes: WebhookProjectsV2ItemReorderedPropChangesType
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2_item: ProjectsV2ItemType
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ItemReorderedPropChangesType(TypedDict):
    """WebhookProjectsV2ItemReorderedPropChanges"""

    previous_projects_v2_item_node_id: NotRequired[
        WebhookProjectsV2ItemReorderedPropChangesPropPreviousProjectsV2ItemNodeIdType
    ]


class WebhookProjectsV2ItemReorderedPropChangesPropPreviousProjectsV2ItemNodeIdType(
    TypedDict
):
    """WebhookProjectsV2ItemReorderedPropChangesPropPreviousProjectsV2ItemNodeId"""

    from_: NotRequired[Union[str, None]]
    to: NotRequired[Union[str, None]]


class WebhookProjectsV2ItemRestoredType(TypedDict):
    """Projects v2 Item Restored Event"""

    action: Literal["restored"]
    changes: WebhookProjectsV2ItemRestoredPropChangesType
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2_item: ProjectsV2ItemType
    sender: SimpleUserWebhooksType


class WebhookProjectsV2ItemRestoredPropChangesType(TypedDict):
    """WebhookProjectsV2ItemRestoredPropChanges"""

    archived_at: NotRequired[WebhookProjectsV2ItemRestoredPropChangesPropArchivedAtType]


class WebhookProjectsV2ItemRestoredPropChangesPropArchivedAtType(TypedDict):
    """WebhookProjectsV2ItemRestoredPropChangesPropArchivedAt"""

    from_: NotRequired[Union[datetime, None]]
    to: NotRequired[Union[datetime, None]]


class WebhookProjectsV2ProjectReopenedType(TypedDict):
    """Projects v2 Project Reopened Event"""

    action: Literal["reopened"]
    installation: NotRequired[SimpleInstallationType]
    organization: OrganizationSimpleWebhooksType
    projects_v2: ProjectsV2Type
    sender: SimpleUserWebhooksType


class WebhookPublicType(TypedDict):
    """public event"""

    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    organization: NotRequired[OrganizationSimpleWebhooksType]
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookPullRequestAssignedType(TypedDict):
    """pull_request assigned event"""

    action: Literal["assigned"]
    assignee: Union[WebhookPullRequestAssignedPropAssigneeType, None]
    enterprise: NotRequired[EnterpriseWebhooksType]
    installation: NotRequired[SimpleInstallationType]
    number: int
    organization: NotRequired[OrganizationSimpleWebhooksType]
    pull_request: WebhookPullRequestAssignedPropPullRequestType
    repository: RepositoryWebhooksType
    sender: SimpleUserWebhooksType


class WebhookPullRequestAssignedPropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestType(TypedDict):
    """Pull Request"""

    links: WebhookPullRequestAssignedPropPullRequestPropLinksType
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ]
    additions: NotRequired[int]
    assignee: Union[WebhookPullRequestAssignedPropPullRequestPropAssigneeType, None]
    assignees: List[
        Union[WebhookPullRequestAssignedPropPullRequestPropAssigneesItemsType, None]
    ]
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ]
    auto_merge: Union[WebhookPullRequestAssignedPropPullRequestPropAutoMergeType, None]
    base: WebhookPullRequestAssignedPropPullRequestPropBaseType
    body: Union[str, None]
    changed_files: NotRequired[int]
    closed_at: Union[datetime, None]
    comments: NotRequired[int]
    comments_url: str
    commits: NotRequired[int]
    commits_url: str
    created_at: datetime
    deletions: NotRequired[int]
    diff_url: str
    draft: bool
    head: WebhookPullRequestAssignedPropPullRequestPropHeadType
    html_url: str
    id: int
    issue_url: str
    labels: List[WebhookPullRequestAssignedPropPullRequestPropLabelsItemsType]
    locked: bool
    maintainer_can_modify: NotRequired[bool]
    merge_commit_sha: Union[str, None]
    mergeable: NotRequired[Union[bool, None]]
    mergeable_state: NotRequired[str]
    merged: NotRequired[Union[bool, None]]
    merged_at: Union[datetime, None]
    merged_by: NotRequired[
        Union[WebhookPullRequestAssignedPropPullRequestPropMergedByType, None]
    ]
    milestone: Union[WebhookPullRequestAssignedPropPullRequestPropMilestoneType, None]
    node_id: str
    number: int
    patch_url: str
    rebaseable: NotRequired[Union[bool, None]]
    requested_reviewers: List[
        Union[
            WebhookPullRequestAssignedPropPullRequestPropRequestedReviewersItemsOneof0Type,
            None,
            WebhookPullRequestAssignedPropPullRequestPropRequestedReviewersItemsOneof1Type,
        ]
    ]
    requested_teams: List[
        WebhookPullRequestAssignedPropPullRequestPropRequestedTeamsItemsType
    ]
    review_comment_url: str
    review_comments: NotRequired[int]
    review_comments_url: str
    state: Literal["open", "closed"]
    statuses_url: str
    title: str
    updated_at: datetime
    url: str
    user: Union[WebhookPullRequestAssignedPropPullRequestPropUserType, None]


class WebhookPullRequestAssignedPropPullRequestPropLinksType(TypedDict):
    """WebhookPullRequestAssignedPropPullRequestPropLinks"""

    comments: WebhookPullRequestAssignedPropPullRequestPropLinksPropCommentsType
    commits: WebhookPullRequestAssignedPropPullRequestPropLinksPropCommitsType
    html: WebhookPullRequestAssignedPropPullRequestPropLinksPropHtmlType
    issue: WebhookPullRequestAssignedPropPullRequestPropLinksPropIssueType
    review_comment: WebhookPullRequestAssignedPropPullRequestPropLinksPropReviewCommentType
    review_comments: WebhookPullRequestAssignedPropPullRequestPropLinksPropReviewCommentsType
    self_: WebhookPullRequestAssignedPropPullRequestPropLinksPropSelfType
    statuses: WebhookPullRequestAssignedPropPullRequestPropLinksPropStatusesType


class WebhookPullRequestAssignedPropPullRequestPropLinksPropCommentsType(TypedDict):
    """Link"""

    href: str


class WebhookPullRequestAssignedPropPullRequestPropLinksPropCommitsType(TypedDict):
    """Link"""

    href: str


class WebhookPullRequestAssignedPropPullRequestPropLinksPropHtmlType(TypedDict):
    """Link"""

    href: str


class WebhookPullRequestAssignedPropPullRequestPropLinksPropIssueType(TypedDict):
    """Link"""

    href: str


class WebhookPullRequestAssignedPropPullRequestPropLinksPropReviewCommentType(
    TypedDict
):
    """Link"""

    href: str


class WebhookPullRequestAssignedPropPullRequestPropLinksPropReviewCommentsType(
    TypedDict
):
    """Link"""

    href: str


class WebhookPullRequestAssignedPropPullRequestPropLinksPropSelfType(TypedDict):
    """Link"""

    href: str


class WebhookPullRequestAssignedPropPullRequestPropLinksPropStatusesType(TypedDict):
    """Link"""

    href: str


class WebhookPullRequestAssignedPropPullRequestPropAssigneeType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestPropAssigneesItemsType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestPropAutoMergePropEnabledByType(
    TypedDict
):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestPropAutoMergeType(TypedDict):
    """PullRequestAutoMerge

    The status of auto merging a pull request.
    """

    commit_message: Union[str, None]
    commit_title: Union[str, None]
    enabled_by: Union[
        WebhookPullRequestAssignedPropPullRequestPropAutoMergePropEnabledByType, None
    ]
    merge_method: Literal["merge", "squash", "rebase"]


class WebhookPullRequestAssignedPropPullRequestPropBaseType(TypedDict):
    """WebhookPullRequestAssignedPropPullRequestPropBase"""

    label: str
    ref: str
    repo: WebhookPullRequestAssignedPropPullRequestPropBasePropRepoType
    sha: str
    user: Union[WebhookPullRequestAssignedPropPullRequestPropBasePropUserType, None]


class WebhookPullRequestAssignedPropPullRequestPropBasePropRepoType(TypedDict):
    """Repository

    A git repository
    """

    allow_auto_merge: NotRequired[bool]
    allow_forking: NotRequired[bool]
    allow_merge_commit: NotRequired[bool]
    allow_rebase_merge: NotRequired[bool]
    allow_squash_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    archive_url: str
    archived: bool
    assignees_url: str
    blobs_url: str
    branches_url: str
    clone_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    created_at: Union[int, datetime]
    default_branch: str
    delete_branch_on_merge: NotRequired[bool]
    deployments_url: str
    description: Union[str, None]
    disabled: NotRequired[bool]
    downloads_url: str
    events_url: str
    fork: bool
    forks: int
    forks_count: int
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    has_downloads: bool
    has_issues: bool
    has_pages: bool
    has_projects: bool
    has_wiki: bool
    has_discussions: bool
    homepage: Union[str, None]
    hooks_url: str
    html_url: str
    id: int
    is_template: NotRequired[bool]
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    language: Union[str, None]
    languages_url: str
    license_: Union[
        WebhookPullRequestAssignedPropPullRequestPropBasePropRepoPropLicenseType, None
    ]
    master_branch: NotRequired[str]
    merge_commit_message: NotRequired[Literal["PR_BODY", "PR_TITLE", "BLANK"]]
    merge_commit_title: NotRequired[Literal["PR_TITLE", "MERGE_MESSAGE"]]
    merges_url: str
    milestones_url: str
    mirror_url: Union[str, None]
    name: str
    node_id: str
    notifications_url: str
    open_issues: int
    open_issues_count: int
    organization: NotRequired[str]
    owner: Union[
        WebhookPullRequestAssignedPropPullRequestPropBasePropRepoPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookPullRequestAssignedPropPullRequestPropBasePropRepoPropPermissionsType
    ]
    private: bool
    public: NotRequired[bool]
    pulls_url: str
    pushed_at: Union[int, datetime, None]
    releases_url: str
    role_name: NotRequired[Union[str, None]]
    size: int
    squash_merge_commit_message: NotRequired[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ]
    squash_merge_commit_title: NotRequired[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]]
    ssh_url: str
    stargazers: NotRequired[int]
    stargazers_count: int
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    svn_url: str
    tags_url: str
    teams_url: str
    topics: List[str]
    trees_url: str
    updated_at: datetime
    url: str
    use_squash_pr_title_as_default: NotRequired[bool]
    visibility: Literal["public", "private", "internal"]
    watchers: int
    watchers_count: int
    web_commit_signoff_required: NotRequired[bool]


class WebhookPullRequestAssignedPropPullRequestPropBasePropRepoPropLicenseType(
    TypedDict
):
    """License"""

    key: str
    name: str
    node_id: str
    spdx_id: str
    url: Union[str, None]


class WebhookPullRequestAssignedPropPullRequestPropBasePropRepoPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestPropBasePropRepoPropPermissionsType(
    TypedDict
):
    """WebhookPullRequestAssignedPropPullRequestPropBasePropRepoPropPermissions"""

    admin: bool
    maintain: NotRequired[bool]
    pull: bool
    push: bool
    triage: NotRequired[bool]


class WebhookPullRequestAssignedPropPullRequestPropBasePropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestPropHeadType(TypedDict):
    """WebhookPullRequestAssignedPropPullRequestPropHead"""

    label: Union[str, None]
    ref: str
    repo: Union[WebhookPullRequestAssignedPropPullRequestPropHeadPropRepoType, None]
    sha: str
    user: Union[WebhookPullRequestAssignedPropPullRequestPropHeadPropUserType, None]


class WebhookPullRequestAssignedPropPullRequestPropHeadPropRepoPropLicenseType(
    TypedDict
):
    """License"""

    key: str
    name: str
    node_id: str
    spdx_id: str
    url: Union[str, None]


class WebhookPullRequestAssignedPropPullRequestPropHeadPropRepoPropOwnerType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestPropHeadPropRepoPropPermissionsType(
    TypedDict
):
    """WebhookPullRequestAssignedPropPullRequestPropHeadPropRepoPropPermissions"""

    admin: bool
    maintain: NotRequired[bool]
    pull: bool
    push: bool
    triage: NotRequired[bool]


class WebhookPullRequestAssignedPropPullRequestPropHeadPropRepoType(TypedDict):
    """Repository

    A git repository
    """

    allow_auto_merge: NotRequired[bool]
    allow_forking: NotRequired[bool]
    allow_merge_commit: NotRequired[bool]
    allow_rebase_merge: NotRequired[bool]
    allow_squash_merge: NotRequired[bool]
    allow_update_branch: NotRequired[bool]
    archive_url: str
    archived: bool
    assignees_url: str
    blobs_url: str
    branches_url: str
    clone_url: str
    collaborators_url: str
    comments_url: str
    commits_url: str
    compare_url: str
    contents_url: str
    contributors_url: str
    created_at: Union[int, datetime]
    default_branch: str
    delete_branch_on_merge: NotRequired[bool]
    deployments_url: str
    description: Union[str, None]
    disabled: NotRequired[bool]
    downloads_url: str
    events_url: str
    fork: bool
    forks: int
    forks_count: int
    forks_url: str
    full_name: str
    git_commits_url: str
    git_refs_url: str
    git_tags_url: str
    git_url: str
    has_downloads: bool
    has_issues: bool
    has_pages: bool
    has_projects: bool
    has_wiki: bool
    has_discussions: bool
    homepage: Union[str, None]
    hooks_url: str
    html_url: str
    id: int
    is_template: NotRequired[bool]
    issue_comment_url: str
    issue_events_url: str
    issues_url: str
    keys_url: str
    labels_url: str
    language: Union[str, None]
    languages_url: str
    license_: Union[
        WebhookPullRequestAssignedPropPullRequestPropHeadPropRepoPropLicenseType, None
    ]
    master_branch: NotRequired[str]
    merge_commit_message: NotRequired[Literal["PR_BODY", "PR_TITLE", "BLANK"]]
    merge_commit_title: NotRequired[Literal["PR_TITLE", "MERGE_MESSAGE"]]
    merges_url: str
    milestones_url: str
    mirror_url: Union[str, None]
    name: str
    node_id: str
    notifications_url: str
    open_issues: int
    open_issues_count: int
    organization: NotRequired[str]
    owner: Union[
        WebhookPullRequestAssignedPropPullRequestPropHeadPropRepoPropOwnerType, None
    ]
    permissions: NotRequired[
        WebhookPullRequestAssignedPropPullRequestPropHeadPropRepoPropPermissionsType
    ]
    private: bool
    public: NotRequired[bool]
    pulls_url: str
    pushed_at: Union[int, datetime, None]
    releases_url: str
    role_name: NotRequired[Union[str, None]]
    size: int
    squash_merge_commit_message: NotRequired[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ]
    squash_merge_commit_title: NotRequired[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]]
    ssh_url: str
    stargazers: NotRequired[int]
    stargazers_count: int
    stargazers_url: str
    statuses_url: str
    subscribers_url: str
    subscription_url: str
    svn_url: str
    tags_url: str
    teams_url: str
    topics: List[str]
    trees_url: str
    updated_at: datetime
    url: str
    use_squash_pr_title_as_default: NotRequired[bool]
    visibility: Literal["public", "private", "internal"]
    watchers: int
    watchers_count: int
    web_commit_signoff_required: NotRequired[bool]


class WebhookPullRequestAssignedPropPullRequestPropHeadPropUserType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestPropLabelsItemsType(TypedDict):
    """Label"""

    color: str
    default: bool
    description: Union[str, None]
    id: int
    name: str
    node_id: str
    url: str


class WebhookPullRequestAssignedPropPullRequestPropMergedByType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestPropMilestonePropCreatorType(TypedDict):
    """User"""

    avatar_url: NotRequired[str]
    deleted: NotRequired[bool]
    email: NotRequired[Union[str, None]]
    events_url: NotRequired[str]
    followers_url: NotRequired[str]
    following_url: NotRequired[str]
    gists_url: NotRequired[str]
    gravatar_id: NotRequired[str]
    html_url: NotRequired[str]
    id: int
    login: str
    name: NotRequired[str]
    node_id: NotRequired[str]
    organizations_url: NotRequired[str]
    received_events_url: NotRequired[str]
    repos_url: NotRequired[str]
    site_admin: NotRequired[bool]
    starred_url: NotRequired[str]
    subscriptions_url: NotRequired[str]
    type: NotRequired[Literal["Bot", "User", "Organization", "Mannequin"]]
    url: NotRequired[str]


class WebhookPullRequestAssignedPropPullRequestPropMilestoneType(TypedDict):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[dateti