"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from __future__ import annotations

from datetime import datetime
from typing import List, Union

from pydantic import Field

from githubkit.utils import UNSET
from githubkit.typing import Missing
from githubkit.compat import GitHubModel, model_rebuild

from .group_0243 import HookResponse


class Hook(GitHubModel):
    """Webhook

    Webhooks for repositories.
    """

    type: str = Field()
    id: int = Field(description="Unique identifier of the webhook.")
    name: str = Field(
        description="The name of a valid service, use 'web' for a webhook."
    )
    active: bool = Field(
        description="Determines whether the hook is actually triggered on pushes."
    )
    events: List[str] = Field(
        description="Determines what events the hook is triggered for. Default: ['push']."
    )
    config: HookPropConfig = Field()
    updated_at: datetime = Field()
    created_at: datetime = Field()
    url: str = Field()
    test_url: str = Field()
    ping_url: str = Field()
    deliveries_url: Missing[str] = Field(default=UNSET)
    last_response: HookResponse = Field(title="Hook Response")


class HookPropConfig(GitHubModel):
    """HookPropConfig"""

    email: Missing[str] = Field(default=UNSET)
    password: Missing[str] = Field(default=UNSET)
    room: Missing[str] = Field(default=UNSET)
    subdomain: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(
        default=UNSET, description="The URL to which the payloads will be delivered."
    )
    insecure_ssl: Missing[Union[str, float]] = Field(default=UNSET)
    content_type: Missing[str] = Field(
        default=UNSET,
        description="The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.",
    )
    digest: Missing[str] = Field(default=UNSET)
    secret: Missing[str] = Field(
        default=UNSET,
        description="If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).",
    )
    token: Missing[str] = Field(default=UNSET)


model_rebuild(Hook)
model_rebuild(HookPropConfig)

__all__ = (
    "Hook",
    "HookPropConfig",
)
