"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from __future__ import annotations

from datetime import datetime
from typing import List, Union

from pydantic import Field

from githubkit.utils import UNSET
from githubkit.typing import Missing
from githubkit.compat import GitHubModel, ExtraGitHubModel, model_rebuild

from .group_0001 import SimpleUser
from .group_0005 import Integration


class Deployment(GitHubModel):
    """Deployment

    A request for a specific ref(branch,sha,tag) to be deployed
    """

    url: str = Field()
    id: int = Field(description="Unique identifier of the deployment")
    node_id: str = Field()
    sha: str = Field()
    ref: str = Field(
        description="The ref to deploy. This can be a branch, tag, or sha."
    )
    task: str = Field(description="Parameter to specify a task to execute")
    payload: Union[DeploymentPropPayloadOneof0, str] = Field()
    original_environment: Missing[str] = Field(default=UNSET)
    environment: str = Field(description="Name for the target deployment environment.")
    description: Union[str, None] = Field()
    creator: Union[None, SimpleUser] = Field()
    created_at: datetime = Field()
    updated_at: datetime = Field()
    statuses_url: str = Field()
    repository_url: str = Field()
    transient_environment: Missing[bool] = Field(
        default=UNSET,
        description="Specifies if the given environment is will no longer exist at some point in the future. Default: false.",
    )
    production_environment: Missing[bool] = Field(
        default=UNSET,
        description="Specifies if the given environment is one that end-users directly interact with. Default: false.",
    )
    performed_via_github_app: Missing[Union[None, Integration]] = Field(default=UNSET)


class DeploymentPropPayloadOneof0(ExtraGitHubModel):
    """DeploymentPropPayloadOneof0"""


model_rebuild(Deployment)
model_rebuild(DeploymentPropPayloadOneof0)

__all__ = (
    "Deployment",
    "DeploymentPropPayloadOneof0",
)
