"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""


from __future__ import annotations

from weakref import ref
from typing_extensions import Annotated
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import Field, BaseModel

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from typing import List, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import Package, PackageVersion


class PackagesClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_docker_migration_conflicting_packages_for_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package, BasicError

        url = f"/orgs/{org}/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_docker_migration_conflicting_packages_for_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package, BasicError

        url = f"/orgs/{org}/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_packages_for_organization(
        self,
        org: str,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package, BasicError

        url = f"/orgs/{org}/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_packages_for_organization(
        self,
        org: str,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package, BasicError

        url = f"/orgs/{org}/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_for_organization(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Package]:
        from ..models import Package

        url = f"/orgs/{org}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    async def async_get_package_for_organization(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Package]:
        from ..models import Package

        url = f"/orgs/{org}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    def delete_package_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        token: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        token: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_all_package_versions_for_package_owned_by_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PackageVersion]]:
        from typing import List

        from ..models import BasicError, PackageVersion

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions"

        params = {
            "page": page,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_all_package_versions_for_package_owned_by_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PackageVersion]]:
        from typing import List

        from ..models import BasicError, PackageVersion

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions"

        params = {
            "page": page,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_version_for_organization(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackageVersion]:
        from ..models import PackageVersion

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    async def async_get_package_version_for_organization(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackageVersion]:
        from ..models import PackageVersion

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    def delete_package_version_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_version_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_version_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_version_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_docker_migration_conflicting_packages_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package

        url = "/user/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Package],
        )

    async def async_list_docker_migration_conflicting_packages_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package

        url = "/user/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Package],
        )

    def list_packages_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package

        url = "/user/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={},
        )

    async def async_list_packages_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package

        url = "/user/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={},
        )

    def get_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Package]:
        from ..models import Package

        url = f"/user/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    async def async_get_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Package]:
        from ..models import Package

        url = f"/user/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    def delete_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        token: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        token: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_all_package_versions_for_package_owned_by_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PackageVersion]]:
        from typing import List

        from ..models import BasicError, PackageVersion

        url = f"/user/packages/{package_type}/{package_name}/versions"

        params = {
            "page": page,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_all_package_versions_for_package_owned_by_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PackageVersion]]:
        from typing import List

        from ..models import BasicError, PackageVersion

        url = f"/user/packages/{package_type}/{package_name}/versions"

        params = {
            "page": page,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackageVersion]:
        from ..models import PackageVersion

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    async def async_get_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackageVersion]:
        from ..models import PackageVersion

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    def delete_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_docker_migration_conflicting_packages_for_user(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package, BasicError

        url = f"/users/{username}/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_docker_migration_conflicting_packages_for_user(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package, BasicError

        url = f"/users/{username}/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_packages_for_user(
        self,
        username: str,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package, BasicError

        url = f"/users/{username}/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_packages_for_user(
        self,
        username: str,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Package]]:
        from typing import List

        from ..models import Package, BasicError

        url = f"/users/{username}/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Package]:
        from ..models import Package

        url = f"/users/{username}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    async def async_get_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Package]:
        from ..models import Package

        url = f"/users/{username}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    def delete_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        token: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        token: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_all_package_versions_for_package_owned_by_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PackageVersion]]:
        from typing import List

        from ..models import BasicError, PackageVersion

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_all_package_versions_for_package_owned_by_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PackageVersion]]:
        from typing import List

        from ..models import BasicError, PackageVersion

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackageVersion]:
        from ..models import PackageVersion

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    async def async_get_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackageVersion]:
        from ..models import PackageVersion

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    def delete_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        package_version_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )
