"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel

from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import (
        Team,
        TeamFull,
        SimpleUser,
        TeamProject,
        GroupMapping,
        ExternalGroup,
        ExternalGroups,
        TeamDiscussion,
        TeamMembership,
        TeamRepository,
        MinimalRepository,
        TeamDiscussionComment,
        OrganizationInvitation,
    )
    from ..types import (
        OrgsOrgTeamsPostBodyType,
        TeamsTeamIdPatchBodyType,
        OrgsOrgTeamsTeamSlugPatchBodyType,
        TeamsTeamIdDiscussionsPostBodyType,
        TeamsTeamIdReposOwnerRepoPutBodyType,
        TeamsTeamIdProjectsProjectIdPutBodyType,
        TeamsTeamIdMembershipsUsernamePutBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
        OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType,
        TeamsTeamIdTeamSyncGroupMappingsPatchBodyType,
        OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType,
        OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType,
        OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType,
        OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType,
        TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
        OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType,
        TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    )


class TeamsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def external_idp_group_info_for_org(
        self,
        org: str,
        group_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ExternalGroup]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#get-an-external-group"""

        from ..models import ExternalGroup

        url = f"/orgs/{org}/external-group/{group_id}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExternalGroup,
        )

    async def async_external_idp_group_info_for_org(
        self,
        org: str,
        group_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ExternalGroup]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#get-an-external-group"""

        from ..models import ExternalGroup

        url = f"/orgs/{org}/external-group/{group_id}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExternalGroup,
        )

    def list_external_idp_groups_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ExternalGroups]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#list-external-groups-in-an-organization"""

        from ..models import ExternalGroups

        url = f"/orgs/{org}/external-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "display_name": display_name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExternalGroups,
        )

    async def async_list_external_idp_groups_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ExternalGroups]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#list-external-groups-in-an-organization"""

        from ..models import ExternalGroups

        url = f"/orgs/{org}/external-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "display_name": display_name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExternalGroups,
        )

    def list_idp_groups_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[str] = UNSET,
        q: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-an-organization"""

        from ..models import GroupMapping

        url = f"/orgs/{org}/team-sync/groups"

        params = {
            "per_page": per_page,
            "page": page,
            "q": q,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    async def async_list_idp_groups_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[str] = UNSET,
        q: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-an-organization"""

        from ..models import GroupMapping

        url = f"/orgs/{org}/team-sync/groups"

        params = {
            "per_page": per_page,
            "page": page,
            "q": q,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    def list(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-teams"""

        from typing import List

        from ..models import Team, BasicError

        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "403": BasicError,
            },
        )

    async def async_list(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-teams"""

        from typing import List

        from ..models import Team, BasicError

        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def create(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsPostBodyType,
    ) -> Response[TeamFull]: ...

    @overload
    def create(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        maintainers: Missing[List[str]] = UNSET,
        repo_names: Missing[List[str]] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push"]] = UNSET,
        parent_team_id: Missing[int] = UNSET,
    ) -> Response[TeamFull]: ...

    def create(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#create-a-team"""

        from ..models import TeamFull, BasicError, ValidationError, OrgsOrgTeamsPostBody

        url = f"/orgs/{org}/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsPostBodyType,
    ) -> Response[TeamFull]: ...

    @overload
    async def async_create(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        maintainers: Missing[List[str]] = UNSET,
        repo_names: Missing[List[str]] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push"]] = UNSET,
        parent_team_id: Missing[int] = UNSET,
    ) -> Response[TeamFull]: ...

    async def async_create(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#create-a-team"""

        from ..models import TeamFull, BasicError, ValidationError, OrgsOrgTeamsPostBody

        url = f"/orgs/{org}/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_by_name(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-by-name"""

        from ..models import TeamFull, BasicError

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_name(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-by-name"""

        from ..models import TeamFull, BasicError

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
    ) -> Response[TeamFull]: ...

    @overload
    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull]: ...

    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team"""

        from ..models import (
            TeamFull,
            BasicError,
            ValidationError,
            OrgsOrgTeamsTeamSlugPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsTeamSlugPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
    ) -> Response[TeamFull]: ...

    @overload
    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull]: ...

    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team"""

        from ..models import (
            TeamFull,
            BasicError,
            ValidationError,
            OrgsOrgTeamsTeamSlugPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsTeamSlugPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        pinned: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamDiscussion]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions"""

        from typing import List

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussion],
        )

    async def async_list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        pinned: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamDiscussion]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions"""

        from typing import List

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussion],
        )

    @overload
    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion]: ...

    @overload
    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion"""

        from ..models import TeamDiscussion, OrgsOrgTeamsTeamSlugDiscussionsPostBody

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsTeamSlugDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion]: ...

    @overload
    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion"""

        from ..models import TeamDiscussion, OrgsOrgTeamsTeamSlugDiscussionsPostBody

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsTeamSlugDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion"""

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion"""

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    @overload
    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion"""

        from ..models import (
            TeamDiscussion,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    @overload
    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion"""

        from ..models import (
            TeamDiscussion,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamDiscussionComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments"""

        from typing import List

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamDiscussionComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments"""

        from typing import List

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussionComment],
        )

    @overload
    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment]: ...

    @overload
    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment]: ...

    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment"""

        from ..models import (
            TeamDiscussionComment,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment]: ...

    @overload
    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment]: ...

    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment"""

        from ..models import (
            TeamDiscussionComment,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment"""

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment"""

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment]: ...

    @overload
    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment]: ...

    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment"""

        from ..models import (
            TeamDiscussionComment,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment]: ...

    @overload
    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment]: ...

    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment"""

        from ..models import (
            TeamDiscussionComment,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def list_linked_external_idp_groups_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ExternalGroups]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#list-a-connection-between-an-external-group-and-a-team"""

        from ..models import ExternalGroups

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ExternalGroups,
        )

    async def async_list_linked_external_idp_groups_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ExternalGroups]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#list-a-connection-between-an-external-group-and-a-team"""

        from ..models import ExternalGroups

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ExternalGroups,
        )

    def unlink_external_idp_group_from_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#remove-the-connection-between-an-external-group-and-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_unlink_external_idp_group_from_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#remove-the-connection-between-an-external-group-and-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType,
    ) -> Response[ExternalGroup]: ...

    @overload
    def link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        group_id: int,
    ) -> Response[ExternalGroup]: ...

    def link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ExternalGroup]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#update-the-connection-between-an-external-group-and-a-team"""

        from ..models import ExternalGroup, OrgsOrgTeamsTeamSlugExternalGroupsPatchBody

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsTeamSlugExternalGroupsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ExternalGroup,
        )

    @overload
    async def async_link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType,
    ) -> Response[ExternalGroup]: ...

    @overload
    async def async_link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        group_id: int,
    ) -> Response[ExternalGroup]: ...

    async def async_link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ExternalGroup]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#update-the-connection-between-an-external-group-and-a-team"""

        from ..models import ExternalGroup, OrgsOrgTeamsTeamSlugExternalGroupsPatchBody

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsTeamSlugExternalGroupsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ExternalGroup,
        )

    def list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationInvitation]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations"""

        from typing import List

        from ..models import OrganizationInvitation

        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
        )

    async def async_list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationInvitation]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations"""

        from typing import List

        from ..models import OrganizationInvitation

        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
        )

    def list_members_in_org(
        self,
        org: str,
        team_slug: str,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members"""

        from typing import List

        from ..models import SimpleUser

        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_members_in_org(
        self,
        org: str,
        team_slug: str,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members"""

        from typing import List

        from ..models import SimpleUser

        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamMembership]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user"""

        from ..models import TeamMembership

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    async def async_get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamMembership]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user"""

        from ..models import TeamMembership

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    @overload
    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership]: ...

    @overload
    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership]: ...

    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user"""

        from ..models import (
            TeamMembership,
            OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    @overload
    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership]: ...

    @overload
    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership]: ...

    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user"""

        from ..models import (
            TeamMembership,
            OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    def remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user"""

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user"""

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamProject]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-projects"""

        from typing import List

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamProject],
        )

    async def async_list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamProject]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-projects"""

        from typing import List

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamProject],
        )

    def check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamProject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-project"""

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamProject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-project"""

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    @overload
    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-project-permissions"""

        from typing import Union

        from ..models import (
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody,
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
        )

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody, None], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    @overload
    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-project-permissions"""

        from typing import Union

        from ..models import (
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody,
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
        )

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody, None], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    def remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-project-from-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-project-from-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories"""

        from typing import List

        from ..models import MinimalRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    async def async_list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories"""

        from typing import List

        from ..models import MinimalRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    def check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository"""

        from ..models import TeamRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository"""

        from ..models import TeamRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    @overload
    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response: ...

    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions"""

        from ..models import OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions"""

        from ..models import OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_idp_groups_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team"""

        from ..models import GroupMapping

        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    async def async_list_idp_groups_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team"""

        from ..models import GroupMapping

        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    @overload
    def create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType,
    ) -> Response[GroupMapping]: ...

    @overload
    def create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        groups: Missing[
            List[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType]
        ] = UNSET,
    ) -> Response[GroupMapping]: ...

    def create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections"""

        from ..models import (
            GroupMapping,
            OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    @overload
    async def async_create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType,
    ) -> Response[GroupMapping]: ...

    @overload
    async def async_create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        groups: Missing[
            List[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType]
        ] = UNSET,
    ) -> Response[GroupMapping]: ...

    async def async_create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections"""

        from ..models import (
            GroupMapping,
            OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    def list_child_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams"""

        from typing import List

        from ..models import Team

        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
        )

    async def async_list_child_in_org(
        self,
        org: str,
        team_slug: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams"""

        from typing import List

        from ..models import Team

        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
        )

    def get_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-legacy"""

        from ..models import TeamFull, BasicError

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-legacy"""

        from ..models import TeamFull, BasicError

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team-legacy"""

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_delete_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team-legacy"""

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdPatchBodyType,
    ) -> Response[TeamFull]: ...

    @overload
    def update_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull]: ...

    def update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team-legacy"""

        from ..models import TeamFull, BasicError, ValidationError, TeamsTeamIdPatchBody

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdPatchBodyType,
    ) -> Response[TeamFull]: ...

    @overload
    async def async_update_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull]: ...

    async def async_update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team-legacy"""

        from ..models import TeamFull, BasicError, ValidationError, TeamsTeamIdPatchBody

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_discussions_legacy(
        self,
        team_id: int,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamDiscussion]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions-legacy"""

        from typing import List

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussion],
        )

    async def async_list_discussions_legacy(
        self,
        team_id: int,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamDiscussion]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions-legacy"""

        from typing import List

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussion],
        )

    @overload
    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion]: ...

    @overload
    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion-legacy"""

        from ..models import TeamDiscussion, TeamsTeamIdDiscussionsPostBody

        url = f"/teams/{team_id}/discussions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion]: ...

    @overload
    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion-legacy"""

        from ..models import TeamDiscussion, TeamsTeamIdDiscussionsPostBody

        url = f"/teams/{team_id}/discussions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion-legacy"""

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion-legacy"""

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion-legacy"""

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion-legacy"""

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    @overload
    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion-legacy"""

        from ..models import (
            TeamDiscussion,
            TeamsTeamIdDiscussionsDiscussionNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            TeamsTeamIdDiscussionsDiscussionNumberPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    @overload
    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion]: ...

    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion-legacy"""

        from ..models import (
            TeamDiscussion,
            TeamsTeamIdDiscussionsDiscussionNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            TeamsTeamIdDiscussionsDiscussionNumberPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamDiscussionComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments-legacy"""

        from typing import List

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamDiscussionComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments-legacy"""

        from typing import List

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamDiscussionComment],
        )

    @overload
    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment]: ...

    @overload
    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment]: ...

    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment-legacy"""

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment]: ...

    @overload
    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment]: ...

    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment-legacy"""

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment-legacy"""

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment-legacy"""

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment-legacy"""

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment-legacy"""

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment]: ...

    @overload
    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment]: ...

    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment-legacy"""

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment]: ...

    @overload
    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment]: ...

    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment-legacy"""

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def list_pending_invitations_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationInvitation]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations-legacy"""

        from typing import List

        from ..models import OrganizationInvitation

        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
        )

    async def async_list_pending_invitations_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationInvitation]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations-legacy"""

        from typing import List

        from ..models import OrganizationInvitation

        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
        )

    def list_members_legacy(
        self,
        team_id: int,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members-legacy"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_members_legacy(
        self,
        team_id: int,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members-legacy"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    def get_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-member-legacy"""

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_get_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-member-legacy"""

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def add_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-team-member-legacy"""

        from ..models import BasicError

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_add_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-team-member-legacy"""

        from ..models import BasicError

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def remove_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-member-legacy"""

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-member-legacy"""

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamMembership]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user-legacy"""

        from ..models import BasicError, TeamMembership

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamMembership]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user-legacy"""

        from ..models import BasicError, TeamMembership

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership]: ...

    @overload
    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership]: ...

    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user-legacy"""

        from ..models import (
            BasicError,
            TeamMembership,
            TeamsTeamIdMembershipsUsernamePutBody,
        )

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership]: ...

    @overload
    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership]: ...

    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user-legacy"""

        from ..models import (
            BasicError,
            TeamMembership,
            TeamsTeamIdMembershipsUsernamePutBody,
        )

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    def remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user-legacy"""

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user-legacy"""

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_projects_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamProject]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-projects-legacy"""

        from typing import List

        from ..models import BasicError, TeamProject

        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_projects_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamProject]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-projects-legacy"""

        from typing import List

        from ..models import BasicError, TeamProject

        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamProject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-project-legacy"""

        from ..models import TeamProject

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamProject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-project-legacy"""

        from ..models import TeamProject

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    @overload
    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-project-permissions-legacy"""

        from ..models import (
            BasicError,
            ValidationError,
            TeamsTeamIdProjectsProjectIdPutBody,
            TeamsTeamIdProjectsProjectIdPutResponse403,
        )

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdProjectsProjectIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-project-permissions-legacy"""

        from ..models import (
            BasicError,
            ValidationError,
            TeamsTeamIdProjectsProjectIdPutBody,
            TeamsTeamIdProjectsProjectIdPutResponse403,
        )

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdProjectsProjectIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-project-from-a-team-legacy"""

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-project-from-a-team-legacy"""

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_repos_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories-legacy"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories-legacy"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository-legacy"""

        from ..models import TeamRepository

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[TeamRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository-legacy"""

        from ..models import TeamRepository

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    @overload
    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
    ) -> Response: ...

    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions-legacy"""

        from ..models import (
            BasicError,
            ValidationError,
            TeamsTeamIdReposOwnerRepoPutBody,
        )

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions-legacy"""

        from ..models import (
            BasicError,
            ValidationError,
            TeamsTeamIdReposOwnerRepoPutBody,
        )

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team-legacy"""

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team-legacy"""

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_idp_groups_for_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team-legacy"""

        from ..models import BasicError, GroupMapping

        url = f"/teams/{team_id}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GroupMapping,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_idp_groups_for_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team-legacy"""

        from ..models import BasicError, GroupMapping

        url = f"/teams/{team_id}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GroupMapping,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdTeamSyncGroupMappingsPatchBodyType,
    ) -> Response[GroupMapping]: ...

    @overload
    def create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        groups: List[TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType],
        synced_at: Missing[str] = UNSET,
    ) -> Response[GroupMapping]: ...

    def create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdTeamSyncGroupMappingsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections-legacy"""

        from ..models import (
            BasicError,
            GroupMapping,
            ValidationError,
            TeamsTeamIdTeamSyncGroupMappingsPatchBody,
        )

        url = f"/teams/{team_id}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdTeamSyncGroupMappingsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdTeamSyncGroupMappingsPatchBodyType,
    ) -> Response[GroupMapping]: ...

    @overload
    async def async_create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        groups: List[TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType],
        synced_at: Missing[str] = UNSET,
    ) -> Response[GroupMapping]: ...

    async def async_create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[TeamsTeamIdTeamSyncGroupMappingsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GroupMapping]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections-legacy"""

        from ..models import (
            BasicError,
            GroupMapping,
            ValidationError,
            TeamsTeamIdTeamSyncGroupMappingsPatchBody,
        )

        url = f"/teams/{team_id}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(TeamsTeamIdTeamSyncGroupMappingsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_child_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams-legacy"""

        from typing import List

        from ..models import Team, BasicError, ValidationError

        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_child_legacy(
        self,
        team_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams-legacy"""

        from typing import List

        from ..models import Team, BasicError, ValidationError

        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamFull]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-teams-for-the-authenticated-user"""

        from typing import List

        from ..models import TeamFull, BasicError

        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamFull]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-teams-for-the-authenticated-user"""

        from typing import List

        from ..models import TeamFull, BasicError

        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )
