"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel

from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..types import (
        SelectedActionsType,
        ReviewCustomGatesStateRequiredType,
        OrgsOrgActionsVariablesPostBodyType,
        OrgsOrgActionsPermissionsPutBodyType,
        ReviewCustomGatesCommentRequiredType,
        ActionsWorkflowAccessToRepositoryType,
        OrgsOrgActionsRunnerGroupsPostBodyType,
        ActionsSetDefaultWorkflowPermissionsType,
        OrgsOrgActionsVariablesNamePatchBodyType,
        OrgsOrgActionsSecretsSecretNamePutBodyType,
        ReposOwnerRepoActionsVariablesPostBodyType,
        ReposOwnerRepoActionsPermissionsPutBodyType,
        ActionsOidcCustomIssuerPolicyForEnterpriseType,
        OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
        OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
        ReposOwnerRepoActionsJobsJobIdRerunPostBodyType,
        ReposOwnerRepoActionsRunsRunIdRerunPostBodyType,
        ReposOwnerRepoActionsVariablesNamePatchBodyType,
        OrgsOrgActionsPermissionsRepositoriesPutBodyType,
        ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
        OrgsOrgActionsRunnersGenerateJitconfigPostBodyType,
        OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType,
        ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
        ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
        OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
        ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
        ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType,
        ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType,
        ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType,
        ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
        ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType,
    )
    from ..models import (
        Job,
        Runner,
        Artifact,
        Workflow,
        Deployment,
        EmptyObject,
        WorkflowRun,
        ActionsSecret,
        WorkflowUsage,
        ActionsVariable,
        RunnerGroupsOrg,
        SelectedActions,
        ActionsCacheList,
        ActionsPublicKey,
        WorkflowRunUsage,
        OidcCustomSubRepo,
        PendingDeployment,
        RunnerApplication,
        AuthenticationToken,
        EnvironmentApprovals,
        OrganizationActionsSecret,
        OrganizationActionsVariable,
        ActionsRepositoryPermissions,
        ActionsCacheUsageByRepository,
        ActionsCacheUsageOrgEnterprise,
        ActionsOrganizationPermissions,
        ActionsWorkflowAccessToRepository,
        OrgsOrgActionsRunnersGetResponse200,
        OrgsOrgActionsSecretsGetResponse200,
        ActionsGetDefaultWorkflowPermissions,
        OrgsOrgActionsVariablesGetResponse200,
        ReposOwnerRepoActionsRunsGetResponse200,
        OrgsOrgActionsRunnerGroupsGetResponse200,
        ReposOwnerRepoActionsRunnersGetResponse200,
        ReposOwnerRepoActionsSecretsGetResponse200,
        ReposOwnerRepoActionsArtifactsGetResponse200,
        ReposOwnerRepoActionsVariablesGetResponse200,
        ReposOwnerRepoActionsWorkflowsGetResponse200,
        ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
        ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
    )


class ActionsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_actions_cache_usage_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheUsageOrgEnterprise]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-an-enterprise"""

        from ..models import ActionsCacheUsageOrgEnterprise

        url = f"/enterprises/{enterprise}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    async def async_get_actions_cache_usage_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheUsageOrgEnterprise]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-an-enterprise"""

        from ..models import ActionsCacheUsageOrgEnterprise

        url = f"/enterprises/{enterprise}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    @overload
    def set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsOidcCustomIssuerPolicyForEnterpriseType,
    ) -> Response: ...

    @overload
    def set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        include_enterprise_slug: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsOidcCustomIssuerPolicyForEnterpriseType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#set-the-github-actions-oidc-custom-issuer-policy-for-an-enterprise"""

        from ..models import ActionsOidcCustomIssuerPolicyForEnterprise

        url = f"/enterprises/{enterprise}/actions/oidc/customization/issuer"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ActionsOidcCustomIssuerPolicyForEnterprise, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsOidcCustomIssuerPolicyForEnterpriseType,
    ) -> Response: ...

    @overload
    async def async_set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        include_enterprise_slug: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_actions_oidc_custom_issuer_policy_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsOidcCustomIssuerPolicyForEnterpriseType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#set-the-github-actions-oidc-custom-issuer-policy-for-an-enterprise"""

        from ..models import ActionsOidcCustomIssuerPolicyForEnterprise

        url = f"/enterprises/{enterprise}/actions/oidc/customization/issuer"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ActionsOidcCustomIssuerPolicyForEnterprise, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def get_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsGetDefaultWorkflowPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-an-enterprise"""

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsGetDefaultWorkflowPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-an-enterprise"""

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> Response: ...

    @overload
    def set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-an-enterprise"""

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_default_workflow_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-an-enterprise"""

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/enterprises/{enterprise}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    def generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    @overload
    def generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    def generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBody,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        )

        url = f"/enterprises/{enterprise}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    @overload
    async def async_generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    async def async_generate_runner_jitconfig_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBody,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        )

        url = f"/enterprises/{enterprise}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_actions_cache_usage_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheUsageOrgEnterprise]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-an-organization"""

        from ..models import ActionsCacheUsageOrgEnterprise

        url = f"/orgs/{org}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    async def async_get_actions_cache_usage_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheUsageOrgEnterprise]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-an-organization"""

        from ..models import ActionsCacheUsageOrgEnterprise

        url = f"/orgs/{org}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageOrgEnterprise,
        )

    def get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsCacheUsageByRepositoryGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#list-repositories-with-github-actions-cache-usage-for-an-organization"""

        from ..models import OrgsOrgActionsCacheUsageByRepositoryGetResponse200

        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    async def async_get_actions_cache_usage_by_repo_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsCacheUsageByRepositoryGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#list-repositories-with-github-actions-cache-usage-for-an-organization"""

        from ..models import OrgsOrgActionsCacheUsageByRepositoryGetResponse200

        url = f"/orgs/{org}/actions/cache/usage-by-repository"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsCacheUsageByRepositoryGetResponse200,
        )

    def get_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsOrganizationPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-an-organization"""

        from ..models import ActionsOrganizationPermissions

        url = f"/orgs/{org}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsOrganizationPermissions,
        )

    async def async_get_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsOrganizationPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-an-organization"""

        from ..models import ActionsOrganizationPermissions

        url = f"/orgs/{org}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsOrganizationPermissions,
        )

    @overload
    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> Response: ...

    def set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-an-organization"""

        from ..models import OrgsOrgActionsPermissionsPutBody

        url = f"/orgs/{org}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsPermissionsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enabled_repositories: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-an-organization"""

        from ..models import OrgsOrgActionsPermissionsPutBody

        url = f"/orgs/{org}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsPermissionsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsPermissionsRepositoriesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-selected-repositories-enabled-for-github-actions-in-an-organization"""

        from ..models import OrgsOrgActionsPermissionsRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    async def async_list_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsPermissionsRepositoriesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-selected-repositories-enabled-for-github-actions-in-an-organization"""

        from ..models import OrgsOrgActionsPermissionsRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/permissions/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsPermissionsRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsPermissionsRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> Response: ...

    def set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsPermissionsRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-selected-repositories-enabled-for-github-actions-in-an-organization"""

        from ..models import OrgsOrgActionsPermissionsRepositoriesPutBody

        url = f"/orgs/{org}/actions/permissions/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsPermissionsRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsPermissionsRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> Response: ...

    async def async_set_selected_repositories_enabled_github_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsPermissionsRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-selected-repositories-enabled-for-github-actions-in-an-organization"""

        from ..models import OrgsOrgActionsPermissionsRepositoriesPutBody

        url = f"/orgs/{org}/actions/permissions/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsPermissionsRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#enable-a-selected-repository-for-github-actions-in-an-organization"""

        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#enable-a-selected-repository-for-github-actions-in-an-organization"""

        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#disable-a-selected-repository-for-github-actions-in-an-organization"""

        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_selected_repository_github_actions_organization(
        self,
        org: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#disable-a-selected-repository-for-github-actions-in-an-organization"""

        url = f"/orgs/{org}/actions/permissions/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[SelectedActions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-an-organization"""

        from ..models import SelectedActions

        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[SelectedActions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-an-organization"""

        from ..models import SelectedActions

        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> Response: ...

    @overload
    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[List[str]] = UNSET,
    ) -> Response: ...

    def set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-an-organization"""

        from ..models import SelectedActions

        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[List[str]] = UNSET,
    ) -> Response: ...

    async def async_set_allowed_actions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-an-organization"""

        from ..models import SelectedActions

        url = f"/orgs/{org}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsGetDefaultWorkflowPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-an-organization"""

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsGetDefaultWorkflowPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-an-organization"""

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
    ) -> Response: ...

    @overload
    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-an-organization"""

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_default_workflow_permissions_organization(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-an-organization"""

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/orgs/{org}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_self_hosted_runner_groups_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        visible_to_repository: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsRunnerGroupsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runner-groups-for-an-organization"""

        from ..models import OrgsOrgActionsRunnerGroupsGetResponse200

        url = f"/orgs/{org}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_repository": visible_to_repository,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnerGroupsGetResponse200,
        )

    async def async_list_self_hosted_runner_groups_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        visible_to_repository: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsRunnerGroupsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runner-groups-for-an-organization"""

        from ..models import OrgsOrgActionsRunnerGroupsGetResponse200

        url = f"/orgs/{org}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_repository": visible_to_repository,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnerGroupsGetResponse200,
        )

    @overload
    def create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnerGroupsPostBodyType,
    ) -> Response[RunnerGroupsOrg]: ...

    @overload
    def create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        visibility: Missing[Literal["selected", "all", "private"]] = UNSET,
        selected_repository_ids: Missing[List[int]] = UNSET,
        runners: Missing[List[int]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[List[str]] = UNSET,
    ) -> Response[RunnerGroupsOrg]: ...

    def create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnerGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsOrg]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#create-a-self-hosted-runner-group-for-an-organization"""

        from ..models import RunnerGroupsOrg, OrgsOrgActionsRunnerGroupsPostBody

        url = f"/orgs/{org}/actions/runner-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsRunnerGroupsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RunnerGroupsOrg,
        )

    @overload
    async def async_create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnerGroupsPostBodyType,
    ) -> Response[RunnerGroupsOrg]: ...

    @overload
    async def async_create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        visibility: Missing[Literal["selected", "all", "private"]] = UNSET,
        selected_repository_ids: Missing[List[int]] = UNSET,
        runners: Missing[List[int]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[List[str]] = UNSET,
    ) -> Response[RunnerGroupsOrg]: ...

    async def async_create_self_hosted_runner_group_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnerGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsOrg]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#create-a-self-hosted-runner-group-for-an-organization"""

        from ..models import RunnerGroupsOrg, OrgsOrgActionsRunnerGroupsPostBody

        url = f"/orgs/{org}/actions/runner-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsRunnerGroupsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RunnerGroupsOrg,
        )

    def get_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RunnerGroupsOrg]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#get-a-self-hosted-runner-group-for-an-organization"""

        from ..models import RunnerGroupsOrg

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RunnerGroupsOrg,
        )

    async def async_get_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RunnerGroupsOrg]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#get-a-self-hosted-runner-group-for-an-organization"""

        from ..models import RunnerGroupsOrg

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RunnerGroupsOrg,
        )

    def delete_self_hosted_runner_group_from_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#delete-a-self-hosted-runner-group-from-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_self_hosted_runner_group_from_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#delete-a-self-hosted-runner-group-from-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType,
    ) -> Response[RunnerGroupsOrg]: ...

    @overload
    def update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        visibility: Missing[Literal["selected", "all", "private"]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[List[str]] = UNSET,
    ) -> Response[RunnerGroupsOrg]: ...

    def update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsOrg]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#update-a-self-hosted-runner-group-for-an-organization"""

        from ..models import (
            RunnerGroupsOrg,
            OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RunnerGroupsOrg,
        )

    @overload
    async def async_update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType,
    ) -> Response[RunnerGroupsOrg]: ...

    @overload
    async def async_update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        visibility: Missing[Literal["selected", "all", "private"]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[List[str]] = UNSET,
    ) -> Response[RunnerGroupsOrg]: ...

    async def async_update_self_hosted_runner_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsOrg]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#update-a-self-hosted-runner-group-for-an-organization"""

        from ..models import (
            RunnerGroupsOrg,
            OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RunnerGroupsOrg,
        )

    def list_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-repository-access-to-a-self-hosted-runner-group-in-an-organization"""

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

    async def async_list_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-repository-access-to-a-self-hosted-runner-group-in-an-organization"""

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesGetResponse200,
        )

    @overload
    def set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> Response: ...

    def set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-repository-access-for-a-self-hosted-runner-group-in-an-organization"""

        from ..models import OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> Response: ...

    async def async_set_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-repository-access-for-a-self-hosted-runner-group-in-an-organization"""

        from ..models import OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def add_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-repository-access-to-a-self-hosted-runner-group-in-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_add_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-repository-access-to-a-self-hosted-runner-group-in-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def remove_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-repository-access-to-a-self-hosted-runner-group-in-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_repo_access_to_self_hosted_runner_group_in_org(
        self,
        org: str,
        runner_group_id: int,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-repository-access-to-a-self-hosted-runner-group-in-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runners-in-a-group-for-an-organization"""

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runners-in-a-group-for-an-organization"""

        from ..models import (
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    @overload
    def set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> Response: ...

    @overload
    def set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        runners: List[int],
    ) -> Response: ...

    def set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-self-hosted-runners-in-a-group-for-an-organization"""

        from ..models import OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        runners: List[int],
    ) -> Response: ...

    async def async_set_self_hosted_runners_in_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-self-hosted-runners-in-a-group-for-an-organization"""

        from ..models import OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnerGroupsRunnerGroupIdRunnersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def add_self_hosted_runner_to_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-a-self-hosted-runner-to-a-group-for-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_add_self_hosted_runner_to_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-a-self-hosted-runner-to-a-group-for-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def remove_self_hosted_runner_from_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-a-self-hosted-runner-from-a-group-for-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_self_hosted_runner_from_group_for_org(
        self,
        org: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-a-self-hosted-runner-from-a-group-for-an-organization"""

        url = f"/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_self_hosted_runners_for_org(
        self,
        org: str,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsRunnersGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-an-organization"""

        from ..models import OrgsOrgActionsRunnersGetResponse200

        url = f"/orgs/{org}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_org(
        self,
        org: str,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsRunnersGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-an-organization"""

        from ..models import OrgsOrgActionsRunnersGetResponse200

        url = f"/orgs/{org}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RunnerApplication]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-an-organization"""

        from typing import List

        from ..models import RunnerApplication

        url = f"/orgs/{org}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RunnerApplication]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-an-organization"""

        from typing import List

        from ..models import RunnerApplication

        url = f"/orgs/{org}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RunnerApplication],
        )

    @overload
    def generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    @overload
    def generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    def generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersGenerateJitconfigPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            OrgsOrgActionsRunnersGenerateJitconfigPostBody,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        )

        url = f"/orgs/{org}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    @overload
    async def async_generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    async def async_generate_runner_jitconfig_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersGenerateJitconfigPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            OrgsOrgActionsRunnersGenerateJitconfigPostBody,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        )

        url = f"/orgs/{org}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def create_registration_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AuthenticationToken]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-an-organization"""

        from ..models import AuthenticationToken

        url = f"/orgs/{org}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AuthenticationToken]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-an-organization"""

        from ..models import AuthenticationToken

        url = f"/orgs/{org}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AuthenticationToken]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-an-organization"""

        from ..models import AuthenticationToken

        url = f"/orgs/{org}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AuthenticationToken]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-an-organization"""

        from ..models import AuthenticationToken

        url = f"/orgs/{org}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Runner]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-an-organization"""

        from ..models import Runner

        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Runner]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-an-organization"""

        from ..models import Runner

        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-an-organization"""

        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_self_hosted_runner_from_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-an-organization"""

        url = f"/orgs/{org}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    def set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            OrgsOrgActionsRunnersRunnerIdLabelsPutBody,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    async def async_set_custom_labels_for_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            OrgsOrgActionsRunnersRunnerIdLabelsPutBody,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    def add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            OrgsOrgActionsRunnersRunnerIdLabelsPostBody,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    async def async_add_custom_labels_to_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            OrgsOrgActionsRunnersRunnerIdLabelsPostBody,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_org(
        self,
        org: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/orgs/{org}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsSecretsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-organization-secrets"""

        from ..models import OrgsOrgActionsSecretsGetResponse200

        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsSecretsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-organization-secrets"""

        from ..models import OrgsOrgActionsSecretsGetResponse200

        url = f"/orgs/{org}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsPublicKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-organization-public-key"""

        from ..models import ActionsPublicKey

        url = f"/orgs/{org}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsPublicKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-organization-public-key"""

        from ..models import ActionsPublicKey

        url = f"/orgs/{org}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrganizationActionsSecret]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-organization-secret"""

        from ..models import OrganizationActionsSecret

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationActionsSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrganizationActionsSecret]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-organization-secret"""

        from ..models import OrganizationActionsSecret

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationActionsSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> Response[EmptyObject]: ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret"""

        from ..models import EmptyObject, OrgsOrgActionsSecretsSecretNamePutBody

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> Response[EmptyObject]: ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-organization-secret"""

        from ..models import EmptyObject, OrgsOrgActionsSecretsSecretNamePutBody

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-an-organization-secret"""

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-an-organization-secret"""

        url = f"/orgs/{org}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-selected-repositories-for-an-organization-secret"""

        from ..models import OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-selected-repositories-for-an-organization-secret"""

        from ..models import OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsSecretsSecretNameRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> Response: ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#set-selected-repositories-for-an-organization-secret"""

        from ..models import OrgsOrgActionsSecretsSecretNameRepositoriesPutBody

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> Response: ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsSecretsSecretNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#set-selected-repositories-for-an-organization-secret"""

        from ..models import OrgsOrgActionsSecretsSecretNameRepositoriesPutBody

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#add-selected-repository-to-an-organization-secret"""

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#add-selected-repository-to-an-organization-secret"""

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#remove-selected-repository-from-an-organization-secret"""

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#remove-selected-repository-from-an-organization-secret"""

        url = f"/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_org_variables(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsVariablesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-organization-variables"""

        from ..models import OrgsOrgActionsVariablesGetResponse200

        url = f"/orgs/{org}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsVariablesGetResponse200,
        )

    async def async_list_org_variables(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsVariablesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-organization-variables"""

        from ..models import OrgsOrgActionsVariablesGetResponse200

        url = f"/orgs/{org}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsVariablesGetResponse200,
        )

    @overload
    def create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesPostBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    def create_org_variable(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> Response[EmptyObject]: ...

    def create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-an-organization-variable"""

        from ..models import EmptyObject, OrgsOrgActionsVariablesPostBody

        url = f"/orgs/{org}/actions/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsVariablesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesPostBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_create_org_variable(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> Response[EmptyObject]: ...

    async def async_create_org_variable(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-an-organization-variable"""

        from ..models import EmptyObject, OrgsOrgActionsVariablesPostBody

        url = f"/orgs/{org}/actions/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsVariablesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def get_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrganizationActionsVariable]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-an-organization-variable"""

        from ..models import OrganizationActionsVariable

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationActionsVariable,
        )

    async def async_get_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrganizationActionsVariable]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-an-organization-variable"""

        from ..models import OrganizationActionsVariable

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationActionsVariable,
        )

    def delete_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-an-organization-variable"""

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-an-organization-variable"""

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
        visibility: Missing[Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> Response: ...

    def update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-an-organization-variable"""

        from ..models import OrgsOrgActionsVariablesNamePatchBody

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsVariablesNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
        visibility: Missing[Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Missing[List[int]] = UNSET,
    ) -> Response: ...

    async def async_update_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-an-organization-variable"""

        from ..models import OrgsOrgActionsVariablesNamePatchBody

        url = f"/orgs/{org}/actions/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgActionsVariablesNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsVariablesNameRepositoriesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-selected-repositories-for-an-organization-variable"""

        from ..models import OrgsOrgActionsVariablesNameRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
            error_models={},
        )

    async def async_list_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgActionsVariablesNameRepositoriesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-selected-repositories-for-an-organization-variable"""

        from ..models import OrgsOrgActionsVariablesNameRepositoriesGetResponse200

        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgActionsVariablesNameRepositoriesGetResponse200,
            error_models={},
        )

    @overload
    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> Response: ...

    def set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#set-selected-repositories-for-an-organization-variable"""

        from ..models import OrgsOrgActionsVariablesNameRepositoriesPutBody

        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsVariablesNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgActionsVariablesNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        selected_repository_ids: List[int],
    ) -> Response: ...

    async def async_set_selected_repos_for_org_variable(
        self,
        org: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgActionsVariablesNameRepositoriesPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#set-selected-repositories-for-an-organization-variable"""

        from ..models import OrgsOrgActionsVariablesNameRepositoriesPutBody

        url = f"/orgs/{org}/actions/variables/{name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgActionsVariablesNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    def add_selected_repo_to_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#add-selected-repository-to-an-organization-variable"""

        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_add_selected_repo_to_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#add-selected-repository-to-an-organization-variable"""

        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_selected_repo_from_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#remove-selected-repository-from-an-organization-variable"""

        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_selected_repo_from_org_variable(
        self,
        org: str,
        name: str,
        repository_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#remove-selected-repository-from-an-organization-variable"""

        url = f"/orgs/{org}/actions/variables/{name}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsArtifactsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#list-artifacts-for-a-repository"""

        from ..models import ReposOwnerRepoActionsArtifactsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    async def async_list_artifacts_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsArtifactsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#list-artifacts-for-a-repository"""

        from ..models import ReposOwnerRepoActionsArtifactsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsArtifactsGetResponse200,
        )

    def get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Artifact]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#get-an-artifact"""

        from ..models import Artifact

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Artifact,
        )

    async def async_get_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Artifact]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#get-an-artifact"""

        from ..models import Artifact

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Artifact,
        )

    def delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#delete-an-artifact"""

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#delete-an-artifact"""

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#download-an-artifact"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "410": BasicError,
            },
        )

    async def async_download_artifact(
        self,
        owner: str,
        repo: str,
        artifact_id: int,
        archive_format: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#download-an-artifact"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "410": BasicError,
            },
        )

    def get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheUsageByRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-a-repository"""

        from ..models import ActionsCacheUsageByRepository

        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageByRepository,
        )

    async def async_get_actions_cache_usage(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheUsageByRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#get-github-actions-cache-usage-for-a-repository"""

        from ..models import ActionsCacheUsageByRepository

        url = f"/repos/{owner}/{repo}/actions/cache/usage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsCacheUsageByRepository,
        )

    def get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        key: Missing[str] = UNSET,
        sort: Missing[
            Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheList]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#list-github-actions-caches-for-a-repository"""

        from ..models import ActionsCacheList

        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ActionsCacheList,
        )

    async def async_get_actions_cache_list(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        key: Missing[str] = UNSET,
        sort: Missing[
            Literal["created_at", "last_accessed_at", "size_in_bytes"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheList]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#list-github-actions-caches-for-a-repository"""

        from ..models import ActionsCacheList

        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "per_page": per_page,
            "page": page,
            "ref": ref,
            "key": key,
            "sort": sort,
            "direction": direction,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        key: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheList]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#delete-github-actions-caches-for-a-repository-using-a-cache-key"""

        from ..models import ActionsCacheList

        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ActionsCacheList,
        )

    async def async_delete_actions_cache_by_key(
        self,
        owner: str,
        repo: str,
        key: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsCacheList]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#delete-github-actions-caches-for-a-repository-using-a-cache-key"""

        from ..models import ActionsCacheList

        url = f"/repos/{owner}/{repo}/actions/caches"

        params = {
            "key": key,
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ActionsCacheList,
        )

    def delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#delete-a-github-actions-cache-for-a-repository-using-a-cache-id"""

        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_actions_cache_by_id(
        self,
        owner: str,
        repo: str,
        cache_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/cache#delete-a-github-actions-cache-for-a-repository-using-a-cache-id"""

        url = f"/repos/{owner}/{repo}/actions/caches/{cache_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Job]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#get-a-job-for-a-workflow-run"""

        from ..models import Job

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Job,
        )

    async def async_get_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Job]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#get-a-job-for-a-workflow-run"""

        from ..models import Job

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Job,
        )

    def download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#download-job-logs-for-a-workflow-run"""

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_job_logs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#download-job-logs-for-a-workflow-run"""

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject]: ...

    @overload
    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject]: ...

    def re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-a-job-from-a-workflow-run"""

        from typing import Union

        from ..models import (
            BasicError,
            EmptyObject,
            ReposOwnerRepoActionsJobsJobIdRerunPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsJobsJobIdRerunPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject]: ...

    async def async_re_run_job_for_workflow_run(
        self,
        owner: str,
        repo: str,
        job_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsJobsJobIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-a-job-from-a-workflow-run"""

        from typing import Union

        from ..models import (
            BasicError,
            EmptyObject,
            ReposOwnerRepoActionsJobsJobIdRerunPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsJobsJobIdRerunPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
            },
        )

    def get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OidcCustomSubRepo]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#get-the-customization-template-for-an-oidc-subject-claim-for-a-repository"""

        from ..models import BasicError, OidcCustomSubRepo

        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OidcCustomSubRepo,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OidcCustomSubRepo]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#get-the-customization-template-for-an-oidc-subject-claim-for-a-repository"""

        from ..models import BasicError, OidcCustomSubRepo

        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OidcCustomSubRepo,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        use_default: bool,
        include_claim_keys: Missing[List[str]] = UNSET,
    ) -> Response[EmptyObject]: ...

    def set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsOidcCustomizationSubPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#set-the-customization-template-for-an-oidc-subject-claim-for-a-repository"""

        from ..models import (
            BasicError,
            EmptyObject,
            ValidationErrorSimple,
            ReposOwnerRepoActionsOidcCustomizationSubPutBody,
        )

        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsOidcCustomizationSubPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsOidcCustomizationSubPutBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        use_default: bool,
        include_claim_keys: Missing[List[str]] = UNSET,
    ) -> Response[EmptyObject]: ...

    async def async_set_custom_oidc_sub_claim_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsOidcCustomizationSubPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/oidc#set-the-customization-template-for-an-oidc-subject-claim-for-a-repository"""

        from ..models import (
            BasicError,
            EmptyObject,
            ValidationErrorSimple,
            ReposOwnerRepoActionsOidcCustomizationSubPutBody,
        )

        url = f"/repos/{owner}/{repo}/actions/oidc/customization/sub"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsOidcCustomizationSubPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "400": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_repo_organization_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsOrganizationSecretsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-repository-organization-secrets"""

        from ..models import ReposOwnerRepoActionsOrganizationSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/organization-secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        )

    async def async_list_repo_organization_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsOrganizationSecretsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-repository-organization-secrets"""

        from ..models import ReposOwnerRepoActionsOrganizationSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/organization-secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsOrganizationSecretsGetResponse200,
        )

    def list_repo_organization_variables(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsOrganizationVariablesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-repository-organization-variables"""

        from ..models import ReposOwnerRepoActionsOrganizationVariablesGetResponse200

        url = f"/repos/{owner}/{repo}/actions/organization-variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        )

    async def async_list_repo_organization_variables(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsOrganizationVariablesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-repository-organization-variables"""

        from ..models import ReposOwnerRepoActionsOrganizationVariablesGetResponse200

        url = f"/repos/{owner}/{repo}/actions/organization-variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsOrganizationVariablesGetResponse200,
        )

    def get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsRepositoryPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-a-repository"""

        from ..models import ActionsRepositoryPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsRepositoryPermissions,
        )

    async def async_get_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsRepositoryPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-a-repository"""

        from ..models import ActionsRepositoryPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsRepositoryPermissions,
        )

    @overload
    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enabled: bool,
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> Response: ...

    def set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-a-repository"""

        from ..models import ReposOwnerRepoActionsPermissionsPutBody

        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoActionsPermissionsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enabled: bool,
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-a-repository"""

        from ..models import ReposOwnerRepoActionsPermissionsPutBody

        url = f"/repos/{owner}/{repo}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoActionsPermissionsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsWorkflowAccessToRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-the-level-of-access-for-workflows-outside-of-the-repository"""

        from ..models import ActionsWorkflowAccessToRepository

        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsWorkflowAccessToRepository,
        )

    async def async_get_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsWorkflowAccessToRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-the-level-of-access-for-workflows-outside-of-the-repository"""

        from ..models import ActionsWorkflowAccessToRepository

        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsWorkflowAccessToRepository,
        )

    @overload
    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsWorkflowAccessToRepositoryType,
    ) -> Response: ...

    @overload
    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_level: Literal["none", "user", "organization", "enterprise"],
    ) -> Response: ...

    def set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsWorkflowAccessToRepositoryType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-the-level-of-access-for-workflows-outside-of-the-repository"""

        from ..models import ActionsWorkflowAccessToRepository

        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsWorkflowAccessToRepository, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsWorkflowAccessToRepositoryType,
    ) -> Response: ...

    @overload
    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        access_level: Literal["none", "user", "organization", "enterprise"],
    ) -> Response: ...

    async def async_set_workflow_access_to_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsWorkflowAccessToRepositoryType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-the-level-of-access-for-workflows-outside-of-the-repository"""

        from ..models import ActionsWorkflowAccessToRepository

        url = f"/repos/{owner}/{repo}/actions/permissions/access"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsWorkflowAccessToRepository, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[SelectedActions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-a-repository"""

        from ..models import SelectedActions

        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[SelectedActions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-a-repository"""

        from ..models import SelectedActions

        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> Response: ...

    @overload
    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[List[str]] = UNSET,
    ) -> Response: ...

    def set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-a-repository"""

        from ..models import SelectedActions

        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[List[str]] = UNSET,
    ) -> Response: ...

    async def async_set_allowed_actions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-a-repository"""

        from ..models import SelectedActions

        url = f"/repos/{owner}/{repo}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsGetDefaultWorkflowPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-a-repository"""

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    async def async_get_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsGetDefaultWorkflowPermissions]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-default-workflow-permissions-for-a-repository"""

        from ..models import ActionsGetDefaultWorkflowPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsGetDefaultWorkflowPermissions,
        )

    @overload
    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> Response: ...

    @overload
    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    def set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-a-repository"""

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ActionsSetDefaultWorkflowPermissionsType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        default_workflow_permissions: Missing[Literal["read", "write"]] = UNSET,
        can_approve_pull_request_reviews: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_default_workflow_permissions_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ActionsSetDefaultWorkflowPermissionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-default-workflow-permissions-for-a-repository"""

        from ..models import ActionsSetDefaultWorkflowPermissions

        url = f"/repos/{owner}/{repo}/actions/permissions/workflow"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ActionsSetDefaultWorkflowPermissions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsRunnersGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-a-repository"""

        from ..models import ReposOwnerRepoActionsRunnersGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_repo(
        self,
        owner: str,
        repo: str,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsRunnersGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-a-repository"""

        from ..models import ReposOwnerRepoActionsRunnersGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RunnerApplication]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-a-repository"""

        from typing import List

        from ..models import RunnerApplication

        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RunnerApplication],
        )

    async def async_list_runner_applications_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RunnerApplication]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-a-repository"""

        from typing import List

        from ..models import RunnerApplication

        url = f"/repos/{owner}/{repo}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[RunnerApplication],
        )

    @overload
    def generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    @overload
    def generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    def generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    @overload
    async def async_generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        runner_group_id: int,
        labels: List[str],
        work_folder: Missing[str] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201
    ]: ...

    async def async_generate_runner_jitconfig_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-configuration-for-a-just-in-time-runner-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody,
            EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/generate-jitconfig"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersGenerateJitconfigPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersGenerateJitconfigPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AuthenticationToken]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-a-repository"""

        from ..models import AuthenticationToken

        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AuthenticationToken]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-a-repository"""

        from ..models import AuthenticationToken

        url = f"/repos/{owner}/{repo}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AuthenticationToken]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-a-repository"""

        from ..models import AuthenticationToken

        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AuthenticationToken]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-a-repository"""

        from ..models import AuthenticationToken

        url = f"/repos/{owner}/{repo}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Runner]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-a-repository"""

        from ..models import Runner

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Runner]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-a-repository"""

        from ..models import Runner

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-a-repository"""

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_self_hosted_runner_from_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-a-repository"""

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    def set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    async def async_set_custom_labels_for_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    def add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: List[str],
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]: ...

    async def async_add_custom_labels_to_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_repo(
        self,
        owner: str,
        repo: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationErrorSimple,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        created: Missing[str] = UNSET,
        exclude_pull_requests: Missing[bool] = UNSET,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsRunsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#list-workflow-runs-for-a-repository"""

        from ..models import ReposOwnerRepoActionsRunsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    async def async_list_workflow_runs_for_repo(
        self,
        owner: str,
        repo: str,
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        created: Missing[str] = UNSET,
        exclude_pull_requests: Missing[bool] = UNSET,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsRunsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#list-workflow-runs-for-a-repository"""

        from ..models import ReposOwnerRepoActionsRunsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsGetResponse200,
        )

    def get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        exclude_pull_requests: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WorkflowRun]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-a-workflow-run"""

        from ..models import WorkflowRun

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        exclude_pull_requests: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WorkflowRun]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-a-workflow-run"""

        from ..models import WorkflowRun

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=WorkflowRun,
        )

    def delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#delete-a-workflow-run"""

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#delete-a-workflow-run"""

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[EnvironmentApprovals]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-the-review-history-for-a-workflow-run"""

        from typing import List

        from ..models import EnvironmentApprovals

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[EnvironmentApprovals],
        )

    async def async_get_reviews_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[EnvironmentApprovals]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-the-review-history-for-a-workflow-run"""

        from typing import List

        from ..models import EnvironmentApprovals

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approvals"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[EnvironmentApprovals],
        )

    def approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#approve-a-workflow-run-for-a-fork-pull-request"""

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_approve_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#approve-a-workflow-run-for-a-fork-pull-request"""

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/approve"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#list-workflow-run-artifacts"""

        from ..models import ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    async def async_list_workflow_run_artifacts(
        self,
        owner: str,
        repo: str,
        run_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        name: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/artifacts#list-workflow-run-artifacts"""

        from ..models import ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts"

        params = {
            "per_page": per_page,
            "page": page,
            "name": name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdArtifactsGetResponse200,
        )

    def get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        exclude_pull_requests: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WorkflowRun]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-a-workflow-run-attempt"""

        from ..models import WorkflowRun

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=WorkflowRun,
        )

    async def async_get_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        exclude_pull_requests: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WorkflowRun]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-a-workflow-run-attempt"""

        from ..models import WorkflowRun

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}"

        params = {
            "exclude_pull_requests": exclude_pull_requests,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=WorkflowRun,
        )

    def list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#list-jobs-for-a-workflow-run-attempt"""

        from ..models import (
            BasicError,
            ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_jobs_for_workflow_run_attempt(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#list-jobs-for-a-workflow-run-attempt"""

        from ..models import (
            BasicError,
            ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdAttemptsAttemptNumberJobsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#download-workflow-run-attempt-logs"""

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_workflow_run_attempt_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        attempt_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#download-workflow-run-attempt-logs"""

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    def cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#cancel-a-workflow-run"""

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    async def async_cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#cancel-a-workflow-run"""

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    @overload
    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
        ],
    ) -> Response: ...

    @overload
    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_name: str,
        comment: str,
    ) -> Response: ...

    @overload
    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_name: str,
        state: Literal["approved", "rejected"],
        comment: Missing[str] = UNSET,
    ) -> Response: ...

    def review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#review-custom-deployment-protection-rules-for-a-workflow-run"""

        from typing import Union

        from ..models import (
            ReviewCustomGatesStateRequired,
            ReviewCustomGatesCommentRequired,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReviewCustomGatesCommentRequired, ReviewCustomGatesStateRequired],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
        ],
    ) -> Response: ...

    @overload
    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_name: str,
        comment: str,
    ) -> Response: ...

    @overload
    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_name: str,
        state: Literal["approved", "rejected"],
        comment: Missing[str] = UNSET,
    ) -> Response: ...

    async def async_review_custom_gates_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReviewCustomGatesCommentRequiredType, ReviewCustomGatesStateRequiredType
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#review-custom-deployment-protection-rules-for-a-workflow-run"""

        from typing import Union

        from ..models import (
            ReviewCustomGatesStateRequired,
            ReviewCustomGatesCommentRequired,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/deployment_protection_rule"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReviewCustomGatesCommentRequired, ReviewCustomGatesStateRequired],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def force_cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#force-cancel-a-workflow-run"""

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    async def async_force_cancel_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#force-cancel-a-workflow-run"""

        from ..models import BasicError, EmptyObject

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/force-cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "409": BasicError,
            },
        )

    def list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        filter_: Missing[Literal["latest", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsRunsRunIdJobsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#list-jobs-for-a-workflow-run"""

        from ..models import ReposOwnerRepoActionsRunsRunIdJobsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    async def async_list_jobs_for_workflow_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        filter_: Missing[Literal["latest", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsRunsRunIdJobsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-jobs#list-jobs-for-a-workflow-run"""

        from ..models import ReposOwnerRepoActionsRunsRunIdJobsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/jobs"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsRunsRunIdJobsGetResponse200,
        )

    def download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#download-workflow-run-logs"""

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#download-workflow-run-logs"""

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    def delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#delete-workflow-run-logs"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_workflow_run_logs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#delete-workflow-run-logs"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/logs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "500": BasicError,
            },
        )

    def get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PendingDeployment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-pending-deployments-for-a-workflow-run"""

        from typing import List

        from ..models import PendingDeployment

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[PendingDeployment],
        )

    async def async_get_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PendingDeployment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-pending-deployments-for-a-workflow-run"""

        from typing import List

        from ..models import PendingDeployment

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[PendingDeployment],
        )

    @overload
    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    ) -> Response[List[Deployment]]: ...

    @overload
    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_ids: List[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> Response[List[Deployment]]: ...

    def review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Deployment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run"""

        from typing import List

        from ..models import (
            Deployment,
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Deployment],
        )

    @overload
    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType,
    ) -> Response[List[Deployment]]: ...

    @overload
    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        environment_ids: List[int],
        state: Literal["approved", "rejected"],
        comment: str,
    ) -> Response[List[Deployment]]: ...

    async def async_review_pending_deployments_for_run(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Deployment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#review-pending-deployments-for-a-workflow-run"""

        from typing import List

        from ..models import (
            Deployment,
            ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsRunsRunIdPendingDeploymentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Deployment],
        )

    @overload
    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject]: ...

    @overload
    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject]: ...

    def re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-a-workflow"""

        from typing import Union

        from ..models import EmptyObject, ReposOwnerRepoActionsRunsRunIdRerunPostBody

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsRunsRunIdRerunPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject]: ...

    async def async_re_run_workflow(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-a-workflow"""

        from typing import Union

        from ..models import EmptyObject, ReposOwnerRepoActionsRunsRunIdRerunPostBody

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsRunsRunIdRerunPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject]: ...

    @overload
    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject]: ...

    def re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-failed-jobs-from-a-workflow-run"""

        from typing import Union

        from ..models import (
            EmptyObject,
            ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        enable_debug_logging: Missing[bool] = UNSET,
    ) -> Response[EmptyObject]: ...

    async def async_re_run_workflow_failed_jobs(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#re-run-failed-jobs-from-a-workflow-run"""

        from typing import Union

        from ..models import (
            EmptyObject,
            ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody,
        )

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoActionsRunsRunIdRerunFailedJobsPostBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WorkflowRunUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-workflow-run-usage"""

        from ..models import WorkflowRunUsage

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WorkflowRunUsage,
        )

    async def async_get_workflow_run_usage(
        self,
        owner: str,
        repo: str,
        run_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WorkflowRunUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#get-workflow-run-usage"""

        from ..models import WorkflowRunUsage

        url = f"/repos/{owner}/{repo}/actions/runs/{run_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WorkflowRunUsage,
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsSecretsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-repository-secrets"""

        from ..models import ReposOwnerRepoActionsSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsSecretsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-repository-secrets"""

        from ..models import ReposOwnerRepoActionsSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsPublicKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-a-repository-public-key"""

        from ..models import ActionsPublicKey

        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsPublicKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-a-repository-public-key"""

        from ..models import ActionsPublicKey

        url = f"/repos/{owner}/{repo}/actions/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsSecret]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-a-repository-secret"""

        from ..models import ActionsSecret

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsSecret]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-a-repository-secret"""

        from ..models import ActionsSecret

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> Response[EmptyObject]: ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-a-repository-secret"""

        from ..models import EmptyObject, ReposOwnerRepoActionsSecretsSecretNamePutBody

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> Response[EmptyObject]: ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-a-repository-secret"""

        from ..models import EmptyObject, ReposOwnerRepoActionsSecretsSecretNamePutBody

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-a-repository-secret"""

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-a-repository-secret"""

        url = f"/repos/{owner}/{repo}/actions/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_repo_variables(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsVariablesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-repository-variables"""

        from ..models import ReposOwnerRepoActionsVariablesGetResponse200

        url = f"/repos/{owner}/{repo}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsVariablesGetResponse200,
        )

    async def async_list_repo_variables(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsVariablesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-repository-variables"""

        from ..models import ReposOwnerRepoActionsVariablesGetResponse200

        url = f"/repos/{owner}/{repo}/actions/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsVariablesGetResponse200,
        )

    @overload
    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsVariablesPostBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
    ) -> Response[EmptyObject]: ...

    def create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-a-repository-variable"""

        from ..models import EmptyObject, ReposOwnerRepoActionsVariablesPostBody

        url = f"/repos/{owner}/{repo}/actions/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoActionsVariablesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsVariablesPostBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
    ) -> Response[EmptyObject]: ...

    async def async_create_repo_variable(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsVariablesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-a-repository-variable"""

        from ..models import EmptyObject, ReposOwnerRepoActionsVariablesPostBody

        url = f"/repos/{owner}/{repo}/actions/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoActionsVariablesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def get_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsVariable]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-a-repository-variable"""

        from ..models import ActionsVariable

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsVariable,
        )

    async def async_get_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsVariable]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-a-repository-variable"""

        from ..models import ActionsVariable

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsVariable,
        )

    def delete_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-a-repository-variable"""

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-a-repository-variable"""

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
    ) -> Response: ...

    def update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-a-repository-variable"""

        from ..models import ReposOwnerRepoActionsVariablesNamePatchBody

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsVariablesNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
    ) -> Response: ...

    async def async_update_repo_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoActionsVariablesNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-a-repository-variable"""

        from ..models import ReposOwnerRepoActionsVariablesNamePatchBody

        url = f"/repos/{owner}/{repo}/actions/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsVariablesNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_repo_workflows(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsWorkflowsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#list-repository-workflows"""

        from ..models import ReposOwnerRepoActionsWorkflowsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    async def async_list_repo_workflows(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsWorkflowsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#list-repository-workflows"""

        from ..models import ReposOwnerRepoActionsWorkflowsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/workflows"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsWorkflowsGetResponse200,
        )

    def get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Workflow]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#get-a-workflow"""

        from ..models import Workflow

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Workflow,
        )

    async def async_get_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Workflow]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#get-a-workflow"""

        from ..models import Workflow

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Workflow,
        )

    def disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#disable-a-workflow"""

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#disable-a-workflow"""

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: str,
        inputs: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType
        ] = UNSET,
    ) -> Response: ...

    def create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#create-a-workflow-dispatch-event"""

        from ..models import ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: str,
        inputs: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyPropInputsType
        ] = UNSET,
    ) -> Response: ...

    async def async_create_workflow_dispatch(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#create-a-workflow-dispatch-event"""

        from ..models import ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoActionsWorkflowsWorkflowIdDispatchesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#enable-a-workflow"""

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_workflow(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#enable-a-workflow"""

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        created: Missing[str] = UNSET,
        exclude_pull_requests: Missing[bool] = UNSET,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#list-workflow-runs-for-a-workflow"""

        from ..models import ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    async def async_list_workflow_runs(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        actor: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        event: Missing[str] = UNSET,
        status: Missing[
            Literal[
                "completed",
                "action_required",
                "cancelled",
                "failure",
                "neutral",
                "skipped",
                "stale",
                "success",
                "timed_out",
                "in_progress",
                "queued",
                "requested",
                "waiting",
                "pending",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        created: Missing[str] = UNSET,
        exclude_pull_requests: Missing[bool] = UNSET,
        check_suite_id: Missing[int] = UNSET,
        head_sha: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflow-runs#list-workflow-runs-for-a-workflow"""

        from ..models import ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs"

        params = {
            "actor": actor,
            "branch": branch,
            "event": event,
            "status": status,
            "per_page": per_page,
            "page": page,
            "created": created,
            "exclude_pull_requests": exclude_pull_requests,
            "check_suite_id": check_suite_id,
            "head_sha": head_sha,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoActionsWorkflowsWorkflowIdRunsGetResponse200,
        )

    def get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WorkflowUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#get-workflow-usage"""

        from ..models import WorkflowUsage

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WorkflowUsage,
        )

    async def async_get_workflow_usage(
        self,
        owner: str,
        repo: str,
        workflow_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WorkflowUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/workflows#get-workflow-usage"""

        from ..models import WorkflowUsage

        url = f"/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WorkflowUsage,
        )

    def list_environment_secrets(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-environment-secrets"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    async def async_list_environment_secrets(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#list-environment-secrets"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameSecretsGetResponse200,
        )

    def get_environment_public_key(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsPublicKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-environment-public-key"""

        from ..models import ActionsPublicKey

        url = (
            f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    async def async_get_environment_public_key(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsPublicKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-environment-public-key"""

        from ..models import ActionsPublicKey

        url = (
            f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/public-key"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsPublicKey,
        )

    def get_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsSecret]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-environment-secret"""

        from ..models import ActionsSecret

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsSecret,
        )

    async def async_get_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsSecret]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#get-an-environment-secret"""

        from ..models import ActionsSecret

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsSecret,
        )

    @overload
    def create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    def create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: str,
        key_id: str,
    ) -> Response[EmptyObject]: ...

    def create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-environment-secret"""

        from ..models import (
            EmptyObject,
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        encrypted_value: str,
        key_id: str,
    ) -> Response[EmptyObject]: ...

    async def async_create_or_update_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#create-or-update-an-environment-secret"""

        from ..models import (
            EmptyObject,
            ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-an-environment-secret"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_environment_secret(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        secret_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/secrets#delete-an-environment-secret"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_environment_variables(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-environment-variables"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

    async def async_list_environment_variables(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#list-environment-variables"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameVariablesGetResponse200,
        )

    @overload
    def create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    def create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
    ) -> Response[EmptyObject]: ...

    def create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-an-environment-variable"""

        from ..models import (
            EmptyObject,
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType,
    ) -> Response[EmptyObject]: ...

    @overload
    async def async_create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        value: str,
    ) -> Response[EmptyObject]: ...

    async def async_create_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#create-an-environment-variable"""

        from ..models import (
            EmptyObject,
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameVariablesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def get_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsVariable]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-an-environment-variable"""

        from ..models import ActionsVariable

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsVariable,
        )

    async def async_get_environment_variable(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsVariable]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#get-an-environment-variable"""

        from ..models import ActionsVariable

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsVariable,
        )

    def delete_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-an-environment-variable"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#delete-an-environment-variable"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    def update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
    ) -> Response: ...

    def update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-an-environment-variable"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType,
    ) -> Response: ...

    @overload
    async def async_update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value: Missing[str] = UNSET,
    ) -> Response: ...

    async def async_update_environment_variable(
        self,
        owner: str,
        repo: str,
        name: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/variables#update-an-environment-variable"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/variables/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameVariablesNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )
