"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel

from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from datetime import datetime
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..types import (
        NotificationsPutBodyType,
        ReposOwnerRepoSubscriptionPutBodyType,
        ReposOwnerRepoNotificationsPutBodyType,
        NotificationsThreadsThreadIdSubscriptionPutBodyType,
    )
    from ..models import (
        Feed,
        Event,
        Thread,
        Stargazer,
        Repository,
        SimpleUser,
        MinimalRepository,
        StarredRepository,
        ThreadSubscription,
        RepositorySubscription,
        NotificationsPutResponse202,
        ReposOwnerRepoNotificationsPutResponse202,
    )


class ActivityClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_public_events(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-events"""

        from typing import List

        from ..models import (
            Event,
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = "/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
            error_models={
                "403": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_public_events(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-events"""

        from typing import List

        from ..models import (
            Event,
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = "/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
            error_models={
                "403": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_feeds(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Feed]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/feeds#get-feeds"""

        from ..models import Feed

        url = "/feeds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Feed,
        )

    async def async_get_feeds(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Feed]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/feeds#get-feeds"""

        from ..models import Feed

        url = "/feeds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Feed,
        )

    def list_public_events_for_repo_network(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-events-for-a-network-of-repositories"""

        from typing import List

        from ..models import Event, BasicError

        url = f"/networks/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_public_events_for_repo_network(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-events-for-a-network-of-repositories"""

        from typing import List

        from ..models import Event, BasicError

        url = f"/networks/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_notifications_for_authenticated_user(
        self,
        all_: Missing[bool] = UNSET,
        participating: Missing[bool] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Thread]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#list-notifications-for-the-authenticated-user"""

        from typing import List

        from ..models import Thread, BasicError, ValidationError

        url = "/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Thread],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_notifications_for_authenticated_user(
        self,
        all_: Missing[bool] = UNSET,
        participating: Missing[bool] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Thread]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#list-notifications-for-the-authenticated-user"""

        from typing import List

        from ..models import Thread, BasicError, ValidationError

        url = "/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Thread],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def mark_notifications_as_read(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[NotificationsPutBodyType] = UNSET,
    ) -> Response[NotificationsPutResponse202]: ...

    @overload
    def mark_notifications_as_read(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        last_read_at: Missing[datetime] = UNSET,
        read: Missing[bool] = UNSET,
    ) -> Response[NotificationsPutResponse202]: ...

    def mark_notifications_as_read(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[NotificationsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[NotificationsPutResponse202]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#mark-notifications-as-read"""

        from ..models import (
            BasicError,
            NotificationsPutBody,
            NotificationsPutResponse202,
        )

        url = "/notifications"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(NotificationsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=NotificationsPutResponse202,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_mark_notifications_as_read(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[NotificationsPutBodyType] = UNSET,
    ) -> Response[NotificationsPutResponse202]: ...

    @overload
    async def async_mark_notifications_as_read(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        last_read_at: Missing[datetime] = UNSET,
        read: Missing[bool] = UNSET,
    ) -> Response[NotificationsPutResponse202]: ...

    async def async_mark_notifications_as_read(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[NotificationsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[NotificationsPutResponse202]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#mark-notifications-as-read"""

        from ..models import (
            BasicError,
            NotificationsPutBody,
            NotificationsPutResponse202,
        )

        url = "/notifications"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(NotificationsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=NotificationsPutResponse202,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_thread(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Thread]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#get-a-thread"""

        from ..models import Thread, BasicError

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Thread,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_thread(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Thread]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#get-a-thread"""

        from ..models import Thread, BasicError

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Thread,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def mark_thread_as_done(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#mark-a-thread-as-done"""

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_mark_thread_as_done(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#mark-a-thread-as-done"""

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def mark_thread_as_read(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#mark-a-thread-as-read"""

        from ..models import BasicError

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_mark_thread_as_read(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#mark-a-thread-as-read"""

        from ..models import BasicError

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def get_thread_subscription_for_authenticated_user(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ThreadSubscription]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#get-a-thread-subscription-for-the-authenticated-user"""

        from ..models import BasicError, ThreadSubscription

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_thread_subscription_for_authenticated_user(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ThreadSubscription]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#get-a-thread-subscription-for-the-authenticated-user"""

        from ..models import BasicError, ThreadSubscription

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def set_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[NotificationsThreadsThreadIdSubscriptionPutBodyType] = UNSET,
    ) -> Response[ThreadSubscription]: ...

    @overload
    def set_thread_subscription(
        self,
        thread_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ignored: Missing[bool] = UNSET,
    ) -> Response[ThreadSubscription]: ...

    def set_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[NotificationsThreadsThreadIdSubscriptionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ThreadSubscription]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#set-a-thread-subscription"""

        from ..models import (
            BasicError,
            ThreadSubscription,
            NotificationsThreadsThreadIdSubscriptionPutBody,
        )

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                NotificationsThreadsThreadIdSubscriptionPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_set_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[NotificationsThreadsThreadIdSubscriptionPutBodyType] = UNSET,
    ) -> Response[ThreadSubscription]: ...

    @overload
    async def async_set_thread_subscription(
        self,
        thread_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ignored: Missing[bool] = UNSET,
    ) -> Response[ThreadSubscription]: ...

    async def async_set_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[NotificationsThreadsThreadIdSubscriptionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ThreadSubscription]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#set-a-thread-subscription"""

        from ..models import (
            BasicError,
            ThreadSubscription,
            NotificationsThreadsThreadIdSubscriptionPutBody,
        )

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                NotificationsThreadsThreadIdSubscriptionPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#delete-a-thread-subscription"""

        from ..models import BasicError

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#delete-a-thread-subscription"""

        from ..models import BasicError

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_public_org_events(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-organization-events"""

        from typing import List

        from ..models import Event

        url = f"/orgs/{org}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    async def async_list_public_org_events(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-organization-events"""

        from typing import List

        from ..models import Event

        url = f"/orgs/{org}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    def list_repo_events(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-repository-events"""

        from typing import List

        from ..models import Event

        url = f"/repos/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    async def async_list_repo_events(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-repository-events"""

        from typing import List

        from ..models import Event

        url = f"/repos/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    def list_repo_notifications_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        all_: Missing[bool] = UNSET,
        participating: Missing[bool] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Thread]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#list-repository-notifications-for-the-authenticated-user"""

        from typing import List

        from ..models import Thread

        url = f"/repos/{owner}/{repo}/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Thread],
        )

    async def async_list_repo_notifications_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        all_: Missing[bool] = UNSET,
        participating: Missing[bool] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Thread]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#list-repository-notifications-for-the-authenticated-user"""

        from typing import List

        from ..models import Thread

        url = f"/repos/{owner}/{repo}/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Thread],
        )

    @overload
    def mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoNotificationsPutBodyType] = UNSET,
    ) -> Response[ReposOwnerRepoNotificationsPutResponse202]: ...

    @overload
    def mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        last_read_at: Missing[datetime] = UNSET,
    ) -> Response[ReposOwnerRepoNotificationsPutResponse202]: ...

    def mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoNotificationsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReposOwnerRepoNotificationsPutResponse202]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#mark-repository-notifications-as-read"""

        from ..models import (
            ReposOwnerRepoNotificationsPutBody,
            ReposOwnerRepoNotificationsPutResponse202,
        )

        url = f"/repos/{owner}/{repo}/notifications"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoNotificationsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoNotificationsPutResponse202,
        )

    @overload
    async def async_mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoNotificationsPutBodyType] = UNSET,
    ) -> Response[ReposOwnerRepoNotificationsPutResponse202]: ...

    @overload
    async def async_mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        last_read_at: Missing[datetime] = UNSET,
    ) -> Response[ReposOwnerRepoNotificationsPutResponse202]: ...

    async def async_mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoNotificationsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReposOwnerRepoNotificationsPutResponse202]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/notifications#mark-repository-notifications-as-read"""

        from ..models import (
            ReposOwnerRepoNotificationsPutBody,
            ReposOwnerRepoNotificationsPutResponse202,
        )

        url = f"/repos/{owner}/{repo}/notifications"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoNotificationsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoNotificationsPutResponse202,
        )

    def list_stargazers_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[List[SimpleUser], List[Stargazer]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#list-stargazers"""

        from typing import List, Union

        from ..models import Stargazer, SimpleUser, ValidationError

        url = f"/repos/{owner}/{repo}/stargazers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[List[SimpleUser], List[Stargazer]],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_stargazers_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[List[SimpleUser], List[Stargazer]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#list-stargazers"""

        from typing import List, Union

        from ..models import Stargazer, SimpleUser, ValidationError

        url = f"/repos/{owner}/{repo}/stargazers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[List[SimpleUser], List[Stargazer]],
            error_models={
                "422": ValidationError,
            },
        )

    def list_watchers_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#list-watchers"""

        from typing import List

        from ..models import SimpleUser

        url = f"/repos/{owner}/{repo}/subscribers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_watchers_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#list-watchers"""

        from typing import List

        from ..models import SimpleUser

        url = f"/repos/{owner}/{repo}/subscribers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def get_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RepositorySubscription]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#get-a-repository-subscription"""

        from ..models import BasicError, RepositorySubscription

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositorySubscription,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RepositorySubscription]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#get-a-repository-subscription"""

        from ..models import BasicError, RepositorySubscription

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositorySubscription,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoSubscriptionPutBodyType] = UNSET,
    ) -> Response[RepositorySubscription]: ...

    @overload
    def set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        subscribed: Missing[bool] = UNSET,
        ignored: Missing[bool] = UNSET,
    ) -> Response[RepositorySubscription]: ...

    def set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoSubscriptionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositorySubscription]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#set-a-repository-subscription"""

        from ..models import RepositorySubscription, ReposOwnerRepoSubscriptionPutBody

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoSubscriptionPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositorySubscription,
        )

    @overload
    async def async_set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoSubscriptionPutBodyType] = UNSET,
    ) -> Response[RepositorySubscription]: ...

    @overload
    async def async_set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        subscribed: Missing[bool] = UNSET,
        ignored: Missing[bool] = UNSET,
    ) -> Response[RepositorySubscription]: ...

    async def async_set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoSubscriptionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositorySubscription]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#set-a-repository-subscription"""

        from ..models import RepositorySubscription, ReposOwnerRepoSubscriptionPutBody

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoSubscriptionPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositorySubscription,
        )

    def delete_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#delete-a-repository-subscription"""

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#delete-a-repository-subscription"""

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_repos_starred_by_authenticated_user(
        self,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Repository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#list-repositories-starred-by-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, Repository

        url = "/user/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Repository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_repos_starred_by_authenticated_user(
        self,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Repository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#list-repositories-starred-by-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, Repository

        url = "/user/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Repository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def check_repo_is_starred_by_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#check-if-a-repository-is-starred-by-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    async def async_check_repo_is_starred_by_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#check-if-a-repository-is-starred-by-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    def star_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#star-a-repository-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_star_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#star-a-repository-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    def unstar_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#unstar-a-repository-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    async def async_unstar_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#unstar-a-repository-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    def list_watched_repos_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#list-repositories-watched-by-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = "/user/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_watched_repos_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#list-repositories-watched-by-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = "/user/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_events_for_authenticated_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-events-for-the-authenticated-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    async def async_list_events_for_authenticated_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-events-for-the-authenticated-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    def list_org_events_for_authenticated_user(
        self,
        username: str,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-organization-events-for-the-authenticated-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/events/orgs/{org}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    async def async_list_org_events_for_authenticated_user(
        self,
        username: str,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-organization-events-for-the-authenticated-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/events/orgs/{org}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    def list_public_events_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-events-for-a-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    async def async_list_public_events_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-events-for-a-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    def list_received_events_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-events-received-by-the-authenticated-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/received_events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    async def async_list_received_events_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-events-received-by-the-authenticated-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/received_events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    def list_received_public_events_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-events-received-by-a-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/received_events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    async def async_list_received_public_events_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Event]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/events#list-public-events-received-by-a-user"""

        from typing import List

        from ..models import Event

        url = f"/users/{username}/received_events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Event],
        )

    def list_repos_starred_by_user(
        self,
        username: str,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[List[StarredRepository], List[Repository]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#list-repositories-starred-by-a-user"""

        from typing import List, Union

        from ..models import Repository, StarredRepository

        url = f"/users/{username}/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[List[StarredRepository], List[Repository]],
        )

    async def async_list_repos_starred_by_user(
        self,
        username: str,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[List[StarredRepository], List[Repository]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/starring#list-repositories-starred-by-a-user"""

        from typing import List, Union

        from ..models import Repository, StarredRepository

        url = f"/users/{username}/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[List[StarredRepository], List[Repository]],
        )

    def list_repos_watched_by_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#list-repositories-watched-by-a-user"""

        from typing import List

        from ..models import MinimalRepository

        url = f"/users/{username}/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    async def async_list_repos_watched_by_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/activity/watching#list-repositories-watched-by-a-user"""

        from typing import List

        from ..models import MinimalRepository

        url = f"/users/{username}/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )
