"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing_extensions import Annotated
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import Field, BaseModel

from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from datetime import datetime
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import (
        Issue,
        Label,
        Milestone,
        IssueEvent,
        SimpleUser,
        IssueComment,
        LockedIssueEvent,
        LabeledIssueEvent,
        RenamedIssueEvent,
        AssignedIssueEvent,
        UnlabeledIssueEvent,
        MilestonedIssueEvent,
        TimelineCommentEvent,
        UnassignedIssueEvent,
        StateChangeIssueEvent,
        TimelineReviewedEvent,
        DemilestonedIssueEvent,
        TimelineCommittedEvent,
        AddedToProjectIssueEvent,
        ReviewDismissedIssueEvent,
        ReviewRequestedIssueEvent,
        TimelineAssignedIssueEvent,
        TimelineLineCommentedEvent,
        RemovedFromProjectIssueEvent,
        TimelineCommitCommentedEvent,
        TimelineCrossReferencedEvent,
        TimelineUnassignedIssueEvent,
        ConvertedNoteToIssueIssueEvent,
        MovedColumnInProjectIssueEvent,
        ReviewRequestRemovedIssueEvent,
    )
    from ..types import (
        ReposOwnerRepoIssuesPostBodyType,
        ReposOwnerRepoLabelsPostBodyType,
        ReposOwnerRepoMilestonesPostBodyType,
        ReposOwnerRepoLabelsNamePatchBodyType,
        ReposOwnerRepoIssuesIssueNumberPatchBodyType,
        ReposOwnerRepoIssuesIssueNumberLockPutBodyType,
        ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType,
        ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType,
        ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType,
        ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType,
        ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type,
        ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType,
        ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
        ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
        ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
        ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
        ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType,
        ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType,
        ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
        ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType,
        ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType,
    )


class IssuesClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        collab: Missing[bool] = UNSET,
        orgs: Missing[bool] = UNSET,
        owned: Missing[bool] = UNSET,
        pulls: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Issue]]:
        """See also: https://docs.github.com/rest/issues/issues#list-issues-assigned-to-the-authenticated-user"""

        from typing import List

        from ..models import Issue, BasicError, ValidationError

        url = "/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "collab": collab,
            "orgs": orgs,
            "owned": owned,
            "pulls": pulls,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_list(
        self,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        collab: Missing[bool] = UNSET,
        orgs: Missing[bool] = UNSET,
        owned: Missing[bool] = UNSET,
        pulls: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Issue]]:
        """See also: https://docs.github.com/rest/issues/issues#list-issues-assigned-to-the-authenticated-user"""

        from typing import List

        from ..models import Issue, BasicError, ValidationError

        url = "/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "collab": collab,
            "orgs": orgs,
            "owned": owned,
            "pulls": pulls,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_for_org(
        self,
        org: str,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Issue]]:
        """See also: https://docs.github.com/rest/issues/issues#list-organization-issues-assigned-to-the-authenticated-user"""

        from typing import List

        from ..models import Issue, BasicError

        url = f"/orgs/{org}/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Issue],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_org(
        self,
        org: str,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Issue]]:
        """See also: https://docs.github.com/rest/issues/issues#list-organization-issues-assigned-to-the-authenticated-user"""

        from typing import List

        from ..models import Issue, BasicError

        url = f"/orgs/{org}/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Issue],
            error_models={
                "404": BasicError,
            },
        )

    def list_assignees(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/issues/assignees#list-assignees"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/assignees"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_assignees(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/issues/assignees#list-assignees"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/assignees"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    def check_user_can_be_assigned(
        self,
        owner: str,
        repo: str,
        assignee: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/assignees#check-if-a-user-can-be-assigned"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/assignees/{assignee}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_user_can_be_assigned(
        self,
        owner: str,
        repo: str,
        assignee: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/assignees#check-if-a-user-can-be-assigned"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/assignees/{assignee}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_for_repo(
        self,
        owner: str,
        repo: str,
        milestone: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        assignee: Missing[str] = UNSET,
        creator: Missing[str] = UNSET,
        mentioned: Missing[str] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Issue]]:
        """See also: https://docs.github.com/rest/issues/issues#list-repository-issues"""

        from typing import List

        from ..models import Issue, BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/issues"

        params = {
            "milestone": milestone,
            "state": state,
            "assignee": assignee,
            "creator": creator,
            "mentioned": mentioned,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_list_for_repo(
        self,
        owner: str,
        repo: str,
        milestone: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        assignee: Missing[str] = UNSET,
        creator: Missing[str] = UNSET,
        mentioned: Missing[str] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Issue]]:
        """See also: https://docs.github.com/rest/issues/issues#list-repository-issues"""

        from typing import List

        from ..models import Issue, BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/issues"

        params = {
            "milestone": milestone,
            "state": state,
            "assignee": assignee,
            "creator": creator,
            "mentioned": mentioned,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesPostBodyType,
    ) -> Response[Issue]: ...

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Union[str, int],
        body: Missing[str] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
        milestone: Missing[Union[str, int, None]] = UNSET,
        labels: Missing[
            List[Union[str, ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type]]
        ] = UNSET,
        assignees: Missing[List[str]] = UNSET,
    ) -> Response[Issue]: ...

    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/issues#create-an-issue"""

        from ..models import (
            Issue,
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesPostBody,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/issues"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoIssuesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesPostBodyType,
    ) -> Response[Issue]: ...

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Union[str, int],
        body: Missing[str] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
        milestone: Missing[Union[str, int, None]] = UNSET,
        labels: Missing[
            List[Union[str, ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type]]
        ] = UNSET,
        assignees: Missing[List[str]] = UNSET,
    ) -> Response[Issue]: ...

    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/issues#create-an-issue"""

        from ..models import (
            Issue,
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesPostBody,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/issues"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoIssuesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
                "404": BasicError,
                "410": BasicError,
            },
        )

    def list_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[IssueComment]]:
        """See also: https://docs.github.com/rest/issues/comments#list-issue-comments-for-a-repository"""

        from typing import List

        from ..models import BasicError, IssueComment, ValidationError

        url = f"/repos/{owner}/{repo}/issues/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[IssueComment],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_list_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[IssueComment]]:
        """See also: https://docs.github.com/rest/issues/comments#list-issue-comments-for-a-repository"""

        from typing import List

        from ..models import BasicError, IssueComment, ValidationError

        url = f"/repos/{owner}/{repo}/issues/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[IssueComment],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[IssueComment]:
        """See also: https://docs.github.com/rest/issues/comments#get-an-issue-comment"""

        from ..models import BasicError, IssueComment

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[IssueComment]:
        """See also: https://docs.github.com/rest/issues/comments#get-an-issue-comment"""

        from ..models import BasicError, IssueComment

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/comments#delete-an-issue-comment"""

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/comments#delete-an-issue-comment"""

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType,
    ) -> Response[IssueComment]: ...

    @overload
    def update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[IssueComment]: ...

    def update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[IssueComment]:
        """See also: https://docs.github.com/rest/issues/comments#update-an-issue-comment"""

        from ..models import (
            IssueComment,
            ValidationError,
            ReposOwnerRepoIssuesCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesCommentsCommentIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType,
    ) -> Response[IssueComment]: ...

    @overload
    async def async_update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[IssueComment]: ...

    async def async_update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[IssueComment]:
        """See also: https://docs.github.com/rest/issues/comments#update-an-issue-comment"""

        from ..models import (
            IssueComment,
            ValidationError,
            ReposOwnerRepoIssuesCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesCommentsCommentIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "422": ValidationError,
            },
        )

    def list_events_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[IssueEvent]]:
        """See also: https://docs.github.com/rest/issues/events#list-issue-events-for-a-repository"""

        from typing import List

        from ..models import IssueEvent, ValidationError

        url = f"/repos/{owner}/{repo}/issues/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[IssueEvent],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_events_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[IssueEvent]]:
        """See also: https://docs.github.com/rest/issues/events#list-issue-events-for-a-repository"""

        from typing import List

        from ..models import IssueEvent, ValidationError

        url = f"/repos/{owner}/{repo}/issues/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[IssueEvent],
            error_models={
                "422": ValidationError,
            },
        )

    def get_event(
        self,
        owner: str,
        repo: str,
        event_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[IssueEvent]:
        """See also: https://docs.github.com/rest/issues/events#get-an-issue-event"""

        from ..models import BasicError, IssueEvent

        url = f"/repos/{owner}/{repo}/issues/events/{event_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=IssueEvent,
            error_models={
                "404": BasicError,
                "410": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_event(
        self,
        owner: str,
        repo: str,
        event_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[IssueEvent]:
        """See also: https://docs.github.com/rest/issues/events#get-an-issue-event"""

        from ..models import BasicError, IssueEvent

        url = f"/repos/{owner}/{repo}/issues/events/{event_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=IssueEvent,
            error_models={
                "404": BasicError,
                "410": BasicError,
                "403": BasicError,
            },
        )

    def get(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/issues#get-an-issue"""

        from ..models import Issue, BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/issues#get-an-issue"""

        from ..models import Issue, BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
    ) -> Response[Issue]: ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[Union[str, int, None]] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        state_reason: Missing[
            Union[None, Literal["completed", "not_planned", "reopened"]]
        ] = UNSET,
        milestone: Missing[Union[str, int, None]] = UNSET,
        labels: Missing[
            List[
                Union[
                    str,
                    ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
                ]
            ]
        ] = UNSET,
        assignees: Missing[List[str]] = UNSET,
    ) -> Response[Issue]: ...

    def update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/issues#update-an-issue"""

        from ..models import (
            Issue,
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberPatchBody,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoIssuesIssueNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "422": ValidationError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
    ) -> Response[Issue]: ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[Union[str, int, None]] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        state_reason: Missing[
            Union[None, Literal["completed", "not_planned", "reopened"]]
        ] = UNSET,
        milestone: Missing[Union[str, int, None]] = UNSET,
        labels: Missing[
            List[
                Union[
                    str,
                    ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
                ]
            ]
        ] = UNSET,
        assignees: Missing[List[str]] = UNSET,
    ) -> Response[Issue]: ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/issues#update-an-issue"""

        from ..models import (
            Issue,
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberPatchBody,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoIssuesIssueNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "422": ValidationError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType] = UNSET,
    ) -> Response[Issue]: ...

    @overload
    def add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        assignees: Missing[List[str]] = UNSET,
    ) -> Response[Issue]: ...

    def add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/assignees#add-assignees-to-an-issue"""

        from ..models import Issue, ReposOwnerRepoIssuesIssueNumberAssigneesPostBody

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberAssigneesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
        )

    @overload
    async def async_add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType] = UNSET,
    ) -> Response[Issue]: ...

    @overload
    async def async_add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        assignees: Missing[List[str]] = UNSET,
    ) -> Response[Issue]: ...

    async def async_add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/assignees#add-assignees-to-an-issue"""

        from ..models import Issue, ReposOwnerRepoIssuesIssueNumberAssigneesPostBody

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberAssigneesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
        )

    @overload
    def remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType] = UNSET,
    ) -> Response[Issue]: ...

    @overload
    def remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        assignees: Missing[List[str]] = UNSET,
    ) -> Response[Issue]: ...

    def remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/assignees#remove-assignees-from-an-issue"""

        from ..models import Issue, ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
        )

    @overload
    async def async_remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType] = UNSET,
    ) -> Response[Issue]: ...

    @overload
    async def async_remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        assignees: Missing[List[str]] = UNSET,
    ) -> Response[Issue]: ...

    async def async_remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue]:
        """See also: https://docs.github.com/rest/issues/assignees#remove-assignees-from-an-issue"""

        from ..models import Issue, ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
        )

    def check_user_can_be_assigned_to_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        assignee: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/assignees#check-if-a-user-can-be-assigned-to-a-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_user_can_be_assigned_to_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        assignee: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/assignees#check-if-a-user-can-be-assigned-to-a-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_comments(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[IssueComment]]:
        """See also: https://docs.github.com/rest/issues/comments#list-issue-comments"""

        from typing import List

        from ..models import BasicError, IssueComment

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[IssueComment],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_comments(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[IssueComment]]:
        """See also: https://docs.github.com/rest/issues/comments#list-issue-comments"""

        from typing import List

        from ..models import BasicError, IssueComment

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[IssueComment],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType,
    ) -> Response[IssueComment]: ...

    @overload
    def create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[IssueComment]: ...

    def create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[IssueComment]:
        """See also: https://docs.github.com/rest/issues/comments#create-an-issue-comment"""

        from ..models import (
            BasicError,
            IssueComment,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberCommentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "403": BasicError,
                "410": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType,
    ) -> Response[IssueComment]: ...

    @overload
    async def async_create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[IssueComment]: ...

    async def async_create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[IssueComment]:
        """See also: https://docs.github.com/rest/issues/comments#create-an-issue-comment"""

        from ..models import (
            BasicError,
            IssueComment,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberCommentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "403": BasicError,
                "410": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_events(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        List[
            Union[
                LabeledIssueEvent,
                UnlabeledIssueEvent,
                AssignedIssueEvent,
                UnassignedIssueEvent,
                MilestonedIssueEvent,
                DemilestonedIssueEvent,
                RenamedIssueEvent,
                ReviewRequestedIssueEvent,
                ReviewRequestRemovedIssueEvent,
                ReviewDismissedIssueEvent,
                LockedIssueEvent,
                AddedToProjectIssueEvent,
                MovedColumnInProjectIssueEvent,
                RemovedFromProjectIssueEvent,
                ConvertedNoteToIssueIssueEvent,
            ]
        ]
    ]:
        """See also: https://docs.github.com/rest/issues/events#list-issue-events"""

        from typing import List, Union

        from ..models import (
            BasicError,
            LockedIssueEvent,
            LabeledIssueEvent,
            RenamedIssueEvent,
            AssignedIssueEvent,
            UnlabeledIssueEvent,
            MilestonedIssueEvent,
            UnassignedIssueEvent,
            DemilestonedIssueEvent,
            AddedToProjectIssueEvent,
            ReviewDismissedIssueEvent,
            ReviewRequestedIssueEvent,
            RemovedFromProjectIssueEvent,
            ConvertedNoteToIssueIssueEvent,
            MovedColumnInProjectIssueEvent,
            ReviewRequestRemovedIssueEvent,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    AssignedIssueEvent,
                    UnassignedIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                ]
            ],
            error_models={
                "410": BasicError,
            },
        )

    async def async_list_events(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        List[
            Union[
                LabeledIssueEvent,
                UnlabeledIssueEvent,
                AssignedIssueEvent,
                UnassignedIssueEvent,
                MilestonedIssueEvent,
                DemilestonedIssueEvent,
                RenamedIssueEvent,
                ReviewRequestedIssueEvent,
                ReviewRequestRemovedIssueEvent,
                ReviewDismissedIssueEvent,
                LockedIssueEvent,
                AddedToProjectIssueEvent,
                MovedColumnInProjectIssueEvent,
                RemovedFromProjectIssueEvent,
                ConvertedNoteToIssueIssueEvent,
            ]
        ]
    ]:
        """See also: https://docs.github.com/rest/issues/events#list-issue-events"""

        from typing import List, Union

        from ..models import (
            BasicError,
            LockedIssueEvent,
            LabeledIssueEvent,
            RenamedIssueEvent,
            AssignedIssueEvent,
            UnlabeledIssueEvent,
            MilestonedIssueEvent,
            UnassignedIssueEvent,
            DemilestonedIssueEvent,
            AddedToProjectIssueEvent,
            ReviewDismissedIssueEvent,
            ReviewRequestedIssueEvent,
            RemovedFromProjectIssueEvent,
            ConvertedNoteToIssueIssueEvent,
            MovedColumnInProjectIssueEvent,
            ReviewRequestRemovedIssueEvent,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    AssignedIssueEvent,
                    UnassignedIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                ]
            ],
            error_models={
                "410": BasicError,
            },
        )

    def list_labels_on_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#list-labels-for-an-issue"""

        from typing import List

        from ..models import Label, BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_labels_on_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#list-labels-for-an-issue"""

        from typing import List

        from ..models import Label, BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
    ) -> Response[List[Label]]: ...

    @overload
    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: Missing[List[str]] = UNSET,
    ) -> Response[List[Label]]: ...

    @overload
    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: Missing[
            List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType]
        ] = UNSET,
    ) -> Response[List[Label]]: ...

    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#set-labels-for-an-issue"""

        from typing import List, Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            Label,
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
                    Annotated[List[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
                    Annotated[
                        List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items],
                        Field(min_length=1 if PYDANTIC_V2 else None),
                    ],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
    ) -> Response[List[Label]]: ...

    @overload
    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: Missing[List[str]] = UNSET,
    ) -> Response[List[Label]]: ...

    @overload
    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: Missing[
            List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType]
        ] = UNSET,
    ) -> Response[List[Label]]: ...

    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#set-labels-for-an-issue"""

        from typing import List, Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            Label,
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
                    Annotated[List[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
                    Annotated[
                        List[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items],
                        Field(min_length=1 if PYDANTIC_V2 else None),
                    ],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
    ) -> Response[List[Label]]: ...

    @overload
    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: Missing[List[str]] = UNSET,
    ) -> Response[List[Label]]: ...

    @overload
    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: Missing[
            List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType]
        ] = UNSET,
    ) -> Response[List[Label]]: ...

    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#add-labels-to-an-issue"""

        from typing import List, Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            Label,
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
                    Annotated[List[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
                    Annotated[
                        List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items],
                        Field(min_length=1 if PYDANTIC_V2 else None),
                    ],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
    ) -> Response[List[Label]]: ...

    @overload
    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: Missing[List[str]] = UNSET,
    ) -> Response[List[Label]]: ...

    @overload
    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        labels: Missing[
            List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType]
        ] = UNSET,
    ) -> Response[List[Label]]: ...

    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                List[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#add-labels-to-an-issue"""

        from typing import List, Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            Label,
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
                    Annotated[List[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
                    Annotated[
                        List[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items],
                        Field(min_length=1 if PYDANTIC_V2 else None),
                    ],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
                "422": ValidationError,
            },
        )

    def remove_all_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/labels#remove-all-labels-from-an-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_remove_all_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/labels#remove-all-labels-from-an-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    def remove_label(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#remove-a-label-from-an-issue"""

        from typing import List

        from ..models import Label, BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_remove_label(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#remove-a-label-from-an-issue"""

        from typing import List

        from ..models import Label, BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        lock_reason: Missing[
            Literal["off-topic", "too heated", "resolved", "spam"]
        ] = UNSET,
    ) -> Response: ...

    def lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/issues#lock-an-issue"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberLockPutBody,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoIssuesIssueNumberLockPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "410": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        lock_reason: Missing[
            Literal["off-topic", "too heated", "resolved", "spam"]
        ] = UNSET,
    ) -> Response: ...

    async def async_lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/issues#lock-an-issue"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberLockPutBody,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoIssuesIssueNumberLockPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "410": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def unlock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/issues#unlock-an-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_unlock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/issues#unlock-an-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_events_for_timeline(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        List[
            Union[
                LabeledIssueEvent,
                UnlabeledIssueEvent,
                MilestonedIssueEvent,
                DemilestonedIssueEvent,
                RenamedIssueEvent,
                ReviewRequestedIssueEvent,
                ReviewRequestRemovedIssueEvent,
                ReviewDismissedIssueEvent,
                LockedIssueEvent,
                AddedToProjectIssueEvent,
                MovedColumnInProjectIssueEvent,
                RemovedFromProjectIssueEvent,
                ConvertedNoteToIssueIssueEvent,
                TimelineCommentEvent,
                TimelineCrossReferencedEvent,
                TimelineCommittedEvent,
                TimelineReviewedEvent,
                TimelineLineCommentedEvent,
                TimelineCommitCommentedEvent,
                TimelineAssignedIssueEvent,
                TimelineUnassignedIssueEvent,
                StateChangeIssueEvent,
            ]
        ]
    ]:
        """See also: https://docs.github.com/rest/issues/timeline#list-timeline-events-for-an-issue"""

        from typing import List, Union

        from ..models import (
            BasicError,
            LockedIssueEvent,
            LabeledIssueEvent,
            RenamedIssueEvent,
            UnlabeledIssueEvent,
            MilestonedIssueEvent,
            TimelineCommentEvent,
            StateChangeIssueEvent,
            TimelineReviewedEvent,
            DemilestonedIssueEvent,
            TimelineCommittedEvent,
            AddedToProjectIssueEvent,
            ReviewDismissedIssueEvent,
            ReviewRequestedIssueEvent,
            TimelineAssignedIssueEvent,
            TimelineLineCommentedEvent,
            RemovedFromProjectIssueEvent,
            TimelineCommitCommentedEvent,
            TimelineCrossReferencedEvent,
            TimelineUnassignedIssueEvent,
            ConvertedNoteToIssueIssueEvent,
            MovedColumnInProjectIssueEvent,
            ReviewRequestRemovedIssueEvent,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/timeline"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                    TimelineCommentEvent,
                    TimelineCrossReferencedEvent,
                    TimelineCommittedEvent,
                    TimelineReviewedEvent,
                    TimelineLineCommentedEvent,
                    TimelineCommitCommentedEvent,
                    TimelineAssignedIssueEvent,
                    TimelineUnassignedIssueEvent,
                    StateChangeIssueEvent,
                ]
            ],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_events_for_timeline(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        List[
            Union[
                LabeledIssueEvent,
                UnlabeledIssueEvent,
                MilestonedIssueEvent,
                DemilestonedIssueEvent,
                RenamedIssueEvent,
                ReviewRequestedIssueEvent,
                ReviewRequestRemovedIssueEvent,
                ReviewDismissedIssueEvent,
                LockedIssueEvent,
                AddedToProjectIssueEvent,
                MovedColumnInProjectIssueEvent,
                RemovedFromProjectIssueEvent,
                ConvertedNoteToIssueIssueEvent,
                TimelineCommentEvent,
                TimelineCrossReferencedEvent,
                TimelineCommittedEvent,
                TimelineReviewedEvent,
                TimelineLineCommentedEvent,
                TimelineCommitCommentedEvent,
                TimelineAssignedIssueEvent,
                TimelineUnassignedIssueEvent,
                StateChangeIssueEvent,
            ]
        ]
    ]:
        """See also: https://docs.github.com/rest/issues/timeline#list-timeline-events-for-an-issue"""

        from typing import List, Union

        from ..models import (
            BasicError,
            LockedIssueEvent,
            LabeledIssueEvent,
            RenamedIssueEvent,
            UnlabeledIssueEvent,
            MilestonedIssueEvent,
            TimelineCommentEvent,
            StateChangeIssueEvent,
            TimelineReviewedEvent,
            DemilestonedIssueEvent,
            TimelineCommittedEvent,
            AddedToProjectIssueEvent,
            ReviewDismissedIssueEvent,
            ReviewRequestedIssueEvent,
            TimelineAssignedIssueEvent,
            TimelineLineCommentedEvent,
            RemovedFromProjectIssueEvent,
            TimelineCommitCommentedEvent,
            TimelineCrossReferencedEvent,
            TimelineUnassignedIssueEvent,
            ConvertedNoteToIssueIssueEvent,
            MovedColumnInProjectIssueEvent,
            ReviewRequestRemovedIssueEvent,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/timeline"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                    TimelineCommentEvent,
                    TimelineCrossReferencedEvent,
                    TimelineCommittedEvent,
                    TimelineReviewedEvent,
                    TimelineLineCommentedEvent,
                    TimelineCommitCommentedEvent,
                    TimelineAssignedIssueEvent,
                    TimelineUnassignedIssueEvent,
                    StateChangeIssueEvent,
                ]
            ],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    def list_labels_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#list-labels-for-a-repository"""

        from typing import List

        from ..models import Label, BasicError

        url = f"/repos/{owner}/{repo}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#list-labels-for-a-repository"""

        from typing import List

        from ..models import Label, BasicError

        url = f"/repos/{owner}/{repo}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Label],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_label(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoLabelsPostBodyType,
    ) -> Response[Label]: ...

    @overload
    def create_label(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        color: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
    ) -> Response[Label]: ...

    def create_label(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Label]:
        """See also: https://docs.github.com/rest/issues/labels#create-a-label"""

        from ..models import (
            Label,
            BasicError,
            ValidationError,
            ReposOwnerRepoLabelsPostBody,
        )

        url = f"/repos/{owner}/{repo}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoLabelsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Label,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_label(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoLabelsPostBodyType,
    ) -> Response[Label]: ...

    @overload
    async def async_create_label(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        color: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
    ) -> Response[Label]: ...

    async def async_create_label(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Label]:
        """See also: https://docs.github.com/rest/issues/labels#create-a-label"""

        from ..models import (
            Label,
            BasicError,
            ValidationError,
            ReposOwnerRepoLabelsPostBody,
        )

        url = f"/repos/{owner}/{repo}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoLabelsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Label,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Label]:
        """See also: https://docs.github.com/rest/issues/labels#get-a-label"""

        from ..models import Label, BasicError

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Label,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Label]:
        """See also: https://docs.github.com/rest/issues/labels#get-a-label"""

        from ..models import Label, BasicError

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Label,
            error_models={
                "404": BasicError,
            },
        )

    def delete_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/labels#delete-a-label"""

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/labels#delete-a-label"""

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
    ) -> Response[Label]: ...

    @overload
    def update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_name: Missing[str] = UNSET,
        color: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
    ) -> Response[Label]: ...

    def update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Label]:
        """See also: https://docs.github.com/rest/issues/labels#update-a-label"""

        from ..models import Label, ReposOwnerRepoLabelsNamePatchBody

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoLabelsNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Label,
        )

    @overload
    async def async_update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
    ) -> Response[Label]: ...

    @overload
    async def async_update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_name: Missing[str] = UNSET,
        color: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
    ) -> Response[Label]: ...

    async def async_update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Label]:
        """See also: https://docs.github.com/rest/issues/labels#update-a-label"""

        from ..models import Label, ReposOwnerRepoLabelsNamePatchBody

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoLabelsNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Label,
        )

    def list_milestones(
        self,
        owner: str,
        repo: str,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        sort: Missing[Literal["due_on", "completeness"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Milestone]]:
        """See also: https://docs.github.com/rest/issues/milestones#list-milestones"""

        from typing import List

        from ..models import Milestone, BasicError

        url = f"/repos/{owner}/{repo}/milestones"

        params = {
            "state": state,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Milestone],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_milestones(
        self,
        owner: str,
        repo: str,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        sort: Missing[Literal["due_on", "completeness"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Milestone]]:
        """See also: https://docs.github.com/rest/issues/milestones#list-milestones"""

        from typing import List

        from ..models import Milestone, BasicError

        url = f"/repos/{owner}/{repo}/milestones"

        params = {
            "state": state,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Milestone],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMilestonesPostBodyType,
    ) -> Response[Milestone]: ...

    @overload
    def create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: str,
        state: Missing[Literal["open", "closed"]] = UNSET,
        description: Missing[str] = UNSET,
        due_on: Missing[datetime] = UNSET,
    ) -> Response[Milestone]: ...

    def create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Milestone]:
        """See also: https://docs.github.com/rest/issues/milestones#create-a-milestone"""

        from ..models import (
            Milestone,
            BasicError,
            ValidationError,
            ReposOwnerRepoMilestonesPostBody,
        )

        url = f"/repos/{owner}/{repo}/milestones"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMilestonesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Milestone,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMilestonesPostBodyType,
    ) -> Response[Milestone]: ...

    @overload
    async def async_create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: str,
        state: Missing[Literal["open", "closed"]] = UNSET,
        description: Missing[str] = UNSET,
        due_on: Missing[datetime] = UNSET,
    ) -> Response[Milestone]: ...

    async def async_create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Milestone]:
        """See also: https://docs.github.com/rest/issues/milestones#create-a-milestone"""

        from ..models import (
            Milestone,
            BasicError,
            ValidationError,
            ReposOwnerRepoMilestonesPostBody,
        )

        url = f"/repos/{owner}/{repo}/milestones"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMilestonesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Milestone,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Milestone]:
        """See also: https://docs.github.com/rest/issues/milestones#get-a-milestone"""

        from ..models import Milestone, BasicError

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Milestone,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Milestone]:
        """See also: https://docs.github.com/rest/issues/milestones#get-a-milestone"""

        from ..models import Milestone, BasicError

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Milestone,
            error_models={
                "404": BasicError,
            },
        )

    def delete_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/milestones#delete-a-milestone"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/issues/milestones#delete-a-milestone"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType] = UNSET,
    ) -> Response[Milestone]: ...

    @overload
    def update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        description: Missing[str] = UNSET,
        due_on: Missing[datetime] = UNSET,
    ) -> Response[Milestone]: ...

    def update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Milestone]:
        """See also: https://docs.github.com/rest/issues/milestones#update-a-milestone"""

        from ..models import Milestone, ReposOwnerRepoMilestonesMilestoneNumberPatchBody

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoMilestonesMilestoneNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Milestone,
        )

    @overload
    async def async_update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType] = UNSET,
    ) -> Response[Milestone]: ...

    @overload
    async def async_update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        description: Missing[str] = UNSET,
        due_on: Missing[datetime] = UNSET,
    ) -> Response[Milestone]: ...

    async def async_update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Milestone]:
        """See also: https://docs.github.com/rest/issues/milestones#update-a-milestone"""

        from ..models import Milestone, ReposOwnerRepoMilestonesMilestoneNumberPatchBody

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoMilestonesMilestoneNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Milestone,
        )

    def list_labels_for_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#list-labels-for-issues-in-a-milestone"""

        from typing import List

        from ..models import Label

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Label],
        )

    async def async_list_labels_for_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Label]]:
        """See also: https://docs.github.com/rest/issues/labels#list-labels-for-issues-in-a-milestone"""

        from typing import List

        from ..models import Label

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Label],
        )

    def list_for_authenticated_user(
        self,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Issue]]:
        """See also: https://docs.github.com/rest/issues/issues#list-user-account-issues-assigned-to-the-authenticated-user"""

        from typing import List

        from ..models import Issue, BasicError

        url = "/user/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Issue],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Issue]]:
        """See also: https://docs.github.com/rest/issues/issues#list-user-account-issues-assigned-to-the-authenticated-user"""

        from typing import List

        from ..models import Issue, BasicError

        url = "/user/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Issue],
            error_models={
                "404": BasicError,
            },
        )
