"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel

from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from typing import List, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import Reaction
    from ..types import (
        ReposOwnerRepoCommentsCommentIdReactionsPostBodyType,
        ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType,
        ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType,
        ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType,
        ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    )


class ReactionsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-comment"""

        from typing import List

        from ..models import Reaction

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    async def async_list_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-comment"""

        from typing import List

        from ..models import Reaction

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    @overload
    def create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    def create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    def create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-comment"""

        from ..models import (
            Reaction,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    async def async_create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    async def async_create_for_team_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-comment"""

        from ..models import (
            Reaction,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    def delete_for_team_discussion_comment(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-team-discussion-comment-reaction"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_team_discussion_comment(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-team-discussion-comment-reaction"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion"""

        from typing import List

        from ..models import Reaction

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    async def async_list_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion"""

        from typing import List

        from ..models import Reaction

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    @overload
    def create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    def create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    def create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion"""

        from ..models import (
            Reaction,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    async def async_create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    async def async_create_for_team_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion"""

        from ..models import (
            Reaction,
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    def delete_for_team_discussion(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-team-discussion-reaction"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_team_discussion(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-team-discussion-reaction"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-commit-comment"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-commit-comment"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    def create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    def create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-commit-comment"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoCommentsCommentIdReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    async def async_create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    async def async_create_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-commit-comment"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoCommentsCommentIdReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-a-commit-comment-reaction"""

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-a-commit-comment-reaction"""

        url = f"/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-an-issue-comment"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-an-issue-comment"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    def create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    def create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-an-issue-comment"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    async def async_create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    async def async_create_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-an-issue-comment"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-an-issue-comment-reaction"""

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_issue_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-an-issue-comment-reaction"""

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-an-issue"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-an-issue"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    def create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    def create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-an-issue"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    async def async_create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    async def async_create_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-an-issue"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoIssuesIssueNumberReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-an-issue-reaction"""

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-an-issue-reaction"""

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-pull-request-review-comment"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-pull-request-review-comment"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    def create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    def create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-pull-request-review-comment"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    async def async_create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    async def async_create_for_pull_request_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-pull-request-review-comment"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsCommentsCommentIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_pull_request_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-a-pull-request-comment-reaction"""

        url = (
            f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_pull_request_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-a-pull-request-comment-reaction"""

        url = (
            f"/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        content: Missing[
            Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-release"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        content: Missing[
            Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-release"""

        from typing import List

        from ..models import Reaction, BasicError

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    def create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"],
    ) -> Response[Reaction]: ...

    def create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-release"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoReleasesReleaseIdReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesReleaseIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    async def async_create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal["+1", "laugh", "heart", "hooray", "rocket", "eyes"],
    ) -> Response[Reaction]: ...

    async def async_create_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdReactionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-release"""

        from ..models import (
            Reaction,
            ValidationError,
            ReposOwnerRepoReleasesReleaseIdReactionsPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesReleaseIdReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
            error_models={
                "422": ValidationError,
            },
        )

    def delete_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-a-release-reaction"""

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_for_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        reaction_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/reactions/reactions#delete-a-release-reaction"""

        url = f"/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-comment-legacy"""

        from typing import List

        from ..models import Reaction

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    async def async_list_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-comment-legacy"""

        from typing import List

        from ..models import Reaction

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    @overload
    def create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    def create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    def create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-comment-legacy"""

        from ..models import (
            Reaction,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    async def async_create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    async def async_create_for_team_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-comment-legacy"""

        from ..models import (
            Reaction,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberReactionsPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    def list_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-legacy"""

        from typing import List

        from ..models import Reaction

        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    async def async_list_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        content: Missing[
            Literal[
                "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Reaction]]:
        """See also: https://docs.github.com/rest/reactions/reactions#list-reactions-for-a-team-discussion-legacy"""

        from typing import List

        from ..models import Reaction

        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        params = {
            "content": content,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Reaction],
        )

    @overload
    def create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    def create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    def create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-legacy"""

        from ..models import (
            Reaction,
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )

    @overload
    async def async_create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType,
    ) -> Response[Reaction]: ...

    @overload
    async def async_create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        content: Literal[
            "+1", "-1", "laugh", "confused", "heart", "hooray", "rocket", "eyes"
        ],
    ) -> Response[Reaction]: ...

    async def async_create_for_team_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Reaction]:
        """See also: https://docs.github.com/rest/reactions/reactions#create-reaction-for-a-team-discussion-legacy"""

        from ..models import (
            Reaction,
            TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/reactions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberReactionsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Reaction,
        )
