"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from datetime import datetime
from typing import Union, Literal

from pydantic import Field

from githubkit.utils import UNSET
from githubkit.typing import Missing
from githubkit.compat import GitHubModel, model_rebuild

from .group_0001 import SimpleUser


class SecretScanningAlert(GitHubModel):
    """SecretScanningAlert"""

    number: Missing[int] = Field(
        default=UNSET, description="The security alert number."
    )
    created_at: Missing[datetime] = Field(
        default=UNSET,
        description="The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    updated_at: Missing[Union[None, datetime]] = Field(default=UNSET)
    url: Missing[str] = Field(
        default=UNSET, description="The REST API URL of the alert resource."
    )
    html_url: Missing[str] = Field(
        default=UNSET, description="The GitHub URL of the alert resource."
    )
    locations_url: Missing[str] = Field(
        default=UNSET,
        description="The REST API URL of the code locations for this alert.",
    )
    state: Missing[Literal["open", "resolved"]] = Field(
        default=UNSET,
        description="Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.",
    )
    resolution: Missing[
        Union[None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]]
    ] = Field(
        default=UNSET,
        description="**Required when the `state` is `resolved`.** The reason for resolving the alert.",
    )
    resolved_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    resolved_by: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    resolution_comment: Missing[Union[str, None]] = Field(
        default=UNSET, description="An optional comment to resolve an alert."
    )
    secret_type: Missing[str] = Field(
        default=UNSET, description="The type of secret that secret scanning detected."
    )
    secret_type_display_name: Missing[str] = Field(
        default=UNSET,
        description='User-friendly name for the detected secret, matching the `secret_type`.\nFor a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."',
    )
    secret: Missing[str] = Field(
        default=UNSET, description="The secret that was detected."
    )
    push_protection_bypassed: Missing[Union[bool, None]] = Field(
        default=UNSET,
        description="Whether push protection was bypassed for the detected secret.",
    )
    push_protection_bypassed_by: Missing[Union[None, SimpleUser]] = Field(default=UNSET)
    push_protection_bypassed_at: Missing[Union[datetime, None]] = Field(
        default=UNSET,
        description="The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.",
    )
    validity: Missing[Literal["active", "inactive", "unknown"]] = Field(
        default=UNSET, description="The token status as of the latest validity check."
    )


model_rebuild(SecretScanningAlert)

__all__ = ("SecretScanningAlert",)
