"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing_extensions import Annotated
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import Field, BaseModel

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import (
        Import,
        Migration,
        PorterAuthor,
        PorterLargeFile,
        MinimalRepository,
    )
    from ..types import (
        UserMigrationsPostBodyType,
        OrgsOrgMigrationsPostBodyType,
        ReposOwnerRepoImportPutBodyType,
        ReposOwnerRepoImportPatchBodyType,
        ReposOwnerRepoImportLfsPatchBodyType,
        ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType,
    )


class MigrationsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        exclude: Missing[List[Literal["repositories"]]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Migration]]:
        """See also: https://docs.github.com/rest/migrations/orgs#list-organization-migrations"""

        from typing import List

        from ..models import Migration

        url = f"/orgs/{org}/migrations"

        params = {
            "per_page": per_page,
            "page": page,
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Migration],
        )

    async def async_list_for_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        exclude: Missing[List[Literal["repositories"]]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Migration]]:
        """See also: https://docs.github.com/rest/migrations/orgs#list-organization-migrations"""

        from typing import List

        from ..models import Migration

        url = f"/orgs/{org}/migrations"

        params = {
            "per_page": per_page,
            "page": page,
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Migration],
        )

    @overload
    def start_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgMigrationsPostBodyType,
    ) -> Response[Migration]: ...

    @overload
    def start_for_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        repositories: List[str],
        lock_repositories: Missing[bool] = UNSET,
        exclude_metadata: Missing[bool] = UNSET,
        exclude_git_data: Missing[bool] = UNSET,
        exclude_attachments: Missing[bool] = UNSET,
        exclude_releases: Missing[bool] = UNSET,
        exclude_owner_projects: Missing[bool] = UNSET,
        org_metadata_only: Missing[bool] = UNSET,
        exclude: Missing[List[Literal["repositories"]]] = UNSET,
    ) -> Response[Migration]: ...

    def start_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Migration]:
        """See also: https://docs.github.com/rest/migrations/orgs#start-an-organization-migration"""

        from ..models import (
            Migration,
            BasicError,
            ValidationError,
            OrgsOrgMigrationsPostBody,
        )

        url = f"/orgs/{org}/migrations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgMigrationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_start_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgMigrationsPostBodyType,
    ) -> Response[Migration]: ...

    @overload
    async def async_start_for_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        repositories: List[str],
        lock_repositories: Missing[bool] = UNSET,
        exclude_metadata: Missing[bool] = UNSET,
        exclude_git_data: Missing[bool] = UNSET,
        exclude_attachments: Missing[bool] = UNSET,
        exclude_releases: Missing[bool] = UNSET,
        exclude_owner_projects: Missing[bool] = UNSET,
        org_metadata_only: Missing[bool] = UNSET,
        exclude: Missing[List[Literal["repositories"]]] = UNSET,
    ) -> Response[Migration]: ...

    async def async_start_for_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Migration]:
        """See also: https://docs.github.com/rest/migrations/orgs#start-an-organization-migration"""

        from ..models import (
            Migration,
            BasicError,
            ValidationError,
            OrgsOrgMigrationsPostBody,
        )

        url = f"/orgs/{org}/migrations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgMigrationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_status_for_org(
        self,
        org: str,
        migration_id: int,
        exclude: Missing[List[Literal["repositories"]]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Migration]:
        """See also: https://docs.github.com/rest/migrations/orgs#get-an-organization-migration-status"""

        from ..models import Migration, BasicError

        url = f"/orgs/{org}/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Migration,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_for_org(
        self,
        org: str,
        migration_id: int,
        exclude: Missing[List[Literal["repositories"]]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Migration]:
        """See also: https://docs.github.com/rest/migrations/orgs#get-an-organization-migration-status"""

        from ..models import Migration, BasicError

        url = f"/orgs/{org}/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Migration,
            error_models={
                "404": BasicError,
            },
        )

    def download_archive_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/orgs#download-an-organization-migration-archive"""

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_download_archive_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/orgs#download-an-organization-migration-archive"""

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def delete_archive_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/orgs#delete-an-organization-migration-archive"""

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_archive_for_org(
        self,
        org: str,
        migration_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/orgs#delete-an-organization-migration-archive"""

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def unlock_repo_for_org(
        self,
        org: str,
        migration_id: int,
        repo_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/orgs#unlock-an-organization-repository"""

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_unlock_repo_for_org(
        self,
        org: str,
        migration_id: int,
        repo_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/orgs#unlock-an-organization-repository"""

        from ..models import BasicError

        url = f"/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_repos_for_org(
        self,
        org: str,
        migration_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/rest/migrations/orgs#list-repositories-in-an-organization-migration"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_for_org(
        self,
        org: str,
        migration_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/rest/migrations/orgs#list-repositories-in-an-organization-migration"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    def get_import_status(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Import]:
        """See also: https://docs.github.com/rest/migrations/source-imports#get-an-import-status"""

        from ..models import Import, BasicError

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Import,
            error_models={
                "404": BasicError,
                "503": BasicError,
            },
        )

    async def async_get_import_status(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Import]:
        """See also: https://docs.github.com/rest/migrations/source-imports#get-an-import-status"""

        from ..models import Import, BasicError

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Import,
            error_models={
                "404": BasicError,
                "503": BasicError,
            },
        )

    @overload
    def start_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoImportPutBodyType,
    ) -> Response[Import]: ...

    @overload
    def start_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        vcs_url: str,
        vcs: Missing[Literal["subversion", "git", "mercurial", "tfvc"]] = UNSET,
        vcs_username: Missing[str] = UNSET,
        vcs_password: Missing[str] = UNSET,
        tfvc_project: Missing[str] = UNSET,
    ) -> Response[Import]: ...

    def start_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoImportPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Import]:
        """See also: https://docs.github.com/rest/migrations/source-imports#start-an-import"""

        from ..models import (
            Import,
            BasicError,
            ValidationError,
            ReposOwnerRepoImportPutBody,
        )

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoImportPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Import,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "503": BasicError,
            },
        )

    @overload
    async def async_start_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoImportPutBodyType,
    ) -> Response[Import]: ...

    @overload
    async def async_start_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        vcs_url: str,
        vcs: Missing[Literal["subversion", "git", "mercurial", "tfvc"]] = UNSET,
        vcs_username: Missing[str] = UNSET,
        vcs_password: Missing[str] = UNSET,
        tfvc_project: Missing[str] = UNSET,
    ) -> Response[Import]: ...

    async def async_start_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoImportPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Import]:
        """See also: https://docs.github.com/rest/migrations/source-imports#start-an-import"""

        from ..models import (
            Import,
            BasicError,
            ValidationError,
            ReposOwnerRepoImportPutBody,
        )

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoImportPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Import,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "503": BasicError,
            },
        )

    def cancel_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/source-imports#cancel-an-import"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "503": BasicError,
            },
        )

    async def async_cancel_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/source-imports#cancel-an-import"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "503": BasicError,
            },
        )

    @overload
    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
    ) -> Response[Import]: ...

    @overload
    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        vcs_username: Missing[str] = UNSET,
        vcs_password: Missing[str] = UNSET,
        vcs: Missing[Literal["subversion", "tfvc", "git", "mercurial"]] = UNSET,
        tfvc_project: Missing[str] = UNSET,
    ) -> Response[Import]: ...

    def update_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Import]:
        """See also: https://docs.github.com/rest/migrations/source-imports#update-an-import"""

        from typing import Union

        from ..models import Import, BasicError, ReposOwnerRepoImportPatchBody

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(Union[ReposOwnerRepoImportPatchBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Import,
            error_models={
                "503": BasicError,
            },
        )

    @overload
    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
    ) -> Response[Import]: ...

    @overload
    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        vcs_username: Missing[str] = UNSET,
        vcs_password: Missing[str] = UNSET,
        vcs: Missing[Literal["subversion", "tfvc", "git", "mercurial"]] = UNSET,
        tfvc_project: Missing[str] = UNSET,
    ) -> Response[Import]: ...

    async def async_update_import(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoImportPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Import]:
        """See also: https://docs.github.com/rest/migrations/source-imports#update-an-import"""

        from typing import Union

        from ..models import Import, BasicError, ReposOwnerRepoImportPatchBody

        url = f"/repos/{owner}/{repo}/import"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(Union[ReposOwnerRepoImportPatchBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Import,
            error_models={
                "503": BasicError,
            },
        )

    def get_commit_authors(
        self,
        owner: str,
        repo: str,
        since: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PorterAuthor]]:
        """See also: https://docs.github.com/rest/migrations/source-imports#get-commit-authors"""

        from typing import List

        from ..models import BasicError, PorterAuthor

        url = f"/repos/{owner}/{repo}/import/authors"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PorterAuthor],
            error_models={
                "404": BasicError,
                "503": BasicError,
            },
        )

    async def async_get_commit_authors(
        self,
        owner: str,
        repo: str,
        since: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PorterAuthor]]:
        """See also: https://docs.github.com/rest/migrations/source-imports#get-commit-authors"""

        from typing import List

        from ..models import BasicError, PorterAuthor

        url = f"/repos/{owner}/{repo}/import/authors"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PorterAuthor],
            error_models={
                "404": BasicError,
                "503": BasicError,
            },
        )

    @overload
    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
    ) -> Response[PorterAuthor]: ...

    @overload
    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        email: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[PorterAuthor]: ...

    def map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PorterAuthor]:
        """See also: https://docs.github.com/rest/migrations/source-imports#map-a-commit-author"""

        from ..models import (
            BasicError,
            PorterAuthor,
            ValidationError,
            ReposOwnerRepoImportAuthorsAuthorIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/import/authors/{author_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoImportAuthorsAuthorIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PorterAuthor,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "503": BasicError,
            },
        )

    @overload
    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
    ) -> Response[PorterAuthor]: ...

    @overload
    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        email: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[PorterAuthor]: ...

    async def async_map_commit_author(
        self,
        owner: str,
        repo: str,
        author_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoImportAuthorsAuthorIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PorterAuthor]:
        """See also: https://docs.github.com/rest/migrations/source-imports#map-a-commit-author"""

        from ..models import (
            BasicError,
            PorterAuthor,
            ValidationError,
            ReposOwnerRepoImportAuthorsAuthorIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/import/authors/{author_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoImportAuthorsAuthorIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PorterAuthor,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "503": BasicError,
            },
        )

    def get_large_files(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PorterLargeFile]]:
        """See also: https://docs.github.com/rest/migrations/source-imports#get-large-files"""

        from typing import List

        from ..models import BasicError, PorterLargeFile

        url = f"/repos/{owner}/{repo}/import/large_files"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[PorterLargeFile],
            error_models={
                "503": BasicError,
            },
        )

    async def async_get_large_files(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PorterLargeFile]]:
        """See also: https://docs.github.com/rest/migrations/source-imports#get-large-files"""

        from typing import List

        from ..models import BasicError, PorterLargeFile

        url = f"/repos/{owner}/{repo}/import/large_files"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[PorterLargeFile],
            error_models={
                "503": BasicError,
            },
        )

    @overload
    def set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoImportLfsPatchBodyType,
    ) -> Response[Import]: ...

    @overload
    def set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        use_lfs: Literal["opt_in", "opt_out"],
    ) -> Response[Import]: ...

    def set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoImportLfsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Import]:
        """See also: https://docs.github.com/rest/migrations/source-imports#update-git-lfs-preference"""

        from ..models import (
            Import,
            BasicError,
            ValidationError,
            ReposOwnerRepoImportLfsPatchBody,
        )

        url = f"/repos/{owner}/{repo}/import/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoImportLfsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Import,
            error_models={
                "422": ValidationError,
                "503": BasicError,
            },
        )

    @overload
    async def async_set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoImportLfsPatchBodyType,
    ) -> Response[Import]: ...

    @overload
    async def async_set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        use_lfs: Literal["opt_in", "opt_out"],
    ) -> Response[Import]: ...

    async def async_set_lfs_preference(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoImportLfsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Import]:
        """See also: https://docs.github.com/rest/migrations/source-imports#update-git-lfs-preference"""

        from ..models import (
            Import,
            BasicError,
            ValidationError,
            ReposOwnerRepoImportLfsPatchBody,
        )

        url = f"/repos/{owner}/{repo}/import/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoImportLfsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Import,
            error_models={
                "422": ValidationError,
                "503": BasicError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Migration]]:
        """See also: https://docs.github.com/rest/migrations/users#list-user-migrations"""

        from typing import List

        from ..models import Migration, BasicError

        url = "/user/migrations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Migration],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Migration]]:
        """See also: https://docs.github.com/rest/migrations/users#list-user-migrations"""

        from typing import List

        from ..models import Migration, BasicError

        url = "/user/migrations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Migration],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def start_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserMigrationsPostBodyType,
    ) -> Response[Migration]: ...

    @overload
    def start_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        lock_repositories: Missing[bool] = UNSET,
        exclude_metadata: Missing[bool] = UNSET,
        exclude_git_data: Missing[bool] = UNSET,
        exclude_attachments: Missing[bool] = UNSET,
        exclude_releases: Missing[bool] = UNSET,
        exclude_owner_projects: Missing[bool] = UNSET,
        org_metadata_only: Missing[bool] = UNSET,
        exclude: Missing[List[Literal["repositories"]]] = UNSET,
        repositories: List[str],
    ) -> Response[Migration]: ...

    def start_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Migration]:
        """See also: https://docs.github.com/rest/migrations/users#start-a-user-migration"""

        from ..models import (
            Migration,
            BasicError,
            ValidationError,
            UserMigrationsPostBody,
        )

        url = "/user/migrations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserMigrationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Migration,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_start_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserMigrationsPostBodyType,
    ) -> Response[Migration]: ...

    @overload
    async def async_start_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        lock_repositories: Missing[bool] = UNSET,
        exclude_metadata: Missing[bool] = UNSET,
        exclude_git_data: Missing[bool] = UNSET,
        exclude_attachments: Missing[bool] = UNSET,
        exclude_releases: Missing[bool] = UNSET,
        exclude_owner_projects: Missing[bool] = UNSET,
        org_metadata_only: Missing[bool] = UNSET,
        exclude: Missing[List[Literal["repositories"]]] = UNSET,
        repositories: List[str],
    ) -> Response[Migration]: ...

    async def async_start_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserMigrationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Migration]:
        """See also: https://docs.github.com/rest/migrations/users#start-a-user-migration"""

        from ..models import (
            Migration,
            BasicError,
            ValidationError,
            UserMigrationsPostBody,
        )

        url = "/user/migrations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserMigrationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Migration,
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_status_for_authenticated_user(
        self,
        migration_id: int,
        exclude: Missing[List[str]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Migration]:
        """See also: https://docs.github.com/rest/migrations/users#get-a-user-migration-status"""

        from ..models import Migration, BasicError

        url = f"/user/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_status_for_authenticated_user(
        self,
        migration_id: int,
        exclude: Missing[List[str]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Migration]:
        """See also: https://docs.github.com/rest/migrations/users#get-a-user-migration-status"""

        from ..models import Migration, BasicError

        url = f"/user/migrations/{migration_id}"

        params = {
            "exclude": exclude,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Migration,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_archive_for_authenticated_user(
        self,
        migration_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/users#download-a-user-migration-archive"""

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_archive_for_authenticated_user(
        self,
        migration_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/users#download-a-user-migration-archive"""

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_archive_for_authenticated_user(
        self,
        migration_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/users#delete-a-user-migration-archive"""

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_archive_for_authenticated_user(
        self,
        migration_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/users#delete-a-user-migration-archive"""

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/archive"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def unlock_repo_for_authenticated_user(
        self,
        migration_id: int,
        repo_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/users#unlock-a-user-repository"""

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/repos/{repo_name}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_unlock_repo_for_authenticated_user(
        self,
        migration_id: int,
        repo_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/migrations/users#unlock-a-user-repository"""

        from ..models import BasicError

        url = f"/user/migrations/{migration_id}/repos/{repo_name}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_repos_for_authenticated_user(
        self,
        migration_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/rest/migrations/users#list-repositories-for-a-user-migration"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/user/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_for_authenticated_user(
        self,
        migration_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/rest/migrations/users#list-repositories-for-a-user-migration"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/user/migrations/{migration_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )
