"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

python -m codegen && isort . && black .

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing_extensions import Annotated
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import Field, BaseModel

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from datetime import datetime
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import (
        Commit,
        DiffEntry,
        PullRequest,
        ReviewComment,
        PullRequestReview,
        PullRequestSimple,
        PullRequestMergeResult,
        PullRequestReviewComment,
        PullRequestReviewRequest,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
    )
    from ..types import (
        ReposOwnerRepoPullsPostBodyType,
        ReposOwnerRepoPullsPullNumberPatchBodyType,
        ReposOwnerRepoPullsPullNumberMergePutBodyType,
        ReposOwnerRepoPullsPullNumberReviewsPostBodyType,
        ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
        ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType,
        ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
        ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
        ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
        ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
        ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
        ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
        ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType,
        ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
    )


class PullsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        owner: str,
        repo: str,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        head: Missing[str] = UNSET,
        base: Missing[str] = UNSET,
        sort: Missing[
            Literal["created", "updated", "popularity", "long-running"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestSimple]]:
        """See also: https://docs.github.com/rest/pulls/pulls#list-pull-requests"""

        from typing import List

        from ..models import ValidationError, PullRequestSimple

        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list(
        self,
        owner: str,
        repo: str,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        head: Missing[str] = UNSET,
        base: Missing[str] = UNSET,
        sort: Missing[
            Literal["created", "updated", "popularity", "long-running"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestSimple]]:
        """See also: https://docs.github.com/rest/pulls/pulls#list-pull-requests"""

        from typing import List

        from ..models import ValidationError, PullRequestSimple

        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPostBodyType,
    ) -> Response[PullRequest]: ...

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        head: str,
        head_repo: Missing[str] = UNSET,
        base: str,
        body: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
        draft: Missing[bool] = UNSET,
        issue: Missing[int] = UNSET,
    ) -> Response[PullRequest]: ...

    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest]:
        """See also: https://docs.github.com/rest/pulls/pulls#create-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            ValidationError,
            ReposOwnerRepoPullsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPostBodyType,
    ) -> Response[PullRequest]: ...

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        head: str,
        head_repo: Missing[str] = UNSET,
        base: str,
        body: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
        draft: Missing[bool] = UNSET,
        issue: Missing[int] = UNSET,
    ) -> Response[PullRequest]: ...

    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest]:
        """See also: https://docs.github.com/rest/pulls/pulls#create-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            ValidationError,
            ReposOwnerRepoPullsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["created", "updated", "created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestReviewComment]]:
        """See also: https://docs.github.com/rest/pulls/comments#list-review-comments-in-a-repository"""

        from typing import List

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReviewComment],
        )

    async def async_list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["created", "updated", "created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestReviewComment]]:
        """See also: https://docs.github.com/rest/pulls/comments#list-review-comments-in-a-repository"""

        from typing import List

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReviewComment],
        )

    def get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequestReviewComment]:
        """See also: https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request"""

        from ..models import BasicError, PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequestReviewComment]:
        """See also: https://docs.github.com/rest/pulls/comments#get-a-review-comment-for-a-pull-request"""

        from ..models import BasicError, PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/pulls/comments#delete-a-review-comment-for-a-pull-request"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/pulls/comments#delete-a-review-comment-for-a-pull-request"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ) -> Response[PullRequestReviewComment]: ...

    @overload
    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReviewComment]: ...

    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment]:
        """See also: https://docs.github.com/rest/pulls/comments#update-a-review-comment-for-a-pull-request"""

        from ..models import (
            PullRequestReviewComment,
            ReposOwnerRepoPullsCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
        )

    @overload
    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ) -> Response[PullRequestReviewComment]: ...

    @overload
    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReviewComment]: ...

    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment]:
        """See also: https://docs.github.com/rest/pulls/comments#update-a-review-comment-for-a-pull-request"""

        from ..models import (
            PullRequestReviewComment,
            ReposOwnerRepoPullsCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
        )

    def get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequest]:
        """See also: https://docs.github.com/rest/pulls/pulls#get-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequest]:
        """See also: https://docs.github.com/rest/pulls/pulls#get-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
    ) -> Response[PullRequest]: ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        base: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
    ) -> Response[PullRequest]: ...

    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest]:
        """See also: https://docs.github.com/rest/pulls/pulls#update-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            ValidationError,
            ReposOwnerRepoPullsPullNumberPatchBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsPullNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
    ) -> Response[PullRequest]: ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        base: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
    ) -> Response[PullRequest]: ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest]:
        """See also: https://docs.github.com/rest/pulls/pulls#update-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            ValidationError,
            ReposOwnerRepoPullsPullNumberPatchBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsPullNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestReviewComment]]:
        """See also: https://docs.github.com/rest/pulls/comments#list-review-comments-on-a-pull-request"""

        from typing import List

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReviewComment],
        )

    async def async_list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestReviewComment]]:
        """See also: https://docs.github.com/rest/pulls/comments#list-review-comments-on-a-pull-request"""

        from typing import List

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReviewComment],
        )

    @overload
    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ) -> Response[PullRequestReviewComment]: ...

    @overload
    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
        commit_id: str,
        path: str,
        position: Missing[int] = UNSET,
        side: Missing[Literal["LEFT", "RIGHT"]] = UNSET,
        line: Missing[int] = UNSET,
        start_line: Missing[int] = UNSET,
        start_side: Missing[Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Missing[int] = UNSET,
        subject_type: Missing[Literal["line", "file"]] = UNSET,
    ) -> Response[PullRequestReviewComment]: ...

    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment]:
        """See also: https://docs.github.com/rest/pulls/comments#create-a-review-comment-for-a-pull-request"""

        from ..models import (
            BasicError,
            ValidationError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsPullNumberCommentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ) -> Response[PullRequestReviewComment]: ...

    @overload
    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
        commit_id: str,
        path: str,
        position: Missing[int] = UNSET,
        side: Missing[Literal["LEFT", "RIGHT"]] = UNSET,
        line: Missing[int] = UNSET,
        start_line: Missing[int] = UNSET,
        start_side: Missing[Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Missing[int] = UNSET,
        subject_type: Missing[Literal["line", "file"]] = UNSET,
    ) -> Response[PullRequestReviewComment]: ...

    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment]:
        """See also: https://docs.github.com/rest/pulls/comments#create-a-review-comment-for-a-pull-request"""

        from ..models import (
            BasicError,
            ValidationError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsPullNumberCommentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ) -> Response[PullRequestReviewComment]: ...

    @overload
    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReviewComment]: ...

    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment]:
        """See also: https://docs.github.com/rest/pulls/comments#create-a-reply-for-a-review-comment"""

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ) -> Response[PullRequestReviewComment]: ...

    @overload
    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReviewComment]: ...

    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment]:
        """See also: https://docs.github.com/rest/pulls/comments#create-a-reply-for-a-review-comment"""

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Commit]]:
        """See also: https://docs.github.com/rest/pulls/pulls#list-commits-on-a-pull-request"""

        from typing import List

        from ..models import Commit

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Commit],
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Commit]]:
        """See also: https://docs.github.com/rest/pulls/pulls#list-commits-on-a-pull-request"""

        from typing import List

        from ..models import Commit

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Commit],
        )

    def list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[DiffEntry]]:
        """See also: https://docs.github.com/rest/pulls/pulls#list-pull-requests-files"""

        from typing import List

        from ..models import (
            DiffEntry,
            BasicError,
            ValidationError,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[DiffEntry]]:
        """See also: https://docs.github.com/rest/pulls/pulls#list-pull-requests-files"""

        from typing import List

        from ..models import (
            DiffEntry,
            BasicError,
            ValidationError,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/pulls/pulls#check-if-a-pull-request-has-been-merged"""

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/pulls/pulls#check-if-a-pull-request-has-been-merged"""

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> Response[PullRequestMergeResult]: ...

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        commit_title: Missing[str] = UNSET,
        commit_message: Missing[str] = UNSET,
        sha: Missing[str] = UNSET,
        merge_method: Missing[Literal["merge", "squash", "rebase"]] = UNSET,
    ) -> Response[PullRequestMergeResult]: ...

    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestMergeResult]:
        """See also: https://docs.github.com/rest/pulls/pulls#merge-a-pull-request"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            PullRequestMergeResult,
            ReposOwnerRepoPullsPullNumberMergePutBody,
            ReposOwnerRepoPullsPullNumberMergePutResponse405,
            ReposOwnerRepoPullsPullNumberMergePutResponse409,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[ReposOwnerRepoPullsPullNumberMergePutBody, None], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> Response[PullRequestMergeResult]: ...

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        commit_title: Missing[str] = UNSET,
        commit_message: Missing[str] = UNSET,
        sha: Missing[str] = UNSET,
        merge_method: Missing[Literal["merge", "squash", "rebase"]] = UNSET,
    ) -> Response[PullRequestMergeResult]: ...

    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestMergeResult]:
        """See also: https://docs.github.com/rest/pulls/pulls#merge-a-pull-request"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            PullRequestMergeResult,
            ReposOwnerRepoPullsPullNumberMergePutBody,
            ReposOwnerRepoPullsPullNumberMergePutResponse405,
            ReposOwnerRepoPullsPullNumberMergePutResponse409,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[ReposOwnerRepoPullsPullNumberMergePutBody, None], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequestReviewRequest]:
        """See also: https://docs.github.com/rest/pulls/review-requests#get-all-requested-reviewers-for-a-pull-request"""

        from ..models import PullRequestReviewRequest

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewRequest,
        )

    async def async_list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequestReviewRequest]:
        """See also: https://docs.github.com/rest/pulls/review-requests#get-all-requested-reviewers-for-a-pull-request"""

        from ..models import PullRequestReviewRequest

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewRequest,
        )

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response[PullRequestSimple]: ...

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: List[str],
        team_reviewers: Missing[List[str]] = UNSET,
    ) -> Response[PullRequestSimple]: ...

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: Missing[List[str]] = UNSET,
        team_reviewers: List[str],
    ) -> Response[PullRequestSimple]: ...

    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple]:
        """See also: https://docs.github.com/rest/pulls/review-requests#request-reviewers-for-a-pull-request"""

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response[PullRequestSimple]: ...

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: List[str],
        team_reviewers: Missing[List[str]] = UNSET,
    ) -> Response[PullRequestSimple]: ...

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: Missing[List[str]] = UNSET,
        team_reviewers: List[str],
    ) -> Response[PullRequestSimple]: ...

    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple]:
        """See also: https://docs.github.com/rest/pulls/review-requests#request-reviewers-for-a-pull-request"""

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ) -> Response[PullRequestSimple]: ...

    @overload
    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: List[str],
        team_reviewers: Missing[List[str]] = UNSET,
    ) -> Response[PullRequestSimple]: ...

    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple]:
        """See also: https://docs.github.com/rest/pulls/review-requests#remove-requested-reviewers-from-a-pull-request"""

        from ..models import (
            ValidationError,
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ) -> Response[PullRequestSimple]: ...

    @overload
    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        reviewers: List[str],
        team_reviewers: Missing[List[str]] = UNSET,
    ) -> Response[PullRequestSimple]: ...

    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple]:
        """See also: https://docs.github.com/rest/pulls/review-requests#remove-requested-reviewers-from-a-pull-request"""

        from ..models import (
            ValidationError,
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    def list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestReview]]:
        """See also: https://docs.github.com/rest/pulls/reviews#list-reviews-for-a-pull-request"""

        from typing import List

        from ..models import PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReview],
        )

    async def async_list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestReview]]:
        """See also: https://docs.github.com/rest/pulls/reviews#list-reviews-for-a-pull-request"""

        from typing import List

        from ..models import PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestReview],
        )

    @overload
    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
    ) -> Response[PullRequestReview]: ...

    @overload
    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        commit_id: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        event: Missing[Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Missing[
            List[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType]
        ] = UNSET,
    ) -> Response[PullRequestReview]: ...

    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#create-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ValidationErrorSimple,
            ReposOwnerRepoPullsPullNumberReviewsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsPullNumberReviewsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
    ) -> Response[PullRequestReview]: ...

    @overload
    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        commit_id: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        event: Missing[Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Missing[
            List[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType]
        ] = UNSET,
    ) -> Response[PullRequestReview]: ...

    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#create-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ValidationErrorSimple,
            ReposOwnerRepoPullsPullNumberReviewsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPullsPullNumberReviewsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    def get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#get-a-review-for-a-pull-request"""

        from ..models import BasicError, PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#get-a-review-for-a-pull-request"""

        from ..models import BasicError, PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ) -> Response[PullRequestReview]: ...

    @overload
    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReview]: ...

    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#update-a-review-for-a-pull-request"""

        from ..models import (
            PullRequestReview,
            ValidationErrorSimple,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ) -> Response[PullRequestReview]: ...

    @overload
    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReview]: ...

    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#update-a-review-for-a-pull-request"""

        from ..models import (
            PullRequestReview,
            ValidationErrorSimple,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#delete-a-pending-review-for-a-pull-request"""

        from ..models import BasicError, PullRequestReview, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    async def async_delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#delete-a-pending-review-for-a-pull-request"""

        from ..models import BasicError, PullRequestReview, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ReviewComment]]:
        """See also: https://docs.github.com/rest/pulls/reviews#list-comments-for-a-pull-request-review"""

        from typing import List

        from ..models import BasicError, ReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ReviewComment]]:
        """See also: https://docs.github.com/rest/pulls/reviews#list-comments-for-a-pull-request-review"""

        from typing import List

        from ..models import BasicError, ReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
    ) -> Response[PullRequestReview]: ...

    @overload
    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        event: Missing[Literal["DISMISS"]] = UNSET,
    ) -> Response[PullRequestReview]: ...

    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#dismiss-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ValidationErrorSimple,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody,
        )

        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
    ) -> Response[PullRequestReview]: ...

    @overload
    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        event: Missing[Literal["DISMISS"]] = UNSET,
    ) -> Response[PullRequestReview]: ...

    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#dismiss-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ValidationErrorSimple,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody,
        )

        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ) -> Response[PullRequestReview]: ...

    @overload
    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: Missing[str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> Response[PullRequestReview]: ...

    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ValidationErrorSimple,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ) -> Response[PullRequestReview]: ...

    @overload
    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: Missing[str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> Response[PullRequestReview]: ...

    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview]:
        """See also: https://docs.github.com/rest/pulls/reviews#submit-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ValidationErrorSimple,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]: ...

    @overload
    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        expected_head_sha: Missing[str] = UNSET,
    ) -> Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]: ...

    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]:
        """See also: https://docs.github.com/rest/pulls/pulls#update-a-pull-request-branch"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutBody,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBody, None], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]: ...

    @overload
    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        expected_head_sha: Missing[str] = UNSET,
    ) -> Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]: ...

    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202]:
        """See also: https://docs.github.com/rest/pulls/pulls#update-a-pull-request-branch"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutBody,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBody, None], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )
