"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from datetime import datetime
from typing import List, Union, Literal

from pydantic import Field

from githubkit.utils import UNSET
from githubkit.typing import Missing
from githubkit.compat import GitHubModel, model_rebuild

from .group_0032 import Milestone
from .group_0357 import EnterpriseWebhooks
from .group_0360 import RepositoryWebhooks
from .group_0361 import SimpleUserWebhooks
from .group_0359 import OrganizationSimpleWebhooks


class WebhookPullRequestDemilestoned(GitHubModel):
    """pull_request demilestoned event"""

    action: Literal["demilestoned"] = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."\n',
    )
    milestone: Missing[Milestone] = Field(
        default=UNSET,
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    number: int = Field(description="The pull request number.")
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    pull_request: WebhookPullRequestDemilestonedPropPullRequest = Field(
        title="Pull Request"
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: Missing[SimpleUserWebhooks] = Field(
        default=UNSET,
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookPullRequestDemilestonedPropPullRequest(GitHubModel):
    """Pull Request"""

    links: WebhookPullRequestDemilestonedPropPullRequestPropLinks = Field(
        alias="_links"
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field()
    additions: Missing[int] = Field(default=UNSET)
    assignee: Union[WebhookPullRequestDemilestonedPropPullRequestPropAssignee, None] = (
        Field(title="User")
    )
    assignees: List[
        Union[WebhookPullRequestDemilestonedPropPullRequestPropAssigneesItems, None]
    ] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    auto_merge: Union[
        WebhookPullRequestDemilestonedPropPullRequestPropAutoMerge, None
    ] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
    )
    base: WebhookPullRequestDemilestonedPropPullRequestPropBase = Field()
    body: Union[str, None] = Field()
    changed_files: Missing[int] = Field(default=UNSET)
    closed_at: Union[datetime, None] = Field()
    comments: Missing[int] = Field(default=UNSET)
    comments_url: str = Field()
    commits: Missing[int] = Field(default=UNSET)
    commits_url: str = Field()
    created_at: datetime = Field()
    deletions: Missing[int] = Field(default=UNSET)
    diff_url: str = Field()
    draft: bool = Field(
        description="Indicates whether or not the pull request is a draft."
    )
    head: WebhookPullRequestDemilestonedPropPullRequestPropHead = Field()
    html_url: str = Field()
    id: int = Field()
    issue_url: str = Field()
    labels: List[WebhookPullRequestDemilestonedPropPullRequestPropLabelsItems] = Field()
    locked: bool = Field()
    maintainer_can_modify: Missing[bool] = Field(
        default=UNSET,
        description="Indicates whether maintainers can modify the pull request.",
    )
    merge_commit_sha: Union[str, None] = Field()
    mergeable: Missing[Union[bool, None]] = Field(default=UNSET)
    mergeable_state: Missing[str] = Field(default=UNSET)
    merged: Missing[Union[bool, None]] = Field(default=UNSET)
    merged_at: Union[datetime, None] = Field()
    merged_by: Missing[
        Union[WebhookPullRequestDemilestonedPropPullRequestPropMergedBy, None]
    ] = Field(default=UNSET, title="User")
    milestone: Union[
        WebhookPullRequestDemilestonedPropPullRequestPropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    node_id: str = Field()
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository."
    )
    patch_url: str = Field()
    rebaseable: Missing[Union[bool, None]] = Field(default=UNSET)
    requested_reviewers: List[
        Union[
            WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof0,
            None,
            WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof1,
        ]
    ] = Field()
    requested_teams: List[
        WebhookPullRequestDemilestonedPropPullRequestPropRequestedTeamsItems
    ] = Field()
    review_comment_url: str = Field()
    review_comments: Missing[int] = Field(default=UNSET)
    review_comments_url: str = Field()
    state: Literal["open", "closed"] = Field(
        description="State of this Pull Request. Either `open` or `closed`."
    )
    statuses_url: str = Field()
    title: str = Field(description="The title of the pull request.")
    updated_at: datetime = Field()
    url: str = Field()
    user: Union[WebhookPullRequestDemilestonedPropPullRequestPropUser, None] = Field(
        title="User"
    )


class WebhookPullRequestDemilestonedPropPullRequestPropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropAssigneesItems(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropAutoMerge(GitHubModel):
    """PullRequestAutoMerge

    The status of auto merging a pull request.
    """

    commit_message: Union[str, None] = Field(
        description="Commit message for the merge commit."
    )
    commit_title: Union[str, None] = Field(
        description="Title for the merge commit message."
    )
    enabled_by: Union[
        WebhookPullRequestDemilestonedPropPullRequestPropAutoMergePropEnabledBy, None
    ] = Field(title="User")
    merge_method: Literal["merge", "squash", "rebase"] = Field(
        description="The merge method to use."
    )


class WebhookPullRequestDemilestonedPropPullRequestPropAutoMergePropEnabledBy(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookPullRequestDemilestonedPropPullRequestPropMergedBy(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropMilestone(GitHubModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[
        WebhookPullRequestDemilestonedPropPullRequestPropMilestonePropCreator, None
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropMilestonePropCreator(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof0(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropLinks(GitHubModel):
    """WebhookPullRequestDemilestonedPropPullRequestPropLinks"""

    comments: WebhookPullRequestDemilestonedPropPullRequestPropLinksPropComments = (
        Field(title="Link")
    )
    commits: WebhookPullRequestDemilestonedPropPullRequestPropLinksPropCommits = Field(
        title="Link"
    )
    html: WebhookPullRequestDemilestonedPropPullRequestPropLinksPropHtml = Field(
        title="Link"
    )
    issue: WebhookPullRequestDemilestonedPropPullRequestPropLinksPropIssue = Field(
        title="Link"
    )
    review_comment: WebhookPullRequestDemilestonedPropPullRequestPropLinksPropReviewComment = Field(
        title="Link"
    )
    review_comments: WebhookPullRequestDemilestonedPropPullRequestPropLinksPropReviewComments = Field(
        title="Link"
    )
    self_: WebhookPullRequestDemilestonedPropPullRequestPropLinksPropSelf = Field(
        alias="self", title="Link"
    )
    statuses: WebhookPullRequestDemilestonedPropPullRequestPropLinksPropStatuses = (
        Field(title="Link")
    )


class WebhookPullRequestDemilestonedPropPullRequestPropLinksPropComments(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropLinksPropCommits(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropLinksPropHtml(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropLinksPropIssue(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropLinksPropReviewComment(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropLinksPropReviewComments(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropLinksPropSelf(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropLinksPropStatuses(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropBase(GitHubModel):
    """WebhookPullRequestDemilestonedPropPullRequestPropBase"""

    label: str = Field()
    ref: str = Field()
    repo: WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepo = Field(
        title="Repository", description="A git repository"
    )
    sha: str = Field()
    user: Union[WebhookPullRequestDemilestonedPropPullRequestPropBasePropUser, None] = (
        Field(title="User")
    )


class WebhookPullRequestDemilestonedPropPullRequestPropBasePropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepo(GitHubModel):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_discussions: bool = Field(
        default=False, description="Whether discussions are enabled."
    )
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[
        WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropLicense, None
    ] = Field(alias="license", title="License")
    master_branch: Missing[str] = Field(default=UNSET)
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[
        WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    squash_merge_commit_title: Missing[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]] = (
        Field(
            default=UNSET,
            description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        )
    )
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: List[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    use_squash_pr_title_as_default: Missing[bool] = Field(
        default=UNSET,
        description="Whether a squash merge commit can use the pull request title as default.",
    )
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropLicense(
    GitHubModel
):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropPermissions(
    GitHubModel
):
    """WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropHead(GitHubModel):
    """WebhookPullRequestDemilestonedPropPullRequestPropHead"""

    label: str = Field()
    ref: str = Field()
    repo: WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepo = Field(
        title="Repository", description="A git repository"
    )
    sha: str = Field()
    user: Union[WebhookPullRequestDemilestonedPropPullRequestPropHeadPropUser, None] = (
        Field(title="User")
    )


class WebhookPullRequestDemilestonedPropPullRequestPropHeadPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepo(GitHubModel):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_discussions: bool = Field(
        default=False, description="Whether discussions are enabled."
    )
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[
        WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropLicense, None
    ] = Field(alias="license", title="License")
    master_branch: Missing[str] = Field(default=UNSET)
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[
        WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    squash_merge_commit_title: Missing[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]] = (
        Field(
            default=UNSET,
            description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        )
    )
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: List[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    use_squash_pr_title_as_default: Missing[bool] = Field(
        default=UNSET,
        description="Whether a squash merge commit can use the pull request title as default.",
    )
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropLicense(
    GitHubModel
):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropPermissions(
    GitHubModel
):
    """WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof1(
    GitHubModel
):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="Description of the team"
    )
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(description="Unique identifier of the team")
    members_url: Missing[str] = Field(default=UNSET)
    name: str = Field(description="Name of the team")
    node_id: Missing[str] = Field(default=UNSET)
    parent: Missing[
        Union[
            WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof1PropParent,
            None,
        ]
    ] = Field(default=UNSET)
    permission: Missing[str] = Field(
        default=UNSET,
        description="Permission that the team will have for its repositories",
    )
    privacy: Missing[Literal["open", "closed", "secret"]] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET, description="URL for the team")


class WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof1PropParent(
    GitHubModel
):
    """WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof1Pr
    opParent
    """

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


class WebhookPullRequestDemilestonedPropPullRequestPropRequestedTeamsItems(GitHubModel):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="Description of the team"
    )
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(description="Unique identifier of the team")
    members_url: Missing[str] = Field(default=UNSET)
    name: str = Field(description="Name of the team")
    node_id: Missing[str] = Field(default=UNSET)
    parent: Missing[
        Union[
            WebhookPullRequestDemilestonedPropPullRequestPropRequestedTeamsItemsPropParent,
            None,
        ]
    ] = Field(default=UNSET)
    permission: Missing[str] = Field(
        default=UNSET,
        description="Permission that the team will have for its repositories",
    )
    privacy: Missing[Literal["open", "closed", "secret"]] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET, description="URL for the team")


class WebhookPullRequestDemilestonedPropPullRequestPropRequestedTeamsItemsPropParent(
    GitHubModel
):
    """WebhookPullRequestDemilestonedPropPullRequestPropRequestedTeamsItemsPropParent"""

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


model_rebuild(WebhookPullRequestDemilestoned)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequest)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropAssignee)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropAssigneesItems)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropAutoMerge)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropAutoMergePropEnabledBy)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLabelsItems)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropMergedBy)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropMilestone)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropMilestonePropCreator)
model_rebuild(
    WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof0
)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropUser)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLinks)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLinksPropComments)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLinksPropCommits)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLinksPropHtml)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLinksPropIssue)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLinksPropReviewComment)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLinksPropReviewComments)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLinksPropSelf)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropLinksPropStatuses)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropBase)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropBasePropUser)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepo)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropLicense)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropOwner)
model_rebuild(
    WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropPermissions
)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropHead)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropHeadPropUser)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepo)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropLicense)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropOwner)
model_rebuild(
    WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropPermissions
)
model_rebuild(
    WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof1
)
model_rebuild(
    WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof1PropParent
)
model_rebuild(WebhookPullRequestDemilestonedPropPullRequestPropRequestedTeamsItems)
model_rebuild(
    WebhookPullRequestDemilestonedPropPullRequestPropRequestedTeamsItemsPropParent
)

__all__ = (
    "WebhookPullRequestDemilestoned",
    "WebhookPullRequestDemilestonedPropPullRequest",
    "WebhookPullRequestDemilestonedPropPullRequestPropAssignee",
    "WebhookPullRequestDemilestonedPropPullRequestPropAssigneesItems",
    "WebhookPullRequestDemilestonedPropPullRequestPropAutoMerge",
    "WebhookPullRequestDemilestonedPropPullRequestPropAutoMergePropEnabledBy",
    "WebhookPullRequestDemilestonedPropPullRequestPropLabelsItems",
    "WebhookPullRequestDemilestonedPropPullRequestPropMergedBy",
    "WebhookPullRequestDemilestonedPropPullRequestPropMilestone",
    "WebhookPullRequestDemilestonedPropPullRequestPropMilestonePropCreator",
    "WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof0",
    "WebhookPullRequestDemilestonedPropPullRequestPropUser",
    "WebhookPullRequestDemilestonedPropPullRequestPropLinks",
    "WebhookPullRequestDemilestonedPropPullRequestPropLinksPropComments",
    "WebhookPullRequestDemilestonedPropPullRequestPropLinksPropCommits",
    "WebhookPullRequestDemilestonedPropPullRequestPropLinksPropHtml",
    "WebhookPullRequestDemilestonedPropPullRequestPropLinksPropIssue",
    "WebhookPullRequestDemilestonedPropPullRequestPropLinksPropReviewComment",
    "WebhookPullRequestDemilestonedPropPullRequestPropLinksPropReviewComments",
    "WebhookPullRequestDemilestonedPropPullRequestPropLinksPropSelf",
    "WebhookPullRequestDemilestonedPropPullRequestPropLinksPropStatuses",
    "WebhookPullRequestDemilestonedPropPullRequestPropBase",
    "WebhookPullRequestDemilestonedPropPullRequestPropBasePropUser",
    "WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepo",
    "WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropLicense",
    "WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropOwner",
    "WebhookPullRequestDemilestonedPropPullRequestPropBasePropRepoPropPermissions",
    "WebhookPullRequestDemilestonedPropPullRequestPropHead",
    "WebhookPullRequestDemilestonedPropPullRequestPropHeadPropUser",
    "WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepo",
    "WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropLicense",
    "WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropOwner",
    "WebhookPullRequestDemilestonedPropPullRequestPropHeadPropRepoPropPermissions",
    "WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof1",
    "WebhookPullRequestDemilestonedPropPullRequestPropRequestedReviewersItemsOneof1PropParent",
    "WebhookPullRequestDemilestonedPropPullRequestPropRequestedTeamsItems",
    "WebhookPullRequestDemilestonedPropPullRequestPropRequestedTeamsItemsPropParent",
)
