"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from datetime import datetime
from typing import List, Union, Literal

from pydantic import Field

from githubkit.utils import UNSET
from githubkit.typing import Missing
from githubkit.compat import GitHubModel, model_rebuild

from .group_0406 import EnterpriseWebhooks
from .group_0407 import SimpleInstallation
from .group_0409 import RepositoryWebhooks
from .group_0410 import SimpleUserWebhooks
from .group_0450 import WebhooksReviewComment
from .group_0408 import OrganizationSimpleWebhooks


class WebhookPullRequestReviewCommentDeleted(GitHubModel):
    """pull_request_review_comment deleted event"""

    action: Literal["deleted"] = Field()
    comment: WebhooksReviewComment = Field(
        title="Pull Request Review Comment",
        description="The [comment](https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#get-a-review-comment-for-a-pull-request) itself.",
    )
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/enterprise-cloud@latest//admin/overview/about-enterprise-accounts)."\n',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/enterprise-cloud@latest//apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    pull_request: WebhookPullRequestReviewCommentDeletedPropPullRequest = Field()
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    sender: SimpleUserWebhooks = Field(
        title="Simple User",
        description="The GitHub user that triggered the event. This property is included in every webhook payload.",
    )


class WebhookPullRequestReviewCommentDeletedPropPullRequest(GitHubModel):
    """WebhookPullRequestReviewCommentDeletedPropPullRequest"""

    links: WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinks = Field(
        alias="_links"
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field()
    assignee: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropAssignee, None
    ] = Field(title="User")
    assignees: List[
        Union[
            WebhookPullRequestReviewCommentDeletedPropPullRequestPropAssigneesItems,
            None,
        ]
    ] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    auto_merge: Missing[
        Union[WebhookPullRequestReviewCommentDeletedPropPullRequestPropAutoMerge, None]
    ] = Field(
        default=UNSET,
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
    )
    base: WebhookPullRequestReviewCommentDeletedPropPullRequestPropBase = Field()
    body: Union[str, None] = Field()
    closed_at: Union[str, None] = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    created_at: str = Field()
    diff_url: str = Field()
    draft: Missing[bool] = Field(default=UNSET)
    head: WebhookPullRequestReviewCommentDeletedPropPullRequestPropHead = Field()
    html_url: str = Field()
    id: int = Field()
    issue_url: str = Field()
    labels: List[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropLabelsItems
    ] = Field()
    locked: bool = Field()
    merge_commit_sha: Union[str, None] = Field()
    merged_at: Union[str, None] = Field()
    milestone: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    node_id: str = Field()
    number: int = Field()
    patch_url: str = Field()
    requested_reviewers: List[
        Union[
            WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof0,
            None,
            WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof1,
        ]
    ] = Field()
    requested_teams: List[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedTeamsItems
    ] = Field()
    review_comment_url: str = Field()
    review_comments_url: str = Field()
    state: Literal["open", "closed"] = Field()
    statuses_url: str = Field()
    title: str = Field()
    updated_at: str = Field()
    url: str = Field()
    user: Union[WebhookPullRequestReviewCommentDeletedPropPullRequestPropUser, None] = (
        Field(title="User")
    )


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropAssigneesItems(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropAutoMerge(GitHubModel):
    """PullRequestAutoMerge

    The status of auto merging a pull request.
    """

    commit_message: Union[str, None] = Field(
        description="Commit message for the merge commit."
    )
    commit_title: Union[str, None] = Field(
        description="Title for the merge commit message."
    )
    enabled_by: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropAutoMergePropEnabledBy,
        None,
    ] = Field(title="User")
    merge_method: Literal["merge", "squash", "rebase"] = Field(
        description="The merge method to use."
    )


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropAutoMergePropEnabledBy(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropMilestone(GitHubModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropMilestonePropCreator,
        None,
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropMilestonePropCreator(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof0(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinks(GitHubModel):
    """WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinks"""

    comments: WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropComments = Field(
        title="Link"
    )
    commits: WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropCommits = Field(
        title="Link"
    )
    html: WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropHtml = (
        Field(title="Link")
    )
    issue: WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropIssue = (
        Field(title="Link")
    )
    review_comment: WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropReviewComment = Field(
        title="Link"
    )
    review_comments: WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropReviewComments = Field(
        title="Link"
    )
    self_: WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropSelf = (
        Field(alias="self", title="Link")
    )
    statuses: WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropStatuses = Field(
        title="Link"
    )


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropComments(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropCommits(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropHtml(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropIssue(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropReviewComment(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropReviewComments(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropSelf(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropStatuses(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropBase(GitHubModel):
    """WebhookPullRequestReviewCommentDeletedPropPullRequestPropBase"""

    label: str = Field()
    ref: str = Field()
    repo: WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepo = Field(
        title="Repository", description="A git repository"
    )
    sha: str = Field()
    user: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropUser, None
    ] = Field(title="User")


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropUser(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepo(
    GitHubModel
):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_discussions: bool = Field(
        default=False, description="Whether discussions are enabled."
    )
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropLicense,
        None,
    ] = Field(alias="license", title="License")
    master_branch: Missing[str] = Field(default=UNSET)
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    squash_merge_commit_title: Missing[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]] = (
        Field(
            default=UNSET,
            description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        )
    )
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: List[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    use_squash_pr_title_as_default: Missing[bool] = Field(
        default=UNSET,
        description="Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.",
    )
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropLicense(
    GitHubModel
):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropPermissions(
    GitHubModel
):
    """WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropPermiss
    ions
    """

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropHead(GitHubModel):
    """WebhookPullRequestReviewCommentDeletedPropPullRequestPropHead"""

    label: str = Field()
    ref: str = Field()
    repo: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepo, None
    ] = Field(title="Repository", description="A git repository")
    sha: str = Field()
    user: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropUser, None
    ] = Field(title="User")


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepo(
    GitHubModel
):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_discussions: bool = Field(
        default=False, description="Whether discussions are enabled."
    )
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropLicense,
        None,
    ] = Field(alias="license", title="License")
    master_branch: Missing[str] = Field(default=UNSET)
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropOwner,
        None,
    ] = Field(title="User")
    permissions: Missing[
        WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    squash_merge_commit_title: Missing[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]] = (
        Field(
            default=UNSET,
            description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        )
    )
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: List[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    use_squash_pr_title_as_default: Missing[bool] = Field(
        default=UNSET,
        description="Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.",
    )
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropLicense(
    GitHubModel
):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropPermissions(
    GitHubModel
):
    """WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropPermiss
    ions
    """

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropUser(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof1(
    GitHubModel
):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="Description of the team"
    )
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(description="Unique identifier of the team")
    members_url: Missing[str] = Field(default=UNSET)
    name: str = Field(description="Name of the team")
    node_id: Missing[str] = Field(default=UNSET)
    parent: Missing[
        Union[
            WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof1PropParent,
            None,
        ]
    ] = Field(default=UNSET)
    permission: Missing[str] = Field(
        default=UNSET,
        description="Permission that the team will have for its repositories",
    )
    privacy: Missing[Literal["open", "closed", "secret"]] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET, description="URL for the team")


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof1PropParent(
    GitHubModel
):
    """WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItems
    Oneof1PropParent
    """

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedTeamsItems(
    GitHubModel
):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="Description of the team"
    )
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(description="Unique identifier of the team")
    members_url: Missing[str] = Field(default=UNSET)
    name: str = Field(description="Name of the team")
    node_id: Missing[str] = Field(default=UNSET)
    parent: Missing[
        Union[
            WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedTeamsItemsPropParent,
            None,
        ]
    ] = Field(default=UNSET)
    permission: Missing[str] = Field(
        default=UNSET,
        description="Permission that the team will have for its repositories",
    )
    privacy: Missing[Literal["open", "closed", "secret"]] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET, description="URL for the team")


class WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedTeamsItemsPropParent(
    GitHubModel
):
    """WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedTeamsItemsProp
    Parent
    """

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


model_rebuild(WebhookPullRequestReviewCommentDeleted)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequest)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropAssignee)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropAssigneesItems)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropAutoMerge)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropAutoMergePropEnabledBy
)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropLabelsItems)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropMilestone)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropMilestonePropCreator
)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof0
)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropUser)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinks)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropComments
)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropCommits)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropHtml)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropIssue)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropReviewComment
)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropReviewComments
)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropSelf)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropStatuses
)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropBase)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropUser)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepo)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropLicense
)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropOwner
)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropPermissions
)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropHead)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepo)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropLicense
)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropOwner
)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropPermissions
)
model_rebuild(WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropUser)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof1
)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof1PropParent
)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedTeamsItems
)
model_rebuild(
    WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedTeamsItemsPropParent
)

__all__ = (
    "WebhookPullRequestReviewCommentDeleted",
    "WebhookPullRequestReviewCommentDeletedPropPullRequest",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropAssignee",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropAssigneesItems",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropAutoMerge",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropAutoMergePropEnabledBy",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLabelsItems",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropMilestone",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropMilestonePropCreator",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof0",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropUser",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinks",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropComments",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropCommits",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropHtml",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropIssue",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropReviewComment",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropReviewComments",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropSelf",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropLinksPropStatuses",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropBase",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropUser",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepo",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropLicense",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropOwner",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropBasePropRepoPropPermissions",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropHead",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepo",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropLicense",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropOwner",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropRepoPropPermissions",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropHeadPropUser",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof1",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedReviewersItemsOneof1PropParent",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedTeamsItems",
    "WebhookPullRequestReviewCommentDeletedPropPullRequestPropRequestedTeamsItemsPropParent",
)
