"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from datetime import datetime
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.response import Response
    from githubkit.typing import Missing, FileTypes

    from ..models import (
        Tag,
        Hook,
        Page,
        Team,
        Topic,
        Commit,
        Status,
        Release,
        Activity,
        Autolink,
        Language,
        DeployKey,
        PageBuild,
        RuleSuite,
        Deployment,
        FileCommit,
        Repository,
        SimpleUser,
        BranchShort,
        ContentFile,
        Contributor,
        Environment,
        Integration,
        ShortBranch,
        ViewTraffic,
        CloneTraffic,
        Collaborator,
        HookDelivery,
        ReleaseAsset,
        CommitComment,
        TagProtection,
        WebhookConfig,
        CommitActivity,
        ContentSymlink,
        ContentTraffic,
        FullRepository,
        MergedUpstream,
        PageDeployment,
        PageBuildStatus,
        ProtectedBranch,
        ReferrerTraffic,
        RuleSuitesItems,
        BranchProtection,
        CodeownersErrors,
        CommitComparison,
        CommunityProfile,
        ContentSubmodule,
        DeploymentStatus,
        HookDeliveryItem,
        PagesHealthCheck,
        MinimalRepository,
        PullRequestSimple,
        RepositoryRuleset,
        StatusCheckPolicy,
        ParticipationStats,
        ContributorActivity,
        CustomPropertyValue,
        ReleaseNotesContent,
        BranchWithProtection,
        CombinedCommitStatus,
        RepositoryInvitation,
        ContentDirectoryItems,
        PagesDeploymentStatus,
        DeploymentBranchPolicy,
        BranchRestrictionPolicy,
        DeploymentProtectionRule,
        CheckAutomatedSecurityFixes,
        ProtectedBranchAdminEnforced,
        RepositoryRuleDetailedOneof0,
        RepositoryRuleDetailedOneof1,
        RepositoryRuleDetailedOneof2,
        RepositoryRuleDetailedOneof3,
        RepositoryRuleDetailedOneof4,
        RepositoryRuleDetailedOneof5,
        RepositoryRuleDetailedOneof6,
        RepositoryRuleDetailedOneof7,
        RepositoryRuleDetailedOneof8,
        RepositoryRuleDetailedOneof9,
        RepositoryRuleDetailedOneof10,
        RepositoryRuleDetailedOneof11,
        RepositoryRuleDetailedOneof12,
        RepositoryRuleDetailedOneof13,
        RepositoryRuleDetailedOneof14,
        RepositoryRuleDetailedOneof15,
        ProtectedBranchPullRequestReview,
        RepositoryCollaboratorPermission,
        ReposOwnerRepoEnvironmentsGetResponse200,
        ReposOwnerRepoAttestationsPostResponse201,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
    )
    from ..types import (
        WebhookConfigType,
        UserReposPostBodyType,
        CustomPropertyValueType,
        OrgsOrgReposPostBodyType,
        RepositoryRuleUpdateType,
        RepositoryRuleOneof14Type,
        RepositoryRuleOneof15Type,
        RepositoryRuleOneof16Type,
        RepositoryRuleOneof17Type,
        RepositoryRuleCreationType,
        RepositoryRuleDeletionType,
        OrgsOrgRulesetsPostBodyType,
        RepositoryRuleWorkflowsType,
        ReposOwnerRepoPatchBodyType,
        RepositoryRulePullRequestType,
        OrgRulesetConditionsOneof0Type,
        OrgRulesetConditionsOneof1Type,
        OrgRulesetConditionsOneof2Type,
        RepositoryRuleCodeScanningType,
        ReposOwnerRepoKeysPostBodyType,
        RepositoryRulesetConditionsType,
        ReposOwnerRepoForksPostBodyType,
        ReposOwnerRepoHooksPostBodyType,
        ReposOwnerRepoTopicsPutBodyType,
        RepositoryRuleNonFastForwardType,
        RepositoryRulesetBypassActorType,
        RepositoryRuleTagNamePatternType,
        ReposOwnerRepoMergesPostBodyType,
        DeploymentBranchPolicySettingsType,
        ReposOwnerRepoReleasesPostBodyType,
        ReposOwnerRepoRulesetsPostBodyType,
        ReposOwnerRepoTransferPostBodyType,
        OrgsOrgRulesetsRulesetIdPutBodyType,
        RepositoryRuleBranchNamePatternType,
        ReposOwnerRepoAutolinksPostBodyType,
        RepositoryRuleRequiredSignaturesType,
        ReposOwnerRepoDispatchesPostBodyType,
        ReposOwnerRepoPagesPutBodyAnyof0Type,
        ReposOwnerRepoPagesPutBodyAnyof1Type,
        ReposOwnerRepoPagesPutBodyAnyof2Type,
        ReposOwnerRepoPagesPutBodyAnyof3Type,
        ReposOwnerRepoPagesPutBodyAnyof4Type,
        DeploymentBranchPolicyNamePatternType,
        RepositoryRuleRequiredDeploymentsType,
        ReposOwnerRepoContentsPathPutBodyType,
        ReposOwnerRepoDeploymentsPostBodyType,
        ReposOwnerRepoPagesPostBodyAnyof0Type,
        ReposOwnerRepoPagesPostBodyAnyof1Type,
        ReposOwnerRepoStatusesShaPostBodyType,
        RepositoryRuleCommitMessagePatternType,
        RepositoryRuleRequiredStatusChecksType,
        ReposOwnerRepoAttestationsPostBodyType,
        ReposOwnerRepoHooksHookIdPatchBodyType,
        RepositoryRuleCommitterEmailPatternType,
        RepositoryRuleRequiredLinearHistoryType,
        ReposOwnerRepoMergeUpstreamPostBodyType,
        ReposOwnerRepoContentsPathDeleteBodyType,
        ReposOwnerRepoTagsProtectionPostBodyType,
        ReposOwnerRepoHooksPostBodyPropConfigType,
        ReposOwnerRepoPagesPostBodyPropSourceType,
        RepositoryRuleCommitAuthorEmailPatternType,
        ReposOwnerRepoPagesDeploymentsPostBodyType,
        ReposOwnerRepoRulesetsRulesetIdPutBodyType,
        ReposOwnerRepoPropertiesValuesPatchBodyType,
        OrgsOrgReposPostBodyPropCustomPropertiesType,
        ReposOwnerRepoCommentsCommentIdPatchBodyType,
        ReposOwnerRepoHooksHookIdConfigPatchBodyType,
        ReposOwnerRepoReleasesReleaseIdPatchBodyType,
        DeploymentBranchPolicyNamePatternWithTypeType,
        ReposOwnerRepoBranchesBranchRenamePostBodyType,
        ReposOwnerRepoCollaboratorsUsernamePutBodyType,
        ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ReposOwnerRepoContentsPathPutBodyPropAuthorType,
        ReposOwnerRepoReleasesGenerateNotesPostBodyType,
        ReposOwnerRepoAttestationsPostBodyPropBundleType,
        ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyType,
        ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
        ReposOwnerRepoContentsPathDeleteBodyPropAuthorType,
        ReposOwnerRepoContentsPathPutBodyPropCommitterType,
        ReposOwnerRepoInvitationsInvitationIdPatchBodyType,
        ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType,
        ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType,
        ReposOwnerRepoContentsPathDeleteBodyPropCommitterType,
        ReposOwnerRepoDispatchesPostBodyPropClientPayloadType,
        ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type,
        ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType,
        ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType,
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
    )


class ReposClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_org(
        self,
        org: str,
        type: Missing[
            Literal["all", "private", "forks", "sources", "member", "internal"]
        ] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-organization-repositories"""

        from typing import List

        from ..models import MinimalRepository

        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    async def async_list_for_org(
        self,
        org: str,
        type: Missing[
            Literal["all", "private", "forks", "sources", "member", "internal"]
        ] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-organization-repositories"""

        from typing import List

        from ..models import MinimalRepository

        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    @overload
    def create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgReposPostBodyType,
    ) -> Response[FullRepository]: ...

    @overload
    def create_in_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        custom_properties: Missing[
            OrgsOrgReposPostBodyPropCustomPropertiesType
        ] = UNSET,
    ) -> Response[FullRepository]: ...

    def create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-an-organization-repository"""

        from ..models import (
            BasicError,
            FullRepository,
            ValidationError,
            OrgsOrgReposPostBody,
        )

        url = f"/orgs/{org}/repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgReposPostBodyType,
    ) -> Response[FullRepository]: ...

    @overload
    async def async_create_in_org(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        custom_properties: Missing[
            OrgsOrgReposPostBodyPropCustomPropertiesType
        ] = UNSET,
    ) -> Response[FullRepository]: ...

    async def async_create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-an-organization-repository"""

        from ..models import (
            BasicError,
            FullRepository,
            ValidationError,
            OrgsOrgReposPostBody,
        )

        url = f"/orgs/{org}/repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_org_rulesets(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RepositoryRuleset]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#get-all-organization-repository-rulesets"""

        from typing import List

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rulesets(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RepositoryRuleset]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#get-all-organization-repository-rulesets"""

        from typing import List

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset]: ...

    @overload
    def create_org_ruleset(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof14Type,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    def create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#create-an-organization-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset, OrgsOrgRulesetsPostBody

        url = f"/orgs/{org}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset]: ...

    @overload
    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof14Type,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#create-an-organization-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset, OrgsOrgRulesetsPostBody

        url = f"/orgs/{org}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_rule_suites(
        self,
        org: str,
        repository_name: Missing[int] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RuleSuitesItems]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rule-suites#list-organization-rule-suites"""

        from typing import List

        from ..models import BasicError, RuleSuitesItems

        url = f"/orgs/{org}/rulesets/rule-suites"

        params = {
            "repository_name": repository_name,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rule_suites(
        self,
        org: str,
        repository_name: Missing[int] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RuleSuitesItems]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rule-suites#list-organization-rule-suites"""

        from typing import List

        from ..models import BasicError, RuleSuitesItems

        url = f"/orgs/{org}/rulesets/rule-suites"

        params = {
            "repository_name": repository_name,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_rule_suite(
        self,
        org: str,
        rule_suite_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RuleSuite]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rule-suites#get-an-organization-rule-suite"""

        from ..models import RuleSuite, BasicError

        url = f"/orgs/{org}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rule_suite(
        self,
        org: str,
        rule_suite_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RuleSuite]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rule-suites#get-an-organization-rule-suite"""

        from ..models import RuleSuite, BasicError

        url = f"/orgs/{org}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#get-an-organization-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#get-an-organization-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    @overload
    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof14Type,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#update-an-organization-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            OrgsOrgRulesetsRulesetIdPutBody,
        )

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    @overload
    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof14Type,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#update-an-organization-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            OrgsOrgRulesetsRulesetIdPutBody,
        )

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def delete_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#delete-an-organization-repository-ruleset"""

        from ..models import BasicError

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#delete-an-organization-repository-ruleset"""

        from ..models import BasicError

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#get-a-repository"""

        from ..models import BasicError, FullRepository

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#get-a-repository"""

        from ..models import BasicError, FullRepository

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#delete-a-repository"""

        from ..models import BasicError, ReposOwnerRepoDeleteResponse403

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    async def async_delete(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#delete-a-repository"""

        from ..models import BasicError, ReposOwnerRepoDeleteResponse403

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> Response[FullRepository]: ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        security_and_analysis: Missing[
            Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        default_branch: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        allow_update_branch: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        archived: Missing[bool] = UNSET,
        allow_forking: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
    ) -> Response[FullRepository]: ...

    def update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#update-a-repository"""

        from ..models import (
            BasicError,
            FullRepository,
            ValidationError,
            ReposOwnerRepoPatchBody,
        )

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> Response[FullRepository]: ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        security_and_analysis: Missing[
            Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        default_branch: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        allow_update_branch: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        archived: Missing[bool] = UNSET,
        allow_forking: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
    ) -> Response[FullRepository]: ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#update-a-repository"""

        from ..models import (
            BasicError,
            FullRepository,
            ValidationError,
            ReposOwnerRepoPatchBody,
        )

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_activities(
        self,
        owner: str,
        repo: str,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        actor: Missing[str] = UNSET,
        time_period: Missing[
            Literal["day", "week", "month", "quarter", "year"]
        ] = UNSET,
        activity_type: Missing[
            Literal[
                "push",
                "force_push",
                "branch_creation",
                "branch_deletion",
                "pr_merge",
                "merge_queue_merge",
            ]
        ] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Activity]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-activities"""

        from typing import List

        from ..models import Activity, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/activity"

        params = {
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
            "ref": ref,
            "actor": actor,
            "time_period": time_period,
            "activity_type": activity_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Activity],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_activities(
        self,
        owner: str,
        repo: str,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        actor: Missing[str] = UNSET,
        time_period: Missing[
            Literal["day", "week", "month", "quarter", "year"]
        ] = UNSET,
        activity_type: Missing[
            Literal[
                "push",
                "force_push",
                "branch_creation",
                "branch_deletion",
                "pr_merge",
                "merge_queue_merge",
            ]
        ] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Activity]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-activities"""

        from typing import List

        from ..models import Activity, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/activity"

        params = {
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
            "ref": ref,
            "actor": actor,
            "time_period": time_period,
            "activity_type": activity_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Activity],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoAttestationsPostBodyType,
    ) -> Response[ReposOwnerRepoAttestationsPostResponse201]: ...

    @overload
    def create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        bundle: ReposOwnerRepoAttestationsPostBodyPropBundleType,
    ) -> Response[ReposOwnerRepoAttestationsPostResponse201]: ...

    def create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoAttestationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReposOwnerRepoAttestationsPostResponse201]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-an-attestation"""

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoAttestationsPostBody,
            ReposOwnerRepoAttestationsPostResponse201,
        )

        url = f"/repos/{owner}/{repo}/attestations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoAttestationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoAttestationsPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoAttestationsPostBodyType,
    ) -> Response[ReposOwnerRepoAttestationsPostResponse201]: ...

    @overload
    async def async_create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        bundle: ReposOwnerRepoAttestationsPostBodyPropBundleType,
    ) -> Response[ReposOwnerRepoAttestationsPostResponse201]: ...

    async def async_create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoAttestationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReposOwnerRepoAttestationsPostResponse201]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-an-attestation"""

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoAttestationsPostBody,
            ReposOwnerRepoAttestationsPostResponse201,
        )

        url = f"/repos/{owner}/{repo}/attestations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoAttestationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoAttestationsPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_attestations(
        self,
        owner: str,
        repo: str,
        subject_digest: str,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoAttestationsSubjectDigestGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-attestations"""

        from ..models import ReposOwnerRepoAttestationsSubjectDigestGetResponse200

        url = f"/repos/{owner}/{repo}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        )

    async def async_list_attestations(
        self,
        owner: str,
        repo: str,
        subject_digest: str,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoAttestationsSubjectDigestGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-attestations"""

        from ..models import ReposOwnerRepoAttestationsSubjectDigestGetResponse200

        url = f"/repos/{owner}/{repo}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        )

    def list_autolinks(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Autolink]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#get-all-autolinks-of-a-repository"""

        from typing import List

        from ..models import Autolink

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Autolink],
        )

    async def async_list_autolinks(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Autolink]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#get-all-autolinks-of-a-repository"""

        from typing import List

        from ..models import Autolink

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Autolink],
        )

    @overload
    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoAutolinksPostBodyType,
    ) -> Response[Autolink]: ...

    @overload
    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Missing[bool] = UNSET,
    ) -> Response[Autolink]: ...

    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Autolink]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#create-an-autolink-reference-for-a-repository"""

        from ..models import Autolink, ValidationError, ReposOwnerRepoAutolinksPostBody

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoAutolinksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoAutolinksPostBodyType,
    ) -> Response[Autolink]: ...

    @overload
    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Missing[bool] = UNSET,
    ) -> Response[Autolink]: ...

    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Autolink]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#create-an-autolink-reference-for-a-repository"""

        from ..models import Autolink, ValidationError, ReposOwnerRepoAutolinksPostBody

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoAutolinksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    def get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Autolink]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#get-an-autolink-reference-of-a-repository"""

        from ..models import Autolink, BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Autolink]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#get-an-autolink-reference-of-a-repository"""

        from ..models import Autolink, BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    def delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#delete-an-autolink-reference-from-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#delete-an-autolink-reference-from-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def check_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CheckAutomatedSecurityFixes]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-automated-security-fixes-are-enabled-for-a-repository"""

        from ..models import CheckAutomatedSecurityFixes

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CheckAutomatedSecurityFixes,
            error_models={},
        )

    async def async_check_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CheckAutomatedSecurityFixes]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-automated-security-fixes-are-enabled-for-a-repository"""

        from ..models import CheckAutomatedSecurityFixes

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CheckAutomatedSecurityFixes,
            error_models={},
        )

    def enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-automated-security-fixes"""

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-automated-security-fixes"""

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-automated-security-fixes"""

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-automated-security-fixes"""

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_branches(
        self,
        owner: str,
        repo: str,
        protected: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ShortBranch]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#list-branches"""

        from typing import List

        from ..models import BasicError, ShortBranch

        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_branches(
        self,
        owner: str,
        repo: str,
        protected: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ShortBranch]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#list-branches"""

        from typing import List

        from ..models import BasicError, ShortBranch

        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    def get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[BranchWithProtection]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#get-a-branch"""

        from ..models import BasicError, BranchWithProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[BranchWithProtection]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#get-a-branch"""

        from ..models import BasicError, BranchWithProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    def get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[BranchProtection]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-branch-protection"""

        from ..models import BasicError, BranchProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[BranchProtection]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-branch-protection"""

        from ..models import BasicError, BranchProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> Response[ProtectedBranch]: ...

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Missing[bool] = UNSET,
        allow_force_pushes: Missing[Union[bool, None]] = UNSET,
        allow_deletions: Missing[bool] = UNSET,
        block_creations: Missing[bool] = UNSET,
        required_conversation_resolution: Missing[bool] = UNSET,
        lock_branch: Missing[bool] = UNSET,
        allow_fork_syncing: Missing[bool] = UNSET,
    ) -> Response[ProtectedBranch]: ...

    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProtectedBranch]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-branch-protection"""

        from ..models import (
            BasicError,
            ProtectedBranch,
            ValidationErrorSimple,
            ReposOwnerRepoBranchesBranchProtectionPutBody,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoBranchesBranchProtectionPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> Response[ProtectedBranch]: ...

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Missing[bool] = UNSET,
        allow_force_pushes: Missing[Union[bool, None]] = UNSET,
        allow_deletions: Missing[bool] = UNSET,
        block_creations: Missing[bool] = UNSET,
        required_conversation_resolution: Missing[bool] = UNSET,
        lock_branch: Missing[bool] = UNSET,
        allow_fork_syncing: Missing[bool] = UNSET,
    ) -> Response[ProtectedBranch]: ...

    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProtectedBranch]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-branch-protection"""

        from ..models import (
            BasicError,
            ProtectedBranch,
            ValidationErrorSimple,
            ReposOwnerRepoBranchesBranchProtectionPutBody,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoBranchesBranchProtectionPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-branch-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-branch-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-admin-branch-protection"""

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-admin-branch-protection"""

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    def set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-admin-branch-protection"""

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-admin-branch-protection"""

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    def delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-admin-branch-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-admin-branch-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchPullRequestReview]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-pull-request-review-protection"""

        from ..models import ProtectedBranchPullRequestReview

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
        )

    async def async_get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchPullRequestReview]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-pull-request-review-protection"""

        from ..models import ProtectedBranchPullRequestReview

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
        )

    def delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-pull-request-review-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-pull-request-review-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
    ) -> Response[ProtectedBranchPullRequestReview]: ...

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        dismissal_restrictions: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType
        ] = UNSET,
        dismiss_stale_reviews: Missing[bool] = UNSET,
        require_code_owner_reviews: Missing[bool] = UNSET,
        required_approving_review_count: Missing[int] = UNSET,
        require_last_push_approval: Missing[bool] = UNSET,
        bypass_pull_request_allowances: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType
        ] = UNSET,
    ) -> Response[ProtectedBranchPullRequestReview]: ...

    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[ProtectedBranchPullRequestReview]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-pull-request-review-protection"""

        from ..models import (
            ValidationError,
            ProtectedBranchPullRequestReview,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
    ) -> Response[ProtectedBranchPullRequestReview]: ...

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        dismissal_restrictions: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType
        ] = UNSET,
        dismiss_stale_reviews: Missing[bool] = UNSET,
        require_code_owner_reviews: Missing[bool] = UNSET,
        required_approving_review_count: Missing[int] = UNSET,
        require_last_push_approval: Missing[bool] = UNSET,
        bypass_pull_request_allowances: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType
        ] = UNSET,
    ) -> Response[ProtectedBranchPullRequestReview]: ...

    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[ProtectedBranchPullRequestReview]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-pull-request-review-protection"""

        from ..models import (
            ValidationError,
            ProtectedBranchPullRequestReview,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    def get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-commit-signature-protection"""

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-commit-signature-protection"""

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#create-commit-signature-protection"""

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#create-commit-signature-protection"""

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-commit-signature-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-commit-signature-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[StatusCheckPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-status-checks-protection"""

        from ..models import BasicError, StatusCheckPolicy

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[StatusCheckPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-status-checks-protection"""

        from ..models import BasicError, StatusCheckPolicy

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-status-check-protection"""

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-status-check-protection"""

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
    ) -> Response[StatusCheckPolicy]: ...

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        strict: Missing[bool] = UNSET,
        contexts: Missing[List[str]] = UNSET,
        checks: Missing[
            List[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ]
        ] = UNSET,
    ) -> Response[StatusCheckPolicy]: ...

    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[StatusCheckPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-status-check-protection"""

        from ..models import (
            BasicError,
            ValidationError,
            StatusCheckPolicy,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
        )

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
    ) -> Response[StatusCheckPolicy]: ...

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        strict: Missing[bool] = UNSET,
        contexts: Missing[List[str]] = UNSET,
        checks: Missing[
            List[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ]
        ] = UNSET,
    ) -> Response[StatusCheckPolicy]: ...

    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[StatusCheckPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-status-check-protection"""

        from ..models import (
            BasicError,
            ValidationError,
            StatusCheckPolicy,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
        )

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-all-status-check-contexts"""

        from typing import List

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-all-status-check-contexts"""

        from typing import List

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[str]]: ...

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> Response[List[str]]: ...

    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-status-check-contexts"""

        from typing import List, Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[str]]: ...

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> Response[List[str]]: ...

    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-status-check-contexts"""

        from typing import List, Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[str]]: ...

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> Response[List[str]]: ...

    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-status-check-contexts"""

        from typing import List, Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[str]]: ...

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> Response[List[str]]: ...

    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-status-check-contexts"""

        from typing import List, Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[str]]: ...

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> Response[List[str]]: ...

    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-status-check-contexts"""

        from typing import List, Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[str]]: ...

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        contexts: List[str],
    ) -> Response[List[str]]: ...

    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-status-check-contexts"""

        from typing import List, Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[BranchRestrictionPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-access-restrictions"""

        from ..models import BasicError, BranchRestrictionPolicy

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[BranchRestrictionPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-access-restrictions"""

        from ..models import BasicError, BranchRestrictionPolicy

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-access-restrictions"""

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-access-restrictions"""

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Union[Integration, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-apps-with-access-to-the-protected-branch"""

        from typing import List, Union

        from ..models import BasicError, Integration

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Union[Integration, None]],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Union[Integration, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-apps-with-access-to-the-protected-branch"""

        from typing import List, Union

        from ..models import BasicError, Integration

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Union[Integration, None]],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Union[Integration, None]]]: ...

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> Response[List[Union[Integration, None]]]: ...

    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Union[Integration, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-app-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Integration,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Union[Integration, None]]]: ...

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> Response[List[Union[Integration, None]]]: ...

    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Union[Integration, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-app-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Integration,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Union[Integration, None]]]: ...

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> Response[List[Union[Integration, None]]]: ...

    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Union[Integration, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-app-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Integration,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Union[Integration, None]]]: ...

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> Response[List[Union[Integration, None]]]: ...

    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Union[Integration, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-app-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Integration,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Union[Integration, None]]]: ...

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> Response[List[Union[Integration, None]]]: ...

    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Union[Integration, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-app-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Integration,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Union[Integration, None]]]: ...

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        apps: List[str],
    ) -> Response[List[Union[Integration, None]]]: ...

    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Union[Integration, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-app-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Integration,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    def get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-teams-with-access-to-the-protected-branch"""

        from typing import List

        from ..models import Team, BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-teams-with-access-to-the-protected-branch"""

        from typing import List

        from ..models import Team, BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Team]]: ...

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> Response[List[Team]]: ...

    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-team-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Team,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Team]]: ...

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> Response[List[Team]]: ...

    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-team-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Team,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Team]]: ...

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> Response[List[Team]]: ...

    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-team-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Team,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Team]]: ...

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> Response[List[Team]]: ...

    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-team-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Team,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Team]]: ...

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> Response[List[Team]]: ...

    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-team-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Team,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[Team]]: ...

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        teams: List[str],
    ) -> Response[List[Team]]: ...

    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-team-access-restrictions"""

        from typing import List, Union

        from ..models import (
            Team,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "422": ValidationError,
            },
        )

    def get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-users-with-access-to-the-protected-branch"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-users-with-access-to-the-protected-branch"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[SimpleUser]]: ...

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> Response[List[SimpleUser]]: ...

    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-user-access-restrictions"""

        from typing import List, Union

        from ..models import (
            SimpleUser,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[SimpleUser]]: ...

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> Response[List[SimpleUser]]: ...

    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-user-access-restrictions"""

        from typing import List, Union

        from ..models import (
            SimpleUser,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[SimpleUser]]: ...

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> Response[List[SimpleUser]]: ...

    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-user-access-restrictions"""

        from typing import List, Union

        from ..models import (
            SimpleUser,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[SimpleUser]]: ...

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> Response[List[SimpleUser]]: ...

    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-user-access-restrictions"""

        from typing import List, Union

        from ..models import (
            SimpleUser,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[SimpleUser]]: ...

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> Response[List[SimpleUser]]: ...

    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-user-access-restrictions"""

        from typing import List, Union

        from ..models import (
            SimpleUser,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
    ) -> Response[List[SimpleUser]]: ...

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        users: List[str],
    ) -> Response[List[SimpleUser]]: ...

    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0Type,
                List[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-user-access-restrictions"""

        from typing import List, Union

        from ..models import (
            SimpleUser,
            ValidationError,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyOneof0,
                List[str],
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> Response[BranchWithProtection]: ...

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_name: str,
    ) -> Response[BranchWithProtection]: ...

    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[BranchWithProtection]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#rename-a-branch"""

        from ..models import (
            BasicError,
            ValidationError,
            BranchWithProtection,
            ReposOwnerRepoBranchesBranchRenamePostBody,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoBranchesBranchRenamePostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> Response[BranchWithProtection]: ...

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_name: str,
    ) -> Response[BranchWithProtection]: ...

    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[BranchWithProtection]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#rename-a-branch"""

        from ..models import (
            BasicError,
            ValidationError,
            BranchWithProtection,
            ReposOwnerRepoBranchesBranchRenamePostBody,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoBranchesBranchRenamePostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def codeowners_errors(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CodeownersErrors]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-codeowners-errors"""

        from ..models import CodeownersErrors

        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CodeownersErrors,
            error_models={},
        )

    async def async_codeowners_errors(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CodeownersErrors]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-codeowners-errors"""

        from ..models import CodeownersErrors

        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CodeownersErrors,
            error_models={},
        )

    def list_collaborators(
        self,
        owner: str,
        repo: str,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        permission: Missing[
            Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Collaborator]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#list-repository-collaborators"""

        from typing import List

        from ..models import BasicError, Collaborator

        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        owner: str,
        repo: str,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        permission: Missing[
            Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Collaborator]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#list-repository-collaborators"""

        from typing import List

        from ..models import BasicError, Collaborator

        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    def check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#check-if-a-user-is-a-repository-collaborator"""

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#check-if-a-user-is-a-repository-collaborator"""

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[RepositoryInvitation]: ...

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response[RepositoryInvitation]: ...

    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#add-a-repository-collaborator"""

        from ..models import (
            BasicError,
            ValidationError,
            RepositoryInvitation,
            ReposOwnerRepoCollaboratorsUsernamePutBody,
        )

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoCollaboratorsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[RepositoryInvitation]: ...

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response[RepositoryInvitation]: ...

    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#add-a-repository-collaborator"""

        from ..models import (
            BasicError,
            ValidationError,
            RepositoryInvitation,
            ReposOwnerRepoCollaboratorsUsernamePutBody,
        )

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoCollaboratorsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#remove-a-repository-collaborator"""

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#remove-a-repository-collaborator"""

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RepositoryCollaboratorPermission]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#get-repository-permissions-for-a-user"""

        from ..models import BasicError, RepositoryCollaboratorPermission

        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RepositoryCollaboratorPermission]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#get-repository-permissions-for-a-user"""

        from ..models import BasicError, RepositoryCollaboratorPermission

        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[CommitComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#list-commit-comments-for-a-repository"""

        from typing import List

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[CommitComment],
        )

    async def async_list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[CommitComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#list-commit-comments-for-a-repository"""

        from typing import List

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[CommitComment],
        )

    def get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CommitComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment"""

        from ..models import BasicError, CommitComment

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CommitComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment"""

        from ..models import BasicError, CommitComment

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#delete-a-commit-comment"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#delete-a-commit-comment"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> Response[CommitComment]: ...

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[CommitComment]: ...

    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#update-a-commit-comment"""

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> Response[CommitComment]: ...

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[CommitComment]: ...

    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#update-a-commit-comment"""

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        sha: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        author: Missing[str] = UNSET,
        committer: Missing[str] = UNSET,
        since: Missing[datetime] = UNSET,
        until: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Commit]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-commits"""

        from typing import List

        from ..models import Commit, BasicError

        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "committer": committer,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        sha: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        author: Missing[str] = UNSET,
        committer: Missing[str] = UNSET,
        since: Missing[datetime] = UNSET,
        until: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Commit]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-commits"""

        from typing import List

        from ..models import Commit, BasicError

        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "committer": committer,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BranchShort]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-branches-for-head-commit"""

        from typing import List

        from ..models import BasicError, BranchShort, ValidationError

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[BranchShort],
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    async def async_list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BranchShort]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-branches-for-head-commit"""

        from typing import List

        from ..models import BasicError, BranchShort, ValidationError

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[BranchShort],
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[CommitComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#list-commit-comments"""

        from typing import List

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[CommitComment],
        )

    async def async_list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[CommitComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#list-commit-comments"""

        from typing import List

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[CommitComment],
        )

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> Response[CommitComment]: ...

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
        path: Missing[str] = UNSET,
        position: Missing[int] = UNSET,
        line: Missing[int] = UNSET,
    ) -> Response[CommitComment]: ...

    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#create-a-commit-comment"""

        from ..models import (
            BasicError,
            CommitComment,
            ValidationError,
            ReposOwnerRepoCommitsCommitShaCommentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoCommitsCommitShaCommentsPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> Response[CommitComment]: ...

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
        path: Missing[str] = UNSET,
        position: Missing[int] = UNSET,
        line: Missing[int] = UNSET,
    ) -> Response[CommitComment]: ...

    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#create-a-commit-comment"""

        from ..models import (
            BasicError,
            CommitComment,
            ValidationError,
            ReposOwnerRepoCommitsCommitShaCommentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoCommitsCommitShaCommentsPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestSimple]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-pull-requests-associated-with-a-commit"""

        from typing import List

        from ..models import BasicError, PullRequestSimple

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestSimple],
            error_models={
                "409": BasicError,
            },
        )

    async def async_list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PullRequestSimple]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-pull-requests-associated-with-a-commit"""

        from typing import List

        from ..models import BasicError, PullRequestSimple

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PullRequestSimple],
            error_models={
                "409": BasicError,
            },
        )

    def get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Commit]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#get-a-commit"""

        from ..models import (
            Commit,
            BasicError,
            ValidationError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "409": BasicError,
            },
        )

    async def async_get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Commit]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#get-a-commit"""

        from ..models import (
            Commit,
            BasicError,
            ValidationError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "409": BasicError,
            },
        )

    def get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CombinedCommitStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#get-the-combined-status-for-a-specific-reference"""

        from ..models import BasicError, CombinedCommitStatus

        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CombinedCommitStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#get-the-combined-status-for-a-specific-reference"""

        from ..models import BasicError, CombinedCommitStatus

        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Status]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#list-commit-statuses-for-a-reference"""

        from typing import List

        from ..models import Status

        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Status],
        )

    async def async_list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Status]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#list-commit-statuses-for-a-reference"""

        from typing import List

        from ..models import Status

        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Status],
        )

    def get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CommunityProfile]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/community#get-community-profile-metrics"""

        from ..models import CommunityProfile

        url = f"/repos/{owner}/{repo}/community/profile"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommunityProfile,
        )

    async def async_get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CommunityProfile]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/community#get-community-profile-metrics"""

        from ..models import CommunityProfile

        url = f"/repos/{owner}/{repo}/community/profile"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommunityProfile,
        )

    def compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CommitComparison]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#compare-two-commits"""

        from ..models import (
            BasicError,
            CommitComparison,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CommitComparison]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#compare-two-commits"""

        from ..models import (
            BasicError,
            CommitComparison,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        Union[
            List[ContentDirectoryItems], ContentFile, ContentSymlink, ContentSubmodule
        ]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-repository-content"""

        from typing import List, Union

        from ..models import (
            BasicError,
            ContentFile,
            ContentSymlink,
            ContentSubmodule,
            ContentDirectoryItems,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[
                List[ContentDirectoryItems],
                ContentFile,
                ContentSymlink,
                ContentSubmodule,
            ],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        Union[
            List[ContentDirectoryItems], ContentFile, ContentSymlink, ContentSubmodule
        ]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-repository-content"""

        from typing import List, Union

        from ..models import (
            BasicError,
            ContentFile,
            ContentSymlink,
            ContentSubmodule,
            ContentDirectoryItems,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[
                List[ContentDirectoryItems],
                ContentFile,
                ContentSymlink,
                ContentSubmodule,
            ],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> Response[FileCommit]: ...

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        content: str,
        sha: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        committer: Missing[ReposOwnerRepoContentsPathPutBodyPropCommitterType] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit]: ...

    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#create-or-update-file-contents"""

        from ..models import (
            BasicError,
            FileCommit,
            ValidationError,
            ReposOwnerRepoContentsPathPutBody,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoContentsPathPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> Response[FileCommit]: ...

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        content: str,
        sha: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        committer: Missing[ReposOwnerRepoContentsPathPutBodyPropCommitterType] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit]: ...

    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#create-or-update-file-contents"""

        from ..models import (
            BasicError,
            FileCommit,
            ValidationError,
            ReposOwnerRepoContentsPathPutBody,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoContentsPathPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> Response[FileCommit]: ...

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        sha: str,
        branch: Missing[str] = UNSET,
        committer: Missing[
            ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathDeleteBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit]: ...

    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#delete-a-file"""

        from ..models import (
            BasicError,
            FileCommit,
            ValidationError,
            ReposOwnerRepoContentsPathDeleteBody,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoContentsPathDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> Response[FileCommit]: ...

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        message: str,
        sha: str,
        branch: Missing[str] = UNSET,
        committer: Missing[
            ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathDeleteBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit]: ...

    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#delete-a-file"""

        from ..models import (
            BasicError,
            FileCommit,
            ValidationError,
            ReposOwnerRepoContentsPathDeleteBody,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoContentsPathDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_contributors(
        self,
        owner: str,
        repo: str,
        anon: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Contributor]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-contributors"""

        from typing import List

        from ..models import BasicError, Contributor

        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_contributors(
        self,
        owner: str,
        repo: str,
        anon: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Contributor]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-contributors"""

        from typing import List

        from ..models import BasicError, Contributor

        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_deployments(
        self,
        owner: str,
        repo: str,
        sha: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        task: Missing[str] = UNSET,
        environment: Missing[Union[str, None]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Deployment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#list-deployments"""

        from typing import List

        from ..models import Deployment

        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Deployment],
        )

    async def async_list_deployments(
        self,
        owner: str,
        repo: str,
        sha: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        task: Missing[str] = UNSET,
        environment: Missing[Union[str, None]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Deployment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#list-deployments"""

        from typing import List

        from ..models import Deployment

        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Deployment],
        )

    @overload
    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDeploymentsPostBodyType,
    ) -> Response[Deployment]: ...

    @overload
    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: str,
        task: Missing[str] = UNSET,
        auto_merge: Missing[bool] = UNSET,
        required_contexts: Missing[List[str]] = UNSET,
        payload: Missing[
            Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        transient_environment: Missing[bool] = UNSET,
        production_environment: Missing[bool] = UNSET,
    ) -> Response[Deployment]: ...

    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Deployment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#create-a-deployment"""

        from ..models import (
            Deployment,
            ValidationError,
            ReposOwnerRepoDeploymentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDeploymentsPostBodyType,
    ) -> Response[Deployment]: ...

    @overload
    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        ref: str,
        task: Missing[str] = UNSET,
        auto_merge: Missing[bool] = UNSET,
        required_contexts: Missing[List[str]] = UNSET,
        payload: Missing[
            Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        transient_environment: Missing[bool] = UNSET,
        production_environment: Missing[bool] = UNSET,
    ) -> Response[Deployment]: ...

    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Deployment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#create-a-deployment"""

        from ..models import (
            Deployment,
            ValidationError,
            ReposOwnerRepoDeploymentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Deployment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#get-a-deployment"""

        from ..models import BasicError, Deployment

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Deployment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#get-a-deployment"""

        from ..models import BasicError, Deployment

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#delete-a-deployment"""

        from ..models import BasicError, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#delete-a-deployment"""

        from ..models import BasicError, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[DeploymentStatus]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#list-deployment-statuses"""

        from typing import List

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[DeploymentStatus]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#list-deployment-statuses"""

        from typing import List

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> Response[DeploymentStatus]: ...

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Missing[str] = UNSET,
        log_url: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        environment_url: Missing[str] = UNSET,
        auto_inactive: Missing[bool] = UNSET,
    ) -> Response[DeploymentStatus]: ...

    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#create-a-deployment-status"""

        from ..models import (
            ValidationError,
            DeploymentStatus,
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody,
        )

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> Response[DeploymentStatus]: ...

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Missing[str] = UNSET,
        log_url: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        environment_url: Missing[str] = UNSET,
        auto_inactive: Missing[bool] = UNSET,
    ) -> Response[DeploymentStatus]: ...

    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#create-a-deployment-status"""

        from ..models import (
            ValidationError,
            DeploymentStatus,
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody,
        )

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[DeploymentStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#get-a-deployment-status"""

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[DeploymentStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#get-a-deployment-status"""

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        event_type: str,
        client_payload: Missing[
            ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> Response: ...

    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-dispatch-event"""

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoDispatchesPostBody,
        )

        url = f"/repos/{owner}/{repo}/dispatches"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoDispatchesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        event_type: str,
        client_payload: Missing[
            ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> Response: ...

    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-dispatch-event"""

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoDispatchesPostBody,
        )

        url = f"/repos/{owner}/{repo}/dispatches"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoDispatchesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_all_environments(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoEnvironmentsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#list-environments"""

        from ..models import ReposOwnerRepoEnvironmentsGetResponse200

        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    async def async_get_all_environments(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoEnvironmentsGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#list-environments"""

        from ..models import ReposOwnerRepoEnvironmentsGetResponse200

        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    def get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Environment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#get-an-environment"""

        from ..models import Environment

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Environment,
        )

    async def async_get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Environment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#get-an-environment"""

        from ..models import Environment

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Environment,
        )

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> Response[Environment]: ...

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        wait_timer: Missing[int] = UNSET,
        prevent_self_review: Missing[bool] = UNSET,
        reviewers: Missing[
            Union[
                List[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ]
        ] = UNSET,
        deployment_branch_policy: Missing[
            Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> Response[Environment]: ...

    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[Environment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#create-or-update-an-environment"""

        from typing import Union

        from ..models import (
            BasicError,
            Environment,
            ReposOwnerRepoEnvironmentsEnvironmentNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> Response[Environment]: ...

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        wait_timer: Missing[int] = UNSET,
        prevent_self_review: Missing[bool] = UNSET,
        reviewers: Missing[
            Union[
                List[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ]
        ] = UNSET,
        deployment_branch_policy: Missing[
            Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> Response[Environment]: ...

    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[Environment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#create-or-update-an-environment"""

        from typing import Union

        from ..models import (
            BasicError,
            Environment,
            ReposOwnerRepoEnvironmentsEnvironmentNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    def delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#delete-an-environment"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#delete-an-environment"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#list-deployment-branch-policies"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    async def async_list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#list-deployment-branch-policies"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternWithTypeType,
    ) -> Response[DeploymentBranchPolicy]: ...

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        type: Missing[Literal["branch", "tag"]] = UNSET,
    ) -> Response[DeploymentBranchPolicy]: ...

    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternWithTypeType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#create-a-deployment-branch-policy"""

        from ..models import (
            DeploymentBranchPolicy,
            DeploymentBranchPolicyNamePatternWithType,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(DeploymentBranchPolicyNamePatternWithType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternWithTypeType,
    ) -> Response[DeploymentBranchPolicy]: ...

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        type: Missing[Literal["branch", "tag"]] = UNSET,
    ) -> Response[DeploymentBranchPolicy]: ...

    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternWithTypeType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#create-a-deployment-branch-policy"""

        from ..models import (
            DeploymentBranchPolicy,
            DeploymentBranchPolicyNamePatternWithType,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(DeploymentBranchPolicyNamePatternWithType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    def get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[DeploymentBranchPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#get-a-deployment-branch-policy"""

        from ..models import DeploymentBranchPolicy

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    async def async_get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[DeploymentBranchPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#get-a-deployment-branch-policy"""

        from ..models import DeploymentBranchPolicy

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> Response[DeploymentBranchPolicy]: ...

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
    ) -> Response[DeploymentBranchPolicy]: ...

    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#update-a-deployment-branch-policy"""

        from ..models import DeploymentBranchPolicy, DeploymentBranchPolicyNamePattern

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(DeploymentBranchPolicyNamePattern, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> Response[DeploymentBranchPolicy]: ...

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
    ) -> Response[DeploymentBranchPolicy]: ...

    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#update-a-deployment-branch-policy"""

        from ..models import DeploymentBranchPolicy, DeploymentBranchPolicyNamePattern

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(DeploymentBranchPolicyNamePattern, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    def delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#delete-a-deployment-branch-policy"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#delete-a-deployment-branch-policy"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_all_deployment_protection_rules(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#get-all-deployment-protection-rules-for-an-environment"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

    async def async_get_all_deployment_protection_rules(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#get-all-deployment-protection-rules-for-an-environment"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

    @overload
    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
    ) -> Response[DeploymentProtectionRule]: ...

    @overload
    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        integration_id: Missing[int] = UNSET,
    ) -> Response[DeploymentProtectionRule]: ...

    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentProtectionRule]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#create-a-custom-deployment-protection-rule-on-an-environment"""

        from ..models import (
            DeploymentProtectionRule,
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    @overload
    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
    ) -> Response[DeploymentProtectionRule]: ...

    @overload
    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        integration_id: Missing[int] = UNSET,
    ) -> Response[DeploymentProtectionRule]: ...

    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentProtectionRule]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#create-a-custom-deployment-protection-rule-on-an-environment"""

        from ..models import (
            DeploymentProtectionRule,
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    def list_custom_deployment_rule_integrations(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#list-custom-deployment-rule-integrations-available-for-an-environment"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

    async def async_list_custom_deployment_rule_integrations(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#list-custom-deployment-rule-integrations-available-for-an-environment"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

    def get_custom_deployment_protection_rule(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        protection_rule_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[DeploymentProtectionRule]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#get-a-custom-deployment-protection-rule"""

        from ..models import DeploymentProtectionRule

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    async def async_get_custom_deployment_protection_rule(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        protection_rule_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[DeploymentProtectionRule]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#get-a-custom-deployment-protection-rule"""

        from ..models import DeploymentProtectionRule

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    def disable_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        protection_rule_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#disable-a-custom-protection-rule-for-an-environment"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        protection_rule_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#disable-a-custom-protection-rule-for-an-environment"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_forks(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["newest", "oldest", "stargazers", "watchers"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/forks#list-forks"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    async def async_list_forks(
        self,
        owner: str,
        repo: str,
        sort: Missing[Literal["newest", "oldest", "stargazers", "watchers"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/forks#list-forks"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> Response[FullRepository]: ...

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        organization: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        default_branch_only: Missing[bool] = UNSET,
    ) -> Response[FullRepository]: ...

    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/forks#create-a-fork"""

        from typing import Union

        from ..models import (
            BasicError,
            FullRepository,
            ValidationError,
            ReposOwnerRepoForksPostBody,
        )

        url = f"/repos/{owner}/{repo}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(Union[ReposOwnerRepoForksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> Response[FullRepository]: ...

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        organization: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        default_branch_only: Missing[bool] = UNSET,
    ) -> Response[FullRepository]: ...

    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/forks#create-a-fork"""

        from typing import Union

        from ..models import (
            BasicError,
            FullRepository,
            ValidationError,
            ReposOwnerRepoForksPostBody,
        )

        url = f"/repos/{owner}/{repo}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(Union[ReposOwnerRepoForksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Hook]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#list-repository-webhooks"""

        from typing import List

        from ..models import Hook, BasicError

        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Hook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Hook]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#list-repository-webhooks"""

        from typing import List

        from ..models import Hook, BasicError

        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Hook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> Response[Hook]: ...

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        config: Missing[ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook]: ...

    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Hook]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#create-a-repository-webhook"""

        from typing import Union

        from ..models import (
            Hook,
            BasicError,
            ValidationError,
            ReposOwnerRepoHooksPostBody,
        )

        url = f"/repos/{owner}/{repo}/hooks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> Response[Hook]: ...

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        config: Missing[ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook]: ...

    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Hook]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#create-a-repository-webhook"""

        from typing import Union

        from ..models import (
            Hook,
            BasicError,
            ValidationError,
            ReposOwnerRepoHooksPostBody,
        )

        url = f"/repos/{owner}/{repo}/hooks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Hook]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-repository-webhook"""

        from ..models import Hook, BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Hook]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-repository-webhook"""

        from ..models import Hook, BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#delete-a-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#delete-a-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> Response[Hook]: ...

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        config: Missing[WebhookConfigType] = UNSET,
        events: Missing[List[str]] = UNSET,
        add_events: Missing[List[str]] = UNSET,
        remove_events: Missing[List[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook]: ...

    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Hook]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#update-a-repository-webhook"""

        from ..models import (
            Hook,
            BasicError,
            ValidationError,
            ReposOwnerRepoHooksHookIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> Response[Hook]: ...

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        config: Missing[WebhookConfigType] = UNSET,
        events: Missing[List[str]] = UNSET,
        add_events: Missing[List[str]] = UNSET,
        remove_events: Missing[List[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook]: ...

    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Hook]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#update-a-repository-webhook"""

        from ..models import (
            Hook,
            BasicError,
            ValidationError,
            ReposOwnerRepoHooksHookIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WebhookConfig]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-webhook-configuration-for-a-repository"""

        from ..models import WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WebhookConfig]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-webhook-configuration-for-a-repository"""

        from ..models import WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig]: ...

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig]: ...

    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#update-a-webhook-configuration-for-a-repository"""

        from ..models import WebhookConfig, ReposOwnerRepoHooksHookIdConfigPatchBody

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig]: ...

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig]: ...

    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#update-a-webhook-configuration-for-a-repository"""

        from ..models import WebhookConfig, ReposOwnerRepoHooksHookIdConfigPatchBody

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[HookDeliveryItem]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#list-deliveries-for-a-repository-webhook"""

        from typing import List

        from ..models import BasicError, ValidationError, HookDeliveryItem

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[HookDeliveryItem]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#list-deliveries-for-a-repository-webhook"""

        from typing import List

        from ..models import BasicError, ValidationError, HookDeliveryItem

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[HookDelivery]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-delivery-for-a-repository-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[HookDelivery]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-delivery-for-a-repository-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#redeliver-a-delivery-for-a-repository-webhook"""

        from ..models import (
            BasicError,
            ValidationError,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#redeliver-a-delivery-for-a-repository-webhook"""

        from ..models import (
            BasicError,
            ValidationError,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#ping-a-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#ping-a-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#test-the-push-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#test-the-push-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_invitations(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RepositoryInvitation]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#list-repository-invitations"""

        from typing import List

        from ..models import RepositoryInvitation

        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryInvitation],
        )

    async def async_list_invitations(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RepositoryInvitation]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#list-repository-invitations"""

        from typing import List

        from ..models import RepositoryInvitation

        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryInvitation],
        )

    def delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#delete-a-repository-invitation"""

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#delete-a-repository-invitation"""

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> Response[RepositoryInvitation]: ...

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permissions: Missing[
            Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> Response[RepositoryInvitation]: ...

    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#update-a-repository-invitation"""

        from ..models import (
            RepositoryInvitation,
            ReposOwnerRepoInvitationsInvitationIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoInvitationsInvitationIdPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
        )

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> Response[RepositoryInvitation]: ...

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        permissions: Missing[
            Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> Response[RepositoryInvitation]: ...

    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#update-a-repository-invitation"""

        from ..models import (
            RepositoryInvitation,
            ReposOwnerRepoInvitationsInvitationIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposOwnerRepoInvitationsInvitationIdPatchBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
        )

    def list_deploy_keys(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[DeployKey]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#list-deploy-keys"""

        from typing import List

        from ..models import DeployKey

        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DeployKey],
        )

    async def async_list_deploy_keys(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[DeployKey]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#list-deploy-keys"""

        from typing import List

        from ..models import DeployKey

        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[DeployKey],
        )

    @overload
    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoKeysPostBodyType,
    ) -> Response[DeployKey]: ...

    @overload
    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
        read_only: Missing[bool] = UNSET,
    ) -> Response[DeployKey]: ...

    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[DeployKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#create-a-deploy-key"""

        from ..models import DeployKey, ValidationError, ReposOwnerRepoKeysPostBody

        url = f"/repos/{owner}/{repo}/keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoKeysPostBodyType,
    ) -> Response[DeployKey]: ...

    @overload
    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
        read_only: Missing[bool] = UNSET,
    ) -> Response[DeployKey]: ...

    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[DeployKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#create-a-deploy-key"""

        from ..models import DeployKey, ValidationError, ReposOwnerRepoKeysPostBody

        url = f"/repos/{owner}/{repo}/keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[DeployKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#get-a-deploy-key"""

        from ..models import DeployKey, BasicError

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[DeployKey]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#get-a-deploy-key"""

        from ..models import DeployKey, BasicError

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#delete-a-deploy-key"""

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#delete-a-deploy-key"""

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_languages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Language]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-languages"""

        from ..models import Language

        url = f"/repos/{owner}/{repo}/languages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Language,
        )

    async def async_list_languages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Language]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-languages"""

        from ..models import Language

        url = f"/repos/{owner}/{repo}/languages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Language,
        )

    def enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/lfs#enable-git-lfs-for-a-repository"""

        from ..models import AppHookDeliveriesDeliveryIdAttemptsPostResponse202

        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    async def async_enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/lfs#enable-git-lfs-for-a-repository"""

        from ..models import AppHookDeliveriesDeliveryIdAttemptsPostResponse202

        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    def disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/lfs#disable-git-lfs-for-a-repository"""

        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/lfs#disable-git-lfs-for-a-repository"""

        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMergeUpstreamPostBodyType,
    ) -> Response[MergedUpstream]: ...

    @overload
    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        branch: str,
    ) -> Response[MergedUpstream]: ...

    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MergedUpstream]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#sync-a-fork-branch-with-the-upstream-repository"""

        from ..models import MergedUpstream, ReposOwnerRepoMergeUpstreamPostBody

        url = f"/repos/{owner}/{repo}/merge-upstream"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMergeUpstreamPostBodyType,
    ) -> Response[MergedUpstream]: ...

    @overload
    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        branch: str,
    ) -> Response[MergedUpstream]: ...

    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MergedUpstream]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#sync-a-fork-branch-with-the-upstream-repository"""

        from ..models import MergedUpstream, ReposOwnerRepoMergeUpstreamPostBody

        url = f"/repos/{owner}/{repo}/merge-upstream"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMergesPostBodyType,
    ) -> Response[Commit]: ...

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        base: str,
        head: str,
        commit_message: Missing[str] = UNSET,
    ) -> Response[Commit]: ...

    def merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Commit]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#merge-a-branch"""

        from ..models import (
            Commit,
            BasicError,
            ValidationError,
            ReposOwnerRepoMergesPostBody,
        )

        url = f"/repos/{owner}/{repo}/merges"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoMergesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoMergesPostBodyType,
    ) -> Response[Commit]: ...

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        base: str,
        head: str,
        commit_message: Missing[str] = UNSET,
    ) -> Response[Commit]: ...

    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Commit]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#merge-a-branch"""

        from ..models import (
            Commit,
            BasicError,
            ValidationError,
            ReposOwnerRepoMergesPostBody,
        )

        url = f"/repos/{owner}/{repo}/merges"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoMergesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_pages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Page]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-a-apiname-pages-site"""

        from ..models import Page, BasicError

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Page]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-a-apiname-pages-site"""

        from ..models import Page, BasicError

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Union[str, None],
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: bool,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: bool,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#update-information-about-a-apiname-pages-site"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoPagesPutBodyAnyof0,
            ReposOwnerRepoPagesPutBodyAnyof1,
            ReposOwnerRepoPagesPutBodyAnyof2,
            ReposOwnerRepoPagesPutBodyAnyof3,
            ReposOwnerRepoPagesPutBodyAnyof4,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0,
                ReposOwnerRepoPagesPutBodyAnyof1,
                ReposOwnerRepoPagesPutBodyAnyof2,
                ReposOwnerRepoPagesPutBodyAnyof3,
                ReposOwnerRepoPagesPutBodyAnyof4,
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Union[str, None],
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: bool,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: bool,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#update-information-about-a-apiname-pages-site"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoPagesPutBodyAnyof0,
            ReposOwnerRepoPagesPutBodyAnyof1,
            ReposOwnerRepoPagesPutBodyAnyof2,
            ReposOwnerRepoPagesPutBodyAnyof3,
            ReposOwnerRepoPagesPutBodyAnyof4,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0,
                ReposOwnerRepoPagesPutBodyAnyof1,
                ReposOwnerRepoPagesPutBodyAnyof2,
                ReposOwnerRepoPagesPutBodyAnyof3,
                ReposOwnerRepoPagesPutBodyAnyof4,
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> Response[Page]: ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> Response[Page]: ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        build_type: Literal["legacy", "workflow"],
        source: Missing[ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> Response[Page]: ...

    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[Page]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#create-a-apiname-pages-site"""

        from typing import Union

        from ..models import (
            Page,
            BasicError,
            ValidationError,
            ReposOwnerRepoPagesPostBodyAnyof0,
            ReposOwnerRepoPagesPostBodyAnyof1,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1,
                None,
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> Response[Page]: ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> Response[Page]: ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        build_type: Literal["legacy", "workflow"],
        source: Missing[ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> Response[Page]: ...

    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[Page]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#create-a-apiname-pages-site"""

        from typing import Union

        from ..models import (
            Page,
            BasicError,
            ValidationError,
            ReposOwnerRepoPagesPostBodyAnyof0,
            ReposOwnerRepoPagesPostBodyAnyof1,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1,
                None,
            ],
            json,
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def delete_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#delete-a-apiname-pages-site"""

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_delete_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#delete-a-apiname-pages-site"""

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_pages_builds(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PageBuild]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#list-apiname-pages-builds"""

        from typing import List

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PageBuild],
        )

    async def async_list_pages_builds(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[PageBuild]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#list-apiname-pages-builds"""

        from typing import List

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[PageBuild],
        )

    def request_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PageBuildStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#request-a-apiname-pages-build"""

        from ..models import PageBuildStatus

        url = f"/repos/{owner}/{repo}/pages/builds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuildStatus,
        )

    async def async_request_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PageBuildStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#request-a-apiname-pages-build"""

        from ..models import PageBuildStatus

        url = f"/repos/{owner}/{repo}/pages/builds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuildStatus,
        )

    def get_latest_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PageBuild]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-latest-pages-build"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    async def async_get_latest_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PageBuild]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-latest-pages-build"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    def get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PageBuild]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-apiname-pages-build"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    async def async_get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PageBuild]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-apiname-pages-build"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    @overload
    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPagesDeploymentsPostBodyType,
    ) -> Response[PageDeployment]: ...

    @overload
    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        artifact_id: Missing[float] = UNSET,
        artifact_url: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> Response[PageDeployment]: ...

    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPagesDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PageDeployment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#create-a-github-pages-deployment"""

        from ..models import (
            BasicError,
            PageDeployment,
            ValidationError,
            ReposOwnerRepoPagesDeploymentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pages/deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPagesDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPagesDeploymentsPostBodyType,
    ) -> Response[PageDeployment]: ...

    @overload
    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        artifact_id: Missing[float] = UNSET,
        artifact_url: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> Response[PageDeployment]: ...

    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPagesDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PageDeployment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#create-a-github-pages-deployment"""

        from ..models import (
            BasicError,
            PageDeployment,
            ValidationError,
            ReposOwnerRepoPagesDeploymentsPostBody,
        )

        url = f"/repos/{owner}/{repo}/pages/deployments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPagesDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PagesDeploymentStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-the-status-of-a-github-pages-deployment"""

        from ..models import BasicError, PagesDeploymentStatus

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesDeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PagesDeploymentStatus]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-the-status-of-a-github-pages-deployment"""

        from ..models import BasicError, PagesDeploymentStatus

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesDeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    def cancel_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#cancel-a-github-pages-deployment"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_cancel_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#cancel-a-github-pages-deployment"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_pages_health_check(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PagesHealthCheck]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-a-dns-health-check-for-github-pages"""

        from ..models import BasicError, PagesHealthCheck

        url = f"/repos/{owner}/{repo}/pages/health"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages_health_check(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PagesHealthCheck]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-a-dns-health-check-for-github-pages"""

        from ..models import BasicError, PagesHealthCheck

        url = f"/repos/{owner}/{repo}/pages/health"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    def check_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-private-vulnerability-reporting-is-enabled-for-a-repository"""

        from ..models import (
            BasicError,
            ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
            error_models={
                "422": BasicError,
            },
        )

    async def async_check_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-private-vulnerability-reporting-is-enabled-for-a-repository"""

        from ..models import (
            BasicError,
            ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
            error_models={
                "422": BasicError,
            },
        )

    def enable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-private-vulnerability-reporting-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": BasicError,
            },
        )

    async def async_enable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-private-vulnerability-reporting-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": BasicError,
            },
        )

    def disable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-private-vulnerability-reporting-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": BasicError,
            },
        )

    async def async_disable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-private-vulnerability-reporting-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": BasicError,
            },
        )

    def get_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[CustomPropertyValue]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/custom-properties#get-all-custom-property-values-for-a-repository"""

        from typing import List

        from ..models import BasicError, CustomPropertyValue

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[CustomPropertyValue],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[CustomPropertyValue]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/custom-properties#get-all-custom-property-values-for-a-repository"""

        from typing import List

        from ..models import BasicError, CustomPropertyValue

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[CustomPropertyValue],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    def create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        properties: List[CustomPropertyValueType],
    ) -> Response: ...

    def create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/custom-properties#create-or-update-custom-property-values-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoPropertiesValuesPatchBody,
        )

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    async def async_create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        properties: List[CustomPropertyValueType],
    ) -> Response: ...

    async def async_create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/custom-properties#create-or-update-custom-property-values-for-a-repository"""

        from ..models import (
            BasicError,
            ValidationError,
            ReposOwnerRepoPropertiesValuesPatchBody,
        )

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_readme(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ContentFile]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-a-repository-readme"""

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ContentFile]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-a-repository-readme"""

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ContentFile]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-a-repository-readme-for-a-directory"""

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        ref: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ContentFile]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-a-repository-readme-for-a-directory"""

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_releases(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Release]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#list-releases"""

        from typing import List

        from ..models import Release, BasicError

        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Release],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_releases(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Release]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#list-releases"""

        from typing import List

        from ..models import Release, BasicError

        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Release],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesPostBodyType,
    ) -> Response[Release]: ...

    @overload
    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
        generate_release_notes: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
    ) -> Response[Release]: ...

    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#create-a-release"""

        from ..models import (
            Release,
            BasicError,
            ValidationError,
            ReposOwnerRepoReleasesPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoReleasesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesPostBodyType,
    ) -> Response[Release]: ...

    @overload
    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
        generate_release_notes: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
    ) -> Response[Release]: ...

    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#create-a-release"""

        from ..models import (
            Release,
            BasicError,
            ValidationError,
            ReposOwnerRepoReleasesPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoReleasesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReleaseAsset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#get-a-release-asset"""

        from ..models import BasicError, ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ReleaseAsset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#get-a-release-asset"""

        from ..models import BasicError, ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    def delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#delete-a-release-asset"""

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#delete-a-release-asset"""

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> Response[ReleaseAsset]: ...

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        label: Missing[str] = UNSET,
        state: Missing[str] = UNSET,
    ) -> Response[ReleaseAsset]: ...

    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseAsset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#update-a-release-asset"""

        from ..models import ReleaseAsset, ReposOwnerRepoReleasesAssetsAssetIdPatchBody

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
        )

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> Response[ReleaseAsset]: ...

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        label: Missing[str] = UNSET,
        state: Missing[str] = UNSET,
    ) -> Response[ReleaseAsset]: ...

    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseAsset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#update-a-release-asset"""

        from ..models import ReleaseAsset, ReposOwnerRepoReleasesAssetsAssetIdPatchBody

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
        )

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> Response[ReleaseNotesContent]: ...

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        previous_tag_name: Missing[str] = UNSET,
        configuration_file_path: Missing[str] = UNSET,
    ) -> Response[ReleaseNotesContent]: ...

    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseNotesContent]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#generate-release-notes-content-for-a-release"""

        from ..models import (
            BasicError,
            ReleaseNotesContent,
            ReposOwnerRepoReleasesGenerateNotesPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoReleasesGenerateNotesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> Response[ReleaseNotesContent]: ...

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        previous_tag_name: Missing[str] = UNSET,
        configuration_file_path: Missing[str] = UNSET,
    ) -> Response[ReleaseNotesContent]: ...

    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseNotesContent]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#generate-release-notes-content-for-a-release"""

        from ..models import (
            BasicError,
            ReleaseNotesContent,
            ReposOwnerRepoReleasesGenerateNotesPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoReleasesGenerateNotesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    def get_latest_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-the-latest-release"""

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
        )

    async def async_get_latest_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-the-latest-release"""

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
        )

    def get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release-by-tag-name"""

        from ..models import Release, BasicError

        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release-by-tag-name"""

        from ..models import Release, BasicError

        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release"""

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={},
        )

    async def async_get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release"""

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={},
        )

    def delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#delete-a-release"""

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#delete-a-release"""

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> Response[Release]: ...

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: Missing[str] = UNSET,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
    ) -> Response[Release]: ...

    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#update-a-release"""

        from ..models import (
            Release,
            BasicError,
            ReposOwnerRepoReleasesReleaseIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> Response[Release]: ...

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        tag_name: Missing[str] = UNSET,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
    ) -> Response[Release]: ...

    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#update-a-release"""

        from ..models import (
            Release,
            BasicError,
            ReposOwnerRepoReleasesReleaseIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ReleaseAsset]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#list-release-assets"""

        from typing import List

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ReleaseAsset],
        )

    async def async_list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ReleaseAsset]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#list-release-assets"""

        from typing import List

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[ReleaseAsset],
        )

    def upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        name: str,
        label: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: FileTypes,
        **kwargs,
    ) -> Response[ReleaseAsset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#upload-a-release-asset"""

        from githubkit.typing import FileTypes

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = type_validate_python(FileTypes, content)
        content = model_dump(content) if isinstance(content, BaseModel) else content

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={},
        )

    async def async_upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        name: str,
        label: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: FileTypes,
        **kwargs,
    ) -> Response[ReleaseAsset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#upload-a-release-asset"""

        from githubkit.typing import FileTypes

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        content = kwargs if data is UNSET else data
        content = type_validate_python(FileTypes, content)
        content = model_dump(content) if isinstance(content, BaseModel) else content

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={},
        )

    def get_branch_rules(
        self,
        owner: str,
        repo: str,
        branch: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        List[
            Union[
                RepositoryRuleDetailedOneof0,
                RepositoryRuleDetailedOneof1,
                RepositoryRuleDetailedOneof2,
                RepositoryRuleDetailedOneof3,
                RepositoryRuleDetailedOneof4,
                RepositoryRuleDetailedOneof5,
                RepositoryRuleDetailedOneof6,
                RepositoryRuleDetailedOneof7,
                RepositoryRuleDetailedOneof8,
                RepositoryRuleDetailedOneof9,
                RepositoryRuleDetailedOneof10,
                RepositoryRuleDetailedOneof11,
                RepositoryRuleDetailedOneof12,
                RepositoryRuleDetailedOneof13,
                RepositoryRuleDetailedOneof14,
                RepositoryRuleDetailedOneof15,
            ]
        ]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-rules-for-a-branch"""

        from typing import List, Union

        from ..models import (
            RepositoryRuleDetailedOneof0,
            RepositoryRuleDetailedOneof1,
            RepositoryRuleDetailedOneof2,
            RepositoryRuleDetailedOneof3,
            RepositoryRuleDetailedOneof4,
            RepositoryRuleDetailedOneof5,
            RepositoryRuleDetailedOneof6,
            RepositoryRuleDetailedOneof7,
            RepositoryRuleDetailedOneof8,
            RepositoryRuleDetailedOneof9,
            RepositoryRuleDetailedOneof10,
            RepositoryRuleDetailedOneof11,
            RepositoryRuleDetailedOneof12,
            RepositoryRuleDetailedOneof13,
            RepositoryRuleDetailedOneof14,
            RepositoryRuleDetailedOneof15,
        )

        url = f"/repos/{owner}/{repo}/rules/branches/{branch}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[
                Union[
                    RepositoryRuleDetailedOneof0,
                    RepositoryRuleDetailedOneof1,
                    RepositoryRuleDetailedOneof2,
                    RepositoryRuleDetailedOneof3,
                    RepositoryRuleDetailedOneof4,
                    RepositoryRuleDetailedOneof5,
                    RepositoryRuleDetailedOneof6,
                    RepositoryRuleDetailedOneof7,
                    RepositoryRuleDetailedOneof8,
                    RepositoryRuleDetailedOneof9,
                    RepositoryRuleDetailedOneof10,
                    RepositoryRuleDetailedOneof11,
                    RepositoryRuleDetailedOneof12,
                    RepositoryRuleDetailedOneof13,
                    RepositoryRuleDetailedOneof14,
                    RepositoryRuleDetailedOneof15,
                ]
            ],
        )

    async def async_get_branch_rules(
        self,
        owner: str,
        repo: str,
        branch: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[
        List[
            Union[
                RepositoryRuleDetailedOneof0,
                RepositoryRuleDetailedOneof1,
                RepositoryRuleDetailedOneof2,
                RepositoryRuleDetailedOneof3,
                RepositoryRuleDetailedOneof4,
                RepositoryRuleDetailedOneof5,
                RepositoryRuleDetailedOneof6,
                RepositoryRuleDetailedOneof7,
                RepositoryRuleDetailedOneof8,
                RepositoryRuleDetailedOneof9,
                RepositoryRuleDetailedOneof10,
                RepositoryRuleDetailedOneof11,
                RepositoryRuleDetailedOneof12,
                RepositoryRuleDetailedOneof13,
                RepositoryRuleDetailedOneof14,
                RepositoryRuleDetailedOneof15,
            ]
        ]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-rules-for-a-branch"""

        from typing import List, Union

        from ..models import (
            RepositoryRuleDetailedOneof0,
            RepositoryRuleDetailedOneof1,
            RepositoryRuleDetailedOneof2,
            RepositoryRuleDetailedOneof3,
            RepositoryRuleDetailedOneof4,
            RepositoryRuleDetailedOneof5,
            RepositoryRuleDetailedOneof6,
            RepositoryRuleDetailedOneof7,
            RepositoryRuleDetailedOneof8,
            RepositoryRuleDetailedOneof9,
            RepositoryRuleDetailedOneof10,
            RepositoryRuleDetailedOneof11,
            RepositoryRuleDetailedOneof12,
            RepositoryRuleDetailedOneof13,
            RepositoryRuleDetailedOneof14,
            RepositoryRuleDetailedOneof15,
        )

        url = f"/repos/{owner}/{repo}/rules/branches/{branch}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[
                Union[
                    RepositoryRuleDetailedOneof0,
                    RepositoryRuleDetailedOneof1,
                    RepositoryRuleDetailedOneof2,
                    RepositoryRuleDetailedOneof3,
                    RepositoryRuleDetailedOneof4,
                    RepositoryRuleDetailedOneof5,
                    RepositoryRuleDetailedOneof6,
                    RepositoryRuleDetailedOneof7,
                    RepositoryRuleDetailedOneof8,
                    RepositoryRuleDetailedOneof9,
                    RepositoryRuleDetailedOneof10,
                    RepositoryRuleDetailedOneof11,
                    RepositoryRuleDetailedOneof12,
                    RepositoryRuleDetailedOneof13,
                    RepositoryRuleDetailedOneof14,
                    RepositoryRuleDetailedOneof15,
                ]
            ],
        )

    def get_repo_rulesets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        includes_parents: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RepositoryRuleset]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-all-repository-rulesets"""

        from typing import List

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rulesets(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        includes_parents: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RepositoryRuleset]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-all-repository-rulesets"""

        from typing import List

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset]: ...

    @overload
    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof14Type,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#create-a-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsPostBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset]: ...

    @overload
    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof14Type,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#create-a-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsPostBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_rule_suites(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RuleSuitesItems]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rule-suites#list-repository-rule-suites"""

        from typing import List

        from ..models import BasicError, RuleSuitesItems

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rule_suites(
        self,
        owner: str,
        repo: str,
        ref: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RuleSuitesItems]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rule-suites#list-repository-rule-suites"""

        from typing import List

        from ..models import BasicError, RuleSuitesItems

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_rule_suite(
        self,
        owner: str,
        repo: str,
        rule_suite_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RuleSuite]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rule-suites#get-a-repository-rule-suite"""

        from ..models import RuleSuite, BasicError

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rule_suite(
        self,
        owner: str,
        repo: str,
        rule_suite_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RuleSuite]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rule-suites#get-a-repository-rule-suite"""

        from ..models import RuleSuite, BasicError

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        includes_parents: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-a-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        includes_parents: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-a-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    @overload
    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof14Type,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#update-a-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsRulesetIdPutBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    @overload
    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[List[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            List[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof14Type,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset]: ...

    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#update-a-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsRulesetIdPutBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def delete_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#delete-a-repository-ruleset"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#delete-a-repository-ruleset"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[List[int]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-weekly-commit-activity"""

        from typing import List

        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[List[int]],
            error_models={},
        )

    async def async_get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[List[int]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-weekly-commit-activity"""

        from typing import List

        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[List[int]],
            error_models={},
        )

    def get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[CommitActivity]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-last-year-of-commit-activity"""

        from typing import List

        from ..models import CommitActivity

        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[CommitActivity],
        )

    async def async_get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[CommitActivity]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-last-year-of-commit-activity"""

        from typing import List

        from ..models import CommitActivity

        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[CommitActivity],
        )

    def get_contributors_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ContributorActivity]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-all-contributor-commit-activity"""

        from typing import List

        from ..models import ContributorActivity

        url = f"/repos/{owner}/{repo}/stats/contributors"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ContributorActivity],
        )

    async def async_get_contributors_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ContributorActivity]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-all-contributor-commit-activity"""

        from typing import List

        from ..models import ContributorActivity

        url = f"/repos/{owner}/{repo}/stats/contributors"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ContributorActivity],
        )

    def get_participation_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ParticipationStats]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-weekly-commit-count"""

        from ..models import BasicError, ParticipationStats

        url = f"/repos/{owner}/{repo}/stats/participation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_participation_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ParticipationStats]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-weekly-commit-count"""

        from ..models import BasicError, ParticipationStats

        url = f"/repos/{owner}/{repo}/stats/participation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    def get_punch_card_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[List[int]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-hourly-commit-count-for-each-day"""

        from typing import List

        url = f"/repos/{owner}/{repo}/stats/punch_card"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[List[int]],
        )

    async def async_get_punch_card_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[List[int]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-hourly-commit-count-for-each-day"""

        from typing import List

        url = f"/repos/{owner}/{repo}/stats/punch_card"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[List[int]],
        )

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> Response[Status]: ...

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[Status]: ...

    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Status]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#create-a-commit-status"""

        from ..models import Status, ReposOwnerRepoStatusesShaPostBody

        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoStatusesShaPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Status,
        )

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> Response[Status]: ...

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[Status]: ...

    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Status]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#create-a-commit-status"""

        from ..models import Status, ReposOwnerRepoStatusesShaPostBody

        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoStatusesShaPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Status,
        )

    def list_tags(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Tag]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-tags"""

        from typing import List

        from ..models import Tag

        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Tag],
        )

    async def async_list_tags(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Tag]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-tags"""

        from typing import List

        from ..models import Tag

        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Tag],
        )

    def list_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TagProtection]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#deprecated---list-tag-protection-states-for-a-repository"""

        from typing import List

        from ..models import BasicError, TagProtection

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TagProtection]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#deprecated---list-tag-protection-states-for-a-repository"""

        from typing import List

        from ..models import BasicError, TagProtection

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTagsProtectionPostBodyType,
    ) -> Response[TagProtection]: ...

    @overload
    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        pattern: str,
    ) -> Response[TagProtection]: ...

    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TagProtection]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#deprecated---create-a-tag-protection-state-for-a-repository"""

        from ..models import (
            BasicError,
            TagProtection,
            ReposOwnerRepoTagsProtectionPostBody,
        )

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoTagsProtectionPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTagsProtectionPostBodyType,
    ) -> Response[TagProtection]: ...

    @overload
    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        pattern: str,
    ) -> Response[TagProtection]: ...

    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TagProtection]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#deprecated---create-a-tag-protection-state-for-a-repository"""

        from ..models import (
            BasicError,
            TagProtection,
            ReposOwnerRepoTagsProtectionPostBody,
        )

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoTagsProtectionPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#deprecated---delete-a-tag-protection-state-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#deprecated---delete-a-tag-protection-state-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#download-a-repository-archive-tar"""

        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#download-a-repository-archive-tar"""

        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    def list_teams(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-teams"""

        from typing import List

        from ..models import Team, BasicError

        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_teams(
        self,
        owner: str,
        repo: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-teams"""

        from typing import List

        from ..models import Team, BasicError

        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    def get_all_topics(
        self,
        owner: str,
        repo: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Topic]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#get-all-repository-topics"""

        from ..models import Topic, BasicError

        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_topics(
        self,
        owner: str,
        repo: str,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Topic]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#get-all-repository-topics"""

        from ..models import Topic, BasicError

        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTopicsPutBodyType,
    ) -> Response[Topic]: ...

    @overload
    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        names: List[str],
    ) -> Response[Topic]: ...

    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Topic]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#replace-all-repository-topics"""

        from ..models import (
            Topic,
            BasicError,
            ValidationErrorSimple,
            ReposOwnerRepoTopicsPutBody,
        )

        url = f"/repos/{owner}/{repo}/topics"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoTopicsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTopicsPutBodyType,
    ) -> Response[Topic]: ...

    @overload
    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        names: List[str],
    ) -> Response[Topic]: ...

    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Topic]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#replace-all-repository-topics"""

        from ..models import (
            Topic,
            BasicError,
            ValidationErrorSimple,
            ReposOwnerRepoTopicsPutBody,
        )

        url = f"/repos/{owner}/{repo}/topics"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoTopicsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_clones(
        self,
        owner: str,
        repo: str,
        per: Missing[Literal["day", "week"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CloneTraffic]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-repository-clones"""

        from ..models import BasicError, CloneTraffic

        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_clones(
        self,
        owner: str,
        repo: str,
        per: Missing[Literal["day", "week"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CloneTraffic]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-repository-clones"""

        from ..models import BasicError, CloneTraffic

        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    def get_top_paths(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ContentTraffic]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-top-referral-paths"""

        from typing import List

        from ..models import BasicError, ContentTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_paths(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ContentTraffic]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-top-referral-paths"""

        from typing import List

        from ..models import BasicError, ContentTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_top_referrers(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ReferrerTraffic]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-top-referral-sources"""

        from typing import List

        from ..models import BasicError, ReferrerTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_referrers(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[ReferrerTraffic]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-top-referral-sources"""

        from typing import List

        from ..models import BasicError, ReferrerTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_views(
        self,
        owner: str,
        repo: str,
        per: Missing[Literal["day", "week"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ViewTraffic]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-page-views"""

        from ..models import BasicError, ViewTraffic

        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_views(
        self,
        owner: str,
        repo: str,
        per: Missing[Literal["day", "week"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ViewTraffic]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-page-views"""

        from ..models import BasicError, ViewTraffic

        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTransferPostBodyType,
    ) -> Response[MinimalRepository]: ...

    @overload
    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_owner: str,
        new_name: Missing[str] = UNSET,
        team_ids: Missing[List[int]] = UNSET,
    ) -> Response[MinimalRepository]: ...

    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MinimalRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#transfer-a-repository"""

        from ..models import MinimalRepository, ReposOwnerRepoTransferPostBody

        url = f"/repos/{owner}/{repo}/transfer"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoTransferPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MinimalRepository,
        )

    @overload
    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposOwnerRepoTransferPostBodyType,
    ) -> Response[MinimalRepository]: ...

    @overload
    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        new_owner: str,
        new_name: Missing[str] = UNSET,
        team_ids: Missing[List[int]] = UNSET,
    ) -> Response[MinimalRepository]: ...

    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MinimalRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#transfer-a-repository"""

        from ..models import MinimalRepository, ReposOwnerRepoTransferPostBody

        url = f"/repos/{owner}/{repo}/transfer"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(ReposOwnerRepoTransferPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MinimalRepository,
        )

    def check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-vulnerability-alerts-are-enabled-for-a-repository"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-vulnerability-alerts-are-enabled-for-a-repository"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-vulnerability-alerts"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-vulnerability-alerts"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-vulnerability-alerts"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-vulnerability-alerts"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#download-a-repository-archive-zip"""

        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#download-a-repository-archive-zip"""

        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> Response[FullRepository]: ...

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        owner: Missing[str] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        include_all_branches: Missing[bool] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[FullRepository]: ...

    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-using-a-template"""

        from ..models import (
            FullRepository,
            ReposTemplateOwnerTemplateRepoGeneratePostBody,
        )

        url = f"/repos/{template_owner}/{template_repo}/generate"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposTemplateOwnerTemplateRepoGeneratePostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
        )

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> Response[FullRepository]: ...

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        owner: Missing[str] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        include_all_branches: Missing[bool] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[FullRepository]: ...

    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-using-a-template"""

        from ..models import (
            FullRepository,
            ReposTemplateOwnerTemplateRepoGeneratePostBody,
        )

        url = f"/repos/{template_owner}/{template_repo}/generate"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            ReposTemplateOwnerTemplateRepoGeneratePostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
        )

    def list_public(
        self,
        since: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-public-repositories"""

        from typing import List

        from ..models import ValidationError, MinimalRepository

        url = "/repositories"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_public(
        self,
        since: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-public-repositories"""

        from typing import List

        from ..models import ValidationError, MinimalRepository

        url = "/repositories"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        visibility: Missing[Literal["all", "public", "private"]] = UNSET,
        affiliation: Missing[str] = UNSET,
        type: Missing[Literal["all", "owner", "public", "private", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Repository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repositories-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, Repository, ValidationError

        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        visibility: Missing[Literal["all", "public", "private"]] = UNSET,
        affiliation: Missing[str] = UNSET,
        type: Missing[Literal["all", "owner", "public", "private", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Repository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repositories-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, Repository, ValidationError

        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_for_authenticated_user(
        self, *, headers: Optional[Dict[str, str]] = None, data: UserReposPostBodyType
    ) -> Response[FullRepository]: ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_discussions: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
    ) -> Response[FullRepository]: ...

    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            FullRepository,
            ValidationError,
            UserReposPostBody,
        )

        url = "/user/repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self, *, headers: Optional[Dict[str, str]] = None, data: UserReposPostBodyType
    ) -> Response[FullRepository]: ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_discussions: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
    ) -> Response[FullRepository]: ...

    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            FullRepository,
            ValidationError,
            UserReposPostBody,
        )

        url = "/user/repos"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    def list_invitations_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RepositoryInvitation]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#list-repository-invitations-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, RepositoryInvitation

        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_invitations_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[RepositoryInvitation]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#list-repository-invitations-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, RepositoryInvitation

        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#decline-a-repository-invitation"""

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#decline-a-repository-invitation"""

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#accept-a-repository-invitation"""

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    async def async_accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#accept-a-repository-invitation"""

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        type: Missing[Literal["all", "owner", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repositories-for-a-user"""

        from typing import List

        from ..models import MinimalRepository

        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )

    async def async_list_for_user(
        self,
        username: str,
        type: Missing[Literal["all", "owner", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repositories-for-a-user"""

        from typing import List

        from ..models import MinimalRepository

        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
        )
