"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from datetime import datetime
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import (
        Team,
        OrgHook,
        SimpleUser,
        TeamSimple,
        HookDelivery,
        OrgMembership,
        WebhookConfig,
        HookDeliveryItem,
        OrganizationFull,
        OrganizationRole,
        MinimalRepository,
        OrgCustomProperty,
        OrganizationSimple,
        TeamRoleAssignment,
        UserRoleAssignment,
        OrganizationInvitation,
        OrgRepoCustomPropertyValues,
        OrganizationFineGrainedPermission,
        OrgsOrgInstallationsGetResponse200,
        OrganizationProgrammaticAccessGrant,
        OrgsOrgOrganizationRolesGetResponse200,
        OrganizationProgrammaticAccessGrantRequest,
        OrgsOrgAttestationsSubjectDigestGetResponse200,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
    )
    from ..types import (
        OrgsOrgPatchBodyType,
        OrgCustomPropertyType,
        CustomPropertyValueType,
        OrgsOrgHooksPostBodyType,
        OrgsOrgInvitationsPostBodyType,
        OrgsOrgHooksHookIdPatchBodyType,
        OrgsOrgHooksPostBodyPropConfigType,
        UserMembershipsOrgsOrgPatchBodyType,
        OrgsOrgOrganizationRolesPostBodyType,
        OrgsOrgPropertiesSchemaPatchBodyType,
        OrgsOrgPropertiesValuesPatchBodyType,
        OrgsOrgHooksHookIdConfigPatchBodyType,
        OrgsOrgMembershipsUsernamePutBodyType,
        OrgsOrgPersonalAccessTokensPostBodyType,
        OrgsOrgHooksHookIdPatchBodyPropConfigType,
        OrgsOrgOrganizationRolesRoleIdPatchBodyType,
        OrgsOrgPersonalAccessTokensPatIdPostBodyType,
        OrgsOrgSecurityProductEnablementPostBodyType,
        OrgsOrgOutsideCollaboratorsUsernamePutBodyType,
        OrgsOrgPersonalAccessTokenRequestsPostBodyType,
        OrgsOrgPropertiesSchemaCustomPropertyNamePutBodyType,
        OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
    )


class OrgsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationSimple]]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-organizations"""

        from typing import List

        from ..models import OrganizationSimple

        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
        )

    async def async_list(
        self,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationSimple]]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-organizations"""

        from typing import List

        from ..models import OrganizationSimple

        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
        )

    def get(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrganizationFull]:
        """See also: https://docs.github.com/rest/orgs/orgs#get-an-organization"""

        from ..models import BasicError, OrganizationFull

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrganizationFull]:
        """See also: https://docs.github.com/rest/orgs/orgs#get-an-organization"""

        from ..models import BasicError, OrganizationFull

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/rest/orgs/orgs#delete-an-organization"""

        from ..models import (
            BasicError,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/rest/orgs/orgs#delete-an-organization"""

        from ..models import (
            BasicError,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
    ) -> Response[OrganizationFull]: ...

    @overload
    def update(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        billing_email: Missing[str] = UNSET,
        company: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        twitter_username: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        has_organization_projects: Missing[bool] = UNSET,
        has_repository_projects: Missing[bool] = UNSET,
        default_repository_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        members_can_create_repositories: Missing[bool] = UNSET,
        members_can_create_internal_repositories: Missing[bool] = UNSET,
        members_can_create_private_repositories: Missing[bool] = UNSET,
        members_can_create_public_repositories: Missing[bool] = UNSET,
        members_allowed_repository_creation_type: Missing[
            Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Missing[bool] = UNSET,
        members_can_create_public_pages: Missing[bool] = UNSET,
        members_can_create_private_pages: Missing[bool] = UNSET,
        members_can_fork_private_repositories: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
        blog: Missing[str] = UNSET,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependency_graph_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Missing[bool] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[str] = UNSET,
    ) -> Response[OrganizationFull]: ...

    def update(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationFull]:
        """See also: https://docs.github.com/rest/orgs/orgs#update-an-organization"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationFull,
            OrgsOrgPatchBody,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
    ) -> Response[OrganizationFull]: ...

    @overload
    async def async_update(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        billing_email: Missing[str] = UNSET,
        company: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        twitter_username: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        has_organization_projects: Missing[bool] = UNSET,
        has_repository_projects: Missing[bool] = UNSET,
        default_repository_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        members_can_create_repositories: Missing[bool] = UNSET,
        members_can_create_internal_repositories: Missing[bool] = UNSET,
        members_can_create_private_repositories: Missing[bool] = UNSET,
        members_can_create_public_repositories: Missing[bool] = UNSET,
        members_allowed_repository_creation_type: Missing[
            Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Missing[bool] = UNSET,
        members_can_create_public_pages: Missing[bool] = UNSET,
        members_can_create_private_pages: Missing[bool] = UNSET,
        members_can_fork_private_repositories: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
        blog: Missing[str] = UNSET,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependency_graph_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Missing[bool] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[str] = UNSET,
    ) -> Response[OrganizationFull]: ...

    async def async_update(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationFull]:
        """See also: https://docs.github.com/rest/orgs/orgs#update-an-organization"""

        from typing import Union

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationFull,
            OrgsOrgPatchBody,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    def list_attestations(
        self,
        org: str,
        subject_digest: str,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgAttestationsSubjectDigestGetResponse200]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-attestations"""

        from ..models import OrgsOrgAttestationsSubjectDigestGetResponse200

        url = f"/orgs/{org}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgAttestationsSubjectDigestGetResponse200,
        )

    async def async_list_attestations(
        self,
        org: str,
        subject_digest: str,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgAttestationsSubjectDigestGetResponse200]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-attestations"""

        from ..models import OrgsOrgAttestationsSubjectDigestGetResponse200

        url = f"/orgs/{org}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgAttestationsSubjectDigestGetResponse200,
        )

    def list_blocked_users(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/orgs/blocking#list-users-blocked-by-an-organization"""

        from typing import List

        from ..models import SimpleUser

        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_blocked_users(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/orgs/blocking#list-users-blocked-by-an-organization"""

        from typing import List

        from ..models import SimpleUser

        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def check_blocked_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/blocking#check-if-a-user-is-blocked-by-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_blocked_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/blocking#check-if-a-user-is-blocked-by-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def block_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/blocking#block-a-user-from-an-organization"""

        from ..models import ValidationError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    async def async_block_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/blocking#block-a-user-from-an-organization"""

        from ..models import ValidationError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    def unblock_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/blocking#unblock-a-user-from-an-organization"""

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_unblock_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/blocking#unblock-a-user-from-an-organization"""

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_failed_invitations(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationInvitation]]:
        """See also: https://docs.github.com/rest/orgs/members#list-failed-organization-invitations"""

        from typing import List

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_failed_invitations(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationInvitation]]:
        """See also: https://docs.github.com/rest/orgs/members#list-failed-organization-invitations"""

        from typing import List

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrgHook]]:
        """See also: https://docs.github.com/rest/orgs/webhooks#list-organization-webhooks"""

        from typing import List

        from ..models import OrgHook, BasicError

        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrgHook]]:
        """See also: https://docs.github.com/rest/orgs/webhooks#list-organization-webhooks"""

        from typing import List

        from ..models import OrgHook, BasicError

        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgHooksPostBodyType,
    ) -> Response[OrgHook]: ...

    @overload
    def create_webhook(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Missing[List[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[OrgHook]: ...

    def create_webhook(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook]:
        """See also: https://docs.github.com/rest/orgs/webhooks#create-an-organization-webhook"""

        from ..models import OrgHook, BasicError, ValidationError, OrgsOrgHooksPostBody

        url = f"/orgs/{org}/hooks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgHooksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgHooksPostBodyType,
    ) -> Response[OrgHook]: ...

    @overload
    async def async_create_webhook(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Missing[List[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[OrgHook]: ...

    async def async_create_webhook(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook]:
        """See also: https://docs.github.com/rest/orgs/webhooks#create-an-organization-webhook"""

        from ..models import OrgHook, BasicError, ValidationError, OrgsOrgHooksPostBody

        url = f"/orgs/{org}/hooks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgHooksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgHook]:
        """See also: https://docs.github.com/rest/orgs/webhooks#get-an-organization-webhook"""

        from ..models import OrgHook, BasicError

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgHook]:
        """See also: https://docs.github.com/rest/orgs/webhooks#get-an-organization-webhook"""

        from ..models import OrgHook, BasicError

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/webhooks#delete-an-organization-webhook"""

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/webhooks#delete-an-organization-webhook"""

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> Response[OrgHook]: ...

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        config: Missing[OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = UNSET,
        active: Missing[bool] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[OrgHook]: ...

    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook]:
        """See also: https://docs.github.com/rest/orgs/webhooks#update-an-organization-webhook"""

        from ..models import (
            OrgHook,
            BasicError,
            ValidationError,
            OrgsOrgHooksHookIdPatchBody,
        )

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> Response[OrgHook]: ...

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        config: Missing[OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[List[str]] = UNSET,
        active: Missing[bool] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[OrgHook]: ...

    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook]:
        """See also: https://docs.github.com/rest/orgs/webhooks#update-an-organization-webhook"""

        from ..models import (
            OrgHook,
            BasicError,
            ValidationError,
            OrgsOrgHooksHookIdPatchBody,
        )

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WebhookConfig]:
        """See also: https://docs.github.com/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization"""

        from ..models import WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[WebhookConfig]:
        """See also: https://docs.github.com/rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization"""

        from ..models import WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig]: ...

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig]: ...

    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig]:
        """See also: https://docs.github.com/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization"""

        from ..models import WebhookConfig, OrgsOrgHooksHookIdConfigPatchBody

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig]: ...

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig]: ...

    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig]:
        """See also: https://docs.github.com/rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization"""

        from ..models import WebhookConfig, OrgsOrgHooksHookIdConfigPatchBody

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[HookDeliveryItem]]:
        """See also: https://docs.github.com/rest/orgs/webhooks#list-deliveries-for-an-organization-webhook"""

        from typing import List

        from ..models import BasicError, ValidationError, HookDeliveryItem

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        redelivery: Missing[bool] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[HookDeliveryItem]]:
        """See also: https://docs.github.com/rest/orgs/webhooks#list-deliveries-for-an-organization-webhook"""

        from typing import List

        from ..models import BasicError, ValidationError, HookDeliveryItem

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
            "redelivery": redelivery,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[HookDelivery]:
        """See also: https://docs.github.com/rest/orgs/webhooks#get-a-webhook-delivery-for-an-organization-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[HookDelivery]:
        """See also: https://docs.github.com/rest/orgs/webhooks#get-a-webhook-delivery-for-an-organization-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/rest/orgs/webhooks#redeliver-a-delivery-for-an-organization-webhook"""

        from ..models import (
            BasicError,
            ValidationError,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/rest/orgs/webhooks#redeliver-a-delivery-for-an-organization-webhook"""

        from ..models import (
            BasicError,
            ValidationError,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/webhooks#ping-an-organization-webhook"""

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/webhooks#ping-an-organization-webhook"""

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_app_installations(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgInstallationsGetResponse200]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-app-installations-for-an-organization"""

        from ..models import OrgsOrgInstallationsGetResponse200

        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    async def async_list_app_installations(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgInstallationsGetResponse200]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-app-installations-for-an-organization"""

        from ..models import OrgsOrgInstallationsGetResponse200

        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    def list_pending_invitations(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        role: Missing[
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ]
        ] = UNSET,
        invitation_source: Missing[Literal["all", "member", "scim"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationInvitation]]:
        """See also: https://docs.github.com/rest/orgs/members#list-pending-organization-invitations"""

        from typing import List

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_pending_invitations(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        role: Missing[
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ]
        ] = UNSET,
        invitation_source: Missing[Literal["all", "member", "scim"]] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationInvitation]]:
        """See also: https://docs.github.com/rest/orgs/members#list-pending-organization-invitations"""

        from typing import List

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_invitation(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
    ) -> Response[OrganizationInvitation]: ...

    @overload
    def create_invitation(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        invitee_id: Missing[int] = UNSET,
        email: Missing[str] = UNSET,
        role: Missing[
            Literal["admin", "direct_member", "billing_manager", "reinstate"]
        ] = UNSET,
        team_ids: Missing[List[int]] = UNSET,
    ) -> Response[OrganizationInvitation]: ...

    def create_invitation(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationInvitation]:
        """See also: https://docs.github.com/rest/orgs/members#create-an-organization-invitation"""

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationInvitation,
            OrgsOrgInvitationsPostBody,
        )

        url = f"/orgs/{org}/invitations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgInvitationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_invitation(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
    ) -> Response[OrganizationInvitation]: ...

    @overload
    async def async_create_invitation(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        invitee_id: Missing[int] = UNSET,
        email: Missing[str] = UNSET,
        role: Missing[
            Literal["admin", "direct_member", "billing_manager", "reinstate"]
        ] = UNSET,
        team_ids: Missing[List[int]] = UNSET,
    ) -> Response[OrganizationInvitation]: ...

    async def async_create_invitation(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationInvitation]:
        """See also: https://docs.github.com/rest/orgs/members#create-an-organization-invitation"""

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationInvitation,
            OrgsOrgInvitationsPostBody,
        )

        url = f"/orgs/{org}/invitations"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgInvitationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def cancel_invitation(
        self,
        org: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#cancel-an-organization-invitation"""

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_cancel_invitation(
        self,
        org: str,
        invitation_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#cancel-an-organization-invitation"""

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/rest/orgs/members#list-organization-invitation-teams"""

        from typing import List

        from ..models import Team, BasicError

        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Team]]:
        """See also: https://docs.github.com/rest/orgs/members#list-organization-invitation-teams"""

        from typing import List

        from ..models import Team, BasicError

        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Team],
            error_models={
                "404": BasicError,
            },
        )

    def list_members(
        self,
        org: str,
        filter_: Missing[Literal["2fa_disabled", "all"]] = UNSET,
        role: Missing[Literal["all", "admin", "member"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/orgs/members#list-organization-members"""

        from typing import List

        from ..models import SimpleUser, ValidationError

        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_members(
        self,
        org: str,
        filter_: Missing[Literal["2fa_disabled", "all"]] = UNSET,
        role: Missing[Literal["all", "admin", "member"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/orgs/members#list-organization-members"""

        from typing import List

        from ..models import SimpleUser, ValidationError

        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    def check_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#check-organization-membership-for-a-user"""

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#check-organization-membership-for-a-user"""

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_member(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#remove-an-organization-member"""

        from ..models import BasicError

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_remove_member(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#remove-an-organization-member"""

        from ..models import BasicError

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def get_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgMembership]:
        """See also: https://docs.github.com/rest/orgs/members#get-organization-membership-for-a-user"""

        from ..models import BasicError, OrgMembership

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgMembership]:
        """See also: https://docs.github.com/rest/orgs/members#get-organization-membership-for-a-user"""

        from ..models import BasicError, OrgMembership

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[OrgMembership]: ...

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        role: Missing[Literal["admin", "member"]] = UNSET,
    ) -> Response[OrgMembership]: ...

    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership]:
        """See also: https://docs.github.com/rest/orgs/members#set-organization-membership-for-a-user"""

        from ..models import (
            BasicError,
            OrgMembership,
            ValidationError,
            OrgsOrgMembershipsUsernamePutBody,
        )

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[OrgMembership]: ...

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        role: Missing[Literal["admin", "member"]] = UNSET,
    ) -> Response[OrgMembership]: ...

    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership]:
        """See also: https://docs.github.com/rest/orgs/members#set-organization-membership-for-a-user"""

        from ..models import (
            BasicError,
            OrgMembership,
            ValidationError,
            OrgsOrgMembershipsUsernamePutBody,
        )

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#remove-organization-membership-for-a-user"""

        from ..models import BasicError

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#remove-organization-membership-for-a-user"""

        from ..models import BasicError

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_organization_fine_grained_permissions(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationFineGrainedPermission]]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#list-organization-fine-grained-permissions-for-an-organization"""

        from typing import List

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationFineGrainedPermission,
        )

        url = f"/orgs/{org}/organization-fine-grained-permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[OrganizationFineGrainedPermission],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_organization_fine_grained_permissions(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationFineGrainedPermission]]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#list-organization-fine-grained-permissions-for-an-organization"""

        from typing import List

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationFineGrainedPermission,
        )

        url = f"/orgs/{org}/organization-fine-grained-permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[OrganizationFineGrainedPermission],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_org_roles(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgOrganizationRolesGetResponse200]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#get-all-organization-roles-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgOrganizationRolesGetResponse200,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgOrganizationRolesGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_org_roles(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgsOrgOrganizationRolesGetResponse200]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#get-all-organization-roles-for-an-organization"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgOrganizationRolesGetResponse200,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgOrganizationRolesGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def create_custom_organization_role(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgOrganizationRolesPostBodyType,
    ) -> Response[OrganizationRole]: ...

    @overload
    def create_custom_organization_role(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        permissions: List[str],
    ) -> Response[OrganizationRole]: ...

    def create_custom_organization_role(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgOrganizationRolesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationRole]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#create-a-custom-organization-role"""

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationRole,
            OrgsOrgOrganizationRolesPostBody,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgOrganizationRolesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_custom_organization_role(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgOrganizationRolesPostBodyType,
    ) -> Response[OrganizationRole]: ...

    @overload
    async def async_create_custom_organization_role(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        permissions: List[str],
    ) -> Response[OrganizationRole]: ...

    async def async_create_custom_organization_role(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgOrganizationRolesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationRole]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#create-a-custom-organization-role"""

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationRole,
            OrgsOrgOrganizationRolesPostBody,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgOrganizationRolesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def revoke_all_org_roles_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#remove-all-organization-roles-for-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_all_org_roles_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#remove-all-organization-roles-for-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def assign_team_to_org_role(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#assign-an-organization-role-to-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_assign_team_to_org_role(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#assign-an-organization-role-to-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def revoke_org_role_team(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#remove-an-organization-role-from-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_org_role_team(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#remove-an-organization-role-from-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def revoke_all_org_roles_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#remove-all-organization-roles-for-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_all_org_roles_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#remove-all-organization-roles-for-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def assign_user_to_org_role(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#assign-an-organization-role-to-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_assign_user_to_org_role(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#assign-an-organization-role-to-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def revoke_org_role_user(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#remove-an-organization-role-from-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_org_role_user(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#remove-an-organization-role-from-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_org_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrganizationRole]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#get-an-organization-role"""

        from ..models import BasicError, ValidationError, OrganizationRole

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_org_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrganizationRole]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#get-an-organization-role"""

        from ..models import BasicError, ValidationError, OrganizationRole

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def delete_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#delete-a-custom-organization-role"""

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/organization-roles#delete-a-custom-organization-role"""

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgOrganizationRolesRoleIdPatchBodyType,
    ) -> Response[OrganizationRole]: ...

    @overload
    def patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        permissions: Missing[List[str]] = UNSET,
    ) -> Response[OrganizationRole]: ...

    def patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgOrganizationRolesRoleIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationRole]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#update-a-custom-organization-role"""

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationRole,
            OrgsOrgOrganizationRolesRoleIdPatchBody,
        )

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgOrganizationRolesRoleIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "422": ValidationError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgOrganizationRolesRoleIdPatchBodyType,
    ) -> Response[OrganizationRole]: ...

    @overload
    async def async_patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        permissions: Missing[List[str]] = UNSET,
    ) -> Response[OrganizationRole]: ...

    async def async_patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgOrganizationRolesRoleIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationRole]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#update-a-custom-organization-role"""

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationRole,
            OrgsOrgOrganizationRolesRoleIdPatchBody,
        )

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgOrganizationRolesRoleIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "422": ValidationError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    def list_org_role_teams(
        self,
        org: str,
        role_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamRoleAssignment]]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#list-teams-that-are-assigned-to-an-organization-role"""

        from typing import List

        from ..models import TeamRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamRoleAssignment],
            error_models={},
        )

    async def async_list_org_role_teams(
        self,
        org: str,
        role_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamRoleAssignment]]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#list-teams-that-are-assigned-to-an-organization-role"""

        from typing import List

        from ..models import TeamRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[TeamRoleAssignment],
            error_models={},
        )

    def list_org_role_users(
        self,
        org: str,
        role_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[UserRoleAssignment]]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#list-users-that-are-assigned-to-an-organization-role"""

        from typing import List

        from ..models import UserRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/users"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[UserRoleAssignment],
            error_models={},
        )

    async def async_list_org_role_users(
        self,
        org: str,
        role_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[UserRoleAssignment]]:
        """See also: https://docs.github.com/rest/orgs/organization-roles#list-users-that-are-assigned-to-an-organization-role"""

        from typing import List

        from ..models import UserRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/users"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[UserRoleAssignment],
            error_models={},
        )

    def list_outside_collaborators(
        self,
        org: str,
        filter_: Missing[Literal["2fa_disabled", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/orgs/outside-collaborators#list-outside-collaborators-for-an-organization"""

        from typing import List

        from ..models import SimpleUser

        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_outside_collaborators(
        self,
        org: str,
        filter_: Missing[Literal["2fa_disabled", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/orgs/outside-collaborators#list-outside-collaborators-for-an-organization"""

        from typing import List

        from ..models import SimpleUser

        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]: ...

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        async_: Missing[bool] = UNSET,
    ) -> Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]: ...

    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]:
        """See also: https://docs.github.com/rest/orgs/outside-collaborators#convert-an-organization-member-to-outside-collaborator"""

        from ..models import (
            BasicError,
            OrgsOrgOutsideCollaboratorsUsernamePutBody,
            OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        )

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgOutsideCollaboratorsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]: ...

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        async_: Missing[bool] = UNSET,
    ) -> Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]: ...

    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgsOrgOutsideCollaboratorsUsernamePutResponse202]:
        """See also: https://docs.github.com/rest/orgs/outside-collaborators#convert-an-organization-member-to-outside-collaborator"""

        from ..models import (
            BasicError,
            OrgsOrgOutsideCollaboratorsUsernamePutBody,
            OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        )

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgOutsideCollaboratorsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    def remove_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/outside-collaborators#remove-outside-collaborator-from-an-organization"""

        from ..models import OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    async def async_remove_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/outside-collaborators#remove-outside-collaborator-from-an-organization"""

        from ..models import OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    def list_pat_grant_requests(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[List[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationProgrammaticAccessGrantRequest]]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens"""

        from typing import List

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationProgrammaticAccessGrantRequest,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationProgrammaticAccessGrantRequest],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_requests(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[List[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationProgrammaticAccessGrantRequest]]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens"""

        from typing import List

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationProgrammaticAccessGrantRequest,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationProgrammaticAccessGrantRequest],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokenRequestsPostBodyType,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]: ...

    @overload
    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        pat_request_ids: Missing[List[int]] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]: ...

    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokenRequestsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#review-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPersonalAccessTokenRequestsPostBody,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPersonalAccessTokenRequestsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokenRequestsPostBodyType,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]: ...

    @overload
    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        pat_request_ids: Missing[List[int]] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]: ...

    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokenRequestsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#review-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPersonalAccessTokenRequestsPostBody,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPersonalAccessTokenRequestsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
    ) -> Response: ...

    @overload
    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response: ...

    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#review-a-request-to-access-organization-resources-with-a-fine-grained-personal-access-token"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody,
        )

        url = f"/orgs/{org}/personal-access-token-requests/{pat_request_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
    ) -> Response: ...

    @overload
    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response: ...

    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#review-a-request-to-access-organization-resources-with-a-fine-grained-personal-access-token"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody,
        )

        url = f"/orgs/{org}/personal-access-token-requests/{pat_request_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_pat_grant_request_repositories(
        self,
        org: str,
        pat_request_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-repositories-requested-to-be-accessed-by-a-fine-grained-personal-access-token"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = (
            f"/orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_request_repositories(
        self,
        org: str,
        pat_request_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-repositories-requested-to-be-accessed-by-a-fine-grained-personal-access-token"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = (
            f"/orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_pat_grants(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[List[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationProgrammaticAccessGrant]]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-fine-grained-personal-access-tokens-with-access-to-organization-resources"""

        from typing import List

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationProgrammaticAccessGrant,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationProgrammaticAccessGrant],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grants(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[List[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationProgrammaticAccessGrant]]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-fine-grained-personal-access-tokens-with-access-to-organization-resources"""

        from typing import List

        from ..models import (
            BasicError,
            ValidationError,
            OrganizationProgrammaticAccessGrant,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationProgrammaticAccessGrant],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokensPostBodyType,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]: ...

    @overload
    def update_pat_accesses(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        action: Literal["revoke"],
        pat_ids: List[int],
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]: ...

    def update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#update-the-access-to-organization-resources-via-fine-grained-personal-access-tokens"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPersonalAccessTokensPostBody,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPersonalAccessTokensPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokensPostBodyType,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]: ...

    @overload
    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        action: Literal["revoke"],
        pat_ids: List[int],
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]: ...

    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[AppHookDeliveriesDeliveryIdAttemptsPostResponse202]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#update-the-access-to-organization-resources-via-fine-grained-personal-access-tokens"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPersonalAccessTokensPostBody,
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPersonalAccessTokensPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokensPatIdPostBodyType,
    ) -> Response: ...

    @overload
    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        action: Literal["revoke"],
    ) -> Response: ...

    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokensPatIdPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#update-the-access-a-fine-grained-personal-access-token-has-to-organization-resources"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPersonalAccessTokensPatIdPostBody,
        )

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPersonalAccessTokensPatIdPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokensPatIdPostBodyType,
    ) -> Response: ...

    @overload
    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        action: Literal["revoke"],
    ) -> Response: ...

    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokensPatIdPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#update-the-access-a-fine-grained-personal-access-token-has-to-organization-resources"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPersonalAccessTokensPatIdPostBody,
        )

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPersonalAccessTokensPatIdPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pat_grant_repositories(
        self,
        org: str,
        pat_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-repositories-a-fine-grained-personal-access-token-has-access-to"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_repositories(
        self,
        org: str,
        pat_id: int,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[MinimalRepository]]:
        """See also: https://docs.github.com/rest/orgs/personal-access-tokens#list-repositories-a-fine-grained-personal-access-token-has-access-to"""

        from typing import List

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def get_all_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrgCustomProperty]]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#get-all-custom-properties-for-an-organization"""

        from typing import List

        from ..models import BasicError, OrgCustomProperty

        url = f"/orgs/{org}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[OrgCustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_all_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrgCustomProperty]]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#get-all-custom-properties-for-an-organization"""

        from typing import List

        from ..models import BasicError, OrgCustomProperty

        url = f"/orgs/{org}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[OrgCustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPropertiesSchemaPatchBodyType,
    ) -> Response[List[OrgCustomProperty]]: ...

    @overload
    def create_or_update_custom_properties(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        properties: List[OrgCustomPropertyType],
    ) -> Response[List[OrgCustomProperty]]: ...

    def create_or_update_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[List[OrgCustomProperty]]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-custom-properties-for-an-organization"""

        from typing import List

        from ..models import (
            BasicError,
            OrgCustomProperty,
            OrgsOrgPropertiesSchemaPatchBody,
        )

        url = f"/orgs/{org}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPropertiesSchemaPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[OrgCustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPropertiesSchemaPatchBodyType,
    ) -> Response[List[OrgCustomProperty]]: ...

    @overload
    async def async_create_or_update_custom_properties(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        properties: List[OrgCustomPropertyType],
    ) -> Response[List[OrgCustomProperty]]: ...

    async def async_create_or_update_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[List[OrgCustomProperty]]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-custom-properties-for-an-organization"""

        from typing import List

        from ..models import (
            BasicError,
            OrgCustomProperty,
            OrgsOrgPropertiesSchemaPatchBody,
        )

        url = f"/orgs/{org}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPropertiesSchemaPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[OrgCustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgCustomProperty]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#get-a-custom-property-for-an-organization"""

        from ..models import BasicError, OrgCustomProperty

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgCustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgCustomProperty]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#get-a-custom-property-for-an-organization"""

        from ..models import BasicError, OrgCustomProperty

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgCustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPropertiesSchemaCustomPropertyNamePutBodyType,
    ) -> Response[OrgCustomProperty]: ...

    @overload
    def create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, List[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[List[str], None]] = UNSET,
    ) -> Response[OrgCustomProperty]: ...

    def create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesSchemaCustomPropertyNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgCustomProperty]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-a-custom-property-for-an-organization"""

        from ..models import (
            BasicError,
            OrgCustomProperty,
            OrgsOrgPropertiesSchemaCustomPropertyNamePutBody,
        )

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgPropertiesSchemaCustomPropertyNamePutBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgCustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPropertiesSchemaCustomPropertyNamePutBodyType,
    ) -> Response[OrgCustomProperty]: ...

    @overload
    async def async_create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, List[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[List[str], None]] = UNSET,
    ) -> Response[OrgCustomProperty]: ...

    async def async_create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesSchemaCustomPropertyNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgCustomProperty]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-a-custom-property-for-an-organization"""

        from ..models import (
            BasicError,
            OrgCustomProperty,
            OrgsOrgPropertiesSchemaCustomPropertyNamePutBody,
        )

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            OrgsOrgPropertiesSchemaCustomPropertyNamePutBody, json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgCustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def remove_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/custom-properties#remove-a-custom-property-for-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/custom-properties#remove-a-custom-property-for-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_custom_properties_values_for_repos(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        repository_query: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrgRepoCustomPropertyValues]]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#list-custom-property-values-for-organization-repositories"""

        from typing import List

        from ..models import BasicError, OrgRepoCustomPropertyValues

        url = f"/orgs/{org}/properties/values"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_query": repository_query,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgRepoCustomPropertyValues],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_custom_properties_values_for_repos(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        repository_query: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrgRepoCustomPropertyValues]]:
        """See also: https://docs.github.com/rest/orgs/custom-properties#list-custom-property-values-for-organization-repositories"""

        from typing import List

        from ..models import BasicError, OrgRepoCustomPropertyValues

        url = f"/orgs/{org}/properties/values"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_query": repository_query,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgRepoCustomPropertyValues],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    def create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        repository_names: List[str],
        properties: List[CustomPropertyValueType],
    ) -> Response: ...

    def create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-custom-property-values-for-organization-repositories"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPropertiesValuesPatchBody,
        )

        url = f"/orgs/{org}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: OrgsOrgPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    async def async_create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        repository_names: List[str],
        properties: List[CustomPropertyValueType],
    ) -> Response: ...

    async def async_create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/custom-properties#create-or-update-custom-property-values-for-organization-repositories"""

        from ..models import (
            BasicError,
            ValidationError,
            OrgsOrgPropertiesValuesPatchBody,
        )

        url = f"/orgs/{org}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_public_members(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/orgs/members#list-public-organization-members"""

        from typing import List

        from ..models import SimpleUser

        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_public_members(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/orgs/members#list-public-organization-members"""

        from typing import List

        from ..models import SimpleUser

        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def check_public_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#check-public-organization-membership-for-a-user"""

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_public_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#check-public-organization-membership-for-a-user"""

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#set-public-organization-membership-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#set-public-organization-membership-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#remove-public-organization-membership-for-the-authenticated-user"""

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/members#remove-public-organization-membership-for-the-authenticated-user"""

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_security_manager_teams(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamSimple]]:
        """See also: https://docs.github.com/rest/orgs/security-managers#list-security-manager-teams"""

        from typing import List

        from ..models import TeamSimple

        url = f"/orgs/{org}/security-managers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[TeamSimple],
        )

    async def async_list_security_manager_teams(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[TeamSimple]]:
        """See also: https://docs.github.com/rest/orgs/security-managers#list-security-manager-teams"""

        from typing import List

        from ..models import TeamSimple

        url = f"/orgs/{org}/security-managers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=List[TeamSimple],
        )

    def add_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/security-managers#add-a-security-manager-team"""

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_add_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/security-managers#add-a-security-manager-team"""

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/security-managers#remove-a-security-manager-team"""

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/security-managers#remove-a-security-manager-team"""

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        query_suite: Missing[Literal["default", "extended"]] = UNSET,
    ) -> Response: ...

    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/orgs#enable-or-disable-a-security-feature-for-an-organization"""

        from ..models import OrgsOrgSecurityProductEnablementPostBody

        url = f"/orgs/{org}/{security_product}/{enablement}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgSecurityProductEnablementPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        query_suite: Missing[Literal["default", "extended"]] = UNSET,
    ) -> Response: ...

    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/orgs/orgs#enable-or-disable-a-security-feature-for-an-organization"""

        from ..models import OrgsOrgSecurityProductEnablementPostBody

        url = f"/orgs/{org}/{security_product}/{enablement}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(OrgsOrgSecurityProductEnablementPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_memberships_for_authenticated_user(
        self,
        state: Missing[Literal["active", "pending"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrgMembership]]:
        """See also: https://docs.github.com/rest/orgs/members#list-organization-memberships-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, OrgMembership, ValidationError

        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_memberships_for_authenticated_user(
        self,
        state: Missing[Literal["active", "pending"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrgMembership]]:
        """See also: https://docs.github.com/rest/orgs/members#list-organization-memberships-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, OrgMembership, ValidationError

        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def get_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgMembership]:
        """See also: https://docs.github.com/rest/orgs/members#get-an-organization-membership-for-the-authenticated-user"""

        from ..models import BasicError, OrgMembership

        url = f"/user/memberships/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[OrgMembership]:
        """See also: https://docs.github.com/rest/orgs/members#get-an-organization-membership-for-the-authenticated-user"""

        from ..models import BasicError, OrgMembership

        url = f"/user/memberships/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserMembershipsOrgsOrgPatchBodyType,
    ) -> Response[OrgMembership]: ...

    @overload
    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal["active"],
    ) -> Response[OrgMembership]: ...

    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership]:
        """See also: https://docs.github.com/rest/orgs/members#update-an-organization-membership-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            OrgMembership,
            ValidationError,
            UserMembershipsOrgsOrgPatchBody,
        )

        url = f"/user/memberships/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserMembershipsOrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserMembershipsOrgsOrgPatchBodyType,
    ) -> Response[OrgMembership]: ...

    @overload
    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        state: Literal["active"],
    ) -> Response[OrgMembership]: ...

    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership]:
        """See also: https://docs.github.com/rest/orgs/members#update-an-organization-membership-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            OrgMembership,
            ValidationError,
            UserMembershipsOrgsOrgPatchBody,
        )

        url = f"/user/memberships/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserMembershipsOrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationSimple]]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-organizations-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, OrganizationSimple

        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationSimple]]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-organizations-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, OrganizationSimple

        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationSimple]]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-organizations-for-a-user"""

        from typing import List

        from ..models import OrganizationSimple

        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
        )

    async def async_list_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[OrganizationSimple]]:
        """See also: https://docs.github.com/rest/orgs/orgs#list-organizations-for-a-user"""

        from typing import List

        from ..models import OrganizationSimple

        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[OrganizationSimple],
        )
