"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import (
        Key,
        Email,
        GpgKey,
        Hovercard,
        KeySimple,
        PublicUser,
        SimpleUser,
        PrivateUser,
        SocialAccount,
        SshSigningKey,
        UsersUsernameAttestationsSubjectDigestGetResponse200,
    )
    from ..types import (
        UserPatchBodyType,
        UserKeysPostBodyType,
        UserGpgKeysPostBodyType,
        UserEmailsPostBodyOneof0Type,
        UserEmailsDeleteBodyOneof0Type,
        UserSocialAccountsPostBodyType,
        UserSshSigningKeysPostBodyType,
        UserEmailVisibilityPatchBodyType,
        UserSocialAccountsDeleteBodyType,
    )


class UsersClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_authenticated(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[PrivateUser, PublicUser]]:
        """See also: https://docs.github.com/rest/users/users#get-the-authenticated-user"""

        from typing import Union

        from ..models import BasicError, PublicUser, PrivateUser

        url = "/user"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_authenticated(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[PrivateUser, PublicUser]]:
        """See also: https://docs.github.com/rest/users/users#get-the-authenticated-user"""

        from typing import Union

        from ..models import BasicError, PublicUser, PrivateUser

        url = "/user"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_authenticated(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserPatchBodyType] = UNSET,
    ) -> Response[PrivateUser]: ...

    @overload
    def update_authenticated(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        blog: Missing[str] = UNSET,
        twitter_username: Missing[Union[str, None]] = UNSET,
        company: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        hireable: Missing[bool] = UNSET,
        bio: Missing[str] = UNSET,
    ) -> Response[PrivateUser]: ...

    def update_authenticated(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PrivateUser]:
        """See also: https://docs.github.com/rest/users/users#update-the-authenticated-user"""

        from ..models import BasicError, PrivateUser, UserPatchBody, ValidationError

        url = "/user"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PrivateUser,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_authenticated(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserPatchBodyType] = UNSET,
    ) -> Response[PrivateUser]: ...

    @overload
    async def async_update_authenticated(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        blog: Missing[str] = UNSET,
        twitter_username: Missing[Union[str, None]] = UNSET,
        company: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        hireable: Missing[bool] = UNSET,
        bio: Missing[str] = UNSET,
    ) -> Response[PrivateUser]: ...

    async def async_update_authenticated(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PrivateUser]:
        """See also: https://docs.github.com/rest/users/users#update-the-authenticated-user"""

        from ..models import BasicError, PrivateUser, UserPatchBody, ValidationError

        url = "/user"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PrivateUser,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def list_blocked_by_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/blocking#list-users-blocked-by-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = "/user/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_blocked_by_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/blocking#list-users-blocked-by-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = "/user/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def check_blocked(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/blocking#check-if-a-user-is-blocked-by-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_check_blocked(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/blocking#check-if-a-user-is-blocked-by-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def block(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/blocking#block-a-user"""

        from ..models import BasicError, ValidationError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_block(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/blocking#block-a-user"""

        from ..models import BasicError, ValidationError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def unblock(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/blocking#unblock-a-user"""

        from ..models import BasicError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_unblock(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/blocking#unblock-a-user"""

        from ..models import BasicError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserEmailVisibilityPatchBodyType,
    ) -> Response[List[Email]]: ...

    @overload
    def set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        visibility: Literal["public", "private"],
    ) -> Response[List[Email]]: ...

    def set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserEmailVisibilityPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[List[Email]]:
        """See also: https://docs.github.com/rest/users/emails#set-primary-email-visibility-for-the-authenticated-user"""

        from typing import List

        from ..models import (
            Email,
            BasicError,
            ValidationError,
            UserEmailVisibilityPatchBody,
        )

        url = "/user/email/visibility"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserEmailVisibilityPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserEmailVisibilityPatchBodyType,
    ) -> Response[List[Email]]: ...

    @overload
    async def async_set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        visibility: Literal["public", "private"],
    ) -> Response[List[Email]]: ...

    async def async_set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserEmailVisibilityPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[List[Email]]:
        """See also: https://docs.github.com/rest/users/emails#set-primary-email-visibility-for-the-authenticated-user"""

        from typing import List

        from ..models import (
            Email,
            BasicError,
            ValidationError,
            UserEmailVisibilityPatchBody,
        )

        url = "/user/email/visibility"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserEmailVisibilityPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def list_emails_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Email]]:
        """See also: https://docs.github.com/rest/users/emails#list-email-addresses-for-the-authenticated-user"""

        from typing import List

        from ..models import Email, BasicError

        url = "/user/emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_emails_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Email]]:
        """See also: https://docs.github.com/rest/users/emails#list-email-addresses-for-the-authenticated-user"""

        from typing import List

        from ..models import Email, BasicError

        url = "/user/emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[UserEmailsPostBodyOneof0Type, List[str], str]] = UNSET,
    ) -> Response[List[Email]]: ...

    @overload
    def add_email_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        emails: List[str],
    ) -> Response[List[Email]]: ...

    def add_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[UserEmailsPostBodyOneof0Type, List[str], str]] = UNSET,
        **kwargs,
    ) -> Response[List[Email]]:
        """See also: https://docs.github.com/rest/users/emails#add-an-email-address-for-the-authenticated-user"""

        from typing import List, Union

        from ..models import (
            Email,
            BasicError,
            ValidationError,
            UserEmailsPostBodyOneof0,
        )

        url = "/user/emails"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[UserEmailsPostBodyOneof0, List[str], str], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Email],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[UserEmailsPostBodyOneof0Type, List[str], str]] = UNSET,
    ) -> Response[List[Email]]: ...

    @overload
    async def async_add_email_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        emails: List[str],
    ) -> Response[List[Email]]: ...

    async def async_add_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[UserEmailsPostBodyOneof0Type, List[str], str]] = UNSET,
        **kwargs,
    ) -> Response[List[Email]]:
        """See also: https://docs.github.com/rest/users/emails#add-an-email-address-for-the-authenticated-user"""

        from typing import List, Union

        from ..models import (
            Email,
            BasicError,
            ValidationError,
            UserEmailsPostBodyOneof0,
        )

        url = "/user/emails"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[UserEmailsPostBodyOneof0, List[str], str], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[Email],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def delete_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[UserEmailsDeleteBodyOneof0Type, List[str], str]] = UNSET,
    ) -> Response: ...

    @overload
    def delete_email_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        emails: List[str],
    ) -> Response: ...

    def delete_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[UserEmailsDeleteBodyOneof0Type, List[str], str]] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/emails#delete-an-email-address-for-the-authenticated-user"""

        from typing import List, Union

        from ..models import BasicError, ValidationError, UserEmailsDeleteBodyOneof0

        url = "/user/emails"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[UserEmailsDeleteBodyOneof0, List[str], str], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_delete_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[UserEmailsDeleteBodyOneof0Type, List[str], str]] = UNSET,
    ) -> Response: ...

    @overload
    async def async_delete_email_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        emails: List[str],
    ) -> Response: ...

    async def async_delete_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[UserEmailsDeleteBodyOneof0Type, List[str], str]] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/emails#delete-an-email-address-for-the-authenticated-user"""

        from typing import List, Union

        from ..models import BasicError, ValidationError, UserEmailsDeleteBodyOneof0

        url = "/user/emails"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(
            Union[UserEmailsDeleteBodyOneof0, List[str], str], json
        )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def list_followers_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/followers#list-followers-of-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = "/user/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_followers_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/followers#list-followers-of-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = "/user/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_followed_by_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/followers#list-the-people-the-authenticated-user-follows"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = "/user/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_followed_by_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/followers#list-the-people-the-authenticated-user-follows"""

        from typing import List

        from ..models import BasicError, SimpleUser

        url = "/user/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def check_person_is_followed_by_authenticated(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/followers#check-if-a-person-is-followed-by-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_check_person_is_followed_by_authenticated(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/followers#check-if-a-person-is-followed-by-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def follow(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/followers#follow-a-user"""

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_follow(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/followers#follow-a-user"""

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def unfollow(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/followers#unfollow-a-user"""

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_unfollow(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/followers#unfollow-a-user"""

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_gpg_keys_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GpgKey]]:
        """See also: https://docs.github.com/rest/users/gpg-keys#list-gpg-keys-for-the-authenticated-user"""

        from typing import List

        from ..models import GpgKey, BasicError

        url = "/user/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GpgKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_gpg_keys_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GpgKey]]:
        """See also: https://docs.github.com/rest/users/gpg-keys#list-gpg-keys-for-the-authenticated-user"""

        from typing import List

        from ..models import GpgKey, BasicError

        url = "/user/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GpgKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_gpg_key_for_authenticated_user(
        self, *, headers: Optional[Dict[str, str]] = None, data: UserGpgKeysPostBodyType
    ) -> Response[GpgKey]: ...

    @overload
    def create_gpg_key_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        armored_public_key: str,
    ) -> Response[GpgKey]: ...

    def create_gpg_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserGpgKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GpgKey]:
        """See also: https://docs.github.com/rest/users/gpg-keys#create-a-gpg-key-for-the-authenticated-user"""

        from ..models import GpgKey, BasicError, ValidationError, UserGpgKeysPostBody

        url = "/user/gpg_keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserGpgKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GpgKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_gpg_key_for_authenticated_user(
        self, *, headers: Optional[Dict[str, str]] = None, data: UserGpgKeysPostBodyType
    ) -> Response[GpgKey]: ...

    @overload
    async def async_create_gpg_key_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        name: Missing[str] = UNSET,
        armored_public_key: str,
    ) -> Response[GpgKey]: ...

    async def async_create_gpg_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserGpgKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GpgKey]:
        """See also: https://docs.github.com/rest/users/gpg-keys#create-a-gpg-key-for-the-authenticated-user"""

        from ..models import GpgKey, BasicError, ValidationError, UserGpgKeysPostBody

        url = "/user/gpg_keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserGpgKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GpgKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GpgKey]:
        """See also: https://docs.github.com/rest/users/gpg-keys#get-a-gpg-key-for-the-authenticated-user"""

        from ..models import GpgKey, BasicError

        url = f"/user/gpg_keys/{gpg_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GpgKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GpgKey]:
        """See also: https://docs.github.com/rest/users/gpg-keys#get-a-gpg-key-for-the-authenticated-user"""

        from ..models import GpgKey, BasicError

        url = f"/user/gpg_keys/{gpg_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GpgKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/gpg-keys#delete-a-gpg-key-for-the-authenticated-user"""

        from ..models import BasicError, ValidationError

        url = f"/user/gpg_keys/{gpg_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/gpg-keys#delete-a-gpg-key-for-the-authenticated-user"""

        from ..models import BasicError, ValidationError

        url = f"/user/gpg_keys/{gpg_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_public_ssh_keys_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Key]]:
        """See also: https://docs.github.com/rest/users/keys#list-public-ssh-keys-for-the-authenticated-user"""

        from typing import List

        from ..models import Key, BasicError

        url = "/user/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Key],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_public_ssh_keys_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Key]]:
        """See also: https://docs.github.com/rest/users/keys#list-public-ssh-keys-for-the-authenticated-user"""

        from typing import List

        from ..models import Key, BasicError

        url = "/user/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Key],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_public_ssh_key_for_authenticated_user(
        self, *, headers: Optional[Dict[str, str]] = None, data: UserKeysPostBodyType
    ) -> Response[Key]: ...

    @overload
    def create_public_ssh_key_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
    ) -> Response[Key]: ...

    def create_public_ssh_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Key]:
        """See also: https://docs.github.com/rest/users/keys#create-a-public-ssh-key-for-the-authenticated-user"""

        from ..models import Key, BasicError, ValidationError, UserKeysPostBody

        url = "/user/keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Key,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_public_ssh_key_for_authenticated_user(
        self, *, headers: Optional[Dict[str, str]] = None, data: UserKeysPostBodyType
    ) -> Response[Key]: ...

    @overload
    async def async_create_public_ssh_key_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
    ) -> Response[Key]: ...

    async def async_create_public_ssh_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Key]:
        """See also: https://docs.github.com/rest/users/keys#create-a-public-ssh-key-for-the-authenticated-user"""

        from ..models import Key, BasicError, ValidationError, UserKeysPostBody

        url = "/user/keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Key,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Key]:
        """See also: https://docs.github.com/rest/users/keys#get-a-public-ssh-key-for-the-authenticated-user"""

        from ..models import Key, BasicError

        url = f"/user/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Key,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Key]:
        """See also: https://docs.github.com/rest/users/keys#get-a-public-ssh-key-for-the-authenticated-user"""

        from ..models import Key, BasicError

        url = f"/user/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Key,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/keys#delete-a-public-ssh-key-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/keys#delete-a-public-ssh-key-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_public_emails_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Email]]:
        """See also: https://docs.github.com/rest/users/emails#list-public-email-addresses-for-the-authenticated-user"""

        from typing import List

        from ..models import Email, BasicError

        url = "/user/public_emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_public_emails_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[Email]]:
        """See also: https://docs.github.com/rest/users/emails#list-public-email-addresses-for-the-authenticated-user"""

        from typing import List

        from ..models import Email, BasicError

        url = "/user/public_emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_social_accounts_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SocialAccount]]:
        """See also: https://docs.github.com/rest/users/social-accounts#list-social-accounts-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, SocialAccount

        url = "/user/social_accounts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SocialAccount],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_social_accounts_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SocialAccount]]:
        """See also: https://docs.github.com/rest/users/social-accounts#list-social-accounts-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, SocialAccount

        url = "/user/social_accounts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SocialAccount],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserSocialAccountsPostBodyType,
    ) -> Response[List[SocialAccount]]: ...

    @overload
    def add_social_account_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        account_urls: List[str],
    ) -> Response[List[SocialAccount]]: ...

    def add_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserSocialAccountsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[List[SocialAccount]]:
        """See also: https://docs.github.com/rest/users/social-accounts#add-social-accounts-for-the-authenticated-user"""

        from typing import List

        from ..models import (
            BasicError,
            SocialAccount,
            ValidationError,
            UserSocialAccountsPostBody,
        )

        url = "/user/social_accounts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserSocialAccountsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SocialAccount],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserSocialAccountsPostBodyType,
    ) -> Response[List[SocialAccount]]: ...

    @overload
    async def async_add_social_account_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        account_urls: List[str],
    ) -> Response[List[SocialAccount]]: ...

    async def async_add_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserSocialAccountsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[List[SocialAccount]]:
        """See also: https://docs.github.com/rest/users/social-accounts#add-social-accounts-for-the-authenticated-user"""

        from typing import List

        from ..models import (
            BasicError,
            SocialAccount,
            ValidationError,
            UserSocialAccountsPostBody,
        )

        url = "/user/social_accounts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserSocialAccountsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=List[SocialAccount],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def delete_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserSocialAccountsDeleteBodyType,
    ) -> Response: ...

    @overload
    def delete_social_account_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        account_urls: List[str],
    ) -> Response: ...

    def delete_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserSocialAccountsDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/social-accounts#delete-social-accounts-for-the-authenticated-user"""

        from ..models import BasicError, ValidationError, UserSocialAccountsDeleteBody

        url = "/user/social_accounts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserSocialAccountsDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_delete_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserSocialAccountsDeleteBodyType,
    ) -> Response: ...

    @overload
    async def async_delete_social_account_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        account_urls: List[str],
    ) -> Response: ...

    async def async_delete_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserSocialAccountsDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/social-accounts#delete-social-accounts-for-the-authenticated-user"""

        from ..models import BasicError, ValidationError, UserSocialAccountsDeleteBody

        url = "/user/social_accounts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserSocialAccountsDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_ssh_signing_keys_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SshSigningKey]]:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#list-ssh-signing-keys-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, SshSigningKey

        url = "/user/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SshSigningKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_ssh_signing_keys_for_authenticated_user(
        self,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SshSigningKey]]:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#list-ssh-signing-keys-for-the-authenticated-user"""

        from typing import List

        from ..models import BasicError, SshSigningKey

        url = "/user/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SshSigningKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserSshSigningKeysPostBodyType,
    ) -> Response[SshSigningKey]: ...

    @overload
    def create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
    ) -> Response[SshSigningKey]: ...

    def create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserSshSigningKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[SshSigningKey]:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#create-a-ssh-signing-key-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            SshSigningKey,
            ValidationError,
            UserSshSigningKeysPostBody,
        )

        url = "/user/ssh_signing_keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserSshSigningKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=SshSigningKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: UserSshSigningKeysPostBodyType,
    ) -> Response[SshSigningKey]: ...

    @overload
    async def async_create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        data: Literal[UNSET] = UNSET,
        headers: Optional[Dict[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
    ) -> Response[SshSigningKey]: ...

    async def async_create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[UserSshSigningKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[SshSigningKey]:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#create-a-ssh-signing-key-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            SshSigningKey,
            ValidationError,
            UserSshSigningKeysPostBody,
        )

        url = "/user/ssh_signing_keys"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(UserSshSigningKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=SshSigningKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[SshSigningKey]:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#get-an-ssh-signing-key-for-the-authenticated-user"""

        from ..models import BasicError, SshSigningKey

        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SshSigningKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[SshSigningKey]:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#get-an-ssh-signing-key-for-the-authenticated-user"""

        from ..models import BasicError, SshSigningKey

        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SshSigningKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#delete-an-ssh-signing-key-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#delete-an-ssh-signing-key-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_by_id(
        self,
        account_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[PrivateUser, PublicUser]]:
        """See also: https://docs.github.com/rest/users/users#get-a-user-using-their-id"""

        from typing import Union

        from ..models import BasicError, PublicUser, PrivateUser

        url = f"/user/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_id(
        self,
        account_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[PrivateUser, PublicUser]]:
        """See also: https://docs.github.com/rest/users/users#get-a-user-using-their-id"""

        from typing import Union

        from ..models import BasicError, PublicUser, PrivateUser

        url = f"/user/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    def list(
        self,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/users#list-users"""

        from typing import List

        from ..models import SimpleUser

        url = "/users"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list(
        self,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/users#list-users"""

        from typing import List

        from ..models import SimpleUser

        url = "/users"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def get_by_username(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[PrivateUser, PublicUser]]:
        """See also: https://docs.github.com/rest/users/users#get-a-user"""

        from typing import Union

        from ..models import BasicError, PublicUser, PrivateUser

        url = f"/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_username(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Union[PrivateUser, PublicUser]]:
        """See also: https://docs.github.com/rest/users/users#get-a-user"""

        from typing import Union

        from ..models import BasicError, PublicUser, PrivateUser

        url = f"/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    def list_attestations(
        self,
        username: str,
        subject_digest: str,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[UsersUsernameAttestationsSubjectDigestGetResponse200]:
        """See also: https://docs.github.com/rest/users/attestations#list-attestations"""

        from ..models import (
            BasicError,
            UsersUsernameAttestationsSubjectDigestGetResponse200,
        )

        url = f"/users/{username}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsersUsernameAttestationsSubjectDigestGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_attestations(
        self,
        username: str,
        subject_digest: str,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[UsersUsernameAttestationsSubjectDigestGetResponse200]:
        """See also: https://docs.github.com/rest/users/attestations#list-attestations"""

        from ..models import (
            BasicError,
            UsersUsernameAttestationsSubjectDigestGetResponse200,
        )

        url = f"/users/{username}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsersUsernameAttestationsSubjectDigestGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def list_followers_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/followers#list-followers-of-a-user"""

        from typing import List

        from ..models import SimpleUser

        url = f"/users/{username}/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_followers_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/followers#list-followers-of-a-user"""

        from typing import List

        from ..models import SimpleUser

        url = f"/users/{username}/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def list_following_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/followers#list-the-people-a-user-follows"""

        from typing import List

        from ..models import SimpleUser

        url = f"/users/{username}/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    async def async_list_following_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SimpleUser]]:
        """See also: https://docs.github.com/rest/users/followers#list-the-people-a-user-follows"""

        from typing import List

        from ..models import SimpleUser

        url = f"/users/{username}/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SimpleUser],
        )

    def check_following_for_user(
        self,
        username: str,
        target_user: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/followers#check-if-a-user-follows-another-user"""

        url = f"/users/{username}/following/{target_user}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_following_for_user(
        self,
        username: str,
        target_user: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/users/followers#check-if-a-user-follows-another-user"""

        url = f"/users/{username}/following/{target_user}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_gpg_keys_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GpgKey]]:
        """See also: https://docs.github.com/rest/users/gpg-keys#list-gpg-keys-for-a-user"""

        from typing import List

        from ..models import GpgKey

        url = f"/users/{username}/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GpgKey],
        )

    async def async_list_gpg_keys_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GpgKey]]:
        """See also: https://docs.github.com/rest/users/gpg-keys#list-gpg-keys-for-a-user"""

        from typing import List

        from ..models import GpgKey

        url = f"/users/{username}/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GpgKey],
        )

    def get_context_for_user(
        self,
        username: str,
        subject_type: Missing[
            Literal["organization", "repository", "issue", "pull_request"]
        ] = UNSET,
        subject_id: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Hovercard]:
        """See also: https://docs.github.com/rest/users/users#get-contextual-information-for-a-user"""

        from ..models import Hovercard, BasicError, ValidationError

        url = f"/users/{username}/hovercard"

        params = {
            "subject_type": subject_type,
            "subject_id": subject_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Hovercard,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_context_for_user(
        self,
        username: str,
        subject_type: Missing[
            Literal["organization", "repository", "issue", "pull_request"]
        ] = UNSET,
        subject_id: Missing[str] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[Hovercard]:
        """See also: https://docs.github.com/rest/users/users#get-contextual-information-for-a-user"""

        from ..models import Hovercard, BasicError, ValidationError

        url = f"/users/{username}/hovercard"

        params = {
            "subject_type": subject_type,
            "subject_id": subject_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Hovercard,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_public_keys_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[KeySimple]]:
        """See also: https://docs.github.com/rest/users/keys#list-public-keys-for-a-user"""

        from typing import List

        from ..models import KeySimple

        url = f"/users/{username}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[KeySimple],
        )

    async def async_list_public_keys_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[KeySimple]]:
        """See also: https://docs.github.com/rest/users/keys#list-public-keys-for-a-user"""

        from typing import List

        from ..models import KeySimple

        url = f"/users/{username}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[KeySimple],
        )

    def list_social_accounts_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SocialAccount]]:
        """See also: https://docs.github.com/rest/users/social-accounts#list-social-accounts-for-a-user"""

        from typing import List

        from ..models import SocialAccount

        url = f"/users/{username}/social_accounts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SocialAccount],
        )

    async def async_list_social_accounts_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SocialAccount]]:
        """See also: https://docs.github.com/rest/users/social-accounts#list-social-accounts-for-a-user"""

        from typing import List

        from ..models import SocialAccount

        url = f"/users/{username}/social_accounts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SocialAccount],
        )

    def list_ssh_signing_keys_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SshSigningKey]]:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#list-ssh-signing-keys-for-a-user"""

        from typing import List

        from ..models import SshSigningKey

        url = f"/users/{username}/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SshSigningKey],
        )

    async def async_list_ssh_signing_keys_for_user(
        self,
        username: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[SshSigningKey]]:
        """See also: https://docs.github.com/rest/users/ssh-signing-keys#list-ssh-signing-keys-for-a-user"""

        from typing import List

        from ..models import SshSigningKey

        url = f"/users/{username}/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[SshSigningKey],
        )
