"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing import TYPE_CHECKING, Dict, Literal, Optional, overload

from pydantic import BaseModel

from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset
from githubkit.compat import model_dump, type_validate_python

if TYPE_CHECKING:
    from datetime import datetime
    from typing import List, Union, Literal

    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import BaseGist, GistCommit, GistSimple, GistComment
    from ..types import (
        GistsPostBodyType,
        GistsGistIdPatchBodyType,
        GistsPostBodyPropFilesType,
        GistsGistIdCommentsPostBodyType,
        GistsGistIdPatchBodyPropFilesType,
        GistsGistIdCommentsCommentIdPatchBodyType,
    )


class GistsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BaseGist]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-gists-for-the-authenticated-user"""

        from typing import List

        from ..models import BaseGist, BasicError

        url = "/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[BaseGist],
            error_models={
                "403": BasicError,
            },
        )

    async def async_list(
        self,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BaseGist]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-gists-for-the-authenticated-user"""

        from typing import List

        from ..models import BaseGist, BasicError

        url = "/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[BaseGist],
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def create(
        self, *, headers: Optional[Dict[str, str]] = None, data: GistsPostBodyType
    ) -> Response[GistSimple]: ...

    @overload
    def create(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        description: Missing[str] = UNSET,
        files: GistsPostBodyPropFilesType,
        public: Missing[Union[bool, Literal["true", "false"]]] = UNSET,
    ) -> Response[GistSimple]: ...

    def create(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[GistsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistSimple]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#create-a-gist"""

        from ..models import BasicError, GistSimple, GistsPostBody, ValidationError

        url = "/gists"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(GistsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create(
        self, *, headers: Optional[Dict[str, str]] = None, data: GistsPostBodyType
    ) -> Response[GistSimple]: ...

    @overload
    async def async_create(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        description: Missing[str] = UNSET,
        files: GistsPostBodyPropFilesType,
        public: Missing[Union[bool, Literal["true", "false"]]] = UNSET,
    ) -> Response[GistSimple]: ...

    async def async_create(
        self,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[GistsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistSimple]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#create-a-gist"""

        from ..models import BasicError, GistSimple, GistsPostBody, ValidationError

        url = "/gists"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(GistsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_public(
        self,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BaseGist]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-public-gists"""

        from typing import List

        from ..models import BaseGist, BasicError, ValidationError

        url = "/gists/public"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[BaseGist],
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_list_public(
        self,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BaseGist]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-public-gists"""

        from typing import List

        from ..models import BaseGist, BasicError, ValidationError

        url = "/gists/public"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[BaseGist],
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_starred(
        self,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BaseGist]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-starred-gists"""

        from typing import List

        from ..models import BaseGist, BasicError

        url = "/gists/starred"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[BaseGist],
            error_models={
                "401": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_starred(
        self,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BaseGist]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-starred-gists"""

        from typing import List

        from ..models import BaseGist, BasicError

        url = "/gists/starred"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[BaseGist],
            error_models={
                "401": BasicError,
                "403": BasicError,
            },
        )

    def get(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GistSimple]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#get-a-gist"""

        from ..models import BasicError, GistSimple, GistsGistIdGetResponse403

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GistSimple,
            error_models={
                "403": GistsGistIdGetResponse403,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GistSimple]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#get-a-gist"""

        from ..models import BasicError, GistSimple, GistsGistIdGetResponse403

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GistSimple,
            error_models={
                "403": GistsGistIdGetResponse403,
                "404": BasicError,
            },
        )

    def delete(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#delete-a-gist"""

        from ..models import BasicError

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#delete-a-gist"""

        from ..models import BasicError

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[GistsGistIdPatchBodyType, None],
    ) -> Response[GistSimple]: ...

    @overload
    def update(
        self,
        gist_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        description: Missing[str] = UNSET,
        files: Missing[GistsGistIdPatchBodyPropFilesType] = UNSET,
    ) -> Response[GistSimple]: ...

    def update(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[GistsGistIdPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[GistSimple]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#update-a-gist"""

        from typing import Union

        from ..models import (
            BasicError,
            GistSimple,
            ValidationError,
            GistsGistIdPatchBody,
        )

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(Union[GistsGistIdPatchBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Union[GistsGistIdPatchBodyType, None],
    ) -> Response[GistSimple]: ...

    @overload
    async def async_update(
        self,
        gist_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        description: Missing[str] = UNSET,
        files: Missing[GistsGistIdPatchBodyPropFilesType] = UNSET,
    ) -> Response[GistSimple]: ...

    async def async_update(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[Union[GistsGistIdPatchBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[GistSimple]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#update-a-gist"""

        from typing import Union

        from ..models import (
            BasicError,
            GistSimple,
            ValidationError,
            GistsGistIdPatchBody,
        )

        url = f"/gists/{gist_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(Union[GistsGistIdPatchBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_comments(
        self,
        gist_id: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GistComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#list-gist-comments"""

        from typing import List

        from ..models import BasicError, GistComment

        url = f"/gists/{gist_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GistComment],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_comments(
        self,
        gist_id: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GistComment]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#list-gist-comments"""

        from typing import List

        from ..models import BasicError, GistComment

        url = f"/gists/{gist_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GistComment],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def create_comment(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: GistsGistIdCommentsPostBodyType,
    ) -> Response[GistComment]: ...

    @overload
    def create_comment(
        self,
        gist_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[GistComment]: ...

    def create_comment(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[GistsGistIdCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#create-a-gist-comment"""

        from ..models import BasicError, GistComment, GistsGistIdCommentsPostBody

        url = f"/gists/{gist_id}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(GistsGistIdCommentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_comment(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: GistsGistIdCommentsPostBodyType,
    ) -> Response[GistComment]: ...

    @overload
    async def async_create_comment(
        self,
        gist_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[GistComment]: ...

    async def async_create_comment(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[GistsGistIdCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#create-a-gist-comment"""

        from ..models import BasicError, GistComment, GistsGistIdCommentsPostBody

        url = f"/gists/{gist_id}/comments"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(GistsGistIdCommentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def get_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GistComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#get-a-gist-comment"""

        from ..models import BasicError, GistComment, GistsGistIdGetResponse403

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": GistsGistIdGetResponse403,
            },
        )

    async def async_get_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GistComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#get-a-gist-comment"""

        from ..models import BasicError, GistComment, GistsGistIdGetResponse403

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GistComment,
            error_models={
                "404": BasicError,
                "403": GistsGistIdGetResponse403,
            },
        )

    def delete_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#delete-a-gist-comment"""

        from ..models import BasicError

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#delete-a-gist-comment"""

        from ..models import BasicError

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: GistsGistIdCommentsCommentIdPatchBodyType,
    ) -> Response[GistComment]: ...

    @overload
    def update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[GistComment]: ...

    def update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[GistsGistIdCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#update-a-gist-comment"""

        from ..models import (
            BasicError,
            GistComment,
            GistsGistIdCommentsCommentIdPatchBody,
        )

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(GistsGistIdCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GistComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: GistsGistIdCommentsCommentIdPatchBodyType,
    ) -> Response[GistComment]: ...

    @overload
    async def async_update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Dict[str, str]] = None,
        body: str,
    ) -> Response[GistComment]: ...

    async def async_update_comment(
        self,
        gist_id: str,
        comment_id: int,
        *,
        headers: Optional[Dict[str, str]] = None,
        data: Missing[GistsGistIdCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GistComment]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/comments#update-a-gist-comment"""

        from ..models import (
            BasicError,
            GistComment,
            GistsGistIdCommentsCommentIdPatchBody,
        )

        url = f"/gists/{gist_id}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        if not kwargs:
            kwargs = UNSET

        json = kwargs if data is UNSET else data
        json = type_validate_python(GistsGistIdCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GistComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        gist_id: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GistCommit]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-gist-commits"""

        from typing import List

        from ..models import BasicError, GistCommit

        url = f"/gists/{gist_id}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GistCommit],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_commits(
        self,
        gist_id: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GistCommit]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-gist-commits"""

        from typing import List

        from ..models import BasicError, GistCommit

        url = f"/gists/{gist_id}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GistCommit],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_forks(
        self,
        gist_id: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GistSimple]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-gist-forks"""

        from typing import List

        from ..models import BasicError, GistSimple

        url = f"/gists/{gist_id}/forks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GistSimple],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_forks(
        self,
        gist_id: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[GistSimple]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-gist-forks"""

        from typing import List

        from ..models import BasicError, GistSimple

        url = f"/gists/{gist_id}/forks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[GistSimple],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def fork(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[BaseGist]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#fork-a-gist"""

        from ..models import BaseGist, BasicError, ValidationError

        url = f"/gists/{gist_id}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=BaseGist,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_fork(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[BaseGist]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#fork-a-gist"""

        from ..models import BaseGist, BasicError, ValidationError

        url = f"/gists/{gist_id}/forks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=BaseGist,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def check_is_starred(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#check-if-a-gist-is-starred"""

        from ..models import BasicError, GistsGistIdStarGetResponse404

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": GistsGistIdStarGetResponse404,
                "403": BasicError,
            },
        )

    async def async_check_is_starred(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#check-if-a-gist-is-starred"""

        from ..models import BasicError, GistsGistIdStarGetResponse404

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": GistsGistIdStarGetResponse404,
                "403": BasicError,
            },
        )

    def star(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#star-a-gist"""

        from ..models import BasicError

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_star(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#star-a-gist"""

        from ..models import BasicError

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def unstar(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#unstar-a-gist"""

        from ..models import BasicError

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_unstar(
        self,
        gist_id: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#unstar-a-gist"""

        from ..models import BasicError

        url = f"/gists/{gist_id}/star"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def get_revision(
        self,
        gist_id: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GistSimple]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#get-a-gist-revision"""

        from ..models import BasicError, GistSimple, ValidationError

        url = f"/gists/{gist_id}/{sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_revision(
        self,
        gist_id: str,
        sha: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[GistSimple]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#get-a-gist-revision"""

        from ..models import BasicError, GistSimple, ValidationError

        url = f"/gists/{gist_id}/{sha}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GistSimple,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BaseGist]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-gists-for-a-user"""

        from typing import List

        from ..models import BaseGist, ValidationError

        url = f"/users/{username}/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[BaseGist],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_for_user(
        self,
        username: str,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[List[BaseGist]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/gists/gists#list-gists-for-a-user"""

        from typing import List

        from ..models import BaseGist, ValidationError

        url = f"/users/{username}/gists"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=List[BaseGist],
            error_models={
                "422": ValidationError,
            },
        )
