"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        Commit,
        DiffEntry,
        PullRequest,
        PullRequestMergeResult,
        PullRequestReview,
        PullRequestReviewComment,
        PullRequestReviewRequest,
        PullRequestSimple,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReviewComment,
    )
    from ..types import (
        CommitType,
        DiffEntryType,
        PullRequestMergeResultType,
        PullRequestReviewCommentType,
        PullRequestReviewRequestType,
        PullRequestReviewType,
        PullRequestSimpleType,
        PullRequestType,
        ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
        ReposOwnerRepoPullsPostBodyType,
        ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
        ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
        ReposOwnerRepoPullsPullNumberMergePutBodyType,
        ReposOwnerRepoPullsPullNumberPatchBodyType,
        ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
        ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
        ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
        ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType,
        ReposOwnerRepoPullsPullNumberReviewsPostBodyType,
        ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
        ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
        ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
        ReviewCommentType,
    )


class PullsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        head: Missing[str] = UNSET,
        base: Missing[str] = UNSET,
        sort: Missing[
            Literal["created", "updated", "popularity", "long-running"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PullRequestSimple], list[PullRequestSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#list-pull-requests"""

        from ..models import PullRequestSimple, ValidationError

        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        head: Missing[str] = UNSET,
        base: Missing[str] = UNSET,
        sort: Missing[
            Literal["created", "updated", "popularity", "long-running"]
        ] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PullRequestSimple], list[PullRequestSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#list-pull-requests"""

        from ..models import PullRequestSimple, ValidationError

        url = f"/repos/{owner}/{repo}/pulls"

        params = {
            "state": state,
            "head": head,
            "base": base,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestSimple],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPostBodyType,
    ) -> Response[PullRequest, PullRequestType]: ...

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        head: str,
        head_repo: Missing[str] = UNSET,
        base: str,
        body: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
        draft: Missing[bool] = UNSET,
        issue: Missing[int] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest, PullRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#create-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            ReposOwnerRepoPullsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPullsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPostBodyType,
    ) -> Response[PullRequest, PullRequestType]: ...

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        head: str,
        head_repo: Missing[str] = UNSET,
        base: str,
        body: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
        draft: Missing[bool] = UNSET,
        issue: Missing[int] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest, PullRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#create-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            ReposOwnerRepoPullsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPullsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["created", "updated", "created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PullRequestReviewComment], list[PullRequestReviewCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#list-review-comments-in-a-repository"""

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestReviewComment],
        )

    async def async_list_review_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["created", "updated", "created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PullRequestReviewComment], list[PullRequestReviewCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#list-review-comments-in-a-repository"""

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestReviewComment],
        )

    def get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#get-a-review-comment-for-a-pull-request"""

        from ..models import BasicError, PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#get-a-review-comment-for-a-pull-request"""

        from ..models import BasicError, PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#delete-a-review-comment-for-a-pull-request"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#delete-a-review-comment-for-a-pull-request"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    def update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#update-a-review-comment-for-a-pull-request"""

        from ..models import (
            PullRequestReviewComment,
            ReposOwnerRepoPullsCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsCommentsCommentIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
        )

    @overload
    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsCommentsCommentIdPatchBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    async def async_update_review_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#update-a-review-comment-for-a-pull-request"""

        from ..models import (
            PullRequestReviewComment,
            ReposOwnerRepoPullsCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsCommentsCommentIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
        )

    def get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequest, PullRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#get-a-pull-request"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            PullRequest,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "404": BasicError,
                "406": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequest, PullRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#get-a-pull-request"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            PullRequest,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "404": BasicError,
                "406": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        base: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    def update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest, PullRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#update-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            ReposOwnerRepoPullsPullNumberPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPullsPullNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        base: Missing[str] = UNSET,
        maintainer_can_modify: Missing[bool] = UNSET,
    ) -> Response[PullRequest, PullRequestType]: ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequest, PullRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#update-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequest,
            ReposOwnerRepoPullsPullNumberPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPullsPullNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequest,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PullRequestReviewComment], list[PullRequestReviewCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#list-review-comments-on-a-pull-request"""

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestReviewComment],
        )

    async def async_list_review_comments(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PullRequestReviewComment], list[PullRequestReviewCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#list-review-comments-on-a-pull-request"""

        from ..models import PullRequestReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestReviewComment],
        )

    @overload
    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
        commit_id: str,
        path: str,
        position: Missing[int] = UNSET,
        side: Missing[Literal["LEFT", "RIGHT"]] = UNSET,
        line: Missing[int] = UNSET,
        start_line: Missing[int] = UNSET,
        start_side: Missing[Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Missing[int] = UNSET,
        subject_type: Missing[Literal["line", "file"]] = UNSET,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    def create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#create-a-review-comment-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsPostBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
        commit_id: str,
        path: str,
        position: Missing[int] = UNSET,
        side: Missing[Literal["LEFT", "RIGHT"]] = UNSET,
        line: Missing[int] = UNSET,
        start_line: Missing[int] = UNSET,
        start_side: Missing[Literal["LEFT", "RIGHT", "side"]] = UNSET,
        in_reply_to: Missing[int] = UNSET,
        subject_type: Missing[Literal["line", "file"]] = UNSET,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    async def async_create_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#create-a-review-comment-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    def create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#create-a-reply-for-a-review-comment"""

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    @overload
    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]: ...

    async def async_create_reply_for_review_comment(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReviewComment, PullRequestReviewCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/comments#create-a-reply-for-a-review-comment"""

        from ..models import (
            BasicError,
            PullRequestReviewComment,
            ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberCommentsCommentIdRepliesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReviewComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Commit], list[CommitType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#list-commits-on-a-pull-request"""

        from ..models import Commit

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Commit],
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Commit], list[CommitType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#list-commits-on-a-pull-request"""

        from ..models import Commit

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/commits"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Commit],
        )

    def list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[DiffEntry], list[DiffEntryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#list-pull-requests-files"""

        from ..models import (
            BasicError,
            DiffEntry,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_files(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[DiffEntry], list[DiffEntryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#list-pull-requests-files"""

        from ..models import (
            BasicError,
            DiffEntry,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/files"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DiffEntry],
            error_models={
                "422": ValidationError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#check-if-a-pull-request-has-been-merged"""

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_if_merged(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#check-if-a-pull-request-has-been-merged"""

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]: ...

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        commit_title: Missing[str] = UNSET,
        commit_message: Missing[str] = UNSET,
        sha: Missing[str] = UNSET,
        merge_method: Missing[Literal["merge", "squash", "rebase"]] = UNSET,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]: ...

    def merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#merge-a-pull-request"""

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestMergeResult,
            ReposOwnerRepoPullsPullNumberMergePutBody,
            ReposOwnerRepoPullsPullNumberMergePutResponse405,
            ReposOwnerRepoPullsPullNumberMergePutResponse409,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberMergePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]: ...

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        commit_title: Missing[str] = UNSET,
        commit_message: Missing[str] = UNSET,
        sha: Missing[str] = UNSET,
        merge_method: Missing[Literal["merge", "squash", "rebase"]] = UNSET,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]: ...

    async def async_merge(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberMergePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestMergeResult, PullRequestMergeResultType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#merge-a-pull-request"""

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestMergeResult,
            ReposOwnerRepoPullsPullNumberMergePutBody,
            ReposOwnerRepoPullsPullNumberMergePutResponse405,
            ReposOwnerRepoPullsPullNumberMergePutResponse409,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/merge"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberMergePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestMergeResult,
            error_models={
                "405": ReposOwnerRepoPullsPullNumberMergePutResponse405,
                "409": ReposOwnerRepoPullsPullNumberMergePutResponse409,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequestReviewRequest, PullRequestReviewRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/review-requests#get-all-requested-reviewers-for-a-pull-request"""

        from ..models import PullRequestReviewRequest

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewRequest,
        )

    async def async_list_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequestReviewRequest, PullRequestReviewRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/review-requests#get-all-requested-reviewers-for-a-pull-request"""

        from ..models import PullRequestReviewRequest

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReviewRequest,
        )

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        reviewers: list[str],
        team_reviewers: Missing[list[str]] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        reviewers: Missing[list[str]] = UNSET,
        team_reviewers: list[str],
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    def request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/review-requests#request-reviewers-for-a-pull-request"""

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
                    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        reviewers: list[str],
        team_reviewers: Missing[list[str]] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        reviewers: Missing[list[str]] = UNSET,
        team_reviewers: list[str],
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    async def async_request_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0Type,
                ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/review-requests#request-reviewers-for-a-pull-request"""

        from typing import Union

        from ..models import (
            BasicError,
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
            ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof0,
                    ReposOwnerRepoPullsPullNumberRequestedReviewersPostBodyAnyof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        reviewers: list[str],
        team_reviewers: Missing[list[str]] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    def remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/review-requests#remove-requested-reviewers-from-a-pull-request"""

        from ..models import (
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    @overload
    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        reviewers: list[str],
        team_reviewers: Missing[list[str]] = UNSET,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]: ...

    async def async_remove_requested_reviewers(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestSimple, PullRequestSimpleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/review-requests#remove-requested-reviewers-from-a-pull-request"""

        from ..models import (
            PullRequestSimple,
            ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberRequestedReviewersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestSimple,
            error_models={
                "422": ValidationError,
            },
        )

    def list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PullRequestReview], list[PullRequestReviewType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#list-reviews-for-a-pull-request"""

        from ..models import PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestReview],
        )

    async def async_list_reviews(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PullRequestReview], list[PullRequestReviewType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#list-reviews-for-a-pull-request"""

        from ..models import PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestReview],
        )

    @overload
    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        commit_id: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        event: Missing[Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Missing[
            list[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType]
        ] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    def create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#create-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        commit_id: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        event: Missing[Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"]] = UNSET,
        comments: Missing[
            list[ReposOwnerRepoPullsPullNumberReviewsPostBodyPropCommentsItemsType]
        ] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    async def async_create_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#create-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    def get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#get-a-review-for-a-pull-request"""

        from ..models import BasicError, PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#get-a-review-for-a-pull-request"""

        from ..models import BasicError, PullRequestReview

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    def update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#update-a-review-for-a-pull-request"""

        from ..models import (
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    async def async_update_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#update-a-review-for-a-pull-request"""

        from ..models import (
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    def delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#delete-a-pending-review-for-a-pull-request"""

        from ..models import BasicError, PullRequestReview, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    async def async_delete_pending_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#delete-a-pending-review-for-a-pull-request"""

        from ..models import BasicError, PullRequestReview, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ReviewComment], list[ReviewCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#list-comments-for-a-pull-request-review"""

        from ..models import BasicError, ReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_comments_for_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ReviewComment], list[ReviewCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#list-comments-for-a-pull-request-review"""

        from ..models import BasicError, ReviewComment

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ReviewComment],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        message: str,
        event: Missing[Literal["DISMISS"]] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    def dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#dismiss-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody,
            ValidationErrorSimple,
        )

        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        message: str,
        event: Missing[Literal["DISMISS"]] = UNSET,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    async def async_dismiss_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#dismiss-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody,
            ValidationErrorSimple,
        )

        url = (
            f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdDismissalsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: Missing[str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    def submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#submit-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType,
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    @overload
    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: Missing[str] = UNSET,
        event: Literal["APPROVE", "REQUEST_CHANGES", "COMMENT"],
    ) -> Response[PullRequestReview, PullRequestReviewType]: ...

    async def async_submit_review(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        review_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[PullRequestReview, PullRequestReviewType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/reviews#submit-a-review-for-a-pull-request"""

        from ..models import (
            BasicError,
            PullRequestReview,
            ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoPullsPullNumberReviewsReviewIdEventsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PullRequestReview,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
                "403": BasicError,
            },
        )

    @overload
    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]: ...

    @overload
    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        expected_head_sha: Missing[str] = UNSET,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]: ...

    def update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#update-a-pull-request-branch"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutBody,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]: ...

    @overload
    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        expected_head_sha: Missing[str] = UNSET,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]: ...

    async def async_update_branch(
        self,
        owner: str,
        repo: str,
        pull_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
        ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pulls/pulls#update-a-pull-request-branch"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutBody,
            ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pulls/{pull_number}/update-branch"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoPullsPullNumberUpdateBranchPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPullsPullNumberUpdateBranchPutResponse202,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )
