"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from datetime import datetime
from typing import Literal, Union

from pydantic import Field

from githubkit.compat import GitHubModel, model_rebuild
from githubkit.typing import Missing
from githubkit.utils import UNSET

from .group_0002 import SimpleUser
from .group_0388 import EnterpriseWebhooks
from .group_0389 import SimpleInstallation
from .group_0390 import OrganizationSimpleWebhooks
from .group_0391 import RepositoryWebhooks
from .group_0430 import WebhooksReview


class WebhookPullRequestReviewEdited(GitHubModel):
    """pull_request_review edited event"""

    action: Literal["edited"] = Field()
    changes: WebhookPullRequestReviewEditedPropChanges = Field()
    enterprise: Missing[EnterpriseWebhooks] = Field(
        default=UNSET,
        title="Enterprise",
        description='An enterprise on GitHub. Webhook payloads contain the `enterprise` property when the webhook is configured\non an enterprise account or an organization that\'s part of an enterprise account. For more information,\nsee "[About enterprise accounts](https://docs.github.com/admin/overview/about-enterprise-accounts)."',
    )
    installation: Missing[SimpleInstallation] = Field(
        default=UNSET,
        title="Simple Installation",
        description='The GitHub App installation. Webhook payloads contain the `installation` property when the event is configured\nfor and sent to a GitHub App. For more information,\nsee "[Using webhooks with GitHub Apps](https://docs.github.com/apps/creating-github-apps/registering-a-github-app/using-webhooks-with-github-apps)."',
    )
    organization: Missing[OrganizationSimpleWebhooks] = Field(
        default=UNSET,
        title="Organization Simple",
        description="A GitHub organization. Webhook payloads contain the `organization` property when the webhook is configured for an\norganization, or when the event occurs from activity in a repository owned by an organization.",
    )
    pull_request: WebhookPullRequestReviewEditedPropPullRequest = Field(
        title="Simple Pull Request"
    )
    repository: RepositoryWebhooks = Field(
        title="Repository",
        description="The repository on GitHub where the event occurred. Webhook payloads contain the `repository` property\nwhen the event occurs from activity in a repository.",
    )
    review: WebhooksReview = Field(description="The review that was affected.")
    sender: SimpleUser = Field(title="Simple User", description="A GitHub user.")


class WebhookPullRequestReviewEditedPropChanges(GitHubModel):
    """WebhookPullRequestReviewEditedPropChanges"""

    body: Missing[WebhookPullRequestReviewEditedPropChangesPropBody] = Field(
        default=UNSET
    )


class WebhookPullRequestReviewEditedPropChangesPropBody(GitHubModel):
    """WebhookPullRequestReviewEditedPropChangesPropBody"""

    from_: str = Field(
        alias="from",
        description="The previous version of the body if the action was `edited`.",
    )


class WebhookPullRequestReviewEditedPropPullRequest(GitHubModel):
    """Simple Pull Request"""

    links: WebhookPullRequestReviewEditedPropPullRequestPropLinks = Field(
        alias="_links"
    )
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field()
    assignee: Union[WebhookPullRequestReviewEditedPropPullRequestPropAssignee, None] = (
        Field(title="User")
    )
    assignees: list[
        Union[WebhookPullRequestReviewEditedPropPullRequestPropAssigneesItems, None]
    ] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    auto_merge: Union[
        WebhookPullRequestReviewEditedPropPullRequestPropAutoMerge, None
    ] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
    )
    base: WebhookPullRequestReviewEditedPropPullRequestPropBase = Field()
    body: Union[str, None] = Field()
    closed_at: Union[str, None] = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    created_at: str = Field()
    diff_url: str = Field()
    draft: bool = Field()
    head: WebhookPullRequestReviewEditedPropPullRequestPropHead = Field()
    html_url: str = Field()
    id: int = Field()
    issue_url: str = Field()
    labels: list[WebhookPullRequestReviewEditedPropPullRequestPropLabelsItems] = Field()
    locked: bool = Field()
    merge_commit_sha: Union[str, None] = Field()
    merged_at: Union[str, None] = Field()
    milestone: Union[
        WebhookPullRequestReviewEditedPropPullRequestPropMilestone, None
    ] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    node_id: str = Field()
    number: int = Field()
    patch_url: str = Field()
    requested_reviewers: list[
        Union[
            WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof0,
            None,
            WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof1,
        ]
    ] = Field()
    requested_teams: list[
        WebhookPullRequestReviewEditedPropPullRequestPropRequestedTeamsItems
    ] = Field()
    review_comment_url: str = Field()
    review_comments_url: str = Field()
    state: Literal["open", "closed"] = Field()
    statuses_url: str = Field()
    title: str = Field()
    updated_at: str = Field()
    url: str = Field()
    user: Union[WebhookPullRequestReviewEditedPropPullRequestPropUser, None] = Field(
        title="User"
    )


class WebhookPullRequestReviewEditedPropPullRequestPropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropAssigneesItems(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropAutoMerge(GitHubModel):
    """PullRequestAutoMerge

    The status of auto merging a pull request.
    """

    commit_message: Union[str, None] = Field(
        description="Commit message for the merge commit."
    )
    commit_title: Union[str, None] = Field(
        description="Title for the merge commit message."
    )
    enabled_by: Union[
        WebhookPullRequestReviewEditedPropPullRequestPropAutoMergePropEnabledBy, None
    ] = Field(title="User")
    merge_method: Literal["merge", "squash", "rebase"] = Field(
        description="The merge method to use."
    )


class WebhookPullRequestReviewEditedPropPullRequestPropAutoMergePropEnabledBy(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhookPullRequestReviewEditedPropPullRequestPropMilestone(GitHubModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[
        WebhookPullRequestReviewEditedPropPullRequestPropMilestonePropCreator, None
    ] = Field(title="User")
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropMilestonePropCreator(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof0(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropLinks(GitHubModel):
    """WebhookPullRequestReviewEditedPropPullRequestPropLinks"""

    comments: WebhookPullRequestReviewEditedPropPullRequestPropLinksPropComments = (
        Field(title="Link")
    )
    commits: WebhookPullRequestReviewEditedPropPullRequestPropLinksPropCommits = Field(
        title="Link"
    )
    html: WebhookPullRequestReviewEditedPropPullRequestPropLinksPropHtml = Field(
        title="Link"
    )
    issue: WebhookPullRequestReviewEditedPropPullRequestPropLinksPropIssue = Field(
        title="Link"
    )
    review_comment: WebhookPullRequestReviewEditedPropPullRequestPropLinksPropReviewComment = Field(
        title="Link"
    )
    review_comments: WebhookPullRequestReviewEditedPropPullRequestPropLinksPropReviewComments = Field(
        title="Link"
    )
    self_: WebhookPullRequestReviewEditedPropPullRequestPropLinksPropSelf = Field(
        alias="self", title="Link"
    )
    statuses: WebhookPullRequestReviewEditedPropPullRequestPropLinksPropStatuses = (
        Field(title="Link")
    )


class WebhookPullRequestReviewEditedPropPullRequestPropLinksPropComments(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropLinksPropCommits(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropLinksPropHtml(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropLinksPropIssue(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropLinksPropReviewComment(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropLinksPropReviewComments(
    GitHubModel
):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropLinksPropSelf(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropLinksPropStatuses(GitHubModel):
    """Link"""

    href: str = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropBase(GitHubModel):
    """WebhookPullRequestReviewEditedPropPullRequestPropBase"""

    label: str = Field()
    ref: str = Field()
    repo: WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepo = Field(
        title="Repository", description="A git repository"
    )
    sha: str = Field()
    user: Union[WebhookPullRequestReviewEditedPropPullRequestPropBasePropUser, None] = (
        Field(title="User")
    )


class WebhookPullRequestReviewEditedPropPullRequestPropBasePropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepo(GitHubModel):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[
        WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropLicense, None
    ] = Field(alias="license", title="License")
    master_branch: Missing[str] = Field(default=UNSET)
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[
        WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: list[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropLicense(
    GitHubModel
):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropPermissions(
    GitHubModel
):
    """WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropHead(GitHubModel):
    """WebhookPullRequestReviewEditedPropPullRequestPropHead"""

    label: str = Field()
    ref: str = Field()
    repo: Union[WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepo, None] = (
        Field(title="Repository", description="A git repository")
    )
    sha: str = Field()
    user: Union[WebhookPullRequestReviewEditedPropPullRequestPropHeadPropUser, None] = (
        Field(title="User")
    )


class WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepo(GitHubModel):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[
        WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropLicense, None
    ] = Field(alias="license", title="License")
    master_branch: Missing[str] = Field(default=UNSET)
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[
        WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropOwner, None
    ] = Field(title="User")
    permissions: Missing[
        WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropPermissions
    ] = Field(default=UNSET)
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: list[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropLicense(
    GitHubModel
):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropOwner(
    GitHubModel
):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropPermissions(
    GitHubModel
):
    """WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropHeadPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)
    user_view_type: Missing[str] = Field(default=UNSET)


class WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof1(
    GitHubModel
):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    parent: Missing[
        Union[
            WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof1PropParent,
            None,
        ]
    ] = Field(default=UNSET)
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


class WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof1PropParent(
    GitHubModel
):
    """WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof1Pr
    opParent
    """

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


class WebhookPullRequestReviewEditedPropPullRequestPropRequestedTeamsItems(GitHubModel):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="Description of the team"
    )
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(description="Unique identifier of the team")
    members_url: Missing[str] = Field(default=UNSET)
    name: str = Field(description="Name of the team")
    node_id: Missing[str] = Field(default=UNSET)
    parent: Missing[
        Union[
            WebhookPullRequestReviewEditedPropPullRequestPropRequestedTeamsItemsPropParent,
            None,
        ]
    ] = Field(default=UNSET)
    permission: Missing[str] = Field(
        default=UNSET,
        description="Permission that the team will have for its repositories",
    )
    privacy: Missing[Literal["open", "closed", "secret"]] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET, description="URL for the team")


class WebhookPullRequestReviewEditedPropPullRequestPropRequestedTeamsItemsPropParent(
    GitHubModel
):
    """WebhookPullRequestReviewEditedPropPullRequestPropRequestedTeamsItemsPropParent"""

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


model_rebuild(WebhookPullRequestReviewEdited)
model_rebuild(WebhookPullRequestReviewEditedPropChanges)
model_rebuild(WebhookPullRequestReviewEditedPropChangesPropBody)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequest)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropAssignee)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropAssigneesItems)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropAutoMerge)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropAutoMergePropEnabledBy)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLabelsItems)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropMilestone)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropMilestonePropCreator)
model_rebuild(
    WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof0
)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropUser)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLinks)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLinksPropComments)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLinksPropCommits)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLinksPropHtml)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLinksPropIssue)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLinksPropReviewComment)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLinksPropReviewComments)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLinksPropSelf)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropLinksPropStatuses)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropBase)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropBasePropUser)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepo)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropLicense)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropOwner)
model_rebuild(
    WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropPermissions
)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropHead)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepo)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropLicense)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropOwner)
model_rebuild(
    WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropPermissions
)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropHeadPropUser)
model_rebuild(
    WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof1
)
model_rebuild(
    WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof1PropParent
)
model_rebuild(WebhookPullRequestReviewEditedPropPullRequestPropRequestedTeamsItems)
model_rebuild(
    WebhookPullRequestReviewEditedPropPullRequestPropRequestedTeamsItemsPropParent
)

__all__ = (
    "WebhookPullRequestReviewEdited",
    "WebhookPullRequestReviewEditedPropChanges",
    "WebhookPullRequestReviewEditedPropChangesPropBody",
    "WebhookPullRequestReviewEditedPropPullRequest",
    "WebhookPullRequestReviewEditedPropPullRequestPropAssignee",
    "WebhookPullRequestReviewEditedPropPullRequestPropAssigneesItems",
    "WebhookPullRequestReviewEditedPropPullRequestPropAutoMerge",
    "WebhookPullRequestReviewEditedPropPullRequestPropAutoMergePropEnabledBy",
    "WebhookPullRequestReviewEditedPropPullRequestPropBase",
    "WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepo",
    "WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropLicense",
    "WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropOwner",
    "WebhookPullRequestReviewEditedPropPullRequestPropBasePropRepoPropPermissions",
    "WebhookPullRequestReviewEditedPropPullRequestPropBasePropUser",
    "WebhookPullRequestReviewEditedPropPullRequestPropHead",
    "WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepo",
    "WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropLicense",
    "WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropOwner",
    "WebhookPullRequestReviewEditedPropPullRequestPropHeadPropRepoPropPermissions",
    "WebhookPullRequestReviewEditedPropPullRequestPropHeadPropUser",
    "WebhookPullRequestReviewEditedPropPullRequestPropLabelsItems",
    "WebhookPullRequestReviewEditedPropPullRequestPropLinks",
    "WebhookPullRequestReviewEditedPropPullRequestPropLinksPropComments",
    "WebhookPullRequestReviewEditedPropPullRequestPropLinksPropCommits",
    "WebhookPullRequestReviewEditedPropPullRequestPropLinksPropHtml",
    "WebhookPullRequestReviewEditedPropPullRequestPropLinksPropIssue",
    "WebhookPullRequestReviewEditedPropPullRequestPropLinksPropReviewComment",
    "WebhookPullRequestReviewEditedPropPullRequestPropLinksPropReviewComments",
    "WebhookPullRequestReviewEditedPropPullRequestPropLinksPropSelf",
    "WebhookPullRequestReviewEditedPropPullRequestPropLinksPropStatuses",
    "WebhookPullRequestReviewEditedPropPullRequestPropMilestone",
    "WebhookPullRequestReviewEditedPropPullRequestPropMilestonePropCreator",
    "WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof0",
    "WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof1",
    "WebhookPullRequestReviewEditedPropPullRequestPropRequestedReviewersItemsOneof1PropParent",
    "WebhookPullRequestReviewEditedPropPullRequestPropRequestedTeamsItems",
    "WebhookPullRequestReviewEditedPropPullRequestPropRequestedTeamsItemsPropParent",
    "WebhookPullRequestReviewEditedPropPullRequestPropUser",
)
