"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ActionsBillingUsage,
        AdvancedSecurityActiveCommitters,
        BillingUsageReport,
        CombinedBillingUsage,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        GetAllCostCenters,
        PackagesBillingUsage,
    )
    from ..types import (
        ActionsBillingUsageType,
        AdvancedSecurityActiveCommittersType,
        BillingUsageReportType,
        CombinedBillingUsageType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
        GetAllCostCentersType,
        PackagesBillingUsageType,
    )


class BillingClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_github_actions_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-actions-billing-for-an-enterprise"""

        from ..models import ActionsBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    async def async_get_github_actions_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-actions-billing-for-an-enterprise"""

        from ..models import ActionsBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    def get_github_advanced_security_billing_ghe(
        self,
        enterprise: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AdvancedSecurityActiveCommitters, AdvancedSecurityActiveCommittersType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-advanced-security-active-committers-for-an-enterprise"""

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/enterprises/{enterprise}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=AdvancedSecurityActiveCommitters,
        )

    async def async_get_github_advanced_security_billing_ghe(
        self,
        enterprise: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AdvancedSecurityActiveCommitters, AdvancedSecurityActiveCommittersType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-advanced-security-active-committers-for-an-enterprise"""

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/enterprises/{enterprise}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=AdvancedSecurityActiveCommitters,
        )

    def get_all_cost_centers(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GetAllCostCenters, GetAllCostCentersType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-all-cost-centers-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetAllCostCenters,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GetAllCostCenters,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_all_cost_centers(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GetAllCostCenters, GetAllCostCentersType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-all-cost-centers-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            GetAllCostCenters,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GetAllCostCenters,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]: ...

    @overload
    def add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]: ...

    def add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#add-users-to-a-cost-center"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]: ...

    @overload
    async def async_add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]: ...

    async def async_add_resource_to_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#add-users-to-a-cost-center"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourcePostResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "409": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]: ...

    @overload
    def remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]: ...

    def remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#remove-users-from-a-cost-center"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]: ...

    @overload
    async def async_remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]: ...

    async def async_remove_resource_from_cost_center(
        self,
        enterprise: str,
        cost_center_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#remove-users-from-a-cost-center"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
            EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
        )

        url = f"/enterprises/{enterprise}/settings/billing/cost-centers/{cost_center_id}/resource"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseSettingsBillingCostCentersCostCenterIdResourceDeleteResponse200,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_packages_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-packages-billing-for-an-enterprise"""

        from ..models import PackagesBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    async def async_get_github_packages_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-packages-billing-for-an-enterprise"""

        from ..models import PackagesBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    def get_shared_storage_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-shared-storage-billing-for-an-enterprise"""

        from ..models import CombinedBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    async def async_get_shared_storage_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-shared-storage-billing-for-an-enterprise"""

        from ..models import CombinedBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    def get_github_billing_usage_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BillingUsageReport, BillingUsageReportType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-billing-usage-report-for-an-enterprise"""

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_github_billing_usage_report_ghe(
        self,
        enterprise: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        cost_center_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BillingUsageReport, BillingUsageReportType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-billing-usage-report-for-an-enterprise"""

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
            "cost_center_id": cost_center_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_billing_usage_report_org(
        self,
        org: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BillingUsageReport, BillingUsageReportType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/enhanced-billing#get-billing-usage-report-for-an-organization"""

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/organizations/{org}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_github_billing_usage_report_org(
        self,
        org: str,
        *,
        year: Missing[int] = UNSET,
        month: Missing[int] = UNSET,
        day: Missing[int] = UNSET,
        hour: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BillingUsageReport, BillingUsageReportType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/enhanced-billing#get-billing-usage-report-for-an-organization"""

        from ..models import (
            BasicError,
            BillingUsageReport,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/organizations/{org}/settings/billing/usage"

        params = {
            "year": year,
            "month": month,
            "day": day,
            "hour": hour,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=BillingUsageReport,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_github_actions_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-an-organization"""

        from ..models import ActionsBillingUsage

        url = f"/orgs/{org}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    async def async_get_github_actions_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-an-organization"""

        from ..models import ActionsBillingUsage

        url = f"/orgs/{org}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    def get_github_advanced_security_billing_org(
        self,
        org: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AdvancedSecurityActiveCommitters, AdvancedSecurityActiveCommittersType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-advanced-security-active-committers-for-an-organization"""

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/orgs/{org}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=AdvancedSecurityActiveCommitters,
        )

    async def async_get_github_advanced_security_billing_org(
        self,
        org: str,
        *,
        advanced_security_product: Missing[
            Literal["code_security", "secret_protection"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AdvancedSecurityActiveCommitters, AdvancedSecurityActiveCommittersType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-advanced-security-active-committers-for-an-organization"""

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/orgs/{org}/settings/billing/advanced-security"

        params = {
            "advanced_security_product": advanced_security_product,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=AdvancedSecurityActiveCommitters,
        )

    def get_github_packages_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-an-organization"""

        from ..models import PackagesBillingUsage

        url = f"/orgs/{org}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    async def async_get_github_packages_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-an-organization"""

        from ..models import PackagesBillingUsage

        url = f"/orgs/{org}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    def get_shared_storage_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-an-organization"""

        from ..models import CombinedBillingUsage

        url = f"/orgs/{org}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    async def async_get_shared_storage_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-an-organization"""

        from ..models import CombinedBillingUsage

        url = f"/orgs/{org}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    def get_github_actions_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-a-user"""

        from ..models import ActionsBillingUsage

        url = f"/users/{username}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    async def async_get_github_actions_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ActionsBillingUsage, ActionsBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-a-user"""

        from ..models import ActionsBillingUsage

        url = f"/users/{username}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    def get_github_packages_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-a-user"""

        from ..models import PackagesBillingUsage

        url = f"/users/{username}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    async def async_get_github_packages_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackagesBillingUsage, PackagesBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-a-user"""

        from ..models import PackagesBillingUsage

        url = f"/users/{username}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    def get_shared_storage_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-a-user"""

        from ..models import CombinedBillingUsage

        url = f"/users/{username}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    async def async_get_shared_storage_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CombinedBillingUsage, CombinedBillingUsageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-a-user"""

        from ..models import CombinedBillingUsage

        url = f"/users/{username}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )
