"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Optional
from weakref import ref

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        Classroom,
        ClassroomAcceptedAssignment,
        ClassroomAssignment,
        ClassroomAssignmentGrade,
        SimpleClassroom,
        SimpleClassroomAssignment,
    )
    from ..types import (
        ClassroomAcceptedAssignmentType,
        ClassroomAssignmentGradeType,
        ClassroomAssignmentType,
        ClassroomType,
        SimpleClassroomAssignmentType,
        SimpleClassroomType,
    )


class ClassroomClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_an_assignment(
        self,
        assignment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ClassroomAssignment, ClassroomAssignmentType]:
        """See also: https://docs.github.com/rest/classroom/classroom#get-an-assignment"""

        from ..models import BasicError, ClassroomAssignment

        url = f"/assignments/{assignment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ClassroomAssignment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_an_assignment(
        self,
        assignment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ClassroomAssignment, ClassroomAssignmentType]:
        """See also: https://docs.github.com/rest/classroom/classroom#get-an-assignment"""

        from ..models import BasicError, ClassroomAssignment

        url = f"/assignments/{assignment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ClassroomAssignment,
            error_models={
                "404": BasicError,
            },
        )

    def list_accepted_assignments_for_an_assignment(
        self,
        assignment_id: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[ClassroomAcceptedAssignment], list[ClassroomAcceptedAssignmentType]
    ]:
        """See also: https://docs.github.com/rest/classroom/classroom#list-accepted-assignments-for-an-assignment"""

        from ..models import ClassroomAcceptedAssignment

        url = f"/assignments/{assignment_id}/accepted_assignments"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ClassroomAcceptedAssignment],
        )

    async def async_list_accepted_assignments_for_an_assignment(
        self,
        assignment_id: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[ClassroomAcceptedAssignment], list[ClassroomAcceptedAssignmentType]
    ]:
        """See also: https://docs.github.com/rest/classroom/classroom#list-accepted-assignments-for-an-assignment"""

        from ..models import ClassroomAcceptedAssignment

        url = f"/assignments/{assignment_id}/accepted_assignments"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ClassroomAcceptedAssignment],
        )

    def get_assignment_grades(
        self,
        assignment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ClassroomAssignmentGrade], list[ClassroomAssignmentGradeType]]:
        """See also: https://docs.github.com/rest/classroom/classroom#get-assignment-grades"""

        from ..models import BasicError, ClassroomAssignmentGrade

        url = f"/assignments/{assignment_id}/grades"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[ClassroomAssignmentGrade],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_assignment_grades(
        self,
        assignment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ClassroomAssignmentGrade], list[ClassroomAssignmentGradeType]]:
        """See also: https://docs.github.com/rest/classroom/classroom#get-assignment-grades"""

        from ..models import BasicError, ClassroomAssignmentGrade

        url = f"/assignments/{assignment_id}/grades"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[ClassroomAssignmentGrade],
            error_models={
                "404": BasicError,
            },
        )

    def list_classrooms(
        self,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleClassroom], list[SimpleClassroomType]]:
        """See also: https://docs.github.com/rest/classroom/classroom#list-classrooms"""

        from ..models import SimpleClassroom

        url = "/classrooms"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleClassroom],
        )

    async def async_list_classrooms(
        self,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleClassroom], list[SimpleClassroomType]]:
        """See also: https://docs.github.com/rest/classroom/classroom#list-classrooms"""

        from ..models import SimpleClassroom

        url = "/classrooms"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleClassroom],
        )

    def get_a_classroom(
        self,
        classroom_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Classroom, ClassroomType]:
        """See also: https://docs.github.com/rest/classroom/classroom#get-a-classroom"""

        from ..models import BasicError, Classroom

        url = f"/classrooms/{classroom_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Classroom,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_a_classroom(
        self,
        classroom_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Classroom, ClassroomType]:
        """See also: https://docs.github.com/rest/classroom/classroom#get-a-classroom"""

        from ..models import BasicError, Classroom

        url = f"/classrooms/{classroom_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Classroom,
            error_models={
                "404": BasicError,
            },
        )

    def list_assignments_for_a_classroom(
        self,
        classroom_id: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleClassroomAssignment], list[SimpleClassroomAssignmentType]]:
        """See also: https://docs.github.com/rest/classroom/classroom#list-assignments-for-a-classroom"""

        from ..models import SimpleClassroomAssignment

        url = f"/classrooms/{classroom_id}/assignments"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleClassroomAssignment],
        )

    async def async_list_assignments_for_a_classroom(
        self,
        classroom_id: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleClassroomAssignment], list[SimpleClassroomAssignmentType]]:
        """See also: https://docs.github.com/rest/classroom/classroom#list-assignments-for-a-classroom"""

        from ..models import SimpleClassroomAssignment

        url = f"/classrooms/{classroom_id}/assignments"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleClassroomAssignment],
        )
