"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ExternalGroup,
        ExternalGroups,
        GroupMapping,
        MinimalRepository,
        OrganizationInvitation,
        SimpleUser,
        Team,
        TeamDiscussion,
        TeamDiscussionComment,
        TeamFull,
        TeamMembership,
        TeamProject,
        TeamRepository,
    )
    from ..types import (
        ExternalGroupsType,
        ExternalGroupType,
        GroupMappingType,
        MinimalRepositoryType,
        OrganizationInvitationType,
        OrgsOrgTeamsPostBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
        OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType,
        OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType,
        OrgsOrgTeamsTeamSlugPatchBodyType,
        OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType,
        OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType,
        OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType,
        OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType,
        SimpleUserType,
        TeamDiscussionCommentType,
        TeamDiscussionType,
        TeamFullType,
        TeamMembershipType,
        TeamProjectType,
        TeamRepositoryType,
        TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType,
        TeamsTeamIdDiscussionsPostBodyType,
        TeamsTeamIdMembershipsUsernamePutBodyType,
        TeamsTeamIdPatchBodyType,
        TeamsTeamIdProjectsProjectIdPutBodyType,
        TeamsTeamIdReposOwnerRepoPutBodyType,
        TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType,
        TeamsTeamIdTeamSyncGroupMappingsPatchBodyType,
        TeamType,
    )


class TeamsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def external_idp_group_info_for_org(
        self,
        org: str,
        group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ExternalGroup, ExternalGroupType]:
        """teams/external-idp-group-info-for-org

        GET /orgs/{org}/external-group/{group_id}

        Displays information about the specific group's usage.  Provides a list of the group's external members as well as a list of teams that this group is connected to.

        You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#get-an-external-group
        """

        from ..models import ExternalGroup

        url = f"/orgs/{org}/external-group/{group_id}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExternalGroup,
        )

    async def async_external_idp_group_info_for_org(
        self,
        org: str,
        group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ExternalGroup, ExternalGroupType]:
        """teams/external-idp-group-info-for-org

        GET /orgs/{org}/external-group/{group_id}

        Displays information about the specific group's usage.  Provides a list of the group's external members as well as a list of teams that this group is connected to.

        You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#get-an-external-group
        """

        from ..models import ExternalGroup

        url = f"/orgs/{org}/external-group/{group_id}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExternalGroup,
        )

    def list_external_idp_groups_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ExternalGroups, ExternalGroupsType]:
        """teams/list-external-idp-groups-for-org

        GET /orgs/{org}/external-groups

        Lists external groups available in an organization. You can query the groups using the `display_name` parameter, only groups with a `group_name` containing the text provided in the `display_name` parameter will be returned.  You can also limit your page results using the `per_page` parameter. GitHub Enterprise Cloud generates a url-encoded `page` token using a cursor value for where the next page begins. For more information on cursor pagination, see "[Offset and Cursor Pagination explained](https://dev.to/jackmarchant/offset-and-cursor-pagination-explained-b89)."

        You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#list-external-groups-in-an-organization
        """

        from ..models import ExternalGroups

        url = f"/orgs/{org}/external-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "display_name": display_name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExternalGroups,
        )

    async def async_list_external_idp_groups_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        display_name: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ExternalGroups, ExternalGroupsType]:
        """teams/list-external-idp-groups-for-org

        GET /orgs/{org}/external-groups

        Lists external groups available in an organization. You can query the groups using the `display_name` parameter, only groups with a `group_name` containing the text provided in the `display_name` parameter will be returned.  You can also limit your page results using the `per_page` parameter. GitHub Enterprise Cloud generates a url-encoded `page` token using a cursor value for where the next page begins. For more information on cursor pagination, see "[Offset and Cursor Pagination explained](https://dev.to/jackmarchant/offset-and-cursor-pagination-explained-b89)."

        You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#list-external-groups-in-an-organization
        """

        from ..models import ExternalGroups

        url = f"/orgs/{org}/external-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "display_name": display_name,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ExternalGroups,
        )

    def list_idp_groups_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[str] = UNSET,
        q: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GroupMapping, GroupMappingType]:
        """teams/list-idp-groups-for-org

        GET /orgs/{org}/team-sync/groups

        Lists IdP groups available in an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-an-organization
        """

        from ..models import GroupMapping

        url = f"/orgs/{org}/team-sync/groups"

        params = {
            "per_page": per_page,
            "page": page,
            "q": q,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    async def async_list_idp_groups_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[str] = UNSET,
        q: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GroupMapping, GroupMappingType]:
        """teams/list-idp-groups-for-org

        GET /orgs/{org}/team-sync/groups

        Lists IdP groups available in an organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-an-organization
        """

        from ..models import GroupMapping

        url = f"/orgs/{org}/team-sync/groups"

        params = {
            "per_page": per_page,
            "page": page,
            "q": q,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    def list(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """teams/list

        GET /orgs/{org}/teams

        Lists all teams in an organization that are visible to the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-teams
        """

        from ..models import BasicError, Team

        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "403": BasicError,
            },
        )

    async def async_list(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """teams/list

        GET /orgs/{org}/teams

        Lists all teams in an organization that are visible to the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-teams
        """

        from ..models import BasicError, Team

        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def create(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsPostBodyType,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    def create(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        maintainers: Missing[list[str]] = UNSET,
        repo_names: Missing[list[str]] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push"]] = UNSET,
        parent_team_id: Missing[int] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    def create(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """teams/create

        POST /orgs/{org}/teams

        To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/enterprise-cloud@latest//articles/setting-team-creation-permissions-in-your-organization)."

        When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-organizations-and-teams/about-teams)".

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#create-a-team
        """

        from ..models import BasicError, OrgsOrgTeamsPostBody, TeamFull, ValidationError

        url = f"/orgs/{org}/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsPostBodyType,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    async def async_create(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        maintainers: Missing[list[str]] = UNSET,
        repo_names: Missing[list[str]] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push"]] = UNSET,
        parent_team_id: Missing[int] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    async def async_create(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """teams/create

        POST /orgs/{org}/teams

        To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/enterprise-cloud@latest//articles/setting-team-creation-permissions-in-your-organization)."

        When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-organizations-and-teams/about-teams)".

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#create-a-team
        """

        from ..models import BasicError, OrgsOrgTeamsPostBody, TeamFull, ValidationError

        url = f"/orgs/{org}/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_by_name(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamFull, TeamFullType]:
        """teams/get-by-name

        GET /orgs/{org}/teams/{team_slug}

        Gets a team using the team's `slug`. To create the `slug`, GitHub Enterprise Cloud replaces special characters in the `name` string, changes all words to lowercase, and replaces spaces with a `-` separator. For example, `"My TEam Näme"` would become `my-team-name`.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-by-name
        """

        from ..models import BasicError, TeamFull

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_name(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamFull, TeamFullType]:
        """teams/get-by-name

        GET /orgs/{org}/teams/{team_slug}

        Gets a team using the team's `slug`. To create the `slug`, GitHub Enterprise Cloud replaces special characters in the `name` string, changes all words to lowercase, and replaces spaces with a `-` separator. For example, `"My TEam Näme"` would become `my-team-name`.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-by-name
        """

        from ..models import BasicError, TeamFull

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/delete-in-org

        DELETE /orgs/{org}/teams/{team_slug}

        To delete a team, the authenticated user must be an organization owner or team maintainer.

        If you are an organization owner, deleting a parent team will delete all of its child teams as well.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team
        """

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/delete-in-org

        DELETE /orgs/{org}/teams/{team_slug}

        To delete a team, the authenticated user must be an organization owner or team maintainer.

        If you are an organization owner, deleting a parent team will delete all of its child teams as well.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team
        """

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """teams/update-in-org

        PATCH /orgs/{org}/teams/{team_slug}

        To edit a team, the authenticated user must either be an organization owner or a team maintainer.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team
        """

        from ..models import (
            BasicError,
            OrgsOrgTeamsTeamSlugPatchBody,
            TeamFull,
            ValidationError,
        )

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """teams/update-in-org

        PATCH /orgs/{org}/teams/{team_slug}

        To edit a team, the authenticated user must either be an organization owner or a team maintainer.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team
        """

        from ..models import (
            BasicError,
            OrgsOrgTeamsTeamSlugPatchBody,
            TeamFull,
            ValidationError,
        )

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        pinned: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamDiscussion], list[TeamDiscussionType]]:
        """teams/list-discussions-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions

        List all discussions on a team's page.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions
        """

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussion],
        )

    async def async_list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        pinned: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamDiscussion], list[TeamDiscussionType]]:
        """teams/list-discussions-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions

        List all discussions on a team's page.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions
        """

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussion],
        )

    @overload
    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """teams/create-discussion-in-org

        POST /orgs/{org}/teams/{team_slug}/discussions

        Creates a new discussion post on a team's page.

        This endpoint triggers [notifications](https://docs.github.com/enterprise-cloud@latest//github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-using-the-rest-api)."

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion
        """

        from ..models import OrgsOrgTeamsTeamSlugDiscussionsPostBody, TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """teams/create-discussion-in-org

        POST /orgs/{org}/teams/{team_slug}/discussions

        Creates a new discussion post on a team's page.

        This endpoint triggers [notifications](https://docs.github.com/enterprise-cloud@latest//github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-using-the-rest-api)."

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion
        """

        from ..models import OrgsOrgTeamsTeamSlugDiscussionsPostBody, TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """teams/get-discussion-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}

        Get a specific discussion on a team's page.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion
        """

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """teams/get-discussion-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}

        Get a specific discussion on a team's page.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion
        """

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/delete-discussion-in-org

        DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}

        Delete a discussion from a team's page.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion
        """

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/delete-discussion-in-org

        DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}

        Delete a discussion from a team's page.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion
        """

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """teams/update-discussion-in-org

        PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}

        Edits the title and body text of a discussion post. Only the parameters you provide are updated.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody,
            TeamDiscussion,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """teams/update-discussion-in-org

        PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}

        Edits the title and body text of a discussion post. Only the parameters you provide are updated.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody,
            TeamDiscussion,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamDiscussionComment], list[TeamDiscussionCommentType]]:
        """teams/list-discussion-comments-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments

        List all comments on a team discussion.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments
        """

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamDiscussionComment], list[TeamDiscussionCommentType]]:
        """teams/list-discussion-comments-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments

        List all comments on a team discussion.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments
        """

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussionComment],
        )

    @overload
    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """teams/create-discussion-comment-in-org

        POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments

        Creates a new comment on a team discussion.

        This endpoint triggers [notifications](https://docs.github.com/enterprise-cloud@latest//github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-using-the-rest-api)."

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody,
            TeamDiscussionComment,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """teams/create-discussion-comment-in-org

        POST /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments

        Creates a new comment on a team discussion.

        This endpoint triggers [notifications](https://docs.github.com/enterprise-cloud@latest//github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-using-the-rest-api)."

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody,
            TeamDiscussionComment,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """teams/get-discussion-comment-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}

        Get a specific comment on a team discussion.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment
        """

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """teams/get-discussion-comment-in-org

        GET /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}

        Get a specific comment on a team discussion.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment
        """

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/delete-discussion-comment-in-org

        DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}

        Deletes a comment on a team discussion.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment
        """

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/delete-discussion-comment-in-org

        DELETE /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}

        Deletes a comment on a team discussion.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment
        """

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """teams/update-discussion-comment-in-org

        PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}

        Edits the body text of a discussion comment.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
            TeamDiscussionComment,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """teams/update-discussion-comment-in-org

        PATCH /orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}

        Edits the body text of a discussion comment.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
            TeamDiscussionComment,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def list_linked_external_idp_groups_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ExternalGroups, ExternalGroupsType]:
        """teams/list-linked-external-idp-groups-to-team-for-org

        GET /orgs/{org}/teams/{team_slug}/external-groups

        Lists a connection between a team and an external group.

        You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#list-a-connection-between-an-external-group-and-a-team
        """

        from ..models import ExternalGroups

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ExternalGroups,
        )

    async def async_list_linked_external_idp_groups_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ExternalGroups, ExternalGroupsType]:
        """teams/list-linked-external-idp-groups-to-team-for-org

        GET /orgs/{org}/teams/{team_slug}/external-groups

        Lists a connection between a team and an external group.

        You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#list-a-connection-between-an-external-group-and-a-team
        """

        from ..models import ExternalGroups

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ExternalGroups,
        )

    def unlink_external_idp_group_from_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/unlink-external-idp-group-from-team-for-org

        DELETE /orgs/{org}/teams/{team_slug}/external-groups

        Deletes a connection between a team and an external group.

        You can manage team membership with your IdP using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#remove-the-connection-between-an-external-group-and-a-team
        """

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_unlink_external_idp_group_from_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/unlink-external-idp-group-from-team-for-org

        DELETE /orgs/{org}/teams/{team_slug}/external-groups

        Deletes a connection between a team and an external group.

        You can manage team membership with your IdP using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#remove-the-connection-between-an-external-group-and-a-team
        """

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType,
    ) -> Response[ExternalGroup, ExternalGroupType]: ...

    @overload
    def link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        group_id: int,
    ) -> Response[ExternalGroup, ExternalGroupType]: ...

    def link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ExternalGroup, ExternalGroupType]:
        """teams/link-external-idp-group-to-team-for-org

        PATCH /orgs/{org}/teams/{team_slug}/external-groups

        Creates a connection between a team and an external group.  Only one external group can be linked to a team.

        You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#update-the-connection-between-an-external-group-and-a-team
        """

        from ..models import ExternalGroup, OrgsOrgTeamsTeamSlugExternalGroupsPatchBody

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugExternalGroupsPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ExternalGroup,
        )

    @overload
    async def async_link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType,
    ) -> Response[ExternalGroup, ExternalGroupType]: ...

    @overload
    async def async_link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        group_id: int,
    ) -> Response[ExternalGroup, ExternalGroupType]: ...

    async def async_link_external_idp_group_to_team_for_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugExternalGroupsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ExternalGroup, ExternalGroupType]:
        """teams/link-external-idp-group-to-team-for-org

        PATCH /orgs/{org}/teams/{team_slug}/external-groups

        Creates a connection between a team and an external group.  Only one external group can be linked to a team.

        You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/external-groups#update-the-connection-between-an-external-group-and-a-team
        """

        from ..models import ExternalGroup, OrgsOrgTeamsTeamSlugExternalGroupsPatchBody

        url = f"/orgs/{org}/teams/{team_slug}/external-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugExternalGroupsPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ExternalGroup,
        )

    def list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """teams/list-pending-invitations-in-org

        GET /orgs/{org}/teams/{team_slug}/invitations

        The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub Enterprise Cloud member, the `login` field in the return hash will be `null`.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations
        """

        from ..models import OrganizationInvitation

        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
        )

    async def async_list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """teams/list-pending-invitations-in-org

        GET /orgs/{org}/teams/{team_slug}/invitations

        The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub Enterprise Cloud member, the `login` field in the return hash will be `null`.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations
        """

        from ..models import OrganizationInvitation

        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
        )

    def list_members_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """teams/list-members-in-org

        GET /orgs/{org}/teams/{team_slug}/members

        Team members will include the members of child teams.

        To list members in a team, the team must be visible to the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members
        """

        from ..models import SimpleUser

        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    async def async_list_members_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """teams/list-members-in-org

        GET /orgs/{org}/teams/{team_slug}/members

        Team members will include the members of child teams.

        To list members in a team, the team must be visible to the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members
        """

        from ..models import SimpleUser

        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    def get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """teams/get-membership-for-user-in-org

        GET /orgs/{org}/teams/{team_slug}/memberships/{username}

        Team members will include the members of child teams.

        To get a user's membership with a team, the team must be visible to the authenticated user.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.

        > [!NOTE]
        > The response contains the `state` of the membership and the member's `role`.

        The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#create-a-team).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user
        """

        from ..models import TeamMembership

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    async def async_get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """teams/get-membership-for-user-in-org

        GET /orgs/{org}/teams/{team_slug}/memberships/{username}

        Team members will include the members of child teams.

        To get a user's membership with a team, the team must be visible to the authenticated user.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.

        > [!NOTE]
        > The response contains the `state` of the membership and the member's `role`.

        The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#create-a-team).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user
        """

        from ..models import TeamMembership

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    @overload
    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    @overload
    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """teams/add-or-update-membership-for-user-in-org

        PUT /orgs/{org}/teams/{team_slug}/memberships/{username}

        Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.

        If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody,
            TeamMembership,
        )

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    @overload
    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    @overload
    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """teams/add-or-update-membership-for-user-in-org

        PUT /orgs/{org}/teams/{team_slug}/memberships/{username}

        Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.

        If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user
        """

        from ..models import (
            OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody,
            TeamMembership,
        )

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    def remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/remove-membership-for-user-in-org

        DELETE /orgs/{org}/teams/{team_slug}/memberships/{username}

        To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user
        """

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/remove-membership-for-user-in-org

        DELETE /orgs/{org}/teams/{team_slug}/memberships/{username}

        To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user
        """

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamProject], list[TeamProjectType]]:
        """DEPRECATED teams/list-projects-in-org

        GET /orgs/{org}/teams/{team_slug}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-projects
        """

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamProject],
        )

    async def async_list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamProject], list[TeamProjectType]]:
        """DEPRECATED teams/list-projects-in-org

        GET /orgs/{org}/teams/{team_slug}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-projects
        """

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamProject],
        )

    def check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamProject, TeamProjectType]:
        """DEPRECATED teams/check-permissions-for-project-in-org

        GET /orgs/{org}/teams/{team_slug}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-project
        """

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamProject, TeamProjectType]:
        """DEPRECATED teams/check-permissions-for-project-in-org

        GET /orgs/{org}/teams/{team_slug}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-project
        """

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    @overload
    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED teams/add-or-update-project-permissions-in-org

        PUT /orgs/{org}/teams/{team_slug}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-project-permissions
        """

        from typing import Union

        from ..models import (
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody,
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
        )

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    @overload
    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED teams/add-or-update-project-permissions-in-org

        PUT /orgs/{org}/teams/{team_slug}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-project-permissions
        """

        from typing import Union

        from ..models import (
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody,
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
        )

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    def remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-project-in-org

        DELETE /orgs/{org}/teams/{team_slug}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-project-from-a-team
        """

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-project-in-org

        DELETE /orgs/{org}/teams/{team_slug}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-project-from-a-team
        """

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """teams/list-repos-in-org

        GET /orgs/{org}/teams/{team_slug}/repos

        Lists a team's repositories visible to the authenticated user.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories
        """

        from ..models import MinimalRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
        )

    async def async_list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """teams/list-repos-in-org

        GET /orgs/{org}/teams/{team_slug}/repos

        Lists a team's repositories visible to the authenticated user.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories
        """

        from ..models import MinimalRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
        )

    def check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamRepository, TeamRepositoryType]:
        """teams/check-permissions-for-repo-in-org

        GET /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}

        Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.

        You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `application/vnd.github.v3.repository+json` accept header.

        If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.

        If the repository is private, you must have at least `read` permission for that repository, and your token must have the `repo` or `admin:org` scope. Otherwise, you will receive a `404 Not Found` response status.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository
        """

        from ..models import TeamRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamRepository, TeamRepositoryType]:
        """teams/check-permissions-for-repo-in-org

        GET /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}

        Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.

        You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `application/vnd.github.v3.repository+json` accept header.

        If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.

        If the repository is private, you must have at least `read` permission for that repository, and your token must have the `repo` or `admin:org` scope. Otherwise, you will receive a `404 Not Found` response status.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository
        """

        from ..models import TeamRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    @overload
    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response: ...

    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """teams/add-or-update-repo-permissions-in-org

        PUT /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}

        To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#http-method)."

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.

        For more information about the permission levels, see "[Repository permission levels for an organization](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions
        """

        from ..models import OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """teams/add-or-update-repo-permissions-in-org

        PUT /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}

        To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#http-method)."

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.

        For more information about the permission levels, see "[Repository permission levels for an organization](https://docs.github.com/enterprise-cloud@latest//github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions
        """

        from ..models import OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/remove-repo-in-org

        DELETE /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}

        If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team
        """

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """teams/remove-repo-in-org

        DELETE /orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}

        If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team
        """

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_idp_groups_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GroupMapping, GroupMappingType]:
        """teams/list-idp-groups-in-org

        GET /orgs/{org}/teams/{team_slug}/team-sync/group-mappings

        List IdP groups connected to a team on GitHub Enterprise Cloud.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team
        """

        from ..models import GroupMapping

        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    async def async_list_idp_groups_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GroupMapping, GroupMappingType]:
        """teams/list-idp-groups-in-org

        GET /orgs/{org}/teams/{team_slug}/team-sync/group-mappings

        List IdP groups connected to a team on GitHub Enterprise Cloud.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team
        """

        from ..models import GroupMapping

        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    @overload
    def create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType,
    ) -> Response[GroupMapping, GroupMappingType]: ...

    @overload
    def create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        groups: Missing[
            list[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType]
        ] = UNSET,
    ) -> Response[GroupMapping, GroupMappingType]: ...

    def create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GroupMapping, GroupMappingType]:
        """teams/create-or-update-idp-group-connections-in-org

        PATCH /orgs/{org}/teams/{team_slug}/team-sync/group-mappings

        Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections
        """

        from ..models import (
            GroupMapping,
            OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    @overload
    async def async_create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType,
    ) -> Response[GroupMapping, GroupMappingType]: ...

    @overload
    async def async_create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        groups: Missing[
            list[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyPropGroupsItemsType]
        ] = UNSET,
    ) -> Response[GroupMapping, GroupMappingType]: ...

    async def async_create_or_update_idp_group_connections_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GroupMapping, GroupMappingType]:
        """teams/create-or-update-idp-group-connections-in-org

        PATCH /orgs/{org}/teams/{team_slug}/team-sync/group-mappings

        Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections
        """

        from ..models import (
            GroupMapping,
            OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody,
        )

        url = f"/orgs/{org}/teams/{team_slug}/team-sync/group-mappings"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugTeamSyncGroupMappingsPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
        )

    def list_child_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """teams/list-child-in-org

        GET /orgs/{org}/teams/{team_slug}/teams

        Lists the child teams of the team specified by `{team_slug}`.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams
        """

        from ..models import Team

        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
        )

    async def async_list_child_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """teams/list-child-in-org

        GET /orgs/{org}/teams/{team_slug}/teams

        Lists the child teams of the team specified by `{team_slug}`.

        > [!NOTE]
        > You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams
        """

        from ..models import Team

        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
        )

    def get_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamFull, TeamFullType]:
        """DEPRECATED teams/get-legacy

        GET /teams/{team_id}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-by-name) endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-legacy
        """

        from ..models import BasicError, TeamFull

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamFull, TeamFullType]:
        """DEPRECATED teams/get-legacy

        GET /teams/{team_id}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-by-name) endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#get-a-team-legacy
        """

        from ..models import BasicError, TeamFull

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/delete-legacy

        DELETE /teams/{team_id}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team) endpoint.

        To delete a team, the authenticated user must be an organization owner or team maintainer.

        If you are an organization owner, deleting a parent team will delete all of its child teams as well.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team-legacy
        """

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_delete_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/delete-legacy

        DELETE /teams/{team_id}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team) endpoint.

        To delete a team, the authenticated user must be an organization owner or team maintainer.

        If you are an organization owner, deleting a parent team will delete all of its child teams as well.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#delete-a-team-legacy
        """

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdPatchBodyType,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    def update_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    def update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """DEPRECATED teams/update-legacy

        PATCH /teams/{team_id}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team) endpoint.

        To edit a team, the authenticated user must either be an organization owner or a team maintainer.

        > [!NOTE]
        > With nested teams, the `privacy` for parent teams cannot be `secret`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team-legacy
        """

        from ..models import BasicError, TeamFull, TeamsTeamIdPatchBody, ValidationError

        url = f"/teams/{team_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdPatchBodyType,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    async def async_update_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    async def async_update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """DEPRECATED teams/update-legacy

        PATCH /teams/{team_id}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team) endpoint.

        To edit a team, the authenticated user must either be an organization owner or a team maintainer.

        > [!NOTE]
        > With nested teams, the `privacy` for parent teams cannot be `secret`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#update-a-team-legacy
        """

        from ..models import BasicError, TeamFull, TeamsTeamIdPatchBody, ValidationError

        url = f"/teams/{team_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_discussions_legacy(
        self,
        team_id: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamDiscussion], list[TeamDiscussionType]]:
        """DEPRECATED teams/list-discussions-legacy

        GET /teams/{team_id}/discussions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions) endpoint.

        List all discussions on a team's page.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions-legacy
        """

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussion],
        )

    async def async_list_discussions_legacy(
        self,
        team_id: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamDiscussion], list[TeamDiscussionType]]:
        """DEPRECATED teams/list-discussions-legacy

        GET /teams/{team_id}/discussions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions) endpoint.

        List all discussions on a team's page.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#list-discussions-legacy
        """

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussion],
        )

    @overload
    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """DEPRECATED teams/create-discussion-legacy

        POST /teams/{team_id}/discussions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion) endpoint.

        Creates a new discussion post on a team's page.

        This endpoint triggers [notifications](https://docs.github.com/enterprise-cloud@latest//github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-using-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion-legacy
        """

        from ..models import TeamDiscussion, TeamsTeamIdDiscussionsPostBody

        url = f"/teams/{team_id}/discussions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """DEPRECATED teams/create-discussion-legacy

        POST /teams/{team_id}/discussions

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion) endpoint.

        Creates a new discussion post on a team's page.

        This endpoint triggers [notifications](https://docs.github.com/enterprise-cloud@latest//github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-using-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#create-a-discussion-legacy
        """

        from ..models import TeamDiscussion, TeamsTeamIdDiscussionsPostBody

        url = f"/teams/{team_id}/discussions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """DEPRECATED teams/get-discussion-legacy

        GET /teams/{team_id}/discussions/{discussion_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion) endpoint.

        Get a specific discussion on a team's page.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion-legacy
        """

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """DEPRECATED teams/get-discussion-legacy

        GET /teams/{team_id}/discussions/{discussion_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion) endpoint.

        Get a specific discussion on a team's page.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#get-a-discussion-legacy
        """

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/delete-discussion-legacy

        DELETE /teams/{team_id}/discussions/{discussion_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion) endpoint.

        Delete a discussion from a team's page.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion-legacy
        """

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/delete-discussion-legacy

        DELETE /teams/{team_id}/discussions/{discussion_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion) endpoint.

        Delete a discussion from a team's page.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#delete-a-discussion-legacy
        """

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """DEPRECATED teams/update-discussion-legacy

        PATCH /teams/{team_id}/discussions/{discussion_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion) endpoint.

        Edits the title and body text of a discussion post. Only the parameters you provide are updated.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion-legacy
        """

        from ..models import (
            TeamDiscussion,
            TeamsTeamIdDiscussionsDiscussionNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """DEPRECATED teams/update-discussion-legacy

        PATCH /teams/{team_id}/discussions/{discussion_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion) endpoint.

        Edits the title and body text of a discussion post. Only the parameters you provide are updated.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussions#update-a-discussion-legacy
        """

        from ..models import (
            TeamDiscussion,
            TeamsTeamIdDiscussionsDiscussionNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamDiscussionComment], list[TeamDiscussionCommentType]]:
        """DEPRECATED teams/list-discussion-comments-legacy

        GET /teams/{team_id}/discussions/{discussion_number}/comments

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments) endpoint.

        List all comments on a team discussion.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments-legacy
        """

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamDiscussionComment], list[TeamDiscussionCommentType]]:
        """DEPRECATED teams/list-discussion-comments-legacy

        GET /teams/{team_id}/discussions/{discussion_number}/comments

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments) endpoint.

        List all comments on a team discussion.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#list-discussion-comments-legacy
        """

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussionComment],
        )

    @overload
    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """DEPRECATED teams/create-discussion-comment-legacy

        POST /teams/{team_id}/discussions/{discussion_number}/comments

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment) endpoint.

        Creates a new comment on a team discussion.

        This endpoint triggers [notifications](https://docs.github.com/enterprise-cloud@latest//github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-using-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment-legacy
        """

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """DEPRECATED teams/create-discussion-comment-legacy

        POST /teams/{team_id}/discussions/{discussion_number}/comments

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment) endpoint.

        Creates a new comment on a team discussion.

        This endpoint triggers [notifications](https://docs.github.com/enterprise-cloud@latest//github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/best-practices-for-using-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#create-a-discussion-comment-legacy
        """

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """DEPRECATED teams/get-discussion-comment-legacy

        GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment) endpoint.

        Get a specific comment on a team discussion.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment-legacy
        """

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """DEPRECATED teams/get-discussion-comment-legacy

        GET /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment) endpoint.

        Get a specific comment on a team discussion.

        OAuth app tokens and personal access tokens (classic) need the `read:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#get-a-discussion-comment-legacy
        """

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/delete-discussion-comment-legacy

        DELETE /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment) endpoint.

        Deletes a comment on a team discussion.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment-legacy
        """

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/delete-discussion-comment-legacy

        DELETE /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment) endpoint.

        Deletes a comment on a team discussion.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#delete-a-discussion-comment-legacy
        """

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """DEPRECATED teams/update-discussion-comment-legacy

        PATCH /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment) endpoint.

        Edits the body text of a discussion comment.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment-legacy
        """

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """DEPRECATED teams/update-discussion-comment-legacy

        PATCH /teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment) endpoint.

        Edits the body text of a discussion comment.

        OAuth app tokens and personal access tokens (classic) need the `write:discussion` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/discussion-comments#update-a-discussion-comment-legacy
        """

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def list_pending_invitations_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """DEPRECATED teams/list-pending-invitations-legacy

        GET /teams/{team_id}/invitations

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations) endpoint.

        The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub Enterprise Cloud member, the `login` field in the return hash will be `null`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations-legacy
        """

        from ..models import OrganizationInvitation

        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
        )

    async def async_list_pending_invitations_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """DEPRECATED teams/list-pending-invitations-legacy

        GET /teams/{team_id}/invitations

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations) endpoint.

        The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub Enterprise Cloud member, the `login` field in the return hash will be `null`.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-pending-team-invitations-legacy
        """

        from ..models import OrganizationInvitation

        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
        )

    def list_members_legacy(
        self,
        team_id: int,
        *,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """DEPRECATED teams/list-members-legacy

        GET /teams/{team_id}/members

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members) endpoint.

        Team members will include the members of child teams.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members-legacy
        """

        from ..models import BasicError, SimpleUser

        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_members_legacy(
        self,
        team_id: int,
        *,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """DEPRECATED teams/list-members-legacy

        GET /teams/{team_id}/members

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members) endpoint.

        Team members will include the members of child teams.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#list-team-members-legacy
        """

        from ..models import BasicError, SimpleUser

        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    def get_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/get-member-legacy

        GET /teams/{team_id}/members/{username}

        The "Get team member" endpoint (described below) is closing down.

        We recommend using the [Get team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.

        To list members in a team, the team must be visible to the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-member-legacy
        """

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_get_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/get-member-legacy

        GET /teams/{team_id}/members/{username}

        The "Get team member" endpoint (described below) is closing down.

        We recommend using the [Get team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.

        To list members in a team, the team must be visible to the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-member-legacy
        """

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def add_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/add-member-legacy

        PUT /teams/{team_id}/members/{username}

        The "Add team member" endpoint (described below) is closing down.

        We recommend using the [Add or update team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-team-member-legacy
        """

        from ..models import BasicError

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_add_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/add-member-legacy

        PUT /teams/{team_id}/members/{username}

        The "Add team member" endpoint (described below) is closing down.

        We recommend using the [Add or update team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-team-member-legacy
        """

        from ..models import BasicError

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def remove_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-member-legacy

        DELETE /teams/{team_id}/members/{username}

        The "Remove team member" endpoint (described below) is closing down.

        We recommend using the [Remove team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-member-legacy
        """

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-member-legacy

        DELETE /teams/{team_id}/members/{username}

        The "Remove team member" endpoint (described below) is closing down.

        We recommend using the [Remove team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-member-legacy
        """

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """DEPRECATED teams/get-membership-for-user-legacy

        GET /teams/{team_id}/memberships/{username}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user) endpoint.

        Team members will include the members of child teams.

        To get a user's membership with a team, the team must be visible to the authenticated user.

        **Note:**
        The response contains the `state` of the membership and the member's `role`.

        The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#create-a-team).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user-legacy
        """

        from ..models import BasicError, TeamMembership

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """DEPRECATED teams/get-membership-for-user-legacy

        GET /teams/{team_id}/memberships/{username}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user) endpoint.

        Team members will include the members of child teams.

        To get a user's membership with a team, the team must be visible to the authenticated user.

        **Note:**
        The response contains the `state` of the membership and the member's `role`.

        The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#create-a-team).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#get-team-membership-for-a-user-legacy
        """

        from ..models import BasicError, TeamMembership

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    @overload
    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """DEPRECATED teams/add-or-update-membership-for-user-legacy

        PUT /teams/{team_id}/memberships/{username}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user) endpoint.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.

        If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user-legacy
        """

        from ..models import (
            BasicError,
            TeamMembership,
            TeamsTeamIdMembershipsUsernamePutBody,
        )

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    @overload
    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """DEPRECATED teams/add-or-update-membership-for-user-legacy

        PUT /teams/{team_id}/memberships/{username}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user) endpoint.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.

        If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#add-or-update-team-membership-for-a-user-legacy
        """

        from ..models import (
            BasicError,
            TeamMembership,
            TeamsTeamIdMembershipsUsernamePutBody,
        )

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    def remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-membership-for-user-legacy

        DELETE /teams/{team_id}/memberships/{username}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user) endpoint.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user-legacy
        """

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-membership-for-user-legacy

        DELETE /teams/{team_id}/memberships/{username}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user) endpoint.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.

        > [!NOTE]
        > When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub Enterprise Cloud team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub Enterprise Cloud](https://docs.github.com/enterprise-cloud@latest//articles/synchronizing-teams-between-your-identity-provider-and-github/)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/members#remove-team-membership-for-a-user-legacy
        """

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_projects_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamProject], list[TeamProjectType]]:
        """DEPRECATED teams/list-projects-legacy

        GET /teams/{team_id}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-projects-legacy
        """

        from ..models import BasicError, TeamProject

        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_projects_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamProject], list[TeamProjectType]]:
        """DEPRECATED teams/list-projects-legacy

        GET /teams/{team_id}/projects

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-projects-legacy
        """

        from ..models import BasicError, TeamProject

        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamProject, TeamProjectType]:
        """DEPRECATED teams/check-permissions-for-project-legacy

        GET /teams/{team_id}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-project-legacy
        """

        from ..models import TeamProject

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamProject, TeamProjectType]:
        """DEPRECATED teams/check-permissions-for-project-legacy

        GET /teams/{team_id}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-project-legacy
        """

        from ..models import TeamProject

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    @overload
    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED teams/add-or-update-project-permissions-legacy

        PUT /teams/{team_id}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-project-permissions-legacy
        """

        from ..models import (
            BasicError,
            TeamsTeamIdProjectsProjectIdPutBody,
            TeamsTeamIdProjectsProjectIdPutResponse403,
            ValidationError,
        )

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdProjectsProjectIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED teams/add-or-update-project-permissions-legacy

        PUT /teams/{team_id}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-project-permissions-legacy
        """

        from ..models import (
            BasicError,
            TeamsTeamIdProjectsProjectIdPutBody,
            TeamsTeamIdProjectsProjectIdPutResponse403,
            ValidationError,
        )

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdProjectsProjectIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-project-legacy

        DELETE /teams/{team_id}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-project-from-a-team-legacy
        """

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-project-legacy

        DELETE /teams/{team_id}/projects/{project_id}

        > [!WARNING]
        > **Closing down notice:** Projects (classic) is being deprecated in favor of the new Projects experience.
        > See the [changelog](https://github.blog/changelog/2024-05-23-sunset-notice-projects-classic/) for more information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-project-from-a-team-legacy
        """

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_repos_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """DEPRECATED teams/list-repos-legacy

        GET /teams/{team_id}/repos

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories) endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories-legacy
        """

        from ..models import BasicError, MinimalRepository

        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """DEPRECATED teams/list-repos-legacy

        GET /teams/{team_id}/repos

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories) endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-team-repositories-legacy
        """

        from ..models import BasicError, MinimalRepository

        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamRepository, TeamRepositoryType]:
        """DEPRECATED teams/check-permissions-for-repo-legacy

        GET /teams/{team_id}/repos/{owner}/{repo}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository) endpoint.

        > [!NOTE]
        > Repositories inherited through a parent team will also be checked.

        You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `Accept` header:

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository-legacy
        """

        from ..models import TeamRepository

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[TeamRepository, TeamRepositoryType]:
        """DEPRECATED teams/check-permissions-for-repo-legacy

        GET /teams/{team_id}/repos/{owner}/{repo}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository) endpoint.

        > [!NOTE]
        > Repositories inherited through a parent team will also be checked.

        You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/enterprise-cloud@latest//rest/using-the-rest-api/getting-started-with-the-rest-api#media-types/) via the `Accept` header:

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#check-team-permissions-for-a-repository-legacy
        """

        from ..models import TeamRepository

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    @overload
    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
    ) -> Response: ...

    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED teams/add-or-update-repo-permissions-legacy

        PUT /teams/{team_id}/repos/{owner}/{repo}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions)" endpoint.

        To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.

        Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions-legacy
        """

        from ..models import (
            BasicError,
            TeamsTeamIdReposOwnerRepoPutBody,
            ValidationError,
        )

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """DEPRECATED teams/add-or-update-repo-permissions-legacy

        PUT /teams/{team_id}/repos/{owner}/{repo}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions)" endpoint.

        To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.

        Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#add-or-update-team-repository-permissions-legacy
        """

        from ..models import (
            BasicError,
            TeamsTeamIdReposOwnerRepoPutBody,
            ValidationError,
        )

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-repo-legacy

        DELETE /teams/{team_id}/repos/{owner}/{repo}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team) endpoint.

        If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team-legacy
        """

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """DEPRECATED teams/remove-repo-legacy

        DELETE /teams/{team_id}/repos/{owner}/{repo}

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team) endpoint.

        If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#remove-a-repository-from-a-team-legacy
        """

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_idp_groups_for_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GroupMapping, GroupMappingType]:
        """DEPRECATED teams/list-idp-groups-for-legacy

        GET /teams/{team_id}/team-sync/group-mappings

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List IdP groups for a team`](https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team) endpoint.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        List IdP groups connected to a team on GitHub Enterprise Cloud.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team-legacy
        """

        from ..models import BasicError, GroupMapping

        url = f"/teams/{team_id}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GroupMapping,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_idp_groups_for_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GroupMapping, GroupMappingType]:
        """DEPRECATED teams/list-idp-groups-for-legacy

        GET /teams/{team_id}/team-sync/group-mappings

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List IdP groups for a team`](https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team) endpoint.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        List IdP groups connected to a team on GitHub Enterprise Cloud.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#list-idp-groups-for-a-team-legacy
        """

        from ..models import BasicError, GroupMapping

        url = f"/teams/{team_id}/team-sync/group-mappings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GroupMapping,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdTeamSyncGroupMappingsPatchBodyType,
    ) -> Response[GroupMapping, GroupMappingType]: ...

    @overload
    def create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        groups: list[TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType],
        synced_at: Missing[str] = UNSET,
    ) -> Response[GroupMapping, GroupMappingType]: ...

    def create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdTeamSyncGroupMappingsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GroupMapping, GroupMappingType]:
        """DEPRECATED teams/create-or-update-idp-group-connections-legacy

        PATCH /teams/{team_id}/team-sync/group-mappings

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create or update IdP group connections`](https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections) endpoint.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections-legacy
        """

        from ..models import (
            BasicError,
            GroupMapping,
            TeamsTeamIdTeamSyncGroupMappingsPatchBody,
            ValidationError,
        )

        url = f"/teams/{team_id}/team-sync/group-mappings"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdTeamSyncGroupMappingsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: TeamsTeamIdTeamSyncGroupMappingsPatchBodyType,
    ) -> Response[GroupMapping, GroupMappingType]: ...

    @overload
    async def async_create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        groups: list[TeamsTeamIdTeamSyncGroupMappingsPatchBodyPropGroupsItemsType],
        synced_at: Missing[str] = UNSET,
    ) -> Response[GroupMapping, GroupMappingType]: ...

    async def async_create_or_update_idp_group_connections_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[TeamsTeamIdTeamSyncGroupMappingsPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[GroupMapping, GroupMappingType]:
        """DEPRECATED teams/create-or-update-idp-group-connections-legacy

        PATCH /teams/{team_id}/team-sync/group-mappings

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create or update IdP group connections`](https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections) endpoint.

        Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/enterprise-cloud@latest//github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/team-sync#create-or-update-idp-group-connections-legacy
        """

        from ..models import (
            BasicError,
            GroupMapping,
            TeamsTeamIdTeamSyncGroupMappingsPatchBody,
            ValidationError,
        )

        url = f"/teams/{team_id}/team-sync/group-mappings"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdTeamSyncGroupMappingsPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GroupMapping,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_child_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """DEPRECATED teams/list-child-legacy

        GET /teams/{team_id}/teams

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams) endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams-legacy
        """

        from ..models import BasicError, Team, ValidationError

        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_child_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """DEPRECATED teams/list-child-legacy

        GET /teams/{team_id}/teams

        > [!WARNING]
        > **Endpoint closing down notice:** This endpoint route is closing down and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams) endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-child-teams-legacy
        """

        from ..models import BasicError, Team, ValidationError

        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamFull], list[TeamFullType]]:
        """teams/list-for-authenticated-user

        GET /user/teams

        List all of the teams across all of the organizations to which the authenticated
        user belongs.

        OAuth app tokens and personal access tokens (classic) need the `user`, `repo`, or `read:org` scope to use this endpoint.

        When using a fine-grained personal access token, the resource owner of the token must be a single organization, and the response will only include the teams from that organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-teams-for-the-authenticated-user
        """

        from ..models import BasicError, TeamFull

        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TeamFull], list[TeamFullType]]:
        """teams/list-for-authenticated-user

        GET /user/teams

        List all of the teams across all of the organizations to which the authenticated
        user belongs.

        OAuth app tokens and personal access tokens (classic) need the `user`, `repo`, or `read:org` scope to use this endpoint.

        When using a fine-grained personal access token, the resource owner of the token must be a single organization, and the response will only include the teams from that organization.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/teams/teams#list-teams-for-the-authenticated-user
        """

        from ..models import BasicError, TeamFull

        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )
