"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        CodeSecurityConfiguration,
        CodeSecurityConfigurationForRepository,
        CodeSecurityConfigurationRepositories,
        CodeSecurityDefaultConfigurationsItems,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
    )
    from ..types import (
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
        CodeScanningDefaultSetupOptionsType,
        CodeSecurityConfigurationForRepositoryType,
        CodeSecurityConfigurationRepositoriesType,
        CodeSecurityConfigurationType,
        CodeSecurityDefaultConfigurationsItemsType,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdAttachPostBodyType,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBodyPropDependencyGraphAutosubmitActionOptionsType,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBodyType,
        EnterprisesEnterpriseCodeSecurityConfigurationsPostBodyPropDependencyGraphAutosubmitActionOptionsType,
        EnterprisesEnterpriseCodeSecurityConfigurationsPostBodyType,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdAttachPostBodyType,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyPropDependencyGraphAutosubmitActionOptionsType,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyPropSecretScanningDelegatedBypassOptionsType,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyType,
        OrgsOrgCodeSecurityConfigurationsDetachDeleteBodyType,
        OrgsOrgCodeSecurityConfigurationsPostBodyPropDependencyGraphAutosubmitActionOptionsType,
        OrgsOrgCodeSecurityConfigurationsPostBodyPropSecretScanningDelegatedBypassOptionsType,
        OrgsOrgCodeSecurityConfigurationsPostBodyType,
    )


class CodeSecurityClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_configurations_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeSecurityConfiguration], list[CodeSecurityConfigurationType]]:
        """code-security/get-configurations-for-enterprise

        GET /enterprises/{enterprise}/code-security/configurations

        Lists all code security configurations available in an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-code-security-configurations-for-an-enterprise
        """

        from ..models import BasicError, CodeSecurityConfiguration

        url = f"/enterprises/{enterprise}/code-security/configurations"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityConfiguration],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_configurations_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeSecurityConfiguration], list[CodeSecurityConfigurationType]]:
        """code-security/get-configurations-for-enterprise

        GET /enterprises/{enterprise}/code-security/configurations

        Lists all code security configurations available in an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-code-security-configurations-for-an-enterprise
        """

        from ..models import BasicError, CodeSecurityConfiguration

        url = f"/enterprises/{enterprise}/code-security/configurations"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityConfiguration],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseCodeSecurityConfigurationsPostBodyType,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    @overload
    def create_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: str,
        advanced_security: Missing[
            Literal["enabled", "disabled", "code_security", "secret_protection"]
        ] = UNSET,
        dependency_graph: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependency_graph_autosubmit_action: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        dependency_graph_autosubmit_action_options: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsPostBodyPropDependencyGraphAutosubmitActionOptionsType
        ] = UNSET,
        dependabot_alerts: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependabot_security_updates: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup_options: Missing[
            Union[CodeScanningDefaultSetupOptionsType, None]
        ] = UNSET,
        code_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        secret_scanning_push_protection: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_validity_checks: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_non_provider_patterns: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_generic_secrets: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        private_vulnerability_reporting: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        enforcement: Missing[Literal["enforced", "unenforced"]] = UNSET,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    def create_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/create-configuration-for-enterprise

        POST /enterprises/{enterprise}/code-security/configurations

        Creates a code security configuration in an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#create-a-code-security-configuration-for-an-enterprise
        """

        from ..models import (
            BasicError,
            CodeSecurityConfiguration,
            EnterprisesEnterpriseCodeSecurityConfigurationsPostBody,
        )

        url = f"/enterprises/{enterprise}/code-security/configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityConfigurationsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseCodeSecurityConfigurationsPostBodyType,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    @overload
    async def async_create_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: str,
        advanced_security: Missing[
            Literal["enabled", "disabled", "code_security", "secret_protection"]
        ] = UNSET,
        dependency_graph: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependency_graph_autosubmit_action: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        dependency_graph_autosubmit_action_options: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsPostBodyPropDependencyGraphAutosubmitActionOptionsType
        ] = UNSET,
        dependabot_alerts: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependabot_security_updates: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup_options: Missing[
            Union[CodeScanningDefaultSetupOptionsType, None]
        ] = UNSET,
        code_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        secret_scanning_push_protection: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_validity_checks: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_non_provider_patterns: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_generic_secrets: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        private_vulnerability_reporting: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        enforcement: Missing[Literal["enforced", "unenforced"]] = UNSET,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    async def async_create_configuration_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/create-configuration-for-enterprise

        POST /enterprises/{enterprise}/code-security/configurations

        Creates a code security configuration in an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#create-a-code-security-configuration-for-an-enterprise
        """

        from ..models import (
            BasicError,
            CodeSecurityConfiguration,
            EnterprisesEnterpriseCodeSecurityConfigurationsPostBody,
        )

        url = f"/enterprises/{enterprise}/code-security/configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityConfigurationsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_default_configurations_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeSecurityDefaultConfigurationsItems],
        list[CodeSecurityDefaultConfigurationsItemsType],
    ]:
        """code-security/get-default-configurations-for-enterprise

        GET /enterprises/{enterprise}/code-security/configurations/defaults

        Lists the default code security configurations for an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-default-code-security-configurations-for-an-enterprise
        """

        from ..models import CodeSecurityDefaultConfigurationsItems

        url = f"/enterprises/{enterprise}/code-security/configurations/defaults"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityDefaultConfigurationsItems],
        )

    async def async_get_default_configurations_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeSecurityDefaultConfigurationsItems],
        list[CodeSecurityDefaultConfigurationsItemsType],
    ]:
        """code-security/get-default-configurations-for-enterprise

        GET /enterprises/{enterprise}/code-security/configurations/defaults

        Lists the default code security configurations for an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-default-code-security-configurations-for-an-enterprise
        """

        from ..models import CodeSecurityDefaultConfigurationsItems

        url = f"/enterprises/{enterprise}/code-security/configurations/defaults"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityDefaultConfigurationsItems],
        )

    def get_single_configuration_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/get-single-configuration-for-enterprise

        GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}

        Gets a code security configuration available in an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#retrieve-a-code-security-configuration-of-an-enterprise
        """

        from ..models import BasicError, CodeSecurityConfiguration

        url = (
            f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_single_configuration_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/get-single-configuration-for-enterprise

        GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}

        Gets a code security configuration available in an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#retrieve-a-code-security-configuration-of-an-enterprise
        """

        from ..models import BasicError, CodeSecurityConfiguration

        url = (
            f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_configuration_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """code-security/delete-configuration-for-enterprise

        DELETE /enterprises/{enterprise}/code-security/configurations/{configuration_id}

        Deletes a code security configuration from an enterprise.
        Repositories attached to the configuration will retain their settings but will no longer be associated with
        the configuration.

        The authenticated user must be an administrator for the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#delete-a-code-security-configuration-for-an-enterprise
        """

        from ..models import BasicError

        url = (
            f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_delete_configuration_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """code-security/delete-configuration-for-enterprise

        DELETE /enterprises/{enterprise}/code-security/configurations/{configuration_id}

        Deletes a code security configuration from an enterprise.
        Repositories attached to the configuration will retain their settings but will no longer be associated with
        the configuration.

        The authenticated user must be an administrator for the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#delete-a-code-security-configuration-for-an-enterprise
        """

        from ..models import BasicError

        url = (
            f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def update_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBodyType,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    @overload
    def update_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        advanced_security: Missing[
            Literal["enabled", "disabled", "code_security", "secret_protection"]
        ] = UNSET,
        dependency_graph: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependency_graph_autosubmit_action: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        dependency_graph_autosubmit_action_options: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBodyPropDependencyGraphAutosubmitActionOptionsType
        ] = UNSET,
        dependabot_alerts: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependabot_security_updates: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup_options: Missing[
            Union[CodeScanningDefaultSetupOptionsType, None]
        ] = UNSET,
        code_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        secret_scanning_push_protection: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_validity_checks: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_non_provider_patterns: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_generic_secrets: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        private_vulnerability_reporting: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        enforcement: Missing[Literal["enforced", "unenforced"]] = UNSET,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    def update_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/update-enterprise-configuration

        PATCH /enterprises/{enterprise}/code-security/configurations/{configuration_id}

        Updates a code security configuration in an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#update-a-custom-code-security-configuration-for-an-enterprise
        """

        from ..models import (
            BasicError,
            CodeSecurityConfiguration,
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBody,
        )

        url = (
            f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_update_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBodyType,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    @overload
    async def async_update_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        advanced_security: Missing[
            Literal["enabled", "disabled", "code_security", "secret_protection"]
        ] = UNSET,
        dependency_graph: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependency_graph_autosubmit_action: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        dependency_graph_autosubmit_action_options: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBodyPropDependencyGraphAutosubmitActionOptionsType
        ] = UNSET,
        dependabot_alerts: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependabot_security_updates: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup_options: Missing[
            Union[CodeScanningDefaultSetupOptionsType, None]
        ] = UNSET,
        code_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        secret_scanning_push_protection: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_validity_checks: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_non_provider_patterns: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_generic_secrets: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        private_vulnerability_reporting: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        enforcement: Missing[Literal["enforced", "unenforced"]] = UNSET,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    async def async_update_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/update-enterprise-configuration

        PATCH /enterprises/{enterprise}/code-security/configurations/{configuration_id}

        Updates a code security configuration in an enterprise.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#update-a-custom-code-security-configuration-for-an-enterprise
        """

        from ..models import (
            BasicError,
            CodeSecurityConfiguration,
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBody,
        )

        url = (
            f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def attach_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdAttachPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    def attach_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        scope: Literal["all", "all_without_configurations"],
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    def attach_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdAttachPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """code-security/attach-enterprise-configuration

        POST /enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach

        Attaches an enterprise code security configuration to repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.

        If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.

        The authenticated user must be an administrator for the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#attach-an-enterprise-configuration-to-repositories
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdAttachPostBody,
        )

        url = f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdAttachPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_attach_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdAttachPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    async def async_attach_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        scope: Literal["all", "all_without_configurations"],
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    async def async_attach_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdAttachPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """code-security/attach-enterprise-configuration

        POST /enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach

        Attaches an enterprise code security configuration to repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.

        If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.

        The authenticated user must be an administrator for the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#attach-an-enterprise-configuration-to-repositories
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdAttachPostBody,
        )

        url = f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}/attach"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdAttachPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def set_configuration_as_default_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]: ...

    @overload
    def set_configuration_as_default_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        default_for_new_repos: Missing[
            Literal["all", "none", "private_and_internal", "public"]
        ] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]: ...

    def set_configuration_as_default_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]:
        """code-security/set-configuration-as-default-for-enterprise

        PUT /enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults

        Sets a code security configuration as a default to be applied to new repositories in your enterprise.

        This configuration will be applied by default to the matching repository type when created, but only for organizations within the enterprise that do not already have a default code security configuration set.

        The authenticated user must be an administrator for the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutBody,
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        )

        url = f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_set_configuration_as_default_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]: ...

    @overload
    async def async_set_configuration_as_default_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        default_for_new_repos: Missing[
            Literal["all", "none", "private_and_internal", "public"]
        ] = UNSET,
    ) -> Response[
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]: ...

    async def async_set_configuration_as_default_for_enterprise(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]:
        """code-security/set-configuration-as-default-for-enterprise

        PUT /enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults

        Sets a code security configuration as a default to be applied to new repositories in your enterprise.

        This configuration will be applied by default to the matching repository type when created, but only for organizations within the enterprise that do not already have a default code security configuration set.

        The authenticated user must be an administrator for the enterprise to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `admin:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutBody,
            EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        )

        url = f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}/defaults"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_repositories_for_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        status: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeSecurityConfigurationRepositories],
        list[CodeSecurityConfigurationRepositoriesType],
    ]:
        """code-security/get-repositories-for-enterprise-configuration

        GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories

        Lists the repositories associated with an enterprise code security configuration in an organization.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-repositories-associated-with-an-enterprise-code-security-configuration
        """

        from ..models import BasicError, CodeSecurityConfigurationRepositories

        url = f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "status": status,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityConfigurationRepositories],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_repositories_for_enterprise_configuration(
        self,
        enterprise: str,
        configuration_id: int,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        status: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeSecurityConfigurationRepositories],
        list[CodeSecurityConfigurationRepositoriesType],
    ]:
        """code-security/get-repositories-for-enterprise-configuration

        GET /enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories

        Lists the repositories associated with an enterprise code security configuration in an organization.

        The authenticated user must be an administrator of the enterprise in order to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:enterprise` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-repositories-associated-with-an-enterprise-code-security-configuration
        """

        from ..models import BasicError, CodeSecurityConfigurationRepositories

        url = f"/enterprises/{enterprise}/code-security/configurations/{configuration_id}/repositories"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "status": status,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityConfigurationRepositories],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_configurations_for_org(
        self,
        org: str,
        *,
        target_type: Missing[Literal["global", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeSecurityConfiguration], list[CodeSecurityConfigurationType]]:
        """code-security/get-configurations-for-org

        GET /orgs/{org}/code-security/configurations

        Lists all code security configurations available in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-code-security-configurations-for-an-organization
        """

        from ..models import BasicError, CodeSecurityConfiguration

        url = f"/orgs/{org}/code-security/configurations"

        params = {
            "target_type": target_type,
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityConfiguration],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_configurations_for_org(
        self,
        org: str,
        *,
        target_type: Missing[Literal["global", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeSecurityConfiguration], list[CodeSecurityConfigurationType]]:
        """code-security/get-configurations-for-org

        GET /orgs/{org}/code-security/configurations

        Lists all code security configurations available in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-code-security-configurations-for-an-organization
        """

        from ..models import BasicError, CodeSecurityConfiguration

        url = f"/orgs/{org}/code-security/configurations"

        params = {
            "target_type": target_type,
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityConfiguration],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_configuration(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsPostBodyType,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    @overload
    def create_configuration(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: str,
        advanced_security: Missing[
            Literal["enabled", "disabled", "code_security", "secret_protection"]
        ] = UNSET,
        dependency_graph: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependency_graph_autosubmit_action: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        dependency_graph_autosubmit_action_options: Missing[
            OrgsOrgCodeSecurityConfigurationsPostBodyPropDependencyGraphAutosubmitActionOptionsType
        ] = UNSET,
        dependabot_alerts: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependabot_security_updates: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup_options: Missing[
            Union[CodeScanningDefaultSetupOptionsType, None]
        ] = UNSET,
        code_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        secret_scanning_push_protection: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_bypass: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_bypass_options: Missing[
            OrgsOrgCodeSecurityConfigurationsPostBodyPropSecretScanningDelegatedBypassOptionsType
        ] = UNSET,
        secret_scanning_validity_checks: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_non_provider_patterns: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_generic_secrets: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        private_vulnerability_reporting: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        enforcement: Missing[Literal["enforced", "unenforced"]] = UNSET,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    def create_configuration(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgCodeSecurityConfigurationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/create-configuration

        POST /orgs/{org}/code-security/configurations

        Creates a code security configuration in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#create-a-code-security-configuration
        """

        from ..models import (
            CodeSecurityConfiguration,
            OrgsOrgCodeSecurityConfigurationsPostBody,
        )

        url = f"/orgs/{org}/code-security/configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCodeSecurityConfigurationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
        )

    @overload
    async def async_create_configuration(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsPostBodyType,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    @overload
    async def async_create_configuration(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: str,
        advanced_security: Missing[
            Literal["enabled", "disabled", "code_security", "secret_protection"]
        ] = UNSET,
        dependency_graph: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependency_graph_autosubmit_action: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        dependency_graph_autosubmit_action_options: Missing[
            OrgsOrgCodeSecurityConfigurationsPostBodyPropDependencyGraphAutosubmitActionOptionsType
        ] = UNSET,
        dependabot_alerts: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependabot_security_updates: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup_options: Missing[
            Union[CodeScanningDefaultSetupOptionsType, None]
        ] = UNSET,
        code_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        secret_scanning_push_protection: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_bypass: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_bypass_options: Missing[
            OrgsOrgCodeSecurityConfigurationsPostBodyPropSecretScanningDelegatedBypassOptionsType
        ] = UNSET,
        secret_scanning_validity_checks: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_non_provider_patterns: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_generic_secrets: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        private_vulnerability_reporting: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        enforcement: Missing[Literal["enforced", "unenforced"]] = UNSET,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    async def async_create_configuration(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgCodeSecurityConfigurationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/create-configuration

        POST /orgs/{org}/code-security/configurations

        Creates a code security configuration in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#create-a-code-security-configuration
        """

        from ..models import (
            CodeSecurityConfiguration,
            OrgsOrgCodeSecurityConfigurationsPostBody,
        )

        url = f"/orgs/{org}/code-security/configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgCodeSecurityConfigurationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
        )

    def get_default_configurations(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeSecurityDefaultConfigurationsItems],
        list[CodeSecurityDefaultConfigurationsItemsType],
    ]:
        """code-security/get-default-configurations

        GET /orgs/{org}/code-security/configurations/defaults

        Lists the default code security configurations for an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-default-code-security-configurations
        """

        from ..models import BasicError, CodeSecurityDefaultConfigurationsItems

        url = f"/orgs/{org}/code-security/configurations/defaults"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityDefaultConfigurationsItems],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_default_configurations(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeSecurityDefaultConfigurationsItems],
        list[CodeSecurityDefaultConfigurationsItemsType],
    ]:
        """code-security/get-default-configurations

        GET /orgs/{org}/code-security/configurations/defaults

        Lists the default code security configurations for an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-default-code-security-configurations
        """

        from ..models import BasicError, CodeSecurityDefaultConfigurationsItems

        url = f"/orgs/{org}/code-security/configurations/defaults"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityDefaultConfigurationsItems],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def detach_configuration(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsDetachDeleteBodyType,
    ) -> Response: ...

    @overload
    def detach_configuration(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response: ...

    def detach_configuration(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgCodeSecurityConfigurationsDetachDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """code-security/detach-configuration

        DELETE /orgs/{org}/code-security/configurations/detach

        Detach code security configuration(s) from a set of repositories.
        Repositories will retain their settings but will no longer be associated with the configuration.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#detach-configurations-from-repositories
        """

        from ..models import (
            BasicError,
            OrgsOrgCodeSecurityConfigurationsDetachDeleteBody,
        )

        url = f"/orgs/{org}/code-security/configurations/detach"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodeSecurityConfigurationsDetachDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_detach_configuration(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsDetachDeleteBodyType,
    ) -> Response: ...

    @overload
    async def async_detach_configuration(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response: ...

    async def async_detach_configuration(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgCodeSecurityConfigurationsDetachDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """code-security/detach-configuration

        DELETE /orgs/{org}/code-security/configurations/detach

        Detach code security configuration(s) from a set of repositories.
        Repositories will retain their settings but will no longer be associated with the configuration.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#detach-configurations-from-repositories
        """

        from ..models import (
            BasicError,
            OrgsOrgCodeSecurityConfigurationsDetachDeleteBody,
        )

        url = f"/orgs/{org}/code-security/configurations/detach"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodeSecurityConfigurationsDetachDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def get_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/get-configuration

        GET /orgs/{org}/code-security/configurations/{configuration_id}

        Gets a code security configuration available in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-a-code-security-configuration
        """

        from ..models import BasicError, CodeSecurityConfiguration

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/get-configuration

        GET /orgs/{org}/code-security/configurations/{configuration_id}

        Gets a code security configuration available in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-a-code-security-configuration
        """

        from ..models import BasicError, CodeSecurityConfiguration

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """code-security/delete-configuration

        DELETE /orgs/{org}/code-security/configurations/{configuration_id}

        Deletes the desired code security configuration from an organization.
        Repositories attached to the configuration will retain their settings but will no longer be associated with
        the configuration.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#delete-a-code-security-configuration
        """

        from ..models import BasicError

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_delete_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """code-security/delete-configuration

        DELETE /orgs/{org}/code-security/configurations/{configuration_id}

        Deletes the desired code security configuration from an organization.
        Repositories attached to the configuration will retain their settings but will no longer be associated with
        the configuration.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#delete-a-code-security-configuration
        """

        from ..models import BasicError

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def update_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyType,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    @overload
    def update_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        advanced_security: Missing[
            Literal["enabled", "disabled", "code_security", "secret_protection"]
        ] = UNSET,
        dependency_graph: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependency_graph_autosubmit_action: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        dependency_graph_autosubmit_action_options: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyPropDependencyGraphAutosubmitActionOptionsType
        ] = UNSET,
        dependabot_alerts: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependabot_security_updates: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup_options: Missing[
            Union[CodeScanningDefaultSetupOptionsType, None]
        ] = UNSET,
        code_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        secret_scanning_push_protection: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_bypass: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_bypass_options: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyPropSecretScanningDelegatedBypassOptionsType
        ] = UNSET,
        secret_scanning_validity_checks: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_non_provider_patterns: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_generic_secrets: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        private_vulnerability_reporting: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        enforcement: Missing[Literal["enforced", "unenforced"]] = UNSET,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    def update_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/update-configuration

        PATCH /orgs/{org}/code-security/configurations/{configuration_id}

        Updates a code security configuration in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#update-a-code-security-configuration
        """

        from ..models import (
            CodeSecurityConfiguration,
            OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBody,
        )

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
        )

    @overload
    async def async_update_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyType,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    @overload
    async def async_update_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        advanced_security: Missing[
            Literal["enabled", "disabled", "code_security", "secret_protection"]
        ] = UNSET,
        dependency_graph: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependency_graph_autosubmit_action: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        dependency_graph_autosubmit_action_options: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyPropDependencyGraphAutosubmitActionOptionsType
        ] = UNSET,
        dependabot_alerts: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        dependabot_security_updates: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        code_scanning_default_setup_options: Missing[
            Union[CodeScanningDefaultSetupOptionsType, None]
        ] = UNSET,
        code_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning: Missing[Literal["enabled", "disabled", "not_set"]] = UNSET,
        secret_scanning_push_protection: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_bypass: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_bypass_options: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyPropSecretScanningDelegatedBypassOptionsType
        ] = UNSET,
        secret_scanning_validity_checks: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_non_provider_patterns: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_generic_secrets: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        secret_scanning_delegated_alert_dismissal: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        private_vulnerability_reporting: Missing[
            Literal["enabled", "disabled", "not_set"]
        ] = UNSET,
        enforcement: Missing[Literal["enforced", "unenforced"]] = UNSET,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]: ...

    async def async_update_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[CodeSecurityConfiguration, CodeSecurityConfigurationType]:
        """code-security/update-configuration

        PATCH /orgs/{org}/code-security/configurations/{configuration_id}

        Updates a code security configuration in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#update-a-code-security-configuration
        """

        from ..models import (
            CodeSecurityConfiguration,
            OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBody,
        )

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodeSecurityConfigurationsConfigurationIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfiguration,
        )

    @overload
    def attach_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsConfigurationIdAttachPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    def attach_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        scope: Literal[
            "all",
            "all_without_configurations",
            "public",
            "private_or_internal",
            "selected",
        ],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    def attach_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdAttachPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """code-security/attach-configuration

        POST /orgs/{org}/code-security/configurations/{configuration_id}/attach

        Attach a code security configuration to a set of repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.

        If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#attach-a-configuration-to-repositories
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            OrgsOrgCodeSecurityConfigurationsConfigurationIdAttachPostBody,
        )

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}/attach"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodeSecurityConfigurationsConfigurationIdAttachPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

    @overload
    async def async_attach_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsConfigurationIdAttachPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    async def async_attach_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        scope: Literal[
            "all",
            "all_without_configurations",
            "public",
            "private_or_internal",
            "selected",
        ],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    async def async_attach_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdAttachPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """code-security/attach-configuration

        POST /orgs/{org}/code-security/configurations/{configuration_id}/attach

        Attach a code security configuration to a set of repositories. If the repositories specified are already attached to a configuration, they will be re-attached to the provided configuration.

        If insufficient GHAS licenses are available to attach the configuration to a repository, only free features will be enabled.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#attach-a-configuration-to-repositories
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            OrgsOrgCodeSecurityConfigurationsConfigurationIdAttachPostBody,
        )

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}/attach"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodeSecurityConfigurationsConfigurationIdAttachPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        )

    @overload
    def set_configuration_as_default(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType,
    ) -> Response[
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]: ...

    @overload
    def set_configuration_as_default(
        self,
        org: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        default_for_new_repos: Missing[
            Literal["all", "none", "private_and_internal", "public"]
        ] = UNSET,
    ) -> Response[
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]: ...

    def set_configuration_as_default(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]:
        """code-security/set-configuration-as-default

        PUT /orgs/{org}/code-security/configurations/{configuration_id}/defaults

        Sets a code security configuration as a default to be applied to new repositories in your organization.

        This configuration will be applied to the matching repository type (all, none, public, private and internal) by default when they are created.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutBody,
            OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        )

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}/defaults"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_set_configuration_as_default(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType,
    ) -> Response[
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]: ...

    @overload
    async def async_set_configuration_as_default(
        self,
        org: str,
        configuration_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        default_for_new_repos: Missing[
            Literal["all", "none", "private_and_internal", "public"]
        ] = UNSET,
    ) -> Response[
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]: ...

    async def async_set_configuration_as_default(
        self,
        org: str,
        configuration_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200Type,
    ]:
        """code-security/set-configuration-as-default

        PUT /orgs/{org}/code-security/configurations/{configuration_id}/defaults

        Sets a code security configuration as a default to be applied to new repositories in your organization.

        This configuration will be applied to the matching repository type (all, none, public, private and internal) by default when they are created.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#set-a-code-security-configuration-as-a-default-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutBody,
            OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
        )

        url = f"/orgs/{org}/code-security/configurations/{configuration_id}/defaults"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgCodeSecurityConfigurationsConfigurationIdDefaultsPutResponse200,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_repositories_for_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        status: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeSecurityConfigurationRepositories],
        list[CodeSecurityConfigurationRepositoriesType],
    ]:
        """code-security/get-repositories-for-configuration

        GET /orgs/{org}/code-security/configurations/{configuration_id}/repositories

        Lists the repositories associated with a code security configuration in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-repositories-associated-with-a-code-security-configuration
        """

        from ..models import BasicError, CodeSecurityConfigurationRepositories

        url = (
            f"/orgs/{org}/code-security/configurations/{configuration_id}/repositories"
        )

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "status": status,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityConfigurationRepositories],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_repositories_for_configuration(
        self,
        org: str,
        configuration_id: int,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        status: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeSecurityConfigurationRepositories],
        list[CodeSecurityConfigurationRepositoriesType],
    ]:
        """code-security/get-repositories-for-configuration

        GET /orgs/{org}/code-security/configurations/{configuration_id}/repositories

        Lists the repositories associated with a code security configuration in an organization.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `write:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-repositories-associated-with-a-code-security-configuration
        """

        from ..models import BasicError, CodeSecurityConfigurationRepositories

        url = (
            f"/orgs/{org}/code-security/configurations/{configuration_id}/repositories"
        )

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "status": status,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeSecurityConfigurationRepositories],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_configuration_for_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        CodeSecurityConfigurationForRepository,
        CodeSecurityConfigurationForRepositoryType,
    ]:
        """code-security/get-configuration-for-repository

        GET /repos/{owner}/{repo}/code-security-configuration

        Get the code security configuration that manages a repository's code security settings.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-the-code-security-configuration-associated-with-a-repository
        """

        from ..models import BasicError, CodeSecurityConfigurationForRepository

        url = f"/repos/{owner}/{repo}/code-security-configuration"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfigurationForRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_configuration_for_repository(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        CodeSecurityConfigurationForRepository,
        CodeSecurityConfigurationForRepositoryType,
    ]:
        """code-security/get-configuration-for-repository

        GET /repos/{owner}/{repo}/code-security-configuration

        Get the code security configuration that manages a repository's code security settings.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/code-security/configurations#get-the-code-security-configuration-associated-with-a-repository
        """

        from ..models import BasicError, CodeSecurityConfigurationForRepository

        url = f"/repos/{owner}/{repo}/code-security-configuration"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeSecurityConfigurationForRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )
