"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response

    from ..models import AppHookDeliveriesDeliveryIdAttemptsPostResponse202
    from ..types import (
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
        CredentialsRevokePostBodyType,
    )


class CredentialsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    @overload
    def revoke(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: CredentialsRevokePostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    def revoke(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        credentials: list[str],
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    def revoke(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[CredentialsRevokePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """credentials/revoke

        POST /credentials/revoke

        Submit a list of credentials to be revoked. This endpoint is intended to revoke credentials the caller does not own and may have found exposed on GitHub.com or elsewhere. It can also be used for credentials associated with an old user account that you no longer have access to. Credential owners will be notified of the revocation.

        This endpoint currently accepts the following credential types:
        - Personal access tokens (classic)
        - Fine-grained personal access tokens

        Revoked credentials may impact users on GitHub Free, Pro, & Team and GitHub Enterprise Cloud, and GitHub Enterprise Cloud with Enterprise Managed Users.
        GitHub cannot reactivate any credentials that have been revoked; new credentials will need to be generated.

        To prevent abuse, this API is limited to only 60 unauthenticated requests per hour and a max of 1000 tokens per API request.

        > [!NOTE]
        > Any authenticated requests will return a 403.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/credentials/revoke#revoke-a-list-of-credentials
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            CredentialsRevokePostBody,
            ValidationErrorSimple,
        )

        url = "/credentials/revoke"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CredentialsRevokePostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "422": ValidationErrorSimple,
                "500": BasicError,
            },
        )

    @overload
    async def async_revoke(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: CredentialsRevokePostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    async def async_revoke(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        credentials: list[str],
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    async def async_revoke(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[CredentialsRevokePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """credentials/revoke

        POST /credentials/revoke

        Submit a list of credentials to be revoked. This endpoint is intended to revoke credentials the caller does not own and may have found exposed on GitHub.com or elsewhere. It can also be used for credentials associated with an old user account that you no longer have access to. Credential owners will be notified of the revocation.

        This endpoint currently accepts the following credential types:
        - Personal access tokens (classic)
        - Fine-grained personal access tokens

        Revoked credentials may impact users on GitHub Free, Pro, & Team and GitHub Enterprise Cloud, and GitHub Enterprise Cloud with Enterprise Managed Users.
        GitHub cannot reactivate any credentials that have been revoked; new credentials will need to be generated.

        To prevent abuse, this API is limited to only 60 unauthenticated requests per hour and a max of 1000 tokens per API request.

        > [!NOTE]
        > Any authenticated requests will return a 403.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/credentials/revoke#revoke-a-list-of-credentials
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            CredentialsRevokePostBody,
            ValidationErrorSimple,
        )

        url = "/credentials/revoke"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CredentialsRevokePostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "422": ValidationErrorSimple,
                "500": BasicError,
            },
        )
