"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional
from weakref import ref

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import Package, PackageVersion
    from ..types import PackageType, PackageVersionType


class PackagesClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_docker_migration_conflicting_packages_for_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-docker-migration-conflicting-packages-for-organization

        GET /orgs/{org}/docker/conflicts

        Lists all packages that are in a specific organization, are readable by the requesting user, and that encountered a conflict during a Docker migration.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-list-of-conflicting-packages-during-docker-migration-for-organization
        """

        from ..models import BasicError, Package

        url = f"/orgs/{org}/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_docker_migration_conflicting_packages_for_organization(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-docker-migration-conflicting-packages-for-organization

        GET /orgs/{org}/docker/conflicts

        Lists all packages that are in a specific organization, are readable by the requesting user, and that encountered a conflict during a Docker migration.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-list-of-conflicting-packages-during-docker-migration-for-organization
        """

        from ..models import BasicError, Package

        url = f"/orgs/{org}/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_packages_for_organization(
        self,
        org: str,
        *,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-packages-for-organization

        GET /orgs/{org}/packages

        Lists packages in an organization readable by the user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-packages-for-an-organization
        """

        from ..models import BasicError, Package

        url = f"/orgs/{org}/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_packages_for_organization(
        self,
        org: str,
        *,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-packages-for-organization

        GET /orgs/{org}/packages

        Lists packages in an organization readable by the user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-packages-for-an-organization
        """

        from ..models import BasicError, Package

        url = f"/orgs/{org}/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_for_organization(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Package, PackageType]:
        """packages/get-package-for-organization

        GET /orgs/{org}/packages/{package_type}/{package_name}

        Gets a specific package in an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-for-an-organization
        """

        from ..models import Package

        url = f"/orgs/{org}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    async def async_get_package_for_organization(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Package, PackageType]:
        """packages/get-package-for-organization

        GET /orgs/{org}/packages/{package_type}/{package_name}

        Gets a specific package in an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-for-an-organization
        """

        from ..models import Package

        url = f"/orgs/{org}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    def delete_package_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-for-org

        DELETE /orgs/{org}/packages/{package_type}/{package_name}

        Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.

        The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-a-package-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-for-org

        DELETE /orgs/{org}/packages/{package_type}/{package_name}

        Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.

        The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-a-package-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        token: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-for-org

        POST /orgs/{org}/packages/{package_type}/{package_name}/restore

        Restores an entire package in an organization.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-a-package-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        token: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-for-org

        POST /orgs/{org}/packages/{package_type}/{package_name}/restore

        Restores an entire package in an organization.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-a-package-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_all_package_versions_for_package_owned_by_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PackageVersion], list[PackageVersionType]]:
        """packages/get-all-package-versions-for-package-owned-by-org

        GET /orgs/{org}/packages/{package_type}/{package_name}/versions

        Lists package versions for a package owned by an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-package-versions-for-a-package-owned-by-an-organization
        """

        from ..models import BasicError, PackageVersion

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions"

        params = {
            "page": page,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_all_package_versions_for_package_owned_by_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PackageVersion], list[PackageVersionType]]:
        """packages/get-all-package-versions-for-package-owned-by-org

        GET /orgs/{org}/packages/{package_type}/{package_name}/versions

        Lists package versions for a package owned by an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-package-versions-for-a-package-owned-by-an-organization
        """

        from ..models import BasicError, PackageVersion

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions"

        params = {
            "page": page,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_version_for_organization(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackageVersion, PackageVersionType]:
        """packages/get-package-version-for-organization

        GET /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}

        Gets a specific package version in an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-version-for-an-organization
        """

        from ..models import PackageVersion

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    async def async_get_package_version_for_organization(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackageVersion, PackageVersionType]:
        """packages/get-package-version-for-organization

        GET /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}

        Gets a specific package version in an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-version-for-an-organization
        """

        from ..models import PackageVersion

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    def delete_package_version_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-version-for-org

        DELETE /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}

        Deletes a specific package version in an organization. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.

        The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-package-version-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_version_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-version-for-org

        DELETE /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}

        Deletes a specific package version in an organization. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.

        The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-package-version-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_version_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-version-for-org

        POST /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore

        Restores a specific package version in an organization.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-package-version-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_version_for_org(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        org: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-version-for-org

        POST /orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore

        Restores a specific package version in an organization.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        The authenticated user must have admin permissions in the organization to use this endpoint. If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must also have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-package-version-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_docker_migration_conflicting_packages_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-docker-migration-conflicting-packages-for-authenticated-user

        GET /user/docker/conflicts

        Lists all packages that are owned by the authenticated user within the user's namespace, and that encountered a conflict during a Docker migration.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-list-of-conflicting-packages-during-docker-migration-for-authenticated-user
        """

        from ..models import Package

        url = "/user/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Package],
        )

    async def async_list_docker_migration_conflicting_packages_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-docker-migration-conflicting-packages-for-authenticated-user

        GET /user/docker/conflicts

        Lists all packages that are owned by the authenticated user within the user's namespace, and that encountered a conflict during a Docker migration.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-list-of-conflicting-packages-during-docker-migration-for-authenticated-user
        """

        from ..models import Package

        url = "/user/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Package],
        )

    def list_packages_for_authenticated_user(
        self,
        *,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-packages-for-authenticated-user

        GET /user/packages

        Lists packages owned by the authenticated user within the user's namespace.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-packages-for-the-authenticated-users-namespace
        """

        from ..models import Package

        url = "/user/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={},
        )

    async def async_list_packages_for_authenticated_user(
        self,
        *,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-packages-for-authenticated-user

        GET /user/packages

        Lists packages owned by the authenticated user within the user's namespace.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-packages-for-the-authenticated-users-namespace
        """

        from ..models import Package

        url = "/user/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={},
        )

    def get_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Package, PackageType]:
        """packages/get-package-for-authenticated-user

        GET /user/packages/{package_type}/{package_name}

        Gets a specific package for a package owned by the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-for-the-authenticated-user
        """

        from ..models import Package

        url = f"/user/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    async def async_get_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Package, PackageType]:
        """packages/get-package-for-authenticated-user

        GET /user/packages/{package_type}/{package_name}

        Gets a specific package for a package owned by the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-for-the-authenticated-user
        """

        from ..models import Package

        url = f"/user/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    def delete_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-for-authenticated-user

        DELETE /user/packages/{package_type}/{package_name}

        Deletes a package owned by the authenticated user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-a-package-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-for-authenticated-user

        DELETE /user/packages/{package_type}/{package_name}

        Deletes a package owned by the authenticated user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-a-package-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        token: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-for-authenticated-user

        POST /user/packages/{package_type}/{package_name}/restore

        Restores a package owned by the authenticated user.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-a-package-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        token: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-for-authenticated-user

        POST /user/packages/{package_type}/{package_name}/restore

        Restores a package owned by the authenticated user.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-a-package-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_all_package_versions_for_package_owned_by_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PackageVersion], list[PackageVersionType]]:
        """packages/get-all-package-versions-for-package-owned-by-authenticated-user

        GET /user/packages/{package_type}/{package_name}/versions

        Lists package versions for a package owned by the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-package-versions-for-a-package-owned-by-the-authenticated-user
        """

        from ..models import BasicError, PackageVersion

        url = f"/user/packages/{package_type}/{package_name}/versions"

        params = {
            "page": page,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_all_package_versions_for_package_owned_by_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        state: Missing[Literal["active", "deleted"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PackageVersion], list[PackageVersionType]]:
        """packages/get-all-package-versions-for-package-owned-by-authenticated-user

        GET /user/packages/{package_type}/{package_name}/versions

        Lists package versions for a package owned by the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-package-versions-for-a-package-owned-by-the-authenticated-user
        """

        from ..models import BasicError, PackageVersion

        url = f"/user/packages/{package_type}/{package_name}/versions"

        params = {
            "page": page,
            "per_page": per_page,
            "state": state,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackageVersion, PackageVersionType]:
        """packages/get-package-version-for-authenticated-user

        GET /user/packages/{package_type}/{package_name}/versions/{package_version_id}

        Gets a specific package version for a package owned by the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-version-for-the-authenticated-user
        """

        from ..models import PackageVersion

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    async def async_get_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackageVersion, PackageVersionType]:
        """packages/get-package-version-for-authenticated-user

        GET /user/packages/{package_type}/{package_name}/versions/{package_version_id}

        Gets a specific package version for a package owned by the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-version-for-the-authenticated-user
        """

        from ..models import PackageVersion

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    def delete_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-version-for-authenticated-user

        DELETE /user/packages/{package_type}/{package_name}/versions/{package_version_id}

        Deletes a specific package version for a package owned by the authenticated user.  If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.

        The authenticated user must have admin permissions in the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-a-package-version-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-version-for-authenticated-user

        DELETE /user/packages/{package_type}/{package_name}/versions/{package_version_id}

        Deletes a specific package version for a package owned by the authenticated user.  If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.

        The authenticated user must have admin permissions in the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-a-package-version-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-version-for-authenticated-user

        POST /user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore

        Restores a package version owned by the authenticated user.

        You can restore a deleted package version under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-a-package-version-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_version_for_authenticated_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-version-for-authenticated-user

        POST /user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore

        Restores a package version owned by the authenticated user.

        You can restore a deleted package version under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-a-package-version-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_docker_migration_conflicting_packages_for_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-docker-migration-conflicting-packages-for-user

        GET /users/{username}/docker/conflicts

        Lists all packages that are in a specific user's namespace, that the requesting user has access to, and that encountered a conflict during Docker migration.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-list-of-conflicting-packages-during-docker-migration-for-user
        """

        from ..models import BasicError, Package

        url = f"/users/{username}/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_docker_migration_conflicting_packages_for_user(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-docker-migration-conflicting-packages-for-user

        GET /users/{username}/docker/conflicts

        Lists all packages that are in a specific user's namespace, that the requesting user has access to, and that encountered a conflict during Docker migration.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-list-of-conflicting-packages-during-docker-migration-for-user
        """

        from ..models import BasicError, Package

        url = f"/users/{username}/docker/conflicts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_packages_for_user(
        self,
        username: str,
        *,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-packages-for-user

        GET /users/{username}/packages

        Lists all packages in a user's namespace for which the requesting user has access.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-packages-for-a-user
        """

        from ..models import BasicError, Package

        url = f"/users/{username}/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_packages_for_user(
        self,
        username: str,
        *,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Package], list[PackageType]]:
        """packages/list-packages-for-user

        GET /users/{username}/packages

        Lists all packages in a user's namespace for which the requesting user has access.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-packages-for-a-user
        """

        from ..models import BasicError, Package

        url = f"/users/{username}/packages"

        params = {
            "package_type": package_type,
            "visibility": visibility,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Package],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Package, PackageType]:
        """packages/get-package-for-user

        GET /users/{username}/packages/{package_type}/{package_name}

        Gets a specific package metadata for a public package owned by a user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-for-a-user
        """

        from ..models import Package

        url = f"/users/{username}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    async def async_get_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Package, PackageType]:
        """packages/get-package-for-user

        GET /users/{username}/packages/{package_type}/{package_name}

        Gets a specific package metadata for a public package owned by a user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-for-a-user
        """

        from ..models import Package

        url = f"/users/{username}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Package,
        )

    def delete_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-for-user

        DELETE /users/{username}/packages/{package_type}/{package_name}

        Deletes an entire package for a user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.

        If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-a-package-for-a-user
        """

        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-for-user

        DELETE /users/{username}/packages/{package_type}/{package_name}

        Deletes an entire package for a user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.

        If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-a-package-for-a-user
        """

        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        token: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-for-user

        POST /users/{username}/packages/{package_type}/{package_name}/restore

        Restores an entire package for a user.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-a-package-for-a-user
        """

        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        token: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-for-user

        POST /users/{username}/packages/{package_type}/{package_name}/restore

        Restores an entire package for a user.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-a-package-for-a-user
        """

        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/restore"

        params = {
            "token": token,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_all_package_versions_for_package_owned_by_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PackageVersion], list[PackageVersionType]]:
        """packages/get-all-package-versions-for-package-owned-by-user

        GET /users/{username}/packages/{package_type}/{package_name}/versions

        Lists package versions for a public package owned by a specified user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-package-versions-for-a-package-owned-by-a-user
        """

        from ..models import BasicError, PackageVersion

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_all_package_versions_for_package_owned_by_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PackageVersion], list[PackageVersionType]]:
        """packages/get-all-package-versions-for-package-owned-by-user

        GET /users/{username}/packages/{package_type}/{package_name}/versions

        Lists package versions for a public package owned by a specified user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#list-package-versions-for-a-package-owned-by-a-user
        """

        from ..models import BasicError, PackageVersion

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[PackageVersion],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackageVersion, PackageVersionType]:
        """packages/get-package-version-for-user

        GET /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}

        Gets a specific package version for a public package owned by a specified user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-version-for-a-user
        """

        from ..models import PackageVersion

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    async def async_get_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        package_version_id: int,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PackageVersion, PackageVersionType]:
        """packages/get-package-version-for-user

        GET /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}

        Gets a specific package version for a public package owned by a specified user.

        OAuth app tokens and personal access tokens (classic) need the `read:packages` scope to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#get-a-package-version-for-a-user
        """

        from ..models import PackageVersion

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackageVersion,
        )

    def delete_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-version-for-user

        DELETE /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}

        Deletes a specific package version for a user. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.

        If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-package-version-for-a-user
        """

        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/delete-package-version-for-user

        DELETE /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}

        Deletes a specific package version for a user. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.

        If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `delete:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#delete-package-version-for-a-user
        """

        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def restore_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-version-for-user

        POST /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore

        Restores a specific package version for a user.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-package-version-for-a-user
        """

        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_restore_package_version_for_user(
        self,
        package_type: Literal[
            "npm", "maven", "rubygems", "docker", "nuget", "container"
        ],
        package_name: str,
        username: str,
        package_version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """packages/restore-package-version-for-user

        POST /users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore

        Restores a specific package version for a user.

        You can restore a deleted package under the following conditions:
          - The package was deleted within the last 30 days.
          - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.

        If the `package_type` belongs to a GitHub Packages registry that supports granular permissions, the authenticated user must have admin permissions to the package. For the list of these registries, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#granular-permissions-for-userorganization-scoped-packages)."

        OAuth app tokens and personal access tokens (classic) need the `read:packages` and `write:packages` scopes to use this endpoint. For more information, see "[About permissions for GitHub Packages](https://docs.github.com/enterprise-cloud@latest//packages/learn-github-packages/about-permissions-for-github-packages#permissions-for-repository-scoped-packages)."

        See also: https://docs.github.com/enterprise-cloud@latest//rest/packages/packages#restore-package-version-for-a-user
        """

        from ..models import BasicError

        url = f"/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )
