"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        NetworkConfiguration,
        NetworkSettings,
        OrgsOrgSettingsNetworkConfigurationsGetResponse200,
    )
    from ..types import (
        NetworkConfigurationType,
        NetworkSettingsType,
        OrgsOrgSettingsNetworkConfigurationsGetResponse200Type,
        OrgsOrgSettingsNetworkConfigurationsNetworkConfigurationIdPatchBodyType,
        OrgsOrgSettingsNetworkConfigurationsPostBodyType,
    )


class HostedComputeClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_network_configurations_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        OrgsOrgSettingsNetworkConfigurationsGetResponse200,
        OrgsOrgSettingsNetworkConfigurationsGetResponse200Type,
    ]:
        """hosted-compute/list-network-configurations-for-org

        GET /orgs/{org}/settings/network-configurations

        Lists all hosted compute network configurations configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#list-hosted-compute-network-configurations-for-an-organization
        """

        from ..models import OrgsOrgSettingsNetworkConfigurationsGetResponse200

        url = f"/orgs/{org}/settings/network-configurations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgSettingsNetworkConfigurationsGetResponse200,
        )

    async def async_list_network_configurations_for_org(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        OrgsOrgSettingsNetworkConfigurationsGetResponse200,
        OrgsOrgSettingsNetworkConfigurationsGetResponse200Type,
    ]:
        """hosted-compute/list-network-configurations-for-org

        GET /orgs/{org}/settings/network-configurations

        Lists all hosted compute network configurations configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#list-hosted-compute-network-configurations-for-an-organization
        """

        from ..models import OrgsOrgSettingsNetworkConfigurationsGetResponse200

        url = f"/orgs/{org}/settings/network-configurations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgSettingsNetworkConfigurationsGetResponse200,
        )

    @overload
    def create_network_configuration_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgSettingsNetworkConfigurationsPostBodyType,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    @overload
    def create_network_configuration_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        compute_service: Missing[Literal["none", "actions"]] = UNSET,
        network_settings_ids: list[str],
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    def create_network_configuration_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgSettingsNetworkConfigurationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/create-network-configuration-for-org

        POST /orgs/{org}/settings/network-configurations

        Creates a hosted compute network configuration for an organization.

        OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#create-a-hosted-compute-network-configuration-for-an-organization
        """

        from ..models import (
            NetworkConfiguration,
            OrgsOrgSettingsNetworkConfigurationsPostBody,
        )

        url = f"/orgs/{org}/settings/network-configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgSettingsNetworkConfigurationsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=NetworkConfiguration,
        )

    @overload
    async def async_create_network_configuration_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgSettingsNetworkConfigurationsPostBodyType,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    @overload
    async def async_create_network_configuration_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        compute_service: Missing[Literal["none", "actions"]] = UNSET,
        network_settings_ids: list[str],
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    async def async_create_network_configuration_for_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgSettingsNetworkConfigurationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/create-network-configuration-for-org

        POST /orgs/{org}/settings/network-configurations

        Creates a hosted compute network configuration for an organization.

        OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#create-a-hosted-compute-network-configuration-for-an-organization
        """

        from ..models import (
            NetworkConfiguration,
            OrgsOrgSettingsNetworkConfigurationsPostBody,
        )

        url = f"/orgs/{org}/settings/network-configurations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgSettingsNetworkConfigurationsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=NetworkConfiguration,
        )

    def get_network_configuration_for_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/get-network-configuration-for-org

        GET /orgs/{org}/settings/network-configurations/{network_configuration_id}

        Gets a hosted compute network configuration configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#get-a-hosted-compute-network-configuration-for-an-organization
        """

        from ..models import NetworkConfiguration

        url = f"/orgs/{org}/settings/network-configurations/{network_configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=NetworkConfiguration,
        )

    async def async_get_network_configuration_for_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/get-network-configuration-for-org

        GET /orgs/{org}/settings/network-configurations/{network_configuration_id}

        Gets a hosted compute network configuration configured in an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#get-a-hosted-compute-network-configuration-for-an-organization
        """

        from ..models import NetworkConfiguration

        url = f"/orgs/{org}/settings/network-configurations/{network_configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=NetworkConfiguration,
        )

    def delete_network_configuration_from_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """hosted-compute/delete-network-configuration-from-org

        DELETE /orgs/{org}/settings/network-configurations/{network_configuration_id}

        Deletes a hosted compute network configuration from an organization.

        OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#delete-a-hosted-compute-network-configuration-from-an-organization
        """

        url = f"/orgs/{org}/settings/network-configurations/{network_configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_network_configuration_from_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """hosted-compute/delete-network-configuration-from-org

        DELETE /orgs/{org}/settings/network-configurations/{network_configuration_id}

        Deletes a hosted compute network configuration from an organization.

        OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#delete-a-hosted-compute-network-configuration-from-an-organization
        """

        url = f"/orgs/{org}/settings/network-configurations/{network_configuration_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_network_configuration_for_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgSettingsNetworkConfigurationsNetworkConfigurationIdPatchBodyType,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    @overload
    def update_network_configuration_for_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        compute_service: Missing[Literal["none", "actions"]] = UNSET,
        network_settings_ids: Missing[list[str]] = UNSET,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    def update_network_configuration_for_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgSettingsNetworkConfigurationsNetworkConfigurationIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/update-network-configuration-for-org

        PATCH /orgs/{org}/settings/network-configurations/{network_configuration_id}

        Updates a hosted compute network configuration for an organization.

        OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#update-a-hosted-compute-network-configuration-for-an-organization
        """

        from ..models import (
            NetworkConfiguration,
            OrgsOrgSettingsNetworkConfigurationsNetworkConfigurationIdPatchBody,
        )

        url = f"/orgs/{org}/settings/network-configurations/{network_configuration_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgSettingsNetworkConfigurationsNetworkConfigurationIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=NetworkConfiguration,
        )

    @overload
    async def async_update_network_configuration_for_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgSettingsNetworkConfigurationsNetworkConfigurationIdPatchBodyType,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    @overload
    async def async_update_network_configuration_for_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        compute_service: Missing[Literal["none", "actions"]] = UNSET,
        network_settings_ids: Missing[list[str]] = UNSET,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]: ...

    async def async_update_network_configuration_for_org(
        self,
        org: str,
        network_configuration_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgSettingsNetworkConfigurationsNetworkConfigurationIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[NetworkConfiguration, NetworkConfigurationType]:
        """hosted-compute/update-network-configuration-for-org

        PATCH /orgs/{org}/settings/network-configurations/{network_configuration_id}

        Updates a hosted compute network configuration for an organization.

        OAuth app tokens and personal access tokens (classic) need the `write:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#update-a-hosted-compute-network-configuration-for-an-organization
        """

        from ..models import (
            NetworkConfiguration,
            OrgsOrgSettingsNetworkConfigurationsNetworkConfigurationIdPatchBody,
        )

        url = f"/orgs/{org}/settings/network-configurations/{network_configuration_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgSettingsNetworkConfigurationsNetworkConfigurationIdPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=NetworkConfiguration,
        )

    def get_network_settings_for_org(
        self,
        org: str,
        network_settings_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[NetworkSettings, NetworkSettingsType]:
        """hosted-compute/get-network-settings-for-org

        GET /orgs/{org}/settings/network-settings/{network_settings_id}

        Gets a hosted compute network settings resource configured for an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#get-a-hosted-compute-network-settings-resource-for-an-organization
        """

        from ..models import NetworkSettings

        url = f"/orgs/{org}/settings/network-settings/{network_settings_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=NetworkSettings,
        )

    async def async_get_network_settings_for_org(
        self,
        org: str,
        network_settings_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[NetworkSettings, NetworkSettingsType]:
        """hosted-compute/get-network-settings-for-org

        GET /orgs/{org}/settings/network-settings/{network_settings_id}

        Gets a hosted compute network settings resource configured for an organization.

        OAuth app tokens and personal access tokens (classic) need the `read:network_configurations` scope to use this endpoint.

        See also: https://docs.github.com/rest/orgs/network-configurations#get-a-hosted-compute-network-settings-resource-for-an-organization
        """

        from ..models import NetworkSettings

        url = f"/orgs/{org}/settings/network-settings/{network_settings_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=NetworkSettings,
        )
