"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        OrganizationSecretScanningAlert,
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
        SecretScanningAlert,
        SecretScanningBypassRequest,
        SecretScanningDismissalRequest,
        SecretScanningLocation,
        SecretScanningPushProtectionBypass,
        SecretScanningScanHistory,
    )
    from ..types import (
        OrganizationSecretScanningAlertType,
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchBodyType,
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200Type,
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchBodyType,
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200Type,
        ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyType,
        ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType,
        SecretScanningAlertType,
        SecretScanningBypassRequestType,
        SecretScanningDismissalRequestType,
        SecretScanningLocationType,
        SecretScanningPushProtectionBypassType,
        SecretScanningScanHistoryType,
    )


class SecretScanningClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_alerts_for_enterprise(
        self,
        enterprise: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[OrganizationSecretScanningAlert], list[OrganizationSecretScanningAlertType]
    ]:
        """secret-scanning/list-alerts-for-enterprise

        GET /enterprises/{enterprise}/secret-scanning/alerts

        Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.
        To use this endpoint, you must be a member of the enterprise, and you must use an access token with the `repo` scope or `security_events` scope. Alerts are only returned for organizations in the enterprise for which you are an organization owner or a [security manager](https://docs.github.com/enterprise-cloud@latest//organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization), or for repositories owned by enterprise managed users.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            OrganizationSecretScanningAlert,
        )

        url = f"/enterprises/{enterprise}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSecretScanningAlert],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_alerts_for_enterprise(
        self,
        enterprise: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[OrganizationSecretScanningAlert], list[OrganizationSecretScanningAlertType]
    ]:
        """secret-scanning/list-alerts-for-enterprise

        GET /enterprises/{enterprise}/secret-scanning/alerts

        Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.
        To use this endpoint, you must be a member of the enterprise, and you must use an access token with the `repo` scope or `security_events` scope. Alerts are only returned for organizations in the enterprise for which you are an organization owner or a [security manager](https://docs.github.com/enterprise-cloud@latest//organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization), or for repositories owned by enterprise managed users.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-an-enterprise
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            OrganizationSecretScanningAlert,
        )

        url = f"/enterprises/{enterprise}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSecretScanningAlert],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_org_bypass_requests(
        self,
        org: str,
        *,
        repository_name: Missing[str] = UNSET,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed",
                "cancelled",
                "approved",
                "expired",
                "deleted",
                "denied",
                "open",
                "all",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[SecretScanningBypassRequest], list[SecretScanningBypassRequestType]
    ]:
        """secret-scanning/list-org-bypass-requests

        GET /orgs/{org}/bypass-requests/secret-scanning

        List requests to bypass secret scanning push protection in an org.

        Delegated bypass must be enabled on repositories in the org and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#list-bypass-requests-for-secret-scanning-for-an-org
        """

        from ..models import BasicError, SecretScanningBypassRequest

        url = f"/orgs/{org}/bypass-requests/secret-scanning"

        params = {
            "repository_name": repository_name,
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningBypassRequest],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_org_bypass_requests(
        self,
        org: str,
        *,
        repository_name: Missing[str] = UNSET,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed",
                "cancelled",
                "approved",
                "expired",
                "deleted",
                "denied",
                "open",
                "all",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[SecretScanningBypassRequest], list[SecretScanningBypassRequestType]
    ]:
        """secret-scanning/list-org-bypass-requests

        GET /orgs/{org}/bypass-requests/secret-scanning

        List requests to bypass secret scanning push protection in an org.

        Delegated bypass must be enabled on repositories in the org and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#list-bypass-requests-for-secret-scanning-for-an-org
        """

        from ..models import BasicError, SecretScanningBypassRequest

        url = f"/orgs/{org}/bypass-requests/secret-scanning"

        params = {
            "repository_name": repository_name,
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningBypassRequest],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def list_org_dismissal_requests(
        self,
        org: str,
        *,
        repository_name: Missing[str] = UNSET,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed", "cancelled", "approved", "expired", "denied", "open", "all"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[SecretScanningDismissalRequest], list[SecretScanningDismissalRequestType]
    ]:
        """secret-scanning/list-org-dismissal-requests

        GET /orgs/{org}/dismissal-requests/secret-scanning

        Lists requests to dismiss secret scanning alerts in an org.

        Delegated alert dismissal must be enabled on repositories in the org and the user must be an org admin, security manager,
        or have the "Review and manage secret scanning alert dismissal requests" permission to access this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/alert-dismissal-requests#list-alert-dismissal-requests-for-secret-scanning-for-an-org
        """

        from ..models import BasicError, SecretScanningDismissalRequest

        url = f"/orgs/{org}/dismissal-requests/secret-scanning"

        params = {
            "repository_name": repository_name,
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningDismissalRequest],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_org_dismissal_requests(
        self,
        org: str,
        *,
        repository_name: Missing[str] = UNSET,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed", "cancelled", "approved", "expired", "denied", "open", "all"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[SecretScanningDismissalRequest], list[SecretScanningDismissalRequestType]
    ]:
        """secret-scanning/list-org-dismissal-requests

        GET /orgs/{org}/dismissal-requests/secret-scanning

        Lists requests to dismiss secret scanning alerts in an org.

        Delegated alert dismissal must be enabled on repositories in the org and the user must be an org admin, security manager,
        or have the "Review and manage secret scanning alert dismissal requests" permission to access this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/alert-dismissal-requests#list-alert-dismissal-requests-for-secret-scanning-for-an-org
        """

        from ..models import BasicError, SecretScanningDismissalRequest

        url = f"/orgs/{org}/dismissal-requests/secret-scanning"

        params = {
            "repository_name": repository_name,
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningDismissalRequest],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    def list_alerts_for_org(
        self,
        org: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[OrganizationSecretScanningAlert], list[OrganizationSecretScanningAlertType]
    ]:
        """secret-scanning/list-alerts-for-org

        GET /orgs/{org}/secret-scanning/alerts

        Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            OrganizationSecretScanningAlert,
        )

        url = f"/orgs/{org}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSecretScanningAlert],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_alerts_for_org(
        self,
        org: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[OrganizationSecretScanningAlert], list[OrganizationSecretScanningAlertType]
    ]:
        """secret-scanning/list-alerts-for-org

        GET /orgs/{org}/secret-scanning/alerts

        Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.

        The authenticated user must be an administrator or security manager for the organization to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-an-organization
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            OrganizationSecretScanningAlert,
        )

        url = f"/orgs/{org}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSecretScanningAlert],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_repo_bypass_requests(
        self,
        owner: str,
        repo: str,
        *,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed",
                "cancelled",
                "approved",
                "expired",
                "deleted",
                "denied",
                "open",
                "all",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[SecretScanningBypassRequest], list[SecretScanningBypassRequestType]
    ]:
        """secret-scanning/list-repo-bypass-requests

        GET /repos/{owner}/{repo}/bypass-requests/secret-scanning

        Lists requests to bypass secret scanning push protection in a repository.

        Delegated bypass must be enabled on the repository and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#list-bypass-requests-for-secret-scanning-for-a-repository
        """

        from ..models import BasicError, SecretScanningBypassRequest

        url = f"/repos/{owner}/{repo}/bypass-requests/secret-scanning"

        params = {
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningBypassRequest],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_repo_bypass_requests(
        self,
        owner: str,
        repo: str,
        *,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed",
                "cancelled",
                "approved",
                "expired",
                "deleted",
                "denied",
                "open",
                "all",
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[SecretScanningBypassRequest], list[SecretScanningBypassRequestType]
    ]:
        """secret-scanning/list-repo-bypass-requests

        GET /repos/{owner}/{repo}/bypass-requests/secret-scanning

        Lists requests to bypass secret scanning push protection in a repository.

        Delegated bypass must be enabled on the repository and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#list-bypass-requests-for-secret-scanning-for-a-repository
        """

        from ..models import BasicError, SecretScanningBypassRequest

        url = f"/repos/{owner}/{repo}/bypass-requests/secret-scanning"

        params = {
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningBypassRequest],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    def get_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SecretScanningBypassRequest, SecretScanningBypassRequestType]:
        """secret-scanning/get-bypass-request

        GET /repos/{owner}/{repo}/bypass-requests/secret-scanning/{bypass_request_number}

        Gets a specific request to bypass secret scanning push protection in a repository.

        Delegated bypass must be enabled on the repository and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#get-a-bypass-request-for-secret-scanning
        """

        from ..models import BasicError, SecretScanningBypassRequest

        url = f"/repos/{owner}/{repo}/bypass-requests/secret-scanning/{bypass_request_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SecretScanningBypassRequest,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SecretScanningBypassRequest, SecretScanningBypassRequestType]:
        """secret-scanning/get-bypass-request

        GET /repos/{owner}/{repo}/bypass-requests/secret-scanning/{bypass_request_number}

        Gets a specific request to bypass secret scanning push protection in a repository.

        Delegated bypass must be enabled on the repository and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#get-a-bypass-request-for-secret-scanning
        """

        from ..models import BasicError, SecretScanningBypassRequest

        url = f"/repos/{owner}/{repo}/bypass-requests/secret-scanning/{bypass_request_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SecretScanningBypassRequest,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def review_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchBodyType,
    ) -> Response[
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200Type,
    ]: ...

    @overload
    def review_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        status: Literal["approve", "reject"],
        message: str,
    ) -> Response[
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200Type,
    ]: ...

    def review_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200Type,
    ]:
        """secret-scanning/review-bypass-request

        PATCH /repos/{owner}/{repo}/bypass-requests/secret-scanning/{bypass_request_number}

        Approve or deny a request to bypass secret scanning push protection in a repository.

        Delegated bypass must be enabled on the repository and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#review-a-bypass-request-for-secret-scanning
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchBody,
            ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/bypass-requests/secret-scanning/{bypass_request_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    async def async_review_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchBodyType,
    ) -> Response[
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200Type,
    ]: ...

    @overload
    async def async_review_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        status: Literal["approve", "reject"],
        message: str,
    ) -> Response[
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200Type,
    ]: ...

    async def async_review_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
        ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200Type,
    ]:
        """secret-scanning/review-bypass-request

        PATCH /repos/{owner}/{repo}/bypass-requests/secret-scanning/{bypass_request_number}

        Approve or deny a request to bypass secret scanning push protection in a repository.

        Delegated bypass must be enabled on the repository and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#review-a-bypass-request-for-secret-scanning
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchBody,
            ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/bypass-requests/secret-scanning/{bypass_request_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoBypassRequestsSecretScanningBypassRequestNumberPatchResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    def dismiss_bypass_response(
        self,
        owner: str,
        repo: str,
        bypass_response_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """secret-scanning/dismiss-bypass-response

        DELETE /repos/{owner}/{repo}/bypass-responses/secret-scanning/{bypass_response_id}

        Dissmiss a response given to a bypass request for secret scanning push protection in a repository.

        Delegated bypass must be enabled on the repository and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#dismiss-a-response-on-a-bypass-request-for-secret-scanning
        """

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/bypass-responses/secret-scanning/{bypass_response_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    async def async_dismiss_bypass_response(
        self,
        owner: str,
        repo: str,
        bypass_response_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """secret-scanning/dismiss-bypass-response

        DELETE /repos/{owner}/{repo}/bypass-responses/secret-scanning/{bypass_response_id}

        Dissmiss a response given to a bypass request for secret scanning push protection in a repository.

        Delegated bypass must be enabled on the repository and the user must be a bypass reviewer to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/delegated-bypass#dismiss-a-response-on-a-bypass-request-for-secret-scanning
        """

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/bypass-responses/secret-scanning/{bypass_response_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    def list_repo_dismissal_requests(
        self,
        owner: str,
        repo: str,
        *,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed", "cancelled", "approved", "expired", "denied", "open", "all"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[SecretScanningDismissalRequest], list[SecretScanningDismissalRequestType]
    ]:
        """secret-scanning/list-repo-dismissal-requests

        GET /repos/{owner}/{repo}/dismissal-requests/secret-scanning

        Lists requests to dismiss secret scanning alerts in a repository.

        Delegated alert dismissal must be enabled on the repository and the user must be an org admin, security manager,
        or have the "Review and manage secret scanning alert dismissal requests" permission to access this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/alert-dismissal-requests#list-alert-dismissal-requests-for-secret-scanning-for-a-repository
        """

        from ..models import BasicError, SecretScanningDismissalRequest

        url = f"/repos/{owner}/{repo}/dismissal-requests/secret-scanning"

        params = {
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningDismissalRequest],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_repo_dismissal_requests(
        self,
        owner: str,
        repo: str,
        *,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal[
                "completed", "cancelled", "approved", "expired", "denied", "open", "all"
            ]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[SecretScanningDismissalRequest], list[SecretScanningDismissalRequestType]
    ]:
        """secret-scanning/list-repo-dismissal-requests

        GET /repos/{owner}/{repo}/dismissal-requests/secret-scanning

        Lists requests to dismiss secret scanning alerts in a repository.

        Delegated alert dismissal must be enabled on the repository and the user must be an org admin, security manager,
        or have the "Review and manage secret scanning alert dismissal requests" permission to access this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/alert-dismissal-requests#list-alert-dismissal-requests-for-secret-scanning-for-a-repository
        """

        from ..models import BasicError, SecretScanningDismissalRequest

        url = f"/repos/{owner}/{repo}/dismissal-requests/secret-scanning"

        params = {
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningDismissalRequest],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    def get_dismissal_request(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SecretScanningDismissalRequest, SecretScanningDismissalRequestType]:
        """secret-scanning/get-dismissal-request

        GET /repos/{owner}/{repo}/dismissal-requests/secret-scanning/{alert_number}

        Gets a specific request to dismiss a secret scanning alert in a repository.

        Delegated alert dismissal must be enabled on the repository and the user must be an org admin, security manager,
        or have the "Review and manage secret scanning alert dismissal requests" permission to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/alert-dismissal-requests#get-an-alert-dismissal-request-for-secret-scanning
        """

        from ..models import BasicError, SecretScanningDismissalRequest

        url = f"/repos/{owner}/{repo}/dismissal-requests/secret-scanning/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SecretScanningDismissalRequest,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_dismissal_request(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SecretScanningDismissalRequest, SecretScanningDismissalRequestType]:
        """secret-scanning/get-dismissal-request

        GET /repos/{owner}/{repo}/dismissal-requests/secret-scanning/{alert_number}

        Gets a specific request to dismiss a secret scanning alert in a repository.

        Delegated alert dismissal must be enabled on the repository and the user must be an org admin, security manager,
        or have the "Review and manage secret scanning alert dismissal requests" permission to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/alert-dismissal-requests#get-an-alert-dismissal-request-for-secret-scanning
        """

        from ..models import BasicError, SecretScanningDismissalRequest

        url = f"/repos/{owner}/{repo}/dismissal-requests/secret-scanning/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SecretScanningDismissalRequest,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def review_dismissal_request(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchBodyType,
    ) -> Response[
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200Type,
    ]: ...

    @overload
    def review_dismissal_request(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        status: Literal["approve", "deny"],
        message: str,
    ) -> Response[
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200Type,
    ]: ...

    def review_dismissal_request(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200Type,
    ]:
        """secret-scanning/review-dismissal-request

        PATCH /repos/{owner}/{repo}/dismissal-requests/secret-scanning/{alert_number}

        Approve or deny a request to dismiss a secret scanning alert in a repository.

        Delegated alert dismissal must be enabled on the repository and the user must be an org admin, security manager,
        or have the "Review and manage secret scanning alert dismissal requests" permission to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/alert-dismissal-requests#review-an-alert-dismissal-request-for-secret-scanning
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchBody,
            ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/dismissal-requests/secret-scanning/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    @overload
    async def async_review_dismissal_request(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchBodyType,
    ) -> Response[
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200Type,
    ]: ...

    @overload
    async def async_review_dismissal_request(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        status: Literal["approve", "deny"],
        message: str,
    ) -> Response[
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200Type,
    ]: ...

    async def async_review_dismissal_request(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
        ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200Type,
    ]:
        """secret-scanning/review-dismissal-request

        PATCH /repos/{owner}/{repo}/dismissal-requests/secret-scanning/{alert_number}

        Approve or deny a request to dismiss a secret scanning alert in a repository.

        Delegated alert dismissal must be enabled on the repository and the user must be an org admin, security manager,
        or have the "Review and manage secret scanning alert dismissal requests" permission to access this endpoint.
        Personal access tokens (classic) need the `security_events` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/alert-dismissal-requests#review-an-alert-dismissal-request-for-secret-scanning
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchBody,
            ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/dismissal-requests/secret-scanning/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoDismissalRequestsSecretScanningAlertNumberPatchResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "500": BasicError,
            },
        )

    def list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SecretScanningAlert], list[SecretScanningAlertType]]:
        """secret-scanning/list-alerts-for-repo

        GET /repos/{owner}/{repo}/secret-scanning/alerts

        Lists secret scanning alerts for an eligible repository, from newest to oldest.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-a-repository
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            SecretScanningAlert,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningAlert],
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "resolved"]] = UNSET,
        secret_type: Missing[str] = UNSET,
        resolution: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        validity: Missing[str] = UNSET,
        is_publicly_leaked: Missing[bool] = UNSET,
        is_multi_repo: Missing[bool] = UNSET,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SecretScanningAlert], list[SecretScanningAlertType]]:
        """secret-scanning/list-alerts-for-repo

        GET /repos/{owner}/{repo}/secret-scanning/alerts

        Lists secret scanning alerts for an eligible repository, from newest to oldest.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#list-secret-scanning-alerts-for-a-repository
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            SecretScanningAlert,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts"

        params = {
            "state": state,
            "secret_type": secret_type,
            "resolution": resolution,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "validity": validity,
            "is_publicly_leaked": is_publicly_leaked,
            "is_multi_repo": is_multi_repo,
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningAlert],
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SecretScanningAlert, SecretScanningAlertType]:
        """secret-scanning/get-alert

        GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}

        Gets a single secret scanning alert detected in an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#get-a-secret-scanning-alert
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            SecretScanningAlert,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}"

        params = {
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=SecretScanningAlert,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        hide_secret: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SecretScanningAlert, SecretScanningAlertType]:
        """secret-scanning/get-alert

        GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}

        Gets a single secret scanning alert detected in an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#get-a-secret-scanning-alert
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            SecretScanningAlert,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}"

        params = {
            "hide_secret": hide_secret,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=SecretScanningAlert,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyType,
    ) -> Response[SecretScanningAlert, SecretScanningAlertType]: ...

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal["open", "resolved"],
        resolution: Missing[
            Union[
                None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]
            ]
        ] = UNSET,
        resolution_comment: Missing[Union[str, None]] = UNSET,
    ) -> Response[SecretScanningAlert, SecretScanningAlertType]: ...

    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[SecretScanningAlert, SecretScanningAlertType]:
        """secret-scanning/update-alert

        PATCH /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}

        Updates the status of a secret scanning alert in an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#update-a-secret-scanning-alert
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBody,
            SecretScanningAlert,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=SecretScanningAlert,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyType,
    ) -> Response[SecretScanningAlert, SecretScanningAlertType]: ...

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal["open", "resolved"],
        resolution: Missing[
            Union[
                None, Literal["false_positive", "wont_fix", "revoked", "used_in_tests"]
            ]
        ] = UNSET,
        resolution_comment: Missing[Union[str, None]] = UNSET,
    ) -> Response[SecretScanningAlert, SecretScanningAlertType]: ...

    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[SecretScanningAlert, SecretScanningAlertType]:
        """secret-scanning/update-alert

        PATCH /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}

        Updates the status of a secret scanning alert in an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#update-a-secret-scanning-alert
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBody,
            SecretScanningAlert,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoSecretScanningAlertsAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=SecretScanningAlert,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_locations_for_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SecretScanningLocation], list[SecretScanningLocationType]]:
        """secret-scanning/list-locations-for-alert

        GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations

        Lists all locations for a given secret scanning alert for an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#list-locations-for-a-secret-scanning-alert
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            SecretScanningLocation,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningLocation],
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_locations_for_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SecretScanningLocation], list[SecretScanningLocationType]]:
        """secret-scanning/list-locations-for-alert

        GET /repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations

        Lists all locations for a given secret scanning alert for an eligible repository.

        The authenticated user must be an administrator for the repository or for the organization that owns the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#list-locations-for-a-secret-scanning-alert
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            SecretScanningLocation,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SecretScanningLocation],
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType,
    ) -> Response[
        SecretScanningPushProtectionBypass, SecretScanningPushProtectionBypassType
    ]: ...

    @overload
    def create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        reason: Literal["false_positive", "used_in_tests", "will_fix_later"],
        placeholder_id: str,
    ) -> Response[
        SecretScanningPushProtectionBypass, SecretScanningPushProtectionBypassType
    ]: ...

    def create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        SecretScanningPushProtectionBypass, SecretScanningPushProtectionBypassType
    ]:
        """secret-scanning/create-push-protection-bypass

        POST /repos/{owner}/{repo}/secret-scanning/push-protection-bypasses

        Creates a bypass for a previously push protected secret.

        The authenticated user must be the original author of the committed secret.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#create-a-push-protection-bypass
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoSecretScanningPushProtectionBypassesPostBody,
            SecretScanningPushProtectionBypass,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoSecretScanningPushProtectionBypassesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=SecretScanningPushProtectionBypass,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType,
    ) -> Response[
        SecretScanningPushProtectionBypass, SecretScanningPushProtectionBypassType
    ]: ...

    @overload
    async def async_create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        reason: Literal["false_positive", "used_in_tests", "will_fix_later"],
        placeholder_id: str,
    ) -> Response[
        SecretScanningPushProtectionBypass, SecretScanningPushProtectionBypassType
    ]: ...

    async def async_create_push_protection_bypass(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoSecretScanningPushProtectionBypassesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        SecretScanningPushProtectionBypass, SecretScanningPushProtectionBypassType
    ]:
        """secret-scanning/create-push-protection-bypass

        POST /repos/{owner}/{repo}/secret-scanning/push-protection-bypasses

        Creates a bypass for a previously push protected secret.

        The authenticated user must be the original author of the committed secret.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#create-a-push-protection-bypass
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoSecretScanningPushProtectionBypassesPostBody,
            SecretScanningPushProtectionBypass,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/push-protection-bypasses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoSecretScanningPushProtectionBypassesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=SecretScanningPushProtectionBypass,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_scan_history(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SecretScanningScanHistory, SecretScanningScanHistoryType]:
        """secret-scanning/get-scan-history

        GET /repos/{owner}/{repo}/secret-scanning/scan-history

        Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#get-secret-scanning-scan-history-for-a-repository
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            SecretScanningScanHistory,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/scan-history"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SecretScanningScanHistory,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_scan_history(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SecretScanningScanHistory, SecretScanningScanHistoryType]:
        """secret-scanning/get-scan-history

        GET /repos/{owner}/{repo}/secret-scanning/scan-history

        Lists the latest default incremental and backfill scans by type for a repository. Scans from Copilot Secret Scanning are not included.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `security_events` scope to use this endpoint. If this endpoint is only used with public repositories, the token can use the `public_repo` scope instead.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/secret-scanning/secret-scanning#get-secret-scanning-scan-history-for-a-repository
        """

        from ..models import (
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            SecretScanningScanHistory,
        )

        url = f"/repos/{owner}/{repo}/secret-scanning/scan-history"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SecretScanningScanHistory,
            error_models={
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )
