"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Annotated, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel, Field

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        Email,
        GpgKey,
        Hovercard,
        Key,
        KeySimple,
        PrivateUser,
        PublicUser,
        SimpleUser,
        SocialAccount,
        SshSigningKey,
        UsersUsernameAttestationsSubjectDigestGetResponse200,
    )
    from ..types import (
        EmailType,
        GpgKeyType,
        HovercardType,
        KeySimpleType,
        KeyType,
        PrivateUserType,
        PublicUserType,
        SimpleUserType,
        SocialAccountType,
        SshSigningKeyType,
        UserEmailsDeleteBodyOneof0Type,
        UserEmailsPostBodyOneof0Type,
        UserEmailVisibilityPatchBodyType,
        UserGpgKeysPostBodyType,
        UserKeysPostBodyType,
        UserPatchBodyType,
        UserSocialAccountsDeleteBodyType,
        UserSocialAccountsPostBodyType,
        UserSshSigningKeysPostBodyType,
        UsersUsernameAttestationsDeleteRequestPostBodyOneof0Type,
        UsersUsernameAttestationsDeleteRequestPostBodyOneof1Type,
        UsersUsernameAttestationsSubjectDigestGetResponse200Type,
    )


class UsersClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_authenticated(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        Union[PrivateUser, PublicUser], Union[PrivateUserType, PublicUserType]
    ]:
        """users/get-authenticated

        GET /user

        OAuth app tokens and personal access tokens (classic) need the `user` scope in order for the response to include private profile information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#get-the-authenticated-user
        """

        from typing import Union

        from ..models import BasicError, PrivateUser, PublicUser

        url = "/user"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_authenticated(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        Union[PrivateUser, PublicUser], Union[PrivateUserType, PublicUserType]
    ]:
        """users/get-authenticated

        GET /user

        OAuth app tokens and personal access tokens (classic) need the `user` scope in order for the response to include private profile information.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#get-the-authenticated-user
        """

        from typing import Union

        from ..models import BasicError, PrivateUser, PublicUser

        url = "/user"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_authenticated(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserPatchBodyType] = UNSET,
    ) -> Response[PrivateUser, PrivateUserType]: ...

    @overload
    def update_authenticated(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        blog: Missing[str] = UNSET,
        twitter_username: Missing[Union[str, None]] = UNSET,
        company: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        hireable: Missing[bool] = UNSET,
        bio: Missing[str] = UNSET,
    ) -> Response[PrivateUser, PrivateUserType]: ...

    def update_authenticated(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PrivateUser, PrivateUserType]:
        """users/update-authenticated

        PATCH /user

        **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#update-the-authenticated-user
        """

        from ..models import BasicError, PrivateUser, UserPatchBody, ValidationError

        url = "/user"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PrivateUser,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_authenticated(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserPatchBodyType] = UNSET,
    ) -> Response[PrivateUser, PrivateUserType]: ...

    @overload
    async def async_update_authenticated(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        blog: Missing[str] = UNSET,
        twitter_username: Missing[Union[str, None]] = UNSET,
        company: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        hireable: Missing[bool] = UNSET,
        bio: Missing[str] = UNSET,
    ) -> Response[PrivateUser, PrivateUserType]: ...

    async def async_update_authenticated(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[PrivateUser, PrivateUserType]:
        """users/update-authenticated

        PATCH /user

        **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#update-the-authenticated-user
        """

        from ..models import BasicError, PrivateUser, UserPatchBody, ValidationError

        url = "/user"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PrivateUser,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def list_blocked_by_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-blocked-by-authenticated-user

        GET /user/blocks

        List the users you've blocked on your personal account.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/blocking#list-users-blocked-by-the-authenticated-user
        """

        from ..models import BasicError, SimpleUser

        url = "/user/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_blocked_by_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-blocked-by-authenticated-user

        GET /user/blocks

        List the users you've blocked on your personal account.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/blocking#list-users-blocked-by-the-authenticated-user
        """

        from ..models import BasicError, SimpleUser

        url = "/user/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def check_blocked(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/check-blocked

        GET /user/blocks/{username}

        Returns a 204 if the given user is blocked by the authenticated user. Returns a 404 if the given user is not blocked by the authenticated user, or if the given user account has been identified as spam by GitHub.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/blocking#check-if-a-user-is-blocked-by-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_check_blocked(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/check-blocked

        GET /user/blocks/{username}

        Returns a 204 if the given user is blocked by the authenticated user. Returns a 404 if the given user is not blocked by the authenticated user, or if the given user account has been identified as spam by GitHub.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/blocking#check-if-a-user-is-blocked-by-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def block(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/block

        PUT /user/blocks/{username}

        Blocks the given user and returns a 204. If the authenticated user cannot block the given user a 422 is returned.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/blocking#block-a-user
        """

        from ..models import BasicError, ValidationError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_block(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/block

        PUT /user/blocks/{username}

        Blocks the given user and returns a 204. If the authenticated user cannot block the given user a 422 is returned.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/blocking#block-a-user
        """

        from ..models import BasicError, ValidationError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def unblock(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/unblock

        DELETE /user/blocks/{username}

        Unblocks the given user and returns a 204.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/blocking#unblock-a-user
        """

        from ..models import BasicError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_unblock(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/unblock

        DELETE /user/blocks/{username}

        Unblocks the given user and returns a 204.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/blocking#unblock-a-user
        """

        from ..models import BasicError

        url = f"/user/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserEmailVisibilityPatchBodyType,
    ) -> Response[list[Email], list[EmailType]]: ...

    @overload
    def set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        visibility: Literal["public", "private"],
    ) -> Response[list[Email], list[EmailType]]: ...

    def set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserEmailVisibilityPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[Email], list[EmailType]]:
        """users/set-primary-email-visibility-for-authenticated-user

        PATCH /user/email/visibility

        Sets the visibility for your primary email addresses.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#set-primary-email-visibility-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            Email,
            UserEmailVisibilityPatchBody,
            ValidationError,
        )

        url = "/user/email/visibility"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserEmailVisibilityPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserEmailVisibilityPatchBodyType,
    ) -> Response[list[Email], list[EmailType]]: ...

    @overload
    async def async_set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        visibility: Literal["public", "private"],
    ) -> Response[list[Email], list[EmailType]]: ...

    async def async_set_primary_email_visibility_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserEmailVisibilityPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[Email], list[EmailType]]:
        """users/set-primary-email-visibility-for-authenticated-user

        PATCH /user/email/visibility

        Sets the visibility for your primary email addresses.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#set-primary-email-visibility-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            Email,
            UserEmailVisibilityPatchBody,
            ValidationError,
        )

        url = "/user/email/visibility"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserEmailVisibilityPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def list_emails_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Email], list[EmailType]]:
        """users/list-emails-for-authenticated-user

        GET /user/emails

        Lists all of your email addresses, and specifies which one is visible
        to the public.

        OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#list-email-addresses-for-the-authenticated-user
        """

        from ..models import BasicError, Email

        url = "/user/emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_emails_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Email], list[EmailType]]:
        """users/list-emails-for-authenticated-user

        GET /user/emails

        Lists all of your email addresses, and specifies which one is visible
        to the public.

        OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#list-email-addresses-for-the-authenticated-user
        """

        from ..models import BasicError, Email

        url = "/user/emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[UserEmailsPostBodyOneof0Type, list[str], str]] = UNSET,
    ) -> Response[list[Email], list[EmailType]]: ...

    @overload
    def add_email_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        emails: list[str],
    ) -> Response[list[Email], list[EmailType]]: ...

    def add_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[UserEmailsPostBodyOneof0Type, list[str], str]] = UNSET,
        **kwargs,
    ) -> Response[list[Email], list[EmailType]]:
        """users/add-email-for-authenticated-user

        POST /user/emails

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#add-an-email-address-for-the-authenticated-user
        """

        from typing import Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            BasicError,
            Email,
            UserEmailsPostBodyOneof0,
            ValidationError,
        )

        url = "/user/emails"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UserEmailsPostBodyOneof0,
                    Annotated[list[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Email],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[UserEmailsPostBodyOneof0Type, list[str], str]] = UNSET,
    ) -> Response[list[Email], list[EmailType]]: ...

    @overload
    async def async_add_email_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        emails: list[str],
    ) -> Response[list[Email], list[EmailType]]: ...

    async def async_add_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[UserEmailsPostBodyOneof0Type, list[str], str]] = UNSET,
        **kwargs,
    ) -> Response[list[Email], list[EmailType]]:
        """users/add-email-for-authenticated-user

        POST /user/emails

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#add-an-email-address-for-the-authenticated-user
        """

        from typing import Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            BasicError,
            Email,
            UserEmailsPostBodyOneof0,
            ValidationError,
        )

        url = "/user/emails"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UserEmailsPostBodyOneof0,
                    Annotated[list[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Email],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def delete_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[UserEmailsDeleteBodyOneof0Type, list[str], str]] = UNSET,
    ) -> Response: ...

    @overload
    def delete_email_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        emails: list[str],
    ) -> Response: ...

    def delete_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[UserEmailsDeleteBodyOneof0Type, list[str], str]] = UNSET,
        **kwargs,
    ) -> Response:
        """users/delete-email-for-authenticated-user

        DELETE /user/emails

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#delete-an-email-address-for-the-authenticated-user
        """

        from typing import Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import BasicError, UserEmailsDeleteBodyOneof0, ValidationError

        url = "/user/emails"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UserEmailsDeleteBodyOneof0,
                    Annotated[list[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_delete_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[UserEmailsDeleteBodyOneof0Type, list[str], str]] = UNSET,
    ) -> Response: ...

    @overload
    async def async_delete_email_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        emails: list[str],
    ) -> Response: ...

    async def async_delete_email_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[UserEmailsDeleteBodyOneof0Type, list[str], str]] = UNSET,
        **kwargs,
    ) -> Response:
        """users/delete-email-for-authenticated-user

        DELETE /user/emails

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#delete-an-email-address-for-the-authenticated-user
        """

        from typing import Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import BasicError, UserEmailsDeleteBodyOneof0, ValidationError

        url = "/user/emails"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UserEmailsDeleteBodyOneof0,
                    Annotated[list[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def list_followers_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-followers-for-authenticated-user

        GET /user/followers

        Lists the people following the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#list-followers-of-the-authenticated-user
        """

        from ..models import BasicError, SimpleUser

        url = "/user/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_followers_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-followers-for-authenticated-user

        GET /user/followers

        Lists the people following the authenticated user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#list-followers-of-the-authenticated-user
        """

        from ..models import BasicError, SimpleUser

        url = "/user/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_followed_by_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-followed-by-authenticated-user

        GET /user/following

        Lists the people who the authenticated user follows.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#list-the-people-the-authenticated-user-follows
        """

        from ..models import BasicError, SimpleUser

        url = "/user/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_followed_by_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-followed-by-authenticated-user

        GET /user/following

        Lists the people who the authenticated user follows.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#list-the-people-the-authenticated-user-follows
        """

        from ..models import BasicError, SimpleUser

        url = "/user/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def check_person_is_followed_by_authenticated(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/check-person-is-followed-by-authenticated

        GET /user/following/{username}

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#check-if-a-person-is-followed-by-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_check_person_is_followed_by_authenticated(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/check-person-is-followed-by-authenticated

        GET /user/following/{username}

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#check-if-a-person-is-followed-by-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def follow(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/follow

        PUT /user/following/{username}

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#http-method)."

        OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#follow-a-user
        """

        from ..models import BasicError, ValidationError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_follow(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/follow

        PUT /user/following/{username}

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#http-method)."

        OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#follow-a-user
        """

        from ..models import BasicError, ValidationError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def unfollow(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/unfollow

        DELETE /user/following/{username}

        OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#unfollow-a-user
        """

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_unfollow(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/unfollow

        DELETE /user/following/{username}

        OAuth app tokens and personal access tokens (classic) need the `user:follow` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#unfollow-a-user
        """

        from ..models import BasicError

        url = f"/user/following/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_gpg_keys_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[GpgKey], list[GpgKeyType]]:
        """users/list-gpg-keys-for-authenticated-user

        GET /user/gpg_keys

        Lists the current user's GPG keys.

        OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#list-gpg-keys-for-the-authenticated-user
        """

        from ..models import BasicError, GpgKey

        url = "/user/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[GpgKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_gpg_keys_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[GpgKey], list[GpgKeyType]]:
        """users/list-gpg-keys-for-authenticated-user

        GET /user/gpg_keys

        Lists the current user's GPG keys.

        OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#list-gpg-keys-for-the-authenticated-user
        """

        from ..models import BasicError, GpgKey

        url = "/user/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[GpgKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_gpg_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserGpgKeysPostBodyType,
    ) -> Response[GpgKey, GpgKeyType]: ...

    @overload
    def create_gpg_key_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        armored_public_key: str,
    ) -> Response[GpgKey, GpgKeyType]: ...

    def create_gpg_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserGpgKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GpgKey, GpgKeyType]:
        """users/create-gpg-key-for-authenticated-user

        POST /user/gpg_keys

        Adds a GPG key to the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `write:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#create-a-gpg-key-for-the-authenticated-user
        """

        from ..models import BasicError, GpgKey, UserGpgKeysPostBody, ValidationError

        url = "/user/gpg_keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserGpgKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GpgKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_gpg_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserGpgKeysPostBodyType,
    ) -> Response[GpgKey, GpgKeyType]: ...

    @overload
    async def async_create_gpg_key_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        armored_public_key: str,
    ) -> Response[GpgKey, GpgKeyType]: ...

    async def async_create_gpg_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserGpgKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GpgKey, GpgKeyType]:
        """users/create-gpg-key-for-authenticated-user

        POST /user/gpg_keys

        Adds a GPG key to the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `write:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#create-a-gpg-key-for-the-authenticated-user
        """

        from ..models import BasicError, GpgKey, UserGpgKeysPostBody, ValidationError

        url = "/user/gpg_keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserGpgKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GpgKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GpgKey, GpgKeyType]:
        """users/get-gpg-key-for-authenticated-user

        GET /user/gpg_keys/{gpg_key_id}

        View extended details for a single GPG key.

        OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#get-a-gpg-key-for-the-authenticated-user
        """

        from ..models import BasicError, GpgKey

        url = f"/user/gpg_keys/{gpg_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GpgKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[GpgKey, GpgKeyType]:
        """users/get-gpg-key-for-authenticated-user

        GET /user/gpg_keys/{gpg_key_id}

        View extended details for a single GPG key.

        OAuth app tokens and personal access tokens (classic) need the `read:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#get-a-gpg-key-for-the-authenticated-user
        """

        from ..models import BasicError, GpgKey

        url = f"/user/gpg_keys/{gpg_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GpgKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-gpg-key-for-authenticated-user

        DELETE /user/gpg_keys/{gpg_key_id}

        Removes a GPG key from the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `admin:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#delete-a-gpg-key-for-the-authenticated-user
        """

        from ..models import BasicError, ValidationError

        url = f"/user/gpg_keys/{gpg_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_gpg_key_for_authenticated_user(
        self,
        gpg_key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-gpg-key-for-authenticated-user

        DELETE /user/gpg_keys/{gpg_key_id}

        Removes a GPG key from the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `admin:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#delete-a-gpg-key-for-the-authenticated-user
        """

        from ..models import BasicError, ValidationError

        url = f"/user/gpg_keys/{gpg_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_public_ssh_keys_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Key], list[KeyType]]:
        """users/list-public-ssh-keys-for-authenticated-user

        GET /user/keys

        Lists the public SSH keys for the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#list-public-ssh-keys-for-the-authenticated-user
        """

        from ..models import BasicError, Key

        url = "/user/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Key],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_public_ssh_keys_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Key], list[KeyType]]:
        """users/list-public-ssh-keys-for-authenticated-user

        GET /user/keys

        Lists the public SSH keys for the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#list-public-ssh-keys-for-the-authenticated-user
        """

        from ..models import BasicError, Key

        url = "/user/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Key],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_public_ssh_key_for_authenticated_user(
        self, *, headers: Optional[Mapping[str, str]] = None, data: UserKeysPostBodyType
    ) -> Response[Key, KeyType]: ...

    @overload
    def create_public_ssh_key_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
    ) -> Response[Key, KeyType]: ...

    def create_public_ssh_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Key, KeyType]:
        """users/create-public-ssh-key-for-authenticated-user

        POST /user/keys

        Adds a public SSH key to the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `write:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#create-a-public-ssh-key-for-the-authenticated-user
        """

        from ..models import BasicError, Key, UserKeysPostBody, ValidationError

        url = "/user/keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Key,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_public_ssh_key_for_authenticated_user(
        self, *, headers: Optional[Mapping[str, str]] = None, data: UserKeysPostBodyType
    ) -> Response[Key, KeyType]: ...

    @overload
    async def async_create_public_ssh_key_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
    ) -> Response[Key, KeyType]: ...

    async def async_create_public_ssh_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Key, KeyType]:
        """users/create-public-ssh-key-for-authenticated-user

        POST /user/keys

        Adds a public SSH key to the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `write:gpg_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#create-a-public-ssh-key-for-the-authenticated-user
        """

        from ..models import BasicError, Key, UserKeysPostBody, ValidationError

        url = "/user/keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Key,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Key, KeyType]:
        """users/get-public-ssh-key-for-authenticated-user

        GET /user/keys/{key_id}

        View extended details for a single public SSH key.

        OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#get-a-public-ssh-key-for-the-authenticated-user
        """

        from ..models import BasicError, Key

        url = f"/user/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Key,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Key, KeyType]:
        """users/get-public-ssh-key-for-authenticated-user

        GET /user/keys/{key_id}

        View extended details for a single public SSH key.

        OAuth app tokens and personal access tokens (classic) need the `read:public_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#get-a-public-ssh-key-for-the-authenticated-user
        """

        from ..models import BasicError, Key

        url = f"/user/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Key,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-public-ssh-key-for-authenticated-user

        DELETE /user/keys/{key_id}

        Removes a public SSH key from the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `admin:public_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#delete-a-public-ssh-key-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_public_ssh_key_for_authenticated_user(
        self,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-public-ssh-key-for-authenticated-user

        DELETE /user/keys/{key_id}

        Removes a public SSH key from the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `admin:public_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#delete-a-public-ssh-key-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_public_emails_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Email], list[EmailType]]:
        """users/list-public-emails-for-authenticated-user

        GET /user/public_emails

        Lists your publicly visible email address, which you can set with the
        [Set primary email visibility for the authenticated user](https://docs.github.com/enterprise-cloud@latest//rest/users/emails#set-primary-email-visibility-for-the-authenticated-user)
        endpoint.

        OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#list-public-email-addresses-for-the-authenticated-user
        """

        from ..models import BasicError, Email

        url = "/user/public_emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_public_emails_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Email], list[EmailType]]:
        """users/list-public-emails-for-authenticated-user

        GET /user/public_emails

        Lists your publicly visible email address, which you can set with the
        [Set primary email visibility for the authenticated user](https://docs.github.com/enterprise-cloud@latest//rest/users/emails#set-primary-email-visibility-for-the-authenticated-user)
        endpoint.

        OAuth app tokens and personal access tokens (classic) need the `user:email` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/emails#list-public-email-addresses-for-the-authenticated-user
        """

        from ..models import BasicError, Email

        url = "/user/public_emails"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Email],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_social_accounts_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SocialAccount], list[SocialAccountType]]:
        """users/list-social-accounts-for-authenticated-user

        GET /user/social_accounts

        Lists all of your social accounts.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/social-accounts#list-social-accounts-for-the-authenticated-user
        """

        from ..models import BasicError, SocialAccount

        url = "/user/social_accounts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SocialAccount],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_social_accounts_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SocialAccount], list[SocialAccountType]]:
        """users/list-social-accounts-for-authenticated-user

        GET /user/social_accounts

        Lists all of your social accounts.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/social-accounts#list-social-accounts-for-the-authenticated-user
        """

        from ..models import BasicError, SocialAccount

        url = "/user/social_accounts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SocialAccount],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserSocialAccountsPostBodyType,
    ) -> Response[list[SocialAccount], list[SocialAccountType]]: ...

    @overload
    def add_social_account_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        account_urls: list[str],
    ) -> Response[list[SocialAccount], list[SocialAccountType]]: ...

    def add_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserSocialAccountsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[SocialAccount], list[SocialAccountType]]:
        """users/add-social-account-for-authenticated-user

        POST /user/social_accounts

        Add one or more social accounts to the authenticated user's profile.

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/social-accounts#add-social-accounts-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            SocialAccount,
            UserSocialAccountsPostBody,
            ValidationError,
        )

        url = "/user/social_accounts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserSocialAccountsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[SocialAccount],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserSocialAccountsPostBodyType,
    ) -> Response[list[SocialAccount], list[SocialAccountType]]: ...

    @overload
    async def async_add_social_account_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        account_urls: list[str],
    ) -> Response[list[SocialAccount], list[SocialAccountType]]: ...

    async def async_add_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserSocialAccountsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[SocialAccount], list[SocialAccountType]]:
        """users/add-social-account-for-authenticated-user

        POST /user/social_accounts

        Add one or more social accounts to the authenticated user's profile.

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/social-accounts#add-social-accounts-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            SocialAccount,
            UserSocialAccountsPostBody,
            ValidationError,
        )

        url = "/user/social_accounts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserSocialAccountsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[SocialAccount],
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def delete_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserSocialAccountsDeleteBodyType,
    ) -> Response: ...

    @overload
    def delete_social_account_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        account_urls: list[str],
    ) -> Response: ...

    def delete_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserSocialAccountsDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """users/delete-social-account-for-authenticated-user

        DELETE /user/social_accounts

        Deletes one or more social accounts from the authenticated user's profile.

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/social-accounts#delete-social-accounts-for-the-authenticated-user
        """

        from ..models import BasicError, UserSocialAccountsDeleteBody, ValidationError

        url = "/user/social_accounts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserSocialAccountsDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_delete_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserSocialAccountsDeleteBodyType,
    ) -> Response: ...

    @overload
    async def async_delete_social_account_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        account_urls: list[str],
    ) -> Response: ...

    async def async_delete_social_account_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserSocialAccountsDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """users/delete-social-account-for-authenticated-user

        DELETE /user/social_accounts

        Deletes one or more social accounts from the authenticated user's profile.

        OAuth app tokens and personal access tokens (classic) need the `user` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/social-accounts#delete-social-accounts-for-the-authenticated-user
        """

        from ..models import BasicError, UserSocialAccountsDeleteBody, ValidationError

        url = "/user/social_accounts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserSocialAccountsDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_ssh_signing_keys_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SshSigningKey], list[SshSigningKeyType]]:
        """users/list-ssh-signing-keys-for-authenticated-user

        GET /user/ssh_signing_keys

        Lists the SSH signing keys for the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#list-ssh-signing-keys-for-the-authenticated-user
        """

        from ..models import BasicError, SshSigningKey

        url = "/user/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SshSigningKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_ssh_signing_keys_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SshSigningKey], list[SshSigningKeyType]]:
        """users/list-ssh-signing-keys-for-authenticated-user

        GET /user/ssh_signing_keys

        Lists the SSH signing keys for the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#list-ssh-signing-keys-for-the-authenticated-user
        """

        from ..models import BasicError, SshSigningKey

        url = "/user/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SshSigningKey],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserSshSigningKeysPostBodyType,
    ) -> Response[SshSigningKey, SshSigningKeyType]: ...

    @overload
    def create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
    ) -> Response[SshSigningKey, SshSigningKeyType]: ...

    def create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserSshSigningKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[SshSigningKey, SshSigningKeyType]:
        """users/create-ssh-signing-key-for-authenticated-user

        POST /user/ssh_signing_keys

        Creates an SSH signing key for the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `write:ssh_signing_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#create-a-ssh-signing-key-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            SshSigningKey,
            UserSshSigningKeysPostBody,
            ValidationError,
        )

        url = "/user/ssh_signing_keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserSshSigningKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=SshSigningKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserSshSigningKeysPostBodyType,
    ) -> Response[SshSigningKey, SshSigningKeyType]: ...

    @overload
    async def async_create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
    ) -> Response[SshSigningKey, SshSigningKeyType]: ...

    async def async_create_ssh_signing_key_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserSshSigningKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[SshSigningKey, SshSigningKeyType]:
        """users/create-ssh-signing-key-for-authenticated-user

        POST /user/ssh_signing_keys

        Creates an SSH signing key for the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `write:ssh_signing_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#create-a-ssh-signing-key-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            SshSigningKey,
            UserSshSigningKeysPostBody,
            ValidationError,
        )

        url = "/user/ssh_signing_keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserSshSigningKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=SshSigningKey,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SshSigningKey, SshSigningKeyType]:
        """users/get-ssh-signing-key-for-authenticated-user

        GET /user/ssh_signing_keys/{ssh_signing_key_id}

        Gets extended details for an SSH signing key.

        OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#get-an-ssh-signing-key-for-the-authenticated-user
        """

        from ..models import BasicError, SshSigningKey

        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SshSigningKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[SshSigningKey, SshSigningKeyType]:
        """users/get-ssh-signing-key-for-authenticated-user

        GET /user/ssh_signing_keys/{ssh_signing_key_id}

        Gets extended details for an SSH signing key.

        OAuth app tokens and personal access tokens (classic) need the `read:ssh_signing_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#get-an-ssh-signing-key-for-the-authenticated-user
        """

        from ..models import BasicError, SshSigningKey

        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SshSigningKey,
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-ssh-signing-key-for-authenticated-user

        DELETE /user/ssh_signing_keys/{ssh_signing_key_id}

        Deletes an SSH signing key from the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `admin:ssh_signing_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#delete-an-ssh-signing-key-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_ssh_signing_key_for_authenticated_user(
        self,
        ssh_signing_key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-ssh-signing-key-for-authenticated-user

        DELETE /user/ssh_signing_keys/{ssh_signing_key_id}

        Deletes an SSH signing key from the authenticated user's GitHub account.

        OAuth app tokens and personal access tokens (classic) need the `admin:ssh_signing_key` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#delete-an-ssh-signing-key-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/ssh_signing_keys/{ssh_signing_key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_by_id(
        self,
        account_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        Union[PrivateUser, PublicUser], Union[PrivateUserType, PublicUserType]
    ]:
        """users/get-by-id

        GET /user/{account_id}

        Provides publicly available information about someone with a GitHub account. This method takes their durable user `ID` instead of their `login`, which can change over time.

        If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest//enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.

        The `email` key in the following response is the publicly visible email address from your GitHub Enterprise Cloud [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub Enterprise Cloud. For more information, see [Authentication](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#authentication).

        The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/enterprise-cloud@latest//rest/users/emails).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#get-a-user-using-their-id
        """

        from typing import Union

        from ..models import BasicError, PrivateUser, PublicUser

        url = f"/user/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_id(
        self,
        account_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        Union[PrivateUser, PublicUser], Union[PrivateUserType, PublicUserType]
    ]:
        """users/get-by-id

        GET /user/{account_id}

        Provides publicly available information about someone with a GitHub account. This method takes their durable user `ID` instead of their `login`, which can change over time.

        If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest//enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.

        The `email` key in the following response is the publicly visible email address from your GitHub Enterprise Cloud [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub Enterprise Cloud. For more information, see [Authentication](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#authentication).

        The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/enterprise-cloud@latest//rest/users/emails).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#get-a-user-using-their-id
        """

        from typing import Union

        from ..models import BasicError, PrivateUser, PublicUser

        url = f"/user/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    def list(
        self,
        *,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list

        GET /users

        Lists all users, in the order that they signed up on GitHub Enterprise Cloud. This list includes personal user accounts and organization accounts.

        Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/enterprise-cloud@latest//rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of users.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#list-users
        """

        from ..models import SimpleUser

        url = "/users"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    async def async_list(
        self,
        *,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list

        GET /users

        Lists all users, in the order that they signed up on GitHub Enterprise Cloud. This list includes personal user accounts and organization accounts.

        Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/enterprise-cloud@latest//rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of users.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#list-users
        """

        from ..models import SimpleUser

        url = "/users"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    def get_by_username(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        Union[PrivateUser, PublicUser], Union[PrivateUserType, PublicUserType]
    ]:
        """users/get-by-username

        GET /users/{username}

        Provides publicly available information about someone with a GitHub account.

        If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest//enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.

        The `email` key in the following response is the publicly visible email address from your GitHub Enterprise Cloud [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub Enterprise Cloud. For more information, see [Authentication](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#authentication).

        The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/enterprise-cloud@latest//rest/users/emails).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#get-a-user
        """

        from typing import Union

        from ..models import BasicError, PrivateUser, PublicUser

        url = f"/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_username(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        Union[PrivateUser, PublicUser], Union[PrivateUserType, PublicUserType]
    ]:
        """users/get-by-username

        GET /users/{username}

        Provides publicly available information about someone with a GitHub account.

        If you are requesting information about an [Enterprise Managed User](https://docs.github.com/enterprise-cloud@latest//enterprise-cloud@latest/admin/managing-iam/understanding-iam-for-enterprises/about-enterprise-managed-users), or a GitHub App bot that is installed in an organization that uses Enterprise Managed Users, your requests must be authenticated as a user or GitHub App that has access to the organization to view that account's information. If you are not authorized, the request will return a `404 Not Found` status.

        The `email` key in the following response is the publicly visible email address from your GitHub Enterprise Cloud [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be public which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub Enterprise Cloud. For more information, see [Authentication](https://docs.github.com/enterprise-cloud@latest//rest/guides/getting-started-with-the-rest-api#authentication).

        The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see [Emails API](https://docs.github.com/enterprise-cloud@latest//rest/users/emails).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#get-a-user
        """

        from typing import Union

        from ..models import BasicError, PrivateUser, PublicUser

        url = f"/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[PrivateUser, PublicUser],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def delete_attestations_bulk(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Union[
            UsersUsernameAttestationsDeleteRequestPostBodyOneof0Type,
            UsersUsernameAttestationsDeleteRequestPostBodyOneof1Type,
        ],
    ) -> Response: ...

    @overload
    def delete_attestations_bulk(
        self,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        subject_digests: list[str],
    ) -> Response: ...

    @overload
    def delete_attestations_bulk(
        self,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        attestation_ids: list[int],
    ) -> Response: ...

    def delete_attestations_bulk(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                UsersUsernameAttestationsDeleteRequestPostBodyOneof0Type,
                UsersUsernameAttestationsDeleteRequestPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """users/delete-attestations-bulk

        POST /users/{username}/attestations/delete-request

        Delete artifact attestations in bulk by either subject digests or unique ID.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/attestations#delete-attestations-in-bulk
        """

        from typing import Union

        from ..models import (
            BasicError,
            UsersUsernameAttestationsDeleteRequestPostBodyOneof0,
            UsersUsernameAttestationsDeleteRequestPostBodyOneof1,
        )

        url = f"/users/{username}/attestations/delete-request"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UsersUsernameAttestationsDeleteRequestPostBodyOneof0,
                    UsersUsernameAttestationsDeleteRequestPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_delete_attestations_bulk(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Union[
            UsersUsernameAttestationsDeleteRequestPostBodyOneof0Type,
            UsersUsernameAttestationsDeleteRequestPostBodyOneof1Type,
        ],
    ) -> Response: ...

    @overload
    async def async_delete_attestations_bulk(
        self,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        subject_digests: list[str],
    ) -> Response: ...

    @overload
    async def async_delete_attestations_bulk(
        self,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        attestation_ids: list[int],
    ) -> Response: ...

    async def async_delete_attestations_bulk(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                UsersUsernameAttestationsDeleteRequestPostBodyOneof0Type,
                UsersUsernameAttestationsDeleteRequestPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """users/delete-attestations-bulk

        POST /users/{username}/attestations/delete-request

        Delete artifact attestations in bulk by either subject digests or unique ID.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/attestations#delete-attestations-in-bulk
        """

        from typing import Union

        from ..models import (
            BasicError,
            UsersUsernameAttestationsDeleteRequestPostBodyOneof0,
            UsersUsernameAttestationsDeleteRequestPostBodyOneof1,
        )

        url = f"/users/{username}/attestations/delete-request"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    UsersUsernameAttestationsDeleteRequestPostBodyOneof0,
                    UsersUsernameAttestationsDeleteRequestPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def delete_attestations_by_subject_digest(
        self,
        username: str,
        subject_digest: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-attestations-by-subject-digest

        DELETE /users/{username}/attestations/digest/{subject_digest}

        Delete an artifact attestation by subject digest.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/attestations#delete-attestations-by-subject-digest
        """

        from ..models import BasicError

        url = f"/users/{username}/attestations/digest/{subject_digest}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_attestations_by_subject_digest(
        self,
        username: str,
        subject_digest: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-attestations-by-subject-digest

        DELETE /users/{username}/attestations/digest/{subject_digest}

        Delete an artifact attestation by subject digest.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/attestations#delete-attestations-by-subject-digest
        """

        from ..models import BasicError

        url = f"/users/{username}/attestations/digest/{subject_digest}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def delete_attestations_by_id(
        self,
        username: str,
        attestation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-attestations-by-id

        DELETE /users/{username}/attestations/{attestation_id}

        Delete an artifact attestation by unique ID that is associated with a repository owned by a user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/attestations#delete-attestations-by-id
        """

        from ..models import BasicError

        url = f"/users/{username}/attestations/{attestation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_attestations_by_id(
        self,
        username: str,
        attestation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/delete-attestations-by-id

        DELETE /users/{username}/attestations/{attestation_id}

        Delete an artifact attestation by unique ID that is associated with a repository owned by a user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/attestations#delete-attestations-by-id
        """

        from ..models import BasicError

        url = f"/users/{username}/attestations/{attestation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_attestations(
        self,
        username: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        UsersUsernameAttestationsSubjectDigestGetResponse200,
        UsersUsernameAttestationsSubjectDigestGetResponse200Type,
    ]:
        """users/list-attestations

        GET /users/{username}/attestations/{subject_digest}

        List a collection of artifact attestations with a given subject digest that are associated with repositories owned by a user.

        The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.

        **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/enterprise-cloud@latest//actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/attestations#list-attestations
        """

        from ..models import (
            BasicError,
            UsersUsernameAttestationsSubjectDigestGetResponse200,
        )

        url = f"/users/{username}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsersUsernameAttestationsSubjectDigestGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_attestations(
        self,
        username: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        UsersUsernameAttestationsSubjectDigestGetResponse200,
        UsersUsernameAttestationsSubjectDigestGetResponse200Type,
    ]:
        """users/list-attestations

        GET /users/{username}/attestations/{subject_digest}

        List a collection of artifact attestations with a given subject digest that are associated with repositories owned by a user.

        The collection of attestations returned by this endpoint is filtered according to the authenticated user's permissions; if the authenticated user cannot read a repository, the attestations associated with that repository will not be included in the response. In addition, when using a fine-grained access token the `attestations:read` permission is required.

        **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/enterprise-cloud@latest//actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/attestations#list-attestations
        """

        from ..models import (
            BasicError,
            UsersUsernameAttestationsSubjectDigestGetResponse200,
        )

        url = f"/users/{username}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UsersUsernameAttestationsSubjectDigestGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def list_followers_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-followers-for-user

        GET /users/{username}/followers

        Lists the people following the specified user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#list-followers-of-a-user
        """

        from ..models import SimpleUser

        url = f"/users/{username}/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    async def async_list_followers_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-followers-for-user

        GET /users/{username}/followers

        Lists the people following the specified user.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#list-followers-of-a-user
        """

        from ..models import SimpleUser

        url = f"/users/{username}/followers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    def list_following_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-following-for-user

        GET /users/{username}/following

        Lists the people who the specified user follows.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#list-the-people-a-user-follows
        """

        from ..models import SimpleUser

        url = f"/users/{username}/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    async def async_list_following_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """users/list-following-for-user

        GET /users/{username}/following

        Lists the people who the specified user follows.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#list-the-people-a-user-follows
        """

        from ..models import SimpleUser

        url = f"/users/{username}/following"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    def check_following_for_user(
        self,
        username: str,
        target_user: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/check-following-for-user

        GET /users/{username}/following/{target_user}

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#check-if-a-user-follows-another-user
        """

        url = f"/users/{username}/following/{target_user}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_following_for_user(
        self,
        username: str,
        target_user: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """users/check-following-for-user

        GET /users/{username}/following/{target_user}

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/followers#check-if-a-user-follows-another-user
        """

        url = f"/users/{username}/following/{target_user}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_gpg_keys_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[GpgKey], list[GpgKeyType]]:
        """users/list-gpg-keys-for-user

        GET /users/{username}/gpg_keys

        Lists the GPG keys for a user. This information is accessible by anyone.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#list-gpg-keys-for-a-user
        """

        from ..models import GpgKey

        url = f"/users/{username}/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[GpgKey],
        )

    async def async_list_gpg_keys_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[GpgKey], list[GpgKeyType]]:
        """users/list-gpg-keys-for-user

        GET /users/{username}/gpg_keys

        Lists the GPG keys for a user. This information is accessible by anyone.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/gpg-keys#list-gpg-keys-for-a-user
        """

        from ..models import GpgKey

        url = f"/users/{username}/gpg_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[GpgKey],
        )

    def get_context_for_user(
        self,
        username: str,
        *,
        subject_type: Missing[
            Literal["organization", "repository", "issue", "pull_request"]
        ] = UNSET,
        subject_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Hovercard, HovercardType]:
        """users/get-context-for-user

        GET /users/{username}/hovercard

        Provides hovercard information. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.

          The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository, you would use a `subject_type` value of `repository` and a `subject_id` value of `1300192` (the ID of the `Spoon-Knife` repository).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#get-contextual-information-for-a-user
        """

        from ..models import BasicError, Hovercard, ValidationError

        url = f"/users/{username}/hovercard"

        params = {
            "subject_type": subject_type,
            "subject_id": subject_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Hovercard,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_context_for_user(
        self,
        username: str,
        *,
        subject_type: Missing[
            Literal["organization", "repository", "issue", "pull_request"]
        ] = UNSET,
        subject_id: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Hovercard, HovercardType]:
        """users/get-context-for-user

        GET /users/{username}/hovercard

        Provides hovercard information. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.

          The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository, you would use a `subject_type` value of `repository` and a `subject_id` value of `1300192` (the ID of the `Spoon-Knife` repository).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/users#get-contextual-information-for-a-user
        """

        from ..models import BasicError, Hovercard, ValidationError

        url = f"/users/{username}/hovercard"

        params = {
            "subject_type": subject_type,
            "subject_id": subject_id,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Hovercard,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_public_keys_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[KeySimple], list[KeySimpleType]]:
        """users/list-public-keys-for-user

        GET /users/{username}/keys

        Lists the _verified_ public SSH keys for a user. This is accessible by anyone.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#list-public-keys-for-a-user
        """

        from ..models import KeySimple

        url = f"/users/{username}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[KeySimple],
        )

    async def async_list_public_keys_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[KeySimple], list[KeySimpleType]]:
        """users/list-public-keys-for-user

        GET /users/{username}/keys

        Lists the _verified_ public SSH keys for a user. This is accessible by anyone.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/keys#list-public-keys-for-a-user
        """

        from ..models import KeySimple

        url = f"/users/{username}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[KeySimple],
        )

    def list_social_accounts_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SocialAccount], list[SocialAccountType]]:
        """users/list-social-accounts-for-user

        GET /users/{username}/social_accounts

        Lists social media accounts for a user. This endpoint is accessible by anyone.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/social-accounts#list-social-accounts-for-a-user
        """

        from ..models import SocialAccount

        url = f"/users/{username}/social_accounts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SocialAccount],
        )

    async def async_list_social_accounts_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SocialAccount], list[SocialAccountType]]:
        """users/list-social-accounts-for-user

        GET /users/{username}/social_accounts

        Lists social media accounts for a user. This endpoint is accessible by anyone.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/social-accounts#list-social-accounts-for-a-user
        """

        from ..models import SocialAccount

        url = f"/users/{username}/social_accounts"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SocialAccount],
        )

    def list_ssh_signing_keys_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SshSigningKey], list[SshSigningKeyType]]:
        """users/list-ssh-signing-keys-for-user

        GET /users/{username}/ssh_signing_keys

        Lists the SSH signing keys for a user. This operation is accessible by anyone.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#list-ssh-signing-keys-for-a-user
        """

        from ..models import SshSigningKey

        url = f"/users/{username}/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SshSigningKey],
        )

    async def async_list_ssh_signing_keys_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SshSigningKey], list[SshSigningKeyType]]:
        """users/list-ssh-signing-keys-for-user

        GET /users/{username}/ssh_signing_keys

        Lists the SSH signing keys for a user. This operation is accessible by anyone.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/users/ssh-signing-keys#list-ssh-signing-keys-for-a-user
        """

        from ..models import SshSigningKey

        url = f"/users/{username}/ssh_signing_keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SshSigningKey],
        )
