"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        OrgPrivateRegistryConfiguration,
        OrgPrivateRegistryConfigurationWithSelectedRepositories,
        OrgsOrgPrivateRegistriesGetResponse200,
        OrgsOrgPrivateRegistriesPublicKeyGetResponse200,
    )
    from ..types import (
        OrgPrivateRegistryConfigurationType,
        OrgPrivateRegistryConfigurationWithSelectedRepositoriesType,
        OrgsOrgPrivateRegistriesGetResponse200Type,
        OrgsOrgPrivateRegistriesPostBodyType,
        OrgsOrgPrivateRegistriesPublicKeyGetResponse200Type,
        OrgsOrgPrivateRegistriesSecretNamePatchBodyType,
    )


class PrivateRegistriesClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_org_private_registries(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgPrivateRegistriesGetResponse200,
        OrgsOrgPrivateRegistriesGetResponse200Type,
    ]:
        """private-registries/list-org-private-registries

        GET /orgs/{org}/private-registries


        Lists all private registry configurations available at the organization-level without revealing their encrypted
        values.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#list-private-registries-for-an-organization
        """

        from ..models import BasicError, OrgsOrgPrivateRegistriesGetResponse200

        url = f"/orgs/{org}/private-registries"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgPrivateRegistriesGetResponse200,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_org_private_registries(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgPrivateRegistriesGetResponse200,
        OrgsOrgPrivateRegistriesGetResponse200Type,
    ]:
        """private-registries/list-org-private-registries

        GET /orgs/{org}/private-registries


        Lists all private registry configurations available at the organization-level without revealing their encrypted
        values.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#list-private-registries-for-an-organization
        """

        from ..models import BasicError, OrgsOrgPrivateRegistriesGetResponse200

        url = f"/orgs/{org}/private-registries"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgPrivateRegistriesGetResponse200,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_org_private_registry(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPrivateRegistriesPostBodyType,
    ) -> Response[
        OrgPrivateRegistryConfigurationWithSelectedRepositories,
        OrgPrivateRegistryConfigurationWithSelectedRepositoriesType,
    ]: ...

    @overload
    def create_org_private_registry(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        registry_type: Literal["maven_repository", "nuget_feed", "goproxy_server"],
        url: str,
        username: Missing[Union[str, None]] = UNSET,
        encrypted_value: str,
        key_id: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[
        OrgPrivateRegistryConfigurationWithSelectedRepositories,
        OrgPrivateRegistryConfigurationWithSelectedRepositoriesType,
    ]: ...

    def create_org_private_registry(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPrivateRegistriesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgPrivateRegistryConfigurationWithSelectedRepositories,
        OrgPrivateRegistryConfigurationWithSelectedRepositoriesType,
    ]:
        """private-registries/create-org-private-registry

        POST /orgs/{org}/private-registries


        Creates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#create-a-private-registry-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgPrivateRegistryConfigurationWithSelectedRepositories,
            OrgsOrgPrivateRegistriesPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/private-registries"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPrivateRegistriesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgPrivateRegistryConfigurationWithSelectedRepositories,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_org_private_registry(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPrivateRegistriesPostBodyType,
    ) -> Response[
        OrgPrivateRegistryConfigurationWithSelectedRepositories,
        OrgPrivateRegistryConfigurationWithSelectedRepositoriesType,
    ]: ...

    @overload
    async def async_create_org_private_registry(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        registry_type: Literal["maven_repository", "nuget_feed", "goproxy_server"],
        url: str,
        username: Missing[Union[str, None]] = UNSET,
        encrypted_value: str,
        key_id: str,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response[
        OrgPrivateRegistryConfigurationWithSelectedRepositories,
        OrgPrivateRegistryConfigurationWithSelectedRepositoriesType,
    ]: ...

    async def async_create_org_private_registry(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPrivateRegistriesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgPrivateRegistryConfigurationWithSelectedRepositories,
        OrgPrivateRegistryConfigurationWithSelectedRepositoriesType,
    ]:
        """private-registries/create-org-private-registry

        POST /orgs/{org}/private-registries


        Creates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#create-a-private-registry-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgPrivateRegistryConfigurationWithSelectedRepositories,
            OrgsOrgPrivateRegistriesPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/private-registries"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPrivateRegistriesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgPrivateRegistryConfigurationWithSelectedRepositories,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgPrivateRegistriesPublicKeyGetResponse200,
        OrgsOrgPrivateRegistriesPublicKeyGetResponse200Type,
    ]:
        """private-registries/get-org-public-key

        GET /orgs/{org}/private-registries/public-key


        Gets the org public key, which is needed to encrypt private registry secrets. You need to encrypt a secret before you can create or update secrets.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#get-private-registries-public-key-for-an-organization
        """

        from ..models import BasicError, OrgsOrgPrivateRegistriesPublicKeyGetResponse200

        url = f"/orgs/{org}/private-registries/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgPrivateRegistriesPublicKeyGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        OrgsOrgPrivateRegistriesPublicKeyGetResponse200,
        OrgsOrgPrivateRegistriesPublicKeyGetResponse200Type,
    ]:
        """private-registries/get-org-public-key

        GET /orgs/{org}/private-registries/public-key


        Gets the org public key, which is needed to encrypt private registry secrets. You need to encrypt a secret before you can create or update secrets.

        OAuth tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#get-private-registries-public-key-for-an-organization
        """

        from ..models import BasicError, OrgsOrgPrivateRegistriesPublicKeyGetResponse200

        url = f"/orgs/{org}/private-registries/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgsOrgPrivateRegistriesPublicKeyGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    def get_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrgPrivateRegistryConfiguration, OrgPrivateRegistryConfigurationType]:
        """private-registries/get-org-private-registry

        GET /orgs/{org}/private-registries/{secret_name}


        Get the configuration of a single private registry defined for an organization, omitting its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#get-a-private-registry-for-an-organization
        """

        from ..models import BasicError, OrgPrivateRegistryConfiguration

        url = f"/orgs/{org}/private-registries/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgPrivateRegistryConfiguration,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[OrgPrivateRegistryConfiguration, OrgPrivateRegistryConfigurationType]:
        """private-registries/get-org-private-registry

        GET /orgs/{org}/private-registries/{secret_name}


        Get the configuration of a single private registry defined for an organization, omitting its encrypted value.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#get-a-private-registry-for-an-organization
        """

        from ..models import BasicError, OrgPrivateRegistryConfiguration

        url = f"/orgs/{org}/private-registries/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=OrgPrivateRegistryConfiguration,
            error_models={
                "404": BasicError,
            },
        )

    def delete_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """private-registries/delete-org-private-registry

        DELETE /orgs/{org}/private-registries/{secret_name}


        Delete a private registry configuration at the organization-level.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#delete-a-private-registry-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/private-registries/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """private-registries/delete-org-private-registry

        DELETE /orgs/{org}/private-registries/{secret_name}


        Delete a private registry configuration at the organization-level.

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#delete-a-private-registry-for-an-organization
        """

        from ..models import BasicError

        url = f"/orgs/{org}/private-registries/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPrivateRegistriesSecretNamePatchBodyType,
    ) -> Response: ...

    @overload
    def update_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        registry_type: Missing[
            Literal["maven_repository", "nuget_feed", "goproxy_server"]
        ] = UNSET,
        url: Missing[str] = UNSET,
        username: Missing[Union[str, None]] = UNSET,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Missing[Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response: ...

    def update_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPrivateRegistriesSecretNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """private-registries/update-org-private-registry

        PATCH /orgs/{org}/private-registries/{secret_name}


        Updates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#update-a-private-registry-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgPrivateRegistriesSecretNamePatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/private-registries/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPrivateRegistriesSecretNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgPrivateRegistriesSecretNamePatchBodyType,
    ) -> Response: ...

    @overload
    async def async_update_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        registry_type: Missing[
            Literal["maven_repository", "nuget_feed", "goproxy_server"]
        ] = UNSET,
        url: Missing[str] = UNSET,
        username: Missing[Union[str, None]] = UNSET,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Missing[Literal["all", "private", "selected"]] = UNSET,
        selected_repository_ids: Missing[list[int]] = UNSET,
    ) -> Response: ...

    async def async_update_org_private_registry(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgPrivateRegistriesSecretNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """private-registries/update-org-private-registry

        PATCH /orgs/{org}/private-registries/{secret_name}


        Updates a private registry configuration with an encrypted value for an organization. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). For more information, see "[Encrypting secrets for the REST API](https://docs.github.com/enterprise-cloud@latest//rest/guides/encrypting-secrets-for-the-rest-api)."

        OAuth app tokens and personal access tokens (classic) need the `admin:org` scope to use this endpoint.

        See also: https://docs.github.com/enterprise-cloud@latest//rest/private-registries/organization-configurations#update-a-private-registry-for-an-organization
        """

        from ..models import (
            BasicError,
            OrgsOrgPrivateRegistriesSecretNamePatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/private-registries/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPrivateRegistriesSecretNamePatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )
