"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        Event,
        Feed,
        MinimalRepository,
        NotificationsPutResponse202,
        Repository,
        RepositorySubscription,
        ReposOwnerRepoNotificationsPutResponse202,
        SimpleUser,
        Stargazer,
        StarredRepository,
        Thread,
        ThreadSubscription,
    )
    from ..types import (
        EventType,
        FeedType,
        MinimalRepositoryType,
        NotificationsPutBodyType,
        NotificationsPutResponse202Type,
        NotificationsThreadsThreadIdSubscriptionPutBodyType,
        RepositorySubscriptionType,
        RepositoryType,
        ReposOwnerRepoNotificationsPutBodyType,
        ReposOwnerRepoNotificationsPutResponse202Type,
        ReposOwnerRepoSubscriptionPutBodyType,
        SimpleUserType,
        StargazerType,
        StarredRepositoryType,
        ThreadSubscriptionType,
        ThreadType,
    )


class ActivityClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_public_events(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-public-events

        GET /events

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-events
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            Event,
        )

        url = "/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
            error_models={
                "403": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_list_public_events(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-public-events

        GET /events

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-events
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            Event,
        )

        url = "/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
            error_models={
                "403": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def get_feeds(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Feed, FeedType]:
        """activity/get-feeds

        GET /feeds

        Lists the feeds available to the authenticated user. The response provides a URL for each feed. You can then get a specific feed by sending a request to one of the feed URLs.

        *   **Timeline**: The GitHub global public timeline
        *   **User**: The public timeline for any user, using `uri_template`. For more information, see "[Hypermedia](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."
        *   **Current user public**: The public timeline for the authenticated user
        *   **Current user**: The private timeline for the authenticated user
        *   **Current user actor**: The private timeline for activity created by the authenticated user
        *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
        *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.

        By default, timeline resources are returned in JSON. You can specify the `application/atom+xml` type in the `Accept` header to return timeline resources in Atom format. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        > [!NOTE]
        > Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) since current feed URIs use the older, non revocable auth tokens.

        See also: https://docs.github.com/rest/activity/feeds#get-feeds
        """

        from ..models import Feed

        url = "/feeds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Feed,
        )

    async def async_get_feeds(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Feed, FeedType]:
        """activity/get-feeds

        GET /feeds

        Lists the feeds available to the authenticated user. The response provides a URL for each feed. You can then get a specific feed by sending a request to one of the feed URLs.

        *   **Timeline**: The GitHub global public timeline
        *   **User**: The public timeline for any user, using `uri_template`. For more information, see "[Hypermedia](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."
        *   **Current user public**: The public timeline for the authenticated user
        *   **Current user**: The private timeline for the authenticated user
        *   **Current user actor**: The private timeline for activity created by the authenticated user
        *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
        *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.

        By default, timeline resources are returned in JSON. You can specify the `application/atom+xml` type in the `Accept` header to return timeline resources in Atom format. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        > [!NOTE]
        > Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/authentication/authenticating-to-the-rest-api#using-basic-authentication) since current feed URIs use the older, non revocable auth tokens.

        See also: https://docs.github.com/rest/activity/feeds#get-feeds
        """

        from ..models import Feed

        url = "/feeds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Feed,
        )

    def list_public_events_for_repo_network(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-public-events-for-repo-network

        GET /networks/{owner}/{repo}/events

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-events-for-a-network-of-repositories
        """

        from ..models import BasicError, Event

        url = f"/networks/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_public_events_for_repo_network(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-public-events-for-repo-network

        GET /networks/{owner}/{repo}/events

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-events-for-a-network-of-repositories
        """

        from ..models import BasicError, Event

        url = f"/networks/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_notifications_for_authenticated_user(
        self,
        *,
        all_: Missing[bool] = UNSET,
        participating: Missing[bool] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Thread], list[ThreadType]]:
        """activity/list-notifications-for-authenticated-user

        GET /notifications

        List all notifications for the current user, sorted by most recently updated.

        See also: https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user
        """

        from ..models import BasicError, Thread, ValidationError

        url = "/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Thread],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_notifications_for_authenticated_user(
        self,
        *,
        all_: Missing[bool] = UNSET,
        participating: Missing[bool] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Thread], list[ThreadType]]:
        """activity/list-notifications-for-authenticated-user

        GET /notifications

        List all notifications for the current user, sorted by most recently updated.

        See also: https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user
        """

        from ..models import BasicError, Thread, ValidationError

        url = "/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Thread],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def mark_notifications_as_read(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[NotificationsPutBodyType] = UNSET,
    ) -> Response[NotificationsPutResponse202, NotificationsPutResponse202Type]: ...

    @overload
    def mark_notifications_as_read(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        last_read_at: Missing[datetime] = UNSET,
        read: Missing[bool] = UNSET,
    ) -> Response[NotificationsPutResponse202, NotificationsPutResponse202Type]: ...

    def mark_notifications_as_read(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[NotificationsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[NotificationsPutResponse202, NotificationsPutResponse202Type]:
        """activity/mark-notifications-as-read

        PUT /notifications

        Marks all notifications as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.

        See also: https://docs.github.com/rest/activity/notifications#mark-notifications-as-read
        """

        from ..models import (
            BasicError,
            NotificationsPutBody,
            NotificationsPutResponse202,
        )

        url = "/notifications"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(NotificationsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NotificationsPutResponse202,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_mark_notifications_as_read(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[NotificationsPutBodyType] = UNSET,
    ) -> Response[NotificationsPutResponse202, NotificationsPutResponse202Type]: ...

    @overload
    async def async_mark_notifications_as_read(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        last_read_at: Missing[datetime] = UNSET,
        read: Missing[bool] = UNSET,
    ) -> Response[NotificationsPutResponse202, NotificationsPutResponse202Type]: ...

    async def async_mark_notifications_as_read(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[NotificationsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[NotificationsPutResponse202, NotificationsPutResponse202Type]:
        """activity/mark-notifications-as-read

        PUT /notifications

        Marks all notifications as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.

        See also: https://docs.github.com/rest/activity/notifications#mark-notifications-as-read
        """

        from ..models import (
            BasicError,
            NotificationsPutBody,
            NotificationsPutResponse202,
        )

        url = "/notifications"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(NotificationsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=NotificationsPutResponse202,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def get_thread(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Thread, ThreadType]:
        """activity/get-thread

        GET /notifications/threads/{thread_id}

        Gets information about a notification thread.

        See also: https://docs.github.com/rest/activity/notifications#get-a-thread
        """

        from ..models import BasicError, Thread

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Thread,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_thread(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Thread, ThreadType]:
        """activity/get-thread

        GET /notifications/threads/{thread_id}

        Gets information about a notification thread.

        See also: https://docs.github.com/rest/activity/notifications#get-a-thread
        """

        from ..models import BasicError, Thread

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Thread,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def mark_thread_as_done(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/mark-thread-as-done

        DELETE /notifications/threads/{thread_id}

        Marks a thread as "done." Marking a thread as "done" is equivalent to marking a notification in your notification inbox on GitHub as done: https://github.com/notifications.

        See also: https://docs.github.com/rest/activity/notifications#mark-a-thread-as-done
        """

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_mark_thread_as_done(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/mark-thread-as-done

        DELETE /notifications/threads/{thread_id}

        Marks a thread as "done." Marking a thread as "done" is equivalent to marking a notification in your notification inbox on GitHub as done: https://github.com/notifications.

        See also: https://docs.github.com/rest/activity/notifications#mark-a-thread-as-done
        """

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def mark_thread_as_read(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/mark-thread-as-read

        PATCH /notifications/threads/{thread_id}

        Marks a thread as "read." Marking a thread as "read" is equivalent to clicking a notification in your notification inbox on GitHub: https://github.com/notifications.

        See also: https://docs.github.com/rest/activity/notifications#mark-a-thread-as-read
        """

        from ..models import BasicError

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    async def async_mark_thread_as_read(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/mark-thread-as-read

        PATCH /notifications/threads/{thread_id}

        Marks a thread as "read." Marking a thread as "read" is equivalent to clicking a notification in your notification inbox on GitHub: https://github.com/notifications.

        See also: https://docs.github.com/rest/activity/notifications#mark-a-thread-as-read
        """

        from ..models import BasicError

        url = f"/notifications/threads/{thread_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    def get_thread_subscription_for_authenticated_user(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ThreadSubscription, ThreadSubscriptionType]:
        """activity/get-thread-subscription-for-authenticated-user

        GET /notifications/threads/{thread_id}/subscription

        This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/activity/watching#get-a-repository-subscription).

        Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.

        See also: https://docs.github.com/rest/activity/notifications#get-a-thread-subscription-for-the-authenticated-user
        """

        from ..models import BasicError, ThreadSubscription

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_thread_subscription_for_authenticated_user(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ThreadSubscription, ThreadSubscriptionType]:
        """activity/get-thread-subscription-for-authenticated-user

        GET /notifications/threads/{thread_id}/subscription

        This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/activity/watching#get-a-repository-subscription).

        Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.

        See also: https://docs.github.com/rest/activity/notifications#get-a-thread-subscription-for-the-authenticated-user
        """

        from ..models import BasicError, ThreadSubscription

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def set_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[NotificationsThreadsThreadIdSubscriptionPutBodyType] = UNSET,
    ) -> Response[ThreadSubscription, ThreadSubscriptionType]: ...

    @overload
    def set_thread_subscription(
        self,
        thread_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ignored: Missing[bool] = UNSET,
    ) -> Response[ThreadSubscription, ThreadSubscriptionType]: ...

    def set_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[NotificationsThreadsThreadIdSubscriptionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ThreadSubscription, ThreadSubscriptionType]:
        """activity/set-thread-subscription

        PUT /notifications/threads/{thread_id}/subscription

        If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.

        You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.

        Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/activity/notifications#delete-a-thread-subscription) endpoint.

        See also: https://docs.github.com/rest/activity/notifications#set-a-thread-subscription
        """

        from ..models import (
            BasicError,
            NotificationsThreadsThreadIdSubscriptionPutBody,
            ThreadSubscription,
        )

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                NotificationsThreadsThreadIdSubscriptionPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_set_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[NotificationsThreadsThreadIdSubscriptionPutBodyType] = UNSET,
    ) -> Response[ThreadSubscription, ThreadSubscriptionType]: ...

    @overload
    async def async_set_thread_subscription(
        self,
        thread_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ignored: Missing[bool] = UNSET,
    ) -> Response[ThreadSubscription, ThreadSubscriptionType]: ...

    async def async_set_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[NotificationsThreadsThreadIdSubscriptionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ThreadSubscription, ThreadSubscriptionType]:
        """activity/set-thread-subscription

        PUT /notifications/threads/{thread_id}/subscription

        If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.

        You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.

        Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/activity/notifications#delete-a-thread-subscription) endpoint.

        See also: https://docs.github.com/rest/activity/notifications#set-a-thread-subscription
        """

        from ..models import (
            BasicError,
            NotificationsThreadsThreadIdSubscriptionPutBody,
            ThreadSubscription,
        )

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                NotificationsThreadsThreadIdSubscriptionPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ThreadSubscription,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/delete-thread-subscription

        DELETE /notifications/threads/{thread_id}/subscription

        Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/activity/notifications#set-a-thread-subscription) endpoint and set `ignore` to `true`.

        See also: https://docs.github.com/rest/activity/notifications#delete-a-thread-subscription
        """

        from ..models import BasicError

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_thread_subscription(
        self,
        thread_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/delete-thread-subscription

        DELETE /notifications/threads/{thread_id}/subscription

        Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/activity/notifications#set-a-thread-subscription) endpoint and set `ignore` to `true`.

        See also: https://docs.github.com/rest/activity/notifications#delete-a-thread-subscription
        """

        from ..models import BasicError

        url = f"/notifications/threads/{thread_id}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_public_org_events(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-public-org-events

        GET /orgs/{org}/events

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-organization-events
        """

        from ..models import Event

        url = f"/orgs/{org}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    async def async_list_public_org_events(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-public-org-events

        GET /orgs/{org}/events

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-organization-events
        """

        from ..models import Event

        url = f"/orgs/{org}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    def list_repo_events(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-repo-events

        GET /repos/{owner}/{repo}/events

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-repository-events
        """

        from ..models import Event

        url = f"/repos/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    async def async_list_repo_events(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-repo-events

        GET /repos/{owner}/{repo}/events

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-repository-events
        """

        from ..models import Event

        url = f"/repos/{owner}/{repo}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    def list_repo_notifications_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        all_: Missing[bool] = UNSET,
        participating: Missing[bool] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Thread], list[ThreadType]]:
        """activity/list-repo-notifications-for-authenticated-user

        GET /repos/{owner}/{repo}/notifications

        Lists all notifications for the current user in the specified repository.

        See also: https://docs.github.com/rest/activity/notifications#list-repository-notifications-for-the-authenticated-user
        """

        from ..models import Thread

        url = f"/repos/{owner}/{repo}/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Thread],
        )

    async def async_list_repo_notifications_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        all_: Missing[bool] = UNSET,
        participating: Missing[bool] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Thread], list[ThreadType]]:
        """activity/list-repo-notifications-for-authenticated-user

        GET /repos/{owner}/{repo}/notifications

        Lists all notifications for the current user in the specified repository.

        See also: https://docs.github.com/rest/activity/notifications#list-repository-notifications-for-the-authenticated-user
        """

        from ..models import Thread

        url = f"/repos/{owner}/{repo}/notifications"

        params = {
            "all": all_,
            "participating": participating,
            "since": since,
            "before": before,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Thread],
        )

    @overload
    def mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoNotificationsPutBodyType] = UNSET,
    ) -> Response[
        ReposOwnerRepoNotificationsPutResponse202,
        ReposOwnerRepoNotificationsPutResponse202Type,
    ]: ...

    @overload
    def mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        last_read_at: Missing[datetime] = UNSET,
    ) -> Response[
        ReposOwnerRepoNotificationsPutResponse202,
        ReposOwnerRepoNotificationsPutResponse202Type,
    ]: ...

    def mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoNotificationsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoNotificationsPutResponse202,
        ReposOwnerRepoNotificationsPutResponse202Type,
    ]:
        """activity/mark-repo-notifications-as-read

        PUT /repos/{owner}/{repo}/notifications

        Marks all notifications in a repository as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.

        See also: https://docs.github.com/rest/activity/notifications#mark-repository-notifications-as-read
        """

        from ..models import (
            ReposOwnerRepoNotificationsPutBody,
            ReposOwnerRepoNotificationsPutResponse202,
        )

        url = f"/repos/{owner}/{repo}/notifications"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoNotificationsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoNotificationsPutResponse202,
        )

    @overload
    async def async_mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoNotificationsPutBodyType] = UNSET,
    ) -> Response[
        ReposOwnerRepoNotificationsPutResponse202,
        ReposOwnerRepoNotificationsPutResponse202Type,
    ]: ...

    @overload
    async def async_mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        last_read_at: Missing[datetime] = UNSET,
    ) -> Response[
        ReposOwnerRepoNotificationsPutResponse202,
        ReposOwnerRepoNotificationsPutResponse202Type,
    ]: ...

    async def async_mark_repo_notifications_as_read(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoNotificationsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoNotificationsPutResponse202,
        ReposOwnerRepoNotificationsPutResponse202Type,
    ]:
        """activity/mark-repo-notifications-as-read

        PUT /repos/{owner}/{repo}/notifications

        Marks all notifications in a repository as "read" for the current user. If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/rest/activity/notifications#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.

        See also: https://docs.github.com/rest/activity/notifications#mark-repository-notifications-as-read
        """

        from ..models import (
            ReposOwnerRepoNotificationsPutBody,
            ReposOwnerRepoNotificationsPutResponse202,
        )

        url = f"/repos/{owner}/{repo}/notifications"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoNotificationsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoNotificationsPutResponse202,
        )

    def list_stargazers_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[list[SimpleUser], list[Stargazer]],
        Union[list[SimpleUserType], list[StargazerType]],
    ]:
        """activity/list-stargazers-for-repo

        GET /repos/{owner}/{repo}/stargazers

        Lists the people that have starred the repository.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.

        See also: https://docs.github.com/rest/activity/starring#list-stargazers
        """

        from typing import Union

        from ..models import SimpleUser, Stargazer, ValidationError

        url = f"/repos/{owner}/{repo}/stargazers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[list[SimpleUser], list[Stargazer]],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_stargazers_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[list[SimpleUser], list[Stargazer]],
        Union[list[SimpleUserType], list[StargazerType]],
    ]:
        """activity/list-stargazers-for-repo

        GET /repos/{owner}/{repo}/stargazers

        Lists the people that have starred the repository.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.

        See also: https://docs.github.com/rest/activity/starring#list-stargazers
        """

        from typing import Union

        from ..models import SimpleUser, Stargazer, ValidationError

        url = f"/repos/{owner}/{repo}/stargazers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[list[SimpleUser], list[Stargazer]],
            error_models={
                "422": ValidationError,
            },
        )

    def list_watchers_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """activity/list-watchers-for-repo

        GET /repos/{owner}/{repo}/subscribers

        Lists the people watching the specified repository.

        See also: https://docs.github.com/rest/activity/watching#list-watchers
        """

        from ..models import SimpleUser

        url = f"/repos/{owner}/{repo}/subscribers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    async def async_list_watchers_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """activity/list-watchers-for-repo

        GET /repos/{owner}/{repo}/subscribers

        Lists the people watching the specified repository.

        See also: https://docs.github.com/rest/activity/watching#list-watchers
        """

        from ..models import SimpleUser

        url = f"/repos/{owner}/{repo}/subscribers"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
        )

    def get_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepositorySubscription, RepositorySubscriptionType]:
        """activity/get-repo-subscription

        GET /repos/{owner}/{repo}/subscription

        Gets information about whether the authenticated user is subscribed to the repository.

        See also: https://docs.github.com/rest/activity/watching#get-a-repository-subscription
        """

        from ..models import BasicError, RepositorySubscription

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositorySubscription,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepositorySubscription, RepositorySubscriptionType]:
        """activity/get-repo-subscription

        GET /repos/{owner}/{repo}/subscription

        Gets information about whether the authenticated user is subscribed to the repository.

        See also: https://docs.github.com/rest/activity/watching#get-a-repository-subscription
        """

        from ..models import BasicError, RepositorySubscription

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositorySubscription,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoSubscriptionPutBodyType] = UNSET,
    ) -> Response[RepositorySubscription, RepositorySubscriptionType]: ...

    @overload
    def set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        subscribed: Missing[bool] = UNSET,
        ignored: Missing[bool] = UNSET,
    ) -> Response[RepositorySubscription, RepositorySubscriptionType]: ...

    def set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoSubscriptionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositorySubscription, RepositorySubscriptionType]:
        """activity/set-repo-subscription

        PUT /repos/{owner}/{repo}/subscription

        If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/rest/activity/watching#delete-a-repository-subscription) completely.

        See also: https://docs.github.com/rest/activity/watching#set-a-repository-subscription
        """

        from ..models import RepositorySubscription, ReposOwnerRepoSubscriptionPutBody

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoSubscriptionPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositorySubscription,
        )

    @overload
    async def async_set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoSubscriptionPutBodyType] = UNSET,
    ) -> Response[RepositorySubscription, RepositorySubscriptionType]: ...

    @overload
    async def async_set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        subscribed: Missing[bool] = UNSET,
        ignored: Missing[bool] = UNSET,
    ) -> Response[RepositorySubscription, RepositorySubscriptionType]: ...

    async def async_set_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoSubscriptionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositorySubscription, RepositorySubscriptionType]:
        """activity/set-repo-subscription

        PUT /repos/{owner}/{repo}/subscription

        If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/rest/activity/watching#delete-a-repository-subscription) completely.

        See also: https://docs.github.com/rest/activity/watching#set-a-repository-subscription
        """

        from ..models import RepositorySubscription, ReposOwnerRepoSubscriptionPutBody

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoSubscriptionPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositorySubscription,
        )

    def delete_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/delete-repo-subscription

        DELETE /repos/{owner}/{repo}/subscription

        This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/rest/activity/watching#set-a-repository-subscription).

        See also: https://docs.github.com/rest/activity/watching#delete-a-repository-subscription
        """

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_repo_subscription(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/delete-repo-subscription

        DELETE /repos/{owner}/{repo}/subscription

        This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/rest/activity/watching#set-a-repository-subscription).

        See also: https://docs.github.com/rest/activity/watching#delete-a-repository-subscription
        """

        url = f"/repos/{owner}/{repo}/subscription"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_repos_starred_by_authenticated_user(
        self,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Repository], list[RepositoryType]]:
        """activity/list-repos-starred-by-authenticated-user

        GET /user/starred

        Lists repositories the authenticated user has starred.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.

        See also: https://docs.github.com/rest/activity/starring#list-repositories-starred-by-the-authenticated-user
        """

        from ..models import BasicError, Repository

        url = "/user/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Repository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_repos_starred_by_authenticated_user(
        self,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Repository], list[RepositoryType]]:
        """activity/list-repos-starred-by-authenticated-user

        GET /user/starred

        Lists repositories the authenticated user has starred.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.

        See also: https://docs.github.com/rest/activity/starring#list-repositories-starred-by-the-authenticated-user
        """

        from ..models import BasicError, Repository

        url = "/user/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Repository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def check_repo_is_starred_by_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/check-repo-is-starred-by-authenticated-user

        GET /user/starred/{owner}/{repo}

        Whether the authenticated user has starred the repository.

        See also: https://docs.github.com/rest/activity/starring#check-if-a-repository-is-starred-by-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    async def async_check_repo_is_starred_by_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/check-repo-is-starred-by-authenticated-user

        GET /user/starred/{owner}/{repo}

        Whether the authenticated user has starred the repository.

        See also: https://docs.github.com/rest/activity/starring#check-if-a-repository-is-starred-by-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    def star_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/star-repo-for-authenticated-user

        PUT /user/starred/{owner}/{repo}

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/rest/activity/starring#star-a-repository-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_star_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/star-repo-for-authenticated-user

        PUT /user/starred/{owner}/{repo}

        Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."

        See also: https://docs.github.com/rest/activity/starring#star-a-repository-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    def unstar_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/unstar-repo-for-authenticated-user

        DELETE /user/starred/{owner}/{repo}

        Unstar a repository that the authenticated user has previously starred.

        See also: https://docs.github.com/rest/activity/starring#unstar-a-repository-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    async def async_unstar_repo_for_authenticated_user(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """activity/unstar-repo-for-authenticated-user

        DELETE /user/starred/{owner}/{repo}

        Unstar a repository that the authenticated user has previously starred.

        See also: https://docs.github.com/rest/activity/starring#unstar-a-repository-for-the-authenticated-user
        """

        from ..models import BasicError

        url = f"/user/starred/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "401": BasicError,
                "403": BasicError,
            },
        )

    def list_watched_repos_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """activity/list-watched-repos-for-authenticated-user

        GET /user/subscriptions

        Lists repositories the authenticated user is watching.

        See also: https://docs.github.com/rest/activity/watching#list-repositories-watched-by-the-authenticated-user
        """

        from ..models import BasicError, MinimalRepository

        url = "/user/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_watched_repos_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """activity/list-watched-repos-for-authenticated-user

        GET /user/subscriptions

        Lists repositories the authenticated user is watching.

        See also: https://docs.github.com/rest/activity/watching#list-repositories-watched-by-the-authenticated-user
        """

        from ..models import BasicError, MinimalRepository

        url = "/user/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_events_for_authenticated_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-events-for-authenticated-user

        GET /users/{username}/events

        If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events. _Optional_: use the fine-grained token with following permission set to view private events: "Events" user permissions (read).

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-events-for-the-authenticated-user
        """

        from ..models import Event

        url = f"/users/{username}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    async def async_list_events_for_authenticated_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-events-for-authenticated-user

        GET /users/{username}/events

        If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events. _Optional_: use the fine-grained token with following permission set to view private events: "Events" user permissions (read).

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-events-for-the-authenticated-user
        """

        from ..models import Event

        url = f"/users/{username}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    def list_org_events_for_authenticated_user(
        self,
        username: str,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-org-events-for-authenticated-user

        GET /users/{username}/events/orgs/{org}

        This is the user's organization dashboard. You must be authenticated as the user to view this.

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-organization-events-for-the-authenticated-user
        """

        from ..models import Event

        url = f"/users/{username}/events/orgs/{org}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    async def async_list_org_events_for_authenticated_user(
        self,
        username: str,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-org-events-for-authenticated-user

        GET /users/{username}/events/orgs/{org}

        This is the user's organization dashboard. You must be authenticated as the user to view this.

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-organization-events-for-the-authenticated-user
        """

        from ..models import Event

        url = f"/users/{username}/events/orgs/{org}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    def list_public_events_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-public-events-for-user

        GET /users/{username}/events/public

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-events-for-a-user
        """

        from ..models import Event

        url = f"/users/{username}/events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    async def async_list_public_events_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-public-events-for-user

        GET /users/{username}/events/public

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-events-for-a-user
        """

        from ..models import Event

        url = f"/users/{username}/events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    def list_received_events_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-received-events-for-user

        GET /users/{username}/received_events

        These are events that you've received by watching repositories and following users. If you are authenticated as the
        given user, you will see private events. Otherwise, you'll only see public events.

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-events-received-by-the-authenticated-user
        """

        from ..models import Event

        url = f"/users/{username}/received_events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    async def async_list_received_events_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-received-events-for-user

        GET /users/{username}/received_events

        These are events that you've received by watching repositories and following users. If you are authenticated as the
        given user, you will see private events. Otherwise, you'll only see public events.

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-events-received-by-the-authenticated-user
        """

        from ..models import Event

        url = f"/users/{username}/received_events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    def list_received_public_events_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-received-public-events-for-user

        GET /users/{username}/received_events/public

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-events-received-by-a-user
        """

        from ..models import Event

        url = f"/users/{username}/received_events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    async def async_list_received_public_events_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Event], list[EventType]]:
        """activity/list-received-public-events-for-user

        GET /users/{username}/received_events/public

        > [!NOTE]
        > This API is not built to serve real-time use cases. Depending on the time of day, event latency can be anywhere from 30s to 6h.

        See also: https://docs.github.com/rest/activity/events#list-public-events-received-by-a-user
        """

        from ..models import Event

        url = f"/users/{username}/received_events/public"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Event],
        )

    def list_repos_starred_by_user(
        self,
        username: str,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[list[StarredRepository], list[Repository]],
        Union[list[StarredRepositoryType], list[RepositoryType]],
    ]:
        """activity/list-repos-starred-by-user

        GET /users/{username}/starred

        Lists repositories a user has starred.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.

        See also: https://docs.github.com/rest/activity/starring#list-repositories-starred-by-a-user
        """

        from typing import Union

        from ..models import Repository, StarredRepository

        url = f"/users/{username}/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[list[StarredRepository], list[Repository]],
        )

    async def async_list_repos_starred_by_user(
        self,
        username: str,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[list[StarredRepository], list[Repository]],
        Union[list[StarredRepositoryType], list[RepositoryType]],
    ]:
        """activity/list-repos-starred-by-user

        GET /users/{username}/starred

        Lists repositories a user has starred.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.star+json`**: Includes a timestamp of when the star was created.

        See also: https://docs.github.com/rest/activity/starring#list-repositories-starred-by-a-user
        """

        from typing import Union

        from ..models import Repository, StarredRepository

        url = f"/users/{username}/starred"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[list[StarredRepository], list[Repository]],
        )

    def list_repos_watched_by_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """activity/list-repos-watched-by-user

        GET /users/{username}/subscriptions

        Lists repositories a user is watching.

        See also: https://docs.github.com/rest/activity/watching#list-repositories-watched-by-a-user
        """

        from ..models import MinimalRepository

        url = f"/users/{username}/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
        )

    async def async_list_repos_watched_by_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """activity/list-repos-watched-by-user

        GET /users/{username}/subscriptions

        Lists repositories a user is watching.

        See also: https://docs.github.com/rest/activity/watching#list-repositories-watched-by-a-user
        """

        from ..models import MinimalRepository

        url = f"/users/{username}/subscriptions"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
        )
