"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import TYPE_CHECKING, Annotated, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel, Field

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        AddedToProjectIssueEvent,
        AssignedIssueEvent,
        ConvertedNoteToIssueIssueEvent,
        DemilestonedIssueEvent,
        Issue,
        IssueComment,
        IssueEvent,
        Label,
        LabeledIssueEvent,
        LockedIssueEvent,
        Milestone,
        MilestonedIssueEvent,
        MovedColumnInProjectIssueEvent,
        RemovedFromProjectIssueEvent,
        RenamedIssueEvent,
        ReviewDismissedIssueEvent,
        ReviewRequestedIssueEvent,
        ReviewRequestRemovedIssueEvent,
        SimpleUser,
        StateChangeIssueEvent,
        TimelineAssignedIssueEvent,
        TimelineCommentEvent,
        TimelineCommitCommentedEvent,
        TimelineCommittedEvent,
        TimelineCrossReferencedEvent,
        TimelineLineCommentedEvent,
        TimelineReviewedEvent,
        TimelineUnassignedIssueEvent,
        UnassignedIssueEvent,
        UnlabeledIssueEvent,
    )
    from ..types import (
        AddedToProjectIssueEventType,
        AssignedIssueEventType,
        ConvertedNoteToIssueIssueEventType,
        DemilestonedIssueEventType,
        IssueCommentType,
        IssueEventType,
        IssueType,
        LabeledIssueEventType,
        LabelType,
        LockedIssueEventType,
        MilestonedIssueEventType,
        MilestoneType,
        MovedColumnInProjectIssueEventType,
        RemovedFromProjectIssueEventType,
        RenamedIssueEventType,
        ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType,
        ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType,
        ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType,
        ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType,
        ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
        ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType,
        ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
        ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType,
        ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
        ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType,
        ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
        ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType,
        ReposOwnerRepoIssuesIssueNumberLockPutBodyType,
        ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
        ReposOwnerRepoIssuesIssueNumberPatchBodyType,
        ReposOwnerRepoIssuesIssueNumberSubIssueDeleteBodyType,
        ReposOwnerRepoIssuesIssueNumberSubIssuesPostBodyType,
        ReposOwnerRepoIssuesIssueNumberSubIssuesPriorityPatchBodyType,
        ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type,
        ReposOwnerRepoIssuesPostBodyType,
        ReposOwnerRepoLabelsNamePatchBodyType,
        ReposOwnerRepoLabelsPostBodyType,
        ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType,
        ReposOwnerRepoMilestonesPostBodyType,
        ReviewDismissedIssueEventType,
        ReviewRequestedIssueEventType,
        ReviewRequestRemovedIssueEventType,
        SimpleUserType,
        StateChangeIssueEventType,
        TimelineAssignedIssueEventType,
        TimelineCommentEventType,
        TimelineCommitCommentedEventType,
        TimelineCommittedEventType,
        TimelineCrossReferencedEventType,
        TimelineLineCommentedEventType,
        TimelineReviewedEventType,
        TimelineUnassignedIssueEventType,
        UnassignedIssueEventType,
        UnlabeledIssueEventType,
    )


class IssuesClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        *,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        collab: Missing[bool] = UNSET,
        orgs: Missing[bool] = UNSET,
        owned: Missing[bool] = UNSET,
        pulls: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#list-issues-assigned-to-the-authenticated-user"""

        from ..models import BasicError, Issue, ValidationError

        url = "/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "collab": collab,
            "orgs": orgs,
            "owned": owned,
            "pulls": pulls,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_list(
        self,
        *,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        collab: Missing[bool] = UNSET,
        orgs: Missing[bool] = UNSET,
        owned: Missing[bool] = UNSET,
        pulls: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#list-issues-assigned-to-the-authenticated-user"""

        from ..models import BasicError, Issue, ValidationError

        url = "/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "collab": collab,
            "orgs": orgs,
            "owned": owned,
            "pulls": pulls,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_for_org(
        self,
        org: str,
        *,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#list-organization-issues-assigned-to-the-authenticated-user"""

        from ..models import BasicError, Issue

        url = f"/orgs/{org}/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_org(
        self,
        org: str,
        *,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#list-organization-issues-assigned-to-the-authenticated-user"""

        from ..models import BasicError, Issue

        url = f"/orgs/{org}/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "404": BasicError,
            },
        )

    def list_assignees(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#list-assignees"""

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/assignees"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_assignees(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#list-assignees"""

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/assignees"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    def check_user_can_be_assigned(
        self,
        owner: str,
        repo: str,
        assignee: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#check-if-a-user-can-be-assigned"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/assignees/{assignee}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_user_can_be_assigned(
        self,
        owner: str,
        repo: str,
        assignee: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#check-if-a-user-can-be-assigned"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/assignees/{assignee}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        milestone: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        assignee: Missing[str] = UNSET,
        creator: Missing[str] = UNSET,
        mentioned: Missing[str] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#list-repository-issues"""

        from ..models import BasicError, Issue, ValidationError

        url = f"/repos/{owner}/{repo}/issues"

        params = {
            "milestone": milestone,
            "state": state,
            "assignee": assignee,
            "creator": creator,
            "mentioned": mentioned,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_list_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        milestone: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        assignee: Missing[str] = UNSET,
        creator: Missing[str] = UNSET,
        mentioned: Missing[str] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#list-repository-issues"""

        from ..models import BasicError, Issue, ValidationError

        url = f"/repos/{owner}/{repo}/issues"

        params = {
            "milestone": milestone,
            "state": state,
            "assignee": assignee,
            "creator": creator,
            "mentioned": mentioned,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesPostBodyType,
    ) -> Response[Issue, IssueType]: ...

    @overload
    def create(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Union[str, int],
        body: Missing[str] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
        milestone: Missing[Union[str, int, None]] = UNSET,
        labels: Missing[
            list[Union[str, ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type]]
        ] = UNSET,
        assignees: Missing[list[str]] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    def create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#create-an-issue"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            Issue,
            ReposOwnerRepoIssuesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoIssuesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesPostBodyType,
    ) -> Response[Issue, IssueType]: ...

    @overload
    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Union[str, int],
        body: Missing[str] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
        milestone: Missing[Union[str, int, None]] = UNSET,
        labels: Missing[
            list[Union[str, ReposOwnerRepoIssuesPostBodyPropLabelsItemsOneof1Type]]
        ] = UNSET,
        assignees: Missing[list[str]] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    async def async_create(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#create-an-issue"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            Issue,
            ReposOwnerRepoIssuesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoIssuesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "404": BasicError,
                "410": BasicError,
            },
        )

    def list_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[IssueComment], list[IssueCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#list-issue-comments-for-a-repository"""

        from ..models import BasicError, IssueComment, ValidationError

        url = f"/repos/{owner}/{repo}/issues/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[IssueComment],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_list_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[IssueComment], list[IssueCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#list-issue-comments-for-a-repository"""

        from ..models import BasicError, IssueComment, ValidationError

        url = f"/repos/{owner}/{repo}/issues/comments"

        params = {
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[IssueComment],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[IssueComment, IssueCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#get-an-issue-comment"""

        from ..models import BasicError, IssueComment

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[IssueComment, IssueCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#get-an-issue-comment"""

        from ..models import BasicError, IssueComment

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#delete-an-issue-comment"""

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#delete-an-issue-comment"""

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType,
    ) -> Response[IssueComment, IssueCommentType]: ...

    @overload
    def update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[IssueComment, IssueCommentType]: ...

    def update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[IssueComment, IssueCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#update-an-issue-comment"""

        from ..models import (
            IssueComment,
            ReposOwnerRepoIssuesCommentsCommentIdPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesCommentsCommentIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType,
    ) -> Response[IssueComment, IssueCommentType]: ...

    @overload
    async def async_update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[IssueComment, IssueCommentType]: ...

    async def async_update_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[IssueComment, IssueCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#update-an-issue-comment"""

        from ..models import (
            IssueComment,
            ReposOwnerRepoIssuesCommentsCommentIdPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesCommentsCommentIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "422": ValidationError,
            },
        )

    def list_events_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[IssueEvent], list[IssueEventType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/events#list-issue-events-for-a-repository"""

        from ..models import IssueEvent, ValidationError

        url = f"/repos/{owner}/{repo}/issues/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[IssueEvent],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_events_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[IssueEvent], list[IssueEventType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/events#list-issue-events-for-a-repository"""

        from ..models import IssueEvent, ValidationError

        url = f"/repos/{owner}/{repo}/issues/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[IssueEvent],
            error_models={
                "422": ValidationError,
            },
        )

    def get_event(
        self,
        owner: str,
        repo: str,
        event_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[IssueEvent, IssueEventType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/events#get-an-issue-event"""

        from ..models import BasicError, IssueEvent

        url = f"/repos/{owner}/{repo}/issues/events/{event_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=IssueEvent,
            error_models={
                "404": BasicError,
                "410": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_event(
        self,
        owner: str,
        repo: str,
        event_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[IssueEvent, IssueEventType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/events#get-an-issue-event"""

        from ..models import BasicError, IssueEvent

        url = f"/repos/{owner}/{repo}/issues/events/{event_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=IssueEvent,
            error_models={
                "404": BasicError,
                "410": BasicError,
                "403": BasicError,
            },
        )

    def get(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#get-an-issue"""

        from ..models import BasicError, Issue

        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#get-an-issue"""

        from ..models import BasicError, Issue

        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[Union[str, int, None]] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        state_reason: Missing[
            Union[None, Literal["completed", "not_planned", "reopened"]]
        ] = UNSET,
        milestone: Missing[Union[str, int, None]] = UNSET,
        labels: Missing[
            list[
                Union[
                    str,
                    ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
                ]
            ]
        ] = UNSET,
        assignees: Missing[list[str]] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    def update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#update-an-issue"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            Issue,
            ReposOwnerRepoIssuesIssueNumberPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoIssuesIssueNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "422": ValidationError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[Union[str, int, None]] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        assignee: Missing[Union[str, None]] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        state_reason: Missing[
            Union[None, Literal["completed", "not_planned", "reopened"]]
        ] = UNSET,
        milestone: Missing[Union[str, int, None]] = UNSET,
        labels: Missing[
            list[
                Union[
                    str,
                    ReposOwnerRepoIssuesIssueNumberPatchBodyPropLabelsItemsOneof1Type,
                ]
            ]
        ] = UNSET,
        assignees: Missing[list[str]] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#update-an-issue"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            Issue,
            ReposOwnerRepoIssuesIssueNumberPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoIssuesIssueNumberPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "422": ValidationError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    @overload
    def add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        assignees: Missing[list[str]] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    def add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#add-assignees-to-an-issue"""

        from ..models import Issue, ReposOwnerRepoIssuesIssueNumberAssigneesPostBody

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberAssigneesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
        )

    @overload
    async def async_add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    @overload
    async def async_add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        assignees: Missing[list[str]] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    async def async_add_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#add-assignees-to-an-issue"""

        from ..models import Issue, ReposOwnerRepoIssuesIssueNumberAssigneesPostBody

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberAssigneesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
        )

    @overload
    def remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    @overload
    def remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        assignees: Missing[list[str]] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    def remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#remove-assignees-from-an-issue"""

        from ..models import Issue, ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
        )

    @overload
    async def async_remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    @overload
    async def async_remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        assignees: Missing[list[str]] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    async def async_remove_assignees(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#remove-assignees-from-an-issue"""

        from ..models import Issue, ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberAssigneesDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
        )

    def check_user_can_be_assigned_to_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        assignee: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#check-if-a-user-can-be-assigned-to-a-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_user_can_be_assigned_to_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        assignee: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/assignees#check-if-a-user-can-be-assigned-to-a-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/assignees/{assignee}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_comments(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[IssueComment], list[IssueCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#list-issue-comments"""

        from ..models import BasicError, IssueComment

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[IssueComment],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_comments(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[IssueComment], list[IssueCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#list-issue-comments"""

        from ..models import BasicError, IssueComment

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        params = {
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[IssueComment],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType,
    ) -> Response[IssueComment, IssueCommentType]: ...

    @overload
    def create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[IssueComment, IssueCommentType]: ...

    def create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[IssueComment, IssueCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#create-an-issue-comment"""

        from ..models import (
            BasicError,
            IssueComment,
            ReposOwnerRepoIssuesIssueNumberCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "403": BasicError,
                "410": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType,
    ) -> Response[IssueComment, IssueCommentType]: ...

    @overload
    async def async_create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[IssueComment, IssueCommentType]: ...

    async def async_create_comment(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[IssueComment, IssueCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/comments#create-an-issue-comment"""

        from ..models import (
            BasicError,
            IssueComment,
            ReposOwnerRepoIssuesIssueNumberCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=IssueComment,
            error_models={
                "403": BasicError,
                "410": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_events(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[
            Union[
                LabeledIssueEvent,
                UnlabeledIssueEvent,
                AssignedIssueEvent,
                UnassignedIssueEvent,
                MilestonedIssueEvent,
                DemilestonedIssueEvent,
                RenamedIssueEvent,
                ReviewRequestedIssueEvent,
                ReviewRequestRemovedIssueEvent,
                ReviewDismissedIssueEvent,
                LockedIssueEvent,
                AddedToProjectIssueEvent,
                MovedColumnInProjectIssueEvent,
                RemovedFromProjectIssueEvent,
                ConvertedNoteToIssueIssueEvent,
            ]
        ],
        list[
            Union[
                LabeledIssueEventType,
                UnlabeledIssueEventType,
                AssignedIssueEventType,
                UnassignedIssueEventType,
                MilestonedIssueEventType,
                DemilestonedIssueEventType,
                RenamedIssueEventType,
                ReviewRequestedIssueEventType,
                ReviewRequestRemovedIssueEventType,
                ReviewDismissedIssueEventType,
                LockedIssueEventType,
                AddedToProjectIssueEventType,
                MovedColumnInProjectIssueEventType,
                RemovedFromProjectIssueEventType,
                ConvertedNoteToIssueIssueEventType,
            ]
        ],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/events#list-issue-events"""

        from typing import Union

        from ..models import (
            AddedToProjectIssueEvent,
            AssignedIssueEvent,
            BasicError,
            ConvertedNoteToIssueIssueEvent,
            DemilestonedIssueEvent,
            LabeledIssueEvent,
            LockedIssueEvent,
            MilestonedIssueEvent,
            MovedColumnInProjectIssueEvent,
            RemovedFromProjectIssueEvent,
            RenamedIssueEvent,
            ReviewDismissedIssueEvent,
            ReviewRequestedIssueEvent,
            ReviewRequestRemovedIssueEvent,
            UnassignedIssueEvent,
            UnlabeledIssueEvent,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    AssignedIssueEvent,
                    UnassignedIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                ]
            ],
            error_models={
                "410": BasicError,
            },
        )

    async def async_list_events(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[
            Union[
                LabeledIssueEvent,
                UnlabeledIssueEvent,
                AssignedIssueEvent,
                UnassignedIssueEvent,
                MilestonedIssueEvent,
                DemilestonedIssueEvent,
                RenamedIssueEvent,
                ReviewRequestedIssueEvent,
                ReviewRequestRemovedIssueEvent,
                ReviewDismissedIssueEvent,
                LockedIssueEvent,
                AddedToProjectIssueEvent,
                MovedColumnInProjectIssueEvent,
                RemovedFromProjectIssueEvent,
                ConvertedNoteToIssueIssueEvent,
            ]
        ],
        list[
            Union[
                LabeledIssueEventType,
                UnlabeledIssueEventType,
                AssignedIssueEventType,
                UnassignedIssueEventType,
                MilestonedIssueEventType,
                DemilestonedIssueEventType,
                RenamedIssueEventType,
                ReviewRequestedIssueEventType,
                ReviewRequestRemovedIssueEventType,
                ReviewDismissedIssueEventType,
                LockedIssueEventType,
                AddedToProjectIssueEventType,
                MovedColumnInProjectIssueEventType,
                RemovedFromProjectIssueEventType,
                ConvertedNoteToIssueIssueEventType,
            ]
        ],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/events#list-issue-events"""

        from typing import Union

        from ..models import (
            AddedToProjectIssueEvent,
            AssignedIssueEvent,
            BasicError,
            ConvertedNoteToIssueIssueEvent,
            DemilestonedIssueEvent,
            LabeledIssueEvent,
            LockedIssueEvent,
            MilestonedIssueEvent,
            MovedColumnInProjectIssueEvent,
            RemovedFromProjectIssueEvent,
            RenamedIssueEvent,
            ReviewDismissedIssueEvent,
            ReviewRequestedIssueEvent,
            ReviewRequestRemovedIssueEvent,
            UnassignedIssueEvent,
            UnlabeledIssueEvent,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/events"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    AssignedIssueEvent,
                    UnassignedIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                ]
            ],
            error_models={
                "410": BasicError,
            },
        )

    def list_labels_on_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#list-labels-for-an-issue"""

        from ..models import BasicError, Label

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_labels_on_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#list-labels-for-an-issue"""

        from ..models import BasicError, Label

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                list[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                list[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    @overload
    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: Missing[list[str]] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    @overload
    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: Missing[
            list[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType]
        ] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    def set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                list[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                list[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#set-labels-for-an-issue"""

        from typing import Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            BasicError,
            Label,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
                    Annotated[list[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
                    Annotated[
                        list[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items],
                        Field(min_length=1 if PYDANTIC_V2 else None),
                    ],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                list[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                list[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    @overload
    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: Missing[list[str]] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    @overload
    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: Missing[
            list[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2PropLabelsItemsType]
        ] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    async def async_set_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0Type,
                list[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2Type,
                list[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#set-labels-for-an-issue"""

        from typing import Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            BasicError,
            Label,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
            ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof0,
                    Annotated[list[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof2,
                    Annotated[
                        list[ReposOwnerRepoIssuesIssueNumberLabelsPutBodyOneof3Items],
                        Field(min_length=1 if PYDANTIC_V2 else None),
                    ],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                list[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                list[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    @overload
    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: Missing[list[str]] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    @overload
    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: Missing[
            list[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType]
        ] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    def add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                list[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                list[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#add-labels-to-an-issue"""

        from typing import Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            BasicError,
            Label,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
                    Annotated[list[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
                    Annotated[
                        list[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items],
                        Field(min_length=1 if PYDANTIC_V2 else None),
                    ],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                list[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                list[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    @overload
    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: Missing[list[str]] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    @overload
    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: Missing[
            list[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2PropLabelsItemsType]
        ] = UNSET,
    ) -> Response[list[Label], list[LabelType]]: ...

    async def async_add_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0Type,
                list[str],
                ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2Type,
                list[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3ItemsType],
                str,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#add-labels-to-an-issue"""

        from typing import Union

        from githubkit.compat import PYDANTIC_V2

        from ..models import (
            BasicError,
            Label,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
            ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof0,
                    Annotated[list[str], Field(min_length=1 if PYDANTIC_V2 else None)],
                    ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof2,
                    Annotated[
                        list[ReposOwnerRepoIssuesIssueNumberLabelsPostBodyOneof3Items],
                        Field(min_length=1 if PYDANTIC_V2 else None),
                    ],
                    str,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
                "422": ValidationError,
            },
        )

    def remove_all_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#remove-all-labels-from-an-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_remove_all_labels(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#remove-all-labels-from-an-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    def remove_label(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#remove-a-label-from-an-issue"""

        from ..models import BasicError, Label

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_remove_label(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#remove-a-label-from-an-issue"""

        from ..models import BasicError, Label

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        lock_reason: Missing[
            Literal["off-topic", "too heated", "resolved", "spam"]
        ] = UNSET,
    ) -> Response: ...

    def lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#lock-an-issue"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoIssuesIssueNumberLockPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoIssuesIssueNumberLockPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "410": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        lock_reason: Missing[
            Literal["off-topic", "too heated", "resolved", "spam"]
        ] = UNSET,
    ) -> Response: ...

    async def async_lock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoIssuesIssueNumberLockPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#lock-an-issue"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoIssuesIssueNumberLockPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoIssuesIssueNumberLockPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "410": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def unlock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#unlock-an-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_unlock(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#unlock-an-issue"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/lock"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def remove_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberSubIssueDeleteBodyType,
    ) -> Response[Issue, IssueType]: ...

    @overload
    def remove_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        sub_issue_id: int,
    ) -> Response[Issue, IssueType]: ...

    def remove_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberSubIssueDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/sub-issues#remove-sub-issue"""

        from ..models import (
            BasicError,
            Issue,
            ReposOwnerRepoIssuesIssueNumberSubIssueDeleteBody,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/sub_issue"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberSubIssueDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_remove_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberSubIssueDeleteBodyType,
    ) -> Response[Issue, IssueType]: ...

    @overload
    async def async_remove_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        sub_issue_id: int,
    ) -> Response[Issue, IssueType]: ...

    async def async_remove_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberSubIssueDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/sub-issues#remove-sub-issue"""

        from ..models import (
            BasicError,
            Issue,
            ReposOwnerRepoIssuesIssueNumberSubIssueDeleteBody,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/sub_issue"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberSubIssueDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "400": BasicError,
                "404": BasicError,
            },
        )

    def list_sub_issues(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/sub-issues#list-sub-issues"""

        from ..models import BasicError, Issue

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/sub_issues"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_sub_issues(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/sub-issues#list-sub-issues"""

        from ..models import BasicError, Issue

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/sub_issues"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    @overload
    def add_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberSubIssuesPostBodyType,
    ) -> Response[Issue, IssueType]: ...

    @overload
    def add_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        sub_issue_id: int,
        replace_parent: Missing[bool] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    def add_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberSubIssuesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/sub-issues#add-sub-issue"""

        from ..models import (
            BasicError,
            Issue,
            ReposOwnerRepoIssuesIssueNumberSubIssuesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/sub_issues"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberSubIssuesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "403": BasicError,
                "410": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberSubIssuesPostBodyType,
    ) -> Response[Issue, IssueType]: ...

    @overload
    async def async_add_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        sub_issue_id: int,
        replace_parent: Missing[bool] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    async def async_add_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoIssuesIssueNumberSubIssuesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/sub-issues#add-sub-issue"""

        from ..models import (
            BasicError,
            Issue,
            ReposOwnerRepoIssuesIssueNumberSubIssuesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/sub_issues"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberSubIssuesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "403": BasicError,
                "410": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def reprioritize_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberSubIssuesPriorityPatchBodyType,
    ) -> Response[Issue, IssueType]: ...

    @overload
    def reprioritize_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        sub_issue_id: int,
        after_id: Missing[int] = UNSET,
        before_id: Missing[int] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    def reprioritize_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoIssuesIssueNumberSubIssuesPriorityPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/sub-issues#reprioritize-sub-issue"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            Issue,
            ReposOwnerRepoIssuesIssueNumberSubIssuesPriorityPatchBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberSubIssuesPriorityPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_reprioritize_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoIssuesIssueNumberSubIssuesPriorityPatchBodyType,
    ) -> Response[Issue, IssueType]: ...

    @overload
    async def async_reprioritize_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        sub_issue_id: int,
        after_id: Missing[int] = UNSET,
        before_id: Missing[int] = UNSET,
    ) -> Response[Issue, IssueType]: ...

    async def async_reprioritize_sub_issue(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            ReposOwnerRepoIssuesIssueNumberSubIssuesPriorityPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[Issue, IssueType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/sub-issues#reprioritize-sub-issue"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            Issue,
            ReposOwnerRepoIssuesIssueNumberSubIssuesPriorityPatchBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/sub_issues/priority"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoIssuesIssueNumberSubIssuesPriorityPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Issue,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_events_for_timeline(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[
            Union[
                LabeledIssueEvent,
                UnlabeledIssueEvent,
                MilestonedIssueEvent,
                DemilestonedIssueEvent,
                RenamedIssueEvent,
                ReviewRequestedIssueEvent,
                ReviewRequestRemovedIssueEvent,
                ReviewDismissedIssueEvent,
                LockedIssueEvent,
                AddedToProjectIssueEvent,
                MovedColumnInProjectIssueEvent,
                RemovedFromProjectIssueEvent,
                ConvertedNoteToIssueIssueEvent,
                TimelineCommentEvent,
                TimelineCrossReferencedEvent,
                TimelineCommittedEvent,
                TimelineReviewedEvent,
                TimelineLineCommentedEvent,
                TimelineCommitCommentedEvent,
                TimelineAssignedIssueEvent,
                TimelineUnassignedIssueEvent,
                StateChangeIssueEvent,
            ]
        ],
        list[
            Union[
                LabeledIssueEventType,
                UnlabeledIssueEventType,
                MilestonedIssueEventType,
                DemilestonedIssueEventType,
                RenamedIssueEventType,
                ReviewRequestedIssueEventType,
                ReviewRequestRemovedIssueEventType,
                ReviewDismissedIssueEventType,
                LockedIssueEventType,
                AddedToProjectIssueEventType,
                MovedColumnInProjectIssueEventType,
                RemovedFromProjectIssueEventType,
                ConvertedNoteToIssueIssueEventType,
                TimelineCommentEventType,
                TimelineCrossReferencedEventType,
                TimelineCommittedEventType,
                TimelineReviewedEventType,
                TimelineLineCommentedEventType,
                TimelineCommitCommentedEventType,
                TimelineAssignedIssueEventType,
                TimelineUnassignedIssueEventType,
                StateChangeIssueEventType,
            ]
        ],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/timeline#list-timeline-events-for-an-issue"""

        from typing import Union

        from ..models import (
            AddedToProjectIssueEvent,
            BasicError,
            ConvertedNoteToIssueIssueEvent,
            DemilestonedIssueEvent,
            LabeledIssueEvent,
            LockedIssueEvent,
            MilestonedIssueEvent,
            MovedColumnInProjectIssueEvent,
            RemovedFromProjectIssueEvent,
            RenamedIssueEvent,
            ReviewDismissedIssueEvent,
            ReviewRequestedIssueEvent,
            ReviewRequestRemovedIssueEvent,
            StateChangeIssueEvent,
            TimelineAssignedIssueEvent,
            TimelineCommentEvent,
            TimelineCommitCommentedEvent,
            TimelineCommittedEvent,
            TimelineCrossReferencedEvent,
            TimelineLineCommentedEvent,
            TimelineReviewedEvent,
            TimelineUnassignedIssueEvent,
            UnlabeledIssueEvent,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/timeline"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                    TimelineCommentEvent,
                    TimelineCrossReferencedEvent,
                    TimelineCommittedEvent,
                    TimelineReviewedEvent,
                    TimelineLineCommentedEvent,
                    TimelineCommitCommentedEvent,
                    TimelineAssignedIssueEvent,
                    TimelineUnassignedIssueEvent,
                    StateChangeIssueEvent,
                ]
            ],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    async def async_list_events_for_timeline(
        self,
        owner: str,
        repo: str,
        issue_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[
            Union[
                LabeledIssueEvent,
                UnlabeledIssueEvent,
                MilestonedIssueEvent,
                DemilestonedIssueEvent,
                RenamedIssueEvent,
                ReviewRequestedIssueEvent,
                ReviewRequestRemovedIssueEvent,
                ReviewDismissedIssueEvent,
                LockedIssueEvent,
                AddedToProjectIssueEvent,
                MovedColumnInProjectIssueEvent,
                RemovedFromProjectIssueEvent,
                ConvertedNoteToIssueIssueEvent,
                TimelineCommentEvent,
                TimelineCrossReferencedEvent,
                TimelineCommittedEvent,
                TimelineReviewedEvent,
                TimelineLineCommentedEvent,
                TimelineCommitCommentedEvent,
                TimelineAssignedIssueEvent,
                TimelineUnassignedIssueEvent,
                StateChangeIssueEvent,
            ]
        ],
        list[
            Union[
                LabeledIssueEventType,
                UnlabeledIssueEventType,
                MilestonedIssueEventType,
                DemilestonedIssueEventType,
                RenamedIssueEventType,
                ReviewRequestedIssueEventType,
                ReviewRequestRemovedIssueEventType,
                ReviewDismissedIssueEventType,
                LockedIssueEventType,
                AddedToProjectIssueEventType,
                MovedColumnInProjectIssueEventType,
                RemovedFromProjectIssueEventType,
                ConvertedNoteToIssueIssueEventType,
                TimelineCommentEventType,
                TimelineCrossReferencedEventType,
                TimelineCommittedEventType,
                TimelineReviewedEventType,
                TimelineLineCommentedEventType,
                TimelineCommitCommentedEventType,
                TimelineAssignedIssueEventType,
                TimelineUnassignedIssueEventType,
                StateChangeIssueEventType,
            ]
        ],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/timeline#list-timeline-events-for-an-issue"""

        from typing import Union

        from ..models import (
            AddedToProjectIssueEvent,
            BasicError,
            ConvertedNoteToIssueIssueEvent,
            DemilestonedIssueEvent,
            LabeledIssueEvent,
            LockedIssueEvent,
            MilestonedIssueEvent,
            MovedColumnInProjectIssueEvent,
            RemovedFromProjectIssueEvent,
            RenamedIssueEvent,
            ReviewDismissedIssueEvent,
            ReviewRequestedIssueEvent,
            ReviewRequestRemovedIssueEvent,
            StateChangeIssueEvent,
            TimelineAssignedIssueEvent,
            TimelineCommentEvent,
            TimelineCommitCommentedEvent,
            TimelineCommittedEvent,
            TimelineCrossReferencedEvent,
            TimelineLineCommentedEvent,
            TimelineReviewedEvent,
            TimelineUnassignedIssueEvent,
            UnlabeledIssueEvent,
        )

        url = f"/repos/{owner}/{repo}/issues/{issue_number}/timeline"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[
                Union[
                    LabeledIssueEvent,
                    UnlabeledIssueEvent,
                    MilestonedIssueEvent,
                    DemilestonedIssueEvent,
                    RenamedIssueEvent,
                    ReviewRequestedIssueEvent,
                    ReviewRequestRemovedIssueEvent,
                    ReviewDismissedIssueEvent,
                    LockedIssueEvent,
                    AddedToProjectIssueEvent,
                    MovedColumnInProjectIssueEvent,
                    RemovedFromProjectIssueEvent,
                    ConvertedNoteToIssueIssueEvent,
                    TimelineCommentEvent,
                    TimelineCrossReferencedEvent,
                    TimelineCommittedEvent,
                    TimelineReviewedEvent,
                    TimelineLineCommentedEvent,
                    TimelineCommitCommentedEvent,
                    TimelineAssignedIssueEvent,
                    TimelineUnassignedIssueEvent,
                    StateChangeIssueEvent,
                ]
            ],
            error_models={
                "404": BasicError,
                "410": BasicError,
            },
        )

    def list_labels_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#list-labels-for-a-repository"""

        from ..models import BasicError, Label

        url = f"/repos/{owner}/{repo}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#list-labels-for-a-repository"""

        from ..models import BasicError, Label

        url = f"/repos/{owner}/{repo}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Label],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_label(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoLabelsPostBodyType,
    ) -> Response[Label, LabelType]: ...

    @overload
    def create_label(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        color: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
    ) -> Response[Label, LabelType]: ...

    def create_label(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Label, LabelType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#create-a-label"""

        from ..models import (
            BasicError,
            Label,
            ReposOwnerRepoLabelsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoLabelsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Label,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_label(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoLabelsPostBodyType,
    ) -> Response[Label, LabelType]: ...

    @overload
    async def async_create_label(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        color: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
    ) -> Response[Label, LabelType]: ...

    async def async_create_label(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Label, LabelType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#create-a-label"""

        from ..models import (
            BasicError,
            Label,
            ReposOwnerRepoLabelsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoLabelsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Label,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Label, LabelType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#get-a-label"""

        from ..models import BasicError, Label

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Label,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Label, LabelType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#get-a-label"""

        from ..models import BasicError, Label

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Label,
            error_models={
                "404": BasicError,
            },
        )

    def delete_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#delete-a-label"""

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#delete-a-label"""

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
    ) -> Response[Label, LabelType]: ...

    @overload
    def update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        new_name: Missing[str] = UNSET,
        color: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
    ) -> Response[Label, LabelType]: ...

    def update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Label, LabelType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#update-a-label"""

        from ..models import Label, ReposOwnerRepoLabelsNamePatchBody

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoLabelsNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Label,
        )

    @overload
    async def async_update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
    ) -> Response[Label, LabelType]: ...

    @overload
    async def async_update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        new_name: Missing[str] = UNSET,
        color: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
    ) -> Response[Label, LabelType]: ...

    async def async_update_label(
        self,
        owner: str,
        repo: str,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoLabelsNamePatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Label, LabelType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#update-a-label"""

        from ..models import Label, ReposOwnerRepoLabelsNamePatchBody

        url = f"/repos/{owner}/{repo}/labels/{name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoLabelsNamePatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Label,
        )

    def list_milestones(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        sort: Missing[Literal["due_on", "completeness"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Milestone], list[MilestoneType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#list-milestones"""

        from ..models import BasicError, Milestone

        url = f"/repos/{owner}/{repo}/milestones"

        params = {
            "state": state,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Milestone],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_milestones(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        sort: Missing[Literal["due_on", "completeness"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Milestone], list[MilestoneType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#list-milestones"""

        from ..models import BasicError, Milestone

        url = f"/repos/{owner}/{repo}/milestones"

        params = {
            "state": state,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Milestone],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoMilestonesPostBodyType,
    ) -> Response[Milestone, MilestoneType]: ...

    @overload
    def create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: str,
        state: Missing[Literal["open", "closed"]] = UNSET,
        description: Missing[str] = UNSET,
        due_on: Missing[datetime] = UNSET,
    ) -> Response[Milestone, MilestoneType]: ...

    def create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Milestone, MilestoneType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#create-a-milestone"""

        from ..models import (
            BasicError,
            Milestone,
            ReposOwnerRepoMilestonesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/milestones"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMilestonesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Milestone,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoMilestonesPostBodyType,
    ) -> Response[Milestone, MilestoneType]: ...

    @overload
    async def async_create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: str,
        state: Missing[Literal["open", "closed"]] = UNSET,
        description: Missing[str] = UNSET,
        due_on: Missing[datetime] = UNSET,
    ) -> Response[Milestone, MilestoneType]: ...

    async def async_create_milestone(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Milestone, MilestoneType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#create-a-milestone"""

        from ..models import (
            BasicError,
            Milestone,
            ReposOwnerRepoMilestonesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/milestones"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMilestonesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Milestone,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Milestone, MilestoneType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#get-a-milestone"""

        from ..models import BasicError, Milestone

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Milestone,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Milestone, MilestoneType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#get-a-milestone"""

        from ..models import BasicError, Milestone

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Milestone,
            error_models={
                "404": BasicError,
            },
        )

    def delete_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#delete-a-milestone"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#delete-a-milestone"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType] = UNSET,
    ) -> Response[Milestone, MilestoneType]: ...

    @overload
    def update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        description: Missing[str] = UNSET,
        due_on: Missing[datetime] = UNSET,
    ) -> Response[Milestone, MilestoneType]: ...

    def update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Milestone, MilestoneType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#update-a-milestone"""

        from ..models import Milestone, ReposOwnerRepoMilestonesMilestoneNumberPatchBody

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoMilestonesMilestoneNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Milestone,
        )

    @overload
    async def async_update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType] = UNSET,
    ) -> Response[Milestone, MilestoneType]: ...

    @overload
    async def async_update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        state: Missing[Literal["open", "closed"]] = UNSET,
        description: Missing[str] = UNSET,
        due_on: Missing[datetime] = UNSET,
    ) -> Response[Milestone, MilestoneType]: ...

    async def async_update_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoMilestonesMilestoneNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Milestone, MilestoneType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/milestones#update-a-milestone"""

        from ..models import Milestone, ReposOwnerRepoMilestonesMilestoneNumberPatchBody

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoMilestonesMilestoneNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Milestone,
        )

    def list_labels_for_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#list-labels-for-issues-in-a-milestone"""

        from ..models import Label

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Label],
        )

    async def async_list_labels_for_milestone(
        self,
        owner: str,
        repo: str,
        milestone_number: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Label], list[LabelType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/labels#list-labels-for-issues-in-a-milestone"""

        from ..models import Label

        url = f"/repos/{owner}/{repo}/milestones/{milestone_number}/labels"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Label],
        )

    def list_for_authenticated_user(
        self,
        *,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#list-user-account-issues-assigned-to-the-authenticated-user"""

        from ..models import BasicError, Issue

        url = "/user/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        *,
        filter_: Missing[
            Literal["assigned", "created", "mentioned", "subscribed", "repos", "all"]
        ] = UNSET,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        labels: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated", "comments"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        since: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Issue], list[IssueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/issues/issues#list-user-account-issues-assigned-to-the-authenticated-user"""

        from ..models import BasicError, Issue

        url = "/user/issues"

        params = {
            "filter": filter_,
            "state": state,
            "labels": labels,
            "sort": sort,
            "direction": direction,
            "since": since,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Issue],
            error_models={
                "404": BasicError,
            },
        )
