"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        MinimalRepository,
        OrganizationInvitation,
        SimpleUser,
        Team,
        TeamDiscussion,
        TeamDiscussionComment,
        TeamFull,
        TeamMembership,
        TeamProject,
        TeamRepository,
    )
    from ..types import (
        MinimalRepositoryType,
        OrganizationInvitationType,
        OrgsOrgTeamsPostBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType,
        OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
        OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType,
        OrgsOrgTeamsTeamSlugPatchBodyType,
        OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType,
        OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType,
        SimpleUserType,
        TeamDiscussionCommentType,
        TeamDiscussionType,
        TeamFullType,
        TeamMembershipType,
        TeamProjectType,
        TeamRepositoryType,
        TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
        TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType,
        TeamsTeamIdDiscussionsPostBodyType,
        TeamsTeamIdMembershipsUsernamePutBodyType,
        TeamsTeamIdPatchBodyType,
        TeamsTeamIdProjectsProjectIdPutBodyType,
        TeamsTeamIdReposOwnerRepoPutBodyType,
        TeamType,
    )


class TeamsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-teams"""

        from ..models import BasicError, Team

        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "403": BasicError,
            },
        )

    async def async_list(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-teams"""

        from ..models import BasicError, Team

        url = f"/orgs/{org}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def create(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgTeamsPostBodyType,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    def create(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        maintainers: Missing[list[str]] = UNSET,
        repo_names: Missing[list[str]] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push"]] = UNSET,
        parent_team_id: Missing[int] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    def create(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#create-a-team"""

        from ..models import BasicError, OrgsOrgTeamsPostBody, TeamFull, ValidationError

        url = f"/orgs/{org}/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgTeamsPostBodyType,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    async def async_create(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        maintainers: Missing[list[str]] = UNSET,
        repo_names: Missing[list[str]] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push"]] = UNSET,
        parent_team_id: Missing[int] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    async def async_create(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#create-a-team"""

        from ..models import BasicError, OrgsOrgTeamsPostBody, TeamFull, ValidationError

        url = f"/orgs/{org}/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_by_name(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#get-a-team-by-name"""

        from ..models import BasicError, TeamFull

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_by_name(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#get-a-team-by-name"""

        from ..models import BasicError, TeamFull

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#delete-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#delete-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    def update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#update-a-team"""

        from ..models import (
            BasicError,
            OrgsOrgTeamsTeamSlugPatchBody,
            TeamFull,
            ValidationError,
        )

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    async def async_update_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#update-a-team"""

        from ..models import (
            BasicError,
            OrgsOrgTeamsTeamSlugPatchBody,
            TeamFull,
            ValidationError,
        )

        url = f"/orgs/{org}/teams/{team_slug}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        pinned: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamDiscussion], list[TeamDiscussionType]]:
        """See also: https://docs.github.com/rest/teams/discussions#list-discussions"""

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussion],
        )

    async def async_list_discussions_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        pinned: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamDiscussion], list[TeamDiscussionType]]:
        """See also: https://docs.github.com/rest/teams/discussions#list-discussions"""

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "pinned": pinned,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussion],
        )

    @overload
    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    def create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#create-a-discussion"""

        from ..models import OrgsOrgTeamsTeamSlugDiscussionsPostBody, TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    async def async_create_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#create-a-discussion"""

        from ..models import OrgsOrgTeamsTeamSlugDiscussionsPostBody, TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#get-a-discussion"""

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#get-a-discussion"""

        from ..models import TeamDiscussion

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/discussions#delete-a-discussion"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/discussions#delete-a-discussion"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    def update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#update-a-discussion"""

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody,
            TeamDiscussion,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    async def async_update_discussion_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#update-a-discussion"""

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody,
            TeamDiscussion,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamDiscussionComment], list[TeamDiscussionCommentType]]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#list-discussion-comments"""

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamDiscussionComment], list[TeamDiscussionCommentType]]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#list-discussion-comments"""

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussionComment],
        )

    @overload
    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    def create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#create-a-discussion-comment"""

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody,
            TeamDiscussionComment,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    async def async_create_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#create-a-discussion-comment"""

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody,
            TeamDiscussionComment,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment"""

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment"""

        from ..models import TeamDiscussionComment

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/discussion-comments#delete-a-discussion-comment"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/discussion-comments#delete-a-discussion-comment"""

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    def update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#update-a-discussion-comment"""

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
            TeamDiscussionComment,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    async def async_update_discussion_comment_in_org(
        self,
        org: str,
        team_slug: str,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#update-a-discussion-comment"""

        from ..models import (
            OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
            TeamDiscussionComment,
        )

        url = f"/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """See also: https://docs.github.com/rest/teams/members#list-pending-team-invitations"""

        from ..models import OrganizationInvitation

        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
        )

    async def async_list_pending_invitations_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """See also: https://docs.github.com/rest/teams/members#list-pending-team-invitations"""

        from ..models import OrganizationInvitation

        url = f"/orgs/{org}/teams/{team_slug}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
        )

    def list_members_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/rest/teams/members#list-team-members"""

        from ..models import SimpleUser

        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    async def async_list_members_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/rest/teams/members#list-team-members"""

        from ..models import SimpleUser

        url = f"/orgs/{org}/teams/{team_slug}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    def get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """See also: https://docs.github.com/rest/teams/members#get-team-membership-for-a-user"""

        from ..models import TeamMembership

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    async def async_get_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """See also: https://docs.github.com/rest/teams/members#get-team-membership-for-a-user"""

        from ..models import TeamMembership

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    @overload
    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    @overload
    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    def add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """See also: https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user"""

        from ..models import (
            OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody,
            TeamMembership,
        )

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    @overload
    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    @overload
    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    async def async_add_or_update_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """See also: https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user"""

        from ..models import (
            OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody,
            TeamMembership,
        )

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgTeamsTeamSlugMembershipsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={},
        )

    def remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user"""

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_membership_for_user_in_org(
        self,
        org: str,
        team_slug: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user"""

        url = f"/orgs/{org}/teams/{team_slug}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamProject], list[TeamProjectType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-team-projects"""

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamProject],
        )

    async def async_list_projects_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamProject], list[TeamProjectType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-team-projects"""

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamProject],
        )

    def check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamProject, TeamProjectType]:
        """See also: https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-project"""

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamProject, TeamProjectType]:
        """See also: https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-project"""

        from ..models import TeamProject

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    @overload
    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    def add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#add-or-update-team-project-permissions"""

        from typing import Union

        from ..models import (
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody,
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
        )

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    @overload
    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_project_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#add-or-update-team-project-permissions"""

        from typing import Union

        from ..models import (
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody,
            OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
        )

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[OrgsOrgTeamsTeamSlugProjectsProjectIdPutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": OrgsOrgTeamsTeamSlugProjectsProjectIdPutResponse403,
            },
        )

    def remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#remove-a-project-from-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_project_in_org(
        self,
        org: str,
        team_slug: str,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#remove-a-project-from-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-team-repositories"""

        from ..models import MinimalRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
        )

    async def async_list_repos_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-team-repositories"""

        from ..models import MinimalRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
        )

    def check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamRepository, TeamRepositoryType]:
        """See also: https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-repository"""

        from ..models import TeamRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamRepository, TeamRepositoryType]:
        """See also: https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-repository"""

        from ..models import TeamRepository

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    @overload
    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response: ...

    def add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#add-or-update-team-repository-permissions"""

        from ..models import OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_repo_permissions_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgTeamsTeamSlugReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#add-or-update-team-repository-permissions"""

        from ..models import OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgTeamsTeamSlugReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#remove-a-repository-from-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_repo_in_org(
        self,
        org: str,
        team_slug: str,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#remove-a-repository-from-a-team"""

        url = f"/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_child_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-child-teams"""

        from ..models import Team

        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
        )

    async def async_list_child_in_org(
        self,
        org: str,
        team_slug: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-child-teams"""

        from ..models import Team

        url = f"/orgs/{org}/teams/{team_slug}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
        )

    def get_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#get-a-team-legacy"""

        from ..models import BasicError, TeamFull

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#get-a-team-legacy"""

        from ..models import BasicError, TeamFull

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#delete-a-team-legacy"""

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_delete_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#delete-a-team-legacy"""

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: TeamsTeamIdPatchBodyType,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    def update_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    def update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#update-a-team-legacy"""

        from ..models import BasicError, TeamFull, TeamsTeamIdPatchBody, ValidationError

        url = f"/teams/{team_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: TeamsTeamIdPatchBodyType,
    ) -> Response[TeamFull, TeamFullType]: ...

    @overload
    async def async_update_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        privacy: Missing[Literal["secret", "closed"]] = UNSET,
        notification_setting: Missing[
            Literal["notifications_enabled", "notifications_disabled"]
        ] = UNSET,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
        parent_team_id: Missing[Union[int, None]] = UNSET,
    ) -> Response[TeamFull, TeamFullType]: ...

    async def async_update_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamFull, TeamFullType]:
        """See also: https://docs.github.com/rest/teams/teams#update-a-team-legacy"""

        from ..models import BasicError, TeamFull, TeamsTeamIdPatchBody, ValidationError

        url = f"/teams/{team_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamFull,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def list_discussions_legacy(
        self,
        team_id: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamDiscussion], list[TeamDiscussionType]]:
        """See also: https://docs.github.com/rest/teams/discussions#list-discussions-legacy"""

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussion],
        )

    async def async_list_discussions_legacy(
        self,
        team_id: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamDiscussion], list[TeamDiscussionType]]:
        """See also: https://docs.github.com/rest/teams/discussions#list-discussions-legacy"""

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussion],
        )

    @overload
    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    def create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#create-a-discussion-legacy"""

        from ..models import TeamDiscussion, TeamsTeamIdDiscussionsPostBody

        url = f"/teams/{team_id}/discussions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsPostBodyType,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: str,
        body: str,
        private: Missing[bool] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    async def async_create_discussion_legacy(
        self,
        team_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#create-a-discussion-legacy"""

        from ..models import TeamDiscussion, TeamsTeamIdDiscussionsPostBody

        url = f"/teams/{team_id}/discussions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdDiscussionsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#get-a-discussion-legacy"""

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    async def async_get_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#get-a-discussion-legacy"""

        from ..models import TeamDiscussion

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/discussions#delete-a-discussion-legacy"""

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/discussions#delete-a-discussion-legacy"""

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    def update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#update-a-discussion-legacy"""

        from ..models import (
            TeamDiscussion,
            TeamsTeamIdDiscussionsDiscussionNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    @overload
    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    @overload
    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        title: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
    ) -> Response[TeamDiscussion, TeamDiscussionType]: ...

    async def async_update_discussion_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdDiscussionsDiscussionNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussion, TeamDiscussionType]:
        """See also: https://docs.github.com/rest/teams/discussions#update-a-discussion-legacy"""

        from ..models import (
            TeamDiscussion,
            TeamsTeamIdDiscussionsDiscussionNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussion,
        )

    def list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamDiscussionComment], list[TeamDiscussionCommentType]]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#list-discussion-comments-legacy"""

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussionComment],
        )

    async def async_list_discussion_comments_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamDiscussionComment], list[TeamDiscussionCommentType]]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#list-discussion-comments-legacy"""

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        params = {
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamDiscussionComment],
        )

    @overload
    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    def create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#create-a-discussion-comment-legacy"""

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    async def async_create_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#create-a-discussion-comment-legacy"""

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment-legacy"""

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    async def async_get_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#get-a-discussion-comment-legacy"""

        from ..models import TeamDiscussionComment

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/discussion-comments#delete-a-discussion-comment-legacy"""

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/discussion-comments#delete-a-discussion-comment-legacy"""

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    def update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#update-a-discussion-comment-legacy"""

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    @overload
    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    @overload
    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        body: str,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]: ...

    async def async_update_discussion_comment_legacy(
        self,
        team_id: int,
        discussion_number: int,
        comment_number: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[TeamDiscussionComment, TeamDiscussionCommentType]:
        """See also: https://docs.github.com/rest/teams/discussion-comments#update-a-discussion-comment-legacy"""

        from ..models import (
            TeamDiscussionComment,
            TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
        )

        url = f"/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                TeamsTeamIdDiscussionsDiscussionNumberCommentsCommentNumberPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamDiscussionComment,
        )

    def list_pending_invitations_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """See also: https://docs.github.com/rest/teams/members#list-pending-team-invitations-legacy"""

        from ..models import OrganizationInvitation

        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
        )

    async def async_list_pending_invitations_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """See also: https://docs.github.com/rest/teams/members#list-pending-team-invitations-legacy"""

        from ..models import OrganizationInvitation

        url = f"/teams/{team_id}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
        )

    def list_members_legacy(
        self,
        team_id: int,
        *,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/rest/teams/members#list-team-members-legacy"""

        from ..models import BasicError, SimpleUser

        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_members_legacy(
        self,
        team_id: int,
        *,
        role: Missing[Literal["member", "maintainer", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/rest/teams/members#list-team-members-legacy"""

        from ..models import BasicError, SimpleUser

        url = f"/teams/{team_id}/members"

        params = {
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    def get_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#get-team-member-legacy"""

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_get_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#get-team-member-legacy"""

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def add_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#add-team-member-legacy"""

        from ..models import BasicError

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_add_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#add-team-member-legacy"""

        from ..models import BasicError

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def remove_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#remove-team-member-legacy"""

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_member_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#remove-team-member-legacy"""

        url = f"/teams/{team_id}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """See also: https://docs.github.com/rest/teams/members#get-team-membership-for-a-user-legacy"""

        from ..models import BasicError, TeamMembership

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """See also: https://docs.github.com/rest/teams/members#get-team-membership-for-a-user-legacy"""

        from ..models import BasicError, TeamMembership

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    @overload
    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    def add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """See also: https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user-legacy"""

        from ..models import (
            BasicError,
            TeamMembership,
            TeamsTeamIdMembershipsUsernamePutBody,
        )

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    @overload
    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        role: Missing[Literal["member", "maintainer"]] = UNSET,
    ) -> Response[TeamMembership, TeamMembershipType]: ...

    async def async_add_or_update_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[TeamMembership, TeamMembershipType]:
        """See also: https://docs.github.com/rest/teams/members#add-or-update-team-membership-for-a-user-legacy"""

        from ..models import (
            BasicError,
            TeamMembership,
            TeamsTeamIdMembershipsUsernamePutBody,
        )

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TeamMembership,
            error_models={
                "404": BasicError,
            },
        )

    def remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user-legacy"""

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_membership_for_user_legacy(
        self,
        team_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/members#remove-team-membership-for-a-user-legacy"""

        url = f"/teams/{team_id}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_projects_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamProject], list[TeamProjectType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-team-projects-legacy"""

        from ..models import BasicError, TeamProject

        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_projects_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamProject], list[TeamProjectType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-team-projects-legacy"""

        from ..models import BasicError, TeamProject

        url = f"/teams/{team_id}/projects"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamProject],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamProject, TeamProjectType]:
        """See also: https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-project-legacy"""

        from ..models import TeamProject

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    async def async_check_permissions_for_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamProject, TeamProjectType]:
        """See also: https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-project-legacy"""

        from ..models import TeamProject

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamProject,
            error_models={},
        )

    @overload
    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    def add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#add-or-update-team-project-permissions-legacy"""

        from ..models import (
            BasicError,
            TeamsTeamIdProjectsProjectIdPutBody,
            TeamsTeamIdProjectsProjectIdPutResponse403,
            ValidationError,
        )

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdProjectsProjectIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_project_permissions_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdProjectsProjectIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#add-or-update-team-project-permissions-legacy"""

        from ..models import (
            BasicError,
            TeamsTeamIdProjectsProjectIdPutBody,
            TeamsTeamIdProjectsProjectIdPutResponse403,
            ValidationError,
        )

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdProjectsProjectIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": TeamsTeamIdProjectsProjectIdPutResponse403,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#remove-a-project-from-a-team-legacy"""

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_remove_project_legacy(
        self,
        team_id: int,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#remove-a-project-from-a-team-legacy"""

        from ..models import BasicError, ValidationError

        url = f"/teams/{team_id}/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_repos_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-team-repositories-legacy"""

        from ..models import BasicError, MinimalRepository

        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_repos_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-team-repositories-legacy"""

        from ..models import BasicError, MinimalRepository

        url = f"/teams/{team_id}/repos"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "404": BasicError,
            },
        )

    def check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamRepository, TeamRepositoryType]:
        """See also: https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-repository-legacy"""

        from ..models import TeamRepository

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    async def async_check_permissions_for_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[TeamRepository, TeamRepositoryType]:
        """See also: https://docs.github.com/rest/teams/teams#check-team-permissions-for-a-repository-legacy"""

        from ..models import TeamRepository

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=TeamRepository,
            error_models={},
        )

    @overload
    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
    ) -> Response: ...

    def add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#add-or-update-team-repository-permissions-legacy"""

        from ..models import (
            BasicError,
            TeamsTeamIdReposOwnerRepoPutBody,
            ValidationError,
        )

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[Literal["pull", "push", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_or_update_repo_permissions_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[TeamsTeamIdReposOwnerRepoPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#add-or-update-team-repository-permissions-legacy"""

        from ..models import (
            BasicError,
            TeamsTeamIdReposOwnerRepoPutBody,
            ValidationError,
        )

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(TeamsTeamIdReposOwnerRepoPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#remove-a-repository-from-a-team-legacy"""

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_repo_legacy(
        self,
        team_id: int,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/rest/teams/teams#remove-a-repository-from-a-team-legacy"""

        url = f"/teams/{team_id}/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_child_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-child-teams-legacy"""

        from ..models import BasicError, Team, ValidationError

        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_child_legacy(
        self,
        team_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-child-teams-legacy"""

        from ..models import BasicError, Team, ValidationError

        url = f"/teams/{team_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamFull], list[TeamFullType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-teams-for-the-authenticated-user"""

        from ..models import BasicError, TeamFull

        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamFull], list[TeamFullType]]:
        """See also: https://docs.github.com/rest/teams/teams#list-teams-for-the-authenticated-user"""

        from ..models import BasicError, TeamFull

        url = "/user/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamFull],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )
