"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        AnnouncementBanner,
        ApiInsightsRouteStatsItems,
        ApiInsightsSubjectStatsItems,
        ApiInsightsSummaryStats,
        ApiInsightsTimeStatsItems,
        ApiInsightsUserStatsItems,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AuditLogEvent,
        CredentialAuthorization,
        CustomProperty,
        HookDelivery,
        HookDeliveryItem,
        MinimalRepository,
        OrganizationCustomRepositoryRole,
        OrganizationFineGrainedPermission,
        OrganizationFull,
        OrganizationInvitation,
        OrganizationProgrammaticAccessGrant,
        OrganizationProgrammaticAccessGrantRequest,
        OrganizationRole,
        OrganizationSimple,
        OrganizationsOrganizationIdCustomRolesGetResponse200,
        OrgHook,
        OrgMembership,
        OrgRepoCustomPropertyValues,
        OrgsOrgAttestationsSubjectDigestGetResponse200,
        OrgsOrgCustomRepositoryRolesGetResponse200,
        OrgsOrgInstallationsGetResponse200,
        OrgsOrgOrganizationRolesGetResponse200,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        PushRuleBypassRequest,
        RepositoryFineGrainedPermission,
        SimpleUser,
        Team,
        TeamRoleAssignment,
        TeamSimple,
        UserRoleAssignment,
        WebhookConfig,
    )
    from ..types import (
        AnnouncementBannerType,
        AnnouncementType,
        ApiInsightsRouteStatsItemsType,
        ApiInsightsSubjectStatsItemsType,
        ApiInsightsSummaryStatsType,
        ApiInsightsTimeStatsItemsType,
        ApiInsightsUserStatsItemsType,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
        AuditLogEventType,
        CredentialAuthorizationType,
        CustomPropertySetPayloadType,
        CustomPropertyType,
        CustomPropertyValueType,
        HookDeliveryItemType,
        HookDeliveryType,
        MinimalRepositoryType,
        OrganizationCustomOrganizationRoleCreateSchemaType,
        OrganizationCustomOrganizationRoleUpdateSchemaType,
        OrganizationCustomRepositoryRoleCreateSchemaType,
        OrganizationCustomRepositoryRoleType,
        OrganizationCustomRepositoryRoleUpdateSchemaType,
        OrganizationFineGrainedPermissionType,
        OrganizationFullType,
        OrganizationInvitationType,
        OrganizationProgrammaticAccessGrantRequestType,
        OrganizationProgrammaticAccessGrantType,
        OrganizationRoleType,
        OrganizationSimpleType,
        OrganizationsOrganizationIdCustomRolesGetResponse200Type,
        OrgHookType,
        OrgMembershipType,
        OrgRepoCustomPropertyValuesType,
        OrgsOrgAttestationsSubjectDigestGetResponse200Type,
        OrgsOrgCustomRepositoryRolesGetResponse200Type,
        OrgsOrgHooksHookIdConfigPatchBodyType,
        OrgsOrgHooksHookIdPatchBodyPropConfigType,
        OrgsOrgHooksHookIdPatchBodyType,
        OrgsOrgHooksPostBodyPropConfigType,
        OrgsOrgHooksPostBodyType,
        OrgsOrgInstallationsGetResponse200Type,
        OrgsOrgInvitationsPostBodyType,
        OrgsOrgMembershipsUsernamePutBodyType,
        OrgsOrgOrganizationRolesGetResponse200Type,
        OrgsOrgOutsideCollaboratorsUsernamePutBodyType,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202Type,
        OrgsOrgPatchBodyType,
        OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
        OrgsOrgPersonalAccessTokenRequestsPostBodyType,
        OrgsOrgPersonalAccessTokensPatIdPostBodyType,
        OrgsOrgPersonalAccessTokensPostBodyType,
        OrgsOrgPropertiesSchemaPatchBodyType,
        OrgsOrgPropertiesValuesPatchBodyType,
        OrgsOrgSecurityProductEnablementPostBodyType,
        PushRuleBypassRequestType,
        RepositoryFineGrainedPermissionType,
        SimpleUserType,
        TeamRoleAssignmentType,
        TeamSimpleType,
        TeamType,
        UserMembershipsOrgsOrgPatchBodyType,
        UserRoleAssignmentType,
        WebhookConfigType,
    )


class OrgsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list(
        self,
        *,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-organizations"""

        from ..models import OrganizationSimple

        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSimple],
        )

    async def async_list(
        self,
        *,
        since: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-organizations"""

        from ..models import OrganizationSimple

        url = "/organizations"

        params = {
            "since": since,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSimple],
        )

    def list_custom_roles(
        self,
        organization_id: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrganizationsOrganizationIdCustomRolesGetResponse200,
        OrganizationsOrganizationIdCustomRolesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---list-custom-repository-roles-in-an-organization"""

        from ..models import OrganizationsOrganizationIdCustomRolesGetResponse200

        url = f"/organizations/{organization_id}/custom_roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationsOrganizationIdCustomRolesGetResponse200,
        )

    async def async_list_custom_roles(
        self,
        organization_id: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrganizationsOrganizationIdCustomRolesGetResponse200,
        OrganizationsOrganizationIdCustomRolesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---list-custom-repository-roles-in-an-organization"""

        from ..models import OrganizationsOrganizationIdCustomRolesGetResponse200

        url = f"/organizations/{organization_id}/custom_roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationsOrganizationIdCustomRolesGetResponse200,
        )

    def get(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrganizationFull, OrganizationFullType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#get-an-organization"""

        from ..models import BasicError, OrganizationFull

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrganizationFull, OrganizationFullType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#get-an-organization"""

        from ..models import BasicError, OrganizationFull

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "404": BasicError,
            },
        )

    def delete(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#delete-an-organization"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
        )

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_delete(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#delete-an-organization"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
        )

        url = f"/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
    ) -> Response[OrganizationFull, OrganizationFullType]: ...

    @overload
    def update(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        billing_email: Missing[str] = UNSET,
        company: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        twitter_username: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        has_organization_projects: Missing[bool] = UNSET,
        has_repository_projects: Missing[bool] = UNSET,
        default_repository_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        members_can_create_repositories: Missing[bool] = UNSET,
        members_can_create_internal_repositories: Missing[bool] = UNSET,
        members_can_create_private_repositories: Missing[bool] = UNSET,
        members_can_create_public_repositories: Missing[bool] = UNSET,
        members_allowed_repository_creation_type: Missing[
            Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Missing[bool] = UNSET,
        members_can_create_public_pages: Missing[bool] = UNSET,
        members_can_create_private_pages: Missing[bool] = UNSET,
        members_can_fork_private_repositories: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
        blog: Missing[str] = UNSET,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependency_graph_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Missing[bool] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[str] = UNSET,
        secret_scanning_validity_checks_enabled: Missing[bool] = UNSET,
        deploy_keys_enabled_for_repositories: Missing[bool] = UNSET,
    ) -> Response[OrganizationFull, OrganizationFullType]: ...

    def update(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationFull, OrganizationFullType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#update-an-organization"""

        from typing import Union

        from ..models import (
            BasicError,
            OrganizationFull,
            OrgsOrgPatchBody,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
    ) -> Response[OrganizationFull, OrganizationFullType]: ...

    @overload
    async def async_update(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        billing_email: Missing[str] = UNSET,
        company: Missing[str] = UNSET,
        email: Missing[str] = UNSET,
        twitter_username: Missing[str] = UNSET,
        location: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        has_organization_projects: Missing[bool] = UNSET,
        has_repository_projects: Missing[bool] = UNSET,
        default_repository_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        members_can_create_repositories: Missing[bool] = UNSET,
        members_can_create_internal_repositories: Missing[bool] = UNSET,
        members_can_create_private_repositories: Missing[bool] = UNSET,
        members_can_create_public_repositories: Missing[bool] = UNSET,
        members_allowed_repository_creation_type: Missing[
            Literal["all", "private", "none"]
        ] = UNSET,
        members_can_create_pages: Missing[bool] = UNSET,
        members_can_create_public_pages: Missing[bool] = UNSET,
        members_can_create_private_pages: Missing[bool] = UNSET,
        members_can_fork_private_repositories: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
        blog: Missing[str] = UNSET,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependabot_security_updates_enabled_for_new_repositories: Missing[bool] = UNSET,
        dependency_graph_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link_enabled: Missing[bool] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[str] = UNSET,
        secret_scanning_validity_checks_enabled: Missing[bool] = UNSET,
        deploy_keys_enabled_for_repositories: Missing[bool] = UNSET,
    ) -> Response[OrganizationFull, OrganizationFullType]: ...

    async def async_update(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationFull, OrganizationFullType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#update-an-organization"""

        from typing import Union

        from ..models import (
            BasicError,
            OrganizationFull,
            OrgsOrgPatchBody,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationFull,
            error_models={
                "422": Union[ValidationError, ValidationErrorSimple],
                "409": BasicError,
            },
        )

    def get_announcement_banner_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/organizations#get-announcement-banner-for-organization"""

        from ..models import AnnouncementBanner

        url = f"/orgs/{org}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=AnnouncementBanner,
        )

    async def async_get_announcement_banner_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/organizations#get-announcement-banner-for-organization"""

        from ..models import AnnouncementBanner

        url = f"/orgs/{org}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=AnnouncementBanner,
        )

    def remove_announcement_banner_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/organizations#remove-announcement-banner-from-organization"""

        url = f"/orgs/{org}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_announcement_banner_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/organizations#remove-announcement-banner-from-organization"""

        url = f"/orgs/{org}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def set_announcement_banner_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: AnnouncementType,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    @overload
    def set_announcement_banner_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        announcement: Union[str, None],
        expires_at: Missing[Union[datetime, None]] = UNSET,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    def set_announcement_banner_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[AnnouncementType] = UNSET,
        **kwargs,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/organizations#set-announcement-banner-for-organization"""

        from ..models import Announcement, AnnouncementBanner

        url = f"/orgs/{org}/announcement"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Announcement, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AnnouncementBanner,
        )

    @overload
    async def async_set_announcement_banner_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: AnnouncementType,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    @overload
    async def async_set_announcement_banner_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        announcement: Union[str, None],
        expires_at: Missing[Union[datetime, None]] = UNSET,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    async def async_set_announcement_banner_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[AnnouncementType] = UNSET,
        **kwargs,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/organizations#set-announcement-banner-for-organization"""

        from ..models import Announcement, AnnouncementBanner

        url = f"/orgs/{org}/announcement"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Announcement, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AnnouncementBanner,
        )

    def list_attestations(
        self,
        org: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrgsOrgAttestationsSubjectDigestGetResponse200,
        OrgsOrgAttestationsSubjectDigestGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-attestations"""

        from ..models import OrgsOrgAttestationsSubjectDigestGetResponse200

        url = f"/orgs/{org}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgAttestationsSubjectDigestGetResponse200,
        )

    async def async_list_attestations(
        self,
        org: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrgsOrgAttestationsSubjectDigestGetResponse200,
        OrgsOrgAttestationsSubjectDigestGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-attestations"""

        from ..models import OrgsOrgAttestationsSubjectDigestGetResponse200

        url = f"/orgs/{org}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgAttestationsSubjectDigestGetResponse200,
        )

    def get_audit_log(
        self,
        org: str,
        *,
        phrase: Missing[str] = UNSET,
        include: Missing[Literal["web", "git", "all"]] = UNSET,
        after: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[AuditLogEvent], list[AuditLogEventType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#get-the-audit-log-for-an-organization"""

        from ..models import AuditLogEvent

        url = f"/orgs/{org}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[AuditLogEvent],
        )

    async def async_get_audit_log(
        self,
        org: str,
        *,
        phrase: Missing[str] = UNSET,
        include: Missing[Literal["web", "git", "all"]] = UNSET,
        after: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[AuditLogEvent], list[AuditLogEventType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#get-the-audit-log-for-an-organization"""

        from ..models import AuditLogEvent

        url = f"/orgs/{org}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[AuditLogEvent],
        )

    def list_blocked_users(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/blocking#list-users-blocked-by-an-organization"""

        from ..models import SimpleUser

        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    async def async_list_blocked_users(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/blocking#list-users-blocked-by-an-organization"""

        from ..models import SimpleUser

        url = f"/orgs/{org}/blocks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    def check_blocked_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/blocking#check-if-a-user-is-blocked-by-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_check_blocked_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/blocking#check-if-a-user-is-blocked-by-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def block_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/blocking#block-a-user-from-an-organization"""

        from ..models import ValidationError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    async def async_block_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/blocking#block-a-user-from-an-organization"""

        from ..models import ValidationError

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    def unblock_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/blocking#unblock-a-user-from-an-organization"""

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_unblock_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/blocking#unblock-a-user-from-an-organization"""

        url = f"/orgs/{org}/blocks/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_push_bypass_requests(
        self,
        org: str,
        *,
        repository_name: Missing[str] = UNSET,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal["completed", "cancelled", "expired", "denied", "open", "all"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PushRuleBypassRequest], list[PushRuleBypassRequestType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/bypass-requests#list-push-rule-bypass-requests-within-an-organization"""

        from ..models import BasicError, PushRuleBypassRequest

        url = f"/orgs/{org}/bypass-requests/push-rules"

        params = {
            "repository_name": repository_name,
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PushRuleBypassRequest],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_push_bypass_requests(
        self,
        org: str,
        *,
        repository_name: Missing[str] = UNSET,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal["completed", "cancelled", "expired", "denied", "open", "all"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[PushRuleBypassRequest], list[PushRuleBypassRequestType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/bypass-requests#list-push-rule-bypass-requests-within-an-organization"""

        from ..models import BasicError, PushRuleBypassRequest

        url = f"/orgs/{org}/bypass-requests/push-rules"

        params = {
            "repository_name": repository_name,
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PushRuleBypassRequest],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def list_saml_sso_authorizations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        login: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[CredentialAuthorization], list[CredentialAuthorizationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-saml-sso-authorizations-for-an-organization"""

        from ..models import CredentialAuthorization

        url = f"/orgs/{org}/credential-authorizations"

        params = {
            "per_page": per_page,
            "page": page,
            "login": login,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CredentialAuthorization],
        )

    async def async_list_saml_sso_authorizations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        login: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[CredentialAuthorization], list[CredentialAuthorizationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-saml-sso-authorizations-for-an-organization"""

        from ..models import CredentialAuthorization

        url = f"/orgs/{org}/credential-authorizations"

        params = {
            "per_page": per_page,
            "page": page,
            "login": login,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CredentialAuthorization],
        )

    def remove_saml_sso_authorization(
        self,
        org: str,
        credential_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#remove-a-saml-sso-authorization-for-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/credential-authorizations/{credential_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_remove_saml_sso_authorization(
        self,
        org: str,
        credential_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#remove-a-saml-sso-authorization-for-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/credential-authorizations/{credential_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_custom_repo_roles(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrgsOrgCustomRepositoryRolesGetResponse200,
        OrgsOrgCustomRepositoryRolesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#list-custom-repository-roles-in-an-organization"""

        from ..models import OrgsOrgCustomRepositoryRolesGetResponse200

        url = f"/orgs/{org}/custom-repository-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgCustomRepositoryRolesGetResponse200,
        )

    async def async_list_custom_repo_roles(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrgsOrgCustomRepositoryRolesGetResponse200,
        OrgsOrgCustomRepositoryRolesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#list-custom-repository-roles-in-an-organization"""

        from ..models import OrgsOrgCustomRepositoryRolesGetResponse200

        url = f"/orgs/{org}/custom-repository-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgCustomRepositoryRolesGetResponse200,
        )

    @overload
    def create_custom_repo_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomRepositoryRoleCreateSchemaType,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    @overload
    def create_custom_repo_role(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[Union[str, None]] = UNSET,
        base_role: Literal["read", "triage", "write", "maintain"],
        permissions: list[str],
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    def create_custom_repo_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomRepositoryRoleCreateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#create-a-custom-repository-role"""

        from ..models import (
            BasicError,
            OrganizationCustomRepositoryRole,
            OrganizationCustomRepositoryRoleCreateSchema,
            ValidationError,
        )

        url = f"/orgs/{org}/custom-repository-roles"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomRepositoryRoleCreateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_custom_repo_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomRepositoryRoleCreateSchemaType,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    @overload
    async def async_create_custom_repo_role(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[Union[str, None]] = UNSET,
        base_role: Literal["read", "triage", "write", "maintain"],
        permissions: list[str],
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    async def async_create_custom_repo_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomRepositoryRoleCreateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#create-a-custom-repository-role"""

        from ..models import (
            BasicError,
            OrganizationCustomRepositoryRole,
            OrganizationCustomRepositoryRoleCreateSchema,
            ValidationError,
        )

        url = f"/orgs/{org}/custom-repository-roles"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomRepositoryRoleCreateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#get-a-custom-repository-role"""

        from ..models import BasicError, OrganizationCustomRepositoryRole

        url = f"/orgs/{org}/custom-repository-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#get-a-custom-repository-role"""

        from ..models import BasicError, OrganizationCustomRepositoryRole

        url = f"/orgs/{org}/custom-repository-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "404": BasicError,
            },
        )

    def delete_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#delete-a-custom-repository-role"""

        url = f"/orgs/{org}/custom-repository-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#delete-a-custom-repository-role"""

        url = f"/orgs/{org}/custom-repository-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomRepositoryRoleUpdateSchemaType,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    @overload
    def update_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        base_role: Missing[Literal["read", "triage", "write", "maintain"]] = UNSET,
        permissions: Missing[list[str]] = UNSET,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    def update_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomRepositoryRoleUpdateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#update-a-custom-repository-role"""

        from ..models import (
            BasicError,
            OrganizationCustomRepositoryRole,
            OrganizationCustomRepositoryRoleUpdateSchema,
            ValidationError,
        )

        url = f"/orgs/{org}/custom-repository-roles/{role_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomRepositoryRoleUpdateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomRepositoryRoleUpdateSchemaType,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    @overload
    async def async_update_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        base_role: Missing[Literal["read", "triage", "write", "maintain"]] = UNSET,
        permissions: Missing[list[str]] = UNSET,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    async def async_update_custom_repo_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomRepositoryRoleUpdateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#update-a-custom-repository-role"""

        from ..models import (
            BasicError,
            OrganizationCustomRepositoryRole,
            OrganizationCustomRepositoryRoleUpdateSchema,
            ValidationError,
        )

        url = f"/orgs/{org}/custom-repository-roles/{role_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomRepositoryRoleUpdateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def create_custom_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomRepositoryRoleCreateSchemaType,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    @overload
    def create_custom_role(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[Union[str, None]] = UNSET,
        base_role: Literal["read", "triage", "write", "maintain"],
        permissions: list[str],
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    def create_custom_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomRepositoryRoleCreateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---create-a-custom-role"""

        from ..models import (
            BasicError,
            OrganizationCustomRepositoryRole,
            OrganizationCustomRepositoryRoleCreateSchema,
            ValidationError,
        )

        url = f"/orgs/{org}/custom_roles"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomRepositoryRoleCreateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_custom_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomRepositoryRoleCreateSchemaType,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    @overload
    async def async_create_custom_role(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[Union[str, None]] = UNSET,
        base_role: Literal["read", "triage", "write", "maintain"],
        permissions: list[str],
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    async def async_create_custom_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomRepositoryRoleCreateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---create-a-custom-role"""

        from ..models import (
            BasicError,
            OrganizationCustomRepositoryRole,
            OrganizationCustomRepositoryRoleCreateSchema,
            ValidationError,
        )

        url = f"/orgs/{org}/custom_roles"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomRepositoryRoleCreateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---get-a-custom-role"""

        from ..models import BasicError, OrganizationCustomRepositoryRole

        url = f"/orgs/{org}/custom_roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---get-a-custom-role"""

        from ..models import BasicError, OrganizationCustomRepositoryRole

        url = f"/orgs/{org}/custom_roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "404": BasicError,
            },
        )

    def delete_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---delete-a-custom-role"""

        url = f"/orgs/{org}/custom_roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---delete-a-custom-role"""

        url = f"/orgs/{org}/custom_roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomRepositoryRoleUpdateSchemaType,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    @overload
    def update_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        base_role: Missing[Literal["read", "triage", "write", "maintain"]] = UNSET,
        permissions: Missing[list[str]] = UNSET,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    def update_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomRepositoryRoleUpdateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---update-a-custom-role"""

        from ..models import (
            BasicError,
            OrganizationCustomRepositoryRole,
            OrganizationCustomRepositoryRoleUpdateSchema,
            ValidationError,
        )

        url = f"/orgs/{org}/custom_roles/{role_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomRepositoryRoleUpdateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomRepositoryRoleUpdateSchemaType,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    @overload
    async def async_update_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        base_role: Missing[Literal["read", "triage", "write", "maintain"]] = UNSET,
        permissions: Missing[list[str]] = UNSET,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]: ...

    async def async_update_custom_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomRepositoryRoleUpdateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[
        OrganizationCustomRepositoryRole, OrganizationCustomRepositoryRoleType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---update-a-custom-role"""

        from ..models import (
            BasicError,
            OrganizationCustomRepositoryRole,
            OrganizationCustomRepositoryRoleUpdateSchema,
            ValidationError,
        )

        url = f"/orgs/{org}/custom_roles/{role_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomRepositoryRoleUpdateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationCustomRepositoryRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_failed_invitations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-failed-organization-invitations"""

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_failed_invitations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-failed-organization-invitations"""

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/failed_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    def list_fine_grained_permissions(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[RepositoryFineGrainedPermission], list[RepositoryFineGrainedPermissionType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---list-fine-grained-permissions-for-an-organization"""

        from ..models import RepositoryFineGrainedPermission

        url = f"/orgs/{org}/fine_grained_permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[RepositoryFineGrainedPermission],
        )

    async def async_list_fine_grained_permissions(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[RepositoryFineGrainedPermission], list[RepositoryFineGrainedPermissionType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#closing-down---list-fine-grained-permissions-for-an-organization"""

        from ..models import RepositoryFineGrainedPermission

        url = f"/orgs/{org}/fine_grained_permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[RepositoryFineGrainedPermission],
        )

    def list_webhooks(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrgHook], list[OrgHookType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#list-organization-webhooks"""

        from ..models import BasicError, OrgHook

        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrgHook], list[OrgHookType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#list-organization-webhooks"""

        from ..models import BasicError, OrgHook

        url = f"/orgs/{org}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrgHook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgHooksPostBodyType,
    ) -> Response[OrgHook, OrgHookType]: ...

    @overload
    def create_webhook(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[OrgHook, OrgHookType]: ...

    def create_webhook(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook, OrgHookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#create-an-organization-webhook"""

        from ..models import BasicError, OrgHook, OrgsOrgHooksPostBody, ValidationError

        url = f"/orgs/{org}/hooks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgHooksPostBodyType,
    ) -> Response[OrgHook, OrgHookType]: ...

    @overload
    async def async_create_webhook(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        config: OrgsOrgHooksPostBodyPropConfigType,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[OrgHook, OrgHookType]: ...

    async def async_create_webhook(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook, OrgHookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#create-an-organization-webhook"""

        from ..models import BasicError, OrgHook, OrgsOrgHooksPostBody, ValidationError

        url = f"/orgs/{org}/hooks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrgHook, OrgHookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#get-an-organization-webhook"""

        from ..models import BasicError, OrgHook

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrgHook, OrgHookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#get-an-organization-webhook"""

        from ..models import BasicError, OrgHook

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#delete-an-organization-webhook"""

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#delete-an-organization-webhook"""

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> Response[OrgHook, OrgHookType]: ...

    @overload
    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        config: Missing[OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[OrgHook, OrgHookType]: ...

    def update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook, OrgHookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#update-an-organization-webhook"""

        from ..models import (
            BasicError,
            OrgHook,
            OrgsOrgHooksHookIdPatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
    ) -> Response[OrgHook, OrgHookType]: ...

    @overload
    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        config: Missing[OrgsOrgHooksHookIdPatchBodyPropConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
        name: Missing[str] = UNSET,
    ) -> Response[OrgHook, OrgHookType]: ...

    async def async_update_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgHook, OrgHookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#update-an-organization-webhook"""

        from ..models import (
            BasicError,
            OrgHook,
            OrgsOrgHooksHookIdPatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/hooks/{hook_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgHook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization"""

        from ..models import WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#get-a-webhook-configuration-for-an-organization"""

        from ..models import WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    @overload
    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    def update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization"""

        from ..models import OrgsOrgHooksHookIdConfigPatchBody, WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    @overload
    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    async def async_update_webhook_config_for_org(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#update-a-webhook-configuration-for-an-organization"""

        from ..models import OrgsOrgHooksHookIdConfigPatchBody, WebhookConfig

        url = f"/orgs/{org}/hooks/{hook_id}/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#list-deliveries-for-an-organization-webhook"""

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        org: str,
        hook_id: int,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#list-deliveries-for-an-organization-webhook"""

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[HookDelivery, HookDeliveryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#get-a-webhook-delivery-for-an-organization-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[HookDelivery, HookDeliveryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#get-a-webhook-delivery-for-an-organization-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#redeliver-a-delivery-for-an-organization-webhook"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        org: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#redeliver-a-delivery-for-an-organization-webhook"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#ping-an-organization-webhook"""

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        org: str,
        hook_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/webhooks#ping-an-organization-webhook"""

        from ..models import BasicError

        url = f"/orgs/{org}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_route_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "http_method",
                    "api_route",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        api_route_substring: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[ApiInsightsRouteStatsItems], list[ApiInsightsRouteStatsItemsType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-route-stats-by-actor"""

        from ..models import ApiInsightsRouteStatsItems

        url = f"/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "api_route_substring": api_route_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsRouteStatsItems],
        )

    async def async_get_route_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "http_method",
                    "api_route",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        api_route_substring: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[ApiInsightsRouteStatsItems], list[ApiInsightsRouteStatsItemsType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-route-stats-by-actor"""

        from ..models import ApiInsightsRouteStatsItems

        url = f"/orgs/{org}/insights/api/route-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "api_route_substring": api_route_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsRouteStatsItems],
        )

    def get_subject_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "subject_name",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        subject_name_substring: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[ApiInsightsSubjectStatsItems], list[ApiInsightsSubjectStatsItemsType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-subject-stats"""

        from ..models import ApiInsightsSubjectStatsItems

        url = f"/orgs/{org}/insights/api/subject-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "subject_name_substring": subject_name_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsSubjectStatsItems],
        )

    async def async_get_subject_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "subject_name",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        subject_name_substring: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[ApiInsightsSubjectStatsItems], list[ApiInsightsSubjectStatsItemsType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-subject-stats"""

        from ..models import ApiInsightsSubjectStatsItems

        url = f"/orgs/{org}/insights/api/subject-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "subject_name_substring": subject_name_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsSubjectStatsItems],
        )

    def get_summary_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-summary-stats"""

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ApiInsightsSummaryStats,
        )

    async def async_get_summary_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-summary-stats"""

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ApiInsightsSummaryStats,
        )

    def get_summary_stats_by_user(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-summary-stats-by-user"""

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats/users/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ApiInsightsSummaryStats,
        )

    async def async_get_summary_stats_by_user(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-summary-stats-by-user"""

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats/users/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ApiInsightsSummaryStats,
        )

    def get_summary_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-summary-stats-by-actor"""

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ApiInsightsSummaryStats,
        )

    async def async_get_summary_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ApiInsightsSummaryStats, ApiInsightsSummaryStatsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-summary-stats-by-actor"""

        from ..models import ApiInsightsSummaryStats

        url = f"/orgs/{org}/insights/api/summary-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ApiInsightsSummaryStats,
        )

    def get_time_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-time-stats"""

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsTimeStatsItems],
        )

    async def async_get_time_stats(
        self,
        org: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-time-stats"""

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsTimeStatsItems],
        )

    def get_time_stats_by_user(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-time-stats-by-user"""

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats/users/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsTimeStatsItems],
        )

    async def async_get_time_stats_by_user(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-time-stats-by-user"""

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats/users/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsTimeStatsItems],
        )

    def get_time_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-time-stats-by-actor"""

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsTimeStatsItems],
        )

    async def async_get_time_stats_by_actor(
        self,
        org: str,
        actor_type: Literal[
            "installation",
            "classic_pat",
            "fine_grained_pat",
            "oauth_app",
            "github_app_user_to_server",
        ],
        actor_id: int,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        timestamp_increment: str,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ApiInsightsTimeStatsItems], list[ApiInsightsTimeStatsItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-time-stats-by-actor"""

        from ..models import ApiInsightsTimeStatsItems

        url = f"/orgs/{org}/insights/api/time-stats/{actor_type}/{actor_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "timestamp_increment": timestamp_increment,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsTimeStatsItems],
        )

    def get_user_stats(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "subject_name",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        actor_name_substring: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ApiInsightsUserStatsItems], list[ApiInsightsUserStatsItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-user-stats"""

        from ..models import ApiInsightsUserStatsItems

        url = f"/orgs/{org}/insights/api/user-stats/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "actor_name_substring": actor_name_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsUserStatsItems],
        )

    async def async_get_user_stats(
        self,
        org: str,
        user_id: str,
        *,
        min_timestamp: str,
        max_timestamp: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[
            list[
                Literal[
                    "last_rate_limited_timestamp",
                    "last_request_timestamp",
                    "rate_limited_request_count",
                    "subject_name",
                    "total_request_count",
                ]
            ]
        ] = UNSET,
        actor_name_substring: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ApiInsightsUserStatsItems], list[ApiInsightsUserStatsItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/api-insights#get-user-stats"""

        from ..models import ApiInsightsUserStatsItems

        url = f"/orgs/{org}/insights/api/user-stats/{user_id}"

        params = {
            "min_timestamp": min_timestamp,
            "max_timestamp": max_timestamp,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "sort": sort,
            "actor_name_substring": actor_name_substring,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ApiInsightsUserStatsItems],
        )

    def list_app_installations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrgsOrgInstallationsGetResponse200, OrgsOrgInstallationsGetResponse200Type
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-app-installations-for-an-organization"""

        from ..models import OrgsOrgInstallationsGetResponse200

        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    async def async_list_app_installations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrgsOrgInstallationsGetResponse200, OrgsOrgInstallationsGetResponse200Type
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-app-installations-for-an-organization"""

        from ..models import OrgsOrgInstallationsGetResponse200

        url = f"/orgs/{org}/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgInstallationsGetResponse200,
        )

    def list_pending_invitations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        role: Missing[
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ]
        ] = UNSET,
        invitation_source: Missing[Literal["all", "member", "scim"]] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-pending-organization-invitations"""

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_pending_invitations(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        role: Missing[
            Literal[
                "all", "admin", "direct_member", "billing_manager", "hiring_manager"
            ]
        ] = UNSET,
        invitation_source: Missing[Literal["all", "member", "scim"]] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationInvitation], list[OrganizationInvitationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-pending-organization-invitations"""

        from ..models import BasicError, OrganizationInvitation

        url = f"/orgs/{org}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
            "role": role,
            "invitation_source": invitation_source,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationInvitation],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_invitation(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
    ) -> Response[OrganizationInvitation, OrganizationInvitationType]: ...

    @overload
    def create_invitation(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        invitee_id: Missing[int] = UNSET,
        email: Missing[str] = UNSET,
        role: Missing[
            Literal["admin", "direct_member", "billing_manager", "reinstate"]
        ] = UNSET,
        team_ids: Missing[list[int]] = UNSET,
    ) -> Response[OrganizationInvitation, OrganizationInvitationType]: ...

    def create_invitation(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationInvitation, OrganizationInvitationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#create-an-organization-invitation"""

        from ..models import (
            BasicError,
            OrganizationInvitation,
            OrgsOrgInvitationsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/invitations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgInvitationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_invitation(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
    ) -> Response[OrganizationInvitation, OrganizationInvitationType]: ...

    @overload
    async def async_create_invitation(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        invitee_id: Missing[int] = UNSET,
        email: Missing[str] = UNSET,
        role: Missing[
            Literal["admin", "direct_member", "billing_manager", "reinstate"]
        ] = UNSET,
        team_ids: Missing[list[int]] = UNSET,
    ) -> Response[OrganizationInvitation, OrganizationInvitationType]: ...

    async def async_create_invitation(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgInvitationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationInvitation, OrganizationInvitationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#create-an-organization-invitation"""

        from ..models import (
            BasicError,
            OrganizationInvitation,
            OrgsOrgInvitationsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/invitations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgInvitationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationInvitation,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def cancel_invitation(
        self,
        org: str,
        invitation_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#cancel-an-organization-invitation"""

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    async def async_cancel_invitation(
        self,
        org: str,
        invitation_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#cancel-an-organization-invitation"""

        from ..models import BasicError, ValidationError

        url = f"/orgs/{org}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-organization-invitation-teams"""

        from ..models import BasicError, Team

        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_invitation_teams(
        self,
        org: str,
        invitation_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-organization-invitation-teams"""

        from ..models import BasicError, Team

        url = f"/orgs/{org}/invitations/{invitation_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    def list_members(
        self,
        org: str,
        *,
        filter_: Missing[Literal["2fa_disabled", "all"]] = UNSET,
        role: Missing[Literal["all", "admin", "member"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-organization-members"""

        from ..models import SimpleUser, ValidationError

        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_members(
        self,
        org: str,
        *,
        filter_: Missing[Literal["2fa_disabled", "all"]] = UNSET,
        role: Missing[Literal["all", "admin", "member"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-organization-members"""

        from ..models import SimpleUser, ValidationError

        url = f"/orgs/{org}/members"

        params = {
            "filter": filter_,
            "role": role,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    def check_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#check-organization-membership-for-a-user"""

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#check-organization-membership-for-a-user"""

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_member(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#remove-an-organization-member"""

        from ..models import BasicError

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_remove_member(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#remove-an-organization-member"""

        from ..models import BasicError

        url = f"/orgs/{org}/members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def get_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrgMembership, OrgMembershipType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#get-organization-membership-for-a-user"""

        from ..models import BasicError, OrgMembership

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrgMembership, OrgMembershipType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#get-organization-membership-for-a-user"""

        from ..models import BasicError, OrgMembership

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[OrgMembership, OrgMembershipType]: ...

    @overload
    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        role: Missing[Literal["admin", "member"]] = UNSET,
    ) -> Response[OrgMembership, OrgMembershipType]: ...

    def set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership, OrgMembershipType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#set-organization-membership-for-a-user"""

        from ..models import (
            BasicError,
            OrgMembership,
            OrgsOrgMembershipsUsernamePutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
    ) -> Response[OrgMembership, OrgMembershipType]: ...

    @overload
    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        role: Missing[Literal["admin", "member"]] = UNSET,
    ) -> Response[OrgMembership, OrgMembershipType]: ...

    async def async_set_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgMembershipsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership, OrgMembershipType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#set-organization-membership-for-a-user"""

        from ..models import (
            BasicError,
            OrgMembership,
            OrgsOrgMembershipsUsernamePutBody,
            ValidationError,
        )

        url = f"/orgs/{org}/memberships/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgMembershipsUsernamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#remove-organization-membership-for-a-user"""

        from ..models import BasicError

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#remove-organization-membership-for-a-user"""

        from ..models import BasicError

        url = f"/orgs/{org}/memberships/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_organization_fine_grained_permissions(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[OrganizationFineGrainedPermission],
        list[OrganizationFineGrainedPermissionType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#list-organization-fine-grained-permissions-for-an-organization"""

        from ..models import (
            BasicError,
            OrganizationFineGrainedPermission,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-fine-grained-permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[OrganizationFineGrainedPermission],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_organization_fine_grained_permissions(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[OrganizationFineGrainedPermission],
        list[OrganizationFineGrainedPermissionType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#list-organization-fine-grained-permissions-for-an-organization"""

        from ..models import (
            BasicError,
            OrganizationFineGrainedPermission,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-fine-grained-permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[OrganizationFineGrainedPermission],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_org_roles(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrgsOrgOrganizationRolesGetResponse200,
        OrgsOrgOrganizationRolesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#get-all-organization-roles-for-an-organization"""

        from ..models import (
            BasicError,
            OrgsOrgOrganizationRolesGetResponse200,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgOrganizationRolesGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_org_roles(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        OrgsOrgOrganizationRolesGetResponse200,
        OrgsOrgOrganizationRolesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#get-all-organization-roles-for-an-organization"""

        from ..models import (
            BasicError,
            OrgsOrgOrganizationRolesGetResponse200,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgsOrgOrganizationRolesGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def create_custom_organization_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomOrganizationRoleCreateSchemaType,
    ) -> Response[OrganizationRole, OrganizationRoleType]: ...

    @overload
    def create_custom_organization_role(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        permissions: list[str],
        base_role: Missing[
            Literal["read", "triage", "write", "maintain", "admin"]
        ] = UNSET,
    ) -> Response[OrganizationRole, OrganizationRoleType]: ...

    def create_custom_organization_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomOrganizationRoleCreateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationRole, OrganizationRoleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#create-a-custom-organization-role"""

        from ..models import (
            BasicError,
            OrganizationCustomOrganizationRoleCreateSchema,
            OrganizationRole,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomOrganizationRoleCreateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_custom_organization_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomOrganizationRoleCreateSchemaType,
    ) -> Response[OrganizationRole, OrganizationRoleType]: ...

    @overload
    async def async_create_custom_organization_role(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        permissions: list[str],
        base_role: Missing[
            Literal["read", "triage", "write", "maintain", "admin"]
        ] = UNSET,
    ) -> Response[OrganizationRole, OrganizationRoleType]: ...

    async def async_create_custom_organization_role(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomOrganizationRoleCreateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationRole, OrganizationRoleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#create-a-custom-organization-role"""

        from ..models import (
            BasicError,
            OrganizationCustomOrganizationRoleCreateSchema,
            OrganizationRole,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-roles"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomOrganizationRoleCreateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def revoke_all_org_roles_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#remove-all-organization-roles-for-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_all_org_roles_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#remove-all-organization-roles-for-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def assign_team_to_org_role(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#assign-an-organization-role-to-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_assign_team_to_org_role(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#assign-an-organization-role-to-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def revoke_org_role_team(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#remove-an-organization-role-from-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_org_role_team(
        self,
        org: str,
        team_slug: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#remove-an-organization-role-from-a-team"""

        url = f"/orgs/{org}/organization-roles/teams/{team_slug}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def revoke_all_org_roles_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#remove-all-organization-roles-for-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_all_org_roles_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#remove-all-organization-roles-for-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def assign_user_to_org_role(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#assign-an-organization-role-to-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_assign_user_to_org_role(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#assign-an-organization-role-to-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def revoke_org_role_user(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#remove-an-organization-role-from-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_org_role_user(
        self,
        org: str,
        username: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#remove-an-organization-role-from-a-user"""

        url = f"/orgs/{org}/organization-roles/users/{username}/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_org_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrganizationRole, OrganizationRoleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#get-an-organization-role"""

        from ..models import BasicError, OrganizationRole, ValidationError

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_org_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrganizationRole, OrganizationRoleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#get-an-organization-role"""

        from ..models import BasicError, OrganizationRole, ValidationError

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def delete_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#delete-a-custom-organization-role"""

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#delete-a-custom-organization-role"""

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomOrganizationRoleUpdateSchemaType,
    ) -> Response[OrganizationRole, OrganizationRoleType]: ...

    @overload
    def patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        permissions: Missing[list[str]] = UNSET,
        base_role: Missing[
            Literal["none", "read", "triage", "write", "maintain", "admin"]
        ] = UNSET,
    ) -> Response[OrganizationRole, OrganizationRoleType]: ...

    def patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomOrganizationRoleUpdateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationRole, OrganizationRoleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#update-a-custom-organization-role"""

        from ..models import (
            BasicError,
            OrganizationCustomOrganizationRoleUpdateSchema,
            OrganizationRole,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomOrganizationRoleUpdateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "422": ValidationError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrganizationCustomOrganizationRoleUpdateSchemaType,
    ) -> Response[OrganizationRole, OrganizationRoleType]: ...

    @overload
    async def async_patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        permissions: Missing[list[str]] = UNSET,
        base_role: Missing[
            Literal["none", "read", "triage", "write", "maintain", "admin"]
        ] = UNSET,
    ) -> Response[OrganizationRole, OrganizationRoleType]: ...

    async def async_patch_custom_organization_role(
        self,
        org: str,
        role_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrganizationCustomOrganizationRoleUpdateSchemaType] = UNSET,
        **kwargs,
    ) -> Response[OrganizationRole, OrganizationRoleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#update-a-custom-organization-role"""

        from ..models import (
            BasicError,
            OrganizationCustomOrganizationRoleUpdateSchema,
            OrganizationRole,
            ValidationError,
        )

        url = f"/orgs/{org}/organization-roles/{role_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrganizationCustomOrganizationRoleUpdateSchema, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrganizationRole,
            error_models={
                "422": ValidationError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    def list_org_role_teams(
        self,
        org: str,
        role_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamRoleAssignment], list[TeamRoleAssignmentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#list-teams-that-are-assigned-to-an-organization-role"""

        from ..models import TeamRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamRoleAssignment],
            error_models={},
        )

    async def async_list_org_role_teams(
        self,
        org: str,
        role_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamRoleAssignment], list[TeamRoleAssignmentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#list-teams-that-are-assigned-to-an-organization-role"""

        from ..models import TeamRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[TeamRoleAssignment],
            error_models={},
        )

    def list_org_role_users(
        self,
        org: str,
        role_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[UserRoleAssignment], list[UserRoleAssignmentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#list-users-that-are-assigned-to-an-organization-role"""

        from ..models import UserRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/users"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[UserRoleAssignment],
            error_models={},
        )

    async def async_list_org_role_users(
        self,
        org: str,
        role_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[UserRoleAssignment], list[UserRoleAssignmentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/organization-roles#list-users-that-are-assigned-to-an-organization-role"""

        from ..models import UserRoleAssignment

        url = f"/orgs/{org}/organization-roles/{role_id}/users"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[UserRoleAssignment],
            error_models={},
        )

    def list_outside_collaborators(
        self,
        org: str,
        *,
        filter_: Missing[Literal["2fa_disabled", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/outside-collaborators#list-outside-collaborators-for-an-organization"""

        from ..models import SimpleUser

        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    async def async_list_outside_collaborators(
        self,
        org: str,
        *,
        filter_: Missing[Literal["2fa_disabled", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/outside-collaborators#list-outside-collaborators-for-an-organization"""

        from ..models import SimpleUser

        url = f"/orgs/{org}/outside_collaborators"

        params = {
            "filter": filter_,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202Type,
    ]: ...

    @overload
    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        async_: Missing[bool] = UNSET,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202Type,
    ]: ...

    def convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/outside-collaborators#convert-an-organization-member-to-outside-collaborator"""

        from ..models import (
            BasicError,
            OrgsOrgOutsideCollaboratorsUsernamePutBody,
            OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        )

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgOutsideCollaboratorsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202Type,
    ]: ...

    @overload
    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        async_: Missing[bool] = UNSET,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202Type,
    ]: ...

    async def async_convert_member_to_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgOutsideCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        OrgsOrgOutsideCollaboratorsUsernamePutResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/outside-collaborators#convert-an-organization-member-to-outside-collaborator"""

        from ..models import (
            BasicError,
            OrgsOrgOutsideCollaboratorsUsernamePutBody,
            OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
        )

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgOutsideCollaboratorsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgsOrgOutsideCollaboratorsUsernamePutResponse202,
            error_models={
                "404": BasicError,
            },
        )

    def remove_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/outside-collaborators#remove-outside-collaborator-from-an-organization"""

        from ..models import OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    async def async_remove_outside_collaborator(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/outside-collaborators#remove-outside-collaborator-from-an-organization"""

        from ..models import OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422

        url = f"/orgs/{org}/outside_collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": OrgsOrgOutsideCollaboratorsUsernameDeleteResponse422,
            },
        )

    def list_pat_grant_requests(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[list[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[OrganizationProgrammaticAccessGrantRequest],
        list[OrganizationProgrammaticAccessGrantRequestType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#list-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens"""

        from ..models import (
            BasicError,
            OrganizationProgrammaticAccessGrantRequest,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationProgrammaticAccessGrantRequest],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_requests(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[list[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[OrganizationProgrammaticAccessGrantRequest],
        list[OrganizationProgrammaticAccessGrantRequestType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#list-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens"""

        from ..models import (
            BasicError,
            OrganizationProgrammaticAccessGrantRequest,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationProgrammaticAccessGrantRequest],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokenRequestsPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        pat_request_ids: Missing[list[int]] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    def review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokenRequestsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#review-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            OrgsOrgPersonalAccessTokenRequestsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPersonalAccessTokenRequestsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokenRequestsPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        pat_request_ids: Missing[list[int]] = UNSET,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    async def async_review_pat_grant_requests_in_bulk(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokenRequestsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#review-requests-to-access-organization-resources-with-fine-grained-personal-access-tokens"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            OrgsOrgPersonalAccessTokenRequestsPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPersonalAccessTokenRequestsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
    ) -> Response: ...

    @overload
    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response: ...

    def review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#review-a-request-to-access-organization-resources-with-a-fine-grained-personal-access-token"""

        from ..models import (
            BasicError,
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests/{pat_request_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType,
    ) -> Response: ...

    @overload
    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        action: Literal["approve", "deny"],
        reason: Missing[Union[str, None]] = UNSET,
    ) -> Response: ...

    async def async_review_pat_grant_request(
        self,
        org: str,
        pat_request_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#review-a-request-to-access-organization-resources-with-a-fine-grained-personal-access-token"""

        from ..models import (
            BasicError,
            OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-token-requests/{pat_request_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgPersonalAccessTokenRequestsPatRequestIdPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_pat_grant_request_repositories(
        self,
        org: str,
        pat_request_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#list-repositories-requested-to-be-accessed-by-a-fine-grained-personal-access-token"""

        from ..models import BasicError, MinimalRepository

        url = (
            f"/orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_request_repositories(
        self,
        org: str,
        pat_request_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#list-repositories-requested-to-be-accessed-by-a-fine-grained-personal-access-token"""

        from ..models import BasicError, MinimalRepository

        url = (
            f"/orgs/{org}/personal-access-token-requests/{pat_request_id}/repositories"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def list_pat_grants(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[list[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[OrganizationProgrammaticAccessGrant],
        list[OrganizationProgrammaticAccessGrantType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#list-fine-grained-personal-access-tokens-with-access-to-organization-resources"""

        from ..models import (
            BasicError,
            OrganizationProgrammaticAccessGrant,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationProgrammaticAccessGrant],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grants(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        sort: Missing[Literal["created_at"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        owner: Missing[list[str]] = UNSET,
        repository: Missing[str] = UNSET,
        permission: Missing[str] = UNSET,
        last_used_before: Missing[datetime] = UNSET,
        last_used_after: Missing[datetime] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[OrganizationProgrammaticAccessGrant],
        list[OrganizationProgrammaticAccessGrantType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#list-fine-grained-personal-access-tokens-with-access-to-organization-resources"""

        from ..models import (
            BasicError,
            OrganizationProgrammaticAccessGrant,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        params = {
            "per_page": per_page,
            "page": page,
            "sort": sort,
            "direction": direction,
            "owner": owner,
            "repository": repository,
            "permission": permission,
            "last_used_before": last_used_before,
            "last_used_after": last_used_after,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationProgrammaticAccessGrant],
            error_models={
                "500": BasicError,
                "422": ValidationError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokensPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    def update_pat_accesses(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        action: Literal["revoke"],
        pat_ids: list[int],
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    def update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#update-the-access-to-organization-resources-via-fine-grained-personal-access-tokens"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            OrgsOrgPersonalAccessTokensPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPersonalAccessTokensPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokensPostBodyType,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    @overload
    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        action: Literal["revoke"],
        pat_ids: list[int],
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]: ...

    async def async_update_pat_accesses(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#update-the-access-to-organization-resources-via-fine-grained-personal-access-tokens"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            OrgsOrgPersonalAccessTokensPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPersonalAccessTokensPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokensPatIdPostBodyType,
    ) -> Response: ...

    @overload
    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        action: Literal["revoke"],
    ) -> Response: ...

    def update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokensPatIdPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#update-the-access-a-fine-grained-personal-access-token-has-to-organization-resources"""

        from ..models import (
            BasicError,
            OrgsOrgPersonalAccessTokensPatIdPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPersonalAccessTokensPatIdPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPersonalAccessTokensPatIdPostBodyType,
    ) -> Response: ...

    @overload
    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        action: Literal["revoke"],
    ) -> Response: ...

    async def async_update_pat_access(
        self,
        org: str,
        pat_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPersonalAccessTokensPatIdPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#update-the-access-a-fine-grained-personal-access-token-has-to-organization-resources"""

        from ..models import (
            BasicError,
            OrgsOrgPersonalAccessTokensPatIdPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPersonalAccessTokensPatIdPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pat_grant_repositories(
        self,
        org: str,
        pat_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#list-repositories-a-fine-grained-personal-access-token-has-access-to"""

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_pat_grant_repositories(
        self,
        org: str,
        pat_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/personal-access-tokens#list-repositories-a-fine-grained-personal-access-token-has-access-to"""

        from ..models import BasicError, MinimalRepository

        url = f"/orgs/{org}/personal-access-tokens/{pat_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "500": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def get_all_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#get-all-custom-properties-for-an-organization"""

        from ..models import BasicError, CustomProperty

        url = f"/orgs/{org}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_all_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#get-all-custom-properties-for-an-organization"""

        from ..models import BasicError, CustomProperty

        url = f"/orgs/{org}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPropertiesSchemaPatchBodyType,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    @overload
    def create_or_update_custom_properties(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        properties: list[CustomPropertyType],
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    def create_or_update_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#create-or-update-custom-properties-for-an-organization"""

        from ..models import (
            BasicError,
            CustomProperty,
            OrgsOrgPropertiesSchemaPatchBody,
        )

        url = f"/orgs/{org}/properties/schema"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPropertiesSchemaPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPropertiesSchemaPatchBodyType,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    @overload
    async def async_create_or_update_custom_properties(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        properties: list[CustomPropertyType],
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    async def async_create_or_update_custom_properties(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#create-or-update-custom-properties-for-an-organization"""

        from ..models import (
            BasicError,
            CustomProperty,
            OrgsOrgPropertiesSchemaPatchBody,
        )

        url = f"/orgs/{org}/properties/schema"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPropertiesSchemaPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#get-a-custom-property-for-an-organization"""

        from ..models import BasicError, CustomProperty

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#get-a-custom-property-for-an-organization"""

        from ..models import BasicError, CustomProperty

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: CustomPropertySetPayloadType,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    @overload
    def create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, list[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[list[str], None]] = UNSET,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    def create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[CustomPropertySetPayloadType] = UNSET,
        **kwargs,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#create-or-update-a-custom-property-for-an-organization"""

        from ..models import BasicError, CustomProperty, CustomPropertySetPayload

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CustomPropertySetPayload, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: CustomPropertySetPayloadType,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    @overload
    async def async_create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, list[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[list[str], None]] = UNSET,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    async def async_create_or_update_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[CustomPropertySetPayloadType] = UNSET,
        **kwargs,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#create-or-update-a-custom-property-for-an-organization"""

        from ..models import BasicError, CustomProperty, CustomPropertySetPayload

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CustomPropertySetPayload, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def remove_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#remove-a-custom-property-for-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_custom_property(
        self,
        org: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#remove-a-custom-property-for-an-organization"""

        from ..models import BasicError

        url = f"/orgs/{org}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        repository_query: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[OrgRepoCustomPropertyValues], list[OrgRepoCustomPropertyValuesType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#list-custom-property-values-for-organization-repositories"""

        from ..models import BasicError, OrgRepoCustomPropertyValues

        url = f"/orgs/{org}/properties/values"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_query": repository_query,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrgRepoCustomPropertyValues],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        repository_query: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[OrgRepoCustomPropertyValues], list[OrgRepoCustomPropertyValuesType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#list-custom-property-values-for-organization-repositories"""

        from ..models import BasicError, OrgRepoCustomPropertyValues

        url = f"/orgs/{org}/properties/values"

        params = {
            "per_page": per_page,
            "page": page,
            "repository_query": repository_query,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrgRepoCustomPropertyValues],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    def create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        repository_names: list[str],
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    def create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#create-or-update-custom-property-values-for-organization-repositories"""

        from ..models import (
            BasicError,
            OrgsOrgPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    async def async_create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        repository_names: list[str],
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    async def async_create_or_update_custom_properties_values_for_repos(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-properties#create-or-update-custom-property-values-for-organization-repositories"""

        from ..models import (
            BasicError,
            OrgsOrgPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/orgs/{org}/properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_public_members(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-public-organization-members"""

        from ..models import SimpleUser

        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    async def async_list_public_members(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-public-organization-members"""

        from ..models import SimpleUser

        url = f"/orgs/{org}/public_members"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
        )

    def check_public_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#check-public-organization-membership-for-a-user"""

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_public_membership_for_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#check-public-organization-membership-for-a-user"""

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#set-public-organization-membership-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_set_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#set-public-organization-membership-for-the-authenticated-user"""

        from ..models import BasicError

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#remove-public-organization-membership-for-the-authenticated-user"""

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_public_membership_for_authenticated_user(
        self,
        org: str,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#remove-public-organization-membership-for-the-authenticated-user"""

        url = f"/orgs/{org}/public_members/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_repo_fine_grained_permissions(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[RepositoryFineGrainedPermission], list[RepositoryFineGrainedPermissionType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#list-repository-fine-grained-permissions-for-an-organization"""

        from ..models import RepositoryFineGrainedPermission

        url = f"/orgs/{org}/repository-fine-grained-permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[RepositoryFineGrainedPermission],
        )

    async def async_list_repo_fine_grained_permissions(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[RepositoryFineGrainedPermission], list[RepositoryFineGrainedPermissionType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/custom-roles#list-repository-fine-grained-permissions-for-an-organization"""

        from ..models import RepositoryFineGrainedPermission

        url = f"/orgs/{org}/repository-fine-grained-permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[RepositoryFineGrainedPermission],
        )

    def list_security_manager_teams(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamSimple], list[TeamSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/security-managers#list-security-manager-teams"""

        from ..models import TeamSimple

        url = f"/orgs/{org}/security-managers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[TeamSimple],
        )

    async def async_list_security_manager_teams(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[TeamSimple], list[TeamSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/security-managers#list-security-manager-teams"""

        from ..models import TeamSimple

        url = f"/orgs/{org}/security-managers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[TeamSimple],
        )

    def add_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/security-managers#add-a-security-manager-team"""

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_add_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/security-managers#add-a-security-manager-team"""

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/security-managers#remove-a-security-manager-team"""

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_security_manager_team(
        self,
        org: str,
        team_slug: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/security-managers#remove-a-security-manager-team"""

        url = f"/orgs/{org}/security-managers/teams/{team_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
    ) -> Response: ...

    @overload
    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        query_suite: Missing[Literal["default", "extended"]] = UNSET,
    ) -> Response: ...

    def enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#enable-or-disable-a-security-feature-for-an-organization"""

        from ..models import OrgsOrgSecurityProductEnablementPostBody

        url = f"/orgs/{org}/{security_product}/{enablement}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgSecurityProductEnablementPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
    ) -> Response: ...

    @overload
    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        query_suite: Missing[Literal["default", "extended"]] = UNSET,
    ) -> Response: ...

    async def async_enable_or_disable_security_product_on_all_org_repos(
        self,
        org: str,
        security_product: Literal[
            "dependency_graph",
            "dependabot_alerts",
            "dependabot_security_updates",
            "advanced_security",
            "code_scanning_default_setup",
            "secret_scanning",
            "secret_scanning_push_protection",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgSecurityProductEnablementPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#enable-or-disable-a-security-feature-for-an-organization"""

        from ..models import OrgsOrgSecurityProductEnablementPostBody

        url = f"/orgs/{org}/{security_product}/{enablement}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgSecurityProductEnablementPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_memberships_for_authenticated_user(
        self,
        *,
        state: Missing[Literal["active", "pending"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrgMembership], list[OrgMembershipType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-organization-memberships-for-the-authenticated-user"""

        from ..models import BasicError, OrgMembership, ValidationError

        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_memberships_for_authenticated_user(
        self,
        *,
        state: Missing[Literal["active", "pending"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrgMembership], list[OrgMembershipType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#list-organization-memberships-for-the-authenticated-user"""

        from ..models import BasicError, OrgMembership, ValidationError

        url = "/user/memberships/orgs"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrgMembership],
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationError,
            },
        )

    def get_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrgMembership, OrgMembershipType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#get-an-organization-membership-for-the-authenticated-user"""

        from ..models import BasicError, OrgMembership

        url = f"/user/memberships/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OrgMembership, OrgMembershipType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#get-an-organization-membership-for-the-authenticated-user"""

        from ..models import BasicError, OrgMembership

        url = f"/user/memberships/orgs/{org}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: UserMembershipsOrgsOrgPatchBodyType,
    ) -> Response[OrgMembership, OrgMembershipType]: ...

    @overload
    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        state: Literal["active"],
    ) -> Response[OrgMembership, OrgMembershipType]: ...

    def update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership, OrgMembershipType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#update-an-organization-membership-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            OrgMembership,
            UserMembershipsOrgsOrgPatchBody,
            ValidationError,
        )

        url = f"/user/memberships/orgs/{org}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserMembershipsOrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: UserMembershipsOrgsOrgPatchBodyType,
    ) -> Response[OrgMembership, OrgMembershipType]: ...

    @overload
    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        state: Literal["active"],
    ) -> Response[OrgMembership, OrgMembershipType]: ...

    async def async_update_membership_for_authenticated_user(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[UserMembershipsOrgsOrgPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[OrgMembership, OrgMembershipType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/members#update-an-organization-membership-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            OrgMembership,
            UserMembershipsOrgsOrgPatchBody,
            ValidationError,
        )

        url = f"/user/memberships/orgs/{org}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserMembershipsOrgsOrgPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=OrgMembership,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-organizations-for-the-authenticated-user"""

        from ..models import BasicError, OrganizationSimple

        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-organizations-for-the-authenticated-user"""

        from ..models import BasicError, OrganizationSimple

        url = "/user/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSimple],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-organizations-for-a-user"""

        from ..models import OrganizationSimple

        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSimple],
        )

    async def async_list_for_user(
        self,
        username: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[OrganizationSimple], list[OrganizationSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/orgs#list-organizations-for-a-user"""

        from ..models import OrganizationSimple

        url = f"/users/{username}/orgs"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[OrganizationSimple],
        )
