"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import TYPE_CHECKING, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.response import Response

    from ..models import EmptyObject, OidcCustomSub
    from ..types import EmptyObjectType, OidcCustomSubType


class OidcClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OidcCustomSub, OidcCustomSubType]:
        """See also: https://docs.github.com/rest/actions/oidc#get-the-customization-template-for-an-oidc-subject-claim-for-an-organization"""

        from ..models import OidcCustomSub

        url = f"/orgs/{org}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OidcCustomSub,
        )

    async def async_get_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[OidcCustomSub, OidcCustomSubType]:
        """See also: https://docs.github.com/rest/actions/oidc#get-the-customization-template-for-an-oidc-subject-claim-for-an-organization"""

        from ..models import OidcCustomSub

        url = f"/orgs/{org}/actions/oidc/customization/sub"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OidcCustomSub,
        )

    @overload
    def update_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OidcCustomSubType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def update_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        include_claim_keys: list[str],
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def update_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OidcCustomSubType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """See also: https://docs.github.com/rest/actions/oidc#set-the-customization-template-for-an-oidc-subject-claim-for-an-organization"""

        from ..models import BasicError, EmptyObject, OidcCustomSub

        url = f"/orgs/{org}/actions/oidc/customization/sub"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OidcCustomSub, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    async def async_update_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OidcCustomSubType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_update_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        include_claim_keys: list[str],
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_update_oidc_custom_sub_template_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OidcCustomSubType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """See also: https://docs.github.com/rest/actions/oidc#set-the-customization-template-for-an-oidc-subject-claim-for-an-organization"""

        from ..models import BasicError, EmptyObject, OidcCustomSub

        url = f"/orgs/{org}/actions/oidc/customization/sub"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OidcCustomSub, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )
