"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        ActionsEnterprisePermissions,
        AnnouncementBanner,
        AuditLogEvent,
        AuditLogStreamKey,
        AuthenticationToken,
        CustomProperty,
        EnterpriseSecurityAnalysisSettings,
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        GetAuditLogStreamConfig,
        GetAuditLogStreamConfigsItems,
        GetConsumedLicenses,
        GetLicenseSyncStatus,
        Runner,
        RunnerApplication,
        RunnerGroupsEnterprise,
        ScimEnterpriseGroupList,
        ScimEnterpriseGroupResponse,
        ScimEnterpriseUserList,
        ScimEnterpriseUserResponse,
        SelectedActions,
    )
    from ..types import (
        ActionsEnterprisePermissionsType,
        AmazonS3AccessKeysConfigType,
        AmazonS3OidcConfigType,
        AnnouncementBannerType,
        AnnouncementType,
        AuditLogEventType,
        AuditLogStreamKeyType,
        AuthenticationTokenType,
        AzureBlobConfigType,
        AzureHubConfigType,
        CustomPropertySetPayloadType,
        CustomPropertyType,
        DatadogConfigType,
        EnterpriseSecurityAnalysisSettingsType,
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200Type,
        EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
        EnterprisesEnterpriseActionsPermissionsPutBodyType,
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200Type,
        EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200Type,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
        EnterprisesEnterpriseActionsRunnersGetResponse200Type,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
        EnterprisesEnterpriseAuditLogStreamsPostBodyType,
        EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType,
        EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType,
        EnterprisesEnterprisePropertiesSchemaPatchBodyType,
        GetAuditLogStreamConfigsItemsType,
        GetAuditLogStreamConfigType,
        GetConsumedLicensesType,
        GetLicenseSyncStatusType,
        GoogleCloudConfigType,
        GroupPropMembersItemsType,
        GroupType,
        PatchSchemaPropOperationsItemsType,
        PatchSchemaType,
        RunnerApplicationType,
        RunnerGroupsEnterpriseType,
        RunnerType,
        ScimEnterpriseGroupListType,
        ScimEnterpriseGroupResponseType,
        ScimEnterpriseUserListType,
        ScimEnterpriseUserResponseType,
        SelectedActionsType,
        SplunkConfigType,
        UserEmailsItemsType,
        UserNameType,
        UserRoleItemsType,
        UserType,
    )


class EnterpriseAdminClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ActionsEnterprisePermissions, ActionsEnterprisePermissionsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-an-enterprise"""

        from ..models import ActionsEnterprisePermissions

        url = f"/enterprises/{enterprise}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsEnterprisePermissions,
        )

    async def async_get_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ActionsEnterprisePermissions, ActionsEnterprisePermissionsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-github-actions-permissions-for-an-enterprise"""

        from ..models import ActionsEnterprisePermissions

        url = f"/enterprises/{enterprise}/actions/permissions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsEnterprisePermissions,
        )

    @overload
    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> Response: ...

    def set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterpriseActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-an-enterprise"""

        from ..models import EnterprisesEnterpriseActionsPermissionsPutBody

        url = f"/enterprises/{enterprise}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsPermissionsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        enabled_organizations: Literal["all", "none", "selected"],
        allowed_actions: Missing[Literal["all", "local_only", "selected"]] = UNSET,
    ) -> Response: ...

    async def async_set_github_actions_permissions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterpriseActionsPermissionsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-github-actions-permissions-for-an-enterprise"""

        from ..models import EnterprisesEnterpriseActionsPermissionsPutBody

        url = f"/enterprises/{enterprise}/actions/permissions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-selected-organizations-enabled-for-github-actions-in-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    async def async_list_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#list-selected-organizations-enabled-for-github-actions-in-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsPermissionsOrganizationsGetResponse200,
        )

    @overload
    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        selected_organization_ids: list[int],
    ) -> Response: ...

    def set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-selected-organizations-enabled-for-github-actions-in-an-enterprise"""

        from ..models import EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody

        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        selected_organization_ids: list[int],
    ) -> Response: ...

    async def async_set_selected_organizations_enabled_github_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsPermissionsOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-selected-organizations-enabled-for-github-actions-in-an-enterprise"""

        from ..models import EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody

        url = f"/enterprises/{enterprise}/actions/permissions/organizations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsPermissionsOrganizationsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#enable-a-selected-organization-for-github-actions-in-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#enable-a-selected-organization-for-github-actions-in-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#disable-a-selected-organization-for-github-actions-in-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_selected_organization_github_actions_enterprise(
        self,
        enterprise: str,
        org_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#disable-a-selected-organization-for-github-actions-in-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/permissions/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[SelectedActions, SelectedActionsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-an-enterprise"""

        from ..models import SelectedActions

        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    async def async_get_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[SelectedActions, SelectedActionsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#get-allowed-actions-and-reusable-workflows-for-an-enterprise"""

        from ..models import SelectedActions

        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=SelectedActions,
        )

    @overload
    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: SelectedActionsType,
    ) -> Response: ...

    @overload
    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[list[str]] = UNSET,
    ) -> Response: ...

    def set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-an-enterprise"""

        from ..models import SelectedActions

        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: SelectedActionsType,
    ) -> Response: ...

    @overload
    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        github_owned_allowed: Missing[bool] = UNSET,
        verified_allowed: Missing[bool] = UNSET,
        patterns_allowed: Missing[list[str]] = UNSET,
    ) -> Response: ...

    async def async_set_allowed_actions_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[SelectedActionsType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/permissions#set-allowed-actions-and-reusable-workflows-for-an-enterprise"""

        from ..models import SelectedActions

        url = f"/enterprises/{enterprise}/actions/permissions/selected-actions"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(SelectedActions, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        visible_to_organization: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runner-groups-for-an-enterprise"""

        from ..models import EnterprisesEnterpriseActionsRunnerGroupsGetResponse200

        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    async def async_list_self_hosted_runner_groups_for_enterprise(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        visible_to_organization: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runner-groups-for-an-enterprise"""

        from ..models import EnterprisesEnterpriseActionsRunnerGroupsGetResponse200

        url = f"/enterprises/{enterprise}/actions/runner-groups"

        params = {
            "per_page": per_page,
            "page": page,
            "visible_to_organization": visible_to_organization,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsGetResponse200,
        )

    @overload
    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    @overload
    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        visibility: Missing[Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Missing[list[int]] = UNSET,
        runners: Missing[list[int]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    def create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterpriseActionsRunnerGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#create-a-self-hosted-runner-group-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsPostBody,
            RunnerGroupsEnterprise,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RunnerGroupsEnterprise,
        )

    @overload
    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnerGroupsPostBodyType,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    @overload
    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        visibility: Missing[Literal["selected", "all"]] = UNSET,
        selected_organization_ids: Missing[list[int]] = UNSET,
        runners: Missing[list[int]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    async def async_create_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterpriseActionsRunnerGroupsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#create-a-self-hosted-runner-group-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsPostBody,
            RunnerGroupsEnterprise,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RunnerGroupsEnterprise,
        )

    def get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#get-a-self-hosted-runner-group-for-an-enterprise"""

        from ..models import RunnerGroupsEnterprise

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RunnerGroupsEnterprise,
        )

    async def async_get_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#get-a-self-hosted-runner-group-for-an-enterprise"""

        from ..models import RunnerGroupsEnterprise

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RunnerGroupsEnterprise,
        )

    def delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#delete-a-self-hosted-runner-group-from-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_self_hosted_runner_group_from_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#delete-a-self-hosted-runner-group-from-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    @overload
    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        visibility: Missing[Literal["selected", "all"]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    def update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#update-a-self-hosted-runner-group-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody,
            RunnerGroupsEnterprise,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RunnerGroupsEnterprise,
        )

    @overload
    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    @overload
    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        visibility: Missing[Literal["selected", "all"]] = UNSET,
        allows_public_repositories: Missing[bool] = UNSET,
        restricted_to_workflows: Missing[bool] = UNSET,
        selected_workflows: Missing[list[str]] = UNSET,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]: ...

    async def async_update_self_hosted_runner_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[RunnerGroupsEnterprise, RunnerGroupsEnterpriseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#update-a-self-hosted-runner-group-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody,
            RunnerGroupsEnterprise,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RunnerGroupsEnterprise,
        )

    def list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-organization-access-to-a-self-hosted-runner-group-in-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    async def async_list_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-organization-access-to-a-self-hosted-runner-group-in-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsGetResponse200,
        )

    @overload
    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
    ) -> Response: ...

    @overload
    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        selected_organization_ids: list[int],
    ) -> Response: ...

    def set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-organization-access-for-a-self-hosted-runner-group-in-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        selected_organization_ids: list[int],
    ) -> Response: ...

    async def async_set_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-organization-access-for-a-self-hosted-runner-group-in-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
        )

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdOrganizationsPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-organization-access-to-a-self-hosted-runner-group-in-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_add_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-organization-access-to-a-self-hosted-runner-group-in-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-organization-access-to-a-self-hosted-runner-group-in-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_org_access_to_self_hosted_runner_group_in_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        org_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-organization-access-to-a-self-hosted-runner-group-in-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runners-in-a-group-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#list-self-hosted-runners-in-a-group-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersGetResponse200,
        )

    @overload
    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> Response: ...

    @overload
    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        runners: list[int],
    ) -> Response: ...

    def set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-self-hosted-runners-in-a-group-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
        )

        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        runners: list[int],
    ) -> Response: ...

    async def async_set_self_hosted_runners_in_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#set-self-hosted-runners-in-a-group-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
        )

        url = (
            f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnerGroupsRunnerGroupIdRunnersPutBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-a-self-hosted-runner-to-a-group-for-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_add_self_hosted_runner_to_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#add-a-self-hosted-runner-to-a-group-for-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-a-self-hosted-runner-from-a-group-for-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_self_hosted_runner_from_group_for_enterprise(
        self,
        enterprise: str,
        runner_group_id: int,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runner-groups#remove-a-self-hosted-runner-from-a-group-for-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        *,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnersGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-an-enterprise"""

        from ..models import EnterprisesEnterpriseActionsRunnersGetResponse200

        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    async def async_list_self_hosted_runners_for_enterprise(
        self,
        enterprise: str,
        *,
        name: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersGetResponse200,
        EnterprisesEnterpriseActionsRunnersGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-self-hosted-runners-for-an-enterprise"""

        from ..models import EnterprisesEnterpriseActionsRunnersGetResponse200

        url = f"/enterprises/{enterprise}/actions/runners"

        params = {
            "name": name,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersGetResponse200,
        )

    def list_runner_applications_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[RunnerApplication], list[RunnerApplicationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-an-enterprise"""

        from ..models import RunnerApplication

        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[RunnerApplication],
        )

    async def async_list_runner_applications_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[RunnerApplication], list[RunnerApplicationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-runner-applications-for-an-enterprise"""

        from ..models import RunnerApplication

        url = f"/enterprises/{enterprise}/actions/runners/downloads"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[RunnerApplication],
        )

    def create_registration_token_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-an-enterprise"""

        from ..models import AuthenticationToken

        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_registration_token_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-registration-token-for-an-enterprise"""

        from ..models import AuthenticationToken

        url = f"/enterprises/{enterprise}/actions/runners/registration-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def create_remove_token_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-an-enterprise"""

        from ..models import AuthenticationToken

        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    async def async_create_remove_token_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AuthenticationToken, AuthenticationTokenType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#create-a-remove-token-for-an-enterprise"""

        from ..models import AuthenticationToken

        url = f"/enterprises/{enterprise}/actions/runners/remove-token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AuthenticationToken,
        )

    def get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Runner, RunnerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-an-enterprise"""

        from ..models import Runner

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    async def async_get_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Runner, RunnerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#get-a-self-hosted-runner-for-an-enterprise"""

        from ..models import Runner

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Runner,
        )

    def delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_self_hosted_runner_from_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#delete-a-self-hosted-runner-from-an-enterprise"""

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#list-labels-for-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    def set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    async def async_set_custom_labels_for_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#set-custom-labels-for-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    def add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    @overload
    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        labels: list[str],
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]: ...

    async def async_add_custom_labels_to_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#add-custom-labels-to-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseActionsRunnersRunnerIdLabelsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_all_custom_labels_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-all-custom-labels-from-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsDeleteResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_remove_custom_label_from_self_hosted_runner_for_enterprise(
        self,
        enterprise: str,
        runner_id: int,
        name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
        EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/actions/self-hosted-runners#remove-a-custom-label-from-a-self-hosted-runner-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            response_model=EnterprisesEnterpriseActionsRunnersRunnerIdLabelsGetResponse200,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#get-announcement-banner-for-enterprise"""

        from ..models import AnnouncementBanner

        url = f"/enterprises/{enterprise}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=AnnouncementBanner,
        )

    async def async_get_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#get-announcement-banner-for-enterprise"""

        from ..models import AnnouncementBanner

        url = f"/enterprises/{enterprise}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=AnnouncementBanner,
        )

    def remove_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#remove-announcement-banner-from-enterprise"""

        url = f"/enterprises/{enterprise}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#remove-announcement-banner-from-enterprise"""

        url = f"/enterprises/{enterprise}/announcement"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: AnnouncementType,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    @overload
    def set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        announcement: Union[str, None],
        expires_at: Missing[Union[datetime, None]] = UNSET,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    def set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[AnnouncementType] = UNSET,
        **kwargs,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#set-announcement-banner-for-enterprise"""

        from ..models import Announcement, AnnouncementBanner

        url = f"/enterprises/{enterprise}/announcement"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Announcement, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AnnouncementBanner,
        )

    @overload
    async def async_set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: AnnouncementType,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    @overload
    async def async_set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        announcement: Union[str, None],
        expires_at: Missing[Union[datetime, None]] = UNSET,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]: ...

    async def async_set_announcement_banner_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[AnnouncementType] = UNSET,
        **kwargs,
    ) -> Response[AnnouncementBanner, AnnouncementBannerType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/announcement-banners/enterprises#set-announcement-banner-for-enterprise"""

        from ..models import Announcement, AnnouncementBanner

        url = f"/enterprises/{enterprise}/announcement"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Announcement, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=AnnouncementBanner,
        )

    def get_audit_log(
        self,
        enterprise: str,
        *,
        phrase: Missing[str] = UNSET,
        include: Missing[Literal["web", "git", "all"]] = UNSET,
        after: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[AuditLogEvent], list[AuditLogEventType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#get-the-audit-log-for-an-enterprise"""

        from ..models import AuditLogEvent

        url = f"/enterprises/{enterprise}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[AuditLogEvent],
        )

    async def async_get_audit_log(
        self,
        enterprise: str,
        *,
        phrase: Missing[str] = UNSET,
        include: Missing[Literal["web", "git", "all"]] = UNSET,
        after: Missing[str] = UNSET,
        before: Missing[str] = UNSET,
        order: Missing[Literal["desc", "asc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[AuditLogEvent], list[AuditLogEventType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#get-the-audit-log-for-an-enterprise"""

        from ..models import AuditLogEvent

        url = f"/enterprises/{enterprise}/audit-log"

        params = {
            "phrase": phrase,
            "include": include,
            "after": after,
            "before": before,
            "order": order,
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[AuditLogEvent],
        )

    def get_audit_log_stream_key(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AuditLogStreamKey, AuditLogStreamKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#get-the-audit-log-stream-key-for-encrypting-secrets"""

        from ..models import AuditLogStreamKey

        url = f"/enterprises/{enterprise}/audit-log/stream-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=AuditLogStreamKey,
        )

    async def async_get_audit_log_stream_key(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[AuditLogStreamKey, AuditLogStreamKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#get-the-audit-log-stream-key-for-encrypting-secrets"""

        from ..models import AuditLogStreamKey

        url = f"/enterprises/{enterprise}/audit-log/stream-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=AuditLogStreamKey,
        )

    def get_audit_log_streams(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[GetAuditLogStreamConfigsItems], list[GetAuditLogStreamConfigsItemsType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#list-audit-log-stream-configurations-for-an-enterprise"""

        from ..models import GetAuditLogStreamConfigsItems

        url = f"/enterprises/{enterprise}/audit-log/streams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[GetAuditLogStreamConfigsItems],
        )

    async def async_get_audit_log_streams(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        list[GetAuditLogStreamConfigsItems], list[GetAuditLogStreamConfigsItemsType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#list-audit-log-stream-configurations-for-an-enterprise"""

        from ..models import GetAuditLogStreamConfigsItems

        url = f"/enterprises/{enterprise}/audit-log/streams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[GetAuditLogStreamConfigsItems],
        )

    @overload
    def create_audit_log_stream(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseAuditLogStreamsPostBodyType,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    @overload
    def create_audit_log_stream(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        enabled: bool,
        stream_type: Literal[
            "Azure Blob Storage",
            "Azure Event Hubs",
            "Amazon S3",
            "Splunk",
            "HTTPS Event Collector",
            "Google Cloud Storage",
            "Datadog",
        ],
        vendor_specific: Union[
            AzureBlobConfigType,
            AzureHubConfigType,
            AmazonS3OidcConfigType,
            AmazonS3AccessKeysConfigType,
            SplunkConfigType,
            GoogleCloudConfigType,
            DatadogConfigType,
        ],
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    def create_audit_log_stream(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterpriseAuditLogStreamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#create-an-audit-log-streaming-configuration-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseAuditLogStreamsPostBody,
            GetAuditLogStreamConfig,
        )

        url = f"/enterprises/{enterprise}/audit-log/streams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseAuditLogStreamsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GetAuditLogStreamConfig,
        )

    @overload
    async def async_create_audit_log_stream(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseAuditLogStreamsPostBodyType,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    @overload
    async def async_create_audit_log_stream(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        enabled: bool,
        stream_type: Literal[
            "Azure Blob Storage",
            "Azure Event Hubs",
            "Amazon S3",
            "Splunk",
            "HTTPS Event Collector",
            "Google Cloud Storage",
            "Datadog",
        ],
        vendor_specific: Union[
            AzureBlobConfigType,
            AzureHubConfigType,
            AmazonS3OidcConfigType,
            AmazonS3AccessKeysConfigType,
            SplunkConfigType,
            GoogleCloudConfigType,
            DatadogConfigType,
        ],
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    async def async_create_audit_log_stream(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterpriseAuditLogStreamsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#create-an-audit-log-streaming-configuration-for-an-enterprise"""

        from ..models import (
            EnterprisesEnterpriseAuditLogStreamsPostBody,
            GetAuditLogStreamConfig,
        )

        url = f"/enterprises/{enterprise}/audit-log/streams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseAuditLogStreamsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GetAuditLogStreamConfig,
        )

    def get_one_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#list-one-audit-log-streaming-configuration-via-a-stream-id"""

        from ..models import GetAuditLogStreamConfig

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GetAuditLogStreamConfig,
        )

    async def async_get_one_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#list-one-audit-log-streaming-configuration-via-a-stream-id"""

        from ..models import GetAuditLogStreamConfig

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GetAuditLogStreamConfig,
        )

    @overload
    def update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    @overload
    def update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        enabled: bool,
        stream_type: Literal[
            "Azure Blob Storage",
            "Azure Event Hubs",
            "Amazon S3",
            "Splunk",
            "HTTPS Event Collector",
            "Google Cloud Storage",
            "Datadog",
        ],
        vendor_specific: Union[
            AzureBlobConfigType,
            AzureHubConfigType,
            AmazonS3OidcConfigType,
            AmazonS3AccessKeysConfigType,
            SplunkConfigType,
            GoogleCloudConfigType,
            DatadogConfigType,
        ],
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    def update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#update-an-existing-audit-log-stream-configuration"""

        from ..models import (
            EnterprisesEnterpriseAuditLogStreamsStreamIdPutBody,
            EnterprisesEnterpriseAuditLogStreamsStreamIdPutResponse422,
            GetAuditLogStreamConfig,
        )

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseAuditLogStreamsStreamIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GetAuditLogStreamConfig,
            error_models={
                "422": EnterprisesEnterpriseAuditLogStreamsStreamIdPutResponse422,
            },
        )

    @overload
    async def async_update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    @overload
    async def async_update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        enabled: bool,
        stream_type: Literal[
            "Azure Blob Storage",
            "Azure Event Hubs",
            "Amazon S3",
            "Splunk",
            "HTTPS Event Collector",
            "Google Cloud Storage",
            "Datadog",
        ],
        vendor_specific: Union[
            AzureBlobConfigType,
            AzureHubConfigType,
            AmazonS3OidcConfigType,
            AmazonS3AccessKeysConfigType,
            SplunkConfigType,
            GoogleCloudConfigType,
            DatadogConfigType,
        ],
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]: ...

    async def async_update_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterpriseAuditLogStreamsStreamIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[GetAuditLogStreamConfig, GetAuditLogStreamConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#update-an-existing-audit-log-stream-configuration"""

        from ..models import (
            EnterprisesEnterpriseAuditLogStreamsStreamIdPutBody,
            EnterprisesEnterpriseAuditLogStreamsStreamIdPutResponse422,
            GetAuditLogStreamConfig,
        )

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseAuditLogStreamsStreamIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=GetAuditLogStreamConfig,
            error_models={
                "422": EnterprisesEnterpriseAuditLogStreamsStreamIdPutResponse422,
            },
        )

    def delete_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#delete-an-audit-log-streaming-configuration-for-an-enterprise"""

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_audit_log_stream(
        self,
        enterprise: str,
        stream_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/audit-log#delete-an-audit-log-streaming-configuration-for-an-enterprise"""

        url = f"/enterprises/{enterprise}/audit-log/streams/{stream_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterpriseSecurityAnalysisSettings, EnterpriseSecurityAnalysisSettingsType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#get-code-security-and-analysis-features-for-an-enterprise"""

        from ..models import BasicError, EnterpriseSecurityAnalysisSettings

        url = f"/enterprises/{enterprise}/code_security_and_analysis"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=EnterpriseSecurityAnalysisSettings,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[
        EnterpriseSecurityAnalysisSettings, EnterpriseSecurityAnalysisSettingsType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#get-code-security-and-analysis-features-for-an-enterprise"""

        from ..models import BasicError, EnterpriseSecurityAnalysisSettings

        url = f"/enterprises/{enterprise}/code_security_and_analysis"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=EnterpriseSecurityAnalysisSettings,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType
        ] = UNSET,
    ) -> Response: ...

    @overload
    def patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        advanced_security_enabled_new_user_namespace_repos: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[Union[str, None]] = UNSET,
        secret_scanning_non_provider_patterns_enabled_for_new_repositories: Missing[
            Union[bool, None]
        ] = UNSET,
    ) -> Response: ...

    def patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#update-code-security-and-analysis-features-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBody,
        )

        url = f"/enterprises/{enterprise}/code_security_and_analysis"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        advanced_security_enabled_for_new_repositories: Missing[bool] = UNSET,
        advanced_security_enabled_new_user_namespace_repos: Missing[bool] = UNSET,
        dependabot_alerts_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_enabled_for_new_repositories: Missing[bool] = UNSET,
        secret_scanning_push_protection_enabled_for_new_repositories: Missing[
            bool
        ] = UNSET,
        secret_scanning_push_protection_custom_link: Missing[Union[str, None]] = UNSET,
        secret_scanning_non_provider_patterns_enabled_for_new_repositories: Missing[
            Union[bool, None]
        ] = UNSET,
    ) -> Response: ...

    async def async_patch_security_analysis_settings_for_enterprise(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#update-code-security-and-analysis-features-for-an-enterprise"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBody,
        )

        url = f"/enterprises/{enterprise}/code_security_and_analysis"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseCodeSecurityAndAnalysisPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_consumed_licenses(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[GetConsumedLicenses, GetConsumedLicensesType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/license#list-enterprise-consumed-licenses"""

        from ..models import GetConsumedLicenses

        url = f"/enterprises/{enterprise}/consumed-licenses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=GetConsumedLicenses,
        )

    async def async_get_consumed_licenses(
        self,
        enterprise: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[GetConsumedLicenses, GetConsumedLicensesType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/license#list-enterprise-consumed-licenses"""

        from ..models import GetConsumedLicenses

        url = f"/enterprises/{enterprise}/consumed-licenses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=GetConsumedLicenses,
        )

    def get_license_sync_status(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[GetLicenseSyncStatus, GetLicenseSyncStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/license#get-a-license-sync-status"""

        from ..models import GetLicenseSyncStatus

        url = f"/enterprises/{enterprise}/license-sync-status"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GetLicenseSyncStatus,
        )

    async def async_get_license_sync_status(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[GetLicenseSyncStatus, GetLicenseSyncStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/license#get-a-license-sync-status"""

        from ..models import GetLicenseSyncStatus

        url = f"/enterprises/{enterprise}/license-sync-status"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=GetLicenseSyncStatus,
        )

    def get_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#get-custom-properties-for-an-enterprise"""

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#get-custom-properties-for-an-enterprise"""

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterprisePropertiesSchemaPatchBodyType,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    @overload
    def create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        properties: list[CustomPropertyType],
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    def create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterprisePropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#create-or-update-custom-properties-for-an-enterprise"""

        from ..models import (
            BasicError,
            CustomProperty,
            EnterprisesEnterprisePropertiesSchemaPatchBody,
        )

        url = f"/enterprises/{enterprise}/properties/schema"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterprisePropertiesSchemaPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: EnterprisesEnterprisePropertiesSchemaPatchBodyType,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    @overload
    async def async_create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        properties: list[CustomPropertyType],
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]: ...

    async def async_create_or_update_enterprise_custom_properties(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[EnterprisesEnterprisePropertiesSchemaPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[list[CustomProperty], list[CustomPropertyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#create-or-update-custom-properties-for-an-enterprise"""

        from ..models import (
            BasicError,
            CustomProperty,
            EnterprisesEnterprisePropertiesSchemaPatchBody,
        )

        url = f"/enterprises/{enterprise}/properties/schema"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterprisePropertiesSchemaPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[CustomProperty],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def get_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#get-a-custom-property-for-an-enterprise"""

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#get-a-custom-property-for-an-enterprise"""

        from ..models import BasicError, CustomProperty

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: CustomPropertySetPayloadType,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    @overload
    def create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, list[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[list[str], None]] = UNSET,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    def create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[CustomPropertySetPayloadType] = UNSET,
        **kwargs,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#create-or-update-a-custom-property-for-an-enterprise"""

        from ..models import BasicError, CustomProperty, CustomPropertySetPayload

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CustomPropertySetPayload, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: CustomPropertySetPayloadType,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    @overload
    async def async_create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        value_type: Literal["string", "single_select", "multi_select", "true_false"],
        required: Missing[bool] = UNSET,
        default_value: Missing[Union[str, list[str], None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        allowed_values: Missing[Union[list[str], None]] = UNSET,
    ) -> Response[CustomProperty, CustomPropertyType]: ...

    async def async_create_or_update_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[CustomPropertySetPayloadType] = UNSET,
        **kwargs,
    ) -> Response[CustomProperty, CustomPropertyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#create-or-update-a-custom-property-for-an-enterprise"""

        from ..models import BasicError, CustomProperty, CustomPropertySetPayload

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CustomPropertySetPayload, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CustomProperty,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def remove_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#remove-a-custom-property-for-an-enterprise"""

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_enterprise_custom_property(
        self,
        enterprise: str,
        custom_property_name: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/custom-properties#remove-a-custom-property-for-an-enterprise"""

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/properties/schema/{custom_property_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def post_security_product_enablement_for_enterprise(
        self,
        enterprise: str,
        security_product: Literal[
            "advanced_security",
            "advanced_security_user_namespace",
            "dependabot_alerts",
            "secret_scanning",
            "secret_scanning_push_protection",
            "secret_scanning_non_provider_patterns",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#enable-or-disable-a-security-feature"""

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/{security_product}/{enablement}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_post_security_product_enablement_for_enterprise(
        self,
        enterprise: str,
        security_product: Literal[
            "advanced_security",
            "advanced_security_user_namespace",
            "dependabot_alerts",
            "secret_scanning",
            "secret_scanning_push_protection",
            "secret_scanning_non_provider_patterns",
        ],
        enablement: Literal["enable_all", "disable_all"],
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/code-security-and-analysis#enable-or-disable-a-security-feature"""

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/{security_product}/{enablement}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_provisioned_groups_enterprise(
        self,
        enterprise: str,
        *,
        filter_: Missing[str] = UNSET,
        excluded_attributes: Missing[str] = UNSET,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ScimEnterpriseGroupList, ScimEnterpriseGroupListType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#list-provisioned-scim-groups-for-an-enterprise"""

        from ..models import ScimEnterpriseGroupList, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        params = {
            "filter": filter_,
            "excludedAttributes": excluded_attributes,
            "startIndex": start_index,
            "count": count,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseGroupList,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_list_provisioned_groups_enterprise(
        self,
        enterprise: str,
        *,
        filter_: Missing[str] = UNSET,
        excluded_attributes: Missing[str] = UNSET,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ScimEnterpriseGroupList, ScimEnterpriseGroupListType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#list-provisioned-scim-groups-for-an-enterprise"""

        from ..models import ScimEnterpriseGroupList, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        params = {
            "filter": filter_,
            "excludedAttributes": excluded_attributes,
            "startIndex": start_index,
            "count": count,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseGroupList,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def provision_enterprise_group(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: GroupType,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    @overload
    def provision_enterprise_group(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:Group"]],
        external_id: str,
        display_name: str,
        members: list[GroupPropMembersItemsType],
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    def provision_enterprise_group(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[GroupType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#provision-a-scim-enterprise-group"""

        from ..models import Group, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Group, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_provision_enterprise_group(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: GroupType,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    @overload
    async def async_provision_enterprise_group(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:Group"]],
        external_id: str,
        display_name: str,
        members: list[GroupPropMembersItemsType],
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    async def async_provision_enterprise_group(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[GroupType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#provision-a-scim-enterprise-group"""

        from ..models import Group, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Group, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def get_provisioning_information_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        excluded_attributes: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#get-scim-provisioning-information-for-an-enterprise-group"""

        from ..models import BasicError, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        params = {
            "excludedAttributes": excluded_attributes,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_get_provisioning_information_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        excluded_attributes: Missing[str] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#get-scim-provisioning-information-for-an-enterprise-group"""

        from ..models import BasicError, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        params = {
            "excludedAttributes": excluded_attributes,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: GroupType,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    @overload
    def set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:Group"]],
        external_id: str,
        display_name: str,
        members: list[GroupPropMembersItemsType],
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    def set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[GroupType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#set-scim-information-for-a-provisioned-enterprise-group"""

        from ..models import BasicError, Group, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Group, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: GroupType,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    @overload
    async def async_set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:Group"]],
        external_id: str,
        display_name: str,
        members: list[GroupPropMembersItemsType],
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]: ...

    async def async_set_information_for_provisioned_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[GroupType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseGroupResponse, ScimEnterpriseGroupResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#set-scim-information-for-a-provisioned-enterprise-group"""

        from ..models import BasicError, Group, ScimEnterpriseGroupResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Group, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseGroupResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def delete_scim_group_from_enterprise(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#delete-a-scim-group-from-an-enterprise"""

        from ..models import BasicError, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_delete_scim_group_from_enterprise(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#delete-a-scim-group-from-an-enterprise"""

        from ..models import BasicError, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: PatchSchemaType,
    ) -> Response: ...

    @overload
    def update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        operations: list[PatchSchemaPropOperationsItemsType],
        schemas: list[Literal["urn:ietf:params:scim:api:messages:2.0:PatchOp"]],
    ) -> Response: ...

    def update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[PatchSchemaType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#update-an-attribute-for-a-scim-enterprise-group"""

        from ..models import BasicError, PatchSchema, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PatchSchema, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: PatchSchemaType,
    ) -> Response: ...

    @overload
    async def async_update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        operations: list[PatchSchemaPropOperationsItemsType],
        schemas: list[Literal["urn:ietf:params:scim:api:messages:2.0:PatchOp"]],
    ) -> Response: ...

    async def async_update_attribute_for_enterprise_group(
        self,
        scim_group_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[PatchSchemaType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#update-an-attribute-for-a-scim-enterprise-group"""

        from ..models import BasicError, PatchSchema, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PatchSchema, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def list_provisioned_identities_enterprise(
        self,
        enterprise: str,
        *,
        filter_: Missing[str] = UNSET,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ScimEnterpriseUserList, ScimEnterpriseUserListType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#list-scim-provisioned-identities-for-an-enterprise"""

        from ..models import ScimEnterpriseUserList, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users"

        params = {
            "filter": filter_,
            "startIndex": start_index,
            "count": count,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserList,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_list_provisioned_identities_enterprise(
        self,
        enterprise: str,
        *,
        filter_: Missing[str] = UNSET,
        start_index: Missing[int] = UNSET,
        count: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ScimEnterpriseUserList, ScimEnterpriseUserListType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#list-scim-provisioned-identities-for-an-enterprise"""

        from ..models import ScimEnterpriseUserList, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users"

        params = {
            "filter": filter_,
            "startIndex": start_index,
            "count": count,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserList,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def provision_enterprise_user(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: UserType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    def provision_enterprise_user(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:User"]],
        external_id: str,
        active: bool,
        user_name: str,
        name: Missing[UserNameType] = UNSET,
        display_name: str,
        emails: list[UserEmailsItemsType],
        roles: Missing[list[UserRoleItemsType]] = UNSET,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    def provision_enterprise_user(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[UserType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#provision-a-scim-enterprise-user"""

        from ..models import ScimEnterpriseUserResponse, ScimError, User

        url = f"/scim/v2/enterprises/{enterprise}/Users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(User, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_provision_enterprise_user(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: UserType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    async def async_provision_enterprise_user(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:User"]],
        external_id: str,
        active: bool,
        user_name: str,
        name: Missing[UserNameType] = UNSET,
        display_name: str,
        emails: list[UserEmailsItemsType],
        roles: Missing[list[UserRoleItemsType]] = UNSET,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    async def async_provision_enterprise_user(
        self,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[UserType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#provision-a-scim-enterprise-user"""

        from ..models import ScimEnterpriseUserResponse, ScimError, User

        url = f"/scim/v2/enterprises/{enterprise}/Users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(User, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def get_provisioning_information_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#get-scim-provisioning-information-for-an-enterprise-user"""

        from ..models import BasicError, ScimEnterpriseUserResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_get_provisioning_information_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#get-scim-provisioning-information-for-an-enterprise-user"""

        from ..models import BasicError, ScimEnterpriseUserResponse, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: UserType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    def set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:User"]],
        external_id: str,
        active: bool,
        user_name: str,
        name: Missing[UserNameType] = UNSET,
        display_name: str,
        emails: list[UserEmailsItemsType],
        roles: Missing[list[UserRoleItemsType]] = UNSET,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    def set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[UserType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#set-scim-information-for-a-provisioned-enterprise-user"""

        from ..models import BasicError, ScimEnterpriseUserResponse, ScimError, User

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(User, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: UserType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    async def async_set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        schemas: list[Literal["urn:ietf:params:scim:schemas:core:2.0:User"]],
        external_id: str,
        active: bool,
        user_name: str,
        name: Missing[UserNameType] = UNSET,
        display_name: str,
        emails: list[UserEmailsItemsType],
        roles: Missing[list[UserRoleItemsType]] = UNSET,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    async def async_set_information_for_provisioned_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[UserType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#set-scim-information-for-a-provisioned-enterprise-user"""

        from ..models import BasicError, ScimEnterpriseUserResponse, ScimError, User

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(User, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    def delete_user_from_enterprise(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#delete-a-scim-user-from-an-enterprise"""

        from ..models import BasicError, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    async def async_delete_user_from_enterprise(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#delete-a-scim-user-from-an-enterprise"""

        from ..models import BasicError, ScimError

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    def update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: PatchSchemaType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    def update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        operations: list[PatchSchemaPropOperationsItemsType],
        schemas: list[Literal["urn:ietf:params:scim:api:messages:2.0:PatchOp"]],
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    def update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[PatchSchemaType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#update-an-attribute-for-a-scim-enterprise-user"""

        from ..models import (
            BasicError,
            PatchSchema,
            ScimEnterpriseUserResponse,
            ScimError,
        )

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PatchSchema, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )

    @overload
    async def async_update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: PatchSchemaType,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    @overload
    async def async_update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        operations: list[PatchSchemaPropOperationsItemsType],
        schemas: list[Literal["urn:ietf:params:scim:api:messages:2.0:PatchOp"]],
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]: ...

    async def async_update_attribute_for_enterprise_user(
        self,
        scim_user_id: str,
        enterprise: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[PatchSchemaType] = UNSET,
        **kwargs,
    ) -> Response[ScimEnterpriseUserResponse, ScimEnterpriseUserResponseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/scim#update-an-attribute-for-a-scim-enterprise-user"""

        from ..models import (
            BasicError,
            PatchSchema,
            ScimEnterpriseUserResponse,
            ScimError,
        )

        url = f"/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(PatchSchema, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ScimEnterpriseUserResponse,
            error_models={
                "400": ScimError,
                "404": BasicError,
                "429": ScimError,
                "500": ScimError,
            },
        )
