"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        Project,
        ProjectCard,
        ProjectCollaboratorPermission,
        ProjectColumn,
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201,
        SimpleUser,
    )
    from ..types import (
        OrgsOrgProjectsPostBodyType,
        ProjectCardType,
        ProjectCollaboratorPermissionType,
        ProjectColumnType,
        ProjectsColumnsCardsCardIdMovesPostBodyType,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
        ProjectsColumnsCardsCardIdPatchBodyType,
        ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
        ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ProjectsColumnsColumnIdMovesPostBodyType,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
        ProjectsColumnsColumnIdPatchBodyType,
        ProjectsProjectIdCollaboratorsUsernamePutBodyType,
        ProjectsProjectIdColumnsPostBodyType,
        ProjectsProjectIdPatchBodyType,
        ProjectType,
        ReposOwnerRepoProjectsPostBodyType,
        SimpleUserType,
        UserProjectsPostBodyType,
    )


class ProjectsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_org(
        self,
        org: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Project], list[ProjectType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-organization-projects"""

        from ..models import Project, ValidationErrorSimple

        url = f"/orgs/{org}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Project],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_for_org(
        self,
        org: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Project], list[ProjectType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-organization-projects"""

        from ..models import Project, ValidationErrorSimple

        url = f"/orgs/{org}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Project],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    def create_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        body: Missing[str] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    def create_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#create-an-organization-project"""

        from ..models import (
            BasicError,
            OrgsOrgProjectsPostBody,
            Project,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: OrgsOrgProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    async def async_create_for_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        body: Missing[str] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    async def async_create_for_org(
        self,
        org: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[OrgsOrgProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#create-an-organization-project"""

        from ..models import (
            BasicError,
            OrgsOrgProjectsPostBody,
            Project,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ProjectCard, ProjectCardType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#get-a-project-card"""

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ProjectCard, ProjectCardType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#get-a-project-card"""

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
            },
        )

    def delete_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#delete-a-project-card"""

        from ..models import BasicError, ProjectsColumnsCardsCardIdDeleteResponse403

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#delete-a-project-card"""

        from ..models import BasicError, ProjectsColumnsCardsCardIdDeleteResponse403

        url = f"/projects/columns/cards/{card_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ProjectsColumnsCardsCardIdDeleteResponse403,
                "401": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    def update_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        note: Missing[Union[str, None]] = UNSET,
        archived: Missing[bool] = UNSET,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    def update_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#update-an-existing-project-card"""

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsCardsCardIdPatchBody,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    async def async_update_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        note: Missing[Union[str, None]] = UNSET,
        archived: Missing[bool] = UNSET,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    async def async_update_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsCardsCardIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#update-an-existing-project-card"""

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsCardsCardIdPatchBody,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/cards/{card_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def move_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ProjectsColumnsCardsCardIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]: ...

    @overload
    def move_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        position: str,
        column_id: Missing[int] = UNSET,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]: ...

    def move_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsCardsCardIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#move-a-project-card"""

        from ..models import (
            BasicError,
            ProjectsColumnsCardsCardIdMovesPostBody,
            ProjectsColumnsCardsCardIdMovesPostResponse201,
            ProjectsColumnsCardsCardIdMovesPostResponse403,
            ProjectsColumnsCardsCardIdMovesPostResponse503,
            ValidationError,
        )

        url = f"/projects/columns/cards/{card_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    @overload
    async def async_move_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ProjectsColumnsCardsCardIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]: ...

    @overload
    async def async_move_card(
        self,
        card_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        position: str,
        column_id: Missing[int] = UNSET,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]: ...

    async def async_move_card(
        self,
        card_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsCardsCardIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsCardsCardIdMovesPostResponse201,
        ProjectsColumnsCardsCardIdMovesPostResponse201Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#move-a-project-card"""

        from ..models import (
            BasicError,
            ProjectsColumnsCardsCardIdMovesPostBody,
            ProjectsColumnsCardsCardIdMovesPostResponse201,
            ProjectsColumnsCardsCardIdMovesPostResponse403,
            ProjectsColumnsCardsCardIdMovesPostResponse503,
            ValidationError,
        )

        url = f"/projects/columns/cards/{card_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsCardsCardIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectsColumnsCardsCardIdMovesPostResponse201,
            error_models={
                "403": ProjectsColumnsCardsCardIdMovesPostResponse403,
                "401": BasicError,
                "503": ProjectsColumnsCardsCardIdMovesPostResponse503,
                "422": ValidationError,
            },
        )

    def get_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#get-a-project-column"""

        from ..models import BasicError, ProjectColumn

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#get-a-project-column"""

        from ..models import BasicError, ProjectColumn

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "401": BasicError,
            },
        )

    def delete_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#delete-a-project-column"""

        from ..models import BasicError

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_delete_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#delete-a-project-column"""

        from ..models import BasicError

        url = f"/projects/columns/{column_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def update_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ProjectsColumnsColumnIdPatchBodyType,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    @overload
    def update_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    def update_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#update-an-existing-project-column"""

        from ..models import BasicError, ProjectColumn, ProjectsColumnsColumnIdPatchBody

        url = f"/projects/columns/{column_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_update_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ProjectsColumnsColumnIdPatchBodyType,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    @overload
    async def async_update_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    async def async_update_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsColumnIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#update-an-existing-project-column"""

        from ..models import BasicError, ProjectColumn, ProjectsColumnsColumnIdPatchBody

        url = f"/projects/columns/{column_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_cards(
        self,
        column_id: int,
        *,
        archived_state: Missing[Literal["all", "archived", "not_archived"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ProjectCard], list[ProjectCardType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#list-project-cards"""

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_cards(
        self,
        column_id: int,
        *,
        archived_state: Missing[Literal["all", "archived", "not_archived"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ProjectCard], list[ProjectCardType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#list-project-cards"""

        from ..models import BasicError, ProjectCard

        url = f"/projects/columns/{column_id}/cards"

        params = {
            "archived_state": archived_state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ProjectCard],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_card(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    def create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        note: Union[str, None],
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    def create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        content_id: int,
        content_type: str,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    def create_card(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
                ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#create-a-project-card"""

        from typing import Union

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsColumnIdCardsPostBodyOneof0,
            ProjectsColumnsColumnIdCardsPostBodyOneof1,
            ProjectsColumnsColumnIdCardsPostResponse503,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/cards"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ProjectsColumnsColumnIdCardsPostBodyOneof0,
                    ProjectsColumnsColumnIdCardsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    @overload
    async def async_create_card(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Union[
            ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
            ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
        ],
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    async def async_create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        note: Union[str, None],
    ) -> Response[ProjectCard, ProjectCardType]: ...

    @overload
    async def async_create_card(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        content_id: int,
        content_type: str,
    ) -> Response[ProjectCard, ProjectCardType]: ...

    async def async_create_card(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[
                ProjectsColumnsColumnIdCardsPostBodyOneof0Type,
                ProjectsColumnsColumnIdCardsPostBodyOneof1Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[ProjectCard, ProjectCardType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/cards#create-a-project-card"""

        from typing import Union

        from ..models import (
            BasicError,
            ProjectCard,
            ProjectsColumnsColumnIdCardsPostBodyOneof0,
            ProjectsColumnsColumnIdCardsPostBodyOneof1,
            ProjectsColumnsColumnIdCardsPostResponse503,
            ValidationError,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/cards"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ProjectsColumnsColumnIdCardsPostBodyOneof0,
                    ProjectsColumnsColumnIdCardsPostBodyOneof1,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectCard,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": Union[ValidationError, ValidationErrorSimple],
                "503": ProjectsColumnsColumnIdCardsPostResponse503,
            },
        )

    @overload
    def move_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ProjectsColumnsColumnIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]: ...

    @overload
    def move_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        position: str,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]: ...

    def move_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#move-a-project-column"""

        from ..models import (
            BasicError,
            ProjectsColumnsColumnIdMovesPostBody,
            ProjectsColumnsColumnIdMovesPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @overload
    async def async_move_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ProjectsColumnsColumnIdMovesPostBodyType,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]: ...

    @overload
    async def async_move_column(
        self,
        column_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        position: str,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]: ...

    async def async_move_column(
        self,
        column_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsColumnsColumnIdMovesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ProjectsColumnsColumnIdMovesPostResponse201,
        ProjectsColumnsColumnIdMovesPostResponse201Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#move-a-project-column"""

        from ..models import (
            BasicError,
            ProjectsColumnsColumnIdMovesPostBody,
            ProjectsColumnsColumnIdMovesPostResponse201,
            ValidationErrorSimple,
        )

        url = f"/projects/columns/{column_id}/moves"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsColumnsColumnIdMovesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectsColumnsColumnIdMovesPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    def get(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-a-project"""

        from ..models import BasicError, Project

        url = f"/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#get-a-project"""

        from ..models import BasicError, Project

        url = f"/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def delete(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#delete-a-project"""

        from ..models import BasicError, ProjectsProjectIdDeleteResponse403

        url = f"/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ProjectsProjectIdDeleteResponse403,
                "401": BasicError,
                "410": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#delete-a-project"""

        from ..models import BasicError, ProjectsProjectIdDeleteResponse403

        url = f"/projects/{project_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ProjectsProjectIdDeleteResponse403,
                "401": BasicError,
                "410": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    @overload
    def update(
        self,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        state: Missing[str] = UNSET,
        organization_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    def update(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#update-a-project"""

        from ..models import (
            BasicError,
            Project,
            ProjectsProjectIdPatchBody,
            ProjectsProjectIdPatchResponse403,
            ValidationErrorSimple,
        )

        url = f"/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsProjectIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": ProjectsProjectIdPatchResponse403,
                "401": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    @overload
    async def async_update(
        self,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: Missing[str] = UNSET,
        body: Missing[Union[str, None]] = UNSET,
        state: Missing[str] = UNSET,
        organization_permission: Missing[
            Literal["read", "write", "admin", "none"]
        ] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    async def async_update(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsProjectIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#update-a-project"""

        from ..models import (
            BasicError,
            Project,
            ProjectsProjectIdPatchBody,
            ProjectsProjectIdPatchResponse403,
            ValidationErrorSimple,
        )

        url = f"/projects/{project_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsProjectIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": ProjectsProjectIdPatchResponse403,
                "401": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_collaborators(
        self,
        project_id: int,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/collaborators#list-project-collaborators"""

        from ..models import BasicError, SimpleUser, ValidationError

        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        project_id: int,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/collaborators#list-project-collaborators"""

        from ..models import BasicError, SimpleUser, ValidationError

        url = f"/projects/{project_id}/collaborators"

        params = {
            "affiliation": affiliation,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    def add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/collaborators#add-project-collaborator"""

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsProjectIdCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        permission: Missing[Literal["read", "write", "admin"]] = UNSET,
    ) -> Response: ...

    async def async_add_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[
            Union[ProjectsProjectIdCollaboratorsUsernamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/collaborators#add-project-collaborator"""

        from typing import Union

        from ..models import (
            BasicError,
            ProjectsProjectIdCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ProjectsProjectIdCollaboratorsUsernamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def remove_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/collaborators#remove-user-as-a-collaborator"""

        from ..models import BasicError, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    async def async_remove_collaborator(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/collaborators#remove-user-as-a-collaborator"""

        from ..models import BasicError, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    def get_permission_for_user(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ProjectCollaboratorPermission, ProjectCollaboratorPermissionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/collaborators#get-project-permission-for-a-user"""

        from ..models import BasicError, ProjectCollaboratorPermission, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_permission_for_user(
        self,
        project_id: int,
        username: str,
        *,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[ProjectCollaboratorPermission, ProjectCollaboratorPermissionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/collaborators#get-project-permission-for-a-user"""

        from ..models import BasicError, ProjectCollaboratorPermission, ValidationError

        url = f"/projects/{project_id}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProjectCollaboratorPermission,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_columns(
        self,
        project_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ProjectColumn], list[ProjectColumnType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#list-project-columns"""

        from ..models import BasicError, ProjectColumn

        url = f"/projects/{project_id}/columns"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ProjectColumn],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_columns(
        self,
        project_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[ProjectColumn], list[ProjectColumnType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#list-project-columns"""

        from ..models import BasicError, ProjectColumn

        url = f"/projects/{project_id}/columns"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ProjectColumn],
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_column(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ProjectsProjectIdColumnsPostBodyType,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    @overload
    def create_column(
        self,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    def create_column(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsProjectIdColumnsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#create-a-project-column"""

        from ..models import (
            BasicError,
            ProjectColumn,
            ProjectsProjectIdColumnsPostBody,
            ValidationErrorSimple,
        )

        url = f"/projects/{project_id}/columns"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsProjectIdColumnsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    @overload
    async def async_create_column(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ProjectsProjectIdColumnsPostBodyType,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    @overload
    async def async_create_column(
        self,
        project_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
    ) -> Response[ProjectColumn, ProjectColumnType]: ...

    async def async_create_column(
        self,
        project_id: int,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ProjectsProjectIdColumnsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProjectColumn, ProjectColumnType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/columns#create-a-project-column"""

        from ..models import (
            BasicError,
            ProjectColumn,
            ProjectsProjectIdColumnsPostBody,
            ValidationErrorSimple,
        )

        url = f"/projects/{project_id}/columns"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ProjectsProjectIdColumnsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProjectColumn,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "401": BasicError,
            },
        )

    def list_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Project], list[ProjectType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-repository-projects"""

        from ..models import BasicError, Project, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Project],
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Project], list[ProjectType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-repository-projects"""

        from ..models import BasicError, Project, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Project],
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    def create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        body: Missing[str] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    def create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#create-a-repository-project"""

        from ..models import (
            BasicError,
            Project,
            ReposOwnerRepoProjectsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: ReposOwnerRepoProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    async def async_create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        body: Missing[str] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    async def async_create_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[ReposOwnerRepoProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#create-a-repository-project"""

        from ..models import (
            BasicError,
            Project,
            ReposOwnerRepoProjectsPostBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "410": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[dict[str, str]] = None,
        data: UserProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        body: Missing[Union[str, None]] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[UserProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#create-a-user-project"""

        from ..models import (
            BasicError,
            Project,
            UserProjectsPostBody,
            ValidationErrorSimple,
        )

        url = "/user/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[dict[str, str]] = None,
        data: UserProjectsPostBodyType,
    ) -> Response[Project, ProjectType]: ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[dict[str, str]] = None,
        name: str,
        body: Missing[Union[str, None]] = UNSET,
    ) -> Response[Project, ProjectType]: ...

    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[dict[str, str]] = None,
        data: Missing[UserProjectsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Project, ProjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#create-a-user-project"""

        from ..models import (
            BasicError,
            Project,
            UserProjectsPostBody,
            ValidationErrorSimple,
        )

        url = "/user/projects"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserProjectsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Project,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_for_user(
        self,
        username: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Project], list[ProjectType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-user-projects"""

        from ..models import Project, ValidationError

        url = f"/users/{username}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Project],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_for_user(
        self,
        username: str,
        *,
        state: Missing[Literal["open", "closed", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[dict[str, str]] = None,
    ) -> Response[list[Project], list[ProjectType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/projects/projects#list-user-projects"""

        from ..models import Project, ValidationError

        url = f"/users/{username}/projects"

        params = {
            "state": state,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Project],
            error_models={
                "422": ValidationError,
            },
        )
