"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from typing import Literal

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        DependabotAlert,
        DependabotAlertWithRepository,
        DependabotPublicKey,
        DependabotSecret,
        EmptyObject,
        OrganizationDependabotSecret,
        OrgsOrgDependabotSecretsGetResponse200,
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        ReposOwnerRepoDependabotSecretsGetResponse200,
    )
    from ..types import (
        DependabotAlertType,
        DependabotAlertWithRepositoryType,
        DependabotPublicKeyType,
        DependabotSecretType,
        EmptyObjectType,
        OrganizationDependabotSecretType,
        OrgsOrgDependabotSecretsGetResponse200Type,
        OrgsOrgDependabotSecretsSecretNamePutBodyType,
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200Type,
        OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType,
        ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType,
        ReposOwnerRepoDependabotSecretsGetResponse200Type,
        ReposOwnerRepoDependabotSecretsSecretNamePutBodyType,
    )


class DependabotClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_alerts_for_enterprise(
        self,
        enterprise: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = UNSET,
        last: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[DependabotAlertWithRepository], list[DependabotAlertWithRepositoryType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#list-dependabot-alerts-for-an-enterprise"""

        from ..models import (
            BasicError,
            DependabotAlertWithRepository,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DependabotAlertWithRepository],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_alerts_for_enterprise(
        self,
        enterprise: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = UNSET,
        last: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[DependabotAlertWithRepository], list[DependabotAlertWithRepositoryType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#list-dependabot-alerts-for-an-enterprise"""

        from ..models import (
            BasicError,
            DependabotAlertWithRepository,
            ValidationErrorSimple,
        )

        url = f"/enterprises/{enterprise}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DependabotAlertWithRepository],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_alerts_for_org(
        self,
        org: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = UNSET,
        last: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[DependabotAlertWithRepository], list[DependabotAlertWithRepositoryType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#list-dependabot-alerts-for-an-organization"""

        from ..models import (
            BasicError,
            DependabotAlertWithRepository,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DependabotAlertWithRepository],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_alerts_for_org(
        self,
        org: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = UNSET,
        last: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[DependabotAlertWithRepository], list[DependabotAlertWithRepositoryType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#list-dependabot-alerts-for-an-organization"""

        from ..models import (
            BasicError,
            DependabotAlertWithRepository,
            ValidationErrorSimple,
        )

        url = f"/orgs/{org}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DependabotAlertWithRepository],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_org_secrets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        OrgsOrgDependabotSecretsGetResponse200,
        OrgsOrgDependabotSecretsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#list-organization-secrets"""

        from ..models import OrgsOrgDependabotSecretsGetResponse200

        url = f"/orgs/{org}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgDependabotSecretsGetResponse200,
        )

    async def async_list_org_secrets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        OrgsOrgDependabotSecretsGetResponse200,
        OrgsOrgDependabotSecretsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#list-organization-secrets"""

        from ..models import OrgsOrgDependabotSecretsGetResponse200

        url = f"/orgs/{org}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgDependabotSecretsGetResponse200,
        )

    def get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DependabotPublicKey, DependabotPublicKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#get-an-organization-public-key"""

        from ..models import DependabotPublicKey

        url = f"/orgs/{org}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotPublicKey,
        )

    async def async_get_org_public_key(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DependabotPublicKey, DependabotPublicKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#get-an-organization-public-key"""

        from ..models import DependabotPublicKey

        url = f"/orgs/{org}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotPublicKey,
        )

    def get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[OrganizationDependabotSecret, OrganizationDependabotSecretType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#get-an-organization-secret"""

        from ..models import OrganizationDependabotSecret

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationDependabotSecret,
        )

    async def async_get_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[OrganizationDependabotSecret, OrganizationDependabotSecretType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#get-an-organization-secret"""

        from ..models import OrganizationDependabotSecret

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=OrganizationDependabotSecret,
        )

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgDependabotSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[str]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#create-or-update-an-organization-secret"""

        from ..models import EmptyObject, OrgsOrgDependabotSecretsSecretNamePutBody

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgDependabotSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgDependabotSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
        visibility: Literal["all", "private", "selected"],
        selected_repository_ids: Missing[list[str]] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_or_update_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#create-or-update-an-organization-secret"""

        from ..models import EmptyObject, OrgsOrgDependabotSecretsSecretNamePutBody

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgDependabotSecretsSecretNamePutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#delete-an-organization-secret"""

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#delete-an-organization-secret"""

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#list-selected-repositories-for-an-organization-secret"""

        from ..models import (
            OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

    async def async_list_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#list-selected-repositories-for-an-organization-secret"""

        from ..models import (
            OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=OrgsOrgDependabotSecretsSecretNameRepositoriesGetResponse200,
        )

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        selected_repository_ids: list[int],
    ) -> Response: ...

    def set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret"""

        from ..models import OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType,
    ) -> Response: ...

    @overload
    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        selected_repository_ids: list[int],
    ) -> Response: ...

    async def async_set_selected_repos_for_org_secret(
        self,
        org: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            OrgsOrgDependabotSecretsSecretNameRepositoriesPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#set-selected-repositories-for-an-organization-secret"""

        from ..models import OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody

        url = f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                OrgsOrgDependabotSecretsSecretNameRepositoriesPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
        )

    def add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#add-selected-repository-to-an-organization-secret"""

        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_add_selected_repo_to_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#add-selected-repository-to-an-organization-secret"""

        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret"""

        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_remove_selected_repo_from_org_secret(
        self,
        org: str,
        secret_name: str,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#remove-selected-repository-from-an-organization-secret"""

        url = (
            f"/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        manifest: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = UNSET,
        last: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[DependabotAlert], list[DependabotAlertType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#list-dependabot-alerts-for-a-repository"""

        from ..models import BasicError, DependabotAlert, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "manifest": manifest,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DependabotAlert],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        state: Missing[str] = UNSET,
        severity: Missing[str] = UNSET,
        ecosystem: Missing[str] = UNSET,
        package: Missing[str] = UNSET,
        manifest: Missing[str] = UNSET,
        scope: Missing[Literal["development", "runtime"]] = UNSET,
        sort: Missing[Literal["created", "updated", "epss_percentage"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        first: Missing[int] = UNSET,
        last: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[DependabotAlert], list[DependabotAlertType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#list-dependabot-alerts-for-a-repository"""

        from ..models import BasicError, DependabotAlert, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/dependabot/alerts"

        params = {
            "state": state,
            "severity": severity,
            "ecosystem": ecosystem,
            "package": package,
            "manifest": manifest,
            "scope": scope,
            "sort": sort,
            "direction": direction,
            "page": page,
            "per_page": per_page,
            "before": before,
            "after": after,
            "first": first,
            "last": last,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DependabotAlert],
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DependabotAlert, DependabotAlertType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#get-a-dependabot-alert"""

        from ..models import BasicError, DependabotAlert

        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DependabotAlert, DependabotAlertType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#get-a-dependabot-alert"""

        from ..models import BasicError, DependabotAlert

        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType,
    ) -> Response[DependabotAlert, DependabotAlertType]: ...

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal["dismissed", "open"],
        dismissed_reason: Missing[
            Literal[
                "fix_started",
                "inaccurate",
                "no_bandwidth",
                "not_used",
                "tolerable_risk",
            ]
        ] = UNSET,
        dismissed_comment: Missing[str] = UNSET,
    ) -> Response[DependabotAlert, DependabotAlertType]: ...

    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[DependabotAlert, DependabotAlertType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#update-a-dependabot-alert"""

        from ..models import (
            BasicError,
            DependabotAlert,
            ReposOwnerRepoDependabotAlertsAlertNumberPatchBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDependabotAlertsAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DependabotAlert,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType,
    ) -> Response[DependabotAlert, DependabotAlertType]: ...

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal["dismissed", "open"],
        dismissed_reason: Missing[
            Literal[
                "fix_started",
                "inaccurate",
                "no_bandwidth",
                "not_used",
                "tolerable_risk",
            ]
        ] = UNSET,
        dismissed_comment: Missing[str] = UNSET,
    ) -> Response[DependabotAlert, DependabotAlertType]: ...

    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoDependabotAlertsAlertNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[DependabotAlert, DependabotAlertType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/alerts#update-a-dependabot-alert"""

        from ..models import (
            BasicError,
            DependabotAlert,
            ReposOwnerRepoDependabotAlertsAlertNumberPatchBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/dependabot/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDependabotAlertsAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DependabotAlert,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_repo_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoDependabotSecretsGetResponse200,
        ReposOwnerRepoDependabotSecretsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#list-repository-secrets"""

        from ..models import ReposOwnerRepoDependabotSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoDependabotSecretsGetResponse200,
        )

    async def async_list_repo_secrets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoDependabotSecretsGetResponse200,
        ReposOwnerRepoDependabotSecretsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#list-repository-secrets"""

        from ..models import ReposOwnerRepoDependabotSecretsGetResponse200

        url = f"/repos/{owner}/{repo}/dependabot/secrets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoDependabotSecretsGetResponse200,
        )

    def get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DependabotPublicKey, DependabotPublicKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#get-a-repository-public-key"""

        from ..models import DependabotPublicKey

        url = f"/repos/{owner}/{repo}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotPublicKey,
        )

    async def async_get_repo_public_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DependabotPublicKey, DependabotPublicKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#get-a-repository-public-key"""

        from ..models import DependabotPublicKey

        url = f"/repos/{owner}/{repo}/dependabot/secrets/public-key"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotPublicKey,
        )

    def get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DependabotSecret, DependabotSecretType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#get-a-repository-secret"""

        from ..models import DependabotSecret

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotSecret,
        )

    async def async_get_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DependabotSecret, DependabotSecretType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#get-a-repository-secret"""

        from ..models import DependabotSecret

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DependabotSecret,
        )

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDependabotSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#create-or-update-a-repository-secret"""

        from ..models import (
            EmptyObject,
            ReposOwnerRepoDependabotSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDependabotSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDependabotSecretsSecretNamePutBodyType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        encrypted_value: Missing[str] = UNSET,
        key_id: Missing[str] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_create_or_update_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoDependabotSecretsSecretNamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#create-or-update-a-repository-secret"""

        from ..models import (
            EmptyObject,
            ReposOwnerRepoDependabotSecretsSecretNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDependabotSecretsSecretNamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
        )

    def delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#delete-a-repository-secret"""

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_repo_secret(
        self,
        owner: str,
        repo: str,
        secret_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/dependabot/secrets#delete-a-repository-secret"""

        url = f"/repos/{owner}/{repo}/dependabot/secrets/{secret_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )
