"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppManifestsCodeConversionsPostResponse201,
        Authorization,
        HookDelivery,
        HookDeliveryItem,
        Installation,
        InstallationRepositoriesGetResponse200,
        InstallationToken,
        Integration,
        IntegrationInstallationRequest,
        MarketplaceListingPlan,
        MarketplacePurchase,
        UserInstallationsGetResponse200,
        UserInstallationsInstallationIdRepositoriesGetResponse200,
        UserMarketplacePurchase,
        WebhookConfig,
    )
    from ..types import (
        AppHookConfigPatchBodyType,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
        AppInstallationsInstallationIdAccessTokensPostBodyType,
        ApplicationsClientIdGrantDeleteBodyType,
        ApplicationsClientIdTokenDeleteBodyType,
        ApplicationsClientIdTokenPatchBodyType,
        ApplicationsClientIdTokenPostBodyType,
        ApplicationsClientIdTokenScopedPostBodyType,
        AppManifestsCodeConversionsPostResponse201Type,
        AppPermissionsType,
        AuthorizationType,
        HookDeliveryItemType,
        HookDeliveryType,
        InstallationRepositoriesGetResponse200Type,
        InstallationTokenType,
        InstallationType,
        IntegrationInstallationRequestType,
        IntegrationType,
        MarketplaceListingPlanType,
        MarketplacePurchaseType,
        UserInstallationsGetResponse200Type,
        UserInstallationsInstallationIdRepositoriesGetResponse200Type,
        UserMarketplacePurchaseType,
        WebhookConfigType,
    )


class AppsClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_authenticated(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Union[Integration, None], Union[IntegrationType, None]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-the-authenticated-app"""

        from typing import Union

        from ..models import Integration

        url = "/app"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[Integration, None],
        )

    async def async_get_authenticated(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Union[Integration, None], Union[IntegrationType, None]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-the-authenticated-app"""

        from typing import Union

        from ..models import Integration

        url = "/app"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[Integration, None],
        )

    def create_from_manifest(
        self,
        code: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AppManifestsCodeConversionsPostResponse201,
        AppManifestsCodeConversionsPostResponse201Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#create-a-github-app-from-a-manifest"""

        from ..models import (
            AppManifestsCodeConversionsPostResponse201,
            BasicError,
            ValidationErrorSimple,
        )

        url = f"/app-manifests/{code}/conversions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppManifestsCodeConversionsPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_create_from_manifest(
        self,
        code: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AppManifestsCodeConversionsPostResponse201,
        AppManifestsCodeConversionsPostResponse201Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#create-a-github-app-from-a-manifest"""

        from ..models import (
            AppManifestsCodeConversionsPostResponse201,
            BasicError,
            ValidationErrorSimple,
        )

        url = f"/app-manifests/{code}/conversions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppManifestsCodeConversionsPostResponse201,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_webhook_config_for_app(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#get-a-webhook-configuration-for-an-app"""

        from ..models import WebhookConfig

        url = "/app/hook/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_app(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#get-a-webhook-configuration-for-an-app"""

        from ..models import WebhookConfig

        url = "/app/hook/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_app(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: AppHookConfigPatchBodyType,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    @overload
    def update_webhook_config_for_app(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    def update_webhook_config_for_app(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[AppHookConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#update-a-webhook-configuration-for-an-app"""

        from ..models import AppHookConfigPatchBody, WebhookConfig

        url = "/app/hook/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(AppHookConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_app(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: AppHookConfigPatchBodyType,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    @overload
    async def async_update_webhook_config_for_app(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    async def async_update_webhook_config_for_app(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[AppHookConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#update-a-webhook-configuration-for-an-app"""

        from ..models import AppHookConfigPatchBody, WebhookConfig

        url = "/app/hook/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(AppHookConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#list-deliveries-for-an-app-webhook"""

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = "/app/hook/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#list-deliveries-for-an-app-webhook"""

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = "/app/hook/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[HookDelivery, HookDeliveryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#get-a-delivery-for-an-app-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/app/hook/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[HookDelivery, HookDeliveryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#get-a-delivery-for-an-app-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/app/hook/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#redeliver-a-delivery-for-an-app-webhook"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/app/hook/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/webhooks#redeliver-a-delivery-for-an-app-webhook"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/app/hook/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def list_installation_requests_for_authenticated_app(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[IntegrationInstallationRequest], list[IntegrationInstallationRequestType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#list-installation-requests-for-the-authenticated-app"""

        from ..models import BasicError, IntegrationInstallationRequest

        url = "/app/installation-requests"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[IntegrationInstallationRequest],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_installation_requests_for_authenticated_app(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[IntegrationInstallationRequest], list[IntegrationInstallationRequestType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#list-installation-requests-for-the-authenticated-app"""

        from ..models import BasicError, IntegrationInstallationRequest

        url = "/app/installation-requests"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[IntegrationInstallationRequest],
            error_models={
                "401": BasicError,
            },
        )

    def list_installations(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        since: Missing[datetime] = UNSET,
        outdated: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Installation], list[InstallationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#list-installations-for-the-authenticated-app"""

        from ..models import Installation

        url = "/app/installations"

        params = {
            "per_page": per_page,
            "page": page,
            "since": since,
            "outdated": outdated,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Installation],
        )

    async def async_list_installations(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        since: Missing[datetime] = UNSET,
        outdated: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Installation], list[InstallationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#list-installations-for-the-authenticated-app"""

        from ..models import Installation

        url = "/app/installations"

        params = {
            "per_page": per_page,
            "page": page,
            "since": since,
            "outdated": outdated,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Installation],
        )

    def get_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Installation, InstallationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-an-installation-for-the-authenticated-app"""

        from ..models import BasicError, Installation

        url = f"/app/installations/{installation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Installation, InstallationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-an-installation-for-the-authenticated-app"""

        from ..models import BasicError, Installation

        url = f"/app/installations/{installation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    def delete_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#delete-an-installation-for-the-authenticated-app"""

        from ..models import BasicError

        url = f"/app/installations/{installation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#delete-an-installation-for-the-authenticated-app"""

        from ..models import BasicError

        url = f"/app/installations/{installation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_installation_access_token(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[AppInstallationsInstallationIdAccessTokensPostBodyType] = UNSET,
    ) -> Response[InstallationToken, InstallationTokenType]: ...

    @overload
    def create_installation_access_token(
        self,
        installation_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        repositories: Missing[list[str]] = UNSET,
        repository_ids: Missing[list[int]] = UNSET,
        permissions: Missing[AppPermissionsType] = UNSET,
    ) -> Response[InstallationToken, InstallationTokenType]: ...

    def create_installation_access_token(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[AppInstallationsInstallationIdAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[InstallationToken, InstallationTokenType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#create-an-installation-access-token-for-an-app"""

        from ..models import (
            AppInstallationsInstallationIdAccessTokensPostBody,
            BasicError,
            InstallationToken,
            ValidationError,
        )

        url = f"/app/installations/{installation_id}/access_tokens"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                AppInstallationsInstallationIdAccessTokensPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=InstallationToken,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_installation_access_token(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[AppInstallationsInstallationIdAccessTokensPostBodyType] = UNSET,
    ) -> Response[InstallationToken, InstallationTokenType]: ...

    @overload
    async def async_create_installation_access_token(
        self,
        installation_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        repositories: Missing[list[str]] = UNSET,
        repository_ids: Missing[list[int]] = UNSET,
        permissions: Missing[AppPermissionsType] = UNSET,
    ) -> Response[InstallationToken, InstallationTokenType]: ...

    async def async_create_installation_access_token(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[AppInstallationsInstallationIdAccessTokensPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[InstallationToken, InstallationTokenType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#create-an-installation-access-token-for-an-app"""

        from ..models import (
            AppInstallationsInstallationIdAccessTokensPostBody,
            BasicError,
            InstallationToken,
            ValidationError,
        )

        url = f"/app/installations/{installation_id}/access_tokens"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                AppInstallationsInstallationIdAccessTokensPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=InstallationToken,
            error_models={
                "403": BasicError,
                "401": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def suspend_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#suspend-an-app-installation"""

        from ..models import BasicError

        url = f"/app/installations/{installation_id}/suspended"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_suspend_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#suspend-an-app-installation"""

        from ..models import BasicError

        url = f"/app/installations/{installation_id}/suspended"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def unsuspend_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#unsuspend-an-app-installation"""

        from ..models import BasicError

        url = f"/app/installations/{installation_id}/suspended"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_unsuspend_installation(
        self,
        installation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#unsuspend-an-app-installation"""

        from ..models import BasicError

        url = f"/app/installations/{installation_id}/suspended"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def delete_authorization(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdGrantDeleteBodyType,
    ) -> Response: ...

    @overload
    def delete_authorization(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
    ) -> Response: ...

    def delete_authorization(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdGrantDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/oauth-applications#delete-an-app-authorization"""

        from ..models import ApplicationsClientIdGrantDeleteBody, ValidationError

        url = f"/applications/{client_id}/grant"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdGrantDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_delete_authorization(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdGrantDeleteBodyType,
    ) -> Response: ...

    @overload
    async def async_delete_authorization(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
    ) -> Response: ...

    async def async_delete_authorization(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdGrantDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/oauth-applications#delete-an-app-authorization"""

        from ..models import ApplicationsClientIdGrantDeleteBody, ValidationError

        url = f"/applications/{client_id}/grant"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdGrantDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def check_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdTokenPostBodyType,
    ) -> Response[Authorization, AuthorizationType]: ...

    @overload
    def check_token(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
    ) -> Response[Authorization, AuthorizationType]: ...

    def check_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Authorization, AuthorizationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/oauth-applications#check-a-token"""

        from ..models import (
            ApplicationsClientIdTokenPostBody,
            Authorization,
            BasicError,
            ValidationError,
        )

        url = f"/applications/{client_id}/token"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdTokenPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_check_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdTokenPostBodyType,
    ) -> Response[Authorization, AuthorizationType]: ...

    @overload
    async def async_check_token(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
    ) -> Response[Authorization, AuthorizationType]: ...

    async def async_check_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Authorization, AuthorizationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/oauth-applications#check-a-token"""

        from ..models import (
            ApplicationsClientIdTokenPostBody,
            Authorization,
            BasicError,
            ValidationError,
        )

        url = f"/applications/{client_id}/token"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdTokenPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def delete_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdTokenDeleteBodyType,
    ) -> Response: ...

    @overload
    def delete_token(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
    ) -> Response: ...

    def delete_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/oauth-applications#delete-an-app-token"""

        from ..models import ApplicationsClientIdTokenDeleteBody, ValidationError

        url = f"/applications/{client_id}/token"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdTokenDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_delete_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdTokenDeleteBodyType,
    ) -> Response: ...

    @overload
    async def async_delete_token(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
    ) -> Response: ...

    async def async_delete_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/oauth-applications#delete-an-app-token"""

        from ..models import ApplicationsClientIdTokenDeleteBody, ValidationError

        url = f"/applications/{client_id}/token"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdTokenDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def reset_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdTokenPatchBodyType,
    ) -> Response[Authorization, AuthorizationType]: ...

    @overload
    def reset_token(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
    ) -> Response[Authorization, AuthorizationType]: ...

    def reset_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Authorization, AuthorizationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/oauth-applications#reset-a-token"""

        from ..models import (
            ApplicationsClientIdTokenPatchBody,
            Authorization,
            ValidationError,
        )

        url = f"/applications/{client_id}/token"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdTokenPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_reset_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdTokenPatchBodyType,
    ) -> Response[Authorization, AuthorizationType]: ...

    @overload
    async def async_reset_token(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
    ) -> Response[Authorization, AuthorizationType]: ...

    async def async_reset_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Authorization, AuthorizationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/oauth-applications#reset-a-token"""

        from ..models import (
            ApplicationsClientIdTokenPatchBody,
            Authorization,
            ValidationError,
        )

        url = f"/applications/{client_id}/token"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdTokenPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def scope_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdTokenScopedPostBodyType,
    ) -> Response[Authorization, AuthorizationType]: ...

    @overload
    def scope_token(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
        target: Missing[str] = UNSET,
        target_id: Missing[int] = UNSET,
        repositories: Missing[list[str]] = UNSET,
        repository_ids: Missing[list[int]] = UNSET,
        permissions: Missing[AppPermissionsType] = UNSET,
    ) -> Response[Authorization, AuthorizationType]: ...

    def scope_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenScopedPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Authorization, AuthorizationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#create-a-scoped-access-token"""

        from ..models import (
            ApplicationsClientIdTokenScopedPostBody,
            Authorization,
            BasicError,
            ValidationError,
        )

        url = f"/applications/{client_id}/token/scoped"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdTokenScopedPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_scope_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ApplicationsClientIdTokenScopedPostBodyType,
    ) -> Response[Authorization, AuthorizationType]: ...

    @overload
    async def async_scope_token(
        self,
        client_id: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        access_token: str,
        target: Missing[str] = UNSET,
        target_id: Missing[int] = UNSET,
        repositories: Missing[list[str]] = UNSET,
        repository_ids: Missing[list[int]] = UNSET,
        permissions: Missing[AppPermissionsType] = UNSET,
    ) -> Response[Authorization, AuthorizationType]: ...

    async def async_scope_token(
        self,
        client_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ApplicationsClientIdTokenScopedPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Authorization, AuthorizationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#create-a-scoped-access-token"""

        from ..models import (
            ApplicationsClientIdTokenScopedPostBody,
            Authorization,
            BasicError,
            ValidationError,
        )

        url = f"/applications/{client_id}/token/scoped"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ApplicationsClientIdTokenScopedPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Authorization,
            error_models={
                "401": BasicError,
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_by_slug(
        self,
        app_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Union[Integration, None], Union[IntegrationType, None]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-an-app"""

        from typing import Union

        from ..models import BasicError, Integration

        url = f"/apps/{app_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[Integration, None],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_by_slug(
        self,
        app_slug: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Union[Integration, None], Union[IntegrationType, None]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-an-app"""

        from typing import Union

        from ..models import BasicError, Integration

        url = f"/apps/{app_slug}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Union[Integration, None],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_repos_accessible_to_installation(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        InstallationRepositoriesGetResponse200,
        InstallationRepositoriesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#list-repositories-accessible-to-the-app-installation"""

        from ..models import BasicError, InstallationRepositoriesGetResponse200

        url = "/installation/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=InstallationRepositoriesGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_repos_accessible_to_installation(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        InstallationRepositoriesGetResponse200,
        InstallationRepositoriesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#list-repositories-accessible-to-the-app-installation"""

        from ..models import BasicError, InstallationRepositoriesGetResponse200

        url = "/installation/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=InstallationRepositoriesGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def revoke_installation_access_token(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#revoke-an-installation-access-token"""

        url = "/installation/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_revoke_installation_access_token(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#revoke-an-installation-access-token"""

        url = "/installation/token"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_subscription_plan_for_account(
        self,
        account_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[MarketplacePurchase, MarketplacePurchaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#get-a-subscription-plan-for-an-account"""

        from ..models import BasicError, MarketplacePurchase

        url = f"/marketplace_listing/accounts/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=MarketplacePurchase,
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_get_subscription_plan_for_account(
        self,
        account_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[MarketplacePurchase, MarketplacePurchaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#get-a-subscription-plan-for-an-account"""

        from ..models import BasicError, MarketplacePurchase

        url = f"/marketplace_listing/accounts/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=MarketplacePurchase,
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    def list_plans(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MarketplaceListingPlan], list[MarketplaceListingPlanType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-plans"""

        from ..models import BasicError, MarketplaceListingPlan

        url = "/marketplace_listing/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MarketplaceListingPlan],
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_plans(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MarketplaceListingPlan], list[MarketplaceListingPlanType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-plans"""

        from ..models import BasicError, MarketplaceListingPlan

        url = "/marketplace_listing/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MarketplaceListingPlan],
            error_models={
                "404": BasicError,
                "401": BasicError,
            },
        )

    def list_accounts_for_plan(
        self,
        plan_id: int,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MarketplacePurchase], list[MarketplacePurchaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-accounts-for-a-plan"""

        from ..models import BasicError, MarketplacePurchase, ValidationError

        url = f"/marketplace_listing/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MarketplacePurchase],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    async def async_list_accounts_for_plan(
        self,
        plan_id: int,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MarketplacePurchase], list[MarketplacePurchaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-accounts-for-a-plan"""

        from ..models import BasicError, MarketplacePurchase, ValidationError

        url = f"/marketplace_listing/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MarketplacePurchase],
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "401": BasicError,
            },
        )

    def get_subscription_plan_for_account_stubbed(
        self,
        account_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[MarketplacePurchase, MarketplacePurchaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#get-a-subscription-plan-for-an-account-stubbed"""

        from ..models import BasicError, MarketplacePurchase

        url = f"/marketplace_listing/stubbed/accounts/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=MarketplacePurchase,
            error_models={
                "401": BasicError,
            },
        )

    async def async_get_subscription_plan_for_account_stubbed(
        self,
        account_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[MarketplacePurchase, MarketplacePurchaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#get-a-subscription-plan-for-an-account-stubbed"""

        from ..models import BasicError, MarketplacePurchase

        url = f"/marketplace_listing/stubbed/accounts/{account_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=MarketplacePurchase,
            error_models={
                "401": BasicError,
            },
        )

    def list_plans_stubbed(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MarketplaceListingPlan], list[MarketplaceListingPlanType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-plans-stubbed"""

        from ..models import BasicError, MarketplaceListingPlan

        url = "/marketplace_listing/stubbed/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MarketplaceListingPlan],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_plans_stubbed(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MarketplaceListingPlan], list[MarketplaceListingPlanType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-plans-stubbed"""

        from ..models import BasicError, MarketplaceListingPlan

        url = "/marketplace_listing/stubbed/plans"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MarketplaceListingPlan],
            error_models={
                "401": BasicError,
            },
        )

    def list_accounts_for_plan_stubbed(
        self,
        plan_id: int,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MarketplacePurchase], list[MarketplacePurchaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-accounts-for-a-plan-stubbed"""

        from ..models import BasicError, MarketplacePurchase

        url = f"/marketplace_listing/stubbed/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_accounts_for_plan_stubbed(
        self,
        plan_id: int,
        *,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MarketplacePurchase], list[MarketplacePurchaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-accounts-for-a-plan-stubbed"""

        from ..models import BasicError, MarketplacePurchase

        url = f"/marketplace_listing/stubbed/plans/{plan_id}/accounts"

        params = {
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    def get_org_installation(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Installation, InstallationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-an-organization-installation-for-the-authenticated-app"""

        from ..models import Installation

        url = f"/orgs/{org}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
        )

    async def async_get_org_installation(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Installation, InstallationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-an-organization-installation-for-the-authenticated-app"""

        from ..models import Installation

        url = f"/orgs/{org}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
        )

    def get_repo_installation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Installation, InstallationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-a-repository-installation-for-the-authenticated-app"""

        from ..models import BasicError, Installation

        url = f"/repos/{owner}/{repo}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_repo_installation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Installation, InstallationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-a-repository-installation-for-the-authenticated-app"""

        from ..models import BasicError, Installation

        url = f"/repos/{owner}/{repo}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
            error_models={
                "404": BasicError,
            },
        )

    def list_installations_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[UserInstallationsGetResponse200, UserInstallationsGetResponse200Type]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#list-app-installations-accessible-to-the-user-access-token"""

        from ..models import BasicError, UserInstallationsGetResponse200

        url = "/user/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserInstallationsGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_installations_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[UserInstallationsGetResponse200, UserInstallationsGetResponse200Type]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#list-app-installations-accessible-to-the-user-access-token"""

        from ..models import BasicError, UserInstallationsGetResponse200

        url = "/user/installations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserInstallationsGetResponse200,
            error_models={
                "403": BasicError,
                "401": BasicError,
            },
        )

    def list_installation_repos_for_authenticated_user(
        self,
        installation_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        UserInstallationsInstallationIdRepositoriesGetResponse200,
        UserInstallationsInstallationIdRepositoriesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#list-repositories-accessible-to-the-user-access-token"""

        from ..models import (
            BasicError,
            UserInstallationsInstallationIdRepositoriesGetResponse200,
        )

        url = f"/user/installations/{installation_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserInstallationsInstallationIdRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_list_installation_repos_for_authenticated_user(
        self,
        installation_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        UserInstallationsInstallationIdRepositoriesGetResponse200,
        UserInstallationsInstallationIdRepositoriesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#list-repositories-accessible-to-the-user-access-token"""

        from ..models import (
            BasicError,
            UserInstallationsInstallationIdRepositoriesGetResponse200,
        )

        url = f"/user/installations/{installation_id}/repositories"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=UserInstallationsInstallationIdRepositoriesGetResponse200,
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    def add_repo_to_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#add-a-repository-to-an-app-installation"""

        from ..models import BasicError

        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_add_repo_to_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#add-a-repository-to-an-app-installation"""

        from ..models import BasicError

        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def remove_repo_from_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#remove-a-repository-from-an-app-installation"""

        from ..models import BasicError

        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_remove_repo_from_installation_for_authenticated_user(
        self,
        installation_id: int,
        repository_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/installations#remove-a-repository-from-an-app-installation"""

        from ..models import BasicError

        url = f"/user/installations/{installation_id}/repositories/{repository_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_subscriptions_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[UserMarketplacePurchase], list[UserMarketplacePurchaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-subscriptions-for-the-authenticated-user"""

        from ..models import BasicError, UserMarketplacePurchase

        url = "/user/marketplace_purchases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_subscriptions_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[UserMarketplacePurchase], list[UserMarketplacePurchaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-subscriptions-for-the-authenticated-user"""

        from ..models import BasicError, UserMarketplacePurchase

        url = "/user/marketplace_purchases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
                "404": BasicError,
            },
        )

    def list_subscriptions_for_authenticated_user_stubbed(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[UserMarketplacePurchase], list[UserMarketplacePurchaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-subscriptions-for-the-authenticated-user-stubbed"""

        from ..models import BasicError, UserMarketplacePurchase

        url = "/user/marketplace_purchases/stubbed"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    async def async_list_subscriptions_for_authenticated_user_stubbed(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[UserMarketplacePurchase], list[UserMarketplacePurchaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/marketplace#list-subscriptions-for-the-authenticated-user-stubbed"""

        from ..models import BasicError, UserMarketplacePurchase

        url = "/user/marketplace_purchases/stubbed"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[UserMarketplacePurchase],
            error_models={
                "401": BasicError,
            },
        )

    def get_user_installation(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Installation, InstallationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-a-user-installation-for-the-authenticated-app"""

        from ..models import Installation

        url = f"/users/{username}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
        )

    async def async_get_user_installation(
        self,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Installation, InstallationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/apps/apps#get-a-user-installation-for-the-authenticated-app"""

        from ..models import Installation

        url = f"/users/{username}/installation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Installation,
        )
