"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import Missing
    from githubkit.utils import UNSET

    from ..models import (
        CodeScanningAlert,
        CodeScanningAlertInstance,
        CodeScanningAlertItems,
        CodeScanningAnalysis,
        CodeScanningAnalysisDeletion,
        CodeScanningAutofix,
        CodeScanningAutofixCommitsResponse,
        CodeScanningCodeqlDatabase,
        CodeScanningDefaultSetup,
        CodeScanningOrganizationAlertItems,
        CodeScanningSarifsReceipt,
        CodeScanningSarifsStatus,
        CodeScanningVariantAnalysis,
        CodeScanningVariantAnalysisRepoTask,
        EmptyObject,
    )
    from ..types import (
        CodeScanningAlertInstanceType,
        CodeScanningAlertItemsType,
        CodeScanningAlertType,
        CodeScanningAnalysisDeletionType,
        CodeScanningAnalysisType,
        CodeScanningAutofixCommitsResponseType,
        CodeScanningAutofixCommitsType,
        CodeScanningAutofixType,
        CodeScanningCodeqlDatabaseType,
        CodeScanningDefaultSetupType,
        CodeScanningDefaultSetupUpdateType,
        CodeScanningOrganizationAlertItemsType,
        CodeScanningSarifsReceiptType,
        CodeScanningSarifsStatusType,
        CodeScanningVariantAnalysisRepoTaskType,
        CodeScanningVariantAnalysisType,
        EmptyObjectType,
        ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBodyType,
        ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof0Type,
        ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof1Type,
        ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof2Type,
        ReposOwnerRepoCodeScanningSarifsPostBodyType,
    )


class CodeScanningClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_alerts_for_enterprise(
        self,
        enterprise: str,
        *,
        tool_name: Missing[str] = UNSET,
        tool_guid: Missing[Union[str, None]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        state: Missing[Literal["open", "closed", "dismissed", "fixed"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeScanningOrganizationAlertItems],
        list[CodeScanningOrganizationAlertItemsType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-code-scanning-alerts-for-an-enterprise"""

        from ..models import (
            BasicError,
            CodeScanningOrganizationAlertItems,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/code-scanning/alerts"

        params = {
            "tool_name": tool_name,
            "tool_guid": tool_guid,
            "before": before,
            "after": after,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "state": state,
            "sort": sort,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningOrganizationAlertItems],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_alerts_for_enterprise(
        self,
        enterprise: str,
        *,
        tool_name: Missing[str] = UNSET,
        tool_guid: Missing[Union[str, None]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        state: Missing[Literal["open", "closed", "dismissed", "fixed"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeScanningOrganizationAlertItems],
        list[CodeScanningOrganizationAlertItemsType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-code-scanning-alerts-for-an-enterprise"""

        from ..models import (
            BasicError,
            CodeScanningOrganizationAlertItems,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/enterprises/{enterprise}/code-scanning/alerts"

        params = {
            "tool_name": tool_name,
            "tool_guid": tool_guid,
            "before": before,
            "after": after,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "state": state,
            "sort": sort,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningOrganizationAlertItems],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_alerts_for_org(
        self,
        org: str,
        *,
        tool_name: Missing[str] = UNSET,
        tool_guid: Missing[Union[str, None]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        state: Missing[Literal["open", "closed", "dismissed", "fixed"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        severity: Missing[
            Literal["critical", "high", "medium", "low", "warning", "note", "error"]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeScanningOrganizationAlertItems],
        list[CodeScanningOrganizationAlertItemsType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-code-scanning-alerts-for-an-organization"""

        from ..models import (
            BasicError,
            CodeScanningOrganizationAlertItems,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/orgs/{org}/code-scanning/alerts"

        params = {
            "tool_name": tool_name,
            "tool_guid": tool_guid,
            "before": before,
            "after": after,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "state": state,
            "sort": sort,
            "severity": severity,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningOrganizationAlertItems],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_alerts_for_org(
        self,
        org: str,
        *,
        tool_name: Missing[str] = UNSET,
        tool_guid: Missing[Union[str, None]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        state: Missing[Literal["open", "closed", "dismissed", "fixed"]] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        severity: Missing[
            Literal["critical", "high", "medium", "low", "warning", "note", "error"]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeScanningOrganizationAlertItems],
        list[CodeScanningOrganizationAlertItemsType],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-code-scanning-alerts-for-an-organization"""

        from ..models import (
            BasicError,
            CodeScanningOrganizationAlertItems,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/orgs/{org}/code-scanning/alerts"

        params = {
            "tool_name": tool_name,
            "tool_guid": tool_guid,
            "before": before,
            "after": after,
            "page": page,
            "per_page": per_page,
            "direction": direction,
            "state": state,
            "sort": sort,
            "severity": severity,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningOrganizationAlertItems],
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        tool_name: Missing[str] = UNSET,
        tool_guid: Missing[Union[str, None]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        pr: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        state: Missing[Literal["open", "closed", "dismissed", "fixed"]] = UNSET,
        severity: Missing[
            Literal["critical", "high", "medium", "low", "warning", "note", "error"]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeScanningAlertItems], list[CodeScanningAlertItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-code-scanning-alerts-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningAlertItems,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts"

        params = {
            "tool_name": tool_name,
            "tool_guid": tool_guid,
            "page": page,
            "per_page": per_page,
            "ref": ref,
            "pr": pr,
            "direction": direction,
            "before": before,
            "after": after,
            "sort": sort,
            "state": state,
            "severity": severity,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningAlertItems],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_alerts_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        tool_name: Missing[str] = UNSET,
        tool_guid: Missing[Union[str, None]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        pr: Missing[int] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        sort: Missing[Literal["created", "updated"]] = UNSET,
        state: Missing[Literal["open", "closed", "dismissed", "fixed"]] = UNSET,
        severity: Missing[
            Literal["critical", "high", "medium", "low", "warning", "note", "error"]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeScanningAlertItems], list[CodeScanningAlertItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-code-scanning-alerts-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningAlertItems,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts"

        params = {
            "tool_name": tool_name,
            "tool_guid": tool_guid,
            "page": page,
            "per_page": per_page,
            "ref": ref,
            "pr": pr,
            "direction": direction,
            "before": before,
            "after": after,
            "sort": sort,
            "state": state,
            "severity": severity,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningAlertItems],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAlert, CodeScanningAlertType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAlert,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAlert, CodeScanningAlertType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAlert,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBodyType,
    ) -> Response[CodeScanningAlert, CodeScanningAlertType]: ...

    @overload
    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal["open", "dismissed"],
        dismissed_reason: Missing[
            Union[None, Literal["false positive", "won't fix", "used in tests"]]
        ] = UNSET,
        dismissed_comment: Missing[Union[str, None]] = UNSET,
    ) -> Response[CodeScanningAlert, CodeScanningAlertType]: ...

    def update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CodeScanningAlert, CodeScanningAlertType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#update-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAlert,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBody,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeScanningAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBodyType,
    ) -> Response[CodeScanningAlert, CodeScanningAlertType]: ...

    @overload
    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal["open", "dismissed"],
        dismissed_reason: Missing[
            Union[None, Literal["false positive", "won't fix", "used in tests"]]
        ] = UNSET,
        dismissed_comment: Missing[Union[str, None]] = UNSET,
    ) -> Response[CodeScanningAlert, CodeScanningAlertType]: ...

    async def async_update_alert(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CodeScanningAlert, CodeScanningAlertType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#update-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAlert,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBody,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCodeScanningAlertsAlertNumberPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeScanningAlert,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAutofix, CodeScanningAutofixType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-the-status-of-an-autofix-for-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAutofix,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningAutofix,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAutofix, CodeScanningAutofixType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-the-status-of-an-autofix-for-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAutofix,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningAutofix,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def create_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAutofix, CodeScanningAutofixType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#create-an-autofix-for-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAutofix,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningAutofix,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_create_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAutofix, CodeScanningAutofixType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#create-an-autofix-for-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAutofix,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningAutofix,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def commit_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[CodeScanningAutofixCommitsType, None]] = UNSET,
    ) -> Response[
        CodeScanningAutofixCommitsResponse, CodeScanningAutofixCommitsResponseType
    ]: ...

    @overload
    def commit_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        target_ref: Missing[str] = UNSET,
        message: Missing[str] = UNSET,
    ) -> Response[
        CodeScanningAutofixCommitsResponse, CodeScanningAutofixCommitsResponseType
    ]: ...

    def commit_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[CodeScanningAutofixCommitsType, None]] = UNSET,
        **kwargs,
    ) -> Response[
        CodeScanningAutofixCommitsResponse, CodeScanningAutofixCommitsResponseType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#commit-an-autofix-for-a-code-scanning-alert"""

        from typing import Union

        from ..models import (
            BasicError,
            CodeScanningAutofixCommits,
            CodeScanningAutofixCommitsResponse,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = (
            f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[CodeScanningAutofixCommits, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeScanningAutofixCommitsResponse,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_commit_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[CodeScanningAutofixCommitsType, None]] = UNSET,
    ) -> Response[
        CodeScanningAutofixCommitsResponse, CodeScanningAutofixCommitsResponseType
    ]: ...

    @overload
    async def async_commit_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        target_ref: Missing[str] = UNSET,
        message: Missing[str] = UNSET,
    ) -> Response[
        CodeScanningAutofixCommitsResponse, CodeScanningAutofixCommitsResponseType
    ]: ...

    async def async_commit_autofix(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[CodeScanningAutofixCommitsType, None]] = UNSET,
        **kwargs,
    ) -> Response[
        CodeScanningAutofixCommitsResponse, CodeScanningAutofixCommitsResponseType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#commit-an-autofix-for-a-code-scanning-alert"""

        from typing import Union

        from ..models import (
            BasicError,
            CodeScanningAutofixCommits,
            CodeScanningAutofixCommitsResponse,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = (
            f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/autofix/commits"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[CodeScanningAutofixCommits, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeScanningAutofixCommitsResponse,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_alert_instances(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        pr: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeScanningAlertInstance], list[CodeScanningAlertInstanceType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-instances-of-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAlertInstance,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances"

        params = {
            "page": page,
            "per_page": per_page,
            "ref": ref,
            "pr": pr,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningAlertInstance],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_alert_instances(
        self,
        owner: str,
        repo: str,
        alert_number: int,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        pr: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeScanningAlertInstance], list[CodeScanningAlertInstanceType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-instances-of-a-code-scanning-alert"""

        from ..models import (
            BasicError,
            CodeScanningAlertInstance,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances"

        params = {
            "page": page,
            "per_page": per_page,
            "ref": ref,
            "pr": pr,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningAlertInstance],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_recent_analyses(
        self,
        owner: str,
        repo: str,
        *,
        tool_name: Missing[str] = UNSET,
        tool_guid: Missing[Union[str, None]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        pr: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        sarif_id: Missing[str] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[Literal["created"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeScanningAnalysis], list[CodeScanningAnalysisType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-code-scanning-analyses-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningAnalysis,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/analyses"

        params = {
            "tool_name": tool_name,
            "tool_guid": tool_guid,
            "page": page,
            "per_page": per_page,
            "pr": pr,
            "ref": ref,
            "sarif_id": sarif_id,
            "direction": direction,
            "sort": sort,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningAnalysis],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_recent_analyses(
        self,
        owner: str,
        repo: str,
        *,
        tool_name: Missing[str] = UNSET,
        tool_guid: Missing[Union[str, None]] = UNSET,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        pr: Missing[int] = UNSET,
        ref: Missing[str] = UNSET,
        sarif_id: Missing[str] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        sort: Missing[Literal["created"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CodeScanningAnalysis], list[CodeScanningAnalysisType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-code-scanning-analyses-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningAnalysis,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/analyses"

        params = {
            "tool_name": tool_name,
            "tool_guid": tool_guid,
            "page": page,
            "per_page": per_page,
            "pr": pr,
            "ref": ref,
            "sarif_id": sarif_id,
            "direction": direction,
            "sort": sort,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CodeScanningAnalysis],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_analysis(
        self,
        owner: str,
        repo: str,
        analysis_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAnalysis, CodeScanningAnalysisType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-a-code-scanning-analysis-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningAnalysis,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningAnalysis,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_analysis(
        self,
        owner: str,
        repo: str,
        analysis_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAnalysis, CodeScanningAnalysisType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-a-code-scanning-analysis-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningAnalysis,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningAnalysis,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def delete_analysis(
        self,
        owner: str,
        repo: str,
        analysis_id: int,
        *,
        confirm_delete: Missing[Union[str, None]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAnalysisDeletion, CodeScanningAnalysisDeletionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#delete-a-code-scanning-analysis-from-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningAnalysisDeletion,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}"

        params = {
            "confirm_delete": confirm_delete,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CodeScanningAnalysisDeletion,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_delete_analysis(
        self,
        owner: str,
        repo: str,
        analysis_id: int,
        *,
        confirm_delete: Missing[Union[str, None]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningAnalysisDeletion, CodeScanningAnalysisDeletionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#delete-a-code-scanning-analysis-from-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningAnalysisDeletion,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}"

        params = {
            "confirm_delete": confirm_delete,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CodeScanningAnalysisDeletion,
            error_models={
                "400": BasicError,
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_codeql_databases(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeScanningCodeqlDatabase], list[CodeScanningCodeqlDatabaseType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-codeql-databases-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningCodeqlDatabase,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/databases"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CodeScanningCodeqlDatabase],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_list_codeql_databases(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[CodeScanningCodeqlDatabase], list[CodeScanningCodeqlDatabaseType]
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#list-codeql-databases-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningCodeqlDatabase,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/databases"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CodeScanningCodeqlDatabase],
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_codeql_database(
        self,
        owner: str,
        repo: str,
        language: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningCodeqlDatabase, CodeScanningCodeqlDatabaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-a-codeql-database-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningCodeqlDatabase,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningCodeqlDatabase,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_codeql_database(
        self,
        owner: str,
        repo: str,
        language: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningCodeqlDatabase, CodeScanningCodeqlDatabaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-a-codeql-database-for-a-repository"""

        from ..models import (
            BasicError,
            CodeScanningCodeqlDatabase,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningCodeqlDatabase,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def delete_codeql_database(
        self,
        owner: str,
        repo: str,
        language: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#delete-a-codeql-database"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_delete_codeql_database(
        self,
        owner: str,
        repo: str,
        language: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#delete-a-codeql-database"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/databases/{language}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Union[
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof0Type,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof1Type,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof2Type,
        ],
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]: ...

    @overload
    def create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        language: Literal[
            "cpp", "csharp", "go", "java", "javascript", "python", "ruby", "swift"
        ],
        query_pack: str,
        repositories: list[str],
        repository_lists: Missing[list[str]] = UNSET,
        repository_owners: Missing[list[str]] = UNSET,
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]: ...

    @overload
    def create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        language: Literal[
            "cpp", "csharp", "go", "java", "javascript", "python", "ruby", "swift"
        ],
        query_pack: str,
        repositories: Missing[list[str]] = UNSET,
        repository_lists: list[str],
        repository_owners: Missing[list[str]] = UNSET,
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]: ...

    @overload
    def create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        language: Literal[
            "cpp", "csharp", "go", "java", "javascript", "python", "ruby", "swift"
        ],
        query_pack: str,
        repositories: Missing[list[str]] = UNSET,
        repository_lists: Missing[list[str]] = UNSET,
        repository_owners: list[str],
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]: ...

    def create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof0Type,
                ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof1Type,
                ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof2Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#create-a-codeql-variant-analysis"""

        from typing import Union

        from ..models import (
            BasicError,
            CodeScanningVariantAnalysis,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof0,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof1,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof2,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof0,
                    ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof1,
                    ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof2,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeScanningVariantAnalysis,
            error_models={
                "404": BasicError,
                "422": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Union[
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof0Type,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof1Type,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof2Type,
        ],
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]: ...

    @overload
    async def async_create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        language: Literal[
            "cpp", "csharp", "go", "java", "javascript", "python", "ruby", "swift"
        ],
        query_pack: str,
        repositories: list[str],
        repository_lists: Missing[list[str]] = UNSET,
        repository_owners: Missing[list[str]] = UNSET,
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]: ...

    @overload
    async def async_create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        language: Literal[
            "cpp", "csharp", "go", "java", "javascript", "python", "ruby", "swift"
        ],
        query_pack: str,
        repositories: Missing[list[str]] = UNSET,
        repository_lists: list[str],
        repository_owners: Missing[list[str]] = UNSET,
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]: ...

    @overload
    async def async_create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        language: Literal[
            "cpp", "csharp", "go", "java", "javascript", "python", "ruby", "swift"
        ],
        query_pack: str,
        repositories: Missing[list[str]] = UNSET,
        repository_lists: Missing[list[str]] = UNSET,
        repository_owners: list[str],
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]: ...

    async def async_create_variant_analysis(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof0Type,
                ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof1Type,
                ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof2Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#create-a-codeql-variant-analysis"""

        from typing import Union

        from ..models import (
            BasicError,
            CodeScanningVariantAnalysis,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof0,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof1,
            ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof2,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof0,
                    ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof1,
                    ReposOwnerRepoCodeScanningCodeqlVariantAnalysesPostBodyOneof2,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeScanningVariantAnalysis,
            error_models={
                "404": BasicError,
                "422": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_variant_analysis(
        self,
        owner: str,
        repo: str,
        codeql_variant_analysis_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-the-summary-of-a-codeql-variant-analysis"""

        from ..models import (
            BasicError,
            CodeScanningVariantAnalysis,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningVariantAnalysis,
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_variant_analysis(
        self,
        owner: str,
        repo: str,
        codeql_variant_analysis_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningVariantAnalysis, CodeScanningVariantAnalysisType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-the-summary-of-a-codeql-variant-analysis"""

        from ..models import (
            BasicError,
            CodeScanningVariantAnalysis,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningVariantAnalysis,
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_variant_analysis_repo_task(
        self,
        owner: str,
        repo: str,
        codeql_variant_analysis_id: int,
        repo_owner: str,
        repo_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        CodeScanningVariantAnalysisRepoTask, CodeScanningVariantAnalysisRepoTaskType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-the-analysis-status-of-a-repository-in-a-codeql-variant-analysis"""

        from ..models import (
            BasicError,
            CodeScanningVariantAnalysisRepoTask,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningVariantAnalysisRepoTask,
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_variant_analysis_repo_task(
        self,
        owner: str,
        repo: str,
        codeql_variant_analysis_id: int,
        repo_owner: str,
        repo_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        CodeScanningVariantAnalysisRepoTask, CodeScanningVariantAnalysisRepoTaskType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-the-analysis-status-of-a-repository-in-a-codeql-variant-analysis"""

        from ..models import (
            BasicError,
            CodeScanningVariantAnalysisRepoTask,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/codeql/variant-analyses/{codeql_variant_analysis_id}/repos/{repo_owner}/{repo_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningVariantAnalysisRepoTask,
            error_models={
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_default_setup(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningDefaultSetup, CodeScanningDefaultSetupType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-a-code-scanning-default-setup-configuration"""

        from ..models import (
            BasicError,
            CodeScanningDefaultSetup,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/default-setup"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningDefaultSetup,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_default_setup(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningDefaultSetup, CodeScanningDefaultSetupType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-a-code-scanning-default-setup-configuration"""

        from ..models import (
            BasicError,
            CodeScanningDefaultSetup,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/default-setup"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningDefaultSetup,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def update_default_setup(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: CodeScanningDefaultSetupUpdateType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    def update_default_setup(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Missing[Literal["configured", "not-configured"]] = UNSET,
        runner_type: Missing[Literal["standard", "labeled"]] = UNSET,
        runner_label: Missing[Union[str, None]] = UNSET,
        query_suite: Missing[Literal["default", "extended"]] = UNSET,
        languages: Missing[
            list[
                Literal[
                    "actions",
                    "c-cpp",
                    "csharp",
                    "go",
                    "java-kotlin",
                    "javascript-typescript",
                    "python",
                    "ruby",
                    "swift",
                ]
            ]
        ] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    def update_default_setup(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[CodeScanningDefaultSetupUpdateType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#update-a-code-scanning-default-setup-configuration"""

        from ..models import (
            BasicError,
            CodeScanningDefaultSetupUpdate,
            EmptyObject,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/default-setup"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CodeScanningDefaultSetupUpdate, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_update_default_setup(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: CodeScanningDefaultSetupUpdateType,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    @overload
    async def async_update_default_setup(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Missing[Literal["configured", "not-configured"]] = UNSET,
        runner_type: Missing[Literal["standard", "labeled"]] = UNSET,
        runner_label: Missing[Union[str, None]] = UNSET,
        query_suite: Missing[Literal["default", "extended"]] = UNSET,
        languages: Missing[
            list[
                Literal[
                    "actions",
                    "c-cpp",
                    "csharp",
                    "go",
                    "java-kotlin",
                    "javascript-typescript",
                    "python",
                    "ruby",
                    "swift",
                ]
            ]
        ] = UNSET,
    ) -> Response[EmptyObject, EmptyObjectType]: ...

    async def async_update_default_setup(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[CodeScanningDefaultSetupUpdateType] = UNSET,
        **kwargs,
    ) -> Response[EmptyObject, EmptyObjectType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#update-a-code-scanning-default-setup-configuration"""

        from ..models import (
            BasicError,
            CodeScanningDefaultSetupUpdate,
            EmptyObject,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/default-setup"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(CodeScanningDefaultSetupUpdate, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=EmptyObject,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    def upload_sarif(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoCodeScanningSarifsPostBodyType,
    ) -> Response[CodeScanningSarifsReceipt, CodeScanningSarifsReceiptType]: ...

    @overload
    def upload_sarif(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        commit_sha: str,
        ref: str,
        sarif: str,
        checkout_uri: Missing[str] = UNSET,
        started_at: Missing[datetime] = UNSET,
        tool_name: Missing[str] = UNSET,
        validate_: Missing[bool] = UNSET,
    ) -> Response[CodeScanningSarifsReceipt, CodeScanningSarifsReceiptType]: ...

    def upload_sarif(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCodeScanningSarifsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CodeScanningSarifsReceipt, CodeScanningSarifsReceiptType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#upload-an-analysis-as-sarif-data"""

        from ..models import (
            BasicError,
            CodeScanningSarifsReceipt,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoCodeScanningSarifsPostBody,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/sarifs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoCodeScanningSarifsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeScanningSarifsReceipt,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_upload_sarif(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoCodeScanningSarifsPostBodyType,
    ) -> Response[CodeScanningSarifsReceipt, CodeScanningSarifsReceiptType]: ...

    @overload
    async def async_upload_sarif(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        commit_sha: str,
        ref: str,
        sarif: str,
        checkout_uri: Missing[str] = UNSET,
        started_at: Missing[datetime] = UNSET,
        tool_name: Missing[str] = UNSET,
        validate_: Missing[bool] = UNSET,
    ) -> Response[CodeScanningSarifsReceipt, CodeScanningSarifsReceiptType]: ...

    async def async_upload_sarif(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCodeScanningSarifsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CodeScanningSarifsReceipt, CodeScanningSarifsReceiptType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#upload-an-analysis-as-sarif-data"""

        from ..models import (
            BasicError,
            CodeScanningSarifsReceipt,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ReposOwnerRepoCodeScanningSarifsPostBody,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/sarifs"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoCodeScanningSarifsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CodeScanningSarifsReceipt,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_sarif(
        self,
        owner: str,
        repo: str,
        sarif_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningSarifsStatus, CodeScanningSarifsStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-information-about-a-sarif-upload"""

        from ..models import (
            BasicError,
            CodeScanningSarifsStatus,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningSarifsStatus,
            error_models={
                "403": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_get_sarif(
        self,
        owner: str,
        repo: str,
        sarif_id: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeScanningSarifsStatus, CodeScanningSarifsStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/code-scanning/code-scanning#get-information-about-a-sarif-upload"""

        from ..models import (
            BasicError,
            CodeScanningSarifsStatus,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CodeScanningSarifsStatus,
            error_models={
                "403": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )
