"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import FileTypes, Missing
    from githubkit.utils import UNSET

    from ..models import (
        Activity,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        Autolink,
        BranchProtection,
        BranchRestrictionPolicy,
        BranchShort,
        BranchWithProtection,
        CheckAutomatedSecurityFixes,
        CloneTraffic,
        CodeownersErrors,
        Collaborator,
        CombinedCommitStatus,
        Commit,
        CommitActivity,
        CommitComment,
        CommitComparison,
        CommunityProfile,
        ContentDirectoryItems,
        ContentFile,
        ContentSubmodule,
        ContentSymlink,
        ContentTraffic,
        Contributor,
        ContributorActivity,
        CustomPropertyValue,
        DeployKey,
        Deployment,
        DeploymentBranchPolicy,
        DeploymentProtectionRule,
        DeploymentStatus,
        Environment,
        FileCommit,
        FullRepository,
        Hook,
        HookDelivery,
        HookDeliveryItem,
        Integration,
        Language,
        MergedUpstream,
        MinimalRepository,
        Page,
        PageBuild,
        PageBuildStatus,
        PageDeployment,
        PagesDeploymentStatus,
        PagesHealthCheck,
        ParticipationStats,
        ProtectedBranch,
        ProtectedBranchAdminEnforced,
        ProtectedBranchPullRequestReview,
        PullRequestSimple,
        PushRuleBypassRequest,
        ReferrerTraffic,
        Release,
        ReleaseAsset,
        ReleaseNotesContent,
        Repository,
        RepositoryCollaboratorPermission,
        RepositoryInvitation,
        RepositoryRuleDetailedOneof0,
        RepositoryRuleDetailedOneof1,
        RepositoryRuleDetailedOneof2,
        RepositoryRuleDetailedOneof3,
        RepositoryRuleDetailedOneof4,
        RepositoryRuleDetailedOneof5,
        RepositoryRuleDetailedOneof6,
        RepositoryRuleDetailedOneof7,
        RepositoryRuleDetailedOneof8,
        RepositoryRuleDetailedOneof9,
        RepositoryRuleDetailedOneof10,
        RepositoryRuleDetailedOneof11,
        RepositoryRuleDetailedOneof12,
        RepositoryRuleDetailedOneof13,
        RepositoryRuleDetailedOneof14,
        RepositoryRuleDetailedOneof15,
        RepositoryRuleDetailedOneof16,
        RepositoryRuleset,
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        ReposOwnerRepoEnvironmentsGetResponse200,
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        RulesetVersion,
        RulesetVersionWithState,
        RuleSuite,
        RuleSuitesItems,
        ShortBranch,
        SimpleUser,
        Status,
        StatusCheckPolicy,
        Tag,
        TagProtection,
        Team,
        Topic,
        ViewTraffic,
        WebhookConfig,
    )
    from ..types import (
        ActivityType,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
        AutolinkType,
        BranchProtectionType,
        BranchRestrictionPolicyType,
        BranchShortType,
        BranchWithProtectionType,
        CheckAutomatedSecurityFixesType,
        CloneTrafficType,
        CodeownersErrorsType,
        CollaboratorType,
        CombinedCommitStatusType,
        CommitActivityType,
        CommitCommentType,
        CommitComparisonType,
        CommitType,
        CommunityProfileType,
        ContentDirectoryItemsType,
        ContentFileType,
        ContentSubmoduleType,
        ContentSymlinkType,
        ContentTrafficType,
        ContributorActivityType,
        ContributorType,
        CustomPropertyValueType,
        DeployKeyType,
        DeploymentBranchPolicyNamePatternType,
        DeploymentBranchPolicyNamePatternWithTypeType,
        DeploymentBranchPolicySettingsType,
        DeploymentBranchPolicyType,
        DeploymentProtectionRuleType,
        DeploymentStatusType,
        DeploymentType,
        EnterpriseRulesetConditionsOneof0Type,
        EnterpriseRulesetConditionsOneof1Type,
        EnterpriseRulesetConditionsOneof2Type,
        EnterpriseRulesetConditionsOneof3Type,
        EnterprisesEnterpriseRulesetsPostBodyType,
        EnterprisesEnterpriseRulesetsRulesetIdPutBodyType,
        EnvironmentType,
        FileCommitType,
        FullRepositoryType,
        HookDeliveryItemType,
        HookDeliveryType,
        HookType,
        IntegrationType,
        LanguageType,
        MergedUpstreamType,
        MinimalRepositoryType,
        OrgRulesetConditionsOneof0Type,
        OrgRulesetConditionsOneof1Type,
        OrgRulesetConditionsOneof2Type,
        OrgsOrgReposPostBodyPropCustomPropertiesType,
        OrgsOrgReposPostBodyType,
        OrgsOrgRulesetsPostBodyType,
        OrgsOrgRulesetsRulesetIdPutBodyType,
        PageBuildStatusType,
        PageBuildType,
        PageDeploymentType,
        PagesDeploymentStatusType,
        PagesHealthCheckType,
        PageType,
        ParticipationStatsType,
        ProtectedBranchAdminEnforcedType,
        ProtectedBranchPullRequestReviewType,
        ProtectedBranchType,
        PullRequestSimpleType,
        PushRuleBypassRequestType,
        ReferrerTrafficType,
        ReleaseAssetType,
        ReleaseNotesContentType,
        ReleaseType,
        RepositoryCollaboratorPermissionType,
        RepositoryInvitationType,
        RepositoryRuleBranchNamePatternType,
        RepositoryRuleCodeScanningType,
        RepositoryRuleCommitAuthorEmailPatternType,
        RepositoryRuleCommitMessagePatternType,
        RepositoryRuleCommitterEmailPatternType,
        RepositoryRuleCreationType,
        RepositoryRuleDeletionType,
        RepositoryRuleDetailedOneof0Type,
        RepositoryRuleDetailedOneof1Type,
        RepositoryRuleDetailedOneof2Type,
        RepositoryRuleDetailedOneof3Type,
        RepositoryRuleDetailedOneof4Type,
        RepositoryRuleDetailedOneof5Type,
        RepositoryRuleDetailedOneof6Type,
        RepositoryRuleDetailedOneof7Type,
        RepositoryRuleDetailedOneof8Type,
        RepositoryRuleDetailedOneof9Type,
        RepositoryRuleDetailedOneof10Type,
        RepositoryRuleDetailedOneof11Type,
        RepositoryRuleDetailedOneof12Type,
        RepositoryRuleDetailedOneof13Type,
        RepositoryRuleDetailedOneof14Type,
        RepositoryRuleDetailedOneof15Type,
        RepositoryRuleDetailedOneof16Type,
        RepositoryRuleMergeQueueType,
        RepositoryRuleNonFastForwardType,
        RepositoryRuleOneof15Type,
        RepositoryRuleOneof16Type,
        RepositoryRuleOneof17Type,
        RepositoryRuleOneof18Type,
        RepositoryRulePullRequestType,
        RepositoryRuleRequiredDeploymentsType,
        RepositoryRuleRequiredLinearHistoryType,
        RepositoryRuleRequiredSignaturesType,
        RepositoryRuleRequiredStatusChecksType,
        RepositoryRulesetBypassActorType,
        RepositoryRulesetConditionsType,
        RepositoryRulesetType,
        RepositoryRuleTagNamePatternType,
        RepositoryRuleUpdateType,
        RepositoryRuleWorkflowsType,
        RepositoryType,
        ReposOwnerRepoAttestationsPostBodyPropBundleType,
        ReposOwnerRepoAttestationsPostBodyType,
        ReposOwnerRepoAttestationsPostResponse201Type,
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200Type,
        ReposOwnerRepoAutolinksPostBodyType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyType,
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType,
        ReposOwnerRepoBranchesBranchRenamePostBodyType,
        ReposOwnerRepoCollaboratorsUsernamePutBodyType,
        ReposOwnerRepoCommentsCommentIdPatchBodyType,
        ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
        ReposOwnerRepoContentsPathDeleteBodyPropAuthorType,
        ReposOwnerRepoContentsPathDeleteBodyPropCommitterType,
        ReposOwnerRepoContentsPathDeleteBodyType,
        ReposOwnerRepoContentsPathPutBodyPropAuthorType,
        ReposOwnerRepoContentsPathPutBodyPropCommitterType,
        ReposOwnerRepoContentsPathPutBodyType,
        ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
        ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type,
        ReposOwnerRepoDeploymentsPostBodyType,
        ReposOwnerRepoDispatchesPostBodyPropClientPayloadType,
        ReposOwnerRepoDispatchesPostBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200Type,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200Type,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200Type,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType,
        ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType,
        ReposOwnerRepoEnvironmentsGetResponse200Type,
        ReposOwnerRepoForksPostBodyType,
        ReposOwnerRepoHooksHookIdConfigPatchBodyType,
        ReposOwnerRepoHooksHookIdPatchBodyType,
        ReposOwnerRepoHooksPostBodyPropConfigType,
        ReposOwnerRepoHooksPostBodyType,
        ReposOwnerRepoInvitationsInvitationIdPatchBodyType,
        ReposOwnerRepoKeysPostBodyType,
        ReposOwnerRepoMergesPostBodyType,
        ReposOwnerRepoMergeUpstreamPostBodyType,
        ReposOwnerRepoPagesDeploymentsPostBodyType,
        ReposOwnerRepoPagesPostBodyAnyof0Type,
        ReposOwnerRepoPagesPostBodyAnyof1Type,
        ReposOwnerRepoPagesPostBodyPropSourceType,
        ReposOwnerRepoPagesPutBodyAnyof0Type,
        ReposOwnerRepoPagesPutBodyAnyof1Type,
        ReposOwnerRepoPagesPutBodyAnyof2Type,
        ReposOwnerRepoPagesPutBodyAnyof3Type,
        ReposOwnerRepoPagesPutBodyAnyof4Type,
        ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType,
        ReposOwnerRepoPatchBodyType,
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200Type,
        ReposOwnerRepoPropertiesValuesPatchBodyType,
        ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType,
        ReposOwnerRepoReleasesGenerateNotesPostBodyType,
        ReposOwnerRepoReleasesPostBodyType,
        ReposOwnerRepoReleasesReleaseIdPatchBodyType,
        ReposOwnerRepoRulesetsPostBodyType,
        ReposOwnerRepoRulesetsRulesetIdPutBodyType,
        ReposOwnerRepoStatusesShaPostBodyType,
        ReposOwnerRepoTagsProtectionPostBodyType,
        ReposOwnerRepoTopicsPutBodyType,
        ReposOwnerRepoTransferPostBodyType,
        ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
        RulesetVersionType,
        RulesetVersionWithStateType,
        RuleSuitesItemsType,
        RuleSuiteType,
        ShortBranchType,
        SimpleUserType,
        StatusCheckPolicyType,
        StatusType,
        TagProtectionType,
        TagType,
        TeamType,
        TopicType,
        UserReposPostBodyType,
        ViewTrafficType,
        WebhookConfigType,
    )


class ReposClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    @overload
    def create_enterprise_ruleset(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def create_enterprise_ruleset(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                EnterpriseRulesetConditionsOneof0Type,
                EnterpriseRulesetConditionsOneof1Type,
                EnterpriseRulesetConditionsOneof2Type,
                EnterpriseRulesetConditionsOneof3Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def create_enterprise_ruleset(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[EnterprisesEnterpriseRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#create-an-enterprise-repository-ruleset"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseRulesetsPostBody,
            RepositoryRuleset,
        )

        url = f"/enterprises/{enterprise}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(EnterprisesEnterpriseRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_enterprise_ruleset(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: EnterprisesEnterpriseRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_create_enterprise_ruleset(
        self,
        enterprise: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                EnterpriseRulesetConditionsOneof0Type,
                EnterpriseRulesetConditionsOneof1Type,
                EnterpriseRulesetConditionsOneof2Type,
                EnterpriseRulesetConditionsOneof3Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_create_enterprise_ruleset(
        self,
        enterprise: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[EnterprisesEnterpriseRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#create-an-enterprise-repository-ruleset"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseRulesetsPostBody,
            RepositoryRuleset,
        )

        url = f"/enterprises/{enterprise}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(EnterprisesEnterpriseRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#get-an-enterprise-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#get-an-enterprise-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def update_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[EnterprisesEnterpriseRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def update_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                EnterpriseRulesetConditionsOneof0Type,
                EnterpriseRulesetConditionsOneof1Type,
                EnterpriseRulesetConditionsOneof2Type,
                EnterpriseRulesetConditionsOneof3Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def update_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[EnterprisesEnterpriseRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#update-an-enterprise-repository-ruleset"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseRulesetsRulesetIdPutBody,
            RepositoryRuleset,
        )

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseRulesetsRulesetIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_update_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[EnterprisesEnterpriseRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_update_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                EnterpriseRulesetConditionsOneof0Type,
                EnterpriseRulesetConditionsOneof1Type,
                EnterpriseRulesetConditionsOneof2Type,
                EnterpriseRulesetConditionsOneof3Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_update_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[EnterprisesEnterpriseRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#update-an-enterprise-repository-ruleset"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseRulesetsRulesetIdPutBody,
            RepositoryRuleset,
        )

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                EnterprisesEnterpriseRulesetsRulesetIdPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def delete_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#delete-an-enterprise-repository-ruleset"""

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_enterprise_ruleset(
        self,
        enterprise: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/rules#delete-an-enterprise-repository-ruleset"""

        from ..models import BasicError

        url = f"/enterprises/{enterprise}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def list_for_org(
        self,
        org: str,
        *,
        type: Missing[
            Literal["all", "private", "forks", "sources", "member", "internal"]
        ] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-organization-repositories"""

        from ..models import MinimalRepository

        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
        )

    async def async_list_for_org(
        self,
        org: str,
        *,
        type: Missing[
            Literal["all", "private", "forks", "sources", "member", "internal"]
        ] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-organization-repositories"""

        from ..models import MinimalRepository

        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
        )

    @overload
    def create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgReposPostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def create_in_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        custom_properties: Missing[
            OrgsOrgReposPostBodyPropCustomPropertiesType
        ] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-an-organization-repository"""

        from ..models import (
            BasicError,
            FullRepository,
            OrgsOrgReposPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgReposPostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_create_in_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        custom_properties: Missing[
            OrgsOrgReposPostBodyPropCustomPropertiesType
        ] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-an-organization-repository"""

        from ..models import (
            BasicError,
            FullRepository,
            OrgsOrgReposPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_org_rulesets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        targets: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RepositoryRuleset], list[RepositoryRulesetType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#get-all-organization-repository-rulesets"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "targets": targets,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rulesets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        targets: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RepositoryRuleset], list[RepositoryRulesetType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#get-all-organization-repository-rulesets"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "targets": targets,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def create_org_ruleset(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#create-an-organization-repository-ruleset"""

        from ..models import BasicError, OrgsOrgRulesetsPostBody, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: OrgsOrgRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#create-an-organization-repository-ruleset"""

        from ..models import BasicError, OrgsOrgRulesetsPostBody, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_rule_suites(
        self,
        org: str,
        *,
        ref: Missing[str] = UNSET,
        repository_name: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RuleSuitesItems], list[RuleSuitesItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rule-suites#list-organization-rule-suites"""

        from ..models import BasicError, RuleSuitesItems

        url = f"/orgs/{org}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "repository_name": repository_name,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rule_suites(
        self,
        org: str,
        *,
        ref: Missing[str] = UNSET,
        repository_name: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RuleSuitesItems], list[RuleSuitesItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rule-suites#list-organization-rule-suites"""

        from ..models import BasicError, RuleSuitesItems

        url = f"/orgs/{org}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "repository_name": repository_name,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_rule_suite(
        self,
        org: str,
        rule_suite_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RuleSuite, RuleSuiteType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rule-suites#get-an-organization-rule-suite"""

        from ..models import BasicError, RuleSuite

        url = f"/orgs/{org}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rule_suite(
        self,
        org: str,
        rule_suite_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RuleSuite, RuleSuiteType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rule-suites#get-an-organization-rule-suite"""

        from ..models import BasicError, RuleSuite

        url = f"/orgs/{org}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#get-an-organization-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#get-an-organization-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#update-an-organization-repository-ruleset"""

        from ..models import (
            BasicError,
            OrgsOrgRulesetsRulesetIdPutBody,
            RepositoryRuleset,
        )

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#update-an-organization-repository-ruleset"""

        from ..models import (
            BasicError,
            OrgsOrgRulesetsRulesetIdPutBody,
            RepositoryRuleset,
        )

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def delete_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#delete-an-organization-repository-ruleset"""

        from ..models import BasicError

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/orgs/rules#delete-an-organization-repository-ruleset"""

        from ..models import BasicError

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#get-a-repository"""

        from ..models import BasicError, FullRepository

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#get-a-repository"""

        from ..models import BasicError, FullRepository

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#delete-a-repository"""

        from ..models import BasicError, ReposOwnerRepoDeleteResponse403

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    async def async_delete(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#delete-a-repository"""

        from ..models import BasicError, ReposOwnerRepoDeleteResponse403

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        security_and_analysis: Missing[
            Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        default_branch: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        allow_update_branch: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        archived: Missing[bool] = UNSET,
        allow_forking: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#update-a-repository"""

        from ..models import (
            BasicError,
            FullRepository,
            ReposOwnerRepoPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private", "internal"]] = UNSET,
        security_and_analysis: Missing[
            Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        default_branch: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        allow_update_branch: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        archived: Missing[bool] = UNSET,
        allow_forking: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#update-a-repository"""

        from ..models import (
            BasicError,
            FullRepository,
            ReposOwnerRepoPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_activities(
        self,
        owner: str,
        repo: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        actor: Missing[str] = UNSET,
        time_period: Missing[
            Literal["day", "week", "month", "quarter", "year"]
        ] = UNSET,
        activity_type: Missing[
            Literal[
                "push",
                "force_push",
                "branch_creation",
                "branch_deletion",
                "pr_merge",
                "merge_queue_merge",
            ]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Activity], list[ActivityType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-activities"""

        from ..models import Activity, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/activity"

        params = {
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
            "ref": ref,
            "actor": actor,
            "time_period": time_period,
            "activity_type": activity_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Activity],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_activities(
        self,
        owner: str,
        repo: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        actor: Missing[str] = UNSET,
        time_period: Missing[
            Literal["day", "week", "month", "quarter", "year"]
        ] = UNSET,
        activity_type: Missing[
            Literal[
                "push",
                "force_push",
                "branch_creation",
                "branch_deletion",
                "pr_merge",
                "merge_queue_merge",
            ]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Activity], list[ActivityType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-activities"""

        from ..models import Activity, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/activity"

        params = {
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
            "ref": ref,
            "actor": actor,
            "time_period": time_period,
            "activity_type": activity_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Activity],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoAttestationsPostBodyType,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]: ...

    @overload
    def create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        bundle: ReposOwnerRepoAttestationsPostBodyPropBundleType,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]: ...

    def create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoAttestationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-an-attestation"""

        from ..models import (
            BasicError,
            ReposOwnerRepoAttestationsPostBody,
            ReposOwnerRepoAttestationsPostResponse201,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/attestations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoAttestationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoAttestationsPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoAttestationsPostBodyType,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]: ...

    @overload
    async def async_create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        bundle: ReposOwnerRepoAttestationsPostBodyPropBundleType,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]: ...

    async def async_create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoAttestationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-an-attestation"""

        from ..models import (
            BasicError,
            ReposOwnerRepoAttestationsPostBody,
            ReposOwnerRepoAttestationsPostResponse201,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/attestations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoAttestationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoAttestationsPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_attestations(
        self,
        owner: str,
        repo: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-attestations"""

        from ..models import ReposOwnerRepoAttestationsSubjectDigestGetResponse200

        url = f"/repos/{owner}/{repo}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        )

    async def async_list_attestations(
        self,
        owner: str,
        repo: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-attestations"""

        from ..models import ReposOwnerRepoAttestationsSubjectDigestGetResponse200

        url = f"/repos/{owner}/{repo}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        )

    def list_autolinks(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Autolink], list[AutolinkType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#get-all-autolinks-of-a-repository"""

        from ..models import Autolink

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Autolink],
        )

    async def async_list_autolinks(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Autolink], list[AutolinkType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#get-all-autolinks-of-a-repository"""

        from ..models import Autolink

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Autolink],
        )

    @overload
    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoAutolinksPostBodyType,
    ) -> Response[Autolink, AutolinkType]: ...

    @overload
    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Missing[bool] = UNSET,
    ) -> Response[Autolink, AutolinkType]: ...

    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Autolink, AutolinkType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#create-an-autolink-reference-for-a-repository"""

        from ..models import Autolink, ReposOwnerRepoAutolinksPostBody, ValidationError

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoAutolinksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoAutolinksPostBodyType,
    ) -> Response[Autolink, AutolinkType]: ...

    @overload
    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Missing[bool] = UNSET,
    ) -> Response[Autolink, AutolinkType]: ...

    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Autolink, AutolinkType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#create-an-autolink-reference-for-a-repository"""

        from ..models import Autolink, ReposOwnerRepoAutolinksPostBody, ValidationError

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoAutolinksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    def get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Autolink, AutolinkType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#get-an-autolink-reference-of-a-repository"""

        from ..models import Autolink, BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Autolink, AutolinkType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#get-an-autolink-reference-of-a-repository"""

        from ..models import Autolink, BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    def delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#delete-an-autolink-reference-from-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/autolinks#delete-an-autolink-reference-from-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def check_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CheckAutomatedSecurityFixes, CheckAutomatedSecurityFixesType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-dependabot-security-updates-are-enabled-for-a-repository"""

        from ..models import CheckAutomatedSecurityFixes

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CheckAutomatedSecurityFixes,
            error_models={},
        )

    async def async_check_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CheckAutomatedSecurityFixes, CheckAutomatedSecurityFixesType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-dependabot-security-updates-are-enabled-for-a-repository"""

        from ..models import CheckAutomatedSecurityFixes

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CheckAutomatedSecurityFixes,
            error_models={},
        )

    def enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-dependabot-security-updates"""

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-dependabot-security-updates"""

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-dependabot-security-updates"""

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-dependabot-security-updates"""

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_branches(
        self,
        owner: str,
        repo: str,
        *,
        protected: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ShortBranch], list[ShortBranchType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#list-branches"""

        from ..models import BasicError, ShortBranch

        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_branches(
        self,
        owner: str,
        repo: str,
        *,
        protected: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ShortBranch], list[ShortBranchType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#list-branches"""

        from ..models import BasicError, ShortBranch

        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    def get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#get-a-branch"""

        from ..models import BasicError, BranchWithProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#get-a-branch"""

        from ..models import BasicError, BranchWithProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    def get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BranchProtection, BranchProtectionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-branch-protection"""

        from ..models import BasicError, BranchProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BranchProtection, BranchProtectionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-branch-protection"""

        from ..models import BasicError, BranchProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> Response[ProtectedBranch, ProtectedBranchType]: ...

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Missing[bool] = UNSET,
        allow_force_pushes: Missing[Union[bool, None]] = UNSET,
        allow_deletions: Missing[bool] = UNSET,
        block_creations: Missing[bool] = UNSET,
        required_conversation_resolution: Missing[bool] = UNSET,
        lock_branch: Missing[bool] = UNSET,
        allow_fork_syncing: Missing[bool] = UNSET,
    ) -> Response[ProtectedBranch, ProtectedBranchType]: ...

    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProtectedBranch, ProtectedBranchType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-branch-protection"""

        from ..models import (
            BasicError,
            ProtectedBranch,
            ReposOwnerRepoBranchesBranchProtectionPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> Response[ProtectedBranch, ProtectedBranchType]: ...

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Missing[bool] = UNSET,
        allow_force_pushes: Missing[Union[bool, None]] = UNSET,
        allow_deletions: Missing[bool] = UNSET,
        block_creations: Missing[bool] = UNSET,
        required_conversation_resolution: Missing[bool] = UNSET,
        lock_branch: Missing[bool] = UNSET,
        allow_fork_syncing: Missing[bool] = UNSET,
    ) -> Response[ProtectedBranch, ProtectedBranchType]: ...

    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProtectedBranch, ProtectedBranchType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-branch-protection"""

        from ..models import (
            BasicError,
            ProtectedBranch,
            ReposOwnerRepoBranchesBranchProtectionPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-branch-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    async def async_delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-branch-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
            },
        )

    def get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-admin-branch-protection"""

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-admin-branch-protection"""

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    def set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-admin-branch-protection"""

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-admin-branch-protection"""

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
        )

    def delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-admin-branch-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-admin-branch-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-pull-request-review-protection"""

        from ..models import ProtectedBranchPullRequestReview

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
        )

    async def async_get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-pull-request-review-protection"""

        from ..models import ProtectedBranchPullRequestReview

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
        )

    def delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-pull-request-review-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-pull-request-review-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]: ...

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        dismissal_restrictions: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType
        ] = UNSET,
        dismiss_stale_reviews: Missing[bool] = UNSET,
        require_code_owner_reviews: Missing[bool] = UNSET,
        required_approving_review_count: Missing[int] = UNSET,
        require_last_push_approval: Missing[bool] = UNSET,
        bypass_pull_request_allowances: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType
        ] = UNSET,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]: ...

    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-pull-request-review-protection"""

        from ..models import (
            ProtectedBranchPullRequestReview,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]: ...

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        dismissal_restrictions: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType
        ] = UNSET,
        dismiss_stale_reviews: Missing[bool] = UNSET,
        require_code_owner_reviews: Missing[bool] = UNSET,
        required_approving_review_count: Missing[int] = UNSET,
        require_last_push_approval: Missing[bool] = UNSET,
        bypass_pull_request_allowances: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType
        ] = UNSET,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]: ...

    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-pull-request-review-protection"""

        from ..models import (
            ProtectedBranchPullRequestReview,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    def get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-commit-signature-protection"""

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-commit-signature-protection"""

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#create-commit-signature-protection"""

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#create-commit-signature-protection"""

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-commit-signature-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-commit-signature-protection"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-status-checks-protection"""

        from ..models import BasicError, StatusCheckPolicy

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-status-checks-protection"""

        from ..models import BasicError, StatusCheckPolicy

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-status-check-protection"""

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-status-check-protection"""

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]: ...

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        strict: Missing[bool] = UNSET,
        contexts: Missing[list[str]] = UNSET,
        checks: Missing[
            list[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ]
        ] = UNSET,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]: ...

    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-status-check-protection"""

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
            StatusCheckPolicy,
            ValidationError,
        )

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]: ...

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        strict: Missing[bool] = UNSET,
        contexts: Missing[list[str]] = UNSET,
        checks: Missing[
            list[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ]
        ] = UNSET,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]: ...

    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#update-status-check-protection"""

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
            StatusCheckPolicy,
            ValidationError,
        )

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[str], list[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-all-status-check-contexts"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[str],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[str], list[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-all-status-check-contexts"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[str],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-status-check-contexts"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-status-check-contexts"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-status-check-contexts"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-status-check-contexts"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-status-check-contexts"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-status-check-contexts"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BranchRestrictionPolicy, BranchRestrictionPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-access-restrictions"""

        from ..models import BasicError, BranchRestrictionPolicy

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[BranchRestrictionPolicy, BranchRestrictionPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-access-restrictions"""

        from ..models import BasicError, BranchRestrictionPolicy

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-access-restrictions"""

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#delete-access-restrictions"""

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-apps-with-access-to-the-protected-branch"""

        from typing import Union

        from ..models import BasicError, Integration

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Union[Integration, None]],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-apps-with-access-to-the-protected-branch"""

        from typing import Union

        from ..models import BasicError, Integration

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Union[Integration, None]],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-app-access-restrictions"""

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-app-access-restrictions"""

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-app-access-restrictions"""

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-app-access-restrictions"""

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-app-access-restrictions"""

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-app-access-restrictions"""

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    def get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-teams-with-access-to-the-protected-branch"""

        from ..models import BasicError, Team

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-teams-with-access-to-the-protected-branch"""

        from ..models import BasicError, Team

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-team-access-restrictions"""

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-team-access-restrictions"""

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-team-access-restrictions"""

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-team-access-restrictions"""

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-team-access-restrictions"""

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-team-access-restrictions"""

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    def get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-users-with-access-to-the-protected-branch"""

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#get-users-with-access-to-the-protected-branch"""

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-user-access-restrictions"""

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#set-user-access-restrictions"""

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-user-access-restrictions"""

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#add-user-access-restrictions"""

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-user-access-restrictions"""

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branch-protection#remove-user-access-restrictions"""

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]: ...

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        new_name: str,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]: ...

    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#rename-a-branch"""

        from ..models import (
            BasicError,
            BranchWithProtection,
            ReposOwnerRepoBranchesBranchRenamePostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchRenamePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]: ...

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        new_name: str,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]: ...

    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#rename-a-branch"""

        from ..models import (
            BasicError,
            BranchWithProtection,
            ReposOwnerRepoBranchesBranchRenamePostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchRenamePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_repo_push_bypass_requests(
        self,
        owner: str,
        repo: str,
        *,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal["completed", "cancelled", "expired", "denied", "open", "all"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PushRuleBypassRequest], list[PushRuleBypassRequestType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/bypass-requests#list-repository-push-rule-bypass-requests"""

        from ..models import BasicError, PushRuleBypassRequest

        url = f"/repos/{owner}/{repo}/bypass-requests/push-rules"

        params = {
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PushRuleBypassRequest],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_list_repo_push_bypass_requests(
        self,
        owner: str,
        repo: str,
        *,
        reviewer: Missing[str] = UNSET,
        requester: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        request_status: Missing[
            Literal["completed", "cancelled", "expired", "denied", "open", "all"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PushRuleBypassRequest], list[PushRuleBypassRequestType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/bypass-requests#list-repository-push-rule-bypass-requests"""

        from ..models import BasicError, PushRuleBypassRequest

        url = f"/repos/{owner}/{repo}/bypass-requests/push-rules"

        params = {
            "reviewer": reviewer,
            "requester": requester,
            "time_period": time_period,
            "request_status": request_status,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PushRuleBypassRequest],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_push_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PushRuleBypassRequest, PushRuleBypassRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/bypass-requests#get-a-repository-push-bypass-request"""

        from ..models import BasicError, PushRuleBypassRequest

        url = (
            f"/repos/{owner}/{repo}/bypass-requests/push-rules/{bypass_request_number}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PushRuleBypassRequest,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_push_bypass_request(
        self,
        owner: str,
        repo: str,
        bypass_request_number: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PushRuleBypassRequest, PushRuleBypassRequestType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/bypass-requests#get-a-repository-push-bypass-request"""

        from ..models import BasicError, PushRuleBypassRequest

        url = (
            f"/repos/{owner}/{repo}/bypass-requests/push-rules/{bypass_request_number}"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PushRuleBypassRequest,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def codeowners_errors(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeownersErrors, CodeownersErrorsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-codeowners-errors"""

        from ..models import CodeownersErrors

        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CodeownersErrors,
            error_models={},
        )

    async def async_codeowners_errors(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CodeownersErrors, CodeownersErrorsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-codeowners-errors"""

        from ..models import CodeownersErrors

        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CodeownersErrors,
            error_models={},
        )

    def list_collaborators(
        self,
        owner: str,
        repo: str,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        permission: Missing[
            Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Collaborator], list[CollaboratorType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#list-repository-collaborators"""

        from ..models import BasicError, Collaborator

        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        owner: str,
        repo: str,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        permission: Missing[
            Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Collaborator], list[CollaboratorType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#list-repository-collaborators"""

        from ..models import BasicError, Collaborator

        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    def check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#check-if-a-user-is-a-repository-collaborator"""

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#check-if-a-user-is-a-repository-collaborator"""

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#add-a-repository-collaborator"""

        from ..models import (
            BasicError,
            RepositoryInvitation,
            ReposOwnerRepoCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCollaboratorsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permission: Missing[str] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#add-a-repository-collaborator"""

        from ..models import (
            BasicError,
            RepositoryInvitation,
            ReposOwnerRepoCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCollaboratorsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#remove-a-repository-collaborator"""

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#remove-a-repository-collaborator"""

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        RepositoryCollaboratorPermission, RepositoryCollaboratorPermissionType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#get-repository-permissions-for-a-user"""

        from ..models import BasicError, RepositoryCollaboratorPermission

        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        RepositoryCollaboratorPermission, RepositoryCollaboratorPermissionType
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/collaborators#get-repository-permissions-for-a-user"""

        from ..models import BasicError, RepositoryCollaboratorPermission

        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CommitComment], list[CommitCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#list-commit-comments-for-a-repository"""

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CommitComment],
        )

    async def async_list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CommitComment], list[CommitCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#list-commit-comments-for-a-repository"""

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CommitComment],
        )

    def get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CommitComment, CommitCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment"""

        from ..models import BasicError, CommitComment

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CommitComment, CommitCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#get-a-commit-comment"""

        from ..models import BasicError, CommitComment

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#delete-a-commit-comment"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#delete-a-commit-comment"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> Response[CommitComment, CommitCommentType]: ...

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[CommitComment, CommitCommentType]: ...

    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment, CommitCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#update-a-commit-comment"""

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> Response[CommitComment, CommitCommentType]: ...

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
    ) -> Response[CommitComment, CommitCommentType]: ...

    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment, CommitCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#update-a-commit-comment"""

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        *,
        sha: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        author: Missing[str] = UNSET,
        committer: Missing[str] = UNSET,
        since: Missing[datetime] = UNSET,
        until: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Commit], list[CommitType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-commits"""

        from ..models import BasicError, Commit

        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "committer": committer,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        *,
        sha: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        author: Missing[str] = UNSET,
        committer: Missing[str] = UNSET,
        since: Missing[datetime] = UNSET,
        until: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Commit], list[CommitType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-commits"""

        from ..models import BasicError, Commit

        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "committer": committer,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[BranchShort], list[BranchShortType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-branches-for-head-commit"""

        from ..models import BasicError, BranchShort, ValidationError

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[BranchShort],
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    async def async_list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[BranchShort], list[BranchShortType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-branches-for-head-commit"""

        from ..models import BasicError, BranchShort, ValidationError

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[BranchShort],
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CommitComment], list[CommitCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#list-commit-comments"""

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CommitComment],
        )

    async def async_list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CommitComment], list[CommitCommentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#list-commit-comments"""

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[CommitComment],
        )

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> Response[CommitComment, CommitCommentType]: ...

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
        path: Missing[str] = UNSET,
        position: Missing[int] = UNSET,
        line: Missing[int] = UNSET,
    ) -> Response[CommitComment, CommitCommentType]: ...

    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment, CommitCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#create-a-commit-comment"""

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommitsCommitShaCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCommitsCommitShaCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> Response[CommitComment, CommitCommentType]: ...

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        body: str,
        path: Missing[str] = UNSET,
        position: Missing[int] = UNSET,
        line: Missing[int] = UNSET,
    ) -> Response[CommitComment, CommitCommentType]: ...

    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment, CommitCommentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/comments#create-a-commit-comment"""

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommitsCommitShaCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCommitsCommitShaCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PullRequestSimple], list[PullRequestSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-pull-requests-associated-with-a-commit"""

        from ..models import BasicError, PullRequestSimple

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestSimple],
            error_models={
                "409": BasicError,
            },
        )

    async def async_list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PullRequestSimple], list[PullRequestSimpleType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#list-pull-requests-associated-with-a-commit"""

        from ..models import BasicError, PullRequestSimple

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PullRequestSimple],
            error_models={
                "409": BasicError,
            },
        )

    def get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Commit, CommitType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#get-a-commit"""

        from ..models import (
            BasicError,
            Commit,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "409": BasicError,
            },
        )

    async def async_get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Commit, CommitType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#get-a-commit"""

        from ..models import (
            BasicError,
            Commit,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
                "409": BasicError,
            },
        )

    def get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CombinedCommitStatus, CombinedCommitStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#get-the-combined-status-for-a-specific-reference"""

        from ..models import BasicError, CombinedCommitStatus

        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CombinedCommitStatus, CombinedCommitStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#get-the-combined-status-for-a-specific-reference"""

        from ..models import BasicError, CombinedCommitStatus

        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Status], list[StatusType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#list-commit-statuses-for-a-reference"""

        from ..models import Status

        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Status],
        )

    async def async_list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Status], list[StatusType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#list-commit-statuses-for-a-reference"""

        from ..models import Status

        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Status],
        )

    def get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CommunityProfile, CommunityProfileType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/community#get-community-profile-metrics"""

        from ..models import CommunityProfile

        url = f"/repos/{owner}/{repo}/community/profile"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommunityProfile,
        )

    async def async_get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CommunityProfile, CommunityProfileType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/community#get-community-profile-metrics"""

        from ..models import CommunityProfile

        url = f"/repos/{owner}/{repo}/community/profile"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CommunityProfile,
        )

    def compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CommitComparison, CommitComparisonType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#compare-two-commits"""

        from ..models import (
            BasicError,
            CommitComparison,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    async def async_compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CommitComparison, CommitComparisonType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/commits#compare-two-commits"""

        from ..models import (
            BasicError,
            CommitComparison,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        Union[
            list[ContentDirectoryItems], ContentFile, ContentSymlink, ContentSubmodule
        ],
        Union[
            list[ContentDirectoryItemsType],
            ContentFileType,
            ContentSymlinkType,
            ContentSubmoduleType,
        ],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-repository-content"""

        from typing import Union

        from ..models import (
            BasicError,
            ContentDirectoryItems,
            ContentFile,
            ContentSubmodule,
            ContentSymlink,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[
                list[ContentDirectoryItems],
                ContentFile,
                ContentSymlink,
                ContentSubmodule,
            ],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        Union[
            list[ContentDirectoryItems], ContentFile, ContentSymlink, ContentSubmodule
        ],
        Union[
            list[ContentDirectoryItemsType],
            ContentFileType,
            ContentSymlinkType,
            ContentSubmoduleType,
        ],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-repository-content"""

        from typing import Union

        from ..models import (
            BasicError,
            ContentDirectoryItems,
            ContentFile,
            ContentSubmodule,
            ContentSymlink,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Union[
                list[ContentDirectoryItems],
                ContentFile,
                ContentSymlink,
                ContentSubmodule,
            ],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> Response[FileCommit, FileCommitType]: ...

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        message: str,
        content: str,
        sha: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        committer: Missing[ReposOwnerRepoContentsPathPutBodyPropCommitterType] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit, FileCommitType]: ...

    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit, FileCommitType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#create-or-update-file-contents"""

        from typing import Union

        from ..models import (
            BasicError,
            FileCommit,
            RepositoryRuleViolationError,
            ReposOwnerRepoContentsPathPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoContentsPathPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": Union[BasicError, RepositoryRuleViolationError],
            },
        )

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> Response[FileCommit, FileCommitType]: ...

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        message: str,
        content: str,
        sha: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        committer: Missing[ReposOwnerRepoContentsPathPutBodyPropCommitterType] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit, FileCommitType]: ...

    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit, FileCommitType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#create-or-update-file-contents"""

        from typing import Union

        from ..models import (
            BasicError,
            FileCommit,
            RepositoryRuleViolationError,
            ReposOwnerRepoContentsPathPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoContentsPathPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": Union[BasicError, RepositoryRuleViolationError],
            },
        )

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> Response[FileCommit, FileCommitType]: ...

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        message: str,
        sha: str,
        branch: Missing[str] = UNSET,
        committer: Missing[
            ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathDeleteBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit, FileCommitType]: ...

    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit, FileCommitType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#delete-a-file"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            FileCommit,
            ReposOwnerRepoContentsPathDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoContentsPathDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> Response[FileCommit, FileCommitType]: ...

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        message: str,
        sha: str,
        branch: Missing[str] = UNSET,
        committer: Missing[
            ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathDeleteBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit, FileCommitType]: ...

    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit, FileCommitType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#delete-a-file"""

        from ..models import (
            BasicError,
            EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            FileCommit,
            ReposOwnerRepoContentsPathDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoContentsPathDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseCodeScanningAlertsGetResponse503,
            },
        )

    def list_contributors(
        self,
        owner: str,
        repo: str,
        *,
        anon: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Contributor], list[ContributorType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-contributors"""

        from ..models import BasicError, Contributor

        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_contributors(
        self,
        owner: str,
        repo: str,
        *,
        anon: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Contributor], list[ContributorType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-contributors"""

        from ..models import BasicError, Contributor

        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_deployments(
        self,
        owner: str,
        repo: str,
        *,
        sha: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        task: Missing[str] = UNSET,
        environment: Missing[Union[str, None]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Deployment], list[DeploymentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#list-deployments"""

        from ..models import Deployment

        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Deployment],
        )

    async def async_list_deployments(
        self,
        owner: str,
        repo: str,
        *,
        sha: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        task: Missing[str] = UNSET,
        environment: Missing[Union[str, None]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Deployment], list[DeploymentType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#list-deployments"""

        from ..models import Deployment

        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Deployment],
        )

    @overload
    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDeploymentsPostBodyType,
    ) -> Response[Deployment, DeploymentType]: ...

    @overload
    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        ref: str,
        task: Missing[str] = UNSET,
        auto_merge: Missing[bool] = UNSET,
        required_contexts: Missing[list[str]] = UNSET,
        payload: Missing[
            Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        transient_environment: Missing[bool] = UNSET,
        production_environment: Missing[bool] = UNSET,
    ) -> Response[Deployment, DeploymentType]: ...

    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Deployment, DeploymentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#create-a-deployment"""

        from ..models import (
            Deployment,
            ReposOwnerRepoDeploymentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDeploymentsPostBodyType,
    ) -> Response[Deployment, DeploymentType]: ...

    @overload
    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        ref: str,
        task: Missing[str] = UNSET,
        auto_merge: Missing[bool] = UNSET,
        required_contexts: Missing[list[str]] = UNSET,
        payload: Missing[
            Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        transient_environment: Missing[bool] = UNSET,
        production_environment: Missing[bool] = UNSET,
    ) -> Response[Deployment, DeploymentType]: ...

    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Deployment, DeploymentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#create-a-deployment"""

        from ..models import (
            Deployment,
            ReposOwnerRepoDeploymentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Deployment, DeploymentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#get-a-deployment"""

        from ..models import BasicError, Deployment

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Deployment, DeploymentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#get-a-deployment"""

        from ..models import BasicError, Deployment

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#delete-a-deployment"""

        from ..models import BasicError, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/deployments#delete-a-deployment"""

        from ..models import BasicError, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[DeploymentStatus], list[DeploymentStatusType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#list-deployment-statuses"""

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[DeploymentStatus], list[DeploymentStatusType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#list-deployment-statuses"""

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> Response[DeploymentStatus, DeploymentStatusType]: ...

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Missing[str] = UNSET,
        log_url: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        environment_url: Missing[str] = UNSET,
        auto_inactive: Missing[bool] = UNSET,
    ) -> Response[DeploymentStatus, DeploymentStatusType]: ...

    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentStatus, DeploymentStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#create-a-deployment-status"""

        from ..models import (
            DeploymentStatus,
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> Response[DeploymentStatus, DeploymentStatusType]: ...

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Missing[str] = UNSET,
        log_url: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        environment_url: Missing[str] = UNSET,
        auto_inactive: Missing[bool] = UNSET,
    ) -> Response[DeploymentStatus, DeploymentStatusType]: ...

    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentStatus, DeploymentStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#create-a-deployment-status"""

        from ..models import (
            DeploymentStatus,
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DeploymentStatus, DeploymentStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#get-a-deployment-status"""

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DeploymentStatus, DeploymentStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/statuses#get-a-deployment-status"""

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        event_type: str,
        client_payload: Missing[
            ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> Response: ...

    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-dispatch-event"""

        from ..models import (
            BasicError,
            ReposOwnerRepoDispatchesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/dispatches"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoDispatchesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        event_type: str,
        client_payload: Missing[
            ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> Response: ...

    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-dispatch-event"""

        from ..models import (
            BasicError,
            ReposOwnerRepoDispatchesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/dispatches"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoDispatchesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_all_environments(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsGetResponse200,
        ReposOwnerRepoEnvironmentsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#list-environments"""

        from ..models import ReposOwnerRepoEnvironmentsGetResponse200

        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    async def async_get_all_environments(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsGetResponse200,
        ReposOwnerRepoEnvironmentsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#list-environments"""

        from ..models import ReposOwnerRepoEnvironmentsGetResponse200

        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    def get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Environment, EnvironmentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#get-an-environment"""

        from ..models import Environment

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Environment,
        )

    async def async_get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Environment, EnvironmentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#get-an-environment"""

        from ..models import Environment

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Environment,
        )

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> Response[Environment, EnvironmentType]: ...

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        wait_timer: Missing[int] = UNSET,
        prevent_self_review: Missing[bool] = UNSET,
        reviewers: Missing[
            Union[
                list[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ]
        ] = UNSET,
        deployment_branch_policy: Missing[
            Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> Response[Environment, EnvironmentType]: ...

    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[Environment, EnvironmentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#create-or-update-an-environment"""

        from typing import Union

        from ..models import (
            BasicError,
            Environment,
            ReposOwnerRepoEnvironmentsEnvironmentNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> Response[Environment, EnvironmentType]: ...

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        wait_timer: Missing[int] = UNSET,
        prevent_self_review: Missing[bool] = UNSET,
        reviewers: Missing[
            Union[
                list[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ]
        ] = UNSET,
        deployment_branch_policy: Missing[
            Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> Response[Environment, EnvironmentType]: ...

    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[Environment, EnvironmentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#create-or-update-an-environment"""

        from typing import Union

        from ..models import (
            BasicError,
            Environment,
            ReposOwnerRepoEnvironmentsEnvironmentNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    def delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#delete-an-environment"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/environments#delete-an-environment"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#list-deployment-branch-policies"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    async def async_list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#list-deployment-branch-policies"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternWithTypeType,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        type: Missing[Literal["branch", "tag"]] = UNSET,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternWithTypeType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#create-a-deployment-branch-policy"""

        from ..models import (
            DeploymentBranchPolicy,
            DeploymentBranchPolicyNamePatternWithType,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(DeploymentBranchPolicyNamePatternWithType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternWithTypeType,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        type: Missing[Literal["branch", "tag"]] = UNSET,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternWithTypeType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#create-a-deployment-branch-policy"""

        from ..models import (
            DeploymentBranchPolicy,
            DeploymentBranchPolicyNamePatternWithType,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(DeploymentBranchPolicyNamePatternWithType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    def get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#get-a-deployment-branch-policy"""

        from ..models import DeploymentBranchPolicy

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    async def async_get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#get-a-deployment-branch-policy"""

        from ..models import DeploymentBranchPolicy

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#update-a-deployment-branch-policy"""

        from ..models import DeploymentBranchPolicy, DeploymentBranchPolicyNamePattern

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(DeploymentBranchPolicyNamePattern, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#update-a-deployment-branch-policy"""

        from ..models import DeploymentBranchPolicy, DeploymentBranchPolicyNamePattern

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(DeploymentBranchPolicyNamePattern, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentBranchPolicy,
        )

    def delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#delete-a-deployment-branch-policy"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/branch-policies#delete-a-deployment-branch-policy"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def get_all_deployment_protection_rules(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#get-all-deployment-protection-rules-for-an-environment"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

    async def async_get_all_deployment_protection_rules(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#get-all-deployment-protection-rules-for-an-environment"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

    @overload
    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]: ...

    @overload
    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        integration_id: Missing[int] = UNSET,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]: ...

    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#create-a-custom-deployment-protection-rule-on-an-environment"""

        from ..models import (
            DeploymentProtectionRule,
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    @overload
    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]: ...

    @overload
    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        integration_id: Missing[int] = UNSET,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]: ...

    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#create-a-custom-deployment-protection-rule-on-an-environment"""

        from ..models import (
            DeploymentProtectionRule,
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    def list_custom_deployment_rule_integrations(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#list-custom-deployment-rule-integrations-available-for-an-environment"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

    async def async_list_custom_deployment_rule_integrations(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#list-custom-deployment-rule-integrations-available-for-an-environment"""

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

    def get_custom_deployment_protection_rule(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        protection_rule_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#get-a-custom-deployment-protection-rule"""

        from ..models import DeploymentProtectionRule

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    async def async_get_custom_deployment_protection_rule(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        protection_rule_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#get-a-custom-deployment-protection-rule"""

        from ..models import DeploymentProtectionRule

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeploymentProtectionRule,
        )

    def disable_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        protection_rule_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#disable-a-custom-protection-rule-for-an-environment"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        protection_rule_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deployments/protection-rules#disable-a-custom-protection-rule-for-an-environment"""

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_forks(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["newest", "oldest", "stargazers", "watchers"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/forks#list-forks"""

        from ..models import BasicError, MinimalRepository

        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    async def async_list_forks(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["newest", "oldest", "stargazers", "watchers"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/forks#list-forks"""

        from ..models import BasicError, MinimalRepository

        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        organization: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        default_branch_only: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/forks#create-a-fork"""

        from typing import Union

        from ..models import (
            BasicError,
            FullRepository,
            ReposOwnerRepoForksPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/forks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[ReposOwnerRepoForksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        organization: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        default_branch_only: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/forks#create-a-fork"""

        from typing import Union

        from ..models import (
            BasicError,
            FullRepository,
            ReposOwnerRepoForksPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/forks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[ReposOwnerRepoForksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Hook], list[HookType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#list-repository-webhooks"""

        from ..models import BasicError, Hook

        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Hook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Hook], list[HookType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#list-repository-webhooks"""

        from ..models import BasicError, Hook

        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Hook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> Response[Hook, HookType]: ...

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        config: Missing[ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook, HookType]: ...

    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Hook, HookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#create-a-repository-webhook"""

        from typing import Union

        from ..models import (
            BasicError,
            Hook,
            ReposOwnerRepoHooksPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> Response[Hook, HookType]: ...

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        config: Missing[ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook, HookType]: ...

    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Hook, HookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#create-a-repository-webhook"""

        from typing import Union

        from ..models import (
            BasicError,
            Hook,
            ReposOwnerRepoHooksPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Hook, HookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-repository-webhook"""

        from ..models import BasicError, Hook

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Hook, HookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-repository-webhook"""

        from ..models import BasicError, Hook

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#delete-a-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#delete-a-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> Response[Hook, HookType]: ...

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        config: Missing[WebhookConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        add_events: Missing[list[str]] = UNSET,
        remove_events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook, HookType]: ...

    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Hook, HookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#update-a-repository-webhook"""

        from ..models import (
            BasicError,
            Hook,
            ReposOwnerRepoHooksHookIdPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> Response[Hook, HookType]: ...

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        config: Missing[WebhookConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        add_events: Missing[list[str]] = UNSET,
        remove_events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook, HookType]: ...

    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Hook, HookType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#update-a-repository-webhook"""

        from ..models import (
            BasicError,
            Hook,
            ReposOwnerRepoHooksHookIdPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-webhook-configuration-for-a-repository"""

        from ..models import WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-webhook-configuration-for-a-repository"""

        from ..models import WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#update-a-webhook-configuration-for-a-repository"""

        from ..models import ReposOwnerRepoHooksHookIdConfigPatchBody, WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#update-a-webhook-configuration-for-a-repository"""

        from ..models import ReposOwnerRepoHooksHookIdConfigPatchBody, WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#list-deliveries-for-a-repository-webhook"""

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#list-deliveries-for-a-repository-webhook"""

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[HookDelivery, HookDeliveryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-delivery-for-a-repository-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[HookDelivery, HookDeliveryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#get-a-delivery-for-a-repository-webhook"""

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#redeliver-a-delivery-for-a-repository-webhook"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#redeliver-a-delivery-for-a-repository-webhook"""

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#ping-a-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#ping-a-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#test-the-push-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/webhooks#test-the-push-repository-webhook"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def list_invitations(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RepositoryInvitation], list[RepositoryInvitationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#list-repository-invitations"""

        from ..models import RepositoryInvitation

        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RepositoryInvitation],
        )

    async def async_list_invitations(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RepositoryInvitation], list[RepositoryInvitationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#list-repository-invitations"""

        from ..models import RepositoryInvitation

        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RepositoryInvitation],
        )

    def delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#delete-a-repository-invitation"""

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#delete-a-repository-invitation"""

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permissions: Missing[
            Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#update-a-repository-invitation"""

        from ..models import (
            RepositoryInvitation,
            ReposOwnerRepoInvitationsInvitationIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoInvitationsInvitationIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
        )

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        permissions: Missing[
            Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#update-a-repository-invitation"""

        from ..models import (
            RepositoryInvitation,
            ReposOwnerRepoInvitationsInvitationIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoInvitationsInvitationIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryInvitation,
        )

    def list_deploy_keys(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[DeployKey], list[DeployKeyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#list-deploy-keys"""

        from ..models import DeployKey

        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DeployKey],
        )

    async def async_list_deploy_keys(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[DeployKey], list[DeployKeyType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#list-deploy-keys"""

        from ..models import DeployKey

        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[DeployKey],
        )

    @overload
    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoKeysPostBodyType,
    ) -> Response[DeployKey, DeployKeyType]: ...

    @overload
    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
        read_only: Missing[bool] = UNSET,
    ) -> Response[DeployKey, DeployKeyType]: ...

    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[DeployKey, DeployKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#create-a-deploy-key"""

        from ..models import DeployKey, ReposOwnerRepoKeysPostBody, ValidationError

        url = f"/repos/{owner}/{repo}/keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoKeysPostBodyType,
    ) -> Response[DeployKey, DeployKeyType]: ...

    @overload
    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        title: Missing[str] = UNSET,
        key: str,
        read_only: Missing[bool] = UNSET,
    ) -> Response[DeployKey, DeployKeyType]: ...

    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[DeployKey, DeployKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#create-a-deploy-key"""

        from ..models import DeployKey, ReposOwnerRepoKeysPostBody, ValidationError

        url = f"/repos/{owner}/{repo}/keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DeployKey, DeployKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#get-a-deploy-key"""

        from ..models import BasicError, DeployKey

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[DeployKey, DeployKeyType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#get-a-deploy-key"""

        from ..models import BasicError, DeployKey

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#delete-a-deploy-key"""

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/deploy-keys/deploy-keys#delete-a-deploy-key"""

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def list_languages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Language, LanguageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-languages"""

        from ..models import Language

        url = f"/repos/{owner}/{repo}/languages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Language,
        )

    async def async_list_languages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Language, LanguageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-languages"""

        from ..models import Language

        url = f"/repos/{owner}/{repo}/languages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Language,
        )

    def enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/lfs#enable-git-lfs-for-a-repository"""

        from ..models import AppHookDeliveriesDeliveryIdAttemptsPostResponse202

        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    async def async_enable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/lfs#enable-git-lfs-for-a-repository"""

        from ..models import AppHookDeliveriesDeliveryIdAttemptsPostResponse202

        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={},
        )

    def disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/lfs#disable-git-lfs-for-a-repository"""

        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_lfs_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/lfs#disable-git-lfs-for-a-repository"""

        url = f"/repos/{owner}/{repo}/lfs"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoMergeUpstreamPostBodyType,
    ) -> Response[MergedUpstream, MergedUpstreamType]: ...

    @overload
    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        branch: str,
    ) -> Response[MergedUpstream, MergedUpstreamType]: ...

    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MergedUpstream, MergedUpstreamType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#sync-a-fork-branch-with-the-upstream-repository"""

        from ..models import MergedUpstream, ReposOwnerRepoMergeUpstreamPostBody

        url = f"/repos/{owner}/{repo}/merge-upstream"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoMergeUpstreamPostBodyType,
    ) -> Response[MergedUpstream, MergedUpstreamType]: ...

    @overload
    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        branch: str,
    ) -> Response[MergedUpstream, MergedUpstreamType]: ...

    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MergedUpstream, MergedUpstreamType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#sync-a-fork-branch-with-the-upstream-repository"""

        from ..models import MergedUpstream, ReposOwnerRepoMergeUpstreamPostBody

        url = f"/repos/{owner}/{repo}/merge-upstream"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoMergesPostBodyType,
    ) -> Response[Commit, CommitType]: ...

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        base: str,
        head: str,
        commit_message: Missing[str] = UNSET,
    ) -> Response[Commit, CommitType]: ...

    def merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Commit, CommitType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#merge-a-branch"""

        from ..models import (
            BasicError,
            Commit,
            ReposOwnerRepoMergesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/merges"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMergesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoMergesPostBodyType,
    ) -> Response[Commit, CommitType]: ...

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        base: str,
        head: str,
        commit_message: Missing[str] = UNSET,
    ) -> Response[Commit, CommitType]: ...

    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Commit, CommitType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/branches/branches#merge-a-branch"""

        from ..models import (
            BasicError,
            Commit,
            ReposOwnerRepoMergesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/merges"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMergesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_pages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Page, PageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-a-apiname-pages-site"""

        from ..models import BasicError, Page

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Page, PageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-a-apiname-pages-site"""

        from ..models import BasicError, Page

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Union[str, None],
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: bool,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: bool,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#update-information-about-a-apiname-pages-site"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoPagesPutBodyAnyof0,
            ReposOwnerRepoPagesPutBodyAnyof1,
            ReposOwnerRepoPagesPutBodyAnyof2,
            ReposOwnerRepoPagesPutBodyAnyof3,
            ReposOwnerRepoPagesPutBodyAnyof4,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPagesPutBodyAnyof0,
                    ReposOwnerRepoPagesPutBodyAnyof1,
                    ReposOwnerRepoPagesPutBodyAnyof2,
                    ReposOwnerRepoPagesPutBodyAnyof3,
                    ReposOwnerRepoPagesPutBodyAnyof4,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Union[str, None],
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: bool,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: bool,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
        public: Missing[bool] = UNSET,
    ) -> Response: ...

    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#update-information-about-a-apiname-pages-site"""

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoPagesPutBodyAnyof0,
            ReposOwnerRepoPagesPutBodyAnyof1,
            ReposOwnerRepoPagesPutBodyAnyof2,
            ReposOwnerRepoPagesPutBodyAnyof3,
            ReposOwnerRepoPagesPutBodyAnyof4,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPagesPutBodyAnyof0,
                    ReposOwnerRepoPagesPutBodyAnyof1,
                    ReposOwnerRepoPagesPutBodyAnyof2,
                    ReposOwnerRepoPagesPutBodyAnyof3,
                    ReposOwnerRepoPagesPutBodyAnyof4,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> Response[Page, PageType]: ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> Response[Page, PageType]: ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        build_type: Literal["legacy", "workflow"],
        source: Missing[ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> Response[Page, PageType]: ...

    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[Page, PageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#create-a-apiname-pages-site"""

        from typing import Union

        from ..models import (
            BasicError,
            Page,
            ReposOwnerRepoPagesPostBodyAnyof0,
            ReposOwnerRepoPagesPostBodyAnyof1,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPagesPostBodyAnyof0,
                    None,
                    ReposOwnerRepoPagesPostBodyAnyof1,
                    None,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> Response[Page, PageType]: ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> Response[Page, PageType]: ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        build_type: Literal["legacy", "workflow"],
        source: Missing[ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> Response[Page, PageType]: ...

    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[Page, PageType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#create-a-apiname-pages-site"""

        from typing import Union

        from ..models import (
            BasicError,
            Page,
            ReposOwnerRepoPagesPostBodyAnyof0,
            ReposOwnerRepoPagesPostBodyAnyof1,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPagesPostBodyAnyof0,
                    None,
                    ReposOwnerRepoPagesPostBodyAnyof1,
                    None,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def delete_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#delete-a-apiname-pages-site"""

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_delete_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#delete-a-apiname-pages-site"""

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_pages_builds(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PageBuild], list[PageBuildType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#list-apiname-pages-builds"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PageBuild],
        )

    async def async_list_pages_builds(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[PageBuild], list[PageBuildType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#list-apiname-pages-builds"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[PageBuild],
        )

    def request_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PageBuildStatus, PageBuildStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#request-a-apiname-pages-build"""

        from ..models import PageBuildStatus

        url = f"/repos/{owner}/{repo}/pages/builds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuildStatus,
        )

    async def async_request_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PageBuildStatus, PageBuildStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#request-a-apiname-pages-build"""

        from ..models import PageBuildStatus

        url = f"/repos/{owner}/{repo}/pages/builds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuildStatus,
        )

    def get_latest_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PageBuild, PageBuildType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-latest-pages-build"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    async def async_get_latest_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PageBuild, PageBuildType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-latest-pages-build"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    def get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PageBuild, PageBuildType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-apiname-pages-build"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    async def async_get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PageBuild, PageBuildType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-apiname-pages-build"""

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PageBuild,
        )

    @overload
    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoPagesDeploymentsPostBodyType,
    ) -> Response[PageDeployment, PageDeploymentType]: ...

    @overload
    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        artifact_id: Missing[float] = UNSET,
        artifact_url: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> Response[PageDeployment, PageDeploymentType]: ...

    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoPagesDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PageDeployment, PageDeploymentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#create-a-github-pages-deployment"""

        from ..models import (
            BasicError,
            PageDeployment,
            ReposOwnerRepoPagesDeploymentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages/deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPagesDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoPagesDeploymentsPostBodyType,
    ) -> Response[PageDeployment, PageDeploymentType]: ...

    @overload
    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        artifact_id: Missing[float] = UNSET,
        artifact_url: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> Response[PageDeployment, PageDeploymentType]: ...

    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoPagesDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PageDeployment, PageDeploymentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#create-a-github-pages-deployment"""

        from ..models import (
            BasicError,
            PageDeployment,
            ReposOwnerRepoPagesDeploymentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages/deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPagesDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PagesDeploymentStatus, PagesDeploymentStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-the-status-of-a-github-pages-deployment"""

        from ..models import BasicError, PagesDeploymentStatus

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesDeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PagesDeploymentStatus, PagesDeploymentStatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-the-status-of-a-github-pages-deployment"""

        from ..models import BasicError, PagesDeploymentStatus

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesDeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    def cancel_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#cancel-a-github-pages-deployment"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    async def async_cancel_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#cancel-a-github-pages-deployment"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
            },
        )

    def get_pages_health_check(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PagesHealthCheck, PagesHealthCheckType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-a-dns-health-check-for-github-pages"""

        from ..models import BasicError, PagesHealthCheck

        url = f"/repos/{owner}/{repo}/pages/health"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages_health_check(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[PagesHealthCheck, PagesHealthCheckType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/pages/pages#get-a-dns-health-check-for-github-pages"""

        from ..models import BasicError, PagesHealthCheck

        url = f"/repos/{owner}/{repo}/pages/health"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    def check_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-private-vulnerability-reporting-is-enabled-for-a-repository"""

        from ..models import (
            BasicError,
            ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
            error_models={
                "422": BasicError,
            },
        )

    async def async_check_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200Type,
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-private-vulnerability-reporting-is-enabled-for-a-repository"""

        from ..models import (
            BasicError,
            ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
            error_models={
                "422": BasicError,
            },
        )

    def enable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-private-vulnerability-reporting-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": BasicError,
            },
        )

    async def async_enable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-private-vulnerability-reporting-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": BasicError,
            },
        )

    def disable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-private-vulnerability-reporting-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": BasicError,
            },
        )

    async def async_disable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-private-vulnerability-reporting-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "422": BasicError,
            },
        )

    def get_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CustomPropertyValue], list[CustomPropertyValueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/custom-properties#get-all-custom-property-values-for-a-repository"""

        from ..models import BasicError, CustomPropertyValue

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CustomPropertyValue],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CustomPropertyValue], list[CustomPropertyValueType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/custom-properties#get-all-custom-property-values-for-a-repository"""

        from ..models import BasicError, CustomPropertyValue

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CustomPropertyValue],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    def create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    def create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/custom-properties#create-or-update-custom-property-values-for-a-repository"""

        from ..models import (
            BasicError,
            ReposOwnerRepoPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    async def async_create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    async def async_create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/custom-properties#create-or-update-custom-property-values-for-a-repository"""

        from ..models import (
            BasicError,
            ReposOwnerRepoPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_readme(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ContentFile, ContentFileType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-a-repository-readme"""

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ContentFile, ContentFileType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-a-repository-readme"""

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ContentFile, ContentFileType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-a-repository-readme-for-a-directory"""

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ContentFile, ContentFileType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#get-a-repository-readme-for-a-directory"""

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_releases(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Release], list[ReleaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#list-releases"""

        from ..models import BasicError, Release

        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Release],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_releases(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Release], list[ReleaseType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#list-releases"""

        from ..models import BasicError, Release

        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Release],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoReleasesPostBodyType,
    ) -> Response[Release, ReleaseType]: ...

    @overload
    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
        generate_release_notes: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#create-a-release"""

        from ..models import (
            BasicError,
            Release,
            ReposOwnerRepoReleasesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/releases"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoReleasesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoReleasesPostBodyType,
    ) -> Response[Release, ReleaseType]: ...

    @overload
    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
        generate_release_notes: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#create-a-release"""

        from ..models import (
            BasicError,
            Release,
            ReposOwnerRepoReleasesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/releases"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoReleasesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#get-a-release-asset"""

        from ..models import BasicError, ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#get-a-release-asset"""

        from ..models import BasicError, ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    def delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#delete-a-release-asset"""

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#delete-a-release-asset"""

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> Response[ReleaseAsset, ReleaseAssetType]: ...

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        label: Missing[str] = UNSET,
        state: Missing[str] = UNSET,
    ) -> Response[ReleaseAsset, ReleaseAssetType]: ...

    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#update-a-release-asset"""

        from ..models import ReleaseAsset, ReposOwnerRepoReleasesAssetsAssetIdPatchBody

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
        )

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> Response[ReleaseAsset, ReleaseAssetType]: ...

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        label: Missing[str] = UNSET,
        state: Missing[str] = UNSET,
    ) -> Response[ReleaseAsset, ReleaseAssetType]: ...

    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#update-a-release-asset"""

        from ..models import ReleaseAsset, ReposOwnerRepoReleasesAssetsAssetIdPatchBody

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
        )

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]: ...

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        previous_tag_name: Missing[str] = UNSET,
        configuration_file_path: Missing[str] = UNSET,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]: ...

    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#generate-release-notes-content-for-a-release"""

        from ..models import (
            BasicError,
            ReleaseNotesContent,
            ReposOwnerRepoReleasesGenerateNotesPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesGenerateNotesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]: ...

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        previous_tag_name: Missing[str] = UNSET,
        configuration_file_path: Missing[str] = UNSET,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]: ...

    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#generate-release-notes-content-for-a-release"""

        from ..models import (
            BasicError,
            ReleaseNotesContent,
            ReposOwnerRepoReleasesGenerateNotesPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesGenerateNotesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    def get_latest_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-the-latest-release"""

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
        )

    async def async_get_latest_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-the-latest-release"""

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
        )

    def get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release-by-tag-name"""

        from ..models import BasicError, Release

        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release-by-tag-name"""

        from ..models import BasicError, Release

        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release"""

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={},
        )

    async def async_get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#get-a-release"""

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={},
        )

    def delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#delete-a-release"""

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#delete-a-release"""

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        tag_name: Missing[str] = UNSET,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#update-a-release"""

        from ..models import (
            BasicError,
            Release,
            ReposOwnerRepoReleasesReleaseIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        tag_name: Missing[str] = UNSET,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release, ReleaseType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/releases#update-a-release"""

        from ..models import (
            BasicError,
            Release,
            ReposOwnerRepoReleasesReleaseIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ReleaseAsset], list[ReleaseAssetType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#list-release-assets"""

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ReleaseAsset],
        )

    async def async_list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ReleaseAsset], list[ReleaseAssetType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#list-release-assets"""

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[ReleaseAsset],
        )

    def upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        name: str,
        label: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        data: FileTypes,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#upload-a-release-asset"""

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        headers = {
            "Content-Type": "application/octet-stream",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        content = data

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={},
        )

    async def async_upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        name: str,
        label: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        data: FileTypes,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/releases/assets#upload-a-release-asset"""

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        headers = {
            "Content-Type": "application/octet-stream",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        content = data

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            response_model=ReleaseAsset,
            error_models={},
        )

    def get_branch_rules(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[
            Union[
                RepositoryRuleDetailedOneof0,
                RepositoryRuleDetailedOneof1,
                RepositoryRuleDetailedOneof2,
                RepositoryRuleDetailedOneof3,
                RepositoryRuleDetailedOneof4,
                RepositoryRuleDetailedOneof5,
                RepositoryRuleDetailedOneof6,
                RepositoryRuleDetailedOneof7,
                RepositoryRuleDetailedOneof8,
                RepositoryRuleDetailedOneof9,
                RepositoryRuleDetailedOneof10,
                RepositoryRuleDetailedOneof11,
                RepositoryRuleDetailedOneof12,
                RepositoryRuleDetailedOneof13,
                RepositoryRuleDetailedOneof14,
                RepositoryRuleDetailedOneof15,
                RepositoryRuleDetailedOneof16,
            ]
        ],
        list[
            Union[
                RepositoryRuleDetailedOneof0Type,
                RepositoryRuleDetailedOneof1Type,
                RepositoryRuleDetailedOneof2Type,
                RepositoryRuleDetailedOneof3Type,
                RepositoryRuleDetailedOneof4Type,
                RepositoryRuleDetailedOneof5Type,
                RepositoryRuleDetailedOneof6Type,
                RepositoryRuleDetailedOneof7Type,
                RepositoryRuleDetailedOneof8Type,
                RepositoryRuleDetailedOneof9Type,
                RepositoryRuleDetailedOneof10Type,
                RepositoryRuleDetailedOneof11Type,
                RepositoryRuleDetailedOneof12Type,
                RepositoryRuleDetailedOneof13Type,
                RepositoryRuleDetailedOneof14Type,
                RepositoryRuleDetailedOneof15Type,
                RepositoryRuleDetailedOneof16Type,
            ]
        ],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-rules-for-a-branch"""

        from typing import Union

        from ..models import (
            RepositoryRuleDetailedOneof0,
            RepositoryRuleDetailedOneof1,
            RepositoryRuleDetailedOneof2,
            RepositoryRuleDetailedOneof3,
            RepositoryRuleDetailedOneof4,
            RepositoryRuleDetailedOneof5,
            RepositoryRuleDetailedOneof6,
            RepositoryRuleDetailedOneof7,
            RepositoryRuleDetailedOneof8,
            RepositoryRuleDetailedOneof9,
            RepositoryRuleDetailedOneof10,
            RepositoryRuleDetailedOneof11,
            RepositoryRuleDetailedOneof12,
            RepositoryRuleDetailedOneof13,
            RepositoryRuleDetailedOneof14,
            RepositoryRuleDetailedOneof15,
            RepositoryRuleDetailedOneof16,
        )

        url = f"/repos/{owner}/{repo}/rules/branches/{branch}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[
                Union[
                    RepositoryRuleDetailedOneof0,
                    RepositoryRuleDetailedOneof1,
                    RepositoryRuleDetailedOneof2,
                    RepositoryRuleDetailedOneof3,
                    RepositoryRuleDetailedOneof4,
                    RepositoryRuleDetailedOneof5,
                    RepositoryRuleDetailedOneof6,
                    RepositoryRuleDetailedOneof7,
                    RepositoryRuleDetailedOneof8,
                    RepositoryRuleDetailedOneof9,
                    RepositoryRuleDetailedOneof10,
                    RepositoryRuleDetailedOneof11,
                    RepositoryRuleDetailedOneof12,
                    RepositoryRuleDetailedOneof13,
                    RepositoryRuleDetailedOneof14,
                    RepositoryRuleDetailedOneof15,
                    RepositoryRuleDetailedOneof16,
                ]
            ],
        )

    async def async_get_branch_rules(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[
        list[
            Union[
                RepositoryRuleDetailedOneof0,
                RepositoryRuleDetailedOneof1,
                RepositoryRuleDetailedOneof2,
                RepositoryRuleDetailedOneof3,
                RepositoryRuleDetailedOneof4,
                RepositoryRuleDetailedOneof5,
                RepositoryRuleDetailedOneof6,
                RepositoryRuleDetailedOneof7,
                RepositoryRuleDetailedOneof8,
                RepositoryRuleDetailedOneof9,
                RepositoryRuleDetailedOneof10,
                RepositoryRuleDetailedOneof11,
                RepositoryRuleDetailedOneof12,
                RepositoryRuleDetailedOneof13,
                RepositoryRuleDetailedOneof14,
                RepositoryRuleDetailedOneof15,
                RepositoryRuleDetailedOneof16,
            ]
        ],
        list[
            Union[
                RepositoryRuleDetailedOneof0Type,
                RepositoryRuleDetailedOneof1Type,
                RepositoryRuleDetailedOneof2Type,
                RepositoryRuleDetailedOneof3Type,
                RepositoryRuleDetailedOneof4Type,
                RepositoryRuleDetailedOneof5Type,
                RepositoryRuleDetailedOneof6Type,
                RepositoryRuleDetailedOneof7Type,
                RepositoryRuleDetailedOneof8Type,
                RepositoryRuleDetailedOneof9Type,
                RepositoryRuleDetailedOneof10Type,
                RepositoryRuleDetailedOneof11Type,
                RepositoryRuleDetailedOneof12Type,
                RepositoryRuleDetailedOneof13Type,
                RepositoryRuleDetailedOneof14Type,
                RepositoryRuleDetailedOneof15Type,
                RepositoryRuleDetailedOneof16Type,
            ]
        ],
    ]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-rules-for-a-branch"""

        from typing import Union

        from ..models import (
            RepositoryRuleDetailedOneof0,
            RepositoryRuleDetailedOneof1,
            RepositoryRuleDetailedOneof2,
            RepositoryRuleDetailedOneof3,
            RepositoryRuleDetailedOneof4,
            RepositoryRuleDetailedOneof5,
            RepositoryRuleDetailedOneof6,
            RepositoryRuleDetailedOneof7,
            RepositoryRuleDetailedOneof8,
            RepositoryRuleDetailedOneof9,
            RepositoryRuleDetailedOneof10,
            RepositoryRuleDetailedOneof11,
            RepositoryRuleDetailedOneof12,
            RepositoryRuleDetailedOneof13,
            RepositoryRuleDetailedOneof14,
            RepositoryRuleDetailedOneof15,
            RepositoryRuleDetailedOneof16,
        )

        url = f"/repos/{owner}/{repo}/rules/branches/{branch}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[
                Union[
                    RepositoryRuleDetailedOneof0,
                    RepositoryRuleDetailedOneof1,
                    RepositoryRuleDetailedOneof2,
                    RepositoryRuleDetailedOneof3,
                    RepositoryRuleDetailedOneof4,
                    RepositoryRuleDetailedOneof5,
                    RepositoryRuleDetailedOneof6,
                    RepositoryRuleDetailedOneof7,
                    RepositoryRuleDetailedOneof8,
                    RepositoryRuleDetailedOneof9,
                    RepositoryRuleDetailedOneof10,
                    RepositoryRuleDetailedOneof11,
                    RepositoryRuleDetailedOneof12,
                    RepositoryRuleDetailedOneof13,
                    RepositoryRuleDetailedOneof14,
                    RepositoryRuleDetailedOneof15,
                    RepositoryRuleDetailedOneof16,
                ]
            ],
        )

    def get_repo_rulesets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        includes_parents: Missing[bool] = UNSET,
        targets: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RepositoryRuleset], list[RepositoryRulesetType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-all-repository-rulesets"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "includes_parents": includes_parents,
            "targets": targets,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rulesets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        includes_parents: Missing[bool] = UNSET,
        targets: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RepositoryRuleset], list[RepositoryRulesetType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-all-repository-rulesets"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "includes_parents": includes_parents,
            "targets": targets,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#create-a-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsPostBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#create-a-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsPostBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_rule_suites(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RuleSuitesItems], list[RuleSuitesItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rule-suites#list-repository-rule-suites"""

        from ..models import BasicError, RuleSuitesItems

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rule_suites(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RuleSuitesItems], list[RuleSuitesItemsType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rule-suites#list-repository-rule-suites"""

        from ..models import BasicError, RuleSuitesItems

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_rule_suite(
        self,
        owner: str,
        repo: str,
        rule_suite_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RuleSuite, RuleSuiteType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rule-suites#get-a-repository-rule-suite"""

        from ..models import BasicError, RuleSuite

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rule_suite(
        self,
        owner: str,
        repo: str,
        rule_suite_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RuleSuite, RuleSuiteType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rule-suites#get-a-repository-rule-suite"""

        from ..models import BasicError, RuleSuite

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        includes_parents: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-a-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        includes_parents: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-a-repository-ruleset"""

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#update-a-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsRulesetIdPutBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleOneof15Type,
                    RepositoryRuleOneof16Type,
                    RepositoryRuleOneof17Type,
                    RepositoryRuleOneof18Type,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#update-a-repository-ruleset"""

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsRulesetIdPutBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def delete_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#delete-a-repository-ruleset"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#delete-a-repository-ruleset"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_ruleset_history(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RulesetVersion], list[RulesetVersionType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-repository-ruleset-history"""

        from ..models import BasicError, RulesetVersion

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}/history"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RulesetVersion],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_ruleset_history(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RulesetVersion], list[RulesetVersionType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-repository-ruleset-history"""

        from ..models import BasicError, RulesetVersion

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}/history"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RulesetVersion],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_ruleset_version(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RulesetVersionWithState, RulesetVersionWithStateType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-repository-ruleset-version"""

        from ..models import BasicError, RulesetVersionWithState

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RulesetVersionWithState,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_ruleset_version(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[RulesetVersionWithState, RulesetVersionWithStateType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/rules#get-repository-ruleset-version"""

        from ..models import BasicError, RulesetVersionWithState

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=RulesetVersionWithState,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[list[int]], list[list[int]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-weekly-commit-activity"""

        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[list[int]],
            error_models={},
        )

    async def async_get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[list[int]], list[list[int]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-weekly-commit-activity"""

        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[list[int]],
            error_models={},
        )

    def get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CommitActivity], list[CommitActivityType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-last-year-of-commit-activity"""

        from ..models import CommitActivity

        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CommitActivity],
        )

    async def async_get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[CommitActivity], list[CommitActivityType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-last-year-of-commit-activity"""

        from ..models import CommitActivity

        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[CommitActivity],
        )

    def get_contributors_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ContributorActivity], list[ContributorActivityType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-all-contributor-commit-activity"""

        from ..models import ContributorActivity

        url = f"/repos/{owner}/{repo}/stats/contributors"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[ContributorActivity],
        )

    async def async_get_contributors_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ContributorActivity], list[ContributorActivityType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-all-contributor-commit-activity"""

        from ..models import ContributorActivity

        url = f"/repos/{owner}/{repo}/stats/contributors"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[ContributorActivity],
        )

    def get_participation_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ParticipationStats, ParticipationStatsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-weekly-commit-count"""

        from ..models import BasicError, ParticipationStats

        url = f"/repos/{owner}/{repo}/stats/participation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_participation_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ParticipationStats, ParticipationStatsType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-weekly-commit-count"""

        from ..models import BasicError, ParticipationStats

        url = f"/repos/{owner}/{repo}/stats/participation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    def get_punch_card_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[list[int]], list[list[int]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-hourly-commit-count-for-each-day"""

        url = f"/repos/{owner}/{repo}/stats/punch_card"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[list[int]],
        )

    async def async_get_punch_card_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[list[int]], list[list[int]]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/statistics#get-the-hourly-commit-count-for-each-day"""

        url = f"/repos/{owner}/{repo}/stats/punch_card"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[list[int]],
        )

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> Response[Status, StatusType]: ...

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[Status, StatusType]: ...

    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Status, StatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#create-a-commit-status"""

        from ..models import ReposOwnerRepoStatusesShaPostBody, Status

        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoStatusesShaPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Status,
        )

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> Response[Status, StatusType]: ...

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[Status, StatusType]: ...

    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Status, StatusType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/commits/statuses#create-a-commit-status"""

        from ..models import ReposOwnerRepoStatusesShaPostBody, Status

        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoStatusesShaPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Status,
        )

    def list_tags(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Tag], list[TagType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-tags"""

        from ..models import Tag

        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Tag],
        )

    async def async_list_tags(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Tag], list[TagType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-tags"""

        from ..models import Tag

        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Tag],
        )

    def list_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TagProtection], list[TagProtectionType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#closing-down---list-tag-protection-states-for-a-repository"""

        from ..models import BasicError, TagProtection

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[TagProtection], list[TagProtectionType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#closing-down---list-tag-protection-states-for-a-repository"""

        from ..models import BasicError, TagProtection

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoTagsProtectionPostBodyType,
    ) -> Response[TagProtection, TagProtectionType]: ...

    @overload
    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        pattern: str,
    ) -> Response[TagProtection, TagProtectionType]: ...

    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TagProtection, TagProtectionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#closing-down---create-a-tag-protection-state-for-a-repository"""

        from ..models import (
            BasicError,
            ReposOwnerRepoTagsProtectionPostBody,
            TagProtection,
        )

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTagsProtectionPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoTagsProtectionPostBodyType,
    ) -> Response[TagProtection, TagProtectionType]: ...

    @overload
    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        pattern: str,
    ) -> Response[TagProtection, TagProtectionType]: ...

    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TagProtection, TagProtectionType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#closing-down---create-a-tag-protection-state-for-a-repository"""

        from ..models import (
            BasicError,
            ReposOwnerRepoTagsProtectionPostBody,
            TagProtection,
        )

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTagsProtectionPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#closing-down---delete-a-tag-protection-state-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/tags#closing-down---delete-a-tag-protection-state-for-a-repository"""

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#download-a-repository-archive-tar"""

        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#download-a-repository-archive-tar"""

        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    def list_teams(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-teams"""

        from ..models import BasicError, Team

        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_teams(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Team], list[TeamType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repository-teams"""

        from ..models import BasicError, Team

        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    def get_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Topic, TopicType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#get-all-repository-topics"""

        from ..models import BasicError, Topic

        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[Topic, TopicType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#get-all-repository-topics"""

        from ..models import BasicError, Topic

        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoTopicsPutBodyType,
    ) -> Response[Topic, TopicType]: ...

    @overload
    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        names: list[str],
    ) -> Response[Topic, TopicType]: ...

    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Topic, TopicType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#replace-all-repository-topics"""

        from ..models import (
            BasicError,
            ReposOwnerRepoTopicsPutBody,
            Topic,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/topics"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTopicsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoTopicsPutBodyType,
    ) -> Response[Topic, TopicType]: ...

    @overload
    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        names: list[str],
    ) -> Response[Topic, TopicType]: ...

    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Topic, TopicType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#replace-all-repository-topics"""

        from ..models import (
            BasicError,
            ReposOwnerRepoTopicsPutBody,
            Topic,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/topics"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTopicsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_clones(
        self,
        owner: str,
        repo: str,
        *,
        per: Missing[Literal["day", "week"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CloneTraffic, CloneTrafficType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-repository-clones"""

        from ..models import BasicError, CloneTraffic

        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_clones(
        self,
        owner: str,
        repo: str,
        *,
        per: Missing[Literal["day", "week"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[CloneTraffic, CloneTrafficType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-repository-clones"""

        from ..models import BasicError, CloneTraffic

        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    def get_top_paths(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ContentTraffic], list[ContentTrafficType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-top-referral-paths"""

        from ..models import BasicError, ContentTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_paths(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ContentTraffic], list[ContentTrafficType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-top-referral-paths"""

        from ..models import BasicError, ContentTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_top_referrers(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ReferrerTraffic], list[ReferrerTrafficType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-top-referral-sources"""

        from ..models import BasicError, ReferrerTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_referrers(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[ReferrerTraffic], list[ReferrerTrafficType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-top-referral-sources"""

        from ..models import BasicError, ReferrerTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=list[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_views(
        self,
        owner: str,
        repo: str,
        *,
        per: Missing[Literal["day", "week"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ViewTraffic, ViewTrafficType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-page-views"""

        from ..models import BasicError, ViewTraffic

        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_views(
        self,
        owner: str,
        repo: str,
        *,
        per: Missing[Literal["day", "week"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[ViewTraffic, ViewTrafficType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/metrics/traffic#get-page-views"""

        from ..models import BasicError, ViewTraffic

        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoTransferPostBodyType,
    ) -> Response[MinimalRepository, MinimalRepositoryType]: ...

    @overload
    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        new_owner: str,
        new_name: Missing[str] = UNSET,
        team_ids: Missing[list[int]] = UNSET,
    ) -> Response[MinimalRepository, MinimalRepositoryType]: ...

    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MinimalRepository, MinimalRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#transfer-a-repository"""

        from ..models import MinimalRepository, ReposOwnerRepoTransferPostBody

        url = f"/repos/{owner}/{repo}/transfer"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTransferPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MinimalRepository,
        )

    @overload
    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposOwnerRepoTransferPostBodyType,
    ) -> Response[MinimalRepository, MinimalRepositoryType]: ...

    @overload
    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        new_owner: str,
        new_name: Missing[str] = UNSET,
        team_ids: Missing[list[int]] = UNSET,
    ) -> Response[MinimalRepository, MinimalRepositoryType]: ...

    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MinimalRepository, MinimalRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#transfer-a-repository"""

        from ..models import MinimalRepository, ReposOwnerRepoTransferPostBody

        url = f"/repos/{owner}/{repo}/transfer"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTransferPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=MinimalRepository,
        )

    def check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-vulnerability-alerts-are-enabled-for-a-repository"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    async def async_check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#check-if-vulnerability-alerts-are-enabled-for-a-repository"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            error_models={},
        )

    def enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-vulnerability-alerts"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    async def async_enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#enable-vulnerability-alerts"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
        )

    def disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-vulnerability-alerts"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    async def async_disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#disable-vulnerability-alerts"""

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
        )

    def download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#download-a-repository-archive-zip"""

        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    async def async_download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/contents#download-a-repository-archive-zip"""

        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
        )

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        owner: Missing[str] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        include_all_branches: Missing[bool] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-using-a-template"""

        from ..models import (
            FullRepository,
            ReposTemplateOwnerTemplateRepoGeneratePostBody,
        )

        url = f"/repos/{template_owner}/{template_repo}/generate"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposTemplateOwnerTemplateRepoGeneratePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
        )

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        owner: Missing[str] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        include_all_branches: Missing[bool] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-using-a-template"""

        from ..models import (
            FullRepository,
            ReposTemplateOwnerTemplateRepoGeneratePostBody,
        )

        url = f"/repos/{template_owner}/{template_repo}/generate"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposTemplateOwnerTemplateRepoGeneratePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
        )

    def list_public(
        self,
        *,
        since: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-public-repositories"""

        from ..models import MinimalRepository, ValidationError

        url = "/repositories"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_public(
        self,
        *,
        since: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-public-repositories"""

        from ..models import MinimalRepository, ValidationError

        url = "/repositories"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        *,
        visibility: Missing[Literal["all", "public", "private"]] = UNSET,
        affiliation: Missing[str] = UNSET,
        type: Missing[Literal["all", "owner", "public", "private", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Repository], list[RepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repositories-for-the-authenticated-user"""

        from ..models import BasicError, Repository, ValidationError

        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        *,
        visibility: Missing[Literal["all", "public", "private"]] = UNSET,
        affiliation: Missing[str] = UNSET,
        type: Missing[Literal["all", "owner", "public", "private", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[Repository], list[RepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repositories-for-the-authenticated-user"""

        from ..models import BasicError, Repository, ValidationError

        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserReposPostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_discussions: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            FullRepository,
            UserReposPostBody,
            ValidationError,
        )

        url = "/user/repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: UserReposPostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_discussions: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        data: Missing[UserReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#create-a-repository-for-the-authenticated-user"""

        from ..models import (
            BasicError,
            FullRepository,
            UserReposPostBody,
            ValidationError,
        )

        url = "/user/repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            response_model=FullRepository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    def list_invitations_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RepositoryInvitation], list[RepositoryInvitationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#list-repository-invitations-for-the-authenticated-user"""

        from ..models import BasicError, RepositoryInvitation

        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_invitations_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[RepositoryInvitation], list[RepositoryInvitationType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#list-repository-invitations-for-the-authenticated-user"""

        from ..models import BasicError, RepositoryInvitation

        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#decline-a-repository-invitation"""

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#decline-a-repository-invitation"""

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#accept-a-repository-invitation"""

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    async def async_accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/collaborators/invitations#accept-a-repository-invitation"""

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        *,
        type: Missing[Literal["all", "owner", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repositories-for-a-user"""

        from ..models import MinimalRepository

        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
        )

    async def async_list_for_user(
        self,
        username: str,
        *,
        type: Missing[Literal["all", "owner", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/repos/repos#list-repositories-for-a-user"""

        from ..models import MinimalRepository

        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=list[MinimalRepository],
        )
