"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from collections.abc import Mapping
from typing import TYPE_CHECKING, Literal, Optional, overload
from weakref import ref

from pydantic import BaseModel

from githubkit.compat import model_dump, type_validate_python
from githubkit.typing import Missing, UnsetType
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from datetime import datetime
    from typing import Literal, Union

    from githubkit import GitHubCore
    from githubkit.response import Response
    from githubkit.typing import FileTypes, Missing
    from githubkit.utils import UNSET

    from ..models import (
        Activity,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        Autolink,
        BranchProtection,
        BranchRestrictionPolicy,
        BranchShort,
        BranchWithProtection,
        CheckAutomatedSecurityFixes,
        CloneTraffic,
        CodeownersErrors,
        Collaborator,
        CombinedCommitStatus,
        Commit,
        CommitActivity,
        CommitComment,
        CommitComparison,
        CommunityProfile,
        ContentDirectoryItems,
        ContentFile,
        ContentSubmodule,
        ContentSymlink,
        ContentTraffic,
        Contributor,
        ContributorActivity,
        CustomPropertyValue,
        DeployKey,
        Deployment,
        DeploymentBranchPolicy,
        DeploymentProtectionRule,
        DeploymentStatus,
        Environment,
        FileCommit,
        FullRepository,
        Hook,
        HookDelivery,
        HookDeliveryItem,
        Integration,
        Language,
        MergedUpstream,
        MinimalRepository,
        Page,
        PageBuild,
        PageBuildStatus,
        PageDeployment,
        PagesDeploymentStatus,
        PagesHealthCheck,
        ParticipationStats,
        ProtectedBranch,
        ProtectedBranchAdminEnforced,
        ProtectedBranchPullRequestReview,
        PullRequestSimple,
        ReferrerTraffic,
        Release,
        ReleaseAsset,
        ReleaseNotesContent,
        Repository,
        RepositoryCollaboratorPermission,
        RepositoryInvitation,
        RepositoryRuleDetailedOneof0,
        RepositoryRuleDetailedOneof1,
        RepositoryRuleDetailedOneof2,
        RepositoryRuleDetailedOneof3,
        RepositoryRuleDetailedOneof4,
        RepositoryRuleDetailedOneof5,
        RepositoryRuleDetailedOneof6,
        RepositoryRuleDetailedOneof7,
        RepositoryRuleDetailedOneof8,
        RepositoryRuleDetailedOneof9,
        RepositoryRuleDetailedOneof10,
        RepositoryRuleDetailedOneof11,
        RepositoryRuleDetailedOneof12,
        RepositoryRuleDetailedOneof13,
        RepositoryRuleDetailedOneof14,
        RepositoryRuleDetailedOneof15,
        RepositoryRuleDetailedOneof16,
        RepositoryRuleDetailedOneof17,
        RepositoryRuleDetailedOneof18,
        RepositoryRuleDetailedOneof19,
        RepositoryRuleDetailedOneof20,
        RepositoryRuleset,
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        ReposOwnerRepoEnvironmentsGetResponse200,
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        RulesetVersion,
        RulesetVersionWithState,
        RuleSuite,
        RuleSuitesItems,
        ShortBranch,
        SimpleUser,
        Status,
        StatusCheckPolicy,
        Tag,
        TagProtection,
        Team,
        Topic,
        ViewTraffic,
        WebhookConfig,
    )
    from ..types import (
        ActivityType,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
        AutolinkType,
        BranchProtectionType,
        BranchRestrictionPolicyType,
        BranchShortType,
        BranchWithProtectionType,
        CheckAutomatedSecurityFixesType,
        CloneTrafficType,
        CodeownersErrorsType,
        CollaboratorType,
        CombinedCommitStatusType,
        CommitActivityType,
        CommitCommentType,
        CommitComparisonType,
        CommitType,
        CommunityProfileType,
        ContentDirectoryItemsType,
        ContentFileType,
        ContentSubmoduleType,
        ContentSymlinkType,
        ContentTrafficType,
        ContributorActivityType,
        ContributorType,
        CustomPropertyValueType,
        DeployKeyType,
        DeploymentBranchPolicyNamePatternType,
        DeploymentBranchPolicyNamePatternWithTypeType,
        DeploymentBranchPolicySettingsType,
        DeploymentBranchPolicyType,
        DeploymentProtectionRuleType,
        DeploymentStatusType,
        DeploymentType,
        EnvironmentType,
        FileCommitType,
        FullRepositoryType,
        HookDeliveryItemType,
        HookDeliveryType,
        HookType,
        IntegrationType,
        LanguageType,
        MergedUpstreamType,
        MinimalRepositoryType,
        OrgRulesetConditionsOneof0Type,
        OrgRulesetConditionsOneof1Type,
        OrgRulesetConditionsOneof2Type,
        OrgsOrgReposPostBodyPropCustomPropertiesType,
        OrgsOrgReposPostBodyType,
        OrgsOrgRulesetsPostBodyType,
        OrgsOrgRulesetsRulesetIdPutBodyType,
        PageBuildStatusType,
        PageBuildType,
        PageDeploymentType,
        PagesDeploymentStatusType,
        PagesHealthCheckType,
        PageType,
        ParticipationStatsType,
        ProtectedBranchAdminEnforcedType,
        ProtectedBranchPullRequestReviewType,
        ProtectedBranchType,
        PullRequestSimpleType,
        ReferrerTrafficType,
        ReleaseAssetType,
        ReleaseNotesContentType,
        ReleaseType,
        RepositoryCollaboratorPermissionType,
        RepositoryInvitationType,
        RepositoryRuleBranchNamePatternType,
        RepositoryRuleCodeScanningType,
        RepositoryRuleCommitAuthorEmailPatternType,
        RepositoryRuleCommitMessagePatternType,
        RepositoryRuleCommitterEmailPatternType,
        RepositoryRuleCreationType,
        RepositoryRuleDeletionType,
        RepositoryRuleDetailedOneof0Type,
        RepositoryRuleDetailedOneof1Type,
        RepositoryRuleDetailedOneof2Type,
        RepositoryRuleDetailedOneof3Type,
        RepositoryRuleDetailedOneof4Type,
        RepositoryRuleDetailedOneof5Type,
        RepositoryRuleDetailedOneof6Type,
        RepositoryRuleDetailedOneof7Type,
        RepositoryRuleDetailedOneof8Type,
        RepositoryRuleDetailedOneof9Type,
        RepositoryRuleDetailedOneof10Type,
        RepositoryRuleDetailedOneof11Type,
        RepositoryRuleDetailedOneof12Type,
        RepositoryRuleDetailedOneof13Type,
        RepositoryRuleDetailedOneof14Type,
        RepositoryRuleDetailedOneof15Type,
        RepositoryRuleDetailedOneof16Type,
        RepositoryRuleDetailedOneof17Type,
        RepositoryRuleDetailedOneof18Type,
        RepositoryRuleDetailedOneof19Type,
        RepositoryRuleDetailedOneof20Type,
        RepositoryRuleFileExtensionRestrictionType,
        RepositoryRuleFilePathRestrictionType,
        RepositoryRuleMaxFilePathLengthType,
        RepositoryRuleMaxFileSizeType,
        RepositoryRuleMergeQueueType,
        RepositoryRuleNonFastForwardType,
        RepositoryRulePullRequestType,
        RepositoryRuleRequiredDeploymentsType,
        RepositoryRuleRequiredLinearHistoryType,
        RepositoryRuleRequiredSignaturesType,
        RepositoryRuleRequiredStatusChecksType,
        RepositoryRulesetBypassActorType,
        RepositoryRulesetConditionsType,
        RepositoryRulesetType,
        RepositoryRuleTagNamePatternType,
        RepositoryRuleUpdateType,
        RepositoryRuleWorkflowsType,
        RepositoryType,
        ReposOwnerRepoAttestationsPostBodyPropBundleType,
        ReposOwnerRepoAttestationsPostBodyType,
        ReposOwnerRepoAttestationsPostResponse201Type,
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200Type,
        ReposOwnerRepoAutolinksPostBodyType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType,
        ReposOwnerRepoBranchesBranchProtectionPutBodyType,
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType,
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType,
        ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType,
        ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType,
        ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType,
        ReposOwnerRepoBranchesBranchRenamePostBodyType,
        ReposOwnerRepoCollaboratorsUsernamePutBodyType,
        ReposOwnerRepoCommentsCommentIdPatchBodyType,
        ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
        ReposOwnerRepoContentsPathDeleteBodyPropAuthorType,
        ReposOwnerRepoContentsPathDeleteBodyPropCommitterType,
        ReposOwnerRepoContentsPathDeleteBodyType,
        ReposOwnerRepoContentsPathPutBodyPropAuthorType,
        ReposOwnerRepoContentsPathPutBodyPropCommitterType,
        ReposOwnerRepoContentsPathPutBodyType,
        ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
        ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type,
        ReposOwnerRepoDeploymentsPostBodyType,
        ReposOwnerRepoDispatchesPostBodyPropClientPayloadType,
        ReposOwnerRepoDispatchesPostBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200Type,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200Type,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200Type,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
        ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType,
        ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType,
        ReposOwnerRepoEnvironmentsGetResponse200Type,
        ReposOwnerRepoForksPostBodyType,
        ReposOwnerRepoHooksHookIdConfigPatchBodyType,
        ReposOwnerRepoHooksHookIdPatchBodyType,
        ReposOwnerRepoHooksPostBodyPropConfigType,
        ReposOwnerRepoHooksPostBodyType,
        ReposOwnerRepoInvitationsInvitationIdPatchBodyType,
        ReposOwnerRepoKeysPostBodyType,
        ReposOwnerRepoMergesPostBodyType,
        ReposOwnerRepoMergeUpstreamPostBodyType,
        ReposOwnerRepoPagesDeploymentsPostBodyType,
        ReposOwnerRepoPagesPostBodyAnyof0Type,
        ReposOwnerRepoPagesPostBodyAnyof1Type,
        ReposOwnerRepoPagesPostBodyPropSourceType,
        ReposOwnerRepoPagesPutBodyAnyof0Type,
        ReposOwnerRepoPagesPutBodyAnyof1Type,
        ReposOwnerRepoPagesPutBodyAnyof2Type,
        ReposOwnerRepoPagesPutBodyAnyof3Type,
        ReposOwnerRepoPagesPutBodyAnyof4Type,
        ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType,
        ReposOwnerRepoPatchBodyType,
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200Type,
        ReposOwnerRepoPropertiesValuesPatchBodyType,
        ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType,
        ReposOwnerRepoReleasesGenerateNotesPostBodyType,
        ReposOwnerRepoReleasesPostBodyType,
        ReposOwnerRepoReleasesReleaseIdPatchBodyType,
        ReposOwnerRepoRulesetsPostBodyType,
        ReposOwnerRepoRulesetsRulesetIdPutBodyType,
        ReposOwnerRepoStatusesShaPostBodyType,
        ReposOwnerRepoTagsProtectionPostBodyType,
        ReposOwnerRepoTopicsPutBodyType,
        ReposOwnerRepoTransferPostBodyType,
        ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
        RulesetVersionType,
        RulesetVersionWithStateType,
        RuleSuitesItemsType,
        RuleSuiteType,
        ShortBranchType,
        SimpleUserType,
        StatusCheckPolicyType,
        StatusType,
        TagProtectionType,
        TagType,
        TeamType,
        TopicType,
        UserReposPostBodyType,
        ViewTrafficType,
        WebhookConfigType,
    )


class ReposClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def list_for_org(
        self,
        org: str,
        *,
        type: Missing[
            Literal["all", "public", "private", "forks", "sources", "member"]
        ] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """repos/list-for-org

        GET /orgs/{org}/repos

        Lists repositories for the specified organization.

        > [!NOTE]
        > In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."

        See also: https://docs.github.com/rest/repos/repos#list-organization-repositories
        """

        from ..models import MinimalRepository

        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
        )

    async def async_list_for_org(
        self,
        org: str,
        *,
        type: Missing[
            Literal["all", "public", "private", "forks", "sources", "member"]
        ] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """repos/list-for-org

        GET /orgs/{org}/repos

        Lists repositories for the specified organization.

        > [!NOTE]
        > In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."

        See also: https://docs.github.com/rest/repos/repos#list-organization-repositories
        """

        from ..models import MinimalRepository

        url = f"/orgs/{org}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
        )

    @overload
    def create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgReposPostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def create_in_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private"]] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        custom_properties: Missing[
            OrgsOrgReposPostBodyPropCustomPropertiesType
        ] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/create-in-org

        POST /orgs/{org}/repos

        Creates a new repository in the specified organization. The authenticated user must be a member of the organization.

        OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.

        See also: https://docs.github.com/rest/repos/repos#create-an-organization-repository
        """

        from ..models import (
            BasicError,
            FullRepository,
            OrgsOrgReposPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgReposPostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_create_in_org(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private"]] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        custom_properties: Missing[
            OrgsOrgReposPostBodyPropCustomPropertiesType
        ] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_create_in_org(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/create-in-org

        POST /orgs/{org}/repos

        Creates a new repository in the specified organization. The authenticated user must be a member of the organization.

        OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.

        See also: https://docs.github.com/rest/repos/repos#create-an-organization-repository
        """

        from ..models import (
            BasicError,
            FullRepository,
            OrgsOrgReposPostBody,
            ValidationError,
        )

        url = f"/orgs/{org}/repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_org_rulesets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        targets: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryRuleset], list[RepositoryRulesetType]]:
        """repos/get-org-rulesets

        GET /orgs/{org}/rulesets

        Get all the repository rulesets for an organization.

        See also: https://docs.github.com/rest/orgs/rules#get-all-organization-repository-rulesets
        """

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "targets": targets,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rulesets(
        self,
        org: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        targets: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryRuleset], list[RepositoryRulesetType]]:
        """repos/get-org-rulesets

        GET /orgs/{org}/rulesets

        Get all the repository rulesets for an organization.

        See also: https://docs.github.com/rest/orgs/rules#get-all-organization-repository-rulesets
        """

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "targets": targets,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def create_org_ruleset(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleFilePathRestrictionType,
                    RepositoryRuleMaxFilePathLengthType,
                    RepositoryRuleFileExtensionRestrictionType,
                    RepositoryRuleMaxFileSizeType,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/create-org-ruleset

        POST /orgs/{org}/rulesets

        Create a repository ruleset for an organization.

        See also: https://docs.github.com/rest/orgs/rules#create-an-organization-repository-ruleset
        """

        from ..models import BasicError, OrgsOrgRulesetsPostBody, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: OrgsOrgRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleFilePathRestrictionType,
                    RepositoryRuleMaxFilePathLengthType,
                    RepositoryRuleFileExtensionRestrictionType,
                    RepositoryRuleMaxFileSizeType,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_create_org_ruleset(
        self,
        org: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/create-org-ruleset

        POST /orgs/{org}/rulesets

        Create a repository ruleset for an organization.

        See also: https://docs.github.com/rest/orgs/rules#create-an-organization-repository-ruleset
        """

        from ..models import BasicError, OrgsOrgRulesetsPostBody, RepositoryRuleset

        url = f"/orgs/{org}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_rule_suites(
        self,
        org: str,
        *,
        ref: Missing[str] = UNSET,
        repository_name: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RuleSuitesItems], list[RuleSuitesItemsType]]:
        """repos/get-org-rule-suites

        GET /orgs/{org}/rulesets/rule-suites

        Lists suites of rule evaluations at the organization level.
        For more information, see "[Managing rulesets for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-rulesets-for-repositories-in-your-organization#viewing-insights-for-rulesets)."

        See also: https://docs.github.com/rest/orgs/rule-suites#list-organization-rule-suites
        """

        from ..models import BasicError, RuleSuitesItems

        url = f"/orgs/{org}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "repository_name": repository_name,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rule_suites(
        self,
        org: str,
        *,
        ref: Missing[str] = UNSET,
        repository_name: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RuleSuitesItems], list[RuleSuitesItemsType]]:
        """repos/get-org-rule-suites

        GET /orgs/{org}/rulesets/rule-suites

        Lists suites of rule evaluations at the organization level.
        For more information, see "[Managing rulesets for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-rulesets-for-repositories-in-your-organization#viewing-insights-for-rulesets)."

        See also: https://docs.github.com/rest/orgs/rule-suites#list-organization-rule-suites
        """

        from ..models import BasicError, RuleSuitesItems

        url = f"/orgs/{org}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "repository_name": repository_name,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_rule_suite(
        self,
        org: str,
        rule_suite_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RuleSuite, RuleSuiteType]:
        """repos/get-org-rule-suite

        GET /orgs/{org}/rulesets/rule-suites/{rule_suite_id}

        Gets information about a suite of rule evaluations from within an organization.
        For more information, see "[Managing rulesets for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-rulesets-for-repositories-in-your-organization#viewing-insights-for-rulesets)."

        See also: https://docs.github.com/rest/orgs/rule-suites#get-an-organization-rule-suite
        """

        from ..models import BasicError, RuleSuite

        url = f"/orgs/{org}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_rule_suite(
        self,
        org: str,
        rule_suite_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RuleSuite, RuleSuiteType]:
        """repos/get-org-rule-suite

        GET /orgs/{org}/rulesets/rule-suites/{rule_suite_id}

        Gets information about a suite of rule evaluations from within an organization.
        For more information, see "[Managing rulesets for repositories in your organization](https://docs.github.com/organizations/managing-organization-settings/managing-rulesets-for-repositories-in-your-organization#viewing-insights-for-rulesets)."

        See also: https://docs.github.com/rest/orgs/rule-suites#get-an-organization-rule-suite
        """

        from ..models import BasicError, RuleSuite

        url = f"/orgs/{org}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/get-org-ruleset

        GET /orgs/{org}/rulesets/{ruleset_id}

        Get a repository ruleset for an organization.

        **Note:** To prevent leaking sensitive information, the `bypass_actors` property is only returned if the user
        making the API request has write access to the ruleset.

        See also: https://docs.github.com/rest/orgs/rules#get-an-organization-repository-ruleset
        """

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/get-org-ruleset

        GET /orgs/{org}/rulesets/{ruleset_id}

        Get a repository ruleset for an organization.

        **Note:** To prevent leaking sensitive information, the `bypass_actors` property is only returned if the user
        making the API request has write access to the ruleset.

        See also: https://docs.github.com/rest/orgs/rules#get-an-organization-repository-ruleset
        """

        from ..models import BasicError, RepositoryRuleset

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleFilePathRestrictionType,
                    RepositoryRuleMaxFilePathLengthType,
                    RepositoryRuleFileExtensionRestrictionType,
                    RepositoryRuleMaxFileSizeType,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/update-org-ruleset

        PUT /orgs/{org}/rulesets/{ruleset_id}

        Update a ruleset for an organization.

        See also: https://docs.github.com/rest/orgs/rules#update-an-organization-repository-ruleset
        """

        from ..models import (
            BasicError,
            OrgsOrgRulesetsRulesetIdPutBody,
            RepositoryRuleset,
        )

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push", "repository"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[
            Union[
                OrgRulesetConditionsOneof0Type,
                OrgRulesetConditionsOneof1Type,
                OrgRulesetConditionsOneof2Type,
            ]
        ] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleFilePathRestrictionType,
                    RepositoryRuleMaxFilePathLengthType,
                    RepositoryRuleFileExtensionRestrictionType,
                    RepositoryRuleMaxFileSizeType,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_update_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[OrgsOrgRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/update-org-ruleset

        PUT /orgs/{org}/rulesets/{ruleset_id}

        Update a ruleset for an organization.

        See also: https://docs.github.com/rest/orgs/rules#update-an-organization-repository-ruleset
        """

        from ..models import (
            BasicError,
            OrgsOrgRulesetsRulesetIdPutBody,
            RepositoryRuleset,
        )

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(OrgsOrgRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def delete_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-org-ruleset

        DELETE /orgs/{org}/rulesets/{ruleset_id}

        Delete a ruleset for an organization.

        See also: https://docs.github.com/rest/orgs/rules#delete-an-organization-repository-ruleset
        """

        from ..models import BasicError

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_org_ruleset(
        self,
        org: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-org-ruleset

        DELETE /orgs/{org}/rulesets/{ruleset_id}

        Delete a ruleset for an organization.

        See also: https://docs.github.com/rest/orgs/rules#delete-an-organization-repository-ruleset
        """

        from ..models import BasicError

        url = f"/orgs/{org}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/get

        GET /repos/{owner}/{repo}

        The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network.

        > [!NOTE]
        > In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."

        See also: https://docs.github.com/rest/repos/repos#get-a-repository
        """

        from ..models import BasicError, FullRepository

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/get

        GET /repos/{owner}/{repo}

        The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network.

        > [!NOTE]
        > In order to see the `security_and_analysis` block for a repository you must have admin permissions for the repository or be an owner or security manager for the organization that owns the repository. For more information, see "[Managing security managers in your organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization)."

        See also: https://docs.github.com/rest/repos/repos#get-a-repository
        """

        from ..models import BasicError, FullRepository

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete

        DELETE /repos/{owner}/{repo}

        Deleting a repository requires admin access.

        If an organization owner has configured the organization to prevent members from deleting organization-owned
        repositories, you will get a `403 Forbidden` response.

        OAuth app tokens and personal access tokens (classic) need the `delete_repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/repos/repos#delete-a-repository
        """

        from ..models import BasicError, ReposOwnerRepoDeleteResponse403

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_delete(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete

        DELETE /repos/{owner}/{repo}

        Deleting a repository requires admin access.

        If an organization owner has configured the organization to prevent members from deleting organization-owned
        repositories, you will get a `403 Forbidden` response.

        OAuth app tokens and personal access tokens (classic) need the `delete_repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/repos/repos#delete-a-repository
        """

        from ..models import BasicError, ReposOwnerRepoDeleteResponse403

        url = f"/repos/{owner}/{repo}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": ReposOwnerRepoDeleteResponse403,
                "404": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def update(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private"]] = UNSET,
        security_and_analysis: Missing[
            Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        default_branch: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        allow_update_branch: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        archived: Missing[bool] = UNSET,
        allow_forking: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/update

        PATCH /repos/{owner}/{repo}

        **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/rest/repos/repos#replace-all-repository-topics) endpoint.

        See also: https://docs.github.com/rest/repos/repos#update-a-repository
        """

        from ..models import (
            BasicError,
            FullRepository,
            ReposOwnerRepoPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        visibility: Missing[Literal["public", "private"]] = UNSET,
        security_and_analysis: Missing[
            Union[ReposOwnerRepoPatchBodyPropSecurityAndAnalysisType, None]
        ] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
        default_branch: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        allow_update_branch: Missing[bool] = UNSET,
        use_squash_pr_title_as_default: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        archived: Missing[bool] = UNSET,
        allow_forking: Missing[bool] = UNSET,
        web_commit_signoff_required: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_update(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/update

        PATCH /repos/{owner}/{repo}

        **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/rest/repos/repos#replace-all-repository-topics) endpoint.

        See also: https://docs.github.com/rest/repos/repos#update-a-repository
        """

        from ..models import (
            BasicError,
            FullRepository,
            ReposOwnerRepoPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "403": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def list_activities(
        self,
        owner: str,
        repo: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        actor: Missing[str] = UNSET,
        time_period: Missing[
            Literal["day", "week", "month", "quarter", "year"]
        ] = UNSET,
        activity_type: Missing[
            Literal[
                "push",
                "force_push",
                "branch_creation",
                "branch_deletion",
                "pr_merge",
                "merge_queue_merge",
            ]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Activity], list[ActivityType]]:
        """repos/list-activities

        GET /repos/{owner}/{repo}/activity

        Lists a detailed history of changes to a repository, such as pushes, merges, force pushes, and branch changes, and associates these changes with commits and users.

        For more information about viewing repository activity,
        see "[Viewing activity and data for your repository](https://docs.github.com/repositories/viewing-activity-and-data-for-your-repository)."

        See also: https://docs.github.com/rest/repos/repos#list-repository-activities
        """

        from ..models import Activity, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/activity"

        params = {
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
            "ref": ref,
            "actor": actor,
            "time_period": time_period,
            "activity_type": activity_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Activity],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    async def async_list_activities(
        self,
        owner: str,
        repo: str,
        *,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        actor: Missing[str] = UNSET,
        time_period: Missing[
            Literal["day", "week", "month", "quarter", "year"]
        ] = UNSET,
        activity_type: Missing[
            Literal[
                "push",
                "force_push",
                "branch_creation",
                "branch_deletion",
                "pr_merge",
                "merge_queue_merge",
            ]
        ] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Activity], list[ActivityType]]:
        """repos/list-activities

        GET /repos/{owner}/{repo}/activity

        Lists a detailed history of changes to a repository, such as pushes, merges, force pushes, and branch changes, and associates these changes with commits and users.

        For more information about viewing repository activity,
        see "[Viewing activity and data for your repository](https://docs.github.com/repositories/viewing-activity-and-data-for-your-repository)."

        See also: https://docs.github.com/rest/repos/repos#list-repository-activities
        """

        from ..models import Activity, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/activity"

        params = {
            "direction": direction,
            "per_page": per_page,
            "before": before,
            "after": after,
            "ref": ref,
            "actor": actor,
            "time_period": time_period,
            "activity_type": activity_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Activity],
            error_models={
                "422": ValidationErrorSimple,
            },
        )

    @overload
    def create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoAttestationsPostBodyType,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]: ...

    @overload
    def create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        bundle: ReposOwnerRepoAttestationsPostBodyPropBundleType,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]: ...

    def create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoAttestationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]:
        """repos/create-attestation

        POST /repos/{owner}/{repo}/attestations

        Store an artifact attestation and associate it with a repository.

        The authenticated user must have write permission to the repository and, if using a fine-grained access token, the `attestations:write` permission is required.

        Artifact attestations are meant to be created using the [attest action](https://github.com/actions/attest). For more information, see our guide on [using artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/rest/repos/repos#create-an-attestation
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoAttestationsPostBody,
            ReposOwnerRepoAttestationsPostResponse201,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/attestations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoAttestationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoAttestationsPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoAttestationsPostBodyType,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]: ...

    @overload
    async def async_create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        bundle: ReposOwnerRepoAttestationsPostBodyPropBundleType,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]: ...

    async def async_create_attestation(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoAttestationsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[
        ReposOwnerRepoAttestationsPostResponse201,
        ReposOwnerRepoAttestationsPostResponse201Type,
    ]:
        """repos/create-attestation

        POST /repos/{owner}/{repo}/attestations

        Store an artifact attestation and associate it with a repository.

        The authenticated user must have write permission to the repository and, if using a fine-grained access token, the `attestations:write` permission is required.

        Artifact attestations are meant to be created using the [attest action](https://github.com/actions/attest). For more information, see our guide on [using artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/rest/repos/repos#create-an-attestation
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoAttestationsPostBody,
            ReposOwnerRepoAttestationsPostResponse201,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/attestations"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoAttestationsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoAttestationsPostResponse201,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_attestations(
        self,
        owner: str,
        repo: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200Type,
    ]:
        """repos/list-attestations

        GET /repos/{owner}/{repo}/attestations/{subject_digest}

        List a collection of artifact attestations with a given subject digest that are associated with a repository.

        The authenticated user making the request must have read access to the repository. In addition, when using a fine-grained access token the `attestations:read` permission is required.

        **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/rest/repos/repos#list-attestations
        """

        from ..models import ReposOwnerRepoAttestationsSubjectDigestGetResponse200

        url = f"/repos/{owner}/{repo}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        )

    async def async_list_attestations(
        self,
        owner: str,
        repo: str,
        subject_digest: str,
        *,
        per_page: Missing[int] = UNSET,
        before: Missing[str] = UNSET,
        after: Missing[str] = UNSET,
        predicate_type: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        ReposOwnerRepoAttestationsSubjectDigestGetResponse200Type,
    ]:
        """repos/list-attestations

        GET /repos/{owner}/{repo}/attestations/{subject_digest}

        List a collection of artifact attestations with a given subject digest that are associated with a repository.

        The authenticated user making the request must have read access to the repository. In addition, when using a fine-grained access token the `attestations:read` permission is required.

        **Please note:** in order to offer meaningful security benefits, an attestation's signature and timestamps **must** be cryptographically verified, and the identity of the attestation signer **must** be validated. Attestations can be verified using the [GitHub CLI `attestation verify` command](https://cli.github.com/manual/gh_attestation_verify). For more information, see [our guide on how to use artifact attestations to establish a build's provenance](https://docs.github.com/actions/security-guides/using-artifact-attestations-to-establish-provenance-for-builds).

        See also: https://docs.github.com/rest/repos/repos#list-attestations
        """

        from ..models import ReposOwnerRepoAttestationsSubjectDigestGetResponse200

        url = f"/repos/{owner}/{repo}/attestations/{subject_digest}"

        params = {
            "per_page": per_page,
            "before": before,
            "after": after,
            "predicate_type": predicate_type,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoAttestationsSubjectDigestGetResponse200,
        )

    def list_autolinks(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Autolink], list[AutolinkType]]:
        """repos/list-autolinks

        GET /repos/{owner}/{repo}/autolinks

        Gets all autolinks that are configured for a repository.

        Information about autolinks are only available to repository administrators.

        See also: https://docs.github.com/rest/repos/autolinks#get-all-autolinks-of-a-repository
        """

        from ..models import Autolink

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Autolink],
        )

    async def async_list_autolinks(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Autolink], list[AutolinkType]]:
        """repos/list-autolinks

        GET /repos/{owner}/{repo}/autolinks

        Gets all autolinks that are configured for a repository.

        Information about autolinks are only available to repository administrators.

        See also: https://docs.github.com/rest/repos/autolinks#get-all-autolinks-of-a-repository
        """

        from ..models import Autolink

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Autolink],
        )

    @overload
    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoAutolinksPostBodyType,
    ) -> Response[Autolink, AutolinkType]: ...

    @overload
    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Missing[bool] = UNSET,
    ) -> Response[Autolink, AutolinkType]: ...

    def create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Autolink, AutolinkType]:
        """repos/create-autolink

        POST /repos/{owner}/{repo}/autolinks

        Users with admin access to the repository can create an autolink.

        See also: https://docs.github.com/rest/repos/autolinks#create-an-autolink-reference-for-a-repository
        """

        from ..models import Autolink, ReposOwnerRepoAutolinksPostBody, ValidationError

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoAutolinksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoAutolinksPostBodyType,
    ) -> Response[Autolink, AutolinkType]: ...

    @overload
    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        key_prefix: str,
        url_template: str,
        is_alphanumeric: Missing[bool] = UNSET,
    ) -> Response[Autolink, AutolinkType]: ...

    async def async_create_autolink(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoAutolinksPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Autolink, AutolinkType]:
        """repos/create-autolink

        POST /repos/{owner}/{repo}/autolinks

        Users with admin access to the repository can create an autolink.

        See also: https://docs.github.com/rest/repos/autolinks#create-an-autolink-reference-for-a-repository
        """

        from ..models import Autolink, ReposOwnerRepoAutolinksPostBody, ValidationError

        url = f"/repos/{owner}/{repo}/autolinks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoAutolinksPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Autolink,
            error_models={
                "422": ValidationError,
            },
        )

    def get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Autolink, AutolinkType]:
        """repos/get-autolink

        GET /repos/{owner}/{repo}/autolinks/{autolink_id}

        This returns a single autolink reference by ID that was configured for the given repository.

        Information about autolinks are only available to repository administrators.

        See also: https://docs.github.com/rest/repos/autolinks#get-an-autolink-reference-of-a-repository
        """

        from ..models import Autolink, BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Autolink, AutolinkType]:
        """repos/get-autolink

        GET /repos/{owner}/{repo}/autolinks/{autolink_id}

        This returns a single autolink reference by ID that was configured for the given repository.

        Information about autolinks are only available to repository administrators.

        See also: https://docs.github.com/rest/repos/autolinks#get-an-autolink-reference-of-a-repository
        """

        from ..models import Autolink, BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Autolink,
            error_models={
                "404": BasicError,
            },
        )

    def delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-autolink

        DELETE /repos/{owner}/{repo}/autolinks/{autolink_id}

        This deletes a single autolink reference by ID that was configured for the given repository.

        Information about autolinks are only available to repository administrators.

        See also: https://docs.github.com/rest/repos/autolinks#delete-an-autolink-reference-from-a-repository
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_autolink(
        self,
        owner: str,
        repo: str,
        autolink_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-autolink

        DELETE /repos/{owner}/{repo}/autolinks/{autolink_id}

        This deletes a single autolink reference by ID that was configured for the given repository.

        Information about autolinks are only available to repository administrators.

        See also: https://docs.github.com/rest/repos/autolinks#delete-an-autolink-reference-from-a-repository
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/autolinks/{autolink_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def check_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CheckAutomatedSecurityFixes, CheckAutomatedSecurityFixesType]:
        """repos/check-automated-security-fixes

        GET /repos/{owner}/{repo}/automated-security-fixes

        Shows whether Dependabot security updates are enabled, disabled or paused for a repository. The authenticated user must have admin read access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".

        See also: https://docs.github.com/rest/repos/repos#check-if-dependabot-security-updates-are-enabled-for-a-repository
        """

        from ..models import CheckAutomatedSecurityFixes

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CheckAutomatedSecurityFixes,
            error_models={},
        )

    async def async_check_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CheckAutomatedSecurityFixes, CheckAutomatedSecurityFixesType]:
        """repos/check-automated-security-fixes

        GET /repos/{owner}/{repo}/automated-security-fixes

        Shows whether Dependabot security updates are enabled, disabled or paused for a repository. The authenticated user must have admin read access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".

        See also: https://docs.github.com/rest/repos/repos#check-if-dependabot-security-updates-are-enabled-for-a-repository
        """

        from ..models import CheckAutomatedSecurityFixes

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CheckAutomatedSecurityFixes,
            error_models={},
        )

    def enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/enable-automated-security-fixes

        PUT /repos/{owner}/{repo}/automated-security-fixes

        Enables Dependabot security updates for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".

        See also: https://docs.github.com/rest/repos/repos#enable-dependabot-security-updates
        """

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_enable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/enable-automated-security-fixes

        PUT /repos/{owner}/{repo}/automated-security-fixes

        Enables Dependabot security updates for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".

        See also: https://docs.github.com/rest/repos/repos#enable-dependabot-security-updates
        """

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/disable-automated-security-fixes

        DELETE /repos/{owner}/{repo}/automated-security-fixes

        Disables Dependabot security updates for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".

        See also: https://docs.github.com/rest/repos/repos#disable-dependabot-security-updates
        """

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_disable_automated_security_fixes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/disable-automated-security-fixes

        DELETE /repos/{owner}/{repo}/automated-security-fixes

        Disables Dependabot security updates for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring Dependabot security updates](https://docs.github.com/articles/configuring-automated-security-fixes)".

        See also: https://docs.github.com/rest/repos/repos#disable-dependabot-security-updates
        """

        url = f"/repos/{owner}/{repo}/automated-security-fixes"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_branches(
        self,
        owner: str,
        repo: str,
        *,
        protected: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ShortBranch], list[ShortBranchType]]:
        """repos/list-branches

        GET /repos/{owner}/{repo}/branches

        See also: https://docs.github.com/rest/branches/branches#list-branches
        """

        from ..models import BasicError, ShortBranch

        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_branches(
        self,
        owner: str,
        repo: str,
        *,
        protected: Missing[bool] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ShortBranch], list[ShortBranchType]]:
        """repos/list-branches

        GET /repos/{owner}/{repo}/branches

        See also: https://docs.github.com/rest/branches/branches#list-branches
        """

        from ..models import BasicError, ShortBranch

        url = f"/repos/{owner}/{repo}/branches"

        params = {
            "protected": protected,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ShortBranch],
            error_models={
                "404": BasicError,
            },
        )

    def get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]:
        """repos/get-branch

        GET /repos/{owner}/{repo}/branches/{branch}

        See also: https://docs.github.com/rest/branches/branches#get-a-branch
        """

        from ..models import BasicError, BranchWithProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]:
        """repos/get-branch

        GET /repos/{owner}/{repo}/branches/{branch}

        See also: https://docs.github.com/rest/branches/branches#get-a-branch
        """

        from ..models import BasicError, BranchWithProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BranchWithProtection,
            error_models={
                "404": BasicError,
            },
        )

    def get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BranchProtection, BranchProtectionType]:
        """repos/get-branch-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-branch-protection
        """

        from ..models import BasicError, BranchProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BranchProtection, BranchProtectionType]:
        """repos/get-branch-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-branch-protection
        """

        from ..models import BasicError, BranchProtection

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BranchProtection,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> Response[ProtectedBranch, ProtectedBranchType]: ...

    @overload
    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Missing[bool] = UNSET,
        allow_force_pushes: Missing[Union[bool, None]] = UNSET,
        allow_deletions: Missing[bool] = UNSET,
        block_creations: Missing[bool] = UNSET,
        required_conversation_resolution: Missing[bool] = UNSET,
        lock_branch: Missing[bool] = UNSET,
        allow_fork_syncing: Missing[bool] = UNSET,
    ) -> Response[ProtectedBranch, ProtectedBranchType]: ...

    def update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProtectedBranch, ProtectedBranchType]:
        """repos/update-branch-protection

        PUT /repos/{owner}/{repo}/branches/{branch}/protection

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Protecting a branch requires admin or owner permissions to the repository.

        > [!NOTE]
        > Passing new arrays of `users` and `teams` replaces their previous values.

        > [!NOTE]
        > The list of users, apps, and teams in total is limited to 100 items.

        See also: https://docs.github.com/rest/branches/branch-protection#update-branch-protection
        """

        from ..models import (
            BasicError,
            ProtectedBranch,
            ReposOwnerRepoBranchesBranchProtectionPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionPutBodyType,
    ) -> Response[ProtectedBranch, ProtectedBranchType]: ...

    @overload
    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        required_status_checks: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredStatusChecksType,
            None,
        ],
        enforce_admins: Union[bool, None],
        required_pull_request_reviews: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRequiredPullRequestReviewsType,
            None,
        ],
        restrictions: Union[
            ReposOwnerRepoBranchesBranchProtectionPutBodyPropRestrictionsType, None
        ],
        required_linear_history: Missing[bool] = UNSET,
        allow_force_pushes: Missing[Union[bool, None]] = UNSET,
        allow_deletions: Missing[bool] = UNSET,
        block_creations: Missing[bool] = UNSET,
        required_conversation_resolution: Missing[bool] = UNSET,
        lock_branch: Missing[bool] = UNSET,
        allow_fork_syncing: Missing[bool] = UNSET,
    ) -> Response[ProtectedBranch, ProtectedBranchType]: ...

    async def async_update_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoBranchesBranchProtectionPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[ProtectedBranch, ProtectedBranchType]:
        """repos/update-branch-protection

        PUT /repos/{owner}/{repo}/branches/{branch}/protection

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Protecting a branch requires admin or owner permissions to the repository.

        > [!NOTE]
        > Passing new arrays of `users` and `teams` replaces their previous values.

        > [!NOTE]
        > The list of users, apps, and teams in total is limited to 100 items.

        See also: https://docs.github.com/rest/branches/branch-protection#update-branch-protection
        """

        from ..models import (
            BasicError,
            ProtectedBranch,
            ReposOwnerRepoBranchesBranchProtectionPutBody,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranch,
            error_models={
                "403": BasicError,
                "422": ValidationErrorSimple,
                "404": BasicError,
            },
        )

    def delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-branch-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-branch-protection
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    async def async_delete_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-branch-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-branch-protection
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
            },
        )

    def get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """repos/get-admin-branch-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-admin-branch-protection
        """

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_get_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """repos/get-admin-branch-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-admin-branch-protection
        """

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchAdminEnforced,
        )

    def set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """repos/set-admin-branch-protection

        POST /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.

        See also: https://docs.github.com/rest/branches/branch-protection#set-admin-branch-protection
        """

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchAdminEnforced,
        )

    async def async_set_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """repos/set-admin-branch-protection

        POST /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.

        See also: https://docs.github.com/rest/branches/branch-protection#set-admin-branch-protection
        """

        from ..models import ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchAdminEnforced,
        )

    def delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-admin-branch-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-admin-branch-protection
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_admin_branch_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-admin-branch-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-admin-branch-protection
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]:
        """repos/get-pull-request-review-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-pull-request-review-protection
        """

        from ..models import ProtectedBranchPullRequestReview

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchPullRequestReview,
        )

    async def async_get_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]:
        """repos/get-pull-request-review-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-pull-request-review-protection
        """

        from ..models import ProtectedBranchPullRequestReview

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchPullRequestReview,
        )

    def delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-pull-request-review-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-pull-request-review-protection
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-pull-request-review-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-pull-request-review-protection
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]: ...

    @overload
    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        dismissal_restrictions: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType
        ] = UNSET,
        dismiss_stale_reviews: Missing[bool] = UNSET,
        require_code_owner_reviews: Missing[bool] = UNSET,
        required_approving_review_count: Missing[int] = UNSET,
        require_last_push_approval: Missing[bool] = UNSET,
        bypass_pull_request_allowances: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType
        ] = UNSET,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]: ...

    def update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]:
        """repos/update-pull-request-review-protection

        PATCH /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.

        > [!NOTE]
        > Passing new arrays of `users` and `teams` replaces their previous values.

        See also: https://docs.github.com/rest/branches/branch-protection#update-pull-request-review-protection
        """

        from ..models import (
            ProtectedBranchPullRequestReview,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]: ...

    @overload
    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        dismissal_restrictions: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropDismissalRestrictionsType
        ] = UNSET,
        dismiss_stale_reviews: Missing[bool] = UNSET,
        require_code_owner_reviews: Missing[bool] = UNSET,
        required_approving_review_count: Missing[int] = UNSET,
        require_last_push_approval: Missing[bool] = UNSET,
        bypass_pull_request_allowances: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyPropBypassPullRequestAllowancesType
        ] = UNSET,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]: ...

    async def async_update_pull_request_review_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[
        ProtectedBranchPullRequestReview, ProtectedBranchPullRequestReviewType
    ]:
        """repos/update-pull-request-review-protection

        PATCH /repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.

        > [!NOTE]
        > Passing new arrays of `users` and `teams` replaces their previous values.

        See also: https://docs.github.com/rest/branches/branch-protection#update-pull-request-review-protection
        """

        from ..models import (
            ProtectedBranchPullRequestReview,
            ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRequiredPullRequestReviewsPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchPullRequestReview,
            error_models={
                "422": ValidationError,
            },
        )

    def get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """repos/get-commit-signature-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://docs.github.com/articles/signing-commits-with-gpg) in GitHub Help.

        > [!NOTE]
        > You must enable branch protection to require signed commits.

        See also: https://docs.github.com/rest/branches/branch-protection#get-commit-signature-protection
        """

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """repos/get-commit-signature-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://docs.github.com/articles/signing-commits-with-gpg) in GitHub Help.

        > [!NOTE]
        > You must enable branch protection to require signed commits.

        See also: https://docs.github.com/rest/branches/branch-protection#get-commit-signature-protection
        """

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """repos/create-commit-signature-protection

        POST /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.

        See also: https://docs.github.com/rest/branches/branch-protection#create-commit-signature-protection
        """

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    async def async_create_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ProtectedBranchAdminEnforced, ProtectedBranchAdminEnforcedType]:
        """repos/create-commit-signature-protection

        POST /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.

        See also: https://docs.github.com/rest/branches/branch-protection#create-commit-signature-protection
        """

        from ..models import BasicError, ProtectedBranchAdminEnforced

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ProtectedBranchAdminEnforced,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-commit-signature-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-commit-signature-protection
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_signature_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-commit-signature-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_signatures

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-commit-signature-protection
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]:
        """repos/get-status-checks-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-status-checks-protection
        """

        from ..models import BasicError, StatusCheckPolicy

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_status_checks_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]:
        """repos/get-status-checks-protection

        GET /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-status-checks-protection
        """

        from ..models import BasicError, StatusCheckPolicy

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/remove-status-check-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#remove-status-check-protection
        """

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_remove_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/remove-status-check-protection

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#remove-status-check-protection
        """

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]: ...

    @overload
    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        strict: Missing[bool] = UNSET,
        contexts: Missing[list[str]] = UNSET,
        checks: Missing[
            list[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ]
        ] = UNSET,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]: ...

    def update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]:
        """repos/update-status-check-protection

        PATCH /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.

        See also: https://docs.github.com/rest/branches/branch-protection#update-status-check-protection
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
            StatusCheckPolicy,
            ValidationError,
        )

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]: ...

    @overload
    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        strict: Missing[bool] = UNSET,
        contexts: Missing[list[str]] = UNSET,
        checks: Missing[
            list[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyPropChecksItemsType
            ]
        ] = UNSET,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]: ...

    async def async_update_status_check_protection(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[StatusCheckPolicy, StatusCheckPolicyType]:
        """repos/update-status-check-protection

        PATCH /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.

        See also: https://docs.github.com/rest/branches/branch-protection#update-status-check-protection
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
            StatusCheckPolicy,
            ValidationError,
        )

        url = (
            f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks"
        )

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksPatchBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=StatusCheckPolicy,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[str], list[str]]:
        """repos/get-all-status-check-contexts

        GET /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-all-status-check-contexts
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[str],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[str], list[str]]:
        """repos/get-all-status-check-contexts

        GET /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#get-all-status-check-contexts
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[str],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    def set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """repos/set-status-check-contexts

        PUT /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#set-status-check-contexts
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    async def async_set_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """repos/set-status-check-contexts

        PUT /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#set-status-check-contexts
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPutBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[str],
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    def add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """repos/add-status-check-contexts

        POST /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#add-status-check-contexts
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    async def async_add_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """repos/add-status-check-contexts

        POST /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#add-status-check-contexts
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsPostBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[str],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    def remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """repos/remove-status-check-contexts

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#remove-status-check-contexts
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[str], list[str]]: ...

    @overload
    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        contexts: list[str],
    ) -> Response[list[str], list[str]]: ...

    async def async_remove_status_check_contexts(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[str], list[str]]:
        """repos/remove-status-check-contexts

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        See also: https://docs.github.com/rest/branches/branch-protection#remove-status-check-contexts
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRequiredStatusChecksContextsDeleteBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[str],
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BranchRestrictionPolicy, BranchRestrictionPolicyType]:
        """repos/get-access-restrictions

        GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists who has access to this protected branch.

        > [!NOTE]
        > Users, apps, and teams `restrictions` are only available for organization-owned repositories.

        See also: https://docs.github.com/rest/branches/branch-protection#get-access-restrictions
        """

        from ..models import BasicError, BranchRestrictionPolicy

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[BranchRestrictionPolicy, BranchRestrictionPolicyType]:
        """repos/get-access-restrictions

        GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists who has access to this protected branch.

        > [!NOTE]
        > Users, apps, and teams `restrictions` are only available for organization-owned repositories.

        See also: https://docs.github.com/rest/branches/branch-protection#get-access-restrictions
        """

        from ..models import BasicError, BranchRestrictionPolicy

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BranchRestrictionPolicy,
            error_models={
                "404": BasicError,
            },
        )

    def delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-access-restrictions

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Disables the ability to restrict who can push to this branch.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-access-restrictions
        """

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-access-restrictions

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Disables the ability to restrict who can push to this branch.

        See also: https://docs.github.com/rest/branches/branch-protection#delete-access-restrictions
        """

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """repos/get-apps-with-access-to-protected-branch

        GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists the GitHub Apps that have push access to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.

        See also: https://docs.github.com/rest/branches/branch-protection#get-apps-with-access-to-the-protected-branch
        """

        from typing import Union

        from ..models import BasicError, Integration

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[Integration, None]],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_apps_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """repos/get-apps-with-access-to-protected-branch

        GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists the GitHub Apps that have push access to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.

        See also: https://docs.github.com/rest/branches/branch-protection#get-apps-with-access-to-the-protected-branch
        """

        from typing import Union

        from ..models import BasicError, Integration

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[Integration, None]],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    def set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """repos/set-app-access-restrictions

        PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.

        See also: https://docs.github.com/rest/branches/branch-protection#set-app-access-restrictions
        """

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    async def async_set_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """repos/set-app-access-restrictions

        PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.

        See also: https://docs.github.com/rest/branches/branch-protection#set-app-access-restrictions
        """

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    def add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """repos/add-app-access-restrictions

        POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Grants the specified apps push access for this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.

        See also: https://docs.github.com/rest/branches/branch-protection#add-app-access-restrictions
        """

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    async def async_add_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """repos/add-app-access-restrictions

        POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Grants the specified apps push access for this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.

        See also: https://docs.github.com/rest/branches/branch-protection#add-app-access-restrictions
        """

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    def remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """repos/remove-app-access-restrictions

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Removes the ability of an app to push to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.

        See also: https://docs.github.com/rest/branches/branch-protection#remove-app-access-restrictions
        """

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType,
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    @overload
    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        apps: list[str],
    ) -> Response[
        list[Union[Integration, None]], list[Union[IntegrationType, None]]
    ]: ...

    async def async_remove_app_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Union[Integration, None]], list[Union[IntegrationType, None]]]:
        """repos/remove-app-access-restrictions

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Removes the ability of an app to push to this branch. Only GitHub Apps that are installed on the repository and that have been granted write access to the repository contents can be added as authorized actors on a protected branch.

        See also: https://docs.github.com/rest/branches/branch-protection#remove-app-access-restrictions
        """

        from typing import Union

        from ..models import (
            Integration,
            ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsAppsDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Union[Integration, None]],
            error_models={
                "422": ValidationError,
            },
        )

    def get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/get-teams-with-access-to-protected-branch

        GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists the teams who have push access to this branch. The list includes child teams.

        See also: https://docs.github.com/rest/branches/branch-protection#get-teams-with-access-to-the-protected-branch
        """

        from ..models import BasicError, Team

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_teams_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/get-teams-with-access-to-protected-branch

        GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists the teams who have push access to this branch. The list includes child teams.

        See also: https://docs.github.com/rest/branches/branch-protection#get-teams-with-access-to-the-protected-branch
        """

        from ..models import BasicError, Team

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    def set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/set-team-access-restrictions

        PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.

        See also: https://docs.github.com/rest/branches/branch-protection#set-team-access-restrictions
        """

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    async def async_set_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/set-team-access-restrictions

        PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.

        See also: https://docs.github.com/rest/branches/branch-protection#set-team-access-restrictions
        """

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPutBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    def add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/add-team-access-restrictions

        POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Grants the specified teams push access for this branch. You can also give push access to child teams.

        See also: https://docs.github.com/rest/branches/branch-protection#add-team-access-restrictions
        """

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    async def async_add_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/add-team-access-restrictions

        POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Grants the specified teams push access for this branch. You can also give push access to child teams.

        See also: https://docs.github.com/rest/branches/branch-protection#add-team-access-restrictions
        """

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsPostBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    def remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/remove-team-access-restrictions

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Removes the ability of a team to push to this branch. You can also remove push access for child teams.

        See also: https://docs.github.com/rest/branches/branch-protection#remove-team-access-restrictions
        """

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
    ) -> Response[list[Team], list[TeamType]]: ...

    @overload
    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        teams: list[str],
    ) -> Response[list[Team], list[TeamType]]: ...

    async def async_remove_team_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0Type,
                list[str],
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/remove-team-access-restrictions

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Removes the ability of a team to push to this branch. You can also remove push access for child teams.

        See also: https://docs.github.com/rest/branches/branch-protection#remove-team-access-restrictions
        """

        from typing import Union

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
            Team,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoBranchesBranchProtectionRestrictionsTeamsDeleteBodyOneof0,
                    list[str],
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "422": ValidationError,
            },
        )

    def get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """repos/get-users-with-access-to-protected-branch

        GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists the people who have push access to this branch.

        See also: https://docs.github.com/rest/branches/branch-protection#get-users-with-access-to-the-protected-branch
        """

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_users_with_access_to_protected_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """repos/get-users-with-access-to-protected-branch

        GET /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Lists the people who have push access to this branch.

        See also: https://docs.github.com/rest/branches/branch-protection#get-users-with-access-to-the-protected-branch
        """

        from ..models import BasicError, SimpleUser

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    def set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """repos/set-user-access-restrictions

        PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.

        | Type    | Description                                                                                                                   |
        | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
        | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |

        See also: https://docs.github.com/rest/branches/branch-protection#set-user-access-restrictions
        """

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    async def async_set_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """repos/set-user-access-restrictions

        PUT /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.

        | Type    | Description                                                                                                                   |
        | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
        | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |

        See also: https://docs.github.com/rest/branches/branch-protection#set-user-access-restrictions
        """

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    def add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """repos/add-user-access-restrictions

        POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Grants the specified people push access for this branch.

        | Type    | Description                                                                                                                   |
        | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
        | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |

        See also: https://docs.github.com/rest/branches/branch-protection#add-user-access-restrictions
        """

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    async def async_add_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """repos/add-user-access-restrictions

        POST /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Grants the specified people push access for this branch.

        | Type    | Description                                                                                                                   |
        | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
        | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |

        See also: https://docs.github.com/rest/branches/branch-protection#add-user-access-restrictions
        """

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    def remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """repos/remove-user-access-restrictions

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Removes the ability of a user to push to this branch.

        | Type    | Description                                                                                                                                   |
        | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
        | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |

        See also: https://docs.github.com/rest/branches/branch-protection#remove-user-access-restrictions
        """

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    @overload
    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        users: list[str],
    ) -> Response[list[SimpleUser], list[SimpleUserType]]: ...

    async def async_remove_user_access_restrictions(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[list[SimpleUser], list[SimpleUserType]]:
        """repos/remove-user-access-restrictions

        DELETE /repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Removes the ability of a user to push to this branch.

        | Type    | Description                                                                                                                                   |
        | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
        | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |

        See also: https://docs.github.com/rest/branches/branch-protection#remove-user-access-restrictions
        """

        from ..models import (
            ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBody,
            SimpleUser,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchProtectionRestrictionsUsersDeleteBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[SimpleUser],
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]: ...

    @overload
    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        new_name: str,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]: ...

    def rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]:
        """repos/rename-branch

        POST /repos/{owner}/{repo}/branches/{branch}/rename

        Renames a branch in a repository.

        > [!NOTE]
        > Although the API responds immediately, the branch rename process might take some extra time to complete in the background. You won't be able to push to the old branch name while the rename process is in progress. For more information, see "[Renaming a branch](https://docs.github.com/github/administering-a-repository/renaming-a-branch)".

        The authenticated user must have push access to the branch. If the branch is the default branch, the authenticated user must also have admin or owner permissions.

        In order to rename the default branch, fine-grained access tokens also need the `administration:write` repository permission.

        See also: https://docs.github.com/rest/branches/branches#rename-a-branch
        """

        from ..models import (
            BasicError,
            BranchWithProtection,
            ReposOwnerRepoBranchesBranchRenamePostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchRenamePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoBranchesBranchRenamePostBodyType,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]: ...

    @overload
    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        new_name: str,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]: ...

    async def async_rename_branch(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoBranchesBranchRenamePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[BranchWithProtection, BranchWithProtectionType]:
        """repos/rename-branch

        POST /repos/{owner}/{repo}/branches/{branch}/rename

        Renames a branch in a repository.

        > [!NOTE]
        > Although the API responds immediately, the branch rename process might take some extra time to complete in the background. You won't be able to push to the old branch name while the rename process is in progress. For more information, see "[Renaming a branch](https://docs.github.com/github/administering-a-repository/renaming-a-branch)".

        The authenticated user must have push access to the branch. If the branch is the default branch, the authenticated user must also have admin or owner permissions.

        In order to rename the default branch, fine-grained access tokens also need the `administration:write` repository permission.

        See also: https://docs.github.com/rest/branches/branches#rename-a-branch
        """

        from ..models import (
            BasicError,
            BranchWithProtection,
            ReposOwnerRepoBranchesBranchRenamePostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/branches/{branch}/rename"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoBranchesBranchRenamePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=BranchWithProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def codeowners_errors(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodeownersErrors, CodeownersErrorsType]:
        """repos/codeowners-errors

        GET /repos/{owner}/{repo}/codeowners/errors

        List any syntax errors that are detected in the CODEOWNERS
        file.

        For more information about the correct CODEOWNERS syntax,
        see "[About code owners](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/about-code-owners)."

        See also: https://docs.github.com/rest/repos/repos#list-codeowners-errors
        """

        from ..models import CodeownersErrors

        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodeownersErrors,
            error_models={},
        )

    async def async_codeowners_errors(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CodeownersErrors, CodeownersErrorsType]:
        """repos/codeowners-errors

        GET /repos/{owner}/{repo}/codeowners/errors

        List any syntax errors that are detected in the CODEOWNERS
        file.

        For more information about the correct CODEOWNERS syntax,
        see "[About code owners](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/about-code-owners)."

        See also: https://docs.github.com/rest/repos/repos#list-codeowners-errors
        """

        from ..models import CodeownersErrors

        url = f"/repos/{owner}/{repo}/codeowners/errors"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CodeownersErrors,
            error_models={},
        )

    def list_collaborators(
        self,
        owner: str,
        repo: str,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        permission: Missing[
            Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Collaborator], list[CollaboratorType]]:
        """repos/list-collaborators

        GET /repos/{owner}/{repo}/collaborators

        For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
        The `permissions` hash returned in the response contains the base role permissions of the collaborator. The `role_name` is the highest role assigned to the collaborator after considering all sources of grants, including: repo, teams, organization, and enterprise.
        There is presently not a way to differentiate between an organization level grant and a repository level grant from this endpoint response.

        Team members will include the members of child teams.

        The authenticated user must have write, maintain, or admin privileges on the repository to use this endpoint. For organization-owned repositories, the authenticated user needs to be a member of the organization.
        OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.

        See also: https://docs.github.com/rest/collaborators/collaborators#list-repository-collaborators
        """

        from ..models import BasicError, Collaborator

        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_collaborators(
        self,
        owner: str,
        repo: str,
        *,
        affiliation: Missing[Literal["outside", "direct", "all"]] = UNSET,
        permission: Missing[
            Literal["pull", "triage", "push", "maintain", "admin"]
        ] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Collaborator], list[CollaboratorType]]:
        """repos/list-collaborators

        GET /repos/{owner}/{repo}/collaborators

        For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
        The `permissions` hash returned in the response contains the base role permissions of the collaborator. The `role_name` is the highest role assigned to the collaborator after considering all sources of grants, including: repo, teams, organization, and enterprise.
        There is presently not a way to differentiate between an organization level grant and a repository level grant from this endpoint response.

        Team members will include the members of child teams.

        The authenticated user must have write, maintain, or admin privileges on the repository to use this endpoint. For organization-owned repositories, the authenticated user needs to be a member of the organization.
        OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.

        See also: https://docs.github.com/rest/collaborators/collaborators#list-repository-collaborators
        """

        from ..models import BasicError, Collaborator

        url = f"/repos/{owner}/{repo}/collaborators"

        params = {
            "affiliation": affiliation,
            "permission": permission,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Collaborator],
            error_models={
                "404": BasicError,
            },
        )

    def check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/check-collaborator

        GET /repos/{owner}/{repo}/collaborators/{username}

        For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.

        Team members will include the members of child teams.

        The authenticated user must have push access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.

        See also: https://docs.github.com/rest/collaborators/collaborators#check-if-a-user-is-a-repository-collaborator
        """

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_check_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/check-collaborator

        GET /repos/{owner}/{repo}/collaborators/{username}

        For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.

        Team members will include the members of child teams.

        The authenticated user must have push access to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `read:org` and `repo` scopes to use this endpoint.

        See also: https://docs.github.com/rest/collaborators/collaborators#check-if-a-user-is-a-repository-collaborator
        """

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    @overload
    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permission: Missing[str] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    def add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]:
        """repos/add-collaborator

        PUT /repos/{owner}/{repo}/collaborators/{username}

        Add a user to a repository with a specified level of access. If the repository is owned by an organization, this API does not add the user to the organization - a user that has repository access without being an organization member is called an "outside collaborator" (if they are not an Enterprise Managed User) or a "repository collaborator" if they are an Enterprise Managed User. These users are exempt from some organization policies - see "[Adding outside collaborators to repositories](https://docs.github.com/organizations/managing-user-access-to-your-organizations-repositories/managing-outside-collaborators/adding-outside-collaborators-to-repositories-in-your-organization)" to learn more about these collaborator types.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).

        Adding an outside collaborator may be restricted by enterprise and organization administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)" and "[Setting permissions for adding outside collaborators](https://docs.github.com/organizations/managing-organization-settings/setting-permissions-for-adding-outside-collaborators)" for organization settings.

        For more information on permission levels, see "[Repository permission levels for an organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)". There are restrictions on which permissions can be granted to organization members when an organization base role is in place. In this case, the role being given must be equal to or higher than the org base permission. Otherwise, the request will fail with:

        ```
        Cannot assign {member} permission of {role name}
        ```

        Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."

        The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [API](https://docs.github.com/rest/collaborators/invitations).

        For Enterprise Managed Users, this endpoint does not send invitations - these users are automatically added to organizations and repositories. Enterprise Managed Users can only be added to organizations and repositories within their enterprise.

        **Updating an existing collaborator's permission level**

        The endpoint can also be used to change the permissions of an existing collaborator without first removing and re-adding the collaborator. To change the permissions, use the same endpoint and pass a different `permission` parameter. The response will be a `204`, with no other indication that the permission level changed.

        **Rate limits**

        You are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.

        See also: https://docs.github.com/rest/collaborators/collaborators#add-a-repository-collaborator
        """

        from ..models import (
            BasicError,
            RepositoryInvitation,
            ReposOwnerRepoCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCollaboratorsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    @overload
    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permission: Missing[str] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    async def async_add_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCollaboratorsUsernamePutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]:
        """repos/add-collaborator

        PUT /repos/{owner}/{repo}/collaborators/{username}

        Add a user to a repository with a specified level of access. If the repository is owned by an organization, this API does not add the user to the organization - a user that has repository access without being an organization member is called an "outside collaborator" (if they are not an Enterprise Managed User) or a "repository collaborator" if they are an Enterprise Managed User. These users are exempt from some organization policies - see "[Adding outside collaborators to repositories](https://docs.github.com/organizations/managing-user-access-to-your-organizations-repositories/managing-outside-collaborators/adding-outside-collaborators-to-repositories-in-your-organization)" to learn more about these collaborator types.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications).

        Adding an outside collaborator may be restricted by enterprise and organization administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)" and "[Setting permissions for adding outside collaborators](https://docs.github.com/organizations/managing-organization-settings/setting-permissions-for-adding-outside-collaborators)" for organization settings.

        For more information on permission levels, see "[Repository permission levels for an organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)". There are restrictions on which permissions can be granted to organization members when an organization base role is in place. In this case, the role being given must be equal to or higher than the org base permission. Otherwise, the request will fail with:

        ```
        Cannot assign {member} permission of {role name}
        ```

        Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP method](https://docs.github.com/rest/guides/getting-started-with-the-rest-api#http-method)."

        The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [API](https://docs.github.com/rest/collaborators/invitations).

        For Enterprise Managed Users, this endpoint does not send invitations - these users are automatically added to organizations and repositories. Enterprise Managed Users can only be added to organizations and repositories within their enterprise.

        **Updating an existing collaborator's permission level**

        The endpoint can also be used to change the permissions of an existing collaborator without first removing and re-adding the collaborator. To change the permissions, use the same endpoint and pass a different `permission` parameter. The response will be a `204`, with no other indication that the permission level changed.

        **Rate limits**

        You are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.

        See also: https://docs.github.com/rest/collaborators/collaborators#add-a-repository-collaborator
        """

        from ..models import (
            BasicError,
            RepositoryInvitation,
            ReposOwnerRepoCollaboratorsUsernamePutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCollaboratorsUsernamePutBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryInvitation,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/remove-collaborator

        DELETE /repos/{owner}/{repo}/collaborators/{username}

        Removes a collaborator from a repository.

        To use this endpoint, the authenticated user must either be an administrator of the repository or target themselves for removal.

        This endpoint also:
        - Cancels any outstanding invitations sent by the collaborator
        - Unassigns the user from any issues
        - Removes access to organization projects if the user is not an organization member and is not a collaborator on any other organization repositories.
        - Unstars the repository
        - Updates access permissions to packages

        Removing a user as a collaborator has the following effects on forks:
         - If the user had access to a fork through their membership to this repository, the user will also be removed from the fork.
         - If the user had their own fork of the repository, the fork will be deleted.
         - If the user still has read access to the repository, open pull requests by this user from a fork will be denied.

        > [!NOTE]
        > A user can still have access to the repository through organization permissions like base repository permissions.

        Although the API responds immediately, the additional permission updates might take some extra time to complete in the background.

        For more information on fork permissions, see "[About permissions and visibility of forks](https://docs.github.com/pull-requests/collaborating-with-pull-requests/working-with-forks/about-permissions-and-visibility-of-forks)".

        See also: https://docs.github.com/rest/collaborators/collaborators#remove-a-repository-collaborator
        """

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    async def async_remove_collaborator(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/remove-collaborator

        DELETE /repos/{owner}/{repo}/collaborators/{username}

        Removes a collaborator from a repository.

        To use this endpoint, the authenticated user must either be an administrator of the repository or target themselves for removal.

        This endpoint also:
        - Cancels any outstanding invitations sent by the collaborator
        - Unassigns the user from any issues
        - Removes access to organization projects if the user is not an organization member and is not a collaborator on any other organization repositories.
        - Unstars the repository
        - Updates access permissions to packages

        Removing a user as a collaborator has the following effects on forks:
         - If the user had access to a fork through their membership to this repository, the user will also be removed from the fork.
         - If the user had their own fork of the repository, the fork will be deleted.
         - If the user still has read access to the repository, open pull requests by this user from a fork will be denied.

        > [!NOTE]
        > A user can still have access to the repository through organization permissions like base repository permissions.

        Although the API responds immediately, the additional permission updates might take some extra time to complete in the background.

        For more information on fork permissions, see "[About permissions and visibility of forks](https://docs.github.com/pull-requests/collaborating-with-pull-requests/working-with-forks/about-permissions-and-visibility-of-forks)".

        See also: https://docs.github.com/rest/collaborators/collaborators#remove-a-repository-collaborator
        """

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/collaborators/{username}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        RepositoryCollaboratorPermission, RepositoryCollaboratorPermissionType
    ]:
        """repos/get-collaborator-permission-level

        GET /repos/{owner}/{repo}/collaborators/{username}/permission

        Checks the repository permission and role of a collaborator.

        The `permission` attribute provides the legacy base roles of `admin`, `write`, `read`, and `none`, where the
        `maintain` role is mapped to `write` and the `triage` role is mapped to `read`.
        The `role_name` attribute provides the name of the assigned role, including custom roles. The
        `permission` can also be used to determine which base level of access the collaborator has to the repository.

        The calculated permissions are the highest role assigned to the collaborator after considering all sources of grants, including: repo, teams, organization, and enterprise.
        There is presently not a way to differentiate between an organization level grant and a repository level grant from this endpoint response.

        See also: https://docs.github.com/rest/collaborators/collaborators#get-repository-permissions-for-a-user
        """

        from ..models import BasicError, RepositoryCollaboratorPermission

        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_collaborator_permission_level(
        self,
        owner: str,
        repo: str,
        username: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        RepositoryCollaboratorPermission, RepositoryCollaboratorPermissionType
    ]:
        """repos/get-collaborator-permission-level

        GET /repos/{owner}/{repo}/collaborators/{username}/permission

        Checks the repository permission and role of a collaborator.

        The `permission` attribute provides the legacy base roles of `admin`, `write`, `read`, and `none`, where the
        `maintain` role is mapped to `write` and the `triage` role is mapped to `read`.
        The `role_name` attribute provides the name of the assigned role, including custom roles. The
        `permission` can also be used to determine which base level of access the collaborator has to the repository.

        The calculated permissions are the highest role assigned to the collaborator after considering all sources of grants, including: repo, teams, organization, and enterprise.
        There is presently not a way to differentiate between an organization level grant and a repository level grant from this endpoint response.

        See also: https://docs.github.com/rest/collaborators/collaborators#get-repository-permissions-for-a-user
        """

        from ..models import BasicError, RepositoryCollaboratorPermission

        url = f"/repos/{owner}/{repo}/collaborators/{username}/permission"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryCollaboratorPermission,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CommitComment], list[CommitCommentType]]:
        """repos/list-commit-comments-for-repo

        GET /repos/{owner}/{repo}/comments

        Lists the commit comments for a specified repository. Comments are ordered by ascending ID.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#list-commit-comments-for-a-repository
        """

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CommitComment],
        )

    async def async_list_commit_comments_for_repo(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CommitComment], list[CommitCommentType]]:
        """repos/list-commit-comments-for-repo

        GET /repos/{owner}/{repo}/comments

        Lists the commit comments for a specified repository. Comments are ordered by ascending ID.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#list-commit-comments-for-a-repository
        """

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CommitComment],
        )

    def get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CommitComment, CommitCommentType]:
        """repos/get-commit-comment

        GET /repos/{owner}/{repo}/comments/{comment_id}

        Gets a specified commit comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#get-a-commit-comment
        """

        from ..models import BasicError, CommitComment

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CommitComment, CommitCommentType]:
        """repos/get-commit-comment

        GET /repos/{owner}/{repo}/comments/{comment_id}

        Gets a specified commit comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#get-a-commit-comment
        """

        from ..models import BasicError, CommitComment

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-commit-comment

        DELETE /repos/{owner}/{repo}/comments/{comment_id}

        See also: https://docs.github.com/rest/commits/comments#delete-a-commit-comment
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-commit-comment

        DELETE /repos/{owner}/{repo}/comments/{comment_id}

        See also: https://docs.github.com/rest/commits/comments#delete-a-commit-comment
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> Response[CommitComment, CommitCommentType]: ...

    @overload
    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[CommitComment, CommitCommentType]: ...

    def update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment, CommitCommentType]:
        """repos/update-commit-comment

        PATCH /repos/{owner}/{repo}/comments/{comment_id}

        Updates the contents of a specified commit comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#update-a-commit-comment
        """

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoCommentsCommentIdPatchBodyType,
    ) -> Response[CommitComment, CommitCommentType]: ...

    @overload
    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
    ) -> Response[CommitComment, CommitCommentType]: ...

    async def async_update_commit_comment(
        self,
        owner: str,
        repo: str,
        comment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCommentsCommentIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment, CommitCommentType]:
        """repos/update-commit-comment

        PATCH /repos/{owner}/{repo}/comments/{comment_id}

        Updates the contents of a specified commit comment.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#update-a-commit-comment
        """

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommentsCommentIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/comments/{comment_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoCommentsCommentIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommitComment,
            error_models={
                "404": BasicError,
            },
        )

    def list_commits(
        self,
        owner: str,
        repo: str,
        *,
        sha: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        author: Missing[str] = UNSET,
        committer: Missing[str] = UNSET,
        since: Missing[datetime] = UNSET,
        until: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Commit], list[CommitType]]:
        """repos/list-commits

        GET /repos/{owner}/{repo}/commits

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/rest/commits/commits#list-commits
        """

        from ..models import BasicError, Commit

        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "committer": committer,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_list_commits(
        self,
        owner: str,
        repo: str,
        *,
        sha: Missing[str] = UNSET,
        path: Missing[str] = UNSET,
        author: Missing[str] = UNSET,
        committer: Missing[str] = UNSET,
        since: Missing[datetime] = UNSET,
        until: Missing[datetime] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Commit], list[CommitType]]:
        """repos/list-commits

        GET /repos/{owner}/{repo}/commits

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/rest/commits/commits#list-commits
        """

        from ..models import BasicError, Commit

        url = f"/repos/{owner}/{repo}/commits"

        params = {
            "sha": sha,
            "path": path,
            "author": author,
            "committer": committer,
            "since": since,
            "until": until,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Commit],
            error_models={
                "500": BasicError,
                "400": BasicError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BranchShort], list[BranchShortType]]:
        """repos/list-branches-for-head-commit

        GET /repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.

        See also: https://docs.github.com/rest/commits/commits#list-branches-for-head-commit
        """

        from ..models import BasicError, BranchShort, ValidationError

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BranchShort],
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    async def async_list_branches_for_head_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[BranchShort], list[BranchShortType]]:
        """repos/list-branches-for-head-commit

        GET /repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head

        Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.

        Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.

        See also: https://docs.github.com/rest/commits/commits#list-branches-for-head-commit
        """

        from ..models import BasicError, BranchShort, ValidationError

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[BranchShort],
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CommitComment], list[CommitCommentType]]:
        """repos/list-comments-for-commit

        GET /repos/{owner}/{repo}/commits/{commit_sha}/comments

        Lists the comments for a specified commit.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#list-commit-comments
        """

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CommitComment],
        )

    async def async_list_comments_for_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CommitComment], list[CommitCommentType]]:
        """repos/list-comments-for-commit

        GET /repos/{owner}/{repo}/commits/{commit_sha}/comments

        Lists the comments for a specified commit.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#list-commit-comments
        """

        from ..models import CommitComment

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CommitComment],
        )

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> Response[CommitComment, CommitCommentType]: ...

    @overload
    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
        path: Missing[str] = UNSET,
        position: Missing[int] = UNSET,
        line: Missing[int] = UNSET,
    ) -> Response[CommitComment, CommitCommentType]: ...

    def create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment, CommitCommentType]:
        """repos/create-commit-comment

        POST /repos/{owner}/{repo}/commits/{commit_sha}/comments

        Create a comment for a commit using its `:commit_sha`.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#create-a-commit-comment
        """

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommitsCommitShaCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCommitsCommitShaCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoCommitsCommitShaCommentsPostBodyType,
    ) -> Response[CommitComment, CommitCommentType]: ...

    @overload
    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        body: str,
        path: Missing[str] = UNSET,
        position: Missing[int] = UNSET,
        line: Missing[int] = UNSET,
    ) -> Response[CommitComment, CommitCommentType]: ...

    async def async_create_commit_comment(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoCommitsCommitShaCommentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[CommitComment, CommitCommentType]:
        """repos/create-commit-comment

        POST /repos/{owner}/{repo}/commits/{commit_sha}/comments

        Create a comment for a commit using its `:commit_sha`.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github-commitcomment.raw+json`**: Returns the raw markdown body. Response will include `body`. This is the default if you do not pass any specific media type.
        - **`application/vnd.github-commitcomment.text+json`**: Returns a text only representation of the markdown body. Response will include `body_text`.
        - **`application/vnd.github-commitcomment.html+json`**: Returns HTML rendered from the body's markdown. Response will include `body_html`.
        - **`application/vnd.github-commitcomment.full+json`**: Returns raw, text, and HTML representations. Response will include `body`, `body_text`, and `body_html`.

        See also: https://docs.github.com/rest/commits/comments#create-a-commit-comment
        """

        from ..models import (
            BasicError,
            CommitComment,
            ReposOwnerRepoCommitsCommitShaCommentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/comments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoCommitsCommitShaCommentsPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommitComment,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestSimple], list[PullRequestSimpleType]]:
        """repos/list-pull-requests-associated-with-commit

        GET /repos/{owner}/{repo}/commits/{commit_sha}/pulls

        Lists the merged pull request that introduced the commit to the repository. If the commit is not present in the default branch, it will return merged and open pull requests associated with the commit.

        To list the open or merged pull requests associated with a branch, you can set the `commit_sha` parameter to the branch name.

        See also: https://docs.github.com/rest/commits/commits#list-pull-requests-associated-with-a-commit
        """

        from ..models import BasicError, PullRequestSimple

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestSimple],
            error_models={
                "409": BasicError,
            },
        )

    async def async_list_pull_requests_associated_with_commit(
        self,
        owner: str,
        repo: str,
        commit_sha: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PullRequestSimple], list[PullRequestSimpleType]]:
        """repos/list-pull-requests-associated-with-commit

        GET /repos/{owner}/{repo}/commits/{commit_sha}/pulls

        Lists the merged pull request that introduced the commit to the repository. If the commit is not present in the default branch, it will return merged and open pull requests associated with the commit.

        To list the open or merged pull requests associated with a branch, you can set the `commit_sha` parameter to the branch name.

        See also: https://docs.github.com/rest/commits/commits#list-pull-requests-associated-with-a-commit
        """

        from ..models import BasicError, PullRequestSimple

        url = f"/repos/{owner}/{repo}/commits/{commit_sha}/pulls"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PullRequestSimple],
            error_models={
                "409": BasicError,
            },
        )

    def get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Commit, CommitType]:
        """repos/get-commit

        GET /repos/{owner}/{repo}/commits/{ref}

        Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.

        > [!NOTE]
        > If there are more than 300 files in the commit diff and the default JSON media type is requested, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)." Pagination query parameters are not supported for these media types.

        - **`application/vnd.github.diff`**: Returns the diff of the commit. Larger diffs may time out and return a 5xx status code.
        - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property. Larger diffs may time out and return a 5xx status code.
        - **`application/vnd.github.sha`**: Returns the commit's SHA-1 hash. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/rest/commits/commits#get-a-commit
        """

        from ..models import (
            BasicError,
            Commit,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
                "409": BasicError,
            },
        )

    async def async_get_commit(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Commit, CommitType]:
        """repos/get-commit

        GET /repos/{owner}/{repo}/commits/{ref}

        Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.

        > [!NOTE]
        > If there are more than 300 files in the commit diff and the default JSON media type is requested, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)." Pagination query parameters are not supported for these media types.

        - **`application/vnd.github.diff`**: Returns the diff of the commit. Larger diffs may time out and return a 5xx status code.
        - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property. Larger diffs may time out and return a 5xx status code.
        - **`application/vnd.github.sha`**: Returns the commit's SHA-1 hash. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/rest/commits/commits#get-a-commit
        """

        from ..models import (
            BasicError,
            Commit,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/commits/{ref}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Commit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
                "409": BasicError,
            },
        )

    def get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CombinedCommitStatus, CombinedCommitStatusType]:
        """repos/get-combined-status-for-ref

        GET /repos/{owner}/{repo}/commits/{ref}/status

        Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.


        Additionally, a combined `state` is returned. The `state` is one of:

        *   **failure** if any of the contexts report as `error` or `failure`
        *   **pending** if there are no statuses or a context is `pending`
        *   **success** if the latest status for all contexts is `success`

        See also: https://docs.github.com/rest/commits/statuses#get-the-combined-status-for-a-specific-reference
        """

        from ..models import BasicError, CombinedCommitStatus

        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_combined_status_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CombinedCommitStatus, CombinedCommitStatusType]:
        """repos/get-combined-status-for-ref

        GET /repos/{owner}/{repo}/commits/{ref}/status

        Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.


        Additionally, a combined `state` is returned. The `state` is one of:

        *   **failure** if any of the contexts report as `error` or `failure`
        *   **pending** if there are no statuses or a context is `pending`
        *   **success** if the latest status for all contexts is `success`

        See also: https://docs.github.com/rest/commits/statuses#get-the-combined-status-for-a-specific-reference
        """

        from ..models import BasicError, CombinedCommitStatus

        url = f"/repos/{owner}/{repo}/commits/{ref}/status"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CombinedCommitStatus,
            error_models={
                "404": BasicError,
            },
        )

    def list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Status], list[StatusType]]:
        """repos/list-commit-statuses-for-ref

        GET /repos/{owner}/{repo}/commits/{ref}/statuses

        Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.

        This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.

        See also: https://docs.github.com/rest/commits/statuses#list-commit-statuses-for-a-reference
        """

        from ..models import Status

        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Status],
        )

    async def async_list_commit_statuses_for_ref(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Status], list[StatusType]]:
        """repos/list-commit-statuses-for-ref

        GET /repos/{owner}/{repo}/commits/{ref}/statuses

        Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.

        This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.

        See also: https://docs.github.com/rest/commits/statuses#list-commit-statuses-for-a-reference
        """

        from ..models import Status

        url = f"/repos/{owner}/{repo}/commits/{ref}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Status],
        )

    def get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CommunityProfile, CommunityProfileType]:
        r"""repos/get-community-profile-metrics

        GET /repos/{owner}/{repo}/community/profile

        Returns all community profile metrics for a repository. The repository cannot be a fork.

        The returned metrics include an overall health score, the repository description, the presence of documentation, the
        detected code of conduct, the detected license, and the presence of ISSUE\_TEMPLATE, PULL\_REQUEST\_TEMPLATE,
        README, and CONTRIBUTING files.

        The `health_percentage` score is defined as a percentage of how many of
        the recommended community health files are present. For more information, see
        "[About community profiles for public repositories](https://docs.github.com/communities/setting-up-your-project-for-healthy-contributions/about-community-profiles-for-public-repositories)."

        `content_reports_enabled` is only returned for organization-owned repositories.

        See also: https://docs.github.com/rest/metrics/community#get-community-profile-metrics
        """

        from ..models import CommunityProfile

        url = f"/repos/{owner}/{repo}/community/profile"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommunityProfile,
        )

    async def async_get_community_profile_metrics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CommunityProfile, CommunityProfileType]:
        r"""repos/get-community-profile-metrics

        GET /repos/{owner}/{repo}/community/profile

        Returns all community profile metrics for a repository. The repository cannot be a fork.

        The returned metrics include an overall health score, the repository description, the presence of documentation, the
        detected code of conduct, the detected license, and the presence of ISSUE\_TEMPLATE, PULL\_REQUEST\_TEMPLATE,
        README, and CONTRIBUTING files.

        The `health_percentage` score is defined as a percentage of how many of
        the recommended community health files are present. For more information, see
        "[About community profiles for public repositories](https://docs.github.com/communities/setting-up-your-project-for-healthy-contributions/about-community-profiles-for-public-repositories)."

        `content_reports_enabled` is only returned for organization-owned repositories.

        See also: https://docs.github.com/rest/metrics/community#get-community-profile-metrics
        """

        from ..models import CommunityProfile

        url = f"/repos/{owner}/{repo}/community/profile"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommunityProfile,
        )

    def compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CommitComparison, CommitComparisonType]:
        """repos/compare-commits

        GET /repos/{owner}/{repo}/compare/{basehead}

        Compares two commits against one another. You can compare refs (branches or tags) and commit SHAs in the same repository, or you can compare refs and commit SHAs that exist in different repositories within the same repository network, including fork branches. For more information about how to view a repository's network, see "[Understanding connections between repositories](https://docs.github.com/repositories/viewing-activity-and-data-for-your-repository/understanding-connections-between-repositories)."

        This endpoint is equivalent to running the `git log BASE..HEAD` command, but it returns commits in a different order. The `git log BASE..HEAD` command returns commits in reverse chronological order, whereas the API returns commits in chronological order.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.diff`**: Returns the diff of the commit.
        - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property.

        The API response includes details about the files that were changed between the two commits. This includes the status of the change (if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.

        When calling this endpoint without any paging parameter (`per_page` or `page`), the returned list is limited to 250 commits, and the last commit in the list is the most recent of the entire comparison.

        **Working with large comparisons**

        To process a response with a large number of commits, use a query parameter (`per_page` or `page`) to paginate the results. When using pagination:

        - The list of changed files is only shown on the first page of results, and it includes up to 300 changed files for the entire comparison.
        - The results are returned in chronological order, but the last commit in the returned list may not be the most recent one in the entire set if there are more pages of results.

        For more information on working with pagination, see "[Using pagination in the REST API](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api)."

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The `verification` object includes the following fields:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/rest/commits/commits#compare-two-commits
        """

        from ..models import (
            BasicError,
            CommitComparison,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    async def async_compare_commits(
        self,
        owner: str,
        repo: str,
        basehead: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CommitComparison, CommitComparisonType]:
        """repos/compare-commits

        GET /repos/{owner}/{repo}/compare/{basehead}

        Compares two commits against one another. You can compare refs (branches or tags) and commit SHAs in the same repository, or you can compare refs and commit SHAs that exist in different repositories within the same repository network, including fork branches. For more information about how to view a repository's network, see "[Understanding connections between repositories](https://docs.github.com/repositories/viewing-activity-and-data-for-your-repository/understanding-connections-between-repositories)."

        This endpoint is equivalent to running the `git log BASE..HEAD` command, but it returns commits in a different order. The `git log BASE..HEAD` command returns commits in reverse chronological order, whereas the API returns commits in chronological order.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.diff`**: Returns the diff of the commit.
        - **`application/vnd.github.patch`**: Returns the patch of the commit. Diffs with binary data will have no `patch` property.

        The API response includes details about the files that were changed between the two commits. This includes the status of the change (if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.

        When calling this endpoint without any paging parameter (`per_page` or `page`), the returned list is limited to 250 commits, and the last commit in the list is the most recent of the entire comparison.

        **Working with large comparisons**

        To process a response with a large number of commits, use a query parameter (`per_page` or `page`) to paginate the results. When using pagination:

        - The list of changed files is only shown on the first page of results, and it includes up to 300 changed files for the entire comparison.
        - The results are returned in chronological order, but the last commit in the returned list may not be the most recent one in the entire set if there are more pages of results.

        For more information on working with pagination, see "[Using pagination in the REST API](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api)."

        **Signature verification object**

        The response will include a `verification` object that describes the result of verifying the commit's signature. The `verification` object includes the following fields:

        | Name | Type | Description |
        | ---- | ---- | ----------- |
        | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
        | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
        | `signature` | `string` | The signature that was extracted from the commit. |
        | `payload` | `string` | The value that was signed. |
        | `verified_at` | `string` | The date the signature was verified by GitHub. |

        These are the possible values for `reason` in the `verification` object:

        | Value | Description |
        | ----- | ----------- |
        | `expired_key` | The key that made the signature is expired. |
        | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
        | `gpgverify_error` | There was an error communicating with the signature verification service. |
        | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
        | `unsigned` | The object does not include a signature. |
        | `unknown_signature_type` | A non-PGP signature was found in the commit. |
        | `no_user` | No user was associated with the `committer` email address in the commit. |
        | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on their account. |
        | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
        | `unknown_key` | The key that made the signature has not been registered with any user's account. |
        | `malformed_signature` | There was an error parsing the signature. |
        | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
        | `valid` | None of the above errors applied, so the signature is considered to be verified. |

        See also: https://docs.github.com/rest/commits/commits#compare-two-commits
        """

        from ..models import (
            BasicError,
            CommitComparison,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
        )

        url = f"/repos/{owner}/{repo}/compare/{basehead}"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CommitComparison,
            error_models={
                "404": BasicError,
                "500": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[
            list[ContentDirectoryItems], ContentFile, ContentSymlink, ContentSubmodule
        ],
        Union[
            list[ContentDirectoryItemsType],
            ContentFileType,
            ContentSymlinkType,
            ContentSubmoduleType,
        ],
    ]:
        """repos/get-content

        GET /repos/{owner}/{repo}/contents/{path}

        Gets the contents of a file or directory in a repository. Specify the file path or directory with the `path` parameter. If you omit the `path` parameter, you will receive the contents of the repository's root directory.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw file contents for files and symlinks.
        - **`application/vnd.github.html+json`**: Returns the file contents in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
        - **`application/vnd.github.object+json`**: Returns the contents in a consistent object format regardless of the content type. For example, instead of an array of objects for a directory, the response will be an object with an `entries` attribute containing the array of objects.

        If the content is a directory, the response will be an array of objects, one object for each item in the directory. When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value _should_ be "submodule". This behavior exists [for backwards compatibility purposes](https://git.io/v1YCW). In the next major version of the API, the type will be returned as "submodule".

        If the content is a symlink and the symlink's target is a normal file in the repository, then the API responds with the content of the file. Otherwise, the API responds with an object describing the symlink itself.

        If the content is a submodule, the `submodule_git_url` field identifies the location of the submodule repository, and the `sha` identifies a specific commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out the submodule at that specific commit. If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the github.com URLs (`html_url` and `_links["html"]`) will have null values.

        **Notes**:

        - To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/rest/git/trees#get-a-tree).
        - This API has an upper limit of 1,000 files for a directory. If you need to retrieve
        more files, use the [Git Trees API](https://docs.github.com/rest/git/trees#get-a-tree).
        - Download URLs expire and are meant to be used just once. To ensure the download URL does not expire, please use the contents API to obtain a fresh download URL for each download.
        - If the requested file's size is:
          - 1 MB or smaller: All features of this endpoint are supported.
          - Between 1-100 MB: Only the `raw` or `object` custom media types are supported. Both will work as normal, except that when using the `object` media type, the `content` field will be an empty
        string and the `encoding` field will be `"none"`. To get the contents of these larger files, use the `raw` media type.
          - Greater than 100 MB: This endpoint is not supported.

        See also: https://docs.github.com/rest/repos/contents#get-repository-content
        """

        from typing import Union

        from ..models import (
            BasicError,
            ContentDirectoryItems,
            ContentFile,
            ContentSubmodule,
            ContentSymlink,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[
                list[ContentDirectoryItems],
                ContentFile,
                ContentSymlink,
                ContentSubmodule,
            ],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_get_content(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        Union[
            list[ContentDirectoryItems], ContentFile, ContentSymlink, ContentSubmodule
        ],
        Union[
            list[ContentDirectoryItemsType],
            ContentFileType,
            ContentSymlinkType,
            ContentSubmoduleType,
        ],
    ]:
        """repos/get-content

        GET /repos/{owner}/{repo}/contents/{path}

        Gets the contents of a file or directory in a repository. Specify the file path or directory with the `path` parameter. If you omit the `path` parameter, you will receive the contents of the repository's root directory.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw file contents for files and symlinks.
        - **`application/vnd.github.html+json`**: Returns the file contents in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).
        - **`application/vnd.github.object+json`**: Returns the contents in a consistent object format regardless of the content type. For example, instead of an array of objects for a directory, the response will be an object with an `entries` attribute containing the array of objects.

        If the content is a directory, the response will be an array of objects, one object for each item in the directory. When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value _should_ be "submodule". This behavior exists [for backwards compatibility purposes](https://git.io/v1YCW). In the next major version of the API, the type will be returned as "submodule".

        If the content is a symlink and the symlink's target is a normal file in the repository, then the API responds with the content of the file. Otherwise, the API responds with an object describing the symlink itself.

        If the content is a submodule, the `submodule_git_url` field identifies the location of the submodule repository, and the `sha` identifies a specific commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out the submodule at that specific commit. If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the github.com URLs (`html_url` and `_links["html"]`) will have null values.

        **Notes**:

        - To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/rest/git/trees#get-a-tree).
        - This API has an upper limit of 1,000 files for a directory. If you need to retrieve
        more files, use the [Git Trees API](https://docs.github.com/rest/git/trees#get-a-tree).
        - Download URLs expire and are meant to be used just once. To ensure the download URL does not expire, please use the contents API to obtain a fresh download URL for each download.
        - If the requested file's size is:
          - 1 MB or smaller: All features of this endpoint are supported.
          - Between 1-100 MB: Only the `raw` or `object` custom media types are supported. Both will work as normal, except that when using the `object` media type, the `content` field will be an empty
        string and the `encoding` field will be `"none"`. To get the contents of these larger files, use the `raw` media type.
          - Greater than 100 MB: This endpoint is not supported.

        See also: https://docs.github.com/rest/repos/contents#get-repository-content
        """

        from typing import Union

        from ..models import (
            BasicError,
            ContentDirectoryItems,
            ContentFile,
            ContentSubmodule,
            ContentSymlink,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Union[
                list[ContentDirectoryItems],
                ContentFile,
                ContentSymlink,
                ContentSubmodule,
            ],
            error_models={
                "404": BasicError,
                "403": BasicError,
            },
        )

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> Response[FileCommit, FileCommitType]: ...

    @overload
    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        message: str,
        content: str,
        sha: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        committer: Missing[ReposOwnerRepoContentsPathPutBodyPropCommitterType] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit, FileCommitType]: ...

    def create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit, FileCommitType]:
        """repos/create-or-update-file-contents

        PUT /repos/{owner}/{repo}/contents/{path}

        Creates a new file or replaces an existing file in a repository.

        > [!NOTE]
        > If you use this endpoint and the "[Delete a file](https://docs.github.com/rest/repos/contents/#delete-a-file)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The `workflow` scope is also required in order to modify files in the `.github/workflows` directory.

        See also: https://docs.github.com/rest/repos/contents#create-or-update-file-contents
        """

        from typing import Union

        from ..models import (
            BasicError,
            FileCommit,
            RepositoryRuleViolationError,
            ReposOwnerRepoContentsPathPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoContentsPathPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": Union[BasicError, RepositoryRuleViolationError],
            },
        )

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoContentsPathPutBodyType,
    ) -> Response[FileCommit, FileCommitType]: ...

    @overload
    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        message: str,
        content: str,
        sha: Missing[str] = UNSET,
        branch: Missing[str] = UNSET,
        committer: Missing[ReposOwnerRepoContentsPathPutBodyPropCommitterType] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathPutBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit, FileCommitType]: ...

    async def async_create_or_update_file_contents(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoContentsPathPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit, FileCommitType]:
        """repos/create-or-update-file-contents

        PUT /repos/{owner}/{repo}/contents/{path}

        Creates a new file or replaces an existing file in a repository.

        > [!NOTE]
        > If you use this endpoint and the "[Delete a file](https://docs.github.com/rest/repos/contents/#delete-a-file)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint. The `workflow` scope is also required in order to modify files in the `.github/workflows` directory.

        See also: https://docs.github.com/rest/repos/contents#create-or-update-file-contents
        """

        from typing import Union

        from ..models import (
            BasicError,
            FileCommit,
            RepositoryRuleViolationError,
            ReposOwnerRepoContentsPathPutBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoContentsPathPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FileCommit,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "409": Union[BasicError, RepositoryRuleViolationError],
            },
        )

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> Response[FileCommit, FileCommitType]: ...

    @overload
    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        message: str,
        sha: str,
        branch: Missing[str] = UNSET,
        committer: Missing[
            ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathDeleteBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit, FileCommitType]: ...

    def delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit, FileCommitType]:
        """repos/delete-file

        DELETE /repos/{owner}/{repo}/contents/{path}

        Deletes a file in a repository.

        You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.

        The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.

        You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.

        > [!NOTE]
        > If you use this endpoint and the "[Create or update file contents](https://docs.github.com/rest/repos/contents/#create-or-update-file-contents)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.

        See also: https://docs.github.com/rest/repos/contents#delete-a-file
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            FileCommit,
            ReposOwnerRepoContentsPathDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoContentsPathDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoContentsPathDeleteBodyType,
    ) -> Response[FileCommit, FileCommitType]: ...

    @overload
    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        message: str,
        sha: str,
        branch: Missing[str] = UNSET,
        committer: Missing[
            ReposOwnerRepoContentsPathDeleteBodyPropCommitterType
        ] = UNSET,
        author: Missing[ReposOwnerRepoContentsPathDeleteBodyPropAuthorType] = UNSET,
    ) -> Response[FileCommit, FileCommitType]: ...

    async def async_delete_file(
        self,
        owner: str,
        repo: str,
        path: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoContentsPathDeleteBodyType] = UNSET,
        **kwargs,
    ) -> Response[FileCommit, FileCommitType]:
        """repos/delete-file

        DELETE /repos/{owner}/{repo}/contents/{path}

        Deletes a file in a repository.

        You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.

        The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.

        You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.

        > [!NOTE]
        > If you use this endpoint and the "[Create or update file contents](https://docs.github.com/rest/repos/contents/#create-or-update-file-contents)" endpoint in parallel, the concurrent requests will conflict and you will receive errors. You must use these endpoints serially instead.

        See also: https://docs.github.com/rest/repos/contents#delete-a-file
        """

        from ..models import (
            BasicError,
            EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            FileCommit,
            ReposOwnerRepoContentsPathDeleteBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/contents/{path}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoContentsPathDeleteBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "DELETE",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FileCommit,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
                "503": EnterprisesEnterpriseSecretScanningAlertsGetResponse503,
            },
        )

    def list_contributors(
        self,
        owner: str,
        repo: str,
        *,
        anon: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Contributor], list[ContributorType]]:
        """repos/list-contributors

        GET /repos/{owner}/{repo}/contributors

        Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API caches contributor data to improve performance.

        GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.

        See also: https://docs.github.com/rest/repos/repos#list-repository-contributors
        """

        from ..models import BasicError, Contributor

        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_contributors(
        self,
        owner: str,
        repo: str,
        *,
        anon: Missing[str] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Contributor], list[ContributorType]]:
        """repos/list-contributors

        GET /repos/{owner}/{repo}/contributors

        Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API caches contributor data to improve performance.

        GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.

        See also: https://docs.github.com/rest/repos/repos#list-repository-contributors
        """

        from ..models import BasicError, Contributor

        url = f"/repos/{owner}/{repo}/contributors"

        params = {
            "anon": anon,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Contributor],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_deployments(
        self,
        owner: str,
        repo: str,
        *,
        sha: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        task: Missing[str] = UNSET,
        environment: Missing[Union[str, None]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Deployment], list[DeploymentType]]:
        """repos/list-deployments

        GET /repos/{owner}/{repo}/deployments

        Simple filtering of deployments is available via query parameters:

        See also: https://docs.github.com/rest/deployments/deployments#list-deployments
        """

        from ..models import Deployment

        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Deployment],
        )

    async def async_list_deployments(
        self,
        owner: str,
        repo: str,
        *,
        sha: Missing[str] = UNSET,
        ref: Missing[str] = UNSET,
        task: Missing[str] = UNSET,
        environment: Missing[Union[str, None]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Deployment], list[DeploymentType]]:
        """repos/list-deployments

        GET /repos/{owner}/{repo}/deployments

        Simple filtering of deployments is available via query parameters:

        See also: https://docs.github.com/rest/deployments/deployments#list-deployments
        """

        from ..models import Deployment

        url = f"/repos/{owner}/{repo}/deployments"

        params = {
            "sha": sha,
            "ref": ref,
            "task": task,
            "environment": environment,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Deployment],
        )

    @overload
    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDeploymentsPostBodyType,
    ) -> Response[Deployment, DeploymentType]: ...

    @overload
    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ref: str,
        task: Missing[str] = UNSET,
        auto_merge: Missing[bool] = UNSET,
        required_contexts: Missing[list[str]] = UNSET,
        payload: Missing[
            Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        transient_environment: Missing[bool] = UNSET,
        production_environment: Missing[bool] = UNSET,
    ) -> Response[Deployment, DeploymentType]: ...

    def create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Deployment, DeploymentType]:
        """repos/create-deployment

        POST /repos/{owner}/{repo}/deployments

        Deployments offer a few configurable parameters with certain defaults.

        The `ref` parameter can be any named branch, tag, or SHA. At GitHub we often deploy branches and verify them
        before we merge a pull request.

        The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
        multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
        makes it easier to track which environments have requested deployments. The default environment is `production`.

        The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
        the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
        the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
        return a failure response.

        By default, [commit statuses](https://docs.github.com/rest/commits/statuses) for every submitted context must be in a `success`
        state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
        specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
        not require any contexts or create any commit statuses, the deployment will always succeed.

        The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
        field that will be passed on when a deployment event is dispatched.

        The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
        be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
        application with debugging enabled.

        Merged branch response:

        You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
        a deployment. This auto-merge happens when:
        *   Auto-merge option is enabled in the repository
        *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
        *   There are no merge conflicts

        If there are no new commits in the base branch, a new request to create a deployment should give a successful
        response.

        Merge conflict response:

        This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
        be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.

        Failed commit status checks:

        This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
        status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/deployments#create-a-deployment
        """

        from ..models import (
            Deployment,
            ReposOwnerRepoDeploymentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDeploymentsPostBodyType,
    ) -> Response[Deployment, DeploymentType]: ...

    @overload
    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        ref: str,
        task: Missing[str] = UNSET,
        auto_merge: Missing[bool] = UNSET,
        required_contexts: Missing[list[str]] = UNSET,
        payload: Missing[
            Union[ReposOwnerRepoDeploymentsPostBodyPropPayloadOneof0Type, str]
        ] = UNSET,
        environment: Missing[str] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        transient_environment: Missing[bool] = UNSET,
        production_environment: Missing[bool] = UNSET,
    ) -> Response[Deployment, DeploymentType]: ...

    async def async_create_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Deployment, DeploymentType]:
        """repos/create-deployment

        POST /repos/{owner}/{repo}/deployments

        Deployments offer a few configurable parameters with certain defaults.

        The `ref` parameter can be any named branch, tag, or SHA. At GitHub we often deploy branches and verify them
        before we merge a pull request.

        The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
        multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
        makes it easier to track which environments have requested deployments. The default environment is `production`.

        The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
        the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
        the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
        return a failure response.

        By default, [commit statuses](https://docs.github.com/rest/commits/statuses) for every submitted context must be in a `success`
        state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
        specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
        not require any contexts or create any commit statuses, the deployment will always succeed.

        The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
        field that will be passed on when a deployment event is dispatched.

        The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
        be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
        application with debugging enabled.

        Merged branch response:

        You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
        a deployment. This auto-merge happens when:
        *   Auto-merge option is enabled in the repository
        *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
        *   There are no merge conflicts

        If there are no new commits in the base branch, a new request to create a deployment should give a successful
        response.

        Merge conflict response:

        This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
        be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.

        Failed commit status checks:

        This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
        status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/deployments#create-a-deployment
        """

        from ..models import (
            Deployment,
            ReposOwnerRepoDeploymentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Deployment,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Deployment, DeploymentType]:
        """repos/get-deployment

        GET /repos/{owner}/{repo}/deployments/{deployment_id}

        See also: https://docs.github.com/rest/deployments/deployments#get-a-deployment
        """

        from ..models import BasicError, Deployment

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Deployment, DeploymentType]:
        """repos/get-deployment

        GET /repos/{owner}/{repo}/deployments/{deployment_id}

        See also: https://docs.github.com/rest/deployments/deployments#get-a-deployment
        """

        from ..models import BasicError, Deployment

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Deployment,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-deployment

        DELETE /repos/{owner}/{repo}/deployments/{deployment_id}

        If the repository only has one deployment, you can delete the deployment regardless of its status. If the repository has more than one deployment, you can only delete inactive deployments. This ensures that repositories with multiple deployments will always have an active deployment.

        To set a deployment as inactive, you must:

        *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
        *   Mark the active deployment as inactive by adding any non-successful deployment status.

        For more information, see "[Create a deployment](https://docs.github.com/rest/deployments/deployments/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/rest/deployments/statuses#create-a-deployment-status)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/deployments#delete-a-deployment
        """

        from ..models import BasicError, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    async def async_delete_deployment(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-deployment

        DELETE /repos/{owner}/{repo}/deployments/{deployment_id}

        If the repository only has one deployment, you can delete the deployment regardless of its status. If the repository has more than one deployment, you can only delete inactive deployments. This ensures that repositories with multiple deployments will always have an active deployment.

        To set a deployment as inactive, you must:

        *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
        *   Mark the active deployment as inactive by adding any non-successful deployment status.

        For more information, see "[Create a deployment](https://docs.github.com/rest/deployments/deployments/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/rest/deployments/statuses#create-a-deployment-status)."

        OAuth app tokens and personal access tokens (classic) need the `repo` or `repo_deployment` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/deployments#delete-a-deployment
        """

        from ..models import BasicError, ValidationErrorSimple

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[DeploymentStatus], list[DeploymentStatusType]]:
        """repos/list-deployment-statuses

        GET /repos/{owner}/{repo}/deployments/{deployment_id}/statuses

        Users with pull access can view deployment statuses for a deployment:

        See also: https://docs.github.com/rest/deployments/statuses#list-deployment-statuses
        """

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_deployment_statuses(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[DeploymentStatus], list[DeploymentStatusType]]:
        """repos/list-deployment-statuses

        GET /repos/{owner}/{repo}/deployments/{deployment_id}/statuses

        Users with pull access can view deployment statuses for a deployment:

        See also: https://docs.github.com/rest/deployments/statuses#list-deployment-statuses
        """

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DeploymentStatus],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> Response[DeploymentStatus, DeploymentStatusType]: ...

    @overload
    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Missing[str] = UNSET,
        log_url: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        environment_url: Missing[str] = UNSET,
        auto_inactive: Missing[bool] = UNSET,
    ) -> Response[DeploymentStatus, DeploymentStatusType]: ...

    def create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentStatus, DeploymentStatusType]:
        """repos/create-deployment-status

        POST /repos/{owner}/{repo}/deployments/{deployment_id}/statuses

        Users with `push` access can create deployment statuses for a given deployment.

        OAuth app tokens and personal access tokens (classic) need the `repo_deployment` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/statuses#create-a-deployment-status
        """

        from ..models import (
            DeploymentStatus,
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType,
    ) -> Response[DeploymentStatus, DeploymentStatusType]: ...

    @overload
    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal[
            "error",
            "failure",
            "inactive",
            "in_progress",
            "queued",
            "pending",
            "success",
        ],
        target_url: Missing[str] = UNSET,
        log_url: Missing[str] = UNSET,
        description: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        environment_url: Missing[str] = UNSET,
        auto_inactive: Missing[bool] = UNSET,
    ) -> Response[DeploymentStatus, DeploymentStatusType]: ...

    async def async_create_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentStatus, DeploymentStatusType]:
        """repos/create-deployment-status

        POST /repos/{owner}/{repo}/deployments/{deployment_id}/statuses

        Users with `push` access can create deployment statuses for a given deployment.

        OAuth app tokens and personal access tokens (classic) need the `repo_deployment` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/statuses#create-a-deployment-status
        """

        from ..models import (
            DeploymentStatus,
            ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoDeploymentsDeploymentIdStatusesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentStatus,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeploymentStatus, DeploymentStatusType]:
        """repos/get-deployment-status

        GET /repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}

        Users with pull access can view a deployment status for a deployment:

        See also: https://docs.github.com/rest/deployments/statuses#get-a-deployment-status
        """

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deployment_status(
        self,
        owner: str,
        repo: str,
        deployment_id: int,
        status_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeploymentStatus, DeploymentStatusType]:
        """repos/get-deployment-status

        GET /repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}

        Users with pull access can view a deployment status for a deployment:

        See also: https://docs.github.com/rest/deployments/statuses#get-a-deployment-status
        """

        from ..models import BasicError, DeploymentStatus

        url = f"/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        event_type: str,
        client_payload: Missing[
            ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> Response: ...

    def create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """repos/create-dispatch-event

        POST /repos/{owner}/{repo}/dispatches

        You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/webhooks/event-payloads/#repository_dispatch)."

        The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.

        This input example shows how you can use the `client_payload` as a test to debug your workflow.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/repos/repos#create-a-repository-dispatch-event
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoDispatchesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/dispatches"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoDispatchesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoDispatchesPostBodyType,
    ) -> Response: ...

    @overload
    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        event_type: str,
        client_payload: Missing[
            ReposOwnerRepoDispatchesPostBodyPropClientPayloadType
        ] = UNSET,
    ) -> Response: ...

    async def async_create_dispatch_event(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoDispatchesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """repos/create-dispatch-event

        POST /repos/{owner}/{repo}/dispatches

        You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/webhooks/event-payloads/#repository_dispatch)."

        The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.

        This input example shows how you can use the `client_payload` as a test to debug your workflow.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/repos/repos#create-a-repository-dispatch-event
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoDispatchesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/dispatches"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoDispatchesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_all_environments(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsGetResponse200,
        ReposOwnerRepoEnvironmentsGetResponse200Type,
    ]:
        """repos/get-all-environments

        GET /repos/{owner}/{repo}/environments

        Lists the environments for a repository.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/environments#list-environments
        """

        from ..models import ReposOwnerRepoEnvironmentsGetResponse200

        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    async def async_get_all_environments(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsGetResponse200,
        ReposOwnerRepoEnvironmentsGetResponse200Type,
    ]:
        """repos/get-all-environments

        GET /repos/{owner}/{repo}/environments

        Lists the environments for a repository.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/environments#list-environments
        """

        from ..models import ReposOwnerRepoEnvironmentsGetResponse200

        url = f"/repos/{owner}/{repo}/environments"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsGetResponse200,
        )

    def get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Environment, EnvironmentType]:
        """repos/get-environment

        GET /repos/{owner}/{repo}/environments/{environment_name}

        > [!NOTE]
        > To get information about name patterns that branches must match in order to deploy to this environment, see "[Get a deployment branch policy](/rest/deployments/branch-policies#get-a-deployment-branch-policy)."

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/environments#get-an-environment
        """

        from ..models import Environment

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Environment,
        )

    async def async_get_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Environment, EnvironmentType]:
        """repos/get-environment

        GET /repos/{owner}/{repo}/environments/{environment_name}

        > [!NOTE]
        > To get information about name patterns that branches must match in order to deploy to this environment, see "[Get a deployment branch policy](/rest/deployments/branch-policies#get-a-deployment-branch-policy)."

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/environments#get-an-environment
        """

        from ..models import Environment

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Environment,
        )

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> Response[Environment, EnvironmentType]: ...

    @overload
    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        wait_timer: Missing[int] = UNSET,
        prevent_self_review: Missing[bool] = UNSET,
        reviewers: Missing[
            Union[
                list[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ]
        ] = UNSET,
        deployment_branch_policy: Missing[
            Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> Response[Environment, EnvironmentType]: ...

    def create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[Environment, EnvironmentType]:
        """repos/create-or-update-environment

        PUT /repos/{owner}/{repo}/environments/{environment_name}

        Create or update an environment with protection rules, such as required reviewers. For more information about environment protection rules, see "[Environments](/actions/reference/environments#environment-protection-rules)."

        > [!NOTE]
        > To create or update name patterns that branches must match in order to deploy to this environment, see "[Deployment branch policies](/rest/deployments/branch-policies)."

        > [!NOTE]
        > To create or update secrets for an environment, see "[GitHub Actions secrets](/rest/actions/secrets)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/environments#create-or-update-an-environment
        """

        from typing import Union

        from ..models import (
            BasicError,
            Environment,
            ReposOwnerRepoEnvironmentsEnvironmentNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
    ) -> Response[Environment, EnvironmentType]: ...

    @overload
    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        wait_timer: Missing[int] = UNSET,
        prevent_self_review: Missing[bool] = UNSET,
        reviewers: Missing[
            Union[
                list[
                    ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyPropReviewersItemsType
                ],
                None,
            ]
        ] = UNSET,
        deployment_branch_policy: Missing[
            Union[DeploymentBranchPolicySettingsType, None]
        ] = UNSET,
    ) -> Response[Environment, EnvironmentType]: ...

    async def async_create_or_update_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBodyType, None]
        ] = UNSET,
        **kwargs,
    ) -> Response[Environment, EnvironmentType]:
        """repos/create-or-update-environment

        PUT /repos/{owner}/{repo}/environments/{environment_name}

        Create or update an environment with protection rules, such as required reviewers. For more information about environment protection rules, see "[Environments](/actions/reference/environments#environment-protection-rules)."

        > [!NOTE]
        > To create or update name patterns that branches must match in order to deploy to this environment, see "[Deployment branch policies](/rest/deployments/branch-policies)."

        > [!NOTE]
        > To create or update secrets for an environment, see "[GitHub Actions secrets](/rest/actions/secrets)."

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/environments#create-or-update-an-environment
        """

        from typing import Union

        from ..models import (
            BasicError,
            Environment,
            ReposOwnerRepoEnvironmentsEnvironmentNamePutBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[ReposOwnerRepoEnvironmentsEnvironmentNamePutBody, None], json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Environment,
            error_models={
                "422": BasicError,
            },
        )

    def delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-an-environment

        DELETE /repos/{owner}/{repo}/environments/{environment_name}

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/environments#delete-an-environment
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_an_environment(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-an-environment

        DELETE /repos/{owner}/{repo}/environments/{environment_name}

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/environments#delete-an-environment
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200Type,
    ]:
        """repos/list-deployment-branch-policies

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies

        Lists the deployment branch policies for an environment.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/branch-policies#list-deployment-branch-policies
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    async def async_list_deployment_branch_policies(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200Type,
    ]:
        """repos/list-deployment-branch-policies

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies

        Lists the deployment branch policies for an environment.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/branch-policies#list-deployment-branch-policies
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentBranchPoliciesGetResponse200,
        )

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: DeploymentBranchPolicyNamePatternWithTypeType,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    @overload
    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        type: Missing[Literal["branch", "tag"]] = UNSET,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    def create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[DeploymentBranchPolicyNamePatternWithTypeType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """repos/create-deployment-branch-policy

        POST /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies

        Creates a deployment branch or tag policy for an environment.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/branch-policies#create-a-deployment-branch-policy
        """

        from ..models import (
            DeploymentBranchPolicy,
            DeploymentBranchPolicyNamePatternWithType,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(DeploymentBranchPolicyNamePatternWithType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: DeploymentBranchPolicyNamePatternWithTypeType,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    @overload
    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        type: Missing[Literal["branch", "tag"]] = UNSET,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    async def async_create_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[DeploymentBranchPolicyNamePatternWithTypeType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """repos/create-deployment-branch-policy

        POST /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies

        Creates a deployment branch or tag policy for an environment.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/branch-policies#create-a-deployment-branch-policy
        """

        from ..models import (
            DeploymentBranchPolicy,
            DeploymentBranchPolicyNamePatternWithType,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(DeploymentBranchPolicyNamePatternWithType, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentBranchPolicy,
            error_models={},
        )

    def get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """repos/get-deployment-branch-policy

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}

        Gets a deployment branch or tag policy for an environment.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/branch-policies#get-a-deployment-branch-policy
        """

        from ..models import DeploymentBranchPolicy

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentBranchPolicy,
        )

    async def async_get_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """repos/get-deployment-branch-policy

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}

        Gets a deployment branch or tag policy for an environment.

        Anyone with read access to the repository can use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/branch-policies#get-a-deployment-branch-policy
        """

        from ..models import DeploymentBranchPolicy

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentBranchPolicy,
        )

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    @overload
    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    def update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """repos/update-deployment-branch-policy

        PUT /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}

        Updates a deployment branch or tag policy for an environment.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/branch-policies#update-a-deployment-branch-policy
        """

        from ..models import DeploymentBranchPolicy, DeploymentBranchPolicyNamePattern

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(DeploymentBranchPolicyNamePattern, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentBranchPolicy,
        )

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: DeploymentBranchPolicyNamePatternType,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    @overload
    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]: ...

    async def async_update_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[DeploymentBranchPolicyNamePatternType] = UNSET,
        **kwargs,
    ) -> Response[DeploymentBranchPolicy, DeploymentBranchPolicyType]:
        """repos/update-deployment-branch-policy

        PUT /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}

        Updates a deployment branch or tag policy for an environment.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/branch-policies#update-a-deployment-branch-policy
        """

        from ..models import DeploymentBranchPolicy, DeploymentBranchPolicyNamePattern

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(DeploymentBranchPolicyNamePattern, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentBranchPolicy,
        )

    def delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-deployment-branch-policy

        DELETE /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}

        Deletes a deployment branch or tag policy for an environment.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/branch-policies#delete-a-deployment-branch-policy
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_deployment_branch_policy(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        branch_policy_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-deployment-branch-policy

        DELETE /repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}

        Deletes a deployment branch or tag policy for an environment.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/branch-policies#delete-a-deployment-branch-policy
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment-branch-policies/{branch_policy_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def get_all_deployment_protection_rules(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200Type,
    ]:
        """repos/get-all-deployment-protection-rules

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules

        Gets all custom deployment protection rules that are enabled for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."

        For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/rest/apps/apps#get-an-app).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/protection-rules#get-all-deployment-protection-rules-for-an-environment
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

    async def async_get_all_deployment_protection_rules(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200Type,
    ]:
        """repos/get-all-deployment-protection-rules

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules

        Gets all custom deployment protection rules that are enabled for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."

        For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/rest/apps/apps#get-an-app).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/protection-rules#get-all-deployment-protection-rules-for-an-environment
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesGetResponse200,
        )

    @overload
    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]: ...

    @overload
    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        integration_id: Missing[int] = UNSET,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]: ...

    def create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]:
        """repos/create-deployment-protection-rule

        POST /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules

        Enable a custom deployment protection rule for an environment.

        The authenticated user must have admin or owner permissions to the repository to use this endpoint.

        For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/rest/apps/apps#get-an-app), as well as the [guide to creating custom deployment protection rules](https://docs.github.com/actions/managing-workflow-runs-and-deployments/managing-deployments/creating-custom-deployment-protection-rules).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/protection-rules#create-a-custom-deployment-protection-rule-on-an-environment
        """

        from ..models import (
            DeploymentProtectionRule,
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentProtectionRule,
        )

    @overload
    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]: ...

    @overload
    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        integration_id: Missing[int] = UNSET,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]: ...

    async def async_create_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBodyType
        ] = UNSET,
        **kwargs,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]:
        """repos/create-deployment-protection-rule

        POST /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules

        Enable a custom deployment protection rule for an environment.

        The authenticated user must have admin or owner permissions to the repository to use this endpoint.

        For more information about the app that is providing this custom deployment rule, see the [documentation for the `GET /apps/{app_slug}` endpoint](https://docs.github.com/rest/apps/apps#get-an-app), as well as the [guide to creating custom deployment protection rules](https://docs.github.com/actions/managing-workflow-runs-and-deployments/managing-deployments/creating-custom-deployment-protection-rules).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/protection-rules#create-a-custom-deployment-protection-rule-on-an-environment
        """

        from ..models import (
            DeploymentProtectionRule,
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesPostBody,
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentProtectionRule,
        )

    def list_custom_deployment_rule_integrations(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200Type,
    ]:
        """repos/list-custom-deployment-rule-integrations

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps

        Gets all custom deployment protection rule integrations that are available for an environment.

        The authenticated user must have admin or owner permissions to the repository to use this endpoint.

        For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."

        For more information about the app that is providing this custom deployment rule, see "[GET an app](https://docs.github.com/rest/apps/apps#get-an-app)".

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/protection-rules#list-custom-deployment-rule-integrations-available-for-an-environment
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

    async def async_list_custom_deployment_rule_integrations(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200Type,
    ]:
        """repos/list-custom-deployment-rule-integrations

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps

        Gets all custom deployment protection rule integrations that are available for an environment.

        The authenticated user must have admin or owner permissions to the repository to use this endpoint.

        For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."

        For more information about the app that is providing this custom deployment rule, see "[GET an app](https://docs.github.com/rest/apps/apps#get-an-app)".

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/protection-rules#list-custom-deployment-rule-integrations-available-for-an-environment
        """

        from ..models import (
            ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/apps"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoEnvironmentsEnvironmentNameDeploymentProtectionRulesAppsGetResponse200,
        )

    def get_custom_deployment_protection_rule(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        protection_rule_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]:
        """repos/get-custom-deployment-protection-rule

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}

        Gets an enabled custom deployment protection rule for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."

        For more information about the app that is providing this custom deployment rule, see [`GET /apps/{app_slug}`](https://docs.github.com/rest/apps/apps#get-an-app).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/protection-rules#get-a-custom-deployment-protection-rule
        """

        from ..models import DeploymentProtectionRule

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentProtectionRule,
        )

    async def async_get_custom_deployment_protection_rule(
        self,
        owner: str,
        repo: str,
        environment_name: str,
        protection_rule_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeploymentProtectionRule, DeploymentProtectionRuleType]:
        """repos/get-custom-deployment-protection-rule

        GET /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}

        Gets an enabled custom deployment protection rule for an environment. Anyone with read access to the repository can use this endpoint. For more information about environments, see "[Using environments for deployment](https://docs.github.com/actions/deployment/targeting-different-environments/using-environments-for-deployment)."

        For more information about the app that is providing this custom deployment rule, see [`GET /apps/{app_slug}`](https://docs.github.com/rest/apps/apps#get-an-app).

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/deployments/protection-rules#get-a-custom-deployment-protection-rule
        """

        from ..models import DeploymentProtectionRule

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeploymentProtectionRule,
        )

    def disable_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        protection_rule_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/disable-deployment-protection-rule

        DELETE /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}

        Disables a custom deployment protection rule for an environment.

        The authenticated user must have admin or owner permissions to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/protection-rules#disable-a-custom-protection-rule-for-an-environment
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_disable_deployment_protection_rule(
        self,
        environment_name: str,
        repo: str,
        owner: str,
        protection_rule_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/disable-deployment-protection-rule

        DELETE /repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}

        Disables a custom deployment protection rule for an environment.

        The authenticated user must have admin or owner permissions to the repository to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/deployments/protection-rules#disable-a-custom-protection-rule-for-an-environment
        """

        url = f"/repos/{owner}/{repo}/environments/{environment_name}/deployment_protection_rules/{protection_rule_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_forks(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["newest", "oldest", "stargazers", "watchers"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """repos/list-forks

        GET /repos/{owner}/{repo}/forks

        See also: https://docs.github.com/rest/repos/forks#list-forks
        """

        from ..models import BasicError, MinimalRepository

        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    async def async_list_forks(
        self,
        owner: str,
        repo: str,
        *,
        sort: Missing[Literal["newest", "oldest", "stargazers", "watchers"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """repos/list-forks

        GET /repos/{owner}/{repo}/forks

        See also: https://docs.github.com/rest/repos/forks#list-forks
        """

        from ..models import BasicError, MinimalRepository

        url = f"/repos/{owner}/{repo}/forks"

        params = {
            "sort": sort,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "400": BasicError,
            },
        )

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        organization: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        default_branch_only: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/create-fork

        POST /repos/{owner}/{repo}/forks

        Create a fork for the authenticated user.

        > [!NOTE]
        > Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).

        > [!NOTE]
        > Although this endpoint works with GitHub Apps, the GitHub App must be installed on the destination account with access to all repositories and on the source account with access to the source repository.

        See also: https://docs.github.com/rest/repos/forks#create-a-fork
        """

        from typing import Union

        from ..models import (
            BasicError,
            FullRepository,
            ReposOwnerRepoForksPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/forks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[ReposOwnerRepoForksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        organization: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        default_branch_only: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_create_fork(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoForksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/create-fork

        POST /repos/{owner}/{repo}/forks

        Create a fork for the authenticated user.

        > [!NOTE]
        > Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).

        > [!NOTE]
        > Although this endpoint works with GitHub Apps, the GitHub App must be installed on the destination account with access to all repositories and on the source account with access to the source repository.

        See also: https://docs.github.com/rest/repos/forks#create-a-fork
        """

        from typing import Union

        from ..models import (
            BasicError,
            FullRepository,
            ReposOwnerRepoForksPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/forks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[ReposOwnerRepoForksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "403": BasicError,
                "404": BasicError,
            },
        )

    def list_webhooks(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Hook], list[HookType]]:
        """repos/list-webhooks

        GET /repos/{owner}/{repo}/hooks

        Lists webhooks for a repository. `last response` may return null if there have not been any deliveries within 30 days.

        See also: https://docs.github.com/rest/repos/webhooks#list-repository-webhooks
        """

        from ..models import BasicError, Hook

        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Hook],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_webhooks(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Hook], list[HookType]]:
        """repos/list-webhooks

        GET /repos/{owner}/{repo}/hooks

        Lists webhooks for a repository. `last response` may return null if there have not been any deliveries within 30 days.

        See also: https://docs.github.com/rest/repos/webhooks#list-repository-webhooks
        """

        from ..models import BasicError, Hook

        url = f"/repos/{owner}/{repo}/hooks"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Hook],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> Response[Hook, HookType]: ...

    @overload
    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        config: Missing[ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook, HookType]: ...

    def create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Hook, HookType]:
        """repos/create-webhook

        POST /repos/{owner}/{repo}/hooks

        Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
        share the same `config` as long as those webhooks do not have any `events` that overlap.

        See also: https://docs.github.com/rest/repos/webhooks#create-a-repository-webhook
        """

        from typing import Union

        from ..models import (
            BasicError,
            Hook,
            ReposOwnerRepoHooksPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
    ) -> Response[Hook, HookType]: ...

    @overload
    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        config: Missing[ReposOwnerRepoHooksPostBodyPropConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook, HookType]: ...

    async def async_create_webhook(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[Union[ReposOwnerRepoHooksPostBodyType, None]] = UNSET,
        **kwargs,
    ) -> Response[Hook, HookType]:
        """repos/create-webhook

        POST /repos/{owner}/{repo}/hooks

        Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
        share the same `config` as long as those webhooks do not have any `events` that overlap.

        See also: https://docs.github.com/rest/repos/webhooks#create-a-repository-webhook
        """

        from typing import Union

        from ..models import (
            BasicError,
            Hook,
            ReposOwnerRepoHooksPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(Union[ReposOwnerRepoHooksPostBody, None], json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Hook,
            error_models={
                "404": BasicError,
                "422": ValidationError,
                "403": BasicError,
            },
        )

    def get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Hook, HookType]:
        """repos/get-webhook

        GET /repos/{owner}/{repo}/hooks/{hook_id}

        Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/webhooks/repo-config#get-a-webhook-configuration-for-a-repository)."

        See also: https://docs.github.com/rest/repos/webhooks#get-a-repository-webhook
        """

        from ..models import BasicError, Hook

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Hook, HookType]:
        """repos/get-webhook

        GET /repos/{owner}/{repo}/hooks/{hook_id}

        Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/webhooks/repo-config#get-a-webhook-configuration-for-a-repository)."

        See also: https://docs.github.com/rest/repos/webhooks#get-a-repository-webhook
        """

        from ..models import BasicError, Hook

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Hook,
            error_models={
                "404": BasicError,
            },
        )

    def delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-webhook

        DELETE /repos/{owner}/{repo}/hooks/{hook_id}

        Delete a webhook for an organization.

        The authenticated user must be a repository owner, or have admin access in the repository, to delete the webhook.

        See also: https://docs.github.com/rest/repos/webhooks#delete-a-repository-webhook
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_delete_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-webhook

        DELETE /repos/{owner}/{repo}/hooks/{hook_id}

        Delete a webhook for an organization.

        The authenticated user must be a repository owner, or have admin access in the repository, to delete the webhook.

        See also: https://docs.github.com/rest/repos/webhooks#delete-a-repository-webhook
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> Response[Hook, HookType]: ...

    @overload
    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        config: Missing[WebhookConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        add_events: Missing[list[str]] = UNSET,
        remove_events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook, HookType]: ...

    def update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Hook, HookType]:
        """repos/update-webhook

        PATCH /repos/{owner}/{repo}/hooks/{hook_id}

        Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/webhooks/repo-config#update-a-webhook-configuration-for-a-repository)."

        See also: https://docs.github.com/rest/repos/webhooks#update-a-repository-webhook
        """

        from ..models import (
            BasicError,
            Hook,
            ReposOwnerRepoHooksHookIdPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoHooksHookIdPatchBodyType,
    ) -> Response[Hook, HookType]: ...

    @overload
    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        config: Missing[WebhookConfigType] = UNSET,
        events: Missing[list[str]] = UNSET,
        add_events: Missing[list[str]] = UNSET,
        remove_events: Missing[list[str]] = UNSET,
        active: Missing[bool] = UNSET,
    ) -> Response[Hook, HookType]: ...

    async def async_update_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoHooksHookIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Hook, HookType]:
        """repos/update-webhook

        PATCH /repos/{owner}/{repo}/hooks/{hook_id}

        Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/webhooks/repo-config#update-a-webhook-configuration-for-a-repository)."

        See also: https://docs.github.com/rest/repos/webhooks#update-a-repository-webhook
        """

        from ..models import (
            BasicError,
            Hook,
            ReposOwnerRepoHooksHookIdPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoHooksHookIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Hook,
            error_models={
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """repos/get-webhook-config-for-repo

        GET /repos/{owner}/{repo}/hooks/{hook_id}/config

        Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/webhooks/repos#get-a-repository-webhook)."

        OAuth app tokens and personal access tokens (classic) need the `read:repo_hook` or `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/repos/webhooks#get-a-webhook-configuration-for-a-repository
        """

        from ..models import WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WebhookConfig,
        )

    async def async_get_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """repos/get-webhook-config-for-repo

        GET /repos/{owner}/{repo}/hooks/{hook_id}/config

        Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/webhooks/repos#get-a-repository-webhook)."

        OAuth app tokens and personal access tokens (classic) need the `read:repo_hook` or `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/repos/webhooks#get-a-webhook-configuration-for-a-repository
        """

        from ..models import WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WebhookConfig,
        )

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    @overload
    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    def update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """repos/update-webhook-config-for-repo

        PATCH /repos/{owner}/{repo}/hooks/{hook_id}/config

        Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/webhooks/repos#update-a-repository-webhook)."

        OAuth app tokens and personal access tokens (classic) need the `write:repo_hook` or `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/repos/webhooks#update-a-webhook-configuration-for-a-repository
        """

        from ..models import ReposOwnerRepoHooksHookIdConfigPatchBody, WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WebhookConfig,
        )

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    @overload
    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        url: Missing[str] = UNSET,
        content_type: Missing[str] = UNSET,
        secret: Missing[str] = UNSET,
        insecure_ssl: Missing[Union[str, float]] = UNSET,
    ) -> Response[WebhookConfig, WebhookConfigType]: ...

    async def async_update_webhook_config_for_repo(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoHooksHookIdConfigPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[WebhookConfig, WebhookConfigType]:
        """repos/update-webhook-config-for-repo

        PATCH /repos/{owner}/{repo}/hooks/{hook_id}/config

        Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/webhooks/repos#update-a-repository-webhook)."

        OAuth app tokens and personal access tokens (classic) need the `write:repo_hook` or `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/repos/webhooks#update-a-webhook-configuration-for-a-repository
        """

        from ..models import ReposOwnerRepoHooksHookIdConfigPatchBody, WebhookConfig

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/config"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoHooksHookIdConfigPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=WebhookConfig,
        )

    def list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemType]]:
        """repos/list-webhook-deliveries

        GET /repos/{owner}/{repo}/hooks/{hook_id}/deliveries

        Returns a list of webhook deliveries for a webhook configured in a repository.

        See also: https://docs.github.com/rest/repos/webhooks#list-deliveries-for-a-repository-webhook
        """

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_list_webhook_deliveries(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        per_page: Missing[int] = UNSET,
        cursor: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[HookDeliveryItem], list[HookDeliveryItemType]]:
        """repos/list-webhook-deliveries

        GET /repos/{owner}/{repo}/hooks/{hook_id}/deliveries

        Returns a list of webhook deliveries for a webhook configured in a repository.

        See also: https://docs.github.com/rest/repos/webhooks#list-deliveries-for-a-repository-webhook
        """

        from ..models import BasicError, HookDeliveryItem, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries"

        params = {
            "per_page": per_page,
            "cursor": cursor,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[HookDeliveryItem],
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[HookDelivery, HookDeliveryType]:
        """repos/get-webhook-delivery

        GET /repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}

        Returns a delivery for a webhook configured in a repository.

        See also: https://docs.github.com/rest/repos/webhooks#get-a-delivery-for-a-repository-webhook
        """

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[HookDelivery, HookDeliveryType]:
        """repos/get-webhook-delivery

        GET /repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}

        Returns a delivery for a webhook configured in a repository.

        See also: https://docs.github.com/rest/repos/webhooks#get-a-delivery-for-a-repository-webhook
        """

        from ..models import BasicError, HookDelivery, ValidationError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=HookDelivery,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """repos/redeliver-webhook-delivery

        POST /repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts

        Redeliver a webhook delivery for a webhook configured in a repository.

        See also: https://docs.github.com/rest/repos/webhooks#redeliver-a-delivery-for-a-repository-webhook
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    async def async_redeliver_webhook_delivery(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        delivery_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
        AppHookDeliveriesDeliveryIdAttemptsPostResponse202Type,
    ]:
        """repos/redeliver-webhook-delivery

        POST /repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts

        Redeliver a webhook delivery for a webhook configured in a repository.

        See also: https://docs.github.com/rest/repos/webhooks#redeliver-a-delivery-for-a-repository-webhook
        """

        from ..models import (
            AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            BasicError,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=AppHookDeliveriesDeliveryIdAttemptsPostResponse202,
            error_models={
                "400": BasicError,
                "422": ValidationError,
            },
        )

    def ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/ping-webhook

        POST /repos/{owner}/{repo}/hooks/{hook_id}/pings

        This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.

        See also: https://docs.github.com/rest/repos/webhooks#ping-a-repository-webhook
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_ping_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/ping-webhook

        POST /repos/{owner}/{repo}/hooks/{hook_id}/pings

        This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.

        See also: https://docs.github.com/rest/repos/webhooks#ping-a-repository-webhook
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/pings"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/test-push-webhook

        POST /repos/{owner}/{repo}/hooks/{hook_id}/tests

        This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.

        > [!NOTE]
        > Previously `/repos/:owner/:repo/hooks/:hook_id/test`

        See also: https://docs.github.com/rest/repos/webhooks#test-the-push-repository-webhook
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_test_push_webhook(
        self,
        owner: str,
        repo: str,
        hook_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/test-push-webhook

        POST /repos/{owner}/{repo}/hooks/{hook_id}/tests

        This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.

        > [!NOTE]
        > Previously `/repos/:owner/:repo/hooks/:hook_id/test`

        See also: https://docs.github.com/rest/repos/webhooks#test-the-push-repository-webhook
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/hooks/{hook_id}/tests"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def list_invitations(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryInvitation], list[RepositoryInvitationType]]:
        """repos/list-invitations

        GET /repos/{owner}/{repo}/invitations

        When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations.

        See also: https://docs.github.com/rest/collaborators/invitations#list-repository-invitations
        """

        from ..models import RepositoryInvitation

        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryInvitation],
        )

    async def async_list_invitations(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryInvitation], list[RepositoryInvitationType]]:
        """repos/list-invitations

        GET /repos/{owner}/{repo}/invitations

        When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations.

        See also: https://docs.github.com/rest/collaborators/invitations#list-repository-invitations
        """

        from ..models import RepositoryInvitation

        url = f"/repos/{owner}/{repo}/invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryInvitation],
        )

    def delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-invitation

        DELETE /repos/{owner}/{repo}/invitations/{invitation_id}

        See also: https://docs.github.com/rest/collaborators/invitations#delete-a-repository-invitation
        """

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-invitation

        DELETE /repos/{owner}/{repo}/invitations/{invitation_id}

        See also: https://docs.github.com/rest/collaborators/invitations#delete-a-repository-invitation
        """

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    @overload
    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permissions: Missing[
            Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    def update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]:
        """repos/update-invitation

        PATCH /repos/{owner}/{repo}/invitations/{invitation_id}

        See also: https://docs.github.com/rest/collaborators/invitations#update-a-repository-invitation
        """

        from ..models import (
            RepositoryInvitation,
            ReposOwnerRepoInvitationsInvitationIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoInvitationsInvitationIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryInvitation,
        )

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    @overload
    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        permissions: Missing[
            Literal["read", "write", "maintain", "triage", "admin"]
        ] = UNSET,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]: ...

    async def async_update_invitation(
        self,
        owner: str,
        repo: str,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoInvitationsInvitationIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryInvitation, RepositoryInvitationType]:
        """repos/update-invitation

        PATCH /repos/{owner}/{repo}/invitations/{invitation_id}

        See also: https://docs.github.com/rest/collaborators/invitations#update-a-repository-invitation
        """

        from ..models import (
            RepositoryInvitation,
            ReposOwnerRepoInvitationsInvitationIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/invitations/{invitation_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoInvitationsInvitationIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryInvitation,
        )

    def list_deploy_keys(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[DeployKey], list[DeployKeyType]]:
        """repos/list-deploy-keys

        GET /repos/{owner}/{repo}/keys

        See also: https://docs.github.com/rest/deploy-keys/deploy-keys#list-deploy-keys
        """

        from ..models import DeployKey

        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DeployKey],
        )

    async def async_list_deploy_keys(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[DeployKey], list[DeployKeyType]]:
        """repos/list-deploy-keys

        GET /repos/{owner}/{repo}/keys

        See also: https://docs.github.com/rest/deploy-keys/deploy-keys#list-deploy-keys
        """

        from ..models import DeployKey

        url = f"/repos/{owner}/{repo}/keys"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[DeployKey],
        )

    @overload
    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoKeysPostBodyType,
    ) -> Response[DeployKey, DeployKeyType]: ...

    @overload
    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: Missing[str] = UNSET,
        key: str,
        read_only: Missing[bool] = UNSET,
    ) -> Response[DeployKey, DeployKeyType]: ...

    def create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[DeployKey, DeployKeyType]:
        """repos/create-deploy-key

        POST /repos/{owner}/{repo}/keys

        You can create a read-only deploy key.

        See also: https://docs.github.com/rest/deploy-keys/deploy-keys#create-a-deploy-key
        """

        from ..models import DeployKey, ReposOwnerRepoKeysPostBody, ValidationError

        url = f"/repos/{owner}/{repo}/keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoKeysPostBodyType,
    ) -> Response[DeployKey, DeployKeyType]: ...

    @overload
    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        title: Missing[str] = UNSET,
        key: str,
        read_only: Missing[bool] = UNSET,
    ) -> Response[DeployKey, DeployKeyType]: ...

    async def async_create_deploy_key(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoKeysPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[DeployKey, DeployKeyType]:
        """repos/create-deploy-key

        POST /repos/{owner}/{repo}/keys

        You can create a read-only deploy key.

        See also: https://docs.github.com/rest/deploy-keys/deploy-keys#create-a-deploy-key
        """

        from ..models import DeployKey, ReposOwnerRepoKeysPostBody, ValidationError

        url = f"/repos/{owner}/{repo}/keys"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoKeysPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeployKey,
            error_models={
                "422": ValidationError,
            },
        )

    def get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeployKey, DeployKeyType]:
        """repos/get-deploy-key

        GET /repos/{owner}/{repo}/keys/{key_id}

        See also: https://docs.github.com/rest/deploy-keys/deploy-keys#get-a-deploy-key
        """

        from ..models import BasicError, DeployKey

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[DeployKey, DeployKeyType]:
        """repos/get-deploy-key

        GET /repos/{owner}/{repo}/keys/{key_id}

        See also: https://docs.github.com/rest/deploy-keys/deploy-keys#get-a-deploy-key
        """

        from ..models import BasicError, DeployKey

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=DeployKey,
            error_models={
                "404": BasicError,
            },
        )

    def delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-deploy-key

        DELETE /repos/{owner}/{repo}/keys/{key_id}

        Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead.

        See also: https://docs.github.com/rest/deploy-keys/deploy-keys#delete-a-deploy-key
        """

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_deploy_key(
        self,
        owner: str,
        repo: str,
        key_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-deploy-key

        DELETE /repos/{owner}/{repo}/keys/{key_id}

        Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead.

        See also: https://docs.github.com/rest/deploy-keys/deploy-keys#delete-a-deploy-key
        """

        url = f"/repos/{owner}/{repo}/keys/{key_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_languages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Language, LanguageType]:
        """repos/list-languages

        GET /repos/{owner}/{repo}/languages

        Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language.

        See also: https://docs.github.com/rest/repos/repos#list-repository-languages
        """

        from ..models import Language

        url = f"/repos/{owner}/{repo}/languages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Language,
        )

    async def async_list_languages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Language, LanguageType]:
        """repos/list-languages

        GET /repos/{owner}/{repo}/languages

        Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language.

        See also: https://docs.github.com/rest/repos/repos#list-repository-languages
        """

        from ..models import Language

        url = f"/repos/{owner}/{repo}/languages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Language,
        )

    @overload
    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoMergeUpstreamPostBodyType,
    ) -> Response[MergedUpstream, MergedUpstreamType]: ...

    @overload
    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        branch: str,
    ) -> Response[MergedUpstream, MergedUpstreamType]: ...

    def merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MergedUpstream, MergedUpstreamType]:
        """repos/merge-upstream

        POST /repos/{owner}/{repo}/merge-upstream

        Sync a branch of a forked repository to keep it up-to-date with the upstream repository.

        See also: https://docs.github.com/rest/branches/branches#sync-a-fork-branch-with-the-upstream-repository
        """

        from ..models import MergedUpstream, ReposOwnerRepoMergeUpstreamPostBody

        url = f"/repos/{owner}/{repo}/merge-upstream"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoMergeUpstreamPostBodyType,
    ) -> Response[MergedUpstream, MergedUpstreamType]: ...

    @overload
    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        branch: str,
    ) -> Response[MergedUpstream, MergedUpstreamType]: ...

    async def async_merge_upstream(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoMergeUpstreamPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MergedUpstream, MergedUpstreamType]:
        """repos/merge-upstream

        POST /repos/{owner}/{repo}/merge-upstream

        Sync a branch of a forked repository to keep it up-to-date with the upstream repository.

        See also: https://docs.github.com/rest/branches/branches#sync-a-fork-branch-with-the-upstream-repository
        """

        from ..models import MergedUpstream, ReposOwnerRepoMergeUpstreamPostBody

        url = f"/repos/{owner}/{repo}/merge-upstream"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMergeUpstreamPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=MergedUpstream,
            error_models={},
        )

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoMergesPostBodyType,
    ) -> Response[Commit, CommitType]: ...

    @overload
    def merge(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        base: str,
        head: str,
        commit_message: Missing[str] = UNSET,
    ) -> Response[Commit, CommitType]: ...

    def merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Commit, CommitType]:
        """repos/merge

        POST /repos/{owner}/{repo}/merges

        See also: https://docs.github.com/rest/branches/branches#merge-a-branch
        """

        from ..models import (
            BasicError,
            Commit,
            ReposOwnerRepoMergesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/merges"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMergesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoMergesPostBodyType,
    ) -> Response[Commit, CommitType]: ...

    @overload
    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        base: str,
        head: str,
        commit_message: Missing[str] = UNSET,
    ) -> Response[Commit, CommitType]: ...

    async def async_merge(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoMergesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Commit, CommitType]:
        """repos/merge

        POST /repos/{owner}/{repo}/merges

        See also: https://docs.github.com/rest/branches/branches#merge-a-branch
        """

        from ..models import (
            BasicError,
            Commit,
            ReposOwnerRepoMergesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/merges"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoMergesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Commit,
            error_models={
                "403": BasicError,
                "422": ValidationError,
            },
        )

    def get_pages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Page, PageType]:
        """repos/get-pages

        GET /repos/{owner}/{repo}/pages

        Gets information about a GitHub Pages site.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#get-a-apiname-pages-site
        """

        from ..models import BasicError, Page

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Page, PageType]:
        """repos/get-pages

        GET /repos/{owner}/{repo}/pages

        Gets information about a GitHub Pages site.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#get-a-apiname-pages-site
        """

        from ..models import BasicError, Page

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Page,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Union[str, None],
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response: ...

    @overload
    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: bool,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response: ...

    def update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """repos/update-information-about-pages-site

        PUT /repos/{owner}/{repo}/pages

        Updates information for a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).

        The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#update-information-about-a-apiname-pages-site
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoPagesPutBodyAnyof0,
            ReposOwnerRepoPagesPutBodyAnyof1,
            ReposOwnerRepoPagesPutBodyAnyof2,
            ReposOwnerRepoPagesPutBodyAnyof3,
            ReposOwnerRepoPagesPutBodyAnyof4,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPagesPutBodyAnyof0,
                    ReposOwnerRepoPagesPutBodyAnyof1,
                    ReposOwnerRepoPagesPutBodyAnyof2,
                    ReposOwnerRepoPagesPutBodyAnyof3,
                    ReposOwnerRepoPagesPutBodyAnyof4,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ReposOwnerRepoPagesPutBodyAnyof0Type,
            ReposOwnerRepoPagesPutBodyAnyof1Type,
            ReposOwnerRepoPagesPutBodyAnyof2Type,
            ReposOwnerRepoPagesPutBodyAnyof3Type,
            ReposOwnerRepoPagesPutBodyAnyof4Type,
        ],
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Literal["legacy", "workflow"],
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Union[
            Literal["gh-pages", "master", "master /docs"],
            ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
        ],
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Union[str, None],
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: Missing[bool] = UNSET,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response: ...

    @overload
    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        cname: Missing[Union[str, None]] = UNSET,
        https_enforced: bool,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: Missing[
            Union[
                Literal["gh-pages", "master", "master /docs"],
                ReposOwnerRepoPagesPutBodyPropSourceAnyof1Type,
            ]
        ] = UNSET,
    ) -> Response: ...

    async def async_update_information_about_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPutBodyAnyof0Type,
                ReposOwnerRepoPagesPutBodyAnyof1Type,
                ReposOwnerRepoPagesPutBodyAnyof2Type,
                ReposOwnerRepoPagesPutBodyAnyof3Type,
                ReposOwnerRepoPagesPutBodyAnyof4Type,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response:
        """repos/update-information-about-pages-site

        PUT /repos/{owner}/{repo}/pages

        Updates information for a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).

        The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#update-information-about-a-apiname-pages-site
        """

        from typing import Union

        from ..models import (
            BasicError,
            ReposOwnerRepoPagesPutBodyAnyof0,
            ReposOwnerRepoPagesPutBodyAnyof1,
            ReposOwnerRepoPagesPutBodyAnyof2,
            ReposOwnerRepoPagesPutBodyAnyof3,
            ReposOwnerRepoPagesPutBodyAnyof4,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPagesPutBodyAnyof0,
                    ReposOwnerRepoPagesPutBodyAnyof1,
                    ReposOwnerRepoPagesPutBodyAnyof2,
                    ReposOwnerRepoPagesPutBodyAnyof3,
                    ReposOwnerRepoPagesPutBodyAnyof4,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
                "400": BasicError,
                "409": BasicError,
            },
        )

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> Response[Page, PageType]: ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> Response[Page, PageType]: ...

    @overload
    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        build_type: Literal["legacy", "workflow"],
        source: Missing[ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> Response[Page, PageType]: ...

    def create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[Page, PageType]:
        """repos/create-pages-site

        POST /repos/{owner}/{repo}/pages

        Configures a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)."

        The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#create-a-apiname-pages-site
        """

        from typing import Union

        from ..models import (
            BasicError,
            Page,
            ReposOwnerRepoPagesPostBodyAnyof0,
            ReposOwnerRepoPagesPostBodyAnyof1,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPagesPostBodyAnyof0,
                    None,
                    ReposOwnerRepoPagesPostBodyAnyof1,
                    None,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Union[
            ReposOwnerRepoPagesPostBodyAnyof0Type,
            None,
            ReposOwnerRepoPagesPostBodyAnyof1Type,
            None,
        ],
    ) -> Response[Page, PageType]: ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        build_type: Missing[Literal["legacy", "workflow"]] = UNSET,
        source: ReposOwnerRepoPagesPostBodyPropSourceType,
    ) -> Response[Page, PageType]: ...

    @overload
    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        build_type: Literal["legacy", "workflow"],
        source: Missing[ReposOwnerRepoPagesPostBodyPropSourceType] = UNSET,
    ) -> Response[Page, PageType]: ...

    async def async_create_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[
            Union[
                ReposOwnerRepoPagesPostBodyAnyof0Type,
                None,
                ReposOwnerRepoPagesPostBodyAnyof1Type,
                None,
            ]
        ] = UNSET,
        **kwargs,
    ) -> Response[Page, PageType]:
        """repos/create-pages-site

        POST /repos/{owner}/{repo}/pages

        Configures a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)."

        The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#create-a-apiname-pages-site
        """

        from typing import Union

        from ..models import (
            BasicError,
            Page,
            ReposOwnerRepoPagesPostBodyAnyof0,
            ReposOwnerRepoPagesPostBodyAnyof1,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                Union[
                    ReposOwnerRepoPagesPostBodyAnyof0,
                    None,
                    ReposOwnerRepoPagesPostBodyAnyof1,
                    None,
                ],
                json,
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Page,
            error_models={
                "422": ValidationError,
                "409": BasicError,
            },
        )

    def delete_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-pages-site

        DELETE /repos/{owner}/{repo}/pages

        Deletes a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).

        The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#delete-a-apiname-pages-site
        """

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    async def async_delete_pages_site(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-pages-site

        DELETE /repos/{owner}/{repo}/pages

        Deletes a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).

        The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#delete-a-apiname-pages-site
        """

        from ..models import BasicError, ValidationError

        url = f"/repos/{owner}/{repo}/pages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": ValidationError,
                "404": BasicError,
                "409": BasicError,
            },
        )

    def list_pages_builds(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PageBuild], list[PageBuildType]]:
        """repos/list-pages-builds

        GET /repos/{owner}/{repo}/pages/builds

        Lists builts of a GitHub Pages site.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#list-apiname-pages-builds
        """

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PageBuild],
        )

    async def async_list_pages_builds(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[PageBuild], list[PageBuildType]]:
        """repos/list-pages-builds

        GET /repos/{owner}/{repo}/pages/builds

        Lists builts of a GitHub Pages site.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#list-apiname-pages-builds
        """

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[PageBuild],
        )

    def request_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PageBuildStatus, PageBuildStatusType]:
        """repos/request-pages-build

        POST /repos/{owner}/{repo}/pages/builds

        You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.

        Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.

        See also: https://docs.github.com/rest/pages/pages#request-a-apiname-pages-build
        """

        from ..models import PageBuildStatus

        url = f"/repos/{owner}/{repo}/pages/builds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PageBuildStatus,
        )

    async def async_request_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PageBuildStatus, PageBuildStatusType]:
        """repos/request-pages-build

        POST /repos/{owner}/{repo}/pages/builds

        You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.

        Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.

        See also: https://docs.github.com/rest/pages/pages#request-a-apiname-pages-build
        """

        from ..models import PageBuildStatus

        url = f"/repos/{owner}/{repo}/pages/builds"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PageBuildStatus,
        )

    def get_latest_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PageBuild, PageBuildType]:
        """repos/get-latest-pages-build

        GET /repos/{owner}/{repo}/pages/builds/latest

        Gets information about the single most recent build of a GitHub Pages site.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#get-latest-pages-build
        """

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PageBuild,
        )

    async def async_get_latest_pages_build(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PageBuild, PageBuildType]:
        """repos/get-latest-pages-build

        GET /repos/{owner}/{repo}/pages/builds/latest

        Gets information about the single most recent build of a GitHub Pages site.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#get-latest-pages-build
        """

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PageBuild,
        )

    def get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PageBuild, PageBuildType]:
        """repos/get-pages-build

        GET /repos/{owner}/{repo}/pages/builds/{build_id}

        Gets information about a GitHub Pages build.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#get-apiname-pages-build
        """

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PageBuild,
        )

    async def async_get_pages_build(
        self,
        owner: str,
        repo: str,
        build_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PageBuild, PageBuildType]:
        """repos/get-pages-build

        GET /repos/{owner}/{repo}/pages/builds/{build_id}

        Gets information about a GitHub Pages build.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#get-apiname-pages-build
        """

        from ..models import PageBuild

        url = f"/repos/{owner}/{repo}/pages/builds/{build_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PageBuild,
        )

    @overload
    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPagesDeploymentsPostBodyType,
    ) -> Response[PageDeployment, PageDeploymentType]: ...

    @overload
    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        artifact_id: Missing[float] = UNSET,
        artifact_url: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> Response[PageDeployment, PageDeploymentType]: ...

    def create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPagesDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PageDeployment, PageDeploymentType]:
        """repos/create-pages-deployment

        POST /repos/{owner}/{repo}/pages/deployments

        Create a GitHub Pages deployment for a repository.

        The authenticated user must have write permission to the repository.

        See also: https://docs.github.com/rest/pages/pages#create-a-github-pages-deployment
        """

        from ..models import (
            BasicError,
            PageDeployment,
            ReposOwnerRepoPagesDeploymentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages/deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPagesDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPagesDeploymentsPostBodyType,
    ) -> Response[PageDeployment, PageDeploymentType]: ...

    @overload
    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        artifact_id: Missing[float] = UNSET,
        artifact_url: Missing[str] = UNSET,
        environment: Missing[str] = UNSET,
        pages_build_version: str = "GITHUB_SHA",
        oidc_token: str,
    ) -> Response[PageDeployment, PageDeploymentType]: ...

    async def async_create_pages_deployment(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPagesDeploymentsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[PageDeployment, PageDeploymentType]:
        """repos/create-pages-deployment

        POST /repos/{owner}/{repo}/pages/deployments

        Create a GitHub Pages deployment for a repository.

        The authenticated user must have write permission to the repository.

        See also: https://docs.github.com/rest/pages/pages#create-a-github-pages-deployment
        """

        from ..models import (
            BasicError,
            PageDeployment,
            ReposOwnerRepoPagesDeploymentsPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/pages/deployments"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPagesDeploymentsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PageDeployment,
            error_models={
                "400": BasicError,
                "422": ValidationError,
                "404": BasicError,
            },
        )

    def get_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PagesDeploymentStatus, PagesDeploymentStatusType]:
        """repos/get-pages-deployment

        GET /repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}

        Gets the current status of a GitHub Pages deployment.

        The authenticated user must have read permission for the GitHub Pages site.

        See also: https://docs.github.com/rest/pages/pages#get-the-status-of-a-github-pages-deployment
        """

        from ..models import BasicError, PagesDeploymentStatus

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PagesDeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PagesDeploymentStatus, PagesDeploymentStatusType]:
        """repos/get-pages-deployment

        GET /repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}

        Gets the current status of a GitHub Pages deployment.

        The authenticated user must have read permission for the GitHub Pages site.

        See also: https://docs.github.com/rest/pages/pages#get-the-status-of-a-github-pages-deployment
        """

        from ..models import BasicError, PagesDeploymentStatus

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PagesDeploymentStatus,
            error_models={
                "404": BasicError,
            },
        )

    def cancel_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/cancel-pages-deployment

        POST /repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel

        Cancels a GitHub Pages deployment.

        The authenticated user must have write permissions for the GitHub Pages site.

        See also: https://docs.github.com/rest/pages/pages#cancel-a-github-pages-deployment
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    async def async_cancel_pages_deployment(
        self,
        owner: str,
        repo: str,
        pages_deployment_id: Union[int, str],
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/cancel-pages-deployment

        POST /repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel

        Cancels a GitHub Pages deployment.

        The authenticated user must have write permissions for the GitHub Pages site.

        See also: https://docs.github.com/rest/pages/pages#cancel-a-github-pages-deployment
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/pages/deployments/{pages_deployment_id}/cancel"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "POST",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
            },
        )

    def get_pages_health_check(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PagesHealthCheck, PagesHealthCheckType]:
        """repos/get-pages-health-check

        GET /repos/{owner}/{repo}/pages/health

        Gets a health check of the DNS settings for the `CNAME` record configured for a repository's GitHub Pages.

        The first request to this endpoint returns a `202 Accepted` status and starts an asynchronous background task to get the results for the domain. After the background task completes, subsequent requests to this endpoint return a `200 OK` status with the health check results in the response.

        The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#get-a-dns-health-check-for-github-pages
        """

        from ..models import BasicError, PagesHealthCheck

        url = f"/repos/{owner}/{repo}/pages/health"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_pages_health_check(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[PagesHealthCheck, PagesHealthCheckType]:
        """repos/get-pages-health-check

        GET /repos/{owner}/{repo}/pages/health

        Gets a health check of the DNS settings for the `CNAME` record configured for a repository's GitHub Pages.

        The first request to this endpoint returns a `202 Accepted` status and starts an asynchronous background task to get the results for the domain. After the background task completes, subsequent requests to this endpoint return a `200 OK` status with the health check results in the response.

        The authenticated user must be a repository administrator, maintainer, or have the 'manage GitHub Pages settings' permission to use this endpoint.

        OAuth app tokens and personal access tokens (classic) need the `repo` scope to use this endpoint.

        See also: https://docs.github.com/rest/pages/pages#get-a-dns-health-check-for-github-pages
        """

        from ..models import BasicError, PagesHealthCheck

        url = f"/repos/{owner}/{repo}/pages/health"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=PagesHealthCheck,
            error_models={
                "404": BasicError,
            },
        )

    def check_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200Type,
    ]:
        """repos/check-private-vulnerability-reporting

        GET /repos/{owner}/{repo}/private-vulnerability-reporting

        Returns a boolean indicating whether or not private vulnerability reporting is enabled for the repository. For more information, see "[Evaluating the security settings of a repository](https://docs.github.com/code-security/security-advisories/working-with-repository-security-advisories/evaluating-the-security-settings-of-a-repository)".

        See also: https://docs.github.com/rest/repos/repos#check-if-private-vulnerability-reporting-is-enabled-for-a-repository
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
            error_models={
                "422": BasicError,
            },
        )

    async def async_check_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200Type,
    ]:
        """repos/check-private-vulnerability-reporting

        GET /repos/{owner}/{repo}/private-vulnerability-reporting

        Returns a boolean indicating whether or not private vulnerability reporting is enabled for the repository. For more information, see "[Evaluating the security settings of a repository](https://docs.github.com/code-security/security-advisories/working-with-repository-security-advisories/evaluating-the-security-settings-of-a-repository)".

        See also: https://docs.github.com/rest/repos/repos#check-if-private-vulnerability-reporting-is-enabled-for-a-repository
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
        )

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReposOwnerRepoPrivateVulnerabilityReportingGetResponse200,
            error_models={
                "422": BasicError,
            },
        )

    def enable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/enable-private-vulnerability-reporting

        PUT /repos/{owner}/{repo}/private-vulnerability-reporting

        Enables private vulnerability reporting for a repository. The authenticated user must have admin access to the repository. For more information, see "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)."

        See also: https://docs.github.com/rest/repos/repos#enable-private-vulnerability-reporting-for-a-repository
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": BasicError,
            },
        )

    async def async_enable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/enable-private-vulnerability-reporting

        PUT /repos/{owner}/{repo}/private-vulnerability-reporting

        Enables private vulnerability reporting for a repository. The authenticated user must have admin access to the repository. For more information, see "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)."

        See also: https://docs.github.com/rest/repos/repos#enable-private-vulnerability-reporting-for-a-repository
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": BasicError,
            },
        )

    def disable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/disable-private-vulnerability-reporting

        DELETE /repos/{owner}/{repo}/private-vulnerability-reporting

        Disables private vulnerability reporting for a repository. The authenticated user must have admin access to the repository. For more information, see "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)".

        See also: https://docs.github.com/rest/repos/repos#disable-private-vulnerability-reporting-for-a-repository
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": BasicError,
            },
        )

    async def async_disable_private_vulnerability_reporting(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/disable-private-vulnerability-reporting

        DELETE /repos/{owner}/{repo}/private-vulnerability-reporting

        Disables private vulnerability reporting for a repository. The authenticated user must have admin access to the repository. For more information, see "[Privately reporting a security vulnerability](https://docs.github.com/code-security/security-advisories/guidance-on-reporting-and-writing/privately-reporting-a-security-vulnerability)".

        See also: https://docs.github.com/rest/repos/repos#disable-private-vulnerability-reporting-for-a-repository
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/private-vulnerability-reporting"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "422": BasicError,
            },
        )

    def get_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CustomPropertyValue], list[CustomPropertyValueType]]:
        """repos/get-custom-properties-values

        GET /repos/{owner}/{repo}/properties/values

        Gets all custom property values that are set for a repository.
        Users with read access to the repository can use this endpoint.

        See also: https://docs.github.com/rest/repos/custom-properties#get-all-custom-property-values-for-a-repository
        """

        from ..models import BasicError, CustomPropertyValue

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomPropertyValue],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_get_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CustomPropertyValue], list[CustomPropertyValueType]]:
        """repos/get-custom-properties-values

        GET /repos/{owner}/{repo}/properties/values

        Gets all custom property values that are set for a repository.
        Users with read access to the repository can use this endpoint.

        See also: https://docs.github.com/rest/repos/custom-properties#get-all-custom-property-values-for-a-repository
        """

        from ..models import BasicError, CustomPropertyValue

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CustomPropertyValue],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    def create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    def create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """repos/create-or-update-custom-properties-values

        PATCH /repos/{owner}/{repo}/properties/values

        Create new or update existing custom property values for a repository.
        Using a value of `null` for a custom property will remove or 'unset' the property value from the repository.

        Repository admins and other users with the repository-level "edit custom property values" fine-grained permission can use this endpoint.

        See also: https://docs.github.com/rest/repos/custom-properties#create-or-update-custom-property-values-for-a-repository
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoPropertiesValuesPatchBodyType,
    ) -> Response: ...

    @overload
    async def async_create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        properties: list[CustomPropertyValueType],
    ) -> Response: ...

    async def async_create_or_update_custom_properties_values(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoPropertiesValuesPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response:
        """repos/create-or-update-custom-properties-values

        PATCH /repos/{owner}/{repo}/properties/values

        Create new or update existing custom property values for a repository.
        Using a value of `null` for a custom property will remove or 'unset' the property value from the repository.

        Repository admins and other users with the repository-level "edit custom property values" fine-grained permission can use this endpoint.

        See also: https://docs.github.com/rest/repos/custom-properties#create-or-update-custom-property-values-for-a-repository
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoPropertiesValuesPatchBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/properties/values"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoPropertiesValuesPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_readme(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ContentFile, ContentFileType]:
        """repos/get-readme

        GET /repos/{owner}/{repo}/readme

        Gets the preferred README for a repository.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
        - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).

        See also: https://docs.github.com/rest/repos/contents#get-a-repository-readme
        """

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ContentFile, ContentFileType]:
        """repos/get-readme

        GET /repos/{owner}/{repo}/readme

        Gets the preferred README for a repository.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
        - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).

        See also: https://docs.github.com/rest/repos/contents#get-a-repository-readme
        """

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ContentFile, ContentFileType]:
        """repos/get-readme-in-directory

        GET /repos/{owner}/{repo}/readme/{dir}

        Gets the README from a repository directory.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
        - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).

        See also: https://docs.github.com/rest/repos/contents#get-a-repository-readme-for-a-directory
        """

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    async def async_get_readme_in_directory(
        self,
        owner: str,
        repo: str,
        dir_: str,
        *,
        ref: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ContentFile, ContentFileType]:
        """repos/get-readme-in-directory

        GET /repos/{owner}/{repo}/readme/{dir}

        Gets the README from a repository directory.

        This endpoint supports the following custom media types. For more information, see "[Media types](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types)."

        - **`application/vnd.github.raw+json`**: Returns the raw file contents. This is the default if you do not specify a media type.
        - **`application/vnd.github.html+json`**: Returns the README in HTML. Markup languages are rendered to HTML using GitHub's open-source [Markup library](https://github.com/github/markup).

        See also: https://docs.github.com/rest/repos/contents#get-a-repository-readme-for-a-directory
        """

        from ..models import BasicError, ContentFile, ValidationError

        url = f"/repos/{owner}/{repo}/readme/{dir}"

        params = {
            "ref": ref,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ContentFile,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def list_releases(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Release], list[ReleaseType]]:
        """repos/list-releases

        GET /repos/{owner}/{repo}/releases

        This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/rest/repos/repos#list-repository-tags).

        Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.

        See also: https://docs.github.com/rest/releases/releases#list-releases
        """

        from ..models import BasicError, Release

        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Release],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_releases(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Release], list[ReleaseType]]:
        """repos/list-releases

        GET /repos/{owner}/{repo}/releases

        This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/rest/repos/repos#list-repository-tags).

        Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.

        See also: https://docs.github.com/rest/releases/releases#list-releases
        """

        from ..models import BasicError, Release

        url = f"/repos/{owner}/{repo}/releases"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Release],
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoReleasesPostBodyType,
    ) -> Response[Release, ReleaseType]: ...

    @overload
    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
        generate_release_notes: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    def create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release, ReleaseType]:
        """repos/create-release

        POST /repos/{owner}/{repo}/releases

        Users with push access to the repository can create a release.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        See also: https://docs.github.com/rest/releases/releases#create-a-release
        """

        from ..models import (
            BasicError,
            Release,
            ReposOwnerRepoReleasesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/releases"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoReleasesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    @overload
    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoReleasesPostBodyType,
    ) -> Response[Release, ReleaseType]: ...

    @overload
    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
        generate_release_notes: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    async def async_create_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release, ReleaseType]:
        """repos/create-release

        POST /repos/{owner}/{repo}/releases

        Users with push access to the repository can create a release.

        This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. For more information, see "[Rate limits for the API](https://docs.github.com/rest/using-the-rest-api/rate-limits-for-the-rest-api#about-secondary-rate-limits)" and "[Best practices for using the REST API](https://docs.github.com/rest/guides/best-practices-for-using-the-rest-api)."

        See also: https://docs.github.com/rest/releases/releases#create-a-release
        """

        from ..models import (
            BasicError,
            Release,
            ReposOwnerRepoReleasesPostBody,
            ValidationError,
        )

        url = f"/repos/{owner}/{repo}/releases"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoReleasesPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
            error_models={
                "404": BasicError,
                "422": ValidationError,
            },
        )

    def get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """repos/get-release-asset

        GET /repos/{owner}/{repo}/releases/assets/{asset_id}

        To download the asset's binary content:

        - If within a browser, fetch the location specified in the `browser_download_url` key provided in the response.
        - Alternatively, set the `Accept` header of the request to
          [`application/octet-stream`](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types).
          The API will either redirect the client to the location, or stream it directly if possible.
          API clients should handle both a `200` or `302` response.

        See also: https://docs.github.com/rest/releases/assets#get-a-release-asset
        """

        from ..models import BasicError, ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """repos/get-release-asset

        GET /repos/{owner}/{repo}/releases/assets/{asset_id}

        To download the asset's binary content:

        - If within a browser, fetch the location specified in the `browser_download_url` key provided in the response.
        - Alternatively, set the `Accept` header of the request to
          [`application/octet-stream`](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#media-types).
          The API will either redirect the client to the location, or stream it directly if possible.
          API clients should handle both a `200` or `302` response.

        See also: https://docs.github.com/rest/releases/assets#get-a-release-asset
        """

        from ..models import BasicError, ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReleaseAsset,
            error_models={
                "404": BasicError,
            },
        )

    def delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-release-asset

        DELETE /repos/{owner}/{repo}/releases/assets/{asset_id}

        See also: https://docs.github.com/rest/releases/assets#delete-a-release-asset
        """

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-release-asset

        DELETE /repos/{owner}/{repo}/releases/assets/{asset_id}

        See also: https://docs.github.com/rest/releases/assets#delete-a-release-asset
        """

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> Response[ReleaseAsset, ReleaseAssetType]: ...

    @overload
    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        label: Missing[str] = UNSET,
        state: Missing[str] = UNSET,
    ) -> Response[ReleaseAsset, ReleaseAssetType]: ...

    def update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """repos/update-release-asset

        PATCH /repos/{owner}/{repo}/releases/assets/{asset_id}

        Users with push access to the repository can edit a release asset.

        See also: https://docs.github.com/rest/releases/assets#update-a-release-asset
        """

        from ..models import ReleaseAsset, ReposOwnerRepoReleasesAssetsAssetIdPatchBody

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReleaseAsset,
        )

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
    ) -> Response[ReleaseAsset, ReleaseAssetType]: ...

    @overload
    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        label: Missing[str] = UNSET,
        state: Missing[str] = UNSET,
    ) -> Response[ReleaseAsset, ReleaseAssetType]: ...

    async def async_update_release_asset(
        self,
        owner: str,
        repo: str,
        asset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesAssetsAssetIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """repos/update-release-asset

        PATCH /repos/{owner}/{repo}/releases/assets/{asset_id}

        Users with push access to the repository can edit a release asset.

        See also: https://docs.github.com/rest/releases/assets#update-a-release-asset
        """

        from ..models import ReleaseAsset, ReposOwnerRepoReleasesAssetsAssetIdPatchBody

        url = f"/repos/{owner}/{repo}/releases/assets/{asset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesAssetsAssetIdPatchBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReleaseAsset,
        )

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]: ...

    @overload
    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        previous_tag_name: Missing[str] = UNSET,
        configuration_file_path: Missing[str] = UNSET,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]: ...

    def generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]:
        """repos/generate-release-notes

        POST /repos/{owner}/{repo}/releases/generate-notes

        Generate a name and body describing a [release](https://docs.github.com/rest/releases/releases#get-a-release). The body content will be markdown formatted and contain information like the changes since last release and users who contributed. The generated release notes are not saved anywhere. They are intended to be generated and used when creating a new release.

        See also: https://docs.github.com/rest/releases/releases#generate-release-notes-content-for-a-release
        """

        from ..models import (
            BasicError,
            ReleaseNotesContent,
            ReposOwnerRepoReleasesGenerateNotesPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesGenerateNotesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoReleasesGenerateNotesPostBodyType,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]: ...

    @overload
    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tag_name: str,
        target_commitish: Missing[str] = UNSET,
        previous_tag_name: Missing[str] = UNSET,
        configuration_file_path: Missing[str] = UNSET,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]: ...

    async def async_generate_release_notes(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesGenerateNotesPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[ReleaseNotesContent, ReleaseNotesContentType]:
        """repos/generate-release-notes

        POST /repos/{owner}/{repo}/releases/generate-notes

        Generate a name and body describing a [release](https://docs.github.com/rest/releases/releases#get-a-release). The body content will be markdown formatted and contain information like the changes since last release and users who contributed. The generated release notes are not saved anywhere. They are intended to be generated and used when creating a new release.

        See also: https://docs.github.com/rest/releases/releases#generate-release-notes-content-for-a-release
        """

        from ..models import (
            BasicError,
            ReleaseNotesContent,
            ReposOwnerRepoReleasesGenerateNotesPostBody,
        )

        url = f"/repos/{owner}/{repo}/releases/generate-notes"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposOwnerRepoReleasesGenerateNotesPostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReleaseNotesContent,
            error_models={
                "404": BasicError,
            },
        )

    def get_latest_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Release, ReleaseType]:
        """repos/get-latest-release

        GET /repos/{owner}/{repo}/releases/latest

        View the latest published full release for the repository.

        The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.

        See also: https://docs.github.com/rest/releases/releases#get-the-latest-release
        """

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
        )

    async def async_get_latest_release(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Release, ReleaseType]:
        """repos/get-latest-release

        GET /repos/{owner}/{repo}/releases/latest

        View the latest published full release for the repository.

        The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.

        See also: https://docs.github.com/rest/releases/releases#get-the-latest-release
        """

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/latest"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
        )

    def get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Release, ReleaseType]:
        """repos/get-release-by-tag

        GET /repos/{owner}/{repo}/releases/tags/{tag}

        Get a published release with the specified tag.

        See also: https://docs.github.com/rest/releases/releases#get-a-release-by-tag-name
        """

        from ..models import BasicError, Release

        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_release_by_tag(
        self,
        owner: str,
        repo: str,
        tag: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Release, ReleaseType]:
        """repos/get-release-by-tag

        GET /repos/{owner}/{repo}/releases/tags/{tag}

        Get a published release with the specified tag.

        See also: https://docs.github.com/rest/releases/releases#get-a-release-by-tag-name
        """

        from ..models import BasicError, Release

        url = f"/repos/{owner}/{repo}/releases/tags/{tag}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Release, ReleaseType]:
        """repos/get-release

        GET /repos/{owner}/{repo}/releases/{release_id}

        Gets a public release with the specified release ID.

        > [!NOTE]
        > This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a hypermedia resource. For more information, see "[Getting started with the REST API](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."

        See also: https://docs.github.com/rest/releases/releases#get-a-release
        """

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
            error_models={},
        )

    async def async_get_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Release, ReleaseType]:
        """repos/get-release

        GET /repos/{owner}/{repo}/releases/{release_id}

        Gets a public release with the specified release ID.

        > [!NOTE]
        > This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a hypermedia resource. For more information, see "[Getting started with the REST API](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia)."

        See also: https://docs.github.com/rest/releases/releases#get-a-release
        """

        from ..models import Release

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
            error_models={},
        )

    def delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-release

        DELETE /repos/{owner}/{repo}/releases/{release_id}

        Users with push access to the repository can delete a release.

        See also: https://docs.github.com/rest/releases/releases#delete-a-release
        """

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_delete_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-release

        DELETE /repos/{owner}/{repo}/releases/{release_id}

        Users with push access to the repository can delete a release.

        See also: https://docs.github.com/rest/releases/releases#delete-a-release
        """

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    @overload
    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tag_name: Missing[str] = UNSET,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    def update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release, ReleaseType]:
        """repos/update-release

        PATCH /repos/{owner}/{repo}/releases/{release_id}

        Users with push access to the repository can edit a release.

        See also: https://docs.github.com/rest/releases/releases#update-a-release
        """

        from ..models import (
            BasicError,
            Release,
            ReposOwnerRepoReleasesReleaseIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    @overload
    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        tag_name: Missing[str] = UNSET,
        target_commitish: Missing[str] = UNSET,
        name: Missing[str] = UNSET,
        body: Missing[str] = UNSET,
        draft: Missing[bool] = UNSET,
        prerelease: Missing[bool] = UNSET,
        make_latest: Missing[Literal["true", "false", "legacy"]] = UNSET,
        discussion_category_name: Missing[str] = UNSET,
    ) -> Response[Release, ReleaseType]: ...

    async def async_update_release(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoReleasesReleaseIdPatchBodyType] = UNSET,
        **kwargs,
    ) -> Response[Release, ReleaseType]:
        """repos/update-release

        PATCH /repos/{owner}/{repo}/releases/{release_id}

        Users with push access to the repository can edit a release.

        See also: https://docs.github.com/rest/releases/releases#update-a-release
        """

        from ..models import (
            BasicError,
            Release,
            ReposOwnerRepoReleasesReleaseIdPatchBody,
        )

        url = f"/repos/{owner}/{repo}/releases/{release_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoReleasesReleaseIdPatchBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PATCH",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Release,
            error_models={
                "404": BasicError,
            },
        )

    def list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ReleaseAsset], list[ReleaseAssetType]]:
        """repos/list-release-assets

        GET /repos/{owner}/{repo}/releases/{release_id}/assets

        See also: https://docs.github.com/rest/releases/assets#list-release-assets
        """

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ReleaseAsset],
        )

    async def async_list_release_assets(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ReleaseAsset], list[ReleaseAssetType]]:
        """repos/list-release-assets

        GET /repos/{owner}/{repo}/releases/{release_id}/assets

        See also: https://docs.github.com/rest/releases/assets#list-release-assets
        """

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ReleaseAsset],
        )

    def upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        name: str,
        label: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: FileTypes,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """repos/upload-release-asset

        POST /repos/{owner}/{repo}/releases/{release_id}/assets

        This endpoint makes use of a [Hypermedia relation](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
        the response of the [Create a release endpoint](https://docs.github.com/rest/releases/releases#create-a-release) to upload a release asset.

        You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.

        Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example:

        `application/zip`

        GitHub expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
        you'll still need to pass your authentication to be able to upload an asset.

        When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.

        **Notes:**
        *   GitHub renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List release assets](https://docs.github.com/rest/releases/assets#list-release-assets)"
        endpoint lists the renamed filenames. For more information and help, contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
        *   To find the `release_id` query the [`GET /repos/{owner}/{repo}/releases/latest` endpoint](https://docs.github.com/rest/releases/releases#get-the-latest-release).
        *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.

        See also: https://docs.github.com/rest/releases/assets#upload-a-release-asset
        """

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        headers = {
            "Content-Type": "application/octet-stream",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        content = data

        return self._github.request(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReleaseAsset,
            error_models={},
        )

    async def async_upload_release_asset(
        self,
        owner: str,
        repo: str,
        release_id: int,
        *,
        name: str,
        label: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: FileTypes,
    ) -> Response[ReleaseAsset, ReleaseAssetType]:
        """repos/upload-release-asset

        POST /repos/{owner}/{repo}/releases/{release_id}/assets

        This endpoint makes use of a [Hypermedia relation](https://docs.github.com/rest/using-the-rest-api/getting-started-with-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
        the response of the [Create a release endpoint](https://docs.github.com/rest/releases/releases#create-a-release) to upload a release asset.

        You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.

        Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example:

        `application/zip`

        GitHub expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
        you'll still need to pass your authentication to be able to upload an asset.

        When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.

        **Notes:**
        *   GitHub renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List release assets](https://docs.github.com/rest/releases/assets#list-release-assets)"
        endpoint lists the renamed filenames. For more information and help, contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
        *   To find the `release_id` query the [`GET /repos/{owner}/{repo}/releases/latest` endpoint](https://docs.github.com/rest/releases/releases#get-the-latest-release).
        *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.

        See also: https://docs.github.com/rest/releases/assets#upload-a-release-asset
        """

        from ..models import ReleaseAsset

        url = f"/repos/{owner}/{repo}/releases/{release_id}/assets"

        params = {
            "name": name,
            "label": label,
        }

        headers = {
            "Content-Type": "application/octet-stream",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        content = data

        return await self._github.arequest(
            "POST",
            url,
            params=exclude_unset(params),
            content=exclude_unset(content),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ReleaseAsset,
            error_models={},
        )

    def get_branch_rules(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[
            Union[
                RepositoryRuleDetailedOneof0,
                RepositoryRuleDetailedOneof1,
                RepositoryRuleDetailedOneof2,
                RepositoryRuleDetailedOneof3,
                RepositoryRuleDetailedOneof4,
                RepositoryRuleDetailedOneof5,
                RepositoryRuleDetailedOneof6,
                RepositoryRuleDetailedOneof7,
                RepositoryRuleDetailedOneof8,
                RepositoryRuleDetailedOneof9,
                RepositoryRuleDetailedOneof10,
                RepositoryRuleDetailedOneof11,
                RepositoryRuleDetailedOneof12,
                RepositoryRuleDetailedOneof13,
                RepositoryRuleDetailedOneof14,
                RepositoryRuleDetailedOneof15,
                RepositoryRuleDetailedOneof16,
                RepositoryRuleDetailedOneof17,
                RepositoryRuleDetailedOneof18,
                RepositoryRuleDetailedOneof19,
                RepositoryRuleDetailedOneof20,
            ]
        ],
        list[
            Union[
                RepositoryRuleDetailedOneof0Type,
                RepositoryRuleDetailedOneof1Type,
                RepositoryRuleDetailedOneof2Type,
                RepositoryRuleDetailedOneof3Type,
                RepositoryRuleDetailedOneof4Type,
                RepositoryRuleDetailedOneof5Type,
                RepositoryRuleDetailedOneof6Type,
                RepositoryRuleDetailedOneof7Type,
                RepositoryRuleDetailedOneof8Type,
                RepositoryRuleDetailedOneof9Type,
                RepositoryRuleDetailedOneof10Type,
                RepositoryRuleDetailedOneof11Type,
                RepositoryRuleDetailedOneof12Type,
                RepositoryRuleDetailedOneof13Type,
                RepositoryRuleDetailedOneof14Type,
                RepositoryRuleDetailedOneof15Type,
                RepositoryRuleDetailedOneof16Type,
                RepositoryRuleDetailedOneof17Type,
                RepositoryRuleDetailedOneof18Type,
                RepositoryRuleDetailedOneof19Type,
                RepositoryRuleDetailedOneof20Type,
            ]
        ],
    ]:
        """repos/get-branch-rules

        GET /repos/{owner}/{repo}/rules/branches/{branch}

        Returns all active rules that apply to the specified branch. The branch does not need to exist; rules that would apply
        to a branch with that name will be returned. All active rules that apply will be returned, regardless of the level
        at which they are configured (e.g. repository or organization). Rules in rulesets with "evaluate" or "disabled"
        enforcement statuses are not returned.

        See also: https://docs.github.com/rest/repos/rules#get-rules-for-a-branch
        """

        from typing import Union

        from ..models import (
            RepositoryRuleDetailedOneof0,
            RepositoryRuleDetailedOneof1,
            RepositoryRuleDetailedOneof2,
            RepositoryRuleDetailedOneof3,
            RepositoryRuleDetailedOneof4,
            RepositoryRuleDetailedOneof5,
            RepositoryRuleDetailedOneof6,
            RepositoryRuleDetailedOneof7,
            RepositoryRuleDetailedOneof8,
            RepositoryRuleDetailedOneof9,
            RepositoryRuleDetailedOneof10,
            RepositoryRuleDetailedOneof11,
            RepositoryRuleDetailedOneof12,
            RepositoryRuleDetailedOneof13,
            RepositoryRuleDetailedOneof14,
            RepositoryRuleDetailedOneof15,
            RepositoryRuleDetailedOneof16,
            RepositoryRuleDetailedOneof17,
            RepositoryRuleDetailedOneof18,
            RepositoryRuleDetailedOneof19,
            RepositoryRuleDetailedOneof20,
        )

        url = f"/repos/{owner}/{repo}/rules/branches/{branch}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[
                Union[
                    RepositoryRuleDetailedOneof0,
                    RepositoryRuleDetailedOneof1,
                    RepositoryRuleDetailedOneof2,
                    RepositoryRuleDetailedOneof3,
                    RepositoryRuleDetailedOneof4,
                    RepositoryRuleDetailedOneof5,
                    RepositoryRuleDetailedOneof6,
                    RepositoryRuleDetailedOneof7,
                    RepositoryRuleDetailedOneof8,
                    RepositoryRuleDetailedOneof9,
                    RepositoryRuleDetailedOneof10,
                    RepositoryRuleDetailedOneof11,
                    RepositoryRuleDetailedOneof12,
                    RepositoryRuleDetailedOneof13,
                    RepositoryRuleDetailedOneof14,
                    RepositoryRuleDetailedOneof15,
                    RepositoryRuleDetailedOneof16,
                    RepositoryRuleDetailedOneof17,
                    RepositoryRuleDetailedOneof18,
                    RepositoryRuleDetailedOneof19,
                    RepositoryRuleDetailedOneof20,
                ]
            ],
        )

    async def async_get_branch_rules(
        self,
        owner: str,
        repo: str,
        branch: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[
        list[
            Union[
                RepositoryRuleDetailedOneof0,
                RepositoryRuleDetailedOneof1,
                RepositoryRuleDetailedOneof2,
                RepositoryRuleDetailedOneof3,
                RepositoryRuleDetailedOneof4,
                RepositoryRuleDetailedOneof5,
                RepositoryRuleDetailedOneof6,
                RepositoryRuleDetailedOneof7,
                RepositoryRuleDetailedOneof8,
                RepositoryRuleDetailedOneof9,
                RepositoryRuleDetailedOneof10,
                RepositoryRuleDetailedOneof11,
                RepositoryRuleDetailedOneof12,
                RepositoryRuleDetailedOneof13,
                RepositoryRuleDetailedOneof14,
                RepositoryRuleDetailedOneof15,
                RepositoryRuleDetailedOneof16,
                RepositoryRuleDetailedOneof17,
                RepositoryRuleDetailedOneof18,
                RepositoryRuleDetailedOneof19,
                RepositoryRuleDetailedOneof20,
            ]
        ],
        list[
            Union[
                RepositoryRuleDetailedOneof0Type,
                RepositoryRuleDetailedOneof1Type,
                RepositoryRuleDetailedOneof2Type,
                RepositoryRuleDetailedOneof3Type,
                RepositoryRuleDetailedOneof4Type,
                RepositoryRuleDetailedOneof5Type,
                RepositoryRuleDetailedOneof6Type,
                RepositoryRuleDetailedOneof7Type,
                RepositoryRuleDetailedOneof8Type,
                RepositoryRuleDetailedOneof9Type,
                RepositoryRuleDetailedOneof10Type,
                RepositoryRuleDetailedOneof11Type,
                RepositoryRuleDetailedOneof12Type,
                RepositoryRuleDetailedOneof13Type,
                RepositoryRuleDetailedOneof14Type,
                RepositoryRuleDetailedOneof15Type,
                RepositoryRuleDetailedOneof16Type,
                RepositoryRuleDetailedOneof17Type,
                RepositoryRuleDetailedOneof18Type,
                RepositoryRuleDetailedOneof19Type,
                RepositoryRuleDetailedOneof20Type,
            ]
        ],
    ]:
        """repos/get-branch-rules

        GET /repos/{owner}/{repo}/rules/branches/{branch}

        Returns all active rules that apply to the specified branch. The branch does not need to exist; rules that would apply
        to a branch with that name will be returned. All active rules that apply will be returned, regardless of the level
        at which they are configured (e.g. repository or organization). Rules in rulesets with "evaluate" or "disabled"
        enforcement statuses are not returned.

        See also: https://docs.github.com/rest/repos/rules#get-rules-for-a-branch
        """

        from typing import Union

        from ..models import (
            RepositoryRuleDetailedOneof0,
            RepositoryRuleDetailedOneof1,
            RepositoryRuleDetailedOneof2,
            RepositoryRuleDetailedOneof3,
            RepositoryRuleDetailedOneof4,
            RepositoryRuleDetailedOneof5,
            RepositoryRuleDetailedOneof6,
            RepositoryRuleDetailedOneof7,
            RepositoryRuleDetailedOneof8,
            RepositoryRuleDetailedOneof9,
            RepositoryRuleDetailedOneof10,
            RepositoryRuleDetailedOneof11,
            RepositoryRuleDetailedOneof12,
            RepositoryRuleDetailedOneof13,
            RepositoryRuleDetailedOneof14,
            RepositoryRuleDetailedOneof15,
            RepositoryRuleDetailedOneof16,
            RepositoryRuleDetailedOneof17,
            RepositoryRuleDetailedOneof18,
            RepositoryRuleDetailedOneof19,
            RepositoryRuleDetailedOneof20,
        )

        url = f"/repos/{owner}/{repo}/rules/branches/{branch}"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[
                Union[
                    RepositoryRuleDetailedOneof0,
                    RepositoryRuleDetailedOneof1,
                    RepositoryRuleDetailedOneof2,
                    RepositoryRuleDetailedOneof3,
                    RepositoryRuleDetailedOneof4,
                    RepositoryRuleDetailedOneof5,
                    RepositoryRuleDetailedOneof6,
                    RepositoryRuleDetailedOneof7,
                    RepositoryRuleDetailedOneof8,
                    RepositoryRuleDetailedOneof9,
                    RepositoryRuleDetailedOneof10,
                    RepositoryRuleDetailedOneof11,
                    RepositoryRuleDetailedOneof12,
                    RepositoryRuleDetailedOneof13,
                    RepositoryRuleDetailedOneof14,
                    RepositoryRuleDetailedOneof15,
                    RepositoryRuleDetailedOneof16,
                    RepositoryRuleDetailedOneof17,
                    RepositoryRuleDetailedOneof18,
                    RepositoryRuleDetailedOneof19,
                    RepositoryRuleDetailedOneof20,
                ]
            ],
        )

    def get_repo_rulesets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        includes_parents: Missing[bool] = UNSET,
        targets: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryRuleset], list[RepositoryRulesetType]]:
        """repos/get-repo-rulesets

        GET /repos/{owner}/{repo}/rulesets

        Get all the rulesets for a repository.

        See also: https://docs.github.com/rest/repos/rules#get-all-repository-rulesets
        """

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "includes_parents": includes_parents,
            "targets": targets,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rulesets(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        includes_parents: Missing[bool] = UNSET,
        targets: Missing[str] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryRuleset], list[RepositoryRulesetType]]:
        """repos/get-repo-rulesets

        GET /repos/{owner}/{repo}/rulesets

        Get all the rulesets for a repository.

        See also: https://docs.github.com/rest/repos/rules#get-all-repository-rulesets
        """

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets"

        params = {
            "per_page": per_page,
            "page": page,
            "includes_parents": includes_parents,
            "targets": targets,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryRuleset],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleFilePathRestrictionType,
                    RepositoryRuleMaxFilePathLengthType,
                    RepositoryRuleFileExtensionRestrictionType,
                    RepositoryRuleMaxFileSizeType,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/create-repo-ruleset

        POST /repos/{owner}/{repo}/rulesets

        Create a ruleset for a repository.

        See also: https://docs.github.com/rest/repos/rules#create-a-repository-ruleset
        """

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsPostBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoRulesetsPostBodyType,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Literal["disabled", "active", "evaluate"],
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleFilePathRestrictionType,
                    RepositoryRuleMaxFilePathLengthType,
                    RepositoryRuleFileExtensionRestrictionType,
                    RepositoryRuleMaxFileSizeType,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_create_repo_ruleset(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoRulesetsPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/create-repo-ruleset

        POST /repos/{owner}/{repo}/rulesets

        Create a ruleset for a repository.

        See also: https://docs.github.com/rest/repos/rules#create-a-repository-ruleset
        """

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsPostBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoRulesetsPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_rule_suites(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RuleSuitesItems], list[RuleSuitesItemsType]]:
        """repos/get-repo-rule-suites

        GET /repos/{owner}/{repo}/rulesets/rule-suites

        Lists suites of rule evaluations at the repository level.
        For more information, see "[Managing rulesets for a repository](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets/managing-rulesets-for-a-repository#viewing-insights-for-rulesets)."

        See also: https://docs.github.com/rest/repos/rule-suites#list-repository-rule-suites
        """

        from ..models import BasicError, RuleSuitesItems

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rule_suites(
        self,
        owner: str,
        repo: str,
        *,
        ref: Missing[str] = UNSET,
        time_period: Missing[Literal["hour", "day", "week", "month"]] = UNSET,
        actor_name: Missing[str] = UNSET,
        rule_suite_result: Missing[Literal["pass", "fail", "bypass", "all"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RuleSuitesItems], list[RuleSuitesItemsType]]:
        """repos/get-repo-rule-suites

        GET /repos/{owner}/{repo}/rulesets/rule-suites

        Lists suites of rule evaluations at the repository level.
        For more information, see "[Managing rulesets for a repository](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets/managing-rulesets-for-a-repository#viewing-insights-for-rulesets)."

        See also: https://docs.github.com/rest/repos/rule-suites#list-repository-rule-suites
        """

        from ..models import BasicError, RuleSuitesItems

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites"

        params = {
            "ref": ref,
            "time_period": time_period,
            "actor_name": actor_name,
            "rule_suite_result": rule_suite_result,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RuleSuitesItems],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_rule_suite(
        self,
        owner: str,
        repo: str,
        rule_suite_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RuleSuite, RuleSuiteType]:
        """repos/get-repo-rule-suite

        GET /repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}

        Gets information about a suite of rule evaluations from within a repository.
        For more information, see "[Managing rulesets for a repository](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets/managing-rulesets-for-a-repository#viewing-insights-for-rulesets)."

        See also: https://docs.github.com/rest/repos/rule-suites#get-a-repository-rule-suite
        """

        from ..models import BasicError, RuleSuite

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_rule_suite(
        self,
        owner: str,
        repo: str,
        rule_suite_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RuleSuite, RuleSuiteType]:
        """repos/get-repo-rule-suite

        GET /repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}

        Gets information about a suite of rule evaluations from within a repository.
        For more information, see "[Managing rulesets for a repository](https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-rulesets/managing-rulesets-for-a-repository#viewing-insights-for-rulesets)."

        See also: https://docs.github.com/rest/repos/rule-suites#get-a-repository-rule-suite
        """

        from ..models import BasicError, RuleSuite

        url = f"/repos/{owner}/{repo}/rulesets/rule-suites/{rule_suite_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RuleSuite,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        includes_parents: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/get-repo-ruleset

        GET /repos/{owner}/{repo}/rulesets/{ruleset_id}

        Get a ruleset for a repository.

        **Note:** To prevent leaking sensitive information, the `bypass_actors` property is only returned if the user
        making the API request has write access to the ruleset.

        See also: https://docs.github.com/rest/repos/rules#get-a-repository-ruleset
        """

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        includes_parents: Missing[bool] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/get-repo-ruleset

        GET /repos/{owner}/{repo}/rulesets/{ruleset_id}

        Get a ruleset for a repository.

        **Note:** To prevent leaking sensitive information, the `bypass_actors` property is only returned if the user
        making the API request has write access to the ruleset.

        See also: https://docs.github.com/rest/repos/rules#get-a-repository-ruleset
        """

        from ..models import BasicError, RepositoryRuleset

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        params = {
            "includes_parents": includes_parents,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleFilePathRestrictionType,
                    RepositoryRuleMaxFilePathLengthType,
                    RepositoryRuleFileExtensionRestrictionType,
                    RepositoryRuleMaxFileSizeType,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    def update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/update-repo-ruleset

        PUT /repos/{owner}/{repo}/rulesets/{ruleset_id}

        Update a ruleset for a repository.

        See also: https://docs.github.com/rest/repos/rules#update-a-repository-ruleset
        """

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsRulesetIdPutBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    @overload
    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    @overload
    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: Missing[str] = UNSET,
        target: Missing[Literal["branch", "tag", "push"]] = UNSET,
        enforcement: Missing[Literal["disabled", "active", "evaluate"]] = UNSET,
        bypass_actors: Missing[list[RepositoryRulesetBypassActorType]] = UNSET,
        conditions: Missing[RepositoryRulesetConditionsType] = UNSET,
        rules: Missing[
            list[
                Union[
                    RepositoryRuleCreationType,
                    RepositoryRuleUpdateType,
                    RepositoryRuleDeletionType,
                    RepositoryRuleRequiredLinearHistoryType,
                    RepositoryRuleMergeQueueType,
                    RepositoryRuleRequiredDeploymentsType,
                    RepositoryRuleRequiredSignaturesType,
                    RepositoryRulePullRequestType,
                    RepositoryRuleRequiredStatusChecksType,
                    RepositoryRuleNonFastForwardType,
                    RepositoryRuleCommitMessagePatternType,
                    RepositoryRuleCommitAuthorEmailPatternType,
                    RepositoryRuleCommitterEmailPatternType,
                    RepositoryRuleBranchNamePatternType,
                    RepositoryRuleTagNamePatternType,
                    RepositoryRuleFilePathRestrictionType,
                    RepositoryRuleMaxFilePathLengthType,
                    RepositoryRuleFileExtensionRestrictionType,
                    RepositoryRuleMaxFileSizeType,
                    RepositoryRuleWorkflowsType,
                    RepositoryRuleCodeScanningType,
                ]
            ]
        ] = UNSET,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]: ...

    async def async_update_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoRulesetsRulesetIdPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[RepositoryRuleset, RepositoryRulesetType]:
        """repos/update-repo-ruleset

        PUT /repos/{owner}/{repo}/rulesets/{ruleset_id}

        Update a ruleset for a repository.

        See also: https://docs.github.com/rest/repos/rules#update-a-repository-ruleset
        """

        from ..models import (
            BasicError,
            RepositoryRuleset,
            ReposOwnerRepoRulesetsRulesetIdPutBody,
        )

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoRulesetsRulesetIdPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RepositoryRuleset,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def delete_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-repo-ruleset

        DELETE /repos/{owner}/{repo}/rulesets/{ruleset_id}

        Delete a ruleset for a repository.

        See also: https://docs.github.com/rest/repos/rules#delete-a-repository-ruleset
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_delete_repo_ruleset(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/delete-repo-ruleset

        DELETE /repos/{owner}/{repo}/rulesets/{ruleset_id}

        Delete a ruleset for a repository.

        See also: https://docs.github.com/rest/repos/rules#delete-a-repository-ruleset
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_ruleset_history(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RulesetVersion], list[RulesetVersionType]]:
        """repos/get-repo-ruleset-history

        GET /repos/{owner}/{repo}/rulesets/{ruleset_id}/history

        Get the history of a repository ruleset.

        See also: https://docs.github.com/rest/repos/rules#get-repository-ruleset-history
        """

        from ..models import BasicError, RulesetVersion

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}/history"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RulesetVersion],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_ruleset_history(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RulesetVersion], list[RulesetVersionType]]:
        """repos/get-repo-ruleset-history

        GET /repos/{owner}/{repo}/rulesets/{ruleset_id}/history

        Get the history of a repository ruleset.

        See also: https://docs.github.com/rest/repos/rules#get-repository-ruleset-history
        """

        from ..models import BasicError, RulesetVersion

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}/history"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RulesetVersion],
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_repo_ruleset_version(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RulesetVersionWithState, RulesetVersionWithStateType]:
        """repos/get-repo-ruleset-version

        GET /repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}

        Get a version of a repository ruleset.

        See also: https://docs.github.com/rest/repos/rules#get-repository-ruleset-version
        """

        from ..models import BasicError, RulesetVersionWithState

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RulesetVersionWithState,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    async def async_get_repo_ruleset_version(
        self,
        owner: str,
        repo: str,
        ruleset_id: int,
        version_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[RulesetVersionWithState, RulesetVersionWithStateType]:
        """repos/get-repo-ruleset-version

        GET /repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}

        Get a version of a repository ruleset.

        See also: https://docs.github.com/rest/repos/rules#get-repository-ruleset-version
        """

        from ..models import BasicError, RulesetVersionWithState

        url = f"/repos/{owner}/{repo}/rulesets/{ruleset_id}/history/{version_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=RulesetVersionWithState,
            error_models={
                "404": BasicError,
                "500": BasicError,
            },
        )

    def get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[list[int]], list[list[int]]]:
        """repos/get-code-frequency-stats

        GET /repos/{owner}/{repo}/stats/code_frequency

        Returns a weekly aggregate of the number of additions and deletions pushed to a repository.

        > [!NOTE]
        > This endpoint can only be used for repositories with fewer than 10,000 commits. If the repository contains 10,000 or more commits, a 422 status code will be returned.

        See also: https://docs.github.com/rest/metrics/statistics#get-the-weekly-commit-activity
        """

        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[list[int]],
            error_models={},
        )

    async def async_get_code_frequency_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[list[int]], list[list[int]]]:
        """repos/get-code-frequency-stats

        GET /repos/{owner}/{repo}/stats/code_frequency

        Returns a weekly aggregate of the number of additions and deletions pushed to a repository.

        > [!NOTE]
        > This endpoint can only be used for repositories with fewer than 10,000 commits. If the repository contains 10,000 or more commits, a 422 status code will be returned.

        See also: https://docs.github.com/rest/metrics/statistics#get-the-weekly-commit-activity
        """

        url = f"/repos/{owner}/{repo}/stats/code_frequency"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[list[int]],
            error_models={},
        )

    def get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CommitActivity], list[CommitActivityType]]:
        """repos/get-commit-activity-stats

        GET /repos/{owner}/{repo}/stats/commit_activity

        Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`.

        See also: https://docs.github.com/rest/metrics/statistics#get-the-last-year-of-commit-activity
        """

        from ..models import CommitActivity

        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CommitActivity],
        )

    async def async_get_commit_activity_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[CommitActivity], list[CommitActivityType]]:
        """repos/get-commit-activity-stats

        GET /repos/{owner}/{repo}/stats/commit_activity

        Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`.

        See also: https://docs.github.com/rest/metrics/statistics#get-the-last-year-of-commit-activity
        """

        from ..models import CommitActivity

        url = f"/repos/{owner}/{repo}/stats/commit_activity"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[CommitActivity],
        )

    def get_contributors_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ContributorActivity], list[ContributorActivityType]]:
        """repos/get-contributors-stats

        GET /repos/{owner}/{repo}/stats/contributors


        Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:

        *   `w` - Start of the week, given as a [Unix timestamp](https://en.wikipedia.org/wiki/Unix_time).
        *   `a` - Number of additions
        *   `d` - Number of deletions
        *   `c` - Number of commits

        > [!NOTE]
        > This endpoint will return `0` values for all addition and deletion counts in repositories with 10,000 or more commits.

        See also: https://docs.github.com/rest/metrics/statistics#get-all-contributor-commit-activity
        """

        from ..models import ContributorActivity

        url = f"/repos/{owner}/{repo}/stats/contributors"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ContributorActivity],
        )

    async def async_get_contributors_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ContributorActivity], list[ContributorActivityType]]:
        """repos/get-contributors-stats

        GET /repos/{owner}/{repo}/stats/contributors


        Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:

        *   `w` - Start of the week, given as a [Unix timestamp](https://en.wikipedia.org/wiki/Unix_time).
        *   `a` - Number of additions
        *   `d` - Number of deletions
        *   `c` - Number of commits

        > [!NOTE]
        > This endpoint will return `0` values for all addition and deletion counts in repositories with 10,000 or more commits.

        See also: https://docs.github.com/rest/metrics/statistics#get-all-contributor-commit-activity
        """

        from ..models import ContributorActivity

        url = f"/repos/{owner}/{repo}/stats/contributors"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ContributorActivity],
        )

    def get_participation_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ParticipationStats, ParticipationStatsType]:
        """repos/get-participation-stats

        GET /repos/{owner}/{repo}/stats/participation

        Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.

        The array order is oldest week (index 0) to most recent week.

        The most recent week is seven days ago at UTC midnight to today at UTC midnight.

        See also: https://docs.github.com/rest/metrics/statistics#get-the-weekly-commit-count
        """

        from ..models import BasicError, ParticipationStats

        url = f"/repos/{owner}/{repo}/stats/participation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_participation_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ParticipationStats, ParticipationStatsType]:
        """repos/get-participation-stats

        GET /repos/{owner}/{repo}/stats/participation

        Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.

        The array order is oldest week (index 0) to most recent week.

        The most recent week is seven days ago at UTC midnight to today at UTC midnight.

        See also: https://docs.github.com/rest/metrics/statistics#get-the-weekly-commit-count
        """

        from ..models import BasicError, ParticipationStats

        url = f"/repos/{owner}/{repo}/stats/participation"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ParticipationStats,
            error_models={
                "404": BasicError,
            },
        )

    def get_punch_card_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[list[int]], list[list[int]]]:
        """repos/get-punch-card-stats

        GET /repos/{owner}/{repo}/stats/punch_card

        Each array contains the day number, hour number, and number of commits:

        *   `0-6`: Sunday - Saturday
        *   `0-23`: Hour of day
        *   Number of commits

        For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.

        See also: https://docs.github.com/rest/metrics/statistics#get-the-hourly-commit-count-for-each-day
        """

        url = f"/repos/{owner}/{repo}/stats/punch_card"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[list[int]],
        )

    async def async_get_punch_card_stats(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[list[int]], list[list[int]]]:
        """repos/get-punch-card-stats

        GET /repos/{owner}/{repo}/stats/punch_card

        Each array contains the day number, hour number, and number of commits:

        *   `0-6`: Sunday - Saturday
        *   `0-23`: Hour of day
        *   Number of commits

        For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.

        See also: https://docs.github.com/rest/metrics/statistics#get-the-hourly-commit-count-for-each-day
        """

        url = f"/repos/{owner}/{repo}/stats/punch_card"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[list[int]],
        )

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> Response[Status, StatusType]: ...

    @overload
    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[Status, StatusType]: ...

    def create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Status, StatusType]:
        """repos/create-commit-status

        POST /repos/{owner}/{repo}/statuses/{sha}

        Users with push access in a repository can create commit statuses for a given SHA.

        Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.

        See also: https://docs.github.com/rest/commits/statuses#create-a-commit-status
        """

        from ..models import ReposOwnerRepoStatusesShaPostBody, Status

        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoStatusesShaPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Status,
        )

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoStatusesShaPostBodyType,
    ) -> Response[Status, StatusType]: ...

    @overload
    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        state: Literal["error", "failure", "pending", "success"],
        target_url: Missing[Union[str, None]] = UNSET,
        description: Missing[Union[str, None]] = UNSET,
        context: Missing[str] = UNSET,
    ) -> Response[Status, StatusType]: ...

    async def async_create_commit_status(
        self,
        owner: str,
        repo: str,
        sha: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoStatusesShaPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[Status, StatusType]:
        """repos/create-commit-status

        POST /repos/{owner}/{repo}/statuses/{sha}

        Users with push access in a repository can create commit statuses for a given SHA.

        Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.

        See also: https://docs.github.com/rest/commits/statuses#create-a-commit-status
        """

        from ..models import ReposOwnerRepoStatusesShaPostBody, Status

        url = f"/repos/{owner}/{repo}/statuses/{sha}"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoStatusesShaPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Status,
        )

    def list_tags(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Tag], list[TagType]]:
        """repos/list-tags

        GET /repos/{owner}/{repo}/tags

        See also: https://docs.github.com/rest/repos/repos#list-repository-tags
        """

        from ..models import Tag

        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Tag],
        )

    async def async_list_tags(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Tag], list[TagType]]:
        """repos/list-tags

        GET /repos/{owner}/{repo}/tags

        See also: https://docs.github.com/rest/repos/repos#list-repository-tags
        """

        from ..models import Tag

        url = f"/repos/{owner}/{repo}/tags"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Tag],
        )

    def list_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[TagProtection], list[TagProtectionType]]:
        """DEPRECATED repos/list-tag-protection

        GET /repos/{owner}/{repo}/tags/protection

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#get-all-repository-rulesets)" endpoint instead.

        This returns the tag protection states of a repository.

        This information is only available to repository administrators.

        See also: https://docs.github.com/rest/repos/tags#closing-down---list-tag-protection-states-for-a-repository
        """

        from ..models import BasicError, TagProtection

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_list_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[TagProtection], list[TagProtectionType]]:
        """DEPRECATED repos/list-tag-protection

        GET /repos/{owner}/{repo}/tags/protection

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#get-all-repository-rulesets)" endpoint instead.

        This returns the tag protection states of a repository.

        This information is only available to repository administrators.

        See also: https://docs.github.com/rest/repos/tags#closing-down---list-tag-protection-states-for-a-repository
        """

        from ..models import BasicError, TagProtection

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[TagProtection],
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoTagsProtectionPostBodyType,
    ) -> Response[TagProtection, TagProtectionType]: ...

    @overload
    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        pattern: str,
    ) -> Response[TagProtection, TagProtectionType]: ...

    def create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TagProtection, TagProtectionType]:
        """DEPRECATED repos/create-tag-protection

        POST /repos/{owner}/{repo}/tags/protection

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#create-a-repository-ruleset)" endpoint instead.

        This creates a tag protection state for a repository.
        This endpoint is only available to repository administrators.

        See also: https://docs.github.com/rest/repos/tags#closing-down---create-a-tag-protection-state-for-a-repository
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoTagsProtectionPostBody,
            TagProtection,
        )

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTagsProtectionPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    @overload
    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoTagsProtectionPostBodyType,
    ) -> Response[TagProtection, TagProtectionType]: ...

    @overload
    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        pattern: str,
    ) -> Response[TagProtection, TagProtectionType]: ...

    async def async_create_tag_protection(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoTagsProtectionPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[TagProtection, TagProtectionType]:
        """DEPRECATED repos/create-tag-protection

        POST /repos/{owner}/{repo}/tags/protection

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#create-a-repository-ruleset)" endpoint instead.

        This creates a tag protection state for a repository.
        This endpoint is only available to repository administrators.

        See also: https://docs.github.com/rest/repos/tags#closing-down---create-a-tag-protection-state-for-a-repository
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoTagsProtectionPostBody,
            TagProtection,
        )

        url = f"/repos/{owner}/{repo}/tags/protection"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTagsProtectionPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=TagProtection,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED repos/delete-tag-protection

        DELETE /repos/{owner}/{repo}/tags/protection/{tag_protection_id}

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#delete-a-repository-ruleset)" endpoint instead.

        This deletes a tag protection state for a repository.
        This endpoint is only available to repository administrators.

        See also: https://docs.github.com/rest/repos/tags#closing-down---delete-a-tag-protection-state-for-a-repository
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    async def async_delete_tag_protection(
        self,
        owner: str,
        repo: str,
        tag_protection_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """DEPRECATED repos/delete-tag-protection

        DELETE /repos/{owner}/{repo}/tags/protection/{tag_protection_id}

        > [!WARNING]
        > **Closing down notice:** This operation is closing down and will be removed after August 30, 2024. Use the "[Repository Rulesets](https://docs.github.com/rest/repos/rules#delete-a-repository-ruleset)" endpoint instead.

        This deletes a tag protection state for a repository.
        This endpoint is only available to repository administrators.

        See also: https://docs.github.com/rest/repos/tags#closing-down---delete-a-tag-protection-state-for-a-repository
        """

        from ..models import BasicError

        url = f"/repos/{owner}/{repo}/tags/protection/{tag_protection_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "404": BasicError,
            },
        )

    def download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/download-tarball-archive

        GET /repos/{owner}/{repo}/tarball/{ref}

        Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
        `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
        the `Location` header to make a second `GET` request.

        > [!NOTE]
        > For private repositories, these links are temporary and expire after five minutes.

        See also: https://docs.github.com/rest/repos/contents#download-a-repository-archive-tar
        """

        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_download_tarball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/download-tarball-archive

        GET /repos/{owner}/{repo}/tarball/{ref}

        Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
        `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
        the `Location` header to make a second `GET` request.

        > [!NOTE]
        > For private repositories, these links are temporary and expire after five minutes.

        See also: https://docs.github.com/rest/repos/contents#download-a-repository-archive-tar
        """

        url = f"/repos/{owner}/{repo}/tarball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def list_teams(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/list-teams

        GET /repos/{owner}/{repo}/teams

        Lists the teams that have access to the specified repository and that are also visible to the authenticated user.

        For a public repository, a team is listed only if that team added the public repository explicitly.

        OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to use this endpoint with a public repository, and `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/repos/repos#list-repository-teams
        """

        from ..models import BasicError, Team

        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    async def async_list_teams(
        self,
        owner: str,
        repo: str,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Team], list[TeamType]]:
        """repos/list-teams

        GET /repos/{owner}/{repo}/teams

        Lists the teams that have access to the specified repository and that are also visible to the authenticated user.

        For a public repository, a team is listed only if that team added the public repository explicitly.

        OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to use this endpoint with a public repository, and `repo` scope to use this endpoint with a private repository.

        See also: https://docs.github.com/rest/repos/repos#list-repository-teams
        """

        from ..models import BasicError, Team

        url = f"/repos/{owner}/{repo}/teams"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Team],
            error_models={
                "404": BasicError,
            },
        )

    def get_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Topic, TopicType]:
        """repos/get-all-topics

        GET /repos/{owner}/{repo}/topics

        See also: https://docs.github.com/rest/repos/repos#get-all-repository-topics
        """

        from ..models import BasicError, Topic

        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    async def async_get_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        page: Missing[int] = UNSET,
        per_page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[Topic, TopicType]:
        """repos/get-all-topics

        GET /repos/{owner}/{repo}/topics

        See also: https://docs.github.com/rest/repos/repos#get-all-repository-topics
        """

        from ..models import BasicError, Topic

        url = f"/repos/{owner}/{repo}/topics"

        params = {
            "page": page,
            "per_page": per_page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Topic,
            error_models={
                "404": BasicError,
            },
        )

    @overload
    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoTopicsPutBodyType,
    ) -> Response[Topic, TopicType]: ...

    @overload
    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        names: list[str],
    ) -> Response[Topic, TopicType]: ...

    def replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Topic, TopicType]:
        """repos/replace-all-topics

        PUT /repos/{owner}/{repo}/topics

        See also: https://docs.github.com/rest/repos/repos#replace-all-repository-topics
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoTopicsPutBody,
            Topic,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/topics"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTopicsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    @overload
    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoTopicsPutBodyType,
    ) -> Response[Topic, TopicType]: ...

    @overload
    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        names: list[str],
    ) -> Response[Topic, TopicType]: ...

    async def async_replace_all_topics(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoTopicsPutBodyType] = UNSET,
        **kwargs,
    ) -> Response[Topic, TopicType]:
        """repos/replace-all-topics

        PUT /repos/{owner}/{repo}/topics

        See also: https://docs.github.com/rest/repos/repos#replace-all-repository-topics
        """

        from ..models import (
            BasicError,
            ReposOwnerRepoTopicsPutBody,
            Topic,
            ValidationErrorSimple,
        )

        url = f"/repos/{owner}/{repo}/topics"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTopicsPutBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "PUT",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=Topic,
            error_models={
                "404": BasicError,
                "422": ValidationErrorSimple,
            },
        )

    def get_clones(
        self,
        owner: str,
        repo: str,
        *,
        per: Missing[Literal["day", "week"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CloneTraffic, CloneTrafficType]:
        """repos/get-clones

        GET /repos/{owner}/{repo}/traffic/clones

        Get the total number of clones and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.

        See also: https://docs.github.com/rest/metrics/traffic#get-repository-clones
        """

        from ..models import BasicError, CloneTraffic

        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_clones(
        self,
        owner: str,
        repo: str,
        *,
        per: Missing[Literal["day", "week"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[CloneTraffic, CloneTrafficType]:
        """repos/get-clones

        GET /repos/{owner}/{repo}/traffic/clones

        Get the total number of clones and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.

        See also: https://docs.github.com/rest/metrics/traffic#get-repository-clones
        """

        from ..models import BasicError, CloneTraffic

        url = f"/repos/{owner}/{repo}/traffic/clones"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=CloneTraffic,
            error_models={
                "403": BasicError,
            },
        )

    def get_top_paths(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ContentTraffic], list[ContentTrafficType]]:
        """repos/get-top-paths

        GET /repos/{owner}/{repo}/traffic/popular/paths

        Get the top 10 popular contents over the last 14 days.

        See also: https://docs.github.com/rest/metrics/traffic#get-top-referral-paths
        """

        from ..models import BasicError, ContentTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_paths(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ContentTraffic], list[ContentTrafficType]]:
        """repos/get-top-paths

        GET /repos/{owner}/{repo}/traffic/popular/paths

        Get the top 10 popular contents over the last 14 days.

        See also: https://docs.github.com/rest/metrics/traffic#get-top-referral-paths
        """

        from ..models import BasicError, ContentTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/paths"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ContentTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_top_referrers(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ReferrerTraffic], list[ReferrerTrafficType]]:
        """repos/get-top-referrers

        GET /repos/{owner}/{repo}/traffic/popular/referrers

        Get the top 10 referrers over the last 14 days.

        See also: https://docs.github.com/rest/metrics/traffic#get-top-referral-sources
        """

        from ..models import BasicError, ReferrerTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_top_referrers(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[ReferrerTraffic], list[ReferrerTrafficType]]:
        """repos/get-top-referrers

        GET /repos/{owner}/{repo}/traffic/popular/referrers

        Get the top 10 referrers over the last 14 days.

        See also: https://docs.github.com/rest/metrics/traffic#get-top-referral-sources
        """

        from ..models import BasicError, ReferrerTraffic

        url = f"/repos/{owner}/{repo}/traffic/popular/referrers"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[ReferrerTraffic],
            error_models={
                "403": BasicError,
            },
        )

    def get_views(
        self,
        owner: str,
        repo: str,
        *,
        per: Missing[Literal["day", "week"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ViewTraffic, ViewTrafficType]:
        """repos/get-views

        GET /repos/{owner}/{repo}/traffic/views

        Get the total number of views and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.

        See also: https://docs.github.com/rest/metrics/traffic#get-page-views
        """

        from ..models import BasicError, ViewTraffic

        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    async def async_get_views(
        self,
        owner: str,
        repo: str,
        *,
        per: Missing[Literal["day", "week"]] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[ViewTraffic, ViewTrafficType]:
        """repos/get-views

        GET /repos/{owner}/{repo}/traffic/views

        Get the total number of views and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.

        See also: https://docs.github.com/rest/metrics/traffic#get-page-views
        """

        from ..models import BasicError, ViewTraffic

        url = f"/repos/{owner}/{repo}/traffic/views"

        params = {
            "per": per,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=ViewTraffic,
            error_models={
                "403": BasicError,
            },
        )

    @overload
    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoTransferPostBodyType,
    ) -> Response[MinimalRepository, MinimalRepositoryType]: ...

    @overload
    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        new_owner: str,
        new_name: Missing[str] = UNSET,
        team_ids: Missing[list[int]] = UNSET,
    ) -> Response[MinimalRepository, MinimalRepositoryType]: ...

    def transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MinimalRepository, MinimalRepositoryType]:
        """repos/transfer

        POST /repos/{owner}/{repo}/transfer

        A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://docs.github.com/articles/about-repository-transfers/).

        See also: https://docs.github.com/rest/repos/repos#transfer-a-repository
        """

        from ..models import MinimalRepository, ReposOwnerRepoTransferPostBody

        url = f"/repos/{owner}/{repo}/transfer"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTransferPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=MinimalRepository,
        )

    @overload
    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposOwnerRepoTransferPostBodyType,
    ) -> Response[MinimalRepository, MinimalRepositoryType]: ...

    @overload
    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        new_owner: str,
        new_name: Missing[str] = UNSET,
        team_ids: Missing[list[int]] = UNSET,
    ) -> Response[MinimalRepository, MinimalRepositoryType]: ...

    async def async_transfer(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposOwnerRepoTransferPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[MinimalRepository, MinimalRepositoryType]:
        """repos/transfer

        POST /repos/{owner}/{repo}/transfer

        A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://docs.github.com/articles/about-repository-transfers/).

        See also: https://docs.github.com/rest/repos/repos#transfer-a-repository
        """

        from ..models import MinimalRepository, ReposOwnerRepoTransferPostBody

        url = f"/repos/{owner}/{repo}/transfer"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(ReposOwnerRepoTransferPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=MinimalRepository,
        )

    def check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/check-vulnerability-alerts

        GET /repos/{owner}/{repo}/vulnerability-alerts

        Shows whether dependency alerts are enabled or disabled for a repository. The authenticated user must have admin read access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".

        See also: https://docs.github.com/rest/repos/repos#check-if-vulnerability-alerts-are-enabled-for-a-repository
        """

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    async def async_check_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/check-vulnerability-alerts

        GET /repos/{owner}/{repo}/vulnerability-alerts

        Shows whether dependency alerts are enabled or disabled for a repository. The authenticated user must have admin read access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".

        See also: https://docs.github.com/rest/repos/repos#check-if-vulnerability-alerts-are-enabled-for-a-repository
        """

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={},
        )

    def enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/enable-vulnerability-alerts

        PUT /repos/{owner}/{repo}/vulnerability-alerts

        Enables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".

        See also: https://docs.github.com/rest/repos/repos#enable-vulnerability-alerts
        """

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_enable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/enable-vulnerability-alerts

        PUT /repos/{owner}/{repo}/vulnerability-alerts

        Enables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".

        See also: https://docs.github.com/rest/repos/repos#enable-vulnerability-alerts
        """

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PUT",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/disable-vulnerability-alerts

        DELETE /repos/{owner}/{repo}/vulnerability-alerts

        Disables dependency alerts and the dependency graph for a repository.
        The authenticated user must have admin access to the repository. For more information,
        see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".

        See also: https://docs.github.com/rest/repos/repos#disable-vulnerability-alerts
        """

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_disable_vulnerability_alerts(
        self,
        owner: str,
        repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/disable-vulnerability-alerts

        DELETE /repos/{owner}/{repo}/vulnerability-alerts

        Disables dependency alerts and the dependency graph for a repository.
        The authenticated user must have admin access to the repository. For more information,
        see "[About security alerts for vulnerable dependencies](https://docs.github.com/articles/about-security-alerts-for-vulnerable-dependencies)".

        See also: https://docs.github.com/rest/repos/repos#disable-vulnerability-alerts
        """

        url = f"/repos/{owner}/{repo}/vulnerability-alerts"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    def download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/download-zipball-archive

        GET /repos/{owner}/{repo}/zipball/{ref}

        Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
        `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
        the `Location` header to make a second `GET` request.

        > [!NOTE]
        > For private repositories, these links are temporary and expire after five minutes. If the repository is empty, you will receive a 404 when you follow the redirect.

        See also: https://docs.github.com/rest/repos/contents#download-a-repository-archive-zip
        """

        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    async def async_download_zipball_archive(
        self,
        owner: str,
        repo: str,
        ref: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/download-zipball-archive

        GET /repos/{owner}/{repo}/zipball/{ref}

        Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
        `main`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
        the `Location` header to make a second `GET` request.

        > [!NOTE]
        > For private repositories, these links are temporary and expire after five minutes. If the repository is empty, you will receive a 404 when you follow the redirect.

        See also: https://docs.github.com/rest/repos/contents#download-a-repository-archive-zip
        """

        url = f"/repos/{owner}/{repo}/zipball/{ref}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            stream=stream,
        )

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        owner: Missing[str] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        include_all_branches: Missing[bool] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/create-using-template

        POST /repos/{template_owner}/{template_repo}/generate

        Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. If the repository is not public, the authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/rest/repos/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.

        OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.

        See also: https://docs.github.com/rest/repos/repos#create-a-repository-using-a-template
        """

        from ..models import (
            FullRepository,
            ReposTemplateOwnerTemplateRepoGeneratePostBody,
        )

        url = f"/repos/{template_owner}/{template_repo}/generate"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposTemplateOwnerTemplateRepoGeneratePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
        )

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: ReposTemplateOwnerTemplateRepoGeneratePostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        owner: Missing[str] = UNSET,
        name: str,
        description: Missing[str] = UNSET,
        include_all_branches: Missing[bool] = UNSET,
        private: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_create_using_template(
        self,
        template_owner: str,
        template_repo: str,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[ReposTemplateOwnerTemplateRepoGeneratePostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/create-using-template

        POST /repos/{template_owner}/{template_repo}/generate

        Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. If the repository is not public, the authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/rest/repos/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.

        OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.

        See also: https://docs.github.com/rest/repos/repos#create-a-repository-using-a-template
        """

        from ..models import (
            FullRepository,
            ReposTemplateOwnerTemplateRepoGeneratePostBody,
        )

        url = f"/repos/{template_owner}/{template_repo}/generate"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(
                ReposTemplateOwnerTemplateRepoGeneratePostBody, json
            )
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
        )

    def list_public(
        self,
        *,
        since: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """repos/list-public

        GET /repositories

        Lists all public repositories in the order that they were created.

        Note:
        - For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise.
        - Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of repositories.

        See also: https://docs.github.com/rest/repos/repos#list-public-repositories
        """

        from ..models import MinimalRepository, ValidationError

        url = "/repositories"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    async def async_list_public(
        self,
        *,
        since: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """repos/list-public

        GET /repositories

        Lists all public repositories in the order that they were created.

        Note:
        - For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise.
        - Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/guides/using-pagination-in-the-rest-api#using-link-headers) to get the URL for the next page of repositories.

        See also: https://docs.github.com/rest/repos/repos#list-public-repositories
        """

        from ..models import MinimalRepository, ValidationError

        url = "/repositories"

        params = {
            "since": since,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
            error_models={
                "422": ValidationError,
            },
        )

    def list_for_authenticated_user(
        self,
        *,
        visibility: Missing[Literal["all", "public", "private"]] = UNSET,
        affiliation: Missing[str] = UNSET,
        type: Missing[Literal["all", "owner", "public", "private", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Repository], list[RepositoryType]]:
        """repos/list-for-authenticated-user

        GET /user/repos

        Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.

        The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.

        See also: https://docs.github.com/rest/repos/repos#list-repositories-for-the-authenticated-user
        """

        from ..models import BasicError, Repository, ValidationError

        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_for_authenticated_user(
        self,
        *,
        visibility: Missing[Literal["all", "public", "private"]] = UNSET,
        affiliation: Missing[str] = UNSET,
        type: Missing[Literal["all", "owner", "public", "private", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        since: Missing[datetime] = UNSET,
        before: Missing[datetime] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[Repository], list[RepositoryType]]:
        """repos/list-for-authenticated-user

        GET /user/repos

        Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.

        The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.

        See also: https://docs.github.com/rest/repos/repos#list-repositories-for-the-authenticated-user
        """

        from ..models import BasicError, Repository, ValidationError

        url = "/user/repos"

        params = {
            "visibility": visibility,
            "affiliation": affiliation,
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
            "since": since,
            "before": before,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[Repository],
            error_models={
                "422": ValidationError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    @overload
    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserReposPostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    def create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_discussions: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    def create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/create-for-authenticated-user

        POST /user/repos

        Creates a new repository for the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.

        See also: https://docs.github.com/rest/repos/repos#create-a-repository-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            FullRepository,
            UserReposPostBody,
            ValidationError,
        )

        url = "/user/repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return self._github.request(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: UserReposPostBodyType,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    @overload
    async def async_create_for_authenticated_user(
        self,
        *,
        data: UnsetType = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        name: str,
        description: Missing[str] = UNSET,
        homepage: Missing[str] = UNSET,
        private: Missing[bool] = UNSET,
        has_issues: Missing[bool] = UNSET,
        has_projects: Missing[bool] = UNSET,
        has_wiki: Missing[bool] = UNSET,
        has_discussions: Missing[bool] = UNSET,
        team_id: Missing[int] = UNSET,
        auto_init: Missing[bool] = UNSET,
        gitignore_template: Missing[str] = UNSET,
        license_template: Missing[str] = UNSET,
        allow_squash_merge: Missing[bool] = UNSET,
        allow_merge_commit: Missing[bool] = UNSET,
        allow_rebase_merge: Missing[bool] = UNSET,
        allow_auto_merge: Missing[bool] = UNSET,
        delete_branch_on_merge: Missing[bool] = UNSET,
        squash_merge_commit_title: Missing[
            Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]
        ] = UNSET,
        squash_merge_commit_message: Missing[
            Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
        ] = UNSET,
        merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = UNSET,
        merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = UNSET,
        has_downloads: Missing[bool] = UNSET,
        is_template: Missing[bool] = UNSET,
    ) -> Response[FullRepository, FullRepositoryType]: ...

    async def async_create_for_authenticated_user(
        self,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
        data: Missing[UserReposPostBodyType] = UNSET,
        **kwargs,
    ) -> Response[FullRepository, FullRepositoryType]:
        """repos/create-for-authenticated-user

        POST /user/repos

        Creates a new repository for the authenticated user.

        OAuth app tokens and personal access tokens (classic) need the `public_repo` or `repo` scope to create a public repository, and `repo` scope to create a private repository.

        See also: https://docs.github.com/rest/repos/repos#create-a-repository-for-the-authenticated-user
        """

        from ..models import (
            BasicError,
            FullRepository,
            UserReposPostBody,
            ValidationError,
        )

        url = "/user/repos"

        headers = {
            "Content-Type": "application/json",
            "X-GitHub-Api-Version": self._REST_API_VERSION,
            **(headers or {}),
        }

        json = kwargs if data is UNSET else data
        if self._github.config.rest_api_validate_body:
            json = type_validate_python(UserReposPostBody, json)
        json = model_dump(json) if isinstance(json, BaseModel) else json

        return await self._github.arequest(
            "POST",
            url,
            json=exclude_unset(json),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=FullRepository,
            error_models={
                "401": BasicError,
                "404": BasicError,
                "403": BasicError,
                "422": ValidationError,
                "400": BasicError,
            },
        )

    def list_invitations_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryInvitation], list[RepositoryInvitationType]]:
        """repos/list-invitations-for-authenticated-user

        GET /user/repository_invitations

        When authenticating as a user, this endpoint will list all currently open repository invitations for that user.

        See also: https://docs.github.com/rest/collaborators/invitations#list-repository-invitations-for-the-authenticated-user
        """

        from ..models import BasicError, RepositoryInvitation

        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    async def async_list_invitations_for_authenticated_user(
        self,
        *,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[RepositoryInvitation], list[RepositoryInvitationType]]:
        """repos/list-invitations-for-authenticated-user

        GET /user/repository_invitations

        When authenticating as a user, this endpoint will list all currently open repository invitations for that user.

        See also: https://docs.github.com/rest/collaborators/invitations#list-repository-invitations-for-the-authenticated-user
        """

        from ..models import BasicError, RepositoryInvitation

        url = "/user/repository_invitations"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[RepositoryInvitation],
            error_models={
                "404": BasicError,
                "403": BasicError,
                "401": BasicError,
            },
        )

    def decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/decline-invitation-for-authenticated-user

        DELETE /user/repository_invitations/{invitation_id}

        See also: https://docs.github.com/rest/collaborators/invitations#decline-a-repository-invitation
        """

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    async def async_decline_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/decline-invitation-for-authenticated-user

        DELETE /user/repository_invitations/{invitation_id}

        See also: https://docs.github.com/rest/collaborators/invitations#decline-a-repository-invitation
        """

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "DELETE",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "409": BasicError,
                "404": BasicError,
                "403": BasicError,
            },
        )

    def accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/accept-invitation-for-authenticated-user

        PATCH /user/repository_invitations/{invitation_id}

        See also: https://docs.github.com/rest/collaborators/invitations#accept-a-repository-invitation
        """

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    async def async_accept_invitation_for_authenticated_user(
        self,
        invitation_id: int,
        *,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response:
        """repos/accept-invitation-for-authenticated-user

        PATCH /user/repository_invitations/{invitation_id}

        See also: https://docs.github.com/rest/collaborators/invitations#accept-a-repository-invitation
        """

        from ..models import BasicError

        url = f"/user/repository_invitations/{invitation_id}"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "PATCH",
            url,
            headers=exclude_unset(headers),
            stream=stream,
            error_models={
                "403": BasicError,
                "409": BasicError,
                "404": BasicError,
            },
        )

    def list_for_user(
        self,
        username: str,
        *,
        type: Missing[Literal["all", "owner", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """repos/list-for-user

        GET /users/{username}/repos

        Lists public repositories for the specified user.

        See also: https://docs.github.com/rest/repos/repos#list-repositories-for-a-user
        """

        from ..models import MinimalRepository

        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
        )

    async def async_list_for_user(
        self,
        username: str,
        *,
        type: Missing[Literal["all", "owner", "member"]] = UNSET,
        sort: Missing[Literal["created", "updated", "pushed", "full_name"]] = UNSET,
        direction: Missing[Literal["asc", "desc"]] = UNSET,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        headers: Optional[Mapping[str, str]] = None,
        stream: bool = False,
    ) -> Response[list[MinimalRepository], list[MinimalRepositoryType]]:
        """repos/list-for-user

        GET /users/{username}/repos

        Lists public repositories for the specified user.

        See also: https://docs.github.com/rest/repos/repos#list-repositories-for-a-user
        """

        from ..models import MinimalRepository

        url = f"/users/{username}/repos"

        params = {
            "type": type,
            "sort": sort,
            "direction": direction,
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            stream=stream,
            response_model=list[MinimalRepository],
        )
